/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ZipLoader;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.kawa.reflect.ClassMemberLocation;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure1;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kawa.Shell;

public class load
extends Procedure1 {
    boolean relative;
    private static ThreadLocal currentLoadPath = new ThreadLocal();
    public static final load load = new load("load", false);
    public static final load loadRelative = new load("load-relative", true);

    public load(String string, boolean bl) {
        super(string);
        this.relative = bl;
    }

    public static final void loadClassFile(String string, Environment environment) {
        Environment environment2 = Environment.getCurrent();
        try {
            if (environment != environment2) {
                Environment.setCurrent(environment);
            }
            Language.getDefaultLanguage().loadClass(string);
        }
        catch (Throwable throwable) {
            throw new WrappedException("exception during load of \"" + string + '\"', throwable);
        }
        finally {
            if (environment != environment2) {
                Environment.setCurrent(environment2);
            }
        }
    }

    public static final void loadCompiled(Path path, Environment environment) throws Throwable {
        Environment environment2 = Environment.getCurrent();
        String string = path.toString();
        try {
            Object var7_10;
            if (environment != environment2) {
                Environment.setCurrent(environment);
            }
            if (!(path instanceof FilePath)) {
                throw new RuntimeException("load: " + string + " - not a file path");
            }
            File file = ((FilePath)path).toFile();
            if (!file.exists()) {
                throw new RuntimeException("load: " + string + " - not found");
            }
            if (!file.canRead()) {
                throw new RuntimeException("load: " + string + " - not readable");
            }
            ZipLoader zipLoader = new ZipLoader(string);
            Class clazz = zipLoader.loadAllClasses();
            Object v0 = var7_10 = clazz == null ? null : clazz.newInstance();
            if (!(var7_10 instanceof ModuleBody)) {
                throw new RuntimeException("load: " + string + " - no module in archive");
            }
            ClassMemberLocation.defineAll(var7_10, Language.getDefaultLanguage(), environment);
            ((ModuleBody)var7_10).run();
        }
        catch (IOException iOException) {
            throw new WrappedException("load: " + string + " - " + iOException.toString(), iOException);
        }
        catch (InstantiationException instantiationException) {
            throw new WrappedException("class not instantiable: in load", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedException("class illegal access: in load", illegalAccessException);
        }
        finally {
            if (environment != environment2) {
                Environment.setCurrent(environment2);
            }
        }
    }

    public static final void loadSource(InPort inPort, Environment environment, URL uRL) throws SyntaxException, Throwable {
        SourceMessages sourceMessages;
        Consumer consumer;
        boolean bl = ModuleBody.getMainPrintValues();
        Language language = Language.getDefaultLanguage();
        Throwable throwable = Shell.run(language, environment, inPort, consumer = bl ? Shell.getOutputConsumer(OutPort.outDefault()) : new VoidConsumer(), null, uRL, sourceMessages = new SourceMessages());
        if (throwable != null) {
            throw throwable;
        }
    }

    public final Object apply1(Object object2) throws Throwable {
        return this.apply2(object2, Environment.getCurrent());
    }

    public final Object apply2(Object object2, Object object3) throws Throwable {
        try {
            Environment environment = (Environment)object3;
            kawa.standard.load.apply(object2, environment, this.relative, 0);
            return Values.empty;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("cannot load " + fileNotFoundException.getMessage());
        }
        catch (SyntaxException syntaxException) {
            throw new RuntimeException("load: errors while compiling '" + object2 + "':\n" + syntaxException.getMessages().toString(20));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void apply(Object object2, Environment environment, boolean bl, int n) throws Throwable {
        Path path = (Path)currentLoadPath.get();
        try {
            Path path2 = Path.valueOf(object2);
            if (bl && path != null) {
                path2 = path.resolve(path2);
            }
            currentLoadPath.set(path2);
            kawa.standard.load.apply(path2, environment, bl, n);
        }
        finally {
            currentLoadPath.set(path);
        }
    }

    private static final void apply(Path path, Environment environment, boolean bl, int n) throws Throwable {
        int n2;
        int n3;
        int n4;
        String string = path.toString();
        if (string.endsWith(".zip") || string.endsWith(".jar")) {
            kawa.standard.load.loadCompiled(path, environment);
            return;
        }
        URL uRL = path.toURL();
        char c = System.getProperty("file.separator").charAt(0);
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
            string = string.replace('/', '.');
            if (c != '/') {
                string = string.replace(c, '.');
            }
            kawa.standard.load.loadClassFile(string, environment);
            return;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(path.openInputStream());
        ((InputStream)bufferedInputStream).mark(5);
        int n5 = ((InputStream)bufferedInputStream).read();
        if (n5 == -1) {
            return;
        }
        if (n5 == 80 && (n4 = ((InputStream)bufferedInputStream).read()) == 75 && (n3 = ((InputStream)bufferedInputStream).read()) == 3 && (n2 = ((InputStream)bufferedInputStream).read()) == 4) {
            ((InputStream)bufferedInputStream).close();
            kawa.standard.load.loadCompiled(path, environment);
            return;
        }
        ((InputStream)bufferedInputStream).reset();
        InPort inPort = InPort.openFile(bufferedInputStream, path);
        while (--n >= 0) {
            inPort.skipRestOfLine();
        }
        kawa.standard.load.loadSource(inPort, environment, uRL);
        inPort.close();
    }
}

