/* -*-c-*- ---------------- mixgtk_device.c :
 * actual types for mixgtk devices
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: <01/04/03 00:09:46 jose>
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#include <stdio.h>
#include <mixlib/xmix_device.h>
#include "mixgtk_device.h"

/* device container */
static GtkNotebook *container_ = NULL;
/* virtual machine */
static mix_vm_t *vm_ = NULL;

/* a mixgtk device */
struct mixgtk_device_t
{
  mix_device_t device;
  gchar *buffer;
  GtkText *widget;
  gint pos;
};

/* callbacks for output devices */
static gboolean
write_out_ (mix_device_t *dev, const mix_word_t *block)
{
  struct mixgtk_device_t *gtkdev  = (struct mixgtk_device_t *) dev;
  guint k, j;
  
  for (k = 0; k < SIZES_[dev->type]; k++)
    for (j = 1; j < 6; j++)
      {
	mix_char_t ch = mix_word_get_byte (block[k], j);
	gtkdev->buffer[5 * k + j - 1] = mix_char_to_ascii (ch);
      }

  gtk_text_insert (gtkdev->widget, NULL, NULL, NULL, gtkdev->buffer, -1);
  gtk_notebook_set_page (container_, gtkdev->pos);

  return TRUE;
}

static gboolean 
read_out_ (mix_device_t *dev, mix_word_t *block)
{
  return TRUE;
}

static gboolean 
ioc_out_ (mix_device_t *dev, mix_short_t cmd)
{
  return TRUE;
}

static gboolean
busy_out_ (const mix_device_t *dev) 
{
  return TRUE;
}

static mix_device_vtable_t MIXGTK_OUT_VTABLE_;

/* create a new mixgtk device */
static struct mixgtk_device_t *
mixgtk_device_new_ (mix_device_type_t type)
{
  struct mixgtk_device_t *dev = NULL;

  g_return_val_if_fail (type < mix_dev_INVALID, NULL);

  if (MODES_[type] == mix_dev_CHAR && FMODES_[type] == mix_io_WRITE)
    {
      dev = g_new (struct mixgtk_device_t, 1);
      dev->device.file = NULL;
      dev->device.type = type;
      dev->device.vtable = &MIXGTK_OUT_VTABLE_;
      dev->buffer = g_new (gchar, (SIZES_[type] * 5 + 2));
      dev->buffer[SIZES_[type] * 5] = '\n';
      dev->buffer[SIZES_[type] * 5 + 1] = '\0';
      dev->widget = (GtkText *)gtk_text_new (NULL, NULL);
      g_assert (dev->widget);
      gtk_text_set_editable (dev->widget, FALSE);
    }
  return dev;
}

/* connect a device */
static void
mixgtk_device_connect_ (struct mixgtk_device_t *dev)
{
  static gint last_pos = 0;
  GtkWidget *label = gtk_label_new (DEF_NAMES_[dev->device.type]);
  GtkWidget *box = gtk_hbox_new (0, 0);
  GtkWidget *scroll = gtk_vscrollbar_new (dev->widget->vadj);
  g_assert (label);
  g_assert (box);
  gtk_box_pack_start (GTK_BOX (box), GTK_WIDGET (dev->widget),
		      TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (box), scroll, FALSE, FALSE, 0);
  dev->pos = last_pos++;
  gtk_notebook_insert_page (container_, box, label, dev->pos);
  gtk_widget_show (box);
  gtk_widget_show (label);
  gtk_widget_show (scroll);
  gtk_widget_show (GTK_WIDGET (dev->widget));
  gtk_widget_draw (GTK_WIDGET (container_), NULL);
  (void) mix_vm_connect_device (vm_, (mix_device_t *)dev);
}

/* init default devices */
gboolean
mixgtk_device_init (GtkNotebook *container, mix_vm_t *vm)
{
  static mix_device_type_t def_types[] = {
    mix_dev_CONSOLE, mix_dev_PRINTER, mix_dev_PAPER_TAPE, mix_dev_INVALID
  };
  
  gint k = 0;
				     
  g_return_val_if_fail (container != NULL, FALSE);
  g_return_val_if_fail (vm != NULL, FALSE);
  container_ = container;
  vm_ = vm;

  /* remove dummy page from container */
  gtk_notebook_remove_page (container_, 0);

  /* initialise vtables */
  MIXGTK_OUT_VTABLE_.write = write_out_;
  MIXGTK_OUT_VTABLE_.read = read_out_;
  MIXGTK_OUT_VTABLE_.ioc = ioc_out_;
  MIXGTK_OUT_VTABLE_.busy = busy_out_;
  
  /* connect default devices */
  while (def_types[k] != mix_dev_INVALID)
    {
      struct mixgtk_device_t *dev = mixgtk_device_new_ (def_types[k]);
      if (dev != NULL)
	  mixgtk_device_connect_ (dev);
      ++k;
    }

  /* set to first page */
  gtk_notebook_set_page (container_, 0);
  
  return TRUE;
}

/* connect a new (file-based) device */
gboolean
mixgtk_device_connect (mix_device_type_t type, const gchar *name);
