/* $Id: swverid.h,v 1.11 2000/03/26 16:44:00 jhl Exp jhl $
 *  swverid.h -- IEEE 1387.2 Version structure.
 */ 

/*
 * Copyright (C) 1998,2004  James H. Lowe, Jr.  <jhlowe@acm.org>
 *
 * COPYING TERMS AND CONDITIONS
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#ifndef SWVERID_122998_H
#define SWVERID_122998_H

#include <stdio.h>
#include <stdlib.h>
#include "swsdflt.h"
#include "cplob.h"

#define SWVERID_OBJECT_NAME_LENGTH 42
#define SWVERID_MAX_TAGS 23

/* Name space codes */
#define SWVERID_NS_IVAL		-2 	/* invalid or error */
#define SWVERID_NS_NA		-1 	/* not applicable */
#define SWVERID_NS_SUPER	0	/* */
#define SWVERID_NS_TOP		1	/* product and bundles  */
#define SWVERID_NS_MID		2	/* subproducts, filesets, controlfiles */
#define SWVERID_NS_LOW		3	/* files */


/* Swverid_Cmp_Codes: Comparison result codes 		*/
#define SWVERID_CMP_NOT_USED	-50 /* not used 	*/
#define SWVERID_CMP_ERROR	-40 /* error 		*/
#define SWVERID_CMP_NEQ		-30 /* not equal 	*/
#define SWVERID_CMP_LT		-20 /* less than 	*/
#define SWVERID_CMP_LTE		-10 /* less than or equal to*/
#define SWVERID_CMP_EQ 		0   /* identical 	*/
#define SWVERID_CMP_GTE		10  /* greater than or equal to*/
#define SWVERID_CMP_GT		20  /* less than 	*/


/* version attributes abbreviations */
#define SWVERID_VERID_TAG		0
#define SWVERID_VERID_NAME_ERROR	'0'
#define SWVERID_VERID_REVISION		'r'
#define SWVERID_VERID_ARCHITECTURE	'a'
#define SWVERID_VERID_VENDOR_TAG	'v'
#define SWVERID_VERID_LOCATION		'l'
#define SWVERID_VERID_QUALIFIER		'q'

typedef int Swverid_Cmp_Code;

#define SWVERID_G_taglistM(X)  (X->taglistM)

struct VER_ID {				/*  */
	char ver_idM[3];		/* version id */
	char rel_opM[3];       		/* Relation operation. */
	char valueM[65];     		/* Value. */
	struct VER_ID * nextM;		/* Pointer to next in chain. */
};

typedef struct {				/* Object Version Spec */  
	char * object_nameM;			/* object name, i.e object keyword. */ 	
	char * source_copyM;			/* copy of swverid version string */
	char * catalogM;			/* ``catalog'' attribute. */ 	
	int use_path_compareM;			/* if true, use comparison that disregards leading slashes */
	CPLOB * taglistM;			/* list of tags, Note: The first tag in the list is the */
						/* left most tag to which the version spec applies.	*/
	int namespaceM;				/* namespace code */
	Swverid_Cmp_Code comparison_codeM;	/* `this object'  \<comparision_code_\> `other object' */
	struct VER_ID * ver_id_listM;		/* linked list of version id's */
} SWVERID;

SWVERID * 	swverid_open            	(char * object_keyword, char * swversion_string);
void      	swverid_close           	(SWVERID * swverid);
void 		swverid_set_namespace		(SWVERID * swverid, char * object_keyword);
char * 		swverid_print			(SWVERID * swverid, char * buf, int buflen);
int		swverid_add_attribute		(SWVERID * swverid, char * object_keyword, char * keyw, char * value);
int       	swverid_make_ver_id		(SWVERID * swverid, char * attr_name, char * value, char * rel_op);
struct VER_ID*	swverid_get_ver_id		(SWVERID * swverid, char * keyword, struct VER_ID * ver_id);
char * 		swverid_get_object_name		(SWVERID * swverid);
void     	swverid_set_object_name		(SWVERID * swverid, char * name);
void     	swverid_set_tag			(SWVERID * swverid, char * keyw, char * value);
char *   	swverid_get_tag			(SWVERID * swverid, int n);
int		swverid_compare			(SWVERID * swverid1, SWVERID * swverid2);
void     	swverid_set_comparison_code	(SWVERID * swverid,  Swverid_Cmp_Code code);
/* int      	swverid_get_number_of_id_attr	(SWVERID * swverid); */
int     	swverid_get_ver_id_char		(char * object_keyword, char * attr_name);
Swverid_Cmp_Code  swverid_get_comparison_sense	(SWVERID * swverid1, SWVERID * swverid2);
Swverid_Cmp_Code  swverid_get_comparison_code	(SWVERID * swverid);
int 		swverid_compare_ver_id(SWVERID * swverid1, SWVERID * swverid2);
void		swverid_add_verid(SWVERID * swverid, struct VER_ID  * verid);
CPLOB * swverid_u_parse_swspec(SWVERID * swverid, char * taglist);
/* Private Functions */

#endif
