/*
 *  nwrights.c
 *
 *  Show effective rights for dir or file.
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include "ncplib.h"
#include <unistd.h>
#include <stdlib.h>

static char *progname;

static void
usage(void)
{
	fprintf(stderr, "usage: %s [options]\n", progname);
}

static void
help(void)
{
        printf("\n");
        printf("usage: %s [options] file/directory\n", progname);
        printf("\n"
	       "-h             Print this help text\n"
	       "\n"
	       "file/directory\n"
	       "\n");
}

int
main(int argc, char *argv[])
{
	struct ncp_conn *conn = NULL;
	char *path = ".";
	long err;
	int result = 1;
	int opt;
	__u16 rights;

	progname = argv[0];

	while ((opt = getopt(argc, argv, "h?")) != EOF)
	{
		switch(opt) {
		case 'h':
		case '?':
			help();
			goto finished;
		default:
			usage();
			goto finished;
		}
	}

	if (optind > argc)
	{
		usage();
		goto finished;
	}

	if (optind == argc-1)
	{
		path = argv[optind];
	}

	if ((conn = ncp_open_mount(path, &err)) == NULL)
	{
		com_err(argv[0], err, "when initializing");
		goto finished;
	}

	if ((err = ncp_get_eff_directory_rights(conn, 0, 0, 0x8006,
						conn->i.volume_number,
						conn->i.directory_id, NULL,
						&rights)) != 0)
	{
		com_err(argv[0], err, "when finding rights");
		goto finished;
	}

	printf("Your effective rights for %s are: [%c%c%c%c%c%c%c%c]\n",
	       path,
	       ((rights & NCP_PERM_SUPER ) != 0) ? 'S' : ' ',
	       ((rights & NCP_PERM_READ  ) != 0) ? 'R' : ' ',
	       ((rights & NCP_PERM_WRITE ) != 0) ? 'W' : ' ',
	       ((rights & NCP_PERM_CREATE) != 0) ? 'C' : ' ',
	       ((rights & NCP_PERM_DELETE) != 0) ? 'E' : ' ',
	       ((rights & NCP_PERM_MODIFY) != 0) ? 'M' : ' ',
	       ((rights & NCP_PERM_SEARCH) != 0) ? 'F' : ' ',
	       ((rights & NCP_PERM_OWNER ) != 0) ? 'A' : ' ');

	if ((rights & NCP_PERM_SUPER ) != 0)
	{
		printf("(S): You have SUPERVISOR rights\n");
	}

	if ((rights & NCP_PERM_READ  ) != 0)
	{
		printf("(R): You may READ from files\n");
	}

	if ((rights & NCP_PERM_WRITE ) != 0)
	{
		printf("(W): You may WRITE to files\n");
	}

	if ((rights & NCP_PERM_CREATE) != 0)
	{
		printf("(C): You may CREATE files\n");
	}

	if ((rights & NCP_PERM_DELETE) != 0)
	{
		printf("(E): You may ERASE files\n");
	}

	if ((rights & NCP_PERM_MODIFY) != 0)
	{
		printf("(M): You may MODIFY directory\n");
	}

	if ((rights & NCP_PERM_SEARCH) != 0)
	{
		printf("(F): You may SCAN for files\n");
	}

	if ((rights & NCP_PERM_OWNER ) != 0)
	{
		printf("(A): You may change ACCESS control\n");
	}

	result = 0;

 finished:
	ncp_close(conn);
	return result;
}
