/* kbdinstall.c: program to install default keyboard map file
 * Copyright (C) 1996  A. V. Le Blanc

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 * This program replaces a shell script that didn't quite work right!
 */

#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define ARRAY 100
#define NAMES 1600
#define KDIR "/usr/share/kbd/keytables"

char	names[NAMES],
	*nptr = names,
	*enames = names + NAMES - 1,
	*array[ARRAY],
	kbddir[] = KDIR;
int	total = 0,
	maxlen = 0;

void sort(void)
{
  int gap, a, b, c;
  char *temp;

  gap = 1;
  while (gap <= total) gap <<= 1;
  gap--;

  while (gap >>= 1)
    for (c = total - gap - 1; c >= 0; c--) {
      b = c;
      while ((a = b + gap) < total) {
        if (strcmp(array[b], array[a]) <= 0)
          break;
        temp = array[a];
        array[a] = array[b];
        array[b] = temp;
        b += gap;
      }
    }
}

void list(void)
{
  int	cols = 80 / (maxlen + 7),
	gap,
	i, j, k;

  if (!cols) cols++;
  gap = (total + cols - 1) / cols;
  for (i = 0; i < gap; i++) {
    putchar('\n');
    for (j = 0; (j < cols) && ((k = i + j * gap) < total); j++)
      printf("%2i  %-*.16s   ", k + 1, maxlen, array[k]);
  }
}

void insert(char *name)
{
  char *mapp;
  int size;

  if ((mapp = (char *) strstr(name, ".map"))
	&& (total < ARRAY)
	&& (nptr + (size = mapp - name) < enames)) {
    if (size > maxlen)
      maxlen = size;
    strncpy(nptr, name, size);
    array[total++] = nptr;
    nptr += size;
    *nptr++ = '\0';
  }
}

void main(void)
{
  {
    struct dirent *f;
    DIR *kbd = opendir(kbddir);
    if (!kbd) {
      fprintf(stderr, "Unable to read %s directory\n", kbddir);
      exit(1);
    }

    while (f = readdir(kbd))
      insert(f->d_name);

    closedir(kbd);
  }
  if (maxlen > 16) maxlen = 16;
  sort();

  while (1) {
    char buffer[100], *ptr,
	*argv[] = {"/bin/cp", "-p", buffer, "/etc/kbd.conf", NULL};
    int i;

    list();
    printf("\n\nSelect the default keytable for this machine (0 to quit): ");
    fgets(buffer, 99, stdin);
    ptr = buffer;
    while (*ptr && !isgraph(*ptr)) ptr++;
    if (isdigit(*ptr) && ((i = atoi(ptr)) <= total)) {
      if (!i) exit(1);
      sprintf(buffer, KDIR "/%s.map", array[i - 1]);
      execv(*argv, argv);
    }
  }
}
