/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/*
 * Thu Jul 14 21:44:27 1994: modified for PMS, faith@cs.unc.edu
 */

#include <ansidecl.h>
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/types.h>
#include <stdio.h>

extern int Debug;


#ifndef	HAVE_GNU_LD
#define	__environ	environ
#endif

#define	SHELL_PATH	"/bin/sh"	/* Path of the shell.  */
#define	SHELL_NAME	"sh"		/* Name to give it.  */

#ifndef	FORK
#define	FORK	__fork
#endif

/* Execute LINE as a shell command, returning its status.  */
int
DEFUN(pms_system, (line), register CONST char *line)
{
  int status, save;
  pid_t pid;
  struct sigaction sa, intr, quit;
  sigset_t block, omask;
  char *buffer;
  char *pt;
  char **argv;
  int  argc = 0;
  int  true_argc = 0;

  if (line == NULL)
    return 1;

  buffer = alloca( (strlen( line ) + 1) * sizeof( char ));
  strcpy( buffer, line );
  pt = buffer;
  while (*pt) {
     if (*pt == ' ' || *pt == '\t') ++argc;
     ++pt;
  }
  argv = alloca( (argc + 2) * sizeof( char * ) );

				/* Note that this doesn't allow quoted
				   characters in "line".  But PMS doesn't
				   need this. */

  argv[true_argc++] = pt = buffer;
  while (*pt) {
     if (*pt == ' ' || *pt == '\t') {
	*pt++ = '\0';
	while (*pt && (*pt == ' ' || *pt == '\t')) pt++;
	argv[true_argc++] = pt;
     } else
	   ++pt;
  }
  argv[true_argc] = NULL;
  
  if (Debug) {
     int i;
     printf( "pms_system has %d arg(s):\n", true_argc );
     for (i = 0; i < true_argc; i++)
	   printf( "  Arg %d = \"%s\"\n", i, argv[i] );
  }

  sa.sa_handler = SIG_IGN;
  sa.sa_flags = 0;
  __sigemptyset (&sa.sa_mask);

  if (__sigaction (SIGINT, &sa, &intr) < 0)
    return -1;
  if (__sigaction (SIGQUIT, &sa, &quit) < 0)
    {
      save = errno;
      (void) __sigaction (SIGINT, &intr, (struct sigaction *) NULL);
      errno = save;
      return -1;
    }

  __sigemptyset (&block);
  __sigaddset (&block, SIGCHLD);
  save = errno;
  if (__sigprocmask(SIG_BLOCK, &block, &omask) < 0)
    {
      if (errno == ENOSYS)
	errno = save;
      else
	{
	  save = errno;
	  (void) __sigaction(SIGINT, &intr, (struct sigaction *) NULL);
	  (void) __sigaction(SIGQUIT, &quit, (struct sigaction *) NULL);
	  errno = save;
	  return -1;
	}
    }

  pid = FORK ();
  if (pid == (pid_t) 0)
    {
      /* Child side.  */
      CONST char *new_argv[4];
      new_argv[0] = SHELL_NAME;
      new_argv[1] = "-c";
      new_argv[2] = line;
      new_argv[3] = NULL;

      /* Restore the signals.  */
      (void) __sigaction (SIGINT, &intr, (struct sigaction *) NULL);
      (void) __sigaction (SIGQUIT, &quit, (struct sigaction *) NULL);
      (void) __sigprocmask (SIG_SETMASK, &omask, (sigset_t *) NULL);

      /* Exec the shell.  */
      if (!Debug)
	    (void) execvp (argv[0], (char *CONST *) argv);
      _exit (127);
    }
  else if (pid < (pid_t) 0)
    /* The fork failed.  */
    status = -1;
  else
    /* Parent side.  */
#ifdef	NO_WAITPID
    {
      pid_t child;
      do
	{
	  child = __wait (&status);
	  if (child <= -1)
	    {
	      status = -1;
	      break;
	    }
	} while (child != pid);
    }
#else
    if (__waitpid (pid, &status, 0) != pid)
      status = -1;
#endif

  save = errno;
  if ((__sigaction (SIGINT, &intr, (struct sigaction *) NULL) |
       __sigaction (SIGQUIT, &quit, (struct sigaction *) NULL) |
       __sigprocmask (SIG_SETMASK, &omask, (sigset_t *) NULL)) != 0)
    {
      if (errno == ENOSYS)
	errno = save;
      else
	return -1;
    }

  return status;
}
