char *whatstr = "@(#) what  v1.3  5.4.94  by A.Bagge";
/*
 * Synopsis:
 * ---------
 *	what file ...
 *	what -v
 *
 * Description:
 * ------------
 * what(1) is a program to display copyright or version information
 * from a binary or ASCII file. It provides an easy way to obtain
 * informations from any type of files if a special string sequence
 * is included in the file.
 * It searches for a sequence of the characters @(#) and writes
 * all subsequent characters up to one of the characters " > \ \0 \n
 * or EOF is found.
 * Multiple occurrencies of the @(#) will be found in one file.
 * The -v option prints the version of the what program itself.
 *
 * Example:
 * --------
 * A typical sequence in a C program myprog.c might look like:
 *   const char what[]="@(#) myprog version 1.0  (c) myself";
 * Running what(1) on the source, object file and the executable gives:
 *   $ what myprog.c myprog.o myprog
 *   myprog.c:
 *           myprog version 1.0  (c) myself
 *   myprog.o:
 *           myprog version 1.0  (c) myself
 *   myprog:
 *           myprog version 1.0  (c) myself
 * The what sequence may also be useful in shell scripts or other
 * textfiles like configuration files or binary data files.
 *
 * Origin:
 * -------
 * The idea of this program came from the what utility of the SCCS
 * (source code control system), but it is completely written
 * without any knowledge of the original code.
 *
 * Author:
 * -------
 *	Andreas Bagge		bagge@gih.uni-hannover.de
 *				andreas_bagge@maus_h2.han.de
 *				andreas_bagge@h2.maus.de
 *
 * Copyright:
 * ----------
 * This program and the source code may be freely distributed
 * under the GNU general public licence.
 * See the file COPYING for details.
 *
 * History:
 * --------
 * 1.0	?.?.1993
 * 1.1	26.4.93
 * 1.2	25.10.93
 *	MSDOS port for DGJPP gnu C compiler
 *	new option -v for print version
 * 1.3	5.4.94
 *	printf() replaced by puts()
 * 1.4	18.5.94
 *      bug in fopen() call fixed
 */

#include <stdio.h>
#include <string.h>


int main(int argc, char **argv)
{
    register ret = 0;
    register int i;

    if (argc < 2) {
	fputs("usage: what file ...\n", stderr);
	return (1);
    }
    if (!strncmp(argv[1], "-v", 2)) {
	fputs(&whatstr[5], stderr);
	fputc('\n', stderr);
	return (0);
    }
    for (i = 1; i < argc; i++) {
	register int c;
	FILE *fd;

	if (!(fd = fopen(argv[i], "r"))) {
	    fputs("what: cannot open ", stderr);
	    fputs(argv[i], stderr);
	    fputc('\n', stderr);
	    ret++;
	    continue;
	}
	puts(argv[i]);
	while ((c = getc(fd)) != EOF) {
	    if (c == '@' && getc(fd) == '(' && getc(fd) == '#' && getc(fd) == ')') {
		putchar('\t');
		while ((c = getc(fd)) != '"' && c != '>' && c != '\\' &&
		       c != '\0' && c != '\n' && c != EOF)
		    putchar(c);
		putchar('\n');
	    }
	}
    }
    return (ret);
}
