/* signals.c - signal name handling */

#include <stdio.h>
#include <string.h>
#include "signals.h"


typedef struct {
    int number;
    char *name;
} SIGNAME;


static SIGNAME signals[] = {
#include "signames.h"
  { 0,NULL }};


void list_signals(void)
{
    SIGNAME *walk;
    int col;

    col = 0;
    for (walk = signals; walk->name; walk++) {
	if (col+strlen(walk->name)+1 > 80) {
	    putchar('\n');
	    col = 0;
	}
	printf("%s%s",col ? " " : "",walk->name);
	col += strlen(walk->name)+1;
    }
    putchar('\n');
}


int get_signal(char *name,char *cmd)
{
    SIGNAME *walk;

    for (walk = signals; walk->name; walk++)
	if (!strcmp(walk->name,name)) break;
    if (walk->name) return walk->number;
    fprintf(stderr,"%s: unknown signal; %s -l lists signals.\n",name,cmd);
    exit(1);
}
