// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commit.proto

package gitalypb

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type TreeEntryResponse_ObjectType int32

const (
	TreeEntryResponse_COMMIT TreeEntryResponse_ObjectType = 0
	TreeEntryResponse_BLOB   TreeEntryResponse_ObjectType = 1
	TreeEntryResponse_TREE   TreeEntryResponse_ObjectType = 2
	TreeEntryResponse_TAG    TreeEntryResponse_ObjectType = 3
)

var TreeEntryResponse_ObjectType_name = map[int32]string{
	0: "COMMIT",
	1: "BLOB",
	2: "TREE",
	3: "TAG",
}
var TreeEntryResponse_ObjectType_value = map[string]int32{
	"COMMIT": 0,
	"BLOB":   1,
	"TREE":   2,
	"TAG":    3,
}

func (x TreeEntryResponse_ObjectType) String() string {
	return proto.EnumName(TreeEntryResponse_ObjectType_name, int32(x))
}
func (TreeEntryResponse_ObjectType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor2, []int{5, 0}
}

type TreeEntry_EntryType int32

const (
	TreeEntry_BLOB   TreeEntry_EntryType = 0
	TreeEntry_TREE   TreeEntry_EntryType = 1
	TreeEntry_COMMIT TreeEntry_EntryType = 3
)

var TreeEntry_EntryType_name = map[int32]string{
	0: "BLOB",
	1: "TREE",
	3: "COMMIT",
}
var TreeEntry_EntryType_value = map[string]int32{
	"BLOB":   0,
	"TREE":   1,
	"COMMIT": 3,
}

func (x TreeEntry_EntryType) String() string {
	return proto.EnumName(TreeEntry_EntryType_name, int32(x))
}
func (TreeEntry_EntryType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{10, 0} }

type FindAllCommitsRequest_Order int32

const (
	FindAllCommitsRequest_NONE FindAllCommitsRequest_Order = 0
	FindAllCommitsRequest_TOPO FindAllCommitsRequest_Order = 1
	FindAllCommitsRequest_DATE FindAllCommitsRequest_Order = 2
)

var FindAllCommitsRequest_Order_name = map[int32]string{
	0: "NONE",
	1: "TOPO",
	2: "DATE",
}
var FindAllCommitsRequest_Order_value = map[string]int32{
	"NONE": 0,
	"TOPO": 1,
	"DATE": 2,
}

func (x FindAllCommitsRequest_Order) String() string {
	return proto.EnumName(FindAllCommitsRequest_Order_name, int32(x))
}
func (FindAllCommitsRequest_Order) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor2, []int{19, 0}
}

type CommitStatsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitStatsRequest) Reset()                    { *m = CommitStatsRequest{} }
func (m *CommitStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitStatsRequest) ProtoMessage()               {}
func (*CommitStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *CommitStatsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitStatsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitStatsResponse struct {
	// OID is the commit. Empty means not found
	Oid       string `protobuf:"bytes,1,opt,name=oid" json:"oid,omitempty"`
	Additions int32  `protobuf:"varint,2,opt,name=additions" json:"additions,omitempty"`
	Deletions int32  `protobuf:"varint,3,opt,name=deletions" json:"deletions,omitempty"`
}

func (m *CommitStatsResponse) Reset()                    { *m = CommitStatsResponse{} }
func (m *CommitStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitStatsResponse) ProtoMessage()               {}
func (*CommitStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *CommitStatsResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *CommitStatsResponse) GetAdditions() int32 {
	if m != nil {
		return m.Additions
	}
	return 0
}

func (m *CommitStatsResponse) GetDeletions() int32 {
	if m != nil {
		return m.Deletions
	}
	return 0
}

type CommitIsAncestorRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	AncestorId string      `protobuf:"bytes,2,opt,name=ancestor_id,json=ancestorId" json:"ancestor_id,omitempty"`
	ChildId    string      `protobuf:"bytes,3,opt,name=child_id,json=childId" json:"child_id,omitempty"`
}

func (m *CommitIsAncestorRequest) Reset()                    { *m = CommitIsAncestorRequest{} }
func (m *CommitIsAncestorRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitIsAncestorRequest) ProtoMessage()               {}
func (*CommitIsAncestorRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *CommitIsAncestorRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitIsAncestorRequest) GetAncestorId() string {
	if m != nil {
		return m.AncestorId
	}
	return ""
}

func (m *CommitIsAncestorRequest) GetChildId() string {
	if m != nil {
		return m.ChildId
	}
	return ""
}

type CommitIsAncestorResponse struct {
	Value bool `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *CommitIsAncestorResponse) Reset()                    { *m = CommitIsAncestorResponse{} }
func (m *CommitIsAncestorResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitIsAncestorResponse) ProtoMessage()               {}
func (*CommitIsAncestorResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *CommitIsAncestorResponse) GetValue() bool {
	if m != nil {
		return m.Value
	}
	return false
}

type TreeEntryRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// commit ID or refname
	Revision []byte `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	// entry path relative to repository root
	Path  []byte `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Limit int64  `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *TreeEntryRequest) Reset()                    { *m = TreeEntryRequest{} }
func (m *TreeEntryRequest) String() string            { return proto.CompactTextString(m) }
func (*TreeEntryRequest) ProtoMessage()               {}
func (*TreeEntryRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *TreeEntryRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *TreeEntryRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *TreeEntryRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *TreeEntryRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type TreeEntryResponse struct {
	Type TreeEntryResponse_ObjectType `protobuf:"varint,1,opt,name=type,enum=gitaly.TreeEntryResponse_ObjectType" json:"type,omitempty"`
	// SHA1 object ID
	Oid  string `protobuf:"bytes,2,opt,name=oid" json:"oid,omitempty"`
	Size int64  `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
	// file mode
	Mode int32 `protobuf:"varint,4,opt,name=mode" json:"mode,omitempty"`
	// raw object contents
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *TreeEntryResponse) Reset()                    { *m = TreeEntryResponse{} }
func (m *TreeEntryResponse) String() string            { return proto.CompactTextString(m) }
func (*TreeEntryResponse) ProtoMessage()               {}
func (*TreeEntryResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *TreeEntryResponse) GetType() TreeEntryResponse_ObjectType {
	if m != nil {
		return m.Type
	}
	return TreeEntryResponse_COMMIT
}

func (m *TreeEntryResponse) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *TreeEntryResponse) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *TreeEntryResponse) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *TreeEntryResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type CommitsBetweenRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	From       []byte      `protobuf:"bytes,2,opt,name=from,proto3" json:"from,omitempty"`
	To         []byte      `protobuf:"bytes,3,opt,name=to,proto3" json:"to,omitempty"`
}

func (m *CommitsBetweenRequest) Reset()                    { *m = CommitsBetweenRequest{} }
func (m *CommitsBetweenRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitsBetweenRequest) ProtoMessage()               {}
func (*CommitsBetweenRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *CommitsBetweenRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitsBetweenRequest) GetFrom() []byte {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *CommitsBetweenRequest) GetTo() []byte {
	if m != nil {
		return m.To
	}
	return nil
}

type CommitsBetweenResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *CommitsBetweenResponse) Reset()                    { *m = CommitsBetweenResponse{} }
func (m *CommitsBetweenResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitsBetweenResponse) ProtoMessage()               {}
func (*CommitsBetweenResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *CommitsBetweenResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type CountCommitsRequest struct {
	Repository *Repository                `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte                     `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	After      *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=after" json:"after,omitempty"`
	Before     *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=before" json:"before,omitempty"`
	Path       []byte                     `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	MaxCount   int32                      `protobuf:"varint,6,opt,name=max_count,json=maxCount" json:"max_count,omitempty"`
	// all and revision are mutually exclusive
	All bool `protobuf:"varint,7,opt,name=all" json:"all,omitempty"`
}

func (m *CountCommitsRequest) Reset()                    { *m = CountCommitsRequest{} }
func (m *CountCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*CountCommitsRequest) ProtoMessage()               {}
func (*CountCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *CountCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CountCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CountCommitsRequest) GetAfter() *google_protobuf.Timestamp {
	if m != nil {
		return m.After
	}
	return nil
}

func (m *CountCommitsRequest) GetBefore() *google_protobuf.Timestamp {
	if m != nil {
		return m.Before
	}
	return nil
}

func (m *CountCommitsRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *CountCommitsRequest) GetMaxCount() int32 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

func (m *CountCommitsRequest) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

type CountCommitsResponse struct {
	Count int32 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
}

func (m *CountCommitsResponse) Reset()                    { *m = CountCommitsResponse{} }
func (m *CountCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*CountCommitsResponse) ProtoMessage()               {}
func (*CountCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *CountCommitsResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type TreeEntry struct {
	// OID of the object this tree entry points to
	Oid string `protobuf:"bytes,1,opt,name=oid" json:"oid,omitempty"`
	// OID of the tree attached to commit_oid
	RootOid string `protobuf:"bytes,2,opt,name=root_oid,json=rootOid" json:"root_oid,omitempty"`
	// Path relative to repository root
	Path []byte              `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Type TreeEntry_EntryType `protobuf:"varint,4,opt,name=type,enum=gitaly.TreeEntry_EntryType" json:"type,omitempty"`
	// File mode e.g. 0644
	Mode int32 `protobuf:"varint,5,opt,name=mode" json:"mode,omitempty"`
	// The commit object via which this entry was retrieved
	CommitOid string `protobuf:"bytes,6,opt,name=commit_oid,json=commitOid" json:"commit_oid,omitempty"`
	// Relative path of the first subdir that doesn't have only one directory descendant
	FlatPath []byte `protobuf:"bytes,7,opt,name=flat_path,json=flatPath,proto3" json:"flat_path,omitempty"`
}

func (m *TreeEntry) Reset()                    { *m = TreeEntry{} }
func (m *TreeEntry) String() string            { return proto.CompactTextString(m) }
func (*TreeEntry) ProtoMessage()               {}
func (*TreeEntry) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

func (m *TreeEntry) GetOid() string {
	if m != nil {
		return m.Oid
	}
	return ""
}

func (m *TreeEntry) GetRootOid() string {
	if m != nil {
		return m.RootOid
	}
	return ""
}

func (m *TreeEntry) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *TreeEntry) GetType() TreeEntry_EntryType {
	if m != nil {
		return m.Type
	}
	return TreeEntry_BLOB
}

func (m *TreeEntry) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *TreeEntry) GetCommitOid() string {
	if m != nil {
		return m.CommitOid
	}
	return ""
}

func (m *TreeEntry) GetFlatPath() []byte {
	if m != nil {
		return m.FlatPath
	}
	return nil
}

type GetTreeEntriesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	Recursive  bool        `protobuf:"varint,4,opt,name=recursive" json:"recursive,omitempty"`
}

func (m *GetTreeEntriesRequest) Reset()                    { *m = GetTreeEntriesRequest{} }
func (m *GetTreeEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTreeEntriesRequest) ProtoMessage()               {}
func (*GetTreeEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *GetTreeEntriesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *GetTreeEntriesRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

type GetTreeEntriesResponse struct {
	Entries []*TreeEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *GetTreeEntriesResponse) Reset()                    { *m = GetTreeEntriesResponse{} }
func (m *GetTreeEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetTreeEntriesResponse) ProtoMessage()               {}
func (*GetTreeEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{12} }

func (m *GetTreeEntriesResponse) GetEntries() []*TreeEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type ListFilesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *ListFilesRequest) Reset()                    { *m = ListFilesRequest{} }
func (m *ListFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListFilesRequest) ProtoMessage()               {}
func (*ListFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{13} }

func (m *ListFilesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListFilesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

// A single 'page' of the paginated response
type ListFilesResponse struct {
	// Remember to force encoding utf-8 on the client side
	Paths [][]byte `protobuf:"bytes,1,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (m *ListFilesResponse) Reset()                    { *m = ListFilesResponse{} }
func (m *ListFilesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListFilesResponse) ProtoMessage()               {}
func (*ListFilesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{14} }

func (m *ListFilesResponse) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type FindCommitRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *FindCommitRequest) Reset()                    { *m = FindCommitRequest{} }
func (m *FindCommitRequest) String() string            { return proto.CompactTextString(m) }
func (*FindCommitRequest) ProtoMessage()               {}
func (*FindCommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{15} }

func (m *FindCommitRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindCommitRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type FindCommitResponse struct {
	// commit is nil when the commit was not found
	Commit *GitCommit `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
}

func (m *FindCommitResponse) Reset()                    { *m = FindCommitResponse{} }
func (m *FindCommitResponse) String() string            { return proto.CompactTextString(m) }
func (*FindCommitResponse) ProtoMessage()               {}
func (*FindCommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{16} }

func (m *FindCommitResponse) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

type ListCommitsByOidRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Oid        []string    `protobuf:"bytes,2,rep,name=oid" json:"oid,omitempty"`
}

func (m *ListCommitsByOidRequest) Reset()                    { *m = ListCommitsByOidRequest{} }
func (m *ListCommitsByOidRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCommitsByOidRequest) ProtoMessage()               {}
func (*ListCommitsByOidRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{17} }

func (m *ListCommitsByOidRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListCommitsByOidRequest) GetOid() []string {
	if m != nil {
		return m.Oid
	}
	return nil
}

type ListCommitsByOidResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *ListCommitsByOidResponse) Reset()                    { *m = ListCommitsByOidResponse{} }
func (m *ListCommitsByOidResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCommitsByOidResponse) ProtoMessage()               {}
func (*ListCommitsByOidResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{18} }

func (m *ListCommitsByOidResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FindAllCommitsRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	// When nil, return all commits reachable by any branch in the repo
	Revision []byte                      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	MaxCount int32                       `protobuf:"varint,3,opt,name=max_count,json=maxCount" json:"max_count,omitempty"`
	Skip     int32                       `protobuf:"varint,4,opt,name=skip" json:"skip,omitempty"`
	Order    FindAllCommitsRequest_Order `protobuf:"varint,5,opt,name=order,enum=gitaly.FindAllCommitsRequest_Order" json:"order,omitempty"`
}

func (m *FindAllCommitsRequest) Reset()                    { *m = FindAllCommitsRequest{} }
func (m *FindAllCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindAllCommitsRequest) ProtoMessage()               {}
func (*FindAllCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19} }

func (m *FindAllCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindAllCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *FindAllCommitsRequest) GetMaxCount() int32 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

func (m *FindAllCommitsRequest) GetSkip() int32 {
	if m != nil {
		return m.Skip
	}
	return 0
}

func (m *FindAllCommitsRequest) GetOrder() FindAllCommitsRequest_Order {
	if m != nil {
		return m.Order
	}
	return FindAllCommitsRequest_NONE
}

// A single 'page' of the result set
type FindAllCommitsResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *FindAllCommitsResponse) Reset()                    { *m = FindAllCommitsResponse{} }
func (m *FindAllCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindAllCommitsResponse) ProtoMessage()               {}
func (*FindAllCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{20} }

func (m *FindAllCommitsResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FindCommitsRequest struct {
	Repository  *Repository                `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision    []byte                     `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Limit       int32                      `protobuf:"varint,3,opt,name=limit" json:"limit,omitempty"`
	Offset      int32                      `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
	Paths       [][]byte                   `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	Follow      bool                       `protobuf:"varint,6,opt,name=follow" json:"follow,omitempty"`
	SkipMerges  bool                       `protobuf:"varint,7,opt,name=skip_merges,json=skipMerges" json:"skip_merges,omitempty"`
	DisableWalk bool                       `protobuf:"varint,8,opt,name=disable_walk,json=disableWalk" json:"disable_walk,omitempty"`
	After       *google_protobuf.Timestamp `protobuf:"bytes,9,opt,name=after" json:"after,omitempty"`
	Before      *google_protobuf.Timestamp `protobuf:"bytes,10,opt,name=before" json:"before,omitempty"`
	// all and revision are mutually exclusive
	All bool `protobuf:"varint,11,opt,name=all" json:"all,omitempty"`
}

func (m *FindCommitsRequest) Reset()                    { *m = FindCommitsRequest{} }
func (m *FindCommitsRequest) String() string            { return proto.CompactTextString(m) }
func (*FindCommitsRequest) ProtoMessage()               {}
func (*FindCommitsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{21} }

func (m *FindCommitsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FindCommitsRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *FindCommitsRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *FindCommitsRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *FindCommitsRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *FindCommitsRequest) GetFollow() bool {
	if m != nil {
		return m.Follow
	}
	return false
}

func (m *FindCommitsRequest) GetSkipMerges() bool {
	if m != nil {
		return m.SkipMerges
	}
	return false
}

func (m *FindCommitsRequest) GetDisableWalk() bool {
	if m != nil {
		return m.DisableWalk
	}
	return false
}

func (m *FindCommitsRequest) GetAfter() *google_protobuf.Timestamp {
	if m != nil {
		return m.After
	}
	return nil
}

func (m *FindCommitsRequest) GetBefore() *google_protobuf.Timestamp {
	if m != nil {
		return m.Before
	}
	return nil
}

func (m *FindCommitsRequest) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

// A single 'page' of the result set
type FindCommitsResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *FindCommitsResponse) Reset()                    { *m = FindCommitsResponse{} }
func (m *FindCommitsResponse) String() string            { return proto.CompactTextString(m) }
func (*FindCommitsResponse) ProtoMessage()               {}
func (*FindCommitsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{22} }

func (m *FindCommitsResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type CommitLanguagesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (m *CommitLanguagesRequest) Reset()                    { *m = CommitLanguagesRequest{} }
func (m *CommitLanguagesRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitLanguagesRequest) ProtoMessage()               {}
func (*CommitLanguagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{23} }

func (m *CommitLanguagesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitLanguagesRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitLanguagesResponse struct {
	Languages []*CommitLanguagesResponse_Language `protobuf:"bytes,1,rep,name=languages" json:"languages,omitempty"`
}

func (m *CommitLanguagesResponse) Reset()                    { *m = CommitLanguagesResponse{} }
func (m *CommitLanguagesResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitLanguagesResponse) ProtoMessage()               {}
func (*CommitLanguagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{24} }

func (m *CommitLanguagesResponse) GetLanguages() []*CommitLanguagesResponse_Language {
	if m != nil {
		return m.Languages
	}
	return nil
}

type CommitLanguagesResponse_Language struct {
	Name  string  `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Share float32 `protobuf:"fixed32,2,opt,name=share" json:"share,omitempty"`
	Color string  `protobuf:"bytes,3,opt,name=color" json:"color,omitempty"`
}

func (m *CommitLanguagesResponse_Language) Reset()         { *m = CommitLanguagesResponse_Language{} }
func (m *CommitLanguagesResponse_Language) String() string { return proto.CompactTextString(m) }
func (*CommitLanguagesResponse_Language) ProtoMessage()    {}
func (*CommitLanguagesResponse_Language) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{24, 0}
}

func (m *CommitLanguagesResponse_Language) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CommitLanguagesResponse_Language) GetShare() float32 {
	if m != nil {
		return m.Share
	}
	return 0
}

func (m *CommitLanguagesResponse_Language) GetColor() string {
	if m != nil {
		return m.Color
	}
	return ""
}

type RawBlameRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *RawBlameRequest) Reset()                    { *m = RawBlameRequest{} }
func (m *RawBlameRequest) String() string            { return proto.CompactTextString(m) }
func (*RawBlameRequest) ProtoMessage()               {}
func (*RawBlameRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{25} }

func (m *RawBlameRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawBlameRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *RawBlameRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type RawBlameResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *RawBlameResponse) Reset()                    { *m = RawBlameResponse{} }
func (m *RawBlameResponse) String() string            { return proto.CompactTextString(m) }
func (*RawBlameResponse) ProtoMessage()               {}
func (*RawBlameResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{26} }

func (m *RawBlameResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type LastCommitForPathRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *LastCommitForPathRequest) Reset()                    { *m = LastCommitForPathRequest{} }
func (m *LastCommitForPathRequest) String() string            { return proto.CompactTextString(m) }
func (*LastCommitForPathRequest) ProtoMessage()               {}
func (*LastCommitForPathRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{27} }

func (m *LastCommitForPathRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *LastCommitForPathRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *LastCommitForPathRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

type LastCommitForPathResponse struct {
	// commit is nil when the commit was not found
	Commit *GitCommit `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
}

func (m *LastCommitForPathResponse) Reset()                    { *m = LastCommitForPathResponse{} }
func (m *LastCommitForPathResponse) String() string            { return proto.CompactTextString(m) }
func (*LastCommitForPathResponse) ProtoMessage()               {}
func (*LastCommitForPathResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{28} }

func (m *LastCommitForPathResponse) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

type ListLastCommitsForTreeRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   string      `protobuf:"bytes,2,opt,name=revision" json:"revision,omitempty"`
	Path       []byte      `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// limit == -1 will get the last commit for all paths
	Limit  int32 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
	Offset int32 `protobuf:"varint,5,opt,name=offset" json:"offset,omitempty"`
}

func (m *ListLastCommitsForTreeRequest) Reset()                    { *m = ListLastCommitsForTreeRequest{} }
func (m *ListLastCommitsForTreeRequest) String() string            { return proto.CompactTextString(m) }
func (*ListLastCommitsForTreeRequest) ProtoMessage()               {}
func (*ListLastCommitsForTreeRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{29} }

func (m *ListLastCommitsForTreeRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ListLastCommitsForTreeRequest) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *ListLastCommitsForTreeRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *ListLastCommitsForTreeRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListLastCommitsForTreeRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type ListLastCommitsForTreeResponse struct {
	Commits []*ListLastCommitsForTreeResponse_CommitForTree `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *ListLastCommitsForTreeResponse) Reset()                    { *m = ListLastCommitsForTreeResponse{} }
func (m *ListLastCommitsForTreeResponse) String() string            { return proto.CompactTextString(m) }
func (*ListLastCommitsForTreeResponse) ProtoMessage()               {}
func (*ListLastCommitsForTreeResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{30} }

func (m *ListLastCommitsForTreeResponse) GetCommits() []*ListLastCommitsForTreeResponse_CommitForTree {
	if m != nil {
		return m.Commits
	}
	return nil
}

type ListLastCommitsForTreeResponse_CommitForTree struct {
	Commit *GitCommit `protobuf:"bytes,2,opt,name=commit" json:"commit,omitempty"`
	Path   string     `protobuf:"bytes,3,opt,name=path" json:"path,omitempty"`
}

func (m *ListLastCommitsForTreeResponse_CommitForTree) Reset() {
	*m = ListLastCommitsForTreeResponse_CommitForTree{}
}
func (m *ListLastCommitsForTreeResponse_CommitForTree) String() string {
	return proto.CompactTextString(m)
}
func (*ListLastCommitsForTreeResponse_CommitForTree) ProtoMessage() {}
func (*ListLastCommitsForTreeResponse_CommitForTree) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{30, 0}
}

func (m *ListLastCommitsForTreeResponse_CommitForTree) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *ListLastCommitsForTreeResponse_CommitForTree) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type CommitsByMessageRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Revision   []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Offset     int32       `protobuf:"varint,3,opt,name=offset" json:"offset,omitempty"`
	Limit      int32       `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
	Path       []byte      `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	Query      string      `protobuf:"bytes,6,opt,name=query" json:"query,omitempty"`
}

func (m *CommitsByMessageRequest) Reset()                    { *m = CommitsByMessageRequest{} }
func (m *CommitsByMessageRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitsByMessageRequest) ProtoMessage()               {}
func (*CommitsByMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{31} }

func (m *CommitsByMessageRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitsByMessageRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CommitsByMessageRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *CommitsByMessageRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *CommitsByMessageRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *CommitsByMessageRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

// One 'page' of the paginated response of CommitsByMessage
type CommitsByMessageResponse struct {
	Commits []*GitCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
}

func (m *CommitsByMessageResponse) Reset()                    { *m = CommitsByMessageResponse{} }
func (m *CommitsByMessageResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitsByMessageResponse) ProtoMessage()               {}
func (*CommitsByMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{32} }

func (m *CommitsByMessageResponse) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

type FilterShasWithSignaturesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	Shas       [][]byte    `protobuf:"bytes,2,rep,name=shas,proto3" json:"shas,omitempty"`
}

func (m *FilterShasWithSignaturesRequest) Reset()         { *m = FilterShasWithSignaturesRequest{} }
func (m *FilterShasWithSignaturesRequest) String() string { return proto.CompactTextString(m) }
func (*FilterShasWithSignaturesRequest) ProtoMessage()    {}
func (*FilterShasWithSignaturesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{33}
}

func (m *FilterShasWithSignaturesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *FilterShasWithSignaturesRequest) GetShas() [][]byte {
	if m != nil {
		return m.Shas
	}
	return nil
}

type FilterShasWithSignaturesResponse struct {
	Shas [][]byte `protobuf:"bytes,1,rep,name=shas,proto3" json:"shas,omitempty"`
}

func (m *FilterShasWithSignaturesResponse) Reset()         { *m = FilterShasWithSignaturesResponse{} }
func (m *FilterShasWithSignaturesResponse) String() string { return proto.CompactTextString(m) }
func (*FilterShasWithSignaturesResponse) ProtoMessage()    {}
func (*FilterShasWithSignaturesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{34}
}

func (m *FilterShasWithSignaturesResponse) GetShas() [][]byte {
	if m != nil {
		return m.Shas
	}
	return nil
}

type ExtractCommitSignatureRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitId   string      `protobuf:"bytes,2,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
}

func (m *ExtractCommitSignatureRequest) Reset()                    { *m = ExtractCommitSignatureRequest{} }
func (m *ExtractCommitSignatureRequest) String() string            { return proto.CompactTextString(m) }
func (*ExtractCommitSignatureRequest) ProtoMessage()               {}
func (*ExtractCommitSignatureRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{35} }

func (m *ExtractCommitSignatureRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *ExtractCommitSignatureRequest) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

// Either of the 'signature' and 'signed_text' fields may be present. It
// is up to the caller to stitch them together.
type ExtractCommitSignatureResponse struct {
	Signature  []byte `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
	SignedText []byte `protobuf:"bytes,2,opt,name=signed_text,json=signedText,proto3" json:"signed_text,omitempty"`
}

func (m *ExtractCommitSignatureResponse) Reset()                    { *m = ExtractCommitSignatureResponse{} }
func (m *ExtractCommitSignatureResponse) String() string            { return proto.CompactTextString(m) }
func (*ExtractCommitSignatureResponse) ProtoMessage()               {}
func (*ExtractCommitSignatureResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{36} }

func (m *ExtractCommitSignatureResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *ExtractCommitSignatureResponse) GetSignedText() []byte {
	if m != nil {
		return m.SignedText
	}
	return nil
}

type GetCommitSignaturesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitIds  []string    `protobuf:"bytes,2,rep,name=commit_ids,json=commitIds" json:"commit_ids,omitempty"`
}

func (m *GetCommitSignaturesRequest) Reset()                    { *m = GetCommitSignaturesRequest{} }
func (m *GetCommitSignaturesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCommitSignaturesRequest) ProtoMessage()               {}
func (*GetCommitSignaturesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{37} }

func (m *GetCommitSignaturesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetCommitSignaturesRequest) GetCommitIds() []string {
	if m != nil {
		return m.CommitIds
	}
	return nil
}

type GetCommitSignaturesResponse struct {
	// Only present for a new commit signature data.
	CommitId string `protobuf:"bytes,1,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	// See ExtractCommitSignatureResponse above for how these fields should be handled.
	Signature  []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	SignedText []byte `protobuf:"bytes,3,opt,name=signed_text,json=signedText,proto3" json:"signed_text,omitempty"`
}

func (m *GetCommitSignaturesResponse) Reset()                    { *m = GetCommitSignaturesResponse{} }
func (m *GetCommitSignaturesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetCommitSignaturesResponse) ProtoMessage()               {}
func (*GetCommitSignaturesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{38} }

func (m *GetCommitSignaturesResponse) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *GetCommitSignaturesResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *GetCommitSignaturesResponse) GetSignedText() []byte {
	if m != nil {
		return m.SignedText
	}
	return nil
}

type GetCommitMessagesRequest struct {
	Repository *Repository `protobuf:"bytes,1,opt,name=repository" json:"repository,omitempty"`
	CommitIds  []string    `protobuf:"bytes,2,rep,name=commit_ids,json=commitIds" json:"commit_ids,omitempty"`
}

func (m *GetCommitMessagesRequest) Reset()                    { *m = GetCommitMessagesRequest{} }
func (m *GetCommitMessagesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCommitMessagesRequest) ProtoMessage()               {}
func (*GetCommitMessagesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{39} }

func (m *GetCommitMessagesRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *GetCommitMessagesRequest) GetCommitIds() []string {
	if m != nil {
		return m.CommitIds
	}
	return nil
}

type GetCommitMessagesResponse struct {
	// Only present for a new commit message
	CommitId string `protobuf:"bytes,1,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	Message  []byte `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *GetCommitMessagesResponse) Reset()                    { *m = GetCommitMessagesResponse{} }
func (m *GetCommitMessagesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetCommitMessagesResponse) ProtoMessage()               {}
func (*GetCommitMessagesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{40} }

func (m *GetCommitMessagesResponse) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *GetCommitMessagesResponse) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func init() {
	proto.RegisterType((*CommitStatsRequest)(nil), "gitaly.CommitStatsRequest")
	proto.RegisterType((*CommitStatsResponse)(nil), "gitaly.CommitStatsResponse")
	proto.RegisterType((*CommitIsAncestorRequest)(nil), "gitaly.CommitIsAncestorRequest")
	proto.RegisterType((*CommitIsAncestorResponse)(nil), "gitaly.CommitIsAncestorResponse")
	proto.RegisterType((*TreeEntryRequest)(nil), "gitaly.TreeEntryRequest")
	proto.RegisterType((*TreeEntryResponse)(nil), "gitaly.TreeEntryResponse")
	proto.RegisterType((*CommitsBetweenRequest)(nil), "gitaly.CommitsBetweenRequest")
	proto.RegisterType((*CommitsBetweenResponse)(nil), "gitaly.CommitsBetweenResponse")
	proto.RegisterType((*CountCommitsRequest)(nil), "gitaly.CountCommitsRequest")
	proto.RegisterType((*CountCommitsResponse)(nil), "gitaly.CountCommitsResponse")
	proto.RegisterType((*TreeEntry)(nil), "gitaly.TreeEntry")
	proto.RegisterType((*GetTreeEntriesRequest)(nil), "gitaly.GetTreeEntriesRequest")
	proto.RegisterType((*GetTreeEntriesResponse)(nil), "gitaly.GetTreeEntriesResponse")
	proto.RegisterType((*ListFilesRequest)(nil), "gitaly.ListFilesRequest")
	proto.RegisterType((*ListFilesResponse)(nil), "gitaly.ListFilesResponse")
	proto.RegisterType((*FindCommitRequest)(nil), "gitaly.FindCommitRequest")
	proto.RegisterType((*FindCommitResponse)(nil), "gitaly.FindCommitResponse")
	proto.RegisterType((*ListCommitsByOidRequest)(nil), "gitaly.ListCommitsByOidRequest")
	proto.RegisterType((*ListCommitsByOidResponse)(nil), "gitaly.ListCommitsByOidResponse")
	proto.RegisterType((*FindAllCommitsRequest)(nil), "gitaly.FindAllCommitsRequest")
	proto.RegisterType((*FindAllCommitsResponse)(nil), "gitaly.FindAllCommitsResponse")
	proto.RegisterType((*FindCommitsRequest)(nil), "gitaly.FindCommitsRequest")
	proto.RegisterType((*FindCommitsResponse)(nil), "gitaly.FindCommitsResponse")
	proto.RegisterType((*CommitLanguagesRequest)(nil), "gitaly.CommitLanguagesRequest")
	proto.RegisterType((*CommitLanguagesResponse)(nil), "gitaly.CommitLanguagesResponse")
	proto.RegisterType((*CommitLanguagesResponse_Language)(nil), "gitaly.CommitLanguagesResponse.Language")
	proto.RegisterType((*RawBlameRequest)(nil), "gitaly.RawBlameRequest")
	proto.RegisterType((*RawBlameResponse)(nil), "gitaly.RawBlameResponse")
	proto.RegisterType((*LastCommitForPathRequest)(nil), "gitaly.LastCommitForPathRequest")
	proto.RegisterType((*LastCommitForPathResponse)(nil), "gitaly.LastCommitForPathResponse")
	proto.RegisterType((*ListLastCommitsForTreeRequest)(nil), "gitaly.ListLastCommitsForTreeRequest")
	proto.RegisterType((*ListLastCommitsForTreeResponse)(nil), "gitaly.ListLastCommitsForTreeResponse")
	proto.RegisterType((*ListLastCommitsForTreeResponse_CommitForTree)(nil), "gitaly.ListLastCommitsForTreeResponse.CommitForTree")
	proto.RegisterType((*CommitsByMessageRequest)(nil), "gitaly.CommitsByMessageRequest")
	proto.RegisterType((*CommitsByMessageResponse)(nil), "gitaly.CommitsByMessageResponse")
	proto.RegisterType((*FilterShasWithSignaturesRequest)(nil), "gitaly.FilterShasWithSignaturesRequest")
	proto.RegisterType((*FilterShasWithSignaturesResponse)(nil), "gitaly.FilterShasWithSignaturesResponse")
	proto.RegisterType((*ExtractCommitSignatureRequest)(nil), "gitaly.ExtractCommitSignatureRequest")
	proto.RegisterType((*ExtractCommitSignatureResponse)(nil), "gitaly.ExtractCommitSignatureResponse")
	proto.RegisterType((*GetCommitSignaturesRequest)(nil), "gitaly.GetCommitSignaturesRequest")
	proto.RegisterType((*GetCommitSignaturesResponse)(nil), "gitaly.GetCommitSignaturesResponse")
	proto.RegisterType((*GetCommitMessagesRequest)(nil), "gitaly.GetCommitMessagesRequest")
	proto.RegisterType((*GetCommitMessagesResponse)(nil), "gitaly.GetCommitMessagesResponse")
	proto.RegisterEnum("gitaly.TreeEntryResponse_ObjectType", TreeEntryResponse_ObjectType_name, TreeEntryResponse_ObjectType_value)
	proto.RegisterEnum("gitaly.TreeEntry_EntryType", TreeEntry_EntryType_name, TreeEntry_EntryType_value)
	proto.RegisterEnum("gitaly.FindAllCommitsRequest_Order", FindAllCommitsRequest_Order_name, FindAllCommitsRequest_Order_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CommitService service

type CommitServiceClient interface {
	CommitIsAncestor(ctx context.Context, in *CommitIsAncestorRequest, opts ...grpc.CallOption) (*CommitIsAncestorResponse, error)
	TreeEntry(ctx context.Context, in *TreeEntryRequest, opts ...grpc.CallOption) (CommitService_TreeEntryClient, error)
	CommitsBetween(ctx context.Context, in *CommitsBetweenRequest, opts ...grpc.CallOption) (CommitService_CommitsBetweenClient, error)
	CountCommits(ctx context.Context, in *CountCommitsRequest, opts ...grpc.CallOption) (*CountCommitsResponse, error)
	GetTreeEntries(ctx context.Context, in *GetTreeEntriesRequest, opts ...grpc.CallOption) (CommitService_GetTreeEntriesClient, error)
	ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (CommitService_ListFilesClient, error)
	FindCommit(ctx context.Context, in *FindCommitRequest, opts ...grpc.CallOption) (*FindCommitResponse, error)
	CommitStats(ctx context.Context, in *CommitStatsRequest, opts ...grpc.CallOption) (*CommitStatsResponse, error)
	// Use a stream to paginate the result set
	FindAllCommits(ctx context.Context, in *FindAllCommitsRequest, opts ...grpc.CallOption) (CommitService_FindAllCommitsClient, error)
	FindCommits(ctx context.Context, in *FindCommitsRequest, opts ...grpc.CallOption) (CommitService_FindCommitsClient, error)
	CommitLanguages(ctx context.Context, in *CommitLanguagesRequest, opts ...grpc.CallOption) (*CommitLanguagesResponse, error)
	RawBlame(ctx context.Context, in *RawBlameRequest, opts ...grpc.CallOption) (CommitService_RawBlameClient, error)
	LastCommitForPath(ctx context.Context, in *LastCommitForPathRequest, opts ...grpc.CallOption) (*LastCommitForPathResponse, error)
	ListLastCommitsForTree(ctx context.Context, in *ListLastCommitsForTreeRequest, opts ...grpc.CallOption) (CommitService_ListLastCommitsForTreeClient, error)
	CommitsByMessage(ctx context.Context, in *CommitsByMessageRequest, opts ...grpc.CallOption) (CommitService_CommitsByMessageClient, error)
	ListCommitsByOid(ctx context.Context, in *ListCommitsByOidRequest, opts ...grpc.CallOption) (CommitService_ListCommitsByOidClient, error)
	FilterShasWithSignatures(ctx context.Context, opts ...grpc.CallOption) (CommitService_FilterShasWithSignaturesClient, error)
	// ExtractCommitSignature returns a stream because the signed text may be
	// arbitrarily large and signature verification is impossible without the
	// full text.
	ExtractCommitSignature(ctx context.Context, in *ExtractCommitSignatureRequest, opts ...grpc.CallOption) (CommitService_ExtractCommitSignatureClient, error)
	GetCommitSignatures(ctx context.Context, in *GetCommitSignaturesRequest, opts ...grpc.CallOption) (CommitService_GetCommitSignaturesClient, error)
	GetCommitMessages(ctx context.Context, in *GetCommitMessagesRequest, opts ...grpc.CallOption) (CommitService_GetCommitMessagesClient, error)
}

type commitServiceClient struct {
	cc *grpc.ClientConn
}

func NewCommitServiceClient(cc *grpc.ClientConn) CommitServiceClient {
	return &commitServiceClient{cc}
}

func (c *commitServiceClient) CommitIsAncestor(ctx context.Context, in *CommitIsAncestorRequest, opts ...grpc.CallOption) (*CommitIsAncestorResponse, error) {
	out := new(CommitIsAncestorResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitIsAncestor", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) TreeEntry(ctx context.Context, in *TreeEntryRequest, opts ...grpc.CallOption) (CommitService_TreeEntryClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[0], c.cc, "/gitaly.CommitService/TreeEntry", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceTreeEntryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_TreeEntryClient interface {
	Recv() (*TreeEntryResponse, error)
	grpc.ClientStream
}

type commitServiceTreeEntryClient struct {
	grpc.ClientStream
}

func (x *commitServiceTreeEntryClient) Recv() (*TreeEntryResponse, error) {
	m := new(TreeEntryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitsBetween(ctx context.Context, in *CommitsBetweenRequest, opts ...grpc.CallOption) (CommitService_CommitsBetweenClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[1], c.cc, "/gitaly.CommitService/CommitsBetween", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceCommitsBetweenClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_CommitsBetweenClient interface {
	Recv() (*CommitsBetweenResponse, error)
	grpc.ClientStream
}

type commitServiceCommitsBetweenClient struct {
	grpc.ClientStream
}

func (x *commitServiceCommitsBetweenClient) Recv() (*CommitsBetweenResponse, error) {
	m := new(CommitsBetweenResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CountCommits(ctx context.Context, in *CountCommitsRequest, opts ...grpc.CallOption) (*CountCommitsResponse, error) {
	out := new(CountCommitsResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CountCommits", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) GetTreeEntries(ctx context.Context, in *GetTreeEntriesRequest, opts ...grpc.CallOption) (CommitService_GetTreeEntriesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[2], c.cc, "/gitaly.CommitService/GetTreeEntries", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceGetTreeEntriesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_GetTreeEntriesClient interface {
	Recv() (*GetTreeEntriesResponse, error)
	grpc.ClientStream
}

type commitServiceGetTreeEntriesClient struct {
	grpc.ClientStream
}

func (x *commitServiceGetTreeEntriesClient) Recv() (*GetTreeEntriesResponse, error) {
	m := new(GetTreeEntriesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (CommitService_ListFilesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[3], c.cc, "/gitaly.CommitService/ListFiles", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceListFilesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ListFilesClient interface {
	Recv() (*ListFilesResponse, error)
	grpc.ClientStream
}

type commitServiceListFilesClient struct {
	grpc.ClientStream
}

func (x *commitServiceListFilesClient) Recv() (*ListFilesResponse, error) {
	m := new(ListFilesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FindCommit(ctx context.Context, in *FindCommitRequest, opts ...grpc.CallOption) (*FindCommitResponse, error) {
	out := new(FindCommitResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/FindCommit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) CommitStats(ctx context.Context, in *CommitStatsRequest, opts ...grpc.CallOption) (*CommitStatsResponse, error) {
	out := new(CommitStatsResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) FindAllCommits(ctx context.Context, in *FindAllCommitsRequest, opts ...grpc.CallOption) (CommitService_FindAllCommitsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[4], c.cc, "/gitaly.CommitService/FindAllCommits", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFindAllCommitsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_FindAllCommitsClient interface {
	Recv() (*FindAllCommitsResponse, error)
	grpc.ClientStream
}

type commitServiceFindAllCommitsClient struct {
	grpc.ClientStream
}

func (x *commitServiceFindAllCommitsClient) Recv() (*FindAllCommitsResponse, error) {
	m := new(FindAllCommitsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FindCommits(ctx context.Context, in *FindCommitsRequest, opts ...grpc.CallOption) (CommitService_FindCommitsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[5], c.cc, "/gitaly.CommitService/FindCommits", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFindCommitsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_FindCommitsClient interface {
	Recv() (*FindCommitsResponse, error)
	grpc.ClientStream
}

type commitServiceFindCommitsClient struct {
	grpc.ClientStream
}

func (x *commitServiceFindCommitsClient) Recv() (*FindCommitsResponse, error) {
	m := new(FindCommitsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitLanguages(ctx context.Context, in *CommitLanguagesRequest, opts ...grpc.CallOption) (*CommitLanguagesResponse, error) {
	out := new(CommitLanguagesResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/CommitLanguages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) RawBlame(ctx context.Context, in *RawBlameRequest, opts ...grpc.CallOption) (CommitService_RawBlameClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[6], c.cc, "/gitaly.CommitService/RawBlame", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceRawBlameClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_RawBlameClient interface {
	Recv() (*RawBlameResponse, error)
	grpc.ClientStream
}

type commitServiceRawBlameClient struct {
	grpc.ClientStream
}

func (x *commitServiceRawBlameClient) Recv() (*RawBlameResponse, error) {
	m := new(RawBlameResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) LastCommitForPath(ctx context.Context, in *LastCommitForPathRequest, opts ...grpc.CallOption) (*LastCommitForPathResponse, error) {
	out := new(LastCommitForPathResponse)
	err := grpc.Invoke(ctx, "/gitaly.CommitService/LastCommitForPath", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *commitServiceClient) ListLastCommitsForTree(ctx context.Context, in *ListLastCommitsForTreeRequest, opts ...grpc.CallOption) (CommitService_ListLastCommitsForTreeClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[7], c.cc, "/gitaly.CommitService/ListLastCommitsForTree", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceListLastCommitsForTreeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ListLastCommitsForTreeClient interface {
	Recv() (*ListLastCommitsForTreeResponse, error)
	grpc.ClientStream
}

type commitServiceListLastCommitsForTreeClient struct {
	grpc.ClientStream
}

func (x *commitServiceListLastCommitsForTreeClient) Recv() (*ListLastCommitsForTreeResponse, error) {
	m := new(ListLastCommitsForTreeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) CommitsByMessage(ctx context.Context, in *CommitsByMessageRequest, opts ...grpc.CallOption) (CommitService_CommitsByMessageClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[8], c.cc, "/gitaly.CommitService/CommitsByMessage", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceCommitsByMessageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_CommitsByMessageClient interface {
	Recv() (*CommitsByMessageResponse, error)
	grpc.ClientStream
}

type commitServiceCommitsByMessageClient struct {
	grpc.ClientStream
}

func (x *commitServiceCommitsByMessageClient) Recv() (*CommitsByMessageResponse, error) {
	m := new(CommitsByMessageResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ListCommitsByOid(ctx context.Context, in *ListCommitsByOidRequest, opts ...grpc.CallOption) (CommitService_ListCommitsByOidClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[9], c.cc, "/gitaly.CommitService/ListCommitsByOid", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceListCommitsByOidClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ListCommitsByOidClient interface {
	Recv() (*ListCommitsByOidResponse, error)
	grpc.ClientStream
}

type commitServiceListCommitsByOidClient struct {
	grpc.ClientStream
}

func (x *commitServiceListCommitsByOidClient) Recv() (*ListCommitsByOidResponse, error) {
	m := new(ListCommitsByOidResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) FilterShasWithSignatures(ctx context.Context, opts ...grpc.CallOption) (CommitService_FilterShasWithSignaturesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[10], c.cc, "/gitaly.CommitService/FilterShasWithSignatures", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceFilterShasWithSignaturesClient{stream}
	return x, nil
}

type CommitService_FilterShasWithSignaturesClient interface {
	Send(*FilterShasWithSignaturesRequest) error
	Recv() (*FilterShasWithSignaturesResponse, error)
	grpc.ClientStream
}

type commitServiceFilterShasWithSignaturesClient struct {
	grpc.ClientStream
}

func (x *commitServiceFilterShasWithSignaturesClient) Send(m *FilterShasWithSignaturesRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *commitServiceFilterShasWithSignaturesClient) Recv() (*FilterShasWithSignaturesResponse, error) {
	m := new(FilterShasWithSignaturesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) ExtractCommitSignature(ctx context.Context, in *ExtractCommitSignatureRequest, opts ...grpc.CallOption) (CommitService_ExtractCommitSignatureClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[11], c.cc, "/gitaly.CommitService/ExtractCommitSignature", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceExtractCommitSignatureClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_ExtractCommitSignatureClient interface {
	Recv() (*ExtractCommitSignatureResponse, error)
	grpc.ClientStream
}

type commitServiceExtractCommitSignatureClient struct {
	grpc.ClientStream
}

func (x *commitServiceExtractCommitSignatureClient) Recv() (*ExtractCommitSignatureResponse, error) {
	m := new(ExtractCommitSignatureResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) GetCommitSignatures(ctx context.Context, in *GetCommitSignaturesRequest, opts ...grpc.CallOption) (CommitService_GetCommitSignaturesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[12], c.cc, "/gitaly.CommitService/GetCommitSignatures", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceGetCommitSignaturesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_GetCommitSignaturesClient interface {
	Recv() (*GetCommitSignaturesResponse, error)
	grpc.ClientStream
}

type commitServiceGetCommitSignaturesClient struct {
	grpc.ClientStream
}

func (x *commitServiceGetCommitSignaturesClient) Recv() (*GetCommitSignaturesResponse, error) {
	m := new(GetCommitSignaturesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *commitServiceClient) GetCommitMessages(ctx context.Context, in *GetCommitMessagesRequest, opts ...grpc.CallOption) (CommitService_GetCommitMessagesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_CommitService_serviceDesc.Streams[13], c.cc, "/gitaly.CommitService/GetCommitMessages", opts...)
	if err != nil {
		return nil, err
	}
	x := &commitServiceGetCommitMessagesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type CommitService_GetCommitMessagesClient interface {
	Recv() (*GetCommitMessagesResponse, error)
	grpc.ClientStream
}

type commitServiceGetCommitMessagesClient struct {
	grpc.ClientStream
}

func (x *commitServiceGetCommitMessagesClient) Recv() (*GetCommitMessagesResponse, error) {
	m := new(GetCommitMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for CommitService service

type CommitServiceServer interface {
	CommitIsAncestor(context.Context, *CommitIsAncestorRequest) (*CommitIsAncestorResponse, error)
	TreeEntry(*TreeEntryRequest, CommitService_TreeEntryServer) error
	CommitsBetween(*CommitsBetweenRequest, CommitService_CommitsBetweenServer) error
	CountCommits(context.Context, *CountCommitsRequest) (*CountCommitsResponse, error)
	GetTreeEntries(*GetTreeEntriesRequest, CommitService_GetTreeEntriesServer) error
	ListFiles(*ListFilesRequest, CommitService_ListFilesServer) error
	FindCommit(context.Context, *FindCommitRequest) (*FindCommitResponse, error)
	CommitStats(context.Context, *CommitStatsRequest) (*CommitStatsResponse, error)
	// Use a stream to paginate the result set
	FindAllCommits(*FindAllCommitsRequest, CommitService_FindAllCommitsServer) error
	FindCommits(*FindCommitsRequest, CommitService_FindCommitsServer) error
	CommitLanguages(context.Context, *CommitLanguagesRequest) (*CommitLanguagesResponse, error)
	RawBlame(*RawBlameRequest, CommitService_RawBlameServer) error
	LastCommitForPath(context.Context, *LastCommitForPathRequest) (*LastCommitForPathResponse, error)
	ListLastCommitsForTree(*ListLastCommitsForTreeRequest, CommitService_ListLastCommitsForTreeServer) error
	CommitsByMessage(*CommitsByMessageRequest, CommitService_CommitsByMessageServer) error
	ListCommitsByOid(*ListCommitsByOidRequest, CommitService_ListCommitsByOidServer) error
	FilterShasWithSignatures(CommitService_FilterShasWithSignaturesServer) error
	// ExtractCommitSignature returns a stream because the signed text may be
	// arbitrarily large and signature verification is impossible without the
	// full text.
	ExtractCommitSignature(*ExtractCommitSignatureRequest, CommitService_ExtractCommitSignatureServer) error
	GetCommitSignatures(*GetCommitSignaturesRequest, CommitService_GetCommitSignaturesServer) error
	GetCommitMessages(*GetCommitMessagesRequest, CommitService_GetCommitMessagesServer) error
}

func RegisterCommitServiceServer(s *grpc.Server, srv CommitServiceServer) {
	s.RegisterService(&_CommitService_serviceDesc, srv)
}

func _CommitService_CommitIsAncestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitIsAncestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitIsAncestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitIsAncestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitIsAncestor(ctx, req.(*CommitIsAncestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_TreeEntry_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TreeEntryRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).TreeEntry(m, &commitServiceTreeEntryServer{stream})
}

type CommitService_TreeEntryServer interface {
	Send(*TreeEntryResponse) error
	grpc.ServerStream
}

type commitServiceTreeEntryServer struct {
	grpc.ServerStream
}

func (x *commitServiceTreeEntryServer) Send(m *TreeEntryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitsBetween_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitsBetweenRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).CommitsBetween(m, &commitServiceCommitsBetweenServer{stream})
}

type CommitService_CommitsBetweenServer interface {
	Send(*CommitsBetweenResponse) error
	grpc.ServerStream
}

type commitServiceCommitsBetweenServer struct {
	grpc.ServerStream
}

func (x *commitServiceCommitsBetweenServer) Send(m *CommitsBetweenResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CountCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CountCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CountCommits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CountCommits(ctx, req.(*CountCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_GetTreeEntries_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTreeEntriesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).GetTreeEntries(m, &commitServiceGetTreeEntriesServer{stream})
}

type CommitService_GetTreeEntriesServer interface {
	Send(*GetTreeEntriesResponse) error
	grpc.ServerStream
}

type commitServiceGetTreeEntriesServer struct {
	grpc.ServerStream
}

func (x *commitServiceGetTreeEntriesServer) Send(m *GetTreeEntriesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_ListFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListFilesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ListFiles(m, &commitServiceListFilesServer{stream})
}

type CommitService_ListFilesServer interface {
	Send(*ListFilesResponse) error
	grpc.ServerStream
}

type commitServiceListFilesServer struct {
	grpc.ServerStream
}

func (x *commitServiceListFilesServer) Send(m *ListFilesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FindCommit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindCommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).FindCommit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/FindCommit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).FindCommit(ctx, req.(*FindCommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_CommitStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitStats(ctx, req.(*CommitStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_FindAllCommits_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllCommitsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).FindAllCommits(m, &commitServiceFindAllCommitsServer{stream})
}

type CommitService_FindAllCommitsServer interface {
	Send(*FindAllCommitsResponse) error
	grpc.ServerStream
}

type commitServiceFindAllCommitsServer struct {
	grpc.ServerStream
}

func (x *commitServiceFindAllCommitsServer) Send(m *FindAllCommitsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FindCommits_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindCommitsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).FindCommits(m, &commitServiceFindCommitsServer{stream})
}

type CommitService_FindCommitsServer interface {
	Send(*FindCommitsResponse) error
	grpc.ServerStream
}

type commitServiceFindCommitsServer struct {
	grpc.ServerStream
}

func (x *commitServiceFindCommitsServer) Send(m *FindCommitsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitLanguages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitLanguagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).CommitLanguages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/CommitLanguages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).CommitLanguages(ctx, req.(*CommitLanguagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_RawBlame_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawBlameRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).RawBlame(m, &commitServiceRawBlameServer{stream})
}

type CommitService_RawBlameServer interface {
	Send(*RawBlameResponse) error
	grpc.ServerStream
}

type commitServiceRawBlameServer struct {
	grpc.ServerStream
}

func (x *commitServiceRawBlameServer) Send(m *RawBlameResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_LastCommitForPath_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LastCommitForPathRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CommitServiceServer).LastCommitForPath(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gitaly.CommitService/LastCommitForPath",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CommitServiceServer).LastCommitForPath(ctx, req.(*LastCommitForPathRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CommitService_ListLastCommitsForTree_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListLastCommitsForTreeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ListLastCommitsForTree(m, &commitServiceListLastCommitsForTreeServer{stream})
}

type CommitService_ListLastCommitsForTreeServer interface {
	Send(*ListLastCommitsForTreeResponse) error
	grpc.ServerStream
}

type commitServiceListLastCommitsForTreeServer struct {
	grpc.ServerStream
}

func (x *commitServiceListLastCommitsForTreeServer) Send(m *ListLastCommitsForTreeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_CommitsByMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitsByMessageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).CommitsByMessage(m, &commitServiceCommitsByMessageServer{stream})
}

type CommitService_CommitsByMessageServer interface {
	Send(*CommitsByMessageResponse) error
	grpc.ServerStream
}

type commitServiceCommitsByMessageServer struct {
	grpc.ServerStream
}

func (x *commitServiceCommitsByMessageServer) Send(m *CommitsByMessageResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_ListCommitsByOid_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListCommitsByOidRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ListCommitsByOid(m, &commitServiceListCommitsByOidServer{stream})
}

type CommitService_ListCommitsByOidServer interface {
	Send(*ListCommitsByOidResponse) error
	grpc.ServerStream
}

type commitServiceListCommitsByOidServer struct {
	grpc.ServerStream
}

func (x *commitServiceListCommitsByOidServer) Send(m *ListCommitsByOidResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_FilterShasWithSignatures_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CommitServiceServer).FilterShasWithSignatures(&commitServiceFilterShasWithSignaturesServer{stream})
}

type CommitService_FilterShasWithSignaturesServer interface {
	Send(*FilterShasWithSignaturesResponse) error
	Recv() (*FilterShasWithSignaturesRequest, error)
	grpc.ServerStream
}

type commitServiceFilterShasWithSignaturesServer struct {
	grpc.ServerStream
}

func (x *commitServiceFilterShasWithSignaturesServer) Send(m *FilterShasWithSignaturesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *commitServiceFilterShasWithSignaturesServer) Recv() (*FilterShasWithSignaturesRequest, error) {
	m := new(FilterShasWithSignaturesRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _CommitService_ExtractCommitSignature_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ExtractCommitSignatureRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).ExtractCommitSignature(m, &commitServiceExtractCommitSignatureServer{stream})
}

type CommitService_ExtractCommitSignatureServer interface {
	Send(*ExtractCommitSignatureResponse) error
	grpc.ServerStream
}

type commitServiceExtractCommitSignatureServer struct {
	grpc.ServerStream
}

func (x *commitServiceExtractCommitSignatureServer) Send(m *ExtractCommitSignatureResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_GetCommitSignatures_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetCommitSignaturesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).GetCommitSignatures(m, &commitServiceGetCommitSignaturesServer{stream})
}

type CommitService_GetCommitSignaturesServer interface {
	Send(*GetCommitSignaturesResponse) error
	grpc.ServerStream
}

type commitServiceGetCommitSignaturesServer struct {
	grpc.ServerStream
}

func (x *commitServiceGetCommitSignaturesServer) Send(m *GetCommitSignaturesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _CommitService_GetCommitMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetCommitMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(CommitServiceServer).GetCommitMessages(m, &commitServiceGetCommitMessagesServer{stream})
}

type CommitService_GetCommitMessagesServer interface {
	Send(*GetCommitMessagesResponse) error
	grpc.ServerStream
}

type commitServiceGetCommitMessagesServer struct {
	grpc.ServerStream
}

func (x *commitServiceGetCommitMessagesServer) Send(m *GetCommitMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _CommitService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.CommitService",
	HandlerType: (*CommitServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitIsAncestor",
			Handler:    _CommitService_CommitIsAncestor_Handler,
		},
		{
			MethodName: "CountCommits",
			Handler:    _CommitService_CountCommits_Handler,
		},
		{
			MethodName: "FindCommit",
			Handler:    _CommitService_FindCommit_Handler,
		},
		{
			MethodName: "CommitStats",
			Handler:    _CommitService_CommitStats_Handler,
		},
		{
			MethodName: "CommitLanguages",
			Handler:    _CommitService_CommitLanguages_Handler,
		},
		{
			MethodName: "LastCommitForPath",
			Handler:    _CommitService_LastCommitForPath_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "TreeEntry",
			Handler:       _CommitService_TreeEntry_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitsBetween",
			Handler:       _CommitService_CommitsBetween_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTreeEntries",
			Handler:       _CommitService_GetTreeEntries_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListFiles",
			Handler:       _CommitService_ListFiles_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllCommits",
			Handler:       _CommitService_FindAllCommits_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindCommits",
			Handler:       _CommitService_FindCommits_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawBlame",
			Handler:       _CommitService_RawBlame_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListLastCommitsForTree",
			Handler:       _CommitService_ListLastCommitsForTree_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitsByMessage",
			Handler:       _CommitService_CommitsByMessage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListCommitsByOid",
			Handler:       _CommitService_ListCommitsByOid_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FilterShasWithSignatures",
			Handler:       _CommitService_FilterShasWithSignatures_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ExtractCommitSignature",
			Handler:       _CommitService_ExtractCommitSignature_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetCommitSignatures",
			Handler:       _CommitService_GetCommitSignatures_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetCommitMessages",
			Handler:       _CommitService_GetCommitMessages_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "commit.proto",
}

func init() { proto.RegisterFile("commit.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 1786 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4b, 0x6f, 0xe3, 0xc8,
	0x11, 0x36, 0xf5, 0xb2, 0x58, 0xd2, 0x7a, 0xe5, 0x9e, 0x17, 0x4d, 0xcf, 0x8c, 0xbd, 0xbd, 0xd9,
	0x8d, 0x17, 0x1b, 0x68, 0x0c, 0xe5, 0x81, 0xe4, 0x14, 0xd8, 0x3b, 0xb2, 0xe3, 0x89, 0x3d, 0x5a,
	0xd0, 0x02, 0x06, 0x09, 0x02, 0x08, 0xb4, 0xd8, 0x92, 0x18, 0x53, 0xa2, 0x96, 0x6c, 0xd9, 0x56,
	0x0e, 0xb9, 0x07, 0x08, 0x72, 0xcf, 0x8f, 0xc8, 0x21, 0x3f, 0x21, 0x97, 0xfc, 0x80, 0xdc, 0xf2,
	0x57, 0x16, 0x39, 0x04, 0xfd, 0x20, 0x9b, 0x14, 0x29, 0x7b, 0xc6, 0x5e, 0xcd, 0x85, 0x60, 0x57,
	0x77, 0x57, 0x7d, 0x55, 0x5d, 0xaf, 0x6e, 0xa8, 0xf7, 0xfd, 0xf1, 0xd8, 0xa5, 0xcd, 0x69, 0xe0,
	0x53, 0x1f, 0x55, 0x86, 0x2e, 0xb5, 0xbd, 0xb9, 0x59, 0x0f, 0x47, 0x76, 0x40, 0x1c, 0x41, 0x35,
	0x77, 0x86, 0xbe, 0x3f, 0xf4, 0xc8, 0x2b, 0x3e, 0xba, 0x98, 0x0d, 0x5e, 0x51, 0x77, 0x4c, 0x42,
	0x6a, 0x8f, 0xa7, 0x62, 0x01, 0x76, 0x00, 0x7d, 0xc3, 0xd9, 0x9c, 0x53, 0x9b, 0x86, 0x16, 0xf9,
	0x6e, 0x46, 0x42, 0x8a, 0x5a, 0x00, 0x01, 0x99, 0xfa, 0xa1, 0x4b, 0xfd, 0x60, 0x6e, 0x68, 0xbb,
	0xda, 0x5e, 0xad, 0x85, 0x9a, 0x42, 0x42, 0xd3, 0x8a, 0x67, 0xac, 0xc4, 0x2a, 0x64, 0x42, 0x35,
	0x20, 0x57, 0x6e, 0xe8, 0xfa, 0x13, 0xa3, 0xb0, 0xab, 0xed, 0xd5, 0xad, 0x78, 0x8c, 0xfb, 0xf0,
	0x28, 0x25, 0x25, 0x9c, 0xfa, 0x93, 0x90, 0xa0, 0x06, 0x14, 0x7d, 0xd7, 0xe1, 0xfc, 0x75, 0x8b,
	0xfd, 0xa2, 0xe7, 0xa0, 0xdb, 0x8e, 0xe3, 0x52, 0xd7, 0x9f, 0x84, 0x9c, 0x4b, 0xd9, 0x52, 0x04,
	0x36, 0xeb, 0x10, 0x8f, 0x88, 0xd9, 0xa2, 0x98, 0x8d, 0x09, 0xf8, 0x2f, 0x1a, 0x3c, 0x13, 0x52,
	0x4e, 0xc2, 0x83, 0x49, 0x9f, 0x84, 0xd4, 0x0f, 0x1e, 0xa2, 0xd0, 0x0e, 0xd4, 0x6c, 0xc9, 0xa6,
	0xe7, 0x3a, 0x1c, 0x8d, 0x6e, 0x41, 0x44, 0x3a, 0x71, 0xd0, 0x16, 0x54, 0xfb, 0x23, 0xd7, 0x73,
	0xd8, 0x6c, 0x91, 0xcf, 0xae, 0xf3, 0xf1, 0x89, 0x83, 0xf7, 0xc1, 0xc8, 0x42, 0x91, 0x5a, 0x3f,
	0x86, 0xf2, 0x95, 0xed, 0xcd, 0x08, 0x87, 0x51, 0xb5, 0xc4, 0x00, 0xff, 0x55, 0x83, 0x46, 0x37,
	0x20, 0xa4, 0x3d, 0xa1, 0xc1, 0x7c, 0x45, 0xe7, 0x80, 0x10, 0x94, 0xa6, 0x36, 0x1d, 0x71, 0xb4,
	0x75, 0x8b, 0xff, 0x33, 0x38, 0x9e, 0x3b, 0x76, 0xa9, 0x51, 0xda, 0xd5, 0xf6, 0x8a, 0x96, 0x18,
	0xe0, 0xff, 0x68, 0xb0, 0x99, 0x80, 0x23, 0xa1, 0xff, 0x12, 0x4a, 0x74, 0x3e, 0x15, 0xc8, 0x37,
	0x5a, 0x3f, 0x8a, 0x90, 0x64, 0x16, 0x36, 0x3b, 0x17, 0x7f, 0x24, 0x7d, 0xda, 0x9d, 0x4f, 0x89,
	0xc5, 0x77, 0x44, 0x47, 0x5d, 0x50, 0x47, 0x8d, 0xa0, 0x14, 0xba, 0x7f, 0x22, 0x1c, 0x4b, 0xd1,
	0xe2, 0xff, 0x8c, 0x36, 0xf6, 0x1d, 0xc2, 0xa1, 0x94, 0x2d, 0xfe, 0xcf, 0x68, 0x8e, 0x4d, 0x6d,
	0xa3, 0x2c, 0x30, 0xb3, 0x7f, 0xfc, 0x73, 0x00, 0x25, 0x01, 0x01, 0x54, 0xbe, 0xe9, 0x9c, 0x9d,
	0x9d, 0x74, 0x1b, 0x6b, 0xa8, 0x0a, 0xa5, 0xc3, 0xd3, 0xce, 0x61, 0x43, 0x63, 0x7f, 0x5d, 0xab,
	0xdd, 0x6e, 0x14, 0xd0, 0x3a, 0x14, 0xbb, 0x07, 0xc7, 0x8d, 0x22, 0xf6, 0xe1, 0x89, 0x38, 0x95,
	0xf0, 0x90, 0xd0, 0x6b, 0x42, 0x26, 0x0f, 0xb1, 0x33, 0x82, 0xd2, 0x20, 0xf0, 0xc7, 0xd2, 0xc6,
	0xfc, 0x1f, 0x6d, 0x40, 0x81, 0xfa, 0xd2, 0xba, 0x05, 0xea, 0xe3, 0x36, 0x3c, 0x5d, 0x14, 0x28,
	0x2d, 0xf9, 0x35, 0xac, 0x8b, 0xf0, 0x0d, 0x0d, 0x6d, 0xb7, 0xb8, 0x57, 0x6b, 0x6d, 0x46, 0xe2,
	0x8e, 0x5d, 0x2a, 0xf6, 0x58, 0xd1, 0x0a, 0xfc, 0xb7, 0x02, 0x8b, 0x9f, 0xd9, 0x44, 0x4e, 0xac,
	0x2a, 0x4c, 0xd1, 0x3e, 0x94, 0xed, 0x01, 0x25, 0x01, 0xd7, 0xa0, 0xd6, 0x32, 0x9b, 0x22, 0x7b,
	0x34, 0xa3, 0xec, 0xd1, 0xec, 0x46, 0xd9, 0xc3, 0x12, 0x0b, 0x51, 0x0b, 0x2a, 0x17, 0x64, 0xe0,
	0x07, 0xe2, 0xc8, 0x6e, 0xdf, 0x22, 0x57, 0xc6, 0x4e, 0x58, 0x4e, 0x38, 0xe1, 0x36, 0xe8, 0x63,
	0xfb, 0xa6, 0xd7, 0x67, 0x4a, 0x1a, 0x15, 0x7e, 0xfa, 0xd5, 0xb1, 0x7d, 0xc3, 0x95, 0x66, 0xbe,
	0x63, 0x7b, 0x9e, 0xb1, 0xce, 0xc3, 0x85, 0xfd, 0xe2, 0x9f, 0xc0, 0xe3, 0xb4, 0x3d, 0x54, 0x68,
	0x09, 0x16, 0x1a, 0x67, 0x21, 0x06, 0xf8, 0x7b, 0x0d, 0xf4, 0xd8, 0x45, 0x73, 0x92, 0xce, 0x16,
	0x54, 0x03, 0xdf, 0xa7, 0x3d, 0xe5, 0xa0, 0xeb, 0x6c, 0xdc, 0x11, 0x4e, 0x9a, 0x09, 0x98, 0x57,
	0x32, 0x08, 0x4a, 0x3c, 0x08, 0xb6, 0x33, 0x41, 0xd0, 0xe4, 0xdf, 0x84, 0xef, 0x47, 0x5e, 0x5d,
	0x4e, 0x78, 0xf5, 0x0b, 0x00, 0x71, 0xba, 0x5c, 0x6a, 0x85, 0x4b, 0xd5, 0x05, 0x85, 0xc9, 0xdd,
	0x06, 0x7d, 0xe0, 0xd9, 0xb4, 0xc7, 0x85, 0xaf, 0x8b, 0x63, 0x62, 0x84, 0x6f, 0x6d, 0x3a, 0xc2,
	0x5f, 0x83, 0x1e, 0x8b, 0x88, 0x1d, 0x7e, 0x2d, 0x76, 0x78, 0x2d, 0x11, 0x10, 0x45, 0xfc, 0x77,
	0x0d, 0x9e, 0x1c, 0x13, 0x1a, 0xa1, 0x73, 0x49, 0xf8, 0x31, 0x93, 0xcb, 0x73, 0xd0, 0x03, 0xd2,
	0x9f, 0x05, 0xa1, 0x7b, 0x25, 0x0c, 0x56, 0xb5, 0x14, 0x81, 0x85, 0xc7, 0x22, 0x34, 0x15, 0x1e,
	0x44, 0x90, 0x16, 0xc3, 0x43, 0xe5, 0x9a, 0x68, 0x05, 0xbe, 0x80, 0xc6, 0xa9, 0x1b, 0xd2, 0x23,
	0xd7, 0x5b, 0x99, 0x72, 0xf8, 0x2b, 0xd8, 0x4c, 0xc8, 0x50, 0xee, 0xc6, 0xb4, 0x14, 0x18, 0xeb,
	0x96, 0x18, 0xe0, 0x3e, 0x6c, 0x1e, 0xb9, 0x13, 0x47, 0x06, 0xf1, 0x8a, 0xf0, 0xfc, 0x1a, 0x50,
	0x52, 0x88, 0x04, 0xf4, 0x15, 0x54, 0x84, 0x0f, 0x49, 0x09, 0x39, 0x49, 0x45, 0x2e, 0xc0, 0x3d,
	0x78, 0xc6, 0x14, 0x8a, 0xd2, 0xd3, 0xbc, 0xe3, 0x3a, 0x0f, 0xc1, 0x1a, 0xe7, 0xf7, 0xa2, 0x8c,
	0x2a, 0x7c, 0x0c, 0x46, 0x56, 0xc0, 0x7d, 0xb2, 0xdf, 0xf7, 0x1a, 0x3c, 0x61, 0xba, 0x1e, 0x78,
	0xde, 0x8a, 0xf3, 0x5f, 0x2a, 0x0b, 0x15, 0x17, 0xb2, 0x10, 0xab, 0x57, 0x97, 0xee, 0x34, 0xaa,
	0x4d, 0xec, 0x1f, 0xfd, 0x0a, 0xca, 0x7e, 0xe0, 0x90, 0x80, 0x87, 0xf6, 0x46, 0xeb, 0xf3, 0x48,
	0x76, 0x2e, 0xdc, 0x66, 0x87, 0x2d, 0xb5, 0xc4, 0x0e, 0xfc, 0x05, 0x94, 0xf9, 0x98, 0x85, 0xed,
	0xdb, 0xce, 0xdb, 0xb6, 0x0c, 0xe0, 0xce, 0xb7, 0x1d, 0x51, 0xbb, 0x5e, 0x1f, 0x74, 0xdb, 0x8d,
	0x02, 0x0b, 0x91, 0x45, 0x66, 0xf7, 0xb1, 0xe1, 0xff, 0x0a, 0x49, 0x7f, 0x59, 0x99, 0x01, 0xe3,
	0x5e, 0x42, 0x18, 0x4f, 0x0c, 0xd0, 0x53, 0xa8, 0xf8, 0x83, 0x41, 0x48, 0xa8, 0xb4, 0x9d, 0x1c,
	0xa9, 0xf0, 0x29, 0x27, 0xc2, 0x87, 0xad, 0x1e, 0xf8, 0x9e, 0xe7, 0x5f, 0xf3, 0xac, 0x58, 0xb5,
	0xe4, 0x88, 0xb5, 0x63, 0xcc, 0xe6, 0xbd, 0x31, 0x09, 0x86, 0x24, 0x94, 0xd5, 0x00, 0x18, 0xe9,
	0x8c, 0x53, 0xd0, 0x67, 0x50, 0x77, 0xdc, 0xd0, 0xbe, 0xf0, 0x48, 0xef, 0xda, 0xf6, 0x2e, 0x8d,
	0x2a, 0x5f, 0x51, 0x93, 0xb4, 0x77, 0xb6, 0x77, 0xa9, 0x0a, 0x9c, 0xfe, 0xe1, 0x05, 0x0e, 0xde,
	0xbb, 0xc0, 0xc9, 0x7a, 0x55, 0x53, 0xf5, 0xea, 0x10, 0x1e, 0xa5, 0xac, 0x7f, 0x9f, 0x23, 0x1c,
	0x45, 0xbd, 0xc4, 0xa9, 0x3d, 0x19, 0xce, 0xec, 0xe1, 0xea, 0x72, 0xdd, 0x3f, 0xe2, 0x46, 0x3a,
	0x21, 0x4a, 0x42, 0x3e, 0x02, 0xdd, 0x8b, 0x88, 0x12, 0xf4, 0x5e, 0x24, 0x6a, 0xc9, 0x9e, 0x66,
	0x44, 0xb1, 0xd4, 0x56, 0xf3, 0x0d, 0x54, 0x23, 0x32, 0x8b, 0xac, 0x89, 0x3d, 0x26, 0xb2, 0x24,
	0xf3, 0x7f, 0xe6, 0x1b, 0xfc, 0x22, 0xc3, 0xc1, 0x15, 0x2c, 0x31, 0x10, 0xf5, 0xdd, 0xf3, 0x03,
	0xd9, 0x6e, 0x8b, 0x01, 0x9e, 0xc1, 0xa7, 0x96, 0x7d, 0x7d, 0xe8, 0xd9, 0x63, 0xf2, 0x11, 0x6b,
	0x1b, 0xfe, 0x12, 0x1a, 0x4a, 0xac, 0x34, 0x4f, 0xd4, 0xac, 0x6a, 0x89, 0x66, 0xf5, 0xcf, 0x60,
	0x9c, 0xda, 0x51, 0x22, 0x3c, 0xf2, 0x03, 0x56, 0xc3, 0x3f, 0x26, 0xce, 0x23, 0xd8, 0xca, 0x91,
	0xff, 0xe1, 0x15, 0xe3, 0x9f, 0x1a, 0xbc, 0x60, 0x19, 0x5d, 0x31, 0x0b, 0x8f, 0xfc, 0x80, 0xd5,
	0xe3, 0x1f, 0x52, 0x1b, 0xfd, 0x43, 0xae, 0x2b, 0x39, 0x29, 0xa6, 0x9c, 0x4c, 0x31, 0xf8, 0xdf,
	0x1a, 0xbc, 0x5c, 0x86, 0x59, 0x5a, 0xe0, 0xed, 0x62, 0x10, 0xfe, 0x2c, 0x42, 0x7c, 0xfb, 0xc6,
	0x66, 0x6c, 0x50, 0x4e, 0x8d, 0x98, 0x98, 0x5d, 0xf8, 0x24, 0x35, 0x93, 0x30, 0x71, 0xe1, 0x0e,
	0x13, 0xa7, 0x14, 0xd6, 0x85, 0xc2, 0x6f, 0x4a, 0x55, 0xad, 0x51, 0xc0, 0xff, 0x8a, 0x63, 0x32,
	0x3c, 0x9c, 0x9f, 0x91, 0x30, 0x64, 0xf1, 0xb4, 0x22, 0x27, 0x52, 0xc6, 0x2c, 0x2e, 0xe6, 0xeb,
	0x1c, 0xd3, 0xe7, 0xb5, 0xf3, 0x8f, 0xa1, 0xfc, 0xdd, 0x8c, 0x04, 0x73, 0xd9, 0xd8, 0x8a, 0x01,
	0xeb, 0x08, 0xb2, 0x2a, 0xdc, 0x27, 0x15, 0xba, 0xb0, 0x73, 0xe4, 0x7a, 0x94, 0x04, 0xe7, 0x23,
	0x3b, 0x7c, 0xe7, 0xd2, 0xd1, 0xb9, 0x3b, 0x9c, 0xd8, 0x74, 0x16, 0x3c, 0x2c, 0x27, 0xb2, 0x0a,
	0x3f, 0xb2, 0x43, 0xde, 0xc4, 0xd4, 0x2d, 0xfe, 0x8f, 0x7f, 0x01, 0xbb, 0xcb, 0x45, 0xa9, 0xa0,
	0xe7, 0xfb, 0xb4, 0xc4, 0xbe, 0x29, 0xbc, 0x68, 0xdf, 0xd0, 0xc0, 0xee, 0x4b, 0xf0, 0xf1, 0xb6,
	0x87, 0x00, 0xdc, 0x06, 0x79, 0x45, 0x50, 0xef, 0x11, 0x55, 0x41, 0x38, 0x71, 0x70, 0x0f, 0x5e,
	0x2e, 0x93, 0x28, 0x71, 0x3e, 0x07, 0x3d, 0x8c, 0x88, 0x32, 0x43, 0x29, 0x02, 0xaf, 0xaf, 0xee,
	0x70, 0x42, 0x9c, 0x1e, 0x25, 0x37, 0x54, 0x3a, 0x05, 0x08, 0x52, 0x97, 0xdc, 0x50, 0xec, 0x83,
	0x79, 0x4c, 0x16, 0x99, 0x3f, 0xc8, 0xe0, 0xea, 0x12, 0xe4, 0x3a, 0xa1, 0xec, 0x1d, 0xf5, 0x48,
	0xa1, 0x10, 0xcf, 0x61, 0x3b, 0x57, 0xa0, 0x54, 0x27, 0x65, 0x0d, 0x2d, 0x6d, 0x8d, 0xb4, 0xae,
	0x85, 0x3b, 0x74, 0x2d, 0x66, 0x74, 0x1d, 0x83, 0x11, 0x8b, 0x96, 0xae, 0xba, 0x4a, 0x4d, 0x2d,
	0xd8, 0xca, 0x11, 0xf7, 0x3e, 0x7a, 0x1a, 0xb0, 0x3e, 0x16, 0x1b, 0xa4, 0x96, 0xd1, 0xb0, 0xf5,
	0xdf, 0x4f, 0xa2, 0x44, 0x74, 0x4e, 0x82, 0x2b, 0xb7, 0x4f, 0xd0, 0x3b, 0x68, 0x2c, 0x3e, 0x4a,
	0xa1, 0x9d, 0x74, 0xf1, 0xce, 0xbc, 0x9c, 0x99, 0xbb, 0xcb, 0x17, 0x08, 0x7c, 0x78, 0x0d, 0xbd,
	0x4e, 0xde, 0xaf, 0x8d, 0x9c, 0x57, 0x21, 0xc1, 0x6a, 0x6b, 0xe9, 0x7b, 0x11, 0x5e, 0xdb, 0xd7,
	0xd0, 0x39, 0x6c, 0xa4, 0x1f, 0x4b, 0xd0, 0x8b, 0xb4, 0xec, 0x85, 0x57, 0x1b, 0xf3, 0xe5, 0xb2,
	0xe9, 0x04, 0xd3, 0xdf, 0x42, 0x3d, 0xf9, 0x52, 0x80, 0xb6, 0xd5, 0x9e, 0xcc, 0x7b, 0x8a, 0xf9,
	0x3c, 0x7f, 0x32, 0xd6, 0xf3, 0x1c, 0x36, 0xd2, 0xf7, 0x55, 0x85, 0x30, 0xf7, 0x8a, 0xad, 0x10,
	0xe6, 0x5f, 0x73, 0x39, 0xc2, 0xd7, 0xa0, 0xc7, 0x37, 0x4b, 0x65, 0xbc, 0xc5, 0x0b, 0xad, 0x32,
	0x5e, 0xe6, 0x1a, 0xca, 0xb9, 0xb4, 0x01, 0x54, 0x87, 0x89, 0xb6, 0x92, 0x17, 0x91, 0xd4, 0x45,
	0xd4, 0x34, 0xf3, 0xa6, 0x62, 0x0d, 0x7f, 0x03, 0xb5, 0xc4, 0x43, 0x2d, 0x32, 0xd3, 0x16, 0x4e,
	0xbe, 0x11, 0x9b, 0xdb, 0xb9, 0x73, 0x49, 0x5b, 0xa5, 0x2f, 0x2e, 0xca, 0x56, 0xb9, 0xb7, 0x23,
	0x65, 0xab, 0xfc, 0xfb, 0x0e, 0xd7, 0xf2, 0x0d, 0xd4, 0x12, 0x7d, 0x34, 0xca, 0xd1, 0x25, 0x0b,
	0x2f, 0xa7, 0xf1, 0xe6, 0xbc, 0xba, 0xf0, 0xe9, 0x42, 0xc3, 0x8a, 0x5e, 0x2e, 0xed, 0x64, 0x05,
	0xcf, 0x9d, 0x3b, 0x3a, 0x5d, 0xbc, 0x86, 0x0e, 0xa0, 0x1a, 0x35, 0x85, 0xe8, 0x59, 0x9c, 0x14,
	0xd2, 0xdd, 0xa9, 0x69, 0x64, 0x27, 0x12, 0xc0, 0x7e, 0x0f, 0x9b, 0x99, 0x7e, 0x0d, 0xc5, 0x61,
	0xb8, 0xac, 0x95, 0x34, 0x3f, 0xbb, 0x65, 0x45, 0x0c, 0xef, 0x12, 0x9e, 0xe6, 0x77, 0x35, 0xe8,
	0x8b, 0xbb, 0xba, 0x1e, 0x21, 0xe5, 0xcb, 0xf7, 0x6b, 0x8e, 0xb8, 0x22, 0xbf, 0x8b, 0xf2, 0x8d,
	0xaa, 0xf7, 0x8b, 0xf9, 0x26, 0xd3, 0xcc, 0x2c, 0xe6, 0x9b, 0x6c, 0xab, 0x10, 0xb1, 0x5e, 0x7c,
	0x5c, 0x50, 0xac, 0x97, 0xbc, 0x6b, 0x28, 0xd6, 0xcb, 0xde, 0x25, 0x38, 0xeb, 0x10, 0x8c, 0x65,
	0x15, 0x1f, 0xfd, 0x58, 0x39, 0xd5, 0xad, 0xed, 0x87, 0xb9, 0x77, 0xf7, 0xc2, 0x48, 0xe4, 0x9e,
	0xb6, 0xaf, 0xb1, 0x73, 0xc9, 0x2f, 0xde, 0xea, 0x5c, 0x6e, 0x6d, 0x27, 0xd4, 0xb9, 0xdc, 0xde,
	0x03, 0x70, 0x0d, 0x2f, 0xe0, 0x51, 0x4e, 0x5d, 0x45, 0x38, 0x91, 0xac, 0x96, 0x54, 0x79, 0xf3,
	0xf3, 0x5b, 0xd7, 0x24, 0x64, 0xfc, 0x01, 0x36, 0x33, 0x15, 0x4d, 0x39, 0xf1, 0xb2, 0xda, 0xaa,
	0x9c, 0x78, 0x69, 0x39, 0x64, 0xdc, 0x2f, 0x2a, 0xfc, 0xf6, 0xfd, 0xd3, 0xff, 0x07, 0x00, 0x00,
	0xff, 0xff, 0xd1, 0xee, 0x8b, 0xf5, 0x03, 0x1b, 0x00, 0x00,
}
