/* gnome-nibbles.c generated by valac 0.42.3, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libgnome-games-support.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_0_PROPERTY,
	NIBBLES_NUM_PROPERTIES
};
static GParamSpec* nibbles_properties[NIBBLES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;
enum  {
	SCOREBOARD_0_PROPERTY,
	SCOREBOARD_NUM_PROPERTIES
};
static GParamSpec* scoreboard_properties[SCOREBOARD_NUM_PROPERTIES];
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
enum  {
	PLAYER_SCORE_BOX_0_PROPERTY,
	PLAYER_SCORE_BOX_NUM_PROPERTIES
};
static GParamSpec* player_score_box_properties[PLAYER_SCORE_BOX_NUM_PROPERTIES];
typedef struct _ControlsGridPrivate ControlsGridPrivate;
enum  {
	CONTROLS_GRID_0_PROPERTY,
	CONTROLS_GRID_NUM_PROPERTIES
};
static GParamSpec* controls_grid_properties[CONTROLS_GRID_NUM_PROPERTIES];

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkApplicationWindow* window;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	GtkHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GeeLinkedList* number_of_players_buttons;
	GeeLinkedList* number_of_ai_buttons;
	GtkButton* next_button;
	GtkButton* start_button;
	GtkBox* grids_box;
	GdkPixbuf* arrow_pixbuf;
	GdkPixbuf* arrow_key_pixbuf;
	GtkStack* statusbar_stack;
	GtkLabel* countdown;
	Scoreboard* scoreboard;
	GdkPixbuf* scoreboard_life;
	PreferencesDialog* preferences_dialog;
	NibblesView* view;
	GtkBox* game_box;
	GamesGridFrame* frame;
	NibblesGame* game;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	guint countdown_id;
	gint seconds;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block1Data {
	int _ref_count_;
	Nibbles* self;
	GtkMessageDialog* dialog;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Nibbles* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block3Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* label;
	GtkButton* button;
};

struct _Block4Data {
	int _ref_count_;
	Nibbles* self;
	gboolean should_unpause;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* game_over_label;
	GtkLabel* msg_label;
	GtkLabel* score_label;
	GtkLabel* points_left_label;
	GtkButton* button;
};

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

struct _ControlsGrid {
	GtkGrid parent_instance;
	ControlsGridPrivate * priv;
};

struct _ControlsGridClass {
	GtkGridClass parent_class;
};

struct _ControlsGridPrivate {
	GtkLabel* name_label;
	GtkImage* arrow_up;
	GtkImage* arrow_down;
	GtkImage* arrow_left;
	GtkImage* arrow_right;
	GtkOverlay* move_up;
	GtkLabel* move_up_label;
	GtkOverlay* move_down;
	GtkLabel* move_down_label;
	GtkOverlay* move_left;
	GtkLabel* move_left_label;
	GtkOverlay* move_right;
	GtkLabel* move_right_label;
};


static gint Nibbles_private_offset;
static gpointer nibbles_parent_class = NULL;
static gint Scoreboard_private_offset;
static gpointer scoreboard_parent_class = NULL;
static gint PlayerScoreBox_private_offset;
static gpointer player_score_box_parent_class = NULL;
static gint ControlsGrid_private_offset;
static gpointer controls_grid_parent_class = NULL;

GType nibbles_get_type (void) G_GNUC_CONST;
GType scoreboard_get_type (void) G_GNUC_CONST;
GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_COUNTDOWN_TIME 3
static void nibbles_start_game_cb (Nibbles* self);
static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void nibbles_new_game_cb (Nibbles* self);
static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void nibbles_pause_cb (Nibbles* self);
static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void nibbles_preferences_cb (Nibbles* self);
static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void nibbles_scores_cb (Nibbles* self);
static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void nibbles_help_cb (Nibbles* self);
static void _nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void nibbles_show_new_game_screen_cb (Nibbles* self);
static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void nibbles_show_controls_screen_cb (Nibbles* self);
static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void nibbles_back_cb (Nibbles* self);
static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
Nibbles* nibbles_new (void);
Nibbles* nibbles_construct (GType object_type);
static gint nibbles_real_handle_local_options (GApplication* base,
                                        GVariantDict* options);
static void nibbles_real_startup (GApplication* base);
static void nibbles_settings_changed_cb (Nibbles* self,
                                  const gchar* key);
static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self);
#define NIBBLES_GAME_MAX_WORMS 6
static void nibbles_worm_settings_changed_cb (Nibbles* self,
                                       GSettings* changed_worm_settings,
                                       const gchar* key);
static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
static void nibbles_size_allocate_cb (Nibbles* self,
                               GtkAllocation* allocation);
static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                         GtkAllocation* allocation,
                                                         gpointer self);
static gboolean nibbles_window_state_event_cb (Nibbles* self,
                                        GdkEventWindowState* event);
static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                       GdkEventWindowState* event,
                                                                       gpointer self);
static gboolean nibbles_key_press_event_cb (Nibbles* self,
                                     GtkWidget* widget,
                                     GdkEventKey* event);
static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self);
#define NIBBLES_GAME_MAX_HUMANS 4
static void nibbles_change_number_of_players_cb (Nibbles* self,
                                          GtkToggleButton* button);
static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
#define NIBBLES_GAME_MAX_AI 5
static void nibbles_change_number_of_ai_cb (Nibbles* self,
                                     GtkToggleButton* button);
static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self);
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type,
                                     GSettings* settings);
static void nibbles_log_score_cb (Nibbles* self,
                           gint score,
                           gint level_reached);
static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                   gint score,
                                                   gint level_reached,
                                                   gpointer self);
static void nibbles_level_completed_cb (Nibbles* self);
static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                               gpointer self);
static void __lambda13_ (Nibbles* self);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game);
static gboolean nibbles_configure_event_cb (Nibbles* self,
                                     GdkEventConfigure* event);
static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                                 GdkEventConfigure* event,
                                                                 gpointer self);
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
Scoreboard* scoreboard_new (void);
Scoreboard* scoreboard_construct (GType object_type);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self,
                                          const gchar* pixmap,
                                          gint xsize,
                                          gint ysize);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
static void nibbles_show_first_run_screen (Nibbles* self);
static void nibbles_create_scores (Nibbles* self);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
void nibbles_game_save_properties (NibblesGame* self,
                                   GSettings* settings);
static gboolean nibbles_countdown_cb (Nibbles* self);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
void nibbles_game_start (NibblesGame* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval);
void nibbles_view_board_rescale (NibblesView* self,
                                 gint tile_size);
void nibbles_view_boni_rescale (NibblesView* self,
                                gint tile_size);
void nibbles_view_warps_rescale (NibblesView* self,
                                 gint tile_size);
GType worm_get_type (void) G_GNUC_CONST;
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
void nibbles_game_set_tile_size (NibblesGame* self,
                                 gint value);
void nibbles_game_reset (NibblesGame* self);
void nibbles_view_new_level (NibblesView* self,
                             gint level);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_view_connect_worm_signals (NibblesView* self);
void scoreboard_clear (Scoreboard* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
void scoreboard_register (Scoreboard* self,
                          Worm* worm,
                          const gchar* color_name,
                          GdkPixbuf* life_pixbuf);
gchar* nibbles_view_colorval_name (gint colorval);
void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
void nibbles_game_add_worms (NibblesGame* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_show_game_view (Nibbles* self);
static void nibbles_start_game_with_countdown (Nibbles* self);
static gboolean _nibbles_countdown_cb_gsource_func (gpointer self);
static void nibbles_restart_game (Nibbles* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gboolean nibbles_game_get_is_running (NibblesGame* self);
void nibbles_game_stop (NibblesGame* self);
static void __lambda7_ (Block1Data* _data1_,
                 gint response_id);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
gint nibbles_game_get_numworms (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
GType worm_direction_get_type (void) G_GNUC_CONST;
GType controls_grid_get_type (void) G_GNUC_CONST;
gint worm_get_id (Worm* self);
ControlsGrid* controls_grid_new (gint worm_id,
                                 WormProperties* worm_props,
                                 GdkPixbuf* arrow,
                                 GdkPixbuf* arrow_key);
ControlsGrid* controls_grid_construct (GType object_type,
                                       gint worm_id,
                                       WormProperties* worm_props,
                                       GdkPixbuf* arrow,
                                       GdkPixbuf* arrow_key);
static GamesScoresCategory* nibbles_category_request (Nibbles* self,
                                               const gchar* key);
static gchar* nibbles_get_new_scores_key (Nibbles* self,
                                   const gchar* old_key);
static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                           gpointer self);
static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                                          gpointer self);
static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self,
                                                  gint speed,
                                                  gboolean fakes);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_get_fakes (NibblesGame* self);
static void nibbles_game_over (Nibbles* self,
                        gint score,
                        glong lowest_high_score,
                        gint level_reached);
gint nibbles_game_get_start_level (NibblesGame* self);
static void __lambda10_ (Block2Data* _data2_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
#define NIBBLES_GAME_MAX_LEVEL 26
static void __lambda11_ (Block3Data* _data3_);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda12_ (Block3Data* _data3_);
static gboolean ___lambda12__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window,
                                           GSettings* settings,
                                           GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkApplicationWindow* window,
                                                 GSettings* settings,
                                                 GeeArrayList* worm_settings);
static void __lambda8_ (Block4Data* _data4_);
static void ___lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                     gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
gint nibbles_main (gchar** args,
                   int args_length1);
static void nibbles_finalize (GObject * obj);
GType player_score_box_get_type (void) G_GNUC_CONST;
gint worm_get_score (Worm* self);
gint worm_get_lives (Worm* self);
PlayerScoreBox* player_score_box_new (const gchar* name,
                                      PangoColor* color,
                                      gint score,
                                      gint lives_left,
                                      GdkPixbuf* life_pixbuf);
PlayerScoreBox* player_score_box_construct (GType object_type,
                                            const gchar* name,
                                            PangoColor* color,
                                            gint score,
                                            gint lives_left,
                                            GdkPixbuf* life_pixbuf);
void player_score_box_update (PlayerScoreBox* self,
                              gint score,
                              gint lives_left);
static void scoreboard_finalize (GObject * obj);
#define WORM_MAX_LIVES 12
#define WORM_STARTING_LIVES 6
void player_score_box_update_score (PlayerScoreBox* self,
                                    gint score);
void player_score_box_update_lives (PlayerScoreBox* self,
                                    gint lives_left);
static void player_score_box_finalize (GObject * obj);
static void controls_grid_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[8] = {{"start-game", _nibbles_start_game_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_pause_cb_gsimple_action_activate_callback}, {"preferences", _nibbles_preferences_cb_gsimple_action_activate_callback}, {"scores", _nibbles_scores_cb_gsimple_action_activate_callback}, {"help", _nibbles_help_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GActionEntry NIBBLES_menu_entries[3] = {{"show-new-game-screen", _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback}, {"show-controls-screen", _nibbles_show_controls_screen_cb_gsimple_action_activate_callback}, {"back", _nibbles_back_cb_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};

static inline gpointer
nibbles_get_instance_private (Nibbles* self)
{
	return G_STRUCT_MEMBER_P (self, Nibbles_private_offset);
}


static void
_nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_start_game_cb ((Nibbles*) self);
#line 670 "gnome-nibbles.c"
}


static void
_nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_new_game_cb ((Nibbles*) self);
#line 681 "gnome-nibbles.c"
}


static void
_nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_pause_cb ((Nibbles*) self);
#line 692 "gnome-nibbles.c"
}


static void
_nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_preferences_cb ((Nibbles*) self);
#line 703 "gnome-nibbles.c"
}


static void
_nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_scores_cb ((Nibbles*) self);
#line 714 "gnome-nibbles.c"
}


static void
_nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_help_cb ((Nibbles*) self);
#line 725 "gnome-nibbles.c"
}


static void
_nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_about_cb ((Nibbles*) self);
#line 736 "gnome-nibbles.c"
}


static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 81 "gnome-nibbles.vala"
	g_application_quit ((GApplication*) self);
#line 747 "gnome-nibbles.c"
}


static void
_nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
#line 93 "gnome-nibbles.vala"
	nibbles_show_new_game_screen_cb ((Nibbles*) self);
#line 758 "gnome-nibbles.c"
}


static void
_nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
#line 93 "gnome-nibbles.vala"
	nibbles_show_controls_screen_cb ((Nibbles*) self);
#line 769 "gnome-nibbles.c"
}


static void
_nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
#line 93 "gnome-nibbles.vala"
	nibbles_back_cb ((Nibbles*) self);
#line 780 "gnome-nibbles.c"
}


Nibbles*
nibbles_construct (GType object_type)
{
	Nibbles * self = NULL;
#line 111 "gnome-nibbles.vala"
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.Nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 113 "gnome-nibbles.vala"
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
#line 109 "gnome-nibbles.vala"
	return self;
#line 794 "gnome-nibbles.c"
}


Nibbles*
nibbles_new (void)
{
#line 109 "gnome-nibbles.vala"
	return nibbles_construct (TYPE_NIBBLES);
#line 803 "gnome-nibbles.c"
}


static gint
nibbles_real_handle_local_options (GApplication* base,
                                   GVariantDict* options)
{
	Nibbles * self;
	gint result = 0;
#line 116 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 116 "gnome-nibbles.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 118 "gnome-nibbles.vala"
	if (g_variant_dict_contains (options, "version")) {
#line 819 "gnome-nibbles.c"
		FILE* _tmp0_;
#line 121 "gnome-nibbles.vala"
		_tmp0_ = stderr;
#line 121 "gnome-nibbles.vala"
		fprintf (_tmp0_, "gnome-nibbles %s\n", VERSION);
#line 122 "gnome-nibbles.vala"
		result = EXIT_SUCCESS;
#line 122 "gnome-nibbles.vala"
		return result;
#line 829 "gnome-nibbles.c"
	}
#line 126 "gnome-nibbles.vala"
	result = -1;
#line 126 "gnome-nibbles.vala"
	return result;
#line 835 "gnome-nibbles.c"
}


static void
_nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                 const gchar* key,
                                                 gpointer self)
{
#line 151 "gnome-nibbles.vala"
	nibbles_settings_changed_cb ((Nibbles*) self, key);
#line 846 "gnome-nibbles.c"
}


static void
_nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
#line 158 "gnome-nibbles.vala"
	nibbles_worm_settings_changed_cb ((Nibbles*) self, _sender, key);
#line 857 "gnome-nibbles.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 164 "gnome-nibbles.vala"
	return self ? g_object_ref (self) : NULL;
#line 866 "gnome-nibbles.c"
}


static void
_nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                    GtkAllocation* allocation,
                                                    gpointer self)
{
#line 170 "gnome-nibbles.vala"
	nibbles_size_allocate_cb ((Nibbles*) self, allocation);
#line 877 "gnome-nibbles.c"
}


static gboolean
_nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                              GdkEventWindowState* event,
                                                              gpointer self)
{
	gboolean result;
	result = nibbles_window_state_event_cb ((Nibbles*) self, event);
#line 171 "gnome-nibbles.vala"
	return result;
#line 890 "gnome-nibbles.c"
}


static gboolean
_nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                        GdkEventKey* event,
                                                        gpointer self)
{
	gboolean result;
	result = nibbles_key_press_event_cb ((Nibbles*) self, _sender, event);
#line 172 "gnome-nibbles.vala"
	return result;
#line 903 "gnome-nibbles.c"
}


static void
_nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 189 "gnome-nibbles.vala"
	nibbles_change_number_of_players_cb ((Nibbles*) self, _sender);
#line 913 "gnome-nibbles.c"
}


static void
_nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                           gpointer self)
{
#line 196 "gnome-nibbles.vala"
	nibbles_change_number_of_ai_cb ((Nibbles*) self, _sender);
#line 923 "gnome-nibbles.c"
}


static void
_nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                              gint score,
                                              gint level_reached,
                                              gpointer self)
{
#line 208 "gnome-nibbles.vala"
	nibbles_log_score_cb ((Nibbles*) self, score, level_reached);
#line 935 "gnome-nibbles.c"
}


static void
_nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                          gpointer self)
{
#line 209 "gnome-nibbles.vala"
	nibbles_level_completed_cb ((Nibbles*) self);
#line 945 "gnome-nibbles.c"
}


static void
__lambda13_ (Nibbles* self)
{
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 211 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 211 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_paused (_tmp0_);
#line 211 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 211 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 963 "gnome-nibbles.c"
		GtkStack* _tmp3_;
#line 212 "gnome-nibbles.vala"
		_tmp3_ = self->priv->statusbar_stack;
#line 212 "gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp3_, "paused");
#line 969 "gnome-nibbles.c"
	} else {
		GtkStack* _tmp4_;
#line 214 "gnome-nibbles.vala"
		_tmp4_ = self->priv->statusbar_stack;
#line 214 "gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp4_, "scoreboard");
#line 976 "gnome-nibbles.c"
	}
}


static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 210 "gnome-nibbles.vala"
	__lambda13_ ((Nibbles*) self);
#line 988 "gnome-nibbles.c"
}


static gboolean
_nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                        GdkEventConfigure* event,
                                                        gpointer self)
{
	gboolean result;
	result = nibbles_configure_event_cb ((Nibbles*) self, event);
#line 219 "gnome-nibbles.vala"
	return result;
#line 1001 "gnome-nibbles.c"
}


static void
nibbles_real_startup (GApplication* base)
{
	Nibbles * self;
	gchar** argv = NULL;
	gint argv_length1;
	gint _argv_size_;
	GtkSettings* _tmp0_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* _tmp2_;
	GdkScreen* _tmp3_;
	GtkCssProvider* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GeeArrayList* _tmp7_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GAction* _tmp30_;
	GSimpleAction* _tmp31_;
	GAction* _tmp32_;
	GSimpleAction* _tmp33_;
	GAction* _tmp34_;
	GSimpleAction* _tmp35_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_;
	GtkApplicationWindow* _tmp39_;
	GtkApplicationWindow* _tmp40_;
	GtkApplicationWindow* _tmp41_;
	GtkApplicationWindow* _tmp42_;
	GtkApplicationWindow* _tmp43_;
	GSettings* _tmp44_;
	GSettings* _tmp45_;
	GSettings* _tmp46_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_;
	GtkHeaderBar* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_;
	GtkOverlay* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_;
	GtkButton* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_;
	GtkButton* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_;
	GtkStack* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_;
	GtkBox* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_;
	GtkStack* _tmp68_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_;
	GtkLabel* _tmp71_;
	GeeLinkedList* _tmp72_;
	GeeLinkedList* _tmp86_;
	GtkBuilder* _tmp100_;
	GObject* _tmp101_;
	GtkButton* _tmp102_;
	GtkBuilder* _tmp103_;
	GObject* _tmp104_;
	GtkButton* _tmp105_;
	GtkBuilder* _tmp106_;
	GObject* _tmp107_;
	GtkBox* _tmp108_;
	GtkApplicationWindow* _tmp109_;
	GtkHeaderBar* _tmp110_;
	GtkApplicationWindow* _tmp111_;
	GSettings* _tmp112_;
	NibblesGame* _tmp113_;
	NibblesGame* _tmp114_;
	NibblesGame* _tmp115_;
	NibblesGame* _tmp116_;
	NibblesGame* _tmp117_;
	NibblesView* _tmp118_;
	NibblesView* _tmp119_;
	NibblesView* _tmp120_;
	GSettings* _tmp121_;
	NibblesView* _tmp122_;
	GamesGridFrame* _tmp123_;
	GtkBox* _tmp124_;
	GamesGridFrame* _tmp125_;
	Scoreboard* _tmp126_;
	NibblesView* _tmp127_;
	NibblesGame* _tmp128_;
	gint _tmp129_;
	gint _tmp130_;
	NibblesGame* _tmp131_;
	gint _tmp132_;
	gint _tmp133_;
	GdkPixbuf* _tmp134_;
	Scoreboard* _tmp135_;
	GtkStack* _tmp136_;
	Scoreboard* _tmp137_;
	GamesGridFrame* _tmp138_;
	NibblesView* _tmp139_;
	GamesGridFrame* _tmp140_;
	NibblesGame* _tmp141_;
	GSettings* _tmp142_;
	NibblesGame* _tmp143_;
	GSettings* _tmp144_;
	NibblesView* _tmp145_;
	NibblesGame* _tmp146_;
	gint _tmp147_;
	gint _tmp148_;
	NibblesGame* _tmp149_;
	gint _tmp150_;
	gint _tmp151_;
	GdkPixbuf* _tmp152_;
	NibblesView* _tmp153_;
	NibblesGame* _tmp154_;
	gint _tmp155_;
	gint _tmp156_;
	NibblesGame* _tmp157_;
	gint _tmp158_;
	gint _tmp159_;
	GdkPixbuf* _tmp160_;
	gboolean first_run = FALSE;
	GSettings* _tmp161_;
	gboolean _tmp162_;
	GtkApplicationWindow* _tmp163_;
#line 129 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 131 "gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 133 "gnome-nibbles.vala"
	argv = NULL;
#line 133 "gnome-nibbles.vala"
	argv_length1 = 0;
#line 133 "gnome-nibbles.vala"
	_argv_size_ = argv_length1;
#line 134 "gnome-nibbles.vala"
	gtk_clutter_init (&argv_length1, &argv);
#line 136 "gnome-nibbles.vala"
	g_set_prgname ("org.gnome.Nibbles");
#line 137 "gnome-nibbles.vala"
	g_set_application_name (_ ("Nibbles"));
#line 139 "gnome-nibbles.vala"
	gtk_window_set_default_icon_name ("gnome-nibbles");
#line 141 "gnome-nibbles.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 141 "gnome-nibbles.vala"
	g_object_set ((GObject*) _tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
#line 143 "gnome-nibbles.vala"
	_tmp1_ = gtk_css_provider_new ();
#line 143 "gnome-nibbles.vala"
	css_provider = _tmp1_;
#line 144 "gnome-nibbles.vala"
	_tmp2_ = css_provider;
#line 144 "gnome-nibbles.vala"
	gtk_css_provider_load_from_resource (_tmp2_, "/org/gnome/nibbles/ui/nibbles.css");
#line 145 "gnome-nibbles.vala"
	_tmp3_ = gdk_screen_get_default ();
#line 145 "gnome-nibbles.vala"
	_tmp4_ = css_provider;
#line 145 "gnome-nibbles.vala"
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 147 "gnome-nibbles.vala"
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, G_N_ELEMENTS (NIBBLES_action_entries), self);
#line 148 "gnome-nibbles.vala"
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_menu_entries, G_N_ELEMENTS (NIBBLES_menu_entries), self);
#line 150 "gnome-nibbles.vala"
	_tmp5_ = g_settings_new ("org.gnome.nibbles");
#line 150 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->settings);
#line 150 "gnome-nibbles.vala"
	self->priv->settings = _tmp5_;
#line 151 "gnome-nibbles.vala"
	_tmp6_ = self->priv->settings;
#line 151 "gnome-nibbles.vala"
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _nibbles_settings_changed_cb_g_settings_changed, self, 0);
#line 153 "gnome-nibbles.vala"
	_tmp7_ = gee_array_list_new (g_settings_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 153 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 153 "gnome-nibbles.vala"
	self->priv->worm_settings = _tmp7_;
#line 1198 "gnome-nibbles.c"
	{
		gint i = 0;
#line 154 "gnome-nibbles.vala"
		i = 0;
#line 1203 "gnome-nibbles.c"
		{
			gboolean _tmp8_ = FALSE;
#line 154 "gnome-nibbles.vala"
			_tmp8_ = TRUE;
#line 154 "gnome-nibbles.vala"
			while (TRUE) {
#line 1210 "gnome-nibbles.c"
				gint _tmp10_;
				gchar* name = NULL;
				gint _tmp11_;
				gchar* _tmp12_;
				GeeArrayList* _tmp13_;
				const gchar* _tmp14_;
				GSettings* _tmp15_;
				GSettings* _tmp16_;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				GSettings* _tmp20_;
#line 154 "gnome-nibbles.vala"
				if (!_tmp8_) {
#line 1225 "gnome-nibbles.c"
					gint _tmp9_;
#line 154 "gnome-nibbles.vala"
					_tmp9_ = i;
#line 154 "gnome-nibbles.vala"
					i = _tmp9_ + 1;
#line 1231 "gnome-nibbles.c"
				}
#line 154 "gnome-nibbles.vala"
				_tmp8_ = FALSE;
#line 154 "gnome-nibbles.vala"
				_tmp10_ = i;
#line 154 "gnome-nibbles.vala"
				if (!(_tmp10_ < NIBBLES_GAME_MAX_WORMS)) {
#line 154 "gnome-nibbles.vala"
					break;
#line 1241 "gnome-nibbles.c"
				}
#line 156 "gnome-nibbles.vala"
				_tmp11_ = i;
#line 156 "gnome-nibbles.vala"
				_tmp12_ = g_strdup_printf ("org.gnome.nibbles.worm%d", _tmp11_);
#line 156 "gnome-nibbles.vala"
				name = _tmp12_;
#line 157 "gnome-nibbles.vala"
				_tmp13_ = self->priv->worm_settings;
#line 157 "gnome-nibbles.vala"
				_tmp14_ = name;
#line 157 "gnome-nibbles.vala"
				_tmp15_ = g_settings_new (_tmp14_);
#line 157 "gnome-nibbles.vala"
				_tmp16_ = _tmp15_;
#line 157 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
#line 157 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp16_);
#line 158 "gnome-nibbles.vala"
				_tmp17_ = self->priv->worm_settings;
#line 158 "gnome-nibbles.vala"
				_tmp18_ = i;
#line 158 "gnome-nibbles.vala"
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 158 "gnome-nibbles.vala"
				_tmp20_ = (GSettings*) _tmp19_;
#line 158 "gnome-nibbles.vala"
				g_signal_connect_object (_tmp20_, "changed", (GCallback) _nibbles_worm_settings_changed_cb_g_settings_changed, self, 0);
#line 158 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp20_);
#line 154 "gnome-nibbles.vala"
				_g_free0 (name);
#line 1275 "gnome-nibbles.c"
			}
		}
	}
#line 161 "gnome-nibbles.vala"
	_tmp21_ = g_strdup ("<Primary>q");
#line 161 "gnome-nibbles.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 161 "gnome-nibbles.vala"
	_tmp22_[0] = _tmp21_;
#line 161 "gnome-nibbles.vala"
	_tmp23_ = _tmp22_;
#line 161 "gnome-nibbles.vala"
	_tmp23__length1 = 1;
#line 161 "gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp23_);
#line 161 "gnome-nibbles.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 162 "gnome-nibbles.vala"
	_tmp24_ = g_strdup ("Escape");
#line 162 "gnome-nibbles.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 162 "gnome-nibbles.vala"
	_tmp25_[0] = _tmp24_;
#line 162 "gnome-nibbles.vala"
	_tmp26_ = _tmp25_;
#line 162 "gnome-nibbles.vala"
	_tmp26__length1 = 1;
#line 162 "gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp26_);
#line 162 "gnome-nibbles.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 163 "gnome-nibbles.vala"
	_tmp27_ = g_strdup ("F1");
#line 163 "gnome-nibbles.vala"
	_tmp28_ = g_new0 (gchar*, 1 + 1);
#line 163 "gnome-nibbles.vala"
	_tmp28_[0] = _tmp27_;
#line 163 "gnome-nibbles.vala"
	_tmp29_ = _tmp28_;
#line 163 "gnome-nibbles.vala"
	_tmp29__length1 = 1;
#line 163 "gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
#line 163 "gnome-nibbles.vala"
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
#line 164 "gnome-nibbles.vala"
	_tmp30_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 164 "gnome-nibbles.vala"
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_simple_action_get_type (), GSimpleAction));
#line 164 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 164 "gnome-nibbles.vala"
	self->priv->new_game_action = _tmp31_;
#line 165 "gnome-nibbles.vala"
	_tmp32_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 165 "gnome-nibbles.vala"
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, g_simple_action_get_type (), GSimpleAction));
#line 165 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 165 "gnome-nibbles.vala"
	self->priv->pause_action = _tmp33_;
#line 166 "gnome-nibbles.vala"
	_tmp34_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 166 "gnome-nibbles.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction));
#line 166 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->back_action);
#line 166 "gnome-nibbles.vala"
	self->priv->back_action = _tmp35_;
#line 168 "gnome-nibbles.vala"
	_tmp36_ = gtk_builder_new_from_resource ("/org/gnome/nibbles/ui/nibbles.ui");
#line 168 "gnome-nibbles.vala"
	builder = _tmp36_;
#line 169 "gnome-nibbles.vala"
	_tmp37_ = builder;
#line 169 "gnome-nibbles.vala"
	_tmp38_ = gtk_builder_get_object (_tmp37_, "nibbles-window");
#line 169 "gnome-nibbles.vala"
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp38_) : NULL);
#line 169 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->window);
#line 169 "gnome-nibbles.vala"
	self->priv->window = _tmp39_;
#line 170 "gnome-nibbles.vala"
	_tmp40_ = self->priv->window;
#line 170 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp40_, "size-allocate", (GCallback) _nibbles_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 171 "gnome-nibbles.vala"
	_tmp41_ = self->priv->window;
#line 171 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp41_, "window-state-event", (GCallback) _nibbles_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 172 "gnome-nibbles.vala"
	_tmp42_ = self->priv->window;
#line 172 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp42_, "key-press-event", (GCallback) _nibbles_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 173 "gnome-nibbles.vala"
	_tmp43_ = self->priv->window;
#line 173 "gnome-nibbles.vala"
	_tmp44_ = self->priv->settings;
#line 173 "gnome-nibbles.vala"
	_tmp45_ = self->priv->settings;
#line 173 "gnome-nibbles.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp43_, g_settings_get_int (_tmp44_, "window-width"), g_settings_get_int (_tmp45_, "window-height"));
#line 174 "gnome-nibbles.vala"
	_tmp46_ = self->priv->settings;
#line 174 "gnome-nibbles.vala"
	if (g_settings_get_boolean (_tmp46_, "window-is-maximized")) {
#line 1383 "gnome-nibbles.c"
		GtkApplicationWindow* _tmp47_;
#line 175 "gnome-nibbles.vala"
		_tmp47_ = self->priv->window;
#line 175 "gnome-nibbles.vala"
		gtk_window_maximize ((GtkWindow*) _tmp47_);
#line 1389 "gnome-nibbles.c"
	}
#line 177 "gnome-nibbles.vala"
	_tmp48_ = builder;
#line 177 "gnome-nibbles.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "headerbar");
#line 177 "gnome-nibbles.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 177 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 177 "gnome-nibbles.vala"
	self->priv->headerbar = _tmp50_;
#line 178 "gnome-nibbles.vala"
	_tmp51_ = builder;
#line 178 "gnome-nibbles.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "main_overlay");
#line 178 "gnome-nibbles.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_overlay_get_type (), GtkOverlay));
#line 178 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->overlay);
#line 178 "gnome-nibbles.vala"
	self->priv->overlay = _tmp53_;
#line 179 "gnome-nibbles.vala"
	_tmp54_ = builder;
#line 179 "gnome-nibbles.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "new_game_button");
#line 179 "gnome-nibbles.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_button_get_type (), GtkButton));
#line 179 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 179 "gnome-nibbles.vala"
	self->priv->new_game_button = _tmp56_;
#line 180 "gnome-nibbles.vala"
	_tmp57_ = builder;
#line 180 "gnome-nibbles.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "pause_button");
#line 180 "gnome-nibbles.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_button_get_type (), GtkButton));
#line 180 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 180 "gnome-nibbles.vala"
	self->priv->pause_button = _tmp59_;
#line 181 "gnome-nibbles.vala"
	_tmp60_ = builder;
#line 181 "gnome-nibbles.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "main_stack");
#line 181 "gnome-nibbles.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_stack_get_type (), GtkStack));
#line 181 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 181 "gnome-nibbles.vala"
	self->priv->main_stack = _tmp62_;
#line 182 "gnome-nibbles.vala"
	_tmp63_ = builder;
#line 182 "gnome-nibbles.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "game_box");
#line 182 "gnome-nibbles.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_box_get_type (), GtkBox));
#line 182 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game_box);
#line 182 "gnome-nibbles.vala"
	self->priv->game_box = _tmp65_;
#line 183 "gnome-nibbles.vala"
	_tmp66_ = builder;
#line 183 "gnome-nibbles.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "statusbar_stack");
#line 183 "gnome-nibbles.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_stack_get_type (), GtkStack));
#line 183 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->statusbar_stack);
#line 183 "gnome-nibbles.vala"
	self->priv->statusbar_stack = _tmp68_;
#line 184 "gnome-nibbles.vala"
	_tmp69_ = builder;
#line 184 "gnome-nibbles.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "countdown");
#line 184 "gnome-nibbles.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_label_get_type (), GtkLabel));
#line 184 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->countdown);
#line 184 "gnome-nibbles.vala"
	self->priv->countdown = _tmp71_;
#line 185 "gnome-nibbles.vala"
	_tmp72_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 185 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_players_buttons);
#line 185 "gnome-nibbles.vala"
	self->priv->number_of_players_buttons = _tmp72_;
#line 1477 "gnome-nibbles.c"
	{
		gint i = 0;
#line 186 "gnome-nibbles.vala"
		i = 0;
#line 1482 "gnome-nibbles.c"
		{
			gboolean _tmp73_ = FALSE;
#line 186 "gnome-nibbles.vala"
			_tmp73_ = TRUE;
#line 186 "gnome-nibbles.vala"
			while (TRUE) {
#line 1489 "gnome-nibbles.c"
				gint _tmp75_;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp76_;
				gint _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				GObject* _tmp80_;
				GtkToggleButton* _tmp81_;
				GtkToggleButton* _tmp82_;
				GtkToggleButton* _tmp83_;
				GeeLinkedList* _tmp84_;
				GtkToggleButton* _tmp85_;
#line 186 "gnome-nibbles.vala"
				if (!_tmp73_) {
#line 1504 "gnome-nibbles.c"
					gint _tmp74_;
#line 186 "gnome-nibbles.vala"
					_tmp74_ = i;
#line 186 "gnome-nibbles.vala"
					i = _tmp74_ + 1;
#line 1510 "gnome-nibbles.c"
				}
#line 186 "gnome-nibbles.vala"
				_tmp73_ = FALSE;
#line 186 "gnome-nibbles.vala"
				_tmp75_ = i;
#line 186 "gnome-nibbles.vala"
				if (!(_tmp75_ < NIBBLES_GAME_MAX_HUMANS)) {
#line 186 "gnome-nibbles.vala"
					break;
#line 1520 "gnome-nibbles.c"
				}
#line 188 "gnome-nibbles.vala"
				_tmp76_ = builder;
#line 188 "gnome-nibbles.vala"
				_tmp77_ = i;
#line 188 "gnome-nibbles.vala"
				_tmp78_ = g_strdup_printf ("players%d", _tmp77_ + 1);
#line 188 "gnome-nibbles.vala"
				_tmp79_ = _tmp78_;
#line 188 "gnome-nibbles.vala"
				_tmp80_ = gtk_builder_get_object (_tmp76_, _tmp79_);
#line 188 "gnome-nibbles.vala"
				_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 188 "gnome-nibbles.vala"
				_tmp82_ = _tmp81_;
#line 188 "gnome-nibbles.vala"
				_g_free0 (_tmp79_);
#line 188 "gnome-nibbles.vala"
				button = _tmp82_;
#line 189 "gnome-nibbles.vala"
				_tmp83_ = button;
#line 189 "gnome-nibbles.vala"
				g_signal_connect_object (_tmp83_, "toggled", (GCallback) _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled, self, 0);
#line 190 "gnome-nibbles.vala"
				_tmp84_ = self->priv->number_of_players_buttons;
#line 190 "gnome-nibbles.vala"
				_tmp85_ = button;
#line 190 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, _tmp85_);
#line 186 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 1552 "gnome-nibbles.c"
			}
		}
	}
#line 192 "gnome-nibbles.vala"
	_tmp86_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 192 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_ai_buttons);
#line 192 "gnome-nibbles.vala"
	self->priv->number_of_ai_buttons = _tmp86_;
#line 1562 "gnome-nibbles.c"
	{
		gint i = 0;
#line 193 "gnome-nibbles.vala"
		i = 0;
#line 1567 "gnome-nibbles.c"
		{
			gboolean _tmp87_ = FALSE;
#line 193 "gnome-nibbles.vala"
			_tmp87_ = TRUE;
#line 193 "gnome-nibbles.vala"
			while (TRUE) {
#line 1574 "gnome-nibbles.c"
				gint _tmp89_;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp90_;
				gint _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				GObject* _tmp94_;
				GtkToggleButton* _tmp95_;
				GtkToggleButton* _tmp96_;
				GtkToggleButton* _tmp97_;
				GeeLinkedList* _tmp98_;
				GtkToggleButton* _tmp99_;
#line 193 "gnome-nibbles.vala"
				if (!_tmp87_) {
#line 1589 "gnome-nibbles.c"
					gint _tmp88_;
#line 193 "gnome-nibbles.vala"
					_tmp88_ = i;
#line 193 "gnome-nibbles.vala"
					i = _tmp88_ + 1;
#line 1595 "gnome-nibbles.c"
				}
#line 193 "gnome-nibbles.vala"
				_tmp87_ = FALSE;
#line 193 "gnome-nibbles.vala"
				_tmp89_ = i;
#line 193 "gnome-nibbles.vala"
				if (!(_tmp89_ <= NIBBLES_GAME_MAX_AI)) {
#line 193 "gnome-nibbles.vala"
					break;
#line 1605 "gnome-nibbles.c"
				}
#line 195 "gnome-nibbles.vala"
				_tmp90_ = builder;
#line 195 "gnome-nibbles.vala"
				_tmp91_ = i;
#line 195 "gnome-nibbles.vala"
				_tmp92_ = g_strdup_printf ("ai%d", _tmp91_);
#line 195 "gnome-nibbles.vala"
				_tmp93_ = _tmp92_;
#line 195 "gnome-nibbles.vala"
				_tmp94_ = gtk_builder_get_object (_tmp90_, _tmp93_);
#line 195 "gnome-nibbles.vala"
				_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 195 "gnome-nibbles.vala"
				_tmp96_ = _tmp95_;
#line 195 "gnome-nibbles.vala"
				_g_free0 (_tmp93_);
#line 195 "gnome-nibbles.vala"
				button = _tmp96_;
#line 196 "gnome-nibbles.vala"
				_tmp97_ = button;
#line 196 "gnome-nibbles.vala"
				g_signal_connect_object (_tmp97_, "toggled", (GCallback) _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled, self, 0);
#line 197 "gnome-nibbles.vala"
				_tmp98_ = self->priv->number_of_ai_buttons;
#line 197 "gnome-nibbles.vala"
				_tmp99_ = button;
#line 197 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, _tmp99_);
#line 193 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 1637 "gnome-nibbles.c"
			}
		}
	}
#line 199 "gnome-nibbles.vala"
	_tmp100_ = builder;
#line 199 "gnome-nibbles.vala"
	_tmp101_ = gtk_builder_get_object (_tmp100_, "next_button");
#line 199 "gnome-nibbles.vala"
	_tmp102_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, gtk_button_get_type (), GtkButton));
#line 199 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->next_button);
#line 199 "gnome-nibbles.vala"
	self->priv->next_button = _tmp102_;
#line 200 "gnome-nibbles.vala"
	_tmp103_ = builder;
#line 200 "gnome-nibbles.vala"
	_tmp104_ = gtk_builder_get_object (_tmp103_, "start_button");
#line 200 "gnome-nibbles.vala"
	_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, gtk_button_get_type (), GtkButton));
#line 200 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->start_button);
#line 200 "gnome-nibbles.vala"
	self->priv->start_button = _tmp105_;
#line 201 "gnome-nibbles.vala"
	_tmp106_ = builder;
#line 201 "gnome-nibbles.vala"
	_tmp107_ = gtk_builder_get_object (_tmp106_, "grids_box");
#line 201 "gnome-nibbles.vala"
	_tmp108_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, gtk_box_get_type (), GtkBox));
#line 201 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->grids_box);
#line 201 "gnome-nibbles.vala"
	self->priv->grids_box = _tmp108_;
#line 202 "gnome-nibbles.vala"
	_tmp109_ = self->priv->window;
#line 202 "gnome-nibbles.vala"
	_tmp110_ = self->priv->headerbar;
#line 202 "gnome-nibbles.vala"
	gtk_window_set_titlebar ((GtkWindow*) _tmp109_, (GtkWidget*) _tmp110_);
#line 204 "gnome-nibbles.vala"
	_tmp111_ = self->priv->window;
#line 204 "gnome-nibbles.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp111_);
#line 207 "gnome-nibbles.vala"
	_tmp112_ = self->priv->settings;
#line 207 "gnome-nibbles.vala"
	_tmp113_ = nibbles_game_new (_tmp112_);
#line 207 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game);
#line 207 "gnome-nibbles.vala"
	self->priv->game = _tmp113_;
#line 208 "gnome-nibbles.vala"
	_tmp114_ = self->priv->game;
#line 208 "gnome-nibbles.vala"
	g_signal_connect_object (_tmp114_, "log-score", (GCallback) _nibbles_log_score_cb_nibbles_game_log_score, self, 0);
#line 209 "gnome-nibbles.vala"
	_tmp115_ = self->priv->game;
#line 209 "gnome-nibbles.vala"
	g_signal_connect_object (_tmp115_, "level-completed", (GCallback) _nibbles_level_completed_cb_nibbles_game_level_completed, self, 0);
#line 210 "gnome-nibbles.vala"
	_tmp116_ = self->priv->game;
#line 210 "gnome-nibbles.vala"
	g_signal_connect_object ((GObject*) _tmp116_, "notify::is-paused", (GCallback) ___lambda13__g_object_notify, self, 0);
#line 218 "gnome-nibbles.vala"
	_tmp117_ = self->priv->game;
#line 218 "gnome-nibbles.vala"
	_tmp118_ = nibbles_view_new (_tmp117_);
#line 218 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp118_);
#line 218 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->view);
#line 218 "gnome-nibbles.vala"
	self->priv->view = _tmp118_;
#line 219 "gnome-nibbles.vala"
	_tmp119_ = self->priv->view;
#line 219 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp119_, "configure-event", (GCallback) _nibbles_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 220 "gnome-nibbles.vala"
	_tmp120_ = self->priv->view;
#line 220 "gnome-nibbles.vala"
	_tmp121_ = self->priv->settings;
#line 220 "gnome-nibbles.vala"
	_tmp120_->is_muted = !g_settings_get_boolean (_tmp121_, "sound");
#line 221 "gnome-nibbles.vala"
	_tmp122_ = self->priv->view;
#line 221 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp122_);
#line 223 "gnome-nibbles.vala"
	_tmp123_ = games_grid_frame_new (NIBBLES_GAME_WIDTH, NIBBLES_GAME_HEIGHT);
#line 223 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp123_);
#line 223 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->frame);
#line 223 "gnome-nibbles.vala"
	self->priv->frame = _tmp123_;
#line 224 "gnome-nibbles.vala"
	_tmp124_ = self->priv->game_box;
#line 224 "gnome-nibbles.vala"
	_tmp125_ = self->priv->frame;
#line 224 "gnome-nibbles.vala"
	gtk_box_pack_start (_tmp124_, (GtkWidget*) _tmp125_, TRUE, TRUE, (guint) 0);
#line 227 "gnome-nibbles.vala"
	_tmp126_ = scoreboard_new ();
#line 227 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp126_);
#line 227 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard);
#line 227 "gnome-nibbles.vala"
	self->priv->scoreboard = _tmp126_;
#line 228 "gnome-nibbles.vala"
	_tmp127_ = self->priv->view;
#line 228 "gnome-nibbles.vala"
	_tmp128_ = self->priv->game;
#line 228 "gnome-nibbles.vala"
	_tmp129_ = nibbles_game_get_tile_size (_tmp128_);
#line 228 "gnome-nibbles.vala"
	_tmp130_ = _tmp129_;
#line 228 "gnome-nibbles.vala"
	_tmp131_ = self->priv->game;
#line 228 "gnome-nibbles.vala"
	_tmp132_ = nibbles_game_get_tile_size (_tmp131_);
#line 228 "gnome-nibbles.vala"
	_tmp133_ = _tmp132_;
#line 228 "gnome-nibbles.vala"
	_tmp134_ = nibbles_view_load_pixmap_file (_tmp127_, "scoreboard-life.svg", 2 * _tmp130_, 2 * _tmp133_);
#line 228 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard_life);
#line 228 "gnome-nibbles.vala"
	self->priv->scoreboard_life = _tmp134_;
#line 229 "gnome-nibbles.vala"
	_tmp135_ = self->priv->scoreboard;
#line 229 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp135_);
#line 230 "gnome-nibbles.vala"
	_tmp136_ = self->priv->statusbar_stack;
#line 230 "gnome-nibbles.vala"
	_tmp137_ = self->priv->scoreboard;
#line 230 "gnome-nibbles.vala"
	gtk_stack_add_named (_tmp136_, (GtkWidget*) _tmp137_, "scoreboard");
#line 232 "gnome-nibbles.vala"
	_tmp138_ = self->priv->frame;
#line 232 "gnome-nibbles.vala"
	_tmp139_ = self->priv->view;
#line 232 "gnome-nibbles.vala"
	gtk_container_add ((GtkContainer*) _tmp138_, (GtkWidget*) _tmp139_);
#line 233 "gnome-nibbles.vala"
	_tmp140_ = self->priv->frame;
#line 233 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp140_);
#line 236 "gnome-nibbles.vala"
	_tmp141_ = self->priv->game;
#line 236 "gnome-nibbles.vala"
	_tmp142_ = self->priv->settings;
#line 236 "gnome-nibbles.vala"
	nibbles_game_set_numhumans (_tmp141_, g_settings_get_int (_tmp142_, "players"));
#line 237 "gnome-nibbles.vala"
	_tmp143_ = self->priv->game;
#line 237 "gnome-nibbles.vala"
	_tmp144_ = self->priv->settings;
#line 237 "gnome-nibbles.vala"
	nibbles_game_set_numai (_tmp143_, g_settings_get_int (_tmp144_, "ai"));
#line 240 "gnome-nibbles.vala"
	_tmp145_ = self->priv->view;
#line 240 "gnome-nibbles.vala"
	_tmp146_ = self->priv->game;
#line 240 "gnome-nibbles.vala"
	_tmp147_ = nibbles_game_get_tile_size (_tmp146_);
#line 240 "gnome-nibbles.vala"
	_tmp148_ = _tmp147_;
#line 240 "gnome-nibbles.vala"
	_tmp149_ = self->priv->game;
#line 240 "gnome-nibbles.vala"
	_tmp150_ = nibbles_game_get_tile_size (_tmp149_);
#line 240 "gnome-nibbles.vala"
	_tmp151_ = _tmp150_;
#line 240 "gnome-nibbles.vala"
	_tmp152_ = nibbles_view_load_pixmap_file (_tmp145_, "arrow.svg", 5 * _tmp148_, 5 * _tmp151_);
#line 240 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_pixbuf);
#line 240 "gnome-nibbles.vala"
	self->priv->arrow_pixbuf = _tmp152_;
#line 241 "gnome-nibbles.vala"
	_tmp153_ = self->priv->view;
#line 241 "gnome-nibbles.vala"
	_tmp154_ = self->priv->game;
#line 241 "gnome-nibbles.vala"
	_tmp155_ = nibbles_game_get_tile_size (_tmp154_);
#line 241 "gnome-nibbles.vala"
	_tmp156_ = _tmp155_;
#line 241 "gnome-nibbles.vala"
	_tmp157_ = self->priv->game;
#line 241 "gnome-nibbles.vala"
	_tmp158_ = nibbles_game_get_tile_size (_tmp157_);
#line 241 "gnome-nibbles.vala"
	_tmp159_ = _tmp158_;
#line 241 "gnome-nibbles.vala"
	_tmp160_ = nibbles_view_load_pixmap_file (_tmp153_, "arrow-key.svg", 5 * _tmp156_, 5 * _tmp159_);
#line 241 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
#line 241 "gnome-nibbles.vala"
	self->priv->arrow_key_pixbuf = _tmp160_;
#line 244 "gnome-nibbles.vala"
	_tmp161_ = self->priv->settings;
#line 244 "gnome-nibbles.vala"
	first_run = g_settings_get_boolean (_tmp161_, "first-run");
#line 245 "gnome-nibbles.vala"
	_tmp162_ = first_run;
#line 245 "gnome-nibbles.vala"
	if (_tmp162_) {
#line 246 "gnome-nibbles.vala"
		nibbles_show_first_run_screen (self);
#line 1849 "gnome-nibbles.c"
	} else {
#line 248 "gnome-nibbles.vala"
		nibbles_show_new_game_screen_cb (self);
#line 1853 "gnome-nibbles.c"
	}
#line 251 "gnome-nibbles.vala"
	nibbles_create_scores (self);
#line 253 "gnome-nibbles.vala"
	_tmp163_ = self->priv->window;
#line 253 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp163_);
#line 129 "gnome-nibbles.vala"
	_g_object_unref0 (builder);
#line 129 "gnome-nibbles.vala"
	_g_object_unref0 (css_provider);
#line 1865 "gnome-nibbles.c"
}


static void
nibbles_real_activate (GApplication* base)
{
	Nibbles * self;
	GtkApplicationWindow* _tmp0_;
#line 256 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 258 "gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 260 "gnome-nibbles.vala"
	_tmp0_ = self->priv->window;
#line 260 "gnome-nibbles.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1882 "gnome-nibbles.c"
}


static void
nibbles_real_shutdown (GApplication* base)
{
	Nibbles * self;
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gboolean _tmp5_;
	NibblesGame* _tmp6_;
	GSettings* _tmp7_;
#line 263 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 265 "gnome-nibbles.vala"
	_tmp0_ = self->priv->settings;
#line 265 "gnome-nibbles.vala"
	_tmp1_ = self->priv->window_width;
#line 265 "gnome-nibbles.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 266 "gnome-nibbles.vala"
	_tmp2_ = self->priv->settings;
#line 266 "gnome-nibbles.vala"
	_tmp3_ = self->priv->window_height;
#line 266 "gnome-nibbles.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 267 "gnome-nibbles.vala"
	_tmp4_ = self->priv->settings;
#line 267 "gnome-nibbles.vala"
	_tmp5_ = self->priv->is_maximized;
#line 267 "gnome-nibbles.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 268 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 268 "gnome-nibbles.vala"
	_tmp7_ = self->priv->settings;
#line 268 "gnome-nibbles.vala"
	nibbles_game_save_properties (_tmp6_, _tmp7_);
#line 270 "gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1926 "gnome-nibbles.c"
}


static gboolean
nibbles_countdown_cb (Nibbles* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	GtkLabel* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
#line 273 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 275 "gnome-nibbles.vala"
	_tmp0_ = self->priv->seconds;
#line 275 "gnome-nibbles.vala"
	self->priv->seconds = _tmp0_ - 1;
#line 277 "gnome-nibbles.vala"
	_tmp1_ = self->priv->seconds;
#line 277 "gnome-nibbles.vala"
	if (_tmp1_ == 0) {
#line 1950 "gnome-nibbles.c"
		GtkStack* _tmp2_;
		NibblesView* _tmp3_;
		ClutterActor* _tmp4_;
		ClutterActor* _tmp5_;
		NibblesGame* _tmp6_;
		NibblesGame* _tmp7_;
		GSimpleAction* _tmp8_;
		GSimpleAction* _tmp9_;
#line 279 "gnome-nibbles.vala"
		_tmp2_ = self->priv->statusbar_stack;
#line 279 "gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp2_, "scoreboard");
#line 280 "gnome-nibbles.vala"
		_tmp3_ = self->priv->view;
#line 280 "gnome-nibbles.vala"
		_tmp4_ = nibbles_view_get_name_labels (_tmp3_);
#line 280 "gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 280 "gnome-nibbles.vala"
		clutter_actor_hide (_tmp5_);
#line 282 "gnome-nibbles.vala"
		_tmp6_ = self->priv->game;
#line 282 "gnome-nibbles.vala"
		nibbles_game_add_bonus (_tmp6_, TRUE);
#line 283 "gnome-nibbles.vala"
		_tmp7_ = self->priv->game;
#line 283 "gnome-nibbles.vala"
		nibbles_game_start (_tmp7_);
#line 285 "gnome-nibbles.vala"
		_tmp8_ = self->priv->pause_action;
#line 285 "gnome-nibbles.vala"
		g_simple_action_set_enabled (_tmp8_, TRUE);
#line 286 "gnome-nibbles.vala"
		_tmp9_ = self->priv->back_action;
#line 286 "gnome-nibbles.vala"
		g_simple_action_set_enabled (_tmp9_, TRUE);
#line 288 "gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 289 "gnome-nibbles.vala"
		result = G_SOURCE_REMOVE;
#line 289 "gnome-nibbles.vala"
		return result;
#line 1993 "gnome-nibbles.c"
	}
#line 292 "gnome-nibbles.vala"
	_tmp10_ = self->priv->countdown;
#line 292 "gnome-nibbles.vala"
	_tmp11_ = self->priv->seconds;
#line 292 "gnome-nibbles.vala"
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 292 "gnome-nibbles.vala"
	_tmp13_ = _tmp12_;
#line 292 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp10_, _tmp13_);
#line 292 "gnome-nibbles.vala"
	_g_free0 (_tmp13_);
#line 293 "gnome-nibbles.vala"
	result = G_SOURCE_CONTINUE;
#line 293 "gnome-nibbles.vala"
	return result;
#line 2011 "gnome-nibbles.c"
}


static gboolean
nibbles_key_press_event_cb (Nibbles* self,
                            GtkWidget* widget,
                            GdkEventKey* event)
{
	gboolean result = FALSE;
	NibblesGame* _tmp0_;
	guint _tmp1_;
#line 305 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 305 "gnome-nibbles.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 305 "gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 307 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 307 "gnome-nibbles.vala"
	_tmp1_ = event->keyval;
#line 307 "gnome-nibbles.vala"
	result = nibbles_game_handle_keypress (_tmp0_, _tmp1_);
#line 307 "gnome-nibbles.vala"
	return result;
#line 2037 "gnome-nibbles.c"
}


static void
nibbles_size_allocate_cb (Nibbles* self,
                          GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 310 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 310 "gnome-nibbles.vala"
	g_return_if_fail (allocation != NULL);
#line 312 "gnome-nibbles.vala"
	_tmp1_ = self->priv->is_maximized;
#line 312 "gnome-nibbles.vala"
	if (_tmp1_) {
#line 312 "gnome-nibbles.vala"
		_tmp0_ = TRUE;
#line 2060 "gnome-nibbles.c"
	} else {
		gboolean _tmp2_;
#line 312 "gnome-nibbles.vala"
		_tmp2_ = self->priv->is_tiled;
#line 312 "gnome-nibbles.vala"
		_tmp0_ = _tmp2_;
#line 2067 "gnome-nibbles.c"
	}
#line 312 "gnome-nibbles.vala"
	if (_tmp0_) {
#line 313 "gnome-nibbles.vala"
		return;
#line 2073 "gnome-nibbles.c"
	}
#line 314 "gnome-nibbles.vala"
	_tmp3_ = self->priv->window;
#line 314 "gnome-nibbles.vala"
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
#line 314 "gnome-nibbles.vala"
	self->priv->window_width = _tmp4_;
#line 314 "gnome-nibbles.vala"
	self->priv->window_height = _tmp5_;
#line 2083 "gnome-nibbles.c"
}


static gboolean
nibbles_window_state_event_cb (Nibbles* self,
                               GdkEventWindowState* event)
{
	gboolean result = FALSE;
	GdkWindowState _tmp0_;
	GdkWindowState _tmp2_;
#line 317 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 317 "gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 319 "gnome-nibbles.vala"
	_tmp0_ = event->changed_mask;
#line 319 "gnome-nibbles.vala"
	if ((_tmp0_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 2102 "gnome-nibbles.c"
		GdkWindowState _tmp1_;
#line 320 "gnome-nibbles.vala"
		_tmp1_ = event->new_window_state;
#line 320 "gnome-nibbles.vala"
		self->priv->is_maximized = (_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 2108 "gnome-nibbles.c"
	}
#line 322 "gnome-nibbles.vala"
	_tmp2_ = event->changed_mask;
#line 322 "gnome-nibbles.vala"
	if ((_tmp2_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 2114 "gnome-nibbles.c"
		GdkWindowState _tmp3_;
#line 323 "gnome-nibbles.vala"
		_tmp3_ = event->new_window_state;
#line 323 "gnome-nibbles.vala"
		self->priv->is_tiled = (_tmp3_ & GDK_WINDOW_STATE_TILED) != 0;
#line 2120 "gnome-nibbles.c"
	}
#line 324 "gnome-nibbles.vala"
	result = FALSE;
#line 324 "gnome-nibbles.vala"
	return result;
#line 2126 "gnome-nibbles.c"
}


static gboolean
nibbles_configure_event_cb (Nibbles* self,
                            GdkEventConfigure* event)
{
	gboolean result = FALSE;
	gint tile_size = 0;
	gint ts_x = 0;
	gint ts_y = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	NibblesGame* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
#line 327 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 327 "gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 334 "gnome-nibbles.vala"
	_tmp0_ = event->width;
#line 334 "gnome-nibbles.vala"
	ts_x = _tmp0_ / NIBBLES_GAME_WIDTH;
#line 335 "gnome-nibbles.vala"
	_tmp1_ = event->height;
#line 335 "gnome-nibbles.vala"
	ts_y = _tmp1_ / NIBBLES_GAME_HEIGHT;
#line 336 "gnome-nibbles.vala"
	_tmp2_ = ts_x;
#line 336 "gnome-nibbles.vala"
	_tmp3_ = event->width;
#line 336 "gnome-nibbles.vala"
	if ((_tmp2_ * NIBBLES_GAME_WIDTH) > _tmp3_) {
#line 2170 "gnome-nibbles.c"
		gint _tmp4_;
#line 337 "gnome-nibbles.vala"
		_tmp4_ = ts_x;
#line 337 "gnome-nibbles.vala"
		ts_x = _tmp4_ - 1;
#line 2176 "gnome-nibbles.c"
	}
#line 338 "gnome-nibbles.vala"
	_tmp5_ = ts_y;
#line 338 "gnome-nibbles.vala"
	_tmp6_ = event->height;
#line 338 "gnome-nibbles.vala"
	if ((_tmp5_ * NIBBLES_GAME_HEIGHT) > _tmp6_) {
#line 2184 "gnome-nibbles.c"
		gint _tmp7_;
#line 339 "gnome-nibbles.vala"
		_tmp7_ = ts_y;
#line 339 "gnome-nibbles.vala"
		ts_y = _tmp7_ - 1;
#line 2190 "gnome-nibbles.c"
	}
#line 340 "gnome-nibbles.vala"
	_tmp8_ = ts_x;
#line 340 "gnome-nibbles.vala"
	_tmp9_ = ts_y;
#line 340 "gnome-nibbles.vala"
	tile_size = MIN (_tmp8_, _tmp9_);
#line 342 "gnome-nibbles.vala"
	_tmp11_ = tile_size;
#line 342 "gnome-nibbles.vala"
	if (_tmp11_ == 0) {
#line 342 "gnome-nibbles.vala"
		_tmp10_ = TRUE;
#line 2204 "gnome-nibbles.c"
	} else {
		NibblesGame* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 342 "gnome-nibbles.vala"
		_tmp12_ = self->priv->game;
#line 342 "gnome-nibbles.vala"
		_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
#line 342 "gnome-nibbles.vala"
		_tmp14_ = _tmp13_;
#line 342 "gnome-nibbles.vala"
		_tmp10_ = _tmp14_ == 0;
#line 2217 "gnome-nibbles.c"
	}
#line 342 "gnome-nibbles.vala"
	if (_tmp10_) {
#line 343 "gnome-nibbles.vala"
		result = TRUE;
#line 343 "gnome-nibbles.vala"
		return result;
#line 2225 "gnome-nibbles.c"
	}
#line 345 "gnome-nibbles.vala"
	_tmp15_ = self->priv->game;
#line 345 "gnome-nibbles.vala"
	_tmp16_ = nibbles_game_get_tile_size (_tmp15_);
#line 345 "gnome-nibbles.vala"
	_tmp17_ = _tmp16_;
#line 345 "gnome-nibbles.vala"
	_tmp18_ = tile_size;
#line 345 "gnome-nibbles.vala"
	if (_tmp17_ != _tmp18_) {
#line 2237 "gnome-nibbles.c"
		NibblesView* _tmp19_;
		ClutterActor* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		NibblesView* _tmp23_;
		gint _tmp24_;
		NibblesView* _tmp25_;
		gint _tmp26_;
		NibblesView* _tmp27_;
		gint _tmp28_;
		NibblesGame* _tmp44_;
		gint _tmp45_;
#line 347 "gnome-nibbles.vala"
		_tmp19_ = self->priv->view;
#line 347 "gnome-nibbles.vala"
		_tmp20_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) _tmp19_);
#line 347 "gnome-nibbles.vala"
		_tmp21_ = tile_size;
#line 347 "gnome-nibbles.vala"
		_tmp22_ = tile_size;
#line 347 "gnome-nibbles.vala"
		clutter_actor_set_size (_tmp20_, (gfloat) (_tmp21_ * NIBBLES_GAME_WIDTH), (gfloat) (_tmp22_ * NIBBLES_GAME_HEIGHT));
#line 349 "gnome-nibbles.vala"
		_tmp23_ = self->priv->view;
#line 349 "gnome-nibbles.vala"
		_tmp24_ = tile_size;
#line 349 "gnome-nibbles.vala"
		nibbles_view_board_rescale (_tmp23_, _tmp24_);
#line 350 "gnome-nibbles.vala"
		_tmp25_ = self->priv->view;
#line 350 "gnome-nibbles.vala"
		_tmp26_ = tile_size;
#line 350 "gnome-nibbles.vala"
		nibbles_view_boni_rescale (_tmp25_, _tmp26_);
#line 351 "gnome-nibbles.vala"
		_tmp27_ = self->priv->view;
#line 351 "gnome-nibbles.vala"
		_tmp28_ = tile_size;
#line 351 "gnome-nibbles.vala"
		nibbles_view_warps_rescale (_tmp27_, _tmp28_);
#line 2278 "gnome-nibbles.c"
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesGame* _tmp29_;
			GeeLinkedList* _tmp30_;
			GeeLinkedList* _tmp31_;
			GeeLinkedList* _tmp32_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _worm_index = 0;
#line 352 "gnome-nibbles.vala"
			_tmp29_ = self->priv->game;
#line 352 "gnome-nibbles.vala"
			_tmp30_ = nibbles_game_get_worms (_tmp29_);
#line 352 "gnome-nibbles.vala"
			_tmp31_ = _tmp30_;
#line 352 "gnome-nibbles.vala"
			_tmp32_ = _g_object_ref0 (_tmp31_);
#line 352 "gnome-nibbles.vala"
			_worm_list = _tmp32_;
#line 352 "gnome-nibbles.vala"
			_tmp33_ = _worm_list;
#line 352 "gnome-nibbles.vala"
			_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
#line 352 "gnome-nibbles.vala"
			_tmp35_ = _tmp34_;
#line 352 "gnome-nibbles.vala"
			_worm_size = _tmp35_;
#line 352 "gnome-nibbles.vala"
			_worm_index = -1;
#line 352 "gnome-nibbles.vala"
			while (TRUE) {
#line 2312 "gnome-nibbles.c"
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp39_;
				gint _tmp40_;
				gpointer _tmp41_;
				Worm* _tmp42_;
				gint _tmp43_;
#line 352 "gnome-nibbles.vala"
				_tmp36_ = _worm_index;
#line 352 "gnome-nibbles.vala"
				_worm_index = _tmp36_ + 1;
#line 352 "gnome-nibbles.vala"
				_tmp37_ = _worm_index;
#line 352 "gnome-nibbles.vala"
				_tmp38_ = _worm_size;
#line 352 "gnome-nibbles.vala"
				if (!(_tmp37_ < _tmp38_)) {
#line 352 "gnome-nibbles.vala"
					break;
#line 2334 "gnome-nibbles.c"
				}
#line 352 "gnome-nibbles.vala"
				_tmp39_ = _worm_list;
#line 352 "gnome-nibbles.vala"
				_tmp40_ = _worm_index;
#line 352 "gnome-nibbles.vala"
				_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
#line 352 "gnome-nibbles.vala"
				worm = (Worm*) _tmp41_;
#line 353 "gnome-nibbles.vala"
				_tmp42_ = worm;
#line 353 "gnome-nibbles.vala"
				_tmp43_ = tile_size;
#line 353 "gnome-nibbles.vala"
				g_signal_emit_by_name (_tmp42_, "rescaled", _tmp43_);
#line 352 "gnome-nibbles.vala"
				_g_object_unref0 (worm);
#line 2352 "gnome-nibbles.c"
			}
#line 352 "gnome-nibbles.vala"
			_g_object_unref0 (_worm_list);
#line 2356 "gnome-nibbles.c"
		}
#line 355 "gnome-nibbles.vala"
		_tmp44_ = self->priv->game;
#line 355 "gnome-nibbles.vala"
		_tmp45_ = tile_size;
#line 355 "gnome-nibbles.vala"
		nibbles_game_set_tile_size (_tmp44_, _tmp45_);
#line 2364 "gnome-nibbles.c"
	}
#line 358 "gnome-nibbles.vala"
	result = FALSE;
#line 358 "gnome-nibbles.vala"
	return result;
#line 2370 "gnome-nibbles.c"
}


static void
_scoreboard_update_g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
#line 375 "gnome-nibbles.vala"
	scoreboard_update ((Scoreboard*) self);
#line 2381 "gnome-nibbles.c"
}


static void
nibbles_start_game_cb (Nibbles* self)
{
	GSettings* _tmp0_;
	NibblesGame* _tmp1_;
	NibblesView* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesView* _tmp6_;
	Scoreboard* _tmp7_;
	NibblesGame* _tmp39_;
	NibblesView* _tmp40_;
#line 361 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 363 "gnome-nibbles.vala"
	_tmp0_ = self->priv->settings;
#line 363 "gnome-nibbles.vala"
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
#line 365 "gnome-nibbles.vala"
	_tmp1_ = self->priv->game;
#line 365 "gnome-nibbles.vala"
	nibbles_game_reset (_tmp1_);
#line 367 "gnome-nibbles.vala"
	_tmp2_ = self->priv->view;
#line 367 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 367 "gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
#line 367 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 367 "gnome-nibbles.vala"
	nibbles_view_new_level (_tmp2_, _tmp5_);
#line 368 "gnome-nibbles.vala"
	_tmp6_ = self->priv->view;
#line 368 "gnome-nibbles.vala"
	nibbles_view_connect_worm_signals (_tmp6_);
#line 370 "gnome-nibbles.vala"
	_tmp7_ = self->priv->scoreboard;
#line 370 "gnome-nibbles.vala"
	scoreboard_clear (_tmp7_);
#line 2426 "gnome-nibbles.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp8_;
		GeeLinkedList* _tmp9_;
		GeeLinkedList* _tmp10_;
		GeeLinkedList* _tmp11_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _worm_index = 0;
#line 371 "gnome-nibbles.vala"
		_tmp8_ = self->priv->game;
#line 371 "gnome-nibbles.vala"
		_tmp9_ = nibbles_game_get_worms (_tmp8_);
#line 371 "gnome-nibbles.vala"
		_tmp10_ = _tmp9_;
#line 371 "gnome-nibbles.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 371 "gnome-nibbles.vala"
		_worm_list = _tmp11_;
#line 371 "gnome-nibbles.vala"
		_tmp12_ = _worm_list;
#line 371 "gnome-nibbles.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
#line 371 "gnome-nibbles.vala"
		_tmp14_ = _tmp13_;
#line 371 "gnome-nibbles.vala"
		_worm_size = _tmp14_;
#line 371 "gnome-nibbles.vala"
		_worm_index = -1;
#line 371 "gnome-nibbles.vala"
		while (TRUE) {
#line 2460 "gnome-nibbles.c"
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			gint color = 0;
			NibblesGame* _tmp21_;
			GeeHashMap* _tmp22_;
			GeeHashMap* _tmp23_;
			Worm* _tmp24_;
			gpointer _tmp25_;
			WormProperties* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			Scoreboard* _tmp29_;
			Worm* _tmp30_;
			gint _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GdkPixbuf* _tmp34_;
			Worm* _tmp35_;
			Scoreboard* _tmp36_;
			Worm* _tmp37_;
			Scoreboard* _tmp38_;
#line 371 "gnome-nibbles.vala"
			_tmp15_ = _worm_index;
#line 371 "gnome-nibbles.vala"
			_worm_index = _tmp15_ + 1;
#line 371 "gnome-nibbles.vala"
			_tmp16_ = _worm_index;
#line 371 "gnome-nibbles.vala"
			_tmp17_ = _worm_size;
#line 371 "gnome-nibbles.vala"
			if (!(_tmp16_ < _tmp17_)) {
#line 371 "gnome-nibbles.vala"
				break;
#line 2499 "gnome-nibbles.c"
			}
#line 371 "gnome-nibbles.vala"
			_tmp18_ = _worm_list;
#line 371 "gnome-nibbles.vala"
			_tmp19_ = _worm_index;
#line 371 "gnome-nibbles.vala"
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
#line 371 "gnome-nibbles.vala"
			worm = (Worm*) _tmp20_;
#line 373 "gnome-nibbles.vala"
			_tmp21_ = self->priv->game;
#line 373 "gnome-nibbles.vala"
			_tmp22_ = nibbles_game_get_worm_props (_tmp21_);
#line 373 "gnome-nibbles.vala"
			_tmp23_ = _tmp22_;
#line 373 "gnome-nibbles.vala"
			_tmp24_ = worm;
#line 373 "gnome-nibbles.vala"
			_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
#line 373 "gnome-nibbles.vala"
			_tmp26_ = (WormProperties*) _tmp25_;
#line 373 "gnome-nibbles.vala"
			_tmp27_ = (*_tmp26_).color;
#line 373 "gnome-nibbles.vala"
			_tmp28_ = _tmp27_;
#line 373 "gnome-nibbles.vala"
			_worm_properties_free0 (_tmp26_);
#line 373 "gnome-nibbles.vala"
			color = _tmp28_;
#line 374 "gnome-nibbles.vala"
			_tmp29_ = self->priv->scoreboard;
#line 374 "gnome-nibbles.vala"
			_tmp30_ = worm;
#line 374 "gnome-nibbles.vala"
			_tmp31_ = color;
#line 374 "gnome-nibbles.vala"
			_tmp32_ = nibbles_view_colorval_name (_tmp31_);
#line 374 "gnome-nibbles.vala"
			_tmp33_ = _tmp32_;
#line 374 "gnome-nibbles.vala"
			_tmp34_ = self->priv->scoreboard_life;
#line 374 "gnome-nibbles.vala"
			scoreboard_register (_tmp29_, _tmp30_, _tmp33_, _tmp34_);
#line 374 "gnome-nibbles.vala"
			_g_free0 (_tmp33_);
#line 375 "gnome-nibbles.vala"
			_tmp35_ = worm;
#line 375 "gnome-nibbles.vala"
			_tmp36_ = self->priv->scoreboard;
#line 375 "gnome-nibbles.vala"
			g_signal_connect_object ((GObject*) _tmp35_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp36_, 0);
#line 376 "gnome-nibbles.vala"
			_tmp37_ = worm;
#line 376 "gnome-nibbles.vala"
			_tmp38_ = self->priv->scoreboard;
#line 376 "gnome-nibbles.vala"
			g_signal_connect_object ((GObject*) _tmp37_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp38_, 0);
#line 371 "gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 2559 "gnome-nibbles.c"
		}
#line 371 "gnome-nibbles.vala"
		_g_object_unref0 (_worm_list);
#line 2563 "gnome-nibbles.c"
	}
#line 378 "gnome-nibbles.vala"
	_tmp39_ = self->priv->game;
#line 378 "gnome-nibbles.vala"
	nibbles_game_add_worms (_tmp39_);
#line 380 "gnome-nibbles.vala"
	_tmp40_ = self->priv->view;
#line 380 "gnome-nibbles.vala"
	nibbles_view_create_name_labels (_tmp40_);
#line 382 "gnome-nibbles.vala"
	nibbles_show_game_view (self);
#line 384 "gnome-nibbles.vala"
	nibbles_start_game_with_countdown (self);
#line 2577 "gnome-nibbles.c"
}


static gboolean
_nibbles_countdown_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_countdown_cb ((Nibbles*) self);
#line 397 "gnome-nibbles.vala"
	return result;
#line 2588 "gnome-nibbles.c"
}


static void
nibbles_start_game_with_countdown (Nibbles* self)
{
	GtkStack* _tmp0_;
	GSimpleAction* _tmp1_;
	NibblesView* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 387 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 389 "gnome-nibbles.vala"
	_tmp0_ = self->priv->statusbar_stack;
#line 389 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "countdown");
#line 391 "gnome-nibbles.vala"
	_tmp1_ = self->priv->new_game_action;
#line 391 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp1_, TRUE);
#line 393 "gnome-nibbles.vala"
	self->priv->seconds = NIBBLES_COUNTDOWN_TIME;
#line 394 "gnome-nibbles.vala"
	_tmp2_ = self->priv->view;
#line 394 "gnome-nibbles.vala"
	_tmp3_ = nibbles_view_get_name_labels (_tmp2_);
#line 394 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 394 "gnome-nibbles.vala"
	clutter_actor_show (_tmp4_);
#line 396 "gnome-nibbles.vala"
	_tmp5_ = self->priv->countdown;
#line 396 "gnome-nibbles.vala"
	_tmp6_ = g_strdup_printf ("%i", NIBBLES_COUNTDOWN_TIME);
#line 396 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 396 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp5_, _tmp7_);
#line 396 "gnome-nibbles.vala"
	_g_free0 (_tmp7_);
#line 397 "gnome-nibbles.vala"
	self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 2635 "gnome-nibbles.c"
}


static void
nibbles_restart_game (Nibbles* self)
{
	NibblesView* _tmp0_;
	NibblesGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NibblesGame* _tmp4_;
#line 400 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 402 "gnome-nibbles.vala"
	_tmp0_ = self->priv->view;
#line 402 "gnome-nibbles.vala"
	_tmp1_ = self->priv->game;
#line 402 "gnome-nibbles.vala"
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
#line 402 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 402 "gnome-nibbles.vala"
	nibbles_view_new_level (_tmp0_, _tmp3_);
#line 404 "gnome-nibbles.vala"
	_tmp4_ = self->priv->game;
#line 404 "gnome-nibbles.vala"
	nibbles_game_add_worms (_tmp4_);
#line 405 "gnome-nibbles.vala"
	nibbles_start_game_with_countdown (self);
#line 2665 "gnome-nibbles.c"
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 408 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 408 "gnome-nibbles.vala"
	return _data1_;
#line 2676 "gnome-nibbles.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 408 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 2687 "gnome-nibbles.c"
		Nibbles* self;
#line 408 "gnome-nibbles.vala"
		self = _data1_->self;
#line 408 "gnome-nibbles.vala"
		_g_object_unref0 (_data1_->dialog);
#line 408 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 408 "gnome-nibbles.vala"
		g_slice_free (Block1Data, _data1_);
#line 2697 "gnome-nibbles.c"
	}
}


static void
__lambda7_ (Block1Data* _data1_,
            gint response_id)
{
	Nibbles* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 428 "gnome-nibbles.vala"
	self = _data1_->self;
#line 429 "gnome-nibbles.vala"
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
#line 430 "gnome-nibbles.vala"
		nibbles_show_new_game_screen_cb (self);
#line 2715 "gnome-nibbles.c"
	}
#line 431 "gnome-nibbles.vala"
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
#line 431 "gnome-nibbles.vala"
		_tmp1_ = TRUE;
#line 2721 "gnome-nibbles.c"
	} else {
#line 431 "gnome-nibbles.vala"
		_tmp1_ = response_id == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 2725 "gnome-nibbles.c"
	}
#line 431 "gnome-nibbles.vala"
	if (_tmp1_) {
#line 2729 "gnome-nibbles.c"
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 432 "gnome-nibbles.vala"
		_tmp2_ = self->priv->game;
#line 432 "gnome-nibbles.vala"
		_tmp3_ = nibbles_game_get_is_paused (_tmp2_);
#line 432 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 432 "gnome-nibbles.vala"
		_tmp0_ = !_tmp4_;
#line 2741 "gnome-nibbles.c"
	} else {
#line 431 "gnome-nibbles.vala"
		_tmp0_ = FALSE;
#line 2745 "gnome-nibbles.c"
	}
#line 431 "gnome-nibbles.vala"
	if (_tmp0_) {
#line 2749 "gnome-nibbles.c"
		gint _tmp5_;
		NibblesView* _tmp7_;
#line 434 "gnome-nibbles.vala"
		_tmp5_ = self->priv->seconds;
#line 434 "gnome-nibbles.vala"
		if (_tmp5_ == 0) {
#line 2756 "gnome-nibbles.c"
			NibblesGame* _tmp6_;
#line 435 "gnome-nibbles.vala"
			_tmp6_ = self->priv->game;
#line 435 "gnome-nibbles.vala"
			nibbles_game_start (_tmp6_);
#line 2762 "gnome-nibbles.c"
		} else {
#line 437 "gnome-nibbles.vala"
			self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 2766 "gnome-nibbles.c"
		}
#line 439 "gnome-nibbles.vala"
		_tmp7_ = self->priv->view;
#line 439 "gnome-nibbles.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
#line 2772 "gnome-nibbles.c"
	}
#line 442 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 2776 "gnome-nibbles.c"
}


static void
___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
#line 428 "gnome-nibbles.vala"
	__lambda7_ (self, response_id);
#line 2787 "gnome-nibbles.c"
}


static void
nibbles_new_game_cb (Nibbles* self)
{
	Block1Data* _data1_;
	guint _tmp0_;
	NibblesGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkApplicationWindow* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkButton* button = NULL;
	GtkWidget* _tmp8_;
	GtkButton* _tmp9_;
#line 408 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 408 "gnome-nibbles.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 408 "gnome-nibbles.vala"
	_data1_->_ref_count_ = 1;
#line 408 "gnome-nibbles.vala"
	_data1_->self = g_object_ref (self);
#line 410 "gnome-nibbles.vala"
	_tmp0_ = self->priv->countdown_id;
#line 410 "gnome-nibbles.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2816 "gnome-nibbles.c"
		guint _tmp1_;
#line 412 "gnome-nibbles.vala"
		_tmp1_ = self->priv->countdown_id;
#line 412 "gnome-nibbles.vala"
		g_source_remove (_tmp1_);
#line 413 "gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 2824 "gnome-nibbles.c"
	}
#line 416 "gnome-nibbles.vala"
	_tmp2_ = self->priv->game;
#line 416 "gnome-nibbles.vala"
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
#line 416 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 416 "gnome-nibbles.vala"
	if (_tmp4_) {
#line 2834 "gnome-nibbles.c"
		NibblesGame* _tmp5_;
#line 417 "gnome-nibbles.vala"
		_tmp5_ = self->priv->game;
#line 417 "gnome-nibbles.vala"
		nibbles_game_stop (_tmp5_);
#line 2840 "gnome-nibbles.c"
	}
#line 419 "gnome-nibbles.vala"
	_tmp6_ = self->priv->window;
#line 419 "gnome-nibbles.vala"
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp6_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Are you sure you want to start a new game?"));
#line 419 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp7_);
#line 419 "gnome-nibbles.vala"
	_data1_->dialog = _tmp7_;
#line 424 "gnome-nibbles.vala"
	g_object_set (_data1_->dialog, "secondary-text", _ ("If you start a new game, the current one will be lost."), NULL);
#line 426 "gnome-nibbles.vala"
	_tmp8_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data1_->dialog, (gint) GTK_RESPONSE_OK);
#line 426 "gnome-nibbles.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton));
#line 426 "gnome-nibbles.vala"
	button = _tmp9_;
#line 427 "gnome-nibbles.vala"
	gtk_button_set_label (button, _ ("_New Game"));
#line 428 "gnome-nibbles.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda7__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 445 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _data1_->dialog);
#line 408 "gnome-nibbles.vala"
	_g_object_unref0 (button);
#line 408 "gnome-nibbles.vala"
	block1_data_unref (_data1_);
#line 408 "gnome-nibbles.vala"
	_data1_ = NULL;
#line 2870 "gnome-nibbles.c"
}


static void
nibbles_pause_cb (Nibbles* self)
{
	NibblesGame* _tmp0_;
#line 448 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 450 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 450 "gnome-nibbles.vala"
	if (_tmp0_ != NULL) {
#line 2884 "gnome-nibbles.c"
		NibblesGame* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 452 "gnome-nibbles.vala"
		_tmp1_ = self->priv->game;
#line 452 "gnome-nibbles.vala"
		_tmp2_ = nibbles_game_get_is_running (_tmp1_);
#line 452 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 452 "gnome-nibbles.vala"
		if (_tmp3_) {
#line 2896 "gnome-nibbles.c"
			NibblesGame* _tmp4_;
			GtkButton* _tmp5_;
#line 454 "gnome-nibbles.vala"
			_tmp4_ = self->priv->game;
#line 454 "gnome-nibbles.vala"
			nibbles_game_pause (_tmp4_);
#line 455 "gnome-nibbles.vala"
			_tmp5_ = self->priv->pause_button;
#line 455 "gnome-nibbles.vala"
			gtk_button_set_label (_tmp5_, _ ("_Resume"));
#line 2907 "gnome-nibbles.c"
		} else {
			NibblesGame* _tmp6_;
			GtkButton* _tmp7_;
			NibblesView* _tmp8_;
#line 459 "gnome-nibbles.vala"
			_tmp6_ = self->priv->game;
#line 459 "gnome-nibbles.vala"
			nibbles_game_unpause (_tmp6_);
#line 460 "gnome-nibbles.vala"
			_tmp7_ = self->priv->pause_button;
#line 460 "gnome-nibbles.vala"
			gtk_button_set_label (_tmp7_, _ ("_Pause"));
#line 461 "gnome-nibbles.vala"
			_tmp8_ = self->priv->view;
#line 461 "gnome-nibbles.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 2924 "gnome-nibbles.c"
		}
	}
}


static void
nibbles_settings_changed_cb (Nibbles* self,
                             const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 472 "gnome-nibbles.vala"
	static GQuark _tmp1_label0 = 0;
#line 472 "gnome-nibbles.vala"
	static GQuark _tmp1_label1 = 0;
#line 472 "gnome-nibbles.vala"
	static GQuark _tmp1_label2 = 0;
#line 470 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 470 "gnome-nibbles.vala"
	g_return_if_fail (key != NULL);
#line 472 "gnome-nibbles.vala"
	_tmp0_ = key;
#line 472 "gnome-nibbles.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 472 "gnome-nibbles.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("speed")))) {
#line 472 "gnome-nibbles.vala"
		switch (0) {
#line 2954 "gnome-nibbles.c"
			default:
			{
				NibblesGame* _tmp3_;
				GSettings* _tmp4_;
#line 475 "gnome-nibbles.vala"
				_tmp3_ = self->priv->game;
#line 475 "gnome-nibbles.vala"
				_tmp4_ = self->priv->settings;
#line 475 "gnome-nibbles.vala"
				nibbles_game_set_speed (_tmp3_, g_settings_get_int (_tmp4_, key));
#line 476 "gnome-nibbles.vala"
				break;
#line 2967 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("sound")))) {
#line 472 "gnome-nibbles.vala"
		switch (0) {
#line 2973 "gnome-nibbles.c"
			default:
			{
				NibblesView* _tmp5_;
				GSettings* _tmp6_;
#line 478 "gnome-nibbles.vala"
				_tmp5_ = self->priv->view;
#line 478 "gnome-nibbles.vala"
				_tmp6_ = self->priv->settings;
#line 478 "gnome-nibbles.vala"
				_tmp5_->is_muted = !g_settings_get_boolean (_tmp6_, key);
#line 479 "gnome-nibbles.vala"
				break;
#line 2986 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("fakes")))) {
#line 472 "gnome-nibbles.vala"
		switch (0) {
#line 2992 "gnome-nibbles.c"
			default:
			{
				NibblesGame* _tmp7_;
				GSettings* _tmp8_;
#line 481 "gnome-nibbles.vala"
				_tmp7_ = self->priv->game;
#line 481 "gnome-nibbles.vala"
				_tmp8_ = self->priv->settings;
#line 481 "gnome-nibbles.vala"
				nibbles_game_set_fakes (_tmp7_, g_settings_get_boolean (_tmp8_, key));
#line 482 "gnome-nibbles.vala"
				break;
#line 3005 "gnome-nibbles.c"
			}
		}
	}
}


static void
nibbles_worm_settings_changed_cb (Nibbles* self,
                                  GSettings* changed_worm_settings,
                                  const gchar* key)
{
	NibblesGame* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint id = 0;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	NibblesGame* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Worm* worm = NULL;
	NibblesGame* _tmp10_;
	GeeLinkedList* _tmp11_;
	GeeLinkedList* _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_;
	WormProperties* properties = NULL;
	NibblesGame* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	Worm* _tmp18_;
	gpointer _tmp19_;
	const gchar* _tmp20_;
	GQuark _tmp22_ = 0U;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp21_label0 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp21_label1 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp21_label2 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp21_label3 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp21_label4 = 0;
#line 3052 "gnome-nibbles.c"
	NibblesGame* _tmp28_;
	GeeHashMap* _tmp29_;
	GeeHashMap* _tmp30_;
	Worm* _tmp31_;
	WormProperties* _tmp32_;
#line 486 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 486 "gnome-nibbles.vala"
	g_return_if_fail (changed_worm_settings != NULL);
#line 486 "gnome-nibbles.vala"
	g_return_if_fail (key != NULL);
#line 489 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 489 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
#line 489 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 489 "gnome-nibbles.vala"
	_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
#line 489 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 489 "gnome-nibbles.vala"
	if (_tmp4_ == 0) {
#line 490 "gnome-nibbles.vala"
		return;
#line 3078 "gnome-nibbles.c"
	}
#line 492 "gnome-nibbles.vala"
	_tmp5_ = self->priv->worm_settings;
#line 492 "gnome-nibbles.vala"
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp5_, changed_worm_settings);
#line 494 "gnome-nibbles.vala"
	_tmp6_ = id;
#line 494 "gnome-nibbles.vala"
	_tmp7_ = self->priv->game;
#line 494 "gnome-nibbles.vala"
	_tmp8_ = nibbles_game_get_numworms (_tmp7_);
#line 494 "gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 494 "gnome-nibbles.vala"
	if (_tmp6_ >= _tmp9_) {
#line 495 "gnome-nibbles.vala"
		return;
#line 3096 "gnome-nibbles.c"
	}
#line 497 "gnome-nibbles.vala"
	_tmp10_ = self->priv->game;
#line 497 "gnome-nibbles.vala"
	_tmp11_ = nibbles_game_get_worms (_tmp10_);
#line 497 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 497 "gnome-nibbles.vala"
	_tmp13_ = id;
#line 497 "gnome-nibbles.vala"
	_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 497 "gnome-nibbles.vala"
	worm = (Worm*) _tmp14_;
#line 498 "gnome-nibbles.vala"
	_tmp15_ = self->priv->game;
#line 498 "gnome-nibbles.vala"
	_tmp16_ = nibbles_game_get_worm_props (_tmp15_);
#line 498 "gnome-nibbles.vala"
	_tmp17_ = _tmp16_;
#line 498 "gnome-nibbles.vala"
	_tmp18_ = worm;
#line 498 "gnome-nibbles.vala"
	_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
#line 498 "gnome-nibbles.vala"
	properties = (WormProperties*) _tmp19_;
#line 500 "gnome-nibbles.vala"
	_tmp20_ = key;
#line 500 "gnome-nibbles.vala"
	_tmp22_ = (NULL == _tmp20_) ? 0 : g_quark_from_string (_tmp20_);
#line 500 "gnome-nibbles.vala"
	if (_tmp22_ == ((0 != _tmp21_label0) ? _tmp21_label0 : (_tmp21_label0 = g_quark_from_static_string ("color")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 3130 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp23_;
#line 503 "gnome-nibbles.vala"
				_tmp23_ = properties;
#line 503 "gnome-nibbles.vala"
				(*_tmp23_).color = g_settings_get_enum (changed_worm_settings, "color");
#line 504 "gnome-nibbles.vala"
				break;
#line 3140 "gnome-nibbles.c"
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label1) ? _tmp21_label1 : (_tmp21_label1 = g_quark_from_static_string ("key-up")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 3146 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp24_;
#line 506 "gnome-nibbles.vala"
				_tmp24_ = properties;
#line 506 "gnome-nibbles.vala"
				(*_tmp24_).up = (guint) g_settings_get_int (changed_worm_settings, "key-up");
#line 507 "gnome-nibbles.vala"
				break;
#line 3156 "gnome-nibbles.c"
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label2) ? _tmp21_label2 : (_tmp21_label2 = g_quark_from_static_string ("key-down")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 3162 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp25_;
#line 509 "gnome-nibbles.vala"
				_tmp25_ = properties;
#line 509 "gnome-nibbles.vala"
				(*_tmp25_).down = (guint) g_settings_get_int (changed_worm_settings, "key-down");
#line 510 "gnome-nibbles.vala"
				break;
#line 3172 "gnome-nibbles.c"
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label3) ? _tmp21_label3 : (_tmp21_label3 = g_quark_from_static_string ("key-left")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 3178 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp26_;
#line 512 "gnome-nibbles.vala"
				_tmp26_ = properties;
#line 512 "gnome-nibbles.vala"
				(*_tmp26_).left = (guint) g_settings_get_int (changed_worm_settings, "key-left");
#line 513 "gnome-nibbles.vala"
				break;
#line 3188 "gnome-nibbles.c"
			}
		}
	} else if (_tmp22_ == ((0 != _tmp21_label4) ? _tmp21_label4 : (_tmp21_label4 = g_quark_from_static_string ("key-right")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 3194 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp27_;
#line 515 "gnome-nibbles.vala"
				_tmp27_ = properties;
#line 515 "gnome-nibbles.vala"
				(*_tmp27_).right = (guint) g_settings_get_int (changed_worm_settings, "key-right");
#line 516 "gnome-nibbles.vala"
				break;
#line 3204 "gnome-nibbles.c"
			}
		}
	}
#line 519 "gnome-nibbles.vala"
	_tmp28_ = self->priv->game;
#line 519 "gnome-nibbles.vala"
	_tmp29_ = nibbles_game_get_worm_props (_tmp28_);
#line 519 "gnome-nibbles.vala"
	_tmp30_ = _tmp29_;
#line 519 "gnome-nibbles.vala"
	_tmp31_ = worm;
#line 519 "gnome-nibbles.vala"
	_tmp32_ = properties;
#line 519 "gnome-nibbles.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, _tmp32_);
#line 486 "gnome-nibbles.vala"
	_worm_properties_free0 (properties);
#line 486 "gnome-nibbles.vala"
	_g_object_unref0 (worm);
#line 3224 "gnome-nibbles.c"
}


static void
nibbles_show_first_run_screen (Nibbles* self)
{
	GtkStack* _tmp0_;
#line 526 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 528 "gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 528 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "first_run");
#line 3238 "gnome-nibbles.c"
}


static void
nibbles_show_new_game_screen_cb (Nibbles* self)
{
	guint _tmp0_;
	NibblesGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkHeaderBar* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GeeLinkedList* _tmp12_;
	NibblesGame* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	GtkToggleButton* _tmp17_;
	GeeLinkedList* _tmp18_;
	NibblesGame* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gpointer _tmp22_;
	GtkToggleButton* _tmp23_;
	GtkApplicationWindow* _tmp24_;
	GtkButton* _tmp25_;
	GtkStack* _tmp26_;
	GtkStack* _tmp27_;
	GtkStack* _tmp28_;
#line 531 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 533 "gnome-nibbles.vala"
	_tmp0_ = self->priv->countdown_id;
#line 533 "gnome-nibbles.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 3278 "gnome-nibbles.c"
		guint _tmp1_;
#line 535 "gnome-nibbles.vala"
		_tmp1_ = self->priv->countdown_id;
#line 535 "gnome-nibbles.vala"
		g_source_remove (_tmp1_);
#line 536 "gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 3286 "gnome-nibbles.c"
	}
#line 539 "gnome-nibbles.vala"
	_tmp2_ = self->priv->game;
#line 539 "gnome-nibbles.vala"
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
#line 539 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 539 "gnome-nibbles.vala"
	if (_tmp4_) {
#line 3296 "gnome-nibbles.c"
		NibblesGame* _tmp5_;
#line 540 "gnome-nibbles.vala"
		_tmp5_ = self->priv->game;
#line 540 "gnome-nibbles.vala"
		nibbles_game_stop (_tmp5_);
#line 3302 "gnome-nibbles.c"
	}
#line 542 "gnome-nibbles.vala"
	_tmp6_ = self->priv->headerbar;
#line 542 "gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp6_, _ ("Nibbles"));
#line 544 "gnome-nibbles.vala"
	_tmp7_ = self->priv->new_game_action;
#line 544 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp7_, FALSE);
#line 545 "gnome-nibbles.vala"
	_tmp8_ = self->priv->pause_action;
#line 545 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp8_, FALSE);
#line 546 "gnome-nibbles.vala"
	_tmp9_ = self->priv->back_action;
#line 546 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp9_, TRUE);
#line 548 "gnome-nibbles.vala"
	_tmp10_ = self->priv->new_game_button;
#line 548 "gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp10_);
#line 549 "gnome-nibbles.vala"
	_tmp11_ = self->priv->pause_button;
#line 549 "gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp11_);
#line 551 "gnome-nibbles.vala"
	_tmp12_ = self->priv->number_of_players_buttons;
#line 551 "gnome-nibbles.vala"
	_tmp13_ = self->priv->game;
#line 551 "gnome-nibbles.vala"
	_tmp14_ = nibbles_game_get_numhumans (_tmp13_);
#line 551 "gnome-nibbles.vala"
	_tmp15_ = _tmp14_;
#line 551 "gnome-nibbles.vala"
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp15_ - 1);
#line 551 "gnome-nibbles.vala"
	_tmp17_ = (GtkToggleButton*) _tmp16_;
#line 551 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp17_, TRUE);
#line 551 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp17_);
#line 552 "gnome-nibbles.vala"
	_tmp18_ = self->priv->number_of_ai_buttons;
#line 552 "gnome-nibbles.vala"
	_tmp19_ = self->priv->game;
#line 552 "gnome-nibbles.vala"
	_tmp20_ = nibbles_game_get_numai (_tmp19_);
#line 552 "gnome-nibbles.vala"
	_tmp21_ = _tmp20_;
#line 552 "gnome-nibbles.vala"
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp21_);
#line 552 "gnome-nibbles.vala"
	_tmp23_ = (GtkToggleButton*) _tmp22_;
#line 552 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp23_, TRUE);
#line 552 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp23_);
#line 554 "gnome-nibbles.vala"
	_tmp24_ = self->priv->window;
#line 554 "gnome-nibbles.vala"
	_tmp25_ = self->priv->next_button;
#line 554 "gnome-nibbles.vala"
	gtk_window_set_default ((GtkWindow*) _tmp24_, (GtkWidget*) _tmp25_);
#line 556 "gnome-nibbles.vala"
	_tmp26_ = self->priv->main_stack;
#line 556 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp26_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 557 "gnome-nibbles.vala"
	_tmp27_ = self->priv->main_stack;
#line 557 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp27_, "number_of_players");
#line 558 "gnome-nibbles.vala"
	_tmp28_ = self->priv->main_stack;
#line 558 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp28_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 3378 "gnome-nibbles.c"
}


static void
nibbles_show_controls_screen_cb (Nibbles* self)
{
	NibblesGame* _tmp40_;
	NibblesGame* _tmp41_;
	GeeArrayList* _tmp42_;
	GtkBox* _tmp43_;
	GList* _tmp44_;
	GtkApplicationWindow* _tmp77_;
	GtkButton* _tmp78_;
	GtkStack* _tmp79_;
#line 561 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 3395 "gnome-nibbles.c"
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _button_index = 0;
#line 564 "gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_players_buttons;
#line 564 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 564 "gnome-nibbles.vala"
		_button_list = _tmp1_;
#line 564 "gnome-nibbles.vala"
		_tmp2_ = _button_list;
#line 564 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 564 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 564 "gnome-nibbles.vala"
		_button_size = _tmp4_;
#line 564 "gnome-nibbles.vala"
		_button_index = -1;
#line 564 "gnome-nibbles.vala"
		while (TRUE) {
#line 3423 "gnome-nibbles.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkToggleButton* _tmp11_;
#line 564 "gnome-nibbles.vala"
			_tmp5_ = _button_index;
#line 564 "gnome-nibbles.vala"
			_button_index = _tmp5_ + 1;
#line 564 "gnome-nibbles.vala"
			_tmp6_ = _button_index;
#line 564 "gnome-nibbles.vala"
			_tmp7_ = _button_size;
#line 564 "gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 564 "gnome-nibbles.vala"
				break;
#line 3444 "gnome-nibbles.c"
			}
#line 564 "gnome-nibbles.vala"
			_tmp8_ = _button_list;
#line 564 "gnome-nibbles.vala"
			_tmp9_ = _button_index;
#line 564 "gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 564 "gnome-nibbles.vala"
			button = (GtkToggleButton*) _tmp10_;
#line 566 "gnome-nibbles.vala"
			_tmp11_ = button;
#line 566 "gnome-nibbles.vala"
			if (gtk_toggle_button_get_active (_tmp11_)) {
#line 3458 "gnome-nibbles.c"
				gint numhumans = 0;
				GtkToggleButton* _tmp12_;
				const gchar* _tmp13_;
				NibblesGame* _tmp14_;
				gint _tmp15_;
				GSettings* _tmp16_;
				NibblesGame* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
#line 568 "gnome-nibbles.vala"
				numhumans = -1;
#line 569 "gnome-nibbles.vala"
				_tmp12_ = button;
#line 569 "gnome-nibbles.vala"
				_tmp13_ = gtk_button_get_label ((GtkButton*) _tmp12_);
#line 569 "gnome-nibbles.vala"
				sscanf (_tmp13_, "_%d", &numhumans);
#line 570 "gnome-nibbles.vala"
				_tmp14_ = self->priv->game;
#line 570 "gnome-nibbles.vala"
				_tmp15_ = numhumans;
#line 570 "gnome-nibbles.vala"
				nibbles_game_set_numhumans (_tmp14_, _tmp15_);
#line 573 "gnome-nibbles.vala"
				_tmp16_ = self->priv->settings;
#line 573 "gnome-nibbles.vala"
				_tmp17_ = self->priv->game;
#line 573 "gnome-nibbles.vala"
				_tmp18_ = nibbles_game_get_numhumans (_tmp17_);
#line 573 "gnome-nibbles.vala"
				_tmp19_ = _tmp18_;
#line 573 "gnome-nibbles.vala"
				g_settings_set_int (_tmp16_, "players", _tmp19_);
#line 574 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 574 "gnome-nibbles.vala"
				break;
#line 3496 "gnome-nibbles.c"
			}
#line 564 "gnome-nibbles.vala"
			_g_object_unref0 (button);
#line 3500 "gnome-nibbles.c"
		}
#line 564 "gnome-nibbles.vala"
		_g_object_unref0 (_button_list);
#line 3504 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp20_;
		GeeLinkedList* _tmp21_;
		gint _button_size = 0;
		GeeLinkedList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _button_index = 0;
#line 579 "gnome-nibbles.vala"
		_tmp20_ = self->priv->number_of_ai_buttons;
#line 579 "gnome-nibbles.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 579 "gnome-nibbles.vala"
		_button_list = _tmp21_;
#line 579 "gnome-nibbles.vala"
		_tmp22_ = _button_list;
#line 579 "gnome-nibbles.vala"
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
#line 579 "gnome-nibbles.vala"
		_tmp24_ = _tmp23_;
#line 579 "gnome-nibbles.vala"
		_button_size = _tmp24_;
#line 579 "gnome-nibbles.vala"
		_button_index = -1;
#line 579 "gnome-nibbles.vala"
		while (TRUE) {
#line 3533 "gnome-nibbles.c"
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			GtkToggleButton* _tmp31_;
#line 579 "gnome-nibbles.vala"
			_tmp25_ = _button_index;
#line 579 "gnome-nibbles.vala"
			_button_index = _tmp25_ + 1;
#line 579 "gnome-nibbles.vala"
			_tmp26_ = _button_index;
#line 579 "gnome-nibbles.vala"
			_tmp27_ = _button_size;
#line 579 "gnome-nibbles.vala"
			if (!(_tmp26_ < _tmp27_)) {
#line 579 "gnome-nibbles.vala"
				break;
#line 3554 "gnome-nibbles.c"
			}
#line 579 "gnome-nibbles.vala"
			_tmp28_ = _button_list;
#line 579 "gnome-nibbles.vala"
			_tmp29_ = _button_index;
#line 579 "gnome-nibbles.vala"
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
#line 579 "gnome-nibbles.vala"
			button = (GtkToggleButton*) _tmp30_;
#line 581 "gnome-nibbles.vala"
			_tmp31_ = button;
#line 581 "gnome-nibbles.vala"
			if (gtk_toggle_button_get_active (_tmp31_)) {
#line 3568 "gnome-nibbles.c"
				gint numai = 0;
				GtkToggleButton* _tmp32_;
				const gchar* _tmp33_;
				NibblesGame* _tmp34_;
				gint _tmp35_;
				GSettings* _tmp36_;
				NibblesGame* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
#line 583 "gnome-nibbles.vala"
				numai = -1;
#line 584 "gnome-nibbles.vala"
				_tmp32_ = button;
#line 584 "gnome-nibbles.vala"
				_tmp33_ = gtk_button_get_label ((GtkButton*) _tmp32_);
#line 584 "gnome-nibbles.vala"
				sscanf (_tmp33_, "_%d", &numai);
#line 585 "gnome-nibbles.vala"
				_tmp34_ = self->priv->game;
#line 585 "gnome-nibbles.vala"
				_tmp35_ = numai;
#line 585 "gnome-nibbles.vala"
				nibbles_game_set_numai (_tmp34_, _tmp35_);
#line 588 "gnome-nibbles.vala"
				_tmp36_ = self->priv->settings;
#line 588 "gnome-nibbles.vala"
				_tmp37_ = self->priv->game;
#line 588 "gnome-nibbles.vala"
				_tmp38_ = nibbles_game_get_numai (_tmp37_);
#line 588 "gnome-nibbles.vala"
				_tmp39_ = _tmp38_;
#line 588 "gnome-nibbles.vala"
				g_settings_set_int (_tmp36_, "ai", _tmp39_);
#line 589 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 589 "gnome-nibbles.vala"
				break;
#line 3606 "gnome-nibbles.c"
			}
#line 579 "gnome-nibbles.vala"
			_g_object_unref0 (button);
#line 3610 "gnome-nibbles.c"
		}
#line 579 "gnome-nibbles.vala"
		_g_object_unref0 (_button_list);
#line 3614 "gnome-nibbles.c"
	}
#line 594 "gnome-nibbles.vala"
	_tmp40_ = self->priv->game;
#line 594 "gnome-nibbles.vala"
	nibbles_game_create_worms (_tmp40_);
#line 595 "gnome-nibbles.vala"
	_tmp41_ = self->priv->game;
#line 595 "gnome-nibbles.vala"
	_tmp42_ = self->priv->worm_settings;
#line 595 "gnome-nibbles.vala"
	nibbles_game_load_worm_properties (_tmp41_, _tmp42_);
#line 597 "gnome-nibbles.vala"
	_tmp43_ = self->priv->grids_box;
#line 597 "gnome-nibbles.vala"
	_tmp44_ = gtk_container_get_children ((GtkContainer*) _tmp43_);
#line 3630 "gnome-nibbles.c"
	{
		GList* grid_collection = NULL;
		GList* grid_it = NULL;
#line 597 "gnome-nibbles.vala"
		grid_collection = _tmp44_;
#line 597 "gnome-nibbles.vala"
		for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
#line 3638 "gnome-nibbles.c"
			GtkWidget* grid = NULL;
#line 597 "gnome-nibbles.vala"
			grid = (GtkWidget*) grid_it->data;
#line 3642 "gnome-nibbles.c"
			{
				GtkWidget* _tmp45_;
#line 598 "gnome-nibbles.vala"
				_tmp45_ = grid;
#line 598 "gnome-nibbles.vala"
				gtk_widget_destroy (_tmp45_);
#line 3649 "gnome-nibbles.c"
			}
		}
#line 597 "gnome-nibbles.vala"
		(grid_collection == NULL) ? NULL : (grid_collection = (g_list_free (grid_collection), NULL));
#line 3654 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp46_;
		GeeLinkedList* _tmp47_;
		GeeLinkedList* _tmp48_;
		GeeLinkedList* _tmp49_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _worm_index = 0;
#line 600 "gnome-nibbles.vala"
		_tmp46_ = self->priv->game;
#line 600 "gnome-nibbles.vala"
		_tmp47_ = nibbles_game_get_worms (_tmp46_);
#line 600 "gnome-nibbles.vala"
		_tmp48_ = _tmp47_;
#line 600 "gnome-nibbles.vala"
		_tmp49_ = _g_object_ref0 (_tmp48_);
#line 600 "gnome-nibbles.vala"
		_worm_list = _tmp49_;
#line 600 "gnome-nibbles.vala"
		_tmp50_ = _worm_list;
#line 600 "gnome-nibbles.vala"
		_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
#line 600 "gnome-nibbles.vala"
		_tmp52_ = _tmp51_;
#line 600 "gnome-nibbles.vala"
		_worm_size = _tmp52_;
#line 600 "gnome-nibbles.vala"
		_worm_index = -1;
#line 600 "gnome-nibbles.vala"
		while (TRUE) {
#line 3689 "gnome-nibbles.c"
			gint _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp56_;
			gint _tmp57_;
			gpointer _tmp58_;
			Worm* _tmp59_;
			gboolean _tmp60_;
#line 600 "gnome-nibbles.vala"
			_tmp53_ = _worm_index;
#line 600 "gnome-nibbles.vala"
			_worm_index = _tmp53_ + 1;
#line 600 "gnome-nibbles.vala"
			_tmp54_ = _worm_index;
#line 600 "gnome-nibbles.vala"
			_tmp55_ = _worm_size;
#line 600 "gnome-nibbles.vala"
			if (!(_tmp54_ < _tmp55_)) {
#line 600 "gnome-nibbles.vala"
				break;
#line 3711 "gnome-nibbles.c"
			}
#line 600 "gnome-nibbles.vala"
			_tmp56_ = _worm_list;
#line 600 "gnome-nibbles.vala"
			_tmp57_ = _worm_index;
#line 600 "gnome-nibbles.vala"
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _tmp57_);
#line 600 "gnome-nibbles.vala"
			worm = (Worm*) _tmp58_;
#line 602 "gnome-nibbles.vala"
			_tmp59_ = worm;
#line 602 "gnome-nibbles.vala"
			_tmp60_ = _tmp59_->is_human;
#line 602 "gnome-nibbles.vala"
			if (_tmp60_) {
#line 3727 "gnome-nibbles.c"
				ControlsGrid* grid = NULL;
				Worm* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				NibblesGame* _tmp64_;
				GeeHashMap* _tmp65_;
				GeeHashMap* _tmp66_;
				Worm* _tmp67_;
				gpointer _tmp68_;
				WormProperties* _tmp69_;
				GdkPixbuf* _tmp70_;
				GdkPixbuf* _tmp71_;
				WormProperties _tmp72_;
				ControlsGrid* _tmp73_;
				ControlsGrid* _tmp74_;
				GtkBox* _tmp75_;
				ControlsGrid* _tmp76_;
#line 604 "gnome-nibbles.vala"
				_tmp61_ = worm;
#line 604 "gnome-nibbles.vala"
				_tmp62_ = worm_get_id (_tmp61_);
#line 604 "gnome-nibbles.vala"
				_tmp63_ = _tmp62_;
#line 604 "gnome-nibbles.vala"
				_tmp64_ = self->priv->game;
#line 604 "gnome-nibbles.vala"
				_tmp65_ = nibbles_game_get_worm_props (_tmp64_);
#line 604 "gnome-nibbles.vala"
				_tmp66_ = _tmp65_;
#line 604 "gnome-nibbles.vala"
				_tmp67_ = worm;
#line 604 "gnome-nibbles.vala"
				_tmp68_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp66_, _tmp67_);
#line 604 "gnome-nibbles.vala"
				_tmp69_ = (WormProperties*) _tmp68_;
#line 604 "gnome-nibbles.vala"
				_tmp70_ = self->priv->arrow_pixbuf;
#line 604 "gnome-nibbles.vala"
				_tmp71_ = self->priv->arrow_key_pixbuf;
#line 604 "gnome-nibbles.vala"
				_tmp72_ = *_tmp69_;
#line 604 "gnome-nibbles.vala"
				_tmp73_ = controls_grid_new (_tmp63_, &_tmp72_, _tmp70_, _tmp71_);
#line 604 "gnome-nibbles.vala"
				g_object_ref_sink (_tmp73_);
#line 604 "gnome-nibbles.vala"
				_tmp74_ = _tmp73_;
#line 604 "gnome-nibbles.vala"
				_worm_properties_free0 (_tmp69_);
#line 604 "gnome-nibbles.vala"
				grid = _tmp74_;
#line 605 "gnome-nibbles.vala"
				_tmp75_ = self->priv->grids_box;
#line 605 "gnome-nibbles.vala"
				_tmp76_ = grid;
#line 605 "gnome-nibbles.vala"
				gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
#line 602 "gnome-nibbles.vala"
				_g_object_unref0 (grid);
#line 3787 "gnome-nibbles.c"
			}
#line 600 "gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 3791 "gnome-nibbles.c"
		}
#line 600 "gnome-nibbles.vala"
		_g_object_unref0 (_worm_list);
#line 3795 "gnome-nibbles.c"
	}
#line 609 "gnome-nibbles.vala"
	_tmp77_ = self->priv->window;
#line 609 "gnome-nibbles.vala"
	_tmp78_ = self->priv->start_button;
#line 609 "gnome-nibbles.vala"
	gtk_window_set_default ((GtkWindow*) _tmp77_, (GtkWidget*) _tmp78_);
#line 611 "gnome-nibbles.vala"
	_tmp79_ = self->priv->main_stack;
#line 611 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp79_, "controls");
#line 3807 "gnome-nibbles.c"
}


static void
nibbles_show_game_view (Nibbles* self)
{
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GSimpleAction* _tmp3_;
	GtkHeaderBar* _tmp4_;
	NibblesGame* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
#line 614 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 620 "gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 620 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 621 "gnome-nibbles.vala"
	_tmp1_ = self->priv->new_game_button;
#line 621 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 622 "gnome-nibbles.vala"
	_tmp2_ = self->priv->pause_button;
#line 622 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 624 "gnome-nibbles.vala"
	_tmp3_ = self->priv->back_action;
#line 624 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 626 "gnome-nibbles.vala"
	_tmp4_ = self->priv->headerbar;
#line 626 "gnome-nibbles.vala"
	_tmp5_ = self->priv->game;
#line 626 "gnome-nibbles.vala"
	_tmp6_ = nibbles_game_get_current_level (_tmp5_);
#line 626 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 626 "gnome-nibbles.vala"
	_tmp8_ = g_strdup_printf (_ ("Level %d"), _tmp7_);
#line 626 "gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 626 "gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp4_, _tmp9_);
#line 626 "gnome-nibbles.vala"
	_g_free0 (_tmp9_);
#line 627 "gnome-nibbles.vala"
	_tmp10_ = self->priv->main_stack;
#line 627 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp10_, "game_box");
#line 629 "gnome-nibbles.vala"
	_tmp11_ = self->priv->main_stack;
#line 629 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp11_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 3868 "gnome-nibbles.c"
}


static void
nibbles_back_cb (Nibbles* self)
{
	GtkStack* _tmp0_;
	gchar* child_name = NULL;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label0 = 0;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label1 = 0;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label2 = 0;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label3 = 0;
#line 3891 "gnome-nibbles.c"
	GtkStack* _tmp9_;
#line 632 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 634 "gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 634 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
#line 636 "gnome-nibbles.vala"
	_tmp1_ = self->priv->main_stack;
#line 636 "gnome-nibbles.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 636 "gnome-nibbles.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 636 "gnome-nibbles.vala"
	child_name = _tmp3_;
#line 637 "gnome-nibbles.vala"
	_tmp4_ = child_name;
#line 637 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 637 "gnome-nibbles.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 637 "gnome-nibbles.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first_run")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3917 "gnome-nibbles.c"
			default:
			{
#line 640 "gnome-nibbles.vala"
				break;
#line 3922 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3928 "gnome-nibbles.c"
			default:
			{
#line 642 "gnome-nibbles.vala"
				break;
#line 3933 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("controls")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3939 "gnome-nibbles.c"
			default:
			{
				GtkStack* _tmp8_;
#line 644 "gnome-nibbles.vala"
				_tmp8_ = self->priv->main_stack;
#line 644 "gnome-nibbles.vala"
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
#line 645 "gnome-nibbles.vala"
				break;
#line 3949 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("game_box")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3955 "gnome-nibbles.c"
			default:
			{
#line 647 "gnome-nibbles.vala"
				nibbles_new_game_cb (self);
#line 648 "gnome-nibbles.vala"
				break;
#line 3962 "gnome-nibbles.c"
			}
		}
	}
#line 651 "gnome-nibbles.vala"
	_tmp9_ = self->priv->main_stack;
#line 651 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 632 "gnome-nibbles.vala"
	_g_free0 (child_name);
#line 3972 "gnome-nibbles.c"
}


static void
nibbles_change_number_of_players_cb (Nibbles* self,
                                     GtkToggleButton* button)
{
	gint numhumans = 0;
	const gchar* _tmp16_;
	gint min_ai = 0;
	gint _tmp17_;
	gint max_ai = 0;
	gint _tmp18_;
	gint _tmp47_;
	GeeLinkedList* _tmp51_;
	gint _tmp52_;
	gpointer _tmp53_;
	GtkToggleButton* _tmp54_;
#line 654 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 654 "gnome-nibbles.vala"
	g_return_if_fail (button != NULL);
#line 3995 "gnome-nibbles.c"
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_button_index = 0;
#line 656 "gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_players_buttons;
#line 656 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 656 "gnome-nibbles.vala"
		_other_button_list = _tmp1_;
#line 656 "gnome-nibbles.vala"
		_tmp2_ = _other_button_list;
#line 656 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 656 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 656 "gnome-nibbles.vala"
		_other_button_size = _tmp4_;
#line 656 "gnome-nibbles.vala"
		_other_button_index = -1;
#line 656 "gnome-nibbles.vala"
		while (TRUE) {
#line 4023 "gnome-nibbles.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkToggleButton* _tmp11_;
#line 656 "gnome-nibbles.vala"
			_tmp5_ = _other_button_index;
#line 656 "gnome-nibbles.vala"
			_other_button_index = _tmp5_ + 1;
#line 656 "gnome-nibbles.vala"
			_tmp6_ = _other_button_index;
#line 656 "gnome-nibbles.vala"
			_tmp7_ = _other_button_size;
#line 656 "gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 656 "gnome-nibbles.vala"
				break;
#line 4044 "gnome-nibbles.c"
			}
#line 656 "gnome-nibbles.vala"
			_tmp8_ = _other_button_list;
#line 656 "gnome-nibbles.vala"
			_tmp9_ = _other_button_index;
#line 656 "gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 656 "gnome-nibbles.vala"
			other_button = (GtkToggleButton*) _tmp10_;
#line 658 "gnome-nibbles.vala"
			_tmp11_ = other_button;
#line 658 "gnome-nibbles.vala"
			if (button != _tmp11_) {
#line 4058 "gnome-nibbles.c"
				GtkToggleButton* _tmp12_;
#line 660 "gnome-nibbles.vala"
				_tmp12_ = other_button;
#line 660 "gnome-nibbles.vala"
				if (gtk_toggle_button_get_active (_tmp12_)) {
#line 4064 "gnome-nibbles.c"
					GtkToggleButton* _tmp13_;
					GtkToggleButton* _tmp14_;
					GtkToggleButton* _tmp15_;
#line 665 "gnome-nibbles.vala"
					_tmp13_ = other_button;
#line 665 "gnome-nibbles.vala"
					g_signal_handlers_block_matched (_tmp13_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 666 "gnome-nibbles.vala"
					_tmp14_ = other_button;
#line 666 "gnome-nibbles.vala"
					gtk_toggle_button_set_active (_tmp14_, FALSE);
#line 667 "gnome-nibbles.vala"
					_tmp15_ = other_button;
#line 667 "gnome-nibbles.vala"
					g_signal_handlers_unblock_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 668 "gnome-nibbles.vala"
					_g_object_unref0 (other_button);
#line 668 "gnome-nibbles.vala"
					break;
#line 4084 "gnome-nibbles.c"
				}
			}
#line 656 "gnome-nibbles.vala"
			_g_object_unref0 (other_button);
#line 4089 "gnome-nibbles.c"
		}
#line 656 "gnome-nibbles.vala"
		_g_object_unref0 (_other_button_list);
#line 4093 "gnome-nibbles.c"
	}
#line 672 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (button, TRUE);
#line 674 "gnome-nibbles.vala"
	numhumans = -1;
#line 675 "gnome-nibbles.vala"
	_tmp16_ = gtk_button_get_label ((GtkButton*) button);
#line 675 "gnome-nibbles.vala"
	sscanf (_tmp16_, "_%d", &numhumans);
#line 677 "gnome-nibbles.vala"
	_tmp17_ = numhumans;
#line 677 "gnome-nibbles.vala"
	min_ai = 4 - _tmp17_;
#line 678 "gnome-nibbles.vala"
	_tmp18_ = numhumans;
#line 678 "gnome-nibbles.vala"
	max_ai = NIBBLES_GAME_MAX_WORMS - _tmp18_;
#line 4111 "gnome-nibbles.c"
	{
		gint i = 0;
#line 679 "gnome-nibbles.vala"
		i = 0;
#line 4116 "gnome-nibbles.c"
		{
			gboolean _tmp19_ = FALSE;
#line 679 "gnome-nibbles.vala"
			_tmp19_ = TRUE;
#line 679 "gnome-nibbles.vala"
			while (TRUE) {
#line 4123 "gnome-nibbles.c"
				gint _tmp21_;
				gint _tmp22_;
				GeeLinkedList* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_;
				GtkToggleButton* _tmp26_;
#line 679 "gnome-nibbles.vala"
				if (!_tmp19_) {
#line 4132 "gnome-nibbles.c"
					gint _tmp20_;
#line 679 "gnome-nibbles.vala"
					_tmp20_ = i;
#line 679 "gnome-nibbles.vala"
					i = _tmp20_ + 1;
#line 4138 "gnome-nibbles.c"
				}
#line 679 "gnome-nibbles.vala"
				_tmp19_ = FALSE;
#line 679 "gnome-nibbles.vala"
				_tmp21_ = i;
#line 679 "gnome-nibbles.vala"
				_tmp22_ = min_ai;
#line 679 "gnome-nibbles.vala"
				if (!(_tmp21_ < _tmp22_)) {
#line 679 "gnome-nibbles.vala"
					break;
#line 4150 "gnome-nibbles.c"
				}
#line 681 "gnome-nibbles.vala"
				_tmp23_ = self->priv->number_of_ai_buttons;
#line 681 "gnome-nibbles.vala"
				_tmp24_ = i;
#line 681 "gnome-nibbles.vala"
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
#line 681 "gnome-nibbles.vala"
				_tmp26_ = (GtkToggleButton*) _tmp25_;
#line 681 "gnome-nibbles.vala"
				gtk_widget_hide ((GtkWidget*) _tmp26_);
#line 681 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp26_);
#line 4164 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
		gint _tmp27_;
#line 683 "gnome-nibbles.vala"
		_tmp27_ = min_ai;
#line 683 "gnome-nibbles.vala"
		i = _tmp27_;
#line 4175 "gnome-nibbles.c"
		{
			gboolean _tmp28_ = FALSE;
#line 683 "gnome-nibbles.vala"
			_tmp28_ = TRUE;
#line 683 "gnome-nibbles.vala"
			while (TRUE) {
#line 4182 "gnome-nibbles.c"
				gint _tmp30_;
				gint _tmp31_;
				GeeLinkedList* _tmp32_;
				gint _tmp33_;
				gpointer _tmp34_;
				GtkToggleButton* _tmp35_;
#line 683 "gnome-nibbles.vala"
				if (!_tmp28_) {
#line 4191 "gnome-nibbles.c"
					gint _tmp29_;
#line 683 "gnome-nibbles.vala"
					_tmp29_ = i;
#line 683 "gnome-nibbles.vala"
					i = _tmp29_ + 1;
#line 4197 "gnome-nibbles.c"
				}
#line 683 "gnome-nibbles.vala"
				_tmp28_ = FALSE;
#line 683 "gnome-nibbles.vala"
				_tmp30_ = i;
#line 683 "gnome-nibbles.vala"
				_tmp31_ = max_ai;
#line 683 "gnome-nibbles.vala"
				if (!(_tmp30_ <= _tmp31_)) {
#line 683 "gnome-nibbles.vala"
					break;
#line 4209 "gnome-nibbles.c"
				}
#line 685 "gnome-nibbles.vala"
				_tmp32_ = self->priv->number_of_ai_buttons;
#line 685 "gnome-nibbles.vala"
				_tmp33_ = i;
#line 685 "gnome-nibbles.vala"
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
#line 685 "gnome-nibbles.vala"
				_tmp35_ = (GtkToggleButton*) _tmp34_;
#line 685 "gnome-nibbles.vala"
				gtk_widget_show ((GtkWidget*) _tmp35_);
#line 685 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp35_);
#line 4223 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
		gint _tmp36_;
#line 687 "gnome-nibbles.vala"
		_tmp36_ = max_ai;
#line 687 "gnome-nibbles.vala"
		i = _tmp36_ + 1;
#line 4234 "gnome-nibbles.c"
		{
			gboolean _tmp37_ = FALSE;
#line 687 "gnome-nibbles.vala"
			_tmp37_ = TRUE;
#line 687 "gnome-nibbles.vala"
			while (TRUE) {
#line 4241 "gnome-nibbles.c"
				gint _tmp39_;
				GeeLinkedList* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				GeeLinkedList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				GtkToggleButton* _tmp46_;
#line 687 "gnome-nibbles.vala"
				if (!_tmp37_) {
#line 4252 "gnome-nibbles.c"
					gint _tmp38_;
#line 687 "gnome-nibbles.vala"
					_tmp38_ = i;
#line 687 "gnome-nibbles.vala"
					i = _tmp38_ + 1;
#line 4258 "gnome-nibbles.c"
				}
#line 687 "gnome-nibbles.vala"
				_tmp37_ = FALSE;
#line 687 "gnome-nibbles.vala"
				_tmp39_ = i;
#line 687 "gnome-nibbles.vala"
				_tmp40_ = self->priv->number_of_ai_buttons;
#line 687 "gnome-nibbles.vala"
				_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
#line 687 "gnome-nibbles.vala"
				_tmp42_ = _tmp41_;
#line 687 "gnome-nibbles.vala"
				if (!(_tmp39_ < _tmp42_)) {
#line 687 "gnome-nibbles.vala"
					break;
#line 4274 "gnome-nibbles.c"
				}
#line 689 "gnome-nibbles.vala"
				_tmp43_ = self->priv->number_of_ai_buttons;
#line 689 "gnome-nibbles.vala"
				_tmp44_ = i;
#line 689 "gnome-nibbles.vala"
				_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _tmp44_);
#line 689 "gnome-nibbles.vala"
				_tmp46_ = (GtkToggleButton*) _tmp45_;
#line 689 "gnome-nibbles.vala"
				gtk_widget_hide ((GtkWidget*) _tmp46_);
#line 689 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp46_);
#line 4288 "gnome-nibbles.c"
			}
		}
	}
#line 692 "gnome-nibbles.vala"
	_tmp47_ = numhumans;
#line 692 "gnome-nibbles.vala"
	if (_tmp47_ == 4) {
#line 4296 "gnome-nibbles.c"
		GeeLinkedList* _tmp48_;
		gpointer _tmp49_;
		GtkToggleButton* _tmp50_;
#line 694 "gnome-nibbles.vala"
		_tmp48_ = self->priv->number_of_ai_buttons;
#line 694 "gnome-nibbles.vala"
		_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp48_, 0);
#line 694 "gnome-nibbles.vala"
		_tmp50_ = (GtkToggleButton*) _tmp49_;
#line 694 "gnome-nibbles.vala"
		gtk_widget_show ((GtkWidget*) _tmp50_);
#line 694 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp50_);
#line 4310 "gnome-nibbles.c"
	}
#line 697 "gnome-nibbles.vala"
	_tmp51_ = self->priv->number_of_ai_buttons;
#line 697 "gnome-nibbles.vala"
	_tmp52_ = min_ai;
#line 697 "gnome-nibbles.vala"
	_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _tmp52_);
#line 697 "gnome-nibbles.vala"
	_tmp54_ = (GtkToggleButton*) _tmp53_;
#line 697 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp54_, TRUE);
#line 697 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp54_);
#line 4324 "gnome-nibbles.c"
}


static void
nibbles_change_number_of_ai_cb (Nibbles* self,
                                GtkToggleButton* button)
{
#line 700 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 700 "gnome-nibbles.vala"
	g_return_if_fail (button != NULL);
#line 4336 "gnome-nibbles.c"
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_button_index = 0;
#line 702 "gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_ai_buttons;
#line 702 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 702 "gnome-nibbles.vala"
		_other_button_list = _tmp1_;
#line 702 "gnome-nibbles.vala"
		_tmp2_ = _other_button_list;
#line 702 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 702 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 702 "gnome-nibbles.vala"
		_other_button_size = _tmp4_;
#line 702 "gnome-nibbles.vala"
		_other_button_index = -1;
#line 702 "gnome-nibbles.vala"
		while (TRUE) {
#line 4364 "gnome-nibbles.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GtkToggleButton* _tmp11_;
#line 702 "gnome-nibbles.vala"
			_tmp5_ = _other_button_index;
#line 702 "gnome-nibbles.vala"
			_other_button_index = _tmp5_ + 1;
#line 702 "gnome-nibbles.vala"
			_tmp6_ = _other_button_index;
#line 702 "gnome-nibbles.vala"
			_tmp7_ = _other_button_size;
#line 702 "gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 702 "gnome-nibbles.vala"
				break;
#line 4385 "gnome-nibbles.c"
			}
#line 702 "gnome-nibbles.vala"
			_tmp8_ = _other_button_list;
#line 702 "gnome-nibbles.vala"
			_tmp9_ = _other_button_index;
#line 702 "gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 702 "gnome-nibbles.vala"
			other_button = (GtkToggleButton*) _tmp10_;
#line 704 "gnome-nibbles.vala"
			_tmp11_ = other_button;
#line 704 "gnome-nibbles.vala"
			if (button != _tmp11_) {
#line 4399 "gnome-nibbles.c"
				GtkToggleButton* _tmp12_;
#line 706 "gnome-nibbles.vala"
				_tmp12_ = other_button;
#line 706 "gnome-nibbles.vala"
				if (gtk_toggle_button_get_active (_tmp12_)) {
#line 4405 "gnome-nibbles.c"
					GtkToggleButton* _tmp13_;
					GtkToggleButton* _tmp14_;
					GtkToggleButton* _tmp15_;
#line 711 "gnome-nibbles.vala"
					_tmp13_ = other_button;
#line 711 "gnome-nibbles.vala"
					g_signal_handlers_block_matched (_tmp13_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 712 "gnome-nibbles.vala"
					_tmp14_ = other_button;
#line 712 "gnome-nibbles.vala"
					gtk_toggle_button_set_active (_tmp14_, FALSE);
#line 713 "gnome-nibbles.vala"
					_tmp15_ = other_button;
#line 713 "gnome-nibbles.vala"
					g_signal_handlers_unblock_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 714 "gnome-nibbles.vala"
					_g_object_unref0 (other_button);
#line 714 "gnome-nibbles.vala"
					break;
#line 4425 "gnome-nibbles.c"
				}
			}
#line 702 "gnome-nibbles.vala"
			_g_object_unref0 (other_button);
#line 4430 "gnome-nibbles.c"
		}
#line 702 "gnome-nibbles.vala"
		_g_object_unref0 (_other_button_list);
#line 4434 "gnome-nibbles.c"
	}
#line 718 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (button, TRUE);
#line 4438 "gnome-nibbles.c"
}


static GamesScoresCategory*
nibbles_category_request (Nibbles* self,
                          const gchar* key)
{
	GamesScoresCategory* result = NULL;
#line 725 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 725 "gnome-nibbles.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 4451 "gnome-nibbles.c"
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _cat_index = 0;
#line 727 "gnome-nibbles.vala"
		_tmp0_ = self->priv->scorecats;
#line 727 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 727 "gnome-nibbles.vala"
		_cat_list = _tmp1_;
#line 727 "gnome-nibbles.vala"
		_tmp2_ = _cat_list;
#line 727 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 727 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 727 "gnome-nibbles.vala"
		_cat_size = _tmp4_;
#line 727 "gnome-nibbles.vala"
		_cat_index = -1;
#line 727 "gnome-nibbles.vala"
		while (TRUE) {
#line 4479 "gnome-nibbles.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GamesScoresCategory* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
#line 727 "gnome-nibbles.vala"
			_tmp5_ = _cat_index;
#line 727 "gnome-nibbles.vala"
			_cat_index = _tmp5_ + 1;
#line 727 "gnome-nibbles.vala"
			_tmp6_ = _cat_index;
#line 727 "gnome-nibbles.vala"
			_tmp7_ = _cat_size;
#line 727 "gnome-nibbles.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 727 "gnome-nibbles.vala"
				break;
#line 4502 "gnome-nibbles.c"
			}
#line 727 "gnome-nibbles.vala"
			_tmp8_ = _cat_list;
#line 727 "gnome-nibbles.vala"
			_tmp9_ = _cat_index;
#line 727 "gnome-nibbles.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 727 "gnome-nibbles.vala"
			cat = (GamesScoresCategory*) _tmp10_;
#line 729 "gnome-nibbles.vala"
			_tmp11_ = cat;
#line 729 "gnome-nibbles.vala"
			_tmp12_ = games_scores_category_get_key (_tmp11_);
#line 729 "gnome-nibbles.vala"
			_tmp13_ = _tmp12_;
#line 729 "gnome-nibbles.vala"
			if (g_strcmp0 (key, _tmp13_) == 0) {
#line 730 "gnome-nibbles.vala"
				result = cat;
#line 730 "gnome-nibbles.vala"
				_g_object_unref0 (_cat_list);
#line 730 "gnome-nibbles.vala"
				return result;
#line 4526 "gnome-nibbles.c"
			}
#line 727 "gnome-nibbles.vala"
			_g_object_unref0 (cat);
#line 4530 "gnome-nibbles.c"
		}
#line 727 "gnome-nibbles.vala"
		_g_object_unref0 (_cat_list);
#line 4534 "gnome-nibbles.c"
	}
#line 732 "gnome-nibbles.vala"
	result = NULL;
#line 732 "gnome-nibbles.vala"
	return result;
#line 4540 "gnome-nibbles.c"
}


static gchar*
nibbles_get_new_scores_key (Nibbles* self,
                            const gchar* old_key)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label0 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label1 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label2 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label3 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label4 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label5 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label6 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label7 = 0;
#line 735 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 735 "gnome-nibbles.vala"
	g_return_val_if_fail (old_key != NULL, NULL);
#line 737 "gnome-nibbles.vala"
	_tmp0_ = old_key;
#line 737 "gnome-nibbles.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 737 "gnome-nibbles.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("1.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4579 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp3_;
#line 740 "gnome-nibbles.vala"
				_tmp3_ = g_strdup ("fast");
#line 740 "gnome-nibbles.vala"
				result = _tmp3_;
#line 740 "gnome-nibbles.vala"
				return result;
#line 4589 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("2.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4595 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp4_;
#line 742 "gnome-nibbles.vala"
				_tmp4_ = g_strdup ("medium");
#line 742 "gnome-nibbles.vala"
				result = _tmp4_;
#line 742 "gnome-nibbles.vala"
				return result;
#line 4605 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("3.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4611 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp5_;
#line 744 "gnome-nibbles.vala"
				_tmp5_ = g_strdup ("slow");
#line 744 "gnome-nibbles.vala"
				result = _tmp5_;
#line 744 "gnome-nibbles.vala"
				return result;
#line 4621 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("4.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4627 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp6_;
#line 746 "gnome-nibbles.vala"
				_tmp6_ = g_strdup ("beginner");
#line 746 "gnome-nibbles.vala"
				result = _tmp6_;
#line 746 "gnome-nibbles.vala"
				return result;
#line 4637 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("1.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4643 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp7_;
#line 748 "gnome-nibbles.vala"
				_tmp7_ = g_strdup ("fast-fakes");
#line 748 "gnome-nibbles.vala"
				result = _tmp7_;
#line 748 "gnome-nibbles.vala"
				return result;
#line 4653 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("2.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4659 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp8_;
#line 750 "gnome-nibbles.vala"
				_tmp8_ = g_strdup ("medium-fakes");
#line 750 "gnome-nibbles.vala"
				result = _tmp8_;
#line 750 "gnome-nibbles.vala"
				return result;
#line 4669 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("3.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4675 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp9_;
#line 752 "gnome-nibbles.vala"
				_tmp9_ = g_strdup ("slow-fakes");
#line 752 "gnome-nibbles.vala"
				result = _tmp9_;
#line 752 "gnome-nibbles.vala"
				return result;
#line 4685 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("4.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4691 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp10_;
#line 754 "gnome-nibbles.vala"
				_tmp10_ = g_strdup ("beginner-fakes");
#line 754 "gnome-nibbles.vala"
				result = _tmp10_;
#line 754 "gnome-nibbles.vala"
				return result;
#line 4701 "gnome-nibbles.c"
			}
		}
	}
#line 756 "gnome-nibbles.vala"
	result = NULL;
#line 756 "gnome-nibbles.vala"
	return result;
#line 4709 "gnome-nibbles.c"
}


static GamesScoresCategory*
_nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                      gpointer self)
{
	GamesScoresCategory* result;
	result = nibbles_category_request ((Nibbles*) self, category_key);
#line 779 "gnome-nibbles.vala"
	return result;
#line 4721 "gnome-nibbles.c"
}


static gchar*
_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                                   gpointer self)
{
	gchar* result;
	result = nibbles_get_new_scores_key ((Nibbles*) self, old_key);
#line 779 "gnome-nibbles.vala"
	return result;
#line 4733 "gnome-nibbles.c"
}


static void
nibbles_create_scores (Nibbles* self)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GeeLinkedList* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresCategory* _tmp6_;
	GeeLinkedList* _tmp7_;
	GamesScoresCategory* _tmp8_;
	GamesScoresCategory* _tmp9_;
	GeeLinkedList* _tmp10_;
	GamesScoresCategory* _tmp11_;
	GamesScoresCategory* _tmp12_;
	GeeLinkedList* _tmp13_;
	GamesScoresCategory* _tmp14_;
	GamesScoresCategory* _tmp15_;
	GeeLinkedList* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GamesScoresCategory* _tmp18_;
	GeeLinkedList* _tmp19_;
	GamesScoresCategory* _tmp20_;
	GamesScoresCategory* _tmp21_;
	GeeLinkedList* _tmp22_;
	GamesScoresCategory* _tmp23_;
	GamesScoresCategory* _tmp24_;
	GtkApplicationWindow* _tmp25_;
	GamesScoresDirectoryImporter* _tmp26_;
	GamesScoresDirectoryImporter* _tmp27_;
	GamesScoresContext* _tmp28_;
#line 759 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 761 "gnome-nibbles.vala"
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 761 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scorecats);
#line 761 "gnome-nibbles.vala"
	self->priv->scorecats = _tmp0_;
#line 763 "gnome-nibbles.vala"
	_tmp1_ = self->priv->scorecats;
#line 763 "gnome-nibbles.vala"
	_tmp2_ = games_scores_category_new ("beginner", _ ("Beginner"));
#line 763 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 763 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
#line 763 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp3_);
#line 765 "gnome-nibbles.vala"
	_tmp4_ = self->priv->scorecats;
#line 765 "gnome-nibbles.vala"
	_tmp5_ = games_scores_category_new ("slow", _ ("Slow"));
#line 765 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 765 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
#line 765 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp6_);
#line 767 "gnome-nibbles.vala"
	_tmp7_ = self->priv->scorecats;
#line 767 "gnome-nibbles.vala"
	_tmp8_ = games_scores_category_new ("medium", _ ("Medium"));
#line 767 "gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 767 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
#line 767 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp9_);
#line 769 "gnome-nibbles.vala"
	_tmp10_ = self->priv->scorecats;
#line 769 "gnome-nibbles.vala"
	_tmp11_ = games_scores_category_new ("fast", _ ("Fast"));
#line 769 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 769 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
#line 769 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp12_);
#line 771 "gnome-nibbles.vala"
	_tmp13_ = self->priv->scorecats;
#line 771 "gnome-nibbles.vala"
	_tmp14_ = games_scores_category_new ("beginner-fakes", _ ("Beginner with Fakes"));
#line 771 "gnome-nibbles.vala"
	_tmp15_ = _tmp14_;
#line 771 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 771 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp15_);
#line 773 "gnome-nibbles.vala"
	_tmp16_ = self->priv->scorecats;
#line 773 "gnome-nibbles.vala"
	_tmp17_ = games_scores_category_new ("slow-fakes", _ ("Slow with Fakes"));
#line 773 "gnome-nibbles.vala"
	_tmp18_ = _tmp17_;
#line 773 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
#line 773 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp18_);
#line 775 "gnome-nibbles.vala"
	_tmp19_ = self->priv->scorecats;
#line 775 "gnome-nibbles.vala"
	_tmp20_ = games_scores_category_new ("medium-fakes", _ ("Medium with Fakes"));
#line 775 "gnome-nibbles.vala"
	_tmp21_ = _tmp20_;
#line 775 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
#line 775 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp21_);
#line 777 "gnome-nibbles.vala"
	_tmp22_ = self->priv->scorecats;
#line 777 "gnome-nibbles.vala"
	_tmp23_ = games_scores_category_new ("fast-fakes", _ ("Fast with Fakes"));
#line 777 "gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 777 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
#line 777 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp24_);
#line 779 "gnome-nibbles.vala"
	_tmp25_ = self->priv->window;
#line 779 "gnome-nibbles.vala"
	_tmp26_ = games_scores_directory_importer_new_with_convert_func (_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func, self);
#line 779 "gnome-nibbles.vala"
	_tmp27_ = _tmp26_;
#line 779 "gnome-nibbles.vala"
	_tmp28_ = games_scores_context_new_with_importer ("gnome-nibbles", _ ("Difficulty Level:"), (GtkWindow*) _tmp25_, _nibbles_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp27_);
#line 779 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 779 "gnome-nibbles.vala"
	self->priv->scores_context = _tmp28_;
#line 779 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp27_);
#line 4871 "gnome-nibbles.c"
}


static GamesScoresCategory*
nibbles_get_scores_category (Nibbles* self,
                             gint speed,
                             gboolean fakes)
{
	GamesScoresCategory* result = NULL;
	gchar* key = NULL;
	GeeLinkedList* _tmp21_;
	gpointer _tmp22_;
#line 789 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 791 "gnome-nibbles.vala"
	key = NULL;
#line 792 "gnome-nibbles.vala"
	switch (speed) {
#line 792 "gnome-nibbles.vala"
		case 1:
#line 4892 "gnome-nibbles.c"
		{
			gchar* _tmp0_;
#line 795 "gnome-nibbles.vala"
			_tmp0_ = g_strdup ("fast");
#line 795 "gnome-nibbles.vala"
			_g_free0 (key);
#line 795 "gnome-nibbles.vala"
			key = _tmp0_;
#line 796 "gnome-nibbles.vala"
			break;
#line 4903 "gnome-nibbles.c"
		}
#line 792 "gnome-nibbles.vala"
		case 2:
#line 4907 "gnome-nibbles.c"
		{
			gchar* _tmp1_;
#line 798 "gnome-nibbles.vala"
			_tmp1_ = g_strdup ("medium");
#line 798 "gnome-nibbles.vala"
			_g_free0 (key);
#line 798 "gnome-nibbles.vala"
			key = _tmp1_;
#line 799 "gnome-nibbles.vala"
			break;
#line 4918 "gnome-nibbles.c"
		}
#line 792 "gnome-nibbles.vala"
		case 3:
#line 4922 "gnome-nibbles.c"
		{
			gchar* _tmp2_;
#line 801 "gnome-nibbles.vala"
			_tmp2_ = g_strdup ("slow");
#line 801 "gnome-nibbles.vala"
			_g_free0 (key);
#line 801 "gnome-nibbles.vala"
			key = _tmp2_;
#line 802 "gnome-nibbles.vala"
			break;
#line 4933 "gnome-nibbles.c"
		}
#line 792 "gnome-nibbles.vala"
		case 4:
#line 4937 "gnome-nibbles.c"
		{
			gchar* _tmp3_;
#line 804 "gnome-nibbles.vala"
			_tmp3_ = g_strdup ("beginner");
#line 804 "gnome-nibbles.vala"
			_g_free0 (key);
#line 804 "gnome-nibbles.vala"
			key = _tmp3_;
#line 805 "gnome-nibbles.vala"
			break;
#line 4948 "gnome-nibbles.c"
		}
		default:
#line 792 "gnome-nibbles.vala"
		break;
#line 4953 "gnome-nibbles.c"
	}
#line 808 "gnome-nibbles.vala"
	if (fakes) {
#line 4957 "gnome-nibbles.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 809 "gnome-nibbles.vala"
		_tmp4_ = key;
#line 809 "gnome-nibbles.vala"
		_tmp5_ = g_strconcat (_tmp4_, "-fakes", NULL);
#line 809 "gnome-nibbles.vala"
		_g_free0 (key);
#line 809 "gnome-nibbles.vala"
		key = _tmp5_;
#line 4968 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp6_;
		GeeLinkedList* _tmp7_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _cat_index = 0;
#line 811 "gnome-nibbles.vala"
		_tmp6_ = self->priv->scorecats;
#line 811 "gnome-nibbles.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 811 "gnome-nibbles.vala"
		_cat_list = _tmp7_;
#line 811 "gnome-nibbles.vala"
		_tmp8_ = _cat_list;
#line 811 "gnome-nibbles.vala"
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 811 "gnome-nibbles.vala"
		_tmp10_ = _tmp9_;
#line 811 "gnome-nibbles.vala"
		_cat_size = _tmp10_;
#line 811 "gnome-nibbles.vala"
		_cat_index = -1;
#line 811 "gnome-nibbles.vala"
		while (TRUE) {
#line 4997 "gnome-nibbles.c"
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			const gchar* _tmp17_;
			GamesScoresCategory* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
#line 811 "gnome-nibbles.vala"
			_tmp11_ = _cat_index;
#line 811 "gnome-nibbles.vala"
			_cat_index = _tmp11_ + 1;
#line 811 "gnome-nibbles.vala"
			_tmp12_ = _cat_index;
#line 811 "gnome-nibbles.vala"
			_tmp13_ = _cat_size;
#line 811 "gnome-nibbles.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 811 "gnome-nibbles.vala"
				break;
#line 5021 "gnome-nibbles.c"
			}
#line 811 "gnome-nibbles.vala"
			_tmp14_ = _cat_list;
#line 811 "gnome-nibbles.vala"
			_tmp15_ = _cat_index;
#line 811 "gnome-nibbles.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
#line 811 "gnome-nibbles.vala"
			cat = (GamesScoresCategory*) _tmp16_;
#line 813 "gnome-nibbles.vala"
			_tmp17_ = key;
#line 813 "gnome-nibbles.vala"
			_tmp18_ = cat;
#line 813 "gnome-nibbles.vala"
			_tmp19_ = games_scores_category_get_key (_tmp18_);
#line 813 "gnome-nibbles.vala"
			_tmp20_ = _tmp19_;
#line 813 "gnome-nibbles.vala"
			if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
#line 814 "gnome-nibbles.vala"
				result = cat;
#line 814 "gnome-nibbles.vala"
				_g_object_unref0 (_cat_list);
#line 814 "gnome-nibbles.vala"
				_g_free0 (key);
#line 814 "gnome-nibbles.vala"
				return result;
#line 5049 "gnome-nibbles.c"
			}
#line 811 "gnome-nibbles.vala"
			_g_object_unref0 (cat);
#line 5053 "gnome-nibbles.c"
		}
#line 811 "gnome-nibbles.vala"
		_g_object_unref0 (_cat_list);
#line 5057 "gnome-nibbles.c"
	}
#line 817 "gnome-nibbles.vala"
	_tmp21_ = self->priv->scorecats;
#line 817 "gnome-nibbles.vala"
	_tmp22_ = gee_linked_list_first (_tmp21_);
#line 817 "gnome-nibbles.vala"
	result = (GamesScoresCategory*) _tmp22_;
#line 817 "gnome-nibbles.vala"
	_g_free0 (key);
#line 817 "gnome-nibbles.vala"
	return result;
#line 5069 "gnome-nibbles.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 820 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 820 "gnome-nibbles.vala"
	return _data2_;
#line 5080 "gnome-nibbles.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 820 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 5091 "gnome-nibbles.c"
		Nibbles* self;
#line 820 "gnome-nibbles.vala"
		self = _data2_->self;
#line 820 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 820 "gnome-nibbles.vala"
		g_slice_free (Block2Data, _data2_);
#line 5099 "gnome-nibbles.c"
	}
}


static void
__lambda10_ (Block2Data* _data2_,
             GObject* object,
             GAsyncResult* _result_)
{
	Nibbles* self;
	glong _tmp3_;
	GError * _inner_error_ = NULL;
#line 844 "gnome-nibbles.vala"
	self = _data2_->self;
#line 844 "gnome-nibbles.vala"
	g_return_if_fail (_result_ != NULL);
#line 5116 "gnome-nibbles.c"
	{
		GamesScoresContext* _tmp0_;
#line 847 "gnome-nibbles.vala"
		_tmp0_ = self->priv->scores_context;
#line 847 "gnome-nibbles.vala"
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error_);
#line 847 "gnome-nibbles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5125 "gnome-nibbles.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 845 "gnome-nibbles.vala"
		e = _inner_error_;
#line 845 "gnome-nibbles.vala"
		_inner_error_ = NULL;
#line 851 "gnome-nibbles.vala"
		_tmp1_ = e;
#line 851 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_->message;
#line 851 "gnome-nibbles.vala"
		g_warning ("gnome-nibbles.vala:851: Failed to add score: %s", _tmp2_);
#line 845 "gnome-nibbles.vala"
		_g_error_free0 (e);
#line 5147 "gnome-nibbles.c"
	}
	__finally0:
#line 845 "gnome-nibbles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 845 "gnome-nibbles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 845 "gnome-nibbles.vala"
		g_clear_error (&_inner_error_);
#line 845 "gnome-nibbles.vala"
		return;
#line 5158 "gnome-nibbles.c"
	}
#line 854 "gnome-nibbles.vala"
	_tmp3_ = _data2_->lowest_high_score;
#line 854 "gnome-nibbles.vala"
	nibbles_game_over (self, _data2_->score, _tmp3_, _data2_->level_reached);
#line 5164 "gnome-nibbles.c"
}


static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 841 "gnome-nibbles.vala"
	__lambda10_ (self, source_object, res);
#line 841 "gnome-nibbles.vala"
	block2_data_unref (self);
#line 5177 "gnome-nibbles.c"
}


static void
nibbles_log_score_cb (Nibbles* self,
                      gint score,
                      gint level_reached)
{
	Block2Data* _data2_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesGame* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GamesScoresCategory* _tmp9_;
	GamesScoresCategory* _tmp10_;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	glong _tmp13_ = 0L;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	NibblesGame* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	NibblesGame* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GamesScoresContext* _tmp30_;
	NibblesGame* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	NibblesGame* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GamesScoresCategory* _tmp37_;
	GamesScoresCategory* _tmp38_;
#line 820 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 820 "gnome-nibbles.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 820 "gnome-nibbles.vala"
	_data2_->_ref_count_ = 1;
#line 820 "gnome-nibbles.vala"
	_data2_->self = g_object_ref (self);
#line 820 "gnome-nibbles.vala"
	_data2_->score = score;
#line 820 "gnome-nibbles.vala"
	_data2_->level_reached = level_reached;
#line 823 "gnome-nibbles.vala"
	_tmp0_ = self->priv->new_game_action;
#line 823 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 824 "gnome-nibbles.vala"
	_tmp1_ = self->priv->pause_action;
#line 824 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 826 "gnome-nibbles.vala"
	_tmp2_ = self->priv->scores_context;
#line 826 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 826 "gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_speed (_tmp3_);
#line 826 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 826 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 826 "gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_fakes (_tmp6_);
#line 826 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 826 "gnome-nibbles.vala"
	_tmp9_ = nibbles_get_scores_category (self, _tmp5_, _tmp8_);
#line 826 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 826 "gnome-nibbles.vala"
	_tmp11_ = games_scores_context_get_high_scores (_tmp2_, _tmp10_, 10);
#line 826 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 826 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp10_);
#line 826 "gnome-nibbles.vala"
	scores = _tmp12_;
#line 827 "gnome-nibbles.vala"
	_tmp14_ = scores;
#line 827 "gnome-nibbles.vala"
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
#line 827 "gnome-nibbles.vala"
	_tmp16_ = _tmp15_;
#line 827 "gnome-nibbles.vala"
	if (_tmp16_ == 10) {
#line 5274 "gnome-nibbles.c"
		GeeList* _tmp17_;
		gpointer _tmp18_;
		GamesScoresScore* _tmp19_;
		glong _tmp20_;
		glong _tmp21_;
#line 827 "gnome-nibbles.vala"
		_tmp17_ = scores;
#line 827 "gnome-nibbles.vala"
		_tmp18_ = gee_list_last (_tmp17_);
#line 827 "gnome-nibbles.vala"
		_tmp19_ = (GamesScoresScore*) _tmp18_;
#line 827 "gnome-nibbles.vala"
		_tmp20_ = games_scores_score_get_score (_tmp19_);
#line 827 "gnome-nibbles.vala"
		_tmp21_ = _tmp20_;
#line 827 "gnome-nibbles.vala"
		_tmp13_ = _tmp21_;
#line 827 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp19_);
#line 5294 "gnome-nibbles.c"
	} else {
#line 827 "gnome-nibbles.vala"
		_tmp13_ = (glong) -1;
#line 5298 "gnome-nibbles.c"
	}
#line 827 "gnome-nibbles.vala"
	_data2_->lowest_high_score = _tmp13_;
#line 829 "gnome-nibbles.vala"
	_tmp22_ = self->priv->game;
#line 829 "gnome-nibbles.vala"
	_tmp23_ = nibbles_game_get_numhumans (_tmp22_);
#line 829 "gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 829 "gnome-nibbles.vala"
	if (_tmp24_ != 1) {
#line 5310 "gnome-nibbles.c"
		glong _tmp25_;
#line 831 "gnome-nibbles.vala"
		_tmp25_ = _data2_->lowest_high_score;
#line 831 "gnome-nibbles.vala"
		nibbles_game_over (self, _data2_->score, _tmp25_, _data2_->level_reached);
#line 832 "gnome-nibbles.vala"
		_g_object_unref0 (scores);
#line 832 "gnome-nibbles.vala"
		block2_data_unref (_data2_);
#line 832 "gnome-nibbles.vala"
		_data2_ = NULL;
#line 832 "gnome-nibbles.vala"
		return;
#line 5324 "gnome-nibbles.c"
	}
#line 835 "gnome-nibbles.vala"
	_tmp26_ = self->priv->game;
#line 835 "gnome-nibbles.vala"
	_tmp27_ = nibbles_game_get_start_level (_tmp26_);
#line 835 "gnome-nibbles.vala"
	_tmp28_ = _tmp27_;
#line 835 "gnome-nibbles.vala"
	if (_tmp28_ != 1) {
#line 5334 "gnome-nibbles.c"
		glong _tmp29_;
#line 837 "gnome-nibbles.vala"
		_tmp29_ = _data2_->lowest_high_score;
#line 837 "gnome-nibbles.vala"
		nibbles_game_over (self, _data2_->score, _tmp29_, _data2_->level_reached);
#line 838 "gnome-nibbles.vala"
		_g_object_unref0 (scores);
#line 838 "gnome-nibbles.vala"
		block2_data_unref (_data2_);
#line 838 "gnome-nibbles.vala"
		_data2_ = NULL;
#line 838 "gnome-nibbles.vala"
		return;
#line 5348 "gnome-nibbles.c"
	}
#line 841 "gnome-nibbles.vala"
	_tmp30_ = self->priv->scores_context;
#line 841 "gnome-nibbles.vala"
	_tmp31_ = self->priv->game;
#line 841 "gnome-nibbles.vala"
	_tmp32_ = nibbles_game_get_speed (_tmp31_);
#line 841 "gnome-nibbles.vala"
	_tmp33_ = _tmp32_;
#line 841 "gnome-nibbles.vala"
	_tmp34_ = self->priv->game;
#line 841 "gnome-nibbles.vala"
	_tmp35_ = nibbles_game_get_fakes (_tmp34_);
#line 841 "gnome-nibbles.vala"
	_tmp36_ = _tmp35_;
#line 841 "gnome-nibbles.vala"
	_tmp37_ = nibbles_get_scores_category (self, _tmp33_, _tmp36_);
#line 841 "gnome-nibbles.vala"
	_tmp38_ = _tmp37_;
#line 841 "gnome-nibbles.vala"
	games_scores_context_add_score (_tmp30_, (glong) _data2_->score, _tmp38_, NULL, ___lambda10__gasync_ready_callback, block2_data_ref (_data2_));
#line 841 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp38_);
#line 820 "gnome-nibbles.vala"
	_g_object_unref0 (scores);
#line 820 "gnome-nibbles.vala"
	block2_data_unref (_data2_);
#line 820 "gnome-nibbles.vala"
	_data2_ = NULL;
#line 5378 "gnome-nibbles.c"
}


static void
nibbles_scores_cb (Nibbles* self)
{
	gboolean should_unpause = FALSE;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GamesScoresContext* _tmp4_;
	gboolean _tmp5_;
#line 858 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 860 "gnome-nibbles.vala"
	should_unpause = FALSE;
#line 861 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 861 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 861 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 861 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 5403 "gnome-nibbles.c"
		GSimpleAction* _tmp3_;
#line 863 "gnome-nibbles.vala"
		_tmp3_ = self->priv->pause_action;
#line 863 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
#line 864 "gnome-nibbles.vala"
		should_unpause = TRUE;
#line 5411 "gnome-nibbles.c"
	}
#line 867 "gnome-nibbles.vala"
	_tmp4_ = self->priv->scores_context;
#line 867 "gnome-nibbles.vala"
	games_scores_context_run_dialog (_tmp4_);
#line 870 "gnome-nibbles.vala"
	_tmp5_ = should_unpause;
#line 870 "gnome-nibbles.vala"
	if (_tmp5_) {
#line 5421 "gnome-nibbles.c"
		GSimpleAction* _tmp6_;
#line 871 "gnome-nibbles.vala"
		_tmp6_ = self->priv->pause_action;
#line 871 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp6_, "activate", NULL);
#line 5427 "gnome-nibbles.c"
	}
}


static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 874 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 874 "gnome-nibbles.vala"
	return _data3_;
#line 5439 "gnome-nibbles.c"
}


static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 874 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5450 "gnome-nibbles.c"
		Nibbles* self;
#line 874 "gnome-nibbles.vala"
		self = _data3_->self;
#line 874 "gnome-nibbles.vala"
		_g_object_unref0 (_data3_->button);
#line 874 "gnome-nibbles.vala"
		_g_object_unref0 (_data3_->label);
#line 874 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 874 "gnome-nibbles.vala"
		g_slice_free (Block3Data, _data3_);
#line 5462 "gnome-nibbles.c"
	}
}


static void
__lambda11_ (Block3Data* _data3_)
{
	Nibbles* self;
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	GtkHeaderBar* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	NibblesView* _tmp8_;
#line 899 "gnome-nibbles.vala"
	self = _data3_->self;
#line 900 "gnome-nibbles.vala"
	_tmp0_ = _data3_->label;
#line 900 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 901 "gnome-nibbles.vala"
	_tmp1_ = _data3_->button;
#line 901 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 903 "gnome-nibbles.vala"
	_tmp2_ = self->priv->headerbar;
#line 903 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 903 "gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
#line 903 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 903 "gnome-nibbles.vala"
	_tmp6_ = g_strdup_printf (_ ("Level %d"), _tmp5_);
#line 903 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 903 "gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp2_, _tmp7_);
#line 903 "gnome-nibbles.vala"
	_g_free0 (_tmp7_);
#line 905 "gnome-nibbles.vala"
	_tmp8_ = self->priv->view;
#line 905 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp8_);
#line 907 "gnome-nibbles.vala"
	nibbles_restart_game (self);
#line 5512 "gnome-nibbles.c"
}


static void
___lambda11__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 899 "gnome-nibbles.vala"
	__lambda11_ (self);
#line 5522 "gnome-nibbles.c"
}


static gboolean
__lambda12_ (Block3Data* _data3_)
{
	Nibbles* self;
	gboolean result = FALSE;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
#line 916 "gnome-nibbles.vala"
	self = _data3_->self;
#line 917 "gnome-nibbles.vala"
	_tmp0_ = _data3_->button;
#line 917 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 918 "gnome-nibbles.vala"
	_tmp1_ = _data3_->button;
#line 918 "gnome-nibbles.vala"
	gtk_widget_grab_default ((GtkWidget*) _tmp1_);
#line 920 "gnome-nibbles.vala"
	result = G_SOURCE_REMOVE;
#line 920 "gnome-nibbles.vala"
	return result;
#line 5547 "gnome-nibbles.c"
}


static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ (self);
#line 916 "gnome-nibbles.vala"
	return result;
#line 5558 "gnome-nibbles.c"
}


static void
nibbles_level_completed_cb (Nibbles* self)
{
	Block3Data* _data3_;
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NibblesView* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	NibblesGame* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkLabel* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkOverlay* _tmp28_;
	GtkLabel* _tmp29_;
	GtkOverlay* _tmp30_;
	GtkButton* _tmp31_;
	GtkOverlay* _tmp32_;
	GtkOverlay* _tmp33_;
#line 874 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 874 "gnome-nibbles.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 874 "gnome-nibbles.vala"
	_data3_->_ref_count_ = 1;
#line 874 "gnome-nibbles.vala"
	_data3_->self = g_object_ref (self);
#line 876 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 876 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
#line 876 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 876 "gnome-nibbles.vala"
	if (_tmp2_ == NIBBLES_GAME_MAX_LEVEL) {
#line 877 "gnome-nibbles.vala"
		block3_data_unref (_data3_);
#line 877 "gnome-nibbles.vala"
		_data3_ = NULL;
#line 877 "gnome-nibbles.vala"
		return;
#line 5622 "gnome-nibbles.c"
	}
#line 879 "gnome-nibbles.vala"
	_tmp3_ = self->priv->view;
#line 879 "gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 881 "gnome-nibbles.vala"
	_tmp4_ = self->priv->new_game_action;
#line 881 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp4_, FALSE);
#line 882 "gnome-nibbles.vala"
	_tmp5_ = self->priv->pause_action;
#line 882 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 885 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 885 "gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
#line 885 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 885 "gnome-nibbles.vala"
	_tmp9_ = g_strdup_printf (_ ("Level %d Completed!"), _tmp8_);
#line 885 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 885 "gnome-nibbles.vala"
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
#line 885 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp11_);
#line 885 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 885 "gnome-nibbles.vala"
	_g_free0 (_tmp10_);
#line 885 "gnome-nibbles.vala"
	_data3_->label = _tmp12_;
#line 886 "gnome-nibbles.vala"
	_tmp13_ = _data3_->label;
#line 886 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
#line 887 "gnome-nibbles.vala"
	_tmp14_ = _data3_->label;
#line 887 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
#line 888 "gnome-nibbles.vala"
	_tmp15_ = _data3_->label;
#line 888 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 150);
#line 889 "gnome-nibbles.vala"
	_tmp16_ = _data3_->label;
#line 889 "gnome-nibbles.vala"
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
#line 889 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp17_, "menu-title");
#line 890 "gnome-nibbles.vala"
	_tmp18_ = _data3_->label;
#line 890 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp18_);
#line 892 "gnome-nibbles.vala"
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("_Next Level"));
#line 892 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp19_);
#line 892 "gnome-nibbles.vala"
	_data3_->button = _tmp19_;
#line 893 "gnome-nibbles.vala"
	_tmp20_ = _data3_->button;
#line 893 "gnome-nibbles.vala"
	gtk_button_set_use_underline (_tmp20_, TRUE);
#line 894 "gnome-nibbles.vala"
	_tmp21_ = _data3_->button;
#line 894 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_CENTER);
#line 895 "gnome-nibbles.vala"
	_tmp22_ = _data3_->button;
#line 895 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
#line 896 "gnome-nibbles.vala"
	_tmp23_ = _data3_->button;
#line 896 "gnome-nibbles.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp23_, 100);
#line 897 "gnome-nibbles.vala"
	_tmp24_ = _data3_->button;
#line 897 "gnome-nibbles.vala"
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
#line 897 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp25_, "suggested-action");
#line 898 "gnome-nibbles.vala"
	_tmp26_ = _data3_->button;
#line 898 "gnome-nibbles.vala"
	gtk_widget_set_can_default ((GtkWidget*) _tmp26_, TRUE);
#line 899 "gnome-nibbles.vala"
	_tmp27_ = _data3_->button;
#line 899 "gnome-nibbles.vala"
	g_signal_connect_data (_tmp27_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 910 "gnome-nibbles.vala"
	_tmp28_ = self->priv->overlay;
#line 910 "gnome-nibbles.vala"
	_tmp29_ = _data3_->label;
#line 910 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp28_, (GtkWidget*) _tmp29_);
#line 911 "gnome-nibbles.vala"
	_tmp30_ = self->priv->overlay;
#line 911 "gnome-nibbles.vala"
	_tmp31_ = _data3_->button;
#line 911 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp30_, (GtkWidget*) _tmp31_);
#line 913 "gnome-nibbles.vala"
	_tmp32_ = self->priv->overlay;
#line 913 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp32_);
#line 914 "gnome-nibbles.vala"
	_tmp33_ = self->priv->overlay;
#line 914 "gnome-nibbles.vala"
	gtk_widget_grab_default ((GtkWidget*) _tmp33_);
#line 916 "gnome-nibbles.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda12__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 874 "gnome-nibbles.vala"
	block3_data_unref (_data3_);
#line 874 "gnome-nibbles.vala"
	_data3_ = NULL;
#line 5740 "gnome-nibbles.c"
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 924 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 924 "gnome-nibbles.vala"
	return _data4_;
#line 5751 "gnome-nibbles.c"
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 924 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 5762 "gnome-nibbles.c"
		Nibbles* self;
#line 924 "gnome-nibbles.vala"
		self = _data4_->self;
#line 924 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 924 "gnome-nibbles.vala"
		g_slice_free (Block4Data, _data4_);
#line 5770 "gnome-nibbles.c"
	}
}


static void
__lambda8_ (Block4Data* _data4_)
{
	Nibbles* self;
	gboolean _tmp0_;
#line 945 "gnome-nibbles.vala"
	self = _data4_->self;
#line 946 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 946 "gnome-nibbles.vala"
	self->priv->preferences_dialog = NULL;
#line 948 "gnome-nibbles.vala"
	_tmp0_ = _data4_->should_unpause;
#line 948 "gnome-nibbles.vala"
	if (_tmp0_) {
#line 5790 "gnome-nibbles.c"
		GSimpleAction* _tmp1_;
#line 949 "gnome-nibbles.vala"
		_tmp1_ = self->priv->pause_action;
#line 949 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp1_, "activate", NULL);
#line 5796 "gnome-nibbles.c"
	}
}


static void
___lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                gpointer self)
{
#line 945 "gnome-nibbles.vala"
	__lambda8_ (self);
#line 5807 "gnome-nibbles.c"
}


static void
nibbles_preferences_cb (Nibbles* self)
{
	Block4Data* _data4_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PreferencesDialog* _tmp4_;
	GtkApplicationWindow* _tmp8_;
	GSettings* _tmp9_;
	GeeArrayList* _tmp10_;
	PreferencesDialog* _tmp11_;
	PreferencesDialog* _tmp12_;
	PreferencesDialog* _tmp13_;
#line 924 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 924 "gnome-nibbles.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 924 "gnome-nibbles.vala"
	_data4_->_ref_count_ = 1;
#line 924 "gnome-nibbles.vala"
	_data4_->self = g_object_ref (self);
#line 926 "gnome-nibbles.vala"
	_data4_->should_unpause = FALSE;
#line 927 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 927 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 927 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 927 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 5843 "gnome-nibbles.c"
		GSimpleAction* _tmp3_;
#line 929 "gnome-nibbles.vala"
		_tmp3_ = self->priv->pause_action;
#line 929 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
#line 930 "gnome-nibbles.vala"
		_data4_->should_unpause = TRUE;
#line 5851 "gnome-nibbles.c"
	}
#line 933 "gnome-nibbles.vala"
	_tmp4_ = self->priv->preferences_dialog;
#line 933 "gnome-nibbles.vala"
	if (_tmp4_ != NULL) {
#line 5857 "gnome-nibbles.c"
		PreferencesDialog* _tmp5_;
		gboolean _tmp6_;
#line 935 "gnome-nibbles.vala"
		_tmp5_ = self->priv->preferences_dialog;
#line 935 "gnome-nibbles.vala"
		gtk_window_present ((GtkWindow*) _tmp5_);
#line 937 "gnome-nibbles.vala"
		_tmp6_ = _data4_->should_unpause;
#line 937 "gnome-nibbles.vala"
		if (_tmp6_) {
#line 5868 "gnome-nibbles.c"
			GSimpleAction* _tmp7_;
#line 938 "gnome-nibbles.vala"
			_tmp7_ = self->priv->pause_action;
#line 938 "gnome-nibbles.vala"
			g_signal_emit_by_name (_tmp7_, "activate", NULL);
#line 5874 "gnome-nibbles.c"
		}
#line 940 "gnome-nibbles.vala"
		block4_data_unref (_data4_);
#line 940 "gnome-nibbles.vala"
		_data4_ = NULL;
#line 940 "gnome-nibbles.vala"
		return;
#line 5882 "gnome-nibbles.c"
	}
#line 943 "gnome-nibbles.vala"
	_tmp8_ = self->priv->window;
#line 943 "gnome-nibbles.vala"
	_tmp9_ = self->priv->settings;
#line 943 "gnome-nibbles.vala"
	_tmp10_ = self->priv->worm_settings;
#line 943 "gnome-nibbles.vala"
	_tmp11_ = preferences_dialog_new (_tmp8_, _tmp9_, _tmp10_);
#line 943 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp11_);
#line 943 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 943 "gnome-nibbles.vala"
	self->priv->preferences_dialog = _tmp11_;
#line 945 "gnome-nibbles.vala"
	_tmp12_ = self->priv->preferences_dialog;
#line 945 "gnome-nibbles.vala"
	g_signal_connect_data ((GtkWidget*) _tmp12_, "destroy", (GCallback) ___lambda8__gtk_widget_destroy, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 952 "gnome-nibbles.vala"
	_tmp13_ = self->priv->preferences_dialog;
#line 952 "gnome-nibbles.vala"
	gtk_dialog_run ((GtkDialog*) _tmp13_);
#line 924 "gnome-nibbles.vala"
	block4_data_unref (_data4_);
#line 924 "gnome-nibbles.vala"
	_data4_ = NULL;
#line 5910 "gnome-nibbles.c"
}


static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 955 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 955 "gnome-nibbles.vala"
	return _data5_;
#line 5921 "gnome-nibbles.c"
}


static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 955 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 5932 "gnome-nibbles.c"
		Nibbles* self;
#line 955 "gnome-nibbles.vala"
		self = _data5_->self;
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->button);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->points_left_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->score_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->msg_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->game_over_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 955 "gnome-nibbles.vala"
		g_slice_free (Block5Data, _data5_);
#line 5950 "gnome-nibbles.c"
	}
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1513 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	result = self;
#line 1514 "glib-2.0.vapi"
	return result;
#line 5965 "gnome-nibbles.c"
}


static void
__lambda9_ (Block5Data* _data5_)
{
	Nibbles* self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkButton* _tmp3_;
	GtkLabel* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
#line 996 "gnome-nibbles.vala"
	self = _data5_->self;
#line 997 "gnome-nibbles.vala"
	_tmp0_ = _data5_->game_over_label;
#line 997 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 998 "gnome-nibbles.vala"
	_tmp1_ = _data5_->score_label;
#line 998 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 999 "gnome-nibbles.vala"
	_tmp2_ = _data5_->points_left_label;
#line 999 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
#line 1000 "gnome-nibbles.vala"
	_tmp3_ = _data5_->button;
#line 1000 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1001 "gnome-nibbles.vala"
	_tmp4_ = _data5_->msg_label;
#line 1001 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 1003 "gnome-nibbles.vala"
	_tmp5_ = self->priv->new_game_action;
#line 1003 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp5_, TRUE);
#line 1004 "gnome-nibbles.vala"
	_tmp6_ = self->priv->pause_action;
#line 1004 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 1006 "gnome-nibbles.vala"
	nibbles_show_new_game_screen_cb (self);
#line 6012 "gnome-nibbles.c"
}


static void
___lambda9__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
#line 996 "gnome-nibbles.vala"
	__lambda9_ (self);
#line 6022 "gnome-nibbles.c"
}


static void
nibbles_game_over (Nibbles* self,
                   gint score,
                   glong lowest_high_score,
                   gint level_reached)
{
	Block5Data* _data5_;
	gboolean is_high_score = FALSE;
	gboolean is_game_won = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	gint _tmp13_;
	GtkLabel* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkLabel* _tmp16_;
	gchar* score_string = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	gint _tmp30_;
	GtkLabel* _tmp31_;
	glong points_left = 0L;
	glong _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	gint _tmp40_;
	GtkLabel* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkStyleContext* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* _tmp50_;
	GtkOverlay* _tmp51_;
	GtkLabel* _tmp52_;
	gboolean _tmp53_;
	NibblesGame* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gboolean _tmp61_ = FALSE;
	NibblesGame* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	GtkOverlay* _tmp68_;
	GtkButton* _tmp69_;
	GtkButton* _tmp70_;
	GtkOverlay* _tmp71_;
#line 955 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 955 "gnome-nibbles.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 955 "gnome-nibbles.vala"
	_data5_->_ref_count_ = 1;
#line 955 "gnome-nibbles.vala"
	_data5_->self = g_object_ref (self);
#line 957 "gnome-nibbles.vala"
	is_high_score = ((glong) score) > lowest_high_score;
#line 958 "gnome-nibbles.vala"
	is_game_won = level_reached == (NIBBLES_GAME_MAX_LEVEL + 1);
#line 960 "gnome-nibbles.vala"
	_tmp1_ = is_game_won;
#line 960 "gnome-nibbles.vala"
	if (_tmp1_) {
#line 960 "gnome-nibbles.vala"
		_tmp0_ = _ ("Congratulations!");
#line 6120 "gnome-nibbles.c"
	} else {
#line 960 "gnome-nibbles.vala"
		_tmp0_ = _ ("Game Over!");
#line 6124 "gnome-nibbles.c"
	}
#line 960 "gnome-nibbles.vala"
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp0_);
#line 960 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp2_);
#line 960 "gnome-nibbles.vala"
	_data5_->game_over_label = _tmp2_;
#line 961 "gnome-nibbles.vala"
	_tmp3_ = _data5_->game_over_label;
#line 961 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
#line 962 "gnome-nibbles.vala"
	_tmp4_ = _data5_->game_over_label;
#line 962 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
#line 963 "gnome-nibbles.vala"
	_tmp5_ = _data5_->game_over_label;
#line 963 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp5_, 150);
#line 964 "gnome-nibbles.vala"
	_tmp6_ = _data5_->game_over_label;
#line 964 "gnome-nibbles.vala"
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
#line 964 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp7_, "menu-title");
#line 965 "gnome-nibbles.vala"
	_tmp8_ = _data5_->game_over_label;
#line 965 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp8_);
#line 967 "gnome-nibbles.vala"
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("You have completed the game."));
#line 967 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp9_);
#line 967 "gnome-nibbles.vala"
	_data5_->msg_label = _tmp9_;
#line 968 "gnome-nibbles.vala"
	_tmp10_ = _data5_->msg_label;
#line 968 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
#line 969 "gnome-nibbles.vala"
	_tmp11_ = _data5_->msg_label;
#line 969 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
#line 970 "gnome-nibbles.vala"
	_tmp12_ = _data5_->msg_label;
#line 970 "gnome-nibbles.vala"
	_tmp13_ = self->priv->window_height;
#line 970 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, _tmp13_ / 3);
#line 971 "gnome-nibbles.vala"
	_tmp14_ = _data5_->msg_label;
#line 971 "gnome-nibbles.vala"
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
#line 971 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp15_, "menu-title");
#line 972 "gnome-nibbles.vala"
	_tmp16_ = _data5_->msg_label;
#line 972 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp16_);
#line 974 "gnome-nibbles.vala"
	_tmp17_ = g_strdup (ngettext ("%d Point", "%d Points", (gulong) score));
#line 974 "gnome-nibbles.vala"
	score_string = _tmp17_;
#line 975 "gnome-nibbles.vala"
	_tmp18_ = score_string;
#line 975 "gnome-nibbles.vala"
	_tmp19_ = g_strdup_printf (_tmp18_, score);
#line 975 "gnome-nibbles.vala"
	_g_free0 (score_string);
#line 975 "gnome-nibbles.vala"
	score_string = _tmp19_;
#line 976 "gnome-nibbles.vala"
	_tmp20_ = score_string;
#line 976 "gnome-nibbles.vala"
	_tmp21_ = string_to_string (_tmp20_);
#line 976 "gnome-nibbles.vala"
	_tmp22_ = g_strconcat ("<b>", _tmp21_, "</b>", NULL);
#line 976 "gnome-nibbles.vala"
	_tmp23_ = _tmp22_;
#line 976 "gnome-nibbles.vala"
	_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
#line 976 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp24_);
#line 976 "gnome-nibbles.vala"
	_tmp25_ = _tmp24_;
#line 976 "gnome-nibbles.vala"
	_g_free0 (_tmp23_);
#line 976 "gnome-nibbles.vala"
	_data5_->score_label = _tmp25_;
#line 977 "gnome-nibbles.vala"
	_tmp26_ = _data5_->score_label;
#line 977 "gnome-nibbles.vala"
	gtk_label_set_use_markup (_tmp26_, TRUE);
#line 978 "gnome-nibbles.vala"
	_tmp27_ = _data5_->score_label;
#line 978 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
#line 979 "gnome-nibbles.vala"
	_tmp28_ = _data5_->score_label;
#line 979 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
#line 980 "gnome-nibbles.vala"
	_tmp29_ = _data5_->score_label;
#line 980 "gnome-nibbles.vala"
	_tmp30_ = self->priv->window_height;
#line 980 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp29_, (_tmp30_ / 3) + 80);
#line 981 "gnome-nibbles.vala"
	_tmp31_ = _data5_->score_label;
#line 981 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp31_);
#line 983 "gnome-nibbles.vala"
	points_left = lowest_high_score - score;
#line 984 "gnome-nibbles.vala"
	_tmp32_ = points_left;
#line 984 "gnome-nibbles.vala"
	_tmp33_ = g_strdup_printf (_ ("(%ld more points to reach the leaderboard)"), _tmp32_);
#line 984 "gnome-nibbles.vala"
	_tmp34_ = _tmp33_;
#line 984 "gnome-nibbles.vala"
	_tmp35_ = (GtkLabel*) gtk_label_new (_tmp34_);
#line 984 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp35_);
#line 984 "gnome-nibbles.vala"
	_tmp36_ = _tmp35_;
#line 984 "gnome-nibbles.vala"
	_g_free0 (_tmp34_);
#line 984 "gnome-nibbles.vala"
	_data5_->points_left_label = _tmp36_;
#line 985 "gnome-nibbles.vala"
	_tmp37_ = _data5_->points_left_label;
#line 985 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp37_, GTK_ALIGN_CENTER);
#line 986 "gnome-nibbles.vala"
	_tmp38_ = _data5_->points_left_label;
#line 986 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp38_, GTK_ALIGN_START);
#line 987 "gnome-nibbles.vala"
	_tmp39_ = _data5_->points_left_label;
#line 987 "gnome-nibbles.vala"
	_tmp40_ = self->priv->window_height;
#line 987 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp39_, (_tmp40_ / 3) + 100);
#line 988 "gnome-nibbles.vala"
	_tmp41_ = _data5_->points_left_label;
#line 988 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp41_);
#line 990 "gnome-nibbles.vala"
	_tmp42_ = (GtkButton*) gtk_button_new_with_label (_ ("_Play Again"));
#line 990 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp42_);
#line 990 "gnome-nibbles.vala"
	_data5_->button = _tmp42_;
#line 991 "gnome-nibbles.vala"
	_tmp43_ = _data5_->button;
#line 991 "gnome-nibbles.vala"
	gtk_button_set_use_underline (_tmp43_, TRUE);
#line 992 "gnome-nibbles.vala"
	_tmp44_ = _data5_->button;
#line 992 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp44_, GTK_ALIGN_CENTER);
#line 993 "gnome-nibbles.vala"
	_tmp45_ = _data5_->button;
#line 993 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp45_, GTK_ALIGN_END);
#line 994 "gnome-nibbles.vala"
	_tmp46_ = _data5_->button;
#line 994 "gnome-nibbles.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp46_, 100);
#line 995 "gnome-nibbles.vala"
	_tmp47_ = _data5_->button;
#line 995 "gnome-nibbles.vala"
	_tmp48_ = gtk_widget_get_style_context ((GtkWidget*) _tmp47_);
#line 995 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp48_, "suggested-action");
#line 996 "gnome-nibbles.vala"
	_tmp49_ = _data5_->button;
#line 996 "gnome-nibbles.vala"
	g_signal_connect_data (_tmp49_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 1008 "gnome-nibbles.vala"
	_tmp50_ = _data5_->button;
#line 1008 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp50_);
#line 1010 "gnome-nibbles.vala"
	_tmp51_ = self->priv->overlay;
#line 1010 "gnome-nibbles.vala"
	_tmp52_ = _data5_->game_over_label;
#line 1010 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp51_, (GtkWidget*) _tmp52_);
#line 1011 "gnome-nibbles.vala"
	_tmp53_ = is_game_won;
#line 1011 "gnome-nibbles.vala"
	if (_tmp53_) {
#line 6318 "gnome-nibbles.c"
		GtkOverlay* _tmp54_;
		GtkLabel* _tmp55_;
#line 1012 "gnome-nibbles.vala"
		_tmp54_ = self->priv->overlay;
#line 1012 "gnome-nibbles.vala"
		_tmp55_ = _data5_->msg_label;
#line 1012 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp54_, (GtkWidget*) _tmp55_);
#line 6327 "gnome-nibbles.c"
	}
#line 1013 "gnome-nibbles.vala"
	_tmp56_ = self->priv->game;
#line 1013 "gnome-nibbles.vala"
	_tmp57_ = nibbles_game_get_numhumans (_tmp56_);
#line 1013 "gnome-nibbles.vala"
	_tmp58_ = _tmp57_;
#line 1013 "gnome-nibbles.vala"
	if (_tmp58_ == 1) {
#line 6337 "gnome-nibbles.c"
		GtkOverlay* _tmp59_;
		GtkLabel* _tmp60_;
#line 1014 "gnome-nibbles.vala"
		_tmp59_ = self->priv->overlay;
#line 1014 "gnome-nibbles.vala"
		_tmp60_ = _data5_->score_label;
#line 1014 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp59_, (GtkWidget*) _tmp60_);
#line 6346 "gnome-nibbles.c"
	}
#line 1015 "gnome-nibbles.vala"
	_tmp62_ = self->priv->game;
#line 1015 "gnome-nibbles.vala"
	_tmp63_ = nibbles_game_get_numhumans (_tmp62_);
#line 1015 "gnome-nibbles.vala"
	_tmp64_ = _tmp63_;
#line 1015 "gnome-nibbles.vala"
	if (_tmp64_ == 1) {
#line 6356 "gnome-nibbles.c"
		gboolean _tmp65_;
#line 1015 "gnome-nibbles.vala"
		_tmp65_ = is_high_score;
#line 1015 "gnome-nibbles.vala"
		_tmp61_ = !_tmp65_;
#line 6362 "gnome-nibbles.c"
	} else {
#line 1015 "gnome-nibbles.vala"
		_tmp61_ = FALSE;
#line 6366 "gnome-nibbles.c"
	}
#line 1015 "gnome-nibbles.vala"
	if (_tmp61_) {
#line 6370 "gnome-nibbles.c"
		GtkOverlay* _tmp66_;
		GtkLabel* _tmp67_;
#line 1016 "gnome-nibbles.vala"
		_tmp66_ = self->priv->overlay;
#line 1016 "gnome-nibbles.vala"
		_tmp67_ = _data5_->points_left_label;
#line 1016 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp66_, (GtkWidget*) _tmp67_);
#line 6379 "gnome-nibbles.c"
	}
#line 1017 "gnome-nibbles.vala"
	_tmp68_ = self->priv->overlay;
#line 1017 "gnome-nibbles.vala"
	_tmp69_ = _data5_->button;
#line 1017 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp68_, (GtkWidget*) _tmp69_);
#line 1019 "gnome-nibbles.vala"
	_tmp70_ = _data5_->button;
#line 1019 "gnome-nibbles.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp70_);
#line 1021 "gnome-nibbles.vala"
	_tmp71_ = self->priv->overlay;
#line 1021 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp71_);
#line 955 "gnome-nibbles.vala"
	_g_free0 (score_string);
#line 955 "gnome-nibbles.vala"
	block5_data_unref (_data5_);
#line 955 "gnome-nibbles.vala"
	_data5_ = NULL;
#line 6401 "gnome-nibbles.c"
}


static void
nibbles_help_cb (Nibbles* self)
{
	GError * _inner_error_ = NULL;
#line 1024 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6411 "gnome-nibbles.c"
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
#line 1028 "gnome-nibbles.vala"
		_tmp0_ = self->priv->window;
#line 1028 "gnome-nibbles.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 1028 "gnome-nibbles.vala"
		gtk_show_uri (_tmp1_, "help:gnome-nibbles", gtk_get_current_event_time (), &_inner_error_);
#line 1028 "gnome-nibbles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6423 "gnome-nibbles.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 1026 "gnome-nibbles.vala"
		e = _inner_error_;
#line 1026 "gnome-nibbles.vala"
		_inner_error_ = NULL;
#line 1032 "gnome-nibbles.vala"
		_tmp2_ = e;
#line 1032 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_->message;
#line 1032 "gnome-nibbles.vala"
		g_warning ("gnome-nibbles.vala:1032: Unable to open help: %s", _tmp3_);
#line 1026 "gnome-nibbles.vala"
		_g_error_free0 (e);
#line 6445 "gnome-nibbles.c"
	}
	__finally1:
#line 1026 "gnome-nibbles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1026 "gnome-nibbles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1026 "gnome-nibbles.vala"
		g_clear_error (&_inner_error_);
#line 1026 "gnome-nibbles.vala"
		return;
#line 6456 "gnome-nibbles.c"
	}
}


static void
nibbles_about_cb (Nibbles* self)
{
#line 1038 "gnome-nibbles.vala"
	static const gchar* authors[6] = {"Sean MacIsaac", "Ian Peters", "Andreas Røsdal", "Guillaume Beland", "Iulian-Gabriel Radu", NULL};
#line 1045 "gnome-nibbles.vala"
	static const gchar* documenters[2] = {"Kevin Breit", NULL};
#line 1048 "gnome-nibbles.vala"
	static const gchar* artists[2] = {"Allan Day", NULL};
#line 6470 "gnome-nibbles.c"
	GtkApplicationWindow* _tmp0_;
#line 1036 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1051 "gnome-nibbles.vala"
	_tmp0_ = self->priv->window;
#line 1051 "gnome-nibbles.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _ ("Nibbles"), "logo-icon-name", "gnome-nibbles", "version", VERSION, "comments", _ ("A worm game for GNOME"), "copyright", "Copyright © 1999–2008 Sean MacIsaac, Ian Peters, Andreas Røsdal\n" "Copyright © 2009 Guillaume Beland\n" "Copyright © 2015 Iulian-Gabriel Radu", "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
#line 6478 "gnome-nibbles.c"
}


gint
nibbles_main (gchar** args,
              int args_length1)
{
	gint result = 0;
	Nibbles* _tmp0_;
	Nibbles* _tmp1_;
	gint _tmp2_;
#line 1071 "gnome-nibbles.vala"
	setlocale (LC_ALL, "");
#line 1072 "gnome-nibbles.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 1073 "gnome-nibbles.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 1074 "gnome-nibbles.vala"
	textdomain (GETTEXT_PACKAGE);
#line 1076 "gnome-nibbles.vala"
	_tmp0_ = nibbles_new ();
#line 1076 "gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 1076 "gnome-nibbles.vala"
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, args_length1, args);
#line 1076 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp1_);
#line 1076 "gnome-nibbles.vala"
	result = _tmp2_;
#line 1076 "gnome-nibbles.vala"
	return result;
#line 6510 "gnome-nibbles.c"
}


int
main (int argc,
      char ** argv)
{
#line 1069 "gnome-nibbles.vala"
	return nibbles_main (argv, argc);
#line 6520 "gnome-nibbles.c"
}


static void
nibbles_class_init (NibblesClass * klass)
{
#line 19 "gnome-nibbles.vala"
	nibbles_parent_class = g_type_class_peek_parent (klass);
#line 19 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &Nibbles_private_offset);
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) nibbles_real_handle_local_options;
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) nibbles_real_startup;
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) nibbles_real_activate;
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) nibbles_real_shutdown;
#line 19 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
#line 6541 "gnome-nibbles.c"
}


static void
nibbles_instance_init (Nibbles * self)
{
#line 19 "gnome-nibbles.vala"
	self->priv = nibbles_get_instance_private (self);
#line 57 "gnome-nibbles.vala"
	self->priv->preferences_dialog = NULL;
#line 66 "gnome-nibbles.vala"
	self->priv->game = NULL;
#line 77 "gnome-nibbles.vala"
	self->priv->countdown_id = (guint) 0;
#line 79 "gnome-nibbles.vala"
	self->priv->seconds = 0;
#line 6558 "gnome-nibbles.c"
}


static void
nibbles_finalize (GObject * obj)
{
	Nibbles * self;
#line 19 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
#line 22 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->settings);
#line 23 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 26 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->window);
#line 32 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 33 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->overlay);
#line 36 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 37 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 38 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 41 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_players_buttons);
#line 42 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_ai_buttons);
#line 43 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->next_button);
#line 44 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->start_button);
#line 46 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->grids_box);
#line 47 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_pixbuf);
#line 48 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
#line 51 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->statusbar_stack);
#line 52 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->countdown);
#line 53 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard);
#line 54 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard_life);
#line 57 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 60 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->view);
#line 62 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game_box);
#line 63 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->frame);
#line 66 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game);
#line 69 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 70 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scorecats);
#line 73 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 74 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 75 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->back_action);
#line 19 "gnome-nibbles.vala"
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
#line 6628 "gnome-nibbles.c"
}


GType
nibbles_get_type (void)
{
	static volatile gsize nibbles_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
		GType nibbles_type_id;
		nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
		Nibbles_private_offset = g_type_add_instance_private (nibbles_type_id, sizeof (NibblesPrivate));
		g_once_init_leave (&nibbles_type_id__volatile, nibbles_type_id);
	}
	return nibbles_type_id__volatile;
}


static inline gpointer
scoreboard_get_instance_private (Scoreboard* self)
{
	return G_STRUCT_MEMBER_P (self, Scoreboard_private_offset);
}


Scoreboard*
scoreboard_construct (GType object_type)
{
	Scoreboard * self = NULL;
	GeeHashMap* _tmp0_;
#line 1085 "gnome-nibbles.vala"
	self = (Scoreboard*) g_object_new (object_type, NULL);
#line 1087 "gnome-nibbles.vala"
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1087 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->boxes);
#line 1087 "gnome-nibbles.vala"
	self->priv->boxes = _tmp0_;
#line 1085 "gnome-nibbles.vala"
	return self;
#line 6669 "gnome-nibbles.c"
}


Scoreboard*
scoreboard_new (void)
{
#line 1085 "gnome-nibbles.vala"
	return scoreboard_construct (TYPE_SCOREBOARD);
#line 6678 "gnome-nibbles.c"
}


void
scoreboard_register (Scoreboard* self,
                     Worm* worm,
                     const gchar* color_name,
                     GdkPixbuf* life_pixbuf)
{
	PangoColor color = {0};
	PlayerScoreBox* box = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PangoColor _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	PlayerScoreBox* _tmp9_;
	PlayerScoreBox* _tmp10_;
	GeeHashMap* _tmp11_;
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (worm != NULL);
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (color_name != NULL);
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (life_pixbuf != NULL);
#line 1092 "gnome-nibbles.vala"
	memset (&color, 0, sizeof (PangoColor));
#line 1093 "gnome-nibbles.vala"
	pango_color_parse (&color, color_name);
#line 1098 "gnome-nibbles.vala"
	_tmp0_ = worm_get_id (worm);
#line 1098 "gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 1098 "gnome-nibbles.vala"
	_tmp2_ = g_strdup_printf (_ ("Player %d"), _tmp1_ + 1);
#line 1098 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 1098 "gnome-nibbles.vala"
	_tmp4_ = color;
#line 1098 "gnome-nibbles.vala"
	_tmp5_ = worm_get_score (worm);
#line 1098 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1098 "gnome-nibbles.vala"
	_tmp7_ = worm_get_lives (worm);
#line 1098 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 1098 "gnome-nibbles.vala"
	_tmp9_ = player_score_box_new (_tmp3_, &_tmp4_, _tmp6_, _tmp8_, life_pixbuf);
#line 1098 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp9_);
#line 1098 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 1098 "gnome-nibbles.vala"
	_g_free0 (_tmp3_);
#line 1098 "gnome-nibbles.vala"
	box = _tmp10_;
#line 1099 "gnome-nibbles.vala"
	_tmp11_ = self->priv->boxes;
#line 1099 "gnome-nibbles.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, box, worm);
#line 1100 "gnome-nibbles.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
#line 1090 "gnome-nibbles.vala"
	_g_object_unref0 (box);
#line 6750 "gnome-nibbles.c"
}


void
scoreboard_update (Scoreboard* self)
{
#line 1103 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6759 "gnome-nibbles.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 1105 "gnome-nibbles.vala"
		_tmp0_ = self->priv->boxes;
#line 1105 "gnome-nibbles.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
#line 1105 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1105 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 1105 "gnome-nibbles.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 1105 "gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 1105 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp3_);
#line 1105 "gnome-nibbles.vala"
		_entry_it = _tmp5_;
#line 1105 "gnome-nibbles.vala"
		while (TRUE) {
#line 6786 "gnome-nibbles.c"
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			PlayerScoreBox* _tmp11_;
			PlayerScoreBox* _tmp12_;
			Worm* worm = NULL;
			GeeMapEntry* _tmp13_;
			gconstpointer _tmp14_;
			Worm* _tmp15_;
			Worm* _tmp16_;
			PlayerScoreBox* _tmp17_;
			Worm* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			Worm* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
#line 1105 "gnome-nibbles.vala"
			_tmp6_ = _entry_it;
#line 1105 "gnome-nibbles.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 1105 "gnome-nibbles.vala"
				break;
#line 6814 "gnome-nibbles.c"
			}
#line 1105 "gnome-nibbles.vala"
			_tmp7_ = _entry_it;
#line 1105 "gnome-nibbles.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 1105 "gnome-nibbles.vala"
			entry = (GeeMapEntry*) _tmp8_;
#line 1107 "gnome-nibbles.vala"
			_tmp9_ = entry;
#line 1107 "gnome-nibbles.vala"
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
#line 1107 "gnome-nibbles.vala"
			_tmp11_ = _tmp10_;
#line 1107 "gnome-nibbles.vala"
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
#line 1107 "gnome-nibbles.vala"
			box = _tmp12_;
#line 1108 "gnome-nibbles.vala"
			_tmp13_ = entry;
#line 1108 "gnome-nibbles.vala"
			_tmp14_ = gee_map_entry_get_value (_tmp13_);
#line 1108 "gnome-nibbles.vala"
			_tmp15_ = _tmp14_;
#line 1108 "gnome-nibbles.vala"
			_tmp16_ = _g_object_ref0 ((Worm*) _tmp15_);
#line 1108 "gnome-nibbles.vala"
			worm = _tmp16_;
#line 1110 "gnome-nibbles.vala"
			_tmp17_ = box;
#line 1110 "gnome-nibbles.vala"
			_tmp18_ = worm;
#line 1110 "gnome-nibbles.vala"
			_tmp19_ = worm_get_score (_tmp18_);
#line 1110 "gnome-nibbles.vala"
			_tmp20_ = _tmp19_;
#line 1110 "gnome-nibbles.vala"
			_tmp21_ = worm;
#line 1110 "gnome-nibbles.vala"
			_tmp22_ = worm_get_lives (_tmp21_);
#line 1110 "gnome-nibbles.vala"
			_tmp23_ = _tmp22_;
#line 1110 "gnome-nibbles.vala"
			player_score_box_update (_tmp17_, _tmp20_, _tmp23_);
#line 1105 "gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 1105 "gnome-nibbles.vala"
			_g_object_unref0 (box);
#line 1105 "gnome-nibbles.vala"
			_g_object_unref0 (entry);
#line 6864 "gnome-nibbles.c"
		}
#line 1105 "gnome-nibbles.vala"
		_g_object_unref0 (_entry_it);
#line 6868 "gnome-nibbles.c"
	}
}


void
scoreboard_clear (Scoreboard* self)
{
	GeeHashMap* _tmp14_;
#line 1114 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6879 "gnome-nibbles.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 1116 "gnome-nibbles.vala"
		_tmp0_ = self->priv->boxes;
#line 1116 "gnome-nibbles.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
#line 1116 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1116 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 1116 "gnome-nibbles.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 1116 "gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 1116 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp3_);
#line 1116 "gnome-nibbles.vala"
		_entry_it = _tmp5_;
#line 1116 "gnome-nibbles.vala"
		while (TRUE) {
#line 6906 "gnome-nibbles.c"
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			PlayerScoreBox* _tmp11_;
			PlayerScoreBox* _tmp12_;
			PlayerScoreBox* _tmp13_;
#line 1116 "gnome-nibbles.vala"
			_tmp6_ = _entry_it;
#line 1116 "gnome-nibbles.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 1116 "gnome-nibbles.vala"
				break;
#line 6923 "gnome-nibbles.c"
			}
#line 1116 "gnome-nibbles.vala"
			_tmp7_ = _entry_it;
#line 1116 "gnome-nibbles.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 1116 "gnome-nibbles.vala"
			entry = (GeeMapEntry*) _tmp8_;
#line 1118 "gnome-nibbles.vala"
			_tmp9_ = entry;
#line 1118 "gnome-nibbles.vala"
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
#line 1118 "gnome-nibbles.vala"
			_tmp11_ = _tmp10_;
#line 1118 "gnome-nibbles.vala"
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
#line 1118 "gnome-nibbles.vala"
			box = _tmp12_;
#line 1119 "gnome-nibbles.vala"
			_tmp13_ = box;
#line 1119 "gnome-nibbles.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 1116 "gnome-nibbles.vala"
			_g_object_unref0 (box);
#line 1116 "gnome-nibbles.vala"
			_g_object_unref0 (entry);
#line 6949 "gnome-nibbles.c"
		}
#line 1116 "gnome-nibbles.vala"
		_g_object_unref0 (_entry_it);
#line 6953 "gnome-nibbles.c"
	}
#line 1121 "gnome-nibbles.vala"
	_tmp14_ = self->priv->boxes;
#line 1121 "gnome-nibbles.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp14_);
#line 6959 "gnome-nibbles.c"
}


static void
scoreboard_class_init (ScoreboardClass * klass)
{
#line 1081 "gnome-nibbles.vala"
	scoreboard_parent_class = g_type_class_peek_parent (klass);
#line 1081 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &Scoreboard_private_offset);
#line 1081 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
#line 1081 "gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/scoreboard.ui");
#line 6974 "gnome-nibbles.c"
}


static void
scoreboard_instance_init (Scoreboard * self)
{
#line 1081 "gnome-nibbles.vala"
	self->priv = scoreboard_get_instance_private (self);
#line 1081 "gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 6985 "gnome-nibbles.c"
}


static void
scoreboard_finalize (GObject * obj)
{
	Scoreboard * self;
#line 1081 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
#line 1083 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->boxes);
#line 1081 "gnome-nibbles.vala"
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
#line 6999 "gnome-nibbles.c"
}


GType
scoreboard_get_type (void)
{
	static volatile gsize scoreboard_type_id__volatile = 0;
	if (g_once_init_enter (&scoreboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
		GType scoreboard_type_id;
		scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
		Scoreboard_private_offset = g_type_add_instance_private (scoreboard_type_id, sizeof (ScoreboardPrivate));
		g_once_init_leave (&scoreboard_type_id__volatile, scoreboard_type_id);
	}
	return scoreboard_type_id__volatile;
}


static inline gpointer
player_score_box_get_instance_private (PlayerScoreBox* self)
{
	return G_STRUCT_MEMBER_P (self, PlayerScoreBox_private_offset);
}


PlayerScoreBox*
player_score_box_construct (GType object_type,
                            const gchar* name,
                            PangoColor* color,
                            gint score,
                            gint lives_left,
                            GdkPixbuf* life_pixbuf)
{
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GeeLinkedList* _tmp14_;
#line 1137 "gnome-nibbles.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1137 "gnome-nibbles.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 1137 "gnome-nibbles.vala"
	g_return_val_if_fail (life_pixbuf != NULL, NULL);
#line 1137 "gnome-nibbles.vala"
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp0_ = self->priv->name_label;
#line 1139 "gnome-nibbles.vala"
	_tmp1_ = pango_color_to_string (color);
#line 1139 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 1139 "gnome-nibbles.vala"
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 1139 "gnome-nibbles.vala"
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1139 "gnome-nibbles.vala"
	_tmp7_ = g_strconcat (_tmp6_, name, NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 1139 "gnome-nibbles.vala"
	_tmp9_ = g_strconcat (_tmp8_, "</span>", NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 1139 "gnome-nibbles.vala"
	gtk_label_set_markup (_tmp0_, _tmp10_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp10_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp8_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp6_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp4_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp2_);
#line 1140 "gnome-nibbles.vala"
	_tmp11_ = self->priv->score_label;
#line 1140 "gnome-nibbles.vala"
	_tmp12_ = g_strdup_printf ("%i", score);
#line 1140 "gnome-nibbles.vala"
	_tmp13_ = _tmp12_;
#line 1140 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp11_, _tmp13_);
#line 1140 "gnome-nibbles.vala"
	_g_free0 (_tmp13_);
#line 1142 "gnome-nibbles.vala"
	_tmp14_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1142 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->life_images);
#line 1142 "gnome-nibbles.vala"
	self->priv->life_images = _tmp14_;
#line 7107 "gnome-nibbles.c"
	{
		gint i = 0;
#line 1144 "gnome-nibbles.vala"
		i = 0;
#line 7112 "gnome-nibbles.c"
		{
			gboolean _tmp15_ = FALSE;
#line 1144 "gnome-nibbles.vala"
			_tmp15_ = TRUE;
#line 1144 "gnome-nibbles.vala"
			while (TRUE) {
#line 7119 "gnome-nibbles.c"
				gint _tmp17_;
				GtkImage* life = NULL;
				GtkImage* _tmp18_;
				GtkImage* _tmp19_;
				gint _tmp20_;
				GeeLinkedList* _tmp22_;
				GtkImage* _tmp23_;
				GtkGrid* _tmp24_;
				GtkImage* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
#line 1144 "gnome-nibbles.vala"
				if (!_tmp15_) {
#line 7133 "gnome-nibbles.c"
					gint _tmp16_;
#line 1144 "gnome-nibbles.vala"
					_tmp16_ = i;
#line 1144 "gnome-nibbles.vala"
					i = _tmp16_ + 1;
#line 7139 "gnome-nibbles.c"
				}
#line 1144 "gnome-nibbles.vala"
				_tmp15_ = FALSE;
#line 1144 "gnome-nibbles.vala"
				_tmp17_ = i;
#line 1144 "gnome-nibbles.vala"
				if (!(_tmp17_ < WORM_MAX_LIVES)) {
#line 1144 "gnome-nibbles.vala"
					break;
#line 7149 "gnome-nibbles.c"
				}
#line 1146 "gnome-nibbles.vala"
				_tmp18_ = (GtkImage*) gtk_image_new_from_pixbuf (life_pixbuf);
#line 1146 "gnome-nibbles.vala"
				g_object_ref_sink (_tmp18_);
#line 1146 "gnome-nibbles.vala"
				life = _tmp18_;
#line 1147 "gnome-nibbles.vala"
				_tmp19_ = life;
#line 1147 "gnome-nibbles.vala"
				gtk_widget_show ((GtkWidget*) _tmp19_);
#line 1149 "gnome-nibbles.vala"
				_tmp20_ = i;
#line 1149 "gnome-nibbles.vala"
				if (_tmp20_ >= WORM_STARTING_LIVES) {
#line 7165 "gnome-nibbles.c"
					GtkImage* _tmp21_;
#line 1150 "gnome-nibbles.vala"
					_tmp21_ = life;
#line 1150 "gnome-nibbles.vala"
					gtk_widget_set_opacity ((GtkWidget*) _tmp21_, (gdouble) 0);
#line 7171 "gnome-nibbles.c"
				}
#line 1152 "gnome-nibbles.vala"
				_tmp22_ = self->priv->life_images;
#line 1152 "gnome-nibbles.vala"
				_tmp23_ = life;
#line 1152 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
#line 1153 "gnome-nibbles.vala"
				_tmp24_ = self->priv->lives_grid;
#line 1153 "gnome-nibbles.vala"
				_tmp25_ = life;
#line 1153 "gnome-nibbles.vala"
				_tmp26_ = i;
#line 1153 "gnome-nibbles.vala"
				_tmp27_ = i;
#line 1153 "gnome-nibbles.vala"
				gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, _tmp26_ % 6, _tmp27_ / 6, 1, 1);
#line 1144 "gnome-nibbles.vala"
				_g_object_unref0 (life);
#line 7191 "gnome-nibbles.c"
			}
		}
	}
#line 1137 "gnome-nibbles.vala"
	return self;
#line 7197 "gnome-nibbles.c"
}


PlayerScoreBox*
player_score_box_new (const gchar* name,
                      PangoColor* color,
                      gint score,
                      gint lives_left,
                      GdkPixbuf* life_pixbuf)
{
#line 1137 "gnome-nibbles.vala"
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, life_pixbuf);
#line 7210 "gnome-nibbles.c"
}


void
player_score_box_update (PlayerScoreBox* self,
                         gint score,
                         gint lives_left)
{
#line 1157 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1159 "gnome-nibbles.vala"
	player_score_box_update_score (self, score);
#line 1160 "gnome-nibbles.vala"
	player_score_box_update_lives (self, lives_left);
#line 7225 "gnome-nibbles.c"
}


void
player_score_box_update_score (PlayerScoreBox* self,
                               gint score)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 1163 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1165 "gnome-nibbles.vala"
	_tmp0_ = self->priv->score_label;
#line 1165 "gnome-nibbles.vala"
	_tmp1_ = g_strdup_printf ("%i", score);
#line 1165 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 1165 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp0_, _tmp2_);
#line 1165 "gnome-nibbles.vala"
	_g_free0 (_tmp2_);
#line 7248 "gnome-nibbles.c"
}


void
player_score_box_update_lives (PlayerScoreBox* self,
                               gint lives_left)
{
#line 1168 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 7258 "gnome-nibbles.c"
	{
		gint i = 0;
		GeeLinkedList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
#line 1171 "gnome-nibbles.vala"
		_tmp0_ = self->priv->life_images;
#line 1171 "gnome-nibbles.vala"
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 1171 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1171 "gnome-nibbles.vala"
		i = _tmp2_ - 1;
#line 7272 "gnome-nibbles.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1171 "gnome-nibbles.vala"
			_tmp3_ = TRUE;
#line 1171 "gnome-nibbles.vala"
			while (TRUE) {
#line 7279 "gnome-nibbles.c"
				gint _tmp5_;
				GeeLinkedList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				GtkImage* _tmp9_;
#line 1171 "gnome-nibbles.vala"
				if (!_tmp3_) {
#line 7287 "gnome-nibbles.c"
					gint _tmp4_;
#line 1171 "gnome-nibbles.vala"
					_tmp4_ = i;
#line 1171 "gnome-nibbles.vala"
					i = _tmp4_ - 1;
#line 7293 "gnome-nibbles.c"
				}
#line 1171 "gnome-nibbles.vala"
				_tmp3_ = FALSE;
#line 1171 "gnome-nibbles.vala"
				_tmp5_ = i;
#line 1171 "gnome-nibbles.vala"
				if (!(_tmp5_ >= lives_left)) {
#line 1171 "gnome-nibbles.vala"
					break;
#line 7303 "gnome-nibbles.c"
				}
#line 1172 "gnome-nibbles.vala"
				_tmp6_ = self->priv->life_images;
#line 1172 "gnome-nibbles.vala"
				_tmp7_ = i;
#line 1172 "gnome-nibbles.vala"
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
#line 1172 "gnome-nibbles.vala"
				_tmp9_ = (GtkImage*) _tmp8_;
#line 1172 "gnome-nibbles.vala"
				gtk_widget_set_opacity ((GtkWidget*) _tmp9_, (gdouble) 0);
#line 1172 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp9_);
#line 7317 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
#line 1175 "gnome-nibbles.vala"
		i = 0;
#line 7325 "gnome-nibbles.c"
		{
			gboolean _tmp10_ = FALSE;
#line 1175 "gnome-nibbles.vala"
			_tmp10_ = TRUE;
#line 1175 "gnome-nibbles.vala"
			while (TRUE) {
#line 7332 "gnome-nibbles.c"
				gint _tmp12_;
				GeeLinkedList* _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				GtkImage* _tmp16_;
#line 1175 "gnome-nibbles.vala"
				if (!_tmp10_) {
#line 7340 "gnome-nibbles.c"
					gint _tmp11_;
#line 1175 "gnome-nibbles.vala"
					_tmp11_ = i;
#line 1175 "gnome-nibbles.vala"
					i = _tmp11_ + 1;
#line 7346 "gnome-nibbles.c"
				}
#line 1175 "gnome-nibbles.vala"
				_tmp10_ = FALSE;
#line 1175 "gnome-nibbles.vala"
				_tmp12_ = i;
#line 1175 "gnome-nibbles.vala"
				if (!(_tmp12_ < lives_left)) {
#line 1175 "gnome-nibbles.vala"
					break;
#line 7356 "gnome-nibbles.c"
				}
#line 1176 "gnome-nibbles.vala"
				_tmp13_ = self->priv->life_images;
#line 1176 "gnome-nibbles.vala"
				_tmp14_ = i;
#line 1176 "gnome-nibbles.vala"
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
#line 1176 "gnome-nibbles.vala"
				_tmp16_ = (GtkImage*) _tmp15_;
#line 1176 "gnome-nibbles.vala"
				gtk_widget_set_opacity ((GtkWidget*) _tmp16_, (gdouble) 1);
#line 1176 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp16_);
#line 7370 "gnome-nibbles.c"
			}
		}
	}
}


static void
player_score_box_class_init (PlayerScoreBoxClass * klass)
{
#line 1126 "gnome-nibbles.vala"
	player_score_box_parent_class = g_type_class_peek_parent (klass);
#line 1126 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &PlayerScoreBox_private_offset);
#line 1126 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/player-score-box.ui");
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
#line 7394 "gnome-nibbles.c"
}


static void
player_score_box_instance_init (PlayerScoreBox * self)
{
#line 1126 "gnome-nibbles.vala"
	self->priv = player_score_box_get_instance_private (self);
#line 1126 "gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 7405 "gnome-nibbles.c"
}


static void
player_score_box_finalize (GObject * obj)
{
	PlayerScoreBox * self;
#line 1126 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
#line 1129 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->name_label);
#line 1131 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->score_label);
#line 1133 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->lives_grid);
#line 1135 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->life_images);
#line 1126 "gnome-nibbles.vala"
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
#line 7425 "gnome-nibbles.c"
}


GType
player_score_box_get_type (void)
{
	static volatile gsize player_score_box_type_id__volatile = 0;
	if (g_once_init_enter (&player_score_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
		GType player_score_box_type_id;
		player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
		PlayerScoreBox_private_offset = g_type_add_instance_private (player_score_box_type_id, sizeof (PlayerScoreBoxPrivate));
		g_once_init_leave (&player_score_box_type_id__volatile, player_score_box_type_id);
	}
	return player_score_box_type_id__volatile;
}


static inline gpointer
controls_grid_get_instance_private (ControlsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, ControlsGrid_private_offset);
}


ControlsGrid*
controls_grid_construct (GType object_type,
                         gint worm_id,
                         WormProperties* worm_props,
                         GdkPixbuf* arrow,
                         GdkPixbuf* arrow_key)
{
	ControlsGrid * self = NULL;
	PangoColor color = {0};
	WormProperties _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* player_id = NULL;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkImage* _tmp13_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* _tmp15_;
	GtkImage* _tmp16_;
	GdkPixbuf* _tmp17_;
	GdkPixbuf* _tmp18_;
	GtkImage* _tmp19_;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp21_;
	GtkImage* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	gchar* upper_key = NULL;
	WormProperties _tmp25_;
	guint _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	WormProperties _tmp41_;
	guint _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	WormProperties _tmp57_;
	guint _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	WormProperties _tmp73_;
	guint _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	const gchar* _tmp77_;
#line 1210 "gnome-nibbles.vala"
	g_return_val_if_fail (worm_props != NULL, NULL);
#line 1210 "gnome-nibbles.vala"
	g_return_val_if_fail (arrow != NULL, NULL);
#line 1210 "gnome-nibbles.vala"
	g_return_val_if_fail (arrow_key != NULL, NULL);
#line 1210 "gnome-nibbles.vala"
	self = (ControlsGrid*) g_object_new (object_type, NULL);
#line 1212 "gnome-nibbles.vala"
	memset (&color, 0, sizeof (PangoColor));
#line 1213 "gnome-nibbles.vala"
	_tmp0_ = *worm_props;
#line 1213 "gnome-nibbles.vala"
	_tmp1_ = _tmp0_.color;
#line 1213 "gnome-nibbles.vala"
	_tmp2_ = nibbles_view_colorval_name (_tmp1_);
#line 1213 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 1213 "gnome-nibbles.vala"
	pango_color_parse (&color, _tmp3_);
#line 1213 "gnome-nibbles.vala"
	_g_free0 (_tmp3_);
#line 1216 "gnome-nibbles.vala"
	_tmp4_ = g_strdup_printf (_ ("Player %d"), worm_id + 1);
#line 1216 "gnome-nibbles.vala"
	player_id = _tmp4_;
#line 1217 "gnome-nibbles.vala"
	_tmp5_ = self->priv->name_label;
#line 1217 "gnome-nibbles.vala"
	_tmp6_ = pango_color_to_string (&color);
#line 1217 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 1217 "gnome-nibbles.vala"
	_tmp8_ = string_to_string (_tmp7_);
#line 1217 "gnome-nibbles.vala"
	_tmp9_ = player_id;
#line 1217 "gnome-nibbles.vala"
	_tmp10_ = string_to_string (_tmp9_);
#line 1217 "gnome-nibbles.vala"
	_tmp11_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp8_, "\">", _tmp10_, "</span></b>", NULL);
#line 1217 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 1217 "gnome-nibbles.vala"
	gtk_label_set_markup (_tmp5_, _tmp12_);
#line 1217 "gnome-nibbles.vala"
	_g_free0 (_tmp12_);
#line 1217 "gnome-nibbles.vala"
	_g_free0 (_tmp7_);
#line 1219 "gnome-nibbles.vala"
	_tmp13_ = self->priv->arrow_up;
#line 1219 "gnome-nibbles.vala"
	_tmp14_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_NONE);
#line 1219 "gnome-nibbles.vala"
	_tmp15_ = _tmp14_;
#line 1219 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp13_, _tmp15_);
#line 1219 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp15_);
#line 1220 "gnome-nibbles.vala"
	_tmp16_ = self->priv->arrow_down;
#line 1220 "gnome-nibbles.vala"
	_tmp17_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 1220 "gnome-nibbles.vala"
	_tmp18_ = _tmp17_;
#line 1220 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp16_, _tmp18_);
#line 1220 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp18_);
#line 1221 "gnome-nibbles.vala"
	_tmp19_ = self->priv->arrow_left;
#line 1221 "gnome-nibbles.vala"
	_tmp20_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 1221 "gnome-nibbles.vala"
	_tmp21_ = _tmp20_;
#line 1221 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp19_, _tmp21_);
#line 1221 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp21_);
#line 1222 "gnome-nibbles.vala"
	_tmp22_ = self->priv->arrow_right;
#line 1222 "gnome-nibbles.vala"
	_tmp23_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 1222 "gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 1222 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp22_, _tmp24_);
#line 1222 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp24_);
#line 1225 "gnome-nibbles.vala"
	_tmp25_ = *worm_props;
#line 1225 "gnome-nibbles.vala"
	_tmp26_ = _tmp25_.up;
#line 1225 "gnome-nibbles.vala"
	_tmp27_ = gdk_keyval_name (_tmp26_);
#line 1225 "gnome-nibbles.vala"
	_tmp28_ = g_utf8_strup (_tmp27_, (gssize) -1);
#line 1225 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1225 "gnome-nibbles.vala"
	upper_key = _tmp28_;
#line 1226 "gnome-nibbles.vala"
	_tmp29_ = upper_key;
#line 1226 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp29_, "UP") == 0) {
#line 7611 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp30_;
		GtkOverlay* _tmp31_;
		GdkPixbuf* _tmp32_;
		GtkImage* _tmp33_;
		GtkImage* _tmp34_;
		GtkOverlay* _tmp35_;
#line 1228 "gnome-nibbles.vala"
		_tmp30_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_NONE);
#line 1228 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp30_;
#line 1229 "gnome-nibbles.vala"
		_tmp31_ = self->priv->move_up;
#line 1229 "gnome-nibbles.vala"
		_tmp32_ = rotated_pixbuf;
#line 1229 "gnome-nibbles.vala"
		_tmp33_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp32_);
#line 1229 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp33_);
#line 1229 "gnome-nibbles.vala"
		_tmp34_ = _tmp33_;
#line 1229 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp31_, (GtkWidget*) _tmp34_);
#line 1229 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp34_);
#line 1230 "gnome-nibbles.vala"
		_tmp35_ = self->priv->move_up;
#line 1230 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp35_);
#line 1226 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7643 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
#line 1233 "gnome-nibbles.vala"
		_tmp36_ = self->priv->move_up_label;
#line 1233 "gnome-nibbles.vala"
		_tmp37_ = upper_key;
#line 1233 "gnome-nibbles.vala"
		_tmp38_ = string_to_string (_tmp37_);
#line 1233 "gnome-nibbles.vala"
		_tmp39_ = g_strconcat ("<b>", _tmp38_, "</b>", NULL);
#line 1233 "gnome-nibbles.vala"
		_tmp40_ = _tmp39_;
#line 1233 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp36_, _tmp40_);
#line 1233 "gnome-nibbles.vala"
		_g_free0 (_tmp40_);
#line 7664 "gnome-nibbles.c"
	}
#line 1235 "gnome-nibbles.vala"
	_tmp41_ = *worm_props;
#line 1235 "gnome-nibbles.vala"
	_tmp42_ = _tmp41_.down;
#line 1235 "gnome-nibbles.vala"
	_tmp43_ = gdk_keyval_name (_tmp42_);
#line 1235 "gnome-nibbles.vala"
	_tmp44_ = g_utf8_strup (_tmp43_, (gssize) -1);
#line 1235 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1235 "gnome-nibbles.vala"
	upper_key = _tmp44_;
#line 1236 "gnome-nibbles.vala"
	_tmp45_ = upper_key;
#line 1236 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp45_, "DOWN") == 0) {
#line 7682 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp46_;
		GtkOverlay* _tmp47_;
		GdkPixbuf* _tmp48_;
		GtkImage* _tmp49_;
		GtkImage* _tmp50_;
		GtkOverlay* _tmp51_;
#line 1238 "gnome-nibbles.vala"
		_tmp46_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 1238 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp46_;
#line 1239 "gnome-nibbles.vala"
		_tmp47_ = self->priv->move_down;
#line 1239 "gnome-nibbles.vala"
		_tmp48_ = rotated_pixbuf;
#line 1239 "gnome-nibbles.vala"
		_tmp49_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp48_);
#line 1239 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp49_);
#line 1239 "gnome-nibbles.vala"
		_tmp50_ = _tmp49_;
#line 1239 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp47_, (GtkWidget*) _tmp50_);
#line 1239 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp50_);
#line 1240 "gnome-nibbles.vala"
		_tmp51_ = self->priv->move_down;
#line 1240 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp51_);
#line 1236 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7714 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
#line 1243 "gnome-nibbles.vala"
		_tmp52_ = self->priv->move_down_label;
#line 1243 "gnome-nibbles.vala"
		_tmp53_ = upper_key;
#line 1243 "gnome-nibbles.vala"
		_tmp54_ = string_to_string (_tmp53_);
#line 1243 "gnome-nibbles.vala"
		_tmp55_ = g_strconcat ("<b>", _tmp54_, "</b>", NULL);
#line 1243 "gnome-nibbles.vala"
		_tmp56_ = _tmp55_;
#line 1243 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp52_, _tmp56_);
#line 1243 "gnome-nibbles.vala"
		_g_free0 (_tmp56_);
#line 7735 "gnome-nibbles.c"
	}
#line 1245 "gnome-nibbles.vala"
	_tmp57_ = *worm_props;
#line 1245 "gnome-nibbles.vala"
	_tmp58_ = _tmp57_.left;
#line 1245 "gnome-nibbles.vala"
	_tmp59_ = gdk_keyval_name (_tmp58_);
#line 1245 "gnome-nibbles.vala"
	_tmp60_ = g_utf8_strup (_tmp59_, (gssize) -1);
#line 1245 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1245 "gnome-nibbles.vala"
	upper_key = _tmp60_;
#line 1246 "gnome-nibbles.vala"
	_tmp61_ = upper_key;
#line 1246 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp61_, "LEFT") == 0) {
#line 7753 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp62_;
		GtkOverlay* _tmp63_;
		GdkPixbuf* _tmp64_;
		GtkImage* _tmp65_;
		GtkImage* _tmp66_;
		GtkOverlay* _tmp67_;
#line 1248 "gnome-nibbles.vala"
		_tmp62_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 1248 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp62_;
#line 1249 "gnome-nibbles.vala"
		_tmp63_ = self->priv->move_left;
#line 1249 "gnome-nibbles.vala"
		_tmp64_ = rotated_pixbuf;
#line 1249 "gnome-nibbles.vala"
		_tmp65_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp64_);
#line 1249 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp65_);
#line 1249 "gnome-nibbles.vala"
		_tmp66_ = _tmp65_;
#line 1249 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp66_);
#line 1249 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp66_);
#line 1250 "gnome-nibbles.vala"
		_tmp67_ = self->priv->move_left;
#line 1250 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp67_);
#line 1246 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7785 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
#line 1253 "gnome-nibbles.vala"
		_tmp68_ = self->priv->move_left_label;
#line 1253 "gnome-nibbles.vala"
		_tmp69_ = upper_key;
#line 1253 "gnome-nibbles.vala"
		_tmp70_ = string_to_string (_tmp69_);
#line 1253 "gnome-nibbles.vala"
		_tmp71_ = g_strconcat ("<b>", _tmp70_, "</b>", NULL);
#line 1253 "gnome-nibbles.vala"
		_tmp72_ = _tmp71_;
#line 1253 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp68_, _tmp72_);
#line 1253 "gnome-nibbles.vala"
		_g_free0 (_tmp72_);
#line 7806 "gnome-nibbles.c"
	}
#line 1255 "gnome-nibbles.vala"
	_tmp73_ = *worm_props;
#line 1255 "gnome-nibbles.vala"
	_tmp74_ = _tmp73_.right;
#line 1255 "gnome-nibbles.vala"
	_tmp75_ = gdk_keyval_name (_tmp74_);
#line 1255 "gnome-nibbles.vala"
	_tmp76_ = g_utf8_strup (_tmp75_, (gssize) -1);
#line 1255 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1255 "gnome-nibbles.vala"
	upper_key = _tmp76_;
#line 1256 "gnome-nibbles.vala"
	_tmp77_ = upper_key;
#line 1256 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp77_, "RIGHT") == 0) {
#line 7824 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp78_;
		GtkOverlay* _tmp79_;
		GdkPixbuf* _tmp80_;
		GtkImage* _tmp81_;
		GtkImage* _tmp82_;
		GtkOverlay* _tmp83_;
#line 1258 "gnome-nibbles.vala"
		_tmp78_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 1258 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp78_;
#line 1259 "gnome-nibbles.vala"
		_tmp79_ = self->priv->move_right;
#line 1259 "gnome-nibbles.vala"
		_tmp80_ = rotated_pixbuf;
#line 1259 "gnome-nibbles.vala"
		_tmp81_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp80_);
#line 1259 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp81_);
#line 1259 "gnome-nibbles.vala"
		_tmp82_ = _tmp81_;
#line 1259 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp79_, (GtkWidget*) _tmp82_);
#line 1259 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp82_);
#line 1260 "gnome-nibbles.vala"
		_tmp83_ = self->priv->move_right;
#line 1260 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp83_);
#line 1256 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7856 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp84_;
		const gchar* _tmp85_;
		const gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
#line 1263 "gnome-nibbles.vala"
		_tmp84_ = self->priv->move_right_label;
#line 1263 "gnome-nibbles.vala"
		_tmp85_ = upper_key;
#line 1263 "gnome-nibbles.vala"
		_tmp86_ = string_to_string (_tmp85_);
#line 1263 "gnome-nibbles.vala"
		_tmp87_ = g_strconcat ("<b>", _tmp86_, "</b>", NULL);
#line 1263 "gnome-nibbles.vala"
		_tmp88_ = _tmp87_;
#line 1263 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp84_, _tmp88_);
#line 1263 "gnome-nibbles.vala"
		_g_free0 (_tmp88_);
#line 7877 "gnome-nibbles.c"
	}
#line 1210 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1210 "gnome-nibbles.vala"
	_g_free0 (player_id);
#line 1210 "gnome-nibbles.vala"
	return self;
#line 7885 "gnome-nibbles.c"
}


ControlsGrid*
controls_grid_new (gint worm_id,
                   WormProperties* worm_props,
                   GdkPixbuf* arrow,
                   GdkPixbuf* arrow_key)
{
#line 1210 "gnome-nibbles.vala"
	return controls_grid_construct (TYPE_CONTROLS_GRID, worm_id, worm_props, arrow, arrow_key);
#line 7897 "gnome-nibbles.c"
}


static void
controls_grid_class_init (ControlsGridClass * klass)
{
#line 1181 "gnome-nibbles.vala"
	controls_grid_parent_class = g_type_class_peek_parent (klass);
#line 1181 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &ControlsGrid_private_offset);
#line 1181 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/controls-grid.ui");
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_label));
#line 7938 "gnome-nibbles.c"
}


static void
controls_grid_instance_init (ControlsGrid * self)
{
#line 1181 "gnome-nibbles.vala"
	self->priv = controls_grid_get_instance_private (self);
#line 1181 "gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 7949 "gnome-nibbles.c"
}


static void
controls_grid_finalize (GObject * obj)
{
	ControlsGrid * self;
#line 1181 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
#line 1184 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->name_label);
#line 1186 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_up);
#line 1188 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_down);
#line 1190 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_left);
#line 1192 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_right);
#line 1194 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_up);
#line 1196 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_up_label);
#line 1198 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_down);
#line 1200 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_down_label);
#line 1202 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_left);
#line 1204 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_left_label);
#line 1206 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_right);
#line 1208 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_right_label);
#line 1181 "gnome-nibbles.vala"
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
#line 7987 "gnome-nibbles.c"
}


GType
controls_grid_get_type (void)
{
	static volatile gsize controls_grid_type_id__volatile = 0;
	if (g_once_init_enter (&controls_grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
		GType controls_grid_type_id;
		controls_grid_type_id = g_type_register_static (gtk_grid_get_type (), "ControlsGrid", &g_define_type_info, 0);
		ControlsGrid_private_offset = g_type_add_instance_private (controls_grid_type_id, sizeof (ControlsGridPrivate));
		g_once_init_leave (&controls_grid_type_id__volatile, controls_grid_type_id);
	}
	return controls_grid_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



