# -*-ruby-*-
#
# Copyright (c) 2004-2005 SASADA Koichi <ko1 at atdot.net>
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's license.
#
#
# $Id$
#

=begin

== Abstract

Add time stamp to each log.


== Configuration
BotConfig = [
{
  :name        => :TimeStampBot,
  :interval    => 60 * 60,       # sec
  :stampformat => '== %y/%m/%d-%H:%M:%S ==========================================',
  :client      => false,
}
]

=end

class TimeStampBot < Nadoka::NDK_Bot
  def bot_initialize
    @interval    = @bot_config.fetch(:interval, 60 * 60) # default: 1 hour
    @stampformat = @bot_config.fetch(:stampformat,
      '== %y/%m/%d-%H:%M:%S ==========================================')
    @client      = @bot_config.fetch(:client, false)
    @nexttime    = nexttime
  end

  def nexttime
    t = (Time.now.to_i + @interval)
    Time.at(t - (t % @interval))
  end
  
  def on_timer tm
    if tm >= @nexttime
      stamp_log
      @nexttime = nexttime
    end
  end
  
  def stamp_log
    msg = @nexttime.strftime(@stampformat)
    @state.channels.each{|ch|
      @logger.clog(ch, msg, true)
    }
    @logger.slog(msg, true) if @client
  end
end


