'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _colors = require('colors');

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function emptyFn() {}

/**
 * Debug module.
 */
/**
 * The MIT License (MIT)
 * Copyright (c) 2015-present Dmitry Soshnikov <dmitry.soshnikov@gmail.com>
 */

var Debug = {
  isEnabled: function isEnabled() {
    return !!global.SYNTAX_DEBUG;
  },
  string: function string(message) {
    return _colors2.default.bold('[DEBUG]') + ' ' + message;
  },
  log: function log(message) {
    console.info(Debug.string(message));
  },
  time: function time(label) {
    console.time(this.string(label));
  },
  timeEnd: function timeEnd(label) {
    console.timeEnd(this.string(label));
  }
};

if (!global.SYNTAX_DEBUG) {
  Object.keys(Debug).forEach(function (method) {
    return Debug[method] = emptyFn;
  });
}

exports.default = Debug;