'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The MIT License (MIT)
 * Copyright (c) 2015-present Dmitry Soshnikov <dmitry.soshnikov@gmail.com>
 */

/**
 * Implementation notes.
 *
 * 1. Extend `LRParserGeneratorDefault`
 * 2. Implement `generateParserData()`
 * 3. Implement all specific to the target language
 *    functionality in the trait file.
 */

/**
 * Base class to extend.
 */
var LRParserGeneratorDefault = require(ROOT + 'lr/lr-parser-generator-default').default;

/**
 * A trait file usually implements some very specific to a target language
 * constructs, and transformations.
 */
var ExampleParserGeneratorTrait = require('../example-parser-generator-trait');

/**
 * Generic template for all LR parsers in the Example language.
 */
var EXAMPLE_LR_PARSER_TEMPLATE = _fs2.default.readFileSync(__dirname + '/../templates/lr.template.example', 'utf-8');

/**
 * LR parser generator for Example language.
 */

var LRParserGeneratorExample = function (_LRParserGeneratorDef) {
  _inherits(LRParserGeneratorExample, _LRParserGeneratorDef);

  /**
   * Instance constructor.
   */
  function LRParserGeneratorExample(_ref) {
    var _this;

    var grammar = _ref.grammar,
        outputFile = _ref.outputFile,
        _ref$options = _ref.options,
        options = _ref$options === undefined ? {} : _ref$options;

    _classCallCheck(this, LRParserGeneratorExample);

    (_this = _possibleConstructorReturn(this, (LRParserGeneratorExample.__proto__ || Object.getPrototypeOf(LRParserGeneratorExample)).call(this, { grammar: grammar, outputFile: outputFile, options: options })), _this).setTemplate(EXAMPLE_LR_PARSER_TEMPLATE);

    /**
     * Contains the lexical rule handlers: _lexRule1, _lexRule2, etc.
     * It's populated by the trait file.
     */
    _this._lexHandlers = [];

    /**
     * Contains production handlers: _handler1, _handler2, etc.
     * It's populated by the trait file.
     */
    _this._productionHandlers = [];

    /**
     * Actual class name of your parser. Here we infer from the output filename.
     */
    _this._parserClassName = _path2.default.basename(outputFile, _path2.default.extname(outputFile));

    /**
     * The trait provides methods for lex and production handlers, as well
     * as some very specific code generation for the target language.
     */
    Object.assign(_this, ExampleParserGeneratorTrait);
    return _this;
  }

  /**
   * Generates parser code.
   */


  _createClass(LRParserGeneratorExample, [{
    key: 'generateParserData',
    value: function generateParserData() {
      _get(LRParserGeneratorExample.prototype.__proto__ || Object.getPrototypeOf(LRParserGeneratorExample.prototype), 'generateParserData', this).call(this);
      this.generateLexHandlers();
      this.generateProductionHandlers();
      this.generateParserClassName(this._parserClassName);
    }
  }]);

  return LRParserGeneratorExample;
}(LRParserGeneratorDefault);

exports.default = LRParserGeneratorExample;
;