use Test::More;

my $pwd = `pwd`;
@tests = (
    'lib/*.js'    => 'index.js'           => 0,
    'lib/*.js'    => 'lib/index.js'       => 1,
    'lib/*.js'    => 'lib/a/index.js'     => 0,
    'lib/**/*.js' => 'index.js'           => 0,
    'lib/**/*.js' => 'lib/index.js'       => 1,
    'lib/**/*.js' => 'lib/index.ts'       => 0,
    'lib/**/*.js' => 'lib/a/index.js'     => 1,
    'lib/**/*.js' => 'lib/a/b/c/index.js' => 1,
    'lib/**/*.js' => 'lib/a/b/c/index.ts' => 0,
    'lib/**/*'    => 'index.js'           => 0,
    'lib/**/*'    => 'lib/index'          => 1,

    # NB: "./" is added here since this is the behavior of nodejs.pm
    '**/*' => './index.js'     => 1,
    '**/*' => './lib/index.js' => 1,
);

plan tests => @tests / 3 + 2;

if ( $ENV{PKG_TEST_LOCAL} ) {
    require_ok('./dh_nodejs/Buildsystem/nodejs.pm');
}
else {
    use_ok('Debian::Debhelper::Buildsystem::nodejs');
}

my $self;
ok( $self = Debian::Debhelper::Buildsystem::nodejs->new, 'New object' );

while (@tests) {
    my $expr   = shift @tests;
    my $file   = shift @tests;
    my $expect = shift @tests;
    ptest( $expr, $file, $expect );
}

sub ptest {
    my ( $expr, $file, $expect ) = @_;
    my ( $p, $pattern ) = $self->pattern($expr);
    ok(
        ( ( $file =~ $pattern and $file =~ /^$p/ ) xor !$expect ),
        "File $file " . ( $expect ? 'accepted' : 'rejected' ) . " by $expr"
    );
}
