use Test::More tests => 16;
use Dpkg::IPC;

my $pwd = `pwd`;
chdir "test/submodules";
if ( $ENV{PKG_TEST_LOCAL} ) {
    $ENV{PERL5LIB} = '..';
}

# Configure step
spawn( exec => [ 'dh_auto_configure', '--buildsystem=nodejs' ], wait_child => 1 );
ok( ! -l 'node_modules/comp-one', 'comp-one/nolink');
ok( -l 'node_modules/comp_two', 'Main link');
ok( -l 'node_modules/comp-three', 'Main link');
ok( -l 'comp-three/node_modules/comp_two', 'component_links');
spawn( exec => [ 'dh_auto_test', '--buildsystem=nodejs' ], wait_child => 1 );
ok( -e 'foo', 'File "foo" created' ) or diag `ls -l`;
unlink('foo');
spawn( exec => [ 'dh_auto_install', '--buildsystem=nodejs' ], wait_child => 1 );
foreach (
    qw(
    debian/foo/usr/share/nodejs/foo/package.json
    debian/foo/usr/share/nodejs/foo/index.js
    debian/foo/usr/share/nodejs/foo/node_modules/comp-one/package.json
    debian/foo/usr/share/nodejs/foo/node_modules/comp-one/index.js
    debian/foo/usr/share/nodejs/foo/node_modules/comp_two/package.json
    debian/foo/usr/share/nodejs/foo/node_modules/comp_two/index.js
    debian/foo/usr/share/nodejs/foo/node_modules/comp-three/index.js
    debian/foo/usr/share/nodejs/foo/node_modules/comp-three/package.json
    debian/foo/usr/share/nodejs/foo/node_modules/comp-three/test.js
    )
  )
{
    ok( -f $_, "$_ installed" );
}
foreach (
    qw(
    debian/foo/usr/share/nodejs/foo/node_modules/comp-one/test.js
    debian/foo/usr/share/nodejs/foo/node_modules/comp_two/tests.js
    )
  )
{
    ok( !-f $_, "$_ not installed" );
}
spawn( exec => [ 'dh_auto_clean', '--buildsystem=nodejs' ], wait_child => 1 );
spawn( exec => ['dh_clean'], wait_child => 1 );
chdir $pwd;
