# pkg-js-tools

pkg-js-tools is a collection of tools to aid packaging Node modules in Debian.

## Working with salsa.debian.org repository

To use salsa(1) with pkg-javascript configuration, add something like that in
your .bashrc:

    alias js-salsa='salsa --conf-file +/usr/share/pkg-js-tools/pkg-js-salsa.conf'

Then you can use salsa simply. Some examples:

* if you created a local repo and want to create and push it on
https://salsa.debian.org/js-team, launch simply:

    js-salsa push_repo .

* to configure a repo already pushed:

    js-salsa update_safe node-foobar

* to clone locally a js-team package:

    js-salsa co node-foobar

See salsa(1) for more.

## Debhelper addon

pkg-js-tools provides:
 * **dh\_auto\_configuration** for embedded components: it automatically
   creates links in `node_modules/` directory and removes them during clean
 * **dh\_auto\_install**: automatic install (0.8.4)
   * **main module**: if no debian/install exists, pkg-js-tools will read
     package.json#files field to install files. If not, it install all files
     except \*.md, doc\*, example\*, test\*. **If install is not good**, use
     `debian/nodejs/files` to fix the list. Files are installed following
     "Architecture" field in `/usr/share/nodejs` or `/usr/lib/<gnu-arch>/nodejs`
   * **components**: pkg-js-tools does the same for each component in
     `<module/path>/node_modules/<component-package-name>`. To restrict this
     behavior, write a `debian/nodejs/submodules` and list the components to
     install. An empty `debian/nodejs/submodules` installs no component.
 * **dh\_auto\_test**: launch test written in `debian/tests/pkg-js/test`
   _(using `sh -e`)_. If you use pkg-js-autopkgtest, you can also use the same
   test during build.

Files _(use component name, not module name here if different)_:
 * **debian/nodejs/submodules** lists components to install _(all if missing)_
 * **debian/nodejs/files** overwrites `package.json#files` field.
 * **debian/nodejs/\<component-name\>/files** overwrites `package.json#files`
   field. An empty file avoid any install
 * **debian/nodejs/install** overwrite **debian/nodejs/files**: same usage as
   debian/install except that destination not starting with `/` are related to
   arch path _(`/usr/share/nodejs` or `/usr/lib/<gnu-arch>/nodejs`)_
 * **debian/nodejs/\<component-name\>/install** same as **debian/nodejs/install**
   for components
 * **debian/nodejs/component\_links** lists needed links between components:
   links `../../component-src` in `component-dst/node_modules/component-src-name`
 * **debian/nodejs/\<component-name\>/nolink** avoid node\_modules links creation
   for this component _(configuration step)_

> To install a component in another directory set its files in
**debian/install**:

Example:

* debian/control

```
...
Testsuite: autopkgtest-nodejs
Build-Depends: pkg-js-tools
...
```

* debian/rules

```
#!/usr/bin/make -f
# -*- makefile -*-

%:
        dh $@ --with nodejs
```

* debian/tests/pkg-js/test

```shell
mocha -R spec
```

See also [pkg-js-autopkgtest README](../autopkgtest/README.md).

### Multiple binary packages

When `debiancontrol` provides more than one binary package, `dh_auto_install`
populates a `debian/tmp` and `dh_install` install files in each package. In
this case, you must write a `debian/<package>.install` for each binary
package. Each line with only one argument is related to `debian/tmp`.
Examples:

 * debian/node-arch-indep.install: pick files from `debian/tmp`
```
usr/share/nodejs/foo/
```
 * debian/node-arch-dep.install: pick files from `debian/tmp`
```
usr/lib/*/nodejs/foo/
```
 * debian/libjs.install: pick files from sources
```
  dist/* usr/share/javascript/foo/
```

### Links

Since path is not fixed for arch-dependent package, you must write
`debian/links` using a `*`:
```
# debian/node.foo.links
/usr/lib/*/nodejs/foo/bin/cli.js  /usr/bin/foo
```

## Other tools

* github-debian-upstream: launch it in source repo to create a
  debian/upstream/metadata _(works only if upstream repo is on GitHub)_
* nodepath: show the path of a node module (npm name). You can use `-p` to show
  also the Debian package. Option `-o` shows only Debian package name.
