.TH TEX 1 "21 August 2004" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP for troff
.el .ds OX TeX for nroff
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\" EX and EE are used for displays that are pure code
.de EX
.nf
.ft CW
..
.de EE
.ft R
.fi
..
.\"=====================================================================
.SH NAME
tex, virtex, initex \- text formatting and typesetting
.SH SYNOPSIS
.B tex
.RI [ options ]
[\fB&\fR \fIformat\fR ]
[ \fIfile\fR | \fB\e\fR \fIcommands\fR ]
.\"=====================================================================
.SH DESCRIPTION
Run the \*(TX typesetter on
.IR file ,
usually creating
.IR file.dvi .
If the file argument has no extension, ".tex" will be appended to it. 
Instead of a filename, a set of \*(TX commands can be given, the first
of which must start with a backslash.
With a 
.BI & format
argument \*(TX uses a different set of precompiled commands,
contained in
.IR format.fmt ;
it is usually better to use the
.B -fmt
.I format
option instead.
.PP
\*(TX
formats the interspersed text and commands contained in the named
files
and outputs a typesetter independent file (called
.IR DVI ,
which is short for
.IR "DeVice Independent" ).
\*(TX's capabilities and language are described in
.IR "The \*(OXbook" .
\*(TX
is normally used with a large body of precompiled macros,
and there are several specific formatting systems, such as
\*(LX,
which require the support of several macro files.
.PP
This version of \*(TX looks at its command line to see what name it
was called under.  If they exist, then both
.B initex
and
.B virtex
are symbolic links to the
.B tex
executable.  When called as
.BR initex
(or when the
.B -ini
option is given) it can be used to precompile macros into a
.I .fmt
file.  When called as
.B virtex
it will use the
.I plain
format.  When called under any other name, \*(TX will use that name as
the name of the format to use.  For example, when called as
.B tex
the
.I tex
format is used, which is identical to the
.I plain
format.  The commands defined by the
.I plain
format are documented in
.IR "The \*(OXbook" .
Other formats that are often available include
.I latex
and
.IR amstex .
.PP
The non-option command line arguments to the
\*(TX
program are passed to it as the first input line.  (But it is often
easier to type extended arguments as the first input line, since UNIX
shells tend to gobble up or misinterpret \*(TX's favorite symbols,
like backslashes, unless you quote them.)
As described in
.IR "The \*(OXbook" ,
that first line should begin with a filename, a
.IR \econtrolsequence ,
or a
.IR &formatname .
.PP
The normal usage is to say
.EX
tex paper
.EE
to start processing
.IR paper.tex .
The name
.I paper
will be the ``jobname'', and is used in forming
output filenames.
If \*(TX doesn't get a filename in the first line, the jobname is
.IR texput .
When looking for a file, \*(TX looks for the name with and without the
default extension
.RI ( .tex )
appended, unless the name already contains that extension.  If
.I paper
is the ``jobname'',
a log of error messages, with rather more detail than normally appears
on the screen, will appear in
.IR paper.log ,
and the output file will be in
.IR paper.dvi .
.PP
This version of \*(TX can look in the first line of the file
.I paper.tex
to see if it begins with the magic sequence
.IR %& .
If the first line begins with
.BI %& format
.BI -translate-file \ tcxname
then \*(TX will use the named format and transation table
.I tcxname
to process the source file.  Either the format name or the
.B -translate-file
specification may be omitted, but not both.  This overrides the
format selection based on the name by which the program is invoked.
The
.B -parse-first-line
option or the
.B parse_first_line
configuration variable controls whether this behaviour is enabled.
.PP
The
.I e
response to \*(TX's error prompt causes the system default editor to
start up at the current line of the current file.  The environment
variable TEXEDIT can be used to change the editor used.  It may
contain a string with "%s" indicating where the filename goes and "%d"
indicating where the decimal line number (if any) goes.  For example,
a TEXEDIT string for
.B emacs
can be set with the
.B sh
command
.EX
\fITEXEDIT="emacs +%d %s"; export TEXEDIT\fP
.EE
.PP
A convenient file in the library is
.IR null.tex ,
containing nothing.
When \*(TX can't find a file it thinks you want to input, it keeps
asking you for another filename; responding `null' gets you out
of the loop if you don't want to input anything.  You can also type your
EOF character (usually control-D).
.PP
.\"=====================================================================
.SH OPTIONS
This version of \*(TX understands the following command line options.
.TP
.B -enc
.rb
Enable the enc\*(TX extensions.  This option is only effective in
combination with
.BR -ini .
For documentation of the enc\*(TX extensions see
.BR http://www.olsak.net/enctex.html .
.TP
.B -file-line-error
.rb
Print error messages in the form
.I file:line:error
which is similar to the way many compilers format them.
.TP
.B -no-file-line-error
.rb
Disable printing error messages in the
.I file:line:error
style.
.TP
.B -file-line-error-style
.rb
This is the old name of the
.B -file-line-error
option.
.TP
.BI -fmt \ format
.rb
Use
.I format
as the name of the format to be used, instead of the name by which
\*(TX was called or a
.I %&
line.
.TP
.B -halt-on-error
.rb
Exit with an error code when an error is encountered during processing.
.TP
.B -help
.rb
Print help message and exit.
.TP
.B -ini
.rb
Start in
.I INI
mode, which is used to dump formats.  The
.I INI
mode can be used for typesetting, but no format is preloaded, and
basic initializations like setting catcodes may be required.
.TP
.BI -interaction \ mode
.rb
Sets the interaction mode.  The mode can be either
.IR batchmode ,
.IR nonstopmode ,
.IR scrollmode ,
and
.IR errorstopmode .
The meaning of these modes is the same as that of the corresponding
\ecommands.
.TP
.B -ipc
.rb
Send DVI output to a socket as well as the usual output file.  Whether
this option is available is the choice of the installer.
.TP
.B -ipc-start
.rb
As
.BR -ipc ,
and starts the server at the other end as well.  Whether this option
is available is the choice of the installer.
.TP
.BI -jobname \ name
.rb
Use
.I name
for the job name, instead of deriving it from the name of the input file.
.TP
.BI -kpathsea-debug \ bitmask
.rb
Sets path searching debugging flags according to the bitmask.  See the
.I Kpathsea
manual for details.
.TP
.BI -mktex \ fmt
.rb
Enable
.RI mktex fmt ,
where
.I fmt
must be either
.I tex
or
.IR tfm .
.TP
.B -mltex
.rb
Enable ML\*(TX extensions.  Only effective in combination with
.BR -ini .
.TP
.BI -no-mktex \ fmt
.rb
Disable
.RI mktex fmt ,
where
.I fmt
must be either
.I tex
or
.IR tfm .
.TP
.BI -output-comment \ string
.rb
Use
.I string
for the
.I DVI
file comment instead of the date.
.TP
.BI -output-directory \ directory
.rb Write output files in
.I directory
instead of the current directory.  Look up input files in
.I directory
first, the along the normal search path.
.TP
.B -parse-first-line
.rb
If the first line of the main input file begins with
.I %&
parse it to look for a dump name or a
.B -translate-file
option.
.TP
.B -no-parse-first-line
.rb
Disable parsing of the first line of the main input file.
.TP
.BI -progname \ name
.rb
Pretend to be program
.IR name .
This affects both the format used and the search paths.
.TP
.B -recorder
.rb
Enable the filename recorder.  This leaves a trace of the files opened
for input and output in a file with extension
.IR .fls .
.TP
.B -shell-escape
.rb
Enable the
.BI \ewrite18{ command }
construct.  The
.I command
can be any shell command.  This construct is normally
disallowed for security reasons.
.TP
.B -no-shell-escape
.rb
Disable the
.BI \ewrite18{ command }
construct, even if it is enabled in the
.I texmf.cnf
file.
.TP
.B -src-specials
.rb
Insert source specials into the
.I DVI
file.
.TP
.BI -src-specials \ where
.rb
Insert source specials in certain places of the
.I DVI
file.
.I where
is a comma-separated value list:
.IR cr ,
.IR display ,
.IR hbox ,
.IR math ,
.IR par ,
.IR parent ,
or
.IR vbox .
.TP
.BI -translate-file \ tcxname
.rb
Use the
.I tcxname
translation table to set the mapping of input characters and
re-mapping of output characters.
.TP
.BI -default-translate-file \ tcxname
.rb
Like
.B -translate-file
except that a
.I %&
line can overrule this setting.
.TP
.B -version
.rb
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
See the Kpathsearch library documentation (the `Path specifications'
node) for precise details of how the environment variables are used.
The
.B kpsewhich
utility can be used to query the values of the variables.
.PP
One caveat: In most \*(TX formats, you cannot use ~ in a filename you
give directly to \*(TX, because ~ is an active character, and hence is
expanded, not taken as part of the filename.  Other programs, such as
\*(MF, do not have this problem.
.PP
.TP
TEXMFOUTPUT
Normally, \*(TX puts its output files in the current directory.  If
any output file cannot be opened there, it tries to open it in the
directory specified in the environment variable TEXMFOUTPUT.
There is no default value for that variable.  For example, if you say
.I tex paper
and the current directory is not writable, if TEXMFOUTPUT has
the value
.IR /tmp ,
\*(TX attempts to create
.I /tmp/paper.log
(and
.IR /tmp/paper.dvi ,
if any output is produced.)
.TP
TEXINPUTS
Search path for
.I \einput
and
.I \eopenin
files.
This should probably start with ``.'', so
that user files are found before system files.  An empty path
component will be replaced with the paths defined in the
.I texmf.cnf
file.  For example, set TEXINPUTS to ".:/home/usr/tex:" to prepend the
current direcory and ``/home/user/tex'' to the standard search path.
.TP
TEXFORMATS
Search path for format files.
.TP
TEXPOOL
search path for
.B tex
internal strings.
.TP
TEXEDIT
Command template for switching to editor.  The default, usually
.BR vi ,
is set when \*(TX is compiled.
.TP
TFMFONTS
Search path for font metric
.RI ( .tfm )
files.
.\"=====================================================================
.SH FILES
The location of the files mentioned below varies from system to
system.  Use the
.B kpsewhich
utility to find their locations.
.TP
.I texmf.cnf
Configuration file.  This contains definitions of search paths as well
as other configuration parameters like
.BR parse_first_line .
.TP
.I tex.pool
Text file containing \*(TX's internal strings.
.TP
.I texfonts.map
Filename mapping definitions.
.TP
.I *.tfm
Metric files for \*(TX's fonts.
.TP
.I *.fmt
Predigested \*(TX format (.\|fmt) files.
.TP
.I $TEXMFMAIN/tex/plain/base/plain.tex
The basic macro package described in the \*(OXbook.
.br
.\"=====================================================================
.SH NOTES
This manual page is not meant to be exhaustive.  The complete
documentation for this version of \*(TX can be found in the info manual
.IR "Web2C: A TeX implementation" .
.\"=====================================================================
.SH BUGS
This version of \*(TX implements a number of optional extensions.
In fact, many of these extensions conflict to a greater or lesser
extent with the definition of \*(TX.  When such extensions are
enabled, the banner printed when \*(TX starts is changed to print
.B TeXk
instead of
.BR TeX .
.PP
This version of \*(TX fails to trap arithmetic overflow when
dimensions are added or subtracted.  Cases where this occurs are rare,
but when it does the generated
.I DVI
file will be invalid.
.\"=====================================================================
.SH "SEE ALSO"
.BR mf (1),
.br
Donald E. Knuth,
.IR "The \*(OXbook" ,
Addison-Wesley, 1986, ISBN 0-201-13447-0.
.br
Leslie Lamport,
.IR "\*(LX \- A Document Preparation System" ,
Addison-Wesley, 1985, ISBN 0-201-15790-X.
.br
K. Berry,
.IR "Eplain: Expanded plain \*(TX" ,
ftp://ftp.cs.umb.edu/pub/tex/eplain/doc.
.br
Michael Spivak,
.IR "The Joy of \*(OX" ,
2nd edition, Addison-Wesley, 1990, ISBN 0-8218-2997-1.
.br
.I TUGboat
(the journal of the \*(TX Users Group).
.\"=====================================================================
.SH TRIVIA
\*(TX, pronounced properly, rhymes with ``blecchhh.''  The proper
spelling in typewriter-like fonts is ``TeX'' and not ``TEX'' or ``tex.''
.\"=====================================================================
.SH AUTHORS
\*(TX was designed by Donald E. Knuth,
who implemented it using his \*(WB system for Pascal programs.
It was ported to Unix at Stanford by Howard Trickey, and
at Cornell by Pavel Curtis.
The version now offered with the Unix \*(TX distribution is that
generated by the \*(WB to C system
.RB ( web2c ),
originally written by Tomas Rokicki and Tim Morgan.
.PP
The enc\*(TX extensions were written by Petr Olsak.
