
##############################################################################
#
# Copyright (c) 2003-2018 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2018 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
some benchmarks for tetsing the finley solver.

:var __author__: name of author
:var __licence__: licence agreement
var __url__: url entry point on documentation
:var __version__: version
:var __date__: date of the version
"""

__author__="Lutz Gross, l.gross@uq.edu.au"

from esys.escript.benchmark import BenchmarkSuite,Benchmark
# from esys.finley.finleybench import *
from finleybench import *

type="all" 
type="mantle"
type="simple"

thlist=[1,2,4,8,16]
# thlist=[1,2,4,8,16,32]
# thlist=[1,2,4,8,16,32,64,128]
# thlist=[1,2,4,8,16,32,64,128]
show=True
ff=FinleyFilter()

opt1=FinleyOptions(solver_method=SolverOptions.PCG,preconditioner=SolverOptions.JACOBI,verbose=show)
opt2=FinleyOptions(solver_method=SolverOptions.PCG,preconditioner=SolverOptions.ILU0,verbose=show)
opt3=FinleyOptions(solver_method=SolverOptions.PCG,preconditioner=SolverOptions.RILU,verbose=show)
opt4=FinleyOptions(solver_method=SolverOptions.DIRECT,verbose=show)
ops=(opt1,opt3,opt4)
ops=(opt1,opt3)

bm_L2Do1=Benchmark(name="Laplace 2D (order 1)")
bm_L2Do1.addProblem(Laplace2DOrder1_30k())
bm_L2Do1.addProblem(Laplace2DOrder1_60k())
bm_L2Do1.addProblem(Laplace2DOrder1_120k())
bm_L2Do1.addProblem(Laplace2DOrder1_240k())
bm_L2Do1.addProblem(Laplace2DOrder1_480k())
bm_L2Do1.addProblem(Laplace2DOrder1_960k())
bm_L2Do1.addProblem(Laplace2DOrder1_1920k())
bm_L2Do1.addProblem(Laplace2DOrder1_3840k())
bm_L2Do1.addProblem(Laplace2DOrder1_7680k())
bm_L2Do1.addProblem(Laplace2DOrder1_15360k())
map(bm_L2Do1.addOptions,ops)

bm_L2Do2=Benchmark("Laplace 2D (order 2)")
bm_L2Do2.addProblem(Laplace2DOrder2_30k())
bm_L2Do2.addProblem(Laplace2DOrder2_60k())
bm_L2Do2.addProblem(Laplace2DOrder2_120k())
bm_L2Do2.addProblem(Laplace2DOrder2_240k())
bm_L2Do2.addProblem(Laplace2DOrder2_480k())
bm_L2Do2.addProblem(Laplace2DOrder2_960k())
bm_L2Do2.addProblem(Laplace2DOrder2_1920k())
bm_L2Do2.addProblem(Laplace2DOrder2_3840k())
bm_L2Do2.addProblem(Laplace2DOrder2_7680k())
bm_L2Do2.addProblem(Laplace2DOrder2_15360k())
map(bm_L2Do2.addOptions,ops)

bm_L3Do1=Benchmark("Laplace 3D (order 1)")
bm_L3Do1.addProblem(Laplace3DOrder1_30k())
bm_L3Do1.addProblem(Laplace3DOrder1_60k())
bm_L3Do1.addProblem(Laplace3DOrder1_120k())
bm_L3Do1.addProblem(Laplace3DOrder1_240k())
bm_L3Do1.addProblem(Laplace3DOrder1_480k())
bm_L3Do1.addProblem(Laplace3DOrder1_960k())
bm_L3Do1.addProblem(Laplace3DOrder1_1920k())
bm_L3Do1.addProblem(Laplace3DOrder1_3840k())
bm_L3Do1.addProblem(Laplace3DOrder1_7680k())
bm_L3Do1.addProblem(Laplace3DOrder1_15360k())
map(bm_L3Do1.addOptions,ops)

bm_L3Do2=Benchmark("Laplace 3D (order 2)")
bm_L3Do2.addProblem(Laplace3DOrder2_30k())
bm_L3Do2.addProblem(Laplace3DOrder2_60k())
bm_L3Do2.addProblem(Laplace3DOrder2_120k())
bm_L3Do2.addProblem(Laplace3DOrder2_240k())
bm_L3Do2.addProblem(Laplace3DOrder2_480k())
bm_L3Do2.addProblem(Laplace3DOrder2_960k())
bm_L3Do2.addProblem(Laplace3DOrder2_1920k())
bm_L3Do2.addProblem(Laplace3DOrder2_3840k())
bm_L3Do2.addProblem(Laplace3DOrder2_7680k())
bm_L3Do2.addProblem(Laplace3DOrder2_15360k())
map(bm_L3Do2.addOptions,ops)

bm_A2Do1g30=Benchmark("Anisotropic 2D (gamma=30, order=1)")
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_30k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_60k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_120k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_240k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_480k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_960k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_1920k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_3840k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_7680k())
bm_A2Do1g30.addProblem(Anisotropic2DOrder1Gamma30_15360k())
map(bm_A2Do1g30.addOptions,ops)

bm_A2Do1g45=Benchmark("Anisotropic 2D (gamma=45, order=1)")
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_30k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_60k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_120k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_240k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_480k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_960k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_1920k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_3840k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_7680k())
bm_A2Do1g45.addProblem(Anisotropic2DOrder1Gamma45_15360k())
map(bm_A2Do1g45.addOptions,ops)

bm_A2Do2g30=Benchmark("Anisotropic 2D (gamma=30, order=2)")
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_30k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_60k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_120k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_240k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_480k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_960k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_1920k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_3840k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_7680k())
bm_A2Do2g30.addProblem(Anisotropic2DOrder2Gamma30_15360k())
map(bm_A2Do2g30.addOptions,ops)


bm_A2Do2g45=Benchmark("Anisotropic 2D (gamma=45, order=2)")
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_30k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_60k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_120k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_240k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_480k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_960k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_1920k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_3840k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_7680k())
bm_A2Do2g45.addProblem(Anisotropic2DOrder2Gamma45_15360k())
map(bm_A2Do2g45.addOptions,ops)


bm_A3Do1g30=Benchmark("Anisotropic 3D (gamma=30, order=1)")
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_30k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_60k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_120k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_240k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_480k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_960k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_1920k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_3840k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_7680k())
bm_A3Do1g30.addProblem(Anisotropic3DOrder1Gamma30_15360k())
map(bm_A3Do1g30.addOptions,ops)

bm_A3Do1g45=Benchmark("Anisotropic 3D (gamma=45, order=1)")
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_30k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_60k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_120k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_240k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_480k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_960k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_1920k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_3840k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_7680k())
bm_A3Do1g45.addProblem(Anisotropic3DOrder1Gamma45_15360k())
map(bm_A3Do1g45.addOptions,ops)

bm_A3Do2g30=Benchmark("Anisotropic 3D (gamma=30, order=2)")
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_30k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_60k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_120k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_240k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_480k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_960k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_1920k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_3840k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_7680k())
bm_A3Do2g30.addProblem(Anisotropic3DOrder2Gamma30_15360k())
map(bm_A3Do2g30.addOptions,ops)

bm_A3Do2g45=Benchmark("Anisotropic 3D (gamma=45, order=2)")
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_30k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_60k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_120k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_240k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_480k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_960k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_1920k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_3840k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_7680k())
bm_A3Do2g45.addProblem(Anisotropic3DOrder2Gamma45_15360k())
map(bm_A3Do2g45.addOptions,ops)

bm_LA2D_o1=Benchmark(name="Lame 2D (order 1)")
bm_LA2D_o1.addProblem(Lame2DOrder1_30k())
bm_LA2D_o1.addProblem(Lame2DOrder1_60k())
bm_LA2D_o1.addProblem(Lame2DOrder1_120k())
bm_LA2D_o1.addProblem(Lame2DOrder1_240k())
bm_LA2D_o1.addProblem(Lame2DOrder1_480k())
bm_LA2D_o1.addProblem(Lame2DOrder1_960k())
bm_LA2D_o1.addProblem(Lame2DOrder1_1920k())
bm_LA2D_o1.addProblem(Lame2DOrder1_3840k())
bm_LA2D_o1.addProblem(Lame2DOrder1_7680k())
bm_LA2D_o1.addProblem(Lame2DOrder1_15360k())
map(bm_LA2D_o1.addOptions,ops)

bm_LA2D_o1_pen100=Benchmark(name="Lame 2D (order 1,  penalty 100)")
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_30k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_60k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_120k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_240k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_480k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_960k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_1920k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_3840k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_7680k())
bm_LA2D_o1_pen100.addProblem(Lame2DOrder1Alpha100_15360k())
map(bm_LA2D_o1_pen100.addOptions,ops)

bm_LA2D_o1_c2=Benchmark(name="Lame 2D (order 1, contrast 1e2)")
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_30k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_60k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_120k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_240k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_480k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_960k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_1920k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_3840k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_7680k())
bm_LA2D_o1_c2.addProblem(InhomgeneousLame2DOrder1JumpE2_15360k())
map(bm_LA2D_o1_c2.addOptions,ops)

bm_LA2D_o1_pen100_c2=Benchmark(name="Lame 2D (order 1,  penalty 100, contrast 1e2)")
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_30k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_60k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_120k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_240k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_480k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_960k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_1920k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_3840k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_7680k())
bm_LA2D_o1_pen100_c2.addProblem(InhomgeneousLame2DOrder1JumpE2Alpha100_15360k())
map(bm_LA2D_o1_pen100_c2.addOptions,ops)

bm_LA2D_o1_c6=Benchmark(name="Lame 2D (order 1, contrast 1e6)")
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_30k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_60k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_120k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_240k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_480k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_960k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_1920k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_3840k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_7680k())
bm_LA2D_o1_c6.addProblem(InhomgeneousLame2DOrder1JumpE6_15360k())
map(bm_LA2D_o1_c6.addOptions,ops)

bm_LA2D_o1_pen100_c6=Benchmark(name="Lame 2D (order 1,  penalty 100, contrast 1e6)")
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_30k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_60k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_120k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_240k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_480k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_960k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_1920k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_3840k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_7680k())
bm_LA2D_o1_pen100_c6.addProblem(InhomgeneousLame2DOrder1JumpE6Alpha100_15360k())
map(bm_LA2D_o1_pen100_c6.addOptions,ops)

bm_LA2D_o1_c2_n45=Benchmark(name="Lame 2D (order 1, contrast 1e2, normal 45deg)")
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_30k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_60k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_120k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_240k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_480k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_960k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_1920k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_3840k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_7680k())
bm_LA2D_o1_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45_15360k())
map(bm_LA2D_o1_c2_n45.addOptions,ops)

bm_LA2D_o1_pen100_c2_n45=Benchmark(name="Lame 2D (order 1,  penalty 100, contrast 1e2, normal 45deg)")
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_30k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_60k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_120k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_240k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_480k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_960k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_1920k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_3840k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_7680k())
bm_LA2D_o1_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder1JumpE2Normal45Alpha100_15360k())
map(bm_LA2D_o1_pen100_c2_n45.addOptions,ops)

bm_LA2D_o1_c6_n45=Benchmark(name="Lame 2D (order 1, contrast 1e6, normal 45deg)")
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_30k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_60k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_120k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_240k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_480k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_960k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_1920k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_3840k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_7680k())
bm_LA2D_o1_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45_15360k())
map(bm_LA2D_o1_c6_n45.addOptions,ops)

bm_LA2D_o1_pen100_c6_n45=Benchmark(name="Lame 2D (order 1,  penalty 100, contrast 1e6, normal 45deg)")
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_30k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_60k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_120k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_240k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_480k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_960k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_1920k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_3840k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_7680k())
bm_LA2D_o1_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder1JumpE6Normal45Alpha100_15360k())
map(bm_LA2D_o1_pen100_c6_n45.addOptions,ops)

bm_LA2D_o2=Benchmark(name="Lame 2D (order 2)")
bm_LA2D_o2.addProblem(Lame2DOrder2_30k())
bm_LA2D_o2.addProblem(Lame2DOrder2_60k())
bm_LA2D_o2.addProblem(Lame2DOrder2_120k())
bm_LA2D_o2.addProblem(Lame2DOrder2_240k())
bm_LA2D_o2.addProblem(Lame2DOrder2_480k())
bm_LA2D_o2.addProblem(Lame2DOrder2_960k())
bm_LA2D_o2.addProblem(Lame2DOrder2_1920k())
bm_LA2D_o2.addProblem(Lame2DOrder2_3840k())
bm_LA2D_o2.addProblem(Lame2DOrder2_7680k())
bm_LA2D_o2.addProblem(Lame2DOrder2_15360k())
map(bm_LA2D_o2.addOptions,ops)

bm_LA2D_o2_pen100=Benchmark(name="Lame 2D (order 2,  penalty 100)")
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_30k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_60k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_120k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_240k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_480k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_960k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_1920k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_3840k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_7680k())
bm_LA2D_o2_pen100.addProblem(Lame2DOrder2Alpha100_15360k())
map(bm_LA2D_o2_pen100.addOptions,ops)

bm_LA2D_o2_c2=Benchmark(name="Lame 2D (order 2, contrast 1e2)")
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_30k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_60k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_120k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_240k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_480k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_960k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_1920k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_3840k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_7680k())
bm_LA2D_o2_c2.addProblem(InhomgeneousLame2DOrder2JumpE2_15360k())
map(bm_LA2D_o2_c2.addOptions,ops)

bm_LA2D_o2_pen100_c2=Benchmark(name="Lame 2D (order 2, penalty 100, contrast 1e2)")
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_30k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_60k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_120k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_240k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_480k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_960k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_1920k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_3840k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_7680k())
bm_LA2D_o2_pen100_c2.addProblem(InhomgeneousLame2DOrder2JumpE2Alpha100_15360k())
map(bm_LA2D_o2_pen100_c2.addOptions,ops)

bm_LA2D_o2_c6=Benchmark(name="Lame 2D (order 2, contrast 1e6)")
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_30k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_60k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_120k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_240k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_480k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_960k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_1920k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_3840k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_7680k())
bm_LA2D_o2_c6.addProblem(InhomgeneousLame2DOrder2JumpE6_15360k())
map(bm_LA2D_o2_c6.addOptions,ops)

bm_LA2D_o2_pen100_c6=Benchmark(name="Lame 2D (order 2,  penalty 100, contrast 1e6)")
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_30k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_60k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_120k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_240k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_480k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_960k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_1920k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_3840k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_7680k())
bm_LA2D_o2_pen100_c6.addProblem(InhomgeneousLame2DOrder2JumpE6Alpha100_15360k())
map(bm_LA2D_o2_pen100_c6.addOptions,ops)

bm_LA2D_o2_c2_n45=Benchmark(name="Lame 2D (order 2, contrast 1e2, normal 45deg)")
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_30k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_60k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_120k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_240k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_480k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_960k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_1920k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_3840k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_7680k())
bm_LA2D_o2_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45_15360k())
map(bm_LA2D_o2_c2_n45.addOptions,ops)

bm_LA2D_o2_pen100_c2_n45=Benchmark(name="Lame 2D (order 2,  penalty 100, contrast 1e2, normal 45deg)")
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_30k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_60k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_120k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_240k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_480k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_960k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_1920k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_3840k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_7680k())
bm_LA2D_o2_pen100_c2_n45.addProblem(InhomogeneousLame2DOrder2JumpE2Normal45Alpha100_15360k())
map(bm_LA2D_o2_pen100_c2_n45.addOptions,ops)

bm_LA2D_o2_c6_n45=Benchmark(name="Lame 2D (order 2, contrast 1e6, normal 45deg)")
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_30k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_60k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_120k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_240k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_480k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_960k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_1920k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_3840k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_7680k())
bm_LA2D_o2_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45_15360k())
map(bm_LA2D_o2_c6_n45.addOptions,ops)

bm_LA2D_o2_pen100_c6_n45=Benchmark(name="Lame 2D (order 2,  penalty 100, contrast 1e6, normal 45deg)")
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_30k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_60k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_120k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_240k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_480k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_960k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_1920k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_3840k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_7680k())
bm_LA2D_o2_pen100_c6_n45.addProblem(InhomogeneousLame2DOrder2JumpE6Normal45Alpha100_15360k())
map(bm_LA2D_o2_pen100_c6_n45.addOptions,ops)

bm_LA3D_o1=Benchmark(name="Lame 3D (order 1)")
bm_LA3D_o1.addProblem(Lame3DOrder1_30k())
bm_LA3D_o1.addProblem(Lame3DOrder1_60k())
bm_LA3D_o1.addProblem(Lame3DOrder1_120k())
bm_LA3D_o1.addProblem(Lame3DOrder1_240k())
bm_LA3D_o1.addProblem(Lame3DOrder1_480k())
bm_LA3D_o1.addProblem(Lame3DOrder1_960k())
bm_LA3D_o1.addProblem(Lame3DOrder1_1920k())
bm_LA3D_o1.addProblem(Lame3DOrder1_3840k())
bm_LA3D_o1.addProblem(Lame3DOrder1_7680k())
bm_LA3D_o1.addProblem(Lame3DOrder1_15360k())
map(bm_LA3D_o1.addOptions,ops)

bm_LA3D_o1_pen100=Benchmark(name="Lame 3D (order 1,  penalty 100)")
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_30k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_60k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_120k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_240k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_480k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_960k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_1920k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_3840k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_7680k())
bm_LA3D_o1_pen100.addProblem(Lame3DOrder1Alpha100_15360k())
map(bm_LA3D_o1_pen100.addOptions,ops)

bm_LA3D_o1_c2=Benchmark(name="Lame 3D (order 1, contrast 1e2)")
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_30k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_60k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_120k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_240k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_480k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_960k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_1920k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_3840k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_7680k())
bm_LA3D_o1_c2.addProblem(InhomgeneousLame3DOrder1JumpE2_15360k())
map(bm_LA3D_o1_c2.addOptions,ops)

bm_LA3D_o1_pen100_c2=Benchmark(name="Lame 3D (order 1,  penalty 100, contrast 1e2)")
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_30k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_60k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_120k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_240k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_480k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_960k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_1920k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_3840k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_7680k())
bm_LA3D_o1_pen100_c2.addProblem(InhomgeneousLame3DOrder1JumpE2Alpha100_15360k())
map(bm_LA3D_o1_pen100_c2.addOptions,ops)

bm_LA3D_o1_c6=Benchmark(name="Lame 3D (order 1, contrast 1e6)")
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_30k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_60k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_120k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_240k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_480k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_960k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_1920k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_3840k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_7680k())
bm_LA3D_o1_c6.addProblem(InhomgeneousLame3DOrder1JumpE6_15360k())
map(bm_LA3D_o1_c6.addOptions,ops)

bm_LA3D_o1_pen100_c6=Benchmark(name="Lame 3D (order 1,  penalty 100, contrast 1e6)")
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_30k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_60k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_120k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_240k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_480k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_960k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_1920k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_3840k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_7680k())
bm_LA3D_o1_pen100_c6.addProblem(InhomgeneousLame3DOrder1JumpE6Alpha100_15360k())
map(bm_LA3D_o1_pen100_c6.addOptions,ops)

bm_LA3D_o1_c2_n45=Benchmark(name="Lame 3D (order 1, contrast 1e2, normal 45deg)")
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_30k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_60k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_120k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_240k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_480k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_960k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_1920k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_3840k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_7680k())
bm_LA3D_o1_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45_15360k())
map(bm_LA3D_o1_c2_n45.addOptions,ops)

bm_LA3D_o1_pen100_c2_n45=Benchmark(name="Lame 3D (order 1,  penalty 100, contrast 1e2, normal 45deg)")
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_30k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_60k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_120k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_240k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_480k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_960k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_1920k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_3840k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_7680k())
bm_LA3D_o1_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder1JumpE2Normal45Alpha100_15360k())
map(bm_LA3D_o1_pen100_c2_n45.addOptions,ops)

bm_LA3D_o1_c6_n45=Benchmark(name="Lame 3D (order 1, contrast 1e6, normal 45deg)")
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_30k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_60k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_120k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_240k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_480k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_960k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_1920k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_3840k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_7680k())
bm_LA3D_o1_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45_15360k())
map(bm_LA3D_o1_c6_n45.addOptions,ops)

bm_LA3D_o1_pen100_c6_n45=Benchmark(name="Lame 3D (order 1,  penalty 100, contrast 1e6, normal 45deg)")
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_30k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_60k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_120k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_240k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_480k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_960k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_1920k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_3840k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_7680k())
bm_LA3D_o1_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder1JumpE6Normal45Alpha100_15360k())
map(bm_LA3D_o1_pen100_c6_n45.addOptions,ops)

bm_LA3D_o2=Benchmark(name="Lame 3D (order 2)")
bm_LA3D_o2.addProblem(Lame3DOrder2_30k())
bm_LA3D_o2.addProblem(Lame3DOrder2_60k())
bm_LA3D_o2.addProblem(Lame3DOrder2_120k())
bm_LA3D_o2.addProblem(Lame3DOrder2_240k())
bm_LA3D_o2.addProblem(Lame3DOrder2_480k())
bm_LA3D_o2.addProblem(Lame3DOrder2_960k())
bm_LA3D_o2.addProblem(Lame3DOrder2_1920k())
bm_LA3D_o2.addProblem(Lame3DOrder2_3840k())
bm_LA3D_o2.addProblem(Lame3DOrder2_7680k())
bm_LA3D_o2.addProblem(Lame3DOrder2_15360k())
map(bm_LA3D_o2.addOptions,ops)

bm_LA3D_o2_pen100=Benchmark(name="Lame 3D (order 2,  penalty 100)")
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_30k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_60k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_120k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_240k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_480k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_960k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_1920k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_3840k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_7680k())
bm_LA3D_o2_pen100.addProblem(Lame3DOrder2Alpha100_15360k())
map(bm_LA3D_o2_pen100.addOptions,ops)

bm_LA3D_o2_c2=Benchmark(name="Lame 3D (order 2, contrast 1e2)")
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_30k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_60k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_120k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_240k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_480k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_960k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_1920k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_3840k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_7680k())
bm_LA3D_o2_c2.addProblem(InhomgeneousLame3DOrder2JumpE2_15360k())
map(bm_LA3D_o2_c2.addOptions,ops)

bm_LA3D_o2_pen100_c2=Benchmark(name="Lame 3D (order 2,  penalty 100, contrast 1e2)")
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_30k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_60k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_120k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_240k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_480k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_960k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_1920k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_3840k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_7680k())
bm_LA3D_o2_pen100_c2.addProblem(InhomgeneousLame3DOrder2JumpE2Alpha100_15360k())
map(bm_LA3D_o2_pen100_c2.addOptions,ops)

bm_LA3D_o2_c6=Benchmark(name="Lame 3D (order 2, contrast 1e6)")
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_30k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_60k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_120k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_240k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_480k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_960k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_1920k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_3840k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_7680k())
bm_LA3D_o2_c6.addProblem(InhomgeneousLame3DOrder2JumpE6_15360k())
map(bm_LA3D_o2_c6.addOptions,ops)

bm_LA3D_o2_pen100_c6=Benchmark(name="Lame 3D (order 2,  penalty 100, contrast 1e6)")
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_30k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_60k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_120k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_240k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_480k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_960k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_1920k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_3840k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_7680k())
bm_LA3D_o2_pen100_c6.addProblem(InhomgeneousLame3DOrder2JumpE6Alpha100_15360k())
map(bm_LA3D_o2_pen100_c6.addOptions,ops)

bm_LA3D_o2_c2_n45=Benchmark(name="Lame 3D (order 2, contrast 1e2, normal 45deg)")
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_30k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_60k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_120k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_240k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_480k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_960k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_1920k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_3840k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_7680k())
bm_LA3D_o2_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45_15360k())
map(bm_LA3D_o2_c2_n45.addOptions,ops)

bm_LA3D_o2_pen100_c2_n45=Benchmark(name="Lame 3D (order 2,  penalty 100, contrast 1e2, normal 45deg)")
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_30k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_60k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_120k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_240k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_480k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_960k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_1920k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_3840k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_7680k())
bm_LA3D_o2_pen100_c2_n45.addProblem(InhomogeneousLame3DOrder2JumpE2Normal45Alpha100_15360k())
map(bm_LA3D_o2_pen100_c2_n45.addOptions,ops)

bm_LA3D_o2_c6_n45=Benchmark(name="Lame 3D (order 2, contrast 1e6, normal 45deg)")
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_30k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_60k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_120k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_240k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_480k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_960k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_1920k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_3840k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_7680k())
bm_LA3D_o2_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45_15360k())
map(bm_LA3D_o2_c6_n45.addOptions,ops)

bm_LA3D_o2_pen100_c6_n45=Benchmark(name="Lame 3D (order 2,  penalty 100, contrast 1e6, normal 45deg)")
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_30k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_60k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_120k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_240k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_480k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_960k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_1920k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_3840k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_7680k())
bm_LA3D_o2_pen100_c6_n45.addProblem(InhomogeneousLame3DOrder2JumpE6Normal45Alpha100_15360k())
map(bm_LA3D_o2_pen100_c6_n45.addOptions,ops)

bm_CLA2D_o1=Benchmark(name="Lame 2D (compressible, order 1)")
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_30k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_60k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_120k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_240k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_480k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_960k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_1920k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_3840k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_7680k())
bm_CLA2D_o1.addProblem(CompressibleLame2DOrder1_15360k())
map(bm_CLA2D_o1.addOptions,ops)

bm_CLA2D_o1_c2=Benchmark(name="Lame 2D (compressible, order 1, contrast 1e2)")
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_30k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_60k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_120k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_240k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_480k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_960k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_1920k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_3840k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_7680k())
bm_CLA2D_o1_c2.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE2_15360k())
map(bm_CLA2D_o1_c2.addOptions,ops)

bm_CLA2D_o1_c6=Benchmark(name="Lame 2D (compressible, order 1, contrast 1e6)")
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_30k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_60k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_120k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_240k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_480k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_960k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_1920k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_3840k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_7680k())
bm_CLA2D_o1_c6.addProblem(CompressibleInhomgeneousLame2DOrder1JumpE6_15360k())
map(bm_CLA2D_o1_c6.addOptions,ops)

bm_CLA2D_o1_c2_n45=Benchmark(name="Lame 2D (compressible, order 1, contrast 1e2, normal 45deg)")
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_30k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_60k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_120k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_240k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_480k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_960k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_1920k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_3840k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_7680k())
bm_CLA2D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE2Normal45_15360k())
map(bm_CLA2D_o1_c2_n45.addOptions,ops)

bm_CLA2D_o1_c6_n45=Benchmark(name="Lame 2D (compressible, order 1, contrast 1e6, normal 45deg)")
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_30k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_60k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_120k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_240k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_480k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_960k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_1920k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_3840k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_7680k())
bm_CLA2D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder1JumpE6Normal45_15360k())
map(bm_CLA2D_o1_c6_n45.addOptions,ops)

bm_CLA2D_o2=Benchmark(name="Lame 2D (compressible, order 2)")
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_30k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_60k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_120k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_240k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_480k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_960k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_1920k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_3840k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_7680k())
bm_CLA2D_o2.addProblem(CompressibleLame2DOrder2_15360k())
map(bm_CLA2D_o2.addOptions,ops)

bm_CLA2D_o2_c2=Benchmark(name="Lame 2D (compressible, order 2, contrast 1e2)")
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_30k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_60k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_120k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_240k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_480k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_960k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_1920k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_3840k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_7680k())
bm_CLA2D_o2_c2.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE2_15360k())
map(bm_CLA2D_o2_c2.addOptions,ops)

bm_CLA2D_o2_c6=Benchmark(name="Lame 2D (compressible, order 2, contrast 1e6)")
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_30k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_60k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_120k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_240k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_480k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_960k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_1920k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_3840k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_7680k())
bm_CLA2D_o2_c6.addProblem(CompressibleInhomgeneousLame2DOrder2JumpE6_15360k())
map(bm_CLA2D_o2_c6.addOptions,ops)

bm_CLA2D_o2_c2_n45=Benchmark(name="Lame 2D (compressible, order 2, contrast 1e2, normal 45deg)")
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_30k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_60k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_120k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_240k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_480k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_960k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_1920k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_3840k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_7680k())
bm_CLA2D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE2Normal45_15360k())
map(bm_CLA2D_o2_c2_n45.addOptions,ops)

bm_CLA2D_o2_c6_n45=Benchmark(name="Lame 2D (compressible, order 2, contrast 1e6, normal 45deg)")
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_30k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_60k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_120k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_240k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_480k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_960k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_1920k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_3840k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_7680k())
bm_CLA2D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame2DOrder2JumpE6Normal45_15360k())
map(bm_CLA2D_o2_c6_n45.addOptions,ops)

bm_CLA3D_o1=Benchmark(name="Lame 3D (compressible, order 1)")
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_30k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_60k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_120k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_240k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_480k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_960k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_1920k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_3840k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_7680k())
bm_CLA3D_o1.addProblem(CompressibleLame3DOrder1_15360k())
map(bm_CLA3D_o1.addOptions,ops)

bm_CLA3D_o1_c2=Benchmark(name="Lame 3D (compressible, order 1, contrast 1e2)")
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_30k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_60k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_120k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_240k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_480k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_960k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_1920k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_3840k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_7680k())
bm_CLA3D_o1_c2.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE2_15360k())
map(bm_CLA3D_o1_c2.addOptions,ops)

bm_CLA3D_o1_c6=Benchmark(name="Lame 3D (compressible, order 1, contrast 1e6)")
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_30k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_60k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_120k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_240k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_480k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_960k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_1920k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_3840k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_7680k())
bm_CLA3D_o1_c6.addProblem(CompressibleInhomgeneousLame3DOrder1JumpE6_15360k())
map(bm_CLA3D_o1_c6.addOptions,ops)

bm_CLA3D_o1_c2_n45=Benchmark(name="Lame 3D (compressible, order 1, contrast 1e2, normal 45deg)")
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_30k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_60k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_120k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_240k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_480k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_960k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_1920k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_3840k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_7680k())
bm_CLA3D_o1_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE2Normal45_15360k())
map(bm_CLA3D_o1_c2_n45.addOptions,ops)

bm_CLA3D_o1_c6_n45=Benchmark(name="Lame 3D (compressible, order 1, contrast 1e6, normal 45deg)")
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_30k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_60k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_120k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_240k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_480k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_960k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_1920k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_3840k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_7680k())
bm_CLA3D_o1_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder1JumpE6Normal45_15360k())
map(bm_CLA3D_o1_c6_n45.addOptions,ops)

bm_CLA3D_o2=Benchmark(name="Lame 3D (compressible, order 2)")
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_30k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_60k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_120k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_240k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_480k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_960k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_1920k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_3840k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_7680k())
bm_CLA3D_o2.addProblem(CompressibleLame3DOrder2_15360k())
map(bm_CLA3D_o2.addOptions,ops)

bm_CLA3D_o2_c2=Benchmark(name="Lame 3D (compressible, order 2, contrast 1e2)")
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_30k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_60k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_120k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_240k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_480k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_960k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_1920k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_3840k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_7680k())
bm_CLA3D_o2_c2.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE2_15360k())
map(bm_CLA3D_o2_c2.addOptions,ops)

bm_CLA3D_o2_c6=Benchmark(name="Lame 3D (compressible, order 2, contrast 1e6)")
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_30k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_60k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_120k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_240k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_480k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_960k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_1920k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_3840k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_7680k())
bm_CLA3D_o2_c6.addProblem(CompressibleInhomgeneousLame3DOrder2JumpE6_15360k())
map(bm_CLA3D_o2_c6.addOptions,ops)

bm_CLA3D_o2_c2_n45=Benchmark(name="Lame 3D (compressible, order 2, contrast 1e2, normal 45deg)")
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_30k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_60k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_120k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_240k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_480k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_960k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_1920k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_3840k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_7680k())
bm_CLA3D_o2_c2_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE2Normal45_15360k())
map(bm_CLA3D_o2_c2_n45.addOptions,ops)

bm_CLA3D_o2_c6_n45=Benchmark(name="Lame 3D (compressible, order 2, contrast 1e6, normal 45deg)")
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_30k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_60k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_120k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_240k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_480k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_960k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_1920k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_3840k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_7680k())
bm_CLA3D_o2_c6_n45.addProblem(CompressibleInhomogeneousLame3DOrder2JumpE6Normal45_15360k())
map(bm_CLA3D_o2_c6_n45.addOptions,ops)


bms=BenchmarkSuite("Paso/Finley (%s benchmark)"%type)

# 2D ==========================================================
bms.addBenchmark(bm_L2Do1)
bms.addBenchmark(bm_L2Do2)

if type in ["simple"]:
   bms.addBenchmark(bm_CLA2D_o1)
   bms.addBenchmark(bm_CLA2D_o2)

if type in ["all", "mantle"]:
   bms.addBenchmark(bm_CLA2D_o2)
   bms.addBenchmark(bm_LA2D_o2_pen100)

   bms.addBenchmark(bm_CLA2D_o2_c6)
   bms.addBenchmark(bm_LA2D_o2_pen100_c6)

   bms.addBenchmark(bm_CLA2D_o2_c6_n45)
   bms.addBenchmark(bm_LA2D_o2_pen100_c6_n45)

if type in ["all", "linear elastic"]:
   bms.addBenchmark(bm_LA2D_o2)
   bms.addBenchmark(bm_LA2D_o2_c6)
   bms.addBenchmark(bm_LA2D_o2_c6_n45)

# 3D ==========================================================
bms.addBenchmark(bm_L3Do1)
bms.addBenchmark(bm_L3Do2)
if type in ["simple"]:
   bms.addBenchmark(bm_CLA3D_o1)
   bms.addBenchmark(bm_CLA3D_o2)
     
if type in ["all", "mantle"]:
   bms.addBenchmark(bm_CLA3D_o2)
   bms.addBenchmark(bm_LA3D_o2_pen100)

   bms.addBenchmark(bm_CLA3D_o2_c6)
   bms.addBenchmark(bm_LA3D_o2_pen100_c6)

   bms.addBenchmark(bm_CLA3D_o2_c6_n45)
   bms.addBenchmark(bm_LA3D_o2_pen100_c6_n45)

if type in ["all", "linear elastic"]:
   bms.addBenchmark(bm_LA3D_o2)
   bms.addBenchmark(bm_LA3D_o2_c6)
   bms.addBenchmark(bm_LA3D_o2_c6_n45)

if type in ["all"]:
   bms.addBenchmark(bm_A2Do1g30)
   bms.addBenchmark(bm_A2Do2g30)
   bms.addBenchmark(bm_A2Do2g45)
   bms.addBenchmark(bm_A2Do1g45)
   bms.addBenchmark(bm_A3Do1g30)
   bms.addBenchmark(bm_A3Do1g45)
   bms.addBenchmark(bm_A3Do2g30)
   bms.addBenchmark(bm_A3Do2g45)

   bms.addBenchmark(bm_LA2D_o1)
   bms.addBenchmark(bm_LA2D_o1_c2)
   bms.addBenchmark(bm_LA2D_o1_c6)

   bms.addBenchmark(bm_LA2D_o1_c2_n45)
   bms.addBenchmark(bm_LA2D_o1_c6_n45)

   bms.addBenchmark(bm_LA2D_o1_pen100)
   bms.addBenchmark(bm_LA2D_o1_pen100_c2)
   bms.addBenchmark(bm_LA2D_o1_pen100_c6)

   bms.addBenchmark(bm_LA2D_o1_pen100_c2_n45)
   bms.addBenchmark(bm_LA2D_o1_pen100_c6_n45)

   bms.addBenchmark(bm_LA2D_o2_c2)

   bms.addBenchmark(bm_LA2D_o2_c2_n45)
   bms.addBenchmark(bm_LA2D_o2_pen100_c2)
   bms.addBenchmark(bm_LA2D_o2_pen100_c2_n45)


   bms.addBenchmark(bm_LA3D_o1)
   bms.addBenchmark(bm_LA3D_o1_pen100)
   bms.addBenchmark(bm_LA3D_o1_c2)
   bms.addBenchmark(bm_LA3D_o1_pen100_c2)
   bms.addBenchmark(bm_LA3D_o1_c6)
   bms.addBenchmark(bm_LA3D_o1_pen100_c6)
   bms.addBenchmark(bm_LA3D_o1_c2_n45)
   bms.addBenchmark(bm_LA3D_o1_pen100_c2_n45)
   bms.addBenchmark(bm_LA3D_o1_c6_n45)
   bms.addBenchmark(bm_LA3D_o1_pen100_c6_n45)
   bms.addBenchmark(bm_LA3D_o2_c2)
   bms.addBenchmark(bm_LA3D_o2_pen100)
   bms.addBenchmark(bm_LA3D_o2_pen100_c2)
   bms.addBenchmark(bm_LA3D_o2_c2_n45)
   bms.addBenchmark(bm_LA3D_o2_pen100_c2_n45)
   
   bms.addBenchmark(bm_CLA2D_o1)
   bms.addBenchmark(bm_CLA2D_o1_c2)
   bms.addBenchmark(bm_CLA2D_o1_c6)
   bms.addBenchmark(bm_CLA2D_o1_c2_n45)
   bms.addBenchmark(bm_CLA2D_o1_c6_n45)
   
   bms.addBenchmark(bm_CLA2D_o2_c2)
   bms.addBenchmark(bm_CLA2D_o2_c2_n45)
   
   bms.addBenchmark(bm_CLA3D_o1)
   bms.addBenchmark(bm_CLA3D_o1_c2)
   bms.addBenchmark(bm_CLA3D_o1_c6)
   bms.addBenchmark(bm_CLA3D_o1_c2_n45)
   bms.addBenchmark(bm_CLA3D_o1_c6_n45)
   
   bms.addBenchmark(bm_CLA3D_o2_c2)
   bms.addBenchmark(bm_CLA3D_o2_c2_n45)
   
bms.run(scale=thlist)
out=bms.getHTML(filter=ff)
print(out)
