;;; Proof of the feature interaction:

(defthm user-deliver/auto-response-adds-sender-to-already-answered
 (implies
  (and
   (get-var 'default-response recipient-env)
   (get-var 'user             recipient-env)
   (equal (message-sender msg) sender)
   (not (member-equal sender (get-var 'already-answered recipient-env)))
   )
  (user-in-already-answered 
   sender
   (mv-env (user-deliver msg recipient-env)))
  )
 )

(defthm user-deliver/auto-response-recipient-becomes-message-sender
  (implies
   (and
    (get-var 'default-response recipient-env)
    (get-var 'user             recipient-env)
    (message-p msg)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered recipient-env)))
   )
    (equal 
     (message-sender (mv-msg (user-deliver msg recipient-env)))
     (recipient msg))))


(defthm user-deliver/adds-already-answered-and-recv-msg
  (implies
   (and
    (get-var 'default-response recipient-env)
    (get-var 'user             recipient-env)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered recipient-env)))
    (not (member-equal k '(already-answered recv-msg)))
    )
   (equal 
    (get-var k (mv-env (user-deliver msg recipient-env)))
    (get-var k recipient-env)))
  :hints (("Goal" :in-theory (enable user-deliver))))

;proves
(defthm user-deliver-auto/auto-response-message-sender-becomes-recipient
  (implies
   (and
    (get-var 'default-response env)
    (get-var 'user             env)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered env)))
    )
   (sender-becomes-recipient 
      msg
      (mv-msg (user-deliver-auto msg env))))
  :hints (("Goal" :in-theory (enable user-deliver-auto user-deliver)
	          :hands-off (sender-becomes-recipient)
		  :use (email-auto-incoming/auto-response-message-sender-becomes-recipient))))

(defthm user-deliver/auto-response-message-sender-becomes-recipient
  (implies
   (and
    (get-var 'default-response env)
    (get-var 'user             env)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered env)))
    )
   (sender-becomes-recipient 
      msg
      (mv-msg (user-deliver msg env))))
  :hints (("Goal" :in-theory (enable user-deliver-auto user-deliver)
	          :hands-off (sender-becomes-recipient)
		  :use (email-auto-incoming/auto-response-message-sender-becomes-recipient))))



(defthm user-deliver/auto-response-if-not-already-answered-mail-action
  (implies
   (and
    (lookup 'default-response)             ; autoresponder enabled
    (lookup 'user)                         
    (equal sender (message-sender msg))
    (not (member-equal sender (lookup 'already-answered)))
    )
   (mv-let (s new-msg new-env)
	   (user-deliver msg env)
	   (equal s 'mail)
		))
  :hints (("Goal" :in-theory (enable email-auto-incoming)))) 


(defthm do-deliver/auto-response-message-sender-becomes-recipient
  (implies
   (and
    (action-listp  rest)
    (action-p      action)
    (equal (action-arg1 action) msg)
    (equal (get-var (action-name action) users)
	   env)
    env
    (get-var 'default-response env)
    (get-var 'user             env)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered env)))
    )
   (sender-becomes-recipient 
      msg
      (action-arg1
       (car (mv-actions (do-deliver action rest users hosts))))))
  :hints (("Goal" :in-theory (enable do-deliver)
	          :hands-off (user-deliver get-var add-user-mail-action)
		  :use (user-deliver/auto-response-message-sender-becomes-recipient))))

(defthm do-deliver/auto-response-message-sender-becomes-recipient
  (implies
   (and
    (action-listp  rest)
    (action-p      action)
    (equal (action-arg1 action) msg)
    (equal (get-var (action-name action) users)
	   env)
    env
    (get-var 'default-response env)
    (get-var 'user             env)
    (equal (message-sender msg) sender)
    (not (member-equal sender (get-var 'already-answered env)))
    )
   (sender-becomes-recipient 
      msg
      (action-arg1 
       (car (mv-actions (do-deliver action rest users hosts))))))
  :hints (("Goal" :in-theory (enable do-action-cond)
	          :hands-off (do-deliver user-deliver get-var add-user-mail-action)
		  :use (user-deliver/auto-response-message-sender-becomes-recipient))))



