/***************************************************************************
 *   Copyright (C) 2004-2012 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.4.9. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef COLLECTIONINDEX_H
#define COLLECTIONINDEX_H

#include <QHash>
#include <QStringList>


class bibParser;
class settings;

class QTextStream;


class collectionIndex
{

public:
    collectionIndex(bibParser* bp);
    ~collectionIndex();

    int index(const QString& dir);


private:
    struct KeysentenceData
    {
        inline KeysentenceData() : ndocuments(0) {}
        inline KeysentenceData(const int document) : ndocuments(1)
        {
            documents.append(document);
        }
        inline void update(const int document)
        {
            ++ndocuments;
            documents.append(document);
        }
        int ndocuments;
        QList<int> documents;
    };

    KeysentenceData* _digest_sentence(KeysentenceData* ksd, KeysentenceData* ksdndmax, int* ndmax) const;
    QString preprocessedText(const QString& journal, const QString& text) const;
    QString& replace(QString& str, const QChar& a, const QChar& b) const;
    bool isValidKeySentence(const QString& text) const;
    void analyzeKeySentences();
    void cleanupKeySentences();
    void digestKeySentences();
    void setKeySentences(const int documentid, const QString& text);

    QTextStream& _out;
    bibParser* _bpP;
    const QChar _space_char;
    int _nerrors;
    settings* _settingsP;

    QHash<QString, KeysentenceData> _keysentences;
    QMultiHash<int, QString> _document_sentences;
    QMultiHash<int, int> _document_sentenceids;

};

#endif
