// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/android/customtabs/dynamicmodule/module_metrics.h"

#include <string>

#include "base/files/file_path.h"
#include "base/files/file_util.h"
#include "base/test/metrics/histogram_tester.h"
#include "services/resource_coordinator/public/cpp/memory_instrumentation/os_metrics.h"
#include "testing/gtest/include/gtest/gtest.h"

namespace customtabs {

namespace {
const char kTestSmaps[] =
    "95d75000-ab195000 r--s 00000000 fd:02 294922     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/oat/arm/base.vdex\n"
    "Size:             348288 kB\n"
    "Rss:               45328 kB\n"
    "Pss:               45328 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:     45328 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:        45328 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd mr me ms \n"
    "ab195000-ab19a000 r-xp 00000000 fd:00 427     /system/bin/app_process32\n"
    "Size:                 20 kB\n"
    "Rss:                  12 kB\n"
    "Pss:                   3 kB\n"
    "Shared_Clean:         12 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:           12 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd ex mr mw me dw \n"
    "bbfc1000-bc36a000 r--p 00000000 fd:02 294604     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/oat/arm/base.odex\n"
    "Size:               3748 kB\n"
    "Rss:                2988 kB\n"
    "Pss:                2988 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:      2988 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:         2988 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd mr mw me \n"
    "bc36a000-bc397000 r-xp 003a9000 fd:02 294604     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/oat/arm/base.odex\n"
    "Size:                180 kB\n"
    "Rss:                   4 kB\n"
    "Pss:                   4 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         4 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:            4 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd ex mr mw me \n"
    "bc397000-becbd000 rw-p 00000000 00:00 0     [anon:.bss]\n"
    "Size:              42136 kB\n"
    "Rss:                7384 kB\n"
    "Pss:                7384 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:      7384 kB\n"
    "Referenced:         7384 kB\n"
    "Anonymous:          7384 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd wr mr mw me ac \n"
    "Name:           [anon:.bss]\n"
    "bc397000-becbd000 rw-p 00000000 00:00 0     [anon:.bss]\n"
    "Size:              42136 kB\n"
    "Rss:                7384 kB\n"
    "Pss:                7384 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:      7384 kB\n"
    "Referenced:         7384 kB\n"
    "Anonymous:          7384 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd wr mr mw me ac \n"
    "Name:           [anon:.bss]\n"
    "becbd000-becbe000 r--p 003d6000 fd:02 294604     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/oat/arm/base.odex\n"
    "Size:                  4 kB\n"
    "Rss:                   4 kB\n"
    "Pss:                   4 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         4 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:            4 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd mr mw me \n"
    "becbe000-becbf000 rw-p 003d7000 fd:02 294604     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/oat/arm/base.odex\n"
    "Size:                  4 kB\n"
    "Rss:                   4 kB\n"
    "Pss:                   4 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:         4 kB\n"
    "Referenced:            4 kB\n"
    "Anonymous:             4 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd wr mr mw me ac \n"
    "becc0000-bece1000 rw-s 00064000 00:0c 11218     /dev/kgsl-3d0\n"
    "Size:                132 kB\n"
    "Rss:                   8 kB\n"
    "Pss:                   6 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          4 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:         4 kB\n"
    "Referenced:            8 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd wr sh mr mw me ms dc de dd \n"
    "c1a03000-c2493000 r--s 08654000 fd:02 294358     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/base.apk\n"
    "Size:              10816 kB\n"
    "Rss:                2124 kB\n"
    "Pss:                 745 kB\n"
    "Shared_Clean:       2008 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:       116 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:         2124 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd mr me ms \n"
    "c2493000-c2d03000 rw-s 00000000 00:08 10519     anon_inode:dmabuf\n"
    "Size:               8640 kB\n"
    "Rss:                   0 kB\n"
    "Pss:                   0 kB\n"
    "Shared_Clean:          0 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:            0 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd wr sh mr mw me ms pf io de dd \n"
    "c5355000-c5466000 r--s 0948b000 fd:02 294358     /data/app/com.google.android.googlequicksearchbox-A7cgO6T5LxS1KugchuFVTQ==/base.apk\n"
    "Size:               1092 kB\n"
    "Rss:                1092 kB\n"
    "Pss:                 498 kB\n"
    "Shared_Clean:       1092 kB\n"
    "Shared_Dirty:          0 kB\n"
    "Private_Clean:         0 kB\n"
    "Private_Dirty:         0 kB\n"
    "Referenced:         1092 kB\n"
    "Anonymous:             0 kB\n"
    "AnonHugePages:         0 kB\n"
    "Swap:                  0 kB\n"
    "SwapPss:               0 kB\n"
    "KernelPageSize:        4 kB\n"
    "MMUPageSize:           4 kB\n"
    "Locked:                0 kB\n"
    "VmFlags: rd mr me ms \n";
}  // namespace

TEST(ModuleMetricsTest, RecordCodeMemoryFootprint) {
  base::HistogramTester histogram_tester;
  base::FilePath temp_path;
  base::ScopedFILE temp_file(CreateAndOpenTemporaryFile(&temp_path));
  ASSERT_TRUE(temp_file);

  ASSERT_TRUE(base::WriteFileDescriptor(fileno(temp_file.get()), kTestSmaps,
                                        strlen(kTestSmaps)));

  memory_instrumentation::OSMetrics::SetProcSmapsForTesting(temp_file.get());
  customtabs::RecordCodeMemoryFootprint(
      "com.google.android.googlequicksearchbox", "OnModuleLoad");
  histogram_tester.ExpectUniqueSample(
      "CustomTabs.DynamicModule.ProportionalSet.OnModuleLoad", 55712UL, 1);
  histogram_tester.ExpectUniqueSample(
      "CustomTabs.DynamicModule.ResidentSet.OnModuleLoad", 55712UL, 1);
}

}  // namespace customtabs
