// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chromeos/services/ime/public/cpp/rulebased/def/ar.h"

namespace ar {

const char* kId = "ar";
bool kIs102 = false;
const char* kNormal[] = {
    u8"\u0630",        // BackQuote
    u8"\u0661",        // Digit1
    u8"\u0662",        // Digit2
    u8"\u0663",        // Digit3
    u8"\u0664",        // Digit4
    u8"\u0665",        // Digit5
    u8"\u0666",        // Digit6
    u8"\u0667",        // Digit7
    u8"\u0668",        // Digit8
    u8"\u0669",        // Digit9
    u8"\u0660",        // Digit0
    u8"-",             // Minus
    u8"=",             // Equal
    u8"\u0636",        // KeyQ
    u8"\u0635",        // KeyW
    u8"\u062b",        // KeyE
    u8"\u0642",        // KeyR
    u8"\u0641",        // KeyT
    u8"\u063a",        // KeyY
    u8"\u0639",        // KeyU
    u8"\u0647",        // KeyI
    u8"\u062e",        // KeyO
    u8"\u062d",        // KeyP
    u8"\u062c",        // BracketLeft
    u8"\u062f",        // BracketRight
    u8"\\",            // Backslash
    u8"\u0634",        // KeyA
    u8"\u0633",        // KeyS
    u8"\u064a",        // KeyD
    u8"\u0628",        // KeyF
    u8"\u0644",        // KeyG
    u8"\u0627",        // KeyH
    u8"\u062a",        // KeyJ
    u8"\u0646",        // KeyK
    u8"\u0645",        // KeyL
    u8"\u0643",        // Semicolon
    u8"\u0637",        // Quote
    u8"\u0626",        // KeyZ
    u8"\u0621",        // KeyX
    u8"\u0624",        // KeyC
    u8"\u0631",        // KeyV
    u8"\u0644\u0627",  // KeyB
    u8"\u0649",        // KeyN
    u8"\u0629",        // KeyM
    u8"\u0648",        // Comma
    u8"\u0632",        // Period
    u8"\u0638",        // Slash
    u8"\u0020",        // Space
};
const char* kShift[] = {
    u8"\u0651",        // BackQuote
    u8"!",             // Digit1
    u8"\"",            // Digit2
    u8"#",             // Digit3
    u8"$",             // Digit4
    u8"%",             // Digit5
    u8"^",             // Digit6
    u8"&",             // Digit7
    u8"*",             // Digit8
    u8")",             // Digit9
    u8"(",             // Digit0
    u8"_",             // Minus
    u8"+",             // Equal
    u8"\u064e",        // KeyQ
    u8"\u064b",        // KeyW
    u8"\u064f",        // KeyE
    u8"\u064c",        // KeyR
    u8"\u0644\u0625",  // KeyT
    u8"\u0625",        // KeyY
    u8"\u2018",        // KeyU
    u8"\u00f7",        // KeyI
    u8"\u00d7",        // KeyO
    u8"\u061b",        // KeyP
    u8"<",             // BracketLeft
    u8">",             // BracketRight
    u8"|",             // Backslash
    u8"\u0650",        // KeyA
    u8"\u064d",        // KeyS
    u8"]",             // KeyD
    u8"[",             // KeyF
    u8"\u0644\u0623",  // KeyG
    u8"\u0623",        // KeyH
    u8"\u0640",        // KeyJ
    u8"\u060c",        // KeyK
    u8"/",             // KeyL
    u8":",             // Semicolon
    u8"@",             // Quote
    u8"~",             // KeyZ
    u8"\u0652",        // KeyX
    u8"}",             // KeyC
    u8"{",             // KeyV
    u8"\u0644\u0622",  // KeyB
    u8"\u0622",        // KeyN
    u8"\u2019",        // KeyM
    u8",",             // Comma
    u8".",             // Period
    u8"\u061f",        // Slash
    u8"\u0020",        // Space
};
const char* kAltGr[] = {
    u8"\u0630",        // BackQuote
    u8"\u0661",        // Digit1
    u8"\u0662",        // Digit2
    u8"\u0663",        // Digit3
    u8"\u0664",        // Digit4
    u8"\u0665",        // Digit5
    u8"\u0666",        // Digit6
    u8"\u0667",        // Digit7
    u8"\u0668",        // Digit8
    u8"\u0669",        // Digit9
    u8"\u0660",        // Digit0
    u8"-",             // Minus
    u8"=",             // Equal
    u8"\u0636",        // KeyQ
    u8"\u0635",        // KeyW
    u8"\u062b",        // KeyE
    u8"\u0642",        // KeyR
    u8"\u0641",        // KeyT
    u8"\u063a",        // KeyY
    u8"\u0639",        // KeyU
    u8"\u0647",        // KeyI
    u8"\u062e",        // KeyO
    u8"\u062d",        // KeyP
    u8"\u062c",        // BracketLeft
    u8"\u062f",        // BracketRight
    u8"\\",            // Backslash
    u8"\u0634",        // KeyA
    u8"\u0633",        // KeyS
    u8"\u064a",        // KeyD
    u8"\u0628",        // KeyF
    u8"\u0644",        // KeyG
    u8"\u0627",        // KeyH
    u8"\u062a",        // KeyJ
    u8"\u0646",        // KeyK
    u8"\u0645",        // KeyL
    u8"\u0643",        // Semicolon
    u8"\u0637",        // Quote
    u8"\u0626",        // KeyZ
    u8"\u0621",        // KeyX
    u8"\u0624",        // KeyC
    u8"\u0631",        // KeyV
    u8"\u0644\u0627",  // KeyB
    u8"\u0649",        // KeyN
    u8"\u0629",        // KeyM
    u8"\u0648",        // Comma
    u8"\u0632",        // Period
    u8"\u0638",        // Slash
    u8"\u0020",        // Space
};
const char* kCapslock[] = {
    u8"\u0630",        // BackQuote
    u8"\u0661",        // Digit1
    u8"\u0662",        // Digit2
    u8"\u0663",        // Digit3
    u8"\u0664",        // Digit4
    u8"\u0665",        // Digit5
    u8"\u0666",        // Digit6
    u8"\u0667",        // Digit7
    u8"\u0668",        // Digit8
    u8"\u0669",        // Digit9
    u8"\u0660",        // Digit0
    u8"-",             // Minus
    u8"=",             // Equal
    u8"\u0636",        // KeyQ
    u8"\u0635",        // KeyW
    u8"\u062b",        // KeyE
    u8"\u0642",        // KeyR
    u8"\u0641",        // KeyT
    u8"\u063a",        // KeyY
    u8"\u0639",        // KeyU
    u8"\u0647",        // KeyI
    u8"\u062e",        // KeyO
    u8"\u062d",        // KeyP
    u8"\u062c",        // BracketLeft
    u8"\u062f",        // BracketRight
    u8"\\",            // Backslash
    u8"\u0634",        // KeyA
    u8"\u0633",        // KeyS
    u8"\u064a",        // KeyD
    u8"\u0628",        // KeyF
    u8"\u0644",        // KeyG
    u8"\u0627",        // KeyH
    u8"\u062a",        // KeyJ
    u8"\u0646",        // KeyK
    u8"\u0645",        // KeyL
    u8"\u0643",        // Semicolon
    u8"\u0637",        // Quote
    u8"\u0626",        // KeyZ
    u8"\u0621",        // KeyX
    u8"\u0624",        // KeyC
    u8"\u0631",        // KeyV
    u8"\u0644\u0627",  // KeyB
    u8"\u0649",        // KeyN
    u8"\u0629",        // KeyM
    u8"\u0648",        // Comma
    u8"\u0632",        // Period
    u8"\u0638",        // Slash
    u8"\u0020",        // Space
};
const char* kShiftAltGr[] = {
    u8"\u0651",        // BackQuote
    u8"!",             // Digit1
    u8"\"",            // Digit2
    u8"#",             // Digit3
    u8"$",             // Digit4
    u8"%",             // Digit5
    u8"^",             // Digit6
    u8"&",             // Digit7
    u8"*",             // Digit8
    u8")",             // Digit9
    u8"(",             // Digit0
    u8"_",             // Minus
    u8"+",             // Equal
    u8"\u064e",        // KeyQ
    u8"\u064b",        // KeyW
    u8"\u064f",        // KeyE
    u8"\u064c",        // KeyR
    u8"\u0644\u0625",  // KeyT
    u8"\u0625",        // KeyY
    u8"\u2018",        // KeyU
    u8"\u00f7",        // KeyI
    u8"\u00d7",        // KeyO
    u8"\u061b",        // KeyP
    u8"<",             // BracketLeft
    u8">",             // BracketRight
    u8"|",             // Backslash
    u8"\u0650",        // KeyA
    u8"\u064d",        // KeyS
    u8"]",             // KeyD
    u8"[",             // KeyF
    u8"\u0644\u0623",  // KeyG
    u8"\u0623",        // KeyH
    u8"\u0640",        // KeyJ
    u8"\u060c",        // KeyK
    u8"/",             // KeyL
    u8":",             // Semicolon
    u8"@",             // Quote
    u8"~",             // KeyZ
    u8"\u0652",        // KeyX
    u8"}",             // KeyC
    u8"{",             // KeyV
    u8"\u0644\u0622",  // KeyB
    u8"\u0622",        // KeyN
    u8"\u2019",        // KeyM
    u8",",             // Comma
    u8".",             // Period
    u8"\u061f",        // Slash
    u8"\u0020",        // Space
};
const char* kAltgrCapslock[] = {
    u8"\u0630",        // BackQuote
    u8"\u0661",        // Digit1
    u8"\u0662",        // Digit2
    u8"\u0663",        // Digit3
    u8"\u0664",        // Digit4
    u8"\u0665",        // Digit5
    u8"\u0666",        // Digit6
    u8"\u0667",        // Digit7
    u8"\u0668",        // Digit8
    u8"\u0669",        // Digit9
    u8"\u0660",        // Digit0
    u8"-",             // Minus
    u8"=",             // Equal
    u8"\u0636",        // KeyQ
    u8"\u0635",        // KeyW
    u8"\u062b",        // KeyE
    u8"\u0642",        // KeyR
    u8"\u0641",        // KeyT
    u8"\u063a",        // KeyY
    u8"\u0639",        // KeyU
    u8"\u0647",        // KeyI
    u8"\u062e",        // KeyO
    u8"\u062d",        // KeyP
    u8"\u062c",        // BracketLeft
    u8"\u062f",        // BracketRight
    u8"\\",            // Backslash
    u8"\u0634",        // KeyA
    u8"\u0633",        // KeyS
    u8"\u064a",        // KeyD
    u8"\u0628",        // KeyF
    u8"\u0644",        // KeyG
    u8"\u0627",        // KeyH
    u8"\u062a",        // KeyJ
    u8"\u0646",        // KeyK
    u8"\u0645",        // KeyL
    u8"\u0643",        // Semicolon
    u8"\u0637",        // Quote
    u8"\u0626",        // KeyZ
    u8"\u0621",        // KeyX
    u8"\u0624",        // KeyC
    u8"\u0631",        // KeyV
    u8"\u0644\u0627",  // KeyB
    u8"\u0649",        // KeyN
    u8"\u0629",        // KeyM
    u8"\u0648",        // Comma
    u8"\u0632",        // Period
    u8"\u0638",        // Slash
    u8"\u0020",        // Space
};
const char* kShiftCapslock[] = {
    u8"\u0651",        // BackQuote
    u8"!",             // Digit1
    u8"\"",            // Digit2
    u8"#",             // Digit3
    u8"$",             // Digit4
    u8"%",             // Digit5
    u8"^",             // Digit6
    u8"&",             // Digit7
    u8"*",             // Digit8
    u8")",             // Digit9
    u8"(",             // Digit0
    u8"_",             // Minus
    u8"+",             // Equal
    u8"\u064e",        // KeyQ
    u8"\u064b",        // KeyW
    u8"\u064f",        // KeyE
    u8"\u064c",        // KeyR
    u8"\u0644\u0625",  // KeyT
    u8"\u0625",        // KeyY
    u8"\u2018",        // KeyU
    u8"\u00f7",        // KeyI
    u8"\u00d7",        // KeyO
    u8"\u061b",        // KeyP
    u8"<",             // BracketLeft
    u8">",             // BracketRight
    u8"|",             // Backslash
    u8"\u0650",        // KeyA
    u8"\u064d",        // KeyS
    u8"]",             // KeyD
    u8"[",             // KeyF
    u8"\u0644\u0623",  // KeyG
    u8"\u0623",        // KeyH
    u8"\u0640",        // KeyJ
    u8"\u060c",        // KeyK
    u8"/",             // KeyL
    u8":",             // Semicolon
    u8"@",             // Quote
    u8"~",             // KeyZ
    u8"\u0652",        // KeyX
    u8"}",             // KeyC
    u8"{",             // KeyV
    u8"\u0644\u0622",  // KeyB
    u8"\u0622",        // KeyN
    u8"\u2019",        // KeyM
    u8",",             // Comma
    u8".",             // Period
    u8"\u061f",        // Slash
    u8"\u0020",        // Space
};
const char* kShiftAltGrCapslock[] = {
    u8"\u0651",        // BackQuote
    u8"!",             // Digit1
    u8"\"",            // Digit2
    u8"#",             // Digit3
    u8"$",             // Digit4
    u8"%",             // Digit5
    u8"^",             // Digit6
    u8"&",             // Digit7
    u8"*",             // Digit8
    u8")",             // Digit9
    u8"(",             // Digit0
    u8"_",             // Minus
    u8"+",             // Equal
    u8"\u064e",        // KeyQ
    u8"\u064b",        // KeyW
    u8"\u064f",        // KeyE
    u8"\u064c",        // KeyR
    u8"\u0644\u0625",  // KeyT
    u8"\u0625",        // KeyY
    u8"\u2018",        // KeyU
    u8"\u00f7",        // KeyI
    u8"\u00d7",        // KeyO
    u8"\u061b",        // KeyP
    u8"<",             // BracketLeft
    u8">",             // BracketRight
    u8"|",             // Backslash
    u8"\u0650",        // KeyA
    u8"\u064d",        // KeyS
    u8"]",             // KeyD
    u8"[",             // KeyF
    u8"\u0644\u0623",  // KeyG
    u8"\u0623",        // KeyH
    u8"\u0640",        // KeyJ
    u8"\u060c",        // KeyK
    u8"/",             // KeyL
    u8":",             // Semicolon
    u8"@",             // Quote
    u8"~",             // KeyZ
    u8"\u0652",        // KeyX
    u8"}",             // KeyC
    u8"{",             // KeyV
    u8"\u0644\u0622",  // KeyB
    u8"\u0622",        // KeyN
    u8"\u2019",        // KeyM
    u8",",             // Comma
    u8".",             // Period
    u8"\u061f",        // Slash
    u8"\u0020",        // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace ar
