<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2019
 *
 * Generated from xml/schema/CRM/Dedupe/RuleGroup.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:85fc439e89d4d0dfd403efdd1cf67531)
 */

/**
 * Database access object for the RuleGroup entity.
 */
class CRM_Dedupe_DAO_RuleGroup extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_dedupe_rule_group';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  static $_log = FALSE;

  /**
   * Unique dedupe rule group id
   *
   * @var int unsigned
   */
  public $id;

  /**
   * The type of contacts this group applies to
   *
   * @var string
   */
  public $contact_type;

  /**
   * The weight threshold the sum of the rule weights has to cross to consider two contacts the same
   *
   * @var int
   */
  public $threshold;

  /**
   * Whether the rule should be used for cases where usage is Unsupervised, Supervised OR General(programatically)
   *
   * @var string
   */
  public $used;

  /**
   * Name of the rule group
   *
   * @var string
   */
  public $name;

  /**
   * Label of the rule group
   *
   * @var string
   */
  public $title;

  /**
   * Is this a reserved rule - a rule group that has been optimized and cannot be changed by the admin
   *
   * @var boolean
   */
  public $is_reserved;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_dedupe_rule_group';
    parent::__construct();
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Rule Group ID'),
          'description' => ts('Unique dedupe rule group id'),
          'required' => TRUE,
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
        ],
        'contact_type' => [
          'name' => 'contact_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Type'),
          'description' => ts('The type of contacts this group applies to'),
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'condition' => 'parent_id IS NULL',
          ]
        ],
        'threshold' => [
          'name' => 'threshold',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Threshold'),
          'description' => ts('The weight threshold the sum of the rule weights has to cross to consider two contacts the same'),
          'required' => TRUE,
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'used' => [
          'name' => 'used',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Length'),
          'description' => ts('Whether the rule should be used for cases where usage is Unsupervised, Supervised OR General(programatically)'),
          'required' => TRUE,
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'Radio',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::getDedupeRuleTypes',
          ]
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name'),
          'description' => ts('Name of the rule group'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Title'),
          'description' => ts('Label of the rule group'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
        ],
        'is_reserved' => [
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Reserved?'),
          'description' => ts('Is this a reserved rule - a rule group that has been optimized and cannot be changed by the admin'),
          'table_name' => 'civicrm_dedupe_rule_group',
          'entity' => 'RuleGroup',
          'bao' => 'CRM_Dedupe_BAO_RuleGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'dedupe_rule_group', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'dedupe_rule_group', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
