// Copyright (c) 2018, ETH Zurich and UNC Chapel Hill.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//
//     * Neither the name of ETH Zurich and UNC Chapel Hill nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// Author: Johannes L. Schoenberger (jsch at inf.ethz.ch)

#include "estimators/generalized_absolute_pose_coeffs.h"

namespace colmap {

Eigen::Matrix<double, 9, 1> ComputeDepthsSylvesterCoeffs(
    const Eigen::Matrix<double, 3, 6>& K) {
  Eigen::Matrix<double, 9, 1> coeffs;

  const double k12 = K(0, 1);
  const double k13 = K(0, 2);
  const double k15 = K(0, 4);
  const double k16 = K(0, 5);

  const double k22 = K(1, 1);
  const double k23 = K(1, 2);
  const double k25 = K(1, 4);
  const double k26 = K(1, 5);

  const double k32 = K(2, 1);
  const double k33 = K(2, 2);
  const double k35 = K(2, 4);
  const double k36 = K(2, 5);

  const double t2 = k12 * k12;
  const double t3 = k22 * k22;
  const double t4 = k32 * k32;
  const double t5 = t2 * t2;
  const double t6 = t4 * t4;
  const double t7 = t3 * t3;
  const double t8 = k13 * k13;
  const double t9 = k15 * k15;
  const double t10 = k23 * k23;
  const double t11 = k25 * k25;
  const double t12 = k33 * k33;
  const double t13 = k35 * k35;
  const double t14 = k16 * k16;
  const double t15 = k26 * k26;
  const double t16 = k36 * k36;
  const double t17 = t8 * t8;
  const double t18 = t9 * t9;
  const double t19 = t12 * t12;
  const double t20 = t10 * t10;

  coeffs(0) = t2 * -8.0 - t3 * 8.0 - t4 * 8.0 + t5 + t6 + t7 + t2 * t3 * 2.0 +
              t2 * t4 * 2.0 + t3 * t4 * 2.0 - k12 * k22 * k32 * 8.0 +
              t2 * t3 * t4 + k12 * k22 * k32 * t2 * 2.0 +
              k12 * k22 * k32 * t3 * 2.0 + k12 * k22 * k32 * t4 * 2.0 + 1.6E1;
  coeffs(1) =
      k25 * 3.2E1 + k35 * 3.2E1 - k22 * k23 * 1.6E1 - k32 * k33 * 1.6E1 -
      k25 * t2 * 1.6E1 - k25 * t3 * 8.0 - k25 * t4 * 1.6E1 + k25 * t5 * 2.0 +
      k25 * t6 * 2.0 - k35 * t2 * 1.6E1 - k35 * t3 * 1.6E1 - k35 * t4 * 8.0 +
      k35 * t5 * 2.0 + k35 * t7 * 2.0 + k12 * k15 * k22 * 8.0 +
      k12 * k13 * k32 * 8.0 - k12 * k22 * k33 * 8.0 - k12 * k23 * k32 * 8.0 +
      k13 * k22 * t4 * 4.0 - k13 * k22 * t6 + k22 * k23 * t2 * 4.0 +
      k22 * k23 * t3 * 4.0 + k22 * k23 * t4 * 4.0 + k15 * k32 * t3 * 4.0 -
      k15 * k32 * t7 + k32 * k33 * t2 * 4.0 + k32 * k33 * t3 * 4.0 +
      k32 * k33 * t4 * 4.0 + k25 * t2 * t3 * 2.0 + k25 * t2 * t4 * 4.0 +
      k25 * t3 * t4 * 2.0 + k35 * t2 * t3 * 4.0 + k35 * t2 * t4 * 2.0 +
      k35 * t3 * t4 * 2.0 - k12 * k22 * k25 * k32 * 1.2E1 -
      k12 * k22 * k32 * k35 * 1.2E1 - k12 * k15 * k22 * t2 * 2.0 -
      k12 * k15 * k22 * t3 * 2.0 - k12 * k15 * k22 * t4 * 2.0 -
      k12 * k13 * k32 * t2 * 2.0 - k12 * k13 * k32 * t3 * 2.0 -
      k12 * k13 * k32 * t4 * 2.0 + k12 * k22 * k33 * t2 * 2.0 +
      k12 * k23 * k32 * t2 * 2.0 + k12 * k22 * k33 * t3 * 2.0 +
      k12 * k23 * k32 * t3 * 6.0 + k12 * k22 * k33 * t4 * 6.0 +
      k12 * k23 * k32 * t4 * 2.0 - k13 * k22 * t2 * t4 * 3.0 -
      k13 * k22 * t3 * t4 + k22 * k23 * t2 * t4 * 2.0 -
      k15 * k32 * t2 * t3 * 3.0 - k15 * k32 * t3 * t4 +
      k32 * k33 * t2 * t3 * 2.0 + k25 * t2 * t3 * t4 + k35 * t2 * t3 * t4 +
      k12 * k22 * k25 * k32 * t2 * 3.0 + k12 * k22 * k25 * k32 * t3 +
      k12 * k22 * k25 * k32 * t4 * 3.0 + k12 * k22 * k32 * k35 * t2 * 3.0 +
      k12 * k22 * k32 * k35 * t3 * 3.0 + k12 * k22 * k32 * k35 * t4 -
      k12 * k15 * k22 * t3 * t4 - k12 * k13 * k32 * t3 * t4;
  coeffs(2) =
      k16 * -3.2E1 + k26 * 3.2E1 + k36 * 3.2E1 + t8 * 8.0 + t9 * 8.0 -
      t10 * 8.0 + t11 * 2.4E1 - t12 * 8.0 + t13 * 2.4E1 + k25 * k35 * 4.8E1 +
      k16 * t2 * 8.0 + k16 * t3 * 1.6E1 + k16 * t4 * 1.6E1 - k16 * t6 * 2.0 -
      k16 * t7 * 2.0 - k26 * t2 * 1.6E1 - k26 * t3 * 8.0 - k26 * t4 * 1.6E1 +
      k26 * t5 * 2.0 + k26 * t6 * 2.0 - k36 * t2 * 1.6E1 - k36 * t3 * 1.6E1 -
      k36 * t4 * 8.0 + k36 * t5 * 2.0 + k36 * t7 * 2.0 + t2 * t8 * 2.0 +
      t2 * t9 * 2.0 - t3 * t8 * 2.0 + t2 * t10 * 2.0 - t3 * t9 * 6.0 -
      t4 * t8 * 6.0 - t2 * t11 * 1.0E1 + t3 * t10 * 6.0 - t4 * t9 * 2.0 +
      t2 * t12 * 2.0 - t3 * t11 * 2.0 + t4 * t10 * 2.0 + t6 * t8 -
      t2 * t13 * 1.0E1 + t3 * t12 * 2.0 - t4 * t11 * 1.0E1 - t3 * t13 * 1.0E1 +
      t4 * t12 * 6.0 + t5 * t11 + t7 * t9 - t4 * t13 * 2.0 + t6 * t11 +
      t5 * t13 + t7 * t13 - k12 * k13 * k15 * 1.6E1 + k12 * k15 * k23 * 8.0 +
      k12 * k13 * k33 * 8.0 - k13 * k22 * k25 * 8.0 - k12 * k23 * k33 * 8.0 +
      k13 * k22 * k35 * 8.0 - k22 * k23 * k25 * 1.6E1 + k15 * k25 * k32 * 8.0 -
      k22 * k23 * k35 * 3.2E1 - k15 * k32 * k35 * 8.0 -
      k25 * k32 * k33 * 3.2E1 - k32 * k33 * k35 * 1.6E1 + k13 * k23 * t4 * 4.0 -
      k13 * k23 * t6 + k15 * k33 * t3 * 4.0 - k15 * k33 * t7 -
      k25 * k35 * t2 * 2.8E1 - k25 * k35 * t3 * 1.2E1 - k25 * k35 * t4 * 1.2E1 +
      k25 * k35 * t5 * 4.0 - k16 * t2 * t3 * 2.0 - k16 * t2 * t4 * 2.0 -
      k16 * t3 * t4 * 8.0 + k16 * t3 * t6 + k16 * t4 * t7 +
      k26 * t2 * t3 * 2.0 + k26 * t2 * t4 * 4.0 + k26 * t3 * t4 * 2.0 +
      k36 * t2 * t3 * 4.0 + k36 * t2 * t4 * 2.0 + k36 * t3 * t4 * 2.0 +
      t2 * t3 * t9 + t2 * t4 * t8 + t3 * t4 * t8 * 2.0 + t2 * t3 * t11 +
      t2 * t4 * t10 + t3 * t4 * t9 * 2.0 + t2 * t3 * t12 + t2 * t4 * t11 * 3.0 +
      t2 * t3 * t13 * 3.0 + t3 * t4 * t11 + t2 * t4 * t13 + t3 * t4 * t13 +
      k12 * k15 * k22 * k25 * 1.6E1 + k12 * k13 * k25 * k32 * 8.0 +
      k12 * k16 * k22 * k32 * 4.0 - k13 * k15 * k22 * k32 * 1.2E1 +
      k12 * k15 * k22 * k35 * 8.0 + k12 * k13 * k32 * k35 * 1.6E1 -
      k12 * k22 * k25 * k33 * 1.2E1 - k12 * k22 * k26 * k32 * 1.2E1 -
      k12 * k23 * k25 * k32 * 1.2E1 + k15 * k22 * k23 * k32 * 8.0 +
      k13 * k22 * k32 * k33 * 8.0 - k12 * k22 * k32 * k36 * 1.2E1 -
      k12 * k22 * k33 * k35 * 1.2E1 - k12 * k23 * k32 * k35 * 1.2E1 +
      k22 * k23 * k32 * k33 * 8.0 + k12 * k13 * k15 * t3 * 4.0 +
      k12 * k13 * k15 * t4 * 4.0 - k12 * k15 * k23 * t2 * 2.0 -
      k12 * k15 * k23 * t3 * 6.0 - k12 * k15 * k23 * t4 * 2.0 -
      k12 * k13 * k33 * t2 * 2.0 - k12 * k13 * k33 * t3 * 2.0 -
      k12 * k13 * k33 * t4 * 6.0 - k13 * k22 * k25 * t2 * 2.0 +
      k13 * k22 * k25 * t3 * 2.0 + k13 * k22 * k25 * t4 * 6.0 -
      k13 * k22 * k25 * t6 + k12 * k23 * k33 * t2 * 2.0 +
      k12 * k23 * k33 * t3 * 6.0 + k12 * k23 * k33 * t4 * 6.0 +
      k13 * k22 * k35 * t2 * 2.0 + k22 * k23 * k25 * t2 * 4.0 -
      k13 * k22 * k35 * t3 * 2.0 + k12 * k22 * k32 * t8 * 2.0 +
      k13 * k22 * k35 * t4 * 2.0 + k15 * k25 * k32 * t2 * 2.0 +
      k22 * k23 * k25 * t4 * 4.0 + k12 * k22 * k32 * t9 * 2.0 +
      k15 * k25 * k32 * t3 * 2.0 + k12 * k22 * k32 * t10 * 6.0 -
      k15 * k25 * k32 * t4 * 2.0 - k12 * k22 * k32 * t11 * 2.0 +
      k12 * k22 * k32 * t12 * 6.0 - k12 * k22 * k32 * t13 * 2.0 +
      k22 * k23 * k35 * t2 * 8.0 + k22 * k23 * k35 * t3 * 8.0 -
      k15 * k32 * k35 * t2 * 2.0 + k22 * k23 * k35 * t4 * 4.0;
  coeffs(2) +=
      k15 * k32 * k35 * t3 * 6.0 + k15 * k32 * k35 * t4 * 2.0 -
      k15 * k32 * k35 * t7 + k25 * k32 * k33 * t2 * 8.0 +
      k25 * k32 * k33 * t3 * 4.0 + k25 * k32 * k33 * t4 * 8.0 +
      k32 * k33 * k35 * t2 * 4.0 + k32 * k33 * k35 * t3 * 4.0 -
      k13 * k23 * t2 * t4 * 3.0 - k13 * k23 * t3 * t4 * 3.0 -
      k15 * k33 * t2 * t3 * 3.0 - k15 * k33 * t3 * t4 * 3.0 +
      k25 * k35 * t2 * t3 * 2.0 + k25 * k35 * t2 * t4 * 2.0 +
      k16 * t2 * t3 * t4 * 2.0 + k26 * t2 * t3 * t4 + k36 * t2 * t3 * t4 -
      k12 * k13 * k22 * k23 * k32 * 4.0 - k12 * k15 * k22 * k32 * k33 * 4.0 -
      k12 * k22 * k25 * k32 * k35 * 2.0E1 - k12 * k15 * k22 * k25 * t2 * 2.0 -
      k12 * k15 * k22 * k25 * t3 * 2.0 - k12 * k15 * k22 * k25 * t4 * 2.0 -
      k12 * k13 * k25 * k32 * t2 * 4.0 + k12 * k16 * k22 * k32 * t2 +
      k13 * k15 * k22 * k32 * t2 * 3.0 - k12 * k13 * k25 * k32 * t3 * 2.0 -
      k12 * k16 * k22 * k32 * t3 + k13 * k15 * k22 * k32 * t3 * 3.0 -
      k12 * k13 * k25 * k32 * t4 * 2.0 - k12 * k15 * k22 * k35 * t2 * 4.0 -
      k12 * k16 * k22 * k32 * t4 + k13 * k15 * k22 * k32 * t4 * 3.0 -
      k12 * k15 * k22 * k35 * t3 * 2.0 - k12 * k15 * k22 * k35 * t4 * 2.0 -
      k12 * k13 * k32 * k35 * t2 * 2.0 + k12 * k22 * k25 * k33 * t2 * 3.0 +
      k12 * k22 * k26 * k32 * t2 * 3.0 + k12 * k23 * k25 * k32 * t2 * 3.0 -
      k15 * k22 * k23 * k32 * t2 * 6.0 - k12 * k13 * k32 * k35 * t3 * 2.0 +
      k12 * k22 * k25 * k33 * t3 + k12 * k22 * k26 * k32 * t3 +
      k12 * k23 * k25 * k32 * t3 * 3.0 - k15 * k22 * k23 * k32 * t3 * 4.0 -
      k12 * k13 * k32 * k35 * t4 * 2.0 + k12 * k22 * k25 * k33 * t4 * 9.0 +
      k12 * k22 * k26 * k32 * t4 * 3.0 + k12 * k23 * k25 * k32 * t4 * 3.0 -
      k15 * k22 * k23 * k32 * t4 * 2.0 - k13 * k22 * k32 * k33 * t2 * 6.0 -
      k13 * k22 * k32 * k33 * t3 * 2.0 + k12 * k22 * k32 * k36 * t2 * 3.0 +
      k12 * k22 * k33 * k35 * t2 * 3.0 + k12 * k23 * k32 * k35 * t2 * 3.0 -
      k13 * k22 * k32 * k33 * t4 * 4.0 + k12 * k22 * k32 * k36 * t3 * 3.0 +
      k12 * k22 * k33 * k35 * t3 * 3.0 + k12 * k23 * k32 * k35 * t3 * 9.0 +
      k12 * k22 * k32 * k36 * t4 + k12 * k22 * k33 * k35 * t4 * 3.0 +
      k12 * k23 * k32 * k35 * t4 + k22 * k23 * k32 * k33 * t2 * 4.0 +
      k12 * k13 * k15 * t3 * t4 * 2.0 - k12 * k15 * k23 * t3 * t4 * 3.0 -
      k12 * k13 * k33 * t3 * t4 * 3.0 - k13 * k22 * k25 * t2 * t4 * 4.0 -
      k13 * k22 * k25 * t3 * t4 - k13 * k22 * k35 * t2 * t4 * 2.0 +
      k22 * k23 * k25 * t2 * t4 * 2.0 - k15 * k25 * k32 * t2 * t3 * 2.0 +
      k12 * k22 * k32 * t3 * t9 + k12 * k22 * k32 * t4 * t8 +
      k12 * k22 * k32 * t2 * t11 + k12 * k22 * k32 * t2 * t13 +
      k12 * k22 * k32 * t4 * t11 + k12 * k22 * k32 * t3 * t13 +
      k22 * k23 * k35 * t2 * t4 * 2.0 - k15 * k32 * k35 * t2 * t3 * 4.0 -
      k15 * k32 * k35 * t3 * t4 + k25 * k32 * k33 * t2 * t3 * 2.0 +
      k32 * k33 * k35 * t2 * t3 * 2.0 + k25 * k35 * t2 * t3 * t4 -
      k12 * k13 * k22 * k23 * k32 * t4 * 2.0 -
      k12 * k15 * k22 * k32 * k33 * t3 * 2.0 +
      k12 * k22 * k25 * k32 * k35 * t2 * 4.0 +
      k12 * k22 * k25 * k32 * k35 * t3 + k12 * k22 * k25 * k32 * k35 * t4 -
      k12 * k13 * k25 * k32 * t3 * t4 + k12 * k16 * k22 * k32 * t3 * t4 -
      k12 * k15 * k22 * k35 * t3 * t4;
  coeffs(3) =
      k16 * k25 * -4.8E1 - k16 * k35 * 4.8E1 + k25 * k26 * 4.8E1 +
      k25 * k36 * 4.8E1 + k26 * k35 * 4.8E1 + k35 * k36 * 4.8E1 +
      k25 * t8 * 1.6E1 + k25 * t9 * 8.0 - k25 * t10 * 8.0 + k25 * t11 * 8.0 -
      k25 * t12 * 1.6E1 + k25 * t13 * 2.4E1 + k35 * t8 * 8.0 +
      k35 * t9 * 1.6E1 - k35 * t10 * 1.6E1 + k35 * t11 * 2.4E1 -
      k35 * t12 * 8.0 + k35 * t13 * 8.0 - k13 * k16 * k22 * 8.0 -
      k13 * k22 * k26 * 8.0 - k13 * k23 * k25 * 8.0 + k16 * k22 * k23 * 3.2E1 -
      k15 * k16 * k32 * 8.0 + k13 * k22 * k36 * 8.0 + k13 * k23 * k35 * 8.0 -
      k22 * k23 * k26 * 1.6E1 + k15 * k25 * k33 * 8.0 + k15 * k26 * k32 * 8.0 +
      k16 * k32 * k33 * 3.2E1 - k22 * k23 * k36 * 3.2E1 -
      k15 * k32 * k36 * 8.0 - k15 * k33 * k35 * 8.0 - k26 * k32 * k33 * 3.2E1 -
      k32 * k33 * k36 * 1.6E1 + k16 * k25 * t2 * 1.2E1 + k13 * k22 * t9 * 8.0 +
      k16 * k25 * t3 * 1.2E1 + k16 * k25 * t4 * 2.0E1 - k13 * k22 * t11 * 8.0 +
      k13 * k22 * t12 * 4.0 - k16 * k25 * t6 * 2.0 + k13 * k22 * t13 * 8.0 +
      k16 * k35 * t2 * 1.2E1 - k22 * k23 * t8 * 4.0 - k25 * k26 * t2 * 2.0E1 +
      k16 * k35 * t3 * 2.0E1 - k22 * k23 * t9 * 1.2E1 - k25 * k26 * t3 * 4.0 +
      k15 * k32 * t8 * 8.0 + k16 * k35 * t4 * 1.2E1 + k22 * k23 * t10 * 4.0 -
      k25 * k26 * t4 * 2.0E1 - k22 * k23 * t11 * 4.0 + k25 * k26 * t5 * 2.0 +
      k15 * k32 * t10 * 4.0 + k22 * k23 * t12 * 4.0 + k25 * k26 * t6 * 2.0 +
      k15 * k32 * t11 * 8.0 - k16 * k35 * t7 * 2.0 - k22 * k23 * t13 * 2.0E1 -
      k15 * k32 * t13 * 8.0 - k25 * k36 * t2 * 2.8E1 - k26 * k35 * t2 * 2.8E1 -
      k25 * k36 * t3 * 1.2E1 - k26 * k35 * t3 * 1.2E1 - k25 * k36 * t4 * 1.2E1 -
      k26 * k35 * t4 * 1.2E1 + k25 * k36 * t5 * 4.0 + k26 * k35 * t5 * 4.0 -
      k32 * k33 * t8 * 1.2E1 - k35 * k36 * t2 * 2.0E1 - k32 * k33 * t9 * 4.0 -
      k35 * k36 * t3 * 2.0E1 + k32 * k33 * t10 * 4.0 - k35 * k36 * t4 * 4.0 -
      k32 * k33 * t11 * 2.0E1 + k35 * k36 * t5 * 2.0 + k32 * k33 * t12 * 4.0 -
      k32 * k33 * t13 * 4.0 + k35 * k36 * t7 * 2.0 + k25 * t2 * t8 * 4.0 +
      k25 * t2 * t9 * 2.0 - k25 * t3 * t8 * 2.0 + k25 * t2 * t10 * 2.0 -
      k25 * t3 * t9 * 4.0 - k25 * t4 * t8 * 8.0 - k25 * t2 * t11 * 2.0 -
      k25 * t4 * t9 * 2.0 + k25 * t2 * t12 * 4.0 + k25 * t4 * t10 * 2.0 +
      k25 * t6 * t8 - k25 * t2 * t13 * 1.4E1 + k25 * t3 * t12 * 2.0 -
      k25 * t4 * t11 * 2.0 - k25 * t3 * t13 * 4.0 + k25 * t4 * t12 * 1.2E1 -
      k25 * t4 * t13 * 2.0 + k25 * t5 * t13 * 2.0 + k35 * t2 * t8 * 2.0 +
      k35 * t2 * t9 * 4.0 - k35 * t3 * t8 * 2.0 + k35 * t2 * t10 * 4.0 -
      k35 * t3 * t9 * 8.0 - k35 * t4 * t8 * 4.0 - k35 * t2 * t11 * 1.4E1 +
      k35 * t3 * t10 * 1.2E1 - k35 * t4 * t9 * 2.0 + k35 * t2 * t12 * 2.0 -
      k35 * t3 * t11 * 2.0 + k35 * t4 * t10 * 2.0 - k35 * t2 * t13 * 2.0 +
      k35 * t3 * t12 * 2.0 - k35 * t4 * t11 * 4.0 - k35 * t3 * t13 * 2.0 +
      k35 * t5 * t11 * 2.0 + k35 * t7 * t9 - k12 * k13 * k15 * k25 * 2.4E1 -
      k12 * k13 * k15 * k35 * 2.4E1 + k12 * k15 * k22 * k26 * 1.6E1 +
      k12 * k15 * k23 * k25 * 1.6E1 + k12 * k13 * k25 * k33 * 8.0 +
      k12 * k13 * k26 * k32 * 8.0 + k12 * k16 * k22 * k33 * 4.0 +
      k12 * k16 * k23 * k32 * 4.0 - k13 * k15 * k22 * k33 * 1.2E1 -
      k13 * k15 * k23 * k32 * 1.2E1 + k12 * k15 * k22 * k36 * 8.0 +
      k12 * k15 * k23 * k35 * 8.0 + k12 * k13 * k32 * k36 * 1.6E1 +
      k12 * k13 * k33 * k35 * 1.6E1 - k12 * k22 * k26 * k33 * 1.2E1 -
      k12 * k23 * k25 * k33 * 1.2E1 - k12 * k23 * k26 * k32 * 1.2E1 +
      k15 * k22 * k23 * k33 * 8.0 + k13 * k23 * k32 * k33 * 8.0 -
      k12 * k22 * k33 * k36 * 1.2E1 - k12 * k23 * k32 * k36 * 1.2E1 -
      k12 * k23 * k33 * k35 * 1.2E1 - k22 * k23 * k25 * k35 * 2.4E1 -
      k25 * k32 * k33 * k35 * 2.4E1 - k13 * k16 * k22 * t2 * 2.0 +
      k13 * k16 * k22 * t3 * 2.0 + k13 * k16 * k22 * t4 * 6.0 -
      k12 * k15 * k22 * t8 * 2.0 - k13 * k16 * k22 * t6 -
      k12 * k15 * k22 * t9 * 2.0 - k12 * k15 * k22 * t10 * 6.0 +
      k12 * k15 * k22 * t11 * 6.0 - k12 * k15 * k22 * t12 * 2.0 -
      k12 * k15 * k22 * t13 * 2.0 - k13 * k22 * k26 * t2 * 2.0 -
      k13 * k23 * k25 * t2 * 2.0 - k16 * k22 * k23 * t2 * 4.0 +
      k13 * k22 * k26 * t3 * 2.0 + k13 * k23 * k25 * t3 * 6.0 -
      k16 * k22 * k23 * t3 * 8.0 - k12 * k13 * k32 * t8 * 2.0 +
      k13 * k22 * k26 * t4 * 6.0 + k13 * k23 * k25 * t4 * 6.0 -
      k15 * k16 * k32 * t2 * 2.0 - k16 * k22 * k23 * t4 * 1.6E1 -
      k12 * k13 * k32 * t9 * 2.0 + k15 * k16 * k32 * t3 * 6.0 -
      k12 * k13 * k32 * t10 * 2.0 - k13 * k22 * k26 * t6 -
      k13 * k23 * k25 * t6 + k15 * k16 * k32 * t4 * 2.0 +
      k16 * k22 * k23 * t6 * 2.0 - k12 * k13 * k32 * t11 * 2.0 -
      k12 * k13 * k32 * t12 * 6.0 + k12 * k13 * k32 * t13 * 6.0 -
      k15 * k16 * k32 * t7 + k13 * k22 * k36 * t2 * 2.0 +
      k13 * k23 * k35 * t2 * 2.0 + k22 * k23 * k26 * t2 * 4.0 -
      k13 * k22 * k36 * t3 * 2.0 - k13 * k23 * k35 * t3 * 6.0 +
      k12 * k22 * k33 * t8 * 2.0 + k12 * k23 * k32 * t8 * 2.0 +
      k13 * k22 * k36 * t4 * 2.0 + k13 * k23 * k35 * t4 * 2.0 +
      k15 * k25 * k33 * t2 * 2.0 + k15 * k26 * k32 * t2 * 2.0 +
      k22 * k23 * k26 * t4 * 4.0 + k12 * k22 * k33 * t9 * 2.0 +
      k12 * k23 * k32 * t9 * 2.0 + k15 * k25 * k33 * t3 * 2.0 +
      k15 * k26 * k32 * t3 * 2.0 + k12 * k22 * k33 * t10 * 6.0 +
      k12 * k23 * k32 * t10 * 2.0 - k15 * k25 * k33 * t4 * 6.0 -
      k15 * k26 * k32 * t4 * 2.0 - k12 * k22 * k33 * t11 * 2.0 -
      k12 * k23 * k32 * t11 * 2.0 + k12 * k22 * k33 * t12 * 2.0 +
      k12 * k23 * k32 * t12 * 6.0 - k12 * k22 * k33 * t13 * 2.0 -
      k12 * k23 * k32 * t13 * 2.0 - k16 * k32 * k33 * t2 * 4.0 +
      k22 * k23 * k36 * t2 * 8.0 - k16 * k32 * k33 * t3 * 1.6E1 +
      k22 * k23 * k36 * t3 * 8.0 - k15 * k32 * k36 * t2 * 2.0 -
      k15 * k33 * k35 * t2 * 2.0 - k16 * k32 * k33 * t4 * 8.0 +
      k22 * k23 * k36 * t4 * 4.0 + k15 * k32 * k36 * t3 * 6.0 +
      k15 * k33 * k35 * t3 * 6.0 + k15 * k32 * k36 * t4 * 2.0 +
      k15 * k33 * k35 * t4 * 6.0 + k16 * k32 * k33 * t7 * 2.0 -
      k15 * k32 * k36 * t7 - k15 * k33 * k35 * t7 + k26 * k32 * k33 * t2 * 8.0 +
      k26 * k32 * k33 * t3 * 4.0 + k26 * k32 * k33 * t4 * 8.0 +
      k32 * k33 * k36 * t2 * 4.0 + k32 * k33 * k36 * t3 * 4.0 -
      k13 * k22 * t3 * t9 * 2.0 - k13 * k22 * t4 * t8 -
      k16 * k25 * t2 * t4 * 4.0 - k13 * k22 * t2 * t11 * 2.0 -
      k13 * k22 * t4 * t9 * 3.0 - k16 * k25 * t3 * t4 * 4.0 -
      k13 * k22 * t2 * t12 * 3.0 - k13 * k22 * t4 * t10 * 3.0 +
      k13 * k22 * t2 * t13 * 2.0 - k13 * k22 * t3 * t12 + k13 * k22 * t4 * t11 -
      k13 * k22 * t3 * t13 * 2.0 - k13 * k22 * t4 * t12 * 6.0 -
      k13 * k22 * t4 * t13 - k16 * k35 * t2 * t3 * 4.0 +
      k22 * k23 * t2 * t9 * 2.0 + k25 * k26 * t2 * t3 * 2.0 +
      k22 * k23 * t3 * t9 * 4.0 + k22 * k23 * t4 * t8 * 4.0 +
      k25 * k26 * t2 * t4 * 6.0 - k15 * k32 * t3 * t8 * 3.0 -
      k16 * k35 * t3 * t4 * 4.0 + k22 * k23 * t2 * t11 * 2.0 +
      k22 * k23 * t4 * t9 * 4.0 + k25 * k26 * t3 * t4 * 2.0 -
      k15 * k32 * t2 * t10 * 3.0 - k15 * k32 * t3 * t9 -
      k15 * k32 * t4 * t8 * 2.0 + k22 * k23 * t2 * t12 * 2.0 +
      k15 * k32 * t2 * t11 * 2.0 - k15 * k32 * t3 * t10 * 6.0 +
      k22 * k23 * t2 * t13 * 6.0 + k22 * k23 * t4 * t11 * 2.0 -
      k15 * k32 * t3 * t11 - k15 * k32 * t4 * t10 + k22 * k23 * t3 * t13 * 4.0 -
      k15 * k32 * t2 * t13 * 2.0 - k15 * k32 * t3 * t12 * 3.0 -
      k15 * k32 * t4 * t11 * 2.0 + k22 * k23 * t4 * t13 * 2.0 +
      k15 * k32 * t3 * t13 + k25 * k36 * t2 * t3 * 2.0 +
      k26 * k35 * t2 * t3 * 2.0 + k25 * k36 * t2 * t4 * 2.0 +
      k26 * k35 * t2 * t4 * 2.0 + k32 * k33 * t2 * t8 * 2.0 +
      k32 * k33 * t3 * t8 * 4.0 + k35 * k36 * t2 * t3 * 6.0 +
      k32 * k33 * t2 * t10 * 2.0 + k32 * k33 * t3 * t9 * 4.0 +
      k32 * k33 * t4 * t8 * 4.0 + k35 * k36 * t2 * t4 * 2.0 +
      k32 * k33 * t2 * t11 * 6.0 + k35 * k36 * t3 * t4 * 2.0 +
      k32 * k33 * t3 * t11 * 2.0 + k32 * k33 * t2 * t13 * 2.0 +
      k32 * k33 * t4 * t11 * 4.0 + k32 * k33 * t3 * t13 * 2.0 +
      k25 * t2 * t4 * t8 * 2.0 + k25 * t3 * t4 * t8 * 2.0 +
      k25 * t2 * t4 * t10 + k25 * t2 * t3 * t12 + k25 * t2 * t4 * t11 +
      k25 * t2 * t4 * t13 + k35 * t2 * t3 * t9 * 2.0 + k35 * t2 * t3 * t11 +
      k35 * t2 * t4 * t10 + k35 * t3 * t4 * t9 * 2.0 + k35 * t2 * t3 * t12;
  coeffs(3) +=
      k35 * t2 * t3 * t13 + k12 * k13 * k15 * k22 * k23 * 8.0 -
      k12 * k13 * k22 * k23 * k33 * 4.0 + k12 * k13 * k15 * k32 * k33 * 8.0 +
      k12 * k16 * k22 * k25 * k32 * 4.0 - k13 * k15 * k22 * k25 * k32 * 1.2E1 +
      k12 * k15 * k22 * k25 * k35 * 2.0E1 - k12 * k15 * k23 * k32 * k33 * 4.0 +
      k12 * k13 * k25 * k32 * k35 * 2.0E1 + k12 * k16 * k22 * k32 * k35 * 4.0 -
      k12 * k22 * k25 * k26 * k32 * 4.0 - k13 * k15 * k22 * k32 * k35 * 1.2E1 +
      k15 * k22 * k23 * k25 * k32 * 4.0 + k13 * k22 * k25 * k32 * k33 * 1.2E1 -
      k12 * k22 * k25 * k32 * k36 * 2.0E1 -
      k12 * k22 * k25 * k33 * k35 * 2.0E1 -
      k12 * k22 * k26 * k32 * k35 * 2.0E1 -
      k12 * k23 * k25 * k32 * k35 * 2.0E1 +
      k15 * k22 * k23 * k32 * k35 * 1.2E1 + k13 * k22 * k32 * k33 * k35 * 4.0 +
      k22 * k23 * k25 * k32 * k33 * 8.0 - k12 * k22 * k32 * k35 * k36 * 4.0 +
      k22 * k23 * k32 * k33 * k35 * 8.0 + k12 * k13 * k15 * k25 * t3 * 4.0 +
      k12 * k13 * k15 * k25 * t4 * 4.0 - k12 * k15 * k16 * k22 * t4 * 2.0 -
      k12 * k13 * k16 * k32 * t3 * 2.0 - k12 * k15 * k22 * k26 * t2 * 2.0 -
      k12 * k15 * k23 * k25 * t2 * 2.0 + k12 * k13 * k15 * k35 * t3 * 4.0 -
      k12 * k15 * k22 * k26 * t3 * 2.0 - k12 * k15 * k23 * k25 * t3 * 6.0 +
      k12 * k13 * k15 * k35 * t4 * 4.0 - k12 * k15 * k22 * k26 * t4 * 2.0 -
      k12 * k15 * k23 * k25 * t4 * 2.0 - k12 * k13 * k25 * k33 * t2 * 4.0 -
      k12 * k13 * k26 * k32 * t2 * 4.0 + k12 * k16 * k22 * k33 * t2 +
      k12 * k16 * k23 * k32 * t2 + k13 * k15 * k22 * k33 * t2 * 3.0 +
      k13 * k15 * k23 * k32 * t2 * 3.0 - k12 * k13 * k25 * k33 * t3 * 2.0 -
      k12 * k13 * k26 * k32 * t3 * 2.0 - k12 * k16 * k22 * k33 * t3 -
      k12 * k16 * k23 * k32 * t3 * 3.0 + k13 * k15 * k22 * k33 * t3 * 3.0 +
      k13 * k15 * k23 * k32 * t3 * 9.0 - k12 * k13 * k25 * k33 * t4 * 6.0 -
      k12 * k13 * k26 * k32 * t4 * 2.0 - k12 * k15 * k22 * k36 * t2 * 4.0 -
      k12 * k15 * k23 * k35 * t2 * 4.0 - k12 * k16 * k22 * k33 * t4 * 3.0 -
      k12 * k16 * k23 * k32 * t4 + k13 * k15 * k22 * k33 * t4 * 9.0 +
      k13 * k15 * k23 * k32 * t4 * 3.0 - k12 * k15 * k22 * k36 * t3 * 2.0 -
      k12 * k15 * k23 * k35 * t3 * 6.0 - k12 * k15 * k22 * k36 * t4 * 2.0 -
      k12 * k15 * k23 * k35 * t4 * 2.0 - k12 * k13 * k32 * k36 * t2 * 2.0 -
      k12 * k13 * k33 * k35 * t2 * 2.0 + k12 * k22 * k26 * k33 * t2 * 3.0 +
      k12 * k23 * k25 * k33 * t2 * 3.0 + k12 * k23 * k26 * k32 * t2 * 3.0 -
      k15 * k22 * k23 * k33 * t2 * 6.0 - k12 * k13 * k32 * k36 * t3 * 2.0 -
      k12 * k13 * k33 * k35 * t3 * 2.0 + k12 * k22 * k26 * k33 * t3 +
      k12 * k23 * k25 * k33 * t3 * 3.0 + k12 * k23 * k26 * k32 * t3 * 3.0 -
      k15 * k22 * k23 * k33 * t3 * 4.0 - k12 * k13 * k32 * k36 * t4 * 2.0 -
      k12 * k13 * k33 * k35 * t4 * 6.0 + k12 * k22 * k26 * k33 * t4 * 9.0 +
      k12 * k23 * k25 * k33 * t4 * 9.0 + k12 * k23 * k26 * k32 * t4 * 3.0 -
      k15 * k22 * k23 * k33 * t4 * 6.0 + k13 * k22 * k25 * k35 * t3 * 2.0 +
      k12 * k22 * k25 * k32 * t8 * 5.0 + k13 * k22 * k25 * k35 * t4 * 4.0 -
      k12 * k22 * k25 * k32 * t9 + k12 * k22 * k25 * k32 * t10 * 3.0 +
      k12 * k22 * k25 * k32 * t11 + k12 * k22 * k25 * k32 * t12 * 9.0 -
      k13 * k23 * k32 * k33 * t2 * 6.0 - k12 * k22 * k25 * k32 * t13 * 5.0 -
      k13 * k23 * k32 * k33 * t3 * 6.0 + k12 * k22 * k33 * k36 * t2 * 3.0 +
      k12 * k23 * k32 * k36 * t2 * 3.0 + k12 * k23 * k33 * k35 * t2 * 3.0 -
      k13 * k23 * k32 * k33 * t4 * 4.0 + k12 * k22 * k33 * k36 * t3 * 3.0 +
      k12 * k23 * k32 * k36 * t3 * 9.0 + k12 * k23 * k33 * k35 * t3 * 9.0 +
      k12 * k22 * k33 * k36 * t4 * 3.0 + k12 * k23 * k32 * k36 * t4 +
      k12 * k23 * k33 * k35 * t4 * 3.0 + k22 * k23 * k25 * k35 * t2 * 4.0 -
      k12 * k22 * k32 * k35 * t8 + k12 * k22 * k32 * k35 * t9 * 5.0 +
      k15 * k25 * k32 * k35 * t3 * 4.0 + k12 * k22 * k32 * k35 * t10 * 9.0 +
      k15 * k25 * k32 * k35 * t4 * 2.0 - k12 * k22 * k32 * k35 * t11 * 5.0 +
      k12 * k22 * k32 * k35 * t12 * 3.0 + k12 * k22 * k32 * k35 * t13 +
      k25 * k32 * k33 * k35 * t2 * 4.0 - k13 * k16 * k22 * t2 * t4 -
      k13 * k16 * k22 * t3 * t4 * 2.0 - k12 * k15 * k22 * t4 * t8 -
      k12 * k15 * k22 * t4 * t10 * 3.0 - k12 * k15 * k22 * t2 * t13 * 2.0 -
      k12 * k15 * k22 * t3 * t12 - k12 * k15 * k22 * t4 * t11 -
      k12 * k15 * k22 * t4 * t13 - k13 * k22 * k26 * t2 * t4 * 4.0 -
      k13 * k23 * k25 * t2 * t4 * 4.0 + k16 * k22 * k23 * t2 * t4 * 4.0 -
      k13 * k22 * k26 * t3 * t4 - k13 * k23 * k25 * t3 * t4 * 3.0 -
      k15 * k16 * k32 * t2 * t3 + k16 * k22 * k23 * t3 * t4 * 4.0 -
      k12 * k13 * k32 * t3 * t9 - k12 * k13 * k32 * t2 * t11 * 2.0 -
      k15 * k16 * k32 * t3 * t4 * 2.0 - k12 * k13 * k32 * t3 * t11 -
      k12 * k13 * k32 * t4 * t10 - k12 * k13 * k32 * t3 * t12 * 3.0 -
      k12 * k13 * k32 * t3 * t13 - k13 * k22 * k36 * t2 * t4 * 2.0 -
      k13 * k23 * k35 * t2 * t4 * 2.0 + k22 * k23 * k26 * t2 * t4 * 2.0 -
      k15 * k25 * k33 * t2 * t3 * 2.0 - k15 * k26 * k32 * t2 * t3 * 2.0 +
      k12 * k22 * k33 * t3 * t9 + k12 * k22 * k33 * t4 * t8 * 3.0 +
      k12 * k23 * k32 * t3 * t9 * 3.0 + k12 * k23 * k32 * t4 * t8 +
      k12 * k22 * k33 * t2 * t11 + k12 * k23 * k32 * t2 * t11 +
      k12 * k22 * k33 * t2 * t13 + k12 * k22 * k33 * t4 * t11 * 3.0 +
      k12 * k23 * k32 * t2 * t13 + k12 * k23 * k32 * t4 * t11 +
      k12 * k22 * k33 * t3 * t13 + k12 * k23 * k32 * t3 * t13 * 3.0 +
      k16 * k32 * k33 * t2 * t3 * 4.0 + k22 * k23 * k36 * t2 * t4 * 2.0 -
      k15 * k32 * k36 * t2 * t3 * 4.0 - k15 * k33 * k35 * t2 * t3 * 4.0 +
      k16 * k32 * k33 * t3 * t4 * 4.0 - k15 * k32 * k36 * t3 * t4 -
      k15 * k33 * k35 * t3 * t4 * 3.0 + k26 * k32 * k33 * t2 * t3 * 2.0 +
      k32 * k33 * k36 * t2 * t3 * 2.0 + k16 * k25 * t2 * t3 * t4 -
      k13 * k22 * t2 * t4 * t11 + k16 * k35 * t2 * t3 * t4 -
      k15 * k32 * t2 * t3 * t13 + k25 * k36 * t2 * t3 * t4 +
      k26 * k35 * t2 * t3 * t4 - k12 * k13 * k22 * k23 * k25 * k32 * 4.0 -
      k12 * k13 * k22 * k23 * k32 * k35 * 4.0 -
      k12 * k15 * k22 * k25 * k32 * k33 * 4.0 -
      k12 * k15 * k22 * k32 * k33 * k35 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * t4 * 4.0 -
      k12 * k13 * k22 * k23 * k33 * t4 * 6.0 +
      k12 * k13 * k15 * k32 * k33 * t3 * 4.0 +
      k12 * k16 * k22 * k25 * k32 * t2 +
      k13 * k15 * k22 * k25 * k32 * t2 * 3.0 +
      k12 * k16 * k22 * k25 * k32 * t3 + k13 * k15 * k22 * k25 * k32 * t3 -
      k12 * k15 * k22 * k25 * k35 * t2 * 4.0 -
      k12 * k16 * k22 * k25 * k32 * t4 * 2.0 +
      k13 * k15 * k22 * k25 * k32 * t4 * 2.0 -
      k12 * k15 * k22 * k25 * k35 * t3 * 2.0 -
      k12 * k15 * k23 * k32 * k33 * t3 * 6.0 -
      k12 * k13 * k25 * k32 * k35 * t2 * 4.0 +
      k12 * k16 * k22 * k32 * k35 * t2 +
      k12 * k22 * k25 * k26 * k32 * t2 * 2.0 +
      k13 * k15 * k22 * k32 * k35 * t2 * 3.0 -
      k15 * k22 * k23 * k25 * k32 * t2 * 4.0 -
      k12 * k16 * k22 * k32 * k35 * t3 * 2.0 +
      k13 * k15 * k22 * k32 * k35 * t3 * 2.0 -
      k12 * k13 * k25 * k32 * k35 * t4 * 2.0 +
      k12 * k16 * k22 * k32 * k35 * t4 +
      k12 * k22 * k25 * k26 * k32 * t4 * 2.0 +
      k13 * k15 * k22 * k32 * k35 * t4 -
      k13 * k22 * k25 * k32 * k33 * t2 * 8.0 -
      k13 * k22 * k25 * k32 * k33 * t3 * 2.0 +
      k12 * k22 * k25 * k32 * k36 * t2 * 4.0 +
      k12 * k22 * k25 * k33 * k35 * t2 * 4.0 +
      k12 * k22 * k26 * k32 * k35 * t2 * 4.0 +
      k12 * k23 * k25 * k32 * k35 * t2 * 4.0 -
      k13 * k22 * k25 * k32 * k33 * t4 * 4.0 -
      k15 * k22 * k23 * k32 * k35 * t2 * 8.0 +
      k12 * k22 * k25 * k32 * k36 * t3 + k12 * k22 * k25 * k33 * k35 * t3 +
      k12 * k22 * k26 * k32 * k35 * t3 +
      k12 * k23 * k25 * k32 * k35 * t3 * 3.0 -
      k15 * k22 * k23 * k32 * k35 * t3 * 4.0 +
      k12 * k22 * k25 * k32 * k36 * t4 +
      k12 * k22 * k25 * k33 * k35 * t4 * 3.0 +
      k12 * k22 * k26 * k32 * k35 * t4 + k12 * k23 * k25 * k32 * k35 * t4 -
      k15 * k22 * k23 * k32 * k35 * t4 * 2.0 -
      k13 * k22 * k32 * k33 * k35 * t2 * 4.0 +
      k22 * k23 * k25 * k32 * k33 * t2 * 4.0 +
      k12 * k22 * k32 * k35 * k36 * t2 * 2.0 +
      k12 * k22 * k32 * k35 * k36 * t3 * 2.0 +
      k22 * k23 * k32 * k33 * k35 * t2 * 4.0 + k12 * k13 * k15 * k25 * t3 * t4 -
      k12 * k15 * k16 * k22 * t3 * t4 - k12 * k13 * k16 * k32 * t3 * t4 +
      k12 * k13 * k15 * k35 * t3 * t4 - k12 * k13 * k25 * k33 * t3 * t4 * 3.0 -
      k12 * k13 * k26 * k32 * t3 * t4 + k12 * k16 * k22 * k33 * t3 * t4 * 3.0 +
      k12 * k16 * k23 * k32 * t3 * t4 * 3.0 - k12 * k15 * k22 * k36 * t3 * t4 -
      k12 * k15 * k23 * k35 * t3 * t4 * 3.0 -
      k13 * k22 * k25 * k35 * t2 * t4 * 2.0 + k12 * k22 * k25 * k32 * t4 * t8 +
      k12 * k22 * k25 * k32 * t2 * t13 + k22 * k23 * k25 * k35 * t2 * t4 * 2.0 -
      k15 * k25 * k32 * k35 * t2 * t3 * 2.0 + k12 * k22 * k32 * k35 * t3 * t9 +
      k12 * k22 * k32 * k35 * t2 * t11 + k25 * k32 * k33 * k35 * t2 * t3 * 2.0 -
      k12 * k13 * k22 * k23 * k25 * k32 * t4 * 2.0 -
      k12 * k15 * k22 * k32 * k33 * k35 * t3 * 2.0;
  coeffs(4) =
      t14 * 2.4E1 + t15 * 2.4E1 + t16 * 2.4E1 + t17 + t18 + t19 + t20 -
      k16 * k26 * 4.8E1 - k16 * k36 * 4.8E1 + k26 * k36 * 4.8E1 -
      k16 * t8 * 8.0 - k16 * t9 * 8.0 + k16 * t10 * 1.6E1 - k16 * t11 * 2.4E1 +
      k16 * t12 * 1.6E1 - k16 * t13 * 2.4E1 + k26 * t8 * 1.6E1 +
      k26 * t9 * 8.0 - k26 * t10 * 8.0 + k26 * t11 * 2.4E1 - k26 * t12 * 1.6E1 +
      k26 * t13 * 2.4E1 + k36 * t8 * 8.0 + k36 * t9 * 1.6E1 -
      k36 * t10 * 1.6E1 + k36 * t11 * 2.4E1 - k36 * t12 * 8.0 +
      k36 * t13 * 2.4E1 - t2 * t14 * 2.0 - t2 * t15 * 1.0E1 - t3 * t14 * 1.0E1 -
      t8 * t9 * 2.0 - t2 * t16 * 1.0E1 - t3 * t15 * 2.0 - t4 * t14 * 1.0E1 -
      t8 * t10 * 2.0 - t3 * t16 * 1.0E1 - t4 * t15 * 1.0E1 + t8 * t11 * 1.0E1 -
      t9 * t10 * 6.0 - t4 * t16 * 2.0 + t5 * t15 + t6 * t14 - t8 * t12 * 6.0 +
      t9 * t11 * 2.0 + t5 * t16 + t6 * t15 + t7 * t14 + t8 * t13 * 2.0 -
      t9 * t12 * 2.0 - t10 * t11 * 2.0 + t9 * t13 * 1.0E1 + t10 * t12 * 2.0 +
      t7 * t16 - t10 * t13 * 1.0E1 - t11 * t12 * 1.0E1 + t11 * t13 * 6.0 -
      t12 * t13 * 2.0 + t11 * t11 + t13 * t13 - k13 * k16 * k23 * 8.0 -
      k13 * k23 * k26 * 8.0 - k15 * k16 * k33 * 8.0 + k13 * k23 * k36 * 8.0 +
      k15 * k26 * k33 * 8.0 - k16 * k25 * k35 * 4.8E1 - k15 * k33 * k36 * 8.0 +
      k25 * k26 * k35 * 4.8E1 + k25 * k35 * k36 * 4.8E1 +
      k16 * k26 * t2 * 1.2E1 + k13 * k23 * t9 * 8.0 + k16 * k26 * t3 * 1.2E1 +
      k16 * k26 * t4 * 2.0E1 - k13 * k23 * t11 * 8.0 + k13 * k23 * t12 * 4.0 -
      k16 * k26 * t6 * 2.0 + k13 * k23 * t13 * 8.0 + k16 * k36 * t2 * 1.2E1 +
      k16 * k36 * t3 * 2.0E1 + k15 * k33 * t8 * 8.0 + k16 * k36 * t4 * 1.2E1 +
      k15 * k33 * t10 * 4.0 + k15 * k33 * t11 * 8.0 - k16 * k36 * t7 * 2.0 -
      k15 * k33 * t13 * 8.0 - k26 * k36 * t2 * 2.8E1 - k26 * k36 * t3 * 1.2E1 -
      k26 * k36 * t4 * 1.2E1 + k26 * k36 * t5 * 4.0 + k25 * k35 * t8 * 1.2E1 +
      k25 * k35 * t9 * 1.2E1 - k25 * k35 * t10 * 1.2E1 + k25 * k35 * t11 * 4.0 -
      k25 * k35 * t12 * 1.2E1 + k25 * k35 * t13 * 4.0 + k16 * t3 * t8 * 2.0 -
      k16 * t2 * t10 * 2.0 + k16 * t3 * t9 * 2.0 + k16 * t4 * t8 * 2.0 +
      k16 * t2 * t11 * 4.0 - k16 * t3 * t10 * 1.2E1 + k16 * t4 * t9 * 2.0 -
      k16 * t2 * t12 * 2.0 + k16 * t3 * t11 * 2.0 - k16 * t4 * t10 * 8.0 +
      k16 * t2 * t13 * 4.0 - k16 * t3 * t12 * 8.0 + k16 * t4 * t11 * 6.0 +
      k16 * t3 * t13 * 6.0 - k16 * t4 * t12 * 1.2E1 + k16 * t6 * t10 +
      k16 * t4 * t13 * 2.0 + k16 * t7 * t12 + k26 * t2 * t8 * 4.0 +
      k26 * t2 * t9 * 2.0 - k26 * t3 * t8 * 2.0 + k26 * t2 * t10 * 2.0 -
      k26 * t3 * t9 * 4.0 - k26 * t4 * t8 * 8.0 - k26 * t2 * t11 * 6.0 -
      k26 * t4 * t9 * 2.0 + k26 * t2 * t12 * 4.0 + k26 * t4 * t10 * 2.0 +
      k26 * t6 * t8 - k26 * t2 * t13 * 1.4E1 + k26 * t3 * t12 * 2.0 -
      k26 * t4 * t11 * 6.0 - k26 * t3 * t13 * 4.0 + k26 * t4 * t12 * 1.2E1 -
      k26 * t4 * t13 * 2.0 + k26 * t5 * t13 * 2.0 + k36 * t2 * t8 * 2.0 +
      k36 * t2 * t9 * 4.0 - k36 * t3 * t8 * 2.0 + k36 * t2 * t10 * 4.0 -
      k36 * t3 * t9 * 8.0 - k36 * t4 * t8 * 4.0 - k36 * t2 * t11 * 1.4E1 +
      k36 * t3 * t10 * 1.2E1 - k36 * t4 * t9 * 2.0 + k36 * t2 * t12 * 2.0 -
      k36 * t3 * t11 * 2.0 + k36 * t4 * t10 * 2.0 - k36 * t2 * t13 * 6.0 +
      k36 * t3 * t12 * 2.0 - k36 * t4 * t11 * 4.0 - k36 * t3 * t13 * 6.0 +
      k36 * t5 * t11 * 2.0 + k36 * t7 * t9 + t2 * t3 * t14 + t2 * t3 * t15 +
      t2 * t4 * t14 + t3 * t8 * t9 + t2 * t3 * t16 * 3.0 + t2 * t4 * t15 * 3.0 +
      t2 * t8 * t11 * 2.0 + t2 * t9 * t10 + t3 * t4 * t14 * 3.0 + t4 * t8 * t9 +
      t2 * t4 * t16 + t2 * t8 * t12 + t3 * t4 * t15 + t3 * t8 * t11 +
      t3 * t9 * t10 * 6.0 + t4 * t8 * t10 * 2.0 + t2 * t10 * t11 +
      t3 * t4 * t16 + t3 * t8 * t12 * 2.0 - t4 * t8 * t11 * 2.0 +
      t4 * t9 * t10 * 2.0 + t2 * t9 * t13 * 2.0 + t2 * t10 * t12 +
      t3 * t8 * t13 + t3 * t9 * t12 * 2.0 + t4 * t8 * t12 * 6.0 +
      t4 * t9 * t11 + t2 * t10 * t13 * 3.0 + t2 * t11 * t12 * 3.0 -
      t3 * t9 * t13 * 2.0 + t4 * t10 * t11 - t2 * t11 * t13 * 4.0 +
      t3 * t10 * t13 * 6.0 + t3 * t11 * t12 + t4 * t9 * t13 + t2 * t12 * t13 +
      t4 * t10 * t13 + t4 * t11 * t12 * 6.0 + t3 * t12 * t13 + t5 * t11 * t13 +
      k12 * k13 * k15 * k16 * 8.0 - k12 * k13 * k15 * k26 * 2.4E1 -
      k12 * k13 * k15 * k36 * 2.4E1 + k12 * k15 * k23 * k26 * 1.6E1 +
      k12 * k13 * k26 * k33 * 8.0 + k12 * k16 * k23 * k33 * 4.0 -
      k13 * k15 * k23 * k33 * 1.2E1 + k12 * k15 * k23 * k36 * 8.0 -
      k13 * k16 * k22 * k35 * 1.6E1 - k13 * k22 * k25 * k26 * 1.6E1 +
      k16 * k22 * k23 * k25 * 2.4E1 - k15 * k16 * k25 * k32 * 1.6E1 +
      k12 * k13 * k33 * k36 * 1.6E1 - k12 * k23 * k26 * k33 * 1.2E1 +
      k16 * k22 * k23 * k35 * 4.0E1 - k22 * k23 * k25 * k26 * 8.0 +
      k15 * k25 * k26 * k32 * 1.6E1 - k12 * k23 * k33 * k36 * 1.2E1 +
      k13 * k22 * k35 * k36 * 1.6E1 + k16 * k25 * k32 * k33 * 4.0E1 -
      k22 * k23 * k25 * k36 * 2.4E1 - k22 * k23 * k26 * k35 * 2.4E1 +
      k16 * k32 * k33 * k35 * 2.4E1 - k22 * k23 * k35 * k36 * 4.0E1 -
      k25 * k26 * k32 * k33 * 4.0E1 - k15 * k32 * k35 * k36 * 1.6E1 -
      k25 * k32 * k33 * k36 * 2.4E1 - k26 * k32 * k33 * k35 * 2.4E1 -
      k32 * k33 * k35 * k36 * 8.0 + k12 * k13 * k15 * t10 * 4.0 -
      k12 * k13 * k15 * t11 * 8.0 + k12 * k13 * k15 * t12 * 4.0 -
      k12 * k13 * k15 * t13 * 8.0 - k13 * k16 * k23 * t2 * 2.0 +
      k13 * k16 * k23 * t3 * 6.0 + k13 * k16 * k23 * t4 * 6.0 -
      k12 * k15 * k23 * t8 * 2.0 - k13 * k16 * k23 * t6 -
      k12 * k15 * k23 * t9 * 2.0 - k12 * k15 * k23 * t10 * 2.0 +
      k12 * k15 * k23 * t11 * 6.0 - k12 * k15 * k23 * t12 * 2.0 -
      k12 * k15 * k23 * t13 * 2.0 - k13 * k23 * k26 * t2 * 2.0 +
      k13 * k23 * k26 * t3 * 6.0 - k12 * k13 * k33 * t8 * 2.0 +
      k13 * k23 * k26 * t4 * 6.0 - k15 * k16 * k33 * t2 * 2.0 -
      k12 * k13 * k33 * t9 * 2.0 + k15 * k16 * k33 * t3 * 6.0 -
      k12 * k13 * k33 * t10 * 2.0 - k13 * k22 * k25 * t8 * 2.0 -
      k13 * k23 * k26 * t6 + k15 * k16 * k33 * t4 * 6.0 -
      k12 * k13 * k33 * t11 * 2.0 + k13 * k22 * k25 * t9 * 6.0 -
      k12 * k13 * k33 * t12 * 2.0 + k13 * k22 * k25 * t10 * 6.0 +
      k12 * k13 * k33 * t13 * 6.0 - k13 * k22 * k25 * t11 * 2.0 -
      k15 * k16 * k33 * t7 + k13 * k22 * k25 * t12 * 6.0 +
      k13 * k22 * k25 * t13 * 2.0 + k13 * k23 * k36 * t2 * 2.0 -
      k13 * k23 * k36 * t3 * 6.0 + k12 * k23 * k33 * t8 * 2.0 +
      k13 * k23 * k36 * t4 * 2.0 + k15 * k26 * k33 * t2 * 2.0 +
      k12 * k23 * k33 * t9 * 2.0 + k15 * k26 * k33 * t3 * 2.0 +
      k12 * k23 * k33 * t10 * 2.0 + k13 * k22 * k35 * t8 * 2.0 -
      k15 * k26 * k33 * t4 * 6.0 + k16 * k25 * k35 * t2 * 1.6E1 -
      k22 * k23 * k25 * t8 * 4.0 - k12 * k23 * k33 * t11 * 2.0 +
      k13 * k22 * k35 * t9 * 1.0E1 + k16 * k25 * k35 * t3 * 8.0 -
      k22 * k23 * k25 * t9 * 8.0 - k12 * k22 * k32 * t14 * 2.0 +
      k12 * k23 * k33 * t12 * 2.0 - k13 * k22 * k35 * t10 * 6.0 +
      k15 * k25 * k32 * t8 * 1.0E1 + k16 * k25 * k35 * t4 * 8.0 -
      k12 * k22 * k32 * t15 * 2.0 - k12 * k23 * k33 * t13 * 2.0 -
      k13 * k22 * k35 * t11 * 2.0 + k15 * k25 * k32 * t9 * 2.0 -
      k12 * k22 * k32 * t16 * 2.0 + k13 * k22 * k35 * t12 * 2.0 +
      k15 * k25 * k32 * t10 * 2.0 + k22 * k23 * k25 * t12 * 4.0 +
      k13 * k22 * k35 * t13 * 2.0 + k15 * k25 * k32 * t11 * 2.0 -
      k22 * k23 * k25 * t13 * 8.0 - k15 * k25 * k32 * t12 * 6.0 -
      k15 * k25 * k32 * t13 * 2.0 - k15 * k33 * k36 * t2 * 2.0 +
      k15 * k33 * k36 * t3 * 6.0 + k15 * k33 * k36 * t4 * 6.0 -
      k22 * k23 * k35 * t8 * 4.0 - k25 * k26 * k35 * t2 * 2.8E1 -
      k22 * k23 * k35 * t9 * 1.6E1 - k25 * k26 * k35 * t3 * 4.0 +
      k15 * k32 * k35 * t8 * 6.0 + k22 * k23 * k35 * t10 * 8.0 -
      k25 * k26 * k35 * t4 * 8.0 - k15 * k32 * k35 * t9 * 2.0 -
      k15 * k33 * k36 * t7 - k22 * k23 * k35 * t11 * 4.0 +
      k25 * k26 * k35 * t5 * 4.0 + k15 * k32 * k35 * t10 * 6.0 +
      k22 * k23 * k35 * t12 * 4.0 + k15 * k32 * k35 * t11 * 2.0 -
      k22 * k23 * k35 * t13 * 4.0 + k15 * k32 * k35 * t12 * 6.0 -
      k15 * k32 * k35 * t13 * 2.0 - k25 * k32 * k33 * t8 * 1.6E1 -
      k25 * k35 * k36 * t2 * 2.8E1 - k25 * k32 * k33 * t9 * 4.0 -
      k25 * k35 * k36 * t3 * 8.0 + k25 * k32 * k33 * t10 * 4.0 -
      k25 * k35 * k36 * t4 * 4.0 - k25 * k32 * k33 * t11 * 4.0 +
      k25 * k35 * k36 * t5 * 4.0 + k25 * k32 * k33 * t12 * 8.0 -
      k25 * k32 * k33 * t13 * 4.0 - k32 * k33 * k35 * t8 * 8.0 -
      k32 * k33 * k35 * t9 * 4.0 + k32 * k33 * k35 * t10 * 4.0 -
      k32 * k33 * k35 * t11 * 8.0 - k13 * k23 * t3 * t9 * 6.0 -
      k13 * k23 * t4 * t8 - k16 * k26 * t2 * t4 * 4.0 -
      k13 * k23 * t2 * t11 * 2.0 - k13 * k23 * t4 * t9 * 3.0 -
      k16 * k26 * t3 * t4 * 4.0 - k13 * k23 * t2 * t12 * 3.0 -
      k13 * k23 * t4 * t10 + k13 * k23 * t2 * t13 * 2.0 -
      k13 * k23 * t3 * t12 * 3.0 + k13 * k23 * t4 * t11 -
      k13 * k23 * t3 * t13 * 6.0 - k13 * k23 * t4 * t12 * 6.0 -
      k13 * k23 * t4 * t13 - k16 * k36 * t2 * t3 * 4.0 -
      k15 * k33 * t3 * t8 * 3.0 - k16 * k36 * t3 * t4 * 4.0 -
      k15 * k33 * t2 * t10 * 3.0 - k15 * k33 * t3 * t9 -
      k15 * k33 * t4 * t8 * 6.0 + k15 * k33 * t2 * t11 * 2.0 -
      k15 * k33 * t3 * t10 * 6.0 - k15 * k33 * t3 * t11 -
      k15 * k33 * t4 * t10 * 3.0 - k15 * k33 * t2 * t13 * 2.0 -
      k15 * k33 * t3 * t12 - k15 * k33 * t4 * t11 * 6.0 + k15 * k33 * t3 * t13 +
      k26 * k36 * t2 * t3 * 2.0 + k26 * k36 * t2 * t4 * 2.0 +
      k25 * k35 * t2 * t8 * 4.0 + k25 * k35 * t2 * t9 * 4.0 -
      k25 * k35 * t3 * t8 * 4.0 + k25 * k35 * t2 * t10 * 2.0 -
      k25 * k35 * t3 * t9 * 4.0 - k25 * k35 * t4 * t8 * 4.0 -
      k25 * k35 * t2 * t11 * 2.0 - k25 * k35 * t4 * t9 * 4.0 +
      k25 * k35 * t2 * t12 * 2.0 - k25 * k35 * t2 * t13 * 2.0 +
      k16 * t3 * t4 * t8 + k16 * t2 * t4 * t10 * 2.0 + k16 * t3 * t4 * t9 +
      k16 * t2 * t3 * t12 * 2.0 - k16 * t2 * t4 * t11 * 2.0 +
      k16 * t3 * t4 * t10 * 6.0 - k16 * t2 * t3 * t13 * 2.0 +
      k16 * t3 * t4 * t12 * 6.0 + k26 * t2 * t4 * t8 * 2.0 +
      k26 * t3 * t4 * t8 * 2.0 + k26 * t2 * t4 * t10 + k26 * t2 * t3 * t12 +
      k26 * t2 * t4 * t11 * 3.0 + k26 * t2 * t4 * t13 +
      k36 * t2 * t3 * t9 * 2.0 + k36 * t2 * t3 * t11 + k36 * t2 * t4 * t10 +
      k36 * t3 * t4 * t9 * 2.0 + k36 * t2 * t3 * t12 +
      k36 * t2 * t3 * t13 * 3.0 + t2 * t4 * t8 * t11 + t2 * t3 * t9 * t13 -
      k12 * k15 * k16 * k22 * k25 * 4.0 + k12 * k13 * k16 * k25 * k32 * 4.0 -
      k13 * k15 * k16 * k22 * k32 * 4.0 - k12 * k13 * k15 * k25 * k35 * 3.2E1 +
      k12 * k15 * k16 * k22 * k35 * 4.0 + k12 * k15 * k22 * k25 * k26 * 1.2E1 -
      k12 * k13 * k16 * k32 * k35 * 4.0 - k12 * k13 * k25 * k26 * k32 * 4.0 +
      k12 * k16 * k22 * k25 * k33 * 4.0 + k12 * k16 * k22 * k26 * k32 * 4.0 +
      k12 * k16 * k23 * k25 * k32 * 4.0 - k13 * k15 * k22 * k25 * k33 * 1.2E1 -
      k13 * k15 * k22 * k26 * k32 * 1.2E1 -
      k13 * k15 * k23 * k25 * k32 * 1.2E1 +
      k15 * k16 * k22 * k23 * k32 * 1.2E1 +
      k12 * k15 * k22 * k25 * k36 * 2.0E1 +
      k12 * k15 * k22 * k26 * k35 * 2.0E1 +
      k12 * k15 * k23 * k25 * k35 * 2.0E1 +
      k13 * k16 * k22 * k32 * k33 * 1.2E1 +
      k12 * k13 * k25 * k32 * k36 * 2.0E1 +
      k12 * k13 * k25 * k33 * k35 * 2.0E1 +
      k12 * k13 * k26 * k32 * k35 * 2.0E1 + k12 * k16 * k22 * k32 * k36 * 4.0 +
      k12 * k16 * k22 * k33 * k35 * 4.0 + k12 * k16 * k23 * k32 * k35 * 4.0 -
      k12 * k22 * k25 * k26 * k33 * 4.0 - k12 * k23 * k25 * k26 * k32 * 4.0 -
      k13 * k15 * k22 * k32 * k36 * 1.2E1 -
      k13 * k15 * k22 * k33 * k35 * 1.2E1 -
      k13 * k15 * k23 * k32 * k35 * 1.2E1 + k15 * k22 * k23 * k25 * k33 * 4.0 +
      k15 * k22 * k23 * k26 * k32 * 4.0 - k12 * k15 * k22 * k35 * k36 * 4.0 +
      k13 * k22 * k26 * k32 * k33 * 1.2E1 +
      k13 * k23 * k25 * k32 * k33 * 1.2E1 -
      k16 * k22 * k23 * k32 * k33 * 3.2E1 +
      k12 * k13 * k32 * k35 * k36 * 1.2E1 -
      k12 * k22 * k25 * k33 * k36 * 2.0E1 -
      k12 * k22 * k26 * k32 * k36 * 2.0E1 -
      k12 * k22 * k26 * k33 * k35 * 2.0E1 -
      k12 * k23 * k25 * k32 * k36 * 2.0E1 -
      k12 * k23 * k25 * k33 * k35 * 2.0E1 -
      k12 * k23 * k26 * k32 * k35 * 2.0E1 +
      k15 * k22 * k23 * k32 * k36 * 1.2E1 +
      k15 * k22 * k23 * k33 * k35 * 1.2E1 + k13 * k22 * k32 * k33 * k36 * 4.0 +
      k13 * k23 * k32 * k33 * k35 * 4.0 + k22 * k23 * k26 * k32 * k33 * 8.0 -
      k12 * k22 * k33 * k35 * k36 * 4.0 - k12 * k23 * k32 * k35 * k36 * 4.0 +
      k22 * k23 * k32 * k33 * k36 * 8.0 + k12 * k13 * k15 * k26 * t3 * 4.0 +
      k12 * k13 * k15 * k26 * t4 * 4.0 - k12 * k15 * k16 * k23 * t4 * 2.0 -
      k12 * k13 * k16 * k33 * t3 * 2.0 - k12 * k15 * k23 * k26 * t2 * 2.0 -
      k13 * k16 * k22 * k25 * t2 * 2.0 + k12 * k13 * k15 * k36 * t3 * 4.0 -
      k12 * k15 * k23 * k26 * t3 * 6.0 - k13 * k16 * k22 * k25 * t3 * 2.0 +
      k12 * k13 * k15 * k36 * t4 * 4.0 - k12 * k15 * k23 * k26 * t4 * 2.0 +
      k13 * k16 * k22 * k25 * t4 * 2.0 - k12 * k15 * k22 * k25 * t8 * 2.0 -
      k12 * k15 * k22 * k25 * t10 * 6.0 - k12 * k13 * k26 * k33 * t2 * 4.0 -
      k12 * k15 * k22 * k25 * t12 * 2.0 + k12 * k16 * k23 * k33 * t2 +
      k13 * k15 * k23 * k33 * t2 * 3.0 - k12 * k13 * k26 * k33 * t3 * 2.0 +
      k12 * k15 * k22 * k25 * t13 * 4.0 - k12 * k16 * k23 * k33 * t3 * 3.0 +
      k13 * k15 * k23 * k33 * t3 * 9.0 - k12 * k13 * k26 * k33 * t4 * 6.0 -
      k12 * k15 * k23 * k36 * t2 * 4.0 - k12 * k16 * k23 * k33 * t4 * 3.0 +
      k13 * k15 * k23 * k33 * t4 * 9.0 - k13 * k16 * k22 * k35 * t2 * 2.0 -
      k13 * k22 * k25 * k26 * t2 * 4.0 - k12 * k15 * k23 * k36 * t3 * 6.0 +
      k13 * k16 * k22 * k35 * t3 * 4.0 - k12 * k13 * k25 * k32 * t8 * 4.0 -
      k12 * k15 * k23 * k36 * t4 * 2.0 + k12 * k16 * k22 * k32 * t8 * 3.0 +
      k13 * k15 * k22 * k32 * t8 + k13 * k16 * k22 * k35 * t4 * 4.0 +
      k13 * k22 * k25 * k26 * t4 * 2.0 - k15 * k16 * k25 * k32 * t2 * 2.0 -
      k16 * k22 * k23 * k25 * t4 * 8.0 - k12 * k13 * k25 * k32 * t9 * 2.0 +
      k12 * k16 * k22 * k32 * t9 * 3.0 + k13 * k15 * k22 * k32 * t9 +
      k15 * k16 * k25 * k32 * t3 * 4.0 - k12 * k13 * k25 * k32 * t10 * 2.0 -
      k12 * k15 * k22 * k35 * t8 * 2.0 - k12 * k16 * k22 * k32 * t10 * 3.0 +
      k13 * k15 * k22 * k32 * t10 * 9.0 + k15 * k16 * k25 * k32 * t4 * 4.0 -
      k12 * k13 * k25 * k32 * t11 * 2.0 - k12 * k15 * k22 * k35 * t9 * 4.0 -
      k12 * k16 * k22 * k32 * t11 - k13 * k15 * k22 * k32 * t11 -
      k12 * k13 * k25 * k32 * t12 * 6.0 - k12 * k15 * k22 * k35 * t10 * 6.0 -
      k12 * k16 * k22 * k32 * t12 * 3.0 + k13 * k15 * k22 * k32 * t12 * 9.0;
  coeffs(4) +=
      k12 * k13 * k25 * k32 * t13 * 6.0 + k12 * k15 * k22 * k35 * t11 * 6.0 -
      k12 * k16 * k22 * k32 * t13 - k13 * k15 * k22 * k32 * t13 -
      k12 * k13 * k33 * k36 * t2 * 2.0 - k12 * k15 * k22 * k35 * t12 * 2.0 +
      k12 * k23 * k26 * k33 * t2 * 3.0 - k12 * k13 * k33 * k36 * t3 * 2.0 -
      k12 * k15 * k22 * k35 * t13 * 2.0 + k12 * k23 * k26 * k33 * t3 * 3.0 -
      k12 * k13 * k33 * k36 * t4 * 6.0 + k12 * k23 * k26 * k33 * t4 * 9.0 -
      k16 * k22 * k23 * k35 * t2 * 8.0 + k22 * k23 * k25 * k26 * t2 * 4.0 +
      k13 * k22 * k25 * k36 * t3 * 2.0 + k13 * k22 * k26 * k35 * t3 * 2.0 +
      k13 * k23 * k25 * k35 * t3 * 6.0 - k16 * k22 * k23 * k35 * t3 * 8.0 +
      k12 * k22 * k25 * k33 * t8 * 5.0 + k12 * k22 * k26 * k32 * t8 * 5.0 +
      k12 * k23 * k25 * k32 * t8 * 5.0 + k13 * k22 * k25 * k36 * t4 * 4.0 +
      k13 * k22 * k26 * k35 * t4 * 4.0 + k13 * k23 * k25 * k35 * t4 * 4.0 -
      k15 * k16 * k32 * k35 * t2 * 2.0 - k15 * k22 * k23 * k32 * t8 * 6.0 +
      k15 * k25 * k26 * k32 * t2 * 4.0 - k16 * k22 * k23 * k35 * t4 * 8.0 +
      k22 * k23 * k25 * k26 * t4 * 4.0 - k12 * k13 * k32 * k35 * t9 * 2.0 -
      k12 * k22 * k25 * k33 * t9 - k12 * k22 * k26 * k32 * t9 -
      k12 * k23 * k25 * k32 * t9 + k15 * k16 * k32 * k35 * t3 * 2.0 -
      k15 * k22 * k23 * k32 * t9 * 2.0 - k15 * k25 * k26 * k32 * t3 * 2.0 -
      k12 * k13 * k32 * k35 * t10 * 2.0 + k12 * k22 * k25 * k33 * t10 * 3.0 +
      k12 * k22 * k26 * k32 * t10 * 3.0 + k12 * k23 * k25 * k32 * t10 -
      k15 * k16 * k32 * k35 * t4 * 2.0 - k15 * k22 * k23 * k32 * t10 * 4.0 -
      k15 * k25 * k26 * k32 * t4 * 4.0 + k12 * k13 * k32 * k35 * t11 * 4.0 +
      k12 * k22 * k25 * k33 * t11 + k12 * k22 * k26 * k32 * t11 * 3.0 +
      k12 * k23 * k25 * k32 * t11 - k15 * k22 * k23 * k32 * t11 * 2.0 -
      k12 * k13 * k32 * k35 * t12 * 6.0 + k12 * k22 * k25 * k33 * t12 * 3.0 +
      k12 * k22 * k26 * k32 * t12 * 9.0 + k12 * k23 * k25 * k32 * t12 * 9.0 -
      k15 * k22 * k23 * k32 * t12 * 6.0 - k12 * k22 * k25 * k33 * t13 * 5.0 -
      k12 * k22 * k26 * k32 * t13 * 5.0 - k12 * k23 * k25 * k32 * t13 * 5.0 +
      k15 * k22 * k23 * k32 * t13 * 2.0 + k12 * k23 * k33 * k36 * t2 * 3.0 +
      k12 * k23 * k33 * k36 * t3 * 9.0 + k12 * k23 * k33 * k36 * t4 * 3.0 -
      k13 * k22 * k32 * k33 * t8 * 2.0 + k13 * k22 * k35 * k36 * t2 * 4.0 -
      k16 * k25 * k32 * k33 * t2 * 8.0 + k22 * k23 * k25 * k36 * t2 * 4.0 +
      k22 * k23 * k26 * k35 * t2 * 4.0 - k13 * k22 * k32 * k33 * t9 * 6.0 -
      k13 * k22 * k35 * k36 * t3 * 4.0 - k16 * k25 * k32 * k33 * t3 * 8.0 -
      k12 * k22 * k32 * k36 * t8 - k12 * k22 * k33 * k35 * t8 -
      k12 * k23 * k32 * k35 * t8 - k13 * k22 * k32 * k33 * t10 * 6.0 -
      k13 * k22 * k35 * k36 * t4 * 2.0 - k16 * k25 * k32 * k33 * t4 * 8.0 +
      k12 * k22 * k32 * k36 * t9 * 5.0 + k12 * k22 * k33 * k35 * t9 * 5.0 +
      k12 * k23 * k32 * k35 * t9 * 5.0 + k13 * k22 * k32 * k33 * t11 * 2.0 +
      k15 * k25 * k32 * k36 * t3 * 4.0 + k15 * k25 * k33 * k35 * t3 * 4.0 +
      k15 * k26 * k32 * k35 * t3 * 4.0 + k12 * k22 * k32 * k36 * t10 * 9.0 +
      k12 * k22 * k33 * k35 * t10 * 9.0 + k12 * k23 * k32 * k35 * t10 * 3.0 -
      k13 * k22 * k32 * k33 * t12 * 4.0 + k15 * k25 * k32 * k36 * t4 * 2.0 +
      k15 * k25 * k33 * k35 * t4 * 6.0 + k15 * k26 * k32 * k35 * t4 * 2.0 -
      k12 * k22 * k32 * k36 * t11 * 5.0 - k12 * k22 * k33 * k35 * t11 * 5.0 -
      k12 * k23 * k32 * k35 * t11 * 5.0 - k13 * k22 * k32 * k33 * t13 * 2.0 +
      k12 * k22 * k32 * k36 * t12 * 3.0 + k12 * k22 * k33 * k35 * t12 +
      k12 * k23 * k32 * k35 * t12 * 3.0 + k12 * k22 * k32 * k36 * t13 * 3.0 +
      k12 * k22 * k33 * k35 * t13 + k12 * k23 * k32 * k35 * t13 +
      k22 * k23 * k32 * k33 * t8 * 8.0 + k22 * k23 * k35 * k36 * t2 * 1.2E1 +
      k25 * k26 * k32 * k33 * t2 * 1.2E1 - k16 * k32 * k33 * k35 * t3 * 8.0 +
      k22 * k23 * k32 * k33 * t9 * 8.0 + k22 * k23 * k35 * k36 * t3 * 8.0 +
      k25 * k26 * k32 * k33 * t3 * 4.0 - k15 * k32 * k35 * k36 * t2 * 4.0 +
      k22 * k23 * k35 * k36 * t4 * 4.0 + k25 * k26 * k32 * k33 * t4 * 8.0 +
      k15 * k32 * k35 * k36 * t3 * 2.0 + k22 * k23 * k32 * k33 * t11 * 4.0 +
      k22 * k23 * k32 * k33 * t13 * 4.0 + k25 * k32 * k33 * k36 * t2 * 4.0 +
      k26 * k32 * k33 * k35 * t2 * 4.0 + k32 * k33 * k35 * k36 * t2 * 4.0 +
      k32 * k33 * k35 * k36 * t3 * 4.0 + k12 * k13 * k15 * t4 * t10 * 2.0 +
      k12 * k13 * k15 * t3 * t12 * 2.0 - k13 * k16 * k23 * t2 * t4 -
      k13 * k16 * k23 * t3 * t4 * 6.0 - k12 * k15 * k23 * t4 * t8 -
      k12 * k15 * k23 * t4 * t10 - k12 * k15 * k23 * t2 * t13 * 2.0 -
      k12 * k15 * k23 * t3 * t12 * 3.0 - k12 * k15 * k23 * t4 * t11 -
      k12 * k15 * k23 * t4 * t13 - k13 * k23 * k26 * t2 * t4 * 4.0 -
      k13 * k23 * k26 * t3 * t4 * 3.0 - k15 * k16 * k33 * t2 * t3 -
      k12 * k13 * k33 * t3 * t9 - k12 * k13 * k33 * t2 * t11 * 2.0 -
      k15 * k16 * k33 * t3 * t4 * 6.0 - k12 * k13 * k33 * t3 * t11 -
      k12 * k13 * k33 * t4 * t10 * 3.0 - k13 * k22 * k25 * t4 * t8 -
      k12 * k13 * k33 * t3 * t12 - k13 * k22 * k25 * t4 * t9 -
      k12 * k13 * k33 * t3 * t13 - k13 * k22 * k25 * t2 * t12 * 4.0 -
      k13 * k22 * k25 * t4 * t10 * 3.0 + k13 * k22 * k25 * t2 * t13 * 2.0 -
      k13 * k22 * k25 * t3 * t12 - k13 * k22 * k25 * t4 * t12 * 6.0 -
      k13 * k23 * k36 * t2 * t4 * 2.0 - k15 * k26 * k33 * t2 * t3 * 2.0 +
      k12 * k23 * k33 * t3 * t9 * 3.0 + k12 * k23 * k33 * t4 * t8 * 3.0 +
      k12 * k23 * k33 * t2 * t11 - k13 * k22 * k35 * t3 * t9 * 2.0 +
      k22 * k23 * k25 * t4 * t8 * 4.0 + k12 * k22 * k32 * t2 * t15 +
      k12 * k22 * k32 * t3 * t14 + k12 * k23 * k33 * t2 * t13 +
      k12 * k23 * k33 * t4 * t11 * 3.0 - k13 * k22 * k35 * t2 * t11 * 2.0 -
      k13 * k22 * k35 * t4 * t9 * 2.0 - k15 * k25 * k32 * t3 * t8 * 2.0 +
      k12 * k22 * k32 * t2 * t16 + k12 * k22 * k32 * t4 * t14 +
      k12 * k23 * k33 * t3 * t13 * 3.0 - k13 * k22 * k35 * t2 * t12 * 2.0 -
      k15 * k25 * k32 * t2 * t10 * 2.0 - k15 * k25 * k32 * t4 * t8 * 2.0 +
      k22 * k23 * k25 * t2 * t12 * 2.0 + k12 * k22 * k32 * t3 * t16 +
      k12 * k22 * k32 * t4 * t15 + k12 * k22 * k32 * t8 * t11 * 3.0 +
      k12 * k22 * k32 * t9 * t10 * 3.0 + k12 * k22 * k32 * t8 * t12 * 3.0 -
      k15 * k25 * k32 * t2 * t13 * 2.0 + k12 * k22 * k32 * t9 * t13 * 3.0 +
      k12 * k22 * k32 * t10 * t13 * 3.0 + k12 * k22 * k32 * t11 * t12 * 3.0 -
      k15 * k33 * k36 * t2 * t3 * 4.0 - k15 * k33 * k36 * t3 * t4 * 3.0 +
      k22 * k23 * k35 * t2 * t9 * 4.0 + k25 * k26 * k35 * t2 * t3 * 2.0 +
      k22 * k23 * k35 * t3 * t9 * 4.0 - k15 * k32 * k35 * t3 * t8 +
      k22 * k23 * k35 * t2 * t11 * 2.0 + k22 * k23 * k35 * t4 * t9 * 4.0 -
      k15 * k32 * k35 * t2 * t10 * 4.0 - k15 * k32 * k35 * t3 * t9 +
      k22 * k23 * k35 * t2 * t12 * 2.0 + k15 * k32 * k35 * t2 * t11 * 2.0 -
      k15 * k32 * k35 * t3 * t10 * 6.0 + k22 * k23 * k35 * t2 * t13 * 2.0 -
      k15 * k32 * k35 * t4 * t10 - k15 * k32 * k35 * t3 * t12 * 3.0 +
      k25 * k32 * k33 * t2 * t8 * 4.0 + k25 * k32 * k33 * t3 * t8 * 4.0 +
      k25 * k32 * k33 * t2 * t10 * 2.0 + k25 * k32 * k33 * t4 * t8 * 4.0 +
      k25 * k35 * k36 * t2 * t4 * 2.0 + k25 * k32 * k33 * t2 * t11 * 2.0 +
      k25 * k32 * k33 * t2 * t13 * 2.0 + k32 * k33 * k35 * t2 * t10 * 2.0 +
      k32 * k33 * k35 * t3 * t9 * 4.0 + k16 * k26 * t2 * t3 * t4 -
      k13 * k23 * t2 * t4 * t11 + k16 * k36 * t2 * t3 * t4 -
      k15 * k33 * t2 * t3 * t13 + k26 * k36 * t2 * t3 * t4 +
      k25 * k35 * t2 * t4 * t10 + k25 * k35 * t2 * t3 * t12;
  coeffs(4) +=
      k12 * k13 * k15 * k22 * k23 * k25 * 8.0 -
      k12 * k13 * k16 * k22 * k23 * k32 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k35 * 8.0 -
      k12 * k13 * k22 * k23 * k25 * k33 * 4.0 -
      k12 * k13 * k22 * k23 * k26 * k32 * 4.0 +
      k12 * k13 * k15 * k25 * k32 * k33 * 8.0 -
      k12 * k15 * k16 * k22 * k32 * k33 * 4.0 -
      k12 * k13 * k22 * k23 * k32 * k36 * 4.0 -
      k12 * k13 * k22 * k23 * k33 * k35 * 4.0 +
      k12 * k13 * k15 * k32 * k33 * k35 * 8.0 -
      k12 * k15 * k22 * k26 * k32 * k33 * 4.0 -
      k12 * k15 * k23 * k25 * k32 * k33 * 4.0 +
      k12 * k16 * k22 * k25 * k32 * k35 * 6.0 -
      k13 * k15 * k22 * k25 * k32 * k35 * 1.0E1 -
      k12 * k15 * k22 * k32 * k33 * k36 * 4.0 -
      k12 * k15 * k23 * k32 * k33 * k35 * 4.0 -
      k12 * k22 * k25 * k26 * k32 * k35 * 1.0E1 +
      k15 * k22 * k23 * k25 * k32 * k35 * 8.0 +
      k13 * k22 * k25 * k32 * k33 * k35 * 8.0 -
      k12 * k22 * k25 * k32 * k35 * k36 * 1.0E1 +
      k12 * k15 * k16 * k22 * k25 * t4 * 2.0 -
      k12 * k13 * k16 * k25 * k32 * t3 * 4.0 +
      k13 * k15 * k16 * k22 * k32 * t3 * 2.0 +
      k13 * k15 * k16 * k22 * k32 * t4 * 2.0 +
      k12 * k13 * k15 * k25 * k35 * t3 * 4.0 +
      k12 * k13 * k15 * k25 * k35 * t4 * 4.0 -
      k12 * k15 * k16 * k22 * k35 * t4 * 4.0 -
      k12 * k15 * k22 * k25 * k26 * t4 * 2.0 -
      k12 * k13 * k25 * k26 * k32 * t2 * 4.0 +
      k12 * k16 * k22 * k25 * k33 * t2 + k12 * k16 * k22 * k26 * k32 * t2 +
      k12 * k16 * k23 * k25 * k32 * t2 +
      k13 * k15 * k22 * k25 * k33 * t2 * 3.0 +
      k13 * k15 * k22 * k26 * k32 * t2 * 3.0 +
      k13 * k15 * k23 * k25 * k32 * t2 * 3.0 -
      k15 * k16 * k22 * k23 * k32 * t2 * 2.0 +
      k12 * k13 * k16 * k32 * k35 * t3 * 2.0 -
      k12 * k13 * k22 * k23 * k32 * t9 * 2.0 -
      k12 * k13 * k25 * k26 * k32 * t3 * 2.0 +
      k12 * k16 * k22 * k25 * k33 * t3 + k12 * k16 * k22 * k26 * k32 * t3 +
      k12 * k16 * k23 * k25 * k32 * t3 * 3.0 +
      k13 * k15 * k22 * k25 * k33 * t3 + k13 * k15 * k22 * k26 * k32 * t3 +
      k13 * k15 * k23 * k25 * k32 * t3 * 3.0 -
      k15 * k16 * k22 * k23 * k32 * t3 * 4.0 -
      k12 * k15 * k22 * k25 * k36 * t2 * 4.0 -
      k12 * k15 * k22 * k26 * k35 * t2 * 4.0 -
      k12 * k15 * k23 * k25 * k35 * t2 * 4.0 -
      k12 * k16 * k22 * k25 * k33 * t4 * 6.0 -
      k12 * k16 * k22 * k26 * k32 * t4 * 2.0 -
      k12 * k16 * k23 * k25 * k32 * t4 * 2.0 +
      k13 * k15 * k22 * k25 * k33 * t4 * 6.0 +
      k13 * k15 * k22 * k26 * k32 * t4 * 2.0 +
      k13 * k15 * k23 * k25 * k32 * t4 * 2.0 -
      k15 * k16 * k22 * k23 * k32 * t4 * 4.0 -
      k12 * k13 * k22 * k23 * k32 * t11 * 2.0 -
      k12 * k15 * k22 * k25 * k36 * t3 * 2.0 -
      k12 * k15 * k22 * k26 * k35 * t3 * 2.0 -
      k12 * k15 * k23 * k25 * k35 * t3 * 6.0 -
      k12 * k13 * k22 * k23 * k32 * t12 * 6.0 -
      k12 * k13 * k22 * k23 * k32 * t13 * 2.0 -
      k13 * k16 * k22 * k32 * k33 * t2 * 2.0 -
      k13 * k16 * k22 * k32 * k33 * t3 * 4.0 -
      k12 * k13 * k25 * k32 * k36 * t2 * 4.0 -
      k12 * k13 * k25 * k33 * k35 * t2 * 4.0 -
      k12 * k13 * k26 * k32 * k35 * t2 * 4.0 +
      k12 * k16 * k22 * k32 * k36 * t2 + k12 * k16 * k22 * k33 * k35 * t2 +
      k12 * k16 * k23 * k32 * k35 * t2 +
      k12 * k22 * k25 * k26 * k33 * t2 * 2.0 +
      k12 * k23 * k25 * k26 * k32 * t2 * 2.0 +
      k13 * k15 * k22 * k32 * k36 * t2 * 3.0 +
      k13 * k15 * k22 * k33 * k35 * t2 * 3.0 +
      k13 * k15 * k23 * k32 * k35 * t2 * 3.0 -
      k13 * k16 * k22 * k32 * k33 * t4 * 4.0 -
      k15 * k22 * k23 * k25 * k33 * t2 * 4.0 -
      k15 * k22 * k23 * k26 * k32 * t2 * 4.0 -
      k12 * k16 * k22 * k32 * k36 * t3 * 2.0 -
      k12 * k16 * k22 * k33 * k35 * t3 * 2.0 -
      k12 * k16 * k23 * k32 * k35 * t3 * 6.0 +
      k13 * k15 * k22 * k32 * k36 * t3 * 2.0 +
      k13 * k15 * k22 * k33 * k35 * t3 * 2.0 +
      k13 * k15 * k23 * k32 * k35 * t3 * 6.0 -
      k12 * k13 * k25 * k32 * k36 * t4 * 2.0 -
      k12 * k13 * k25 * k33 * k35 * t4 * 6.0 -
      k12 * k13 * k26 * k32 * k35 * t4 * 2.0 -
      k12 * k15 * k22 * k32 * k33 * t8 * 2.0 -
      k12 * k15 * k22 * k35 * k36 * t2 * 4.0 +
      k12 * k16 * k22 * k32 * k36 * t4 +
      k12 * k16 * k22 * k33 * k35 * t4 * 3.0 +
      k12 * k16 * k23 * k32 * k35 * t4 +
      k12 * k22 * k25 * k26 * k33 * t4 * 6.0 +
      k12 * k23 * k25 * k26 * k32 * t4 * 2.0 +
      k13 * k15 * k22 * k32 * k36 * t4 +
      k13 * k15 * k22 * k33 * k35 * t4 * 3.0 +
      k13 * k15 * k23 * k32 * k35 * t4 -
      k12 * k15 * k22 * k32 * k33 * t10 * 6.0 -
      k12 * k15 * k22 * k35 * k36 * t4 * 2.0 -
      k12 * k15 * k22 * k32 * k33 * t11 * 2.0 -
      k12 * k15 * k22 * k32 * k33 * t13 * 2.0 -
      k13 * k22 * k26 * k32 * k33 * t2 * 8.0 -
      k13 * k23 * k25 * k32 * k33 * t2 * 8.0;
  coeffs(4) +=
      k16 * k22 * k23 * k32 * k33 * t2 * 8.0 -
      k13 * k22 * k26 * k32 * k33 * t3 * 2.0 -
      k13 * k23 * k25 * k32 * k33 * t3 * 6.0 +
      k16 * k22 * k23 * k32 * k33 * t3 * 8.0 +
      k12 * k22 * k25 * k33 * k36 * t2 * 4.0 +
      k12 * k22 * k26 * k32 * k36 * t2 * 4.0 +
      k12 * k22 * k26 * k33 * k35 * t2 * 4.0 +
      k12 * k23 * k25 * k32 * k36 * t2 * 4.0 +
      k12 * k23 * k25 * k33 * k35 * t2 * 4.0 +
      k12 * k23 * k26 * k32 * k35 * t2 * 4.0 -
      k13 * k22 * k26 * k32 * k33 * t4 * 4.0 -
      k13 * k23 * k25 * k32 * k33 * t4 * 4.0 -
      k15 * k22 * k23 * k32 * k36 * t2 * 8.0 -
      k15 * k22 * k23 * k33 * k35 * t2 * 8.0 +
      k16 * k22 * k23 * k32 * k33 * t4 * 8.0 -
      k12 * k13 * k32 * k35 * k36 * t3 * 2.0 +
      k12 * k22 * k25 * k33 * k36 * t3 + k12 * k22 * k26 * k32 * k36 * t3 +
      k12 * k22 * k26 * k33 * k35 * t3 +
      k12 * k23 * k25 * k32 * k36 * t3 * 3.0 +
      k12 * k23 * k25 * k33 * k35 * t3 * 3.0 +
      k12 * k23 * k26 * k32 * k35 * t3 * 3.0 -
      k15 * k22 * k23 * k32 * k36 * t3 * 4.0 -
      k15 * k22 * k23 * k33 * k35 * t3 * 4.0 +
      k12 * k22 * k25 * k33 * k36 * t4 * 3.0 +
      k12 * k22 * k26 * k32 * k36 * t4 +
      k12 * k22 * k26 * k33 * k35 * t4 * 3.0 +
      k12 * k23 * k25 * k32 * k36 * t4 +
      k12 * k23 * k25 * k33 * k35 * t4 * 3.0 +
      k12 * k23 * k26 * k32 * k35 * t4 -
      k15 * k22 * k23 * k32 * k36 * t4 * 2.0 -
      k15 * k22 * k23 * k33 * k35 * t4 * 6.0 -
      k12 * k22 * k25 * k32 * k35 * t8 - k12 * k22 * k25 * k32 * k35 * t9 +
      k12 * k22 * k25 * k32 * k35 * t10 * 3.0 +
      k12 * k22 * k25 * k32 * k35 * t12 * 3.0 -
      k13 * k22 * k32 * k33 * k36 * t2 * 4.0 -
      k13 * k23 * k32 * k33 * k35 * t2 * 4.0 +
      k22 * k23 * k26 * k32 * k33 * t2 * 4.0 +
      k12 * k22 * k33 * k35 * k36 * t2 * 2.0 +
      k12 * k23 * k32 * k35 * k36 * t2 * 2.0 +
      k12 * k22 * k33 * k35 * k36 * t3 * 2.0 +
      k12 * k23 * k32 * k35 * k36 * t3 * 6.0 +
      k22 * k23 * k32 * k33 * k36 * t2 * 4.0 + k12 * k13 * k15 * k16 * t3 * t4 +
      k12 * k13 * k15 * k26 * t3 * t4 - k12 * k15 * k16 * k23 * t3 * t4 * 3.0 -
      k12 * k13 * k16 * k33 * t3 * t4 * 3.0 - k13 * k16 * k22 * k25 * t2 * t4 +
      k12 * k13 * k15 * k36 * t3 * t4 - k12 * k15 * k22 * k25 * t4 * t8 -
      k12 * k15 * k22 * k25 * t2 * t13 * 2.0 -
      k12 * k13 * k26 * k33 * t3 * t4 * 3.0 +
      k12 * k16 * k23 * k33 * t3 * t4 * 9.0 -
      k13 * k22 * k25 * k26 * t2 * t4 * 2.0 +
      k16 * k22 * k23 * k25 * t2 * t4 * 2.0 -
      k12 * k15 * k23 * k36 * t3 * t4 * 3.0 - k12 * k13 * k25 * k32 * t4 * t10 +
      k12 * k16 * k22 * k32 * t4 * t10 * 3.0 -
      k12 * k13 * k25 * k32 * t3 * t12 * 3.0 +
      k12 * k16 * k22 * k32 * t3 * t12 * 3.0 -
      k12 * k15 * k22 * k35 * t4 * t10 * 3.0 -
      k12 * k15 * k22 * k35 * t3 * t12 - k13 * k22 * k25 * k36 * t2 * t4 * 2.0 -
      k13 * k22 * k26 * k35 * t2 * t4 * 2.0 -
      k13 * k23 * k25 * k35 * t2 * t4 * 2.0 +
      k16 * k22 * k23 * k35 * t2 * t4 * 2.0 - k15 * k16 * k32 * k35 * t2 * t3 -
      k12 * k13 * k32 * k35 * t3 * t9 + k12 * k22 * k25 * k33 * t4 * t8 * 3.0 +
      k12 * k22 * k26 * k32 * t4 * t8 + k12 * k23 * k25 * k32 * t4 * t8 -
      k12 * k13 * k32 * k35 * t2 * t11 * 2.0 +
      k12 * k22 * k25 * k33 * t2 * t13 + k12 * k22 * k26 * k32 * t2 * t13 +
      k12 * k23 * k25 * k32 * t2 * t13 -
      k15 * k22 * k23 * k32 * t2 * t13 * 2.0 +
      k16 * k25 * k32 * k33 * t2 * t3 * 2.0 +
      k22 * k23 * k25 * k36 * t2 * t4 * 2.0 +
      k22 * k23 * k26 * k35 * t2 * t4 * 2.0 -
      k13 * k22 * k32 * k33 * t2 * t11 * 2.0 -
      k15 * k25 * k32 * k36 * t2 * t3 * 2.0 -
      k15 * k25 * k33 * k35 * t2 * t3 * 2.0 -
      k15 * k26 * k32 * k35 * t2 * t3 * 2.0 + k12 * k22 * k32 * k36 * t3 * t9 +
      k12 * k22 * k33 * k35 * t3 * t9 + k12 * k23 * k32 * k35 * t3 * t9 * 3.0 +
      k12 * k22 * k32 * k36 * t2 * t11 + k12 * k22 * k33 * k35 * t2 * t11 +
      k12 * k23 * k32 * k35 * t2 * t11 + k16 * k32 * k33 * k35 * t2 * t3 * 2.0 -
      k15 * k32 * k35 * k36 * t2 * t3 * 2.0 +
      k25 * k32 * k33 * k36 * t2 * t3 * 2.0 +
      k26 * k32 * k33 * k35 * t2 * t3 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k32 * k33 * 8.0 +
      k12 * k13 * k15 * k22 * k23 * k25 * t4 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k32 * t4 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k35 * t4 * 2.0 -
      k12 * k13 * k22 * k23 * k25 * k33 * t4 * 6.0 -
      k12 * k13 * k22 * k23 * k26 * k32 * t4 * 2.0 +
      k12 * k13 * k15 * k25 * k32 * k33 * t3 * 2.0 -
      k12 * k15 * k16 * k22 * k32 * k33 * t3 * 2.0 +
      k12 * k13 * k15 * k32 * k33 * k35 * t3 * 2.0 +
      k12 * k16 * k22 * k25 * k32 * k35 * t2 +
      k13 * k15 * k22 * k25 * k32 * k35 * t2 * 3.0 -
      k12 * k15 * k22 * k32 * k33 * k36 * t3 * 2.0 -
      k12 * k15 * k23 * k32 * k33 * k35 * t3 * 6.0 +
      k12 * k22 * k25 * k26 * k32 * k35 * t2 * 2.0 -
      k15 * k22 * k23 * k25 * k32 * k35 * t2 * 4.0 -
      k13 * k22 * k25 * k32 * k33 * k35 * t2 * 4.0 +
      k12 * k22 * k25 * k32 * k35 * k36 * t2 * 2.0 +
      k22 * k23 * k25 * k32 * k33 * k35 * t2 * 4.0;
  coeffs(5) =
      k25 * t14 * 2.4E1 + k25 * t15 * 2.4E1 + k25 * t16 * 2.4E1 +
      k25 * t17 * 2.0 + k25 * t19 * 2.0 + k35 * t14 * 2.4E1 +
      k35 * t15 * 2.4E1 + k35 * t16 * 2.4E1 + k35 * t18 * 2.0 +
      k35 * t20 * 2.0 - k16 * k25 * k26 * 4.8E1 - k16 * k25 * k36 * 4.8E1 -
      k16 * k26 * k35 * 4.8E1 - k16 * k35 * k36 * 4.8E1 +
      k25 * k26 * k36 * 4.8E1 + k26 * k35 * k36 * 4.8E1 +
      k13 * k22 * t14 * 8.0 - k16 * k25 * t8 * 1.2E1 - k13 * k22 * t15 * 8.0 -
      k16 * k25 * t9 * 4.0 + k13 * k22 * t16 * 8.0 + k16 * k25 * t10 * 1.2E1 -
      k16 * k25 * t11 * 4.0 + k16 * k25 * t12 * 2.0E1 - k13 * k22 * t19 -
      k16 * k25 * t13 * 1.2E1 - k16 * k35 * t8 * 4.0 - k22 * k23 * t14 * 2.0E1 +
      k25 * k26 * t8 * 2.0E1 - k16 * k35 * t9 * 1.2E1 - k22 * k23 * t15 * 4.0 +
      k25 * k26 * t9 * 4.0 + k15 * k32 * t14 * 8.0 + k16 * k35 * t10 * 2.0E1 -
      k22 * k23 * t16 * 2.0E1 - k25 * k26 * t10 * 4.0 + k15 * k32 * t15 * 8.0 -
      k16 * k35 * t11 * 1.2E1 + k25 * k26 * t11 * 4.0 - k15 * k32 * t16 * 8.0 +
      k16 * k35 * t12 * 1.2E1 - k25 * k26 * t12 * 2.0E1 -
      k16 * k35 * t13 * 4.0 + k25 * k26 * t13 * 1.2E1 - k15 * k32 * t20 +
      k25 * k36 * t8 * 1.2E1 + k26 * k35 * t8 * 1.2E1 + k25 * k36 * t9 * 1.2E1 +
      k26 * k35 * t9 * 1.2E1 - k25 * k36 * t10 * 1.2E1 -
      k26 * k35 * t10 * 1.2E1 + k25 * k36 * t11 * 4.0 +
      k26 * k35 * t11 * 1.2E1 - k25 * k36 * t12 * 1.2E1 -
      k26 * k35 * t12 * 1.2E1 + k25 * k36 * t13 * 1.2E1 +
      k26 * k35 * t13 * 4.0 - k32 * k33 * t14 * 2.0E1 + k35 * k36 * t8 * 4.0 -
      k32 * k33 * t15 * 2.0E1 + k35 * k36 * t9 * 2.0E1 - k32 * k33 * t16 * 4.0 -
      k35 * k36 * t10 * 2.0E1 + k35 * k36 * t11 * 1.2E1 -
      k35 * k36 * t12 * 4.0 + k35 * k36 * t13 * 4.0 - k25 * t2 * t14 * 2.0 -
      k25 * t2 * t15 * 6.0 - k25 * t3 * t14 * 4.0 - k25 * t8 * t9 * 2.0 -
      k25 * t2 * t16 * 1.4E1 - k25 * t4 * t14 * 6.0 - k25 * t8 * t10 * 2.0 -
      k25 * t3 * t16 * 4.0 - k25 * t4 * t15 * 6.0 + k25 * t8 * t11 * 2.0 -
      k25 * t9 * t10 * 4.0 - k25 * t4 * t16 * 2.0 - k25 * t8 * t12 * 8.0 +
      k25 * t5 * t16 * 2.0 + k25 * t8 * t13 * 2.0 - k25 * t9 * t12 * 2.0 +
      k25 * t9 * t13 * 4.0 + k25 * t10 * t12 * 2.0 - k25 * t10 * t13 * 4.0 -
      k25 * t11 * t12 * 2.0 - k25 * t12 * t13 * 2.0 - k35 * t2 * t14 * 2.0 -
      k35 * t2 * t15 * 1.4E1 - k35 * t3 * t14 * 6.0 - k35 * t8 * t9 * 2.0 -
      k35 * t2 * t16 * 6.0 - k35 * t3 * t15 * 2.0 - k35 * t4 * t14 * 4.0 -
      k35 * t8 * t10 * 2.0 - k35 * t3 * t16 * 6.0 - k35 * t4 * t15 * 4.0 +
      k35 * t8 * t11 * 4.0 - k35 * t9 * t10 * 8.0 + k35 * t5 * t15 * 2.0 -
      k35 * t8 * t12 * 4.0 + k35 * t9 * t11 * 2.0 - k35 * t9 * t12 * 2.0 -
      k35 * t10 * t11 * 2.0 + k35 * t9 * t13 * 2.0 + k35 * t10 * t12 * 2.0 -
      k35 * t10 * t13 * 2.0 - k35 * t11 * t12 * 4.0 -
      k13 * k16 * k22 * k36 * 1.6E1 - k13 * k16 * k23 * k35 * 1.6E1 -
      k13 * k23 * k25 * k26 * 1.6E1 + k16 * k22 * k23 * k26 * 2.4E1 -
      k15 * k16 * k25 * k33 * 1.6E1 - k15 * k16 * k26 * k32 * 1.6E1 +
      k16 * k22 * k23 * k36 * 4.0E1 + k15 * k25 * k26 * k33 * 1.6E1 +
      k13 * k23 * k35 * k36 * 1.6E1 + k16 * k26 * k32 * k33 * 4.0E1 -
      k22 * k23 * k26 * k36 * 2.4E1 + k16 * k32 * k33 * k36 * 2.4E1 -
      k15 * k33 * k35 * k36 * 1.6E1 - k26 * k32 * k33 * k36 * 2.4E1 -
      k13 * k16 * k22 * t8 * 2.0 - k13 * k16 * k22 * t9 * 2.0 +
      k13 * k16 * k22 * t10 * 6.0 + k13 * k16 * k22 * t11 * 2.0 -
      k12 * k15 * k22 * t14 * 2.0 + k13 * k16 * k22 * t12 * 6.0 +
      k12 * k15 * k22 * t15 * 6.0 - k13 * k16 * k22 * t13 * 6.0 -
      k12 * k15 * k22 * t16 * 2.0 - k13 * k22 * k26 * t8 * 2.0 -
      k13 * k23 * k25 * t8 * 2.0 + k16 * k22 * k23 * t8 * 4.0 +
      k16 * k25 * k26 * t2 * 8.0 + k13 * k22 * k26 * t9 * 6.0 +
      k13 * k23 * k25 * t9 * 6.0 + k16 * k22 * k23 * t9 * 4.0 +
      k16 * k25 * k26 * t3 * 4.0 - k12 * k13 * k32 * t14 * 2.0 +
      k13 * k22 * k26 * t10 * 6.0 + k13 * k23 * k25 * t10 * 2.0 -
      k15 * k16 * k32 * t8 * 2.0 - k16 * k22 * k23 * t10 * 8.0 +
      k16 * k25 * k26 * t4 * 1.2E1 - k12 * k13 * k32 * t15 * 2.0 -
      k13 * k22 * k26 * t11 * 6.0 - k13 * k23 * k25 * t11 * 2.0 -
      k15 * k16 * k32 * t9 * 2.0 + k16 * k22 * k23 * t11 * 4.0 +
      k12 * k13 * k32 * t16 * 6.0 + k13 * k22 * k26 * t12 * 6.0 +
      k13 * k23 * k25 * t12 * 6.0 + k15 * k16 * k32 * t10 * 6.0 -
      k16 * k22 * k23 * t12 * 1.6E1 + k13 * k22 * k26 * t13 * 2.0 +
      k13 * k23 * k25 * t13 * 2.0 - k15 * k16 * k32 * t11 * 6.0 +
      k16 * k22 * k23 * t13 * 1.2E1 + k15 * k16 * k32 * t12 * 6.0 +
      k15 * k16 * k32 * t13 * 2.0 + k13 * k22 * k36 * t8 * 2.0 +
      k13 * k23 * k35 * t8 * 2.0 + k16 * k25 * k36 * t2 * 1.6E1 +
      k16 * k26 * k35 * t2 * 1.6E1 - k22 * k23 * k26 * t8 * 4.0 +
      k13 * k22 * k36 * t9 * 1.0E1 + k13 * k23 * k35 * t9 * 1.0E1 +
      k16 * k25 * k36 * t3 * 8.0 + k16 * k26 * k35 * t3 * 8.0 -
      k22 * k23 * k26 * t9 * 8.0 - k12 * k22 * k33 * t14 * 2.0 -
      k12 * k23 * k32 * t14 * 2.0 - k13 * k22 * k36 * t10 * 6.0 -
      k13 * k23 * k35 * t10 * 2.0 + k15 * k25 * k33 * t8 * 1.0E1 +
      k15 * k26 * k32 * t8 * 1.0E1 + k16 * k25 * k36 * t4 * 8.0 +
      k16 * k26 * k35 * t4 * 8.0 - k12 * k22 * k33 * t15 * 2.0 -
      k12 * k23 * k32 * t15 * 2.0 - k13 * k22 * k36 * t11 * 2.0 -
      k13 * k23 * k35 * t11 * 2.0 + k15 * k25 * k33 * t9 * 2.0 +
      k15 * k26 * k32 * t9 * 2.0 - k12 * k22 * k33 * t16 * 2.0 -
      k12 * k23 * k32 * t16 * 2.0 + k13 * k22 * k36 * t12 * 2.0 +
      k13 * k23 * k35 * t12 * 2.0 + k15 * k25 * k33 * t10 * 2.0 +
      k15 * k26 * k32 * t10 * 2.0 + k22 * k23 * k26 * t12 * 4.0 +
      k13 * k22 * k36 * t13 * 6.0 + k13 * k23 * k35 * t13 * 2.0 +
      k15 * k25 * k33 * t11 * 2.0 + k15 * k26 * k32 * t11 * 6.0 -
      k22 * k23 * k26 * t13 * 8.0 - k15 * k25 * k33 * t12 * 2.0 -
      k15 * k26 * k32 * t12 * 6.0 - k15 * k25 * k33 * t13 * 2.0 -
      k15 * k26 * k32 * t13 * 2.0 + k16 * k32 * k33 * t8 * 4.0 +
      k16 * k35 * k36 * t2 * 8.0 - k22 * k23 * k36 * t8 * 4.0 -
      k25 * k26 * k36 * t2 * 2.8E1 + k16 * k32 * k33 * t9 * 4.0 +
      k16 * k35 * k36 * t3 * 1.2E1 - k22 * k23 * k36 * t9 * 1.6E1 -
      k25 * k26 * k36 * t3 * 4.0 + k15 * k32 * k36 * t8 * 6.0 +
      k15 * k33 * k35 * t8 * 6.0 - k16 * k32 * k33 * t10 * 1.6E1 +
      k16 * k35 * k36 * t4 * 4.0 + k22 * k23 * k36 * t10 * 8.0 -
      k25 * k26 * k36 * t4 * 8.0 - k15 * k32 * k36 * t9 * 2.0 -
      k15 * k33 * k35 * t9 * 2.0 + k16 * k32 * k33 * t11 * 1.2E1 -
      k22 * k23 * k36 * t11 * 4.0 + k25 * k26 * k36 * t5 * 4.0 +
      k15 * k32 * k36 * t10 * 6.0 + k15 * k33 * k35 * t10 * 6.0 -
      k16 * k32 * k33 * t12 * 8.0 + k22 * k23 * k36 * t12 * 4.0 +
      k15 * k32 * k36 * t11 * 2.0 + k15 * k33 * k35 * t11 * 2.0 +
      k16 * k32 * k33 * t13 * 4.0 - k22 * k23 * k36 * t13 * 1.2E1 +
      k15 * k32 * k36 * t12 * 6.0 + k15 * k33 * k35 * t12 * 2.0 -
      k15 * k32 * k36 * t13 * 6.0 - k15 * k33 * k35 * t13 * 2.0 -
      k26 * k32 * k33 * t8 * 1.6E1 - k26 * k35 * k36 * t2 * 2.8E1 -
      k26 * k32 * k33 * t9 * 4.0 - k26 * k35 * k36 * t3 * 8.0 +
      k26 * k32 * k33 * t10 * 4.0 - k26 * k35 * k36 * t4 * 4.0 -
      k26 * k32 * k33 * t11 * 1.2E1 + k26 * k35 * k36 * t5 * 4.0 +
      k26 * k32 * k33 * t12 * 8.0 - k26 * k32 * k33 * t13 * 4.0 -
      k32 * k33 * k36 * t8 * 8.0 - k32 * k33 * k36 * t9 * 4.0 +
      k32 * k33 * k36 * t10 * 4.0 - k32 * k33 * k36 * t11 * 8.0 -
      k13 * k22 * t2 * t15 * 2.0 - k13 * k22 * t3 * t14 * 2.0 +
      k16 * k25 * t3 * t8 * 4.0 + k13 * k22 * t2 * t16 * 2.0 -
      k13 * k22 * t4 * t14 * 3.0 + k16 * k25 * t4 * t8 * 2.0 -
      k13 * k22 * t3 * t16 * 2.0 + k13 * k22 * t4 * t15 -
      k13 * k22 * t8 * t11 * 2.0 - k13 * k22 * t9 * t10 * 6.0 -
      k16 * k25 * t4 * t9 * 2.0 - k13 * k22 * t4 * t16 - k13 * k22 * t8 * t12 -
      k16 * k25 * t2 * t12 * 4.0 - k16 * k25 * t4 * t10 * 4.0 -
      k13 * k22 * t9 * t12 * 3.0 + k16 * k25 * t2 * t13 * 4.0 -
      k16 * k25 * t3 * t12 * 4.0 + k13 * k22 * t9 * t13 * 2.0 -
      k13 * k22 * t10 * t12 * 3.0 - k16 * k25 * t4 * t12 * 1.2E1 -
      k13 * k22 * t10 * t13 * 6.0 + k13 * k22 * t11 * t12 -
      k13 * k22 * t12 * t13 + k22 * k23 * t2 * t14 * 2.0 +
      k25 * k26 * t2 * t8 * 4.0 - k16 * k35 * t3 * t8 * 2.0 +
      k22 * k23 * t2 * t15 * 2.0 + k22 * k23 * t3 * t14 * 4.0 +
      k22 * k23 * t8 * t9 * 2.0 + k25 * k26 * t3 * t8 * 2.0 -
      k16 * k35 * t2 * t10 * 4.0 + k16 * k35 * t3 * t9 * 2.0 +
      k22 * k23 * t2 * t16 * 6.0 + k22 * k23 * t4 * t14 * 6.0 +
      k25 * k26 * t2 * t10 * 2.0 - k25 * k26 * t4 * t8 * 4.0 +
      k15 * k32 * t2 * t15 * 2.0 - k15 * k32 * t3 * t14 * 3.0 +
      k16 * k35 * t2 * t11 * 4.0 - k16 * k35 * t3 * t10 * 1.2E1 +
      k16 * k35 * t4 * t9 * 4.0 + k22 * k23 * t3 * t16 * 4.0 +
      k22 * k23 * t4 * t15 * 2.0 + k22 * k23 * t8 * t11 * 2.0 +
      k22 * k23 * t9 * t10 * 4.0 + k25 * k26 * t4 * t9 * 2.0 -
      k15 * k32 * t2 * t16 * 2.0 - k15 * k32 * t3 * t15 -
      k15 * k32 * t4 * t14 * 2.0 - k15 * k32 * t8 * t10 * 3.0 -
      k16 * k35 * t4 * t10 * 4.0 + k22 * k23 * t4 * t16 * 2.0 +
      k22 * k23 * t8 * t12 * 4.0 + k25 * k26 * t2 * t12 * 6.0 +
      k25 * k26 * t4 * t10 * 2.0 + k15 * k32 * t3 * t16 -
      k15 * k32 * t4 * t15 * 2.0 + k15 * k32 * t8 * t11 * 2.0 -
      k15 * k32 * t9 * t10 - k16 * k35 * t3 * t12 * 4.0 +
      k22 * k23 * t8 * t13 * 2.0 + k22 * k23 * t9 * t12 * 4.0 -
      k25 * k26 * t2 * t13 * 8.0 + k25 * k26 * t3 * t12 * 2.0 -
      k15 * k32 * t8 * t12 * 6.0 - k22 * k23 * t9 * t13 * 4.0 +
      k25 * k26 * t4 * t12 * 1.2E1 - k15 * k32 * t10 * t11 +
      k22 * k23 * t10 * t13 * 4.0 + k22 * k23 * t11 * t12 * 2.0 -
      k15 * k32 * t9 * t13 * 2.0 - k15 * k32 * t10 * t12 * 3.0 +
      k25 * k26 * t5 * t13 * 2.0 + k15 * k32 * t10 * t13 -
      k15 * k32 * t11 * t12 * 6.0 + k22 * k23 * t12 * t13 * 2.0 +
      k25 * k36 * t2 * t8 * 4.0 + k26 * k35 * t2 * t8 * 4.0 +
      k25 * k36 * t2 * t9 * 4.0 - k25 * k36 * t3 * t8 * 4.0 +
      k26 * k35 * t2 * t9 * 4.0 - k26 * k35 * t3 * t8 * 4.0 +
      k25 * k36 * t2 * t10 * 2.0 - k25 * k36 * t3 * t9 * 4.0 -
      k25 * k36 * t4 * t8 * 4.0 + k26 * k35 * t2 * t10 * 2.0 -
      k26 * k35 * t3 * t9 * 4.0 - k26 * k35 * t4 * t8 * 4.0 -
      k25 * k36 * t2 * t11 * 2.0 - k25 * k36 * t4 * t9 * 4.0 -
      k26 * k35 * t2 * t11 * 6.0 - k26 * k35 * t4 * t9 * 4.0;
  coeffs(5) +=
      k25 * k36 * t2 * t12 * 2.0 + k26 * k35 * t2 * t12 * 2.0 -
      k25 * k36 * t2 * t13 * 6.0 - k26 * k35 * t2 * t13 * 2.0 +
      k32 * k33 * t2 * t14 * 2.0 + k32 * k33 * t2 * t15 * 6.0 +
      k32 * k33 * t3 * t14 * 6.0 + k32 * k33 * t8 * t9 * 2.0 +
      k35 * k36 * t2 * t9 * 4.0 + k35 * k36 * t3 * t8 * 2.0 +
      k32 * k33 * t2 * t16 * 2.0 + k32 * k33 * t3 * t15 * 2.0 +
      k32 * k33 * t4 * t14 * 4.0 + k32 * k33 * t8 * t10 * 4.0 +
      k35 * k36 * t2 * t10 * 6.0 - k35 * k36 * t3 * t9 * 4.0 +
      k32 * k33 * t3 * t16 * 2.0 + k32 * k33 * t4 * t15 * 4.0 -
      k32 * k33 * t8 * t11 * 4.0 + k32 * k33 * t9 * t10 * 4.0 -
      k35 * k36 * t2 * t11 * 8.0 + k35 * k36 * t3 * t10 * 1.2E1 +
      k35 * k36 * t4 * t9 * 2.0 + k32 * k33 * t8 * t12 * 4.0 +
      k32 * k33 * t9 * t11 * 2.0 + k35 * k36 * t2 * t12 * 2.0 +
      k35 * k36 * t4 * t10 * 2.0 + k32 * k33 * t10 * t11 * 2.0 +
      k35 * k36 * t3 * t12 * 2.0 + k32 * k33 * t9 * t13 * 2.0 +
      k35 * k36 * t5 * t11 * 2.0 + k32 * k33 * t10 * t13 * 2.0 +
      k32 * k33 * t11 * t12 * 4.0 + k25 * t2 * t4 * t14 +
      k25 * t2 * t4 * t15 * 3.0 + k25 * t4 * t8 * t9 + k25 * t2 * t4 * t16 +
      k25 * t2 * t8 * t12 * 2.0 + k25 * t4 * t8 * t10 * 2.0 +
      k25 * t3 * t8 * t12 * 2.0 + k25 * t2 * t9 * t13 * 2.0 +
      k25 * t2 * t10 * t12 + k25 * t4 * t8 * t12 * 6.0 + k25 * t2 * t11 * t12 +
      k25 * t2 * t12 * t13 + k35 * t2 * t3 * t14 + k35 * t2 * t3 * t15 +
      k35 * t3 * t8 * t9 + k35 * t2 * t3 * t16 * 3.0 +
      k35 * t2 * t8 * t11 * 2.0 + k35 * t2 * t9 * t10 * 2.0 +
      k35 * t3 * t9 * t10 * 6.0 + k35 * t2 * t10 * t11 +
      k35 * t4 * t9 * t10 * 2.0 + k35 * t2 * t10 * t12 +
      k35 * t3 * t9 * t12 * 2.0 + k35 * t2 * t10 * t13 +
      k12 * k13 * k15 * k16 * k25 * 8.0 + k12 * k13 * k15 * k16 * k35 * 8.0 -
      k12 * k13 * k15 * k25 * k26 * 1.6E1 - k12 * k15 * k16 * k22 * k26 * 4.0 -
      k12 * k15 * k16 * k23 * k25 * 4.0 + k12 * k13 * k16 * k25 * k33 * 4.0 +
      k12 * k13 * k16 * k26 * k32 * 4.0 - k13 * k15 * k16 * k22 * k33 * 4.0 -
      k13 * k15 * k16 * k23 * k32 * 4.0 - k12 * k13 * k15 * k25 * k36 * 3.2E1 -
      k12 * k13 * k15 * k26 * k35 * 3.2E1 + k12 * k15 * k16 * k22 * k36 * 4.0 +
      k12 * k15 * k16 * k23 * k35 * 4.0 + k12 * k15 * k23 * k25 * k26 * 1.2E1 -
      k12 * k13 * k16 * k32 * k36 * 4.0 - k12 * k13 * k16 * k33 * k35 * 4.0 -
      k12 * k13 * k25 * k26 * k33 * 4.0 + k12 * k16 * k22 * k26 * k33 * 4.0 +
      k12 * k16 * k23 * k25 * k33 * 4.0 + k12 * k16 * k23 * k26 * k32 * 4.0 -
      k13 * k15 * k22 * k26 * k33 * 1.2E1 -
      k13 * k15 * k23 * k25 * k33 * 1.2E1 -
      k13 * k15 * k23 * k26 * k32 * 1.2E1 +
      k15 * k16 * k22 * k23 * k33 * 1.2E1 -
      k12 * k13 * k15 * k35 * k36 * 1.6E1 +
      k12 * k15 * k22 * k26 * k36 * 2.0E1 +
      k12 * k15 * k23 * k25 * k36 * 2.0E1 +
      k12 * k15 * k23 * k26 * k35 * 2.0E1 - k13 * k16 * k22 * k25 * k35 * 4.0 +
      k13 * k16 * k23 * k32 * k33 * 1.2E1 +
      k12 * k13 * k25 * k33 * k36 * 2.0E1 +
      k12 * k13 * k26 * k32 * k36 * 2.0E1 +
      k12 * k13 * k26 * k33 * k35 * 2.0E1 + k12 * k16 * k22 * k33 * k36 * 4.0 +
      k12 * k16 * k23 * k32 * k36 * 4.0 + k12 * k16 * k23 * k33 * k35 * 4.0 -
      k12 * k23 * k25 * k26 * k33 * 4.0 - k13 * k15 * k22 * k33 * k36 * 1.2E1 -
      k13 * k15 * k23 * k32 * k36 * 1.2E1 -
      k13 * k15 * k23 * k33 * k35 * 1.2E1 + k15 * k22 * k23 * k26 * k33 * 4.0 -
      k12 * k15 * k23 * k35 * k36 * 4.0 - k13 * k22 * k25 * k26 * k35 * 4.0 +
      k16 * k22 * k23 * k25 * k35 * 1.6E1 - k15 * k16 * k25 * k32 * k35 * 4.0 +
      k13 * k23 * k26 * k32 * k33 * 1.2E1 +
      k12 * k13 * k33 * k35 * k36 * 1.2E1 -
      k12 * k22 * k26 * k33 * k36 * 2.0E1 -
      k12 * k23 * k25 * k33 * k36 * 2.0E1 -
      k12 * k23 * k26 * k32 * k36 * 2.0E1 -
      k12 * k23 * k26 * k33 * k35 * 2.0E1 +
      k15 * k22 * k23 * k33 * k36 * 1.2E1 + k13 * k22 * k25 * k35 * k36 * 4.0 -
      k22 * k23 * k25 * k26 * k35 * 8.0 + k15 * k25 * k26 * k32 * k35 * 4.0 +
      k13 * k23 * k32 * k33 * k36 * 4.0 - k12 * k23 * k33 * k35 * k36 * 4.0 +
      k16 * k25 * k32 * k33 * k35 * 1.6E1 -
      k22 * k23 * k25 * k35 * k36 * 1.6E1 - k15 * k25 * k32 * k35 * k36 * 4.0 -
      k25 * k26 * k32 * k33 * k35 * 1.6E1 - k25 * k32 * k33 * k35 * k36 * 8.0 +
      k12 * k13 * k15 * k25 * t10 * 4.0 + k12 * k13 * k15 * k25 * t12 * 4.0 -
      k12 * k15 * k16 * k22 * t12 * 2.0 - k12 * k13 * k15 * k25 * t13 * 8.0 +
      k12 * k15 * k16 * k22 * t13 * 4.0 - k13 * k16 * k22 * k26 * t2 * 2.0 -
      k13 * k16 * k23 * k25 * t2 * 2.0 - k13 * k16 * k22 * k26 * t3 * 2.0 -
      k13 * k16 * k23 * k25 * t3 * 6.0 + k13 * k16 * k22 * k26 * t4 * 2.0 +
      k13 * k16 * k23 * k25 * t4 * 2.0 - k12 * k13 * k16 * k32 * t10 * 2.0 -
      k12 * k15 * k22 * k26 * t8 * 2.0 - k12 * k15 * k23 * k25 * t8 * 2.0 +
      k12 * k13 * k16 * k32 * t11 * 4.0 + k12 * k13 * k15 * k35 * t10 * 4.0 -
      k12 * k15 * k22 * k26 * t10 * 6.0 - k12 * k15 * k23 * k25 * t10 * 2.0 -
      k12 * k13 * k15 * k35 * t11 * 8.0 + k12 * k13 * k15 * k35 * t12 * 4.0 -
      k12 * k15 * k22 * k26 * t12 * 2.0 - k12 * k15 * k23 * k25 * t12 * 2.0 +
      k12 * k15 * k22 * k26 * t13 * 4.0 + k12 * k15 * k23 * k25 * t13 * 4.0 -
      k13 * k16 * k22 * k36 * t2 * 2.0 - k13 * k16 * k23 * k35 * t2 * 2.0 -
      k13 * k23 * k25 * k26 * t2 * 4.0 + k13 * k16 * k22 * k36 * t3 * 4.0 +
      k13 * k16 * k23 * k35 * t3 * 1.2E1 - k12 * k13 * k25 * k33 * t8 * 4.0 -
      k12 * k13 * k26 * k32 * t8 * 4.0 + k12 * k16 * k22 * k33 * t8 * 3.0 +
      k12 * k16 * k23 * k32 * t8 * 3.0 + k13 * k15 * k22 * k33 * t8 +
      k13 * k15 * k23 * k32 * t8 + k13 * k16 * k22 * k36 * t4 * 4.0 +
      k13 * k16 * k23 * k35 * t4 * 4.0 + k13 * k23 * k25 * k26 * t4 * 2.0 -
      k15 * k16 * k25 * k33 * t2 * 2.0 - k15 * k16 * k26 * k32 * t2 * 2.0 -
      k16 * k22 * k23 * k26 * t4 * 8.0 - k12 * k13 * k25 * k33 * t9 * 2.0 -
      k12 * k13 * k26 * k32 * t9 * 2.0 + k12 * k16 * k22 * k33 * t9 * 3.0 +
      k12 * k16 * k23 * k32 * t9 * 3.0 + k13 * k15 * k22 * k33 * t9 +
      k13 * k15 * k23 * k32 * t9 + k15 * k16 * k25 * k33 * t3 * 4.0 +
      k15 * k16 * k26 * k32 * t3 * 4.0 - k12 * k13 * k25 * k33 * t10 * 2.0 -
      k12 * k13 * k26 * k32 * t10 * 2.0 - k12 * k15 * k22 * k36 * t8 * 2.0 -
      k12 * k15 * k23 * k35 * t8 * 2.0 - k12 * k16 * k22 * k33 * t10 * 3.0 -
      k12 * k16 * k23 * k32 * t10 + k13 * k15 * k22 * k33 * t10 * 9.0 +
      k13 * k15 * k23 * k32 * t10 * 3.0 + k15 * k16 * k25 * k33 * t4 * 1.2E1 +
      k15 * k16 * k26 * k32 * t4 * 4.0 - k12 * k13 * k25 * k33 * t11 * 2.0 -
      k12 * k13 * k26 * k32 * t11 * 6.0 - k12 * k15 * k22 * k36 * t9 * 4.0 -
      k12 * k15 * k23 * k35 * t9 * 4.0 - k12 * k16 * k22 * k33 * t11 -
      k12 * k16 * k23 * k32 * t11 - k13 * k15 * k22 * k33 * t11 -
      k13 * k15 * k23 * k32 * t11 - k12 * k13 * k25 * k33 * t12 * 2.0 -
      k12 * k13 * k26 * k32 * t12 * 6.0 - k12 * k15 * k22 * k36 * t10 * 6.0 -
      k12 * k15 * k23 * k35 * t10 * 2.0 - k12 * k16 * k22 * k33 * t12 -
      k12 * k16 * k23 * k32 * t12 * 3.0 + k13 * k15 * k22 * k33 * t12 * 3.0 +
      k13 * k15 * k23 * k32 * t12 * 9.0 + k12 * k13 * k25 * k33 * t13 * 6.0 +
      k12 * k13 * k26 * k32 * t13 * 6.0 + k12 * k15 * k22 * k36 * t11 * 6.0 +
      k12 * k15 * k23 * k35 * t11 * 6.0 - k12 * k16 * k22 * k33 * t13 -
      k12 * k16 * k23 * k32 * t13 - k13 * k15 * k22 * k33 * t13 -
      k13 * k15 * k23 * k32 * t13 - k12 * k15 * k22 * k36 * t12 * 2.0 -
      k12 * k15 * k23 * k35 * t12 * 2.0 - k12 * k15 * k22 * k36 * t13 * 6.0 -
      k12 * k15 * k23 * k35 * t13 * 2.0 - k16 * k22 * k23 * k36 * t2 * 8.0 +
      k13 * k22 * k26 * k36 * t3 * 2.0 + k13 * k23 * k25 * k36 * t3 * 6.0 +
      k13 * k23 * k26 * k35 * t3 * 6.0 - k16 * k22 * k23 * k36 * t3 * 8.0 +
      k12 * k22 * k26 * k33 * t8 * 5.0 + k12 * k23 * k25 * k33 * t8 * 5.0 +
      k12 * k23 * k26 * k32 * t8 * 5.0 + k13 * k22 * k26 * k36 * t4 * 4.0 +
      k13 * k23 * k25 * k36 * t4 * 4.0 + k13 * k23 * k26 * k35 * t4 * 4.0 -
      k15 * k16 * k32 * k36 * t2 * 2.0 - k15 * k16 * k33 * k35 * t2 * 2.0 -
      k15 * k22 * k23 * k33 * t8 * 6.0 + k15 * k25 * k26 * k33 * t2 * 4.0 -
      k16 * k22 * k23 * k36 * t4 * 8.0 - k12 * k13 * k32 * k36 * t9 * 2.0 -
      k12 * k13 * k33 * k35 * t9 * 2.0 - k12 * k22 * k26 * k33 * t9 -
      k12 * k23 * k25 * k33 * t9 - k12 * k23 * k26 * k32 * t9 +
      k15 * k16 * k32 * k36 * t3 * 2.0 + k15 * k16 * k33 * k35 * t3 * 2.0 -
      k15 * k22 * k23 * k33 * t9 * 2.0 - k15 * k25 * k26 * k33 * t3 * 2.0 -
      k12 * k13 * k32 * k36 * t10 * 2.0 - k12 * k13 * k33 * k35 * t10 * 2.0 +
      k12 * k22 * k26 * k33 * t10 * 3.0 + k12 * k23 * k25 * k33 * t10 +
      k12 * k23 * k26 * k32 * t10 + k13 * k22 * k25 * k35 * t8 * 2.0 -
      k15 * k16 * k32 * k36 * t4 * 2.0 - k15 * k16 * k33 * k35 * t4 * 6.0 -
      k15 * k22 * k23 * k33 * t10 * 4.0 - k15 * k25 * k26 * k33 * t4 * 1.2E1 +
      k12 * k13 * k32 * k36 * t11 * 4.0 + k12 * k13 * k33 * k35 * t11 * 4.0 +
      k12 * k22 * k26 * k33 * t11 * 3.0 + k12 * k23 * k25 * k33 * t11 +
      k12 * k23 * k26 * k32 * t11 * 3.0 + k13 * k22 * k25 * k35 * t9 * 6.0 -
      k15 * k22 * k23 * k33 * t11 * 2.0 - k12 * k13 * k32 * k36 * t12 * 6.0 -
      k12 * k13 * k33 * k35 * t12 * 2.0 - k12 * k22 * k25 * k32 * t14;
  coeffs(5) +=
      k12 * k22 * k26 * k33 * t12 * 3.0 + k12 * k23 * k25 * k33 * t12 * 3.0 +
      k12 * k23 * k26 * k32 * t12 * 9.0 + k13 * k22 * k25 * k35 * t10 * 6.0 -
      k15 * k22 * k23 * k33 * t12 * 2.0 + k12 * k22 * k25 * k32 * t15 * 3.0 -
      k12 * k22 * k26 * k33 * t13 * 5.0 - k12 * k23 * k25 * k33 * t13 * 5.0 -
      k12 * k23 * k26 * k32 * t13 * 5.0 + k15 * k22 * k23 * k33 * t13 * 2.0 -
      k12 * k22 * k25 * k32 * t16 * 5.0 + k13 * k22 * k25 * k35 * t12 * 4.0 -
      k13 * k23 * k32 * k33 * t8 * 2.0 + k13 * k23 * k35 * k36 * t2 * 4.0 -
      k16 * k26 * k32 * k33 * t2 * 8.0 + k22 * k23 * k26 * k36 * t2 * 4.0 -
      k13 * k23 * k32 * k33 * t9 * 6.0 - k13 * k23 * k35 * k36 * t3 * 1.2E1 -
      k16 * k26 * k32 * k33 * t3 * 8.0 - k12 * k22 * k33 * k36 * t8 -
      k12 * k23 * k32 * k36 * t8 - k12 * k23 * k33 * k35 * t8 -
      k13 * k23 * k32 * k33 * t10 * 2.0 - k13 * k23 * k35 * k36 * t4 * 2.0 -
      k16 * k26 * k32 * k33 * t4 * 8.0 + k12 * k22 * k33 * k36 * t9 * 5.0 +
      k12 * k23 * k32 * k36 * t9 * 5.0 + k12 * k23 * k33 * k35 * t9 * 5.0 +
      k13 * k23 * k32 * k33 * t11 * 2.0 + k15 * k25 * k33 * k36 * t3 * 4.0 +
      k15 * k26 * k32 * k36 * t3 * 4.0 + k15 * k26 * k33 * k35 * t3 * 4.0 +
      k12 * k22 * k33 * k36 * t10 * 9.0 + k12 * k23 * k32 * k36 * t10 * 3.0 +
      k12 * k23 * k33 * k35 * t10 * 3.0 - k13 * k23 * k32 * k33 * t12 * 4.0 +
      k15 * k25 * k33 * k36 * t4 * 6.0 + k15 * k26 * k32 * k36 * t4 * 2.0 +
      k15 * k26 * k33 * k35 * t4 * 6.0 - k22 * k23 * k25 * k35 * t8 * 8.0 -
      k12 * k22 * k33 * k36 * t11 * 5.0 - k12 * k23 * k32 * k36 * t11 * 5.0 -
      k12 * k23 * k33 * k35 * t11 * 5.0 - k13 * k23 * k32 * k33 * t13 * 2.0 -
      k22 * k23 * k25 * k35 * t9 * 8.0 - k12 * k22 * k32 * k35 * t14 +
      k12 * k22 * k33 * k36 * t12 + k12 * k23 * k32 * k36 * t12 * 3.0 +
      k12 * k23 * k33 * k35 * t12 + k15 * k25 * k32 * k35 * t8 * 6.0 -
      k12 * k22 * k32 * k35 * t15 * 5.0 + k12 * k22 * k33 * k36 * t13 * 3.0 +
      k12 * k23 * k32 * k36 * t13 * 3.0 + k12 * k23 * k33 * k35 * t13 +
      k15 * k25 * k32 * k35 * t9 * 2.0 + k12 * k22 * k32 * k35 * t16 * 3.0 +
      k15 * k25 * k32 * k35 * t10 * 4.0 + k15 * k25 * k32 * k35 * t12 * 6.0 -
      k16 * k32 * k33 * k36 * t3 * 8.0 - k15 * k33 * k35 * k36 * t2 * 4.0 +
      k15 * k33 * k35 * k36 * t3 * 2.0 + k26 * k32 * k33 * k36 * t2 * 4.0 -
      k25 * k32 * k33 * k35 * t8 * 8.0 - k25 * k32 * k33 * k35 * t9 * 8.0 -
      k13 * k16 * k22 * t4 * t9 - k13 * k16 * k22 * t2 * t12 -
      k13 * k16 * k22 * t4 * t10 * 6.0 - k13 * k16 * k22 * t3 * t12 * 2.0 -
      k12 * k15 * k22 * t2 * t16 * 2.0 - k12 * k15 * k22 * t4 * t14 -
      k13 * k16 * k22 * t4 * t12 * 6.0 - k12 * k15 * k22 * t4 * t15 -
      k12 * k15 * k22 * t4 * t16 - k12 * k15 * k22 * t8 * t12 -
      k12 * k15 * k22 * t9 * t13 * 2.0 - k12 * k15 * k22 * t10 * t12 * 3.0 -
      k12 * k15 * k22 * t11 * t12 - k13 * k22 * k26 * t4 * t8 -
      k13 * k23 * k25 * t4 * t8 + k16 * k22 * k23 * t4 * t8 * 2.0 -
      k16 * k25 * k26 * t2 * t4 * 4.0 - k12 * k13 * k32 * t2 * t15 * 2.0 -
      k12 * k13 * k32 * t3 * t14 - k12 * k15 * k22 * t12 * t13 -
      k13 * k22 * k26 * t4 * t9 - k13 * k23 * k25 * t4 * t9 -
      k15 * k16 * k32 * t3 * t8 + k16 * k22 * k23 * t4 * t9 * 2.0 -
      k12 * k13 * k32 * t3 * t15 - k13 * k22 * k26 * t2 * t12 * 4.0 -
      k13 * k22 * k26 * t4 * t10 * 3.0 - k13 * k23 * k25 * t2 * t12 * 4.0 -
      k13 * k23 * k25 * t4 * t10 - k15 * k16 * k32 * t2 * t10 +
      k16 * k22 * k23 * t2 * t12 * 4.0 + k16 * k22 * k23 * t4 * t10 * 4.0 -
      k12 * k13 * k32 * t3 * t16 - k12 * k13 * k32 * t8 * t11 * 2.0 -
      k12 * k13 * k32 * t9 * t10 + k13 * k22 * k26 * t2 * t13 * 2.0 -
      k13 * k22 * k26 * t3 * t12 + k13 * k23 * k25 * t2 * t13 * 2.0 -
      k13 * k23 * k25 * t3 * t12 * 3.0 - k15 * k16 * k32 * t3 * t10 * 6.0 -
      k16 * k22 * k23 * t2 * t13 * 4.0 + k16 * k22 * k23 * t3 * t12 * 4.0 -
      k13 * k22 * k26 * t4 * t12 * 6.0 - k13 * k23 * k25 * t4 * t12 * 6.0 -
      k15 * k16 * k32 * t4 * t10 * 2.0 + k16 * k22 * k23 * t4 * t12 * 1.2E1 -
      k12 * k13 * k32 * t10 * t11 - k15 * k16 * k32 * t3 * t12 * 6.0 -
      k12 * k13 * k32 * t10 * t12 * 3.0 - k12 * k13 * k32 * t10 * t13 -
      k13 * k22 * k36 * t3 * t9 * 2.0 - k13 * k23 * k35 * t3 * t9 * 6.0 +
      k22 * k23 * k26 * t4 * t8 * 4.0 + k12 * k22 * k33 * t2 * t15 +
      k12 * k22 * k33 * t3 * t14 + k12 * k23 * k32 * t2 * t15 +
      k12 * k23 * k32 * t3 * t14 * 3.0 - k13 * k22 * k36 * t2 * t11 * 2.0 -
      k13 * k22 * k36 * t4 * t9 * 2.0 - k13 * k23 * k35 * t2 * t11 * 2.0 -
      k13 * k23 * k35 * t4 * t9 * 2.0 - k15 * k25 * k33 * t3 * t8 * 2.0 -
      k15 * k26 * k32 * t3 * t8 * 2.0 + k12 * k22 * k33 * t2 * t16 +
      k12 * k22 * k33 * t4 * t14 * 3.0 + k12 * k23 * k32 * t2 * t16 +
      k12 * k23 * k32 * t4 * t14 - k13 * k22 * k36 * t2 * t12 * 2.0 -
      k13 * k23 * k35 * t2 * t12 * 2.0 - k15 * k25 * k33 * t2 * t10 * 2.0 -
      k15 * k25 * k33 * t4 * t8 * 6.0 - k15 * k26 * k32 * t2 * t10 * 2.0 -
      k15 * k26 * k32 * t4 * t8 * 2.0 + k22 * k23 * k26 * t2 * t12 * 2.0 +
      k12 * k22 * k33 * t3 * t16 + k12 * k22 * k33 * t4 * t15 * 3.0 +
      k12 * k22 * k33 * t8 * t11 * 3.0 + k12 * k22 * k33 * t9 * t10 * 3.0 +
      k12 * k23 * k32 * t3 * t16 * 3.0 + k12 * k23 * k32 * t4 * t15 +
      k12 * k23 * k32 * t8 * t11 * 3.0 + k12 * k23 * k32 * t9 * t10 +
      k12 * k22 * k33 * t8 * t12 + k12 * k23 * k32 * t8 * t12 * 3.0 -
      k15 * k25 * k33 * t2 * t13 * 2.0 - k15 * k26 * k32 * t2 * t13 * 2.0 +
      k12 * k22 * k33 * t9 * t13 * 3.0 + k12 * k23 * k32 * t9 * t13 * 3.0 +
      k12 * k22 * k33 * t10 * t13 * 3.0 + k12 * k22 * k33 * t11 * t12 +
      k12 * k23 * k32 * t10 * t13 + k12 * k23 * k32 * t11 * t12 * 3.0 +
      k16 * k32 * k33 * t3 * t8 * 2.0 - k16 * k35 * k36 * t2 * t3 * 4.0 +
      k22 * k23 * k36 * t2 * t9 * 4.0 + k25 * k26 * k36 * t2 * t3 * 2.0 +
      k16 * k32 * k33 * t2 * t10 * 4.0 + k16 * k32 * k33 * t3 * t9 * 2.0 +
      k22 * k23 * k36 * t3 * t9 * 4.0 - k15 * k32 * k36 * t3 * t8 -
      k15 * k33 * k35 * t3 * t8 - k16 * k32 * k33 * t2 * t11 * 4.0 +
      k16 * k32 * k33 * t3 * t10 * 1.2E1 + k22 * k23 * k36 * t2 * t11 * 2.0 +
      k22 * k23 * k36 * t4 * t9 * 4.0 - k15 * k32 * k36 * t2 * t10 * 4.0 -
      k15 * k32 * k36 * t3 * t9 - k15 * k33 * k35 * t2 * t10 * 4.0 -
      k15 * k33 * k35 * t3 * t9 + k16 * k32 * k33 * t4 * t10 * 4.0 +
      k22 * k23 * k36 * t2 * t12 * 2.0 + k15 * k32 * k36 * t2 * t11 * 2.0 -
      k15 * k32 * k36 * t3 * t10 * 6.0 + k15 * k33 * k35 * t2 * t11 * 2.0 -
      k15 * k33 * k35 * t3 * t10 * 6.0 + k16 * k32 * k33 * t3 * t12 * 4.0 +
      k22 * k23 * k36 * t2 * t13 * 6.0 - k15 * k32 * k36 * t4 * t10 -
      k15 * k33 * k35 * t4 * t10 * 3.0 - k15 * k32 * k36 * t3 * t12 * 3.0 -
      k15 * k33 * k35 * t3 * t12 + k26 * k32 * k33 * t2 * t8 * 4.0 +
      k26 * k32 * k33 * t3 * t8 * 4.0 + k26 * k32 * k33 * t2 * t10 * 2.0 +
      k26 * k32 * k33 * t4 * t8 * 4.0 + k26 * k35 * k36 * t2 * t4 * 2.0 +
      k26 * k32 * k33 * t2 * t11 * 6.0 + k26 * k32 * k33 * t2 * t13 * 2.0 +
      k32 * k33 * k36 * t2 * t10 * 2.0 + k32 * k33 * k36 * t3 * t9 * 4.0 -
      k13 * k22 * t2 * t4 * t15 + k16 * k25 * t2 * t4 * t10 +
      k16 * k25 * t2 * t3 * t12 - k13 * k22 * t2 * t11 * t12 +
      k25 * k26 * t2 * t4 * t8 * 2.0 + k16 * k35 * t2 * t4 * t10 -
      k15 * k32 * t2 * t3 * t16 + k16 * k35 * t2 * t3 * t12 +
      k22 * k23 * t2 * t9 * t13 * 2.0 - k15 * k32 * t2 * t10 * t13 +
      k25 * k36 * t2 * t4 * t10 + k26 * k35 * t2 * t4 * t10 +
      k25 * k36 * t2 * t3 * t12 + k26 * k35 * t2 * t3 * t12 +
      k35 * k36 * t2 * t3 * t9 * 2.0 + k32 * k33 * t2 * t8 * t11 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k26 * 8.0 -
      k12 * k13 * k16 * k22 * k23 * k33 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k36 * 8.0 -
      k13 * k15 * k16 * k22 * k25 * k32 * 2.0 -
      k12 * k15 * k16 * k22 * k25 * k35 * 4.0 -
      k12 * k13 * k22 * k23 * k26 * k33 * 4.0 +
      k12 * k13 * k15 * k26 * k32 * k33 * 8.0 -
      k12 * k15 * k16 * k23 * k32 * k33 * 4.0 -
      k12 * k13 * k16 * k25 * k32 * k35 * 4.0 -
      k12 * k16 * k22 * k25 * k26 * k32 * 2.0 -
      k13 * k15 * k16 * k22 * k32 * k35 * 2.0 -
      k13 * k15 * k22 * k25 * k26 * k32 * 2.0 +
      k15 * k16 * k22 * k23 * k25 * k32 * 8.0 +
      k12 * k15 * k22 * k25 * k26 * k35 * 1.2E1 -
      k12 * k13 * k22 * k23 * k33 * k36 * 4.0 +
      k12 * k13 * k15 * k32 * k33 * k36 * 8.0 -
      k12 * k15 * k23 * k26 * k32 * k33 * 4.0 +
      k13 * k16 * k22 * k25 * k32 * k33 * 4.0 +
      k12 * k13 * k25 * k26 * k32 * k35 * 8.0 +
      k12 * k16 * k22 * k25 * k32 * k36 * 6.0 +
      k12 * k16 * k22 * k25 * k33 * k35 * 6.0 +
      k12 * k16 * k22 * k26 * k32 * k35 * 6.0 +
      k12 * k16 * k23 * k25 * k32 * k35 * 6.0 -
      k13 * k15 * k22 * k25 * k32 * k36 * 1.0E1 -
      k13 * k15 * k22 * k25 * k33 * k35 * 1.0E1 -
      k13 * k15 * k22 * k26 * k32 * k35 * 1.0E1 -
      k13 * k15 * k23 * k25 * k32 * k35 * 1.0E1 +
      k15 * k16 * k22 * k23 * k32 * k35 * 4.0 -
      k15 * k22 * k23 * k25 * k26 * k32 * 4.0 +
      k12 * k15 * k22 * k25 * k35 * k36 * 8.0 -
      k12 * k15 * k23 * k32 * k33 * k36 * 4.0 +
      k13 * k16 * k22 * k32 * k33 * k35 * 8.0 +
      k13 * k22 * k25 * k26 * k32 * k33 * 4.0 -
      k16 * k22 * k23 * k25 * k32 * k33 * 1.6E1 +
      k12 * k13 * k25 * k32 * k35 * k36 * 1.2E1 -
      k12 * k16 * k22 * k32 * k35 * k36 * 2.0 -
      k12 * k22 * k25 * k26 * k32 * k36 * 1.0E1 -
      k12 * k22 * k25 * k26 * k33 * k35 * 1.0E1 -
      k12 * k23 * k25 * k26 * k32 * k35 * 1.0E1 -
      k13 * k15 * k22 * k32 * k35 * k36 * 2.0 +
      k15 * k22 * k23 * k25 * k32 * k36 * 8.0 +
      k15 * k22 * k23 * k25 * k33 * k35 * 8.0 +
      k15 * k22 * k23 * k26 * k32 * k35 * 8.0 +
      k13 * k22 * k25 * k32 * k33 * k36 * 8.0 +
      k13 * k22 * k26 * k32 * k33 * k35 * 8.0 +
      k13 * k23 * k25 * k32 * k33 * k35 * 8.0 -
      k16 * k22 * k23 * k32 * k33 * k35 * 1.6E1 +
      k22 * k23 * k25 * k26 * k32 * k33 * 8.0 -
      k12 * k22 * k25 * k33 * k35 * k36 * 1.0E1 -
      k12 * k22 * k26 * k32 * k35 * k36 * 1.0E1 -
      k12 * k23 * k25 * k32 * k35 * k36 * 1.0E1 +
      k15 * k22 * k23 * k32 * k35 * k36 * 4.0 -
      k13 * k22 * k32 * k33 * k35 * k36 * 4.0 +
      k22 * k23 * k32 * k33 * k35 * k36 * 8.0 +
      k12 * k15 * k16 * k22 * k26 * t4 * 2.0 +
      k12 * k15 * k16 * k23 * k25 * t4 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * t12 * 4.0 -
      k12 * k13 * k16 * k25 * k33 * t3 * 4.0 -
      k12 * k13 * k16 * k26 * k32 * t3 * 4.0 +
      k13 * k15 * k16 * k22 * k33 * t3 * 2.0 +
      k13 * k15 * k16 * k23 * k32 * t3 * 6.0 +
      k13 * k15 * k16 * k22 * k33 * t4 * 6.0 +
      k13 * k15 * k16 * k23 * k32 * t4 * 2.0 +
      k12 * k13 * k15 * k25 * k36 * t3 * 4.0 +
      k12 * k13 * k15 * k26 * k35 * t3 * 4.0 +
      k12 * k13 * k15 * k25 * k36 * t4 * 4.0 +
      k12 * k13 * k15 * k26 * k35 * t4 * 4.0 -
      k12 * k15 * k16 * k22 * k36 * t4 * 4.0 -
      k12 * k15 * k16 * k23 * k35 * t4 * 4.0 -
      k12 * k15 * k23 * k25 * k26 * t4 * 2.0 -
      k12 * k13 * k25 * k26 * k33 * t2 * 4.0 +
      k12 * k16 * k22 * k26 * k33 * t2 + k12 * k16 * k23 * k25 * k33 * t2 +
      k12 * k16 * k23 * k26 * k32 * t2 +
      k13 * k15 * k22 * k26 * k33 * t2 * 3.0 +
      k13 * k15 * k23 * k25 * k33 * t2 * 3.0 +
      k13 * k15 * k23 * k26 * k32 * t2 * 3.0 -
      k15 * k16 * k22 * k23 * k33 * t2 * 2.0 +
      k12 * k13 * k16 * k32 * k36 * t3 * 2.0 +
      k12 * k13 * k16 * k33 * k35 * t3 * 2.0 -
      k12 * k13 * k22 * k23 * k33 * t9 * 2.0 -
      k12 * k13 * k25 * k26 * k33 * t3 * 2.0 +
      k12 * k16 * k22 * k26 * k33 * t3 +
      k12 * k16 * k23 * k25 * k33 * t3 * 3.0 +
      k12 * k16 * k23 * k26 * k32 * t3 * 3.0 +
      k13 * k15 * k22 * k26 * k33 * t3 +
      k13 * k15 * k23 * k25 * k33 * t3 * 3.0 +
      k13 * k15 * k23 * k26 * k32 * t3 * 3.0 -
      k15 * k16 * k22 * k23 * k33 * t3 * 4.0 -
      k12 * k15 * k22 * k26 * k36 * t2 * 4.0 -
      k12 * k15 * k23 * k25 * k36 * t2 * 4.0 -
      k12 * k15 * k23 * k26 * k35 * t2 * 4.0 -
      k12 * k16 * k22 * k26 * k33 * t4 * 6.0 -
      k12 * k16 * k23 * k25 * k33 * t4 * 6.0 -
      k12 * k16 * k23 * k26 * k32 * t4 * 2.0 +
      k13 * k15 * k22 * k26 * k33 * t4 * 6.0 +
      k13 * k15 * k23 * k25 * k33 * t4 * 6.0 +
      k13 * k15 * k23 * k26 * k32 * t4 * 2.0 -
      k13 * k16 * k22 * k25 * k35 * t2 * 2.0 -
      k15 * k16 * k22 * k23 * k33 * t4 * 1.2E1 -
      k12 * k13 * k22 * k23 * k33 * t11 * 2.0 -
      k12 * k15 * k22 * k26 * k36 * t3 * 2.0 -
      k12 * k15 * k23 * k25 * k36 * t3 * 6.0 -
      k12 * k15 * k23 * k26 * k35 * t3 * 6.0 +
      k12 * k13 * k15 * k32 * k33 * t10 * 4.0 -
      k12 * k13 * k22 * k23 * k33 * t12 * 2.0 +
      k12 * k16 * k22 * k25 * k32 * t8 * 3.0 +
      k13 * k15 * k22 * k25 * k32 * t8 -
      k12 * k13 * k22 * k23 * k33 * t13 * 2.0 -
      k12 * k15 * k22 * k25 * k35 * t8 * 2.0 +
      k12 * k16 * k22 * k25 * k32 * t10 * 3.0 +
      k13 * k15 * k22 * k25 * k32 * t10 * 3.0 -
      k12 * k15 * k22 * k25 * k35 * t10 * 6.0 -
      k12 * k16 * k22 * k25 * k32 * t12 * 6.0 +
      k13 * k15 * k22 * k25 * k32 * t12 * 6.0 -
      k13 * k16 * k23 * k32 * k33 * t2 * 2.0 -
      k13 * k16 * k23 * k32 * k33 * t3 * 1.2E1 -
      k12 * k13 * k25 * k33 * k36 * t2 * 4.0 -
      k12 * k13 * k26 * k32 * k36 * t2 * 4.0 -
      k12 * k13 * k26 * k33 * k35 * t2 * 4.0 +
      k12 * k16 * k22 * k33 * k36 * t2 + k12 * k16 * k23 * k32 * k36 * t2 +
      k12 * k16 * k23 * k33 * k35 * t2 +
      k12 * k23 * k25 * k26 * k33 * t2 * 2.0 +
      k13 * k15 * k22 * k33 * k36 * t2 * 3.0 +
      k13 * k15 * k23 * k32 * k36 * t2 * 3.0 +
      k13 * k15 * k23 * k33 * k35 * t2 * 3.0 -
      k13 * k16 * k23 * k32 * k33 * t4 * 4.0 -
      k15 * k22 * k23 * k26 * k33 * t2 * 4.0 -
      k12 * k16 * k22 * k33 * k36 * t3 * 2.0 -
      k12 * k16 * k23 * k32 * k36 * t3 * 6.0 -
      k12 * k16 * k23 * k33 * k35 * t3 * 6.0 +
      k13 * k15 * k22 * k33 * k36 * t3 * 2.0 +
      k13 * k15 * k23 * k32 * k36 * t3 * 6.0 +
      k13 * k15 * k23 * k33 * k35 * t3 * 6.0 -
      k12 * k13 * k25 * k33 * k36 * t4 * 6.0 -
      k12 * k13 * k26 * k32 * k36 * t4 * 2.0 -
      k12 * k13 * k26 * k33 * k35 * t4 * 6.0 -
      k12 * k15 * k23 * k32 * k33 * t8 * 2.0 -
      k12 * k15 * k23 * k35 * k36 * t2 * 4.0 +
      k12 * k16 * k22 * k33 * k36 * t4 * 3.0 +
      k12 * k16 * k23 * k32 * k36 * t4 +
      k12 * k16 * k23 * k33 * k35 * t4 * 3.0 +
      k12 * k23 * k25 * k26 * k33 * t4 * 6.0 +
      k13 * k15 * k22 * k33 * k36 * t4 * 3.0;
  coeffs(5) +=
      k13 * k15 * k23 * k32 * k36 * t4 +
      k13 * k15 * k23 * k33 * k35 * t4 * 3.0 -
      k13 * k22 * k25 * k26 * k35 * t2 * 4.0 -
      k12 * k15 * k23 * k32 * k33 * t10 * 2.0 -
      k12 * k15 * k23 * k35 * k36 * t4 * 2.0 +
      k12 * k22 * k25 * k26 * k32 * t8 * 6.0 -
      k15 * k16 * k25 * k32 * k35 * t2 * 2.0 -
      k15 * k22 * k23 * k25 * k32 * t8 * 4.0 -
      k12 * k13 * k25 * k32 * k35 * t9 * 2.0 -
      k12 * k15 * k23 * k32 * k33 * t11 * 2.0 +
      k12 * k16 * k22 * k32 * k35 * t9 * 3.0 +
      k13 * k15 * k22 * k32 * k35 * t9 -
      k12 * k16 * k22 * k32 * k35 * t10 * 6.0 +
      k13 * k15 * k22 * k32 * k35 * t10 * 6.0 -
      k12 * k15 * k23 * k32 * k33 * t13 * 2.0 -
      k12 * k13 * k25 * k32 * k35 * t12 * 6.0 +
      k12 * k16 * k22 * k32 * k35 * t12 * 3.0 +
      k12 * k22 * k25 * k26 * k32 * t12 * 6.0 +
      k13 * k15 * k22 * k32 * k35 * t12 * 3.0 -
      k13 * k23 * k26 * k32 * k33 * t2 * 8.0 -
      k13 * k23 * k26 * k32 * k33 * t3 * 6.0 +
      k12 * k22 * k26 * k33 * k36 * t2 * 4.0 +
      k12 * k23 * k25 * k33 * k36 * t2 * 4.0 +
      k12 * k23 * k26 * k32 * k36 * t2 * 4.0 +
      k12 * k23 * k26 * k33 * k35 * t2 * 4.0 -
      k13 * k23 * k26 * k32 * k33 * t4 * 4.0 -
      k15 * k22 * k23 * k33 * k36 * t2 * 8.0 -
      k12 * k13 * k33 * k35 * k36 * t3 * 2.0 +
      k12 * k22 * k26 * k33 * k36 * t3 +
      k12 * k23 * k25 * k33 * k36 * t3 * 3.0 +
      k12 * k23 * k26 * k32 * k36 * t3 * 3.0 +
      k12 * k23 * k26 * k33 * k35 * t3 * 3.0 -
      k15 * k22 * k23 * k33 * k36 * t3 * 4.0 +
      k12 * k22 * k26 * k33 * k36 * t4 * 3.0 +
      k12 * k23 * k25 * k33 * k36 * t4 * 3.0 +
      k12 * k23 * k26 * k32 * k36 * t4 +
      k12 * k23 * k26 * k33 * k35 * t4 * 3.0 -
      k13 * k22 * k25 * k32 * k33 * t8 * 2.0 +
      k13 * k22 * k25 * k35 * k36 * t2 * 4.0 -
      k15 * k22 * k23 * k33 * k36 * t4 * 6.0 +
      k22 * k23 * k25 * k26 * k35 * t2 * 4.0 -
      k13 * k22 * k25 * k32 * k33 * t9 * 2.0 -
      k12 * k22 * k25 * k32 * k36 * t8 - k12 * k22 * k25 * k33 * k35 * t8 -
      k12 * k22 * k26 * k32 * k35 * t8 - k12 * k23 * k25 * k32 * k35 * t8 -
      k13 * k22 * k25 * k32 * k33 * t10 * 6.0 -
      k15 * k22 * k23 * k32 * k35 * t8 * 2.0 +
      k15 * k25 * k26 * k32 * k35 * t2 * 4.0 -
      k12 * k22 * k25 * k32 * k36 * t9 - k12 * k22 * k25 * k33 * k35 * t9 -
      k12 * k22 * k26 * k32 * k35 * t9 - k12 * k23 * k25 * k32 * k35 * t9 -
      k15 * k22 * k23 * k32 * k35 * t9 * 2.0 +
      k12 * k22 * k25 * k32 * k36 * t10 * 3.0 +
      k12 * k22 * k25 * k33 * k35 * t10 * 3.0 +
      k12 * k22 * k26 * k32 * k35 * t10 * 3.0 +
      k12 * k23 * k25 * k32 * k35 * t10 -
      k13 * k22 * k25 * k32 * k33 * t12 * 4.0 -
      k15 * k22 * k23 * k32 * k35 * t10 * 4.0 +
      k12 * k22 * k25 * k32 * k36 * t12 * 3.0 +
      k12 * k22 * k25 * k33 * k35 * t12 +
      k12 * k22 * k26 * k32 * k35 * t12 * 3.0 +
      k12 * k23 * k25 * k32 * k35 * t12 * 3.0 -
      k13 * k23 * k32 * k33 * k36 * t2 * 4.0 -
      k15 * k22 * k23 * k32 * k35 * t12 * 6.0 +
      k12 * k23 * k33 * k35 * k36 * t2 * 2.0 +
      k12 * k23 * k33 * k35 * k36 * t3 * 6.0 +
      k22 * k23 * k25 * k32 * k33 * t8 * 8.0 -
      k13 * k22 * k32 * k33 * k35 * t9 * 4.0 -
      k15 * k25 * k32 * k35 * k36 * t2 * 4.0 +
      k12 * k22 * k32 * k35 * k36 * t9 * 6.0 +
      k12 * k22 * k32 * k35 * k36 * t10 * 6.0 +
      k22 * k23 * k32 * k33 * k35 * t9 * 8.0 +
      k25 * k32 * k33 * k35 * k36 * t2 * 4.0 +
      k12 * k13 * k15 * k25 * t4 * t10 -
      k12 * k15 * k16 * k22 * t4 * t10 * 3.0 +
      k12 * k13 * k15 * k25 * t3 * t12 - k12 * k15 * k16 * k22 * t3 * t12 -
      k13 * k16 * k22 * k26 * t2 * t4 - k13 * k16 * k23 * k25 * t2 * t4 -
      k12 * k13 * k16 * k32 * t4 * t10 - k12 * k15 * k22 * k26 * t4 * t8 -
      k12 * k15 * k23 * k25 * t4 * t8 - k12 * k13 * k16 * k32 * t3 * t12 * 3.0 +
      k12 * k13 * k15 * k35 * t4 * t10 + k12 * k13 * k15 * k35 * t3 * t12 -
      k12 * k15 * k22 * k26 * t2 * t13 * 2.0 -
      k12 * k15 * k23 * k25 * t2 * t13 * 2.0 -
      k13 * k23 * k25 * k26 * t2 * t4 * 2.0 +
      k16 * k22 * k23 * k26 * t2 * t4 * 2.0 -
      k12 * k13 * k25 * k33 * t4 * t10 * 3.0 -
      k12 * k13 * k26 * k32 * t4 * t10 +
      k12 * k16 * k22 * k33 * t4 * t10 * 9.0 +
      k12 * k16 * k23 * k32 * t4 * t10 - k12 * k13 * k25 * k33 * t3 * t12 -
      k12 * k13 * k26 * k32 * t3 * t12 * 3.0 +
      k12 * k16 * k22 * k33 * t3 * t12 +
      k12 * k16 * k23 * k32 * t3 * t12 * 9.0 -
      k12 * k15 * k22 * k36 * t4 * t10 * 3.0 -
      k12 * k15 * k23 * k35 * t4 * t10 - k12 * k15 * k22 * k36 * t3 * t12 -
      k12 * k15 * k23 * k35 * t3 * t12 * 3.0 -
      k13 * k22 * k26 * k36 * t2 * t4 * 2.0 -
      k13 * k23 * k25 * k36 * t2 * t4 * 2.0 -
      k13 * k23 * k26 * k35 * t2 * t4 * 2.0 +
      k16 * k22 * k23 * k36 * t2 * t4 * 2.0 - k15 * k16 * k32 * k36 * t2 * t3 -
      k15 * k16 * k33 * k35 * t2 * t3 - k12 * k13 * k32 * k36 * t3 * t9 -
      k12 * k13 * k33 * k35 * t3 * t9 + k12 * k22 * k26 * k33 * t4 * t8 * 3.0 +
      k12 * k23 * k25 * k33 * t4 * t8 * 3.0 + k12 * k23 * k26 * k32 * t4 * t8 -
      k12 * k13 * k32 * k36 * t2 * t11 * 2.0 -
      k12 * k13 * k33 * k35 * t2 * t11 * 2.0 +
      k12 * k22 * k26 * k33 * t2 * t13 + k12 * k23 * k25 * k33 * t2 * t13 +
      k12 * k23 * k26 * k32 * t2 * t13 -
      k15 * k22 * k23 * k33 * t2 * t13 * 2.0 +
      k12 * k22 * k25 * k32 * t2 * t16 -
      k13 * k22 * k25 * k35 * t2 * t12 * 2.0 +
      k12 * k22 * k25 * k32 * t8 * t12 * 3.0 +
      k16 * k26 * k32 * k33 * t2 * t3 * 2.0 +
      k22 * k23 * k26 * k36 * t2 * t4 * 2.0 -
      k13 * k23 * k32 * k33 * t2 * t11 * 2.0 -
      k15 * k25 * k33 * k36 * t2 * t3 * 2.0 -
      k15 * k26 * k32 * k36 * t2 * t3 * 2.0 -
      k15 * k26 * k33 * k35 * t2 * t3 * 2.0 + k12 * k22 * k33 * k36 * t3 * t9 +
      k12 * k23 * k32 * k36 * t3 * t9 * 3.0 +
      k12 * k23 * k33 * k35 * t3 * t9 * 3.0 + k12 * k22 * k33 * k36 * t2 * t11 +
      k12 * k23 * k32 * k36 * t2 * t11 + k12 * k23 * k33 * k35 * t2 * t11 +
      k12 * k22 * k32 * k35 * t2 * t15 -
      k15 * k25 * k32 * k35 * t2 * t10 * 2.0 +
      k22 * k23 * k25 * k35 * t2 * t12 * 2.0 +
      k12 * k22 * k32 * k35 * t9 * t10 * 3.0 +
      k16 * k32 * k33 * k36 * t2 * t3 * 2.0 -
      k15 * k33 * k35 * k36 * t2 * t3 * 2.0 +
      k26 * k32 * k33 * k36 * t2 * t3 * 2.0 +
      k25 * k32 * k33 * k35 * t2 * t10 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k25 * k32 * 8.0 +
      k12 * k13 * k15 * k22 * k23 * k25 * k35 * 8.0 +
      k12 * k13 * k16 * k22 * k23 * k32 * k35 * 4.0 -
      k12 * k13 * k22 * k23 * k25 * k26 * k32 * 4.0 +
      k12 * k15 * k16 * k22 * k25 * k32 * k33 * 4.0 +
      k12 * k13 * k15 * k25 * k32 * k33 * k35 * 8.0 -
      k12 * k15 * k16 * k22 * k32 * k33 * k35 * 8.0 -
      k12 * k15 * k22 * k25 * k26 * k32 * k33 * 4.0 -
      k12 * k13 * k22 * k23 * k32 * k35 * k36 * 4.0 -
      k12 * k15 * k22 * k32 * k33 * k35 * k36 * 4.0 +
      k12 * k13 * k15 * k16 * k22 * k23 * t4 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k26 * t4 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k33 * t4 * 6.0 +
      k12 * k13 * k15 * k16 * k32 * k33 * t3 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k36 * t4 * 2.0 -
      k12 * k13 * k22 * k23 * k26 * k33 * t4 * 6.0 +
      k12 * k13 * k15 * k26 * k32 * k33 * t3 * 2.0 -
      k12 * k15 * k16 * k23 * k32 * k33 * t3 * 6.0 -
      k12 * k13 * k22 * k23 * k25 * k32 * t12 * 6.0 -
      k13 * k16 * k22 * k25 * k32 * k33 * t2 * 2.0 +
      k12 * k13 * k15 * k32 * k33 * k36 * t3 * 2.0 -
      k12 * k13 * k25 * k26 * k32 * k35 * t2 * 4.0 +
      k12 * k16 * k22 * k25 * k32 * k36 * t2 +
      k12 * k16 * k22 * k25 * k33 * k35 * t2 +
      k12 * k16 * k22 * k26 * k32 * k35 * t2 +
      k12 * k16 * k23 * k25 * k32 * k35 * t2 +
      k13 * k15 * k22 * k25 * k32 * k36 * t2 * 3.0 +
      k13 * k15 * k22 * k25 * k33 * k35 * t2 * 3.0 +
      k13 * k15 * k22 * k26 * k32 * k35 * t2 * 3.0 +
      k13 * k15 * k23 * k25 * k32 * k35 * t2 * 3.0 -
      k15 * k16 * k22 * k23 * k32 * k35 * t2 * 2.0 -
      k12 * k13 * k22 * k23 * k32 * k35 * t9 * 2.0 -
      k12 * k15 * k22 * k25 * k32 * k33 * t8 * 2.0 -
      k12 * k15 * k22 * k25 * k35 * k36 * t2 * 4.0 -
      k13 * k22 * k25 * k26 * k32 * k33 * t2 * 4.0 +
      k16 * k22 * k23 * k25 * k32 * k33 * t2 * 4.0 -
      k12 * k15 * k23 * k32 * k33 * k36 * t3 * 6.0 +
      k12 * k22 * k25 * k26 * k32 * k36 * t2 * 2.0 +
      k12 * k22 * k25 * k26 * k33 * k35 * t2 * 2.0 +
      k12 * k23 * k25 * k26 * k32 * k35 * t2 * 2.0 -
      k15 * k22 * k23 * k25 * k32 * k36 * t2 * 4.0 -
      k15 * k22 * k23 * k25 * k33 * k35 * t2 * 4.0 -
      k15 * k22 * k23 * k26 * k32 * k35 * t2 * 4.0 -
      k12 * k15 * k22 * k32 * k33 * k35 * t10 * 6.0 -
      k13 * k22 * k25 * k32 * k33 * k36 * t2 * 4.0 -
      k13 * k22 * k26 * k32 * k33 * k35 * t2 * 4.0 -
      k13 * k23 * k25 * k32 * k33 * k35 * t2 * 4.0 +
      k16 * k22 * k23 * k32 * k33 * k35 * t2 * 4.0 +
      k12 * k22 * k25 * k33 * k35 * k36 * t2 * 2.0 +
      k12 * k22 * k26 * k32 * k35 * k36 * t2 * 2.0 +
      k12 * k23 * k25 * k32 * k35 * k36 * t2 * 2.0 -
      k15 * k22 * k23 * k32 * k35 * k36 * t2 * 4.0 +
      k22 * k23 * k25 * k32 * k33 * k36 * t2 * 4.0 +
      k22 * k23 * k26 * k32 * k33 * k35 * t2 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k25 * k32 * k33 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k32 * k33 * k35 * 4.0;
  coeffs(6) =
      k16 * t14 * -8.0 - k16 * t15 * 2.4E1 - k16 * t16 * 2.4E1 -
      k16 * t19 * 2.0 - k16 * t20 * 2.0 + k26 * t14 * 2.4E1 + k26 * t15 * 8.0 +
      k26 * t16 * 2.4E1 + k26 * t17 * 2.0 + k26 * t19 * 2.0 +
      k36 * t14 * 2.4E1 + k36 * t15 * 2.4E1 + k36 * t16 * 8.0 +
      k36 * t18 * 2.0 + k36 * t20 * 2.0 + t8 * t14 * 2.0 + t8 * t15 * 1.0E1 +
      t9 * t14 * 2.0 + t8 * t16 * 2.0 + t9 * t15 * 2.0 - t10 * t14 * 1.0E1 +
      t9 * t16 * 1.0E1 - t10 * t15 * 2.0 + t11 * t14 * 6.0 - t10 * t16 * 1.0E1 +
      t11 * t15 * 6.0 - t12 * t14 * 1.0E1 + t8 * t19 + t11 * t16 * 6.0 -
      t12 * t15 * 1.0E1 + t13 * t14 * 6.0 + t11 * t17 - t12 * t16 * 2.0 +
      t13 * t15 * 6.0 + t9 * t20 + t13 * t16 * 6.0 + t11 * t19 + t13 * t18 +
      t13 * t20 - k16 * k26 * k36 * 4.8E1 + k13 * k23 * t14 * 8.0 -
      k16 * k26 * t8 * 1.2E1 - k13 * k23 * t15 * 8.0 - k16 * k26 * t9 * 4.0 +
      k13 * k23 * t16 * 8.0 + k16 * k26 * t10 * 1.2E1 -
      k16 * k26 * t11 * 1.2E1 + k16 * k26 * t12 * 2.0E1 - k13 * k23 * t19 -
      k16 * k26 * t13 * 1.2E1 - k16 * k36 * t8 * 4.0 - k16 * k36 * t9 * 1.2E1 +
      k15 * k33 * t14 * 8.0 + k16 * k36 * t10 * 2.0E1 + k15 * k33 * t15 * 8.0 -
      k16 * k36 * t11 * 1.2E1 - k15 * k33 * t16 * 8.0 +
      k16 * k36 * t12 * 1.2E1 - k16 * k36 * t13 * 1.2E1 - k15 * k33 * t20 +
      k26 * k36 * t8 * 1.2E1 + k26 * k36 * t9 * 1.2E1 -
      k26 * k36 * t10 * 1.2E1 + k26 * k36 * t11 * 1.2E1 +
      k25 * k35 * t14 * 1.2E1 - k26 * k36 * t12 * 1.2E1 +
      k25 * k35 * t15 * 1.2E1 + k26 * k36 * t13 * 1.2E1 +
      k25 * k35 * t16 * 1.2E1 + k16 * t2 * t15 * 4.0 + k16 * t3 * t14 * 2.0 +
      k16 * t2 * t16 * 4.0 + k16 * t3 * t15 * 2.0 + k16 * t4 * t14 * 2.0 +
      k16 * t8 * t10 * 2.0 + k16 * t3 * t16 * 6.0 + k16 * t4 * t15 * 6.0 -
      k16 * t8 * t11 * 4.0 + k16 * t9 * t10 * 2.0 + k16 * t4 * t16 * 2.0 +
      k16 * t8 * t12 * 2.0 + k16 * t9 * t12 * 2.0 + k16 * t10 * t11 * 2.0 +
      k16 * t3 * t19 - k16 * t9 * t13 * 4.0 - k16 * t10 * t12 * 8.0 +
      k16 * t10 * t13 * 6.0 + k16 * t11 * t12 * 6.0 + k16 * t4 * t20 +
      k16 * t12 * t13 * 2.0 - k26 * t2 * t14 * 2.0 - k26 * t2 * t15 * 2.0 -
      k26 * t3 * t14 * 4.0 - k26 * t8 * t9 * 2.0 - k26 * t2 * t16 * 1.4E1 -
      k26 * t4 * t14 * 6.0 - k26 * t8 * t10 * 2.0 - k26 * t3 * t16 * 4.0 -
      k26 * t4 * t15 * 2.0 + k26 * t8 * t11 * 6.0 - k26 * t9 * t10 * 4.0 -
      k26 * t4 * t16 * 2.0 - k26 * t8 * t12 * 8.0 + k26 * t5 * t16 * 2.0 +
      k26 * t8 * t13 * 2.0 - k26 * t9 * t12 * 2.0 + k26 * t9 * t13 * 4.0 +
      k26 * t10 * t12 * 2.0 - k26 * t10 * t13 * 4.0 - k26 * t11 * t12 * 6.0 -
      k26 * t12 * t13 * 2.0 - k36 * t2 * t14 * 2.0 - k36 * t2 * t15 * 1.4E1 -
      k36 * t3 * t14 * 6.0 - k36 * t8 * t9 * 2.0 - k36 * t2 * t16 * 2.0 -
      k36 * t3 * t15 * 2.0 - k36 * t4 * t14 * 4.0 - k36 * t8 * t10 * 2.0 -
      k36 * t3 * t16 * 2.0 - k36 * t4 * t15 * 4.0 + k36 * t8 * t11 * 4.0 -
      k36 * t9 * t10 * 8.0 + k36 * t5 * t15 * 2.0 - k36 * t8 * t12 * 4.0 +
      k36 * t9 * t11 * 2.0 - k36 * t9 * t12 * 2.0 - k36 * t10 * t11 * 2.0 +
      k36 * t9 * t13 * 6.0 + k36 * t10 * t12 * 2.0 - k36 * t10 * t13 * 6.0 -
      k36 * t11 * t12 * 4.0 + t2 * t8 * t15 * 2.0 + t3 * t8 * t14 +
      t2 * t10 * t14 + t3 * t8 * t15 + t2 * t9 * t16 * 2.0 + t2 * t10 * t15 +
      t3 * t8 * t16 + t3 * t10 * t14 * 6.0 - t4 * t8 * t15 * 2.0 +
      t4 * t9 * t14 + t8 * t9 * t10 + t2 * t10 * t16 * 3.0 + t2 * t12 * t14 -
      t3 * t9 * t16 * 2.0 + t4 * t9 * t15 + t4 * t10 * t14 * 3.0 -
      t2 * t11 * t16 * 4.0 + t2 * t12 * t15 * 3.0 + t3 * t10 * t16 * 6.0 +
      t3 * t12 * t14 * 3.0 + t4 * t9 * t16 + t4 * t10 * t15 + t8 * t9 * t12 +
      t8 * t10 * t11 + t2 * t12 * t16 - t2 * t13 * t15 * 4.0 + t3 * t12 * t15 +
      t4 * t10 * t16 + t4 * t12 * t14 * 6.0 + t8 * t10 * t12 * 2.0 +
      t3 * t12 * t16 + t4 * t12 * t15 * 6.0 + t8 * t10 * t13 -
      t8 * t11 * t12 * 2.0 + t9 * t10 * t12 * 2.0 + t5 * t11 * t16 -
      t9 * t10 * t13 * 2.0 + t9 * t11 * t12 + t5 * t13 * t15 + t10 * t11 * t12 +
      t9 * t12 * t13 + t10 * t12 * t13 - k13 * k16 * k23 * k36 * 1.6E1 -
      k15 * k16 * k26 * k33 * 1.6E1 - k16 * k25 * k26 * k35 * 2.4E1 -
      k16 * k25 * k35 * k36 * 2.4E1 + k25 * k26 * k35 * k36 * 2.4E1 -
      k12 * k13 * k15 * t15 * 8.0 - k12 * k13 * k15 * t16 * 8.0 -
      k13 * k16 * k23 * t8 * 2.0 - k13 * k16 * k23 * t9 * 2.0 +
      k13 * k16 * k23 * t10 * 2.0 + k13 * k16 * k23 * t11 * 2.0 -
      k12 * k15 * k23 * t14 * 2.0 + k13 * k16 * k23 * t12 * 6.0 +
      k12 * k15 * k23 * t15 * 6.0 - k13 * k16 * k23 * t13 * 6.0 -
      k12 * k15 * k23 * t16 * 2.0 - k13 * k23 * k26 * t8 * 2.0 +
      k13 * k23 * k26 * t9 * 6.0 - k12 * k13 * k33 * t14 * 2.0 +
      k13 * k23 * k26 * t10 * 2.0 - k15 * k16 * k33 * t8 * 2.0 -
      k12 * k13 * k33 * t15 * 2.0 - k13 * k23 * k26 * t11 * 6.0 -
      k15 * k16 * k33 * t9 * 2.0 + k12 * k13 * k33 * t16 * 6.0 +
      k13 * k22 * k25 * t14 * 2.0 + k13 * k23 * k26 * t12 * 6.0 +
      k15 * k16 * k33 * t10 * 6.0 - k13 * k22 * k25 * t15 * 6.0 +
      k13 * k23 * k26 * t13 * 2.0 - k15 * k16 * k33 * t11 * 6.0 +
      k13 * k22 * k25 * t16 * 2.0 + k15 * k16 * k33 * t12 * 2.0 +
      k15 * k16 * k33 * t13 * 2.0 - k13 * k22 * k25 * t19 +
      k13 * k23 * k36 * t8 * 2.0 + k16 * k26 * k36 * t2 * 1.6E1 +
      k13 * k23 * k36 * t9 * 1.0E1 + k16 * k26 * k36 * t3 * 8.0 -
      k12 * k23 * k33 * t14 * 2.0 - k13 * k23 * k36 * t10 * 2.0 +
      k15 * k26 * k33 * t8 * 1.0E1 + k16 * k26 * k36 * t4 * 8.0 -
      k12 * k23 * k33 * t15 * 2.0 - k13 * k23 * k36 * t11 * 2.0 +
      k15 * k26 * k33 * t9 * 2.0 - k12 * k23 * k33 * t16 * 2.0 +
      k13 * k22 * k35 * t14 * 6.0 + k13 * k23 * k36 * t12 * 2.0 +
      k15 * k26 * k33 * t10 * 2.0 - k16 * k25 * k35 * t8 * 4.0 -
      k22 * k23 * k25 * t14 * 8.0 - k13 * k22 * k35 * t15 * 2.0 +
      k13 * k23 * k36 * t13 * 6.0 + k15 * k26 * k33 * t11 * 6.0 -
      k16 * k25 * k35 * t9 * 4.0 + k13 * k22 * k35 * t16 * 6.0 +
      k15 * k25 * k32 * t14 * 6.0 - k15 * k26 * k33 * t12 * 2.0 +
      k16 * k25 * k35 * t10 * 8.0 - k22 * k23 * k25 * t16 * 8.0 +
      k15 * k25 * k32 * t15 * 6.0 - k15 * k26 * k33 * t13 * 2.0 -
      k15 * k25 * k32 * t16 * 2.0 + k16 * k25 * k35 * t12 * 8.0 +
      k15 * k33 * k36 * t8 * 6.0 - k15 * k33 * k36 * t9 * 2.0 +
      k15 * k33 * k36 * t10 * 6.0 - k22 * k23 * k35 * t14 * 1.2E1 +
      k25 * k26 * k35 * t8 * 8.0 + k15 * k33 * k36 * t11 * 2.0 -
      k22 * k23 * k35 * t15 * 4.0 + k25 * k26 * k35 * t9 * 4.0 +
      k15 * k32 * k35 * t14 * 2.0 + k15 * k33 * k36 * t12 * 2.0 -
      k22 * k23 * k35 * t16 * 1.2E1 - k25 * k26 * k35 * t10 * 4.0 +
      k15 * k32 * k35 * t15 * 2.0 - k15 * k33 * k36 * t13 * 6.0 -
      k15 * k32 * k35 * t16 * 6.0 - k25 * k26 * k35 * t12 * 8.0 -
      k15 * k32 * k35 * t20 - k25 * k32 * k33 * t14 * 1.2E1 +
      k25 * k35 * k36 * t8 * 4.0 - k25 * k32 * k33 * t15 * 1.2E1 +
      k25 * k35 * k36 * t9 * 8.0 - k25 * k32 * k33 * t16 * 4.0 -
      k25 * k35 * k36 * t10 * 8.0 - k25 * k35 * k36 * t12 * 4.0 -
      k32 * k33 * k35 * t14 * 8.0 - k32 * k33 * k35 * t15 * 8.0 -
      k13 * k23 * t2 * t15 * 2.0 - k13 * k23 * t3 * t14 * 6.0 +
      k16 * k26 * t3 * t8 * 4.0 + k13 * k23 * t2 * t16 * 2.0 -
      k13 * k23 * t4 * t14 * 3.0 + k16 * k26 * t4 * t8 * 2.0 -
      k13 * k23 * t3 * t16 * 6.0 + k13 * k23 * t4 * t15 -
      k13 * k23 * t8 * t11 * 2.0 - k13 * k23 * t9 * t10 * 2.0 -
      k16 * k26 * t4 * t9 * 2.0 - k13 * k23 * t4 * t16 - k13 * k23 * t8 * t12 -
      k16 * k26 * t2 * t12 * 4.0 - k16 * k26 * t4 * t10 * 4.0 -
      k13 * k23 * t9 * t12 * 3.0 + k16 * k26 * t2 * t13 * 4.0 -
      k16 * k26 * t3 * t12 * 4.0 + k13 * k23 * t9 * t13 * 2.0 -
      k13 * k23 * t10 * t12 - k16 * k26 * t4 * t12 * 1.2E1 -
      k13 * k23 * t10 * t13 * 2.0 + k13 * k23 * t11 * t12 -
      k13 * k23 * t12 * t13 - k16 * k36 * t3 * t8 * 2.0 -
      k16 * k36 * t2 * t10 * 4.0 + k16 * k36 * t3 * t9 * 2.0 +
      k15 * k33 * t2 * t15 * 2.0 - k15 * k33 * t3 * t14 * 3.0 +
      k16 * k36 * t2 * t11 * 4.0 - k16 * k36 * t3 * t10 * 1.2E1 +
      k16 * k36 * t4 * t9 * 4.0 - k15 * k33 * t2 * t16 * 2.0 -
      k15 * k33 * t3 * t15 - k15 * k33 * t4 * t14 * 6.0 -
      k15 * k33 * t8 * t10 * 3.0 - k16 * k36 * t4 * t10 * 4.0 +
      k15 * k33 * t3 * t16 - k15 * k33 * t4 * t15 * 6.0 +
      k15 * k33 * t8 * t11 * 2.0 - k15 * k33 * t9 * t10 -
      k16 * k36 * t3 * t12 * 4.0 - k15 * k33 * t8 * t12 * 2.0 -
      k15 * k33 * t10 * t11 - k15 * k33 * t9 * t13 * 2.0 -
      k15 * k33 * t10 * t12 + k15 * k33 * t10 * t13 -
      k15 * k33 * t11 * t12 * 2.0 + k26 * k36 * t2 * t8 * 4.0 +
      k26 * k36 * t2 * t9 * 4.0 - k26 * k36 * t3 * t8 * 4.0 +
      k26 * k36 * t2 * t10 * 2.0 - k26 * k36 * t3 * t9 * 4.0 -
      k26 * k36 * t4 * t8 * 4.0 - k26 * k36 * t2 * t11 * 6.0 -
      k26 * k36 * t4 * t9 * 4.0 - k25 * k35 * t2 * t14 * 2.0 +
      k26 * k36 * t2 * t12 * 2.0 - k25 * k35 * t2 * t15 * 6.0 -
      k25 * k35 * t8 * t9 * 2.0 - k26 * k36 * t2 * t13 * 6.0 -
      k25 * k35 * t2 * t16 * 6.0 - k25 * k35 * t8 * t10 * 4.0 -
      k25 * k35 * t9 * t10 * 4.0 - k25 * k35 * t8 * t12 * 4.0 -
      k25 * k35 * t9 * t12 * 4.0 - k16 * t2 * t3 * t16 * 2.0 -
      k16 * t2 * t4 * t15 * 2.0 + k16 * t4 * t8 * t10 + k16 * t3 * t8 * t12 +
      k16 * t4 * t9 * t10 + k16 * t2 * t10 * t12 * 2.0 + k16 * t3 * t9 * t12 -
      k16 * t2 * t10 * t13 * 2.0 - k16 * t2 * t11 * t12 * 2.0 +
      k16 * t3 * t10 * t12 * 6.0 + k16 * t4 * t10 * t12 * 6.0 +
      k26 * t2 * t4 * t14 + k26 * t2 * t4 * t15 + k26 * t4 * t8 * t9 +
      k26 * t2 * t4 * t16 + k26 * t2 * t8 * t12 * 2.0 +
      k26 * t4 * t8 * t10 * 2.0 + k26 * t3 * t8 * t12 * 2.0 +
      k26 * t2 * t9 * t13 * 2.0 + k26 * t2 * t10 * t12 +
      k26 * t4 * t8 * t12 * 6.0 + k26 * t2 * t11 * t12 * 3.0 +
      k26 * t2 * t12 * t13 + k36 * t2 * t3 * t14 + k36 * t2 * t3 * t15 +
      k36 * t3 * t8 * t9 + k36 * t2 * t3 * t16 + k36 * t2 * t8 * t11 * 2.0 +
      k36 * t2 * t9 * t10 * 2.0 + k36 * t3 * t9 * t10 * 6.0 +
      k36 * t2 * t10 * t11 + k36 * t4 * t9 * t10 * 2.0 + k36 * t2 * t10 * t12 +
      k36 * t3 * t9 * t12 * 2.0 + k36 * t2 * t10 * t13 * 3.0 +
      t2 * t4 * t8 * t15 + t2 * t3 * t9 * t16 + t2 * t8 * t11 * t12 +
      t2 * t9 * t10 * t13 + k12 * k13 * k15 * k16 * k26 * 8.0;
  coeffs(6) +=
      k12 * k13 * k15 * k16 * k36 * 8.0 - k12 * k15 * k16 * k23 * k26 * 4.0 +
      k12 * k13 * k16 * k26 * k33 * 4.0 - k13 * k15 * k16 * k23 * k33 * 4.0 -
      k12 * k13 * k15 * k26 * k36 * 3.2E1 + k12 * k15 * k16 * k23 * k36 * 4.0 +
      k13 * k16 * k22 * k25 * k26 * 4.0 - k12 * k13 * k16 * k33 * k36 * 4.0 +
      k12 * k16 * k23 * k26 * k33 * 4.0 - k13 * k15 * k23 * k26 * k33 * 1.2E1 +
      k12 * k15 * k23 * k26 * k36 * 2.0E1 - k13 * k16 * k22 * k25 * k36 * 4.0 -
      k13 * k16 * k22 * k26 * k35 * 4.0 - k13 * k16 * k23 * k25 * k35 * 4.0 +
      k16 * k22 * k23 * k25 * k26 * 8.0 - k15 * k16 * k25 * k26 * k32 * 1.2E1 +
      k12 * k13 * k26 * k33 * k36 * 2.0E1 + k12 * k16 * k23 * k33 * k36 * 4.0 -
      k13 * k15 * k23 * k33 * k36 * 1.2E1 -
      k13 * k16 * k22 * k35 * k36 * 1.2E1 - k13 * k22 * k25 * k26 * k36 * 4.0 -
      k13 * k23 * k25 * k26 * k35 * 4.0 + k16 * k22 * k23 * k25 * k36 * 1.6E1 +
      k16 * k22 * k23 * k26 * k35 * 1.6E1 - k15 * k16 * k25 * k32 * k36 * 4.0 -
      k15 * k16 * k25 * k33 * k35 * 4.0 - k15 * k16 * k26 * k32 * k35 * 4.0 -
      k12 * k23 * k26 * k33 * k36 * 2.0E1 + k13 * k22 * k26 * k35 * k36 * 4.0 +
      k13 * k23 * k25 * k35 * k36 * 4.0 + k16 * k22 * k23 * k35 * k36 * 2.4E1 +
      k16 * k25 * k26 * k32 * k33 * 2.4E1 - k22 * k23 * k25 * k26 * k36 * 8.0 +
      k15 * k16 * k32 * k35 * k36 * 4.0 + k15 * k25 * k26 * k32 * k36 * 4.0 +
      k15 * k25 * k26 * k33 * k35 * 4.0 + k16 * k25 * k32 * k33 * k36 * 1.6E1 +
      k16 * k26 * k32 * k33 * k35 * 1.6E1 -
      k22 * k23 * k26 * k35 * k36 * 1.6E1 - k15 * k25 * k33 * k35 * k36 * 4.0 -
      k15 * k26 * k32 * k35 * k36 * 4.0 + k16 * k32 * k33 * k35 * k36 * 8.0 -
      k25 * k26 * k32 * k33 * k36 * 1.6E1 - k26 * k32 * k33 * k35 * k36 * 8.0 +
      k12 * k13 * k15 * k26 * t10 * 4.0 + k12 * k13 * k15 * k26 * t12 * 4.0 -
      k12 * k15 * k16 * k23 * t12 * 2.0 - k12 * k13 * k15 * k26 * t13 * 8.0 +
      k12 * k15 * k16 * k23 * t13 * 4.0 - k13 * k16 * k23 * k26 * t2 * 2.0 -
      k13 * k16 * k23 * k26 * t3 * 6.0 + k13 * k16 * k23 * k26 * t4 * 2.0 -
      k12 * k13 * k16 * k33 * t10 * 2.0 - k12 * k15 * k23 * k26 * t8 * 2.0 -
      k13 * k16 * k22 * k25 * t8 * 2.0 + k12 * k13 * k16 * k33 * t11 * 4.0 +
      k12 * k13 * k15 * k36 * t10 * 4.0 - k12 * k15 * k23 * k26 * t10 * 2.0 -
      k13 * k16 * k22 * k25 * t10 * 6.0 - k12 * k13 * k15 * k36 * t11 * 8.0 +
      k12 * k13 * k15 * k36 * t12 * 4.0 - k12 * k15 * k23 * k26 * t12 * 2.0 +
      k13 * k16 * k22 * k25 * t12 * 2.0 + k12 * k15 * k23 * k26 * t13 * 4.0 +
      k12 * k15 * k22 * k25 * t16 * 4.0 - k13 * k16 * k23 * k36 * t2 * 2.0 +
      k13 * k16 * k23 * k36 * t3 * 1.2E1 - k12 * k13 * k26 * k33 * t8 * 4.0 +
      k12 * k16 * k23 * k33 * t8 * 3.0 + k13 * k15 * k23 * k33 * t8 +
      k13 * k16 * k23 * k36 * t4 * 4.0 - k15 * k16 * k26 * k33 * t2 * 2.0 -
      k12 * k13 * k26 * k33 * t9 * 2.0 + k12 * k16 * k23 * k33 * t9 * 3.0 +
      k13 * k15 * k23 * k33 * t9 + k15 * k16 * k26 * k33 * t3 * 4.0 -
      k12 * k13 * k26 * k33 * t10 * 2.0 - k12 * k15 * k23 * k36 * t8 * 2.0 -
      k12 * k16 * k23 * k33 * t10 + k13 * k15 * k23 * k33 * t10 * 3.0 -
      k13 * k22 * k25 * k26 * t8 * 4.0 + k15 * k16 * k26 * k33 * t4 * 1.2E1 +
      k16 * k22 * k23 * k25 * t8 * 8.0 - k12 * k13 * k26 * k33 * t11 * 6.0 -
      k12 * k15 * k23 * k36 * t9 * 4.0 - k12 * k16 * k23 * k33 * t11 -
      k13 * k15 * k23 * k33 * t11 - k13 * k16 * k22 * k35 * t9 * 2.0 -
      k12 * k13 * k25 * k32 * t14 * 2.0 - k12 * k13 * k26 * k33 * t12 * 2.0 -
      k12 * k15 * k23 * k36 * t10 * 2.0 + k12 * k16 * k22 * k32 * t14 -
      k12 * k16 * k23 * k33 * t12 + k13 * k15 * k22 * k32 * t14 * 3.0 +
      k13 * k15 * k23 * k33 * t12 * 3.0 + k13 * k16 * k22 * k35 * t10 * 1.2E1 -
      k15 * k16 * k25 * k32 * t8 * 2.0 - k12 * k13 * k25 * k32 * t15 * 6.0 +
      k12 * k13 * k26 * k33 * t13 * 6.0 + k12 * k15 * k23 * k36 * t11 * 6.0 -
      k12 * k16 * k22 * k32 * t15 - k12 * k16 * k23 * k33 * t13 -
      k13 * k15 * k22 * k32 * t15 - k13 * k15 * k23 * k33 * t13 +
      k12 * k13 * k25 * k32 * t16 * 6.0 - k12 * k15 * k22 * k35 * t14 * 2.0 -
      k12 * k15 * k23 * k36 * t12 * 2.0 - k12 * k16 * k22 * k32 * t16 -
      k13 * k15 * k22 * k32 * t16 + k13 * k16 * k22 * k35 * t12 * 4.0 +
      k13 * k22 * k25 * k26 * t12 * 2.0 + k15 * k16 * k25 * k32 * t10 * 4.0 -
      k16 * k22 * k23 * k25 * t12 * 8.0 + k12 * k15 * k22 * k35 * t15 * 6.0 -
      k12 * k15 * k23 * k36 * t13 * 6.0 - k12 * k15 * k22 * k35 * t16 * 6.0 +
      k15 * k16 * k25 * k32 * t12 * 1.2E1 + k13 * k23 * k26 * k36 * t3 * 6.0 +
      k12 * k23 * k26 * k33 * t8 * 5.0 + k13 * k23 * k26 * k36 * t4 * 4.0 -
      k15 * k16 * k33 * k36 * t2 * 2.0 - k12 * k13 * k33 * k36 * t9 * 2.0 -
      k12 * k23 * k26 * k33 * t9 + k15 * k16 * k33 * k36 * t3 * 2.0 -
      k12 * k13 * k33 * k36 * t10 * 2.0 + k12 * k23 * k26 * k33 * t10 +
      k13 * k22 * k25 * k36 * t8 * 2.0 + k13 * k22 * k26 * k35 * t8 * 2.0 +
      k13 * k23 * k25 * k35 * t8 * 2.0 - k15 * k16 * k33 * k36 * t4 * 6.0 -
      k16 * k22 * k23 * k35 * t8 * 4.0 + k16 * k25 * k26 * k35 * t2 * 8.0 +
      k22 * k23 * k25 * k26 * t8 * 4.0 + k12 * k13 * k33 * k36 * t11 * 4.0 +
      k12 * k23 * k26 * k33 * t11 * 3.0 + k13 * k22 * k25 * k36 * t9 * 6.0 +
      k13 * k22 * k26 * k35 * t9 * 6.0 + k13 * k23 * k25 * k35 * t9 * 6.0 +
      k16 * k22 * k23 * k35 * t9 * 4.0 - k12 * k13 * k33 * k36 * t12 * 2.0 -
      k12 * k22 * k25 * k33 * t14 - k12 * k22 * k26 * k32 * t14 -
      k12 * k23 * k25 * k32 * t14 + k12 * k23 * k26 * k33 * t12 * 3.0 +
      k13 * k22 * k25 * k36 * t10 * 6.0 + k13 * k22 * k26 * k35 * t10 * 6.0 +
      k13 * k23 * k25 * k35 * t10 * 2.0 - k15 * k22 * k23 * k32 * t14 * 6.0 +
      k15 * k25 * k26 * k32 * t8 * 4.0 - k16 * k22 * k23 * k35 * t10 * 8.0 +
      k12 * k13 * k32 * k35 * t15 * 4.0 + k12 * k22 * k25 * k33 * t15 * 3.0 +
      k12 * k22 * k26 * k32 * t15 + k12 * k23 * k25 * k32 * t15 * 3.0 -
      k12 * k23 * k26 * k33 * t13 * 5.0 - k15 * k16 * k32 * k35 * t9 * 2.0 -
      k15 * k22 * k23 * k32 * t15 * 2.0 - k12 * k22 * k25 * k33 * t16 * 5.0 -
      k12 * k22 * k26 * k32 * t16 * 5.0 - k12 * k23 * k25 * k32 * t16 * 5.0 +
      k13 * k22 * k25 * k36 * t12 * 4.0 + k13 * k22 * k26 * k35 * t12 * 4.0 +
      k13 * k23 * k25 * k35 * t12 * 4.0 + k15 * k16 * k32 * k35 * t10 * 2.0 +
      k15 * k22 * k23 * k32 * t16 * 2.0 - k15 * k25 * k26 * k32 * t10 * 2.0 -
      k16 * k22 * k23 * k35 * t12 * 8.0 + k22 * k23 * k25 * k26 * t12 * 4.0 -
      k15 * k16 * k32 * k35 * t12 * 6.0 - k15 * k25 * k26 * k32 * t12 * 1.2E1 -
      k12 * k23 * k33 * k36 * t8 + k12 * k23 * k33 * k36 * t9 * 5.0 +
      k15 * k26 * k33 * k36 * t3 * 4.0 + k12 * k23 * k33 * k36 * t10 * 3.0 -
      k13 * k22 * k32 * k33 * t14 * 6.0 + k15 * k26 * k33 * k36 * t4 * 6.0 +
      k16 * k25 * k32 * k33 * t8 * 4.0 + k16 * k25 * k35 * k36 * t2 * 8.0 -
      k22 * k23 * k25 * k36 * t8 * 8.0 - k22 * k23 * k26 * k35 * t8 * 8.0 -
      k12 * k23 * k33 * k36 * t11 * 5.0 + k13 * k22 * k32 * k33 * t15 * 2.0 +
      k13 * k22 * k35 * k36 * t9 * 4.0 - k16 * k25 * k32 * k33 * t9 * 4.0 -
      k22 * k23 * k25 * k36 * t9 * 8.0 - k22 * k23 * k26 * k35 * t9 * 8.0 -
      k12 * k22 * k32 * k36 * t14 - k12 * k22 * k33 * k35 * t14 -
      k12 * k23 * k32 * k35 * t14 + k12 * k23 * k33 * k36 * t12 -
      k13 * k22 * k32 * k33 * t16 * 2.0 - k13 * k22 * k35 * k36 * t10 * 1.2E1 +
      k15 * k25 * k32 * k36 * t8 * 6.0 + k15 * k25 * k33 * k35 * t8 * 6.0 +
      k15 * k26 * k32 * k35 * t8 * 6.0 - k16 * k25 * k32 * k33 * t10 * 8.0 -
      k12 * k22 * k32 * k36 * t15 * 5.0 - k12 * k22 * k33 * k35 * t15 * 5.0 -
      k12 * k23 * k32 * k35 * t15 * 5.0 + k12 * k23 * k33 * k36 * t13 * 3.0 +
      k15 * k25 * k32 * k36 * t9 * 2.0 + k15 * k25 * k33 * k35 * t9 * 2.0 +
      k15 * k26 * k32 * k35 * t9 * 2.0 + k12 * k22 * k32 * k36 * t16 +
      k12 * k22 * k33 * k35 * t16 * 3.0 + k12 * k23 * k32 * k35 * t16 * 3.0 -
      k13 * k22 * k35 * k36 * t12 * 2.0 + k15 * k25 * k32 * k36 * t10 * 4.0 +
      k15 * k25 * k33 * k35 * t10 * 4.0 + k15 * k26 * k32 * k35 * t10 * 4.0 -
      k16 * k25 * k32 * k33 * t12 * 8.0 + k15 * k25 * k32 * k36 * t12 * 6.0 +
      k15 * k25 * k33 * k35 * t12 * 2.0 + k15 * k26 * k32 * k35 * t12 * 6.0 +
      k22 * k23 * k32 * k33 * t14 * 1.2E1 + k22 * k23 * k35 * k36 * t8 * 4.0 -
      k25 * k26 * k32 * k33 * t8 * 8.0 - k25 * k26 * k35 * k36 * t2 * 1.6E1 +
      k16 * k32 * k33 * k35 * t9 * 8.0 + k22 * k23 * k32 * k33 * t15 * 4.0 -
      k22 * k23 * k35 * k36 * t9 * 8.0 + k25 * k26 * k32 * k33 * t9 * 4.0 -
      k16 * k32 * k33 * k35 * t10 * 8.0 + k22 * k23 * k32 * k33 * t16 * 4.0 +
      k22 * k23 * k35 * k36 * t10 * 8.0 + k25 * k26 * k32 * k33 * t10 * 4.0 -
      k15 * k32 * k35 * k36 * t9 * 4.0 + k25 * k26 * k35 * k36 * t5 * 4.0 +
      k15 * k32 * k35 * k36 * t10 * 2.0 + k22 * k23 * k35 * k36 * t12 * 4.0 +
      k25 * k26 * k32 * k33 * t12 * 8.0 - k25 * k32 * k33 * k36 * t8 * 8.0 -
      k26 * k32 * k33 * k35 * t8 * 8.0 - k25 * k32 * k33 * k36 * t9 * 8.0 -
      k26 * k32 * k33 * k35 * t9 * 8.0 + k32 * k33 * k35 * k36 * t9 * 4.0 +
      k32 * k33 * k35 * k36 * t10 * 4.0 + k12 * k13 * k15 * t10 * t12 * 2.0 -
      k13 * k16 * k23 * t4 * t9 - k13 * k16 * k23 * t2 * t12 -
      k13 * k16 * k23 * t4 * t10 * 2.0 - k13 * k16 * k23 * t3 * t12 * 6.0 -
      k12 * k15 * k23 * t2 * t16 * 2.0 - k12 * k15 * k23 * t4 * t14 -
      k13 * k16 * k23 * t4 * t12 * 6.0 - k12 * k15 * k23 * t4 * t15 -
      k12 * k15 * k23 * t4 * t16 - k12 * k15 * k23 * t8 * t12 -
      k12 * k15 * k23 * t9 * t13 * 2.0 - k12 * k15 * k23 * t10 * t12 -
      k12 * k15 * k23 * t11 * t12 - k13 * k23 * k26 * t4 * t8 -
      k12 * k13 * k33 * t2 * t15 * 2.0 - k12 * k13 * k33 * t3 * t14 -
      k12 * k15 * k23 * t12 * t13 - k13 * k23 * k26 * t4 * t9 -
      k15 * k16 * k33 * t3 * t8 - k12 * k13 * k33 * t3 * t15 -
      k13 * k23 * k26 * t2 * t12 * 4.0 - k13 * k23 * k26 * t4 * t10 -
      k15 * k16 * k33 * t2 * t10 - k12 * k13 * k33 * t3 * t16 -
      k12 * k13 * k33 * t8 * t11 * 2.0 - k12 * k13 * k33 * t9 * t10 +
      k13 * k23 * k26 * t2 * t13 * 2.0 - k13 * k23 * k26 * t3 * t12 * 3.0 -
      k15 * k16 * k33 * t3 * t10 * 6.0 + k13 * k22 * k25 * t2 * t16 * 2.0 -
      k13 * k23 * k26 * t4 * t12 * 6.0 - k15 * k16 * k33 * t4 * t10 * 6.0 -
      k12 * k13 * k33 * t10 * t11 - k15 * k16 * k33 * t3 * t12 * 2.0 -
      k12 * k13 * k33 * t10 * t12 - k13 * k22 * k25 * t8 * t12 -
      k12 * k13 * k33 * t10 * t13 - k13 * k22 * k25 * t9 * t12 -
      k13 * k22 * k25 * t10 * t12 * 3.0 - k13 * k23 * k36 * t3 * t9 * 6.0 +
      k12 * k23 * k33 * t2 * t15 + k12 * k23 * k33 * t3 * t14 * 3.0 -
      k13 * k23 * k36 * t2 * t11 * 2.0 - k13 * k23 * k36 * t4 * t9 * 2.0 -
      k15 * k26 * k33 * t3 * t8 * 2.0 + k12 * k23 * k33 * t2 * t16 +
      k12 * k23 * k33 * t4 * t14 * 3.0 - k13 * k23 * k36 * t2 * t12 * 2.0 -
      k15 * k26 * k33 * t2 * t10 * 2.0 - k15 * k26 * k33 * t4 * t8 * 6.0 +
      k12 * k23 * k33 * t3 * t16 * 3.0 + k12 * k23 * k33 * t4 * t15 * 3.0 +
      k12 * k23 * k33 * t8 * t11 * 3.0 + k12 * k23 * k33 * t9 * t10 -
      k13 * k22 * k35 * t2 * t15 * 2.0 + k12 * k23 * k33 * t8 * t12 +
      k12 * k22 * k32 * t8 * t15 * 3.0 - k13 * k22 * k35 * t9 * t10 * 6.0 -
      k15 * k26 * k33 * t2 * t13 * 2.0 + k12 * k22 * k32 * t10 * t14 * 3.0 +
      k12 * k23 * k33 * t9 * t13 * 3.0 - k15 * k25 * k32 * t2 * t16 * 2.0 -
      k15 * k25 * k32 * t8 * t10 * 2.0 + k22 * k23 * k25 * t8 * t12 * 4.0 +
      k12 * k22 * k32 * t9 * t16 * 3.0 + k12 * k23 * k33 * t10 * t13 +
      k12 * k23 * k33 * t11 * t12 - k13 * k22 * k35 * t9 * t12 * 2.0 +
      k12 * k22 * k32 * t10 * t16 * 3.0 + k12 * k22 * k32 * t12 * t14 * 3.0 -
      k15 * k25 * k32 * t8 * t12 * 6.0 + k12 * k22 * k32 * t12 * t15 * 3.0 -
      k15 * k33 * k36 * t3 * t8 - k15 * k33 * k36 * t2 * t10 * 4.0 -
      k15 * k33 * k36 * t3 * t9 + k22 * k23 * k35 * t2 * t14 * 2.0 +
      k25 * k26 * k35 * t2 * t8 * 4.0 + k15 * k33 * k36 * t2 * t11 * 2.0 -
      k15 * k33 * k36 * t3 * t10 * 6.0 + k22 * k23 * k35 * t2 * t15 * 2.0 +
      k22 * k23 * k35 * t8 * t9 * 2.0 - k15 * k33 * k36 * t4 * t10 * 3.0 +
      k22 * k23 * k35 * t2 * t16 * 6.0 + k25 * k26 * k35 * t2 * t10 * 2.0 +
      k15 * k32 * k35 * t2 * t15 * 2.0 - k15 * k33 * k36 * t3 * t12 +
      k22 * k23 * k35 * t9 * t10 * 4.0 - k15 * k32 * k35 * t8 * t10 -
      k15 * k32 * k35 * t9 * t10 + k22 * k23 * k35 * t9 * t12 * 4.0 -
      k15 * k32 * k35 * t10 * t12 * 3.0 + k25 * k32 * k33 * t2 * t14 * 2.0 +
      k25 * k32 * k33 * t2 * t15 * 6.0 + k25 * k32 * k33 * t8 * t9 * 2.0 +
      k25 * k35 * k36 * t2 * t9 * 4.0 + k25 * k32 * k33 * t2 * t16 * 2.0 +
      k25 * k32 * k33 * t8 * t10 * 4.0 + k25 * k32 * k33 * t8 * t12 * 4.0 +
      k25 * k35 * k36 * t2 * t12 * 2.0 + k32 * k33 * k35 * t9 * t10 * 4.0 -
      k13 * k23 * t2 * t4 * t15 + k16 * k26 * t2 * t4 * t10 +
      k16 * k26 * t2 * t3 * t12 - k13 * k23 * t2 * t11 * t12 +
      k16 * k36 * t2 * t4 * t10 - k15 * k33 * t2 * t3 * t16 +
      k16 * k36 * t2 * t3 * t12 - k15 * k33 * t2 * t10 * t13 +
      k26 * k36 * t2 * t4 * t10 + k26 * k36 * t2 * t3 * t12 +
      k25 * k35 * t2 * t10 * t12 + k12 * k13 * k15 * k16 * k25 * k35 * 8.0;
  coeffs(6) += k12 * k13 * k16 * k25 * k26 * k32 * 8.0 -
               k13 * k15 * k16 * k22 * k25 * k33 * 2.0 -
               k13 * k15 * k16 * k22 * k26 * k32 * 2.0 -
               k13 * k15 * k16 * k23 * k25 * k32 * 2.0 -
               k12 * k13 * k15 * k25 * k26 * k35 * 1.6E1 -
               k12 * k15 * k16 * k22 * k25 * k36 * 4.0 -
               k12 * k15 * k16 * k22 * k26 * k35 * 4.0 -
               k12 * k15 * k16 * k23 * k25 * k35 * 4.0 -
               k12 * k13 * k16 * k25 * k32 * k36 * 4.0 -
               k12 * k13 * k16 * k25 * k33 * k35 * 4.0 -
               k12 * k13 * k16 * k26 * k32 * k35 * 4.0 -
               k12 * k16 * k22 * k25 * k26 * k33 * 2.0 -
               k12 * k16 * k23 * k25 * k26 * k32 * 2.0 -
               k13 * k15 * k16 * k22 * k32 * k36 * 2.0 -
               k13 * k15 * k16 * k22 * k33 * k35 * 2.0 -
               k13 * k15 * k16 * k23 * k32 * k35 * 2.0 -
               k13 * k15 * k22 * k25 * k26 * k33 * 2.0 -
               k13 * k15 * k23 * k25 * k26 * k32 * 2.0 +
               k15 * k16 * k22 * k23 * k25 * k33 * 8.0 +
               k15 * k16 * k22 * k23 * k26 * k32 * 8.0 -
               k12 * k13 * k15 * k25 * k35 * k36 * 1.6E1 +
               k12 * k15 * k16 * k22 * k35 * k36 * 8.0 +
               k12 * k15 * k22 * k25 * k26 * k36 * 1.2E1 +
               k12 * k15 * k23 * k25 * k26 * k35 * 1.2E1 +
               k13 * k16 * k22 * k26 * k32 * k33 * 4.0 +
               k13 * k16 * k23 * k25 * k32 * k33 * 4.0 +
               k12 * k13 * k25 * k26 * k32 * k36 * 8.0 +
               k12 * k13 * k25 * k26 * k33 * k35 * 8.0 +
               k12 * k16 * k22 * k25 * k33 * k36 * 6.0 +
               k12 * k16 * k22 * k26 * k32 * k36 * 6.0 +
               k12 * k16 * k22 * k26 * k33 * k35 * 6.0 +
               k12 * k16 * k23 * k25 * k32 * k36 * 6.0 +
               k12 * k16 * k23 * k25 * k33 * k35 * 6.0 +
               k12 * k16 * k23 * k26 * k32 * k35 * 6.0 -
               k13 * k15 * k22 * k25 * k33 * k36 * 1.0E1 -
               k13 * k15 * k22 * k26 * k32 * k36 * 1.0E1 -
               k13 * k15 * k22 * k26 * k33 * k35 * 1.0E1 -
               k13 * k15 * k23 * k25 * k32 * k36 * 1.0E1 -
               k13 * k15 * k23 * k25 * k33 * k35 * 1.0E1 -
               k13 * k15 * k23 * k26 * k32 * k35 * 1.0E1 +
               k15 * k16 * k22 * k23 * k32 * k36 * 4.0 +
               k15 * k16 * k22 * k23 * k33 * k35 * 4.0 -
               k15 * k22 * k23 * k25 * k26 * k33 * 4.0 +
               k12 * k15 * k22 * k26 * k35 * k36 * 8.0 +
               k12 * k15 * k23 * k25 * k35 * k36 * 8.0 +
               k13 * k16 * k22 * k32 * k33 * k36 * 8.0 +
               k13 * k16 * k23 * k32 * k33 * k35 * 8.0 +
               k13 * k23 * k25 * k26 * k32 * k33 * 4.0 -
               k16 * k22 * k23 * k26 * k32 * k33 * 1.6E1 +
               k12 * k13 * k25 * k33 * k35 * k36 * 1.2E1 +
               k12 * k13 * k26 * k32 * k35 * k36 * 1.2E1 -
               k12 * k16 * k22 * k33 * k35 * k36 * 2.0 -
               k12 * k16 * k23 * k32 * k35 * k36 * 2.0 -
               k12 * k22 * k25 * k26 * k33 * k36 * 1.0E1 -
               k12 * k23 * k25 * k26 * k32 * k36 * 1.0E1 -
               k12 * k23 * k25 * k26 * k33 * k35 * 1.0E1 -
               k13 * k15 * k22 * k33 * k35 * k36 * 2.0 -
               k13 * k15 * k23 * k32 * k35 * k36 * 2.0 +
               k15 * k22 * k23 * k25 * k33 * k36 * 8.0 +
               k15 * k22 * k23 * k26 * k32 * k36 * 8.0 +
               k15 * k22 * k23 * k26 * k33 * k35 * 8.0 +
               k13 * k22 * k26 * k32 * k33 * k36 * 8.0 +
               k13 * k23 * k25 * k32 * k33 * k36 * 8.0 +
               k13 * k23 * k26 * k32 * k33 * k35 * 8.0 -
               k16 * k22 * k23 * k32 * k33 * k36 * 1.6E1 -
               k12 * k22 * k26 * k33 * k35 * k36 * 1.0E1 -
               k12 * k23 * k25 * k33 * k35 * k36 * 1.0E1 -
               k12 * k23 * k26 * k32 * k35 * k36 * 1.0E1 +
               k15 * k22 * k23 * k33 * k35 * k36 * 4.0 -
               k13 * k23 * k32 * k33 * k35 * k36 * 4.0 +
               k12 * k15 * k16 * k23 * k26 * t4 * 2.0 +
               k12 * k15 * k16 * k22 * k25 * t12 * 2.0 -
               k12 * k13 * k16 * k26 * k33 * t3 * 4.0 +
               k13 * k15 * k16 * k23 * k33 * t3 * 6.0 +
               k13 * k15 * k16 * k23 * k33 * t4 * 6.0 +
               k12 * k13 * k15 * k26 * k36 * t3 * 4.0 +
               k12 * k13 * k15 * k26 * k36 * t4 * 4.0 -
               k12 * k15 * k16 * k23 * k36 * t4 * 4.0 -
               k12 * k13 * k16 * k25 * k32 * t10 * 4.0 +
               k13 * k15 * k16 * k22 * k32 * t10 * 6.0 +
               k12 * k13 * k15 * k25 * k35 * t10 * 4.0 +
               k13 * k15 * k16 * k22 * k32 * t12 * 6.0 +
               k12 * k13 * k15 * k25 * k35 * t12 * 4.0 -
               k12 * k15 * k16 * k22 * k35 * t12 * 4.0 -
               k12 * k15 * k22 * k25 * k26 * t12 * 2.0 +
               k12 * k16 * k23 * k26 * k33 * t2 +
               k13 * k15 * k23 * k26 * k33 * t2 * 3.0 +
               k12 * k13 * k16 * k33 * k36 * t3 * 2.0 +
               k12 * k16 * k23 * k26 * k33 * t3 * 3.0 +
               k13 * k15 * k23 * k26 * k33 * t3 * 3.0 -
               k12 * k15 * k23 * k26 * k36 * t2 * 4.0 -
               k12 * k16 * k23 * k26 * k33 * t4 * 6.0 +
               k13 * k15 * k23 * k26 * k33 * t4 * 6.0 -
               k13 * k16 * k22 * k25 * k36 * t2 * 2.0 -
               k13 * k16 * k22 * k26 * k35 * t2 * 2.0 -
               k13 * k16 * k23 * k25 * k35 * t2 * 2.0 -
               k12 * k15 * k23 * k26 * k36 * t3 * 6.0 -
               k12 * k13 * k22 * k23 * k32 * t14 * 2.0 -
               k12 * k13 * k25 * k26 * k32 * t8 * 4.0 +
               k12 * k16 * k22 * k25 * k33 * t8 * 3.0 +
               k12 * k16 * k22 * k26 * k32 * t8 * 3.0 +
               k12 * k16 * k23 * k25 * k32 * t8 * 3.0 +
               k13 * k15 * k22 * k25 * k33 * t8 +
               k13 * k15 * k22 * k26 * k32 * t8 +
               k13 * k15 * k23 * k25 * k32 * t8 -
               k15 * k16 * k22 * k23 * k32 * t8 * 2.0 -
               k12 * k13 * k22 * k23 * k32 * t15 * 2.0 +
               k12 * k13 * k16 * k32 * k35 * t10 * 2.0 -
               k12 * k13 * k22 * k23 * k32 * t16 * 2.0 -
               k12 * k13 * k25 * k26 * k32 * t10 * 2.0 -
               k12 * k15 * k22 * k25 * k36 * t8 * 2.0 -
               k12 * k15 * k22 * k26 * k35 * t8 * 2.0 -
               k12 * k15 * k23 * k25 * k35 * t8 * 2.0 +
               k12 * k16 * k22 * k25 * k33 * t10 * 3.0 +
               k12 * k16 * k22 * k26 * k32 * t10 * 3.0 +
               k12 * k16 * k23 * k25 * k32 * t10 +
               k13 * k15 * k22 * k25 * k33 * t10 * 3.0 +
               k13 * k15 * k22 * k26 * k32 * t10 * 3.0 +
               k13 * k15 * k23 * k25 * k32 * t10 -
               k15 * k16 * k22 * k23 * k32 * t10 * 4.0 -
               k12 * k15 * k22 * k25 * k36 * t10 * 6.0 -
               k12 * k15 * k22 * k26 * k35 * t10 * 6.0 -
               k12 * k15 * k23 * k25 * k35 * t10 * 2.0 -
               k12 * k16 * k22 * k25 * k33 * t12 * 2.0 -
               k12 * k16 * k22 * k26 * k32 * t12 * 6.0 -
               k12 * k16 * k23 * k25 * k32 * t12 * 6.0 +
               k13 * k15 * k22 * k25 * k33 * t12 * 2.0 +
               k13 * k15 * k22 * k26 * k32 * t12 * 6.0 +
               k13 * k15 * k23 * k25 * k32 * t12 * 6.0 -
               k15 * k16 * k22 * k23 * k32 * t12 * 1.2E1 -
               k12 * k13 * k26 * k33 * k36 * t2 * 4.0 +
               k12 * k16 * k23 * k33 * k36 * t2 +
               k13 * k15 * k23 * k33 * k36 * t2 * 3.0 -
               k12 * k16 * k23 * k33 * k36 * t3 * 6.0 +
               k13 * k15 * k23 * k33 * k36 * t3 * 6.0 -
               k12 * k13 * k26 * k33 * k36 * t4 * 6.0 +
               k12 * k16 * k23 * k33 * k36 * t4 * 3.0 +
               k13 * k15 * k23 * k33 * k36 * t4 * 3.0 -
               k13 * k22 * k25 * k26 * k36 * t2 * 4.0 -
               k13 * k23 * k25 * k26 * k35 * t2 * 4.0 -
               k13 * k16 * k22 * k32 * k33 * t9 * 2.0 +
               k12 * k22 * k25 * k26 * k33 * t8 * 6.0 +
               k12 * k23 * k25 * k26 * k32 * t8 * 6.0 -
               k13 * k16 * k22 * k32 * k33 * t10 * 1.2E1 -
               k15 * k16 * k25 * k32 * k36 * t2 * 2.0 -
               k15 * k16 * k25 * k33 * k35 * t2 * 2.0 -
               k15 * k16 * k26 * k32 * k35 * t2 * 2.0 -
               k15 * k22 * k23 * k25 * k33 * t8 * 4.0 -
               k15 * k22 * k23 * k26 * k32 * t8 * 4.0 -
               k12 * k13 * k25 * k32 * k36 * t9 * 2.0 -
               k12 * k13 * k25 * k33 * k35 * t9 * 2.0 -
               k12 * k13 * k26 * k32 * k35 * t9 * 2.0;
  coeffs(6) +=
      k12 * k16 * k22 * k32 * k36 * t9 * 3.0 +
      k12 * k16 * k22 * k33 * k35 * t9 * 3.0 +
      k12 * k16 * k23 * k32 * k35 * t9 * 3.0 +
      k13 * k15 * k22 * k32 * k36 * t9 + k13 * k15 * k22 * k33 * k35 * t9 +
      k13 * k15 * k23 * k32 * k35 * t9 -
      k12 * k15 * k22 * k32 * k33 * t14 * 2.0 -
      k12 * k16 * k22 * k32 * k36 * t10 * 6.0 -
      k12 * k16 * k22 * k33 * k35 * t10 * 6.0 -
      k12 * k16 * k23 * k32 * k35 * t10 * 2.0 +
      k13 * k15 * k22 * k32 * k36 * t10 * 6.0 +
      k13 * k15 * k22 * k33 * k35 * t10 * 6.0 +
      k13 * k15 * k23 * k32 * k35 * t10 * 2.0 -
      k13 * k16 * k22 * k32 * k33 * t12 * 4.0 -
      k12 * k15 * k22 * k32 * k33 * t15 * 2.0 -
      k12 * k15 * k22 * k35 * k36 * t9 * 4.0 -
      k12 * k13 * k25 * k32 * k36 * t12 * 6.0 -
      k12 * k13 * k25 * k33 * k35 * t12 * 2.0 -
      k12 * k13 * k26 * k32 * k35 * t12 * 6.0 -
      k12 * k15 * k22 * k32 * k33 * t16 * 2.0 +
      k12 * k16 * k22 * k32 * k36 * t12 * 3.0 +
      k12 * k16 * k22 * k33 * k35 * t12 +
      k12 * k16 * k23 * k32 * k35 * t12 * 3.0 +
      k12 * k22 * k25 * k26 * k33 * t12 * 2.0 +
      k12 * k23 * k25 * k26 * k32 * t12 * 6.0 +
      k13 * k15 * k22 * k32 * k36 * t12 * 3.0 +
      k13 * k15 * k22 * k33 * k35 * t12 +
      k13 * k15 * k23 * k32 * k35 * t12 * 3.0 -
      k12 * k15 * k22 * k35 * k36 * t12 * 2.0 +
      k12 * k23 * k26 * k33 * k36 * t2 * 4.0 +
      k12 * k23 * k26 * k33 * k36 * t3 * 3.0 +
      k12 * k23 * k26 * k33 * k36 * t4 * 3.0 -
      k13 * k22 * k26 * k32 * k33 * t8 * 2.0 +
      k13 * k22 * k26 * k35 * k36 * t2 * 4.0 -
      k13 * k23 * k25 * k32 * k33 * t8 * 2.0 +
      k13 * k23 * k25 * k35 * k36 * t2 * 4.0 +
      k16 * k22 * k23 * k32 * k33 * t8 * 4.0 -
      k16 * k22 * k23 * k35 * k36 * t2 * 8.0 -
      k16 * k25 * k26 * k32 * k33 * t2 * 8.0 +
      k22 * k23 * k25 * k26 * k36 * t2 * 4.0 -
      k13 * k22 * k26 * k32 * k33 * t9 * 2.0 -
      k13 * k23 * k25 * k32 * k33 * t9 * 2.0 +
      k16 * k22 * k23 * k32 * k33 * t9 * 4.0 -
      k12 * k22 * k25 * k33 * k36 * t8 - k12 * k22 * k26 * k32 * k36 * t8 -
      k12 * k22 * k26 * k33 * k35 * t8 - k12 * k23 * k25 * k32 * k36 * t8 -
      k12 * k23 * k25 * k33 * k35 * t8 - k12 * k23 * k26 * k32 * k35 * t8 -
      k13 * k22 * k26 * k32 * k33 * t10 * 6.0 -
      k13 * k23 * k25 * k32 * k33 * t10 * 2.0 -
      k15 * k22 * k23 * k32 * k36 * t8 * 2.0 -
      k15 * k22 * k23 * k33 * k35 * t8 * 2.0 +
      k15 * k25 * k26 * k32 * k36 * t2 * 4.0 +
      k15 * k25 * k26 * k33 * k35 * t2 * 4.0 +
      k16 * k22 * k23 * k32 * k33 * t10 * 8.0 -
      k12 * k22 * k25 * k33 * k36 * t9 - k12 * k22 * k26 * k32 * k36 * t9 -
      k12 * k22 * k26 * k33 * k35 * t9 - k12 * k23 * k25 * k32 * k36 * t9 -
      k12 * k23 * k25 * k33 * k35 * t9 - k12 * k23 * k26 * k32 * k35 * t9 -
      k15 * k22 * k23 * k32 * k36 * t9 * 2.0 -
      k15 * k22 * k23 * k33 * k35 * t9 * 2.0 -
      k12 * k13 * k32 * k35 * k36 * t10 * 2.0 +
      k12 * k22 * k25 * k33 * k36 * t10 * 3.0 +
      k12 * k22 * k26 * k32 * k36 * t10 * 3.0 +
      k12 * k22 * k26 * k33 * k35 * t10 * 3.0 +
      k12 * k23 * k25 * k32 * k36 * t10 + k12 * k23 * k25 * k33 * k35 * t10 +
      k12 * k23 * k26 * k32 * k35 * t10 -
      k13 * k22 * k26 * k32 * k33 * t12 * 4.0 -
      k13 * k23 * k25 * k32 * k33 * t12 * 4.0 -
      k15 * k22 * k23 * k32 * k36 * t10 * 4.0 -
      k15 * k22 * k23 * k33 * k35 * t10 * 4.0 +
      k16 * k22 * k23 * k32 * k33 * t12 * 8.0 +
      k12 * k22 * k25 * k33 * k36 * t12 +
      k12 * k22 * k26 * k32 * k36 * t12 * 3.0 +
      k12 * k22 * k26 * k33 * k35 * t12 +
      k12 * k23 * k25 * k32 * k36 * t12 * 3.0 +
      k12 * k23 * k25 * k33 * k35 * t12 +
      k12 * k23 * k26 * k32 * k35 * t12 * 3.0 -
      k15 * k22 * k23 * k32 * k36 * t12 * 6.0 -
      k15 * k22 * k23 * k33 * k35 * t12 * 2.0 +
      k22 * k23 * k26 * k32 * k33 * t8 * 8.0 -
      k13 * k22 * k32 * k33 * k36 * t9 * 4.0 -
      k13 * k23 * k32 * k33 * k35 * t9 * 4.0 -
      k15 * k25 * k33 * k35 * k36 * t2 * 4.0 -
      k15 * k26 * k32 * k35 * k36 * t2 * 4.0 +
      k12 * k22 * k33 * k35 * k36 * t9 * 6.0 +
      k12 * k23 * k32 * k35 * k36 * t9 * 6.0 +
      k12 * k22 * k33 * k35 * k36 * t10 * 6.0 +
      k12 * k23 * k32 * k35 * k36 * t10 * 2.0 +
      k22 * k23 * k32 * k33 * k36 * t9 * 8.0 +
      k26 * k32 * k33 * k35 * k36 * t2 * 4.0 +
      k12 * k13 * k15 * k16 * t4 * t10 + k12 * k13 * k15 * k16 * t3 * t12 +
      k12 * k13 * k15 * k26 * t4 * t10 - k12 * k15 * k16 * k23 * t4 * t10 +
      k12 * k13 * k15 * k26 * t3 * t12 -
      k12 * k15 * k16 * k23 * t3 * t12 * 3.0 - k13 * k16 * k23 * k26 * t2 * t4 -
      k12 * k13 * k16 * k33 * t4 * t10 * 3.0 - k12 * k15 * k23 * k26 * t4 * t8 -
      k12 * k13 * k16 * k33 * t3 * t12 + k12 * k13 * k15 * k36 * t4 * t10 -
      k13 * k16 * k22 * k25 * t2 * t12 + k12 * k13 * k15 * k36 * t3 * t12 -
      k12 * k15 * k23 * k26 * t2 * t13 * 2.0 -
      k12 * k15 * k22 * k25 * t2 * t16 * 2.0 -
      k12 * k15 * k22 * k25 * t8 * t12 -
      k12 * k13 * k26 * k33 * t4 * t10 * 3.0 +
      k12 * k16 * k23 * k33 * t4 * t10 * 3.0 -
      k12 * k13 * k26 * k33 * t3 * t12 +
      k12 * k16 * k23 * k33 * t3 * t12 * 3.0 -
      k12 * k15 * k23 * k36 * t4 * t10 -
      k13 * k22 * k25 * k26 * t2 * t12 * 2.0 +
      k16 * k22 * k23 * k25 * t2 * t12 * 2.0 -
      k12 * k15 * k23 * k36 * t3 * t12 * 3.0 -
      k12 * k13 * k25 * k32 * t10 * t12 * 3.0 +
      k12 * k16 * k22 * k32 * t10 * t12 * 9.0 -
      k13 * k23 * k26 * k36 * t2 * t4 * 2.0 - k15 * k16 * k33 * k36 * t2 * t3 -
      k12 * k13 * k33 * k36 * t3 * t9 -
      k12 * k15 * k22 * k35 * t10 * t12 * 3.0 +
      k12 * k23 * k26 * k33 * t4 * t8 * 3.0 -
      k12 * k13 * k33 * k36 * t2 * t11 * 2.0 -
      k12 * k13 * k32 * k35 * t2 * t15 * 2.0 +
      k12 * k23 * k26 * k33 * t2 * t13 + k12 * k22 * k25 * k33 * t2 * t16 +
      k12 * k22 * k26 * k32 * t2 * t16 + k12 * k23 * k25 * k32 * t2 * t16 -
      k13 * k22 * k25 * k36 * t2 * t12 * 2.0 -
      k13 * k22 * k26 * k35 * t2 * t12 * 2.0 -
      k13 * k23 * k25 * k35 * t2 * t12 * 2.0 -
      k15 * k16 * k32 * k35 * t2 * t10 -
      k15 * k22 * k23 * k32 * t2 * t16 * 2.0 +
      k16 * k22 * k23 * k35 * t2 * t12 * 2.0 -
      k12 * k13 * k32 * k35 * t9 * t10 + k12 * k22 * k25 * k33 * t8 * t12 +
      k12 * k22 * k26 * k32 * t8 * t12 * 3.0 +
      k12 * k23 * k25 * k32 * t8 * t12 * 3.0 -
      k15 * k26 * k33 * k36 * t2 * t3 * 2.0 +
      k12 * k23 * k33 * k36 * t3 * t9 * 3.0 + k12 * k23 * k33 * k36 * t2 * t11 -
      k13 * k22 * k32 * k33 * t2 * t15 * 2.0 +
      k16 * k25 * k32 * k33 * t2 * t10 * 2.0 +
      k12 * k22 * k32 * k36 * t2 * t15 + k12 * k22 * k33 * k35 * t2 * t15 +
      k12 * k23 * k32 * k35 * t2 * t15 -
      k15 * k25 * k32 * k36 * t2 * t10 * 2.0 -
      k15 * k25 * k33 * k35 * t2 * t10 * 2.0 -
      k15 * k26 * k32 * k35 * t2 * t10 * 2.0 +
      k22 * k23 * k25 * k36 * t2 * t12 * 2.0 +
      k22 * k23 * k26 * k35 * t2 * t12 * 2.0 +
      k12 * k22 * k32 * k36 * t9 * t10 * 3.0 +
      k12 * k22 * k33 * k35 * t9 * t10 * 3.0 +
      k12 * k23 * k32 * k35 * t9 * t10 + k25 * k26 * k32 * k33 * t2 * t8 * 4.0 +
      k22 * k23 * k35 * k36 * t2 * t9 * 4.0 +
      k16 * k32 * k33 * k35 * t2 * t10 * 2.0 -
      k15 * k32 * k35 * k36 * t2 * t10 * 2.0 +
      k25 * k32 * k33 * k36 * t2 * t10 * 2.0 +
      k26 * k32 * k33 * k35 * t2 * t10 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k25 * k33 * 8.0 -
      k12 * k13 * k16 * k22 * k23 * k26 * k32 * 8.0 +
      k12 * k13 * k15 * k22 * k23 * k25 * k36 * 8.0 +
      k12 * k13 * k15 * k22 * k23 * k26 * k35 * 8.0 +
      k12 * k13 * k16 * k22 * k23 * k32 * k36 * 4.0 +
      k12 * k13 * k16 * k22 * k23 * k33 * k35 * 4.0 -
      k12 * k13 * k22 * k23 * k25 * k26 * k33 * 4.0 +
      k12 * k15 * k16 * k22 * k26 * k32 * k33 * 4.0 +
      k12 * k15 * k16 * k23 * k25 * k32 * k33 * 4.0 +
      k12 * k13 * k15 * k25 * k32 * k33 * k36 * 8.0 +
      k12 * k13 * k15 * k26 * k32 * k33 * k35 * 8.0 -
      k12 * k15 * k16 * k22 * k32 * k33 * k36 * 8.0 -
      k12 * k15 * k16 * k23 * k32 * k33 * k35 * 8.0 -
      k12 * k15 * k23 * k25 * k26 * k32 * k33 * 4.0 -
      k12 * k13 * k22 * k23 * k33 * k35 * k36 * 4.0 -
      k12 * k15 * k23 * k32 * k33 * k35 * k36 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k25 * t12 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k32 * t12 * 6.0 +
      k12 * k13 * k15 * k22 * k23 * k35 * t12 * 2.0 +
      k12 * k13 * k15 * k25 * k32 * k33 * t10 * 2.0 -
      k12 * k13 * k22 * k23 * k25 * k33 * t12 * 2.0 -
      k12 * k13 * k22 * k23 * k26 * k32 * t12 * 6.0 -
      k12 * k15 * k16 * k22 * k32 * k33 * t10 * 6.0 -
      k13 * k16 * k22 * k26 * k32 * k33 * t2 * 2.0 -
      k13 * k16 * k23 * k25 * k32 * k33 * t2 * 2.0 -
      k12 * k13 * k25 * k26 * k32 * k36 * t2 * 4.0 -
      k12 * k13 * k25 * k26 * k33 * k35 * t2 * 4.0 +
      k12 * k16 * k22 * k25 * k33 * k36 * t2 +
      k12 * k16 * k22 * k26 * k32 * k36 * t2 +
      k12 * k16 * k22 * k26 * k33 * k35 * t2 +
      k12 * k16 * k23 * k25 * k32 * k36 * t2 +
      k12 * k16 * k23 * k25 * k33 * k35 * t2 +
      k12 * k16 * k23 * k26 * k32 * k35 * t2 +
      k13 * k15 * k22 * k25 * k33 * k36 * t2 * 3.0 +
      k13 * k15 * k22 * k26 * k32 * k36 * t2 * 3.0 +
      k13 * k15 * k22 * k26 * k33 * k35 * t2 * 3.0 +
      k13 * k15 * k23 * k25 * k32 * k36 * t2 * 3.0 +
      k13 * k15 * k23 * k25 * k33 * k35 * t2 * 3.0 +
      k13 * k15 * k23 * k26 * k32 * k35 * t2 * 3.0 -
      k15 * k16 * k22 * k23 * k32 * k36 * t2 * 2.0 -
      k15 * k16 * k22 * k23 * k33 * k35 * t2 * 2.0 -
      k12 * k13 * k22 * k23 * k32 * k36 * t9 * 2.0 -
      k12 * k13 * k22 * k23 * k33 * k35 * t9 * 2.0 -
      k12 * k15 * k22 * k26 * k32 * k33 * t8 * 2.0 -
      k12 * k15 * k22 * k26 * k35 * k36 * t2 * 4.0 -
      k12 * k15 * k23 * k25 * k32 * k33 * t8 * 2.0 -
      k12 * k15 * k23 * k25 * k35 * k36 * t2 * 4.0 +
      k12 * k13 * k15 * k32 * k33 * k35 * t10 * 2.0 -
      k13 * k23 * k25 * k26 * k32 * k33 * t2 * 4.0 +
      k16 * k22 * k23 * k26 * k32 * k33 * t2 * 4.0 +
      k12 * k22 * k25 * k26 * k33 * k36 * t2 * 2.0 +
      k12 * k23 * k25 * k26 * k32 * k36 * t2 * 2.0 +
      k12 * k23 * k25 * k26 * k33 * k35 * t2 * 2.0 -
      k15 * k22 * k23 * k25 * k33 * k36 * t2 * 4.0 -
      k15 * k22 * k23 * k26 * k32 * k36 * t2 * 4.0 -
      k15 * k22 * k23 * k26 * k33 * k35 * t2 * 4.0 -
      k12 * k15 * k22 * k32 * k33 * k36 * t10 * 6.0 -
      k12 * k15 * k23 * k32 * k33 * k35 * t10 * 2.0 -
      k13 * k22 * k26 * k32 * k33 * k36 * t2 * 4.0 -
      k13 * k23 * k25 * k32 * k33 * k36 * t2 * 4.0 -
      k13 * k23 * k26 * k32 * k33 * k35 * t2 * 4.0 +
      k16 * k22 * k23 * k32 * k33 * k36 * t2 * 4.0 +
      k12 * k22 * k26 * k33 * k35 * k36 * t2 * 2.0 +
      k12 * k23 * k25 * k33 * k35 * k36 * t2 * 2.0 +
      k12 * k23 * k26 * k32 * k35 * k36 * t2 * 2.0 -
      k15 * k22 * k23 * k33 * k35 * k36 * t2 * 4.0 +
      k22 * k23 * k26 * k32 * k33 * k36 * t2 * 4.0 +
      k12 * k13 * k15 * k16 * k22 * k23 * k32 * k33 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k26 * k32 * k33 * 4.0 +
      k12 * k13 * k15 * k22 * k23 * k32 * k33 * k36 * 4.0;
  coeffs(7) =
      k16 * k25 * t14 * -4.0 - k16 * k25 * t15 * 1.2E1 -
      k16 * k25 * t16 * 1.2E1 - k16 * k25 * t19 * 2.0 - k16 * k35 * t14 * 4.0 +
      k25 * k26 * t14 * 1.2E1 - k16 * k35 * t15 * 1.2E1 +
      k25 * k26 * t15 * 4.0 - k16 * k35 * t16 * 1.2E1 +
      k25 * k26 * t16 * 1.2E1 + k25 * k26 * t17 * 2.0 + k25 * k26 * t19 * 2.0 -
      k16 * k35 * t20 * 2.0 + k25 * k36 * t14 * 1.2E1 +
      k26 * k35 * t14 * 1.2E1 + k25 * k36 * t15 * 1.2E1 +
      k26 * k35 * t15 * 4.0 + k25 * k36 * t16 * 4.0 + k26 * k35 * t16 * 1.2E1 +
      k35 * k36 * t14 * 1.2E1 + k35 * k36 * t15 * 1.2E1 +
      k35 * k36 * t16 * 4.0 + k35 * k36 * t18 * 2.0 + k35 * k36 * t20 * 2.0 +
      k25 * t8 * t14 * 2.0 + k25 * t8 * t15 * 6.0 + k25 * t8 * t16 * 2.0 -
      k25 * t10 * t14 * 4.0 + k25 * t9 * t16 * 4.0 - k25 * t10 * t16 * 4.0 -
      k25 * t12 * t14 * 6.0 + k25 * t8 * t19 - k25 * t12 * t15 * 6.0 -
      k25 * t12 * t16 * 2.0 + k35 * t8 * t15 * 4.0 + k35 * t9 * t14 * 2.0 +
      k35 * t9 * t15 * 2.0 - k35 * t10 * t14 * 6.0 + k35 * t9 * t16 * 6.0 -
      k35 * t10 * t15 * 2.0 - k35 * t10 * t16 * 6.0 - k35 * t12 * t14 * 4.0 -
      k35 * t12 * t15 * 4.0 + k35 * t9 * t20 - k16 * k25 * k26 * k36 * 2.4E1 -
      k16 * k26 * k35 * k36 * 2.4E1 - k13 * k16 * k22 * t14 * 2.0 +
      k13 * k16 * k22 * t15 * 2.0 - k13 * k16 * k22 * t16 * 6.0 -
      k13 * k16 * k22 * t19 + k13 * k22 * k26 * t14 * 2.0 +
      k13 * k23 * k25 * t14 * 2.0 + k16 * k22 * k23 * t14 * 4.0 -
      k16 * k25 * k26 * t8 * 8.0 - k13 * k22 * k26 * t15 * 2.0 -
      k13 * k23 * k25 * t15 * 6.0 + k16 * k22 * k23 * t15 * 4.0 +
      k13 * k22 * k26 * t16 * 2.0 + k13 * k23 * k25 * t16 * 2.0 -
      k15 * k16 * k32 * t14 * 2.0 + k16 * k22 * k23 * t16 * 1.2E1 +
      k16 * k25 * k26 * t10 * 4.0 - k15 * k16 * k32 * t15 * 6.0 +
      k15 * k16 * k32 * t16 * 2.0 + k16 * k25 * k26 * t12 * 1.2E1 -
      k13 * k22 * k26 * t19 - k13 * k23 * k25 * t19 +
      k16 * k22 * k23 * t19 * 2.0 - k15 * k16 * k32 * t20 +
      k13 * k22 * k36 * t14 * 6.0 + k13 * k23 * k35 * t14 * 6.0 -
      k16 * k25 * k36 * t8 * 4.0 - k16 * k26 * k35 * t8 * 4.0 -
      k22 * k23 * k26 * t14 * 8.0 - k13 * k22 * k36 * t15 * 2.0 -
      k13 * k23 * k35 * t15 * 2.0 - k16 * k25 * k36 * t9 * 4.0 -
      k16 * k26 * k35 * t9 * 4.0 + k13 * k22 * k36 * t16 * 2.0 +
      k13 * k23 * k35 * t16 * 6.0 + k15 * k25 * k33 * t14 * 6.0 +
      k15 * k26 * k32 * t14 * 6.0 + k16 * k25 * k36 * t10 * 8.0 +
      k16 * k26 * k35 * t10 * 8.0 - k22 * k23 * k26 * t16 * 8.0 +
      k15 * k25 * k33 * t15 * 6.0 + k15 * k26 * k32 * t15 * 2.0 -
      k15 * k25 * k33 * t16 * 2.0 - k15 * k26 * k32 * t16 * 2.0 +
      k16 * k25 * k36 * t12 * 8.0 + k16 * k26 * k35 * t12 * 8.0 +
      k16 * k32 * k33 * t14 * 4.0 - k22 * k23 * k36 * t14 * 1.2E1 +
      k25 * k26 * k36 * t8 * 8.0 + k16 * k32 * k33 * t15 * 1.2E1 -
      k16 * k35 * k36 * t9 * 8.0 - k22 * k23 * k36 * t15 * 4.0 +
      k25 * k26 * k36 * t9 * 4.0 + k15 * k32 * k36 * t14 * 2.0 +
      k15 * k33 * k35 * t14 * 2.0 + k16 * k32 * k33 * t16 * 4.0 +
      k16 * k35 * k36 * t10 * 1.2E1 - k22 * k23 * k36 * t16 * 4.0 -
      k25 * k26 * k36 * t10 * 4.0 + k15 * k32 * k36 * t15 * 2.0 +
      k15 * k33 * k35 * t15 * 2.0 - k15 * k32 * k36 * t16 * 2.0 -
      k15 * k33 * k35 * t16 * 6.0 + k16 * k35 * k36 * t12 * 4.0 -
      k25 * k26 * k36 * t12 * 8.0 + k16 * k32 * k33 * t20 * 2.0 -
      k15 * k32 * k36 * t20 - k15 * k33 * k35 * t20 -
      k26 * k32 * k33 * t14 * 1.2E1 + k26 * k35 * k36 * t8 * 4.0 -
      k26 * k32 * k33 * t15 * 4.0 + k26 * k35 * k36 * t9 * 8.0 -
      k26 * k32 * k33 * t16 * 4.0 - k26 * k35 * k36 * t10 * 8.0 -
      k26 * k35 * k36 * t12 * 4.0 - k32 * k33 * k36 * t14 * 8.0 -
      k32 * k33 * k36 * t15 * 8.0 - k13 * k22 * t8 * t15 * 2.0 -
      k13 * k22 * t10 * t14 * 6.0 + k16 * k25 * t2 * t16 * 4.0 +
      k16 * k25 * t8 * t10 * 4.0 + k13 * k22 * t9 * t16 * 2.0 -
      k13 * k22 * t10 * t16 * 6.0 - k13 * k22 * t12 * t14 * 3.0 +
      k16 * k25 * t8 * t12 * 2.0 + k13 * k22 * t12 * t15 -
      k16 * k25 * t9 * t12 * 2.0 - k13 * k22 * t12 * t16 -
      k16 * k25 * t10 * t12 * 4.0 + k22 * k23 * t8 * t14 * 2.0 +
      k16 * k35 * t2 * t15 * 4.0 + k22 * k23 * t8 * t15 * 2.0 -
      k16 * k35 * t8 * t10 * 2.0 + k22 * k23 * t8 * t16 * 2.0 +
      k22 * k23 * t10 * t14 * 4.0 - k25 * k26 * t2 * t16 * 8.0 +
      k25 * k26 * t8 * t10 * 2.0 + k15 * k32 * t8 * t15 * 2.0 +
      k16 * k35 * t9 * t10 * 2.0 - k22 * k23 * t9 * t16 * 4.0 -
      k15 * k32 * t10 * t14 * 3.0 + k22 * k23 * t10 * t16 * 4.0 +
      k22 * k23 * t12 * t14 * 6.0 - k25 * k26 * t8 * t12 * 4.0 -
      k15 * k32 * t9 * t16 * 2.0 - k15 * k32 * t10 * t15 +
      k16 * k35 * t9 * t12 * 4.0 + k22 * k23 * t12 * t15 * 2.0 +
      k25 * k26 * t5 * t16 * 2.0 + k25 * k26 * t9 * t12 * 2.0;
  coeffs(7) +=
      k15 * k32 * t10 * t16 - k15 * k32 * t12 * t14 * 6.0 -
      k16 * k35 * t10 * t12 * 4.0 + k22 * k23 * t12 * t16 * 2.0 +
      k25 * k26 * t10 * t12 * 2.0 - k15 * k32 * t12 * t15 * 6.0 -
      k25 * k36 * t2 * t14 * 2.0 - k26 * k35 * t2 * t14 * 2.0 -
      k25 * k36 * t2 * t15 * 6.0 - k25 * k36 * t8 * t9 * 2.0 -
      k26 * k35 * t2 * t15 * 2.0 - k26 * k35 * t8 * t9 * 2.0 -
      k25 * k36 * t2 * t16 * 2.0 - k25 * k36 * t8 * t10 * 4.0 -
      k26 * k35 * t2 * t16 * 6.0 - k26 * k35 * t8 * t10 * 4.0 -
      k25 * k36 * t9 * t10 * 4.0 - k26 * k35 * t9 * t10 * 4.0 -
      k25 * k36 * t8 * t12 * 4.0 - k26 * k35 * t8 * t12 * 4.0 -
      k25 * k36 * t9 * t12 * 4.0 - k26 * k35 * t9 * t12 * 4.0 -
      k32 * k33 * t8 * t15 * 4.0 + k32 * k33 * t9 * t14 * 2.0 -
      k35 * k36 * t2 * t15 * 8.0 + k32 * k33 * t9 * t15 * 2.0 +
      k32 * k33 * t10 * t14 * 6.0 + k35 * k36 * t8 * t10 * 2.0 +
      k32 * k33 * t9 * t16 * 2.0 + k32 * k33 * t10 * t15 * 2.0 -
      k35 * k36 * t9 * t10 * 4.0 + k32 * k33 * t10 * t16 * 2.0 +
      k32 * k33 * t12 * t14 * 4.0 + k35 * k36 * t5 * t15 * 2.0 +
      k32 * k33 * t12 * t15 * 4.0 + k35 * k36 * t9 * t12 * 2.0 +
      k35 * k36 * t10 * t12 * 2.0 + k25 * t2 * t9 * t16 * 2.0 +
      k25 * t2 * t12 * t14 + k25 * t2 * t12 * t15 * 3.0 + k25 * t8 * t9 * t12 +
      k25 * t2 * t12 * t16 + k25 * t8 * t10 * t12 * 2.0 +
      k35 * t2 * t8 * t15 * 2.0 + k35 * t2 * t10 * t14 + k35 * t2 * t10 * t15 +
      k35 * t8 * t9 * t10 + k35 * t2 * t10 * t16 * 3.0 +
      k35 * t9 * t10 * t12 * 2.0 + k13 * k16 * k23 * k25 * k26 * 4.0 -
      k13 * k16 * k22 * k26 * k36 * 4.0 - k13 * k16 * k23 * k25 * k36 * 4.0 -
      k13 * k16 * k23 * k26 * k35 * 4.0 - k15 * k16 * k25 * k26 * k33 * 1.2E1 -
      k13 * k16 * k23 * k35 * k36 * 1.2E1 - k13 * k23 * k25 * k26 * k36 * 4.0 +
      k16 * k22 * k23 * k26 * k36 * 1.6E1 - k15 * k16 * k25 * k33 * k36 * 4.0 -
      k15 * k16 * k26 * k32 * k36 * 4.0 - k15 * k16 * k26 * k33 * k35 * 4.0 +
      k13 * k23 * k26 * k35 * k36 * 4.0 + k15 * k16 * k33 * k35 * k36 * 4.0 +
      k15 * k25 * k26 * k33 * k36 * 4.0 + k16 * k26 * k32 * k33 * k36 * 1.6E1 -
      k15 * k26 * k33 * k35 * k36 * 4.0 - k12 * k13 * k15 * k25 * t16 * 8.0 +
      k12 * k15 * k16 * k22 * t16 * 4.0 - k13 * k16 * k22 * k26 * t8 * 2.0 -
      k13 * k16 * k23 * k25 * t8 * 2.0 - k13 * k16 * k22 * k26 * t10 * 6.0 -
      k13 * k16 * k23 * k25 * t10 * 2.0 + k12 * k13 * k16 * k32 * t15 * 4.0 +
      k13 * k16 * k22 * k26 * t12 * 2.0 + k13 * k16 * k23 * k25 * t12 * 2.0 -
      k12 * k13 * k15 * k35 * t15 * 8.0 + k12 * k15 * k22 * k26 * t16 * 4.0 +
      k12 * k15 * k23 * k25 * t16 * 4.0 - k13 * k23 * k25 * k26 * t8 * 4.0 +
      k16 * k22 * k23 * k26 * t8 * 8.0 - k13 * k16 * k22 * k36 * t9 * 2.0 -
      k13 * k16 * k23 * k35 * t9 * 2.0 - k12 * k13 * k25 * k33 * t14 * 2.0 -
      k12 * k13 * k26 * k32 * t14 * 2.0 + k12 * k16 * k22 * k33 * t14 +
      k12 * k16 * k23 * k32 * t14 + k13 * k15 * k22 * k33 * t14 * 3.0 +
      k13 * k15 * k23 * k32 * t14 * 3.0 + k13 * k16 * k22 * k36 * t10 * 1.2E1 +
      k13 * k16 * k23 * k35 * t10 * 4.0 - k15 * k16 * k25 * k33 * t8 * 2.0 -
      k15 * k16 * k26 * k32 * t8 * 2.0 - k12 * k13 * k25 * k33 * t15 * 6.0 -
      k12 * k13 * k26 * k32 * t15 * 2.0 - k12 * k16 * k22 * k33 * t15 -
      k12 * k16 * k23 * k32 * t15 - k13 * k15 * k22 * k33 * t15 -
      k13 * k15 * k23 * k32 * t15 + k12 * k13 * k25 * k33 * t16 * 6.0 +
      k12 * k13 * k26 * k32 * t16 * 6.0 - k12 * k15 * k22 * k36 * t14 * 2.0 -
      k12 * k15 * k23 * k35 * t14 * 2.0 - k12 * k16 * k22 * k33 * t16 -
      k12 * k16 * k23 * k32 * t16 - k13 * k15 * k22 * k33 * t16 -
      k13 * k15 * k23 * k32 * t16 + k13 * k16 * k22 * k36 * t12 * 4.0 +
      k13 * k16 * k23 * k35 * t12 * 4.0 + k13 * k23 * k25 * k26 * t12 * 2.0 +
      k15 * k16 * k25 * k33 * t10 * 4.0 + k15 * k16 * k26 * k32 * t10 * 4.0 -
      k16 * k22 * k23 * k26 * t12 * 8.0 + k12 * k15 * k22 * k36 * t15 * 6.0 +
      k12 * k15 * k23 * k35 * t15 * 6.0 - k12 * k15 * k22 * k36 * t16 * 2.0 -
      k12 * k15 * k23 * k35 * t16 * 6.0 + k15 * k16 * k25 * k33 * t12 * 4.0 +
      k15 * k16 * k26 * k32 * t12 * 1.2E1 + k13 * k22 * k26 * k36 * t8 * 2.0 +
      k13 * k23 * k25 * k36 * t8 * 2.0 + k13 * k23 * k26 * k35 * t8 * 2.0 -
      k16 * k22 * k23 * k36 * t8 * 4.0 + k16 * k25 * k26 * k36 * t2 * 8.0 +
      k13 * k22 * k26 * k36 * t9 * 6.0 + k13 * k23 * k25 * k36 * t9 * 6.0 +
      k13 * k23 * k26 * k35 * t9 * 6.0 + k16 * k22 * k23 * k36 * t9 * 4.0 -
      k12 * k22 * k26 * k33 * t14 - k12 * k23 * k25 * k33 * t14 -
      k12 * k23 * k26 * k32 * t14 + k13 * k22 * k26 * k36 * t10 * 6.0 +
      k13 * k23 * k25 * k36 * t10 * 2.0 + k13 * k23 * k26 * k35 * t10 * 2.0 -
      k15 * k22 * k23 * k33 * t14 * 6.0 + k15 * k25 * k26 * k33 * t8 * 4.0 -
      k16 * k22 * k23 * k36 * t10 * 8.0 + k12 * k13 * k32 * k36 * t15 * 4.0 +
      k12 * k13 * k33 * k35 * t15 * 4.0 + k12 * k22 * k26 * k33 * t15 +
      k12 * k23 * k25 * k33 * t15 * 3.0 + k12 * k23 * k26 * k32 * t15 -
      k15 * k16 * k32 * k36 * t9 * 2.0 - k15 * k16 * k33 * k35 * t9 * 2.0 -
      k15 * k22 * k23 * k33 * t15 * 2.0 - k12 * k22 * k26 * k33 * t16 * 5.0 -
      k12 * k23 * k25 * k33 * t16 * 5.0 - k12 * k23 * k26 * k32 * t16 * 5.0 +
      k13 * k22 * k26 * k36 * t12 * 4.0 + k13 * k23 * k25 * k36 * t12 * 4.0 +
      k13 * k23 * k26 * k35 * t12 * 4.0 + k15 * k16 * k32 * k36 * t10 * 2.0 +
      k15 * k16 * k33 * k35 * t10 * 2.0 + k15 * k22 * k23 * k33 * t16 * 2.0 -
      k15 * k25 * k26 * k33 * t10 * 2.0 - k16 * k22 * k23 * k36 * t12 * 8.0 -
      k15 * k16 * k32 * k36 * t12 * 6.0 - k15 * k16 * k33 * k35 * t12 * 2.0 -
      k15 * k25 * k26 * k33 * t12 * 4.0 - k13 * k23 * k32 * k33 * t14 * 6.0 +
      k16 * k26 * k32 * k33 * t8 * 4.0 + k16 * k26 * k35 * k36 * t2 * 8.0 -
      k22 * k23 * k26 * k36 * t8 * 8.0 + k13 * k23 * k32 * k33 * t15 * 2.0 +
      k13 * k23 * k35 * k36 * t9 * 4.0 - k16 * k26 * k32 * k33 * t9 * 4.0 -
      k22 * k23 * k26 * k36 * t9 * 8.0 - k12 * k22 * k33 * k36 * t14 -
      k12 * k23 * k32 * k36 * t14 - k12 * k23 * k33 * k35 * t14 -
      k13 * k23 * k32 * k33 * t16 * 2.0 - k13 * k23 * k35 * k36 * t10 * 4.0 +
      k15 * k25 * k33 * k36 * t8 * 6.0 + k15 * k26 * k32 * k36 * t8 * 6.0 +
      k15 * k26 * k33 * k35 * t8 * 6.0 - k16 * k26 * k32 * k33 * t10 * 8.0 -
      k12 * k22 * k33 * k36 * t15 * 5.0 - k12 * k23 * k32 * k36 * t15 * 5.0 -
      k12 * k23 * k33 * k35 * t15 * 5.0 + k15 * k25 * k33 * k36 * t9 * 2.0 +
      k15 * k26 * k32 * k36 * t9 * 2.0 + k15 * k26 * k33 * k35 * t9 * 2.0 +
      k12 * k22 * k33 * k36 * t16 + k12 * k23 * k32 * k36 * t16 +
      k12 * k23 * k33 * k35 * t16 * 3.0 - k13 * k23 * k35 * k36 * t12 * 2.0 +
      k15 * k25 * k33 * k36 * t10 * 4.0 + k15 * k26 * k32 * k36 * t10 * 4.0 +
      k15 * k26 * k33 * k35 * t10 * 4.0 - k16 * k26 * k32 * k33 * t12 * 8.0 +
      k15 * k25 * k33 * k36 * t12 * 2.0 + k15 * k26 * k32 * k36 * t12 * 6.0 +
      k15 * k26 * k33 * k35 * t12 * 2.0 + k16 * k32 * k33 * k36 * t9 * 8.0 -
      k16 * k32 * k33 * k36 * t10 * 8.0 - k15 * k33 * k35 * k36 * t9 * 4.0 +
      k15 * k33 * k35 * k36 * t10 * 2.0 - k26 * k32 * k33 * k36 * t8 * 8.0 -
      k26 * k32 * k33 * k36 * t9 * 8.0 - k13 * k16 * k22 * t9 * t12 -
      k13 * k16 * k22 * t10 * t12 * 6.0 - k12 * k15 * k22 * t9 * t16 * 2.0 -
      k12 * k15 * k22 * t12 * t14 - k12 * k15 * k22 * t12 * t15 -
      k12 * k15 * k22 * t12 * t16 + k13 * k22 * k26 * t2 * t16 * 2.0 +
      k13 * k23 * k25 * t2 * t16 * 2.0 - k16 * k22 * k23 * t2 * t16 * 4.0 -
      k12 * k13 * k32 * t8 * t15 * 2.0 - k12 * k13 * k32 * t10 * t14 -
      k13 * k22 * k26 * t8 * t12 - k13 * k23 * k25 * t8 * t12 -
      k15 * k16 * k32 * t8 * t10 + k16 * k22 * k23 * t8 * t12 * 2.0 -
      k16 * k25 * k26 * t2 * t12 * 4.0 - k12 * k13 * k32 * t10 * t15 -
      k13 * k22 * k26 * t9 * t12 - k13 * k23 * k25 * t9 * t12 +
      k16 * k22 * k23 * t9 * t12 * 2.0 - k12 * k13 * k32 * t10 * t16 -
      k13 * k22 * k26 * t10 * t12 * 3.0 - k13 * k23 * k25 * t10 * t12 +
      k16 * k22 * k23 * t10 * t12 * 4.0 - k15 * k16 * k32 * t10 * t12 * 6.0 -
      k13 * k22 * k36 * t2 * t15 * 2.0 - k13 * k23 * k35 * t2 * t15 * 2.0 +
      k12 * k22 * k33 * t8 * t15 * 3.0 + k12 * k23 * k32 * t8 * t15 * 3.0 -
      k13 * k22 * k36 * t9 * t10 * 6.0 - k13 * k23 * k35 * t9 * t10 * 2.0 +
      k12 * k22 * k33 * t10 * t14 * 3.0 + k12 * k23 * k32 * t10 * t14 -
      k15 * k25 * k33 * t2 * t16 * 2.0 - k15 * k25 * k33 * t8 * t10 * 2.0 -
      k15 * k26 * k32 * t2 * t16 * 2.0 - k15 * k26 * k32 * t8 * t10 * 2.0 +
      k22 * k23 * k26 * t8 * t12 * 4.0 + k12 * k22 * k33 * t9 * t16 * 3.0 +
      k12 * k23 * k32 * t9 * t16 * 3.0 - k13 * k22 * k36 * t9 * t12 * 2.0 -
      k13 * k23 * k35 * t9 * t12 * 2.0 + k12 * k22 * k33 * t10 * t16 * 3.0 +
      k12 * k22 * k33 * t12 * t14 + k12 * k23 * k32 * t10 * t16 +
      k12 * k23 * k32 * t12 * t14 * 3.0 - k15 * k25 * k33 * t8 * t12 * 2.0 -
      k15 * k26 * k32 * t8 * t12 * 6.0 + k12 * k22 * k33 * t12 * t15 +
      k12 * k23 * k32 * t12 * t15 * 3.0 + k22 * k23 * k36 * t2 * t14 * 2.0 +
      k25 * k26 * k36 * t2 * t8 * 4.0 - k16 * k32 * k33 * t2 * t15 * 4.0 +
      k22 * k23 * k36 * t2 * t15 * 2.0 + k22 * k23 * k36 * t8 * t9 * 2.0 +
      k16 * k32 * k33 * t8 * t10 * 2.0 - k16 * k35 * k36 * t2 * t10 * 4.0 +
      k22 * k23 * k36 * t2 * t16 * 2.0 + k25 * k26 * k36 * t2 * t10 * 2.0 +
      k15 * k32 * k36 * t2 * t15 * 2.0 + k15 * k33 * k35 * t2 * t15 * 2.0 +
      k16 * k32 * k33 * t9 * t10 * 2.0 + k22 * k23 * k36 * t9 * t10 * 4.0 -
      k15 * k32 * k36 * t8 * t10 - k15 * k33 * k35 * t8 * t10 -
      k15 * k32 * k36 * t9 * t10 - k15 * k33 * k35 * t9 * t10 +
      k22 * k23 * k36 * t9 * t12 * 4.0 + k16 * k32 * k33 * t10 * t12 * 4.0 -
      k15 * k32 * k36 * t10 * t12 * 3.0 - k15 * k33 * k35 * t10 * t12 +
      k26 * k32 * k33 * t2 * t14 * 2.0 + k26 * k32 * k33 * t2 * t15 * 2.0 +
      k26 * k32 * k33 * t8 * t9 * 2.0 + k26 * k35 * k36 * t2 * t9 * 4.0 +
      k26 * k32 * k33 * t2 * t16 * 2.0 + k26 * k32 * k33 * t8 * t10 * 4.0 +
      k26 * k32 * k33 * t8 * t12 * 4.0 + k26 * k35 * k36 * t2 * t12 * 2.0 +
      k32 * k33 * k36 * t9 * t10 * 4.0 - k13 * k22 * t2 * t12 * t15 +
      k16 * k25 * t2 * t10 * t12 + k22 * k23 * t2 * t9 * t16 * 2.0 +
      k25 * k26 * t2 * t8 * t12 * 2.0 - k15 * k32 * t2 * t10 * t16 +
      k16 * k35 * t2 * t10 * t12 + k25 * k36 * t2 * t10 * t12 +
      k26 * k35 * t2 * t10 * t12 + k32 * k33 * t2 * t8 * t15 * 2.0;
  coeffs(7) +=
      k35 * k36 * t2 * t9 * t10 * 2.0 +
      k12 * k13 * k15 * k16 * k25 * k36 * 8.0 +
      k12 * k13 * k15 * k16 * k26 * k35 * 8.0 +
      k12 * k13 * k16 * k25 * k26 * k33 * 8.0 -
      k13 * k15 * k16 * k22 * k26 * k33 * 2.0 -
      k13 * k15 * k16 * k23 * k25 * k33 * 2.0 -
      k13 * k15 * k16 * k23 * k26 * k32 * 2.0 -
      k12 * k13 * k15 * k25 * k26 * k36 * 1.6E1 -
      k12 * k15 * k16 * k22 * k26 * k36 * 4.0 -
      k12 * k15 * k16 * k23 * k25 * k36 * 4.0 -
      k12 * k15 * k16 * k23 * k26 * k35 * 4.0 -
      k12 * k13 * k16 * k25 * k33 * k36 * 4.0 -
      k12 * k13 * k16 * k26 * k32 * k36 * 4.0 -
      k12 * k13 * k16 * k26 * k33 * k35 * 4.0 -
      k12 * k16 * k23 * k25 * k26 * k33 * 2.0 -
      k13 * k15 * k16 * k22 * k33 * k36 * 2.0 -
      k13 * k15 * k16 * k23 * k32 * k36 * 2.0 -
      k13 * k15 * k16 * k23 * k33 * k35 * 2.0 -
      k13 * k15 * k23 * k25 * k26 * k33 * 2.0 +
      k15 * k16 * k22 * k23 * k26 * k33 * 8.0 -
      k12 * k13 * k15 * k26 * k35 * k36 * 1.6E1 +
      k12 * k15 * k16 * k23 * k35 * k36 * 8.0 +
      k12 * k15 * k23 * k25 * k26 * k36 * 1.2E1 +
      k13 * k16 * k23 * k26 * k32 * k33 * 4.0 +
      k12 * k13 * k25 * k26 * k33 * k36 * 8.0 +
      k12 * k16 * k22 * k26 * k33 * k36 * 6.0 +
      k12 * k16 * k23 * k25 * k33 * k36 * 6.0 +
      k12 * k16 * k23 * k26 * k32 * k36 * 6.0 +
      k12 * k16 * k23 * k26 * k33 * k35 * 6.0 -
      k13 * k15 * k22 * k26 * k33 * k36 * 1.0E1 -
      k13 * k15 * k23 * k25 * k33 * k36 * 1.0E1 -
      k13 * k15 * k23 * k26 * k32 * k36 * 1.0E1 -
      k13 * k15 * k23 * k26 * k33 * k35 * 1.0E1 +
      k15 * k16 * k22 * k23 * k33 * k36 * 4.0 +
      k12 * k15 * k23 * k26 * k35 * k36 * 8.0 +
      k13 * k16 * k23 * k32 * k33 * k36 * 8.0 +
      k12 * k13 * k26 * k33 * k35 * k36 * 1.2E1 -
      k12 * k16 * k23 * k33 * k35 * k36 * 2.0 -
      k12 * k23 * k25 * k26 * k33 * k36 * 1.0E1 -
      k13 * k15 * k23 * k33 * k35 * k36 * 2.0 +
      k15 * k22 * k23 * k26 * k33 * k36 * 8.0 +
      k13 * k23 * k26 * k32 * k33 * k36 * 8.0 -
      k12 * k23 * k26 * k33 * k35 * k36 * 1.0E1 +
      k12 * k15 * k16 * k22 * k26 * t12 * 2.0 +
      k12 * k15 * k16 * k23 * k25 * t12 * 2.0 -
      k12 * k13 * k16 * k25 * k33 * t10 * 4.0 -
      k12 * k13 * k16 * k26 * k32 * t10 * 4.0 +
      k13 * k15 * k16 * k22 * k33 * t10 * 6.0 +
      k13 * k15 * k16 * k23 * k32 * t10 * 2.0 +
      k12 * k13 * k15 * k25 * k36 * t10 * 4.0 +
      k12 * k13 * k15 * k26 * k35 * t10 * 4.0 +
      k13 * k15 * k16 * k22 * k33 * t12 * 2.0 +
      k13 * k15 * k16 * k23 * k32 * t12 * 6.0 +
      k12 * k13 * k15 * k25 * k36 * t12 * 4.0 +
      k12 * k13 * k15 * k26 * k35 * t12 * 4.0 -
      k12 * k15 * k16 * k22 * k36 * t12 * 4.0 -
      k12 * k15 * k16 * k23 * k35 * t12 * 4.0 -
      k12 * k15 * k23 * k25 * k26 * t12 * 2.0 -
      k13 * k16 * k22 * k26 * k36 * t2 * 2.0 -
      k13 * k16 * k23 * k25 * k36 * t2 * 2.0 -
      k13 * k16 * k23 * k26 * k35 * t2 * 2.0 -
      k12 * k13 * k22 * k23 * k33 * t14 * 2.0 -
      k12 * k13 * k25 * k26 * k33 * t8 * 4.0 +
      k12 * k16 * k22 * k26 * k33 * t8 * 3.0 +
      k12 * k16 * k23 * k25 * k33 * t8 * 3.0 +
      k12 * k16 * k23 * k26 * k32 * t8 * 3.0 +
      k13 * k15 * k22 * k26 * k33 * t8 + k13 * k15 * k23 * k25 * k33 * t8 +
      k13 * k15 * k23 * k26 * k32 * t8 -
      k15 * k16 * k22 * k23 * k33 * t8 * 2.0 -
      k12 * k13 * k22 * k23 * k33 * t15 * 2.0 +
      k12 * k13 * k16 * k32 * k36 * t10 * 2.0 +
      k12 * k13 * k16 * k33 * k35 * t10 * 2.0 -
      k12 * k13 * k22 * k23 * k33 * t16 * 2.0 -
      k12 * k13 * k25 * k26 * k33 * t10 * 2.0 -
      k12 * k15 * k22 * k26 * k36 * t8 * 2.0 -
      k12 * k15 * k23 * k25 * k36 * t8 * 2.0 -
      k12 * k15 * k23 * k26 * k35 * t8 * 2.0 +
      k12 * k16 * k22 * k26 * k33 * t10 * 3.0 +
      k12 * k16 * k23 * k25 * k33 * t10 + k12 * k16 * k23 * k26 * k32 * t10 +
      k13 * k15 * k22 * k26 * k33 * t10 * 3.0 +
      k13 * k15 * k23 * k25 * k33 * t10 + k13 * k15 * k23 * k26 * k32 * t10 -
      k15 * k16 * k22 * k23 * k33 * t10 * 4.0 -
      k12 * k15 * k22 * k26 * k36 * t10 * 6.0 -
      k12 * k15 * k23 * k25 * k36 * t10 * 2.0 -
      k12 * k15 * k23 * k26 * k35 * t10 * 2.0 -
      k12 * k16 * k22 * k26 * k33 * t12 * 2.0 -
      k12 * k16 * k23 * k25 * k33 * t12 * 2.0 -
      k12 * k16 * k23 * k26 * k32 * t12 * 6.0 +
      k13 * k15 * k22 * k26 * k33 * t12 * 2.0 +
      k13 * k15 * k23 * k25 * k33 * t12 * 2.0 +
      k13 * k15 * k23 * k26 * k32 * t12 * 6.0 -
      k15 * k16 * k22 * k23 * k33 * t12 * 4.0 -
      k13 * k23 * k25 * k26 * k36 * t2 * 4.0 -
      k13 * k16 * k23 * k32 * k33 * t9 * 2.0 +
      k12 * k23 * k25 * k26 * k33 * t8 * 6.0 -
      k13 * k16 * k23 * k32 * k33 * t10 * 4.0 -
      k15 * k16 * k25 * k33 * k36 * t2 * 2.0 -
      k15 * k16 * k26 * k32 * k36 * t2 * 2.0 -
      k15 * k16 * k26 * k33 * k35 * t2 * 2.0 -
      k15 * k22 * k23 * k26 * k33 * t8 * 4.0 -
      k12 * k13 * k25 * k33 * k36 * t9 * 2.0 -
      k12 * k13 * k26 * k32 * k36 * t9 * 2.0 -
      k12 * k13 * k26 * k33 * k35 * t9 * 2.0 +
      k12 * k16 * k22 * k33 * k36 * t9 * 3.0 +
      k12 * k16 * k23 * k32 * k36 * t9 * 3.0;
  coeffs(7) +=
      k12 * k16 * k23 * k33 * k35 * t9 * 3.0 +
      k13 * k15 * k22 * k33 * k36 * t9 + k13 * k15 * k23 * k32 * k36 * t9 +
      k13 * k15 * k23 * k33 * k35 * t9 -
      k12 * k15 * k23 * k32 * k33 * t14 * 2.0 -
      k12 * k16 * k22 * k33 * k36 * t10 * 6.0 -
      k12 * k16 * k23 * k32 * k36 * t10 * 2.0 -
      k12 * k16 * k23 * k33 * k35 * t10 * 2.0 +
      k13 * k15 * k22 * k33 * k36 * t10 * 6.0 +
      k13 * k15 * k23 * k32 * k36 * t10 * 2.0 +
      k13 * k15 * k23 * k33 * k35 * t10 * 2.0 -
      k13 * k16 * k23 * k32 * k33 * t12 * 4.0 -
      k12 * k15 * k23 * k32 * k33 * t15 * 2.0 -
      k12 * k15 * k23 * k35 * k36 * t9 * 4.0 -
      k12 * k13 * k25 * k33 * k36 * t12 * 2.0 -
      k12 * k13 * k26 * k32 * k36 * t12 * 6.0 -
      k12 * k13 * k26 * k33 * k35 * t12 * 2.0 -
      k12 * k15 * k23 * k32 * k33 * t16 * 2.0 +
      k12 * k16 * k22 * k33 * k36 * t12 +
      k12 * k16 * k23 * k32 * k36 * t12 * 3.0 +
      k12 * k16 * k23 * k33 * k35 * t12 +
      k12 * k23 * k25 * k26 * k33 * t12 * 2.0 +
      k13 * k15 * k22 * k33 * k36 * t12 +
      k13 * k15 * k23 * k32 * k36 * t12 * 3.0 +
      k13 * k15 * k23 * k33 * k35 * t12 -
      k12 * k15 * k23 * k35 * k36 * t12 * 2.0 -
      k13 * k23 * k26 * k32 * k33 * t8 * 2.0 +
      k13 * k23 * k26 * k35 * k36 * t2 * 4.0 -
      k13 * k23 * k26 * k32 * k33 * t9 * 2.0 -
      k12 * k22 * k26 * k33 * k36 * t8 - k12 * k23 * k25 * k33 * k36 * t8 -
      k12 * k23 * k26 * k32 * k36 * t8 - k12 * k23 * k26 * k33 * k35 * t8 -
      k13 * k23 * k26 * k32 * k33 * t10 * 2.0 -
      k15 * k22 * k23 * k33 * k36 * t8 * 2.0 +
      k15 * k25 * k26 * k33 * k36 * t2 * 4.0 -
      k12 * k22 * k26 * k33 * k36 * t9 - k12 * k23 * k25 * k33 * k36 * t9 -
      k12 * k23 * k26 * k32 * k36 * t9 - k12 * k23 * k26 * k33 * k35 * t9 -
      k15 * k22 * k23 * k33 * k36 * t9 * 2.0 -
      k12 * k13 * k33 * k35 * k36 * t10 * 2.0 +
      k12 * k22 * k26 * k33 * k36 * t10 * 3.0 +
      k12 * k23 * k25 * k33 * k36 * t10 + k12 * k23 * k26 * k32 * k36 * t10 +
      k12 * k23 * k26 * k33 * k35 * t10 -
      k13 * k23 * k26 * k32 * k33 * t12 * 4.0 -
      k15 * k22 * k23 * k33 * k36 * t10 * 4.0 +
      k12 * k22 * k26 * k33 * k36 * t12 + k12 * k23 * k25 * k33 * k36 * t12 +
      k12 * k23 * k26 * k32 * k36 * t12 * 3.0 +
      k12 * k23 * k26 * k33 * k35 * t12 -
      k15 * k22 * k23 * k33 * k36 * t12 * 2.0 -
      k13 * k23 * k32 * k33 * k36 * t9 * 4.0 -
      k15 * k26 * k33 * k35 * k36 * t2 * 4.0 +
      k12 * k23 * k33 * k35 * k36 * t9 * 6.0 +
      k12 * k23 * k33 * k35 * k36 * t10 * 2.0 +
      k12 * k13 * k15 * k25 * t10 * t12 -
      k12 * k15 * k16 * k22 * t10 * t12 * 3.0 -
      k13 * k16 * k22 * k26 * t2 * t12 - k13 * k16 * k23 * k25 * t2 * t12 -
      k12 * k15 * k22 * k26 * t2 * t16 * 2.0 -
      k12 * k15 * k23 * k25 * t2 * t16 * 2.0 -
      k12 * k13 * k16 * k32 * t10 * t12 * 3.0 -
      k12 * k15 * k22 * k26 * t8 * t12 - k12 * k15 * k23 * k25 * t8 * t12 +
      k12 * k13 * k15 * k35 * t10 * t12 -
      k13 * k23 * k25 * k26 * t2 * t12 * 2.0 +
      k16 * k22 * k23 * k26 * t2 * t12 * 2.0 -
      k12 * k13 * k25 * k33 * t10 * t12 -
      k12 * k13 * k26 * k32 * t10 * t12 * 3.0 +
      k12 * k16 * k22 * k33 * t10 * t12 * 3.0 +
      k12 * k16 * k23 * k32 * t10 * t12 * 3.0 -
      k12 * k15 * k22 * k36 * t10 * t12 * 3.0 -
      k12 * k15 * k23 * k35 * t10 * t12 -
      k12 * k13 * k32 * k36 * t2 * t15 * 2.0 -
      k12 * k13 * k33 * k35 * t2 * t15 * 2.0 +
      k12 * k22 * k26 * k33 * t2 * t16 + k12 * k23 * k25 * k33 * t2 * t16 +
      k12 * k23 * k26 * k32 * t2 * t16 -
      k13 * k22 * k26 * k36 * t2 * t12 * 2.0 -
      k13 * k23 * k25 * k36 * t2 * t12 * 2.0 -
      k13 * k23 * k26 * k35 * t2 * t12 * 2.0 -
      k15 * k16 * k32 * k36 * t2 * t10 - k15 * k16 * k33 * k35 * t2 * t10 -
      k15 * k22 * k23 * k33 * t2 * t16 * 2.0 +
      k16 * k22 * k23 * k36 * t2 * t12 * 2.0 -
      k12 * k13 * k32 * k36 * t9 * t10 - k12 * k13 * k33 * k35 * t9 * t10 +
      k12 * k22 * k26 * k33 * t8 * t12 + k12 * k23 * k25 * k33 * t8 * t12 +
      k12 * k23 * k26 * k32 * t8 * t12 * 3.0 -
      k13 * k23 * k32 * k33 * t2 * t15 * 2.0 +
      k16 * k26 * k32 * k33 * t2 * t10 * 2.0 +
      k12 * k22 * k33 * k36 * t2 * t15 + k12 * k23 * k32 * k36 * t2 * t15 +
      k12 * k23 * k33 * k35 * t2 * t15 -
      k15 * k25 * k33 * k36 * t2 * t10 * 2.0 -
      k15 * k26 * k32 * k36 * t2 * t10 * 2.0 -
      k15 * k26 * k33 * k35 * t2 * t10 * 2.0 +
      k22 * k23 * k26 * k36 * t2 * t12 * 2.0 +
      k12 * k22 * k33 * k36 * t9 * t10 * 3.0 +
      k12 * k23 * k32 * k36 * t9 * t10 + k12 * k23 * k33 * k35 * t9 * t10 +
      k16 * k32 * k33 * k36 * t2 * t10 * 2.0 -
      k15 * k33 * k35 * k36 * t2 * t10 * 2.0 +
      k26 * k32 * k33 * k36 * t2 * t10 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k26 * k33 * 8.0 +
      k12 * k13 * k15 * k22 * k23 * k26 * k36 * 8.0 +
      k12 * k13 * k16 * k22 * k23 * k33 * k36 * 4.0 +
      k12 * k15 * k16 * k23 * k26 * k32 * k33 * 4.0 +
      k12 * k13 * k15 * k26 * k32 * k33 * k36 * 8.0 -
      k12 * k15 * k16 * k23 * k32 * k33 * k36 * 8.0 +
      k12 * k13 * k15 * k16 * k22 * k23 * t12 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k26 * t12 * 2.0 +
      k12 * k13 * k15 * k16 * k32 * k33 * t10 * 2.0 -
      k12 * k13 * k16 * k22 * k23 * k33 * t12 * 2.0 +
      k12 * k13 * k15 * k22 * k23 * k36 * t12 * 2.0 +
      k12 * k13 * k15 * k26 * k32 * k33 * t10 * 2.0 -
      k12 * k13 * k22 * k23 * k26 * k33 * t12 * 2.0 -
      k12 * k15 * k16 * k23 * k32 * k33 * t10 * 2.0 -
      k13 * k16 * k23 * k26 * k32 * k33 * t2 * 2.0 -
      k12 * k13 * k25 * k26 * k33 * k36 * t2 * 4.0 +
      k12 * k16 * k22 * k26 * k33 * k36 * t2 +
      k12 * k16 * k23 * k25 * k33 * k36 * t2 +
      k12 * k16 * k23 * k26 * k32 * k36 * t2 +
      k12 * k16 * k23 * k26 * k33 * k35 * t2 +
      k13 * k15 * k22 * k26 * k33 * k36 * t2 * 3.0 +
      k13 * k15 * k23 * k25 * k33 * k36 * t2 * 3.0 +
      k13 * k15 * k23 * k26 * k32 * k36 * t2 * 3.0 +
      k13 * k15 * k23 * k26 * k33 * k35 * t2 * 3.0 -
      k15 * k16 * k22 * k23 * k33 * k36 * t2 * 2.0 -
      k12 * k13 * k22 * k23 * k33 * k36 * t9 * 2.0 -
      k12 * k15 * k23 * k26 * k32 * k33 * t8 * 2.0 -
      k12 * k15 * k23 * k26 * k35 * k36 * t2 * 4.0 +
      k12 * k13 * k15 * k32 * k33 * k36 * t10 * 2.0 +
      k12 * k23 * k25 * k26 * k33 * k36 * t2 * 2.0 -
      k15 * k22 * k23 * k26 * k33 * k36 * t2 * 4.0 -
      k12 * k15 * k23 * k32 * k33 * k36 * t10 * 2.0 -
      k13 * k23 * k26 * k32 * k33 * k36 * t2 * 4.0 +
      k12 * k23 * k26 * k33 * k35 * k36 * t2 * 2.0;
  coeffs(8) =
      t14 * t15 * 6.0 + t14 * t16 * 6.0 + t15 * t16 * 6.0 + t15 * t17 +
      t14 * t19 + t14 * t20 + t15 * t19 + t16 * t18 + t16 * t20 + t14 * t14 +
      t15 * t15 + t16 * t16 - k16 * k26 * t14 * 4.0 - k16 * k26 * t15 * 4.0 -
      k16 * k26 * t16 * 1.2E1 - k16 * k26 * t19 * 2.0 - k16 * k36 * t14 * 4.0 -
      k16 * k36 * t15 * 1.2E1 - k16 * k36 * t16 * 4.0 - k16 * k36 * t20 * 2.0 +
      k26 * k36 * t14 * 1.2E1 + k26 * k36 * t15 * 4.0 + k26 * k36 * t16 * 4.0 -
      k16 * t8 * t15 * 4.0 + k16 * t10 * t14 * 2.0 - k16 * t9 * t16 * 4.0 +
      k16 * t10 * t15 * 2.0 + k16 * t10 * t16 * 6.0 + k16 * t12 * t14 * 2.0 +
      k16 * t12 * t15 * 6.0 + k16 * t12 * t16 * 2.0 + k16 * t10 * t19 +
      k16 * t12 * t20 + k26 * t8 * t14 * 2.0 + k26 * t8 * t15 * 2.0 +
      k26 * t8 * t16 * 2.0 - k26 * t10 * t14 * 4.0 + k26 * t9 * t16 * 4.0 -
      k26 * t10 * t16 * 4.0 - k26 * t12 * t14 * 6.0 + k26 * t8 * t19 -
      k26 * t12 * t15 * 2.0 - k26 * t12 * t16 * 2.0 + k36 * t8 * t15 * 4.0 +
      k36 * t9 * t14 * 2.0 + k36 * t9 * t15 * 2.0 - k36 * t10 * t14 * 6.0 +
      k36 * t9 * t16 * 2.0 - k36 * t10 * t15 * 2.0 - k36 * t10 * t16 * 2.0 -
      k36 * t12 * t14 * 4.0 - k36 * t12 * t15 * 4.0 + k36 * t9 * t20 +
      t8 * t10 * t14 - t2 * t15 * t16 * 4.0 + t8 * t10 * t15 + t8 * t10 * t16 -
      t8 * t12 * t15 * 2.0 - t9 * t10 * t16 * 2.0 + t9 * t12 * t14 +
      t5 * t15 * t16 + t9 * t12 * t15 + t10 * t12 * t14 * 3.0 + t9 * t12 * t16 +
      t10 * t12 * t15 + t10 * t12 * t16 - k13 * k16 * k23 * t14 * 2.0 +
      k13 * k16 * k23 * t15 * 2.0 - k13 * k16 * k23 * t16 * 6.0 -
      k13 * k16 * k23 * t19 + k13 * k23 * k26 * t14 * 2.0 -
      k13 * k23 * k26 * t15 * 2.0 + k13 * k23 * k26 * t16 * 2.0 -
      k15 * k16 * k33 * t14 * 2.0 - k15 * k16 * k33 * t15 * 6.0 +
      k15 * k16 * k33 * t16 * 2.0 - k13 * k23 * k26 * t19 -
      k15 * k16 * k33 * t20 + k13 * k23 * k36 * t14 * 6.0 -
      k16 * k26 * k36 * t8 * 4.0 - k13 * k23 * k36 * t15 * 2.0 -
      k16 * k26 * k36 * t9 * 4.0 + k13 * k23 * k36 * t16 * 2.0 +
      k15 * k26 * k33 * t14 * 6.0 + k16 * k26 * k36 * t10 * 8.0 +
      k15 * k26 * k33 * t15 * 2.0 - k15 * k26 * k33 * t16 * 2.0 +
      k16 * k26 * k36 * t12 * 8.0 + k15 * k33 * k36 * t14 * 2.0 +
      k15 * k33 * k36 * t15 * 2.0 - k15 * k33 * k36 * t16 * 2.0 -
      k15 * k33 * k36 * t20 - k13 * k23 * t8 * t15 * 2.0 -
      k13 * k23 * t10 * t14 * 2.0 + k16 * k26 * t2 * t16 * 4.0 +
      k16 * k26 * t8 * t10 * 4.0 + k13 * k23 * t9 * t16 * 2.0 -
      k13 * k23 * t10 * t16 * 2.0 - k13 * k23 * t12 * t14 * 3.0 +
      k16 * k26 * t8 * t12 * 2.0 + k13 * k23 * t12 * t15 -
      k16 * k26 * t9 * t12 * 2.0 - k13 * k23 * t12 * t16 -
      k16 * k26 * t10 * t12 * 4.0 + k16 * k36 * t2 * t15 * 4.0 -
      k16 * k36 * t8 * t10 * 2.0 + k15 * k33 * t8 * t15 * 2.0 +
      k16 * k36 * t9 * t10 * 2.0 - k15 * k33 * t10 * t14 * 3.0 -
      k15 * k33 * t9 * t16 * 2.0 - k15 * k33 * t10 * t15 +
      k16 * k36 * t9 * t12 * 4.0 + k15 * k33 * t10 * t16 -
      k15 * k33 * t12 * t14 * 2.0 - k16 * k36 * t10 * t12 * 4.0 -
      k15 * k33 * t12 * t15 * 2.0 - k26 * k36 * t2 * t14 * 2.0 -
      k26 * k36 * t2 * t15 * 2.0 - k26 * k36 * t8 * t9 * 2.0 -
      k26 * k36 * t2 * t16 * 2.0 - k26 * k36 * t8 * t10 * 4.0 -
      k26 * k36 * t9 * t10 * 4.0 - k26 * k36 * t8 * t12 * 4.0 -
      k26 * k36 * t9 * t12 * 4.0 - k16 * t2 * t10 * t16 * 2.0 -
      k16 * t2 * t12 * t15 * 2.0 + k16 * t8 * t10 * t12 + k16 * t9 * t10 * t12 +
      k26 * t2 * t9 * t16 * 2.0 + k26 * t2 * t12 * t14 + k26 * t2 * t12 * t15 +
      k26 * t8 * t9 * t12 + k26 * t2 * t12 * t16 + k26 * t8 * t10 * t12 * 2.0 +
      k36 * t2 * t8 * t15 * 2.0 + k36 * t2 * t10 * t14 + k36 * t2 * t10 * t15 +
      k36 * t8 * t9 * t10 + k36 * t2 * t10 * t16 + k36 * t9 * t10 * t12 * 2.0 +
      t2 * t8 * t12 * t15 + t2 * t9 * t10 * t16 -
      k13 * k16 * k23 * k26 * k36 * 4.0 - k15 * k16 * k26 * k33 * k36 * 4.0 -
      k12 * k13 * k15 * k26 * t16 * 8.0 + k12 * k15 * k16 * k23 * t16 * 4.0 -
      k13 * k16 * k23 * k26 * t8 * 2.0 - k13 * k16 * k23 * k26 * t10 * 2.0 +
      k12 * k13 * k16 * k33 * t15 * 4.0 + k13 * k16 * k23 * k26 * t12 * 2.0 -
      k12 * k13 * k15 * k36 * t15 * 8.0 + k12 * k15 * k23 * k26 * t16 * 4.0 -
      k13 * k16 * k23 * k36 * t9 * 2.0 - k12 * k13 * k26 * k33 * t14 * 2.0 +
      k12 * k16 * k23 * k33 * t14 + k13 * k15 * k23 * k33 * t14 * 3.0 +
      k13 * k16 * k23 * k36 * t10 * 4.0 - k15 * k16 * k26 * k33 * t8 * 2.0 -
      k12 * k13 * k26 * k33 * t15 * 2.0 - k12 * k16 * k23 * k33 * t15 -
      k13 * k15 * k23 * k33 * t15 + k12 * k13 * k26 * k33 * t16 * 6.0 -
      k12 * k15 * k23 * k36 * t14 * 2.0 - k12 * k16 * k23 * k33 * t16 -
      k13 * k15 * k23 * k33 * t16 + k13 * k16 * k23 * k36 * t12 * 4.0 +
      k15 * k16 * k26 * k33 * t10 * 4.0 + k12 * k15 * k23 * k36 * t15 * 6.0 -
      k12 * k15 * k23 * k36 * t16 * 2.0 + k15 * k16 * k26 * k33 * t12 * 4.0 +
      k13 * k23 * k26 * k36 * t8 * 2.0 + k13 * k23 * k26 * k36 * t9 * 6.0 -
      k12 * k23 * k26 * k33 * t14 + k13 * k23 * k26 * k36 * t10 * 2.0 +
      k12 * k13 * k33 * k36 * t15 * 4.0 + k12 * k23 * k26 * k33 * t15 -
      k15 * k16 * k33 * k36 * t9 * 2.0 - k12 * k23 * k26 * k33 * t16 * 5.0 +
      k13 * k23 * k26 * k36 * t12 * 4.0 + k15 * k16 * k33 * k36 * t10 * 2.0 -
      k15 * k16 * k33 * k36 * t12 * 2.0 - k12 * k23 * k33 * k36 * t14 +
      k15 * k26 * k33 * k36 * t8 * 6.0 - k12 * k23 * k33 * k36 * t15 * 5.0 +
      k15 * k26 * k33 * k36 * t9 * 2.0 + k12 * k23 * k33 * k36 * t16 +
      k15 * k26 * k33 * k36 * t10 * 4.0 + k15 * k26 * k33 * k36 * t12 * 2.0 -
      k13 * k16 * k23 * t9 * t12 - k13 * k16 * k23 * t10 * t12 * 2.0 -
      k12 * k15 * k23 * t9 * t16 * 2.0 - k12 * k15 * k23 * t12 * t14 -
      k12 * k15 * k23 * t12 * t15 - k12 * k15 * k23 * t12 * t16 +
      k13 * k23 * k26 * t2 * t16 * 2.0 - k12 * k13 * k33 * t8 * t15 * 2.0 -
      k12 * k13 * k33 * t10 * t14 - k13 * k23 * k26 * t8 * t12 -
      k15 * k16 * k33 * t8 * t10 - k12 * k13 * k33 * t10 * t15 -
      k13 * k23 * k26 * t9 * t12 - k12 * k13 * k33 * t10 * t16 -
      k13 * k23 * k26 * t10 * t12 - k15 * k16 * k33 * t10 * t12 * 2.0 -
      k13 * k23 * k36 * t2 * t15 * 2.0 + k12 * k23 * k33 * t8 * t15 * 3.0 -
      k13 * k23 * k36 * t9 * t10 * 2.0 + k12 * k23 * k33 * t10 * t14 -
      k15 * k26 * k33 * t2 * t16 * 2.0 - k15 * k26 * k33 * t8 * t10 * 2.0 +
      k12 * k23 * k33 * t9 * t16 * 3.0 - k13 * k23 * k36 * t9 * t12 * 2.0;
  coeffs(8) +=
      k12 * k23 * k33 * t10 * t16 + k12 * k23 * k33 * t12 * t14 -
      k15 * k26 * k33 * t8 * t12 * 2.0 + k12 * k23 * k33 * t12 * t15 +
      k15 * k33 * k36 * t2 * t15 * 2.0 - k15 * k33 * k36 * t8 * t10 -
      k15 * k33 * k36 * t9 * t10 - k15 * k33 * k36 * t10 * t12 -
      k13 * k23 * t2 * t12 * t15 + k16 * k26 * t2 * t10 * t12 -
      k15 * k33 * t2 * t10 * t16 + k16 * k36 * t2 * t10 * t12 +
      k26 * k36 * t2 * t10 * t12 + k12 * k13 * k15 * k16 * k26 * k36 * 8.0 -
      k13 * k15 * k16 * k23 * k26 * k33 * 2.0 -
      k12 * k15 * k16 * k23 * k26 * k36 * 4.0 -
      k12 * k13 * k16 * k26 * k33 * k36 * 4.0 -
      k13 * k15 * k16 * k23 * k33 * k36 * 2.0 +
      k12 * k16 * k23 * k26 * k33 * k36 * 6.0 -
      k13 * k15 * k23 * k26 * k33 * k36 * 1.0E1 +
      k12 * k15 * k16 * k23 * k26 * t12 * 2.0 -
      k12 * k13 * k16 * k26 * k33 * t10 * 4.0 +
      k13 * k15 * k16 * k23 * k33 * t10 * 2.0 +
      k12 * k13 * k15 * k26 * k36 * t10 * 4.0 +
      k13 * k15 * k16 * k23 * k33 * t12 * 2.0 +
      k12 * k13 * k15 * k26 * k36 * t12 * 4.0 -
      k12 * k15 * k16 * k23 * k36 * t12 * 4.0 -
      k13 * k16 * k23 * k26 * k36 * t2 * 2.0 +
      k12 * k16 * k23 * k26 * k33 * t8 * 3.0 +
      k13 * k15 * k23 * k26 * k33 * t8 +
      k12 * k13 * k16 * k33 * k36 * t10 * 2.0 -
      k12 * k15 * k23 * k26 * k36 * t8 * 2.0 +
      k12 * k16 * k23 * k26 * k33 * t10 + k13 * k15 * k23 * k26 * k33 * t10 -
      k12 * k15 * k23 * k26 * k36 * t10 * 2.0 -
      k12 * k16 * k23 * k26 * k33 * t12 * 2.0 +
      k13 * k15 * k23 * k26 * k33 * t12 * 2.0 -
      k15 * k16 * k26 * k33 * k36 * t2 * 2.0 -
      k12 * k13 * k26 * k33 * k36 * t9 * 2.0 +
      k12 * k16 * k23 * k33 * k36 * t9 * 3.0 +
      k13 * k15 * k23 * k33 * k36 * t9 -
      k12 * k16 * k23 * k33 * k36 * t10 * 2.0 +
      k13 * k15 * k23 * k33 * k36 * t10 * 2.0 -
      k12 * k13 * k26 * k33 * k36 * t12 * 2.0 +
      k12 * k16 * k23 * k33 * k36 * t12 + k13 * k15 * k23 * k33 * k36 * t12 -
      k12 * k23 * k26 * k33 * k36 * t8 - k12 * k23 * k26 * k33 * k36 * t9 +
      k12 * k23 * k26 * k33 * k36 * t10 + k12 * k23 * k26 * k33 * k36 * t12 +
      k12 * k13 * k15 * k16 * t10 * t12 + k12 * k13 * k15 * k26 * t10 * t12 -
      k12 * k15 * k16 * k23 * t10 * t12 - k13 * k16 * k23 * k26 * t2 * t12 -
      k12 * k15 * k23 * k26 * t2 * t16 * 2.0 -
      k12 * k13 * k16 * k33 * t10 * t12 - k12 * k15 * k23 * k26 * t8 * t12 +
      k12 * k13 * k15 * k36 * t10 * t12 - k12 * k13 * k26 * k33 * t10 * t12 +
      k12 * k16 * k23 * k33 * t10 * t12 - k12 * k15 * k23 * k36 * t10 * t12 -
      k12 * k13 * k33 * k36 * t2 * t15 * 2.0 +
      k12 * k23 * k26 * k33 * t2 * t16 -
      k13 * k23 * k26 * k36 * t2 * t12 * 2.0 -
      k15 * k16 * k33 * k36 * t2 * t10 - k12 * k13 * k33 * k36 * t9 * t10 +
      k12 * k23 * k26 * k33 * t8 * t12 + k12 * k23 * k33 * k36 * t2 * t15 -
      k15 * k26 * k33 * k36 * t2 * t10 * 2.0 +
      k12 * k23 * k33 * k36 * t9 * t10 +
      k12 * k16 * k23 * k26 * k33 * k36 * t2 +
      k13 * k15 * k23 * k26 * k33 * k36 * t2 * 3.0;

  return coeffs;
}

}  // namespace colmap
