// Code generated by protoc-gen-go. DO NOT EDIT.
// source: shared.proto

package gitalypb

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type Repository struct {
	StorageName  string `protobuf:"bytes,2,opt,name=storage_name,json=storageName" json:"storage_name,omitempty"`
	RelativePath string `protobuf:"bytes,3,opt,name=relative_path,json=relativePath" json:"relative_path,omitempty"`
	// Sets the GIT_OBJECT_DIRECTORY envvar on git commands to the value of this field.
	// It influences the object storage directory the SHA1 directories are created underneath.
	GitObjectDirectory string `protobuf:"bytes,4,opt,name=git_object_directory,json=gitObjectDirectory" json:"git_object_directory,omitempty"`
	// Sets the GIT_ALTERNATE_OBJECT_DIRECTORIES envvar on git commands to the values of this field.
	// It influences the list of Git object directories which can be used to search for Git objects.
	GitAlternateObjectDirectories []string `protobuf:"bytes,5,rep,name=git_alternate_object_directories,json=gitAlternateObjectDirectories" json:"git_alternate_object_directories,omitempty"`
	// Used in callbacks to GitLab so that it knows what repository the event is
	// associated with. May be left empty on RPC's that do not perform callbacks.
	// During project creation, `gl_repository` may not be known.
	GlRepository string `protobuf:"bytes,6,opt,name=gl_repository,json=glRepository" json:"gl_repository,omitempty"`
	// The human-readable GitLab project path (e.g. gitlab-org/gitlab-ce).
	// When hashed storage is use, this associates a project path with its
	// path on disk. The name can change over time (e.g. when a project is
	// renamed). This is primarily used for logging/debugging at the
	// moment.
	GlProjectPath string `protobuf:"bytes,8,opt,name=gl_project_path,json=glProjectPath" json:"gl_project_path,omitempty"`
}

func (m *Repository) Reset()                    { *m = Repository{} }
func (m *Repository) String() string            { return proto.CompactTextString(m) }
func (*Repository) ProtoMessage()               {}
func (*Repository) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{0} }

func (m *Repository) GetStorageName() string {
	if m != nil {
		return m.StorageName
	}
	return ""
}

func (m *Repository) GetRelativePath() string {
	if m != nil {
		return m.RelativePath
	}
	return ""
}

func (m *Repository) GetGitObjectDirectory() string {
	if m != nil {
		return m.GitObjectDirectory
	}
	return ""
}

func (m *Repository) GetGitAlternateObjectDirectories() []string {
	if m != nil {
		return m.GitAlternateObjectDirectories
	}
	return nil
}

func (m *Repository) GetGlRepository() string {
	if m != nil {
		return m.GlRepository
	}
	return ""
}

func (m *Repository) GetGlProjectPath() string {
	if m != nil {
		return m.GlProjectPath
	}
	return ""
}

// Corresponds to Gitlab::Git::Commit
type GitCommit struct {
	Id        string        `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Subject   []byte        `protobuf:"bytes,2,opt,name=subject,proto3" json:"subject,omitempty"`
	Body      []byte        `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`
	Author    *CommitAuthor `protobuf:"bytes,4,opt,name=author" json:"author,omitempty"`
	Committer *CommitAuthor `protobuf:"bytes,5,opt,name=committer" json:"committer,omitempty"`
	ParentIds []string      `protobuf:"bytes,6,rep,name=parent_ids,json=parentIds" json:"parent_ids,omitempty"`
	// If body exceeds a certain threshold, it will be nullified,
	// but its size will be set in body_size so we can know if
	// a commit had a body in the first place.
	BodySize int64 `protobuf:"varint,7,opt,name=body_size,json=bodySize" json:"body_size,omitempty"`
}

func (m *GitCommit) Reset()                    { *m = GitCommit{} }
func (m *GitCommit) String() string            { return proto.CompactTextString(m) }
func (*GitCommit) ProtoMessage()               {}
func (*GitCommit) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{1} }

func (m *GitCommit) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *GitCommit) GetSubject() []byte {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *GitCommit) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

func (m *GitCommit) GetAuthor() *CommitAuthor {
	if m != nil {
		return m.Author
	}
	return nil
}

func (m *GitCommit) GetCommitter() *CommitAuthor {
	if m != nil {
		return m.Committer
	}
	return nil
}

func (m *GitCommit) GetParentIds() []string {
	if m != nil {
		return m.ParentIds
	}
	return nil
}

func (m *GitCommit) GetBodySize() int64 {
	if m != nil {
		return m.BodySize
	}
	return 0
}

type CommitAuthor struct {
	Name  []byte                     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Email []byte                     `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	Date  *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=date" json:"date,omitempty"`
}

func (m *CommitAuthor) Reset()                    { *m = CommitAuthor{} }
func (m *CommitAuthor) String() string            { return proto.CompactTextString(m) }
func (*CommitAuthor) ProtoMessage()               {}
func (*CommitAuthor) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{2} }

func (m *CommitAuthor) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CommitAuthor) GetEmail() []byte {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *CommitAuthor) GetDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.Date
	}
	return nil
}

type ExitStatus struct {
	Value int32 `protobuf:"varint,1,opt,name=value" json:"value,omitempty"`
}

func (m *ExitStatus) Reset()                    { *m = ExitStatus{} }
func (m *ExitStatus) String() string            { return proto.CompactTextString(m) }
func (*ExitStatus) ProtoMessage()               {}
func (*ExitStatus) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{3} }

func (m *ExitStatus) GetValue() int32 {
	if m != nil {
		return m.Value
	}
	return 0
}

// Corresponds to Gitlab::Git::Branch
type Branch struct {
	Name         []byte     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	TargetCommit *GitCommit `protobuf:"bytes,2,opt,name=target_commit,json=targetCommit" json:"target_commit,omitempty"`
}

func (m *Branch) Reset()                    { *m = Branch{} }
func (m *Branch) String() string            { return proto.CompactTextString(m) }
func (*Branch) ProtoMessage()               {}
func (*Branch) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{4} }

func (m *Branch) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Branch) GetTargetCommit() *GitCommit {
	if m != nil {
		return m.TargetCommit
	}
	return nil
}

type Tag struct {
	Name         []byte     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Id           string     `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	TargetCommit *GitCommit `protobuf:"bytes,3,opt,name=target_commit,json=targetCommit" json:"target_commit,omitempty"`
	// If message exceeds a certain threshold, it will be nullified,
	// but its size will be set in message_size so we can know if
	// a tag had a message in the first place.
	Message     []byte        `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	MessageSize int64         `protobuf:"varint,5,opt,name=message_size,json=messageSize" json:"message_size,omitempty"`
	Tagger      *CommitAuthor `protobuf:"bytes,6,opt,name=tagger" json:"tagger,omitempty"`
}

func (m *Tag) Reset()                    { *m = Tag{} }
func (m *Tag) String() string            { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()               {}
func (*Tag) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{5} }

func (m *Tag) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Tag) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Tag) GetTargetCommit() *GitCommit {
	if m != nil {
		return m.TargetCommit
	}
	return nil
}

func (m *Tag) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Tag) GetMessageSize() int64 {
	if m != nil {
		return m.MessageSize
	}
	return 0
}

func (m *Tag) GetTagger() *CommitAuthor {
	if m != nil {
		return m.Tagger
	}
	return nil
}

type User struct {
	GlId       string `protobuf:"bytes,1,opt,name=gl_id,json=glId" json:"gl_id,omitempty"`
	Name       []byte `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Email      []byte `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
	GlUsername string `protobuf:"bytes,4,opt,name=gl_username,json=glUsername" json:"gl_username,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor13, []int{6} }

func (m *User) GetGlId() string {
	if m != nil {
		return m.GlId
	}
	return ""
}

func (m *User) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *User) GetEmail() []byte {
	if m != nil {
		return m.Email
	}
	return nil
}

func (m *User) GetGlUsername() string {
	if m != nil {
		return m.GlUsername
	}
	return ""
}

func init() {
	proto.RegisterType((*Repository)(nil), "gitaly.Repository")
	proto.RegisterType((*GitCommit)(nil), "gitaly.GitCommit")
	proto.RegisterType((*CommitAuthor)(nil), "gitaly.CommitAuthor")
	proto.RegisterType((*ExitStatus)(nil), "gitaly.ExitStatus")
	proto.RegisterType((*Branch)(nil), "gitaly.Branch")
	proto.RegisterType((*Tag)(nil), "gitaly.Tag")
	proto.RegisterType((*User)(nil), "gitaly.User")
}

func init() { proto.RegisterFile("shared.proto", fileDescriptor13) }

var fileDescriptor13 = []byte{
	// 603 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x51, 0x6f, 0xd3, 0x3c,
	0x14, 0x55, 0xd2, 0xb4, 0x6b, 0x6f, 0xb3, 0xef, 0x1b, 0x66, 0x0f, 0xd1, 0xd0, 0xb4, 0x12, 0x24,
	0xb4, 0x07, 0x94, 0xa1, 0x22, 0xf1, 0xbe, 0x01, 0x9a, 0xb6, 0x07, 0x98, 0xb2, 0xed, 0x85, 0x97,
	0xc8, 0x6d, 0xee, 0x5c, 0x23, 0xa7, 0x89, 0xec, 0xdb, 0x89, 0xed, 0x47, 0xf1, 0x4b, 0xf8, 0x1f,
	0xfc, 0x0d, 0x64, 0x3b, 0x29, 0x03, 0x0a, 0xe2, 0xcd, 0x3e, 0x3e, 0xbe, 0xbe, 0xe7, 0x9e, 0x63,
	0x88, 0xcd, 0x82, 0x6b, 0x2c, 0xb3, 0x46, 0xd7, 0x54, 0xb3, 0x81, 0x90, 0xc4, 0xd5, 0xdd, 0xde,
	0x81, 0xa8, 0x6b, 0xa1, 0xf0, 0xc8, 0xa1, 0xb3, 0xd5, 0xcd, 0x11, 0xc9, 0x0a, 0x0d, 0xf1, 0xaa,
	0xf1, 0xc4, 0xf4, 0x4b, 0x08, 0x90, 0x63, 0x53, 0x1b, 0x49, 0xb5, 0xbe, 0x63, 0x4f, 0x21, 0x36,
	0x54, 0x6b, 0x2e, 0xb0, 0x58, 0xf2, 0x0a, 0x93, 0x70, 0x12, 0x1c, 0x8e, 0xf2, 0x71, 0x8b, 0xbd,
	0xe7, 0x15, 0xb2, 0x67, 0xb0, 0xad, 0x51, 0x71, 0x92, 0xb7, 0x58, 0x34, 0x9c, 0x16, 0x49, 0xcf,
	0x71, 0xe2, 0x0e, 0xbc, 0xe0, 0xb4, 0x60, 0x2f, 0x61, 0x57, 0x48, 0x2a, 0xea, 0xd9, 0x27, 0x9c,
	0x53, 0x51, 0x4a, 0x8d, 0x73, 0x5b, 0x3f, 0x89, 0x1c, 0x97, 0x09, 0x49, 0x1f, 0xdc, 0xd1, 0xdb,
	0xee, 0x84, 0x9d, 0xc2, 0xc4, 0xde, 0xe0, 0x8a, 0x50, 0x2f, 0x39, 0xe1, 0xaf, 0x77, 0x25, 0x9a,
	0xa4, 0x3f, 0xe9, 0x1d, 0x8e, 0xf2, 0x7d, 0x21, 0xe9, 0xb8, 0xa3, 0xfd, 0x5c, 0x46, 0xa2, 0xb1,
	0xfd, 0x09, 0x55, 0xe8, 0xb5, 0xa6, 0x64, 0xe0, 0xfb, 0x13, 0xea, 0x81, 0xce, 0xe7, 0xf0, 0xbf,
	0x50, 0x45, 0xa3, 0x6b, 0xf7, 0x86, 0x93, 0x31, 0x74, 0xb4, 0x6d, 0xa1, 0x2e, 0x3c, 0x6a, 0x75,
	0x9c, 0x47, 0xc3, 0x60, 0x27, 0x3c, 0x8f, 0x86, 0x5b, 0x3b, 0xc3, 0x3c, 0xb2, 0xb4, 0xf4, 0x5b,
	0x00, 0xa3, 0x53, 0x49, 0x6f, 0xea, 0xaa, 0x92, 0xc4, 0xfe, 0x83, 0x50, 0x96, 0x49, 0xe0, 0xae,
	0x86, 0xb2, 0x64, 0x09, 0x6c, 0x99, 0x95, 0x6b, 0xc9, 0x8d, 0x2e, 0xce, 0xbb, 0x2d, 0x63, 0x10,
	0xcd, 0xea, 0xf2, 0xce, 0x4d, 0x2b, 0xce, 0xdd, 0x9a, 0xbd, 0x80, 0x01, 0x5f, 0xd1, 0xa2, 0xd6,
	0x6e, 0x2e, 0xe3, 0xe9, 0x6e, 0xe6, 0x6d, 0xcb, 0x7c, 0xf5, 0x63, 0x77, 0x96, 0xb7, 0x1c, 0x36,
	0x85, 0xd1, 0xdc, 0xe1, 0x84, 0x3a, 0xe9, 0xff, 0xe5, 0xc2, 0x0f, 0x1a, 0xdb, 0x07, 0x68, 0xb8,
	0xc6, 0x25, 0x15, 0xb2, 0x34, 0xc9, 0xc0, 0xcd, 0x6f, 0xe4, 0x91, 0xb3, 0xd2, 0xb0, 0x27, 0x30,
	0xb2, 0x8d, 0x14, 0x46, 0xde, 0x63, 0xb2, 0x35, 0x09, 0x0e, 0x7b, 0xf9, 0xd0, 0x02, 0x97, 0xf2,
	0x1e, 0xd3, 0x05, 0xc4, 0x0f, 0xcb, 0x5a, 0x05, 0x2e, 0x13, 0x81, 0x57, 0x60, 0xd7, 0x6c, 0x17,
	0xfa, 0x58, 0x71, 0xa9, 0x5a, 0xb5, 0x7e, 0xc3, 0x32, 0x88, 0x4a, 0x4e, 0xe8, 0xb4, 0x8e, 0xa7,
	0x7b, 0x99, 0x0f, 0x61, 0xd6, 0x85, 0x30, 0xbb, 0xea, 0x42, 0x98, 0x3b, 0x5e, 0x9a, 0x02, 0xbc,
	0xfb, 0x2c, 0xe9, 0x92, 0x38, 0xad, 0x8c, 0xad, 0x79, 0xcb, 0xd5, 0xca, 0x3f, 0xd4, 0xcf, 0xfd,
	0x26, 0xbd, 0x82, 0xc1, 0x89, 0xe6, 0xcb, 0xf9, 0x62, 0x63, 0x1f, 0xaf, 0x61, 0x9b, 0xb8, 0x16,
	0x48, 0x85, 0xd7, 0xee, 0xfa, 0x19, 0x4f, 0x1f, 0x75, 0xf3, 0x59, 0x3b, 0x96, 0xc7, 0x9e, 0xe7,
	0x77, 0xe9, 0xd7, 0x00, 0x7a, 0x57, 0x5c, 0x6c, 0xac, 0xe9, 0xbd, 0x0d, 0xd7, 0xde, 0xfe, 0xf6,
	0x46, 0xef, 0x9f, 0xde, 0xb0, 0x99, 0xa8, 0xd0, 0x18, 0x2e, 0xd0, 0xd9, 0x1c, 0xe7, 0xdd, 0xd6,
	0xfe, 0xb6, 0x76, 0xe9, 0x1d, 0xe8, 0x3b, 0x07, 0xc6, 0x2d, 0x66, 0x4d, 0xb0, 0x11, 0x21, 0x2e,
	0x04, 0x6a, 0x17, 0xe3, 0x3f, 0x46, 0xc4, 0x73, 0xd2, 0x1b, 0x88, 0xae, 0x0d, 0x6a, 0xf6, 0x18,
	0xfa, 0x42, 0x15, 0xeb, 0x64, 0x46, 0x42, 0x9d, 0x95, 0x6b, 0x8d, 0xe1, 0x26, 0xff, 0x7a, 0x0f,
	0xfd, 0x3b, 0x80, 0xb1, 0x50, 0xc5, 0xca, 0xd8, 0x2f, 0x56, 0x61, 0xfb, 0x69, 0x41, 0xa8, 0xeb,
	0x16, 0x39, 0x81, 0x8f, 0x43, 0xdf, 0x46, 0x33, 0x9b, 0x0d, 0x9c, 0xad, 0xaf, 0xbe, 0x07, 0x00,
	0x00, 0xff, 0xff, 0x70, 0x8f, 0xde, 0xf3, 0x81, 0x04, 0x00, 0x00,
}
