// Code generated by protoc-gen-go. DO NOT EDIT.
// source: diff.proto

package gitalypb // import "gitlab.com/gitlab-org/gitaly-proto/go/gitalypb"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type CommitDiffRequest struct {
	Repository             *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId           string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId          string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	IgnoreWhitespaceChange bool        `protobuf:"varint,4,opt,name=ignore_whitespace_change,json=ignoreWhitespaceChange,proto3" json:"ignore_whitespace_change,omitempty"`
	Paths                  [][]byte    `protobuf:"bytes,5,rep,name=paths,proto3" json:"paths,omitempty"`
	CollapseDiffs          bool        `protobuf:"varint,6,opt,name=collapse_diffs,json=collapseDiffs,proto3" json:"collapse_diffs,omitempty"`
	EnforceLimits          bool        `protobuf:"varint,7,opt,name=enforce_limits,json=enforceLimits,proto3" json:"enforce_limits,omitempty"`
	// These limits are only enforced when enforce_limits == true.
	MaxFiles int32 `protobuf:"varint,8,opt,name=max_files,json=maxFiles,proto3" json:"max_files,omitempty"`
	MaxLines int32 `protobuf:"varint,9,opt,name=max_lines,json=maxLines,proto3" json:"max_lines,omitempty"`
	MaxBytes int32 `protobuf:"varint,10,opt,name=max_bytes,json=maxBytes,proto3" json:"max_bytes,omitempty"`
	// Limitation of a single diff patch,
	// patches surpassing this limit are pruned by default.
	// If this is 0 you will get back empty patches.
	MaxPatchBytes int32 `protobuf:"varint,14,opt,name=max_patch_bytes,json=maxPatchBytes,proto3" json:"max_patch_bytes,omitempty"`
	// These limits are only enforced if collapse_diffs == true.
	SafeMaxFiles         int32    `protobuf:"varint,11,opt,name=safe_max_files,json=safeMaxFiles,proto3" json:"safe_max_files,omitempty"`
	SafeMaxLines         int32    `protobuf:"varint,12,opt,name=safe_max_lines,json=safeMaxLines,proto3" json:"safe_max_lines,omitempty"`
	SafeMaxBytes         int32    `protobuf:"varint,13,opt,name=safe_max_bytes,json=safeMaxBytes,proto3" json:"safe_max_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitDiffRequest) Reset()         { *m = CommitDiffRequest{} }
func (m *CommitDiffRequest) String() string { return proto.CompactTextString(m) }
func (*CommitDiffRequest) ProtoMessage()    {}
func (*CommitDiffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{0}
}
func (m *CommitDiffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDiffRequest.Unmarshal(m, b)
}
func (m *CommitDiffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDiffRequest.Marshal(b, m, deterministic)
}
func (dst *CommitDiffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDiffRequest.Merge(dst, src)
}
func (m *CommitDiffRequest) XXX_Size() int {
	return xxx_messageInfo_CommitDiffRequest.Size(m)
}
func (m *CommitDiffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDiffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDiffRequest proto.InternalMessageInfo

func (m *CommitDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDiffRequest) GetIgnoreWhitespaceChange() bool {
	if m != nil {
		return m.IgnoreWhitespaceChange
	}
	return false
}

func (m *CommitDiffRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *CommitDiffRequest) GetCollapseDiffs() bool {
	if m != nil {
		return m.CollapseDiffs
	}
	return false
}

func (m *CommitDiffRequest) GetEnforceLimits() bool {
	if m != nil {
		return m.EnforceLimits
	}
	return false
}

func (m *CommitDiffRequest) GetMaxFiles() int32 {
	if m != nil {
		return m.MaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxLines() int32 {
	if m != nil {
		return m.MaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxBytes() int32 {
	if m != nil {
		return m.MaxBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetMaxPatchBytes() int32 {
	if m != nil {
		return m.MaxPatchBytes
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxFiles() int32 {
	if m != nil {
		return m.SafeMaxFiles
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxLines() int32 {
	if m != nil {
		return m.SafeMaxLines
	}
	return 0
}

func (m *CommitDiffRequest) GetSafeMaxBytes() int32 {
	if m != nil {
		return m.SafeMaxBytes
	}
	return 0
}

// A CommitDiffResponse corresponds to a single changed file in a commit.
type CommitDiffResponse struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId       string `protobuf:"bytes,3,opt,name=from_id,json=fromId,proto3" json:"from_id,omitempty"`
	ToId         string `protobuf:"bytes,4,opt,name=to_id,json=toId,proto3" json:"to_id,omitempty"`
	OldMode      int32  `protobuf:"varint,5,opt,name=old_mode,json=oldMode,proto3" json:"old_mode,omitempty"`
	NewMode      int32  `protobuf:"varint,6,opt,name=new_mode,json=newMode,proto3" json:"new_mode,omitempty"`
	Binary       bool   `protobuf:"varint,7,opt,name=binary,proto3" json:"binary,omitempty"`
	RawPatchData []byte `protobuf:"bytes,9,opt,name=raw_patch_data,json=rawPatchData,proto3" json:"raw_patch_data,omitempty"`
	EndOfPatch   bool   `protobuf:"varint,10,opt,name=end_of_patch,json=endOfPatch,proto3" json:"end_of_patch,omitempty"`
	// Indicates the diff file at which we overflow according to the limitations sent,
	// in which case only this attribute will be set.
	OverflowMarker bool `protobuf:"varint,11,opt,name=overflow_marker,json=overflowMarker,proto3" json:"overflow_marker,omitempty"`
	// Indicates the patch surpassed a "safe" limit and was therefore pruned, but
	// the client may still request the full patch on a separate request.
	Collapsed bool `protobuf:"varint,12,opt,name=collapsed,proto3" json:"collapsed,omitempty"`
	// Indicates the patch was pruned since it surpassed a hard limit, and can
	// therefore not be expanded.
	TooLarge             bool     `protobuf:"varint,13,opt,name=too_large,json=tooLarge,proto3" json:"too_large,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitDiffResponse) Reset()         { *m = CommitDiffResponse{} }
func (m *CommitDiffResponse) String() string { return proto.CompactTextString(m) }
func (*CommitDiffResponse) ProtoMessage()    {}
func (*CommitDiffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{1}
}
func (m *CommitDiffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDiffResponse.Unmarshal(m, b)
}
func (m *CommitDiffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDiffResponse.Marshal(b, m, deterministic)
}
func (dst *CommitDiffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDiffResponse.Merge(dst, src)
}
func (m *CommitDiffResponse) XXX_Size() int {
	return xxx_messageInfo_CommitDiffResponse.Size(m)
}
func (m *CommitDiffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDiffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDiffResponse proto.InternalMessageInfo

func (m *CommitDiffResponse) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDiffResponse) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDiffResponse) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDiffResponse) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDiffResponse) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDiffResponse) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

func (m *CommitDiffResponse) GetBinary() bool {
	if m != nil {
		return m.Binary
	}
	return false
}

func (m *CommitDiffResponse) GetRawPatchData() []byte {
	if m != nil {
		return m.RawPatchData
	}
	return nil
}

func (m *CommitDiffResponse) GetEndOfPatch() bool {
	if m != nil {
		return m.EndOfPatch
	}
	return false
}

func (m *CommitDiffResponse) GetOverflowMarker() bool {
	if m != nil {
		return m.OverflowMarker
	}
	return false
}

func (m *CommitDiffResponse) GetCollapsed() bool {
	if m != nil {
		return m.Collapsed
	}
	return false
}

func (m *CommitDiffResponse) GetTooLarge() bool {
	if m != nil {
		return m.TooLarge
	}
	return false
}

type CommitDeltaRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	Paths                [][]byte    `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CommitDeltaRequest) Reset()         { *m = CommitDeltaRequest{} }
func (m *CommitDeltaRequest) String() string { return proto.CompactTextString(m) }
func (*CommitDeltaRequest) ProtoMessage()    {}
func (*CommitDeltaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{2}
}
func (m *CommitDeltaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDeltaRequest.Unmarshal(m, b)
}
func (m *CommitDeltaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDeltaRequest.Marshal(b, m, deterministic)
}
func (dst *CommitDeltaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDeltaRequest.Merge(dst, src)
}
func (m *CommitDeltaRequest) XXX_Size() int {
	return xxx_messageInfo_CommitDeltaRequest.Size(m)
}
func (m *CommitDeltaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDeltaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDeltaRequest proto.InternalMessageInfo

func (m *CommitDeltaRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitDeltaRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

func (m *CommitDeltaRequest) GetPaths() [][]byte {
	if m != nil {
		return m.Paths
	}
	return nil
}

type CommitDelta struct {
	FromPath []byte `protobuf:"bytes,1,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	ToPath   []byte `protobuf:"bytes,2,opt,name=to_path,json=toPath,proto3" json:"to_path,omitempty"`
	// Blob ID as returned via `git diff --full-index`
	FromId               string   `protobuf:"bytes,3,opt,name=from_id,json=fromId,proto3" json:"from_id,omitempty"`
	ToId                 string   `protobuf:"bytes,4,opt,name=to_id,json=toId,proto3" json:"to_id,omitempty"`
	OldMode              int32    `protobuf:"varint,5,opt,name=old_mode,json=oldMode,proto3" json:"old_mode,omitempty"`
	NewMode              int32    `protobuf:"varint,6,opt,name=new_mode,json=newMode,proto3" json:"new_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitDelta) Reset()         { *m = CommitDelta{} }
func (m *CommitDelta) String() string { return proto.CompactTextString(m) }
func (*CommitDelta) ProtoMessage()    {}
func (*CommitDelta) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{3}
}
func (m *CommitDelta) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDelta.Unmarshal(m, b)
}
func (m *CommitDelta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDelta.Marshal(b, m, deterministic)
}
func (dst *CommitDelta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDelta.Merge(dst, src)
}
func (m *CommitDelta) XXX_Size() int {
	return xxx_messageInfo_CommitDelta.Size(m)
}
func (m *CommitDelta) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDelta.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDelta proto.InternalMessageInfo

func (m *CommitDelta) GetFromPath() []byte {
	if m != nil {
		return m.FromPath
	}
	return nil
}

func (m *CommitDelta) GetToPath() []byte {
	if m != nil {
		return m.ToPath
	}
	return nil
}

func (m *CommitDelta) GetFromId() string {
	if m != nil {
		return m.FromId
	}
	return ""
}

func (m *CommitDelta) GetToId() string {
	if m != nil {
		return m.ToId
	}
	return ""
}

func (m *CommitDelta) GetOldMode() int32 {
	if m != nil {
		return m.OldMode
	}
	return 0
}

func (m *CommitDelta) GetNewMode() int32 {
	if m != nil {
		return m.NewMode
	}
	return 0
}

type CommitDeltaResponse struct {
	Deltas               []*CommitDelta `protobuf:"bytes,1,rep,name=deltas,proto3" json:"deltas,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommitDeltaResponse) Reset()         { *m = CommitDeltaResponse{} }
func (m *CommitDeltaResponse) String() string { return proto.CompactTextString(m) }
func (*CommitDeltaResponse) ProtoMessage()    {}
func (*CommitDeltaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{4}
}
func (m *CommitDeltaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitDeltaResponse.Unmarshal(m, b)
}
func (m *CommitDeltaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitDeltaResponse.Marshal(b, m, deterministic)
}
func (dst *CommitDeltaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitDeltaResponse.Merge(dst, src)
}
func (m *CommitDeltaResponse) XXX_Size() int {
	return xxx_messageInfo_CommitDeltaResponse.Size(m)
}
func (m *CommitDeltaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitDeltaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitDeltaResponse proto.InternalMessageInfo

func (m *CommitDeltaResponse) GetDeltas() []*CommitDelta {
	if m != nil {
		return m.Deltas
	}
	return nil
}

type CommitPatchRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	Revision             []byte      `protobuf:"bytes,2,opt,name=revision,proto3" json:"revision,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CommitPatchRequest) Reset()         { *m = CommitPatchRequest{} }
func (m *CommitPatchRequest) String() string { return proto.CompactTextString(m) }
func (*CommitPatchRequest) ProtoMessage()    {}
func (*CommitPatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{5}
}
func (m *CommitPatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitPatchRequest.Unmarshal(m, b)
}
func (m *CommitPatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitPatchRequest.Marshal(b, m, deterministic)
}
func (dst *CommitPatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitPatchRequest.Merge(dst, src)
}
func (m *CommitPatchRequest) XXX_Size() int {
	return xxx_messageInfo_CommitPatchRequest.Size(m)
}
func (m *CommitPatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitPatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitPatchRequest proto.InternalMessageInfo

func (m *CommitPatchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *CommitPatchRequest) GetRevision() []byte {
	if m != nil {
		return m.Revision
	}
	return nil
}

type CommitPatchResponse struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitPatchResponse) Reset()         { *m = CommitPatchResponse{} }
func (m *CommitPatchResponse) String() string { return proto.CompactTextString(m) }
func (*CommitPatchResponse) ProtoMessage()    {}
func (*CommitPatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{6}
}
func (m *CommitPatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitPatchResponse.Unmarshal(m, b)
}
func (m *CommitPatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitPatchResponse.Marshal(b, m, deterministic)
}
func (dst *CommitPatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitPatchResponse.Merge(dst, src)
}
func (m *CommitPatchResponse) XXX_Size() int {
	return xxx_messageInfo_CommitPatchResponse.Size(m)
}
func (m *CommitPatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitPatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitPatchResponse proto.InternalMessageInfo

func (m *CommitPatchResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawDiffRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawDiffRequest) Reset()         { *m = RawDiffRequest{} }
func (m *RawDiffRequest) String() string { return proto.CompactTextString(m) }
func (*RawDiffRequest) ProtoMessage()    {}
func (*RawDiffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{7}
}
func (m *RawDiffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawDiffRequest.Unmarshal(m, b)
}
func (m *RawDiffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawDiffRequest.Marshal(b, m, deterministic)
}
func (dst *RawDiffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDiffRequest.Merge(dst, src)
}
func (m *RawDiffRequest) XXX_Size() int {
	return xxx_messageInfo_RawDiffRequest.Size(m)
}
func (m *RawDiffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDiffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawDiffRequest proto.InternalMessageInfo

func (m *RawDiffRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawDiffRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *RawDiffRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type RawDiffResponse struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawDiffResponse) Reset()         { *m = RawDiffResponse{} }
func (m *RawDiffResponse) String() string { return proto.CompactTextString(m) }
func (*RawDiffResponse) ProtoMessage()    {}
func (*RawDiffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{8}
}
func (m *RawDiffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawDiffResponse.Unmarshal(m, b)
}
func (m *RawDiffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawDiffResponse.Marshal(b, m, deterministic)
}
func (dst *RawDiffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDiffResponse.Merge(dst, src)
}
func (m *RawDiffResponse) XXX_Size() int {
	return xxx_messageInfo_RawDiffResponse.Size(m)
}
func (m *RawDiffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDiffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawDiffResponse proto.InternalMessageInfo

func (m *RawDiffResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawPatchRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawPatchRequest) Reset()         { *m = RawPatchRequest{} }
func (m *RawPatchRequest) String() string { return proto.CompactTextString(m) }
func (*RawPatchRequest) ProtoMessage()    {}
func (*RawPatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{9}
}
func (m *RawPatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawPatchRequest.Unmarshal(m, b)
}
func (m *RawPatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawPatchRequest.Marshal(b, m, deterministic)
}
func (dst *RawPatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPatchRequest.Merge(dst, src)
}
func (m *RawPatchRequest) XXX_Size() int {
	return xxx_messageInfo_RawPatchRequest.Size(m)
}
func (m *RawPatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawPatchRequest proto.InternalMessageInfo

func (m *RawPatchRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *RawPatchRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *RawPatchRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type RawPatchResponse struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawPatchResponse) Reset()         { *m = RawPatchResponse{} }
func (m *RawPatchResponse) String() string { return proto.CompactTextString(m) }
func (*RawPatchResponse) ProtoMessage()    {}
func (*RawPatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{10}
}
func (m *RawPatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawPatchResponse.Unmarshal(m, b)
}
func (m *RawPatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawPatchResponse.Marshal(b, m, deterministic)
}
func (dst *RawPatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPatchResponse.Merge(dst, src)
}
func (m *RawPatchResponse) XXX_Size() int {
	return xxx_messageInfo_RawPatchResponse.Size(m)
}
func (m *RawPatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawPatchResponse proto.InternalMessageInfo

func (m *RawPatchResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type DiffStatsRequest struct {
	Repository           *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	LeftCommitId         string      `protobuf:"bytes,2,opt,name=left_commit_id,json=leftCommitId,proto3" json:"left_commit_id,omitempty"`
	RightCommitId        string      `protobuf:"bytes,3,opt,name=right_commit_id,json=rightCommitId,proto3" json:"right_commit_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *DiffStatsRequest) Reset()         { *m = DiffStatsRequest{} }
func (m *DiffStatsRequest) String() string { return proto.CompactTextString(m) }
func (*DiffStatsRequest) ProtoMessage()    {}
func (*DiffStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{11}
}
func (m *DiffStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiffStatsRequest.Unmarshal(m, b)
}
func (m *DiffStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiffStatsRequest.Marshal(b, m, deterministic)
}
func (dst *DiffStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiffStatsRequest.Merge(dst, src)
}
func (m *DiffStatsRequest) XXX_Size() int {
	return xxx_messageInfo_DiffStatsRequest.Size(m)
}
func (m *DiffStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DiffStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DiffStatsRequest proto.InternalMessageInfo

func (m *DiffStatsRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *DiffStatsRequest) GetLeftCommitId() string {
	if m != nil {
		return m.LeftCommitId
	}
	return ""
}

func (m *DiffStatsRequest) GetRightCommitId() string {
	if m != nil {
		return m.RightCommitId
	}
	return ""
}

type DiffStats struct {
	Path                 []byte   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Additions            int32    `protobuf:"varint,2,opt,name=additions,proto3" json:"additions,omitempty"`
	Deletions            int32    `protobuf:"varint,3,opt,name=deletions,proto3" json:"deletions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiffStats) Reset()         { *m = DiffStats{} }
func (m *DiffStats) String() string { return proto.CompactTextString(m) }
func (*DiffStats) ProtoMessage()    {}
func (*DiffStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{12}
}
func (m *DiffStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiffStats.Unmarshal(m, b)
}
func (m *DiffStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiffStats.Marshal(b, m, deterministic)
}
func (dst *DiffStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiffStats.Merge(dst, src)
}
func (m *DiffStats) XXX_Size() int {
	return xxx_messageInfo_DiffStats.Size(m)
}
func (m *DiffStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DiffStats.DiscardUnknown(m)
}

var xxx_messageInfo_DiffStats proto.InternalMessageInfo

func (m *DiffStats) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *DiffStats) GetAdditions() int32 {
	if m != nil {
		return m.Additions
	}
	return 0
}

func (m *DiffStats) GetDeletions() int32 {
	if m != nil {
		return m.Deletions
	}
	return 0
}

type DiffStatsResponse struct {
	Stats                []*DiffStats `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DiffStatsResponse) Reset()         { *m = DiffStatsResponse{} }
func (m *DiffStatsResponse) String() string { return proto.CompactTextString(m) }
func (*DiffStatsResponse) ProtoMessage()    {}
func (*DiffStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_diff_696f647dc4d0db76, []int{13}
}
func (m *DiffStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiffStatsResponse.Unmarshal(m, b)
}
func (m *DiffStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiffStatsResponse.Marshal(b, m, deterministic)
}
func (dst *DiffStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiffStatsResponse.Merge(dst, src)
}
func (m *DiffStatsResponse) XXX_Size() int {
	return xxx_messageInfo_DiffStatsResponse.Size(m)
}
func (m *DiffStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DiffStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DiffStatsResponse proto.InternalMessageInfo

func (m *DiffStatsResponse) GetStats() []*DiffStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func init() {
	proto.RegisterType((*CommitDiffRequest)(nil), "gitaly.CommitDiffRequest")
	proto.RegisterType((*CommitDiffResponse)(nil), "gitaly.CommitDiffResponse")
	proto.RegisterType((*CommitDeltaRequest)(nil), "gitaly.CommitDeltaRequest")
	proto.RegisterType((*CommitDelta)(nil), "gitaly.CommitDelta")
	proto.RegisterType((*CommitDeltaResponse)(nil), "gitaly.CommitDeltaResponse")
	proto.RegisterType((*CommitPatchRequest)(nil), "gitaly.CommitPatchRequest")
	proto.RegisterType((*CommitPatchResponse)(nil), "gitaly.CommitPatchResponse")
	proto.RegisterType((*RawDiffRequest)(nil), "gitaly.RawDiffRequest")
	proto.RegisterType((*RawDiffResponse)(nil), "gitaly.RawDiffResponse")
	proto.RegisterType((*RawPatchRequest)(nil), "gitaly.RawPatchRequest")
	proto.RegisterType((*RawPatchResponse)(nil), "gitaly.RawPatchResponse")
	proto.RegisterType((*DiffStatsRequest)(nil), "gitaly.DiffStatsRequest")
	proto.RegisterType((*DiffStats)(nil), "gitaly.DiffStats")
	proto.RegisterType((*DiffStatsResponse)(nil), "gitaly.DiffStatsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DiffServiceClient is the client API for DiffService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DiffServiceClient interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error)
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error)
	CommitPatch(ctx context.Context, in *CommitPatchRequest, opts ...grpc.CallOption) (DiffService_CommitPatchClient, error)
	RawDiff(ctx context.Context, in *RawDiffRequest, opts ...grpc.CallOption) (DiffService_RawDiffClient, error)
	RawPatch(ctx context.Context, in *RawPatchRequest, opts ...grpc.CallOption) (DiffService_RawPatchClient, error)
	DiffStats(ctx context.Context, in *DiffStatsRequest, opts ...grpc.CallOption) (DiffService_DiffStatsClient, error)
}

type diffServiceClient struct {
	cc *grpc.ClientConn
}

func NewDiffServiceClient(cc *grpc.ClientConn) DiffServiceClient {
	return &diffServiceClient{cc}
}

func (c *diffServiceClient) CommitDiff(ctx context.Context, in *CommitDiffRequest, opts ...grpc.CallOption) (DiffService_CommitDiffClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[0], "/gitaly.DiffService/CommitDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDiffClient interface {
	Recv() (*CommitDiffResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDiffClient) Recv() (*CommitDiffResponse, error) {
	m := new(CommitDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) CommitDelta(ctx context.Context, in *CommitDeltaRequest, opts ...grpc.CallOption) (DiffService_CommitDeltaClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[1], "/gitaly.DiffService/CommitDelta", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitDeltaClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitDeltaClient interface {
	Recv() (*CommitDeltaResponse, error)
	grpc.ClientStream
}

type diffServiceCommitDeltaClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitDeltaClient) Recv() (*CommitDeltaResponse, error) {
	m := new(CommitDeltaResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) CommitPatch(ctx context.Context, in *CommitPatchRequest, opts ...grpc.CallOption) (DiffService_CommitPatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[2], "/gitaly.DiffService/CommitPatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceCommitPatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_CommitPatchClient interface {
	Recv() (*CommitPatchResponse, error)
	grpc.ClientStream
}

type diffServiceCommitPatchClient struct {
	grpc.ClientStream
}

func (x *diffServiceCommitPatchClient) Recv() (*CommitPatchResponse, error) {
	m := new(CommitPatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) RawDiff(ctx context.Context, in *RawDiffRequest, opts ...grpc.CallOption) (DiffService_RawDiffClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[3], "/gitaly.DiffService/RawDiff", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceRawDiffClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_RawDiffClient interface {
	Recv() (*RawDiffResponse, error)
	grpc.ClientStream
}

type diffServiceRawDiffClient struct {
	grpc.ClientStream
}

func (x *diffServiceRawDiffClient) Recv() (*RawDiffResponse, error) {
	m := new(RawDiffResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) RawPatch(ctx context.Context, in *RawPatchRequest, opts ...grpc.CallOption) (DiffService_RawPatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[4], "/gitaly.DiffService/RawPatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceRawPatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_RawPatchClient interface {
	Recv() (*RawPatchResponse, error)
	grpc.ClientStream
}

type diffServiceRawPatchClient struct {
	grpc.ClientStream
}

func (x *diffServiceRawPatchClient) Recv() (*RawPatchResponse, error) {
	m := new(RawPatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *diffServiceClient) DiffStats(ctx context.Context, in *DiffStatsRequest, opts ...grpc.CallOption) (DiffService_DiffStatsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DiffService_serviceDesc.Streams[5], "/gitaly.DiffService/DiffStats", opts...)
	if err != nil {
		return nil, err
	}
	x := &diffServiceDiffStatsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DiffService_DiffStatsClient interface {
	Recv() (*DiffStatsResponse, error)
	grpc.ClientStream
}

type diffServiceDiffStatsClient struct {
	grpc.ClientStream
}

func (x *diffServiceDiffStatsClient) Recv() (*DiffStatsResponse, error) {
	m := new(DiffStatsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DiffServiceServer is the server API for DiffService service.
type DiffServiceServer interface {
	// Returns stream of CommitDiffResponse with patches chunked over messages
	CommitDiff(*CommitDiffRequest, DiffService_CommitDiffServer) error
	// Return a stream so we can divide the response in chunks of deltas
	CommitDelta(*CommitDeltaRequest, DiffService_CommitDeltaServer) error
	CommitPatch(*CommitPatchRequest, DiffService_CommitPatchServer) error
	RawDiff(*RawDiffRequest, DiffService_RawDiffServer) error
	RawPatch(*RawPatchRequest, DiffService_RawPatchServer) error
	DiffStats(*DiffStatsRequest, DiffService_DiffStatsServer) error
}

func RegisterDiffServiceServer(s *grpc.Server, srv DiffServiceServer) {
	s.RegisterService(&_DiffService_serviceDesc, srv)
}

func _DiffService_CommitDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDiff(m, &diffServiceCommitDiffServer{stream})
}

type DiffService_CommitDiffServer interface {
	Send(*CommitDiffResponse) error
	grpc.ServerStream
}

type diffServiceCommitDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDiffServer) Send(m *CommitDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_CommitDelta_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitDeltaRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitDelta(m, &diffServiceCommitDeltaServer{stream})
}

type DiffService_CommitDeltaServer interface {
	Send(*CommitDeltaResponse) error
	grpc.ServerStream
}

type diffServiceCommitDeltaServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitDeltaServer) Send(m *CommitDeltaResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_CommitPatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CommitPatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).CommitPatch(m, &diffServiceCommitPatchServer{stream})
}

type DiffService_CommitPatchServer interface {
	Send(*CommitPatchResponse) error
	grpc.ServerStream
}

type diffServiceCommitPatchServer struct {
	grpc.ServerStream
}

func (x *diffServiceCommitPatchServer) Send(m *CommitPatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_RawDiff_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawDiffRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).RawDiff(m, &diffServiceRawDiffServer{stream})
}

type DiffService_RawDiffServer interface {
	Send(*RawDiffResponse) error
	grpc.ServerStream
}

type diffServiceRawDiffServer struct {
	grpc.ServerStream
}

func (x *diffServiceRawDiffServer) Send(m *RawDiffResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_RawPatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RawPatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).RawPatch(m, &diffServiceRawPatchServer{stream})
}

type DiffService_RawPatchServer interface {
	Send(*RawPatchResponse) error
	grpc.ServerStream
}

type diffServiceRawPatchServer struct {
	grpc.ServerStream
}

func (x *diffServiceRawPatchServer) Send(m *RawPatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DiffService_DiffStats_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DiffStatsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DiffServiceServer).DiffStats(m, &diffServiceDiffStatsServer{stream})
}

type DiffService_DiffStatsServer interface {
	Send(*DiffStatsResponse) error
	grpc.ServerStream
}

type diffServiceDiffStatsServer struct {
	grpc.ServerStream
}

func (x *diffServiceDiffStatsServer) Send(m *DiffStatsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _DiffService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.DiffService",
	HandlerType: (*DiffServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "CommitDiff",
			Handler:       _DiffService_CommitDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitDelta",
			Handler:       _DiffService_CommitDelta_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CommitPatch",
			Handler:       _DiffService_CommitPatch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawDiff",
			Handler:       _DiffService_RawDiff_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RawPatch",
			Handler:       _DiffService_RawPatch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "DiffStats",
			Handler:       _DiffService_DiffStats_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "diff.proto",
}

func init() { proto.RegisterFile("diff.proto", fileDescriptor_diff_696f647dc4d0db76) }

var fileDescriptor_diff_696f647dc4d0db76 = []byte{
	// 909 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0xc6, 0x4d, 0xe2, 0x3a, 0x2f, 0x6e, 0xda, 0x4e, 0x51, 0xd7, 0xcd, 0x72, 0x88, 0xa2, 0xfd,
	0x11, 0x84, 0xb6, 0x5d, 0x95, 0x0b, 0x42, 0x08, 0x89, 0x6e, 0x05, 0xea, 0xaa, 0x15, 0x2b, 0x73,
	0x40, 0x82, 0x83, 0x35, 0xc9, 0x8c, 0x93, 0x11, 0xb6, 0x27, 0xcc, 0x0c, 0x4d, 0xfb, 0x97, 0x20,
	0x01, 0x77, 0x2e, 0x1c, 0x91, 0xf8, 0xbf, 0x38, 0x71, 0x44, 0xf3, 0xc6, 0x76, 0x9c, 0x36, 0xda,
	0xcb, 0x6a, 0xa5, 0xde, 0x3c, 0xdf, 0xf7, 0xf9, 0xcd, 0xfb, 0xf1, 0x3d, 0x27, 0x00, 0x4c, 0xa4,
	0xe9, 0xf1, 0x42, 0x49, 0x23, 0x89, 0x3f, 0x13, 0x86, 0x66, 0xb7, 0x83, 0x50, 0xcf, 0xa9, 0xe2,
	0xcc, 0xa1, 0xa3, 0xbf, 0xda, 0xb0, 0xff, 0x4a, 0xe6, 0xb9, 0x30, 0xe7, 0x22, 0x4d, 0x63, 0xfe,
	0xf3, 0x2f, 0x5c, 0x1b, 0x72, 0x0a, 0xa0, 0xf8, 0x42, 0x6a, 0x61, 0xa4, 0xba, 0x8d, 0xbc, 0xa1,
	0x37, 0xee, 0x9d, 0x92, 0x63, 0x17, 0xe0, 0x38, 0xae, 0x99, 0xb8, 0xa1, 0x22, 0x4f, 0xa0, 0x9f,
	0xf1, 0xd4, 0x24, 0x53, 0x8c, 0x96, 0x08, 0x16, 0x6d, 0x0d, 0xbd, 0x71, 0x37, 0x0e, 0x2d, 0xea,
	0xae, 0xb8, 0x60, 0xe4, 0x19, 0xec, 0x2a, 0x31, 0x9b, 0x37, 0x65, 0x2d, 0x94, 0xed, 0x20, 0x5c,
	0xeb, 0x3e, 0x83, 0x48, 0xcc, 0x0a, 0xa9, 0x78, 0xb2, 0x9c, 0x0b, 0xc3, 0xf5, 0x82, 0x4e, 0x79,
	0x32, 0x9d, 0xd3, 0x62, 0xc6, 0xa3, 0xf6, 0xd0, 0x1b, 0x07, 0xf1, 0xa1, 0xe3, 0xbf, 0xaf, 0xe9,
	0x57, 0xc8, 0x92, 0x0f, 0xa1, 0xb3, 0xa0, 0x66, 0xae, 0xa3, 0xce, 0xb0, 0x35, 0x0e, 0x63, 0x77,
	0x20, 0x4f, 0xa1, 0x3f, 0x95, 0x59, 0x46, 0x17, 0x9a, 0x27, 0xb6, 0x29, 0x3a, 0xf2, 0x31, 0xca,
	0x4e, 0x85, 0xda, 0xf2, 0x51, 0xc6, 0x8b, 0x54, 0xaa, 0x29, 0x4f, 0x32, 0x91, 0x0b, 0xa3, 0xa3,
	0x6d, 0x27, 0x2b, 0xd1, 0x4b, 0x04, 0xc9, 0x63, 0xe8, 0xe6, 0xf4, 0x26, 0x49, 0x45, 0xc6, 0x75,
	0x14, 0x0c, 0xbd, 0x71, 0x27, 0x0e, 0x72, 0x7a, 0xf3, 0xb5, 0x3d, 0x57, 0x64, 0x26, 0x0a, 0xae,
	0xa3, 0x6e, 0x4d, 0x5e, 0xda, 0x73, 0x45, 0x4e, 0x6e, 0x0d, 0xd7, 0x11, 0xd4, 0xe4, 0x99, 0x3d,
	0xdb, 0xe6, 0x58, 0x72, 0x41, 0xcd, 0x74, 0x5e, 0x4a, 0xfa, 0x28, 0xd9, 0xc9, 0xe9, 0xcd, 0x1b,
	0x8b, 0x3a, 0xdd, 0x13, 0xe8, 0x6b, 0x9a, 0xf2, 0x64, 0x95, 0x43, 0x0f, 0x65, 0xa1, 0x45, 0xaf,
	0xaa, 0x3c, 0x9a, 0x2a, 0x97, 0x4c, 0xb8, 0xa6, 0x72, 0x09, 0x35, 0x55, 0xee, 0xca, 0x9d, 0x35,
	0x15, 0xde, 0xf8, 0xb9, 0xff, 0xef, 0xaf, 0xe3, 0xad, 0x60, 0x6b, 0xf4, 0xdf, 0x16, 0x90, 0xa6,
	0x5d, 0xf4, 0x42, 0x16, 0x9a, 0xdb, 0xaa, 0x52, 0x25, 0x73, 0x9b, 0xf9, 0x1c, 0xed, 0x12, 0xc6,
	0x81, 0x05, 0xde, 0x50, 0x33, 0x27, 0x8f, 0x60, 0xdb, 0x48, 0x47, 0x6d, 0x21, 0xe5, 0x1b, 0x59,
	0x11, 0xf8, 0x56, 0xed, 0x01, 0xdf, 0x1e, 0x2f, 0x18, 0x39, 0x80, 0x8e, 0x91, 0x16, 0x6e, 0x23,
	0xdc, 0x36, 0xf2, 0x82, 0x91, 0x23, 0x08, 0x64, 0xc6, 0x92, 0x5c, 0x32, 0x1e, 0x75, 0x30, 0xc5,
	0x6d, 0x99, 0xb1, 0x2b, 0xc9, 0xb8, 0xa5, 0x0a, 0xbe, 0x74, 0x94, 0xef, 0xa8, 0x82, 0x2f, 0x91,
	0x3a, 0x04, 0x7f, 0x22, 0x0a, 0xaa, 0x6e, 0xcb, 0x41, 0x96, 0x27, 0x5b, 0xb6, 0xa2, 0xcb, 0xb2,
	0xd5, 0x8c, 0x1a, 0x8a, 0x93, 0x0a, 0xe3, 0x50, 0xd1, 0x25, 0x76, 0xfa, 0x9c, 0x1a, 0x4a, 0x86,
	0x10, 0xf2, 0x82, 0x25, 0x32, 0x75, 0x42, 0x1c, 0x58, 0x10, 0x03, 0x2f, 0xd8, 0xb7, 0x29, 0xaa,
	0xc8, 0x73, 0xd8, 0x95, 0xd7, 0x5c, 0xa5, 0x99, 0x5c, 0x26, 0x39, 0x55, 0x3f, 0x71, 0x85, 0xb3,
	0x08, 0xe2, 0x7e, 0x05, 0x5f, 0x21, 0x4a, 0x3e, 0x82, 0x6e, 0x65, 0x35, 0x86, 0x83, 0x08, 0xe2,
	0x15, 0x60, 0x1b, 0x68, 0xa4, 0x4c, 0x32, 0xaa, 0x66, 0x1c, 0x07, 0x10, 0xc4, 0x81, 0x91, 0xf2,
	0xd2, 0x9e, 0x5f, 0xb7, 0x83, 0x60, 0xaf, 0x3b, 0xfa, 0xdb, 0xab, 0x5b, 0xcf, 0x33, 0x43, 0x1f,
	0xce, 0xaa, 0xd6, 0x0b, 0xd7, 0x6e, 0x2c, 0x5c, 0xed, 0x98, 0x3f, 0x3d, 0xe8, 0x35, 0xd2, 0x7e,
	0xb8, 0x56, 0x19, 0x9d, 0xc1, 0xc1, 0x5a, 0x7f, 0x4b, 0x6f, 0x7f, 0x02, 0x3e, 0xb3, 0x80, 0x8e,
	0xbc, 0x61, 0x6b, 0xdc, 0x3b, 0x3d, 0xa8, 0x9a, 0xdb, 0x14, 0x97, 0x92, 0x51, 0x56, 0xcd, 0x08,
	0xdd, 0xf1, 0x2e, 0x33, 0x1a, 0x40, 0xa0, 0xf8, 0xb5, 0xd0, 0x42, 0x16, 0x65, 0x2f, 0xea, 0x73,
	0xdd, 0xdb, 0x8f, 0xab, 0x8c, 0xcb, 0xdb, 0xca, 0x8c, 0x09, 0xb4, 0xd1, 0xd1, 0xae, 0xbb, 0xf8,
	0x3c, 0xfa, 0xcd, 0x83, 0x7e, 0x4c, 0x97, 0x0f, 0xea, 0x23, 0x5f, 0xd7, 0xf1, 0x14, 0x76, 0xeb,
	0xdc, 0xde, 0x52, 0xc3, 0xef, 0x1e, 0xea, 0xde, 0xb9, 0xb5, 0xef, 0xa7, 0x88, 0x67, 0xb0, 0xb7,
	0x4a, 0xee, 0x2d, 0x55, 0xfc, 0xe1, 0xc1, 0x9e, 0x2d, 0xf5, 0x3b, 0x43, 0x8d, 0x7e, 0x78, 0x65,
	0xfc, 0x08, 0xdd, 0x3a, 0x3b, 0x9b, 0x7f, 0x63, 0x4f, 0xf1, 0xd9, 0x7e, 0xc8, 0x28, 0x63, 0xc2,
	0x08, 0x59, 0x68, 0xbc, 0xb1, 0x13, 0xaf, 0x00, 0xcb, 0x32, 0x9e, 0x71, 0xc7, 0xb6, 0x1c, 0x5b,
	0x03, 0xa3, 0x2f, 0x60, 0xbf, 0x51, 0x7a, 0xd9, 0xa4, 0xe7, 0xd0, 0xd1, 0x16, 0x28, 0xf7, 0x6b,
	0xbf, 0x2a, 0x7b, 0xa5, 0x74, 0xfc, 0xe9, 0x3f, 0x2d, 0xe8, 0x21, 0xc8, 0xd5, 0xb5, 0x98, 0x72,
	0xf2, 0x0d, 0xc0, 0xea, 0xb7, 0x88, 0x1c, 0xdd, 0xd9, 0xcb, 0x95, 0xd3, 0x07, 0x83, 0x4d, 0x94,
	0xbb, 0x7d, 0xf4, 0xc1, 0x4b, 0x8f, 0xbc, 0x5e, 0xff, 0x44, 0x0d, 0x36, 0x6d, 0x78, 0x19, 0xea,
	0xf1, 0x46, 0x6e, 0x53, 0x2c, 0xf7, 0xfb, 0x70, 0x27, 0x56, 0xd3, 0xbb, 0x77, 0x63, 0xad, 0x59,
	0x07, 0x63, 0x7d, 0x09, 0xdb, 0xe5, 0x5e, 0x90, 0xc3, 0xda, 0x0c, 0x6b, 0x4b, 0x3c, 0x78, 0x74,
	0x0f, 0x6f, 0xbc, 0xff, 0x15, 0x04, 0x95, 0x25, 0x49, 0x53, 0xb8, 0x96, 0x45, 0x74, 0x9f, 0x68,
	0x84, 0x38, 0x6f, 0xda, 0x21, 0xba, 0x3f, 0x9a, 0x32, 0xc8, 0xd1, 0x06, 0x66, 0x15, 0xe5, 0xec,
	0xe5, 0x0f, 0x96, 0xcf, 0xe8, 0xe4, 0x78, 0x2a, 0xf3, 0x13, 0xf7, 0xf8, 0x42, 0xaa, 0xd9, 0x89,
	0x7b, 0xeb, 0x05, 0xfe, 0x17, 0x3d, 0x99, 0xc9, 0xf2, 0xbc, 0x98, 0x4c, 0x7c, 0x84, 0x3e, 0xfd,
	0x3f, 0x00, 0x00, 0xff, 0xff, 0x3f, 0xbe, 0x4d, 0xc2, 0xc2, 0x0a, 0x00, 0x00,
}
