// Code generated by protoc-gen-go. DO NOT EDIT.
// source: ssh.proto

package gitalypb // import "gitlab.com/gitlab-org/gitaly-proto/go/gitalypb"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type SSHUploadPackRequest struct {
	// 'repository' must be present in the first message.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// A chunk of raw data to be copied to 'git upload-pack' standard input
	Stdin []byte `protobuf:"bytes,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Parameters to use with git -c (key=value pairs)
	GitConfigOptions []string `protobuf:"bytes,4,rep,name=git_config_options,json=gitConfigOptions,proto3" json:"git_config_options,omitempty"`
	// Git protocol version
	GitProtocol          string   `protobuf:"bytes,5,opt,name=git_protocol,json=gitProtocol,proto3" json:"git_protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SSHUploadPackRequest) Reset()         { *m = SSHUploadPackRequest{} }
func (m *SSHUploadPackRequest) String() string { return proto.CompactTextString(m) }
func (*SSHUploadPackRequest) ProtoMessage()    {}
func (*SSHUploadPackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ssh_e79ebe9ec5e2177f, []int{0}
}
func (m *SSHUploadPackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SSHUploadPackRequest.Unmarshal(m, b)
}
func (m *SSHUploadPackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SSHUploadPackRequest.Marshal(b, m, deterministic)
}
func (dst *SSHUploadPackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SSHUploadPackRequest.Merge(dst, src)
}
func (m *SSHUploadPackRequest) XXX_Size() int {
	return xxx_messageInfo_SSHUploadPackRequest.Size(m)
}
func (m *SSHUploadPackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SSHUploadPackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SSHUploadPackRequest proto.InternalMessageInfo

func (m *SSHUploadPackRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *SSHUploadPackRequest) GetStdin() []byte {
	if m != nil {
		return m.Stdin
	}
	return nil
}

func (m *SSHUploadPackRequest) GetGitConfigOptions() []string {
	if m != nil {
		return m.GitConfigOptions
	}
	return nil
}

func (m *SSHUploadPackRequest) GetGitProtocol() string {
	if m != nil {
		return m.GitProtocol
	}
	return ""
}

type SSHUploadPackResponse struct {
	// A chunk of raw data from 'git upload-pack' standard output
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// A chunk of raw data from 'git upload-pack' standard error
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// This field may be nil. This is intentional: only when the remote
	// command has finished can we return its exit status.
	ExitStatus           *ExitStatus `protobuf:"bytes,3,opt,name=exit_status,json=exitStatus,proto3" json:"exit_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SSHUploadPackResponse) Reset()         { *m = SSHUploadPackResponse{} }
func (m *SSHUploadPackResponse) String() string { return proto.CompactTextString(m) }
func (*SSHUploadPackResponse) ProtoMessage()    {}
func (*SSHUploadPackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ssh_e79ebe9ec5e2177f, []int{1}
}
func (m *SSHUploadPackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SSHUploadPackResponse.Unmarshal(m, b)
}
func (m *SSHUploadPackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SSHUploadPackResponse.Marshal(b, m, deterministic)
}
func (dst *SSHUploadPackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SSHUploadPackResponse.Merge(dst, src)
}
func (m *SSHUploadPackResponse) XXX_Size() int {
	return xxx_messageInfo_SSHUploadPackResponse.Size(m)
}
func (m *SSHUploadPackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SSHUploadPackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SSHUploadPackResponse proto.InternalMessageInfo

func (m *SSHUploadPackResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *SSHUploadPackResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *SSHUploadPackResponse) GetExitStatus() *ExitStatus {
	if m != nil {
		return m.ExitStatus
	}
	return nil
}

type SSHReceivePackRequest struct {
	// 'repository' must be present in the first message.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// A chunk of raw data to be copied to 'git upload-pack' standard input
	Stdin []byte `protobuf:"bytes,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Contents of GL_ID, GL_REPOSITORY, and GL_USERNAME environment variables
	// for 'git receive-pack'
	GlId         string `protobuf:"bytes,3,opt,name=gl_id,json=glId,proto3" json:"gl_id,omitempty"`
	GlRepository string `protobuf:"bytes,4,opt,name=gl_repository,json=glRepository,proto3" json:"gl_repository,omitempty"`
	GlUsername   string `protobuf:"bytes,5,opt,name=gl_username,json=glUsername,proto3" json:"gl_username,omitempty"`
	// Git protocol version
	GitProtocol string `protobuf:"bytes,6,opt,name=git_protocol,json=gitProtocol,proto3" json:"git_protocol,omitempty"`
	// Parameters to use with git -c (key=value pairs)
	GitConfigOptions     []string `protobuf:"bytes,7,rep,name=git_config_options,json=gitConfigOptions,proto3" json:"git_config_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SSHReceivePackRequest) Reset()         { *m = SSHReceivePackRequest{} }
func (m *SSHReceivePackRequest) String() string { return proto.CompactTextString(m) }
func (*SSHReceivePackRequest) ProtoMessage()    {}
func (*SSHReceivePackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ssh_e79ebe9ec5e2177f, []int{2}
}
func (m *SSHReceivePackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SSHReceivePackRequest.Unmarshal(m, b)
}
func (m *SSHReceivePackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SSHReceivePackRequest.Marshal(b, m, deterministic)
}
func (dst *SSHReceivePackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SSHReceivePackRequest.Merge(dst, src)
}
func (m *SSHReceivePackRequest) XXX_Size() int {
	return xxx_messageInfo_SSHReceivePackRequest.Size(m)
}
func (m *SSHReceivePackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SSHReceivePackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SSHReceivePackRequest proto.InternalMessageInfo

func (m *SSHReceivePackRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *SSHReceivePackRequest) GetStdin() []byte {
	if m != nil {
		return m.Stdin
	}
	return nil
}

func (m *SSHReceivePackRequest) GetGlId() string {
	if m != nil {
		return m.GlId
	}
	return ""
}

func (m *SSHReceivePackRequest) GetGlRepository() string {
	if m != nil {
		return m.GlRepository
	}
	return ""
}

func (m *SSHReceivePackRequest) GetGlUsername() string {
	if m != nil {
		return m.GlUsername
	}
	return ""
}

func (m *SSHReceivePackRequest) GetGitProtocol() string {
	if m != nil {
		return m.GitProtocol
	}
	return ""
}

func (m *SSHReceivePackRequest) GetGitConfigOptions() []string {
	if m != nil {
		return m.GitConfigOptions
	}
	return nil
}

type SSHReceivePackResponse struct {
	// A chunk of raw data from 'git receive-pack' standard output
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// A chunk of raw data from 'git receive-pack' standard error
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// This field may be nil. This is intentional: only when the remote
	// command has finished can we return its exit status.
	ExitStatus           *ExitStatus `protobuf:"bytes,3,opt,name=exit_status,json=exitStatus,proto3" json:"exit_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SSHReceivePackResponse) Reset()         { *m = SSHReceivePackResponse{} }
func (m *SSHReceivePackResponse) String() string { return proto.CompactTextString(m) }
func (*SSHReceivePackResponse) ProtoMessage()    {}
func (*SSHReceivePackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ssh_e79ebe9ec5e2177f, []int{3}
}
func (m *SSHReceivePackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SSHReceivePackResponse.Unmarshal(m, b)
}
func (m *SSHReceivePackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SSHReceivePackResponse.Marshal(b, m, deterministic)
}
func (dst *SSHReceivePackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SSHReceivePackResponse.Merge(dst, src)
}
func (m *SSHReceivePackResponse) XXX_Size() int {
	return xxx_messageInfo_SSHReceivePackResponse.Size(m)
}
func (m *SSHReceivePackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SSHReceivePackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SSHReceivePackResponse proto.InternalMessageInfo

func (m *SSHReceivePackResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *SSHReceivePackResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *SSHReceivePackResponse) GetExitStatus() *ExitStatus {
	if m != nil {
		return m.ExitStatus
	}
	return nil
}

type SSHUploadArchiveRequest struct {
	// 'repository' must be present in the first message.
	Repository *Repository `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// A chunk of raw data to be copied to 'git upload-archive' standard input
	Stdin                []byte   `protobuf:"bytes,2,opt,name=stdin,proto3" json:"stdin,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SSHUploadArchiveRequest) Reset()         { *m = SSHUploadArchiveRequest{} }
func (m *SSHUploadArchiveRequest) String() string { return proto.CompactTextString(m) }
func (*SSHUploadArchiveRequest) ProtoMessage()    {}
func (*SSHUploadArchiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ssh_e79ebe9ec5e2177f, []int{4}
}
func (m *SSHUploadArchiveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SSHUploadArchiveRequest.Unmarshal(m, b)
}
func (m *SSHUploadArchiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SSHUploadArchiveRequest.Marshal(b, m, deterministic)
}
func (dst *SSHUploadArchiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SSHUploadArchiveRequest.Merge(dst, src)
}
func (m *SSHUploadArchiveRequest) XXX_Size() int {
	return xxx_messageInfo_SSHUploadArchiveRequest.Size(m)
}
func (m *SSHUploadArchiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SSHUploadArchiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SSHUploadArchiveRequest proto.InternalMessageInfo

func (m *SSHUploadArchiveRequest) GetRepository() *Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *SSHUploadArchiveRequest) GetStdin() []byte {
	if m != nil {
		return m.Stdin
	}
	return nil
}

type SSHUploadArchiveResponse struct {
	// A chunk of raw data from 'git upload-archive' standard output
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// A chunk of raw data from 'git upload-archive' standard error
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// This value will only be set on the last message
	ExitStatus           *ExitStatus `protobuf:"bytes,3,opt,name=exit_status,json=exitStatus,proto3" json:"exit_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SSHUploadArchiveResponse) Reset()         { *m = SSHUploadArchiveResponse{} }
func (m *SSHUploadArchiveResponse) String() string { return proto.CompactTextString(m) }
func (*SSHUploadArchiveResponse) ProtoMessage()    {}
func (*SSHUploadArchiveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ssh_e79ebe9ec5e2177f, []int{5}
}
func (m *SSHUploadArchiveResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SSHUploadArchiveResponse.Unmarshal(m, b)
}
func (m *SSHUploadArchiveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SSHUploadArchiveResponse.Marshal(b, m, deterministic)
}
func (dst *SSHUploadArchiveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SSHUploadArchiveResponse.Merge(dst, src)
}
func (m *SSHUploadArchiveResponse) XXX_Size() int {
	return xxx_messageInfo_SSHUploadArchiveResponse.Size(m)
}
func (m *SSHUploadArchiveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SSHUploadArchiveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SSHUploadArchiveResponse proto.InternalMessageInfo

func (m *SSHUploadArchiveResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *SSHUploadArchiveResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *SSHUploadArchiveResponse) GetExitStatus() *ExitStatus {
	if m != nil {
		return m.ExitStatus
	}
	return nil
}

func init() {
	proto.RegisterType((*SSHUploadPackRequest)(nil), "gitaly.SSHUploadPackRequest")
	proto.RegisterType((*SSHUploadPackResponse)(nil), "gitaly.SSHUploadPackResponse")
	proto.RegisterType((*SSHReceivePackRequest)(nil), "gitaly.SSHReceivePackRequest")
	proto.RegisterType((*SSHReceivePackResponse)(nil), "gitaly.SSHReceivePackResponse")
	proto.RegisterType((*SSHUploadArchiveRequest)(nil), "gitaly.SSHUploadArchiveRequest")
	proto.RegisterType((*SSHUploadArchiveResponse)(nil), "gitaly.SSHUploadArchiveResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SSHServiceClient is the client API for SSHService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SSHServiceClient interface {
	// To forward 'git upload-pack' to Gitaly for SSH sessions
	SSHUploadPack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadPackClient, error)
	// To forward 'git receive-pack' to Gitaly for SSH sessions
	SSHReceivePack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHReceivePackClient, error)
	// To forward 'git upload-archive' to Gitaly for SSH sessions
	SSHUploadArchive(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadArchiveClient, error)
}

type sSHServiceClient struct {
	cc *grpc.ClientConn
}

func NewSSHServiceClient(cc *grpc.ClientConn) SSHServiceClient {
	return &sSHServiceClient{cc}
}

func (c *sSHServiceClient) SSHUploadPack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadPackClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SSHService_serviceDesc.Streams[0], "/gitaly.SSHService/SSHUploadPack", opts...)
	if err != nil {
		return nil, err
	}
	x := &sSHServiceSSHUploadPackClient{stream}
	return x, nil
}

type SSHService_SSHUploadPackClient interface {
	Send(*SSHUploadPackRequest) error
	Recv() (*SSHUploadPackResponse, error)
	grpc.ClientStream
}

type sSHServiceSSHUploadPackClient struct {
	grpc.ClientStream
}

func (x *sSHServiceSSHUploadPackClient) Send(m *SSHUploadPackRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadPackClient) Recv() (*SSHUploadPackResponse, error) {
	m := new(SSHUploadPackResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sSHServiceClient) SSHReceivePack(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHReceivePackClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SSHService_serviceDesc.Streams[1], "/gitaly.SSHService/SSHReceivePack", opts...)
	if err != nil {
		return nil, err
	}
	x := &sSHServiceSSHReceivePackClient{stream}
	return x, nil
}

type SSHService_SSHReceivePackClient interface {
	Send(*SSHReceivePackRequest) error
	Recv() (*SSHReceivePackResponse, error)
	grpc.ClientStream
}

type sSHServiceSSHReceivePackClient struct {
	grpc.ClientStream
}

func (x *sSHServiceSSHReceivePackClient) Send(m *SSHReceivePackRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sSHServiceSSHReceivePackClient) Recv() (*SSHReceivePackResponse, error) {
	m := new(SSHReceivePackResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *sSHServiceClient) SSHUploadArchive(ctx context.Context, opts ...grpc.CallOption) (SSHService_SSHUploadArchiveClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SSHService_serviceDesc.Streams[2], "/gitaly.SSHService/SSHUploadArchive", opts...)
	if err != nil {
		return nil, err
	}
	x := &sSHServiceSSHUploadArchiveClient{stream}
	return x, nil
}

type SSHService_SSHUploadArchiveClient interface {
	Send(*SSHUploadArchiveRequest) error
	Recv() (*SSHUploadArchiveResponse, error)
	grpc.ClientStream
}

type sSHServiceSSHUploadArchiveClient struct {
	grpc.ClientStream
}

func (x *sSHServiceSSHUploadArchiveClient) Send(m *SSHUploadArchiveRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadArchiveClient) Recv() (*SSHUploadArchiveResponse, error) {
	m := new(SSHUploadArchiveResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SSHServiceServer is the server API for SSHService service.
type SSHServiceServer interface {
	// To forward 'git upload-pack' to Gitaly for SSH sessions
	SSHUploadPack(SSHService_SSHUploadPackServer) error
	// To forward 'git receive-pack' to Gitaly for SSH sessions
	SSHReceivePack(SSHService_SSHReceivePackServer) error
	// To forward 'git upload-archive' to Gitaly for SSH sessions
	SSHUploadArchive(SSHService_SSHUploadArchiveServer) error
}

func RegisterSSHServiceServer(s *grpc.Server, srv SSHServiceServer) {
	s.RegisterService(&_SSHService_serviceDesc, srv)
}

func _SSHService_SSHUploadPack_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SSHServiceServer).SSHUploadPack(&sSHServiceSSHUploadPackServer{stream})
}

type SSHService_SSHUploadPackServer interface {
	Send(*SSHUploadPackResponse) error
	Recv() (*SSHUploadPackRequest, error)
	grpc.ServerStream
}

type sSHServiceSSHUploadPackServer struct {
	grpc.ServerStream
}

func (x *sSHServiceSSHUploadPackServer) Send(m *SSHUploadPackResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadPackServer) Recv() (*SSHUploadPackRequest, error) {
	m := new(SSHUploadPackRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SSHService_SSHReceivePack_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SSHServiceServer).SSHReceivePack(&sSHServiceSSHReceivePackServer{stream})
}

type SSHService_SSHReceivePackServer interface {
	Send(*SSHReceivePackResponse) error
	Recv() (*SSHReceivePackRequest, error)
	grpc.ServerStream
}

type sSHServiceSSHReceivePackServer struct {
	grpc.ServerStream
}

func (x *sSHServiceSSHReceivePackServer) Send(m *SSHReceivePackResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sSHServiceSSHReceivePackServer) Recv() (*SSHReceivePackRequest, error) {
	m := new(SSHReceivePackRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SSHService_SSHUploadArchive_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SSHServiceServer).SSHUploadArchive(&sSHServiceSSHUploadArchiveServer{stream})
}

type SSHService_SSHUploadArchiveServer interface {
	Send(*SSHUploadArchiveResponse) error
	Recv() (*SSHUploadArchiveRequest, error)
	grpc.ServerStream
}

type sSHServiceSSHUploadArchiveServer struct {
	grpc.ServerStream
}

func (x *sSHServiceSSHUploadArchiveServer) Send(m *SSHUploadArchiveResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sSHServiceSSHUploadArchiveServer) Recv() (*SSHUploadArchiveRequest, error) {
	m := new(SSHUploadArchiveRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _SSHService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.SSHService",
	HandlerType: (*SSHServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SSHUploadPack",
			Handler:       _SSHService_SSHUploadPack_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SSHReceivePack",
			Handler:       _SSHService_SSHReceivePack_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SSHUploadArchive",
			Handler:       _SSHService_SSHUploadArchive_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "ssh.proto",
}

func init() { proto.RegisterFile("ssh.proto", fileDescriptor_ssh_e79ebe9ec5e2177f) }

var fileDescriptor_ssh_e79ebe9ec5e2177f = []byte{
	// 494 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x54, 0x4d, 0x6e, 0xd3, 0x40,
	0x14, 0xc6, 0x8e, 0x63, 0x9a, 0x17, 0x17, 0x45, 0x43, 0x5b, 0xac, 0x08, 0xa8, 0x31, 0x1b, 0x2f,
	0x68, 0x52, 0xa5, 0x3b, 0x76, 0x80, 0x90, 0x0a, 0x1b, 0xaa, 0xb1, 0xb2, 0x81, 0x85, 0xe5, 0xd8,
	0xc3, 0x64, 0xd4, 0x89, 0xc7, 0xcc, 0x4c, 0xa2, 0x56, 0x02, 0x71, 0x09, 0x10, 0x37, 0xe3, 0x20,
	0x9c, 0x00, 0xd5, 0x36, 0xc1, 0x8e, 0x9b, 0x1d, 0x64, 0x37, 0xef, 0xfb, 0xde, 0xff, 0xf7, 0x6c,
	0xe8, 0x29, 0x35, 0x1f, 0xe5, 0x52, 0x68, 0x81, 0x6c, 0xca, 0x74, 0xcc, 0xaf, 0x87, 0x8e, 0x9a,
	0xc7, 0x92, 0xa4, 0x25, 0xea, 0xff, 0x34, 0xe0, 0x20, 0x0c, 0xcf, 0xa7, 0x39, 0x17, 0x71, 0x7a,
	0x11, 0x27, 0x97, 0x98, 0x7c, 0x5a, 0x12, 0xa5, 0xd1, 0x04, 0x40, 0x92, 0x5c, 0x28, 0xa6, 0x85,
	0xbc, 0x76, 0x0d, 0xcf, 0x08, 0xfa, 0x13, 0x34, 0x2a, 0x73, 0x8c, 0xf0, 0x9a, 0xc1, 0x35, 0x2f,
	0x74, 0x00, 0x5d, 0xa5, 0x53, 0x96, 0xb9, 0xa6, 0x67, 0x04, 0x0e, 0x2e, 0x0d, 0xf4, 0x0c, 0x10,
	0x65, 0x3a, 0x4a, 0x44, 0xf6, 0x91, 0xd1, 0x48, 0xe4, 0x9a, 0x89, 0x4c, 0xb9, 0x96, 0xd7, 0x09,
	0x7a, 0x78, 0x40, 0x99, 0x7e, 0x55, 0x10, 0xef, 0x4a, 0x1c, 0x3d, 0x01, 0xe7, 0xc6, 0xbb, 0xe8,
	0x2e, 0x11, 0xdc, 0xed, 0x7a, 0x46, 0xd0, 0xc3, 0x7d, 0xca, 0xf4, 0x45, 0x05, 0x3d, 0xb7, 0x7f,
	0xfd, 0x08, 0xcc, 0x3d, 0xf3, 0xad, 0xb5, 0xd7, 0x19, 0x58, 0xf8, 0xb0, 0x96, 0x3c, 0x8f, 0x65,
	0xbc, 0x20, 0x9a, 0x48, 0xe5, 0x7f, 0x86, 0xc3, 0x8d, 0xb9, 0x54, 0x2e, 0x32, 0x45, 0xd0, 0x11,
	0xd8, 0x4a, 0xa7, 0x62, 0xa9, 0x8b, 0xa1, 0x1c, 0x5c, 0x59, 0x15, 0x4e, 0xa4, 0xac, 0xba, 0xaf,
	0x2c, 0x74, 0x06, 0x7d, 0x72, 0xc5, 0x74, 0xa4, 0x74, 0xac, 0x97, 0xca, 0xed, 0x34, 0x37, 0xf1,
	0xfa, 0x8a, 0xe9, 0xb0, 0x60, 0x30, 0x90, 0xf5, 0xdb, 0xff, 0x6e, 0x16, 0xe5, 0x31, 0x49, 0x08,
	0x5b, 0x91, 0xff, 0xb3, 0xd7, 0xfb, 0xd0, 0xa5, 0x3c, 0x62, 0x69, 0xd1, 0x52, 0x0f, 0x5b, 0x94,
	0xbf, 0x49, 0xd1, 0x53, 0xd8, 0xa7, 0x3c, 0xaa, 0x55, 0xb0, 0x0a, 0xd2, 0xa1, 0xfc, 0x6f, 0x6e,
	0x74, 0x0c, 0x7d, 0xca, 0xa3, 0xa5, 0x22, 0x32, 0x8b, 0x17, 0xa4, 0x5a, 0x31, 0x50, 0x3e, 0xad,
	0x90, 0x96, 0x08, 0x76, 0x4b, 0x84, 0x2d, 0xaa, 0xde, 0xbd, 0x5d, 0xd5, 0x4a, 0x32, 0xc3, 0xff,
	0x02, 0x47, 0x9b, 0x6b, 0xd9, 0xa5, 0x2c, 0x97, 0xf0, 0x60, 0x7d, 0x14, 0x2f, 0x64, 0x32, 0x67,
	0x2b, 0xf2, 0xcf, 0x75, 0x59, 0xcf, 0xfa, 0x15, 0xdc, 0x76, 0xb1, 0x1d, 0x4e, 0x3b, 0xf9, 0x66,
	0x02, 0x84, 0xe1, 0x79, 0x48, 0xe4, 0x8a, 0x25, 0x04, 0x61, 0xd8, 0x6f, 0x7c, 0x11, 0xe8, 0xe1,
	0x9f, 0xf8, 0xdb, 0x7e, 0x00, 0xc3, 0x47, 0x5b, 0xd8, 0x72, 0x02, 0xff, 0x4e, 0x60, 0x9c, 0x1a,
	0x68, 0x0a, 0xf7, 0x9a, 0x7a, 0xa2, 0x7a, 0x58, 0xfb, 0xfc, 0x87, 0x8f, 0xb7, 0xd1, 0x8d, 0xb4,
	0x1f, 0x60, 0xb0, 0xb9, 0x3a, 0x74, 0xdc, 0xea, 0xa7, 0xa9, 0xe0, 0xd0, 0xdb, 0xee, 0x50, 0x4f,
	0xfe, 0xf2, 0xf4, 0xfd, 0x8d, 0x23, 0x8f, 0x67, 0xa3, 0x44, 0x2c, 0xc6, 0xe5, 0xf3, 0x44, 0x48,
	0x3a, 0x2e, 0xc3, 0x4f, 0x8a, 0xab, 0x1f, 0x53, 0x51, 0xd9, 0xf9, 0x6c, 0x66, 0x17, 0xd0, 0xd9,
	0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x78, 0x96, 0xf9, 0x08, 0x4e, 0x05, 0x00, 0x00,
}
