export const mockEndpoint = '/dashboard/groups.json';

export const ITEM_TYPE = {
  PROJECT: 'project',
  GROUP: 'group',
};

export const GROUP_VISIBILITY_TYPE = {
  public: 'Public - The group and any public projects can be viewed without any authentication.',
  internal: 'Internal - The group and any internal projects can be viewed by any logged in user.',
  private: 'Private - The group and its projects can only be viewed by members.',
};

export const PROJECT_VISIBILITY_TYPE = {
  public: 'Public - The project can be accessed without any authentication.',
  internal: 'Internal - The project can be accessed by any logged in user.',
  private: 'Private - Project access must be granted explicitly to each user.',
};

export const VISIBILITY_TYPE_ICON = {
  public: 'earth',
  internal: 'shield',
  private: 'lock',
};

export const mockParentGroupItem = {
  id: 55,
  name: 'hardware',
  description: '',
  visibility: 'public',
  fullName: 'platform / hardware',
  relativePath: '/platform/hardware',
  canEdit: true,
  type: 'group',
  avatarUrl: null,
  permission: 'Owner',
  editPath: '/groups/platform/hardware/edit',
  childrenCount: 3,
  leavePath: '/groups/platform/hardware/group_members/leave',
  parentId: 54,
  memberCount: '1',
  projectCount: 1,
  subgroupCount: 2,
  canLeave: false,
  children: [],
  isOpen: true,
  isChildrenLoading: false,
  isBeingRemoved: false,
  updatedAt: '2017-04-09T18:40:39.101Z',
};

export const mockRawChildren = [
  {
    id: 57,
    name: 'bsp',
    description: '',
    visibility: 'public',
    full_name: 'platform / hardware / bsp',
    relative_path: '/platform/hardware/bsp',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/platform/hardware/bsp/edit',
    children_count: 6,
    leave_path: '/groups/platform/hardware/bsp/group_members/leave',
    parent_id: 55,
    number_users_with_delimiter: '1',
    project_count: 4,
    subgroup_count: 2,
    can_leave: false,
    children: [],
    updated_at: '2017-04-09T18:40:39.101Z',
  },
];

export const mockChildren = [
  {
    id: 57,
    name: 'bsp',
    description: '',
    visibility: 'public',
    fullName: 'platform / hardware / bsp',
    relativePath: '/platform/hardware/bsp',
    canEdit: true,
    type: 'group',
    avatarUrl: null,
    permission: 'Owner',
    editPath: '/groups/platform/hardware/bsp/edit',
    childrenCount: 6,
    leavePath: '/groups/platform/hardware/bsp/group_members/leave',
    parentId: 55,
    memberCount: '1',
    projectCount: 4,
    subgroupCount: 2,
    canLeave: false,
    children: [],
    isOpen: true,
    isChildrenLoading: false,
    isBeingRemoved: false,
    updatedAt: '2017-04-09T18:40:39.101Z',
  },
];

export const mockGroups = [
  {
    id: 75,
    name: 'test-group',
    description: '',
    visibility: 'public',
    full_name: 'test-group',
    relative_path: '/test-group',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/test-group/edit',
    children_count: 2,
    leave_path: '/groups/test-group/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '1',
    project_count: 2,
    subgroup_count: 0,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
  {
    id: 67,
    name: 'open-source',
    description: '',
    visibility: 'private',
    full_name: 'open-source',
    relative_path: '/open-source',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/open-source/edit',
    children_count: 0,
    leave_path: '/groups/open-source/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '1',
    project_count: 0,
    subgroup_count: 0,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
  {
    id: 54,
    name: 'platform',
    description: '',
    visibility: 'public',
    full_name: 'platform',
    relative_path: '/platform',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/platform/edit',
    children_count: 1,
    leave_path: '/groups/platform/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '1',
    project_count: 0,
    subgroup_count: 1,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
  {
    id: 5,
    name: 'H5bp',
    description: 'Minus dolor consequuntur qui nam recusandae quam incidunt.',
    visibility: 'public',
    full_name: 'H5bp',
    relative_path: '/h5bp',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/h5bp/edit',
    children_count: 1,
    leave_path: '/groups/h5bp/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '5',
    project_count: 1,
    subgroup_count: 0,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
  {
    id: 4,
    name: 'Twitter',
    description: 'Deserunt hic nostrum placeat veniam.',
    visibility: 'public',
    full_name: 'Twitter',
    relative_path: '/twitter',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/twitter/edit',
    children_count: 2,
    leave_path: '/groups/twitter/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '5',
    project_count: 2,
    subgroup_count: 0,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
  {
    id: 3,
    name: 'Documentcloud',
    description: 'Consequatur saepe totam ea pariatur maxime.',
    visibility: 'public',
    full_name: 'Documentcloud',
    relative_path: '/documentcloud',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/documentcloud/edit',
    children_count: 1,
    leave_path: '/groups/documentcloud/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '5',
    project_count: 1,
    subgroup_count: 0,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
  {
    id: 2,
    name: 'Gitlab Org',
    description: 'Debitis ea quas aperiam velit doloremque ab.',
    visibility: 'public',
    full_name: 'Gitlab Org',
    relative_path: '/gitlab-org',
    can_edit: true,
    type: 'group',
    avatar_url: '/uploads/-/system/group/avatar/2/GitLab.png',
    permission: 'Owner',
    edit_path: '/groups/gitlab-org/edit',
    children_count: 4,
    leave_path: '/groups/gitlab-org/group_members/leave',
    parent_id: null,
    number_users_with_delimiter: '5',
    project_count: 4,
    subgroup_count: 0,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
  },
];

export const mockSearchedGroups = [
  {
    id: 55,
    name: 'hardware',
    description: '',
    visibility: 'public',
    full_name: 'platform / hardware',
    relative_path: '/platform/hardware',
    can_edit: true,
    type: 'group',
    avatar_url: null,
    permission: 'Owner',
    edit_path: '/groups/platform/hardware/edit',
    children_count: 3,
    leave_path: '/groups/platform/hardware/group_members/leave',
    parent_id: 54,
    number_users_with_delimiter: '1',
    project_count: 1,
    subgroup_count: 2,
    can_leave: false,
    updated_at: '2017-04-09T18:40:39.101Z',
    children: [
      {
        id: 57,
        name: 'bsp',
        description: '',
        visibility: 'public',
        full_name: 'platform / hardware / bsp',
        relative_path: '/platform/hardware/bsp',
        can_edit: true,
        type: 'group',
        avatar_url: null,
        permission: 'Owner',
        edit_path: '/groups/platform/hardware/bsp/edit',
        children_count: 6,
        leave_path: '/groups/platform/hardware/bsp/group_members/leave',
        parent_id: 55,
        number_users_with_delimiter: '1',
        project_count: 4,
        subgroup_count: 2,
        can_leave: false,
        updated_at: '2017-04-09T18:40:39.101Z',
        children: [
          {
            id: 60,
            name: 'kernel',
            description: '',
            visibility: 'public',
            full_name: 'platform / hardware / bsp / kernel',
            relative_path: '/platform/hardware/bsp/kernel',
            can_edit: true,
            type: 'group',
            avatar_url: null,
            permission: 'Owner',
            edit_path: '/groups/platform/hardware/bsp/kernel/edit',
            children_count: 1,
            leave_path: '/groups/platform/hardware/bsp/kernel/group_members/leave',
            parent_id: 57,
            number_users_with_delimiter: '1',
            project_count: 0,
            subgroup_count: 1,
            can_leave: false,
            updated_at: '2017-04-09T18:40:39.101Z',
            children: [
              {
                id: 61,
                name: 'common',
                description: '',
                visibility: 'public',
                full_name: 'platform / hardware / bsp / kernel / common',
                relative_path: '/platform/hardware/bsp/kernel/common',
                can_edit: true,
                type: 'group',
                avatar_url: null,
                permission: 'Owner',
                edit_path: '/groups/platform/hardware/bsp/kernel/common/edit',
                children_count: 2,
                leave_path: '/groups/platform/hardware/bsp/kernel/common/group_members/leave',
                parent_id: 60,
                number_users_with_delimiter: '1',
                project_count: 2,
                subgroup_count: 0,
                can_leave: false,
                updated_at: '2017-04-09T18:40:39.101Z',
                children: [
                  {
                    id: 17,
                    name: 'v4.4',
                    description:
                      'Voluptatem qui ea error aperiam veritatis doloremque consequatur temporibus.',
                    visibility: 'public',
                    full_name: 'platform / hardware / bsp / kernel / common / v4.4',
                    relative_path: '/platform/hardware/bsp/kernel/common/v4.4',
                    can_edit: true,
                    type: 'project',
                    avatar_url: null,
                    permission: null,
                    edit_path: '/platform/hardware/bsp/kernel/common/v4.4/edit',
                    star_count: 0,
                    updated_at: '2017-09-12T06:37:04.925Z',
                  },
                  {
                    id: 16,
                    name: 'v4.1',
                    description: 'Rerum expedita voluptatem doloribus neque ducimus ut hic.',
                    visibility: 'public',
                    full_name: 'platform / hardware / bsp / kernel / common / v4.1',
                    relative_path: '/platform/hardware/bsp/kernel/common/v4.1',
                    can_edit: true,
                    type: 'project',
                    avatar_url: null,
                    permission: null,
                    edit_path: '/platform/hardware/bsp/kernel/common/v4.1/edit',
                    star_count: 0,
                    updated_at: '2017-04-09T18:41:03.112Z',
                  },
                ],
              },
            ],
          },
        ],
      },
    ],
  },
];

export const mockRawPageInfo = {
  'x-per-page': 10,
  'x-page': 10,
  'x-total': 10,
  'x-total-pages': 10,
  'x-next-page': 10,
  'x-prev-page': 10,
};

export const mockPageInfo = {
  perPage: 10,
  page: 10,
  total: 10,
  totalPages: 10,
  nextPage: 10,
  prevPage: 10,
};
