---
description: How to improve GitLab's documentation.
---

# Documentation improvement workflow

Anyone can contribute a merge request or create an issue for GitLab's documentation.

This page covers the process for any contributions to GitLab's docs that are
not part of feature development. If you are looking for information on updating
GitLab's docs as is required with the development and release of a new feature
or feature enhancement, see the [feature-change documentation workflow](feature-change-workflow.md).

## Who updates the docs

Anyone can contribute! You can create a merge request with documentation
when you find errors or other room for improvement in an existing doc, or when you
have an idea for all-new documentation that would help a GitLab user or admin
to achieve or improve their DevOps workflows.

## How to update the docs

- Follow the described standards and processes listed on the [GitLab Documentation guidelines](index.md) page,
including linked resources: the [Structure and template](structure.md) page, [Style Guide](styleguide.md), and [Markdown Guide](https://about.gitlab.com/handbook/product/technical-writing/markdown-guide/). 
- Follow GitLab's [Merge Request Guidelines](../contributing/merge_request_workflow.md#merge-request-guidelines).
- If you need any help to choose the correct place for a doc, discuss a documentation
idea or outline, or request any other help, ping the Technical Writer for the relevant
[DevOps stage](https://about.gitlab.com/handbook/product/categories/#devops-stages)
in your issue or MR, or write within `#docs` if you are a member of GitLab's Slack workspace.

## Merging

Anyone with master access to the affected GitLab project can merge documentation changes.
This person must make a good-faith effort to ensure that the content is clear
(sufficiently easy for the intended audience to navigate and understand) and
that it meets the [Documentation Guidelines](index.md) and [Style Guide](styleguide.md).

If the author or reviewer has any questions, or would like a techncial writer's review
before merging, mention the writer who is assigned to the relevant [DevOps stage](https://about.gitlab.com/handbook/product/categories/#devops-stages).

## Technical Writer review

The technical writing team reviews changes after they are merged, unless a prior
review is requested.

## Other ways to help

If you have ideas for further documentation resources that would be best
considered/handled by technical writers, devs, and other SMEs, please create an issue.
