
import OpenGL.GL as gl

import glitch, glitch.gtk
from glitch.limbo.objects import make_lit_test_scene

class Accumulate(glitch.Node):
    def render(self, ctx):
        gl.glClear(gl.GL_ACCUM_BUFFER_BIT)

        for child in self.children:
            gl.glClear(gl.GL_COLOR_BUFFER_BIT | gl.GL_DEPTH_BUFFER_BIT)
            child.render(ctx)
            gl.glAccum(gl.GL_ACCUM, 1.0 / len(self.children))

        gl.glAccum(gl.GL_RETURN, 1.0)

if __name__ == '__main__':
    scene = make_lit_test_scene()
    scene_x = glitch.Rotate(0.5, 0, 1, 0, children=[scene])
    scene_y = glitch.Rotate(0.5, 1, 0, 0, children=[scene])
    camera = glitch.gtk.GtkMovingCamera(eye=[0, 2, 3], children=[
        Accumulate(children=[scene, scene_x, scene_y])])
    camera.run()
