#ifndef __GM_LOG_VIEW_H__
#define __GM_LOG_VIEW_H__

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_LOG_VIEW				(gm_log_view_get_type())
#define GM_LOG_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_LOG_VIEW, GmLogView))
#define GM_LOG_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj),\
		GM_TYPE_LOG_VIEW, GmLogView const))
#define GM_LOG_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_LOG_VIEW, GmLogViewClass))
#define GM_IS_LOG_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_LOG_VIEW))
#define GM_IS_LOG_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_LOG_VIEW))
#define GM_LOG_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_LOG_VIEW, GmLogViewClass))

/* Private structure type */
typedef struct _GmLogViewPrivate GmLogViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmLogView GmLogView;
 
struct _GmLogView {
	GtkVBox parent;
	
	/*< private > */
	GmLogViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmLogViewClass 	GmLogViewClass;

struct _GmLogViewClass {
	GtkVBoxClass parent_class;

	/* Signals
	void (* proto) (GmLogView *obj); */
};

GType gm_log_view_get_type(void) G_GNUC_CONST;
GmLogView *gm_log_view_new(void);
void gm_log_view_set_text(GmLogView *view, gchar const *text);

G_END_DECLS
#endif /* __GM_LOG_VIEW_H__ */
