// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp
func (c *Pinpoint) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for Amazon Pinpoint.
//
// Creates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp
func (c *Pinpoint) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCampaignRequest method.
//    req, resp := client.CreateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign
func (c *Pinpoint) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for Amazon Pinpoint.
//
// Creates a new campaign for an application or updates the settings of an existing
// campaign for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign
func (c *Pinpoint) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExportJob = "CreateExportJob"

// CreateExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExportJob for more information on using the CreateExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExportJobRequest method.
//    req, resp := client.CreateExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Pinpoint) CreateExportJobRequest(input *CreateExportJobInput) (req *request.Request, output *CreateExportJobOutput) {
	op := &request.Operation{
		Name:       opCreateExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &CreateExportJobInput{}
	}

	output = &CreateExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExportJob API operation for Amazon Pinpoint.
//
// Creates a new export job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateExportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Pinpoint) CreateExportJob(input *CreateExportJobInput) (*CreateExportJobOutput, error) {
	req, out := c.CreateExportJobRequest(input)
	return out, req.Send()
}

// CreateExportJobWithContext is the same as CreateExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateExportJobWithContext(ctx aws.Context, input *CreateExportJobInput, opts ...request.Option) (*CreateExportJobOutput, error) {
	req, out := c.CreateExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImportJob = "CreateImportJob"

// CreateImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImportJob for more information on using the CreateImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImportJobRequest method.
//    req, resp := client.CreateImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob
func (c *Pinpoint) CreateImportJobRequest(input *CreateImportJobInput) (req *request.Request, output *CreateImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &CreateImportJobInput{}
	}

	output = &CreateImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImportJob API operation for Amazon Pinpoint.
//
// Creates a new import job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob
func (c *Pinpoint) CreateImportJob(input *CreateImportJobInput) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	return out, req.Send()
}

// CreateImportJobWithContext is the same as CreateImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateImportJobWithContext(ctx aws.Context, input *CreateImportJobInput, opts ...request.Option) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSegment = "CreateSegment"

// CreateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSegment for more information on using the CreateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSegmentRequest method.
//    req, resp := client.CreateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment
func (c *Pinpoint) CreateSegmentRequest(input *CreateSegmentInput) (req *request.Request, output *CreateSegmentOutput) {
	op := &request.Operation{
		Name:       opCreateSegment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &CreateSegmentInput{}
	}

	output = &CreateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSegment API operation for Amazon Pinpoint.
//
// Creates a new segment for an application or updates the configuration, dimension,
// and other settings for an existing segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment
func (c *Pinpoint) CreateSegment(input *CreateSegmentInput) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	return out, req.Send()
}

// CreateSegmentWithContext is the same as CreateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateSegmentWithContext(ctx aws.Context, input *CreateSegmentInput, opts ...request.Option) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAdmChannel = "DeleteAdmChannel"

// DeleteAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAdmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAdmChannel for more information on using the DeleteAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAdmChannelRequest method.
//    req, resp := client.DeleteAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Pinpoint) DeleteAdmChannelRequest(input *DeleteAdmChannelInput) (req *request.Request, output *DeleteAdmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteAdmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &DeleteAdmChannelInput{}
	}

	output = &DeleteAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAdmChannel API operation for Amazon Pinpoint.
//
// Disables the ADM channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteAdmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Pinpoint) DeleteAdmChannel(input *DeleteAdmChannelInput) (*DeleteAdmChannelOutput, error) {
	req, out := c.DeleteAdmChannelRequest(input)
	return out, req.Send()
}

// DeleteAdmChannelWithContext is the same as DeleteAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteAdmChannelWithContext(ctx aws.Context, input *DeleteAdmChannelInput, opts ...request.Option) (*DeleteAdmChannelOutput, error) {
	req, out := c.DeleteAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsChannel = "DeleteApnsChannel"

// DeleteApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsChannel for more information on using the DeleteApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsChannelRequest method.
//    req, resp := client.DeleteApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannelRequest(input *DeleteApnsChannelInput) (req *request.Request, output *DeleteApnsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &DeleteApnsChannelInput{}
	}

	output = &DeleteApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsChannel API operation for Amazon Pinpoint.
//
// Disables the APNs channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannel(input *DeleteApnsChannelInput) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsChannelWithContext is the same as DeleteApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsChannelWithContext(ctx aws.Context, input *DeleteApnsChannelInput, opts ...request.Option) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsSandboxChannel = "DeleteApnsSandboxChannel"

// DeleteApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsSandboxChannel for more information on using the DeleteApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsSandboxChannelRequest method.
//    req, resp := client.DeleteApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Pinpoint) DeleteApnsSandboxChannelRequest(input *DeleteApnsSandboxChannelInput) (req *request.Request, output *DeleteApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &DeleteApnsSandboxChannelInput{}
	}

	output = &DeleteApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Disables the APNs sandbox channel for an application and deletes any existing
// settings for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Pinpoint) DeleteApnsSandboxChannel(input *DeleteApnsSandboxChannelInput) (*DeleteApnsSandboxChannelOutput, error) {
	req, out := c.DeleteApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsSandboxChannelWithContext is the same as DeleteApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsSandboxChannelWithContext(ctx aws.Context, input *DeleteApnsSandboxChannelInput, opts ...request.Option) (*DeleteApnsSandboxChannelOutput, error) {
	req, out := c.DeleteApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsVoipChannel = "DeleteApnsVoipChannel"

// DeleteApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsVoipChannel for more information on using the DeleteApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsVoipChannelRequest method.
//    req, resp := client.DeleteApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel
func (c *Pinpoint) DeleteApnsVoipChannelRequest(input *DeleteApnsVoipChannelInput) (req *request.Request, output *DeleteApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsVoipChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &DeleteApnsVoipChannelInput{}
	}

	output = &DeleteApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsVoipChannel API operation for Amazon Pinpoint.
//
// Disables the APNs VoIP channel for an application and deletes any existing
// settings for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsVoipChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel
func (c *Pinpoint) DeleteApnsVoipChannel(input *DeleteApnsVoipChannelInput) (*DeleteApnsVoipChannelOutput, error) {
	req, out := c.DeleteApnsVoipChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsVoipChannelWithContext is the same as DeleteApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsVoipChannelWithContext(ctx aws.Context, input *DeleteApnsVoipChannelInput, opts ...request.Option) (*DeleteApnsVoipChannelOutput, error) {
	req, out := c.DeleteApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsVoipSandboxChannel = "DeleteApnsVoipSandboxChannel"

// DeleteApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsVoipSandboxChannel for more information on using the DeleteApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsVoipSandboxChannelRequest method.
//    req, resp := client.DeleteApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel
func (c *Pinpoint) DeleteApnsVoipSandboxChannelRequest(input *DeleteApnsVoipSandboxChannelInput) (req *request.Request, output *DeleteApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsVoipSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &DeleteApnsVoipSandboxChannelInput{}
	}

	output = &DeleteApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Disables the APNs VoIP sandbox channel for an application and deletes any
// existing settings for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel
func (c *Pinpoint) DeleteApnsVoipSandboxChannel(input *DeleteApnsVoipSandboxChannelInput) (*DeleteApnsVoipSandboxChannelOutput, error) {
	req, out := c.DeleteApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsVoipSandboxChannelWithContext is the same as DeleteApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsVoipSandboxChannelWithContext(ctx aws.Context, input *DeleteApnsVoipSandboxChannelInput, opts ...request.Option) (*DeleteApnsVoipSandboxChannelOutput, error) {
	req, out := c.DeleteApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp
func (c *Pinpoint) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApp API operation for Amazon Pinpoint.
//
// Deletes an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp
func (c *Pinpoint) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBaiduChannel = "DeleteBaiduChannel"

// DeleteBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBaiduChannel for more information on using the DeleteBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBaiduChannelRequest method.
//    req, resp := client.DeleteBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel
func (c *Pinpoint) DeleteBaiduChannelRequest(input *DeleteBaiduChannelInput) (req *request.Request, output *DeleteBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteBaiduChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &DeleteBaiduChannelInput{}
	}

	output = &DeleteBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBaiduChannel API operation for Amazon Pinpoint.
//
// Disables the Baidu channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteBaiduChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel
func (c *Pinpoint) DeleteBaiduChannel(input *DeleteBaiduChannelInput) (*DeleteBaiduChannelOutput, error) {
	req, out := c.DeleteBaiduChannelRequest(input)
	return out, req.Send()
}

// DeleteBaiduChannelWithContext is the same as DeleteBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteBaiduChannelWithContext(ctx aws.Context, input *DeleteBaiduChannelInput, opts ...request.Option) (*DeleteBaiduChannelOutput, error) {
	req, out := c.DeleteBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCampaignRequest method.
//    req, resp := client.DeleteCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign
func (c *Pinpoint) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCampaign API operation for Amazon Pinpoint.
//
// Deletes a campaign from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign
func (c *Pinpoint) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailChannel = "DeleteEmailChannel"

// DeleteEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailChannel for more information on using the DeleteEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailChannelRequest method.
//    req, resp := client.DeleteEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel
func (c *Pinpoint) DeleteEmailChannelRequest(input *DeleteEmailChannelInput) (req *request.Request, output *DeleteEmailChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &DeleteEmailChannelInput{}
	}

	output = &DeleteEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEmailChannel API operation for Amazon Pinpoint.
//
// Disables the email channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEmailChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel
func (c *Pinpoint) DeleteEmailChannel(input *DeleteEmailChannelInput) (*DeleteEmailChannelOutput, error) {
	req, out := c.DeleteEmailChannelRequest(input)
	return out, req.Send()
}

// DeleteEmailChannelWithContext is the same as DeleteEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEmailChannelWithContext(ctx aws.Context, input *DeleteEmailChannelInput, opts ...request.Option) (*DeleteEmailChannelOutput, error) {
	req, out := c.DeleteEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint
func (c *Pinpoint) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpoint API operation for Amazon Pinpoint.
//
// Deletes an endpoint from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint
func (c *Pinpoint) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventStream = "DeleteEventStream"

// DeleteEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventStream for more information on using the DeleteEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventStreamRequest method.
//    req, resp := client.DeleteEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream
func (c *Pinpoint) DeleteEventStreamRequest(input *DeleteEventStreamInput) (req *request.Request, output *DeleteEventStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteEventStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &DeleteEventStreamInput{}
	}

	output = &DeleteEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventStream API operation for Amazon Pinpoint.
//
// Deletes the event stream for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEventStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream
func (c *Pinpoint) DeleteEventStream(input *DeleteEventStreamInput) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	return out, req.Send()
}

// DeleteEventStreamWithContext is the same as DeleteEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEventStreamWithContext(ctx aws.Context, input *DeleteEventStreamInput, opts ...request.Option) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGcmChannel = "DeleteGcmChannel"

// DeleteGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGcmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGcmChannel for more information on using the DeleteGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGcmChannelRequest method.
//    req, resp := client.DeleteGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannelRequest(input *DeleteGcmChannelInput) (req *request.Request, output *DeleteGcmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteGcmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &DeleteGcmChannelInput{}
	}

	output = &DeleteGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGcmChannel API operation for Amazon Pinpoint.
//
// Disables the GCM channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannel(input *DeleteGcmChannelInput) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	return out, req.Send()
}

// DeleteGcmChannelWithContext is the same as DeleteGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteGcmChannelWithContext(ctx aws.Context, input *DeleteGcmChannelInput, opts ...request.Option) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSegment = "DeleteSegment"

// DeleteSegmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSegment for more information on using the DeleteSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSegmentRequest method.
//    req, resp := client.DeleteSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment
func (c *Pinpoint) DeleteSegmentRequest(input *DeleteSegmentInput) (req *request.Request, output *DeleteSegmentOutput) {
	op := &request.Operation{
		Name:       opDeleteSegment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &DeleteSegmentInput{}
	}

	output = &DeleteSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSegment API operation for Amazon Pinpoint.
//
// Deletes a segment from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment
func (c *Pinpoint) DeleteSegment(input *DeleteSegmentInput) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	return out, req.Send()
}

// DeleteSegmentWithContext is the same as DeleteSegment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSegmentWithContext(ctx aws.Context, input *DeleteSegmentInput, opts ...request.Option) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSmsChannel = "DeleteSmsChannel"

// DeleteSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSmsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSmsChannel for more information on using the DeleteSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSmsChannelRequest method.
//    req, resp := client.DeleteSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel
func (c *Pinpoint) DeleteSmsChannelRequest(input *DeleteSmsChannelInput) (req *request.Request, output *DeleteSmsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteSmsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &DeleteSmsChannelInput{}
	}

	output = &DeleteSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSmsChannel API operation for Amazon Pinpoint.
//
// Disables the SMS channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSmsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel
func (c *Pinpoint) DeleteSmsChannel(input *DeleteSmsChannelInput) (*DeleteSmsChannelOutput, error) {
	req, out := c.DeleteSmsChannelRequest(input)
	return out, req.Send()
}

// DeleteSmsChannelWithContext is the same as DeleteSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSmsChannelWithContext(ctx aws.Context, input *DeleteSmsChannelInput, opts ...request.Option) (*DeleteSmsChannelOutput, error) {
	req, out := c.DeleteSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserEndpoints = "DeleteUserEndpoints"

// DeleteUserEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserEndpoints for more information on using the DeleteUserEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserEndpointsRequest method.
//    req, resp := client.DeleteUserEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints
func (c *Pinpoint) DeleteUserEndpointsRequest(input *DeleteUserEndpointsInput) (req *request.Request, output *DeleteUserEndpointsOutput) {
	op := &request.Operation{
		Name:       opDeleteUserEndpoints,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/users/{user-id}",
	}

	if input == nil {
		input = &DeleteUserEndpointsInput{}
	}

	output = &DeleteUserEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserEndpoints API operation for Amazon Pinpoint.
//
// Deletes all the endpoints that are associated with a specific user ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteUserEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints
func (c *Pinpoint) DeleteUserEndpoints(input *DeleteUserEndpointsInput) (*DeleteUserEndpointsOutput, error) {
	req, out := c.DeleteUserEndpointsRequest(input)
	return out, req.Send()
}

// DeleteUserEndpointsWithContext is the same as DeleteUserEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteUserEndpointsWithContext(ctx aws.Context, input *DeleteUserEndpointsInput, opts ...request.Option) (*DeleteUserEndpointsOutput, error) {
	req, out := c.DeleteUserEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceChannel = "DeleteVoiceChannel"

// DeleteVoiceChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceChannel for more information on using the DeleteVoiceChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceChannelRequest method.
//    req, resp := client.DeleteVoiceChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel
func (c *Pinpoint) DeleteVoiceChannelRequest(input *DeleteVoiceChannelInput) (req *request.Request, output *DeleteVoiceChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &DeleteVoiceChannelInput{}
	}

	output = &DeleteVoiceChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVoiceChannel API operation for Amazon Pinpoint.
//
// Disables the voice channel for an application and deletes any existing settings
// for the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteVoiceChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel
func (c *Pinpoint) DeleteVoiceChannel(input *DeleteVoiceChannelInput) (*DeleteVoiceChannelOutput, error) {
	req, out := c.DeleteVoiceChannelRequest(input)
	return out, req.Send()
}

// DeleteVoiceChannelWithContext is the same as DeleteVoiceChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteVoiceChannelWithContext(ctx aws.Context, input *DeleteVoiceChannelInput, opts ...request.Option) (*DeleteVoiceChannelOutput, error) {
	req, out := c.DeleteVoiceChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdmChannel = "GetAdmChannel"

// GetAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetAdmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdmChannel for more information on using the GetAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAdmChannelRequest method.
//    req, resp := client.GetAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Pinpoint) GetAdmChannelRequest(input *GetAdmChannelInput) (req *request.Request, output *GetAdmChannelOutput) {
	op := &request.Operation{
		Name:       opGetAdmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &GetAdmChannelInput{}
	}

	output = &GetAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdmChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the ADM channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetAdmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Pinpoint) GetAdmChannel(input *GetAdmChannelInput) (*GetAdmChannelOutput, error) {
	req, out := c.GetAdmChannelRequest(input)
	return out, req.Send()
}

// GetAdmChannelWithContext is the same as GetAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAdmChannelWithContext(ctx aws.Context, input *GetAdmChannelInput, opts ...request.Option) (*GetAdmChannelOutput, error) {
	req, out := c.GetAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsChannel = "GetApnsChannel"

// GetApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsChannel for more information on using the GetApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsChannelRequest method.
//    req, resp := client.GetApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Pinpoint) GetApnsChannelRequest(input *GetApnsChannelInput) (req *request.Request, output *GetApnsChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &GetApnsChannelInput{}
	}

	output = &GetApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Pinpoint) GetApnsChannel(input *GetApnsChannelInput) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	return out, req.Send()
}

// GetApnsChannelWithContext is the same as GetApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsChannelWithContext(ctx aws.Context, input *GetApnsChannelInput, opts ...request.Option) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsSandboxChannel = "GetApnsSandboxChannel"

// GetApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsSandboxChannel for more information on using the GetApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsSandboxChannelRequest method.
//    req, resp := client.GetApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Pinpoint) GetApnsSandboxChannelRequest(input *GetApnsSandboxChannelInput) (req *request.Request, output *GetApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &GetApnsSandboxChannelInput{}
	}

	output = &GetApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs sandbox channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Pinpoint) GetApnsSandboxChannel(input *GetApnsSandboxChannelInput) (*GetApnsSandboxChannelOutput, error) {
	req, out := c.GetApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// GetApnsSandboxChannelWithContext is the same as GetApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsSandboxChannelWithContext(ctx aws.Context, input *GetApnsSandboxChannelInput, opts ...request.Option) (*GetApnsSandboxChannelOutput, error) {
	req, out := c.GetApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsVoipChannel = "GetApnsVoipChannel"

// GetApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsVoipChannel for more information on using the GetApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsVoipChannelRequest method.
//    req, resp := client.GetApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel
func (c *Pinpoint) GetApnsVoipChannelRequest(input *GetApnsVoipChannelInput) (req *request.Request, output *GetApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsVoipChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &GetApnsVoipChannelInput{}
	}

	output = &GetApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsVoipChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs VoIP channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsVoipChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel
func (c *Pinpoint) GetApnsVoipChannel(input *GetApnsVoipChannelInput) (*GetApnsVoipChannelOutput, error) {
	req, out := c.GetApnsVoipChannelRequest(input)
	return out, req.Send()
}

// GetApnsVoipChannelWithContext is the same as GetApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsVoipChannelWithContext(ctx aws.Context, input *GetApnsVoipChannelInput, opts ...request.Option) (*GetApnsVoipChannelOutput, error) {
	req, out := c.GetApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsVoipSandboxChannel = "GetApnsVoipSandboxChannel"

// GetApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsVoipSandboxChannel for more information on using the GetApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsVoipSandboxChannelRequest method.
//    req, resp := client.GetApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Pinpoint) GetApnsVoipSandboxChannelRequest(input *GetApnsVoipSandboxChannelInput) (req *request.Request, output *GetApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsVoipSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &GetApnsVoipSandboxChannelInput{}
	}

	output = &GetApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs VoIP sandbox
// channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Pinpoint) GetApnsVoipSandboxChannel(input *GetApnsVoipSandboxChannelInput) (*GetApnsVoipSandboxChannelOutput, error) {
	req, out := c.GetApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// GetApnsVoipSandboxChannelWithContext is the same as GetApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsVoipSandboxChannelWithContext(ctx aws.Context, input *GetApnsVoipSandboxChannelInput, opts ...request.Option) (*GetApnsVoipSandboxChannelOutput, error) {
	req, out := c.GetApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApp = "GetApp"

// GetAppRequest generates a "aws/request.Request" representing the
// client's request for the GetApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApp for more information on using the GetApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppRequest method.
//    req, resp := client.GetAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp
func (c *Pinpoint) GetAppRequest(input *GetAppInput) (req *request.Request, output *GetAppOutput) {
	op := &request.Operation{
		Name:       opGetApp,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}",
	}

	if input == nil {
		input = &GetAppInput{}
	}

	output = &GetAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApp API operation for Amazon Pinpoint.
//
// Retrieves information about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp
func (c *Pinpoint) GetApp(input *GetAppInput) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	return out, req.Send()
}

// GetAppWithContext is the same as GetApp with the addition of
// the ability to pass a context and additional request options.
//
// See GetApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAppWithContext(ctx aws.Context, input *GetAppInput, opts ...request.Option) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationDateRangeKpi = "GetApplicationDateRangeKpi"

// GetApplicationDateRangeKpiRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationDateRangeKpi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationDateRangeKpi for more information on using the GetApplicationDateRangeKpi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationDateRangeKpiRequest method.
//    req, resp := client.GetApplicationDateRangeKpiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi
func (c *Pinpoint) GetApplicationDateRangeKpiRequest(input *GetApplicationDateRangeKpiInput) (req *request.Request, output *GetApplicationDateRangeKpiOutput) {
	op := &request.Operation{
		Name:       opGetApplicationDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetApplicationDateRangeKpiInput{}
	}

	output = &GetApplicationDateRangeKpiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationDateRangeKpi API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard metric that applies
// to an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApplicationDateRangeKpi for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi
func (c *Pinpoint) GetApplicationDateRangeKpi(input *GetApplicationDateRangeKpiInput) (*GetApplicationDateRangeKpiOutput, error) {
	req, out := c.GetApplicationDateRangeKpiRequest(input)
	return out, req.Send()
}

// GetApplicationDateRangeKpiWithContext is the same as GetApplicationDateRangeKpi with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationDateRangeKpi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApplicationDateRangeKpiWithContext(ctx aws.Context, input *GetApplicationDateRangeKpiInput, opts ...request.Option) (*GetApplicationDateRangeKpiOutput, error) {
	req, out := c.GetApplicationDateRangeKpiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationSettings = "GetApplicationSettings"

// GetApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationSettings for more information on using the GetApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationSettingsRequest method.
//    req, resp := client.GetApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings
func (c *Pinpoint) GetApplicationSettingsRequest(input *GetApplicationSettingsInput) (req *request.Request, output *GetApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opGetApplicationSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &GetApplicationSettingsInput{}
	}

	output = &GetApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationSettings API operation for Amazon Pinpoint.
//
// Retrieves information about the settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApplicationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings
func (c *Pinpoint) GetApplicationSettings(input *GetApplicationSettingsInput) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	return out, req.Send()
}

// GetApplicationSettingsWithContext is the same as GetApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApplicationSettingsWithContext(ctx aws.Context, input *GetApplicationSettingsInput, opts ...request.Option) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApps = "GetApps"

// GetAppsRequest generates a "aws/request.Request" representing the
// client's request for the GetApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApps for more information on using the GetApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppsRequest method.
//    req, resp := client.GetAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps
func (c *Pinpoint) GetAppsRequest(input *GetAppsInput) (req *request.Request, output *GetAppsOutput) {
	op := &request.Operation{
		Name:       opGetApps,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps",
	}

	if input == nil {
		input = &GetAppsInput{}
	}

	output = &GetAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApps API operation for Amazon Pinpoint.
//
// Retrieves information about all of your applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApps for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps
func (c *Pinpoint) GetApps(input *GetAppsInput) (*GetAppsOutput, error) {
	req, out := c.GetAppsRequest(input)
	return out, req.Send()
}

// GetAppsWithContext is the same as GetApps with the addition of
// the ability to pass a context and additional request options.
//
// See GetApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAppsWithContext(ctx aws.Context, input *GetAppsInput, opts ...request.Option) (*GetAppsOutput, error) {
	req, out := c.GetAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBaiduChannel = "GetBaiduChannel"

// GetBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBaiduChannel for more information on using the GetBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBaiduChannelRequest method.
//    req, resp := client.GetBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Pinpoint) GetBaiduChannelRequest(input *GetBaiduChannelInput) (req *request.Request, output *GetBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opGetBaiduChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &GetBaiduChannelInput{}
	}

	output = &GetBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBaiduChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the Baidu Cloud Push
// channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetBaiduChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Pinpoint) GetBaiduChannel(input *GetBaiduChannelInput) (*GetBaiduChannelOutput, error) {
	req, out := c.GetBaiduChannelRequest(input)
	return out, req.Send()
}

// GetBaiduChannelWithContext is the same as GetBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetBaiduChannelWithContext(ctx aws.Context, input *GetBaiduChannelInput, opts ...request.Option) (*GetBaiduChannelOutput, error) {
	req, out := c.GetBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaign = "GetCampaign"

// GetCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaign for more information on using the GetCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignRequest method.
//    req, resp := client.GetCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Pinpoint) GetCampaignRequest(input *GetCampaignInput) (req *request.Request, output *GetCampaignOutput) {
	op := &request.Operation{
		Name:       opGetCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &GetCampaignInput{}
	}

	output = &GetCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaign API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Pinpoint) GetCampaign(input *GetCampaignInput) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	return out, req.Send()
}

// GetCampaignWithContext is the same as GetCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignWithContext(ctx aws.Context, input *GetCampaignInput, opts ...request.Option) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignActivities = "GetCampaignActivities"

// GetCampaignActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignActivities for more information on using the GetCampaignActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignActivitiesRequest method.
//    req, resp := client.GetCampaignActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities
func (c *Pinpoint) GetCampaignActivitiesRequest(input *GetCampaignActivitiesInput) (req *request.Request, output *GetCampaignActivitiesOutput) {
	op := &request.Operation{
		Name:       opGetCampaignActivities,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
	}

	if input == nil {
		input = &GetCampaignActivitiesInput{}
	}

	output = &GetCampaignActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignActivities API operation for Amazon Pinpoint.
//
// Retrieves information about the activity performed by a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignActivities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities
func (c *Pinpoint) GetCampaignActivities(input *GetCampaignActivitiesInput) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	return out, req.Send()
}

// GetCampaignActivitiesWithContext is the same as GetCampaignActivities with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignActivitiesWithContext(ctx aws.Context, input *GetCampaignActivitiesInput, opts ...request.Option) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignDateRangeKpi = "GetCampaignDateRangeKpi"

// GetCampaignDateRangeKpiRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignDateRangeKpi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignDateRangeKpi for more information on using the GetCampaignDateRangeKpi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignDateRangeKpiRequest method.
//    req, resp := client.GetCampaignDateRangeKpiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi
func (c *Pinpoint) GetCampaignDateRangeKpiRequest(input *GetCampaignDateRangeKpiInput) (req *request.Request, output *GetCampaignDateRangeKpiOutput) {
	op := &request.Operation{
		Name:       opGetCampaignDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetCampaignDateRangeKpiInput{}
	}

	output = &GetCampaignDateRangeKpiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignDateRangeKpi API operation for Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard metric that applies
// to a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignDateRangeKpi for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi
func (c *Pinpoint) GetCampaignDateRangeKpi(input *GetCampaignDateRangeKpiInput) (*GetCampaignDateRangeKpiOutput, error) {
	req, out := c.GetCampaignDateRangeKpiRequest(input)
	return out, req.Send()
}

// GetCampaignDateRangeKpiWithContext is the same as GetCampaignDateRangeKpi with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignDateRangeKpi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignDateRangeKpiWithContext(ctx aws.Context, input *GetCampaignDateRangeKpiInput, opts ...request.Option) (*GetCampaignDateRangeKpiOutput, error) {
	req, out := c.GetCampaignDateRangeKpiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignVersion = "GetCampaignVersion"

// GetCampaignVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignVersion for more information on using the GetCampaignVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignVersionRequest method.
//    req, resp := client.GetCampaignVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion
func (c *Pinpoint) GetCampaignVersionRequest(input *GetCampaignVersionInput) (req *request.Request, output *GetCampaignVersionOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
	}

	if input == nil {
		input = &GetCampaignVersionInput{}
	}

	output = &GetCampaignVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersion API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for a specific version of a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion
func (c *Pinpoint) GetCampaignVersion(input *GetCampaignVersionInput) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	return out, req.Send()
}

// GetCampaignVersionWithContext is the same as GetCampaignVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignVersionWithContext(ctx aws.Context, input *GetCampaignVersionInput, opts ...request.Option) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignVersions = "GetCampaignVersions"

// GetCampaignVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignVersions for more information on using the GetCampaignVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignVersionsRequest method.
//    req, resp := client.GetCampaignVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions
func (c *Pinpoint) GetCampaignVersionsRequest(input *GetCampaignVersionsInput) (req *request.Request, output *GetCampaignVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
	}

	if input == nil {
		input = &GetCampaignVersionsInput{}
	}

	output = &GetCampaignVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersions API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for all versions of a specific campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions
func (c *Pinpoint) GetCampaignVersions(input *GetCampaignVersionsInput) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	return out, req.Send()
}

// GetCampaignVersionsWithContext is the same as GetCampaignVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignVersionsWithContext(ctx aws.Context, input *GetCampaignVersionsInput, opts ...request.Option) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaigns = "GetCampaigns"

// GetCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaigns for more information on using the GetCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignsRequest method.
//    req, resp := client.GetCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns
func (c *Pinpoint) GetCampaignsRequest(input *GetCampaignsInput) (req *request.Request, output *GetCampaignsOutput) {
	op := &request.Operation{
		Name:       opGetCampaigns,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &GetCampaignsInput{}
	}

	output = &GetCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaigns API operation for Amazon Pinpoint.
//
// Retrieves information about the status, configuration, and other settings
// for all the campaigns that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaigns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns
func (c *Pinpoint) GetCampaigns(input *GetCampaignsInput) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	return out, req.Send()
}

// GetCampaignsWithContext is the same as GetCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignsWithContext(ctx aws.Context, input *GetCampaignsInput, opts ...request.Option) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannels = "GetChannels"

// GetChannelsRequest generates a "aws/request.Request" representing the
// client's request for the GetChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannels for more information on using the GetChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChannelsRequest method.
//    req, resp := client.GetChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels
func (c *Pinpoint) GetChannelsRequest(input *GetChannelsInput) (req *request.Request, output *GetChannelsOutput) {
	op := &request.Operation{
		Name:       opGetChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels",
	}

	if input == nil {
		input = &GetChannelsInput{}
	}

	output = &GetChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannels API operation for Amazon Pinpoint.
//
// Retrieves information about the history and status of each channel for an
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetChannels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels
func (c *Pinpoint) GetChannels(input *GetChannelsInput) (*GetChannelsOutput, error) {
	req, out := c.GetChannelsRequest(input)
	return out, req.Send()
}

// GetChannelsWithContext is the same as GetChannels with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetChannelsWithContext(ctx aws.Context, input *GetChannelsInput, opts ...request.Option) (*GetChannelsOutput, error) {
	req, out := c.GetChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailChannel = "GetEmailChannel"

// GetEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailChannel for more information on using the GetEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailChannelRequest method.
//    req, resp := client.GetEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel
func (c *Pinpoint) GetEmailChannelRequest(input *GetEmailChannelInput) (req *request.Request, output *GetEmailChannelOutput) {
	op := &request.Operation{
		Name:       opGetEmailChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &GetEmailChannelInput{}
	}

	output = &GetEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the email channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEmailChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel
func (c *Pinpoint) GetEmailChannel(input *GetEmailChannelInput) (*GetEmailChannelOutput, error) {
	req, out := c.GetEmailChannelRequest(input)
	return out, req.Send()
}

// GetEmailChannelWithContext is the same as GetEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEmailChannelWithContext(ctx aws.Context, input *GetEmailChannelInput, opts ...request.Option) (*GetEmailChannelOutput, error) {
	req, out := c.GetEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEndpoint = "GetEndpoint"

// GetEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEndpoint for more information on using the GetEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEndpointRequest method.
//    req, resp := client.GetEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint
func (c *Pinpoint) GetEndpointRequest(input *GetEndpointInput) (req *request.Request, output *GetEndpointOutput) {
	op := &request.Operation{
		Name:       opGetEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &GetEndpointInput{}
	}

	output = &GetEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpoint API operation for Amazon Pinpoint.
//
// Retrieves information about the settings and attributes of a specific endpoint
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint
func (c *Pinpoint) GetEndpoint(input *GetEndpointInput) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	return out, req.Send()
}

// GetEndpointWithContext is the same as GetEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEndpointWithContext(ctx aws.Context, input *GetEndpointInput, opts ...request.Option) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventStream = "GetEventStream"

// GetEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventStream for more information on using the GetEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventStreamRequest method.
//    req, resp := client.GetEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream
func (c *Pinpoint) GetEventStreamRequest(input *GetEventStreamInput) (req *request.Request, output *GetEventStreamOutput) {
	op := &request.Operation{
		Name:       opGetEventStream,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &GetEventStreamInput{}
	}

	output = &GetEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventStream API operation for Amazon Pinpoint.
//
// Retrieves information about the event stream settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEventStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream
func (c *Pinpoint) GetEventStream(input *GetEventStreamInput) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	return out, req.Send()
}

// GetEventStreamWithContext is the same as GetEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEventStreamWithContext(ctx aws.Context, input *GetEventStreamInput, opts ...request.Option) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportJob = "GetExportJob"

// GetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportJob for more information on using the GetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportJobRequest method.
//    req, resp := client.GetExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob
func (c *Pinpoint) GetExportJobRequest(input *GetExportJobInput) (req *request.Request, output *GetExportJobOutput) {
	op := &request.Operation{
		Name:       opGetExportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export/{job-id}",
	}

	if input == nil {
		input = &GetExportJobInput{}
	}

	output = &GetExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportJob API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of a specific export
// job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetExportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob
func (c *Pinpoint) GetExportJob(input *GetExportJobInput) (*GetExportJobOutput, error) {
	req, out := c.GetExportJobRequest(input)
	return out, req.Send()
}

// GetExportJobWithContext is the same as GetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetExportJobWithContext(ctx aws.Context, input *GetExportJobInput, opts ...request.Option) (*GetExportJobOutput, error) {
	req, out := c.GetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportJobs = "GetExportJobs"

// GetExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportJobs for more information on using the GetExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportJobsRequest method.
//    req, resp := client.GetExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs
func (c *Pinpoint) GetExportJobsRequest(input *GetExportJobsInput) (req *request.Request, output *GetExportJobsOutput) {
	op := &request.Operation{
		Name:       opGetExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &GetExportJobsInput{}
	}

	output = &GetExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of all the export jobs
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetExportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs
func (c *Pinpoint) GetExportJobs(input *GetExportJobsInput) (*GetExportJobsOutput, error) {
	req, out := c.GetExportJobsRequest(input)
	return out, req.Send()
}

// GetExportJobsWithContext is the same as GetExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetExportJobsWithContext(ctx aws.Context, input *GetExportJobsInput, opts ...request.Option) (*GetExportJobsOutput, error) {
	req, out := c.GetExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGcmChannel = "GetGcmChannel"

// GetGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetGcmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGcmChannel for more information on using the GetGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGcmChannelRequest method.
//    req, resp := client.GetGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Pinpoint) GetGcmChannelRequest(input *GetGcmChannelInput) (req *request.Request, output *GetGcmChannelOutput) {
	op := &request.Operation{
		Name:       opGetGcmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &GetGcmChannelInput{}
	}

	output = &GetGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGcmChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the GCM channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Pinpoint) GetGcmChannel(input *GetGcmChannelInput) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	return out, req.Send()
}

// GetGcmChannelWithContext is the same as GetGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetGcmChannelWithContext(ctx aws.Context, input *GetGcmChannelInput, opts ...request.Option) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJob = "GetImportJob"

// GetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJob for more information on using the GetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobRequest method.
//    req, resp := client.GetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob
func (c *Pinpoint) GetImportJobRequest(input *GetImportJobInput) (req *request.Request, output *GetImportJobOutput) {
	op := &request.Operation{
		Name:       opGetImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import/{job-id}",
	}

	if input == nil {
		input = &GetImportJobInput{}
	}

	output = &GetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJob API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of a specific import
// job for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob
func (c *Pinpoint) GetImportJob(input *GetImportJobInput) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	return out, req.Send()
}

// GetImportJobWithContext is the same as GetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetImportJobWithContext(ctx aws.Context, input *GetImportJobInput, opts ...request.Option) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJobs = "GetImportJobs"

// GetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJobs for more information on using the GetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobsRequest method.
//    req, resp := client.GetImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs
func (c *Pinpoint) GetImportJobsRequest(input *GetImportJobsInput) (req *request.Request, output *GetImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &GetImportJobsInput{}
	}

	output = &GetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of all the import jobs
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs
func (c *Pinpoint) GetImportJobs(input *GetImportJobsInput) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	return out, req.Send()
}

// GetImportJobsWithContext is the same as GetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetImportJobsWithContext(ctx aws.Context, input *GetImportJobsInput, opts ...request.Option) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegment = "GetSegment"

// GetSegmentRequest generates a "aws/request.Request" representing the
// client's request for the GetSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegment for more information on using the GetSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentRequest method.
//    req, resp := client.GetSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Pinpoint) GetSegmentRequest(input *GetSegmentInput) (req *request.Request, output *GetSegmentOutput) {
	op := &request.Operation{
		Name:       opGetSegment,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &GetSegmentInput{}
	}

	output = &GetSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegment API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for a specific segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Pinpoint) GetSegment(input *GetSegmentInput) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	return out, req.Send()
}

// GetSegmentWithContext is the same as GetSegment with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentWithContext(ctx aws.Context, input *GetSegmentInput, opts ...request.Option) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentExportJobs = "GetSegmentExportJobs"

// GetSegmentExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentExportJobs for more information on using the GetSegmentExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentExportJobsRequest method.
//    req, resp := client.GetSegmentExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs
func (c *Pinpoint) GetSegmentExportJobsRequest(input *GetSegmentExportJobsInput) (req *request.Request, output *GetSegmentExportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/export",
	}

	if input == nil {
		input = &GetSegmentExportJobsInput{}
	}

	output = &GetSegmentExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentExportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the export jobs for
// a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentExportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs
func (c *Pinpoint) GetSegmentExportJobs(input *GetSegmentExportJobsInput) (*GetSegmentExportJobsOutput, error) {
	req, out := c.GetSegmentExportJobsRequest(input)
	return out, req.Send()
}

// GetSegmentExportJobsWithContext is the same as GetSegmentExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentExportJobsWithContext(ctx aws.Context, input *GetSegmentExportJobsInput, opts ...request.Option) (*GetSegmentExportJobsOutput, error) {
	req, out := c.GetSegmentExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentImportJobs = "GetSegmentImportJobs"

// GetSegmentImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentImportJobs for more information on using the GetSegmentImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentImportJobsRequest method.
//    req, resp := client.GetSegmentImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobsRequest(input *GetSegmentImportJobsInput) (req *request.Request, output *GetSegmentImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
	}

	if input == nil {
		input = &GetSegmentImportJobsInput{}
	}

	output = &GetSegmentImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentImportJobs API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the import jobs for
// a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobs(input *GetSegmentImportJobsInput) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	return out, req.Send()
}

// GetSegmentImportJobsWithContext is the same as GetSegmentImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentImportJobsWithContext(ctx aws.Context, input *GetSegmentImportJobsInput, opts ...request.Option) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentVersion = "GetSegmentVersion"

// GetSegmentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentVersion for more information on using the GetSegmentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentVersionRequest method.
//    req, resp := client.GetSegmentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Pinpoint) GetSegmentVersionRequest(input *GetSegmentVersionInput) (req *request.Request, output *GetSegmentVersionOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
	}

	if input == nil {
		input = &GetSegmentVersionInput{}
	}

	output = &GetSegmentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersion API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for a specific version of a segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Pinpoint) GetSegmentVersion(input *GetSegmentVersionInput) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	return out, req.Send()
}

// GetSegmentVersionWithContext is the same as GetSegmentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentVersionWithContext(ctx aws.Context, input *GetSegmentVersionInput, opts ...request.Option) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentVersions = "GetSegmentVersions"

// GetSegmentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentVersions for more information on using the GetSegmentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentVersionsRequest method.
//    req, resp := client.GetSegmentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions
func (c *Pinpoint) GetSegmentVersionsRequest(input *GetSegmentVersionsInput) (req *request.Request, output *GetSegmentVersionsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions",
	}

	if input == nil {
		input = &GetSegmentVersionsInput{}
	}

	output = &GetSegmentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersions API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for all versions of a specific segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions
func (c *Pinpoint) GetSegmentVersions(input *GetSegmentVersionsInput) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	return out, req.Send()
}

// GetSegmentVersionsWithContext is the same as GetSegmentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentVersionsWithContext(ctx aws.Context, input *GetSegmentVersionsInput, opts ...request.Option) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegments = "GetSegments"

// GetSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegments for more information on using the GetSegments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentsRequest method.
//    req, resp := client.GetSegmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments
func (c *Pinpoint) GetSegmentsRequest(input *GetSegmentsInput) (req *request.Request, output *GetSegmentsOutput) {
	op := &request.Operation{
		Name:       opGetSegments,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &GetSegmentsInput{}
	}

	output = &GetSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegments API operation for Amazon Pinpoint.
//
// Retrieves information about the configuration, dimension, and other settings
// for all the segments that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments
func (c *Pinpoint) GetSegments(input *GetSegmentsInput) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	return out, req.Send()
}

// GetSegmentsWithContext is the same as GetSegments with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentsWithContext(ctx aws.Context, input *GetSegmentsInput, opts ...request.Option) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSmsChannel = "GetSmsChannel"

// GetSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetSmsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSmsChannel for more information on using the GetSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSmsChannelRequest method.
//    req, resp := client.GetSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel
func (c *Pinpoint) GetSmsChannelRequest(input *GetSmsChannelInput) (req *request.Request, output *GetSmsChannelOutput) {
	op := &request.Operation{
		Name:       opGetSmsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &GetSmsChannelInput{}
	}

	output = &GetSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSmsChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the SMS channel for
// an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSmsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel
func (c *Pinpoint) GetSmsChannel(input *GetSmsChannelInput) (*GetSmsChannelOutput, error) {
	req, out := c.GetSmsChannelRequest(input)
	return out, req.Send()
}

// GetSmsChannelWithContext is the same as GetSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSmsChannelWithContext(ctx aws.Context, input *GetSmsChannelInput, opts ...request.Option) (*GetSmsChannelOutput, error) {
	req, out := c.GetSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserEndpoints = "GetUserEndpoints"

// GetUserEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserEndpoints for more information on using the GetUserEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserEndpointsRequest method.
//    req, resp := client.GetUserEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints
func (c *Pinpoint) GetUserEndpointsRequest(input *GetUserEndpointsInput) (req *request.Request, output *GetUserEndpointsOutput) {
	op := &request.Operation{
		Name:       opGetUserEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/users/{user-id}",
	}

	if input == nil {
		input = &GetUserEndpointsInput{}
	}

	output = &GetUserEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserEndpoints API operation for Amazon Pinpoint.
//
// Retrieves information about all the endpoints that are associated with a
// specific user ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetUserEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints
func (c *Pinpoint) GetUserEndpoints(input *GetUserEndpointsInput) (*GetUserEndpointsOutput, error) {
	req, out := c.GetUserEndpointsRequest(input)
	return out, req.Send()
}

// GetUserEndpointsWithContext is the same as GetUserEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetUserEndpointsWithContext(ctx aws.Context, input *GetUserEndpointsInput, opts ...request.Option) (*GetUserEndpointsOutput, error) {
	req, out := c.GetUserEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceChannel = "GetVoiceChannel"

// GetVoiceChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceChannel for more information on using the GetVoiceChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceChannelRequest method.
//    req, resp := client.GetVoiceChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel
func (c *Pinpoint) GetVoiceChannelRequest(input *GetVoiceChannelInput) (req *request.Request, output *GetVoiceChannelOutput) {
	op := &request.Operation{
		Name:       opGetVoiceChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &GetVoiceChannelInput{}
	}

	output = &GetVoiceChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceChannel API operation for Amazon Pinpoint.
//
// Retrieves information about the status and settings of the voice channel
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetVoiceChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel
func (c *Pinpoint) GetVoiceChannel(input *GetVoiceChannelInput) (*GetVoiceChannelOutput, error) {
	req, out := c.GetVoiceChannelRequest(input)
	return out, req.Send()
}

// GetVoiceChannelWithContext is the same as GetVoiceChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetVoiceChannelWithContext(ctx aws.Context, input *GetVoiceChannelInput, opts ...request.Option) (*GetVoiceChannelOutput, error) {
	req, out := c.GetVoiceChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource
func (c *Pinpoint) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Pinpoint.
//
// Retrieves all the tags (keys and values) that are associated with an application,
// campaign, or segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource
func (c *Pinpoint) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPhoneNumberValidate = "PhoneNumberValidate"

// PhoneNumberValidateRequest generates a "aws/request.Request" representing the
// client's request for the PhoneNumberValidate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PhoneNumberValidate for more information on using the PhoneNumberValidate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PhoneNumberValidateRequest method.
//    req, resp := client.PhoneNumberValidateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate
func (c *Pinpoint) PhoneNumberValidateRequest(input *PhoneNumberValidateInput) (req *request.Request, output *PhoneNumberValidateOutput) {
	op := &request.Operation{
		Name:       opPhoneNumberValidate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/phone/number/validate",
	}

	if input == nil {
		input = &PhoneNumberValidateInput{}
	}

	output = &PhoneNumberValidateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PhoneNumberValidate API operation for Amazon Pinpoint.
//
// Retrieves information about a phone number.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PhoneNumberValidate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate
func (c *Pinpoint) PhoneNumberValidate(input *PhoneNumberValidateInput) (*PhoneNumberValidateOutput, error) {
	req, out := c.PhoneNumberValidateRequest(input)
	return out, req.Send()
}

// PhoneNumberValidateWithContext is the same as PhoneNumberValidate with the addition of
// the ability to pass a context and additional request options.
//
// See PhoneNumberValidate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PhoneNumberValidateWithContext(ctx aws.Context, input *PhoneNumberValidateInput, opts ...request.Option) (*PhoneNumberValidateOutput, error) {
	req, out := c.PhoneNumberValidateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventStream = "PutEventStream"

// PutEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the PutEventStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventStream for more information on using the PutEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventStreamRequest method.
//    req, resp := client.PutEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Pinpoint) PutEventStreamRequest(input *PutEventStreamInput) (req *request.Request, output *PutEventStreamOutput) {
	op := &request.Operation{
		Name:       opPutEventStream,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &PutEventStreamInput{}
	}

	output = &PutEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventStream API operation for Amazon Pinpoint.
//
// Creates a new event stream for an application or updates the settings of
// an existing event stream for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PutEventStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Pinpoint) PutEventStream(input *PutEventStreamInput) (*PutEventStreamOutput, error) {
	req, out := c.PutEventStreamRequest(input)
	return out, req.Send()
}

// PutEventStreamWithContext is the same as PutEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PutEventStreamWithContext(ctx aws.Context, input *PutEventStreamInput, opts ...request.Option) (*PutEventStreamOutput, error) {
	req, out := c.PutEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvents = "PutEvents"

// PutEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvents for more information on using the PutEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventsRequest method.
//    req, resp := client.PutEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents
func (c *Pinpoint) PutEventsRequest(input *PutEventsInput) (req *request.Request, output *PutEventsOutput) {
	op := &request.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/events",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	output = &PutEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvents API operation for Amazon Pinpoint.
//
// Creates a new event to record for endpoints, or creates or updates endpoint
// data that existing events are associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PutEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents
func (c *Pinpoint) PutEvents(input *PutEventsInput) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	return out, req.Send()
}

// PutEventsWithContext is the same as PutEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PutEventsWithContext(ctx aws.Context, input *PutEventsInput, opts ...request.Option) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAttributes = "RemoveAttributes"

// RemoveAttributesRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAttributes for more information on using the RemoveAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAttributesRequest method.
//    req, resp := client.RemoveAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes
func (c *Pinpoint) RemoveAttributesRequest(input *RemoveAttributesInput) (req *request.Request, output *RemoveAttributesOutput) {
	op := &request.Operation{
		Name:       opRemoveAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/attributes/{attribute-type}",
	}

	if input == nil {
		input = &RemoveAttributesInput{}
	}

	output = &RemoveAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveAttributes API operation for Amazon Pinpoint.
//
// Removes one or more attributes, of the same attribute type, from all the
// endpoints that are associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation RemoveAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes
func (c *Pinpoint) RemoveAttributes(input *RemoveAttributesInput) (*RemoveAttributesOutput, error) {
	req, out := c.RemoveAttributesRequest(input)
	return out, req.Send()
}

// RemoveAttributesWithContext is the same as RemoveAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) RemoveAttributesWithContext(ctx aws.Context, input *RemoveAttributesInput, opts ...request.Option) (*RemoveAttributesOutput, error) {
	req, out := c.RemoveAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendMessages = "SendMessages"

// SendMessagesRequest generates a "aws/request.Request" representing the
// client's request for the SendMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendMessages for more information on using the SendMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendMessagesRequest method.
//    req, resp := client.SendMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages
func (c *Pinpoint) SendMessagesRequest(input *SendMessagesInput) (req *request.Request, output *SendMessagesOutput) {
	op := &request.Operation{
		Name:       opSendMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/messages",
	}

	if input == nil {
		input = &SendMessagesInput{}
	}

	output = &SendMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendMessages API operation for Amazon Pinpoint.
//
// Creates and sends a direct message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation SendMessages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages
func (c *Pinpoint) SendMessages(input *SendMessagesInput) (*SendMessagesOutput, error) {
	req, out := c.SendMessagesRequest(input)
	return out, req.Send()
}

// SendMessagesWithContext is the same as SendMessages with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) SendMessagesWithContext(ctx aws.Context, input *SendMessagesInput, opts ...request.Option) (*SendMessagesOutput, error) {
	req, out := c.SendMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendUsersMessages = "SendUsersMessages"

// SendUsersMessagesRequest generates a "aws/request.Request" representing the
// client's request for the SendUsersMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendUsersMessages for more information on using the SendUsersMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendUsersMessagesRequest method.
//    req, resp := client.SendUsersMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages
func (c *Pinpoint) SendUsersMessagesRequest(input *SendUsersMessagesInput) (req *request.Request, output *SendUsersMessagesOutput) {
	op := &request.Operation{
		Name:       opSendUsersMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/users-messages",
	}

	if input == nil {
		input = &SendUsersMessagesInput{}
	}

	output = &SendUsersMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendUsersMessages API operation for Amazon Pinpoint.
//
// Creates and sends a message to a list of users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation SendUsersMessages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages
func (c *Pinpoint) SendUsersMessages(input *SendUsersMessagesInput) (*SendUsersMessagesOutput, error) {
	req, out := c.SendUsersMessagesRequest(input)
	return out, req.Send()
}

// SendUsersMessagesWithContext is the same as SendUsersMessages with the addition of
// the ability to pass a context and additional request options.
//
// See SendUsersMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) SendUsersMessagesWithContext(ctx aws.Context, input *SendUsersMessagesInput, opts ...request.Option) (*SendUsersMessagesOutput, error) {
	req, out := c.SendUsersMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource
func (c *Pinpoint) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Pinpoint.
//
// Adds one or more tags (keys and values) to an application, campaign, or segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource
func (c *Pinpoint) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource
func (c *Pinpoint) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resource-arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Pinpoint.
//
// Removes one or more tags (keys and values) from an application, campaign,
// or segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource
func (c *Pinpoint) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAdmChannel = "UpdateAdmChannel"

// UpdateAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAdmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAdmChannel for more information on using the UpdateAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAdmChannelRequest method.
//    req, resp := client.UpdateAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Pinpoint) UpdateAdmChannelRequest(input *UpdateAdmChannelInput) (req *request.Request, output *UpdateAdmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateAdmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &UpdateAdmChannelInput{}
	}

	output = &UpdateAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAdmChannel API operation for Amazon Pinpoint.
//
// Updates the ADM channel settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateAdmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Pinpoint) UpdateAdmChannel(input *UpdateAdmChannelInput) (*UpdateAdmChannelOutput, error) {
	req, out := c.UpdateAdmChannelRequest(input)
	return out, req.Send()
}

// UpdateAdmChannelWithContext is the same as UpdateAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateAdmChannelWithContext(ctx aws.Context, input *UpdateAdmChannelInput, opts ...request.Option) (*UpdateAdmChannelOutput, error) {
	req, out := c.UpdateAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsChannel = "UpdateApnsChannel"

// UpdateApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsChannel for more information on using the UpdateApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsChannelRequest method.
//    req, resp := client.UpdateApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannelRequest(input *UpdateApnsChannelInput) (req *request.Request, output *UpdateApnsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &UpdateApnsChannelInput{}
	}

	output = &UpdateApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsChannel API operation for Amazon Pinpoint.
//
// Updates the APNs channel settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannel(input *UpdateApnsChannelInput) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsChannelWithContext is the same as UpdateApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsChannelWithContext(ctx aws.Context, input *UpdateApnsChannelInput, opts ...request.Option) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsSandboxChannel = "UpdateApnsSandboxChannel"

// UpdateApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsSandboxChannel for more information on using the UpdateApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsSandboxChannelRequest method.
//    req, resp := client.UpdateApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel
func (c *Pinpoint) UpdateApnsSandboxChannelRequest(input *UpdateApnsSandboxChannelInput) (req *request.Request, output *UpdateApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &UpdateApnsSandboxChannelInput{}
	}

	output = &UpdateApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Updates the APNs sandbox channel settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel
func (c *Pinpoint) UpdateApnsSandboxChannel(input *UpdateApnsSandboxChannelInput) (*UpdateApnsSandboxChannelOutput, error) {
	req, out := c.UpdateApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsSandboxChannelWithContext is the same as UpdateApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsSandboxChannelWithContext(ctx aws.Context, input *UpdateApnsSandboxChannelInput, opts ...request.Option) (*UpdateApnsSandboxChannelOutput, error) {
	req, out := c.UpdateApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsVoipChannel = "UpdateApnsVoipChannel"

// UpdateApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsVoipChannel for more information on using the UpdateApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsVoipChannelRequest method.
//    req, resp := client.UpdateApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel
func (c *Pinpoint) UpdateApnsVoipChannelRequest(input *UpdateApnsVoipChannelInput) (req *request.Request, output *UpdateApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsVoipChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &UpdateApnsVoipChannelInput{}
	}

	output = &UpdateApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsVoipChannel API operation for Amazon Pinpoint.
//
// Updates the APNs VoIP channel settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsVoipChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel
func (c *Pinpoint) UpdateApnsVoipChannel(input *UpdateApnsVoipChannelInput) (*UpdateApnsVoipChannelOutput, error) {
	req, out := c.UpdateApnsVoipChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsVoipChannelWithContext is the same as UpdateApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsVoipChannelWithContext(ctx aws.Context, input *UpdateApnsVoipChannelInput, opts ...request.Option) (*UpdateApnsVoipChannelOutput, error) {
	req, out := c.UpdateApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsVoipSandboxChannel = "UpdateApnsVoipSandboxChannel"

// UpdateApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsVoipSandboxChannel for more information on using the UpdateApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsVoipSandboxChannelRequest method.
//    req, resp := client.UpdateApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Pinpoint) UpdateApnsVoipSandboxChannelRequest(input *UpdateApnsVoipSandboxChannelInput) (req *request.Request, output *UpdateApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsVoipSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &UpdateApnsVoipSandboxChannelInput{}
	}

	output = &UpdateApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Updates the settings for the APNs VoIP sandbox channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Pinpoint) UpdateApnsVoipSandboxChannel(input *UpdateApnsVoipSandboxChannelInput) (*UpdateApnsVoipSandboxChannelOutput, error) {
	req, out := c.UpdateApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsVoipSandboxChannelWithContext is the same as UpdateApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsVoipSandboxChannelWithContext(ctx aws.Context, input *UpdateApnsVoipSandboxChannelInput, opts ...request.Option) (*UpdateApnsVoipSandboxChannelOutput, error) {
	req, out := c.UpdateApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationSettings = "UpdateApplicationSettings"

// UpdateApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationSettings for more information on using the UpdateApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationSettingsRequest method.
//    req, resp := client.UpdateApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettingsRequest(input *UpdateApplicationSettingsInput) (req *request.Request, output *UpdateApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &UpdateApplicationSettingsInput{}
	}

	output = &UpdateApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationSettings API operation for Amazon Pinpoint.
//
// Updates the settings for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApplicationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettings(input *UpdateApplicationSettingsInput) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	return out, req.Send()
}

// UpdateApplicationSettingsWithContext is the same as UpdateApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApplicationSettingsWithContext(ctx aws.Context, input *UpdateApplicationSettingsInput, opts ...request.Option) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBaiduChannel = "UpdateBaiduChannel"

// UpdateBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBaiduChannel for more information on using the UpdateBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBaiduChannelRequest method.
//    req, resp := client.UpdateBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel
func (c *Pinpoint) UpdateBaiduChannelRequest(input *UpdateBaiduChannelInput) (req *request.Request, output *UpdateBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateBaiduChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &UpdateBaiduChannelInput{}
	}

	output = &UpdateBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBaiduChannel API operation for Amazon Pinpoint.
//
// Updates the settings of the Baidu channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateBaiduChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel
func (c *Pinpoint) UpdateBaiduChannel(input *UpdateBaiduChannelInput) (*UpdateBaiduChannelOutput, error) {
	req, out := c.UpdateBaiduChannelRequest(input)
	return out, req.Send()
}

// UpdateBaiduChannelWithContext is the same as UpdateBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateBaiduChannelWithContext(ctx aws.Context, input *UpdateBaiduChannelInput, opts ...request.Option) (*UpdateBaiduChannelOutput, error) {
	req, out := c.UpdateBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaign for more information on using the UpdateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCampaignRequest method.
//    req, resp := client.UpdateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Pinpoint) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for Amazon Pinpoint.
//
// Updates the settings for a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Pinpoint) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	return out, req.Send()
}

// UpdateCampaignWithContext is the same as UpdateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateCampaignWithContext(ctx aws.Context, input *UpdateCampaignInput, opts ...request.Option) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEmailChannel = "UpdateEmailChannel"

// UpdateEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEmailChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEmailChannel for more information on using the UpdateEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEmailChannelRequest method.
//    req, resp := client.UpdateEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Pinpoint) UpdateEmailChannelRequest(input *UpdateEmailChannelInput) (req *request.Request, output *UpdateEmailChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateEmailChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &UpdateEmailChannelInput{}
	}

	output = &UpdateEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEmailChannel API operation for Amazon Pinpoint.
//
// Updates the status and settings of the email channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEmailChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Pinpoint) UpdateEmailChannel(input *UpdateEmailChannelInput) (*UpdateEmailChannelOutput, error) {
	req, out := c.UpdateEmailChannelRequest(input)
	return out, req.Send()
}

// UpdateEmailChannelWithContext is the same as UpdateEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEmailChannelWithContext(ctx aws.Context, input *UpdateEmailChannelInput, opts ...request.Option) (*UpdateEmailChannelOutput, error) {
	req, out := c.UpdateEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint
func (c *Pinpoint) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon Pinpoint.
//
// Creates a new endpoint for an application or updates the settings and attributes
// of an existing endpoint for an application. You can also use this operation
// to define custom attributes (Attributes, Metrics, and UserAttributes properties)
// for an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint
func (c *Pinpoint) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointsBatch = "UpdateEndpointsBatch"

// UpdateEndpointsBatchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointsBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointsBatch for more information on using the UpdateEndpointsBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointsBatchRequest method.
//    req, resp := client.UpdateEndpointsBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatchRequest(input *UpdateEndpointsBatchInput) (req *request.Request, output *UpdateEndpointsBatchOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointsBatch,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints",
	}

	if input == nil {
		input = &UpdateEndpointsBatchInput{}
	}

	output = &UpdateEndpointsBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointsBatch API operation for Amazon Pinpoint.
//
// Creates a new batch of endpoints for an application or updates the settings
// and attributes of a batch of existing endpoints for an application. You can
// also use this operation to define custom attributes (Attributes, Metrics,
// and UserAttributes properties) for a batch of endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpointsBatch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatch(input *UpdateEndpointsBatchInput) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	return out, req.Send()
}

// UpdateEndpointsBatchWithContext is the same as UpdateEndpointsBatch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointsBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEndpointsBatchWithContext(ctx aws.Context, input *UpdateEndpointsBatchInput, opts ...request.Option) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGcmChannel = "UpdateGcmChannel"

// UpdateGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGcmChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGcmChannel for more information on using the UpdateGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGcmChannelRequest method.
//    req, resp := client.UpdateGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannelRequest(input *UpdateGcmChannelInput) (req *request.Request, output *UpdateGcmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateGcmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &UpdateGcmChannelInput{}
	}

	output = &UpdateGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGcmChannel API operation for Amazon Pinpoint.
//
// Updates the status and settings of the GCM channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannel(input *UpdateGcmChannelInput) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	return out, req.Send()
}

// UpdateGcmChannelWithContext is the same as UpdateGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateGcmChannelWithContext(ctx aws.Context, input *UpdateGcmChannelInput, opts ...request.Option) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSegment = "UpdateSegment"

// UpdateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSegment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSegment for more information on using the UpdateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSegmentRequest method.
//    req, resp := client.UpdateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Pinpoint) UpdateSegmentRequest(input *UpdateSegmentInput) (req *request.Request, output *UpdateSegmentOutput) {
	op := &request.Operation{
		Name:       opUpdateSegment,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &UpdateSegmentInput{}
	}

	output = &UpdateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSegment API operation for Amazon Pinpoint.
//
// Creates a new segment for an application or updates the configuration, dimension,
// and other settings for an existing segment that's associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Pinpoint) UpdateSegment(input *UpdateSegmentInput) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	return out, req.Send()
}

// UpdateSegmentWithContext is the same as UpdateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSegmentWithContext(ctx aws.Context, input *UpdateSegmentInput, opts ...request.Option) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSmsChannel = "UpdateSmsChannel"

// UpdateSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSmsChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSmsChannel for more information on using the UpdateSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSmsChannelRequest method.
//    req, resp := client.UpdateSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel
func (c *Pinpoint) UpdateSmsChannelRequest(input *UpdateSmsChannelInput) (req *request.Request, output *UpdateSmsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateSmsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &UpdateSmsChannelInput{}
	}

	output = &UpdateSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSmsChannel API operation for Amazon Pinpoint.
//
// Updates the status and settings of the SMS channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSmsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel
func (c *Pinpoint) UpdateSmsChannel(input *UpdateSmsChannelInput) (*UpdateSmsChannelOutput, error) {
	req, out := c.UpdateSmsChannelRequest(input)
	return out, req.Send()
}

// UpdateSmsChannelWithContext is the same as UpdateSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSmsChannelWithContext(ctx aws.Context, input *UpdateSmsChannelInput, opts ...request.Option) (*UpdateSmsChannelOutput, error) {
	req, out := c.UpdateSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceChannel = "UpdateVoiceChannel"

// UpdateVoiceChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceChannel for more information on using the UpdateVoiceChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVoiceChannelRequest method.
//    req, resp := client.UpdateVoiceChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel
func (c *Pinpoint) UpdateVoiceChannelRequest(input *UpdateVoiceChannelInput) (req *request.Request, output *UpdateVoiceChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/voice",
	}

	if input == nil {
		input = &UpdateVoiceChannelInput{}
	}

	output = &UpdateVoiceChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceChannel API operation for Amazon Pinpoint.
//
// Updates the status and settings of the voice channel for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateVoiceChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Provides information about an API request or response.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Provides information about an API request or response.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Provides information about an API request or response.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Provides information about an API request or response.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   Provides information about an API request or response.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Provides information about an API request or response.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel
func (c *Pinpoint) UpdateVoiceChannel(input *UpdateVoiceChannelInput) (*UpdateVoiceChannelOutput, error) {
	req, out := c.UpdateVoiceChannelRequest(input)
	return out, req.Send()
}

// UpdateVoiceChannelWithContext is the same as UpdateVoiceChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateVoiceChannelWithContext(ctx aws.Context, input *UpdateVoiceChannelInput, opts ...request.Option) (*UpdateVoiceChannelOutput, error) {
	req, out := c.UpdateVoiceChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the status and settings of the ADM (Amazon Device Messaging) channel
// for an application.
type ADMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The Client ID that you received from Amazon to send messages by using ADM.
	//
	// ClientId is a required field
	ClientId *string `type:"string" required:"true"`

	// The Client Secret that you received from Amazon to send messages by using
	// ADM.
	//
	// ClientSecret is a required field
	ClientSecret *string `type:"string" required:"true"`

	// Specifies whether to enable the ADM channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ADMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ADMChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ADMChannelRequest"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientSecret == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSecret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *ADMChannelRequest) SetClientId(v string) *ADMChannelRequest {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *ADMChannelRequest) SetClientSecret(v string) *ADMChannelRequest {
	s.ClientSecret = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ADMChannelRequest) SetEnabled(v bool) *ADMChannelRequest {
	s.Enabled = &v
	return s
}

// Provides information about the status and settings of the ADM (Amazon Device
// Messaging) channel for an application.
type ADMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the ADM channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the ADM channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the ADM channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the ADM channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the ADM channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the ADM channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the ADM channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the ADM
	// channel, this value is ADM.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the ADM channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ADMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ADMChannelResponse) SetApplicationId(v string) *ADMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ADMChannelResponse) SetCreationDate(v string) *ADMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ADMChannelResponse) SetEnabled(v bool) *ADMChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *ADMChannelResponse) SetHasCredential(v bool) *ADMChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *ADMChannelResponse) SetId(v string) *ADMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *ADMChannelResponse) SetIsArchived(v bool) *ADMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ADMChannelResponse) SetLastModifiedBy(v string) *ADMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ADMChannelResponse) SetLastModifiedDate(v string) *ADMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ADMChannelResponse) SetPlatform(v string) *ADMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ADMChannelResponse) SetVersion(v int64) *ADMChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the ADM (Amazon Device Messaging) channel.
type ADMMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message.
	Body *string `type:"string"`

	// An arbitrary string that indicates that multiple messages are logically the
	// same and that Amazon Device Messaging (ADM) can drop previously enqueued
	// messages in favor of this message.
	ConsolidationKey *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// The amount of time, in seconds, that ADM should store the message if the
	// recipient's device is offline. Amazon Pinpoint specifies this value in the
	// expiresAfter parameter when it sends the notification message to ADM.
	ExpiresAfter *string `type:"string"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The base64-encoded, MD5 checksum of the value specified by the Data property.
	// ADM uses the MD5 value to verify the integrity of the data.
	MD5 *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. This value overrides the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s ADMMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ADMMessage) SetAction(v string) *ADMMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *ADMMessage) SetBody(v string) *ADMMessage {
	s.Body = &v
	return s
}

// SetConsolidationKey sets the ConsolidationKey field's value.
func (s *ADMMessage) SetConsolidationKey(v string) *ADMMessage {
	s.ConsolidationKey = &v
	return s
}

// SetData sets the Data field's value.
func (s *ADMMessage) SetData(v map[string]*string) *ADMMessage {
	s.Data = v
	return s
}

// SetExpiresAfter sets the ExpiresAfter field's value.
func (s *ADMMessage) SetExpiresAfter(v string) *ADMMessage {
	s.ExpiresAfter = &v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *ADMMessage) SetIconReference(v string) *ADMMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *ADMMessage) SetImageIconUrl(v string) *ADMMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *ADMMessage) SetImageUrl(v string) *ADMMessage {
	s.ImageUrl = &v
	return s
}

// SetMD5 sets the MD5 field's value.
func (s *ADMMessage) SetMD5(v string) *ADMMessage {
	s.MD5 = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *ADMMessage) SetRawContent(v string) *ADMMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *ADMMessage) SetSilentPush(v bool) *ADMMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *ADMMessage) SetSmallImageIconUrl(v string) *ADMMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *ADMMessage) SetSound(v string) *ADMMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *ADMMessage) SetSubstitutions(v map[string][]*string) *ADMMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ADMMessage) SetTitle(v string) *ADMMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ADMMessage) SetUrl(v string) *ADMMessage {
	s.Url = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// channel for an application.
type APNSChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with APNs by using an APNs certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with APNs, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with APNs.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with APNs by using APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSChannelRequest) SetBundleId(v string) *APNSChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSChannelRequest) SetCertificate(v string) *APNSChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSChannelRequest) SetEnabled(v bool) *APNSChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSChannelRequest) SetPrivateKey(v string) *APNSChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSChannelRequest) SetTeamId(v string) *APNSChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSChannelRequest) SetTokenKey(v string) *APNSChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSChannelRequest) SetTokenKeyId(v string) *APNSChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) channel for an application.
type APNSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with APNs for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs channel is configured to communicate with APNs
	// by using APNs tokens. To provide an authentication key for APNs tokens, set
	// the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// channel, this value is APNS.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSChannelResponse) SetApplicationId(v string) *APNSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSChannelResponse) SetCreationDate(v string) *APNSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSChannelResponse) SetEnabled(v bool) *APNSChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSChannelResponse) SetHasCredential(v bool) *APNSChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSChannelResponse) SetHasTokenKey(v bool) *APNSChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSChannelResponse) SetId(v string) *APNSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSChannelResponse) SetIsArchived(v bool) *APNSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSChannelResponse) SetLastModifiedBy(v string) *APNSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSChannelResponse) SetLastModifiedDate(v string) *APNSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSChannelResponse) SetPlatform(v string) *APNSChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSChannelResponse) SetVersion(v int64) *APNSChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the APNs (Apple Push Notification service) channel.
type APNSMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The key that indicates whether and how to modify the badge of your app's
	// icon when the recipient receives the push notification. If this key isn't
	// included in the dictionary, the badge doesn't change. To remove the badge,
	// set this value to 0.
	Badge *int64 `type:"integer"`

	// The body of the notification message.
	Body *string `type:"string"`

	// The key that indicates the notification type for the push notification. This
	// key is a value that's defined by the identifier property of one of your app's
	// registered categories.
	Category *string `type:"string"`

	// An arbitrary identifier that, if assigned to multiple messages, APNs uses
	// to coalesce the messages into a single push notification instead of delivering
	// each message individually. This value can't exceed 64 bytes.
	//
	// Amazon Pinpoint specifies this value in the apns-collapse-id request header
	// when it sends the notification message to APNs.
	CollapseId *string `type:"string"`

	// The JSON payload to use for a silent push notification. This payload is added
	// to the data.pinpoint.jsonBody object of the notification.
	Data map[string]*string `type:"map"`

	// The URL of an image or video to display in the push notification.
	MediaUrl *string `type:"string"`

	// The authentication method that you want Amazon Pinpoint to use when authenticating
	// with Apple Push Notification service (APNs), CERTIFICATE or TOKEN.
	PreferredAuthenticationMethod *string `type:"string"`

	// para>5 - Low priority, the notification might be delayed, delivered as part
	// of a group, or throttled.
	// /listitem>
	// 10 - High priority, the notification is sent immediately. This is the default
	// value. A high priority notification should trigger an alert, play a sound,
	// or badge your app's icon on the recipient's device.
	// /para>
	// Amazon Pinpoint specifies this value in the apns-priority request header
	// when it sends the notification message to APNs.
	//
	// The equivalent values for Firebase Cloud Messaging (FCM), formerly Google
	// Cloud Messaging (GCM), are normal, for 5, and high, for 10. If you specify
	// an FCM value for this property, Amazon Pinpoint accepts and converts the
	// value to the corresponding APNs value.
	Priority *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. This value overrides the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration,
	// displaying messages in an in-app message center, or supporting phone home
	// functionality.
	SilentPush *bool `type:"boolean"`

	// The key for the sound to play when the recipient receives the push notification.
	// The value of this key is the name of a sound file in your app's main bundle
	// or the Library/Sounds folder in your app's data container. If the sound file
	// can't be found or you specify default for the value, the system plays the
	// default alert sound.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override these default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The key that represents your app-specific identifier for grouping notifications.
	// If you provide a Notification Content app extension, you can use this value
	// to group your notifications together.
	ThreadId *string `type:"string"`

	// The amount of time, in seconds, that APNs should store and attempt to deliver
	// the push notification, if the service is unable to deliver the notification
	// the first time. If this value is 0, APNs treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// Amazon Pinpoint specifies this value in the apns-expiration request header
	// when it sends the notification message to APNs.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *APNSMessage) SetAction(v string) *APNSMessage {
	s.Action = &v
	return s
}

// SetBadge sets the Badge field's value.
func (s *APNSMessage) SetBadge(v int64) *APNSMessage {
	s.Badge = &v
	return s
}

// SetBody sets the Body field's value.
func (s *APNSMessage) SetBody(v string) *APNSMessage {
	s.Body = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *APNSMessage) SetCategory(v string) *APNSMessage {
	s.Category = &v
	return s
}

// SetCollapseId sets the CollapseId field's value.
func (s *APNSMessage) SetCollapseId(v string) *APNSMessage {
	s.CollapseId = &v
	return s
}

// SetData sets the Data field's value.
func (s *APNSMessage) SetData(v map[string]*string) *APNSMessage {
	s.Data = v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *APNSMessage) SetMediaUrl(v string) *APNSMessage {
	s.MediaUrl = &v
	return s
}

// SetPreferredAuthenticationMethod sets the PreferredAuthenticationMethod field's value.
func (s *APNSMessage) SetPreferredAuthenticationMethod(v string) *APNSMessage {
	s.PreferredAuthenticationMethod = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *APNSMessage) SetPriority(v string) *APNSMessage {
	s.Priority = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *APNSMessage) SetRawContent(v string) *APNSMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *APNSMessage) SetSilentPush(v bool) *APNSMessage {
	s.SilentPush = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *APNSMessage) SetSound(v string) *APNSMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *APNSMessage) SetSubstitutions(v map[string][]*string) *APNSMessage {
	s.Substitutions = v
	return s
}

// SetThreadId sets the ThreadId field's value.
func (s *APNSMessage) SetThreadId(v string) *APNSMessage {
	s.ThreadId = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *APNSMessage) SetTimeToLive(v int64) *APNSMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *APNSMessage) SetTitle(v string) *APNSMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *APNSMessage) SetUrl(v string) *APNSMessage {
	s.Url = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// sandbox channel for an application.
type APNSSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with the APNs sandbox environment by using an APNs
	// certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with the APNs sandbox environment, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs sandbox channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with the APNs sandbox environment.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with the APNs sandbox environment by using
	// APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSSandboxChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSSandboxChannelRequest) SetBundleId(v string) *APNSSandboxChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSSandboxChannelRequest) SetCertificate(v string) *APNSSandboxChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSSandboxChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSSandboxChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSSandboxChannelRequest) SetEnabled(v bool) *APNSSandboxChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSSandboxChannelRequest) SetPrivateKey(v string) *APNSSandboxChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSSandboxChannelRequest) SetTeamId(v string) *APNSSandboxChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSSandboxChannelRequest) SetTokenKey(v string) *APNSSandboxChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSSandboxChannelRequest) SetTokenKeyId(v string) *APNSSandboxChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) sandbox channel for an application.
type APNSSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs sandbox channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs sandbox channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with the APNs sandbox environment for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs sandbox channel is configured to communicate with
	// APNs by using APNs tokens. To provide an authentication key for APNs tokens,
	// set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs sandbox channel. This property is
	// retained only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs sandbox channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs sandbox channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs sandbox channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// sandbox channel, this value is APNS_SANDBOX.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs sandbox channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSSandboxChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSSandboxChannelResponse) SetApplicationId(v string) *APNSSandboxChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSSandboxChannelResponse) SetCreationDate(v string) *APNSSandboxChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSSandboxChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSSandboxChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSSandboxChannelResponse) SetEnabled(v bool) *APNSSandboxChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSSandboxChannelResponse) SetHasCredential(v bool) *APNSSandboxChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSSandboxChannelResponse) SetHasTokenKey(v bool) *APNSSandboxChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSSandboxChannelResponse) SetId(v string) *APNSSandboxChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSSandboxChannelResponse) SetIsArchived(v bool) *APNSSandboxChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSSandboxChannelResponse) SetLastModifiedBy(v string) *APNSSandboxChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSSandboxChannelResponse) SetLastModifiedDate(v string) *APNSSandboxChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSSandboxChannelResponse) SetPlatform(v string) *APNSSandboxChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSSandboxChannelResponse) SetVersion(v int64) *APNSSandboxChannelResponse {
	s.Version = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// VoIP channel for an application.
type APNSVoipChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with APNs by using an APNs certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with APNs, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether to enable the APNs VoIP channel for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with APNs.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with APNs by using APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSVoipChannelRequest) SetBundleId(v string) *APNSVoipChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSVoipChannelRequest) SetCertificate(v string) *APNSVoipChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSVoipChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipChannelRequest) SetEnabled(v bool) *APNSVoipChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSVoipChannelRequest) SetPrivateKey(v string) *APNSVoipChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSVoipChannelRequest) SetTeamId(v string) *APNSVoipChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSVoipChannelRequest) SetTokenKey(v string) *APNSVoipChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSVoipChannelRequest) SetTokenKeyId(v string) *APNSVoipChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) VoIP channel for an application.
type APNSVoipChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs VoIP channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs VoIP channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with APNs for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs VoIP channel is configured to communicate with
	// APNs by using APNs tokens. To provide an authentication key for APNs tokens,
	// set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs VoIP channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs VoIP channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs VoIP channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs VoIP channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// VoIP channel, this value is APNS_VOIP.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs VoIP channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSVoipChannelResponse) SetApplicationId(v string) *APNSVoipChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSVoipChannelResponse) SetCreationDate(v string) *APNSVoipChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSVoipChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipChannelResponse) SetEnabled(v bool) *APNSVoipChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSVoipChannelResponse) SetHasCredential(v bool) *APNSVoipChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSVoipChannelResponse) SetHasTokenKey(v bool) *APNSVoipChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSVoipChannelResponse) SetId(v string) *APNSVoipChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSVoipChannelResponse) SetIsArchived(v bool) *APNSVoipChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSVoipChannelResponse) SetLastModifiedBy(v string) *APNSVoipChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSVoipChannelResponse) SetLastModifiedDate(v string) *APNSVoipChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSVoipChannelResponse) SetPlatform(v string) *APNSVoipChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSVoipChannelResponse) SetVersion(v int64) *APNSVoipChannelResponse {
	s.Version = &v
	return s
}

// Specifies the status and settings of the APNs (Apple Push Notification service)
// VoIP sandbox channel for an application.
type APNSVoipSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle identifier that's assigned to your iOS app. This identifier is
	// used for APNs tokens.
	BundleId *string `type:"string"`

	// The APNs client certificate that you received from Apple, if you want Amazon
	// Pinpoint to communicate with the APNs sandbox environment by using an APNs
	// certificate.
	Certificate *string `type:"string"`

	// The default authentication method that you want Amazon Pinpoint to use when
	// authenticating with the APNs sandbox environment for this channel, key or
	// certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// The private key for the APNs client certificate that you want Amazon Pinpoint
	// to use to communicate with the APNs sandbox environment.
	PrivateKey *string `type:"string"`

	// The identifier that's assigned to your Apple developer account team. This
	// identifier is used for APNs tokens.
	TeamId *string `type:"string"`

	// The authentication key to use for APNs tokens.
	TokenKey *string `type:"string"`

	// The key identifier that's assigned to your APNs signing key, if you want
	// Amazon Pinpoint to communicate with the APNs sandbox environment by using
	// APNs tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipSandboxChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSVoipSandboxChannelRequest) SetBundleId(v string) *APNSVoipSandboxChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSVoipSandboxChannelRequest) SetCertificate(v string) *APNSVoipSandboxChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipSandboxChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSVoipSandboxChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipSandboxChannelRequest) SetEnabled(v bool) *APNSVoipSandboxChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSVoipSandboxChannelRequest) SetPrivateKey(v string) *APNSVoipSandboxChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSVoipSandboxChannelRequest) SetTeamId(v string) *APNSVoipSandboxChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSVoipSandboxChannelRequest) SetTokenKey(v string) *APNSVoipSandboxChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSVoipSandboxChannelRequest) SetTokenKeyId(v string) *APNSVoipSandboxChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Provides information about the status and settings of the APNs (Apple Push
// Notification service) VoIP sandbox channel for an application.
type APNSVoipSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the APNs VoIP sandbox channel
	// applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the APNs VoIP sandbox channel was enabled.
	CreationDate *string `type:"string"`

	// The default authentication method that Amazon Pinpoint uses to authenticate
	// with the APNs sandbox environment for this channel, key or certificate.
	DefaultAuthenticationMethod *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// Specifies whether the APNs VoIP sandbox channel is configured to communicate
	// with APNs by using APNs tokens. To provide an authentication key for APNs
	// tokens, set the TokenKey property of the channel.
	HasTokenKey *bool `type:"boolean"`

	// (Deprecated) An identifier for the APNs VoIP sandbox channel. This property
	// is retained only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the APNs VoIP sandbox channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the APNs VoIP sandbox channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the APNs VoIP sandbox channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the APNs
	// VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the APNs VoIP sandbox channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipSandboxChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSVoipSandboxChannelResponse) SetApplicationId(v string) *APNSVoipSandboxChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSVoipSandboxChannelResponse) SetCreationDate(v string) *APNSVoipSandboxChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipSandboxChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSVoipSandboxChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipSandboxChannelResponse) SetEnabled(v bool) *APNSVoipSandboxChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSVoipSandboxChannelResponse) SetHasCredential(v bool) *APNSVoipSandboxChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSVoipSandboxChannelResponse) SetHasTokenKey(v bool) *APNSVoipSandboxChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSVoipSandboxChannelResponse) SetId(v string) *APNSVoipSandboxChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSVoipSandboxChannelResponse) SetIsArchived(v bool) *APNSVoipSandboxChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSVoipSandboxChannelResponse) SetLastModifiedBy(v string) *APNSVoipSandboxChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSVoipSandboxChannelResponse) SetLastModifiedDate(v string) *APNSVoipSandboxChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSVoipSandboxChannelResponse) SetPlatform(v string) *APNSVoipSandboxChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSVoipSandboxChannelResponse) SetVersion(v int64) *APNSVoipSandboxChannelResponse {
	s.Version = &v
	return s
}

// Provides information about the activities that were performed by a campaign.
type ActivitiesResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each activity that was performed by the campaign.
	//
	// Item is a required field
	Item []*ActivityResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ActivitiesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivitiesResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ActivitiesResponse) SetItem(v []*ActivityResponse) *ActivitiesResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ActivitiesResponse) SetNextToken(v string) *ActivitiesResponse {
	s.NextToken = &v
	return s
}

// Provides information about an activity that was performed by a campaign.
type ActivityResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the campaign applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the campaign that the activity applies to.
	//
	// CampaignId is a required field
	CampaignId *string `type:"string" required:"true"`

	// The actual time, in ISO 8601 format, when the activity was marked CANCELLED
	// or COMPLETED.
	End *string `type:"string"`

	// The unique identifier for the activity.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies whether the activity succeeded. Possible values are SUCCESS and
	// FAIL.
	Result *string `type:"string"`

	// The scheduled start time, in ISO 8601 format, for the activity.
	ScheduledStart *string `type:"string"`

	// The actual start time, in ISO 8601 format, of the activity.
	Start *string `type:"string"`

	// The state of the activity. Possible values are: PENDING, INITIALIZING, RUNNING,
	// PAUSED, CANCELLED, and COMPLETED.
	State *string `type:"string"`

	// The total number of endpoints that the campaign successfully delivered messages
	// to.
	SuccessfulEndpointCount *int64 `type:"integer"`

	// The total number of time zones that were completed.
	TimezonesCompletedCount *int64 `type:"integer"`

	// The total number of unique time zones that are in the segment for the campaign.
	TimezonesTotalCount *int64 `type:"integer"`

	// The total number of endpoints that the campaign attempted to deliver messages
	// to.
	TotalEndpointCount *int64 `type:"integer"`

	// The unique identifier for the campaign treatment that the activity applies
	// to. A treatment is a variation of a campaign that's used for A/B testing
	// of a campaign.
	TreatmentId *string `type:"string"`
}

// String returns the string representation
func (s ActivityResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ActivityResponse) SetApplicationId(v string) *ActivityResponse {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *ActivityResponse) SetCampaignId(v string) *ActivityResponse {
	s.CampaignId = &v
	return s
}

// SetEnd sets the End field's value.
func (s *ActivityResponse) SetEnd(v string) *ActivityResponse {
	s.End = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActivityResponse) SetId(v string) *ActivityResponse {
	s.Id = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ActivityResponse) SetResult(v string) *ActivityResponse {
	s.Result = &v
	return s
}

// SetScheduledStart sets the ScheduledStart field's value.
func (s *ActivityResponse) SetScheduledStart(v string) *ActivityResponse {
	s.ScheduledStart = &v
	return s
}

// SetStart sets the Start field's value.
func (s *ActivityResponse) SetStart(v string) *ActivityResponse {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *ActivityResponse) SetState(v string) *ActivityResponse {
	s.State = &v
	return s
}

// SetSuccessfulEndpointCount sets the SuccessfulEndpointCount field's value.
func (s *ActivityResponse) SetSuccessfulEndpointCount(v int64) *ActivityResponse {
	s.SuccessfulEndpointCount = &v
	return s
}

// SetTimezonesCompletedCount sets the TimezonesCompletedCount field's value.
func (s *ActivityResponse) SetTimezonesCompletedCount(v int64) *ActivityResponse {
	s.TimezonesCompletedCount = &v
	return s
}

// SetTimezonesTotalCount sets the TimezonesTotalCount field's value.
func (s *ActivityResponse) SetTimezonesTotalCount(v int64) *ActivityResponse {
	s.TimezonesTotalCount = &v
	return s
}

// SetTotalEndpointCount sets the TotalEndpointCount field's value.
func (s *ActivityResponse) SetTotalEndpointCount(v int64) *ActivityResponse {
	s.TotalEndpointCount = &v
	return s
}

// SetTreatmentId sets the TreatmentId field's value.
func (s *ActivityResponse) SetTreatmentId(v string) *ActivityResponse {
	s.TreatmentId = &v
	return s
}

// Specifies address-based configuration settings for a message that's sent
// directly to an endpoint.
type AddressConfiguration struct {
	_ struct{} `type:"structure"`

	// The message body to use instead of the default message body. This value overrides
	// the default message body.
	BodyOverride *string `type:"string"`

	// The channel to use when sending the message.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// An object that maps custom attributes to attributes for the address and is
	// attached to the message. For a push notification, this payload is added to
	// the data.pinpoint object. For an email or text message, this payload is added
	// to email/SMS delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. This value overrides the message.
	RawContent *string `type:"string"`

	// An object that maps variable values for the message. Amazon Pinpoint merges
	// these values with the variable values specified by properties of the DefaultMessage
	// object. The substitutions in this map take precedence over all other substitutions.
	Substitutions map[string][]*string `type:"map"`

	// The message title to use instead of the default message title. This value
	// overrides the default message title.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s AddressConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressConfiguration) GoString() string {
	return s.String()
}

// SetBodyOverride sets the BodyOverride field's value.
func (s *AddressConfiguration) SetBodyOverride(v string) *AddressConfiguration {
	s.BodyOverride = &v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *AddressConfiguration) SetChannelType(v string) *AddressConfiguration {
	s.ChannelType = &v
	return s
}

// SetContext sets the Context field's value.
func (s *AddressConfiguration) SetContext(v map[string]*string) *AddressConfiguration {
	s.Context = v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *AddressConfiguration) SetRawContent(v string) *AddressConfiguration {
	s.RawContent = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *AddressConfiguration) SetSubstitutions(v map[string][]*string) *AddressConfiguration {
	s.Substitutions = v
	return s
}

// SetTitleOverride sets the TitleOverride field's value.
func (s *AddressConfiguration) SetTitleOverride(v string) *AddressConfiguration {
	s.TitleOverride = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application, and provides information about that query.
type ApplicationDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The last date or date and time of the date range that was used to filter
	// the query results, in ISO 8601 format. The date range is inclusive.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of valid values, see the Amazon
	// Pinpoint Developer Guide (developerguide.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the App Metrics resource.
	// The App Metrics resource returns all results in a single page.
	NextToken *string `type:"string"`

	// The first date or date and time of the date range that was used to filter
	// the query results, in ISO 8601 format. The date range is inclusive.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ApplicationDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDateRangeKpiResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationDateRangeKpiResponse) SetApplicationId(v string) *ApplicationDateRangeKpiResponse {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ApplicationDateRangeKpiResponse) SetEndTime(v time.Time) *ApplicationDateRangeKpiResponse {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *ApplicationDateRangeKpiResponse) SetKpiName(v string) *ApplicationDateRangeKpiResponse {
	s.KpiName = &v
	return s
}

// SetKpiResult sets the KpiResult field's value.
func (s *ApplicationDateRangeKpiResponse) SetKpiResult(v *BaseKpiResult) *ApplicationDateRangeKpiResponse {
	s.KpiResult = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ApplicationDateRangeKpiResponse) SetNextToken(v string) *ApplicationDateRangeKpiResponse {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ApplicationDateRangeKpiResponse) SetStartTime(v time.Time) *ApplicationDateRangeKpiResponse {
	s.StartTime = &v
	return s
}

// Provides information about an application.
type ApplicationResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The unique identifier for the application. This identifier is displayed as
	// the Project ID on the Amazon Pinpoint console.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The display name of the application. This name is displayed as the Project
	// name on the Amazon Pinpoint console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the application. Each tag consists of a required tag key
	// and an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ApplicationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationResponse) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ApplicationResponse) SetArn(v string) *ApplicationResponse {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationResponse) SetId(v string) *ApplicationResponse {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationResponse) SetName(v string) *ApplicationResponse {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ApplicationResponse) SetTags(v map[string]*string) *ApplicationResponse {
	s.Tags = v
	return s
}

// Provides information about an application, including the default settings
// for an application.
type ApplicationSettingsResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application. This identifier is displayed as
	// the Project ID on the Amazon Pinpoint console.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The settings for the AWS Lambda function to use by default as a code hook
	// for campaigns in the application.
	CampaignHook *CampaignHook `type:"structure"`

	// The date and time, in ISO 8601 format, when the application's settings were
	// last modified.
	LastModifiedDate *string `type:"string"`

	// The default sending limits for campaigns in the application.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for campaigns in the application. Quiet time is a
	// specific time range when campaigns don't send messages to endpoints, if all
	// the following conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the application
	//    (or a campaign that has custom quiet time settings).
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the application
	//    (or a campaign that has custom quiet time settings).
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from a campaign, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s ApplicationSettingsResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSettingsResource) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSettingsResource) SetApplicationId(v string) *ApplicationSettingsResource {
	s.ApplicationId = &v
	return s
}

// SetCampaignHook sets the CampaignHook field's value.
func (s *ApplicationSettingsResource) SetCampaignHook(v *CampaignHook) *ApplicationSettingsResource {
	s.CampaignHook = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ApplicationSettingsResource) SetLastModifiedDate(v string) *ApplicationSettingsResource {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *ApplicationSettingsResource) SetLimits(v *CampaignLimits) *ApplicationSettingsResource {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *ApplicationSettingsResource) SetQuietTime(v *QuietTime) *ApplicationSettingsResource {
	s.QuietTime = v
	return s
}

// Provides information about all of your applications.
type ApplicationsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each application that was returned.
	Item []*ApplicationResponse `type:"list"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ApplicationsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ApplicationsResponse) SetItem(v []*ApplicationResponse) *ApplicationsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ApplicationsResponse) SetNextToken(v string) *ApplicationsResponse {
	s.NextToken = &v
	return s
}

// Specifies attribute-based criteria for including or excluding endpoints from
// a segment.
type AttributeDimension struct {
	_ struct{} `type:"structure"`

	// The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints
	// that match the criteria are included in the segment; and, EXCLUSIVE, endpoints
	// that match the criteria are excluded from the segment.
	AttributeType *string `type:"string" enum:"AttributeType"`

	// The criteria values to use for the segment dimension. Depending on the value
	// of the AttributeType property, endpoints are included or excluded from the
	// segment if their attribute values match the criteria values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttributeDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeDimension"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributeDimension) SetAttributeType(v string) *AttributeDimension {
	s.AttributeType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AttributeDimension) SetValues(v []*string) *AttributeDimension {
	s.Values = v
	return s
}

// Provides information about the type and the names of attributes that were
// removed from all the endpoints that are associated with an application.
type AttributesResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The type of attribute or attributes that were removed from the endpoints.
	// Valid values are:
	//
	//    * endpoint-custom-attributes - Custom attributes that describe endpoints
	//
	//    * endpoint-custom-metrics - Custom metrics that your app reports to Amazon
	//    Pinpoint for endpoints
	//
	//    * endpoint-user-attributes - Custom attributes that describe users
	//
	// AttributeType is a required field
	AttributeType *string `type:"string" required:"true"`

	// An array that specifies the names of the attributes that were removed from
	// the endpoints.
	Attributes []*string `type:"list"`
}

// String returns the string representation
func (s AttributesResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributesResource) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *AttributesResource) SetApplicationId(v string) *AttributesResource {
	s.ApplicationId = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributesResource) SetAttributeType(v string) *AttributesResource {
	s.AttributeType = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *AttributesResource) SetAttributes(v []*string) *AttributesResource {
	s.Attributes = v
	return s
}

// Specifies the status and settings of the Baidu (Baidu Cloud Push) channel
// for an application.
type BaiduChannelRequest struct {
	_ struct{} `type:"structure"`

	// The API key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// ApiKey is a required field
	ApiKey *string `type:"string" required:"true"`

	// Specifies whether to enable the Baidu channel for the application.
	Enabled *bool `type:"boolean"`

	// The secret key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// SecretKey is a required field
	SecretKey *string `type:"string" required:"true"`
}

// String returns the string representation
func (s BaiduChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BaiduChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BaiduChannelRequest"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.SecretKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *BaiduChannelRequest) SetApiKey(v string) *BaiduChannelRequest {
	s.ApiKey = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BaiduChannelRequest) SetEnabled(v bool) *BaiduChannelRequest {
	s.Enabled = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *BaiduChannelRequest) SetSecretKey(v string) *BaiduChannelRequest {
	s.SecretKey = &v
	return s
}

// Provides information about the status and settings of the Baidu (Baidu Cloud
// Push) channel for an application.
type BaiduChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the Baidu channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time when the Baidu channel was enabled.
	CreationDate *string `type:"string"`

	// The API key that you received from the Baidu Cloud Push service to communicate
	// with the service.
	//
	// Credential is a required field
	Credential *string `type:"string" required:"true"`

	// Specifies whether the Baidu channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the Baidu channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the Baidu channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the Baidu channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the Baidu channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the Baidu
	// channel, this value is BAIDU.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the Baidu channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s BaiduChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *BaiduChannelResponse) SetApplicationId(v string) *BaiduChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *BaiduChannelResponse) SetCreationDate(v string) *BaiduChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *BaiduChannelResponse) SetCredential(v string) *BaiduChannelResponse {
	s.Credential = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BaiduChannelResponse) SetEnabled(v bool) *BaiduChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *BaiduChannelResponse) SetHasCredential(v bool) *BaiduChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *BaiduChannelResponse) SetId(v string) *BaiduChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *BaiduChannelResponse) SetIsArchived(v bool) *BaiduChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *BaiduChannelResponse) SetLastModifiedBy(v string) *BaiduChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *BaiduChannelResponse) SetLastModifiedDate(v string) *BaiduChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *BaiduChannelResponse) SetPlatform(v string) *BaiduChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *BaiduChannelResponse) SetVersion(v int64) *BaiduChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the Baidu (Baidu Cloud Push) channel.
type BaiduMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message.
	Body *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. This value overrides the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The amount of time, in seconds, that the Baidu Cloud Push service should
	// store the message if the recipient's device is offline. The default value
	// and maximum supported time is 604,800 seconds (7 days).
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s BaiduMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BaiduMessage) SetAction(v string) *BaiduMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *BaiduMessage) SetBody(v string) *BaiduMessage {
	s.Body = &v
	return s
}

// SetData sets the Data field's value.
func (s *BaiduMessage) SetData(v map[string]*string) *BaiduMessage {
	s.Data = v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *BaiduMessage) SetIconReference(v string) *BaiduMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *BaiduMessage) SetImageIconUrl(v string) *BaiduMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *BaiduMessage) SetImageUrl(v string) *BaiduMessage {
	s.ImageUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *BaiduMessage) SetRawContent(v string) *BaiduMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *BaiduMessage) SetSilentPush(v bool) *BaiduMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *BaiduMessage) SetSmallImageIconUrl(v string) *BaiduMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *BaiduMessage) SetSound(v string) *BaiduMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *BaiduMessage) SetSubstitutions(v map[string][]*string) *BaiduMessage {
	s.Substitutions = v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *BaiduMessage) SetTimeToLive(v int64) *BaiduMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *BaiduMessage) SetTitle(v string) *BaiduMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *BaiduMessage) SetUrl(v string) *BaiduMessage {
	s.Url = &v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application or campaign.
type BaseKpiResult struct {
	_ struct{} `type:"structure"`

	// An array of objects that provides the results of a query that retrieved the
	// data for a standard metric that applies to an application or campaign.
	//
	// Rows is a required field
	Rows []*ResultRow `type:"list" required:"true"`
}

// String returns the string representation
func (s BaseKpiResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaseKpiResult) GoString() string {
	return s.String()
}

// SetRows sets the Rows field's value.
func (s *BaseKpiResult) SetRows(v []*ResultRow) *BaseKpiResult {
	s.Rows = v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to a campaign, and provides information about that query.
type CampaignDateRangeKpiResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the metric applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier for the campaign that the metric applies to.
	//
	// CampaignId is a required field
	CampaignId *string `type:"string" required:"true"`

	// The last date or date and time of the date range that was used to filter
	// the query results, in ISO 8601 format. The date range is inclusive.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the metric, also referred to as a key performance indicator (KPI),
	// that the data was retrieved for. This value describes the associated metric
	// and consists of two or more terms, which are comprised of lowercase alphanumeric
	// characters, separated by a hyphen. For a list of valid values, see the Amazon
	// Pinpoint Developer Guide (developerguide.html).
	//
	// KpiName is a required field
	KpiName *string `type:"string" required:"true"`

	// An array of objects that contains the results of the query. Each object contains
	// the value for the metric and metadata about that value.
	//
	// KpiResult is a required field
	KpiResult *BaseKpiResult `type:"structure" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null for the Campaign Metrics resource.
	// The Campaign Metrics resource returns all results in a single page.
	NextToken *string `type:"string"`

	// The first date or date and time of the date range that was used to filter
	// the query results, in ISO 8601 format. The date range is inclusive.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s CampaignDateRangeKpiResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignDateRangeKpiResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CampaignDateRangeKpiResponse) SetApplicationId(v string) *CampaignDateRangeKpiResponse {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *CampaignDateRangeKpiResponse) SetCampaignId(v string) *CampaignDateRangeKpiResponse {
	s.CampaignId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CampaignDateRangeKpiResponse) SetEndTime(v time.Time) *CampaignDateRangeKpiResponse {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *CampaignDateRangeKpiResponse) SetKpiName(v string) *CampaignDateRangeKpiResponse {
	s.KpiName = &v
	return s
}

// SetKpiResult sets the KpiResult field's value.
func (s *CampaignDateRangeKpiResponse) SetKpiResult(v *BaseKpiResult) *CampaignDateRangeKpiResponse {
	s.KpiResult = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *CampaignDateRangeKpiResponse) SetNextToken(v string) *CampaignDateRangeKpiResponse {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CampaignDateRangeKpiResponse) SetStartTime(v time.Time) *CampaignDateRangeKpiResponse {
	s.StartTime = &v
	return s
}

// Specifies the content and "From" address for an email message that's sent
// to recipients of a campaign.
type CampaignEmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email for recipients whose email clients don't support HTML
	// content.
	Body *string `type:"string"`

	// The verified email address to send the email from. The default address is
	// the FromAddress specified for the email channel for the application.
	FromAddress *string `type:"string"`

	// The body of the email, in HTML format, for recipients whose email clients
	// support HTML content.
	HtmlBody *string `type:"string"`

	// The subject line, or title, of the email.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CampaignEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignEmailMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CampaignEmailMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CampaignEmailMessage"}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *CampaignEmailMessage) SetBody(v string) *CampaignEmailMessage {
	s.Body = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *CampaignEmailMessage) SetFromAddress(v string) *CampaignEmailMessage {
	s.FromAddress = &v
	return s
}

// SetHtmlBody sets the HtmlBody field's value.
func (s *CampaignEmailMessage) SetHtmlBody(v string) *CampaignEmailMessage {
	s.HtmlBody = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CampaignEmailMessage) SetTitle(v string) *CampaignEmailMessage {
	s.Title = &v
	return s
}

// Specifies the settings for events that cause a campaign to be sent.
type CampaignEventFilter struct {
	_ struct{} `type:"structure"`

	// The dimension settings of the event filter for the campaign.
	//
	// Dimensions is a required field
	Dimensions *EventDimensions `type:"structure" required:"true"`

	// The type of event that causes the campaign to be sent. Valid values are:
	// SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends
	// the campaign when an endpoint event (Events resource) occurs.
	//
	// FilterType is a required field
	FilterType *string `type:"string" required:"true" enum:"FilterType"`
}

// String returns the string representation
func (s CampaignEventFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignEventFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CampaignEventFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CampaignEventFilter"}
	if s.Dimensions == nil {
		invalidParams.Add(request.NewErrParamRequired("Dimensions"))
	}
	if s.FilterType == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterType"))
	}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CampaignEventFilter) SetDimensions(v *EventDimensions) *CampaignEventFilter {
	s.Dimensions = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *CampaignEventFilter) SetFilterType(v string) *CampaignEventFilter {
	s.FilterType = &v
	return s
}

// Specifies the AWS Lambda function to use as a code hook for a campaign.
type CampaignHook struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon
	// Pinpoint invokes to send messages for a campaign.
	LambdaFunctionName *string `type:"string"`

	// Specifies which Lambda mode to use when invoking the AWS Lambda function.
	Mode *string `type:"string" enum:"Mode"`

	// The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function
	// over HTTPS.
	WebUrl *string `type:"string"`
}

// String returns the string representation
func (s CampaignHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignHook) GoString() string {
	return s.String()
}

// SetLambdaFunctionName sets the LambdaFunctionName field's value.
func (s *CampaignHook) SetLambdaFunctionName(v string) *CampaignHook {
	s.LambdaFunctionName = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CampaignHook) SetMode(v string) *CampaignHook {
	s.Mode = &v
	return s
}

// SetWebUrl sets the WebUrl field's value.
func (s *CampaignHook) SetWebUrl(v string) *CampaignHook {
	s.WebUrl = &v
	return s
}

// Specifies limits on the messages that a campaign can send.
type CampaignLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that a campaign can send to a single endpoint
	// during a 24-hour period. The maximum value is 100.
	Daily *int64 `type:"integer"`

	// The maximum amount of time, in seconds, that a campaign can attempt to deliver
	// a message after the scheduled start time for the campaign. The minimum value
	// is 60 seconds.
	MaximumDuration *int64 `type:"integer"`

	// The maximum number of messages that a campaign can send each second. The
	// minimum value is 50. The maximum value is 20,000.
	MessagesPerSecond *int64 `type:"integer"`

	// The maximum number of messages that a campaign can send to a single endpoint
	// during the course of the campaign. The maximum value is 100.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignLimits) GoString() string {
	return s.String()
}

// SetDaily sets the Daily field's value.
func (s *CampaignLimits) SetDaily(v int64) *CampaignLimits {
	s.Daily = &v
	return s
}

// SetMaximumDuration sets the MaximumDuration field's value.
func (s *CampaignLimits) SetMaximumDuration(v int64) *CampaignLimits {
	s.MaximumDuration = &v
	return s
}

// SetMessagesPerSecond sets the MessagesPerSecond field's value.
func (s *CampaignLimits) SetMessagesPerSecond(v int64) *CampaignLimits {
	s.MessagesPerSecond = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *CampaignLimits) SetTotal(v int64) *CampaignLimits {
	s.Total = &v
	return s
}

// Provides information about the status, configuration, and other settings
// for a campaign.
type CampaignResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each treatment that you defined for the campaign,
	// in addition to the default treatment.
	AdditionalTreatments []*TreatmentResource `type:"list"`

	// The unique identifier for the application that the campaign applies to.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the campaign.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date, ISO 8601 format, when the campaign was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The current status of the campaign's default treatment. This value exists
	// only for campaigns that have more than one treatment, to support A/B testing.
	DefaultState *CampaignState `type:"structure"`

	// The custom description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of users (segment members) who shouldn't receive
	// messages from the campaign.
	HoldoutPercent *int64 `type:"integer"`

	// The settings for the AWS Lambda function to use as a code hook for the campaign.
	Hook *CampaignHook `type:"structure"`

	// The unique identifier for the campaign.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies whether the campaign is paused. A paused campaign doesn't run unless
	// you resume it by changing this value to false.
	IsPaused *bool `type:"boolean"`

	// The date, in ISO 8601 format, when the campaign was last modified.
	//
	// LastModifiedDate is a required field
	LastModifiedDate *string `type:"string" required:"true"`

	// The messaging limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings for the campaign.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The name of the campaign.
	Name *string `type:"string"`

	// The schedule settings for the campaign.
	Schedule *Schedule `type:"structure"`

	// The unique identifier for the segment that's associated with the campaign.
	//
	// SegmentId is a required field
	SegmentId *string `type:"string" required:"true"`

	// The version number of the segment that's associated with the campaign.
	//
	// SegmentVersion is a required field
	SegmentVersion *int64 `type:"integer" required:"true"`

	// The current status of the campaign.
	State *CampaignState `type:"structure"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the campaign. Each tag consists of a required tag key and
	// an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The custom description of a variation of the campaign that's used for A/B
	// testing.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign that's used for A/B testing.
	TreatmentName *string `type:"string"`

	// The version number of the campaign.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignResponse) GoString() string {
	return s.String()
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *CampaignResponse) SetAdditionalTreatments(v []*TreatmentResource) *CampaignResponse {
	s.AdditionalTreatments = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CampaignResponse) SetApplicationId(v string) *CampaignResponse {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CampaignResponse) SetArn(v string) *CampaignResponse {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CampaignResponse) SetCreationDate(v string) *CampaignResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultState sets the DefaultState field's value.
func (s *CampaignResponse) SetDefaultState(v *CampaignState) *CampaignResponse {
	s.DefaultState = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CampaignResponse) SetDescription(v string) *CampaignResponse {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *CampaignResponse) SetHoldoutPercent(v int64) *CampaignResponse {
	s.HoldoutPercent = &v
	return s
}

// SetHook sets the Hook field's value.
func (s *CampaignResponse) SetHook(v *CampaignHook) *CampaignResponse {
	s.Hook = v
	return s
}

// SetId sets the Id field's value.
func (s *CampaignResponse) SetId(v string) *CampaignResponse {
	s.Id = &v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *CampaignResponse) SetIsPaused(v bool) *CampaignResponse {
	s.IsPaused = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CampaignResponse) SetLastModifiedDate(v string) *CampaignResponse {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *CampaignResponse) SetLimits(v *CampaignLimits) *CampaignResponse {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *CampaignResponse) SetMessageConfiguration(v *MessageConfiguration) *CampaignResponse {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignResponse) SetName(v string) *CampaignResponse {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CampaignResponse) SetSchedule(v *Schedule) *CampaignResponse {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *CampaignResponse) SetSegmentId(v string) *CampaignResponse {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *CampaignResponse) SetSegmentVersion(v int64) *CampaignResponse {
	s.SegmentVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *CampaignResponse) SetState(v *CampaignState) *CampaignResponse {
	s.State = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CampaignResponse) SetTags(v map[string]*string) *CampaignResponse {
	s.Tags = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *CampaignResponse) SetTreatmentDescription(v string) *CampaignResponse {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *CampaignResponse) SetTreatmentName(v string) *CampaignResponse {
	s.TreatmentName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CampaignResponse) SetVersion(v int64) *CampaignResponse {
	s.Version = &v
	return s
}

// Specifies the content and settings for an SMS message that's sent to recipients
// of a campaign.
type CampaignSmsMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The type of SMS message. Valid values are: TRANSACTIONAL, the message is
	// critical or time-sensitive, such as a one-time password that supports a customer
	// transaction; and, PROMOTIONAL, the message isn't critical or time-sensitive,
	// such as a marketing message.
	MessageType *string `type:"string" enum:"MessageType"`

	// The sender ID to display on recipients' devices when they receive the SMS
	// message.
	SenderId *string `type:"string"`
}

// String returns the string representation
func (s CampaignSmsMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignSmsMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *CampaignSmsMessage) SetBody(v string) *CampaignSmsMessage {
	s.Body = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *CampaignSmsMessage) SetMessageType(v string) *CampaignSmsMessage {
	s.MessageType = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *CampaignSmsMessage) SetSenderId(v string) *CampaignSmsMessage {
	s.SenderId = &v
	return s
}

// Provides information about the status of a campaign.
type CampaignState struct {
	_ struct{} `type:"structure"`

	// The status of the campaign, or the status of a treatment that belongs to
	// an A/B test campaign. If a campaign uses A/B testing, the campaign has a
	// status of COMPLETED only when all campaign treatments have a status of COMPLETED.
	CampaignStatus *string `type:"string" enum:"CampaignStatus"`
}

// String returns the string representation
func (s CampaignState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignState) GoString() string {
	return s.String()
}

// SetCampaignStatus sets the CampaignStatus field's value.
func (s *CampaignState) SetCampaignStatus(v string) *CampaignState {
	s.CampaignStatus = &v
	return s
}

// Provides information about the configuration and other settings for all the
// campaigns that are associated with an application.
type CampaignsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each campaign that's associated with the application.
	//
	// Item is a required field
	Item []*CampaignResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s CampaignsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *CampaignsResponse) SetItem(v []*CampaignResponse) *CampaignsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *CampaignsResponse) SetNextToken(v string) *CampaignsResponse {
	s.NextToken = &v
	return s
}

// Provides information about the general settings and status of a channel for
// an application.
type ChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the channel. This property is retained only
	// for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The current version of the channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ChannelResponse) SetApplicationId(v string) *ChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ChannelResponse) SetCreationDate(v string) *ChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ChannelResponse) SetEnabled(v bool) *ChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *ChannelResponse) SetHasCredential(v bool) *ChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *ChannelResponse) SetId(v string) *ChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *ChannelResponse) SetIsArchived(v bool) *ChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ChannelResponse) SetLastModifiedBy(v string) *ChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ChannelResponse) SetLastModifiedDate(v string) *ChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ChannelResponse) SetVersion(v int64) *ChannelResponse {
	s.Version = &v
	return s
}

// Provides information about the general settings and status of all channels
// for an application, including channels that aren't enabled for the application.
type ChannelsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each channel. For each item
	// in this object, the ChannelType is the key and the Channel is the value.
	//
	// Channels is a required field
	Channels map[string]*ChannelResponse `type:"map" required:"true"`
}

// String returns the string representation
func (s ChannelsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelsResponse) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ChannelsResponse) SetChannels(v map[string]*ChannelResponse) *ChannelsResponse {
	s.Channels = v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure" payload:"CreateApplicationRequest"`

	// Specifies the display name of an application and the tags to associate with
	// the application.
	//
	// CreateApplicationRequest is a required field
	CreateApplicationRequest *CreateApplicationRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.CreateApplicationRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateApplicationRequest"))
	}
	if s.CreateApplicationRequest != nil {
		if err := s.CreateApplicationRequest.Validate(); err != nil {
			invalidParams.AddNested("CreateApplicationRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateApplicationRequest sets the CreateApplicationRequest field's value.
func (s *CreateAppInput) SetCreateApplicationRequest(v *CreateApplicationRequest) *CreateAppInput {
	s.CreateApplicationRequest = v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Provides information about an application.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *CreateAppOutput) SetApplicationResponse(v *ApplicationResponse) *CreateAppOutput {
	s.ApplicationResponse = v
	return s
}

// Specifies the display name of an application and the tags to associate with
// the application.
type CreateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// The display name of the application. This name is displayed as the Project
	// name on the Amazon Pinpoint console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the application. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateApplicationRequest) SetName(v string) *CreateApplicationRequest {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationRequest) SetTags(v map[string]*string) *CreateApplicationRequest {
	s.Tags = v
	return s
}

type CreateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a campaign.
	//
	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}
	if s.WriteCampaignRequest != nil {
		if err := s.WriteCampaignRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteCampaignRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCampaignInput) SetApplicationId(v string) *CreateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *CreateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *CreateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *CreateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *CreateCampaignOutput {
	s.CampaignResponse = v
	return s
}

type CreateExportJobInput struct {
	_ struct{} `type:"structure" payload:"ExportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the settings for a job that exports endpoint definitions to an
	// Amazon Simple Storage Service (Amazon S3) bucket.
	//
	// ExportJobRequest is a required field
	ExportJobRequest *ExportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ExportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportJobRequest"))
	}
	if s.ExportJobRequest != nil {
		if err := s.ExportJobRequest.Validate(); err != nil {
			invalidParams.AddNested("ExportJobRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateExportJobInput) SetApplicationId(v string) *CreateExportJobInput {
	s.ApplicationId = &v
	return s
}

// SetExportJobRequest sets the ExportJobRequest field's value.
func (s *CreateExportJobInput) SetExportJobRequest(v *ExportJobRequest) *CreateExportJobInput {
	s.ExportJobRequest = v
	return s
}

type CreateExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// Provides information about the status and settings of a job that exports
	// endpoint definitions to a file. The file can be added directly to an Amazon
	// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
	// or downloaded directly to a computer by using the Amazon Pinpoint console.
	//
	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobResponse sets the ExportJobResponse field's value.
func (s *CreateExportJobOutput) SetExportJobResponse(v *ExportJobResponse) *CreateExportJobOutput {
	s.ExportJobResponse = v
	return s
}

type CreateImportJobInput struct {
	_ struct{} `type:"structure" payload:"ImportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the settings for a job that imports endpoint definitions from an
	// Amazon Simple Storage Service (Amazon S3) bucket.
	//
	// ImportJobRequest is a required field
	ImportJobRequest *ImportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ImportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportJobRequest"))
	}
	if s.ImportJobRequest != nil {
		if err := s.ImportJobRequest.Validate(); err != nil {
			invalidParams.AddNested("ImportJobRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateImportJobInput) SetApplicationId(v string) *CreateImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetImportJobRequest sets the ImportJobRequest field's value.
func (s *CreateImportJobInput) SetImportJobRequest(v *ImportJobRequest) *CreateImportJobInput {
	s.ImportJobRequest = v
	return s
}

type CreateImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// Provides information about the status and settings of a job that imports
	// endpoint definitions from one or more files. The files can be stored in an
	// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
	// a computer by using the Amazon Pinpoint console.
	//
	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *CreateImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *CreateImportJobOutput {
	s.ImportJobResponse = v
	return s
}

type CreateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the configuration, dimension, and other settings for a segment.
	// A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups
	// object, but not both.
	//
	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}
	if s.WriteSegmentRequest != nil {
		if err := s.WriteSegmentRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteSegmentRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateSegmentInput) SetApplicationId(v string) *CreateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *CreateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *CreateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

type CreateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *CreateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *CreateSegmentOutput {
	s.SegmentResponse = v
	return s
}

// Specifies the default message to use for all channels.
type DefaultMessage struct {
	_ struct{} `type:"structure"`

	// The default message body of the push notification, email, or SMS message.
	Body *string `type:"string"`

	// The default message variables to use in the push notification, email, or
	// SMS message. You can override these default variables with individual address
	// variables.
	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s DefaultMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *DefaultMessage) SetBody(v string) *DefaultMessage {
	s.Body = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *DefaultMessage) SetSubstitutions(v map[string][]*string) *DefaultMessage {
	s.Substitutions = v
	return s
}

// Specifies the default settings and content for a push notification that's
// sent directly to an endpoint.
type DefaultPushNotificationMessage struct {
	_ struct{} `type:"structure"`

	// The default action to occur if a recipient taps the push notification. Valid
	// values are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of the iOS and
	//    Android platforms.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The default body of the notification message.
	Body *string `type:"string"`

	// The JSON data payload to use for the default push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// Specifies whether the default notification is a silent push notification,
	// which is a push notification that doesn't display on a recipient's device.
	// Silent push notifications can be used for cases such as updating an app's
	// configuration or delivering messages to an in-app notification center.
	SilentPush *bool `type:"boolean"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The default title to display above the notification message on a recipient's
	// device.
	Title *string `type:"string"`

	// The default URL to open in a recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultPushNotificationMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DefaultPushNotificationMessage) SetAction(v string) *DefaultPushNotificationMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *DefaultPushNotificationMessage) SetBody(v string) *DefaultPushNotificationMessage {
	s.Body = &v
	return s
}

// SetData sets the Data field's value.
func (s *DefaultPushNotificationMessage) SetData(v map[string]*string) *DefaultPushNotificationMessage {
	s.Data = v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *DefaultPushNotificationMessage) SetSilentPush(v bool) *DefaultPushNotificationMessage {
	s.SilentPush = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *DefaultPushNotificationMessage) SetSubstitutions(v map[string][]*string) *DefaultPushNotificationMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *DefaultPushNotificationMessage) SetTitle(v string) *DefaultPushNotificationMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DefaultPushNotificationMessage) SetUrl(v string) *DefaultPushNotificationMessage {
	s.Url = &v
	return s
}

type DeleteAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAdmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteAdmChannelInput) SetApplicationId(v string) *DeleteAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Provides information about the status and settings of the ADM (Amazon Device
	// Messaging) channel for an application.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *DeleteAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *DeleteAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type DeleteApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsChannelInput) SetApplicationId(v string) *DeleteApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *DeleteApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *DeleteApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type DeleteApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsSandboxChannelInput) SetApplicationId(v string) *DeleteApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) sandbox channel for an application.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *DeleteApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *DeleteApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type DeleteApnsVoipChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsVoipChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsVoipChannelInput) SetApplicationId(v string) *DeleteApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP channel for an application.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *DeleteApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *DeleteApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type DeleteApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsVoipSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsVoipSandboxChannelInput) SetApplicationId(v string) *DeleteApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *DeleteApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *DeleteApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteAppInput) SetApplicationId(v string) *DeleteAppInput {
	s.ApplicationId = &v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Provides information about an application.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *DeleteAppOutput) SetApplicationResponse(v *ApplicationResponse) *DeleteAppOutput {
	s.ApplicationResponse = v
	return s
}

type DeleteBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteBaiduChannelInput) SetApplicationId(v string) *DeleteBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Provides information about the status and settings of the Baidu (Baidu Cloud
	// Push) channel for an application.
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *DeleteBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *DeleteBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteCampaignInput) SetApplicationId(v string) *DeleteCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *DeleteCampaignInput) SetCampaignId(v string) *DeleteCampaignInput {
	s.CampaignId = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *DeleteCampaignOutput) SetCampaignResponse(v *CampaignResponse) *DeleteCampaignOutput {
	s.CampaignResponse = v
	return s
}

type DeleteEmailChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEmailChannelInput) SetApplicationId(v string) *DeleteEmailChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Provides information about the status and settings of the email channel for
	// an application.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *DeleteEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *DeleteEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEndpointInput) SetApplicationId(v string) *DeleteEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DeleteEndpointInput) SetEndpointId(v string) *DeleteEndpointInput {
	s.EndpointId = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// Provides information about the channel type and other settings for an endpoint.
	//
	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *DeleteEndpointOutput) SetEndpointResponse(v *EndpointResponse) *DeleteEndpointOutput {
	s.EndpointResponse = v
	return s
}

type DeleteEventStreamInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEventStreamInput) SetApplicationId(v string) *DeleteEventStreamInput {
	s.ApplicationId = &v
	return s
}

type DeleteEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Specifies settings for publishing event data to an Amazon Kinesis data stream
	// or an Amazon Kinesis Data Firehose delivery stream.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *DeleteEventStreamOutput) SetEventStream(v *EventStream) *DeleteEventStreamOutput {
	s.EventStream = v
	return s
}

type DeleteGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteGcmChannelInput) SetApplicationId(v string) *DeleteGcmChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Provides information about the status and settings of the GCM channel for
	// an application. The GCM channel enables Amazon Pinpoint to send push notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service.
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *DeleteGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *DeleteGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type DeleteSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSegmentInput) SetApplicationId(v string) *DeleteSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *DeleteSegmentInput) SetSegmentId(v string) *DeleteSegmentInput {
	s.SegmentId = &v
	return s
}

type DeleteSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *DeleteSegmentOutput) SetSegmentResponse(v *SegmentResponse) *DeleteSegmentOutput {
	s.SegmentResponse = v
	return s
}

type DeleteSmsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSmsChannelInput) SetApplicationId(v string) *DeleteSmsChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// Provides information about the status and settings of the SMS channel for
	// an application.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *DeleteSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *DeleteSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

type DeleteUserEndpointsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// UserId is a required field
	UserId *string `location:"uri" locationName:"user-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserEndpointsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteUserEndpointsInput) SetApplicationId(v string) *DeleteUserEndpointsInput {
	s.ApplicationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserEndpointsInput) SetUserId(v string) *DeleteUserEndpointsInput {
	s.UserId = &v
	return s
}

type DeleteUserEndpointsOutput struct {
	_ struct{} `type:"structure" payload:"EndpointsResponse"`

	// Provides information about all the endpoints that are associated with a user
	// ID.
	//
	// EndpointsResponse is a required field
	EndpointsResponse *EndpointsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteUserEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointsResponse sets the EndpointsResponse field's value.
func (s *DeleteUserEndpointsOutput) SetEndpointsResponse(v *EndpointsResponse) *DeleteUserEndpointsOutput {
	s.EndpointsResponse = v
	return s
}

type DeleteVoiceChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteVoiceChannelInput) SetApplicationId(v string) *DeleteVoiceChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteVoiceChannelOutput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelResponse"`

	// Provides information about the status and settings of the voice channel for
	// an application.
	//
	// VoiceChannelResponse is a required field
	VoiceChannelResponse *VoiceChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceChannelOutput) GoString() string {
	return s.String()
}

// SetVoiceChannelResponse sets the VoiceChannelResponse field's value.
func (s *DeleteVoiceChannelOutput) SetVoiceChannelResponse(v *VoiceChannelResponse) *DeleteVoiceChannelOutput {
	s.VoiceChannelResponse = v
	return s
}

// Specifies the settings and content for the default message and any default
// messages that you tailored for specific channels.
type DirectMessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The default push notification message for the ADM (Amazon Device Messaging)
	// channel. This message overrides the default push notification message (DefaultPushNotificationMessage).
	ADMMessage *ADMMessage `type:"structure"`

	// The default push notification message for the APNs (Apple Push Notification
	// service) channel. This message overrides the default push notification message
	// (DefaultPushNotificationMessage).
	APNSMessage *APNSMessage `type:"structure"`

	// The default push notification message for the Baidu (Baidu Cloud Push) channel.
	// This message overrides the default push notification message (DefaultPushNotificationMessage).
	BaiduMessage *BaiduMessage `type:"structure"`

	// The default message body for all channels.
	DefaultMessage *DefaultMessage `type:"structure"`

	// The default push notification message for all push channels.
	DefaultPushNotificationMessage *DefaultPushNotificationMessage `type:"structure"`

	// The default message for the email channel. This message overrides the default
	// message (DefaultMessage).
	EmailMessage *EmailMessage `type:"structure"`

	// The default push notification message for the GCM channel, which is used
	// to send notifications through the Firebase Cloud Messaging (FCM), formerly
	// Google Cloud Messaging (GCM), service. This message overrides the default
	// push notification message (DefaultPushNotificationMessage).
	GCMMessage *GCMMessage `type:"structure"`

	// The default message for the SMS channel. This message overrides the default
	// message (DefaultMessage).
	SMSMessage *SMSMessage `type:"structure"`

	// The default message for the voice channel. This message overrides the default
	// message (DefaultMessage).
	VoiceMessage *VoiceMessage `type:"structure"`
}

// String returns the string representation
func (s DirectMessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectMessageConfiguration) GoString() string {
	return s.String()
}

// SetADMMessage sets the ADMMessage field's value.
func (s *DirectMessageConfiguration) SetADMMessage(v *ADMMessage) *DirectMessageConfiguration {
	s.ADMMessage = v
	return s
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *DirectMessageConfiguration) SetAPNSMessage(v *APNSMessage) *DirectMessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetBaiduMessage sets the BaiduMessage field's value.
func (s *DirectMessageConfiguration) SetBaiduMessage(v *BaiduMessage) *DirectMessageConfiguration {
	s.BaiduMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *DirectMessageConfiguration) SetDefaultMessage(v *DefaultMessage) *DirectMessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetDefaultPushNotificationMessage sets the DefaultPushNotificationMessage field's value.
func (s *DirectMessageConfiguration) SetDefaultPushNotificationMessage(v *DefaultPushNotificationMessage) *DirectMessageConfiguration {
	s.DefaultPushNotificationMessage = v
	return s
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *DirectMessageConfiguration) SetEmailMessage(v *EmailMessage) *DirectMessageConfiguration {
	s.EmailMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *DirectMessageConfiguration) SetGCMMessage(v *GCMMessage) *DirectMessageConfiguration {
	s.GCMMessage = v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *DirectMessageConfiguration) SetSMSMessage(v *SMSMessage) *DirectMessageConfiguration {
	s.SMSMessage = v
	return s
}

// SetVoiceMessage sets the VoiceMessage field's value.
func (s *DirectMessageConfiguration) SetVoiceMessage(v *VoiceMessage) *DirectMessageConfiguration {
	s.VoiceMessage = v
	return s
}

// Specifies the status and settings of the email channel for an application.
type EmailChannelRequest struct {
	_ struct{} `type:"structure"`

	// The configuration set that you want to apply to email that you send through
	// the channel by using the Amazon Pinpoint Email API (emailAPIreference.html).
	ConfigurationSet *string `type:"string"`

	// Specifies whether to enable the email channel for the application.
	Enabled *bool `type:"boolean"`

	// The verified email address that you want to send email from when you send
	// email through the channel.
	//
	// FromAddress is a required field
	FromAddress *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
	// Email Service (Amazon SES), that you want to use when you send email through
	// the channel.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that you want
	// Amazon Pinpoint to use when it submits email-related event data for the channel.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EmailChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailChannelRequest"}
	if s.FromAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromAddress"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *EmailChannelRequest) SetConfigurationSet(v string) *EmailChannelRequest {
	s.ConfigurationSet = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EmailChannelRequest) SetEnabled(v bool) *EmailChannelRequest {
	s.Enabled = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailChannelRequest) SetFromAddress(v string) *EmailChannelRequest {
	s.FromAddress = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *EmailChannelRequest) SetIdentity(v string) *EmailChannelRequest {
	s.Identity = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EmailChannelRequest) SetRoleArn(v string) *EmailChannelRequest {
	s.RoleArn = &v
	return s
}

// Provides information about the status and settings of the email channel for
// an application.
type EmailChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the email channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The configuration set that's applied to email that's sent through the channel
	// by using the Amazon Pinpoint Email API (emailAPIreference.html).
	ConfigurationSet *string `type:"string"`

	// The date and time, in ISO 8601 format, when the email channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the email channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// The verified email address that you send email from when you send email through
	// the channel.
	FromAddress *string `type:"string"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the email channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple
	// Email Service (Amazon SES), that you use when you send email through the
	// channel.
	Identity *string `type:"string"`

	// Specifies whether the email channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the email channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the email channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The maximum number of emails that you can send through the channel each second.
	MessagesPerSecond *int64 `type:"integer"`

	// The type of messaging or notification platform for the channel. For the email
	// channel, this value is EMAIL.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that Amazon
	// Pinpoint uses to submit email-related event data for the channel.
	RoleArn *string `type:"string"`

	// The current version of the email channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s EmailChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EmailChannelResponse) SetApplicationId(v string) *EmailChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *EmailChannelResponse) SetConfigurationSet(v string) *EmailChannelResponse {
	s.ConfigurationSet = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EmailChannelResponse) SetCreationDate(v string) *EmailChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EmailChannelResponse) SetEnabled(v bool) *EmailChannelResponse {
	s.Enabled = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailChannelResponse) SetFromAddress(v string) *EmailChannelResponse {
	s.FromAddress = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *EmailChannelResponse) SetHasCredential(v bool) *EmailChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *EmailChannelResponse) SetId(v string) *EmailChannelResponse {
	s.Id = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *EmailChannelResponse) SetIdentity(v string) *EmailChannelResponse {
	s.Identity = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *EmailChannelResponse) SetIsArchived(v bool) *EmailChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *EmailChannelResponse) SetLastModifiedBy(v string) *EmailChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EmailChannelResponse) SetLastModifiedDate(v string) *EmailChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetMessagesPerSecond sets the MessagesPerSecond field's value.
func (s *EmailChannelResponse) SetMessagesPerSecond(v int64) *EmailChannelResponse {
	s.MessagesPerSecond = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EmailChannelResponse) SetPlatform(v string) *EmailChannelResponse {
	s.Platform = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EmailChannelResponse) SetRoleArn(v string) *EmailChannelResponse {
	s.RoleArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *EmailChannelResponse) SetVersion(v int64) *EmailChannelResponse {
	s.Version = &v
	return s
}

// Specifies the default settings and content for a one-time email message that's
// sent directly to an endpoint.
type EmailMessage struct {
	_ struct{} `type:"structure"`

	// The body of the email message.
	Body *string `type:"string"`

	// The email address to forward bounces and complaints to, if feedback forwarding
	// is enabled.
	FeedbackForwardingAddress *string `type:"string"`

	// The verified email address to send the email message from. The default value
	// is the FromAddress specified for the email channel.
	FromAddress *string `type:"string"`

	// The email message, represented as a raw MIME message.
	RawEmail *RawEmail `type:"structure"`

	// The reply-to email address(es) for the email message. If a recipient replies
	// to the email, each reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email message, composed of a subject, a text part, and an HTML part.
	SimpleEmail *SimpleEmail `type:"structure"`

	// The default message variables to use in the email message. You can override
	// the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s EmailMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *EmailMessage) SetBody(v string) *EmailMessage {
	s.Body = &v
	return s
}

// SetFeedbackForwardingAddress sets the FeedbackForwardingAddress field's value.
func (s *EmailMessage) SetFeedbackForwardingAddress(v string) *EmailMessage {
	s.FeedbackForwardingAddress = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailMessage) SetFromAddress(v string) *EmailMessage {
	s.FromAddress = &v
	return s
}

// SetRawEmail sets the RawEmail field's value.
func (s *EmailMessage) SetRawEmail(v *RawEmail) *EmailMessage {
	s.RawEmail = v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *EmailMessage) SetReplyToAddresses(v []*string) *EmailMessage {
	s.ReplyToAddresses = v
	return s
}

// SetSimpleEmail sets the SimpleEmail field's value.
func (s *EmailMessage) SetSimpleEmail(v *SimpleEmail) *EmailMessage {
	s.SimpleEmail = v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *EmailMessage) SetSubstitutions(v map[string][]*string) *EmailMessage {
	s.Substitutions = v
	return s
}

// Specifies an endpoint to create or update and the settings and attributes
// to set or change for the endpoint.
type EndpointBatchItem struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For a push-notification channel,
	// use the token provided by the push notification service, such as an Apple
	// Push Notification service (APNs) device token or a Firebase Cloud Messaging
	// (FCM) registration token. For the SMS channel, use a phone number in E.164
	// format, such as +12065550100. For the email channel, use an email address.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["science", "music", "travel"]. You can use these
	// attributes as filter criteria when you create segments.
	//
	// When you define the name of a custom attribute, avoid using the following
	// characters: number sign (#), colon (:), question mark (?), backslash (\),
	// and slash (/). The Amazon Pinpoint console can't display attribute names
	// that contain these characters. This limitation doesn't apply to attribute
	// values.
	Attributes map[string][]*string `type:"map"`

	// The channel to use when sending messages or push notifications to the endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was created or updated.
	EffectiveDate *string `type:"string"`

	// Not used.
	EndpointStatus *string `type:"string"`

	// The unique identifier for the endpoint in the context of the batch.
	Id *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the request to create or update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointBatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchItem) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointBatchItem) SetAddress(v string) *EndpointBatchItem {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointBatchItem) SetAttributes(v map[string][]*string) *EndpointBatchItem {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointBatchItem) SetChannelType(v string) *EndpointBatchItem {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointBatchItem) SetDemographic(v *EndpointDemographic) *EndpointBatchItem {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointBatchItem) SetEffectiveDate(v string) *EndpointBatchItem {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointBatchItem) SetEndpointStatus(v string) *EndpointBatchItem {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointBatchItem) SetId(v string) *EndpointBatchItem {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointBatchItem) SetLocation(v *EndpointLocation) *EndpointBatchItem {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointBatchItem) SetMetrics(v map[string]*float64) *EndpointBatchItem {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointBatchItem) SetOptOut(v string) *EndpointBatchItem {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointBatchItem) SetRequestId(v string) *EndpointBatchItem {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointBatchItem) SetUser(v *EndpointUser) *EndpointBatchItem {
	s.User = v
	return s
}

// Specifies a batch of endpoints to create or update and the settings and attributes
// to set or change for each endpoint.
type EndpointBatchRequest struct {
	_ struct{} `type:"structure"`

	// An array that defines the endpoints to create or update and, for each endpoint,
	// the property values to set or change. An array can contain a maximum of 100
	// items.
	//
	// Item is a required field
	Item []*EndpointBatchItem `type:"list" required:"true"`
}

// String returns the string representation
func (s EndpointBatchRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointBatchRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointBatchRequest"}
	if s.Item == nil {
		invalidParams.Add(request.NewErrParamRequired("Item"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItem sets the Item field's value.
func (s *EndpointBatchRequest) SetItem(v []*EndpointBatchItem) *EndpointBatchRequest {
	s.Item = v
	return s
}

// Specifies demographic information about an endpoint, such as the applicable
// time zone and platform.
type EndpointDemographic struct {
	_ struct{} `type:"structure"`

	// The version of the app that's associated with the endpoint.
	AppVersion *string `type:"string"`

	// The locale of the endpoint, in the following format: the ISO 639-1 alpha-2
	// code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.
	Locale *string `type:"string"`

	// The manufacturer of the endpoint device, such as Apple or Samsung.
	Make *string `type:"string"`

	// The model name or number of the endpoint device, such as iPhone.
	Model *string `type:"string"`

	// The model version of the endpoint device.
	ModelVersion *string `type:"string"`

	// The platform of the endpoint device, such as iOS or Android.
	Platform *string `type:"string"`

	// The platform version of the endpoint device.
	PlatformVersion *string `type:"string"`

	// The time zone of the endpoint, specified as a tz database name value, such
	// as America/Los_Angeles.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EndpointDemographic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDemographic) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *EndpointDemographic) SetAppVersion(v string) *EndpointDemographic {
	s.AppVersion = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *EndpointDemographic) SetLocale(v string) *EndpointDemographic {
	s.Locale = &v
	return s
}

// SetMake sets the Make field's value.
func (s *EndpointDemographic) SetMake(v string) *EndpointDemographic {
	s.Make = &v
	return s
}

// SetModel sets the Model field's value.
func (s *EndpointDemographic) SetModel(v string) *EndpointDemographic {
	s.Model = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *EndpointDemographic) SetModelVersion(v string) *EndpointDemographic {
	s.ModelVersion = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EndpointDemographic) SetPlatform(v string) *EndpointDemographic {
	s.Platform = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EndpointDemographic) SetPlatformVersion(v string) *EndpointDemographic {
	s.PlatformVersion = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *EndpointDemographic) SetTimezone(v string) *EndpointDemographic {
	s.Timezone = &v
	return s
}

// Provides the status code and message that result from processing data for
// an endpoint.
type EndpointItemResponse struct {
	_ struct{} `type:"structure"`

	// The custom message that's returned in the response as a result of processing
	// the endpoint data.
	Message *string `type:"string"`

	// The status code that's returned in the response as a result of processing
	// the endpoint data.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EndpointItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointItemResponse) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *EndpointItemResponse) SetMessage(v string) *EndpointItemResponse {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EndpointItemResponse) SetStatusCode(v int64) *EndpointItemResponse {
	s.StatusCode = &v
	return s
}

// Specifies geographic information about an endpoint.
type EndpointLocation struct {
	_ struct{} `type:"structure"`

	// The name of the city where the endpoint is located.
	City *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the endpoint is located. For example, US for the United States.
	Country *string `type:"string"`

	// The latitude coordinate of the endpoint location, rounded to one decimal
	// place.
	Latitude *float64 `type:"double"`

	// The longitude coordinate of the endpoint location, rounded to one decimal
	// place.
	Longitude *float64 `type:"double"`

	// The postal or ZIP code for the area where the endpoint is located.
	PostalCode *string `type:"string"`

	// The name of the region where the endpoint is located. For locations in the
	// United States, this value is the name of a state.
	Region *string `type:"string"`
}

// String returns the string representation
func (s EndpointLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointLocation) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *EndpointLocation) SetCity(v string) *EndpointLocation {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *EndpointLocation) SetCountry(v string) *EndpointLocation {
	s.Country = &v
	return s
}

// SetLatitude sets the Latitude field's value.
func (s *EndpointLocation) SetLatitude(v float64) *EndpointLocation {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *EndpointLocation) SetLongitude(v float64) *EndpointLocation {
	s.Longitude = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *EndpointLocation) SetPostalCode(v string) *EndpointLocation {
	s.PostalCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EndpointLocation) SetRegion(v string) *EndpointLocation {
	s.Region = &v
	return s
}

// Provides information about the delivery status and results of sending a message
// directly to an endpoint.
type EndpointMessageResult struct {
	_ struct{} `type:"structure"`

	// The endpoint address that the message was delivered to.
	Address *string `type:"string"`

	// The delivery status of the message. Possible values are:
	//
	//    * DUPLICATE - The endpoint address is a duplicate of another endpoint
	//    address. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * OPT_OUT - The user who's associated with the endpoint has opted out
	//    of receiving messages from you. Amazon Pinpoint won't attempt to send
	//    the message again.
	//
	//    * PERMANENT_FAILURE - An error occurred when delivering the message to
	//    the endpoint. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * SUCCESSFUL - The message was successfully delivered to the endpoint.
	//
	//    * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint will
	//    attempt to deliver the message again later.
	//
	//    * THROTTLED - Amazon Pinpoint throttled the operation to send the message
	//    to the endpoint.
	//
	//    * TIMEOUT - The message couldn't be sent within the timeout period.
	//
	//    * UNKNOWN_FAILURE - An unknown error occurred.
	//
	// DeliveryStatus is a required field
	DeliveryStatus *string `type:"string" required:"true" enum:"DeliveryStatus"`

	// The unique identifier for the message that was sent.
	MessageId *string `type:"string"`

	// The downstream service status code for delivering the message.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The status message for delivering the message.
	StatusMessage *string `type:"string"`

	// For push notifications that are sent through the GCM channel, specifies whether
	// the token was updated as part of delivering the message.
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s EndpointMessageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointMessageResult) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointMessageResult) SetAddress(v string) *EndpointMessageResult {
	s.Address = &v
	return s
}

// SetDeliveryStatus sets the DeliveryStatus field's value.
func (s *EndpointMessageResult) SetDeliveryStatus(v string) *EndpointMessageResult {
	s.DeliveryStatus = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *EndpointMessageResult) SetMessageId(v string) *EndpointMessageResult {
	s.MessageId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EndpointMessageResult) SetStatusCode(v int64) *EndpointMessageResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *EndpointMessageResult) SetStatusMessage(v string) *EndpointMessageResult {
	s.StatusMessage = &v
	return s
}

// SetUpdatedToken sets the UpdatedToken field's value.
func (s *EndpointMessageResult) SetUpdatedToken(v string) *EndpointMessageResult {
	s.UpdatedToken = &v
	return s
}

// Specifies the channel type and other settings for an endpoint.
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For a push-notification channel,
	// use the token provided by the push notification service, such as an Apple
	// Push Notification service (APNs) device token or a Firebase Cloud Messaging
	// (FCM) registration token. For the SMS channel, use a phone number in E.164
	// format, such as +12065550100. For the email channel, use an email address.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["science", "music", "travel"]. You can use these
	// attributes as filter criteria when you create segments.
	//
	// When you define the name of a custom attribute, avoid using the following
	// characters: number sign (#), colon (:), question mark (?), backslash (\),
	// and slash (/). The Amazon Pinpoint console can't display attribute names
	// that contain these characters. This limitation doesn't apply to attribute
	// values.
	Attributes map[string][]*string `type:"map"`

	// The channel to use when sending messages or push notifications to the endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint is updated.
	EffectiveDate *string `type:"string"`

	// Not used.
	EndpointStatus *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that describe the user who's associated
	// with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointRequest) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointRequest) SetAddress(v string) *EndpointRequest {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointRequest) SetAttributes(v map[string][]*string) *EndpointRequest {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointRequest) SetChannelType(v string) *EndpointRequest {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointRequest) SetDemographic(v *EndpointDemographic) *EndpointRequest {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointRequest) SetEffectiveDate(v string) *EndpointRequest {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointRequest) SetEndpointStatus(v string) *EndpointRequest {
	s.EndpointStatus = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointRequest) SetLocation(v *EndpointLocation) *EndpointRequest {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointRequest) SetMetrics(v map[string]*float64) *EndpointRequest {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointRequest) SetOptOut(v string) *EndpointRequest {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointRequest) SetRequestId(v string) *EndpointRequest {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointRequest) SetUser(v *EndpointUser) *EndpointRequest {
	s.User = v
	return s
}

// Provides information about the channel type and other settings for an endpoint.
type EndpointResponse struct {
	_ struct{} `type:"structure"`

	// The destination address for messages or push notifications that you send
	// to the endpoint. The address varies by channel. For example, the address
	// for a push-notification channel is typically the token provided by a push
	// notification service, such as an Apple Push Notification service (APNs) device
	// token or a Firebase Cloud Messaging (FCM) registration token. The address
	// for the SMS channel is a phone number in E.164 format, such as +12065550100.
	// The address for the email channel is an email address.
	Address *string `type:"string"`

	// The unique identifier for the application that's associated with the endpoint.
	ApplicationId *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. For example, the value of a custom attribute
	// named Interests might be: ["science", "music", "travel"]. You can use these
	// attributes as filter criteria when you create segments.
	Attributes map[string][]*string `type:"map"`

	// The channel that's used when sending messages or push notifications to the
	// endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// A number from 0-99 that represents the cohort that the endpoint is assigned
	// to. Endpoints are grouped into cohorts randomly, and each cohort contains
	// approximately 1 percent of the endpoints for an application. Amazon Pinpoint
	// assigns cohorts to the holdout or treatment allocations for campaigns.
	CohortId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the endpoint was created.
	CreationDate *string `type:"string"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was last updated.
	EffectiveDate *string `type:"string"`

	// Not used.
	EndpointStatus *string `type:"string"`

	// The unique identifier that you assigned to the endpoint. The identifier should
	// be a globally unique identifier (GUID) to ensure that it doesn't conflict
	// with other endpoint identifiers that are associated with the application.
	Id *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// The unique identifier for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointResponse) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointResponse) SetAddress(v string) *EndpointResponse {
	s.Address = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EndpointResponse) SetApplicationId(v string) *EndpointResponse {
	s.ApplicationId = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointResponse) SetAttributes(v map[string][]*string) *EndpointResponse {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointResponse) SetChannelType(v string) *EndpointResponse {
	s.ChannelType = &v
	return s
}

// SetCohortId sets the CohortId field's value.
func (s *EndpointResponse) SetCohortId(v string) *EndpointResponse {
	s.CohortId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EndpointResponse) SetCreationDate(v string) *EndpointResponse {
	s.CreationDate = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointResponse) SetDemographic(v *EndpointDemographic) *EndpointResponse {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointResponse) SetEffectiveDate(v string) *EndpointResponse {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointResponse) SetEndpointStatus(v string) *EndpointResponse {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointResponse) SetId(v string) *EndpointResponse {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointResponse) SetLocation(v *EndpointLocation) *EndpointResponse {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointResponse) SetMetrics(v map[string]*float64) *EndpointResponse {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointResponse) SetOptOut(v string) *EndpointResponse {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointResponse) SetRequestId(v string) *EndpointResponse {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointResponse) SetUser(v *EndpointUser) *EndpointResponse {
	s.User = v
	return s
}

// Specifies the content, including message variables and attributes, to use
// in a message that's sent directly to an endpoint.
type EndpointSendConfiguration struct {
	_ struct{} `type:"structure"`

	// The body of the message. If specified, this value overrides the default message
	// body.
	BodyOverride *string `type:"string"`

	// A map of custom attributes to attach to the message for the address. For
	// a push notification, this payload is added to the data.pinpoint object. For
	// an email or text message, this payload is added to email/SMS delivery receipt
	// event attributes.
	Context map[string]*string `type:"map"`

	// The raw, JSON-formatted string to use as the payload for the message. If
	// specified, this value overrides the message.
	RawContent *string `type:"string"`

	// A map of the message variables to merge with the variables specified for
	// the default message (DefaultMessage.Substitutions). The variables specified
	// in this map take precedence over all other variables.
	Substitutions map[string][]*string `type:"map"`

	// The title or subject line of the message. If specified, this value overrides
	// the default message title or subject line.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s EndpointSendConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointSendConfiguration) GoString() string {
	return s.String()
}

// SetBodyOverride sets the BodyOverride field's value.
func (s *EndpointSendConfiguration) SetBodyOverride(v string) *EndpointSendConfiguration {
	s.BodyOverride = &v
	return s
}

// SetContext sets the Context field's value.
func (s *EndpointSendConfiguration) SetContext(v map[string]*string) *EndpointSendConfiguration {
	s.Context = v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *EndpointSendConfiguration) SetRawContent(v string) *EndpointSendConfiguration {
	s.RawContent = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *EndpointSendConfiguration) SetSubstitutions(v map[string][]*string) *EndpointSendConfiguration {
	s.Substitutions = v
	return s
}

// SetTitleOverride sets the TitleOverride field's value.
func (s *EndpointSendConfiguration) SetTitleOverride(v string) *EndpointSendConfiguration {
	s.TitleOverride = &v
	return s
}

// Specifies data for one or more attributes that describe the user who's associated
// with an endpoint.
type EndpointUser struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes that describe the user by associating a name
	// with an array of values. For example, the value of an attribute named Interests
	// might be: ["science", "music", "travel"]. You can use these attributes as
	// filter criteria when you create segments.
	//
	// When you define the name of a custom attribute, avoid using the following
	// characters: number sign (#), colon (:), question mark (?), backslash (\),
	// and slash (/). The Amazon Pinpoint console can't display attribute names
	// that contain these characters. This limitation doesn't apply to attribute
	// values.
	UserAttributes map[string][]*string `type:"map"`

	// The unique identifier for the user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s EndpointUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointUser) GoString() string {
	return s.String()
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *EndpointUser) SetUserAttributes(v map[string][]*string) *EndpointUser {
	s.UserAttributes = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *EndpointUser) SetUserId(v string) *EndpointUser {
	s.UserId = &v
	return s
}

// Provides information about all the endpoints that are associated with a user
// ID.
type EndpointsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each endpoint that's associated with the user
	// ID.
	//
	// Item is a required field
	Item []*EndpointResponse `type:"list" required:"true"`
}

// String returns the string representation
func (s EndpointsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *EndpointsResponse) SetItem(v []*EndpointResponse) *EndpointsResponse {
	s.Item = v
	return s
}

// Specifies information about an event that reports data to Amazon Pinpoint.
type Event struct {
	_ struct{} `type:"structure"`

	// The package name of the app that's recording the event.
	AppPackageName *string `type:"string"`

	// The title of the app that's recording the event.
	AppTitle *string `type:"string"`

	// The version number of the app that's recording the event.
	AppVersionCode *string `type:"string"`

	// One or more custom attributes that are associated with the event.
	Attributes map[string]*string `type:"map"`

	// The version of the SDK that's running on the client device.
	ClientSdkVersion *string `type:"string"`

	// The name of the event.
	//
	// EventType is a required field
	EventType *string `type:"string" required:"true"`

	// One or more custom metrics that are associated with the event.
	Metrics map[string]*float64 `type:"map"`

	// The name of the SDK that's being used to record the event.
	SdkName *string `type:"string"`

	// Information about the session in which the event occurred.
	Session *Session `type:"structure"`

	// The date and time, in ISO 8601 format, when the event occurred.
	//
	// Timestamp is a required field
	Timestamp *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Event) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Event"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.Timestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("Timestamp"))
	}
	if s.Session != nil {
		if err := s.Session.Validate(); err != nil {
			invalidParams.AddNested("Session", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppPackageName sets the AppPackageName field's value.
func (s *Event) SetAppPackageName(v string) *Event {
	s.AppPackageName = &v
	return s
}

// SetAppTitle sets the AppTitle field's value.
func (s *Event) SetAppTitle(v string) *Event {
	s.AppTitle = &v
	return s
}

// SetAppVersionCode sets the AppVersionCode field's value.
func (s *Event) SetAppVersionCode(v string) *Event {
	s.AppVersionCode = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Event) SetAttributes(v map[string]*string) *Event {
	s.Attributes = v
	return s
}

// SetClientSdkVersion sets the ClientSdkVersion field's value.
func (s *Event) SetClientSdkVersion(v string) *Event {
	s.ClientSdkVersion = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *Event) SetEventType(v string) *Event {
	s.EventType = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Event) SetMetrics(v map[string]*float64) *Event {
	s.Metrics = v
	return s
}

// SetSdkName sets the SdkName field's value.
func (s *Event) SetSdkName(v string) *Event {
	s.SdkName = &v
	return s
}

// SetSession sets the Session field's value.
func (s *Event) SetSession(v *Session) *Event {
	s.Session = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Event) SetTimestamp(v string) *Event {
	s.Timestamp = &v
	return s
}

// Specifies the dimensions for an event filter that determines when a campaign
// is sent.
type EventDimensions struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes that your app reports to Amazon Pinpoint. You
	// can use these attributes as selection criteria when you create an event filter.
	Attributes map[string]*AttributeDimension `type:"map"`

	// The name of the event that causes the campaign to be sent. This can be a
	// standard type of event that Amazon Pinpoint generates, such as _session.start,
	// or a custom event that's specific to your app.
	EventType *SetDimension `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint. You
	// can use these metrics as selection criteria when you create an event filter.
	Metrics map[string]*MetricDimension `type:"map"`
}

// String returns the string representation
func (s EventDimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDimensions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDimensions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventDimensions"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EventType != nil {
		if err := s.EventType.Validate(); err != nil {
			invalidParams.AddNested("EventType", err.(request.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *EventDimensions) SetAttributes(v map[string]*AttributeDimension) *EventDimensions {
	s.Attributes = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *EventDimensions) SetEventType(v *SetDimension) *EventDimensions {
	s.EventType = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EventDimensions) SetMetrics(v map[string]*MetricDimension) *EventDimensions {
	s.Metrics = v
	return s
}

// Provides the status code and message that result from processing an event.
type EventItemResponse struct {
	_ struct{} `type:"structure"`

	// A custom message that's returned in the response as a result of processing
	// the event.
	Message *string `type:"string"`

	// The status code that's returned in the response as a result of processing
	// the event. Possible values are: 202, for events that were accepted; and,
	// 400, for events that weren't valid.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s EventItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventItemResponse) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *EventItemResponse) SetMessage(v string) *EventItemResponse {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EventItemResponse) SetStatusCode(v int64) *EventItemResponse {
	s.StatusCode = &v
	return s
}

// Specifies settings for publishing event data to an Amazon Kinesis data stream
// or an Amazon Kinesis Data Firehose delivery stream.
type EventStream struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application to publish event data for.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon
	// Kinesis Data Firehose delivery stream to publish event data to.
	//
	// For a Kinesis data stream, the ARN format is: arn:aws:kinesis:region:account-id:stream/stream_name
	//
	// For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:region:account-id:deliverystream/stream_name
	//
	// DestinationStreamArn is a required field
	DestinationStreamArn *string `type:"string" required:"true"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when publishing event data, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The date, in ISO 8601 format, when the event stream was last modified.
	LastModifiedDate *string `type:"string"`

	// The IAM user who last modified the event stream.
	LastUpdatedBy *string `type:"string"`

	// The AWS Identity and Access Management (IAM) role that authorizes Amazon
	// Pinpoint to publish event data to the stream in your AWS account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EventStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventStream) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EventStream) SetApplicationId(v string) *EventStream {
	s.ApplicationId = &v
	return s
}

// SetDestinationStreamArn sets the DestinationStreamArn field's value.
func (s *EventStream) SetDestinationStreamArn(v string) *EventStream {
	s.DestinationStreamArn = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *EventStream) SetExternalId(v string) *EventStream {
	s.ExternalId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EventStream) SetLastModifiedDate(v string) *EventStream {
	s.LastModifiedDate = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *EventStream) SetLastUpdatedBy(v string) *EventStream {
	s.LastUpdatedBy = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EventStream) SetRoleArn(v string) *EventStream {
	s.RoleArn = &v
	return s
}

// Specifies a batch of endpoints and events to process.
type EventsBatch struct {
	_ struct{} `type:"structure"`

	// A set of properties and attributes that are associated with the endpoint.
	//
	// Endpoint is a required field
	Endpoint *PublicEndpoint `type:"structure" required:"true"`

	// A set of properties that are associated with the event.
	//
	// Events is a required field
	Events map[string]*Event `type:"map" required:"true"`
}

// String returns the string representation
func (s EventsBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsBatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsBatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventsBatch"}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *EventsBatch) SetEndpoint(v *PublicEndpoint) *EventsBatch {
	s.Endpoint = v
	return s
}

// SetEvents sets the Events field's value.
func (s *EventsBatch) SetEvents(v map[string]*Event) *EventsBatch {
	s.Events = v
	return s
}

// Specifies a batch of events to process.
type EventsRequest struct {
	_ struct{} `type:"structure"`

	// The batch of events to process. For each item in a batch, the endpoint ID
	// acts as a key that has an EventsBatch object as its value.
	//
	// BatchItem is a required field
	BatchItem map[string]*EventsBatch `type:"map" required:"true"`
}

// String returns the string representation
func (s EventsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventsRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventsRequest"}
	if s.BatchItem == nil {
		invalidParams.Add(request.NewErrParamRequired("BatchItem"))
	}
	if s.BatchItem != nil {
		for i, v := range s.BatchItem {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BatchItem", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchItem sets the BatchItem field's value.
func (s *EventsRequest) SetBatchItem(v map[string]*EventsBatch) *EventsRequest {
	s.BatchItem = v
	return s
}

// Provides information about endpoints and the events that they're associated
// with.
type EventsResponse struct {
	_ struct{} `type:"structure"`

	// A map that contains a multipart response for each endpoint. For each item
	// in this object, the endpoint ID is the key and the item response is the value.
	// If no item response exists, the value can also be one of the following: 202,
	// the request was processed successfully; or 400, the payload wasn't valid
	// or required fields were missing.
	Results map[string]*ItemResponse `type:"map"`
}

// String returns the string representation
func (s EventsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsResponse) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *EventsResponse) SetResults(v map[string]*ItemResponse) *EventsResponse {
	s.Results = v
	return s
}

// Specifies the settings for a job that exports endpoint definitions to an
// Amazon Simple Storage Service (Amazon S3) bucket.
type ExportJobRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// where you want to export endpoint definitions to.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket
	// where you want to export endpoint definitions to. This location is typically
	// a folder that contains multiple files. The URL should be in the following
	// format: s3://bucket-name/folder-name/.
	//
	// S3UrlPrefix is a required field
	S3UrlPrefix *string `type:"string" required:"true"`

	// The identifier for the segment to export endpoint definitions from. If you
	// don't specify this value, Amazon Pinpoint exports definitions for all the
	// endpoints that are associated with the application.
	SegmentId *string `type:"string"`

	// The version of the segment to export endpoint definitions from, if specified.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportJobRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportJobRequest"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.S3UrlPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3UrlPrefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJobRequest) SetRoleArn(v string) *ExportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3UrlPrefix sets the S3UrlPrefix field's value.
func (s *ExportJobRequest) SetS3UrlPrefix(v string) *ExportJobRequest {
	s.S3UrlPrefix = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ExportJobRequest) SetSegmentId(v string) *ExportJobRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *ExportJobRequest) SetSegmentVersion(v int64) *ExportJobRequest {
	s.SegmentVersion = &v
	return s
}

// Provides information about the resource settings for a job that exports endpoint
// definitions to a file. The file can be added directly to an Amazon Simple
// Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded
// directly to a computer by using the Amazon Pinpoint console.
type ExportJobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location
	// where the endpoint definitions were exported to.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket
	// where the endpoint definitions were exported to. This location is typically
	// a folder that contains multiple files. The URL should be in the following
	// format: s3://bucket-name/folder-name/.
	//
	// S3UrlPrefix is a required field
	S3UrlPrefix *string `type:"string" required:"true"`

	// The identifier for the segment that the endpoint definitions were exported
	// from. If this value isn't present, Amazon Pinpoint exported definitions for
	// all the endpoints that are associated with the application.
	SegmentId *string `type:"string"`

	// The version of the segment that the endpoint definitions were exported from.
	SegmentVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s ExportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobResource) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJobResource) SetRoleArn(v string) *ExportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3UrlPrefix sets the S3UrlPrefix field's value.
func (s *ExportJobResource) SetS3UrlPrefix(v string) *ExportJobResource {
	s.S3UrlPrefix = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ExportJobResource) SetSegmentId(v string) *ExportJobResource {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *ExportJobResource) SetSegmentVersion(v int64) *ExportJobResource {
	s.SegmentVersion = &v
	return s
}

// Provides information about the status and settings of a job that exports
// endpoint definitions to a file. The file can be added directly to an Amazon
// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
// or downloaded directly to a computer by using the Amazon Pinpoint console.
type ExportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that's associated with the export
	// job.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The number of pieces that were processed successfully (completed) by the
	// export job, as of the time of the request.
	CompletedPieces *int64 `type:"integer"`

	// The date, in ISO 8601 format, when the export job was completed.
	CompletionDate *string `type:"string"`

	// The date, in ISO 8601 format, when the export job was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The resource settings that apply to the export job.
	//
	// Definition is a required field
	Definition *ExportJobResource `type:"structure" required:"true"`

	// The number of pieces that weren't processed successfully (failed) by the
	// export job, as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// An array of entries, one for each of the first 100 entries that weren't processed
	// successfully (failed) by the export job, if any.
	Failures []*string `type:"list"`

	// The unique identifier for the export job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of the export job. The job status is FAILED if Amazon Pinpoint
	// wasn't able to process one or more pieces in the job.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// The total number of endpoint definitions that weren't processed successfully
	// (failed) by the export job, typically because an error, such as a syntax
	// error, occurred.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to complete the export
	// job. Each piece consists of an approximately equal portion of the endpoint
	// definitions that are part of the export job.
	TotalPieces *int64 `type:"integer"`

	// The total number of endpoint definitions that were processed by the export
	// job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. This value is EXPORT for export jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ExportJobResponse) SetApplicationId(v string) *ExportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ExportJobResponse) SetCompletedPieces(v int64) *ExportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ExportJobResponse) SetCompletionDate(v string) *ExportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ExportJobResponse) SetCreationDate(v string) *ExportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ExportJobResponse) SetDefinition(v *ExportJobResource) *ExportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ExportJobResponse) SetFailedPieces(v int64) *ExportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ExportJobResponse) SetFailures(v []*string) *ExportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ExportJobResponse) SetId(v string) *ExportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ExportJobResponse) SetJobStatus(v string) *ExportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ExportJobResponse) SetTotalFailures(v int64) *ExportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ExportJobResponse) SetTotalPieces(v int64) *ExportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ExportJobResponse) SetTotalProcessed(v int64) *ExportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportJobResponse) SetType(v string) *ExportJobResponse {
	s.Type = &v
	return s
}

// Provides information about all the export jobs that are associated with an
// application or segment. An export job is a job that exports endpoint definitions
// to a file.
type ExportJobsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each export job that's associated with the
	// application (Export Jobs resource) or segment (Segment Export Jobs resource).
	//
	// Item is a required field
	Item []*ExportJobResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ExportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ExportJobsResponse) SetItem(v []*ExportJobResponse) *ExportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportJobsResponse) SetNextToken(v string) *ExportJobsResponse {
	s.NextToken = &v
	return s
}

// Specifies the status and settings of the GCM channel for an application.
// This channel enables Amazon Pinpoint to send push notifications through the
// Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
type GCMChannelRequest struct {
	_ struct{} `type:"structure"`

	// The API key, also referred to as a server key, that you received from Google
	// to communicate with Google services.
	//
	// ApiKey is a required field
	ApiKey *string `type:"string" required:"true"`

	// Specifies whether to enable the GCM channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GCMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GCMChannelRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GCMChannelRequest"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *GCMChannelRequest) SetApiKey(v string) *GCMChannelRequest {
	s.ApiKey = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GCMChannelRequest) SetEnabled(v bool) *GCMChannelRequest {
	s.Enabled = &v
	return s
}

// Provides information about the status and settings of the GCM channel for
// an application. The GCM channel enables Amazon Pinpoint to send push notifications
// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
// (GCM), service.
type GCMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the GCM channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time when the GCM channel was enabled.
	CreationDate *string `type:"string"`

	// The API key, also referred to as a server key, that you received from Google
	// to communicate with Google services.
	//
	// Credential is a required field
	Credential *string `type:"string" required:"true"`

	// Specifies whether the GCM channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the GCM channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the GCM channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the GCM channel.
	LastModifiedBy *string `type:"string"`

	// The date and time when the GCM channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the GCM
	// channel, this value is GCM.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the GCM channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s GCMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GCMChannelResponse) SetApplicationId(v string) *GCMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GCMChannelResponse) SetCreationDate(v string) *GCMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *GCMChannelResponse) SetCredential(v string) *GCMChannelResponse {
	s.Credential = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GCMChannelResponse) SetEnabled(v bool) *GCMChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *GCMChannelResponse) SetHasCredential(v bool) *GCMChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *GCMChannelResponse) SetId(v string) *GCMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *GCMChannelResponse) SetIsArchived(v bool) *GCMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *GCMChannelResponse) SetLastModifiedBy(v string) *GCMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GCMChannelResponse) SetLastModifiedDate(v string) *GCMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *GCMChannelResponse) SetPlatform(v string) *GCMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GCMChannelResponse) SetVersion(v int64) *GCMChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time message that's sent directly to an
// endpoint through the GCM channel. The GCM channel enables Amazon Pinpoint
// to send messages to the Firebase Cloud Messaging (FCM), formerly Google Cloud
// Messaging (GCM), service.
type GCMMessage struct {
	_ struct{} `type:"structure"`

	// The action to occur if the recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This action uses the deep-linking features of the Android
	//    platform.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message.
	Body *string `type:"string"`

	// An arbitrary string that identifies a group of messages that can be collapsed
	// to ensure that only the last message is sent when delivery can resume. This
	// helps avoid sending too many instances of the same messages when the recipient's
	// device comes online again or becomes active.
	//
	// Amazon Pinpoint specifies this value in the Firebase Cloud Messaging (FCM)
	// collapse_key parameter when it sends the notification message to FCM.
	CollapseKey *string `type:"string"`

	// The JSON data payload to use for the push notification, if the notification
	// is a silent push notification. This payload is added to the data.pinpoint.jsonBody
	// object of the notification.
	Data map[string]*string `type:"map"`

	// The icon image name of the asset saved in your app.
	IconReference *string `type:"string"`

	// The URL of the large icon image to display in the content view of the push
	// notification.
	ImageIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// para>normal - The notification might be delayed. Delivery is optimized for
	// battery usage on the recipient's device. Use this value unless immediate
	// delivery is required.
	// /listitem>
	// high - The notification is sent immediately and might wake a sleeping device.
	// /para>
	// Amazon Pinpoint specifies this value in the FCM priority parameter when it
	// sends the notification message to FCM.
	//
	// The equivalent values for Apple Push Notification service (APNs) are 5, for
	// normal, and 10, for high. If you specify an APNs value for this property,
	// Amazon Pinpoint accepts and converts the value to the corresponding FCM value.
	Priority *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. This value overrides the message.
	RawContent *string `type:"string"`

	// The package name of the application where registration tokens must match
	// in order for the recipient to receive the message.
	RestrictedPackageName *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration
	// or supporting phone home functionality.
	SilentPush *bool `type:"boolean"`

	// The URL of the small icon image to display in the status bar and the content
	// view of the push notification.
	SmallImageIconUrl *string `type:"string"`

	// The sound to play when the recipient receives the push notification. You
	// can use the default stream or specify the file name of a sound resource that's
	// bundled in your app. On an Android platform, the sound file must reside in
	// /res/raw/.
	Sound *string `type:"string"`

	// The default message variables to use in the notification message. You can
	// override the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The amount of time, in seconds, that FCM should store and attempt to deliver
	// the push notification, if the service is unable to deliver the notification
	// the first time. If you don't specify this value, FCM defaults to the maximum
	// value, which is 2,419,200 seconds (28 days).
	//
	// Amazon Pinpoint specifies this value in the FCM time_to_live parameter when
	// it sends the notification message to FCM.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on the recipient's device.
	Title *string `type:"string"`

	// The URL to open in the recipient's default mobile browser, if a recipient
	// taps the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s GCMMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GCMMessage) SetAction(v string) *GCMMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GCMMessage) SetBody(v string) *GCMMessage {
	s.Body = &v
	return s
}

// SetCollapseKey sets the CollapseKey field's value.
func (s *GCMMessage) SetCollapseKey(v string) *GCMMessage {
	s.CollapseKey = &v
	return s
}

// SetData sets the Data field's value.
func (s *GCMMessage) SetData(v map[string]*string) *GCMMessage {
	s.Data = v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *GCMMessage) SetIconReference(v string) *GCMMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *GCMMessage) SetImageIconUrl(v string) *GCMMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *GCMMessage) SetImageUrl(v string) *GCMMessage {
	s.ImageUrl = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GCMMessage) SetPriority(v string) *GCMMessage {
	s.Priority = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *GCMMessage) SetRawContent(v string) *GCMMessage {
	s.RawContent = &v
	return s
}

// SetRestrictedPackageName sets the RestrictedPackageName field's value.
func (s *GCMMessage) SetRestrictedPackageName(v string) *GCMMessage {
	s.RestrictedPackageName = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *GCMMessage) SetSilentPush(v bool) *GCMMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *GCMMessage) SetSmallImageIconUrl(v string) *GCMMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *GCMMessage) SetSound(v string) *GCMMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *GCMMessage) SetSubstitutions(v map[string][]*string) *GCMMessage {
	s.Substitutions = v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *GCMMessage) SetTimeToLive(v int64) *GCMMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GCMMessage) SetTitle(v string) *GCMMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GCMMessage) SetUrl(v string) *GCMMessage {
	s.Url = &v
	return s
}

// Specifies the GPS coordinates of a location.
type GPSCoordinates struct {
	_ struct{} `type:"structure"`

	// The latitude coordinate of the location.
	//
	// Latitude is a required field
	Latitude *float64 `type:"double" required:"true"`

	// The longitude coordinate of the location.
	//
	// Longitude is a required field
	Longitude *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s GPSCoordinates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GPSCoordinates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GPSCoordinates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GPSCoordinates"}
	if s.Latitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Latitude"))
	}
	if s.Longitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Longitude"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatitude sets the Latitude field's value.
func (s *GPSCoordinates) SetLatitude(v float64) *GPSCoordinates {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *GPSCoordinates) SetLongitude(v float64) *GPSCoordinates {
	s.Longitude = &v
	return s
}

// Specifies GPS-based criteria for including or excluding endpoints from a
// segment.
type GPSPointDimension struct {
	_ struct{} `type:"structure"`

	// The GPS coordinates to measure distance from.
	//
	// Coordinates is a required field
	Coordinates *GPSCoordinates `type:"structure" required:"true"`

	// The range, in kilometers, from the GPS coordinates.
	RangeInKilometers *float64 `type:"double"`
}

// String returns the string representation
func (s GPSPointDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GPSPointDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GPSPointDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GPSPointDimension"}
	if s.Coordinates == nil {
		invalidParams.Add(request.NewErrParamRequired("Coordinates"))
	}
	if s.Coordinates != nil {
		if err := s.Coordinates.Validate(); err != nil {
			invalidParams.AddNested("Coordinates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoordinates sets the Coordinates field's value.
func (s *GPSPointDimension) SetCoordinates(v *GPSCoordinates) *GPSPointDimension {
	s.Coordinates = v
	return s
}

// SetRangeInKilometers sets the RangeInKilometers field's value.
func (s *GPSPointDimension) SetRangeInKilometers(v float64) *GPSPointDimension {
	s.RangeInKilometers = &v
	return s
}

type GetAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAdmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetAdmChannelInput) SetApplicationId(v string) *GetAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type GetAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Provides information about the status and settings of the ADM (Amazon Device
	// Messaging) channel for an application.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *GetAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *GetAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type GetApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsChannelInput) SetApplicationId(v string) *GetApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *GetApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *GetApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type GetApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsSandboxChannelInput) SetApplicationId(v string) *GetApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) sandbox channel for an application.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *GetApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *GetApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type GetApnsVoipChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsVoipChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsVoipChannelInput) SetApplicationId(v string) *GetApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP channel for an application.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *GetApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *GetApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type GetApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsVoipSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsVoipSandboxChannelInput) SetApplicationId(v string) *GetApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *GetApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *GetApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type GetAppInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetAppInput) SetApplicationId(v string) *GetAppInput {
	s.ApplicationId = &v
	return s
}

type GetAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Provides information about an application.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *GetAppOutput) SetApplicationResponse(v *ApplicationResponse) *GetAppOutput {
	s.ApplicationResponse = v
	return s
}

type GetApplicationDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetApplicationDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationDateRangeKpiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationDateRangeKpiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationDateRangeKpiInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.KpiName == nil {
		invalidParams.Add(request.NewErrParamRequired("KpiName"))
	}
	if s.KpiName != nil && len(*s.KpiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KpiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationDateRangeKpiInput) SetApplicationId(v string) *GetApplicationDateRangeKpiInput {
	s.ApplicationId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetApplicationDateRangeKpiInput) SetEndTime(v time.Time) *GetApplicationDateRangeKpiInput {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *GetApplicationDateRangeKpiInput) SetKpiName(v string) *GetApplicationDateRangeKpiInput {
	s.KpiName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetApplicationDateRangeKpiInput) SetNextToken(v string) *GetApplicationDateRangeKpiInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetApplicationDateRangeKpiInput) SetPageSize(v string) *GetApplicationDateRangeKpiInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetApplicationDateRangeKpiInput) SetStartTime(v time.Time) *GetApplicationDateRangeKpiInput {
	s.StartTime = &v
	return s
}

type GetApplicationDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard metric
	// that applies to an application, and provides information about that query.
	//
	// ApplicationDateRangeKpiResponse is a required field
	ApplicationDateRangeKpiResponse *ApplicationDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationDateRangeKpiOutput) GoString() string {
	return s.String()
}

// SetApplicationDateRangeKpiResponse sets the ApplicationDateRangeKpiResponse field's value.
func (s *GetApplicationDateRangeKpiOutput) SetApplicationDateRangeKpiResponse(v *ApplicationDateRangeKpiResponse) *GetApplicationDateRangeKpiOutput {
	s.ApplicationDateRangeKpiResponse = v
	return s
}

type GetApplicationSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationSettingsInput) SetApplicationId(v string) *GetApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// Provides information about an application, including the default settings
	// for an application.
	//
	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *GetApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *GetApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

type GetAppsInput struct {
	_ struct{} `type:"structure"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppsInput) GoString() string {
	return s.String()
}

// SetPageSize sets the PageSize field's value.
func (s *GetAppsInput) SetPageSize(v string) *GetAppsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetAppsInput) SetToken(v string) *GetAppsInput {
	s.Token = &v
	return s
}

type GetAppsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationsResponse"`

	// Provides information about all of your applications.
	//
	// ApplicationsResponse is a required field
	ApplicationsResponse *ApplicationsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppsOutput) GoString() string {
	return s.String()
}

// SetApplicationsResponse sets the ApplicationsResponse field's value.
func (s *GetAppsOutput) SetApplicationsResponse(v *ApplicationsResponse) *GetAppsOutput {
	s.ApplicationsResponse = v
	return s
}

type GetBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetBaiduChannelInput) SetApplicationId(v string) *GetBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

type GetBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Provides information about the status and settings of the Baidu (Baidu Cloud
	// Push) channel for an application.
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *GetBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *GetBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type GetCampaignActivitiesInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignActivitiesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignActivitiesInput) SetApplicationId(v string) *GetCampaignActivitiesInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignActivitiesInput) SetCampaignId(v string) *GetCampaignActivitiesInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignActivitiesInput) SetPageSize(v string) *GetCampaignActivitiesInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignActivitiesInput) SetToken(v string) *GetCampaignActivitiesInput {
	s.Token = &v
	return s
}

type GetCampaignActivitiesOutput struct {
	_ struct{} `type:"structure" payload:"ActivitiesResponse"`

	// Provides information about the activities that were performed by a campaign.
	//
	// ActivitiesResponse is a required field
	ActivitiesResponse *ActivitiesResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivitiesResponse sets the ActivitiesResponse field's value.
func (s *GetCampaignActivitiesOutput) SetActivitiesResponse(v *ActivitiesResponse) *GetCampaignActivitiesOutput {
	s.ActivitiesResponse = v
	return s
}

type GetCampaignDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetCampaignDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignDateRangeKpiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignDateRangeKpiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignDateRangeKpiInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}
	if s.KpiName == nil {
		invalidParams.Add(request.NewErrParamRequired("KpiName"))
	}
	if s.KpiName != nil && len(*s.KpiName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KpiName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignDateRangeKpiInput) SetApplicationId(v string) *GetCampaignDateRangeKpiInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignDateRangeKpiInput) SetCampaignId(v string) *GetCampaignDateRangeKpiInput {
	s.CampaignId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetCampaignDateRangeKpiInput) SetEndTime(v time.Time) *GetCampaignDateRangeKpiInput {
	s.EndTime = &v
	return s
}

// SetKpiName sets the KpiName field's value.
func (s *GetCampaignDateRangeKpiInput) SetKpiName(v string) *GetCampaignDateRangeKpiInput {
	s.KpiName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCampaignDateRangeKpiInput) SetNextToken(v string) *GetCampaignDateRangeKpiInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignDateRangeKpiInput) SetPageSize(v string) *GetCampaignDateRangeKpiInput {
	s.PageSize = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetCampaignDateRangeKpiInput) SetStartTime(v time.Time) *GetCampaignDateRangeKpiInput {
	s.StartTime = &v
	return s
}

type GetCampaignDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"CampaignDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard metric
	// that applies to a campaign, and provides information about that query.
	//
	// CampaignDateRangeKpiResponse is a required field
	CampaignDateRangeKpiResponse *CampaignDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignDateRangeKpiOutput) GoString() string {
	return s.String()
}

// SetCampaignDateRangeKpiResponse sets the CampaignDateRangeKpiResponse field's value.
func (s *GetCampaignDateRangeKpiOutput) SetCampaignDateRangeKpiResponse(v *CampaignDateRangeKpiResponse) *GetCampaignDateRangeKpiOutput {
	s.CampaignDateRangeKpiResponse = v
	return s
}

type GetCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignInput) SetApplicationId(v string) *GetCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignInput) SetCampaignId(v string) *GetCampaignInput {
	s.CampaignId = &v
	return s
}

type GetCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignOutput {
	s.CampaignResponse = v
	return s
}

type GetCampaignVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionInput) SetApplicationId(v string) *GetCampaignVersionInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionInput) SetCampaignId(v string) *GetCampaignVersionInput {
	s.CampaignId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetCampaignVersionInput) SetVersion(v string) *GetCampaignVersionInput {
	s.Version = &v
	return s
}

type GetCampaignVersionOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignVersionOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignVersionOutput {
	s.CampaignResponse = v
	return s
}

type GetCampaignVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionsInput) SetApplicationId(v string) *GetCampaignVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionsInput) SetCampaignId(v string) *GetCampaignVersionsInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignVersionsInput) SetPageSize(v string) *GetCampaignVersionsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignVersionsInput) SetToken(v string) *GetCampaignVersionsInput {
	s.Token = &v
	return s
}

type GetCampaignVersionsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// Provides information about the configuration and other settings for all the
	// campaigns that are associated with an application.
	//
	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignVersionsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignVersionsOutput {
	s.CampaignsResponse = v
	return s
}

type GetCampaignsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignsInput) SetApplicationId(v string) *GetCampaignsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignsInput) SetPageSize(v string) *GetCampaignsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignsInput) SetToken(v string) *GetCampaignsInput {
	s.Token = &v
	return s
}

type GetCampaignsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// Provides information about the configuration and other settings for all the
	// campaigns that are associated with an application.
	//
	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignsOutput {
	s.CampaignsResponse = v
	return s
}

type GetChannelsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetChannelsInput) SetApplicationId(v string) *GetChannelsInput {
	s.ApplicationId = &v
	return s
}

type GetChannelsOutput struct {
	_ struct{} `type:"structure" payload:"ChannelsResponse"`

	// Provides information about the general settings and status of all channels
	// for an application, including channels that aren't enabled for the application.
	//
	// ChannelsResponse is a required field
	ChannelsResponse *ChannelsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChannelsOutput) GoString() string {
	return s.String()
}

// SetChannelsResponse sets the ChannelsResponse field's value.
func (s *GetChannelsOutput) SetChannelsResponse(v *ChannelsResponse) *GetChannelsOutput {
	s.ChannelsResponse = v
	return s
}

type GetEmailChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEmailChannelInput) SetApplicationId(v string) *GetEmailChannelInput {
	s.ApplicationId = &v
	return s
}

type GetEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Provides information about the status and settings of the email channel for
	// an application.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *GetEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *GetEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type GetEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEndpointInput) SetApplicationId(v string) *GetEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *GetEndpointInput) SetEndpointId(v string) *GetEndpointInput {
	s.EndpointId = &v
	return s
}

type GetEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// Provides information about the channel type and other settings for an endpoint.
	//
	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *GetEndpointOutput) SetEndpointResponse(v *EndpointResponse) *GetEndpointOutput {
	s.EndpointResponse = v
	return s
}

type GetEventStreamInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEventStreamInput) SetApplicationId(v string) *GetEventStreamInput {
	s.ApplicationId = &v
	return s
}

type GetEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Specifies settings for publishing event data to an Amazon Kinesis data stream
	// or an Amazon Kinesis Data Firehose delivery stream.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *GetEventStreamOutput) SetEventStream(v *EventStream) *GetEventStreamOutput {
	s.EventStream = v
	return s
}

type GetExportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetExportJobInput) SetApplicationId(v string) *GetExportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetExportJobInput) SetJobId(v string) *GetExportJobInput {
	s.JobId = &v
	return s
}

type GetExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// Provides information about the status and settings of a job that exports
	// endpoint definitions to a file. The file can be added directly to an Amazon
	// Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API
	// or downloaded directly to a computer by using the Amazon Pinpoint console.
	//
	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobResponse sets the ExportJobResponse field's value.
func (s *GetExportJobOutput) SetExportJobResponse(v *ExportJobResponse) *GetExportJobOutput {
	s.ExportJobResponse = v
	return s
}

type GetExportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetExportJobsInput) SetApplicationId(v string) *GetExportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetExportJobsInput) SetPageSize(v string) *GetExportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetExportJobsInput) SetToken(v string) *GetExportJobsInput {
	s.Token = &v
	return s
}

type GetExportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobsResponse"`

	// Provides information about all the export jobs that are associated with an
	// application or segment. An export job is a job that exports endpoint definitions
	// to a file.
	//
	// ExportJobsResponse is a required field
	ExportJobsResponse *ExportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobsResponse sets the ExportJobsResponse field's value.
func (s *GetExportJobsOutput) SetExportJobsResponse(v *ExportJobsResponse) *GetExportJobsOutput {
	s.ExportJobsResponse = v
	return s
}

type GetGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetGcmChannelInput) SetApplicationId(v string) *GetGcmChannelInput {
	s.ApplicationId = &v
	return s
}

type GetGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Provides information about the status and settings of the GCM channel for
	// an application. The GCM channel enables Amazon Pinpoint to send push notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service.
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *GetGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *GetGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type GetImportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobInput) SetApplicationId(v string) *GetImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetImportJobInput) SetJobId(v string) *GetImportJobInput {
	s.JobId = &v
	return s
}

type GetImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// Provides information about the status and settings of a job that imports
	// endpoint definitions from one or more files. The files can be stored in an
	// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
	// a computer by using the Amazon Pinpoint console.
	//
	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *GetImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *GetImportJobOutput {
	s.ImportJobResponse = v
	return s
}

type GetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobsInput) SetApplicationId(v string) *GetImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetImportJobsInput) SetPageSize(v string) *GetImportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetImportJobsInput) SetToken(v string) *GetImportJobsInput {
	s.Token = &v
	return s
}

type GetImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Provides information about the status and settings of all the import jobs
	// that are associated with an application or segment. An import job is a job
	// that imports endpoint definitions from one or more files.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

type GetSegmentExportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentExportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentExportJobsInput) SetApplicationId(v string) *GetSegmentExportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentExportJobsInput) SetPageSize(v string) *GetSegmentExportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentExportJobsInput) SetSegmentId(v string) *GetSegmentExportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentExportJobsInput) SetToken(v string) *GetSegmentExportJobsInput {
	s.Token = &v
	return s
}

type GetSegmentExportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobsResponse"`

	// Provides information about all the export jobs that are associated with an
	// application or segment. An export job is a job that exports endpoint definitions
	// to a file.
	//
	// ExportJobsResponse is a required field
	ExportJobsResponse *ExportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobsResponse sets the ExportJobsResponse field's value.
func (s *GetSegmentExportJobsOutput) SetExportJobsResponse(v *ExportJobsResponse) *GetSegmentExportJobsOutput {
	s.ExportJobsResponse = v
	return s
}

type GetSegmentImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentImportJobsInput) SetApplicationId(v string) *GetSegmentImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentImportJobsInput) SetPageSize(v string) *GetSegmentImportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentImportJobsInput) SetSegmentId(v string) *GetSegmentImportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentImportJobsInput) SetToken(v string) *GetSegmentImportJobsInput {
	s.Token = &v
	return s
}

type GetSegmentImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Provides information about the status and settings of all the import jobs
	// that are associated with an application or segment. An import job is a job
	// that imports endpoint definitions from one or more files.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetSegmentImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetSegmentImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

type GetSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentInput) SetApplicationId(v string) *GetSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentInput) SetSegmentId(v string) *GetSegmentInput {
	s.SegmentId = &v
	return s
}

type GetSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentOutput {
	s.SegmentResponse = v
	return s
}

type GetSegmentVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionInput) SetApplicationId(v string) *GetSegmentVersionInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionInput) SetSegmentId(v string) *GetSegmentVersionInput {
	s.SegmentId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSegmentVersionInput) SetVersion(v string) *GetSegmentVersionInput {
	s.Version = &v
	return s
}

type GetSegmentVersionOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentVersionOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentVersionOutput {
	s.SegmentResponse = v
	return s
}

type GetSegmentVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionsInput) SetApplicationId(v string) *GetSegmentVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentVersionsInput) SetPageSize(v string) *GetSegmentVersionsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionsInput) SetSegmentId(v string) *GetSegmentVersionsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentVersionsInput) SetToken(v string) *GetSegmentVersionsInput {
	s.Token = &v
	return s
}

type GetSegmentVersionsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// Provides information about all the segments that are associated with an application.
	//
	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentVersionsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentVersionsOutput {
	s.SegmentsResponse = v
	return s
}

type GetSegmentsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentsInput) SetApplicationId(v string) *GetSegmentsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentsInput) SetPageSize(v string) *GetSegmentsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentsInput) SetToken(v string) *GetSegmentsInput {
	s.Token = &v
	return s
}

type GetSegmentsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// Provides information about all the segments that are associated with an application.
	//
	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentsOutput {
	s.SegmentsResponse = v
	return s
}

type GetSmsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSmsChannelInput) SetApplicationId(v string) *GetSmsChannelInput {
	s.ApplicationId = &v
	return s
}

type GetSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// Provides information about the status and settings of the SMS channel for
	// an application.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *GetSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *GetSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

type GetUserEndpointsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// UserId is a required field
	UserId *string `location:"uri" locationName:"user-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserEndpointsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetUserEndpointsInput) SetApplicationId(v string) *GetUserEndpointsInput {
	s.ApplicationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserEndpointsInput) SetUserId(v string) *GetUserEndpointsInput {
	s.UserId = &v
	return s
}

type GetUserEndpointsOutput struct {
	_ struct{} `type:"structure" payload:"EndpointsResponse"`

	// Provides information about all the endpoints that are associated with a user
	// ID.
	//
	// EndpointsResponse is a required field
	EndpointsResponse *EndpointsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUserEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointsResponse sets the EndpointsResponse field's value.
func (s *GetUserEndpointsOutput) SetEndpointsResponse(v *EndpointsResponse) *GetUserEndpointsOutput {
	s.EndpointsResponse = v
	return s
}

type GetVoiceChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetVoiceChannelInput) SetApplicationId(v string) *GetVoiceChannelInput {
	s.ApplicationId = &v
	return s
}

type GetVoiceChannelOutput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelResponse"`

	// Provides information about the status and settings of the voice channel for
	// an application.
	//
	// VoiceChannelResponse is a required field
	VoiceChannelResponse *VoiceChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetVoiceChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceChannelOutput) GoString() string {
	return s.String()
}

// SetVoiceChannelResponse sets the VoiceChannelResponse field's value.
func (s *GetVoiceChannelOutput) SetVoiceChannelResponse(v *VoiceChannelResponse) *GetVoiceChannelOutput {
	s.VoiceChannelResponse = v
	return s
}

// Specifies the settings for a job that imports endpoint definitions from an
// Amazon Simple Storage Service (Amazon S3) bucket.
type ImportJobRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to create a segment that contains the endpoints, when the
	// endpoint definitions are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions to import.
	// Valid values are: CSV, for comma-separated values format; and, JSON, for
	// newline-delimited JSON format. If the Amazon S3 location stores multiple
	// files that use different formats, Amazon Pinpoint imports data only from
	// the files that use the specified format.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// Specifies whether to register the endpoints with Amazon Pinpoint, when the
	// endpoint definitions are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains
	// the endpoint definitions to import. This location can be a folder or a single
	// file. If the location is a folder, Amazon Pinpoint imports endpoint definitions
	// from the files in this location, including any subfolders that the folder
	// contains.
	//
	// The URL should be in the following format: s3://bucket-name/folder-name/file-name.
	// The location can end with the key for an individual object or a prefix that
	// qualifies multiple objects.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The identifier for the segment to update or add the imported endpoint definitions
	// to, if the import job is meant to update an existing segment.
	SegmentId *string `type:"string"`

	// The custom name for the segment that's created by the import job, if the
	// value of the DefineSegment property is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportJobRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportJobRequest"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.S3Url == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobRequest) SetDefineSegment(v bool) *ImportJobRequest {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobRequest) SetExternalId(v string) *ImportJobRequest {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobRequest) SetFormat(v string) *ImportJobRequest {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobRequest) SetRegisterEndpoints(v bool) *ImportJobRequest {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobRequest) SetRoleArn(v string) *ImportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobRequest) SetS3Url(v string) *ImportJobRequest {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobRequest) SetSegmentId(v string) *ImportJobRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobRequest) SetSegmentName(v string) *ImportJobRequest {
	s.SegmentName = &v
	return s
}

// Provides information about the resource settings for a job that imports endpoint
// definitions from one or more files. The files can be stored in an Amazon
// Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer
// by using the Amazon Pinpoint console.
type ImportJobResource struct {
	_ struct{} `type:"structure"`

	// Specifies whether the import job creates a segment that contains the endpoints,
	// when the endpoint definitions are imported.
	DefineSegment *bool `type:"boolean"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions to import.
	// Valid values are: CSV, for comma-separated values format; and, JSON, for
	// newline-delimited JSON format.
	//
	// If the files are stored in an Amazon S3 location and that location contains
	// multiple files that use different formats, Amazon Pinpoint imports data only
	// from the files that use the specified format.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// Specifies whether the import job registers the endpoints with Amazon Pinpoint,
	// when the endpoint definitions are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains
	// the endpoint definitions to import. This location can be a folder or a single
	// file. If the location is a folder, Amazon Pinpoint imports endpoint definitions
	// from the files in this location, including any subfolders that the folder
	// contains.
	//
	// The URL should be in the following format: s3://bucket-name/folder-name/file-name.
	// The location can end with the key for an individual object or a prefix that
	// qualifies multiple objects.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The identifier for the segment that the import job updates or adds endpoint
	// definitions to, if the import job updates an existing segment.
	SegmentId *string `type:"string"`

	// The custom name for the segment that's created by the import job, if the
	// value of the DefineSegment property is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResource) GoString() string {
	return s.String()
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobResource) SetDefineSegment(v bool) *ImportJobResource {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobResource) SetExternalId(v string) *ImportJobResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobResource) SetFormat(v string) *ImportJobResource {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobResource) SetRegisterEndpoints(v bool) *ImportJobResource {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobResource) SetRoleArn(v string) *ImportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobResource) SetS3Url(v string) *ImportJobResource {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobResource) SetSegmentId(v string) *ImportJobResource {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobResource) SetSegmentName(v string) *ImportJobResource {
	s.SegmentName = &v
	return s
}

// Provides information about the status and settings of a job that imports
// endpoint definitions from one or more files. The files can be stored in an
// Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from
// a computer by using the Amazon Pinpoint console.
type ImportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that's associated with the import
	// job.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The number of pieces that were processed successfully (completed) by the
	// import job, as of the time of the request.
	CompletedPieces *int64 `type:"integer"`

	// The date, in ISO 8601 format, when the import job was completed.
	CompletionDate *string `type:"string"`

	// The date, in ISO 8601 format, when the import job was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The resource settings that apply to the import job.
	//
	// Definition is a required field
	Definition *ImportJobResource `type:"structure" required:"true"`

	// The number of pieces that weren't processed successfully (failed) by the
	// import job, as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	// An array of entries, one for each of the first 100 entries that weren't processed
	// successfully (failed) by the import job, if any.
	Failures []*string `type:"list"`

	// The unique identifier for the import job.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of the import job. The job status is FAILED if Amazon Pinpoint
	// wasn't able to process one or more pieces in the job.
	//
	// JobStatus is a required field
	JobStatus *string `type:"string" required:"true" enum:"JobStatus"`

	// The total number of endpoint definitions that weren't processed successfully
	// (failed) by the import job, typically because an error, such as a syntax
	// error, occurred.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to complete the import
	// job. Each piece consists of an approximately equal portion of the endpoint
	// definitions that are part of the import job.
	TotalPieces *int64 `type:"integer"`

	// The total number of endpoint definitions that were processed by the import
	// job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. This value is IMPORT for import jobs.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ImportJobResponse) SetApplicationId(v string) *ImportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ImportJobResponse) SetCompletedPieces(v int64) *ImportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ImportJobResponse) SetCompletionDate(v string) *ImportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ImportJobResponse) SetCreationDate(v string) *ImportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ImportJobResponse) SetDefinition(v *ImportJobResource) *ImportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ImportJobResponse) SetFailedPieces(v int64) *ImportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ImportJobResponse) SetFailures(v []*string) *ImportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ImportJobResponse) SetId(v string) *ImportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobResponse) SetJobStatus(v string) *ImportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ImportJobResponse) SetTotalFailures(v int64) *ImportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ImportJobResponse) SetTotalPieces(v int64) *ImportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ImportJobResponse) SetTotalProcessed(v int64) *ImportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ImportJobResponse) SetType(v string) *ImportJobResponse {
	s.Type = &v
	return s
}

// Provides information about the status and settings of all the import jobs
// that are associated with an application or segment. An import job is a job
// that imports endpoint definitions from one or more files.
type ImportJobsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each import job that's associated with the
	// application (Import Jobs resource) or segment (Segment Import Jobs resource).
	//
	// Item is a required field
	Item []*ImportJobResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ImportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ImportJobsResponse) SetItem(v []*ImportJobResponse) *ImportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ImportJobsResponse) SetNextToken(v string) *ImportJobsResponse {
	s.NextToken = &v
	return s
}

// Provides information about the results of a request to create or update an
// endpoint that's associated with an event.
type ItemResponse struct {
	_ struct{} `type:"structure"`

	// The response that was received after the endpoint data was accepted.
	EndpointItemResponse *EndpointItemResponse `type:"structure"`

	// A multipart response object that contains a key and a value for each event
	// in the request. In each object, the event ID is the key and an EventItemResponse
	// object is the value.
	EventsItemResponse map[string]*EventItemResponse `type:"map"`
}

// String returns the string representation
func (s ItemResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemResponse) GoString() string {
	return s.String()
}

// SetEndpointItemResponse sets the EndpointItemResponse field's value.
func (s *ItemResponse) SetEndpointItemResponse(v *EndpointItemResponse) *ItemResponse {
	s.EndpointItemResponse = v
	return s
}

// SetEventsItemResponse sets the EventsItemResponse field's value.
func (s *ItemResponse) SetEventsItemResponse(v map[string]*EventItemResponse) *ItemResponse {
	s.EventsItemResponse = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure" payload:"TagsModel"`

	// Specifies the tags (keys and values) for an application, campaign, or segment.
	//
	// TagsModel is a required field
	TagsModel *TagsModel `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagsModel sets the TagsModel field's value.
func (s *ListTagsForResourceOutput) SetTagsModel(v *TagsModel) *ListTagsForResourceOutput {
	s.TagsModel = v
	return s
}

// Specifies the content and settings for a push notification that's sent to
// recipients of a campaign.
type Message struct {
	_ struct{} `type:"structure"`

	// The action to occur if a recipient taps the push notification. Valid values
	// are:
	//
	//    * OPEN_APP - Your app opens or it becomes the foreground app if it was
	//    sent to the background. This is the default action.
	//
	//    * DEEP_LINK - Your app opens and displays a designated user interface
	//    in the app. This setting uses the deep-linking features of iOS and Android.
	//
	//    * URL - The default mobile browser on the recipient's device opens and
	//    loads the web page at a URL that you specify.
	Action *string `type:"string" enum:"Action"`

	// The body of the notification message. The maximum number of characters is
	// 200.
	Body *string `type:"string"`

	// The URL of the image to display as the push-notification icon, such as the
	// icon for the app.
	ImageIconUrl *string `type:"string"`

	// The URL of the image to display as the small, push-notification icon, such
	// as a small version of the icon for the app.
	ImageSmallIconUrl *string `type:"string"`

	// The URL of an image to display in the push notification.
	ImageUrl *string `type:"string"`

	// The JSON payload to use for a silent push notification.
	JsonBody *string `type:"string"`

	// The URL of the image or video to display in the push notification.
	MediaUrl *string `type:"string"`

	// The raw, JSON-formatted string to use as the payload for the notification
	// message. This value overrides other values for the message.
	RawContent *string `type:"string"`

	// Specifies whether the notification is a silent push notification, which is
	// a push notification that doesn't display on a recipient's device. Silent
	// push notifications can be used for cases such as updating an app's configuration,
	// displaying messages in an in-app message center, or supporting phone home
	// functionality.
	SilentPush *bool `type:"boolean"`

	// The number of seconds that the push-notification service should keep the
	// message, if the service is unable to deliver the notification the first time.
	// This value is converted to an expiration value when it's sent to a push-notification
	// service. If this value is 0, the service treats the notification as if it
	// expires immediately and the service doesn't store or try to deliver the notification
	// again.
	//
	// This value doesn't apply to messages that are sent through the Amazon Device
	// Messaging (ADM) service.
	TimeToLive *int64 `type:"integer"`

	// The title to display above the notification message on a recipient's device.
	Title *string `type:"string"`

	// The URL to open in a recipient's default mobile browser, if a recipient taps
	// the push notification and the value of the Action property is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Message) SetAction(v string) *Message {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v string) *Message {
	s.Body = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *Message) SetImageIconUrl(v string) *Message {
	s.ImageIconUrl = &v
	return s
}

// SetImageSmallIconUrl sets the ImageSmallIconUrl field's value.
func (s *Message) SetImageSmallIconUrl(v string) *Message {
	s.ImageSmallIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *Message) SetImageUrl(v string) *Message {
	s.ImageUrl = &v
	return s
}

// SetJsonBody sets the JsonBody field's value.
func (s *Message) SetJsonBody(v string) *Message {
	s.JsonBody = &v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *Message) SetMediaUrl(v string) *Message {
	s.MediaUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *Message) SetRawContent(v string) *Message {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *Message) SetSilentPush(v bool) *Message {
	s.SilentPush = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *Message) SetTimeToLive(v int64) *Message {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Message) SetTitle(v string) *Message {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Message) SetUrl(v string) *Message {
	s.Url = &v
	return s
}

// Provides information about an API request or response.
type MessageBody struct {
	_ struct{} `type:"structure"`

	// The message that's returned from the API.
	Message *string `type:"string"`

	// The unique identifier for the request or response.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageBody) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *MessageBody) SetMessage(v string) *MessageBody {
	s.Message = &v
	return s
}

// SetRequestID sets the RequestID field's value.
func (s *MessageBody) SetRequestID(v string) *MessageBody {
	s.RequestID = &v
	return s
}

// Specifies the message configuration settings for a campaign.
type MessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message that the campaign sends through the ADM (Amazon Device Messaging)
	// channel. This message overrides the default message.
	ADMMessage *Message `type:"structure"`

	// The message that the campaign sends through the APNs (Apple Push Notification
	// service) channel. This message overrides the default message.
	APNSMessage *Message `type:"structure"`

	// The message that the campaign sends through the Baidu (Baidu Cloud Push)
	// channel. This message overrides the default message.
	BaiduMessage *Message `type:"structure"`

	// The default message that the campaign sends through all the channels that
	// are configured for the campaign.
	DefaultMessage *Message `type:"structure"`

	// The message that the campaign sends through the email channel.
	EmailMessage *CampaignEmailMessage `type:"structure"`

	// The message that the campaign sends through the GCM channel, which enables
	// Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging
	// (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides
	// the default message.
	GCMMessage *Message `type:"structure"`

	// The message that the campaign sends through the SMS channel.
	SMSMessage *CampaignSmsMessage `type:"structure"`
}

// String returns the string representation
func (s MessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageConfiguration"}
	if s.EmailMessage != nil {
		if err := s.EmailMessage.Validate(); err != nil {
			invalidParams.AddNested("EmailMessage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetADMMessage sets the ADMMessage field's value.
func (s *MessageConfiguration) SetADMMessage(v *Message) *MessageConfiguration {
	s.ADMMessage = v
	return s
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *MessageConfiguration) SetAPNSMessage(v *Message) *MessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetBaiduMessage sets the BaiduMessage field's value.
func (s *MessageConfiguration) SetBaiduMessage(v *Message) *MessageConfiguration {
	s.BaiduMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *MessageConfiguration) SetDefaultMessage(v *Message) *MessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *MessageConfiguration) SetEmailMessage(v *CampaignEmailMessage) *MessageConfiguration {
	s.EmailMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *MessageConfiguration) SetGCMMessage(v *Message) *MessageConfiguration {
	s.GCMMessage = v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *MessageConfiguration) SetSMSMessage(v *CampaignSmsMessage) *MessageConfiguration {
	s.SMSMessage = v
	return s
}

// Specifies the objects that define configuration and other settings for a
// message.
type MessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of key-value pairs, where each key is an address and each value is
	// an AddressConfiguration object. An address can be a push notification token,
	// a phone number, or an email address. You can use an AddressConfiguration
	// object to tailor the message for an address by specifying settings such as
	// content overrides and message variables.
	Addresses map[string]*AddressConfiguration `type:"map"`

	// A map of custom attributes to attach to the message. For a push notification,
	// this payload is added to the data.pinpoint object. For an email or text message,
	// this payload is added to email/SMS delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// A map of key-value pairs, where each key is an endpoint ID and each value
	// is an EndpointSendConfiguration object. You can use an EndpointSendConfiguration
	// object to tailor the message for an endpoint by specifying settings such
	// as content overrides and message variables.
	Endpoints map[string]*EndpointSendConfiguration `type:"map"`

	// The set of properties that defines the configuration settings for the message.
	//
	// MessageConfiguration is a required field
	MessageConfiguration *DirectMessageConfiguration `type:"structure" required:"true"`

	// The unique identifier for tracing the message. This identifier is visible
	// to message recipients.
	TraceId *string `type:"string"`
}

// String returns the string representation
func (s MessageRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageRequest"}
	if s.MessageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddresses sets the Addresses field's value.
func (s *MessageRequest) SetAddresses(v map[string]*AddressConfiguration) *MessageRequest {
	s.Addresses = v
	return s
}

// SetContext sets the Context field's value.
func (s *MessageRequest) SetContext(v map[string]*string) *MessageRequest {
	s.Context = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *MessageRequest) SetEndpoints(v map[string]*EndpointSendConfiguration) *MessageRequest {
	s.Endpoints = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *MessageRequest) SetMessageConfiguration(v *DirectMessageConfiguration) *MessageRequest {
	s.MessageConfiguration = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *MessageRequest) SetTraceId(v string) *MessageRequest {
	s.TraceId = &v
	return s
}

// Provides information about the results of a request to send a message to
// an endpoint address.
type MessageResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that was used to send the message.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// A map that contains a multipart response for each address that the message
	// was sent to. In the map, the endpoint ID is the key and the result is the
	// value.
	EndpointResult map[string]*EndpointMessageResult `type:"map"`

	// The identifier for the original request that the message was delivered for.
	RequestId *string `type:"string"`

	// A map that contains a multipart response for each address (email address,
	// phone number, or push notification token) that the message was sent to. In
	// the map, the address is the key and the result is the value.
	Result map[string]*MessageResult `type:"map"`
}

// String returns the string representation
func (s MessageResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *MessageResponse) SetApplicationId(v string) *MessageResponse {
	s.ApplicationId = &v
	return s
}

// SetEndpointResult sets the EndpointResult field's value.
func (s *MessageResponse) SetEndpointResult(v map[string]*EndpointMessageResult) *MessageResponse {
	s.EndpointResult = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *MessageResponse) SetRequestId(v string) *MessageResponse {
	s.RequestId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *MessageResponse) SetResult(v map[string]*MessageResult) *MessageResponse {
	s.Result = v
	return s
}

// Provides information about the results of sending a message directly to an
// endpoint address.
type MessageResult struct {
	_ struct{} `type:"structure"`

	// The delivery status of the message. Possible values are:
	//
	//    * DUPLICATE - The endpoint address is a duplicate of another endpoint
	//    address. Amazon Pinpoint won't attempt to send the message again.
	//
	//    * OPT_OUT - The user who's associated with the endpoint address has opted
	//    out of receiving messages from you. Amazon Pinpoint won't attempt to send
	//    the message again.
	//
	//    * PERMANENT_FAILURE - An error occurred when delivering the message to
	//    the endpoint address. Amazon Pinpoint won't attempt to send the message
	//    again.
	//
	//    * SUCCESSFUL - The message was successfully delivered to the endpoint
	//    address.
	//
	//    * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint will
	//    attempt to deliver the message again later.
	//
	//    * THROTTLED - Amazon Pinpoint throttled the operation to send the message
	//    to the endpoint address.
	//
	//    * TIMEOUT - The message couldn't be sent within the timeout period.
	//
	//    * UNKNOWN_FAILURE - An unknown error occurred.
	//
	// DeliveryStatus is a required field
	DeliveryStatus *string `type:"string" required:"true" enum:"DeliveryStatus"`

	// The unique identifier for the message that was sent.
	MessageId *string `type:"string"`

	// The downstream service status code for delivering the message.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The status message for delivering the message.
	StatusMessage *string `type:"string"`

	// For push notifications that are sent through the GCM channel, specifies whether
	// the token was updated as part of delivering the message.
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s MessageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageResult) GoString() string {
	return s.String()
}

// SetDeliveryStatus sets the DeliveryStatus field's value.
func (s *MessageResult) SetDeliveryStatus(v string) *MessageResult {
	s.DeliveryStatus = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *MessageResult) SetMessageId(v string) *MessageResult {
	s.MessageId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *MessageResult) SetStatusCode(v int64) *MessageResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *MessageResult) SetStatusMessage(v string) *MessageResult {
	s.StatusMessage = &v
	return s
}

// SetUpdatedToken sets the UpdatedToken field's value.
func (s *MessageResult) SetUpdatedToken(v string) *MessageResult {
	s.UpdatedToken = &v
	return s
}

// Specifies metric-based criteria for including or excluding endpoints from
// a segment. These criteria derive from custom metrics that you define for
// endpoints.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The operator to use when comparing metric values. Valid values are: GREATER_THAN,
	// LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true"`

	// The value to compare.
	//
	// Value is a required field
	Value *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *MetricDimension) SetComparisonOperator(v string) *MetricDimension {
	s.ComparisonOperator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v float64) *MetricDimension {
	s.Value = &v
	return s
}

// Specifies a phone number to validate and retrieve information about.
type NumberValidateRequest struct {
	_ struct{} `type:"structure"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the phone number was originally registered.
	IsoCountryCode *string `type:"string"`

	// The phone number to retrieve information about. The phone number that you
	// provide should include a valid numeric country code. Otherwise, the operation
	// might result in an error.
	PhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberValidateRequest) GoString() string {
	return s.String()
}

// SetIsoCountryCode sets the IsoCountryCode field's value.
func (s *NumberValidateRequest) SetIsoCountryCode(v string) *NumberValidateRequest {
	s.IsoCountryCode = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *NumberValidateRequest) SetPhoneNumber(v string) *NumberValidateRequest {
	s.PhoneNumber = &v
	return s
}

// Provides information about a phone number.
type NumberValidateResponse struct {
	_ struct{} `type:"structure"`

	// The carrier or service provider that the phone number is currently registered
	// with. In some countries and regions, this value may be the carrier or service
	// provider that the phone number was originally registered with.
	Carrier *string `type:"string"`

	// The name of the city where the phone number was originally registered.
	City *string `type:"string"`

	// The cleansed phone number, in E.164 format, for the location where the phone
	// number was originally registered.
	CleansedPhoneNumberE164 *string `type:"string"`

	// The cleansed phone number, in the format for the location where the phone
	// number was originally registered.
	CleansedPhoneNumberNational *string `type:"string"`

	// The name of the country or region where the phone number was originally registered.
	Country *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region where the phone number was originally registered.
	CountryCodeIso2 *string `type:"string"`

	// The numeric code for the country or region where the phone number was originally
	// registered.
	CountryCodeNumeric *string `type:"string"`

	// The name of the county where the phone number was originally registered.
	County *string `type:"string"`

	// The two-character code, in ISO 3166-1 alpha-2 format, that was sent in the
	// request body.
	OriginalCountryCodeIso2 *string `type:"string"`

	// The phone number that was sent in the request body.
	OriginalPhoneNumber *string `type:"string"`

	// The description of the phone type. Valid values are: MOBILE, LANDLINE, VOIP,
	// INVALID, PREPAID, and OTHER.
	PhoneType *string `type:"string"`

	// The phone type, represented by an integer. Valid values are: 0 (mobile),
	// 1 (landline), 2 (VoIP), 3 (invalid), 4 (other), and 5 (prepaid).
	PhoneTypeCode *int64 `type:"integer"`

	// The time zone for the location where the phone number was originally registered.
	Timezone *string `type:"string"`

	// The postal or ZIP code for the location where the phone number was originally
	// registered.
	ZipCode *string `type:"string"`
}

// String returns the string representation
func (s NumberValidateResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberValidateResponse) GoString() string {
	return s.String()
}

// SetCarrier sets the Carrier field's value.
func (s *NumberValidateResponse) SetCarrier(v string) *NumberValidateResponse {
	s.Carrier = &v
	return s
}

// SetCity sets the City field's value.
func (s *NumberValidateResponse) SetCity(v string) *NumberValidateResponse {
	s.City = &v
	return s
}

// SetCleansedPhoneNumberE164 sets the CleansedPhoneNumberE164 field's value.
func (s *NumberValidateResponse) SetCleansedPhoneNumberE164(v string) *NumberValidateResponse {
	s.CleansedPhoneNumberE164 = &v
	return s
}

// SetCleansedPhoneNumberNational sets the CleansedPhoneNumberNational field's value.
func (s *NumberValidateResponse) SetCleansedPhoneNumberNational(v string) *NumberValidateResponse {
	s.CleansedPhoneNumberNational = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *NumberValidateResponse) SetCountry(v string) *NumberValidateResponse {
	s.Country = &v
	return s
}

// SetCountryCodeIso2 sets the CountryCodeIso2 field's value.
func (s *NumberValidateResponse) SetCountryCodeIso2(v string) *NumberValidateResponse {
	s.CountryCodeIso2 = &v
	return s
}

// SetCountryCodeNumeric sets the CountryCodeNumeric field's value.
func (s *NumberValidateResponse) SetCountryCodeNumeric(v string) *NumberValidateResponse {
	s.CountryCodeNumeric = &v
	return s
}

// SetCounty sets the County field's value.
func (s *NumberValidateResponse) SetCounty(v string) *NumberValidateResponse {
	s.County = &v
	return s
}

// SetOriginalCountryCodeIso2 sets the OriginalCountryCodeIso2 field's value.
func (s *NumberValidateResponse) SetOriginalCountryCodeIso2(v string) *NumberValidateResponse {
	s.OriginalCountryCodeIso2 = &v
	return s
}

// SetOriginalPhoneNumber sets the OriginalPhoneNumber field's value.
func (s *NumberValidateResponse) SetOriginalPhoneNumber(v string) *NumberValidateResponse {
	s.OriginalPhoneNumber = &v
	return s
}

// SetPhoneType sets the PhoneType field's value.
func (s *NumberValidateResponse) SetPhoneType(v string) *NumberValidateResponse {
	s.PhoneType = &v
	return s
}

// SetPhoneTypeCode sets the PhoneTypeCode field's value.
func (s *NumberValidateResponse) SetPhoneTypeCode(v int64) *NumberValidateResponse {
	s.PhoneTypeCode = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *NumberValidateResponse) SetTimezone(v string) *NumberValidateResponse {
	s.Timezone = &v
	return s
}

// SetZipCode sets the ZipCode field's value.
func (s *NumberValidateResponse) SetZipCode(v string) *NumberValidateResponse {
	s.ZipCode = &v
	return s
}

type PhoneNumberValidateInput struct {
	_ struct{} `type:"structure" payload:"NumberValidateRequest"`

	// Specifies a phone number to validate and retrieve information about.
	//
	// NumberValidateRequest is a required field
	NumberValidateRequest *NumberValidateRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s PhoneNumberValidateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberValidateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneNumberValidateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneNumberValidateInput"}
	if s.NumberValidateRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberValidateRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNumberValidateRequest sets the NumberValidateRequest field's value.
func (s *PhoneNumberValidateInput) SetNumberValidateRequest(v *NumberValidateRequest) *PhoneNumberValidateInput {
	s.NumberValidateRequest = v
	return s
}

type PhoneNumberValidateOutput struct {
	_ struct{} `type:"structure" payload:"NumberValidateResponse"`

	// Provides information about a phone number.
	//
	// NumberValidateResponse is a required field
	NumberValidateResponse *NumberValidateResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s PhoneNumberValidateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberValidateOutput) GoString() string {
	return s.String()
}

// SetNumberValidateResponse sets the NumberValidateResponse field's value.
func (s *PhoneNumberValidateOutput) SetNumberValidateResponse(v *NumberValidateResponse) *PhoneNumberValidateOutput {
	s.NumberValidateResponse = v
	return s
}

// Specifies the properties and attributes of an endpoint that's associated
// with an event.
type PublicEndpoint struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the recipient, such as a device token, email address,
	// or mobile phone number.
	Address *string `type:"string"`

	// One or more custom attributes that describe the endpoint by associating a
	// name with an array of values. You can use these attributes as filter criteria
	// when you create segments.
	Attributes map[string][]*string `type:"map"`

	// The channel that's used when sending messages or push notifications to the
	// endpoint.
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The demographic information for the endpoint, such as the time zone and platform.
	Demographic *EndpointDemographic `type:"structure"`

	// The date and time, in ISO 8601 format, when the endpoint was last updated.
	EffectiveDate *string `type:"string"`

	// The status of the update request for the endpoint. Possible values are: INACTIVE,
	// the update failed; and, ACTIVE, the endpoint was updated successfully.
	EndpointStatus *string `type:"string"`

	// The geographic information for the endpoint.
	Location *EndpointLocation `type:"structure"`

	// One or more custom metrics that your app reports to Amazon Pinpoint for the
	// endpoint.
	Metrics map[string]*float64 `type:"map"`

	// Specifies whether the user who's associated with the endpoint has opted out
	// of receiving messages and push notifications from you. Possible values are:
	// ALL, the user has opted out and doesn't want to receive any messages or push
	// notifications; and, NONE, the user hasn't opted out and wants to receive
	// all messages and push notifications.
	OptOut *string `type:"string"`

	// A unique identifier that's generated each time the endpoint is updated.
	RequestId *string `type:"string"`

	// One or more custom user attributes that your app reports to Amazon Pinpoint
	// for the user who's associated with the endpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s PublicEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *PublicEndpoint) SetAddress(v string) *PublicEndpoint {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *PublicEndpoint) SetAttributes(v map[string][]*string) *PublicEndpoint {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *PublicEndpoint) SetChannelType(v string) *PublicEndpoint {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *PublicEndpoint) SetDemographic(v *EndpointDemographic) *PublicEndpoint {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *PublicEndpoint) SetEffectiveDate(v string) *PublicEndpoint {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *PublicEndpoint) SetEndpointStatus(v string) *PublicEndpoint {
	s.EndpointStatus = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *PublicEndpoint) SetLocation(v *EndpointLocation) *PublicEndpoint {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *PublicEndpoint) SetMetrics(v map[string]*float64) *PublicEndpoint {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *PublicEndpoint) SetOptOut(v string) *PublicEndpoint {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PublicEndpoint) SetRequestId(v string) *PublicEndpoint {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *PublicEndpoint) SetUser(v *EndpointUser) *PublicEndpoint {
	s.User = v
	return s
}

type PutEventStreamInput struct {
	_ struct{} `type:"structure" payload:"WriteEventStream"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the Amazon Resource Name (ARN) of an event stream to publish events
	// to and the AWS Identity and Access Management (IAM) role to use when publishing
	// those events.
	//
	// WriteEventStream is a required field
	WriteEventStream *WriteEventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteEventStream == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteEventStream"))
	}
	if s.WriteEventStream != nil {
		if err := s.WriteEventStream.Validate(); err != nil {
			invalidParams.AddNested("WriteEventStream", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutEventStreamInput) SetApplicationId(v string) *PutEventStreamInput {
	s.ApplicationId = &v
	return s
}

// SetWriteEventStream sets the WriteEventStream field's value.
func (s *PutEventStreamInput) SetWriteEventStream(v *WriteEventStream) *PutEventStreamInput {
	s.WriteEventStream = v
	return s
}

type PutEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Specifies settings for publishing event data to an Amazon Kinesis data stream
	// or an Amazon Kinesis Data Firehose delivery stream.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *PutEventStreamOutput) SetEventStream(v *EventStream) *PutEventStreamOutput {
	s.EventStream = v
	return s
}

type PutEventsInput struct {
	_ struct{} `type:"structure" payload:"EventsRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies a batch of events to process.
	//
	// EventsRequest is a required field
	EventsRequest *EventsRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EventsRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EventsRequest"))
	}
	if s.EventsRequest != nil {
		if err := s.EventsRequest.Validate(); err != nil {
			invalidParams.AddNested("EventsRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutEventsInput) SetApplicationId(v string) *PutEventsInput {
	s.ApplicationId = &v
	return s
}

// SetEventsRequest sets the EventsRequest field's value.
func (s *PutEventsInput) SetEventsRequest(v *EventsRequest) *PutEventsInput {
	s.EventsRequest = v
	return s
}

type PutEventsOutput struct {
	_ struct{} `type:"structure" payload:"EventsResponse"`

	// Provides information about endpoints and the events that they're associated
	// with.
	//
	// EventsResponse is a required field
	EventsResponse *EventsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsOutput) GoString() string {
	return s.String()
}

// SetEventsResponse sets the EventsResponse field's value.
func (s *PutEventsOutput) SetEventsResponse(v *EventsResponse) *PutEventsOutput {
	s.EventsResponse = v
	return s
}

// Specifies the start and end times that define a time range when messages
// aren't sent to endpoints.
type QuietTime struct {
	_ struct{} `type:"structure"`

	// The specific time when quiet time ends. This value has to use 24-hour notation
	// and be in HH:MM format, where HH is the hour (with a leading zero, if applicable)
	// and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30
	// to represent 2:30 PM.
	End *string `type:"string"`

	// The specific time when quiet time begins. This value has to use 24-hour notation
	// and be in HH:MM format, where HH is the hour (with a leading zero, if applicable)
	// and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30
	// to represent 2:30 PM.
	Start *string `type:"string"`
}

// String returns the string representation
func (s QuietTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuietTime) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *QuietTime) SetEnd(v string) *QuietTime {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *QuietTime) SetStart(v string) *QuietTime {
	s.Start = &v
	return s
}

// Specifies the contents of an email message, represented as a raw MIME message.
type RawEmail struct {
	_ struct{} `type:"structure"`

	// The email message, represented as a raw MIME message. The entire message
	// must be base64 encoded.
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	Data []byte `type:"blob"`
}

// String returns the string representation
func (s RawEmail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawEmail) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *RawEmail) SetData(v []byte) *RawEmail {
	s.Data = v
	return s
}

// Specifies criteria for including or excluding endpoints from a segment based
// on how recently an endpoint was active.
type RecencyDimension struct {
	_ struct{} `type:"structure"`

	// The duration to use when determining whether an endpoint is active or inactive.
	//
	// Duration is a required field
	Duration *string `type:"string" required:"true" enum:"Duration"`

	// The type of recency dimension to use for the segment. Valid values are: ACTIVE,
	// endpoints that were active within the specified duration are included in
	// the segment; and, INACTIVE, endpoints that weren't active within the specified
	// duration are included in the segment.
	//
	// RecencyType is a required field
	RecencyType *string `type:"string" required:"true" enum:"RecencyType"`
}

// String returns the string representation
func (s RecencyDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecencyDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecencyDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecencyDimension"}
	if s.Duration == nil {
		invalidParams.Add(request.NewErrParamRequired("Duration"))
	}
	if s.RecencyType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecencyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *RecencyDimension) SetDuration(v string) *RecencyDimension {
	s.Duration = &v
	return s
}

// SetRecencyType sets the RecencyType field's value.
func (s *RecencyDimension) SetRecencyType(v string) *RecencyDimension {
	s.RecencyType = &v
	return s
}

type RemoveAttributesInput struct {
	_ struct{} `type:"structure" payload:"UpdateAttributesRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// AttributeType is a required field
	AttributeType *string `location:"uri" locationName:"attribute-type" type:"string" required:"true"`

	// Specifies one or more attributes to remove from all the endpoints that are
	// associated with an application.
	//
	// UpdateAttributesRequest is a required field
	UpdateAttributesRequest *UpdateAttributesRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s RemoveAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAttributesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.AttributeType == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeType"))
	}
	if s.AttributeType != nil && len(*s.AttributeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeType", 1))
	}
	if s.UpdateAttributesRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateAttributesRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *RemoveAttributesInput) SetApplicationId(v string) *RemoveAttributesInput {
	s.ApplicationId = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *RemoveAttributesInput) SetAttributeType(v string) *RemoveAttributesInput {
	s.AttributeType = &v
	return s
}

// SetUpdateAttributesRequest sets the UpdateAttributesRequest field's value.
func (s *RemoveAttributesInput) SetUpdateAttributesRequest(v *UpdateAttributesRequest) *RemoveAttributesInput {
	s.UpdateAttributesRequest = v
	return s
}

type RemoveAttributesOutput struct {
	_ struct{} `type:"structure" payload:"AttributesResource"`

	// Provides information about the type and the names of attributes that were
	// removed from all the endpoints that are associated with an application.
	//
	// AttributesResource is a required field
	AttributesResource *AttributesResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s RemoveAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributesResource sets the AttributesResource field's value.
func (s *RemoveAttributesOutput) SetAttributesResource(v *AttributesResource) *RemoveAttributesOutput {
	s.AttributesResource = v
	return s
}

// Provides the results of a query that retrieved the data for a standard metric
// that applies to an application or campaign.
type ResultRow struct {
	_ struct{} `type:"structure"`

	// An array of objects that defines the field and field values that were used
	// to group data in a result set that contains multiple results. This value
	// is null if the data in a result set isn’t grouped.
	//
	// GroupedBys is a required field
	GroupedBys []*ResultRowValue `type:"list" required:"true"`

	// An array of objects that provides pre-aggregated values for a standard metric
	// that applies to an application or campaign.
	//
	// Values is a required field
	Values []*ResultRowValue `type:"list" required:"true"`
}

// String returns the string representation
func (s ResultRow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultRow) GoString() string {
	return s.String()
}

// SetGroupedBys sets the GroupedBys field's value.
func (s *ResultRow) SetGroupedBys(v []*ResultRowValue) *ResultRow {
	s.GroupedBys = v
	return s
}

// SetValues sets the Values field's value.
func (s *ResultRow) SetValues(v []*ResultRowValue) *ResultRow {
	s.Values = v
	return s
}

// Provides a single value and metadata about that value as part of an array
// of query results for a standard metric that applies to an application or
// campaign.
type ResultRowValue struct {
	_ struct{} `type:"structure"`

	// The name of the field that Amazon Pinpoint uses to store the value specified
	// by the Value property.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The data type of the value specified by the Value property.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// In a Values object, the value for the metric that the query retrieved data
	// for. In a GroupedBys object, the value for the field that was used to group
	// data in a result set that contains multiple results (Values objects).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResultRowValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultRowValue) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResultRowValue) SetKey(v string) *ResultRowValue {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResultRowValue) SetType(v string) *ResultRowValue {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResultRowValue) SetValue(v string) *ResultRowValue {
	s.Value = &v
	return s
}

// Specifies the status and settings of the SMS channel for an application.
type SMSChannelRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the SMS channel for the application.
	Enabled *bool `type:"boolean"`

	// The identity that you want to display on recipients' devices when they receive
	// messages from the SMS channel.
	SenderId *string `type:"string"`

	// The registered short code that you want to use when you send messages through
	// the SMS channel.
	ShortCode *string `type:"string"`
}

// String returns the string representation
func (s SMSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSChannelRequest) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SMSChannelRequest) SetEnabled(v bool) *SMSChannelRequest {
	s.Enabled = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSChannelRequest) SetSenderId(v string) *SMSChannelRequest {
	s.SenderId = &v
	return s
}

// SetShortCode sets the ShortCode field's value.
func (s *SMSChannelRequest) SetShortCode(v string) *SMSChannelRequest {
	s.ShortCode = &v
	return s
}

// Provides information about the status and settings of the SMS channel for
// an application.
type SMSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the SMS channel applies to.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the SMS channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the SMS channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the SMS channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the SMS channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the SMS channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the SMS channel was last modified.
	LastModifiedDate *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the SMS
	// channel, this value is SMS.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The maximum number of promotional messages that you can send through the
	// SMS channel each second.
	PromotionalMessagesPerSecond *int64 `type:"integer"`

	// The identity that displays on recipients' devices when they receive messages
	// from the SMS channel.
	SenderId *string `type:"string"`

	// The registered short code to use when you send messages through the SMS channel.
	ShortCode *string `type:"string"`

	// The maximum number of transactional messages that you can send through the
	// SMS channel each second.
	TransactionalMessagesPerSecond *int64 `type:"integer"`

	// The current version of the SMS channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SMSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SMSChannelResponse) SetApplicationId(v string) *SMSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SMSChannelResponse) SetCreationDate(v string) *SMSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *SMSChannelResponse) SetEnabled(v bool) *SMSChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *SMSChannelResponse) SetHasCredential(v bool) *SMSChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *SMSChannelResponse) SetId(v string) *SMSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *SMSChannelResponse) SetIsArchived(v bool) *SMSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *SMSChannelResponse) SetLastModifiedBy(v string) *SMSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SMSChannelResponse) SetLastModifiedDate(v string) *SMSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *SMSChannelResponse) SetPlatform(v string) *SMSChannelResponse {
	s.Platform = &v
	return s
}

// SetPromotionalMessagesPerSecond sets the PromotionalMessagesPerSecond field's value.
func (s *SMSChannelResponse) SetPromotionalMessagesPerSecond(v int64) *SMSChannelResponse {
	s.PromotionalMessagesPerSecond = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSChannelResponse) SetSenderId(v string) *SMSChannelResponse {
	s.SenderId = &v
	return s
}

// SetShortCode sets the ShortCode field's value.
func (s *SMSChannelResponse) SetShortCode(v string) *SMSChannelResponse {
	s.ShortCode = &v
	return s
}

// SetTransactionalMessagesPerSecond sets the TransactionalMessagesPerSecond field's value.
func (s *SMSChannelResponse) SetTransactionalMessagesPerSecond(v int64) *SMSChannelResponse {
	s.TransactionalMessagesPerSecond = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SMSChannelResponse) SetVersion(v int64) *SMSChannelResponse {
	s.Version = &v
	return s
}

// Specifies the default settings for a one-time SMS message that's sent directly
// to an endpoint.
type SMSMessage struct {
	_ struct{} `type:"structure"`

	// The body of the SMS message.
	Body *string `type:"string"`

	// The SMS program name that you provided to AWS Support when you requested
	// your dedicated number.
	Keyword *string `type:"string"`

	// The SMS message type. Valid values are: TRANSACTIONAL, the message is critical
	// or time-sensitive, such as a one-time password that supports a customer transaction;
	// and, PROMOTIONAL, the message is not critical or time-sensitive, such as
	// a marketing message.
	MessageType *string `type:"string" enum:"MessageType"`

	// The number that the SMS message originates from. This should be one of the
	// dedicated long codes or short codes that you requested from AWS Support and
	// is assigned to your AWS account. If you don't specify a long or short code,
	// Amazon Pinpoint assigns a random long code to the SMS message.
	OriginationNumber *string `type:"string"`

	// The sender ID to display as the sender of the message on a recipient's device.
	// Support for sender IDs varies by country or region.
	SenderId *string `type:"string"`

	// The message variables to use in the SMS message. You can override the default
	// variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s SMSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *SMSMessage) SetBody(v string) *SMSMessage {
	s.Body = &v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *SMSMessage) SetKeyword(v string) *SMSMessage {
	s.Keyword = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SMSMessage) SetMessageType(v string) *SMSMessage {
	s.MessageType = &v
	return s
}

// SetOriginationNumber sets the OriginationNumber field's value.
func (s *SMSMessage) SetOriginationNumber(v string) *SMSMessage {
	s.OriginationNumber = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSMessage) SetSenderId(v string) *SMSMessage {
	s.SenderId = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *SMSMessage) SetSubstitutions(v map[string][]*string) *SMSMessage {
	s.Substitutions = v
	return s
}

// Specifies the schedule settings for a campaign.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The scheduled time, in ISO 8601 format, for the campaign to end.
	EndTime *string `type:"string"`

	// The type of event that causes the campaign to be sent, if the value of the
	// Frequency property is EVENT.
	EventFilter *CampaignEventFilter `type:"structure"`

	// Specifies how often the campaign is sent or whether the campaign is sent
	// in response to a specific event.
	Frequency *string `type:"string" enum:"Frequency"`

	// Specifies whether the start and end times for the campaign schedule use each
	// recipient's local time. To base the schedule on each recipient's local time,
	// set this value to true.
	IsLocalTime *bool `type:"boolean"`

	// The default quiet time for the campaign. Quiet time is a specific time range
	// when a campaign doesn't send messages to endpoints, if all the following
	// conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the campaign.
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the campaign.
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from the campaign, even if quiet time is enabled.
	QuietTime *QuietTime `type:"structure"`

	// The scheduled time, in ISO 8601 format, for the campaign to begin.
	//
	// StartTime is a required field
	StartTime *string `type:"string" required:"true"`

	// The starting UTC offset for the campaign schedule, if the value of the IsLocalTime
	// property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30,
	// UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07,
	// UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02,
	// UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Schedule"}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.EventFilter != nil {
		if err := s.EventFilter.Validate(); err != nil {
			invalidParams.AddNested("EventFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *Schedule) SetEndTime(v string) *Schedule {
	s.EndTime = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *Schedule) SetEventFilter(v *CampaignEventFilter) *Schedule {
	s.EventFilter = v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *Schedule) SetFrequency(v string) *Schedule {
	s.Frequency = &v
	return s
}

// SetIsLocalTime sets the IsLocalTime field's value.
func (s *Schedule) SetIsLocalTime(v bool) *Schedule {
	s.IsLocalTime = &v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *Schedule) SetQuietTime(v *QuietTime) *Schedule {
	s.QuietTime = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Schedule) SetStartTime(v string) *Schedule {
	s.StartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Schedule) SetTimezone(v string) *Schedule {
	s.Timezone = &v
	return s
}

// Specifies dimension settings for including or excluding endpoints from a
// segment based on how recently an endpoint was active.
type SegmentBehaviors struct {
	_ struct{} `type:"structure"`

	// The dimension settings that are based on how recently an endpoint was active.
	Recency *RecencyDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentBehaviors) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentBehaviors) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentBehaviors"}
	if s.Recency != nil {
		if err := s.Recency.Validate(); err != nil {
			invalidParams.AddNested("Recency", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecency sets the Recency field's value.
func (s *SegmentBehaviors) SetRecency(v *RecencyDimension) *SegmentBehaviors {
	s.Recency = v
	return s
}

// Specifies demographic-based dimension settings for including or excluding
// endpoints from a segment. These settings derive from characteristics of endpoint
// devices, such as platform, make, and model.
type SegmentDemographics struct {
	_ struct{} `type:"structure"`

	// The app version criteria for the segment.
	AppVersion *SetDimension `type:"structure"`

	// The channel criteria for the segment.
	Channel *SetDimension `type:"structure"`

	// The device type criteria for the segment.
	DeviceType *SetDimension `type:"structure"`

	// The device make criteria for the segment.
	Make *SetDimension `type:"structure"`

	// The device model criteria for the segment.
	Model *SetDimension `type:"structure"`

	// The device platform criteria for the segment.
	Platform *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentDemographics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentDemographics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentDemographics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentDemographics"}
	if s.AppVersion != nil {
		if err := s.AppVersion.Validate(); err != nil {
			invalidParams.AddNested("AppVersion", err.(request.ErrInvalidParams))
		}
	}
	if s.Channel != nil {
		if err := s.Channel.Validate(); err != nil {
			invalidParams.AddNested("Channel", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceType != nil {
		if err := s.DeviceType.Validate(); err != nil {
			invalidParams.AddNested("DeviceType", err.(request.ErrInvalidParams))
		}
	}
	if s.Make != nil {
		if err := s.Make.Validate(); err != nil {
			invalidParams.AddNested("Make", err.(request.ErrInvalidParams))
		}
	}
	if s.Model != nil {
		if err := s.Model.Validate(); err != nil {
			invalidParams.AddNested("Model", err.(request.ErrInvalidParams))
		}
	}
	if s.Platform != nil {
		if err := s.Platform.Validate(); err != nil {
			invalidParams.AddNested("Platform", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppVersion sets the AppVersion field's value.
func (s *SegmentDemographics) SetAppVersion(v *SetDimension) *SegmentDemographics {
	s.AppVersion = v
	return s
}

// SetChannel sets the Channel field's value.
func (s *SegmentDemographics) SetChannel(v *SetDimension) *SegmentDemographics {
	s.Channel = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *SegmentDemographics) SetDeviceType(v *SetDimension) *SegmentDemographics {
	s.DeviceType = v
	return s
}

// SetMake sets the Make field's value.
func (s *SegmentDemographics) SetMake(v *SetDimension) *SegmentDemographics {
	s.Make = v
	return s
}

// SetModel sets the Model field's value.
func (s *SegmentDemographics) SetModel(v *SetDimension) *SegmentDemographics {
	s.Model = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *SegmentDemographics) SetPlatform(v *SetDimension) *SegmentDemographics {
	s.Platform = v
	return s
}

// Specifies the dimension settings for a segment.
type SegmentDimensions struct {
	_ struct{} `type:"structure"`

	// One or more custom attributes to use as criteria for the segment.
	Attributes map[string]*AttributeDimension `type:"map"`

	// The behavior-based criteria, such as how recently users have used your app,
	// for the segment.
	Behavior *SegmentBehaviors `type:"structure"`

	// The demographic-based criteria, such as device platform, for the segment.
	Demographic *SegmentDemographics `type:"structure"`

	// The location-based criteria, such as region or GPS coordinates, for the segment.
	Location *SegmentLocation `type:"structure"`

	// One or more custom metrics to use as criteria for the segment.
	Metrics map[string]*MetricDimension `type:"map"`

	// One or more custom user attributes to use as criteria for the segment.
	UserAttributes map[string]*AttributeDimension `type:"map"`
}

// String returns the string representation
func (s SegmentDimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentDimensions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentDimensions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentDimensions"}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Behavior != nil {
		if err := s.Behavior.Validate(); err != nil {
			invalidParams.AddNested("Behavior", err.(request.ErrInvalidParams))
		}
	}
	if s.Demographic != nil {
		if err := s.Demographic.Validate(); err != nil {
			invalidParams.AddNested("Demographic", err.(request.ErrInvalidParams))
		}
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		for i, v := range s.Metrics {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Metrics", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SegmentDimensions) SetAttributes(v map[string]*AttributeDimension) *SegmentDimensions {
	s.Attributes = v
	return s
}

// SetBehavior sets the Behavior field's value.
func (s *SegmentDimensions) SetBehavior(v *SegmentBehaviors) *SegmentDimensions {
	s.Behavior = v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *SegmentDimensions) SetDemographic(v *SegmentDemographics) *SegmentDimensions {
	s.Demographic = v
	return s
}

// SetLocation sets the Location field's value.
func (s *SegmentDimensions) SetLocation(v *SegmentLocation) *SegmentDimensions {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *SegmentDimensions) SetMetrics(v map[string]*MetricDimension) *SegmentDimensions {
	s.Metrics = v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *SegmentDimensions) SetUserAttributes(v map[string]*AttributeDimension) *SegmentDimensions {
	s.UserAttributes = v
	return s
}

// Specifies the base segments and dimensions for a segment, and the relationships
// between these base segments and dimensions.
type SegmentGroup struct {
	_ struct{} `type:"structure"`

	// An array that defines the dimensions for the segment.
	Dimensions []*SegmentDimensions `type:"list"`

	// The base segment to build the segment on. A base segment, also referred to
	// as a source segment, defines the initial population of endpoints for a segment.
	// When you add dimensions to a segment, Amazon Pinpoint filters the base segment
	// by using the dimensions that you specify.
	//
	// You can specify more than one dimensional segment or only one imported segment.
	// If you specify an imported segment, the Amazon Pinpoint console displays
	// a segment size estimate that indicates the size of the imported segment without
	// any filters applied to it.
	SourceSegments []*SegmentReference `type:"list"`

	// Specifies how to handle multiple base segments for the segment. For example,
	// if you specify three base segments for the segment, whether the resulting
	// segment is based on all, any, or none of the base segments.
	SourceType *string `type:"string" enum:"SourceType"`

	// Specifies how to handle multiple dimensions for the segment. For example,
	// if you specify three dimensions for the segment, whether the resulting segment
	// includes endpoints that match all, any, or none of the dimensions.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation
func (s SegmentGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentGroup"}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceSegments != nil {
		for i, v := range s.SourceSegments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceSegments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *SegmentGroup) SetDimensions(v []*SegmentDimensions) *SegmentGroup {
	s.Dimensions = v
	return s
}

// SetSourceSegments sets the SourceSegments field's value.
func (s *SegmentGroup) SetSourceSegments(v []*SegmentReference) *SegmentGroup {
	s.SourceSegments = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *SegmentGroup) SetSourceType(v string) *SegmentGroup {
	s.SourceType = &v
	return s
}

// SetType sets the Type field's value.
func (s *SegmentGroup) SetType(v string) *SegmentGroup {
	s.Type = &v
	return s
}

// Specifies the settings that define the relationships between segment groups
// for a segment.
type SegmentGroupList struct {
	_ struct{} `type:"structure"`

	// An array that defines the set of segment criteria to evaluate when handling
	// segment groups for the segment.
	Groups []*SegmentGroup `type:"list"`

	// Specifies how to handle multiple segment groups for the segment. For example,
	// if the segment includes three segment groups, whether the resulting segment
	// includes endpoints that match all, any, or none of the segment groups.
	Include *string `type:"string" enum:"Include"`
}

// String returns the string representation
func (s SegmentGroupList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentGroupList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentGroupList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentGroupList"}
	if s.Groups != nil {
		for i, v := range s.Groups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Groups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroups sets the Groups field's value.
func (s *SegmentGroupList) SetGroups(v []*SegmentGroup) *SegmentGroupList {
	s.Groups = v
	return s
}

// SetInclude sets the Include field's value.
func (s *SegmentGroupList) SetInclude(v string) *SegmentGroupList {
	s.Include = &v
	return s
}

// Provides information about the import job that created a segment. An import
// job is a job that creates a user segment by importing endpoint definitions.
type SegmentImportResource struct {
	_ struct{} `type:"structure"`

	// The number of channel types in the endpoint definitions that were imported
	// to create the segment.
	ChannelCounts map[string]*int64 `type:"map"`

	// (Deprecated) Your AWS account ID, which you assigned to an external ID key
	// in an IAM trust policy. Amazon Pinpoint previously used this value to assume
	// an IAM role when importing endpoint definitions, but we removed this requirement.
	// We don't recommend use of external IDs for IAM roles that are assumed by
	// Amazon Pinpoint.
	//
	// ExternalId is a required field
	ExternalId *string `type:"string" required:"true"`

	// The format of the files that were imported to create the segment. Valid values
	// are: CSV, for comma-separated values format; and, JSON, for newline-delimited
	// JSON format.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location
	// to import endpoint definitions from.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the
	// endpoint definitions were imported from to create the segment.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`

	// The number of endpoint definitions that were imported successfully to create
	// the segment.
	//
	// Size is a required field
	Size *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s SegmentImportResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentImportResource) GoString() string {
	return s.String()
}

// SetChannelCounts sets the ChannelCounts field's value.
func (s *SegmentImportResource) SetChannelCounts(v map[string]*int64) *SegmentImportResource {
	s.ChannelCounts = v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *SegmentImportResource) SetExternalId(v string) *SegmentImportResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *SegmentImportResource) SetFormat(v string) *SegmentImportResource {
	s.Format = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SegmentImportResource) SetRoleArn(v string) *SegmentImportResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *SegmentImportResource) SetS3Url(v string) *SegmentImportResource {
	s.S3Url = &v
	return s
}

// SetSize sets the Size field's value.
func (s *SegmentImportResource) SetSize(v int64) *SegmentImportResource {
	s.Size = &v
	return s
}

// Specifies geographical dimension settings for a segment.
type SegmentLocation struct {
	_ struct{} `type:"structure"`

	// The country or region code, in ISO 3166-1 alpha-2 format, for the segment.
	Country *SetDimension `type:"structure"`

	// The GPS location and range for the segment.
	GPSPoint *GPSPointDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentLocation"}
	if s.Country != nil {
		if err := s.Country.Validate(); err != nil {
			invalidParams.AddNested("Country", err.(request.ErrInvalidParams))
		}
	}
	if s.GPSPoint != nil {
		if err := s.GPSPoint.Validate(); err != nil {
			invalidParams.AddNested("GPSPoint", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountry sets the Country field's value.
func (s *SegmentLocation) SetCountry(v *SetDimension) *SegmentLocation {
	s.Country = v
	return s
}

// SetGPSPoint sets the GPSPoint field's value.
func (s *SegmentLocation) SetGPSPoint(v *GPSPointDimension) *SegmentLocation {
	s.GPSPoint = v
	return s
}

// Specifies the segment identifier and version of a segment.
type SegmentReference struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the segment.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The version number of the segment.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SegmentReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SegmentReference"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *SegmentReference) SetId(v string) *SegmentReference {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SegmentReference) SetVersion(v int64) *SegmentReference {
	s.Version = &v
	return s
}

// Provides information about the configuration, dimension, and other settings
// for a segment.
type SegmentResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the segment is associated
	// with.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the segment.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The date and time when the segment was created.
	//
	// CreationDate is a required field
	CreationDate *string `type:"string" required:"true"`

	// The dimension settings for the segment.
	Dimensions *SegmentDimensions `type:"structure"`

	// The unique identifier for the segment.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The settings for the import job that's associated with the segment.
	ImportDefinition *SegmentImportResource `type:"structure"`

	// The date and time when the segment was last modified.
	LastModifiedDate *string `type:"string"`

	// The name of the segment.
	Name *string `type:"string"`

	// A list of one or more segment groups that apply to the segment. Each segment
	// group consists of zero or more base segments and the dimensions that are
	// applied to those base segments.
	SegmentGroups *SegmentGroupList `type:"structure"`

	// The segment type. Valid values are:
	//
	//    * DIMENSIONAL - A dynamic segment, which is a segment that uses selection
	//    criteria that you specify and is based on endpoint data that's reported
	//    by your app. Dynamic segments can change over time.
	//
	//    * IMPORT - A static segment, which is a segment that uses selection criteria
	//    that you specify and is based on endpoint definitions that you import
	//    from a file. Imported segments are static; they don't change over time.
	//
	// SegmentType is a required field
	SegmentType *string `type:"string" required:"true" enum:"SegmentType"`

	// A string-to-string map of key-value pairs that identifies the tags that are
	// associated with the segment. Each tag consists of a required tag key and
	// an associated tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version number of the segment.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SegmentResponse) SetApplicationId(v string) *SegmentResponse {
	s.ApplicationId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *SegmentResponse) SetArn(v string) *SegmentResponse {
	s.Arn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SegmentResponse) SetCreationDate(v string) *SegmentResponse {
	s.CreationDate = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *SegmentResponse) SetDimensions(v *SegmentDimensions) *SegmentResponse {
	s.Dimensions = v
	return s
}

// SetId sets the Id field's value.
func (s *SegmentResponse) SetId(v string) *SegmentResponse {
	s.Id = &v
	return s
}

// SetImportDefinition sets the ImportDefinition field's value.
func (s *SegmentResponse) SetImportDefinition(v *SegmentImportResource) *SegmentResponse {
	s.ImportDefinition = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SegmentResponse) SetLastModifiedDate(v string) *SegmentResponse {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SegmentResponse) SetName(v string) *SegmentResponse {
	s.Name = &v
	return s
}

// SetSegmentGroups sets the SegmentGroups field's value.
func (s *SegmentResponse) SetSegmentGroups(v *SegmentGroupList) *SegmentResponse {
	s.SegmentGroups = v
	return s
}

// SetSegmentType sets the SegmentType field's value.
func (s *SegmentResponse) SetSegmentType(v string) *SegmentResponse {
	s.SegmentType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SegmentResponse) SetTags(v map[string]*string) *SegmentResponse {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *SegmentResponse) SetVersion(v int64) *SegmentResponse {
	s.Version = &v
	return s
}

// Provides information about all the segments that are associated with an application.
type SegmentsResponse struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each segment that's associated with the application
	// (Segments resource) or each version of a segment that's associated with the
	// application (Segment Versions resource).
	//
	// Item is a required field
	Item []*SegmentResponse `type:"list" required:"true"`

	// The string to use in a subsequent request to get the next page of results
	// in a paginated response. This value is null if there are no additional pages.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SegmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *SegmentsResponse) SetItem(v []*SegmentResponse) *SegmentsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SegmentsResponse) SetNextToken(v string) *SegmentsResponse {
	s.NextToken = &v
	return s
}

type SendMessagesInput struct {
	_ struct{} `type:"structure" payload:"MessageRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the objects that define configuration and other settings for a
	// message.
	//
	// MessageRequest is a required field
	MessageRequest *MessageRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendMessagesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.MessageRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageRequest"))
	}
	if s.MessageRequest != nil {
		if err := s.MessageRequest.Validate(); err != nil {
			invalidParams.AddNested("MessageRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SendMessagesInput) SetApplicationId(v string) *SendMessagesInput {
	s.ApplicationId = &v
	return s
}

// SetMessageRequest sets the MessageRequest field's value.
func (s *SendMessagesInput) SetMessageRequest(v *MessageRequest) *SendMessagesInput {
	s.MessageRequest = v
	return s
}

type SendMessagesOutput struct {
	_ struct{} `type:"structure" payload:"MessageResponse"`

	// Provides information about the results of a request to send a message to
	// an endpoint address.
	//
	// MessageResponse is a required field
	MessageResponse *MessageResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessagesOutput) GoString() string {
	return s.String()
}

// SetMessageResponse sets the MessageResponse field's value.
func (s *SendMessagesOutput) SetMessageResponse(v *MessageResponse) *SendMessagesOutput {
	s.MessageResponse = v
	return s
}

// Specifies the configuration and other settings for a message to send to all
// the endpoints that are associated with a list of users.
type SendUsersMessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of custom attribute-value pairs. For a push notification, Amazon Pinpoint
	// adds these attributes to the data.pinpoint object in the body of the notification
	// payload. Amazon Pinpoint also provides these attributes in the events that
	// it generates for users-messages deliveries.
	Context map[string]*string `type:"map"`

	// The message definitions for the default message and any default messages
	// that you defined for specific channels.
	//
	// MessageConfiguration is a required field
	MessageConfiguration *DirectMessageConfiguration `type:"structure" required:"true"`

	// The unique identifier for tracing the message. This identifier is visible
	// to message recipients.
	TraceId *string `type:"string"`

	// A map that associates user IDs with EndpointSendConfiguration objects. You
	// can use an EndpointSendConfiguration object to tailor the message for a user
	// by specifying settings such as content overrides and message variables.
	//
	// Users is a required field
	Users map[string]*EndpointSendConfiguration `type:"map" required:"true"`
}

// String returns the string representation
func (s SendUsersMessageRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessageRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendUsersMessageRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendUsersMessageRequest"}
	if s.MessageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageConfiguration"))
	}
	if s.Users == nil {
		invalidParams.Add(request.NewErrParamRequired("Users"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContext sets the Context field's value.
func (s *SendUsersMessageRequest) SetContext(v map[string]*string) *SendUsersMessageRequest {
	s.Context = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *SendUsersMessageRequest) SetMessageConfiguration(v *DirectMessageConfiguration) *SendUsersMessageRequest {
	s.MessageConfiguration = v
	return s
}

// SetTraceId sets the TraceId field's value.
func (s *SendUsersMessageRequest) SetTraceId(v string) *SendUsersMessageRequest {
	s.TraceId = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *SendUsersMessageRequest) SetUsers(v map[string]*EndpointSendConfiguration) *SendUsersMessageRequest {
	s.Users = v
	return s
}

// Provides information about which users and endpoints a message was sent to.
type SendUsersMessageResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that was used to send the message.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The unique identifier that was assigned to the message request.
	RequestId *string `type:"string"`

	// An object that indicates which endpoints the message was sent to, for each
	// user. The object lists user IDs and, for each user ID, provides the endpoint
	// IDs that the message was sent to. For each endpoint ID, it provides an EndpointMessageResult
	// object.
	Result map[string]map[string]*EndpointMessageResult `type:"map"`
}

// String returns the string representation
func (s SendUsersMessageResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessageResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SendUsersMessageResponse) SetApplicationId(v string) *SendUsersMessageResponse {
	s.ApplicationId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *SendUsersMessageResponse) SetRequestId(v string) *SendUsersMessageResponse {
	s.RequestId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *SendUsersMessageResponse) SetResult(v map[string]map[string]*EndpointMessageResult) *SendUsersMessageResponse {
	s.Result = v
	return s
}

type SendUsersMessagesInput struct {
	_ struct{} `type:"structure" payload:"SendUsersMessageRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a message to send to all
	// the endpoints that are associated with a list of users.
	//
	// SendUsersMessageRequest is a required field
	SendUsersMessageRequest *SendUsersMessageRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendUsersMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendUsersMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendUsersMessagesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SendUsersMessageRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("SendUsersMessageRequest"))
	}
	if s.SendUsersMessageRequest != nil {
		if err := s.SendUsersMessageRequest.Validate(); err != nil {
			invalidParams.AddNested("SendUsersMessageRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SendUsersMessagesInput) SetApplicationId(v string) *SendUsersMessagesInput {
	s.ApplicationId = &v
	return s
}

// SetSendUsersMessageRequest sets the SendUsersMessageRequest field's value.
func (s *SendUsersMessagesInput) SetSendUsersMessageRequest(v *SendUsersMessageRequest) *SendUsersMessagesInput {
	s.SendUsersMessageRequest = v
	return s
}

type SendUsersMessagesOutput struct {
	_ struct{} `type:"structure" payload:"SendUsersMessageResponse"`

	// Provides information about which users and endpoints a message was sent to.
	//
	// SendUsersMessageResponse is a required field
	SendUsersMessageResponse *SendUsersMessageResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendUsersMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessagesOutput) GoString() string {
	return s.String()
}

// SetSendUsersMessageResponse sets the SendUsersMessageResponse field's value.
func (s *SendUsersMessagesOutput) SetSendUsersMessageResponse(v *SendUsersMessageResponse) *SendUsersMessagesOutput {
	s.SendUsersMessageResponse = v
	return s
}

// Provides information about a session.
type Session struct {
	_ struct{} `type:"structure"`

	// The duration of the session, in milliseconds.
	Duration *int64 `type:"integer"`

	// The unique identifier for the session.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time when the session began.
	//
	// StartTimestamp is a required field
	StartTimestamp *string `type:"string" required:"true"`

	// The date and time when the session ended.
	StopTimestamp *string `type:"string"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Session) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Session) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Session"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.StartTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *Session) SetDuration(v int64) *Session {
	s.Duration = &v
	return s
}

// SetId sets the Id field's value.
func (s *Session) SetId(v string) *Session {
	s.Id = &v
	return s
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *Session) SetStartTimestamp(v string) *Session {
	s.StartTimestamp = &v
	return s
}

// SetStopTimestamp sets the StopTimestamp field's value.
func (s *Session) SetStopTimestamp(v string) *Session {
	s.StopTimestamp = &v
	return s
}

// Specifies the dimension type and values for a segment dimension.
type SetDimension struct {
	_ struct{} `type:"structure"`

	// The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints
	// that match the criteria are included in the segment; and, EXCLUSIVE, endpoints
	// that match the criteria are excluded from the segment.
	DimensionType *string `type:"string" enum:"DimensionType"`

	// The criteria values to use for the segment dimension. Depending on the value
	// of the DimensionType property, endpoints are included or excluded from the
	// segment if their values match the criteria values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDimension"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionType sets the DimensionType field's value.
func (s *SetDimension) SetDimensionType(v string) *SetDimension {
	s.DimensionType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SetDimension) SetValues(v []*string) *SetDimension {
	s.Values = v
	return s
}

// Specifies the content of an email message, composed of a subject, a text
// part, and an HTML part.
type SimpleEmail struct {
	_ struct{} `type:"structure"`

	// The body of the email message, in HTML format. We recommend using an HTML
	// part for email clients that support HTML. You can include links, formatted
	// text, and more in an HTML message.
	HtmlPart *SimpleEmailPart `type:"structure"`

	// The subject line, or title, of the email.
	Subject *SimpleEmailPart `type:"structure"`

	// The body of the email message, in text format. We recommend using a text
	// part for email clients that don't support HTML and clients that are connected
	// to high-latency networks, such as mobile devices.
	TextPart *SimpleEmailPart `type:"structure"`
}

// String returns the string representation
func (s SimpleEmail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimpleEmail) GoString() string {
	return s.String()
}

// SetHtmlPart sets the HtmlPart field's value.
func (s *SimpleEmail) SetHtmlPart(v *SimpleEmailPart) *SimpleEmail {
	s.HtmlPart = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *SimpleEmail) SetSubject(v *SimpleEmailPart) *SimpleEmail {
	s.Subject = v
	return s
}

// SetTextPart sets the TextPart field's value.
func (s *SimpleEmail) SetTextPart(v *SimpleEmailPart) *SimpleEmail {
	s.TextPart = v
	return s
}

// Specifies the subject or body of an email message, represented as textual
// email data and the applicable character set.
type SimpleEmailPart struct {
	_ struct{} `type:"structure"`

	// The applicable character set for the message content.
	Charset *string `type:"string"`

	// The textual data of the message content.
	Data *string `type:"string"`
}

// String returns the string representation
func (s SimpleEmailPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimpleEmailPart) GoString() string {
	return s.String()
}

// SetCharset sets the Charset field's value.
func (s *SimpleEmailPart) SetCharset(v string) *SimpleEmailPart {
	s.Charset = &v
	return s
}

// SetData sets the Data field's value.
func (s *SimpleEmailPart) SetData(v string) *SimpleEmailPart {
	s.Data = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure" payload:"TagsModel"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// Specifies the tags (keys and values) for an application, campaign, or segment.
	//
	// TagsModel is a required field
	TagsModel *TagsModel `type:"structure" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagsModel == nil {
		invalidParams.Add(request.NewErrParamRequired("TagsModel"))
	}
	if s.TagsModel != nil {
		if err := s.TagsModel.Validate(); err != nil {
			invalidParams.AddNested("TagsModel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagsModel sets the TagsModel field's value.
func (s *TagResourceInput) SetTagsModel(v *TagsModel) *TagResourceInput {
	s.TagsModel = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Specifies the tags (keys and values) for an application, campaign, or segment.
type TagsModel struct {
	_ struct{} `type:"structure"`

	// A string-to-string map of key-value pairs that defines the tags for an application,
	// campaign, or segment. A project, campaign, or segment can have a maximum
	// of 50 tags.
	//
	// Each tag consists of a required tag key and an associated tag value. The
	// maximum length of a tag key is 128 characters. The maximum length of a tag
	// value is 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagsModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagsModel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagsModel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagsModel"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *TagsModel) SetTags(v map[string]*string) *TagsModel {
	s.Tags = v
	return s
}

// Specifies the settings for a campaign treatment. A treatment is a variation
// of a campaign that's used for A/B testing of a campaign.
type TreatmentResource struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the treatment.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The message configuration settings for the treatment.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The schedule settings for the treatment.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users (segment members) that the treatment is
	// sent to.
	//
	// SizePercent is a required field
	SizePercent *int64 `type:"integer" required:"true"`

	// The status of the treatment.
	State *CampaignState `type:"structure"`

	// The custom description of the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of the treatment. A treatment is a variation of a campaign
	// that's used for A/B testing of a campaign.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s TreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TreatmentResource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TreatmentResource) SetId(v string) *TreatmentResource {
	s.Id = &v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *TreatmentResource) SetMessageConfiguration(v *MessageConfiguration) *TreatmentResource {
	s.MessageConfiguration = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *TreatmentResource) SetSchedule(v *Schedule) *TreatmentResource {
	s.Schedule = v
	return s
}

// SetSizePercent sets the SizePercent field's value.
func (s *TreatmentResource) SetSizePercent(v int64) *TreatmentResource {
	s.SizePercent = &v
	return s
}

// SetState sets the State field's value.
func (s *TreatmentResource) SetState(v *CampaignState) *TreatmentResource {
	s.State = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *TreatmentResource) SetTreatmentDescription(v string) *TreatmentResource {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *TreatmentResource) SetTreatmentName(v string) *TreatmentResource {
	s.TreatmentName = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAdmChannelInput struct {
	_ struct{} `type:"structure" payload:"ADMChannelRequest"`

	// Specifies the status and settings of the ADM (Amazon Device Messaging) channel
	// for an application.
	//
	// ADMChannelRequest is a required field
	ADMChannelRequest *ADMChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAdmChannelInput"}
	if s.ADMChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ADMChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.ADMChannelRequest != nil {
		if err := s.ADMChannelRequest.Validate(); err != nil {
			invalidParams.AddNested("ADMChannelRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetADMChannelRequest sets the ADMChannelRequest field's value.
func (s *UpdateAdmChannelInput) SetADMChannelRequest(v *ADMChannelRequest) *UpdateAdmChannelInput {
	s.ADMChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateAdmChannelInput) SetApplicationId(v string) *UpdateAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Provides information about the status and settings of the ADM (Amazon Device
	// Messaging) channel for an application.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *UpdateAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *UpdateAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type UpdateApnsChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSChannelRequest"`

	// Specifies the status and settings of the APNs (Apple Push Notification service)
	// channel for an application.
	//
	// APNSChannelRequest is a required field
	APNSChannelRequest *APNSChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsChannelInput"}
	if s.APNSChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSChannelRequest sets the APNSChannelRequest field's value.
func (s *UpdateApnsChannelInput) SetAPNSChannelRequest(v *APNSChannelRequest) *UpdateApnsChannelInput {
	s.APNSChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsChannelInput) SetApplicationId(v string) *UpdateApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *UpdateApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *UpdateApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type UpdateApnsSandboxChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelRequest"`

	// Specifies the status and settings of the APNs (Apple Push Notification service)
	// sandbox channel for an application.
	//
	// APNSSandboxChannelRequest is a required field
	APNSSandboxChannelRequest *APNSSandboxChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsSandboxChannelInput"}
	if s.APNSSandboxChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSSandboxChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSSandboxChannelRequest sets the APNSSandboxChannelRequest field's value.
func (s *UpdateApnsSandboxChannelInput) SetAPNSSandboxChannelRequest(v *APNSSandboxChannelRequest) *UpdateApnsSandboxChannelInput {
	s.APNSSandboxChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsSandboxChannelInput) SetApplicationId(v string) *UpdateApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) sandbox channel for an application.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *UpdateApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *UpdateApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type UpdateApnsVoipChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelRequest"`

	// Specifies the status and settings of the APNs (Apple Push Notification service)
	// VoIP channel for an application.
	//
	// APNSVoipChannelRequest is a required field
	APNSVoipChannelRequest *APNSVoipChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsVoipChannelInput"}
	if s.APNSVoipChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSVoipChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSVoipChannelRequest sets the APNSVoipChannelRequest field's value.
func (s *UpdateApnsVoipChannelInput) SetAPNSVoipChannelRequest(v *APNSVoipChannelRequest) *UpdateApnsVoipChannelInput {
	s.APNSVoipChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsVoipChannelInput) SetApplicationId(v string) *UpdateApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP channel for an application.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *UpdateApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *UpdateApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type UpdateApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelRequest"`

	// Specifies the status and settings of the APNs (Apple Push Notification service)
	// VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelRequest is a required field
	APNSVoipSandboxChannelRequest *APNSVoipSandboxChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsVoipSandboxChannelInput"}
	if s.APNSVoipSandboxChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSVoipSandboxChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSVoipSandboxChannelRequest sets the APNSVoipSandboxChannelRequest field's value.
func (s *UpdateApnsVoipSandboxChannelInput) SetAPNSVoipSandboxChannelRequest(v *APNSVoipSandboxChannelRequest) *UpdateApnsVoipSandboxChannelInput {
	s.APNSVoipSandboxChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsVoipSandboxChannelInput) SetApplicationId(v string) *UpdateApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) VoIP sandbox channel for an application.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *UpdateApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *UpdateApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type UpdateApplicationSettingsInput struct {
	_ struct{} `type:"structure" payload:"WriteApplicationSettingsRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the default settings for an application.
	//
	// WriteApplicationSettingsRequest is a required field
	WriteApplicationSettingsRequest *WriteApplicationSettingsRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.WriteApplicationSettingsRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteApplicationSettingsRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationSettingsInput) SetApplicationId(v string) *UpdateApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

// SetWriteApplicationSettingsRequest sets the WriteApplicationSettingsRequest field's value.
func (s *UpdateApplicationSettingsInput) SetWriteApplicationSettingsRequest(v *WriteApplicationSettingsRequest) *UpdateApplicationSettingsInput {
	s.WriteApplicationSettingsRequest = v
	return s
}

type UpdateApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// Provides information about an application, including the default settings
	// for an application.
	//
	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *UpdateApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *UpdateApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

// Specifies one or more attributes to remove from all the endpoints that are
// associated with an application.
type UpdateAttributesRequest struct {
	_ struct{} `type:"structure"`

	// An array of the attributes to remove from all the endpoints that are associated
	// with the application. The array can specify the complete, exact name of each
	// attribute to remove or it can specify a glob pattern that an attribute name
	// must match in order for the attribute to be removed.
	Blacklist []*string `type:"list"`
}

// String returns the string representation
func (s UpdateAttributesRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAttributesRequest) GoString() string {
	return s.String()
}

// SetBlacklist sets the Blacklist field's value.
func (s *UpdateAttributesRequest) SetBlacklist(v []*string) *UpdateAttributesRequest {
	s.Blacklist = v
	return s
}

type UpdateBaiduChannelInput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the status and settings of the Baidu (Baidu Cloud Push) channel
	// for an application.
	//
	// BaiduChannelRequest is a required field
	BaiduChannelRequest *BaiduChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.BaiduChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("BaiduChannelRequest"))
	}
	if s.BaiduChannelRequest != nil {
		if err := s.BaiduChannelRequest.Validate(); err != nil {
			invalidParams.AddNested("BaiduChannelRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateBaiduChannelInput) SetApplicationId(v string) *UpdateBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

// SetBaiduChannelRequest sets the BaiduChannelRequest field's value.
func (s *UpdateBaiduChannelInput) SetBaiduChannelRequest(v *BaiduChannelRequest) *UpdateBaiduChannelInput {
	s.BaiduChannelRequest = v
	return s
}

type UpdateBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Provides information about the status and settings of the Baidu (Baidu Cloud
	// Push) channel for an application.
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *UpdateBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *UpdateBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type UpdateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Specifies the configuration and other settings for a campaign.
	//
	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}
	if s.WriteCampaignRequest != nil {
		if err := s.WriteCampaignRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteCampaignRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateCampaignInput) SetApplicationId(v string) *UpdateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *UpdateCampaignInput) SetCampaignId(v string) *UpdateCampaignInput {
	s.CampaignId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *UpdateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *UpdateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

type UpdateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Provides information about the status, configuration, and other settings
	// for a campaign.
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *UpdateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *UpdateCampaignOutput {
	s.CampaignResponse = v
	return s
}

type UpdateEmailChannelInput struct {
	_ struct{} `type:"structure" payload:"EmailChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the status and settings of the email channel for an application.
	//
	// EmailChannelRequest is a required field
	EmailChannelRequest *EmailChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EmailChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailChannelRequest"))
	}
	if s.EmailChannelRequest != nil {
		if err := s.EmailChannelRequest.Validate(); err != nil {
			invalidParams.AddNested("EmailChannelRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEmailChannelInput) SetApplicationId(v string) *UpdateEmailChannelInput {
	s.ApplicationId = &v
	return s
}

// SetEmailChannelRequest sets the EmailChannelRequest field's value.
func (s *UpdateEmailChannelInput) SetEmailChannelRequest(v *EmailChannelRequest) *UpdateEmailChannelInput {
	s.EmailChannelRequest = v
	return s
}

type UpdateEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Provides information about the status and settings of the email channel for
	// an application.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *UpdateEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *UpdateEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type UpdateEndpointInput struct {
	_ struct{} `type:"structure" payload:"EndpointRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`

	// Specifies the channel type and other settings for an endpoint.
	//
	// EndpointRequest is a required field
	EndpointRequest *EndpointRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}
	if s.EndpointRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEndpointInput) SetApplicationId(v string) *UpdateEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *UpdateEndpointInput) SetEndpointId(v string) *UpdateEndpointInput {
	s.EndpointId = &v
	return s
}

// SetEndpointRequest sets the EndpointRequest field's value.
func (s *UpdateEndpointInput) SetEndpointRequest(v *EndpointRequest) *UpdateEndpointInput {
	s.EndpointRequest = v
	return s
}

type UpdateEndpointOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *UpdateEndpointOutput) SetMessageBody(v *MessageBody) *UpdateEndpointOutput {
	s.MessageBody = v
	return s
}

type UpdateEndpointsBatchInput struct {
	_ struct{} `type:"structure" payload:"EndpointBatchRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies a batch of endpoints to create or update and the settings and attributes
	// to set or change for each endpoint.
	//
	// EndpointBatchRequest is a required field
	EndpointBatchRequest *EndpointBatchRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointsBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointsBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointsBatchInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.EndpointBatchRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointBatchRequest"))
	}
	if s.EndpointBatchRequest != nil {
		if err := s.EndpointBatchRequest.Validate(); err != nil {
			invalidParams.AddNested("EndpointBatchRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEndpointsBatchInput) SetApplicationId(v string) *UpdateEndpointsBatchInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointBatchRequest sets the EndpointBatchRequest field's value.
func (s *UpdateEndpointsBatchInput) SetEndpointBatchRequest(v *EndpointBatchRequest) *UpdateEndpointsBatchInput {
	s.EndpointBatchRequest = v
	return s
}

type UpdateEndpointsBatchOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Provides information about an API request or response.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointsBatchOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *UpdateEndpointsBatchOutput) SetMessageBody(v *MessageBody) *UpdateEndpointsBatchOutput {
	s.MessageBody = v
	return s
}

type UpdateGcmChannelInput struct {
	_ struct{} `type:"structure" payload:"GCMChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the status and settings of the GCM channel for an application.
	// This channel enables Amazon Pinpoint to send push notifications through the
	// Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
	//
	// GCMChannelRequest is a required field
	GCMChannelRequest *GCMChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.GCMChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("GCMChannelRequest"))
	}
	if s.GCMChannelRequest != nil {
		if err := s.GCMChannelRequest.Validate(); err != nil {
			invalidParams.AddNested("GCMChannelRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateGcmChannelInput) SetApplicationId(v string) *UpdateGcmChannelInput {
	s.ApplicationId = &v
	return s
}

// SetGCMChannelRequest sets the GCMChannelRequest field's value.
func (s *UpdateGcmChannelInput) SetGCMChannelRequest(v *GCMChannelRequest) *UpdateGcmChannelInput {
	s.GCMChannelRequest = v
	return s
}

type UpdateGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Provides information about the status and settings of the GCM channel for
	// an application. The GCM channel enables Amazon Pinpoint to send push notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service.
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *UpdateGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *UpdateGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type UpdateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Specifies the configuration, dimension, and other settings for a segment.
	// A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups
	// object, but not both.
	//
	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.SegmentId != nil && len(*s.SegmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentId", 1))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}
	if s.WriteSegmentRequest != nil {
		if err := s.WriteSegmentRequest.Validate(); err != nil {
			invalidParams.AddNested("WriteSegmentRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateSegmentInput) SetApplicationId(v string) *UpdateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *UpdateSegmentInput) SetSegmentId(v string) *UpdateSegmentInput {
	s.SegmentId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *UpdateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *UpdateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

type UpdateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Provides information about the configuration, dimension, and other settings
	// for a segment.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *UpdateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *UpdateSegmentOutput {
	s.SegmentResponse = v
	return s
}

type UpdateSmsChannelInput struct {
	_ struct{} `type:"structure" payload:"SMSChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the status and settings of the SMS channel for an application.
	//
	// SMSChannelRequest is a required field
	SMSChannelRequest *SMSChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.SMSChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("SMSChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateSmsChannelInput) SetApplicationId(v string) *UpdateSmsChannelInput {
	s.ApplicationId = &v
	return s
}

// SetSMSChannelRequest sets the SMSChannelRequest field's value.
func (s *UpdateSmsChannelInput) SetSMSChannelRequest(v *SMSChannelRequest) *UpdateSmsChannelInput {
	s.SMSChannelRequest = v
	return s
}

type UpdateSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// Provides information about the status and settings of the SMS channel for
	// an application.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *UpdateSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *UpdateSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

type UpdateVoiceChannelInput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the status and settings of the voice channel for an application.
	//
	// VoiceChannelRequest is a required field
	VoiceChannelRequest *VoiceChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateVoiceChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVoiceChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVoiceChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVoiceChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.VoiceChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateVoiceChannelInput) SetApplicationId(v string) *UpdateVoiceChannelInput {
	s.ApplicationId = &v
	return s
}

// SetVoiceChannelRequest sets the VoiceChannelRequest field's value.
func (s *UpdateVoiceChannelInput) SetVoiceChannelRequest(v *VoiceChannelRequest) *UpdateVoiceChannelInput {
	s.VoiceChannelRequest = v
	return s
}

type UpdateVoiceChannelOutput struct {
	_ struct{} `type:"structure" payload:"VoiceChannelResponse"`

	// Provides information about the status and settings of the voice channel for
	// an application.
	//
	// VoiceChannelResponse is a required field
	VoiceChannelResponse *VoiceChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateVoiceChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVoiceChannelOutput) GoString() string {
	return s.String()
}

// SetVoiceChannelResponse sets the VoiceChannelResponse field's value.
func (s *UpdateVoiceChannelOutput) SetVoiceChannelResponse(v *VoiceChannelResponse) *UpdateVoiceChannelOutput {
	s.VoiceChannelResponse = v
	return s
}

// Specifies the status and settings of the voice channel for an application.
type VoiceChannelRequest struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the voice channel for the application.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s VoiceChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceChannelRequest) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *VoiceChannelRequest) SetEnabled(v bool) *VoiceChannelRequest {
	s.Enabled = &v
	return s
}

// Provides information about the status and settings of the voice channel for
// an application.
type VoiceChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the application that the voice channel applies
	// to.
	ApplicationId *string `type:"string"`

	// The date and time, in ISO 8601 format, when the voice channel was enabled.
	CreationDate *string `type:"string"`

	// Specifies whether the voice channel is enabled for the application.
	Enabled *bool `type:"boolean"`

	// (Not used) This property is retained only for backward compatibility.
	HasCredential *bool `type:"boolean"`

	// (Deprecated) An identifier for the voice channel. This property is retained
	// only for backward compatibility.
	Id *string `type:"string"`

	// Specifies whether the voice channel is archived.
	IsArchived *bool `type:"boolean"`

	// The user who last modified the voice channel.
	LastModifiedBy *string `type:"string"`

	// The date and time, in ISO 8601 format, when the voice channel was last modified.
	LastModifiedDate *string `type:"string"`

	OriginationNumber *string `type:"string"`

	// The type of messaging or notification platform for the channel. For the voice
	// channel, this value is VOICE.
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`

	// The current version of the voice channel.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s VoiceChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *VoiceChannelResponse) SetApplicationId(v string) *VoiceChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *VoiceChannelResponse) SetCreationDate(v string) *VoiceChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *VoiceChannelResponse) SetEnabled(v bool) *VoiceChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *VoiceChannelResponse) SetHasCredential(v bool) *VoiceChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *VoiceChannelResponse) SetId(v string) *VoiceChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *VoiceChannelResponse) SetIsArchived(v bool) *VoiceChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *VoiceChannelResponse) SetLastModifiedBy(v string) *VoiceChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *VoiceChannelResponse) SetLastModifiedDate(v string) *VoiceChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetOriginationNumber sets the OriginationNumber field's value.
func (s *VoiceChannelResponse) SetOriginationNumber(v string) *VoiceChannelResponse {
	s.OriginationNumber = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *VoiceChannelResponse) SetPlatform(v string) *VoiceChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *VoiceChannelResponse) SetVersion(v int64) *VoiceChannelResponse {
	s.Version = &v
	return s
}

// Specifies the settings for a one-time voice message that's sent directly
// to an endpoint through the voice channel.
type VoiceMessage struct {
	_ struct{} `type:"structure"`

	// The text script for the voice message.
	Body *string `type:"string"`

	// The language to use when delivering the message. For a list of supported
	// languages, see the Amazon Polly Developer Guide (AmazonPollyDG.html).
	LanguageCode *string `type:"string"`

	// The phone number from the pool or messaging service to send the message from.
	// Although it isn't required, we recommend that you specify the phone number
	// in E.164 format to ensure prompt and accurate delivery.
	OriginationNumber *string `type:"string"`

	// The default message variables to use in the voice message. You can override
	// the default variables with individual address variables.
	Substitutions map[string][]*string `type:"map"`

	// The name of the voice to use when delivering the message. For a list of supported
	// voices, see the Amazon Polly Developer Guide (AmazonPollyDG.html).
	VoiceId *string `type:"string"`
}

// String returns the string representation
func (s VoiceMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *VoiceMessage) SetBody(v string) *VoiceMessage {
	s.Body = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VoiceMessage) SetLanguageCode(v string) *VoiceMessage {
	s.LanguageCode = &v
	return s
}

// SetOriginationNumber sets the OriginationNumber field's value.
func (s *VoiceMessage) SetOriginationNumber(v string) *VoiceMessage {
	s.OriginationNumber = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *VoiceMessage) SetSubstitutions(v map[string][]*string) *VoiceMessage {
	s.Substitutions = v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *VoiceMessage) SetVoiceId(v string) *VoiceMessage {
	s.VoiceId = &v
	return s
}

// Specifies the default settings for an application.
type WriteApplicationSettingsRequest struct {
	_ struct{} `type:"structure"`

	// The settings for the AWS Lambda function to use by default as a code hook
	// for campaigns in the application. To override these settings for a specific
	// campaign, use the Campaign resource to define custom Lambda function settings
	// for the campaign.
	CampaignHook *CampaignHook `type:"structure"`

	// Specifies whether to enable application-related alarms in Amazon CloudWatch.
	CloudWatchMetricsEnabled *bool `type:"boolean"`

	// The default sending limits for campaigns in the application. To override
	// these limits for a specific campaign, use the Campaign resource to define
	// custom limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for campaigns in the application. Quiet time is a
	// specific time range when campaigns don't send messages to endpoints, if all
	// the following conditions are met:
	//
	//    * The EndpointDemographic.Timezone property of the endpoint is set to
	//    a valid value.
	//
	//    * The current time in the endpoint's time zone is later than or equal
	//    to the time specified by the QuietTime.Start property for the application
	//    (or a campaign that has custom quiet time settings).
	//
	//    * The current time in the endpoint's time zone is earlier than or equal
	//    to the time specified by the QuietTime.End property for the application
	//    (or a campaign that has custom quiet time settings).
	//
	// If any of the preceding conditions isn't met, the endpoint will receive messages
	// from a campaign, even if quiet time is enabled.
	//
	// To override the default quiet time settings for a specific campaign, use
	// the Campaign resource to define a custom quiet time for the campaign.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s WriteApplicationSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteApplicationSettingsRequest) GoString() string {
	return s.String()
}

// SetCampaignHook sets the CampaignHook field's value.
func (s *WriteApplicationSettingsRequest) SetCampaignHook(v *CampaignHook) *WriteApplicationSettingsRequest {
	s.CampaignHook = v
	return s
}

// SetCloudWatchMetricsEnabled sets the CloudWatchMetricsEnabled field's value.
func (s *WriteApplicationSettingsRequest) SetCloudWatchMetricsEnabled(v bool) *WriteApplicationSettingsRequest {
	s.CloudWatchMetricsEnabled = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *WriteApplicationSettingsRequest) SetLimits(v *CampaignLimits) *WriteApplicationSettingsRequest {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *WriteApplicationSettingsRequest) SetQuietTime(v *QuietTime) *WriteApplicationSettingsRequest {
	s.QuietTime = v
	return s
}

// Specifies the configuration and other settings for a campaign.
type WriteCampaignRequest struct {
	_ struct{} `type:"structure"`

	// An array of requests that defines additional treatments for the campaign,
	// in addition to the default treatment for the campaign.
	AdditionalTreatments []*WriteTreatmentResource `type:"list"`

	// The custom description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of users (segment members) who shouldn't receive
	// messages from the campaign.
	HoldoutPercent *int64 `type:"integer"`

	// The settings for the AWS Lambda function to use as a code hook for the campaign.
	Hook *CampaignHook `type:"structure"`

	// Specifies whether to pause the campaign. A paused campaign doesn't run unless
	// you resume it by setting this value to false.
	IsPaused *bool `type:"boolean"`

	// The messaging limits for the campaign.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings for the campaign.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The schedule settings for the campaign.
	Schedule *Schedule `type:"structure"`

	// The unique identifier for the segment to associate with the campaign.
	SegmentId *string `type:"string"`

	// The version of the segment to associate with the campaign.
	SegmentVersion *int64 `type:"integer"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the campaign. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The custom description of a variation of the campaign to use for A/B testing.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign to use for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteCampaignRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteCampaignRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteCampaignRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteCampaignRequest"}
	if s.AdditionalTreatments != nil {
		for i, v := range s.AdditionalTreatments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AdditionalTreatments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MessageConfiguration != nil {
		if err := s.MessageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MessageConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *WriteCampaignRequest) SetAdditionalTreatments(v []*WriteTreatmentResource) *WriteCampaignRequest {
	s.AdditionalTreatments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WriteCampaignRequest) SetDescription(v string) *WriteCampaignRequest {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *WriteCampaignRequest) SetHoldoutPercent(v int64) *WriteCampaignRequest {
	s.HoldoutPercent = &v
	return s
}

// SetHook sets the Hook field's value.
func (s *WriteCampaignRequest) SetHook(v *CampaignHook) *WriteCampaignRequest {
	s.Hook = v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *WriteCampaignRequest) SetIsPaused(v bool) *WriteCampaignRequest {
	s.IsPaused = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *WriteCampaignRequest) SetLimits(v *CampaignLimits) *WriteCampaignRequest {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *WriteCampaignRequest) SetMessageConfiguration(v *MessageConfiguration) *WriteCampaignRequest {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *WriteCampaignRequest) SetName(v string) *WriteCampaignRequest {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *WriteCampaignRequest) SetSchedule(v *Schedule) *WriteCampaignRequest {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *WriteCampaignRequest) SetSegmentId(v string) *WriteCampaignRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *WriteCampaignRequest) SetSegmentVersion(v int64) *WriteCampaignRequest {
	s.SegmentVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WriteCampaignRequest) SetTags(v map[string]*string) *WriteCampaignRequest {
	s.Tags = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *WriteCampaignRequest) SetTreatmentDescription(v string) *WriteCampaignRequest {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *WriteCampaignRequest) SetTreatmentName(v string) *WriteCampaignRequest {
	s.TreatmentName = &v
	return s
}

// Specifies the Amazon Resource Name (ARN) of an event stream to publish events
// to and the AWS Identity and Access Management (IAM) role to use when publishing
// those events.
type WriteEventStream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon
	// Kinesis Data Firehose delivery stream that you want to publish event data
	// to.
	//
	// For a Kinesis data stream, the ARN format is: arn:aws:kinesis:region:account-id:stream/stream_name
	//
	// For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:region:account-id:deliverystream/stream_name
	//
	// DestinationStreamArn is a required field
	DestinationStreamArn *string `type:"string" required:"true"`

	// The AWS Identity and Access Management (IAM) role that authorizes Amazon
	// Pinpoint to publish event data to the stream in your AWS account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s WriteEventStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteEventStream) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteEventStream) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteEventStream"}
	if s.DestinationStreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationStreamArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationStreamArn sets the DestinationStreamArn field's value.
func (s *WriteEventStream) SetDestinationStreamArn(v string) *WriteEventStream {
	s.DestinationStreamArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *WriteEventStream) SetRoleArn(v string) *WriteEventStream {
	s.RoleArn = &v
	return s
}

// Specifies the configuration, dimension, and other settings for a segment.
// A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups
// object, but not both.
type WriteSegmentRequest struct {
	_ struct{} `type:"structure"`

	// The criteria that define the dimensions for the segment.
	Dimensions *SegmentDimensions `type:"structure"`

	// The name of the segment.
	Name *string `type:"string"`

	// The segment group to use and the dimensions to apply to the group's base
	// segments in order to build the segment. A segment group can consist of zero
	// or more base segments. Your request can include only one segment group.
	SegmentGroups *SegmentGroupList `type:"structure"`

	// A string-to-string map of key-value pairs that defines the tags to associate
	// with the segment. Each tag consists of a required tag key and an associated
	// tag value.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s WriteSegmentRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteSegmentRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteSegmentRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteSegmentRequest"}
	if s.Dimensions != nil {
		if err := s.Dimensions.Validate(); err != nil {
			invalidParams.AddNested("Dimensions", err.(request.ErrInvalidParams))
		}
	}
	if s.SegmentGroups != nil {
		if err := s.SegmentGroups.Validate(); err != nil {
			invalidParams.AddNested("SegmentGroups", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *WriteSegmentRequest) SetDimensions(v *SegmentDimensions) *WriteSegmentRequest {
	s.Dimensions = v
	return s
}

// SetName sets the Name field's value.
func (s *WriteSegmentRequest) SetName(v string) *WriteSegmentRequest {
	s.Name = &v
	return s
}

// SetSegmentGroups sets the SegmentGroups field's value.
func (s *WriteSegmentRequest) SetSegmentGroups(v *SegmentGroupList) *WriteSegmentRequest {
	s.SegmentGroups = v
	return s
}

// SetTags sets the Tags field's value.
func (s *WriteSegmentRequest) SetTags(v map[string]*string) *WriteSegmentRequest {
	s.Tags = v
	return s
}

// Specifies the settings for a campaign treatment. A treatment is a variation
// of a campaign that's used for A/B testing of a campaign.
type WriteTreatmentResource struct {
	_ struct{} `type:"structure"`

	// The message configuration settings for the treatment.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The schedule settings for the treatment.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users (segment members) to send the treatment
	// to.
	//
	// SizePercent is a required field
	SizePercent *int64 `type:"integer" required:"true"`

	// The custom description of the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of the treatment. A treatment is a variation of a campaign
	// that's used for A/B testing of a campaign.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteTreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteTreatmentResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WriteTreatmentResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WriteTreatmentResource"}
	if s.SizePercent == nil {
		invalidParams.Add(request.NewErrParamRequired("SizePercent"))
	}
	if s.MessageConfiguration != nil {
		if err := s.MessageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MessageConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *WriteTreatmentResource) SetMessageConfiguration(v *MessageConfiguration) *WriteTreatmentResource {
	s.MessageConfiguration = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *WriteTreatmentResource) SetSchedule(v *Schedule) *WriteTreatmentResource {
	s.Schedule = v
	return s
}

// SetSizePercent sets the SizePercent field's value.
func (s *WriteTreatmentResource) SetSizePercent(v int64) *WriteTreatmentResource {
	s.SizePercent = &v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *WriteTreatmentResource) SetTreatmentDescription(v string) *WriteTreatmentResource {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *WriteTreatmentResource) SetTreatmentName(v string) *WriteTreatmentResource {
	s.TreatmentName = &v
	return s
}

const (
	// ActionOpenApp is a Action enum value
	ActionOpenApp = "OPEN_APP"

	// ActionDeepLink is a Action enum value
	ActionDeepLink = "DEEP_LINK"

	// ActionUrl is a Action enum value
	ActionUrl = "URL"
)

const (
	// AttributeTypeInclusive is a AttributeType enum value
	AttributeTypeInclusive = "INCLUSIVE"

	// AttributeTypeExclusive is a AttributeType enum value
	AttributeTypeExclusive = "EXCLUSIVE"
)

const (
	// CampaignStatusScheduled is a CampaignStatus enum value
	CampaignStatusScheduled = "SCHEDULED"

	// CampaignStatusExecuting is a CampaignStatus enum value
	CampaignStatusExecuting = "EXECUTING"

	// CampaignStatusPendingNextRun is a CampaignStatus enum value
	CampaignStatusPendingNextRun = "PENDING_NEXT_RUN"

	// CampaignStatusCompleted is a CampaignStatus enum value
	CampaignStatusCompleted = "COMPLETED"

	// CampaignStatusPaused is a CampaignStatus enum value
	CampaignStatusPaused = "PAUSED"

	// CampaignStatusDeleted is a CampaignStatus enum value
	CampaignStatusDeleted = "DELETED"
)

const (
	// ChannelTypeGcm is a ChannelType enum value
	ChannelTypeGcm = "GCM"

	// ChannelTypeApns is a ChannelType enum value
	ChannelTypeApns = "APNS"

	// ChannelTypeApnsSandbox is a ChannelType enum value
	ChannelTypeApnsSandbox = "APNS_SANDBOX"

	// ChannelTypeApnsVoip is a ChannelType enum value
	ChannelTypeApnsVoip = "APNS_VOIP"

	// ChannelTypeApnsVoipSandbox is a ChannelType enum value
	ChannelTypeApnsVoipSandbox = "APNS_VOIP_SANDBOX"

	// ChannelTypeAdm is a ChannelType enum value
	ChannelTypeAdm = "ADM"

	// ChannelTypeSms is a ChannelType enum value
	ChannelTypeSms = "SMS"

	// ChannelTypeVoice is a ChannelType enum value
	ChannelTypeVoice = "VOICE"

	// ChannelTypeEmail is a ChannelType enum value
	ChannelTypeEmail = "EMAIL"

	// ChannelTypeBaidu is a ChannelType enum value
	ChannelTypeBaidu = "BAIDU"

	// ChannelTypeCustom is a ChannelType enum value
	ChannelTypeCustom = "CUSTOM"
)

const (
	// DeliveryStatusSuccessful is a DeliveryStatus enum value
	DeliveryStatusSuccessful = "SUCCESSFUL"

	// DeliveryStatusThrottled is a DeliveryStatus enum value
	DeliveryStatusThrottled = "THROTTLED"

	// DeliveryStatusTemporaryFailure is a DeliveryStatus enum value
	DeliveryStatusTemporaryFailure = "TEMPORARY_FAILURE"

	// DeliveryStatusPermanentFailure is a DeliveryStatus enum value
	DeliveryStatusPermanentFailure = "PERMANENT_FAILURE"

	// DeliveryStatusUnknownFailure is a DeliveryStatus enum value
	DeliveryStatusUnknownFailure = "UNKNOWN_FAILURE"

	// DeliveryStatusOptOut is a DeliveryStatus enum value
	DeliveryStatusOptOut = "OPT_OUT"

	// DeliveryStatusDuplicate is a DeliveryStatus enum value
	DeliveryStatusDuplicate = "DUPLICATE"
)

const (
	// DimensionTypeInclusive is a DimensionType enum value
	DimensionTypeInclusive = "INCLUSIVE"

	// DimensionTypeExclusive is a DimensionType enum value
	DimensionTypeExclusive = "EXCLUSIVE"
)

const (
	// DurationHr24 is a Duration enum value
	DurationHr24 = "HR_24"

	// DurationDay7 is a Duration enum value
	DurationDay7 = "DAY_7"

	// DurationDay14 is a Duration enum value
	DurationDay14 = "DAY_14"

	// DurationDay30 is a Duration enum value
	DurationDay30 = "DAY_30"
)

const (
	// FilterTypeSystem is a FilterType enum value
	FilterTypeSystem = "SYSTEM"

	// FilterTypeEndpoint is a FilterType enum value
	FilterTypeEndpoint = "ENDPOINT"
)

const (
	// FormatCsv is a Format enum value
	FormatCsv = "CSV"

	// FormatJson is a Format enum value
	FormatJson = "JSON"
)

const (
	// FrequencyOnce is a Frequency enum value
	FrequencyOnce = "ONCE"

	// FrequencyHourly is a Frequency enum value
	FrequencyHourly = "HOURLY"

	// FrequencyDaily is a Frequency enum value
	FrequencyDaily = "DAILY"

	// FrequencyWeekly is a Frequency enum value
	FrequencyWeekly = "WEEKLY"

	// FrequencyMonthly is a Frequency enum value
	FrequencyMonthly = "MONTHLY"

	// FrequencyEvent is a Frequency enum value
	FrequencyEvent = "EVENT"
)

const (
	// IncludeAll is a Include enum value
	IncludeAll = "ALL"

	// IncludeAny is a Include enum value
	IncludeAny = "ANY"

	// IncludeNone is a Include enum value
	IncludeNone = "NONE"
)

const (
	// JobStatusCreated is a JobStatus enum value
	JobStatusCreated = "CREATED"

	// JobStatusInitializing is a JobStatus enum value
	JobStatusInitializing = "INITIALIZING"

	// JobStatusProcessing is a JobStatus enum value
	JobStatusProcessing = "PROCESSING"

	// JobStatusCompleting is a JobStatus enum value
	JobStatusCompleting = "COMPLETING"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailing is a JobStatus enum value
	JobStatusFailing = "FAILING"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

const (
	// MessageTypeTransactional is a MessageType enum value
	MessageTypeTransactional = "TRANSACTIONAL"

	// MessageTypePromotional is a MessageType enum value
	MessageTypePromotional = "PROMOTIONAL"
)

const (
	// ModeDelivery is a Mode enum value
	ModeDelivery = "DELIVERY"

	// ModeFilter is a Mode enum value
	ModeFilter = "FILTER"
)

const (
	// RecencyTypeActive is a RecencyType enum value
	RecencyTypeActive = "ACTIVE"

	// RecencyTypeInactive is a RecencyType enum value
	RecencyTypeInactive = "INACTIVE"
)

const (
	// SegmentTypeDimensional is a SegmentType enum value
	SegmentTypeDimensional = "DIMENSIONAL"

	// SegmentTypeImport is a SegmentType enum value
	SegmentTypeImport = "IMPORT"
)

const (
	// SourceTypeAll is a SourceType enum value
	SourceTypeAll = "ALL"

	// SourceTypeAny is a SourceType enum value
	SourceTypeAny = "ANY"

	// SourceTypeNone is a SourceType enum value
	SourceTypeNone = "NONE"
)

const (
	// TypeAll is a Type enum value
	TypeAll = "ALL"

	// TypeAny is a Type enum value
	TypeAny = "ANY"

	// TypeNone is a Type enum value
	TypeNone = "NONE"
)
