// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package signer

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelSigningProfile = "CancelSigningProfile"

// CancelSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the CancelSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSigningProfile for more information on using the CancelSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSigningProfileRequest method.
//    req, resp := client.CancelSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/CancelSigningProfile
func (c *Signer) CancelSigningProfileRequest(input *CancelSigningProfileInput) (req *request.Request, output *CancelSigningProfileOutput) {
	op := &request.Operation{
		Name:       opCancelSigningProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/signing-profiles/{profileName}",
	}

	if input == nil {
		input = &CancelSigningProfileInput{}
	}

	output = &CancelSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelSigningProfile API operation for AWS Signer.
//
// Changes the state of an ACTIVE signing profile to CANCELED. A canceled profile
// is still viewable with the ListSigningProfiles operation, but it cannot perform
// new signing jobs, and is deleted two years after cancelation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation CancelSigningProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/CancelSigningProfile
func (c *Signer) CancelSigningProfile(input *CancelSigningProfileInput) (*CancelSigningProfileOutput, error) {
	req, out := c.CancelSigningProfileRequest(input)
	return out, req.Send()
}

// CancelSigningProfileWithContext is the same as CancelSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) CancelSigningProfileWithContext(ctx aws.Context, input *CancelSigningProfileInput, opts ...request.Option) (*CancelSigningProfileOutput, error) {
	req, out := c.CancelSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSigningJob = "DescribeSigningJob"

// DescribeSigningJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSigningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSigningJob for more information on using the DescribeSigningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSigningJobRequest method.
//    req, resp := client.DescribeSigningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/DescribeSigningJob
func (c *Signer) DescribeSigningJobRequest(input *DescribeSigningJobInput) (req *request.Request, output *DescribeSigningJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSigningJob,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeSigningJobInput{}
	}

	output = &DescribeSigningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSigningJob API operation for AWS Signer.
//
// Returns information about a specific code signing job. You specify the job
// by using the jobId value that is returned by the StartSigningJob operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation DescribeSigningJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/DescribeSigningJob
func (c *Signer) DescribeSigningJob(input *DescribeSigningJobInput) (*DescribeSigningJobOutput, error) {
	req, out := c.DescribeSigningJobRequest(input)
	return out, req.Send()
}

// DescribeSigningJobWithContext is the same as DescribeSigningJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSigningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) DescribeSigningJobWithContext(ctx aws.Context, input *DescribeSigningJobInput, opts ...request.Option) (*DescribeSigningJobOutput, error) {
	req, out := c.DescribeSigningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSigningPlatform = "GetSigningPlatform"

// GetSigningPlatformRequest generates a "aws/request.Request" representing the
// client's request for the GetSigningPlatform operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSigningPlatform for more information on using the GetSigningPlatform
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSigningPlatformRequest method.
//    req, resp := client.GetSigningPlatformRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningPlatform
func (c *Signer) GetSigningPlatformRequest(input *GetSigningPlatformInput) (req *request.Request, output *GetSigningPlatformOutput) {
	op := &request.Operation{
		Name:       opGetSigningPlatform,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-platforms/{platformId}",
	}

	if input == nil {
		input = &GetSigningPlatformInput{}
	}

	output = &GetSigningPlatformOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSigningPlatform API operation for AWS Signer.
//
// Returns information on a specific signing platform.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation GetSigningPlatform for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningPlatform
func (c *Signer) GetSigningPlatform(input *GetSigningPlatformInput) (*GetSigningPlatformOutput, error) {
	req, out := c.GetSigningPlatformRequest(input)
	return out, req.Send()
}

// GetSigningPlatformWithContext is the same as GetSigningPlatform with the addition of
// the ability to pass a context and additional request options.
//
// See GetSigningPlatform for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) GetSigningPlatformWithContext(ctx aws.Context, input *GetSigningPlatformInput, opts ...request.Option) (*GetSigningPlatformOutput, error) {
	req, out := c.GetSigningPlatformRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSigningProfile = "GetSigningProfile"

// GetSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSigningProfile for more information on using the GetSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSigningProfileRequest method.
//    req, resp := client.GetSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningProfile
func (c *Signer) GetSigningProfileRequest(input *GetSigningProfileInput) (req *request.Request, output *GetSigningProfileOutput) {
	op := &request.Operation{
		Name:       opGetSigningProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-profiles/{profileName}",
	}

	if input == nil {
		input = &GetSigningProfileInput{}
	}

	output = &GetSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSigningProfile API operation for AWS Signer.
//
// Returns information on a specific signing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation GetSigningProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/GetSigningProfile
func (c *Signer) GetSigningProfile(input *GetSigningProfileInput) (*GetSigningProfileOutput, error) {
	req, out := c.GetSigningProfileRequest(input)
	return out, req.Send()
}

// GetSigningProfileWithContext is the same as GetSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) GetSigningProfileWithContext(ctx aws.Context, input *GetSigningProfileInput, opts ...request.Option) (*GetSigningProfileOutput, error) {
	req, out := c.GetSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSigningJobs = "ListSigningJobs"

// ListSigningJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSigningJobs for more information on using the ListSigningJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSigningJobsRequest method.
//    req, resp := client.ListSigningJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningJobs
func (c *Signer) ListSigningJobsRequest(input *ListSigningJobsInput) (req *request.Request, output *ListSigningJobsOutput) {
	op := &request.Operation{
		Name:       opListSigningJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningJobsInput{}
	}

	output = &ListSigningJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningJobs API operation for AWS Signer.
//
// Lists all your signing jobs. You can use the maxResults parameter to limit
// the number of signing jobs that are returned in the response. If additional
// jobs remain to be listed, AWS Signer returns a nextToken value. Use this
// value in subsequent calls to ListSigningJobs to fetch the remaining values.
// You can continue calling ListSigningJobs with your maxResults parameter and
// with new values that AWS Signer returns in the nextToken parameter until
// all of your signing jobs have been returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListSigningJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   You signing certificate could not be validated.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningJobs
func (c *Signer) ListSigningJobs(input *ListSigningJobsInput) (*ListSigningJobsOutput, error) {
	req, out := c.ListSigningJobsRequest(input)
	return out, req.Send()
}

// ListSigningJobsWithContext is the same as ListSigningJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSigningJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningJobsWithContext(ctx aws.Context, input *ListSigningJobsInput, opts ...request.Option) (*ListSigningJobsOutput, error) {
	req, out := c.ListSigningJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSigningJobsPages iterates over the pages of a ListSigningJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningJobs operation.
//    pageNum := 0
//    err := client.ListSigningJobsPages(params,
//        func(page *signer.ListSigningJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Signer) ListSigningJobsPages(input *ListSigningJobsInput, fn func(*ListSigningJobsOutput, bool) bool) error {
	return c.ListSigningJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSigningJobsPagesWithContext same as ListSigningJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningJobsPagesWithContext(ctx aws.Context, input *ListSigningJobsInput, fn func(*ListSigningJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSigningJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSigningJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSigningJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListSigningPlatforms = "ListSigningPlatforms"

// ListSigningPlatformsRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningPlatforms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSigningPlatforms for more information on using the ListSigningPlatforms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSigningPlatformsRequest method.
//    req, resp := client.ListSigningPlatformsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningPlatforms
func (c *Signer) ListSigningPlatformsRequest(input *ListSigningPlatformsInput) (req *request.Request, output *ListSigningPlatformsOutput) {
	op := &request.Operation{
		Name:       opListSigningPlatforms,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-platforms",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningPlatformsInput{}
	}

	output = &ListSigningPlatformsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningPlatforms API operation for AWS Signer.
//
// Lists all signing platforms available in AWS Signer that match the request
// parameters. If additional jobs remain to be listed, AWS Signer returns a
// nextToken value. Use this value in subsequent calls to ListSigningJobs to
// fetch the remaining values. You can continue calling ListSigningJobs with
// your maxResults parameter and with new values that AWS Signer returns in
// the nextToken parameter until all of your signing jobs have been returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListSigningPlatforms for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   You signing certificate could not be validated.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningPlatforms
func (c *Signer) ListSigningPlatforms(input *ListSigningPlatformsInput) (*ListSigningPlatformsOutput, error) {
	req, out := c.ListSigningPlatformsRequest(input)
	return out, req.Send()
}

// ListSigningPlatformsWithContext is the same as ListSigningPlatforms with the addition of
// the ability to pass a context and additional request options.
//
// See ListSigningPlatforms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningPlatformsWithContext(ctx aws.Context, input *ListSigningPlatformsInput, opts ...request.Option) (*ListSigningPlatformsOutput, error) {
	req, out := c.ListSigningPlatformsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSigningPlatformsPages iterates over the pages of a ListSigningPlatforms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningPlatforms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningPlatforms operation.
//    pageNum := 0
//    err := client.ListSigningPlatformsPages(params,
//        func(page *signer.ListSigningPlatformsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Signer) ListSigningPlatformsPages(input *ListSigningPlatformsInput, fn func(*ListSigningPlatformsOutput, bool) bool) error {
	return c.ListSigningPlatformsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSigningPlatformsPagesWithContext same as ListSigningPlatformsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningPlatformsPagesWithContext(ctx aws.Context, input *ListSigningPlatformsInput, fn func(*ListSigningPlatformsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSigningPlatformsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSigningPlatformsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSigningPlatformsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListSigningProfiles = "ListSigningProfiles"

// ListSigningProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSigningProfiles for more information on using the ListSigningProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSigningProfilesRequest method.
//    req, resp := client.ListSigningProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningProfiles
func (c *Signer) ListSigningProfilesRequest(input *ListSigningProfilesInput) (req *request.Request, output *ListSigningProfilesOutput) {
	op := &request.Operation{
		Name:       opListSigningProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/signing-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSigningProfilesInput{}
	}

	output = &ListSigningProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningProfiles API operation for AWS Signer.
//
// Lists all available signing profiles in your AWS account. Returns only profiles
// with an ACTIVE status unless the includeCanceled request field is set to
// true. If additional jobs remain to be listed, AWS Signer returns a nextToken
// value. Use this value in subsequent calls to ListSigningJobs to fetch the
// remaining values. You can continue calling ListSigningJobs with your maxResults
// parameter and with new values that AWS Signer returns in the nextToken parameter
// until all of your signing jobs have been returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation ListSigningProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/ListSigningProfiles
func (c *Signer) ListSigningProfiles(input *ListSigningProfilesInput) (*ListSigningProfilesOutput, error) {
	req, out := c.ListSigningProfilesRequest(input)
	return out, req.Send()
}

// ListSigningProfilesWithContext is the same as ListSigningProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSigningProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningProfilesWithContext(ctx aws.Context, input *ListSigningProfilesInput, opts ...request.Option) (*ListSigningProfilesOutput, error) {
	req, out := c.ListSigningProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSigningProfilesPages iterates over the pages of a ListSigningProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningProfiles operation.
//    pageNum := 0
//    err := client.ListSigningProfilesPages(params,
//        func(page *signer.ListSigningProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Signer) ListSigningProfilesPages(input *ListSigningProfilesInput, fn func(*ListSigningProfilesOutput, bool) bool) error {
	return c.ListSigningProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSigningProfilesPagesWithContext same as ListSigningProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) ListSigningProfilesPagesWithContext(ctx aws.Context, input *ListSigningProfilesInput, fn func(*ListSigningProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSigningProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSigningProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListSigningProfilesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutSigningProfile = "PutSigningProfile"

// PutSigningProfileRequest generates a "aws/request.Request" representing the
// client's request for the PutSigningProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSigningProfile for more information on using the PutSigningProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSigningProfileRequest method.
//    req, resp := client.PutSigningProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/PutSigningProfile
func (c *Signer) PutSigningProfileRequest(input *PutSigningProfileInput) (req *request.Request, output *PutSigningProfileOutput) {
	op := &request.Operation{
		Name:       opPutSigningProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/signing-profiles/{profileName}",
	}

	if input == nil {
		input = &PutSigningProfileInput{}
	}

	output = &PutSigningProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSigningProfile API operation for AWS Signer.
//
// Creates a signing profile. A signing profile is an AWS Signer template that
// can be used to carry out a pre-defined signing job. For more information,
// see http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html
// (http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation PutSigningProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeValidationException "ValidationException"
//   You signing certificate could not be validated.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/PutSigningProfile
func (c *Signer) PutSigningProfile(input *PutSigningProfileInput) (*PutSigningProfileOutput, error) {
	req, out := c.PutSigningProfileRequest(input)
	return out, req.Send()
}

// PutSigningProfileWithContext is the same as PutSigningProfile with the addition of
// the ability to pass a context and additional request options.
//
// See PutSigningProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) PutSigningProfileWithContext(ctx aws.Context, input *PutSigningProfileInput, opts ...request.Option) (*PutSigningProfileOutput, error) {
	req, out := c.PutSigningProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSigningJob = "StartSigningJob"

// StartSigningJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSigningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSigningJob for more information on using the StartSigningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSigningJobRequest method.
//    req, resp := client.StartSigningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/StartSigningJob
func (c *Signer) StartSigningJobRequest(input *StartSigningJobInput) (req *request.Request, output *StartSigningJobOutput) {
	op := &request.Operation{
		Name:       opStartSigningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/signing-jobs",
	}

	if input == nil {
		input = &StartSigningJobInput{}
	}

	output = &StartSigningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSigningJob API operation for AWS Signer.
//
// Initiates a signing job to be performed on the code provided. Signing jobs
// are viewable by the ListSigningJobs operation for two years after they are
// performed. Note the following requirements:
//
//    * You must create an Amazon S3 source bucket. For more information, see
//    Create a Bucket (http://docs.aws.amazon.com/AmazonS3/latest/gsg/CreatingABucket.html)
//    in the Amazon S3 Getting Started Guide.
//
//    * Your S3 source bucket must be version enabled.
//
//    * You must create an S3 destination bucket. AWS Signer uses your S3 destination
//    bucket to write your signed code.
//
//    * You specify the name of the source and destination buckets when calling
//    the StartSigningJob operation.
//
//    * You must also specify a request token that identifies your request to
//    AWS Signer.
//
// You can call the DescribeSigningJob and the ListSigningJobs actions after
// you call StartSigningJob.
//
// For a Java example that shows how to use this action, see http://docs.aws.amazon.com/acm/latest/userguide/
// (http://docs.aws.amazon.com/acm/latest/userguide/)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Signer's
// API operation StartSigningJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   You signing certificate could not be validated.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A specified resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The signing job has been throttled.
//
//   * ErrCodeInternalServiceErrorException "InternalServiceErrorException"
//   An internal error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/signer-2017-08-25/StartSigningJob
func (c *Signer) StartSigningJob(input *StartSigningJobInput) (*StartSigningJobOutput, error) {
	req, out := c.StartSigningJobRequest(input)
	return out, req.Send()
}

// StartSigningJobWithContext is the same as StartSigningJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSigningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Signer) StartSigningJobWithContext(ctx aws.Context, input *StartSigningJobInput, opts ...request.Option) (*StartSigningJobOutput, error) {
	req, out := c.StartSigningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CancelSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the signing profile to be canceled.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSigningProfileInput"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *CancelSigningProfileInput) SetProfileName(v string) *CancelSigningProfileInput {
	s.ProfileName = &v
	return s
}

type CancelSigningProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSigningProfileOutput) GoString() string {
	return s.String()
}

type DescribeSigningJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing job on input.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSigningJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSigningJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSigningJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSigningJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeSigningJobInput) SetJobId(v string) *DescribeSigningJobInput {
	s.JobId = &v
	return s
}

type DescribeSigningJobOutput struct {
	_ struct{} `type:"structure"`

	// Date and time that the signing job was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// Date and time that the signing job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the signing job on output.
	JobId *string `locationName:"jobId" type:"string"`

	// A list of any overrides that were applied to the signing operation.
	Overrides *SigningPlatformOverrides `locationName:"overrides" type:"structure"`

	// The microcontroller platform to which your signed code image will be distributed.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the profile that initiated the signing operation.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The IAM principal that requested the signing job.
	RequestedBy *string `locationName:"requestedBy" type:"string"`

	// Name of the S3 bucket where the signed code image is saved by AWS Signer.
	SignedObject *SignedObject `locationName:"signedObject" type:"structure"`

	// Amazon Resource Name (ARN) of your code signing certificate.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// Map of user-assigned key-value pairs used during signing. These values contain
	// any information that you specified for use in your signing job.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// The object that contains the name of your S3 bucket or your raw code.
	Source *Source `locationName:"source" type:"structure"`

	// Status of the signing job.
	Status *string `locationName:"status" type:"string" enum:"SigningStatus"`

	// String value that contains the status reason.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s DescribeSigningJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSigningJobOutput) GoString() string {
	return s.String()
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *DescribeSigningJobOutput) SetCompletedAt(v time.Time) *DescribeSigningJobOutput {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeSigningJobOutput) SetCreatedAt(v time.Time) *DescribeSigningJobOutput {
	s.CreatedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeSigningJobOutput) SetJobId(v string) *DescribeSigningJobOutput {
	s.JobId = &v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *DescribeSigningJobOutput) SetOverrides(v *SigningPlatformOverrides) *DescribeSigningJobOutput {
	s.Overrides = v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *DescribeSigningJobOutput) SetPlatformId(v string) *DescribeSigningJobOutput {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *DescribeSigningJobOutput) SetProfileName(v string) *DescribeSigningJobOutput {
	s.ProfileName = &v
	return s
}

// SetRequestedBy sets the RequestedBy field's value.
func (s *DescribeSigningJobOutput) SetRequestedBy(v string) *DescribeSigningJobOutput {
	s.RequestedBy = &v
	return s
}

// SetSignedObject sets the SignedObject field's value.
func (s *DescribeSigningJobOutput) SetSignedObject(v *SignedObject) *DescribeSigningJobOutput {
	s.SignedObject = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *DescribeSigningJobOutput) SetSigningMaterial(v *SigningMaterial) *DescribeSigningJobOutput {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *DescribeSigningJobOutput) SetSigningParameters(v map[string]*string) *DescribeSigningJobOutput {
	s.SigningParameters = v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeSigningJobOutput) SetSource(v *Source) *DescribeSigningJobOutput {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeSigningJobOutput) SetStatus(v string) *DescribeSigningJobOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeSigningJobOutput) SetStatusReason(v string) *DescribeSigningJobOutput {
	s.StatusReason = &v
	return s
}

// Points to an S3Destination object that contains information about your S3
// bucket.
type Destination struct {
	_ struct{} `type:"structure"`

	// The S3Destination object.
	S3 *S3Destination `locationName:"s3" type:"structure"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *Destination) SetS3(v *S3Destination) *Destination {
	s.S3 = v
	return s
}

// The encryption algorithm options that are available to an AWS Signer job.
type EncryptionAlgorithmOptions struct {
	_ struct{} `type:"structure"`

	// The set of accepted encryption algorithms that are allowed in an AWS Signer
	// job.
	//
	// AllowedValues is a required field
	AllowedValues []*string `locationName:"allowedValues" type:"list" required:"true"`

	// The default encryption algorithm that is used by an AWS Signer job.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true" enum:"EncryptionAlgorithm"`
}

// String returns the string representation
func (s EncryptionAlgorithmOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionAlgorithmOptions) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *EncryptionAlgorithmOptions) SetAllowedValues(v []*string) *EncryptionAlgorithmOptions {
	s.AllowedValues = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *EncryptionAlgorithmOptions) SetDefaultValue(v string) *EncryptionAlgorithmOptions {
	s.DefaultValue = &v
	return s
}

type GetSigningPlatformInput struct {
	_ struct{} `type:"structure"`

	// The ID of the target signing platform.
	//
	// PlatformId is a required field
	PlatformId *string `location:"uri" locationName:"platformId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSigningPlatformInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSigningPlatformInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSigningPlatformInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSigningPlatformInput"}
	if s.PlatformId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformId"))
	}
	if s.PlatformId != nil && len(*s.PlatformId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlatformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlatformId sets the PlatformId field's value.
func (s *GetSigningPlatformInput) SetPlatformId(v string) *GetSigningPlatformInput {
	s.PlatformId = &v
	return s
}

type GetSigningPlatformOutput struct {
	_ struct{} `type:"structure"`

	// The category type of the target signing platform.
	Category *string `locationName:"category" type:"string" enum:"Category"`

	// The display name of the target signing platform.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The maximum size (in MB) of the payload that can be signed by the target
	// platform.
	MaxSizeInMB *int64 `locationName:"maxSizeInMB" type:"integer"`

	// A list of partner entities that use the target signing platform.
	Partner *string `locationName:"partner" type:"string"`

	// The ID of the target signing platform.
	PlatformId *string `locationName:"platformId" type:"string"`

	// A list of configurations applied to the target platform at signing.
	SigningConfiguration *SigningConfiguration `locationName:"signingConfiguration" type:"structure"`

	// The format of the target platform's signing image.
	SigningImageFormat *SigningImageFormat `locationName:"signingImageFormat" type:"structure"`

	// The validation template that is used by the target signing platform.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s GetSigningPlatformOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSigningPlatformOutput) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *GetSigningPlatformOutput) SetCategory(v string) *GetSigningPlatformOutput {
	s.Category = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetSigningPlatformOutput) SetDisplayName(v string) *GetSigningPlatformOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSizeInMB sets the MaxSizeInMB field's value.
func (s *GetSigningPlatformOutput) SetMaxSizeInMB(v int64) *GetSigningPlatformOutput {
	s.MaxSizeInMB = &v
	return s
}

// SetPartner sets the Partner field's value.
func (s *GetSigningPlatformOutput) SetPartner(v string) *GetSigningPlatformOutput {
	s.Partner = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *GetSigningPlatformOutput) SetPlatformId(v string) *GetSigningPlatformOutput {
	s.PlatformId = &v
	return s
}

// SetSigningConfiguration sets the SigningConfiguration field's value.
func (s *GetSigningPlatformOutput) SetSigningConfiguration(v *SigningConfiguration) *GetSigningPlatformOutput {
	s.SigningConfiguration = v
	return s
}

// SetSigningImageFormat sets the SigningImageFormat field's value.
func (s *GetSigningPlatformOutput) SetSigningImageFormat(v *SigningImageFormat) *GetSigningPlatformOutput {
	s.SigningImageFormat = v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetSigningPlatformOutput) SetTarget(v string) *GetSigningPlatformOutput {
	s.Target = &v
	return s
}

type GetSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the target signing profile.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSigningProfileInput"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *GetSigningProfileInput) SetProfileName(v string) *GetSigningProfileInput {
	s.ProfileName = &v
	return s
}

type GetSigningProfileOutput struct {
	_ struct{} `type:"structure"`

	// A list of overrides applied by the target signing profile for signing operations.
	Overrides *SigningPlatformOverrides `locationName:"overrides" type:"structure"`

	// The ID of the platform that is used by the target signing profile.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the target signing profile.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The ARN of the certificate that the target profile uses for signing operations.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// A map of key-value pairs for signing operations that is attached to the target
	// signing profile.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// The status of the target signing profile.
	Status *string `locationName:"status" type:"string" enum:"SigningProfileStatus"`
}

// String returns the string representation
func (s GetSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSigningProfileOutput) GoString() string {
	return s.String()
}

// SetOverrides sets the Overrides field's value.
func (s *GetSigningProfileOutput) SetOverrides(v *SigningPlatformOverrides) *GetSigningProfileOutput {
	s.Overrides = v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *GetSigningProfileOutput) SetPlatformId(v string) *GetSigningProfileOutput {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *GetSigningProfileOutput) SetProfileName(v string) *GetSigningProfileOutput {
	s.ProfileName = &v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *GetSigningProfileOutput) SetSigningMaterial(v *SigningMaterial) *GetSigningProfileOutput {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *GetSigningProfileOutput) SetSigningParameters(v map[string]*string) *GetSigningProfileOutput {
	s.SigningParameters = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSigningProfileOutput) SetStatus(v string) *GetSigningProfileOutput {
	s.Status = &v
	return s
}

// The hash algorithms that are available to an AWS Signer job.
type HashAlgorithmOptions struct {
	_ struct{} `type:"structure"`

	// The set of accepted hash algorithms allowed in an AWS Signer job.
	//
	// AllowedValues is a required field
	AllowedValues []*string `locationName:"allowedValues" type:"list" required:"true"`

	// The default hash algorithm that is used in an AWS Signer job.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true" enum:"HashAlgorithm"`
}

// String returns the string representation
func (s HashAlgorithmOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HashAlgorithmOptions) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *HashAlgorithmOptions) SetAllowedValues(v []*string) *HashAlgorithmOptions {
	s.AllowedValues = v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *HashAlgorithmOptions) SetDefaultValue(v string) *HashAlgorithmOptions {
	s.DefaultValue = &v
	return s
}

type ListSigningJobsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum number of items to return in the response. Use this
	// parameter when paginating results. If additional items exist beyond the number
	// you specify, the nextToken element is set in the response. Use the nextToken
	// value in a subsequent request to retrieve additional items.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// String for specifying the next set of paginated results to return. After
	// you receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of microcontroller platform that you specified for the distribution
	// of your code image.
	PlatformId *string `location:"querystring" locationName:"platformId" type:"string"`

	// The IAM principal that requested the signing job.
	RequestedBy *string `location:"querystring" locationName:"requestedBy" type:"string"`

	// A status value with which to filter your results.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"SigningStatus"`
}

// String returns the string representation
func (s ListSigningJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSigningJobsInput) SetMaxResults(v int64) *ListSigningJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningJobsInput) SetNextToken(v string) *ListSigningJobsInput {
	s.NextToken = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *ListSigningJobsInput) SetPlatformId(v string) *ListSigningJobsInput {
	s.PlatformId = &v
	return s
}

// SetRequestedBy sets the RequestedBy field's value.
func (s *ListSigningJobsInput) SetRequestedBy(v string) *ListSigningJobsInput {
	s.RequestedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListSigningJobsInput) SetStatus(v string) *ListSigningJobsInput {
	s.Status = &v
	return s
}

type ListSigningJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of your signing jobs.
	Jobs []*SigningJob `locationName:"jobs" type:"list"`

	// String for specifying the next set of paginated results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSigningJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListSigningJobsOutput) SetJobs(v []*SigningJob) *ListSigningJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningJobsOutput) SetNextToken(v string) *ListSigningJobsOutput {
	s.NextToken = &v
	return s
}

type ListSigningPlatformsInput struct {
	_ struct{} `type:"structure"`

	// The category type of a signing platform.
	Category *string `location:"querystring" locationName:"category" type:"string"`

	// The maximum number of results to be returned by this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Value for specifying the next set of paginated results to return. After you
	// receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Any partner entities connected to a signing platform.
	Partner *string `location:"querystring" locationName:"partner" type:"string"`

	// The validation template that is used by the target signing platform.
	Target *string `location:"querystring" locationName:"target" type:"string"`
}

// String returns the string representation
func (s ListSigningPlatformsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningPlatformsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningPlatformsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningPlatformsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *ListSigningPlatformsInput) SetCategory(v string) *ListSigningPlatformsInput {
	s.Category = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSigningPlatformsInput) SetMaxResults(v int64) *ListSigningPlatformsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningPlatformsInput) SetNextToken(v string) *ListSigningPlatformsInput {
	s.NextToken = &v
	return s
}

// SetPartner sets the Partner field's value.
func (s *ListSigningPlatformsInput) SetPartner(v string) *ListSigningPlatformsInput {
	s.Partner = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ListSigningPlatformsInput) SetTarget(v string) *ListSigningPlatformsInput {
	s.Target = &v
	return s
}

type ListSigningPlatformsOutput struct {
	_ struct{} `type:"structure"`

	// Value for specifying the next set of paginated results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all platforms that match the request parameters.
	Platforms []*SigningPlatform `locationName:"platforms" type:"list"`
}

// String returns the string representation
func (s ListSigningPlatformsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningPlatformsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningPlatformsOutput) SetNextToken(v string) *ListSigningPlatformsOutput {
	s.NextToken = &v
	return s
}

// SetPlatforms sets the Platforms field's value.
func (s *ListSigningPlatformsOutput) SetPlatforms(v []*SigningPlatform) *ListSigningPlatformsOutput {
	s.Platforms = v
	return s
}

type ListSigningProfilesInput struct {
	_ struct{} `type:"structure"`

	// Designates whether to include profiles with the status of CANCELED.
	IncludeCanceled *bool `location:"querystring" locationName:"includeCanceled" type:"boolean"`

	// The maximum number of profiles to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Value for specifying the next set of paginated results to return. After you
	// receive a response with truncated results, use this parameter in a subsequent
	// request. Set it to the value of nextToken from the response that you just
	// received.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSigningProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeCanceled sets the IncludeCanceled field's value.
func (s *ListSigningProfilesInput) SetIncludeCanceled(v bool) *ListSigningProfilesInput {
	s.IncludeCanceled = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSigningProfilesInput) SetMaxResults(v int64) *ListSigningProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningProfilesInput) SetNextToken(v string) *ListSigningProfilesInput {
	s.NextToken = &v
	return s
}

type ListSigningProfilesOutput struct {
	_ struct{} `type:"structure"`

	// Value for specifying the next set of paginated results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of profiles that are available in the AWS account. This includes profiles
	// with the status of CANCELED if the includeCanceled parameter is set to true.
	Profiles []*SigningProfile `locationName:"profiles" type:"list"`
}

// String returns the string representation
func (s ListSigningProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSigningProfilesOutput) SetNextToken(v string) *ListSigningProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfiles sets the Profiles field's value.
func (s *ListSigningProfilesOutput) SetProfiles(v []*SigningProfile) *ListSigningProfilesOutput {
	s.Profiles = v
	return s
}

type PutSigningProfileInput struct {
	_ struct{} `type:"structure"`

	// A subfield of platform. This specifies any different configuration options
	// that you want to apply to the chosen platform (such as a different hash-algorithm
	// or signing-algorithm).
	Overrides *SigningPlatformOverrides `locationName:"overrides" type:"structure"`

	// The ID of the signing profile to be created.
	//
	// PlatformId is a required field
	PlatformId *string `locationName:"platformId" type:"string" required:"true"`

	// The name of the signing profile to be created.
	//
	// ProfileName is a required field
	ProfileName *string `location:"uri" locationName:"profileName" min:"2" type:"string" required:"true"`

	// The AWS Certificate Manager certificate that will be used to sign code with
	// the new signing profile.
	//
	// SigningMaterial is a required field
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure" required:"true"`

	// Map of key-value pairs for signing. These can include any information that
	// you want to use during signing.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`
}

// String returns the string representation
func (s PutSigningProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSigningProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSigningProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSigningProfileInput"}
	if s.PlatformId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformId"))
	}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.SigningMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningMaterial"))
	}
	if s.SigningMaterial != nil {
		if err := s.SigningMaterial.Validate(); err != nil {
			invalidParams.AddNested("SigningMaterial", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrides sets the Overrides field's value.
func (s *PutSigningProfileInput) SetOverrides(v *SigningPlatformOverrides) *PutSigningProfileInput {
	s.Overrides = v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *PutSigningProfileInput) SetPlatformId(v string) *PutSigningProfileInput {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *PutSigningProfileInput) SetProfileName(v string) *PutSigningProfileInput {
	s.ProfileName = &v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *PutSigningProfileInput) SetSigningMaterial(v *SigningMaterial) *PutSigningProfileInput {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *PutSigningProfileInput) SetSigningParameters(v map[string]*string) *PutSigningProfileInput {
	s.SigningParameters = v
	return s
}

type PutSigningProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the signing profile created.
	Arn *string `locationName:"arn" type:"string"`
}

// String returns the string representation
func (s PutSigningProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSigningProfileOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PutSigningProfileOutput) SetArn(v string) *PutSigningProfileOutput {
	s.Arn = &v
	return s
}

// The name and prefix of the S3 bucket where AWS Signer saves your signed objects.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string"`

	// An Amazon S3 prefix that you can use to limit responses to those that begin
	// with the specified prefix.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Destination) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3Destination) SetBucketName(v string) *S3Destination {
	s.BucketName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Destination) SetPrefix(v string) *S3Destination {
	s.Prefix = &v
	return s
}

// The S3 bucket name and key where AWS Signer saved your signed code image.
type S3SignedObject struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string"`

	// Key name that uniquely identifies a signed code image in your bucket.
	Key *string `locationName:"key" type:"string"`
}

// String returns the string representation
func (s S3SignedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SignedObject) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3SignedObject) SetBucketName(v string) *S3SignedObject {
	s.BucketName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3SignedObject) SetKey(v string) *S3SignedObject {
	s.Key = &v
	return s
}

// Information about the S3 bucket where you saved your unsigned code.
type S3Source struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// Key name of the bucket object that contains your unsigned code.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// Version of your source image in your version enabled S3 bucket.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Source"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Source) SetBucketName(v string) *S3Source {
	s.BucketName = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Source) SetKey(v string) *S3Source {
	s.Key = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *S3Source) SetVersion(v string) *S3Source {
	s.Version = &v
	return s
}

// Points to an S3SignedObject object that contains information about your signed
// code image.
type SignedObject struct {
	_ struct{} `type:"structure"`

	// The S3SignedObject.
	S3 *S3SignedObject `locationName:"s3" type:"structure"`
}

// String returns the string representation
func (s SignedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedObject) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *SignedObject) SetS3(v *S3SignedObject) *SignedObject {
	s.S3 = v
	return s
}

// The configuration of an AWS Signer operation.
type SigningConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption algorithm options that are available for an AWS Signer job.
	//
	// EncryptionAlgorithmOptions is a required field
	EncryptionAlgorithmOptions *EncryptionAlgorithmOptions `locationName:"encryptionAlgorithmOptions" type:"structure" required:"true"`

	// The hash algorithm options that are available for an AWS Signer job.
	//
	// HashAlgorithmOptions is a required field
	HashAlgorithmOptions *HashAlgorithmOptions `locationName:"hashAlgorithmOptions" type:"structure" required:"true"`
}

// String returns the string representation
func (s SigningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningConfiguration) GoString() string {
	return s.String()
}

// SetEncryptionAlgorithmOptions sets the EncryptionAlgorithmOptions field's value.
func (s *SigningConfiguration) SetEncryptionAlgorithmOptions(v *EncryptionAlgorithmOptions) *SigningConfiguration {
	s.EncryptionAlgorithmOptions = v
	return s
}

// SetHashAlgorithmOptions sets the HashAlgorithmOptions field's value.
func (s *SigningConfiguration) SetHashAlgorithmOptions(v *HashAlgorithmOptions) *SigningConfiguration {
	s.HashAlgorithmOptions = v
	return s
}

// A signing configuration that overrides the default encryption or hash algorithm
// of a signing job.
type SigningConfigurationOverrides struct {
	_ struct{} `type:"structure"`

	// A specified override of the default encryption algorithm that is used in
	// an AWS Signer job.
	EncryptionAlgorithm *string `locationName:"encryptionAlgorithm" type:"string" enum:"EncryptionAlgorithm"`

	// A specified override of the default hash algorithm that is used in an AWS
	// Signer job.
	HashAlgorithm *string `locationName:"hashAlgorithm" type:"string" enum:"HashAlgorithm"`
}

// String returns the string representation
func (s SigningConfigurationOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningConfigurationOverrides) GoString() string {
	return s.String()
}

// SetEncryptionAlgorithm sets the EncryptionAlgorithm field's value.
func (s *SigningConfigurationOverrides) SetEncryptionAlgorithm(v string) *SigningConfigurationOverrides {
	s.EncryptionAlgorithm = &v
	return s
}

// SetHashAlgorithm sets the HashAlgorithm field's value.
func (s *SigningConfigurationOverrides) SetHashAlgorithm(v string) *SigningConfigurationOverrides {
	s.HashAlgorithm = &v
	return s
}

// The image format of an AWS Signer platform or profile.
type SigningImageFormat struct {
	_ struct{} `type:"structure"`

	// The default format of an AWS Signer signing image.
	//
	// DefaultFormat is a required field
	DefaultFormat *string `locationName:"defaultFormat" type:"string" required:"true" enum:"ImageFormat"`

	// The supported formats of an AWS Signer signing image.
	//
	// SupportedFormats is a required field
	SupportedFormats []*string `locationName:"supportedFormats" type:"list" required:"true"`
}

// String returns the string representation
func (s SigningImageFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningImageFormat) GoString() string {
	return s.String()
}

// SetDefaultFormat sets the DefaultFormat field's value.
func (s *SigningImageFormat) SetDefaultFormat(v string) *SigningImageFormat {
	s.DefaultFormat = &v
	return s
}

// SetSupportedFormats sets the SupportedFormats field's value.
func (s *SigningImageFormat) SetSupportedFormats(v []*string) *SigningImageFormat {
	s.SupportedFormats = v
	return s
}

// Contains information about a signing job.
type SigningJob struct {
	_ struct{} `type:"structure"`

	// The date and time that the signing job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the signing job.
	JobId *string `locationName:"jobId" type:"string"`

	// A SignedObject structure that contains information about a signing job's
	// signed code image.
	SignedObject *SignedObject `locationName:"signedObject" type:"structure"`

	// A SigningMaterial object that contains the Amazon Resource Name (ARN) of
	// the certificate used for the signing job.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// A Source that contains information about a signing job's code image source.
	Source *Source `locationName:"source" type:"structure"`

	// The status of the signing job.
	Status *string `locationName:"status" type:"string" enum:"SigningStatus"`
}

// String returns the string representation
func (s SigningJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningJob) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SigningJob) SetCreatedAt(v time.Time) *SigningJob {
	s.CreatedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SigningJob) SetJobId(v string) *SigningJob {
	s.JobId = &v
	return s
}

// SetSignedObject sets the SignedObject field's value.
func (s *SigningJob) SetSignedObject(v *SignedObject) *SigningJob {
	s.SignedObject = v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *SigningJob) SetSigningMaterial(v *SigningMaterial) *SigningJob {
	s.SigningMaterial = v
	return s
}

// SetSource sets the Source field's value.
func (s *SigningJob) SetSource(v *Source) *SigningJob {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SigningJob) SetStatus(v string) *SigningJob {
	s.Status = &v
	return s
}

// The ACM certificate that is used to sign your code.
type SigningMaterial struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificates that is used to sign your
	// code.
	//
	// CertificateArn is a required field
	CertificateArn *string `locationName:"certificateArn" type:"string" required:"true"`
}

// String returns the string representation
func (s SigningMaterial) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningMaterial) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SigningMaterial) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SigningMaterial"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *SigningMaterial) SetCertificateArn(v string) *SigningMaterial {
	s.CertificateArn = &v
	return s
}

// Contains information about the signing configurations and parameters that
// is used to perform an AWS Signer job.
type SigningPlatform struct {
	_ struct{} `type:"structure"`

	// The category of an AWS Signer platform.
	Category *string `locationName:"category" type:"string" enum:"Category"`

	// The display name of an AWS Signer platform.
	DisplayName *string `locationName:"displayName" type:"string"`

	// The maximum size (in MB) of code that can be signed by a AWS Signer platform.
	MaxSizeInMB *int64 `locationName:"maxSizeInMB" type:"integer"`

	// Any partner entities linked to an AWS Signer platform.
	Partner *string `locationName:"partner" type:"string"`

	// The ID of an AWS Signer platform.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The configuration of an AWS Signer platform. This includes the designated
	// hash algorithm and encryption algorithm of a signing platform.
	SigningConfiguration *SigningConfiguration `locationName:"signingConfiguration" type:"structure"`

	// The signing image format that is used by an AWS Signer platform.
	SigningImageFormat *SigningImageFormat `locationName:"signingImageFormat" type:"structure"`

	// The types of targets that can be signed by an AWS Signer platform.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s SigningPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningPlatform) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *SigningPlatform) SetCategory(v string) *SigningPlatform {
	s.Category = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *SigningPlatform) SetDisplayName(v string) *SigningPlatform {
	s.DisplayName = &v
	return s
}

// SetMaxSizeInMB sets the MaxSizeInMB field's value.
func (s *SigningPlatform) SetMaxSizeInMB(v int64) *SigningPlatform {
	s.MaxSizeInMB = &v
	return s
}

// SetPartner sets the Partner field's value.
func (s *SigningPlatform) SetPartner(v string) *SigningPlatform {
	s.Partner = &v
	return s
}

// SetPlatformId sets the PlatformId field's value.
func (s *SigningPlatform) SetPlatformId(v string) *SigningPlatform {
	s.PlatformId = &v
	return s
}

// SetSigningConfiguration sets the SigningConfiguration field's value.
func (s *SigningPlatform) SetSigningConfiguration(v *SigningConfiguration) *SigningPlatform {
	s.SigningConfiguration = v
	return s
}

// SetSigningImageFormat sets the SigningImageFormat field's value.
func (s *SigningPlatform) SetSigningImageFormat(v *SigningImageFormat) *SigningPlatform {
	s.SigningImageFormat = v
	return s
}

// SetTarget sets the Target field's value.
func (s *SigningPlatform) SetTarget(v string) *SigningPlatform {
	s.Target = &v
	return s
}

// Any overrides that are applied to the signing configuration of an AWS Signer
// platform.
type SigningPlatformOverrides struct {
	_ struct{} `type:"structure"`

	// A signing configuration that overrides the default encryption or hash algorithm
	// of a signing job.
	SigningConfiguration *SigningConfigurationOverrides `locationName:"signingConfiguration" type:"structure"`
}

// String returns the string representation
func (s SigningPlatformOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningPlatformOverrides) GoString() string {
	return s.String()
}

// SetSigningConfiguration sets the SigningConfiguration field's value.
func (s *SigningPlatformOverrides) SetSigningConfiguration(v *SigningConfigurationOverrides) *SigningPlatformOverrides {
	s.SigningConfiguration = v
	return s
}

// Contains information about the ACM certificates and AWS Signer configuration
// parameters that can be used by a given AWS Signer user.
type SigningProfile struct {
	_ struct{} `type:"structure"`

	// The ID of a platform that is available for use by a signing profile.
	PlatformId *string `locationName:"platformId" type:"string"`

	// The name of the AWS Signer profile.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The ACM certificate that is available for use by a signing profile.
	SigningMaterial *SigningMaterial `locationName:"signingMaterial" type:"structure"`

	// The parameters that are available for use by an AWS Signer user.
	SigningParameters map[string]*string `locationName:"signingParameters" type:"map"`

	// The status of an AWS Signer profile.
	Status *string `locationName:"status" type:"string" enum:"SigningProfileStatus"`
}

// String returns the string representation
func (s SigningProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningProfile) GoString() string {
	return s.String()
}

// SetPlatformId sets the PlatformId field's value.
func (s *SigningProfile) SetPlatformId(v string) *SigningProfile {
	s.PlatformId = &v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *SigningProfile) SetProfileName(v string) *SigningProfile {
	s.ProfileName = &v
	return s
}

// SetSigningMaterial sets the SigningMaterial field's value.
func (s *SigningProfile) SetSigningMaterial(v *SigningMaterial) *SigningProfile {
	s.SigningMaterial = v
	return s
}

// SetSigningParameters sets the SigningParameters field's value.
func (s *SigningProfile) SetSigningParameters(v map[string]*string) *SigningProfile {
	s.SigningParameters = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SigningProfile) SetStatus(v string) *SigningProfile {
	s.Status = &v
	return s
}

// An S3Source object that contains information about the S3 bucket where you
// saved your unsigned code.
type Source struct {
	_ struct{} `type:"structure"`

	// The S3Source object.
	S3 *S3Source `locationName:"s3" type:"structure"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Source"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *Source) SetS3(v *S3Source) *Source {
	s.S3 = v
	return s
}

type StartSigningJobInput struct {
	_ struct{} `type:"structure"`

	// String that identifies the signing request. All calls after the first that
	// use this token return the same response as the first call.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The S3 bucket in which to save your signed object. The destination contains
	// the name of your bucket and an optional prefix.
	//
	// Destination is a required field
	Destination *Destination `locationName:"destination" type:"structure" required:"true"`

	// The name of the signing profile.
	ProfileName *string `locationName:"profileName" min:"2" type:"string"`

	// The S3 bucket that contains the object to sign or a BLOB that contains your
	// raw code.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartSigningJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSigningJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSigningJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSigningJobInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 2))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSigningJobInput) SetClientRequestToken(v string) *StartSigningJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *StartSigningJobInput) SetDestination(v *Destination) *StartSigningJobInput {
	s.Destination = v
	return s
}

// SetProfileName sets the ProfileName field's value.
func (s *StartSigningJobInput) SetProfileName(v string) *StartSigningJobInput {
	s.ProfileName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *StartSigningJobInput) SetSource(v *Source) *StartSigningJobInput {
	s.Source = v
	return s
}

type StartSigningJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID of your signing job.
	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation
func (s StartSigningJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSigningJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartSigningJobOutput) SetJobId(v string) *StartSigningJobOutput {
	s.JobId = &v
	return s
}

const (
	// CategoryAwsioT is a Category enum value
	CategoryAwsioT = "AWSIoT"
)

const (
	// EncryptionAlgorithmRsa is a EncryptionAlgorithm enum value
	EncryptionAlgorithmRsa = "RSA"

	// EncryptionAlgorithmEcdsa is a EncryptionAlgorithm enum value
	EncryptionAlgorithmEcdsa = "ECDSA"
)

const (
	// HashAlgorithmSha1 is a HashAlgorithm enum value
	HashAlgorithmSha1 = "SHA1"

	// HashAlgorithmSha256 is a HashAlgorithm enum value
	HashAlgorithmSha256 = "SHA256"
)

const (
	// ImageFormatJson is a ImageFormat enum value
	ImageFormatJson = "JSON"
)

const (
	// SigningProfileStatusActive is a SigningProfileStatus enum value
	SigningProfileStatusActive = "Active"

	// SigningProfileStatusCanceled is a SigningProfileStatus enum value
	SigningProfileStatusCanceled = "Canceled"
)

const (
	// SigningStatusInProgress is a SigningStatus enum value
	SigningStatusInProgress = "InProgress"

	// SigningStatusFailed is a SigningStatus enum value
	SigningStatusFailed = "Failed"

	// SigningStatusSucceeded is a SigningStatus enum value
	SigningStatusSucceeded = "Succeeded"
)
