// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/billing.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/metric"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Billing related configuration of the service.
//
// The following example shows how to configure metrics for billing:
//
//     metrics:
//     - name: library.googleapis.com/read_calls
//       metric_kind: DELTA
//       value_type: INT64
//     - name: library.googleapis.com/write_calls
//       metric_kind: DELTA
//       value_type: INT64
//     billing:
//       metrics:
//       - library.googleapis.com/read_calls
//       - library.googleapis.com/write_calls
//
// The next example shows how to enable billing status check and customize the
// check behavior. It makes sure billing status check is included in the `Check`
// method of [Service Control API](https://cloud.google.com/service-control/).
// In the example, "google.storage.Get" method can be served when the billing
// status is either `current` or `delinquent`, while "google.storage.Write"
// method can only be served when the billing status is `current`:
//
//     billing:
//       rules:
//       - selector: google.storage.Get
//         allowed_statuses:
//         - current
//         - delinquent
//       - selector: google.storage.Write
//         allowed_statuses: current
//
// Mostly services should only allow `current` status when serving requests.
// In addition, services can choose to allow both `current` and `delinquent`
// statuses when serving read-only requests to resources. If there's no
// matching selector for operation, no billing status check will be performed.
//
type Billing struct {
	// Names of the metrics to report to billing. Each name must
	// be defined in [Service.metrics][google.api.Service.metrics] section.
	Metrics []string `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty"`
	// A list of billing status rules for configuring billing status check.
	Rules []*BillingStatusRule `protobuf:"bytes,5,rep,name=rules" json:"rules,omitempty"`
}

func (m *Billing) Reset()                    { *m = Billing{} }
func (m *Billing) String() string            { return proto.CompactTextString(m) }
func (*Billing) ProtoMessage()               {}
func (*Billing) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *Billing) GetRules() []*BillingStatusRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// Defines the billing status requirements for operations.
//
// When used with
// [Service Control API](https://cloud.google.com/service-control/), the
// following statuses are supported:
//
// - **current**: the associated billing account is up to date and capable of
//                paying for resource usages.
// - **delinquent**: the associated billing account has a correctable problem,
//                   such as late payment.
//
// Mostly services should only allow `current` status when serving requests.
// In addition, services can choose to allow both `current` and `delinquent`
// statuses when serving read-only requests to resources. If the list of
// allowed_statuses is empty, it means no billing requirement.
//
type BillingStatusRule struct {
	// Selects the operation names to which this rule applies.
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector" json:"selector,omitempty"`
	// Allowed billing statuses. The billing status check passes if the actual
	// billing status matches any of the provided values here.
	AllowedStatuses []string `protobuf:"bytes,2,rep,name=allowed_statuses,json=allowedStatuses" json:"allowed_statuses,omitempty"`
}

func (m *BillingStatusRule) Reset()                    { *m = BillingStatusRule{} }
func (m *BillingStatusRule) String() string            { return proto.CompactTextString(m) }
func (*BillingStatusRule) ProtoMessage()               {}
func (*BillingStatusRule) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func init() {
	proto.RegisterType((*Billing)(nil), "google.api.Billing")
	proto.RegisterType((*BillingStatusRule)(nil), "google.api.BillingStatusRule")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/billing.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 252 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x8f, 0xbd, 0x4b, 0x04, 0x31,
	0x10, 0xc5, 0x59, 0x8f, 0xf3, 0xbc, 0x28, 0x7e, 0xa4, 0x0a, 0x0b, 0xc2, 0x72, 0xd5, 0xda, 0x24,
	0xe0, 0xd5, 0x36, 0x0b, 0x16, 0x76, 0xc7, 0x5e, 0x23, 0x36, 0x92, 0x8b, 0x63, 0x08, 0xe4, 0x32,
	0x4b, 0x26, 0xab, 0xff, 0xbe, 0xb8, 0x89, 0x1f, 0x60, 0x23, 0x57, 0x85, 0x99, 0x37, 0xef, 0x97,
	0xf7, 0xd8, 0xbd, 0x45, 0xb4, 0x1e, 0xa4, 0x45, 0xaf, 0x83, 0x95, 0x18, 0xad, 0xb2, 0x10, 0x86,
	0x88, 0x09, 0x55, 0x96, 0xf4, 0xe0, 0x48, 0xe9, 0xc1, 0x29, 0x82, 0xf8, 0xe6, 0x0c, 0x18, 0x0c,
	0xaf, 0xce, 0xaa, 0x9d, 0xf3, 0xde, 0x05, 0x2b, 0xa7, 0x53, 0xce, 0x0a, 0x46, 0x0f, 0xae, 0x7e,
	0x38, 0x14, 0xa9, 0x43, 0xc0, 0xa4, 0x93, 0xc3, 0x40, 0x19, 0x5b, 0xdf, 0xfd, 0x1f, 0xb5, 0x87,
	0x14, 0x9d, 0x29, 0x4f, 0xb6, 0xaf, 0x1e, 0xd9, 0xa2, 0xcb, 0x31, 0xb9, 0x60, 0x8b, 0x2c, 0x91,
	0xa8, 0x9a, 0x59, 0xbb, 0xec, 0xbf, 0x46, 0xbe, 0x66, 0xf3, 0x38, 0x7a, 0x20, 0x31, 0x6f, 0x66,
	0xed, 0xe9, 0xed, 0xb5, 0xfc, 0xa9, 0x22, 0x8b, 0x7b, 0x9b, 0x74, 0x1a, 0xa9, 0x1f, 0x3d, 0xf4,
	0xf9, 0x76, 0xf5, 0xc4, 0xae, 0xfe, 0x68, 0xbc, 0x66, 0x27, 0x04, 0x1e, 0x4c, 0xc2, 0x28, 0xaa,
	0xa6, 0x6a, 0x97, 0xfd, 0xf7, 0xcc, 0x6f, 0xd8, 0xa5, 0xf6, 0x1e, 0xdf, 0xe1, 0xe5, 0x99, 0x26,
	0x07, 0x90, 0x38, 0x9a, 0x82, 0x5c, 0x94, 0xfd, 0xb6, 0xac, 0xbb, 0x86, 0x9d, 0x1b, 0xdc, 0xff,
	0x8a, 0xd1, 0x9d, 0x95, 0xbf, 0x36, 0x9f, 0xad, 0x36, 0xd5, 0xee, 0x78, 0xaa, 0xb7, 0xfe, 0x08,
	0x00, 0x00, 0xff, 0xff, 0xe0, 0xe1, 0x19, 0xb1, 0xbd, 0x01, 0x00, 0x00,
}
