// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/resourcemanager/v2/folders.proto

package resourcemanager // import "google.golang.org/genproto/googleapis/cloud/resourcemanager/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import v1 "google.golang.org/genproto/googleapis/iam/v1"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Folder lifecycle states.
type Folder_LifecycleState int32

const (
	// Unspecified state.
	Folder_LIFECYCLE_STATE_UNSPECIFIED Folder_LifecycleState = 0
	// The normal and active state.
	Folder_ACTIVE Folder_LifecycleState = 1
	// The folder has been marked for deletion by the user.
	Folder_DELETE_REQUESTED Folder_LifecycleState = 2
)

var Folder_LifecycleState_name = map[int32]string{
	0: "LIFECYCLE_STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "DELETE_REQUESTED",
}
var Folder_LifecycleState_value = map[string]int32{
	"LIFECYCLE_STATE_UNSPECIFIED": 0,
	"ACTIVE":                      1,
	"DELETE_REQUESTED":            2,
}

func (x Folder_LifecycleState) String() string {
	return proto.EnumName(Folder_LifecycleState_name, int32(x))
}
func (Folder_LifecycleState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{0, 0}
}

// The type of operation that failed.
type FolderOperation_OperationType int32

const (
	// Operation type not specified.
	FolderOperation_OPERATION_TYPE_UNSPECIFIED FolderOperation_OperationType = 0
	// A create folder operation.
	FolderOperation_CREATE FolderOperation_OperationType = 1
	// A move folder operation.
	FolderOperation_MOVE FolderOperation_OperationType = 2
)

var FolderOperation_OperationType_name = map[int32]string{
	0: "OPERATION_TYPE_UNSPECIFIED",
	1: "CREATE",
	2: "MOVE",
}
var FolderOperation_OperationType_value = map[string]int32{
	"OPERATION_TYPE_UNSPECIFIED": 0,
	"CREATE":                     1,
	"MOVE":                       2,
}

func (x FolderOperation_OperationType) String() string {
	return proto.EnumName(FolderOperation_OperationType_name, int32(x))
}
func (FolderOperation_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{11, 0}
}

// A Folder in an Organization's resource hierarchy, used to
// organize that Organization's resources.
type Folder struct {
	// Output only. The resource name of the Folder.
	// Its format is `folders/{folder_id}`, for example: "folders/1234".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Folder’s parent's resource name.
	// Updates to the folder's parent must be performed via [MoveFolders].
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The folder’s display name.
	// A folder’s display name must be unique amongst its siblings, e.g.
	// no two folders with the same parent can share the same display name.
	// The display name must start and end with a letter or digit, may contain
	// letters, digits, spaces, hyphens and underscores and can be no longer
	// than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]({\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only.  The lifecycle state of the folder.
	// Updates to the lifecycle_state must be performed via
	// [DeleteFolder] and [UndeleteFolder].
	LifecycleState Folder_LifecycleState `protobuf:"varint,4,opt,name=lifecycle_state,json=lifecycleState,proto3,enum=google.cloud.resourcemanager.v2.Folder_LifecycleState" json:"lifecycle_state,omitempty"`
	// Output only. Timestamp when the Folder was created. Assigned by the server.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when the Folder was last modified.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Folder) Reset()         { *m = Folder{} }
func (m *Folder) String() string { return proto.CompactTextString(m) }
func (*Folder) ProtoMessage()    {}
func (*Folder) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{0}
}
func (m *Folder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Folder.Unmarshal(m, b)
}
func (m *Folder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Folder.Marshal(b, m, deterministic)
}
func (dst *Folder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Folder.Merge(dst, src)
}
func (m *Folder) XXX_Size() int {
	return xxx_messageInfo_Folder.Size(m)
}
func (m *Folder) XXX_DiscardUnknown() {
	xxx_messageInfo_Folder.DiscardUnknown(m)
}

var xxx_messageInfo_Folder proto.InternalMessageInfo

func (m *Folder) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Folder) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Folder) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Folder) GetLifecycleState() Folder_LifecycleState {
	if m != nil {
		return m.LifecycleState
	}
	return Folder_LIFECYCLE_STATE_UNSPECIFIED
}

func (m *Folder) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Folder) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// The ListFolders request message.
type ListFoldersRequest struct {
	// The resource name of the Organization or Folder whose Folders are
	// being listed.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	// Access to this method is controlled by checking the
	// `resourcemanager.folders.list` permission on the `parent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Folders to return in the response.
	// This field is optional.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to `ListFolders`
	// that indicates where this listing should continue from.
	// This field is optional.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Controls whether Folders in the [DELETE_REQUESTED} state should
	// be returned.
	ShowDeleted          bool     `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersRequest) Reset()         { *m = ListFoldersRequest{} }
func (m *ListFoldersRequest) String() string { return proto.CompactTextString(m) }
func (*ListFoldersRequest) ProtoMessage()    {}
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{1}
}
func (m *ListFoldersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersRequest.Unmarshal(m, b)
}
func (m *ListFoldersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersRequest.Marshal(b, m, deterministic)
}
func (dst *ListFoldersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersRequest.Merge(dst, src)
}
func (m *ListFoldersRequest) XXX_Size() int {
	return xxx_messageInfo_ListFoldersRequest.Size(m)
}
func (m *ListFoldersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersRequest proto.InternalMessageInfo

func (m *ListFoldersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListFoldersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFoldersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFoldersRequest) GetShowDeleted() bool {
	if m != nil {
		return m.ShowDeleted
	}
	return false
}

// The ListFolders response message.
type ListFoldersResponse struct {
	// A possibly paginated list of Folders that are direct descendants of
	// the specified parent resource.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// A pagination token returned from a previous call to `ListFolders`
	// that indicates from where listing should continue.
	// This field is optional.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFoldersResponse) Reset()         { *m = ListFoldersResponse{} }
func (m *ListFoldersResponse) String() string { return proto.CompactTextString(m) }
func (*ListFoldersResponse) ProtoMessage()    {}
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{2}
}
func (m *ListFoldersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFoldersResponse.Unmarshal(m, b)
}
func (m *ListFoldersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFoldersResponse.Marshal(b, m, deterministic)
}
func (dst *ListFoldersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFoldersResponse.Merge(dst, src)
}
func (m *ListFoldersResponse) XXX_Size() int {
	return xxx_messageInfo_ListFoldersResponse.Size(m)
}
func (m *ListFoldersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFoldersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFoldersResponse proto.InternalMessageInfo

func (m *ListFoldersResponse) GetFolders() []*Folder {
	if m != nil {
		return m.Folders
	}
	return nil
}

func (m *ListFoldersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for searching folders.
type SearchFoldersRequest struct {
	// The maximum number of folders to return in the response.
	// This field is optional.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to `SearchFolders`
	// that indicates from where search should continue.
	// This field is optional.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Search criteria used to select the Folders to return.
	// If no search criteria is specified then all accessible folders will be
	// returned.
	//
	// Query expressions can be used to restrict results based upon displayName,
	// lifecycleState and parent, where the operators `=`, `NOT`, `AND` and `OR`
	// can be used along with the suffix wildcard symbol `*`.
	//
	// Some example queries are:
	// |Query|Description|
	// |------|-----------|
	// |displayName=Test*|Folders whose display name starts with "Test".|
	// |lifecycleState=ACTIVE|Folders whose lifecycleState is ACTIVE.|
	// |parent=folders/123|Folders whose parent is "folders/123".|
	// |parent=folders/123 AND lifecycleState=ACTIVE|Active folders whose
	// parent is "folders/123".|
	Query                string   `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchFoldersRequest) Reset()         { *m = SearchFoldersRequest{} }
func (m *SearchFoldersRequest) String() string { return proto.CompactTextString(m) }
func (*SearchFoldersRequest) ProtoMessage()    {}
func (*SearchFoldersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{3}
}
func (m *SearchFoldersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchFoldersRequest.Unmarshal(m, b)
}
func (m *SearchFoldersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchFoldersRequest.Marshal(b, m, deterministic)
}
func (dst *SearchFoldersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchFoldersRequest.Merge(dst, src)
}
func (m *SearchFoldersRequest) XXX_Size() int {
	return xxx_messageInfo_SearchFoldersRequest.Size(m)
}
func (m *SearchFoldersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchFoldersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchFoldersRequest proto.InternalMessageInfo

func (m *SearchFoldersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchFoldersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchFoldersRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

// The response message for searching folders.
type SearchFoldersResponse struct {
	// A possibly paginated folder search results.
	// the specified parent resource.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// A pagination token returned from a previous call to `SearchFolders`
	// that indicates from where searching should continue.
	// This field is optional.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchFoldersResponse) Reset()         { *m = SearchFoldersResponse{} }
func (m *SearchFoldersResponse) String() string { return proto.CompactTextString(m) }
func (*SearchFoldersResponse) ProtoMessage()    {}
func (*SearchFoldersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{4}
}
func (m *SearchFoldersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchFoldersResponse.Unmarshal(m, b)
}
func (m *SearchFoldersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchFoldersResponse.Marshal(b, m, deterministic)
}
func (dst *SearchFoldersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchFoldersResponse.Merge(dst, src)
}
func (m *SearchFoldersResponse) XXX_Size() int {
	return xxx_messageInfo_SearchFoldersResponse.Size(m)
}
func (m *SearchFoldersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchFoldersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchFoldersResponse proto.InternalMessageInfo

func (m *SearchFoldersResponse) GetFolders() []*Folder {
	if m != nil {
		return m.Folders
	}
	return nil
}

func (m *SearchFoldersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The GetFolder request message.
type GetFolderRequest struct {
	// The resource name of the Folder to retrieve.
	// Must be of the form `folders/{folder_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFolderRequest) Reset()         { *m = GetFolderRequest{} }
func (m *GetFolderRequest) String() string { return proto.CompactTextString(m) }
func (*GetFolderRequest) ProtoMessage()    {}
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{5}
}
func (m *GetFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFolderRequest.Unmarshal(m, b)
}
func (m *GetFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFolderRequest.Marshal(b, m, deterministic)
}
func (dst *GetFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFolderRequest.Merge(dst, src)
}
func (m *GetFolderRequest) XXX_Size() int {
	return xxx_messageInfo_GetFolderRequest.Size(m)
}
func (m *GetFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFolderRequest proto.InternalMessageInfo

func (m *GetFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The CreateFolder request message.
type CreateFolderRequest struct {
	// The resource name of the new Folder's parent.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The Folder being created, only the display name will be consulted.
	// All other fields will be ignored.
	Folder               *Folder  `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFolderRequest) Reset()         { *m = CreateFolderRequest{} }
func (m *CreateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFolderRequest) ProtoMessage()    {}
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{6}
}
func (m *CreateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFolderRequest.Unmarshal(m, b)
}
func (m *CreateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFolderRequest.Marshal(b, m, deterministic)
}
func (dst *CreateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFolderRequest.Merge(dst, src)
}
func (m *CreateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFolderRequest.Size(m)
}
func (m *CreateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFolderRequest proto.InternalMessageInfo

func (m *CreateFolderRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFolderRequest) GetFolder() *Folder {
	if m != nil {
		return m.Folder
	}
	return nil
}

// The MoveFolder request message.
type MoveFolderRequest struct {
	// The resource name of the Folder to move.
	// Must be of the form folders/{folder_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name of the Folder or Organization to reparent
	// the folder under.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	DestinationParent    string   `protobuf:"bytes,2,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveFolderRequest) Reset()         { *m = MoveFolderRequest{} }
func (m *MoveFolderRequest) String() string { return proto.CompactTextString(m) }
func (*MoveFolderRequest) ProtoMessage()    {}
func (*MoveFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{7}
}
func (m *MoveFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveFolderRequest.Unmarshal(m, b)
}
func (m *MoveFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveFolderRequest.Marshal(b, m, deterministic)
}
func (dst *MoveFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveFolderRequest.Merge(dst, src)
}
func (m *MoveFolderRequest) XXX_Size() int {
	return xxx_messageInfo_MoveFolderRequest.Size(m)
}
func (m *MoveFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveFolderRequest proto.InternalMessageInfo

func (m *MoveFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MoveFolderRequest) GetDestinationParent() string {
	if m != nil {
		return m.DestinationParent
	}
	return ""
}

// The request message for updating a folder's display name.
type UpdateFolderRequest struct {
	// The new definition of the Folder. It must include a
	// a `name` and `display_name` field. The other fields
	// will be ignored.
	Folder *Folder `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	// Fields to be updated.
	// Only the `display_name` can be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFolderRequest) Reset()         { *m = UpdateFolderRequest{} }
func (m *UpdateFolderRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFolderRequest) ProtoMessage()    {}
func (*UpdateFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{8}
}
func (m *UpdateFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFolderRequest.Unmarshal(m, b)
}
func (m *UpdateFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFolderRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFolderRequest.Merge(dst, src)
}
func (m *UpdateFolderRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFolderRequest.Size(m)
}
func (m *UpdateFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFolderRequest proto.InternalMessageInfo

func (m *UpdateFolderRequest) GetFolder() *Folder {
	if m != nil {
		return m.Folder
	}
	return nil
}

func (m *UpdateFolderRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The DeleteFolder request message.
type DeleteFolderRequest struct {
	// the resource name of the Folder to be deleted.
	// Must be of the form `folders/{folder_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Instructs DeleteFolderAction to delete a folder even when the folder is not
	// empty.
	RecursiveDelete      bool     `protobuf:"varint,2,opt,name=recursive_delete,json=recursiveDelete,proto3" json:"recursive_delete,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFolderRequest) Reset()         { *m = DeleteFolderRequest{} }
func (m *DeleteFolderRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFolderRequest) ProtoMessage()    {}
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{9}
}
func (m *DeleteFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFolderRequest.Unmarshal(m, b)
}
func (m *DeleteFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFolderRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFolderRequest.Merge(dst, src)
}
func (m *DeleteFolderRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFolderRequest.Size(m)
}
func (m *DeleteFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFolderRequest proto.InternalMessageInfo

func (m *DeleteFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteFolderRequest) GetRecursiveDelete() bool {
	if m != nil {
		return m.RecursiveDelete
	}
	return false
}

// The UndeleteFolder request message.
type UndeleteFolderRequest struct {
	// The resource name of the Folder to undelete.
	// Must be of the form `folders/{folder_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeleteFolderRequest) Reset()         { *m = UndeleteFolderRequest{} }
func (m *UndeleteFolderRequest) String() string { return proto.CompactTextString(m) }
func (*UndeleteFolderRequest) ProtoMessage()    {}
func (*UndeleteFolderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{10}
}
func (m *UndeleteFolderRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeleteFolderRequest.Unmarshal(m, b)
}
func (m *UndeleteFolderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeleteFolderRequest.Marshal(b, m, deterministic)
}
func (dst *UndeleteFolderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeleteFolderRequest.Merge(dst, src)
}
func (m *UndeleteFolderRequest) XXX_Size() int {
	return xxx_messageInfo_UndeleteFolderRequest.Size(m)
}
func (m *UndeleteFolderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeleteFolderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeleteFolderRequest proto.InternalMessageInfo

func (m *UndeleteFolderRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Metadata describing a long running folder operation
type FolderOperation struct {
	// The display name of the folder.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of this operation.
	OperationType FolderOperation_OperationType `protobuf:"varint,2,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.resourcemanager.v2.FolderOperation_OperationType" json:"operation_type,omitempty"`
	// The resource name of the folder's parent.
	// Only applicable when the operation_type is MOVE.
	SourceParent string `protobuf:"bytes,3,opt,name=source_parent,json=sourceParent,proto3" json:"source_parent,omitempty"`
	// The resource name of the folder or organization we are either creating
	// the folder under or moving the folder to.
	DestinationParent    string   `protobuf:"bytes,4,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FolderOperation) Reset()         { *m = FolderOperation{} }
func (m *FolderOperation) String() string { return proto.CompactTextString(m) }
func (*FolderOperation) ProtoMessage()    {}
func (*FolderOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_folders_6c4bd17feec38232, []int{11}
}
func (m *FolderOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FolderOperation.Unmarshal(m, b)
}
func (m *FolderOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FolderOperation.Marshal(b, m, deterministic)
}
func (dst *FolderOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FolderOperation.Merge(dst, src)
}
func (m *FolderOperation) XXX_Size() int {
	return xxx_messageInfo_FolderOperation.Size(m)
}
func (m *FolderOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_FolderOperation.DiscardUnknown(m)
}

var xxx_messageInfo_FolderOperation proto.InternalMessageInfo

func (m *FolderOperation) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *FolderOperation) GetOperationType() FolderOperation_OperationType {
	if m != nil {
		return m.OperationType
	}
	return FolderOperation_OPERATION_TYPE_UNSPECIFIED
}

func (m *FolderOperation) GetSourceParent() string {
	if m != nil {
		return m.SourceParent
	}
	return ""
}

func (m *FolderOperation) GetDestinationParent() string {
	if m != nil {
		return m.DestinationParent
	}
	return ""
}

func init() {
	proto.RegisterType((*Folder)(nil), "google.cloud.resourcemanager.v2.Folder")
	proto.RegisterType((*ListFoldersRequest)(nil), "google.cloud.resourcemanager.v2.ListFoldersRequest")
	proto.RegisterType((*ListFoldersResponse)(nil), "google.cloud.resourcemanager.v2.ListFoldersResponse")
	proto.RegisterType((*SearchFoldersRequest)(nil), "google.cloud.resourcemanager.v2.SearchFoldersRequest")
	proto.RegisterType((*SearchFoldersResponse)(nil), "google.cloud.resourcemanager.v2.SearchFoldersResponse")
	proto.RegisterType((*GetFolderRequest)(nil), "google.cloud.resourcemanager.v2.GetFolderRequest")
	proto.RegisterType((*CreateFolderRequest)(nil), "google.cloud.resourcemanager.v2.CreateFolderRequest")
	proto.RegisterType((*MoveFolderRequest)(nil), "google.cloud.resourcemanager.v2.MoveFolderRequest")
	proto.RegisterType((*UpdateFolderRequest)(nil), "google.cloud.resourcemanager.v2.UpdateFolderRequest")
	proto.RegisterType((*DeleteFolderRequest)(nil), "google.cloud.resourcemanager.v2.DeleteFolderRequest")
	proto.RegisterType((*UndeleteFolderRequest)(nil), "google.cloud.resourcemanager.v2.UndeleteFolderRequest")
	proto.RegisterType((*FolderOperation)(nil), "google.cloud.resourcemanager.v2.FolderOperation")
	proto.RegisterEnum("google.cloud.resourcemanager.v2.Folder_LifecycleState", Folder_LifecycleState_name, Folder_LifecycleState_value)
	proto.RegisterEnum("google.cloud.resourcemanager.v2.FolderOperation_OperationType", FolderOperation_OperationType_name, FolderOperation_OperationType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FoldersClient is the client API for Folders service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FoldersClient interface {
	// Lists the Folders that are direct descendants of supplied parent resource.
	// List provides a strongly consistent view of the Folders underneath
	// the specified parent resource.
	// List returns Folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// Search provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error)
	// Retrieves a Folder identified by the supplied resource name.
	// Valid Folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Creates a Folder in the resource hierarchy.
	// Returns an Operation which can be used to track the progress of the
	// folder creation workflow.
	// Upon success the Operation.response field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new Folder must not violate
	// the Folder naming, height or fanout constraints.
	// + The Folder's display_name must be distinct from all other Folder's that
	// share its parent.
	// + The addition of the Folder must not cause the active Folder hierarchy
	// to exceed a height of 4. Note, the full active + deleted Folder hierarchy
	// is allowed to reach a height of 8; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the Folder must not cause the total number of Folders
	// under its parent to exceed 100.
	//
	// If the operation fails due to a folder constraint violation,
	// a PreconditionFailure explaining the violation will be returned.
	// If the failure occurs synchronously then the PreconditionFailure
	// will be returned via the Status.details field and if it occurs
	// asynchronously then the PreconditionFailure will be returned
	// via the the Operation.error field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a Folder, changing its display_name.
	// Changes to the folder display_name will be rejected if they violate either
	// the display_name formatting rules or naming constraints described in
	// the [CreateFolder] documentation.
	// + The Folder's display name must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// no longer than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]({\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// PreconditionFailure explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Moves a Folder under a new resource parent.
	// Returns an Operation which can be used to track the progress of the
	// folder move workflow.
	// Upon success the Operation.response field will be populated with the
	// moved Folder.
	// Upon failure, a FolderOperationError categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// FolderOperationError will be returned via the Status.details field
	// and if it occurs asynchronously then the FolderOperation will be returned
	// via the the Operation.error field.
	// In addition, the Operation.metadata field will be populated with a
	// FolderOperation message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height
	// or fanout constraints described in the [CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.move` permission on the
	// folder's current and proposed new parent.
	MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Requests deletion of a Folder. The Folder is moved into the
	// [DELETE_REQUESTED] state immediately, and is deleted approximately 30 days
	// later. This method may only be called on an empty Folder in the [ACTIVE]
	// state, where a Folder is empty if it doesn't contain any Folders or
	// Projects in the [ACTIVE] state.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Cancels the deletion request for a Folder. This method may only be
	// called on a Folder in the [DELETE_REQUESTED] state.
	// In order to succeed, the Folder's parent must be in the [ACTIVE] state.
	// In addition, reintroducing the folder into the tree must not violate
	// folder naming, height and fanout constraints described in the
	// [CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.undelete` permission on the
	// identified folder.
	UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Gets the access control policy for a Folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the Folder's resource name, e.g. "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on a Folder, replacing any existing policy.
	// The `resource` field should be the Folder's resource name, e.g.
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified Folder.
	// The `resource` field should be the Folder's resource name,
	// e.g. "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type foldersClient struct {
	cc *grpc.ClientConn
}

func NewFoldersClient(cc *grpc.ClientConn) FoldersClient {
	return &foldersClient{cc}
}

func (c *foldersClient) ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/ListFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error) {
	out := new(SearchFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/SearchFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/GetFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/CreateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/UpdateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/MoveFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/DeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/UndeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FoldersServer is the server API for Folders service.
type FoldersServer interface {
	// Lists the Folders that are direct descendants of supplied parent resource.
	// List provides a strongly consistent view of the Folders underneath
	// the specified parent resource.
	// List returns Folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// Search provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(context.Context, *SearchFoldersRequest) (*SearchFoldersResponse, error)
	// Retrieves a Folder identified by the supplied resource name.
	// Valid Folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(context.Context, *GetFolderRequest) (*Folder, error)
	// Creates a Folder in the resource hierarchy.
	// Returns an Operation which can be used to track the progress of the
	// folder creation workflow.
	// Upon success the Operation.response field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new Folder must not violate
	// the Folder naming, height or fanout constraints.
	// + The Folder's display_name must be distinct from all other Folder's that
	// share its parent.
	// + The addition of the Folder must not cause the active Folder hierarchy
	// to exceed a height of 4. Note, the full active + deleted Folder hierarchy
	// is allowed to reach a height of 8; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the Folder must not cause the total number of Folders
	// under its parent to exceed 100.
	//
	// If the operation fails due to a folder constraint violation,
	// a PreconditionFailure explaining the violation will be returned.
	// If the failure occurs synchronously then the PreconditionFailure
	// will be returned via the Status.details field and if it occurs
	// asynchronously then the PreconditionFailure will be returned
	// via the the Operation.error field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(context.Context, *CreateFolderRequest) (*longrunning.Operation, error)
	// Updates a Folder, changing its display_name.
	// Changes to the folder display_name will be rejected if they violate either
	// the display_name formatting rules or naming constraints described in
	// the [CreateFolder] documentation.
	// + The Folder's display name must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// no longer than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]({\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// PreconditionFailure explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(context.Context, *UpdateFolderRequest) (*Folder, error)
	// Moves a Folder under a new resource parent.
	// Returns an Operation which can be used to track the progress of the
	// folder move workflow.
	// Upon success the Operation.response field will be populated with the
	// moved Folder.
	// Upon failure, a FolderOperationError categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// FolderOperationError will be returned via the Status.details field
	// and if it occurs asynchronously then the FolderOperation will be returned
	// via the the Operation.error field.
	// In addition, the Operation.metadata field will be populated with a
	// FolderOperation message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height
	// or fanout constraints described in the [CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.move` permission on the
	// folder's current and proposed new parent.
	MoveFolder(context.Context, *MoveFolderRequest) (*longrunning.Operation, error)
	// Requests deletion of a Folder. The Folder is moved into the
	// [DELETE_REQUESTED] state immediately, and is deleted approximately 30 days
	// later. This method may only be called on an empty Folder in the [ACTIVE]
	// state, where a Folder is empty if it doesn't contain any Folders or
	// Projects in the [ACTIVE] state.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(context.Context, *DeleteFolderRequest) (*Folder, error)
	// Cancels the deletion request for a Folder. This method may only be
	// called on a Folder in the [DELETE_REQUESTED] state.
	// In order to succeed, the Folder's parent must be in the [ACTIVE] state.
	// In addition, reintroducing the folder into the tree must not violate
	// folder naming, height and fanout constraints described in the
	// [CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.undelete` permission on the
	// identified folder.
	UndeleteFolder(context.Context, *UndeleteFolderRequest) (*Folder, error)
	// Gets the access control policy for a Folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the Folder's resource name, e.g. "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on a Folder, replacing any existing policy.
	// The `resource` field should be the Folder's resource name, e.g.
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified Folder.
	// The `resource` field should be the Folder's resource name,
	// e.g. "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

func RegisterFoldersServer(s *grpc.Server, srv FoldersServer) {
	s.RegisterService(&_Folders_serviceDesc, srv)
}

func _Folders_ListFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).ListFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/ListFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).ListFolders(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SearchFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SearchFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/SearchFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SearchFolders(ctx, req.(*SearchFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/GetFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetFolder(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_CreateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).CreateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/CreateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).CreateFolder(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UpdateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UpdateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/UpdateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UpdateFolder(ctx, req.(*UpdateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_MoveFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).MoveFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/MoveFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).MoveFolder(ctx, req.(*MoveFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_DeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).DeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/DeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).DeleteFolder(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UndeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UndeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/UndeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UndeleteFolder(ctx, req.(*UndeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Folders_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v2.Folders",
	HandlerType: (*FoldersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFolders",
			Handler:    _Folders_ListFolders_Handler,
		},
		{
			MethodName: "SearchFolders",
			Handler:    _Folders_SearchFolders_Handler,
		},
		{
			MethodName: "GetFolder",
			Handler:    _Folders_GetFolder_Handler,
		},
		{
			MethodName: "CreateFolder",
			Handler:    _Folders_CreateFolder_Handler,
		},
		{
			MethodName: "UpdateFolder",
			Handler:    _Folders_UpdateFolder_Handler,
		},
		{
			MethodName: "MoveFolder",
			Handler:    _Folders_MoveFolder_Handler,
		},
		{
			MethodName: "DeleteFolder",
			Handler:    _Folders_DeleteFolder_Handler,
		},
		{
			MethodName: "UndeleteFolder",
			Handler:    _Folders_UndeleteFolder_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Folders_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Folders_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Folders_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v2/folders.proto",
}

func init() {
	proto.RegisterFile("google/cloud/resourcemanager/v2/folders.proto", fileDescriptor_folders_6c4bd17feec38232)
}

var fileDescriptor_folders_6c4bd17feec38232 = []byte{
	// 1235 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0x5d, 0x6f, 0xdb, 0xd4,
	0x1b, 0xff, 0x9f, 0xac, 0xcb, 0xba, 0x27, 0x2f, 0xcd, 0x4e, 0xdb, 0xfd, 0x4b, 0xba, 0xbe, 0x70,
	0xca, 0x46, 0xd6, 0x6a, 0xce, 0x9a, 0x41, 0x2f, 0x3a, 0x01, 0xea, 0x52, 0xb7, 0x8a, 0xd4, 0x97,
	0xe0, 0xb8, 0x95, 0x86, 0x2a, 0x59, 0x5e, 0x72, 0x9a, 0x5a, 0x75, 0x6c, 0xcf, 0x76, 0x02, 0xd9,
	0x84, 0x34, 0x4d, 0x9a, 0xb8, 0x98, 0xb8, 0xda, 0x1d, 0x88, 0x0b, 0x6e, 0xb9, 0x45, 0xe2, 0x3b,
	0xc0, 0x2d, 0x5f, 0x81, 0x0f, 0x82, 0x7c, 0x7c, 0x9c, 0xda, 0x4e, 0x3a, 0xa7, 0x08, 0x71, 0x55,
	0xfb, 0x79, 0xfd, 0x3d, 0x6f, 0xbf, 0x3a, 0xf0, 0xa0, 0x6d, 0x9a, 0x6d, 0x9d, 0x96, 0x9b, 0xba,
	0xd9, 0x6d, 0x95, 0x6d, 0xea, 0x98, 0x5d, 0xbb, 0x49, 0x3b, 0xaa, 0xa1, 0xb6, 0xa9, 0x5d, 0xee,
	0x55, 0xca, 0xa7, 0xa6, 0xde, 0xa2, 0xb6, 0x23, 0x58, 0xb6, 0xe9, 0x9a, 0x78, 0xc9, 0x37, 0x17,
	0x98, 0xb9, 0x10, 0x33, 0x17, 0x7a, 0x95, 0xe2, 0x1d, 0x1e, 0x4f, 0xb5, 0xb4, 0xb2, 0x6a, 0x18,
	0xa6, 0xab, 0xba, 0x9a, 0x69, 0x70, 0xf7, 0xe2, 0x22, 0xd7, 0x6a, 0x6a, 0xa7, 0xdc, 0x5b, 0xf7,
	0xfe, 0x28, 0x96, 0xa9, 0x6b, 0xcd, 0x3e, 0xd7, 0x17, 0xa3, 0xfa, 0x88, 0x6e, 0x85, 0xeb, 0x74,
	0xd3, 0x68, 0xdb, 0x5d, 0xc3, 0xd0, 0x8c, 0x76, 0xd9, 0xb4, 0xa8, 0x1d, 0x49, 0xb0, 0xcc, 0x8d,
	0xd8, 0xdb, 0xb3, 0xee, 0x69, 0xf9, 0x54, 0xa3, 0x7a, 0x4b, 0xe9, 0xa8, 0xce, 0x39, 0xb7, 0x58,
	0x8a, 0x5b, 0xb8, 0x5a, 0x87, 0x3a, 0xae, 0xda, 0xb1, 0x7c, 0x03, 0xf2, 0xdd, 0x35, 0x48, 0xef,
	0xb0, 0xa2, 0x31, 0x86, 0x09, 0x43, 0xed, 0xd0, 0x39, 0xb4, 0x8c, 0x4a, 0x37, 0x25, 0xf6, 0x8c,
	0x6f, 0x43, 0xda, 0x52, 0x6d, 0x6a, 0xb8, 0x73, 0x29, 0x26, 0xe5, 0x6f, 0xf8, 0x43, 0xc8, 0xb6,
	0x34, 0xc7, 0xd2, 0xd5, 0xbe, 0xc2, 0x7c, 0xae, 0x31, 0x6d, 0x86, 0xcb, 0x0e, 0x3c, 0x57, 0x05,
	0xa6, 0x74, 0xed, 0x94, 0x36, 0xfb, 0x4d, 0x9d, 0x2a, 0x8e, 0xab, 0xba, 0x74, 0x6e, 0x62, 0x19,
	0x95, 0xf2, 0x95, 0x0d, 0x21, 0xa1, 0xad, 0x82, 0x0f, 0x48, 0xd8, 0x0b, 0xdc, 0x1b, 0x9e, 0xb7,
	0x94, 0xd7, 0x23, 0xef, 0xf8, 0x31, 0x64, 0x9a, 0x36, 0x55, 0x5d, 0xaa, 0x78, 0x45, 0xcd, 0x5d,
	0x5f, 0x46, 0xa5, 0x4c, 0xa5, 0x18, 0x04, 0x0f, 0x2a, 0x16, 0xe4, 0xa0, 0x62, 0x09, 0x7c, 0x73,
	0x4f, 0xe0, 0x39, 0x77, 0xad, 0xd6, 0xc0, 0x39, 0x9d, 0xec, 0xec, 0x9b, 0x7b, 0x02, 0xd2, 0x80,
	0x7c, 0x14, 0x1b, 0x5e, 0x82, 0xf9, 0xbd, 0xda, 0x8e, 0x58, 0x7d, 0x5a, 0xdd, 0x13, 0x95, 0x86,
	0xbc, 0x25, 0x8b, 0xca, 0xd1, 0x41, 0xa3, 0x2e, 0x56, 0x6b, 0x3b, 0x35, 0x71, 0xbb, 0xf0, 0x3f,
	0x0c, 0x90, 0xde, 0xaa, 0xca, 0xb5, 0x63, 0xb1, 0x80, 0xf0, 0x0c, 0x14, 0xb6, 0xc5, 0x3d, 0x51,
	0x16, 0x15, 0x49, 0xfc, 0xf2, 0x48, 0x6c, 0xc8, 0xe2, 0x76, 0x21, 0x45, 0xde, 0x22, 0xc0, 0x7b,
	0x9a, 0xe3, 0xfa, 0xc5, 0x3b, 0x12, 0x7d, 0xde, 0xa5, 0x8e, 0x1b, 0x9a, 0x00, 0x8a, 0x4c, 0x60,
	0x1e, 0x6e, 0x5a, 0x6a, 0x9b, 0x2a, 0x8e, 0xf6, 0x82, 0xb2, 0xe1, 0x5c, 0x97, 0x26, 0x3d, 0x41,
	0x43, 0x7b, 0x41, 0xf1, 0x02, 0x00, 0x53, 0xba, 0xe6, 0x39, 0x35, 0xf8, 0x70, 0x98, 0xb9, 0xec,
	0x09, 0xbc, 0xe9, 0x39, 0x67, 0xe6, 0xd7, 0x4a, 0x8b, 0xea, 0xd4, 0xa5, 0x2d, 0x36, 0x97, 0x49,
	0x29, 0xe3, 0xc9, 0xb6, 0x7d, 0x11, 0x79, 0x85, 0x60, 0x3a, 0x82, 0xc6, 0xb1, 0x4c, 0xc3, 0xa1,
	0x78, 0x0b, 0x6e, 0xf0, 0x1b, 0x99, 0x43, 0xcb, 0xd7, 0x4a, 0x99, 0xca, 0xc7, 0x63, 0x4e, 0x53,
	0x0a, 0xfc, 0xf0, 0x3d, 0x98, 0x32, 0xe8, 0x37, 0xae, 0x12, 0x42, 0xe8, 0x2f, 0x57, 0xce, 0x13,
	0xd7, 0x03, 0x94, 0xe4, 0x0c, 0x66, 0x1a, 0x54, 0xb5, 0x9b, 0x67, 0xb1, 0x8e, 0x44, 0x2a, 0x47,
	0xef, 0xad, 0x3c, 0x15, 0xaf, 0x7c, 0x06, 0xae, 0x3f, 0xef, 0x52, 0xbb, 0xcf, 0x7b, 0xe2, 0xbf,
	0x90, 0xd7, 0x08, 0x66, 0x63, 0xa9, 0xfe, 0xfb, 0x72, 0xef, 0x41, 0x61, 0x97, 0xf2, 0x7e, 0x07,
	0xa5, 0x8e, 0x38, 0x49, 0x62, 0xc0, 0x74, 0x95, 0xed, 0x71, 0xd4, 0xf4, 0xb2, 0x3d, 0xf9, 0x02,
	0xd2, 0x3e, 0x12, 0x96, 0xf5, 0x0a, 0x05, 0x70, 0x37, 0x72, 0x0c, 0xb7, 0xf6, 0xcd, 0x1e, 0x4d,
	0x04, 0x86, 0x1f, 0x00, 0x6e, 0x51, 0xc7, 0xd5, 0x0c, 0xc6, 0x51, 0x4a, 0x84, 0x37, 0x6e, 0x85,
	0x34, 0x75, 0xa6, 0x20, 0xef, 0x10, 0x4c, 0x1f, 0xb1, 0x9b, 0x8a, 0x86, 0xbe, 0x00, 0x8c, 0xfe,
	0x11, 0xe0, 0xd0, 0x69, 0x7b, 0x44, 0xc8, 0xcb, 0x1e, 0x3e, 0xed, 0x1d, 0x8f, 0x2b, 0xf7, 0x55,
	0xe7, 0x3c, 0x38, 0x6d, 0xef, 0x99, 0xc8, 0x30, 0xed, 0x9f, 0x40, 0x72, 0xbd, 0xf7, 0xa1, 0x60,
	0xd3, 0x66, 0xd7, 0x76, 0xb4, 0x1e, 0xe5, 0xa7, 0xc4, 0x92, 0x4d, 0x4a, 0x53, 0x03, 0xb9, 0x1f,
	0x8b, 0xac, 0xc1, 0xec, 0x91, 0xd1, 0x1a, 0x2f, 0x2e, 0xf9, 0x2d, 0x05, 0x53, 0xbe, 0xd5, 0x61,
	0x40, 0xf8, 0x43, 0x7c, 0x8b, 0x86, 0xf9, 0x96, 0x42, 0x7e, 0xf0, 0x0f, 0x42, 0x71, 0xfb, 0x96,
	0x0f, 0x26, 0x5f, 0xf9, 0x7c, 0xcc, 0xfe, 0x0d, 0x92, 0x09, 0x83, 0x27, 0xb9, 0x6f, 0x51, 0x29,
	0x67, 0x86, 0x5f, 0xf1, 0x0a, 0xe4, 0xfc, 0x00, 0xc1, 0x80, 0xfd, 0x4b, 0xca, 0xfa, 0x42, 0x7f,
	0xb6, 0x97, 0xac, 0xc2, 0xc4, 0x65, 0xab, 0x20, 0x42, 0x2e, 0x92, 0x13, 0x2f, 0x42, 0xf1, 0xb0,
	0x2e, 0x4a, 0x5b, 0x72, 0xed, 0xf0, 0x40, 0x91, 0x9f, 0xd6, 0x47, 0xb0, 0x69, 0x55, 0x12, 0xb7,
	0x64, 0x8f, 0x4d, 0x27, 0x61, 0x62, 0xff, 0xf0, 0x58, 0x2c, 0xa4, 0x2a, 0xbf, 0x66, 0xe1, 0x06,
	0x3f, 0x60, 0xfc, 0x3d, 0x82, 0x4c, 0x88, 0xbf, 0xf0, 0xa3, 0xc4, 0x2e, 0x0c, 0x73, 0x6f, 0xf1,
	0x93, 0xab, 0x39, 0xf9, 0x9c, 0x41, 0xa6, 0x5f, 0xff, 0xf9, 0xd7, 0xbb, 0x54, 0x0e, 0x67, 0x42,
	0x1f, 0x14, 0xf8, 0x27, 0x04, 0xb9, 0x08, 0xc5, 0xe0, 0x4f, 0x13, 0x83, 0x8f, 0x62, 0xbf, 0xe2,
	0xc6, 0x55, 0xdd, 0x38, 0xaa, 0x05, 0x86, 0xea, 0xff, 0x04, 0x87, 0x50, 0x6d, 0x3a, 0xcc, 0x74,
	0x13, 0xad, 0xe2, 0x37, 0x08, 0x6e, 0x0e, 0xe8, 0x07, 0xaf, 0x27, 0x26, 0x89, 0x53, 0x55, 0x71,
	0xdc, 0x33, 0x25, 0x77, 0x18, 0x90, 0xdb, 0x78, 0xc6, 0x03, 0xf2, 0xd2, 0xdb, 0xe6, 0xcf, 0x38,
	0x9c, 0xf2, 0xea, 0xb7, 0xf8, 0x15, 0x82, 0x6c, 0x98, 0xde, 0x70, 0xf2, 0x0c, 0x46, 0xb0, 0x61,
	0x71, 0x21, 0xf0, 0x0a, 0x7d, 0x3f, 0x5d, 0xec, 0x35, 0x99, 0x67, 0x18, 0x66, 0x49, 0x78, 0x44,
	0x9b, 0x01, 0x7f, 0xfc, 0x80, 0x20, 0x1b, 0x26, 0xa6, 0x31, 0x20, 0x8c, 0xe0, 0xb1, 0xf1, 0x1b,
	0xb2, 0xc6, 0xc0, 0xdc, 0xad, 0xcc, 0xb3, 0x86, 0xf8, 0x20, 0x84, 0x58, 0x5f, 0x06, 0xe0, 0xde,
	0x20, 0x80, 0x0b, 0x3a, 0xc6, 0x95, 0xc4, 0x24, 0x43, 0xdc, 0x9d, 0xd4, 0x9b, 0x8f, 0x18, 0x9c,
	0x45, 0xf2, 0xc1, 0xa8, 0xf9, 0x6c, 0x76, 0xcc, 0x1e, 0xf5, 0xf6, 0xe5, 0x2d, 0x82, 0x6c, 0x98,
	0x28, 0xc7, 0x68, 0xd2, 0x08, 0x5e, 0xbd, 0xf2, 0xd6, 0xac, 0x8e, 0xde, 0x9a, 0x1f, 0x11, 0xe4,
	0xa3, 0x04, 0x8b, 0x93, 0xef, 0x64, 0x24, 0x23, 0x8f, 0x8f, 0xa8, 0xc4, 0x10, 0x11, 0xb2, 0x30,
	0xb2, 0x4f, 0x5d, 0x1e, 0xdc, 0xeb, 0xd5, 0x4b, 0xc8, 0xee, 0x52, 0xb7, 0xa6, 0x76, 0xea, 0xec,
	0x0b, 0x1f, 0x93, 0x20, 0x85, 0xa6, 0x76, 0x84, 0xde, 0xba, 0x10, 0x56, 0x06, 0x30, 0x66, 0x63,
	0x36, 0xbe, 0x96, 0x3c, 0x64, 0x49, 0x57, 0xc9, 0x5d, 0x96, 0x34, 0x00, 0x17, 0x4e, 0xdc, 0x0e,
	0x05, 0xe3, 0xc9, 0x1b, 0xef, 0x4b, 0xde, 0xf8, 0x37, 0x93, 0x3b, 0xb1, 0xe4, 0x3f, 0x23, 0xc0,
	0x32, 0x75, 0x98, 0x90, 0xda, 0x1d, 0xcd, 0x71, 0xbc, 0x5f, 0x2f, 0xb8, 0x14, 0x8b, 0x3f, 0x6c,
	0x12, 0x20, 0xb9, 0x3f, 0x86, 0x25, 0x27, 0xb8, 0x0d, 0x86, 0xee, 0x21, 0x59, 0xbb, 0x14, 0x9d,
	0x3b, 0xe4, 0xbc, 0x89, 0x56, 0x9f, 0xfc, 0x8e, 0x60, 0xa5, 0x69, 0x76, 0x92, 0xc6, 0xfe, 0x24,
	0xcb, 0x19, 0xb5, 0xee, 0x7d, 0x40, 0xd4, 0xd1, 0x57, 0x07, 0xdc, 0xa1, 0x6d, 0xea, 0xaa, 0xd1,
	0x16, 0x4c, 0xbb, 0x5d, 0x6e, 0x53, 0x83, 0x7d, 0x5e, 0x94, 0x7d, 0x95, 0x6a, 0x69, 0xce, 0xa5,
	0x3f, 0x35, 0x1f, 0xc7, 0x44, 0xbf, 0xa4, 0x96, 0x76, 0xfd, 0x80, 0x55, 0x86, 0x40, 0xe2, 0xea,
	0x7d, 0x8e, 0xe0, 0xb8, 0xf2, 0x47, 0x60, 0x71, 0xc2, 0x2c, 0x4e, 0x62, 0x16, 0x27, 0xc7, 0x95,
	0x67, 0x69, 0x96, 0xfe, 0xd1, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xda, 0x9b, 0x45, 0x8f, 0xe8,
	0x0e, 0x00, 0x00,
}
