// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/profile.proto

package talent

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	_ "google.golang.org/genproto/protobuf/field_mask"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The format of a structured resume.
type Resume_ResumeType int32

const (
	// Default value.
	Resume_RESUME_TYPE_UNSPECIFIED Resume_ResumeType = 0
	// The profile contents in HR-XML format.
	// See http://schemas.liquid-technologies.com/hr-xml/2007-04-15/ for more
	// information about Human Resources XML.
	Resume_HRXML Resume_ResumeType = 1
	// Resume type not specified.
	Resume_OTHER_RESUME_TYPE Resume_ResumeType = 2
)

var Resume_ResumeType_name = map[int32]string{
	0: "RESUME_TYPE_UNSPECIFIED",
	1: "HRXML",
	2: "OTHER_RESUME_TYPE",
}

var Resume_ResumeType_value = map[string]int32{
	"RESUME_TYPE_UNSPECIFIED": 0,
	"HRXML":                   1,
	"OTHER_RESUME_TYPE":       2,
}

func (x Resume_ResumeType) String() string {
	return proto.EnumName(Resume_ResumeType_name, int32(x))
}

func (Resume_ResumeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{1, 0}
}

// Enum that represents the type of the telephone.
type Phone_PhoneType int32

const (
	// Default value.
	Phone_PHONE_TYPE_UNSPECIFIED Phone_PhoneType = 0
	// A landline.
	Phone_LANDLINE Phone_PhoneType = 1
	// A mobile.
	Phone_MOBILE Phone_PhoneType = 2
	// A fax.
	Phone_FAX Phone_PhoneType = 3
	// A pager.
	Phone_PAGER Phone_PhoneType = 4
	// A TTY (test telephone) or TDD (telecommunication device for the deaf).
	Phone_TTY_OR_TDD Phone_PhoneType = 5
	// A voicemail.
	Phone_VOICEMAIL Phone_PhoneType = 6
	// A virtual telephone number is a number that can be routed to another
	// number and managed by the user via Web, SMS, IVR, and so on.  It is
	// associated with a particular person, and may be routed to either a MOBILE
	// or LANDLINE number. The [phone
	// usage][google.cloud.talent.v4beta1.ContactInfoUsage] should be set to
	// PERSONAL for these phone types. Some more information can be found here:
	// http://en.wikipedia.org/wiki/Personal_Numbers
	Phone_VIRTUAL Phone_PhoneType = 7
	// Voice over IP numbers. This includes TSoIP (Telephony Service over IP).
	Phone_VOIP Phone_PhoneType = 8
	// In some regions (e.g. the USA), it is impossible to distinguish between
	// fixed-line and mobile numbers by looking at the phone number itself.
	Phone_MOBILE_OR_LANDLINE Phone_PhoneType = 9
)

var Phone_PhoneType_name = map[int32]string{
	0: "PHONE_TYPE_UNSPECIFIED",
	1: "LANDLINE",
	2: "MOBILE",
	3: "FAX",
	4: "PAGER",
	5: "TTY_OR_TDD",
	6: "VOICEMAIL",
	7: "VIRTUAL",
	8: "VOIP",
	9: "MOBILE_OR_LANDLINE",
}

var Phone_PhoneType_value = map[string]int32{
	"PHONE_TYPE_UNSPECIFIED": 0,
	"LANDLINE":               1,
	"MOBILE":                 2,
	"FAX":                    3,
	"PAGER":                  4,
	"TTY_OR_TDD":             5,
	"VOICEMAIL":              6,
	"VIRTUAL":                7,
	"VOIP":                   8,
	"MOBILE_OR_LANDLINE":     9,
}

func (x Phone_PhoneType) String() string {
	return proto.EnumName(Phone_PhoneType_name, int32(x))
}

func (Phone_PhoneType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{5, 0}
}

// A resource that represents the profile for a job candidate (also referred to
// as a "single-source profile").
type Profile struct {
	// Required during profile update.
	//
	// Resource name assigned to a profile by the API.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/tenants/foo/profiles/bar".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Profile's id in client system if available.
	//
	// The maximum number of bytes allowed is 100.
	ExternalId string `protobuf:"bytes,2,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Optional. The source description indicating where the profile is acquired.
	//
	// For example, if a candidate profile is acquired from a resume, the user can
	// input "resume" here to indicate the source.
	//
	// The maximum number of bytes allowed is 100.
	Source string `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Optional. The URI set by clients that links to this profile's client-side
	// copy.
	//
	// The maximum number of bytes allowed is 4000.
	Uri string `protobuf:"bytes,4,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The cluster id of the profile to associate with other profile(s)
	// for the same candidate.
	//
	// This field should be generated by the customer. If a value is not provided,
	// a random UUID is assigned to this field of the profile.
	//
	// This is used to link multiple profiles to the same candidate. For example,
	// a client has a candidate with two profiles, where one was created recently
	// and the other one was created 5 years ago. These two profiles may be very
	// different. The clients can create the first profile and get a generated
	// [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it
	// when the second profile is created, indicating these two profiles are
	// referring to the same candidate.
	GroupId string `protobuf:"bytes,5,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Optional. Indicates the hirable status of the candidate.
	IsHirable *wrappers.BoolValue `protobuf:"bytes,6,opt,name=is_hirable,json=isHirable,proto3" json:"is_hirable,omitempty"`
	// Optional. The timestamp when the profile was first created at this source.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The timestamp when the profile was last updated at this source.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The resume representing this profile.
	Resume *Resume `protobuf:"bytes,53,opt,name=resume,proto3" json:"resume,omitempty"`
	// Optional. The names of the candidate this profile references.
	//
	// Currently only one person name is supported.
	PersonNames []*PersonName `protobuf:"bytes,11,rep,name=person_names,json=personNames,proto3" json:"person_names,omitempty"`
	// Optional. The candidate's postal addresses.
	Addresses []*Address `protobuf:"bytes,12,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// Optional. The candidate's email addresses.
	EmailAddresses []*Email `protobuf:"bytes,13,rep,name=email_addresses,json=emailAddresses,proto3" json:"email_addresses,omitempty"`
	// Optional. The candidate's phone number(s).
	PhoneNumbers []*Phone `protobuf:"bytes,14,rep,name=phone_numbers,json=phoneNumbers,proto3" json:"phone_numbers,omitempty"`
	// Optional. The candidate's personal URIs.
	PersonalUris []*PersonalUri `protobuf:"bytes,15,rep,name=personal_uris,json=personalUris,proto3" json:"personal_uris,omitempty"`
	// Optional. Available contact information besides
	// [addresses][google.cloud.talent.v4beta1.Profile.addresses],
	// [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
	// [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and
	// [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For
	// example, Hang-out, Skype.
	AdditionalContactInfo []*AdditionalContactInfo `protobuf:"bytes,16,rep,name=additional_contact_info,json=additionalContactInfo,proto3" json:"additional_contact_info,omitempty"`
	// Optional. The employment history records of the candidate. It's highly
	// recommended to input this information as accurately as possible to help
	// improve search quality. Here are some recommendations:
	//
	// * Specify the start and end dates of the employment records.
	// * List different employment types separately, no matter how minor the
	// change is.
	// For example, only job title is changed from "software engineer" to "senior
	// software engineer".
	// * Provide
	// [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current]
	// for the current employment if possible. If not, it's inferred from user
	// inputs.
	//
	// The limitation for max number of employment records is 50.
	EmploymentRecords []*EmploymentRecord `protobuf:"bytes,17,rep,name=employment_records,json=employmentRecords,proto3" json:"employment_records,omitempty"`
	// Optional. The education history record of the candidate. It's highly
	// recommended to input this information as accurately as possible to help
	// improve search quality. Here are some recommendations:
	//
	// * Specify the start and end dates of the education records.
	// * List each education type separately, no matter how minor the change is.
	// For example, the profile contains the education experience from the same
	// school but different degrees.
	// * Provide
	// [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current]
	// for the current education if possible. If not, it's inferred from user
	// inputs.
	//
	// The limitation for max number of education records is 10.
	EducationRecords []*EducationRecord `protobuf:"bytes,18,rep,name=education_records,json=educationRecords,proto3" json:"education_records,omitempty"`
	// Optional. The skill set of the candidate. It's highly recommended to
	// provide as much information as possible to help improve the search quality.
	//
	// The limitation for max number of skills is 100.
	Skills []*Skill `protobuf:"bytes,19,rep,name=skills,proto3" json:"skills,omitempty"`
	// Optional. The individual or collaborative activities which the candidate
	// has participated in, for example, open-source projects, class assignments
	// that aren't listed in
	// [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	//
	// The limitation for max number of activities is 50.
	Activities []*Activity `protobuf:"bytes,20,rep,name=activities,proto3" json:"activities,omitempty"`
	// Optional. The publications published by the candidate.
	//
	// The limitation for max number of publications is 50.
	Publications []*Publication `protobuf:"bytes,21,rep,name=publications,proto3" json:"publications,omitempty"`
	// Optional. The patents acquired by the candidate.
	Patents []*Patent `protobuf:"bytes,22,rep,name=patents,proto3" json:"patents,omitempty"`
	// Optional. The certifications acquired by the candidate.
	Certifications []*Certification `protobuf:"bytes,23,rep,name=certifications,proto3" json:"certifications,omitempty"`
	// Output only. The resource names of the candidate's applications.
	Applications []string `protobuf:"bytes,47,rep,name=applications,proto3" json:"applications,omitempty"`
	// Output only. The resource names of the candidate's assignments.
	Assignments []string `protobuf:"bytes,48,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Optional. A map of fields to hold both filterable and non-filterable custom
	// profile attributes that aren't covered by the provided structured fields.
	// See [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more
	// details.
	//
	// At most 100 filterable and at most 100 unfilterable keys are supported. If
	// limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
	// by default. These are filterable when the `filterable` flag is set to
	// `true`.
	//
	// Numeric custom attributes: each key can only map to one numeric value,
	// otherwise an error is thrown. Client can also filter on numeric custom
	// attributes using '>', '<' or '=' operators.
	//
	// String custom attributes: each key can map up to 50 string values. For
	// filterable string value, each value has a byte size of no more than 256B.
	// For unfilterable string values, the maximum byte size of a single key is
	// 64B. An error is thrown for any request exceeding the limit.
	// The maximum total byte size is 10KB.
	CustomAttributes map[string]*CustomAttribute `protobuf:"bytes,26,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Indicates if a summarized profile was created as part of the
	// profile creation API call. This flag does not indicate whether a profile is
	// searchable or not.
	Processed bool `protobuf:"varint,27,opt,name=processed,proto3" json:"processed,omitempty"`
	// Output only. Keyword snippet shows how the search result is related to a
	// search query.  This is only returned in
	// [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
	KeywordSnippet       string   `protobuf:"bytes,28,opt,name=keyword_snippet,json=keywordSnippet,proto3" json:"keyword_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Profile) Reset()         { *m = Profile{} }
func (m *Profile) String() string { return proto.CompactTextString(m) }
func (*Profile) ProtoMessage()    {}
func (*Profile) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{0}
}

func (m *Profile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Profile.Unmarshal(m, b)
}
func (m *Profile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Profile.Marshal(b, m, deterministic)
}
func (m *Profile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Profile.Merge(m, src)
}
func (m *Profile) XXX_Size() int {
	return xxx_messageInfo_Profile.Size(m)
}
func (m *Profile) XXX_DiscardUnknown() {
	xxx_messageInfo_Profile.DiscardUnknown(m)
}

var xxx_messageInfo_Profile proto.InternalMessageInfo

func (m *Profile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Profile) GetExternalId() string {
	if m != nil {
		return m.ExternalId
	}
	return ""
}

func (m *Profile) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *Profile) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Profile) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *Profile) GetIsHirable() *wrappers.BoolValue {
	if m != nil {
		return m.IsHirable
	}
	return nil
}

func (m *Profile) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Profile) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Profile) GetResume() *Resume {
	if m != nil {
		return m.Resume
	}
	return nil
}

func (m *Profile) GetPersonNames() []*PersonName {
	if m != nil {
		return m.PersonNames
	}
	return nil
}

func (m *Profile) GetAddresses() []*Address {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *Profile) GetEmailAddresses() []*Email {
	if m != nil {
		return m.EmailAddresses
	}
	return nil
}

func (m *Profile) GetPhoneNumbers() []*Phone {
	if m != nil {
		return m.PhoneNumbers
	}
	return nil
}

func (m *Profile) GetPersonalUris() []*PersonalUri {
	if m != nil {
		return m.PersonalUris
	}
	return nil
}

func (m *Profile) GetAdditionalContactInfo() []*AdditionalContactInfo {
	if m != nil {
		return m.AdditionalContactInfo
	}
	return nil
}

func (m *Profile) GetEmploymentRecords() []*EmploymentRecord {
	if m != nil {
		return m.EmploymentRecords
	}
	return nil
}

func (m *Profile) GetEducationRecords() []*EducationRecord {
	if m != nil {
		return m.EducationRecords
	}
	return nil
}

func (m *Profile) GetSkills() []*Skill {
	if m != nil {
		return m.Skills
	}
	return nil
}

func (m *Profile) GetActivities() []*Activity {
	if m != nil {
		return m.Activities
	}
	return nil
}

func (m *Profile) GetPublications() []*Publication {
	if m != nil {
		return m.Publications
	}
	return nil
}

func (m *Profile) GetPatents() []*Patent {
	if m != nil {
		return m.Patents
	}
	return nil
}

func (m *Profile) GetCertifications() []*Certification {
	if m != nil {
		return m.Certifications
	}
	return nil
}

func (m *Profile) GetApplications() []string {
	if m != nil {
		return m.Applications
	}
	return nil
}

func (m *Profile) GetAssignments() []string {
	if m != nil {
		return m.Assignments
	}
	return nil
}

func (m *Profile) GetCustomAttributes() map[string]*CustomAttribute {
	if m != nil {
		return m.CustomAttributes
	}
	return nil
}

func (m *Profile) GetProcessed() bool {
	if m != nil {
		return m.Processed
	}
	return false
}

func (m *Profile) GetKeywordSnippet() string {
	if m != nil {
		return m.KeywordSnippet
	}
	return ""
}

// Resource that represents a resume.
type Resume struct {
	// Optional. Users can create a profile with only this field field, if
	// [resume_type][google.cloud.talent.v4beta1.Resume.resume_type] is
	// [HRXML][google.cloud.talent.v4beta1.Resume.ResumeType.HRXML]. For example,
	// the API parses this field and creates a profile with all structured fields
	// populated, for example.
	// [EmploymentRecord][google.cloud.talent.v4beta1.EmploymentRecord],
	// [EducationRecord][google.cloud.talent.v4beta1.EducationRecord], and so on.
	// An error is thrown if this field cannot be parsed.
	//
	// If this field is provided during profile creation or update,
	// any other structured data provided in the profile is ignored. The
	// API populates these fields by parsing this field. Note that the use of the
	// functionality offered by this field to extract data from resumes is an
	// Alpha feature and as such is not covered by any SLA.
	StructuredResume string `protobuf:"bytes,1,opt,name=structured_resume,json=structuredResume,proto3" json:"structured_resume,omitempty"`
	// Optional. The format of
	// [structured_resume][google.cloud.talent.v4beta1.Resume.structured_resume].
	ResumeType           Resume_ResumeType `protobuf:"varint,2,opt,name=resume_type,json=resumeType,proto3,enum=google.cloud.talent.v4beta1.Resume_ResumeType" json:"resume_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Resume) Reset()         { *m = Resume{} }
func (m *Resume) String() string { return proto.CompactTextString(m) }
func (*Resume) ProtoMessage()    {}
func (*Resume) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{1}
}

func (m *Resume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resume.Unmarshal(m, b)
}
func (m *Resume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resume.Marshal(b, m, deterministic)
}
func (m *Resume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resume.Merge(m, src)
}
func (m *Resume) XXX_Size() int {
	return xxx_messageInfo_Resume.Size(m)
}
func (m *Resume) XXX_DiscardUnknown() {
	xxx_messageInfo_Resume.DiscardUnknown(m)
}

var xxx_messageInfo_Resume proto.InternalMessageInfo

func (m *Resume) GetStructuredResume() string {
	if m != nil {
		return m.StructuredResume
	}
	return ""
}

func (m *Resume) GetResumeType() Resume_ResumeType {
	if m != nil {
		return m.ResumeType
	}
	return Resume_RESUME_TYPE_UNSPECIFIED
}

// Resource that represents the name of a person.
type PersonName struct {
	// The name of a person. It can be one of
	// [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] or
	// [structured_name][google.cloud.talent.v4beta1.PersonName.structured_name].
	//
	// Types that are valid to be assigned to PersonName:
	//	*PersonName_FormattedName
	//	*PersonName_StructuredName
	PersonName isPersonName_PersonName `protobuf_oneof:"person_name"`
	// Optional. Preferred name for the person. This field is ignored if
	// [structured_name][google.cloud.talent.v4beta1.PersonName.structured_name]
	// is provided.
	//
	// Number of characters allowed is 100.
	PreferredName        string   `protobuf:"bytes,3,opt,name=preferred_name,json=preferredName,proto3" json:"preferred_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonName) Reset()         { *m = PersonName{} }
func (m *PersonName) String() string { return proto.CompactTextString(m) }
func (*PersonName) ProtoMessage()    {}
func (*PersonName) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{2}
}

func (m *PersonName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonName.Unmarshal(m, b)
}
func (m *PersonName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonName.Marshal(b, m, deterministic)
}
func (m *PersonName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonName.Merge(m, src)
}
func (m *PersonName) XXX_Size() int {
	return xxx_messageInfo_PersonName.Size(m)
}
func (m *PersonName) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonName.DiscardUnknown(m)
}

var xxx_messageInfo_PersonName proto.InternalMessageInfo

type isPersonName_PersonName interface {
	isPersonName_PersonName()
}

type PersonName_FormattedName struct {
	FormattedName string `protobuf:"bytes,1,opt,name=formatted_name,json=formattedName,proto3,oneof"`
}

type PersonName_StructuredName struct {
	StructuredName *PersonName_PersonStructuredName `protobuf:"bytes,2,opt,name=structured_name,json=structuredName,proto3,oneof"`
}

func (*PersonName_FormattedName) isPersonName_PersonName() {}

func (*PersonName_StructuredName) isPersonName_PersonName() {}

func (m *PersonName) GetPersonName() isPersonName_PersonName {
	if m != nil {
		return m.PersonName
	}
	return nil
}

func (m *PersonName) GetFormattedName() string {
	if x, ok := m.GetPersonName().(*PersonName_FormattedName); ok {
		return x.FormattedName
	}
	return ""
}

func (m *PersonName) GetStructuredName() *PersonName_PersonStructuredName {
	if x, ok := m.GetPersonName().(*PersonName_StructuredName); ok {
		return x.StructuredName
	}
	return nil
}

func (m *PersonName) GetPreferredName() string {
	if m != nil {
		return m.PreferredName
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PersonName) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PersonName_FormattedName)(nil),
		(*PersonName_StructuredName)(nil),
	}
}

// Resource that represents a person's structured name.
type PersonName_PersonStructuredName struct {
	// Optional. Given/first name.
	//
	// It's derived from
	// [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name]
	// if not provided.
	//
	// Number of characters allowed is 100.
	GivenName string `protobuf:"bytes,1,opt,name=given_name,json=givenName,proto3" json:"given_name,omitempty"`
	// Optional. Preferred given/first name or nickname.
	//
	// Number of characters allowed is 100.
	PreferredName string `protobuf:"bytes,6,opt,name=preferred_name,json=preferredName,proto3" json:"preferred_name,omitempty"`
	// Optional. Middle initial.
	//
	// It's derived from
	// [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name]
	// if not provided.
	//
	// Number of characters allowed is 20.
	MiddleInitial string `protobuf:"bytes,2,opt,name=middle_initial,json=middleInitial,proto3" json:"middle_initial,omitempty"`
	// Optional. Family/last name.
	//
	// It's derived from
	// [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name]
	// if not provided.
	//
	// Number of characters allowed is 100.
	FamilyName string `protobuf:"bytes,3,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// Optional. Suffixes.
	//
	// Number of characters allowed is 20.
	Suffixes []string `protobuf:"bytes,4,rep,name=suffixes,proto3" json:"suffixes,omitempty"`
	// Optional. Prefixes.
	//
	// Number of characters allowed is 20.
	Prefixes             []string `protobuf:"bytes,5,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonName_PersonStructuredName) Reset()         { *m = PersonName_PersonStructuredName{} }
func (m *PersonName_PersonStructuredName) String() string { return proto.CompactTextString(m) }
func (*PersonName_PersonStructuredName) ProtoMessage()    {}
func (*PersonName_PersonStructuredName) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{2, 0}
}

func (m *PersonName_PersonStructuredName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonName_PersonStructuredName.Unmarshal(m, b)
}
func (m *PersonName_PersonStructuredName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonName_PersonStructuredName.Marshal(b, m, deterministic)
}
func (m *PersonName_PersonStructuredName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonName_PersonStructuredName.Merge(m, src)
}
func (m *PersonName_PersonStructuredName) XXX_Size() int {
	return xxx_messageInfo_PersonName_PersonStructuredName.Size(m)
}
func (m *PersonName_PersonStructuredName) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonName_PersonStructuredName.DiscardUnknown(m)
}

var xxx_messageInfo_PersonName_PersonStructuredName proto.InternalMessageInfo

func (m *PersonName_PersonStructuredName) GetGivenName() string {
	if m != nil {
		return m.GivenName
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetPreferredName() string {
	if m != nil {
		return m.PreferredName
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetMiddleInitial() string {
	if m != nil {
		return m.MiddleInitial
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetSuffixes() []string {
	if m != nil {
		return m.Suffixes
	}
	return nil
}

func (m *PersonName_PersonStructuredName) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

// Resource that represents a address.
type Address struct {
	// Optional. The usage of the address. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// The address of a person. It can be one of
	// [unstructured_address][google.cloud.talent.v4beta1.Address.unstructured_address]
	// or
	// [structured_address][google.cloud.talent.v4beta1.Address.structured_address].
	//
	// Types that are valid to be assigned to Address:
	//	*Address_UnstructuredAddress
	//	*Address_StructuredAddress
	Address isAddress_Address `protobuf_oneof:"address"`
	// Optional. Indicates if it's the person's current address.
	Current              *wrappers.BoolValue `protobuf:"bytes,4,opt,name=current,proto3" json:"current,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Address) Reset()         { *m = Address{} }
func (m *Address) String() string { return proto.CompactTextString(m) }
func (*Address) ProtoMessage()    {}
func (*Address) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{3}
}

func (m *Address) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Address.Unmarshal(m, b)
}
func (m *Address) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Address.Marshal(b, m, deterministic)
}
func (m *Address) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address.Merge(m, src)
}
func (m *Address) XXX_Size() int {
	return xxx_messageInfo_Address.Size(m)
}
func (m *Address) XXX_DiscardUnknown() {
	xxx_messageInfo_Address.DiscardUnknown(m)
}

var xxx_messageInfo_Address proto.InternalMessageInfo

func (m *Address) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

type isAddress_Address interface {
	isAddress_Address()
}

type Address_UnstructuredAddress struct {
	UnstructuredAddress string `protobuf:"bytes,2,opt,name=unstructured_address,json=unstructuredAddress,proto3,oneof"`
}

type Address_StructuredAddress struct {
	StructuredAddress *postaladdress.PostalAddress `protobuf:"bytes,3,opt,name=structured_address,json=structuredAddress,proto3,oneof"`
}

func (*Address_UnstructuredAddress) isAddress_Address() {}

func (*Address_StructuredAddress) isAddress_Address() {}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Address) GetUnstructuredAddress() string {
	if x, ok := m.GetAddress().(*Address_UnstructuredAddress); ok {
		return x.UnstructuredAddress
	}
	return ""
}

func (m *Address) GetStructuredAddress() *postaladdress.PostalAddress {
	if x, ok := m.GetAddress().(*Address_StructuredAddress); ok {
		return x.StructuredAddress
	}
	return nil
}

func (m *Address) GetCurrent() *wrappers.BoolValue {
	if m != nil {
		return m.Current
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Address) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Address_UnstructuredAddress)(nil),
		(*Address_StructuredAddress)(nil),
	}
}

// Resource that represents a person's email address.
type Email struct {
	// Optional. The usage of the email address. For example, SCHOOL, WORK,
	// PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Optional. Email address.
	//
	// Number of characters allowed is 4,000.
	EmailAddress         string   `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Email) Reset()         { *m = Email{} }
func (m *Email) String() string { return proto.CompactTextString(m) }
func (*Email) ProtoMessage()    {}
func (*Email) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{4}
}

func (m *Email) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Email.Unmarshal(m, b)
}
func (m *Email) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Email.Marshal(b, m, deterministic)
}
func (m *Email) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Email.Merge(m, src)
}
func (m *Email) XXX_Size() int {
	return xxx_messageInfo_Email.Size(m)
}
func (m *Email) XXX_DiscardUnknown() {
	xxx_messageInfo_Email.DiscardUnknown(m)
}

var xxx_messageInfo_Email proto.InternalMessageInfo

func (m *Email) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *Email) GetEmailAddress() string {
	if m != nil {
		return m.EmailAddress
	}
	return ""
}

// Resource that represents a person's telephone number.
type Phone struct {
	// Optional. The usage of the phone. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Optional. The phone type. For example, LANDLINE, MOBILE, FAX.
	Type Phone_PhoneType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.Phone_PhoneType" json:"type,omitempty"`
	// Optional. Phone number.
	//
	// Any phone formats are supported and only exact matches are performed on
	// searches. For example, if a phone number in profile is provided in the
	// format of "(xxx)xxx-xxxx", in profile searches the same phone format
	// has to be provided.
	//
	// Number of characters allowed is 20.
	Number string `protobuf:"bytes,3,opt,name=number,proto3" json:"number,omitempty"`
	// Optional. When this number is available. Any descriptive string is
	// expected.
	//
	// Number of characters allowed is 100.
	WhenAvailable        string   `protobuf:"bytes,4,opt,name=when_available,json=whenAvailable,proto3" json:"when_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Phone) Reset()         { *m = Phone{} }
func (m *Phone) String() string { return proto.CompactTextString(m) }
func (*Phone) ProtoMessage()    {}
func (*Phone) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{5}
}

func (m *Phone) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Phone.Unmarshal(m, b)
}
func (m *Phone) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Phone.Marshal(b, m, deterministic)
}
func (m *Phone) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Phone.Merge(m, src)
}
func (m *Phone) XXX_Size() int {
	return xxx_messageInfo_Phone.Size(m)
}
func (m *Phone) XXX_DiscardUnknown() {
	xxx_messageInfo_Phone.DiscardUnknown(m)
}

var xxx_messageInfo_Phone proto.InternalMessageInfo

func (m *Phone) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *Phone) GetType() Phone_PhoneType {
	if m != nil {
		return m.Type
	}
	return Phone_PHONE_TYPE_UNSPECIFIED
}

func (m *Phone) GetNumber() string {
	if m != nil {
		return m.Number
	}
	return ""
}

func (m *Phone) GetWhenAvailable() string {
	if m != nil {
		return m.WhenAvailable
	}
	return ""
}

// Resource that represents a valid URI for a personal use.
type PersonalUri struct {
	// Optional. The personal URI.
	//
	// Number of characters allowed is 4,000.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonalUri) Reset()         { *m = PersonalUri{} }
func (m *PersonalUri) String() string { return proto.CompactTextString(m) }
func (*PersonalUri) ProtoMessage()    {}
func (*PersonalUri) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{6}
}

func (m *PersonalUri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonalUri.Unmarshal(m, b)
}
func (m *PersonalUri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonalUri.Marshal(b, m, deterministic)
}
func (m *PersonalUri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonalUri.Merge(m, src)
}
func (m *PersonalUri) XXX_Size() int {
	return xxx_messageInfo_PersonalUri.Size(m)
}
func (m *PersonalUri) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonalUri.DiscardUnknown(m)
}

var xxx_messageInfo_PersonalUri proto.InternalMessageInfo

func (m *PersonalUri) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Resource that represents contact information other than phone, email,
// URI and addresses.
type AdditionalContactInfo struct {
	// Optional. The usage of this contact method. For example, SCHOOL, WORK,
	// PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Optional. The name of the contact method.
	//
	// For example, "hangout", "skype".
	//
	// Number of characters allowed is 100.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The contact id.
	//
	// Number of characters allowed is 100.
	ContactId            string   `protobuf:"bytes,3,opt,name=contact_id,json=contactId,proto3" json:"contact_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdditionalContactInfo) Reset()         { *m = AdditionalContactInfo{} }
func (m *AdditionalContactInfo) String() string { return proto.CompactTextString(m) }
func (*AdditionalContactInfo) ProtoMessage()    {}
func (*AdditionalContactInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{7}
}

func (m *AdditionalContactInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdditionalContactInfo.Unmarshal(m, b)
}
func (m *AdditionalContactInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdditionalContactInfo.Marshal(b, m, deterministic)
}
func (m *AdditionalContactInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdditionalContactInfo.Merge(m, src)
}
func (m *AdditionalContactInfo) XXX_Size() int {
	return xxx_messageInfo_AdditionalContactInfo.Size(m)
}
func (m *AdditionalContactInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdditionalContactInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdditionalContactInfo proto.InternalMessageInfo

func (m *AdditionalContactInfo) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *AdditionalContactInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AdditionalContactInfo) GetContactId() string {
	if m != nil {
		return m.ContactId
	}
	return ""
}

// Resource that represents an employment record of a candidate.
type EmploymentRecord struct {
	// Optional. Start date of the employment.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional. End date of the employment.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Optional. The name of the employer company/organization.
	//
	// For example, "Google", "Alphabet", and so on.
	//
	// Number of characters allowed is 100.
	EmployerName string `protobuf:"bytes,3,opt,name=employer_name,json=employerName,proto3" json:"employer_name,omitempty"`
	// Optional. The division name of the employment.
	//
	// For example, division, department, client, and so on.
	//
	// Number of characters allowed is 100.
	DivisionName string `protobuf:"bytes,4,opt,name=division_name,json=divisionName,proto3" json:"division_name,omitempty"`
	// Optional. The physical address of the employer.
	Address *Address `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// Optional. The job title of the employment.
	//
	// For example, "Software Engineer", "Data Scientist", and so on.
	//
	// Number of characters allowed is 100.
	JobTitle string `protobuf:"bytes,6,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Optional. The description of job content.
	//
	// Number of characters allowed is 100,000.
	JobDescription string `protobuf:"bytes,7,opt,name=job_description,json=jobDescription,proto3" json:"job_description,omitempty"`
	// Optional. If the jobs is a supervisor position.
	IsSupervisor *wrappers.BoolValue `protobuf:"bytes,8,opt,name=is_supervisor,json=isSupervisor,proto3" json:"is_supervisor,omitempty"`
	// Optional. If this employment is self-employed.
	IsSelfEmployed *wrappers.BoolValue `protobuf:"bytes,9,opt,name=is_self_employed,json=isSelfEmployed,proto3" json:"is_self_employed,omitempty"`
	// Optional. If this employment is current.
	IsCurrent *wrappers.BoolValue `protobuf:"bytes,10,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	// Output only. The job title snippet shows how the
	// [job_title][google.cloud.talent.v4beta1.EmploymentRecord.job_title] is
	// related to a search query. It's empty if the
	// [job_title][google.cloud.talent.v4beta1.EmploymentRecord.job_title] isn't
	// related to the search query.
	JobTitleSnippet string `protobuf:"bytes,11,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	// Output only. The job description snippet shows how the
	// [job_description][google.cloud.talent.v4beta1.EmploymentRecord.job_description]
	// is related to a search query. It's empty if the
	// [job_description][google.cloud.talent.v4beta1.EmploymentRecord.job_description]
	// isn't related to the search query.
	JobDescriptionSnippet string `protobuf:"bytes,12,opt,name=job_description_snippet,json=jobDescriptionSnippet,proto3" json:"job_description_snippet,omitempty"`
	// Output only. The employer name snippet shows how the
	// [employer_name][google.cloud.talent.v4beta1.EmploymentRecord.employer_name]
	// is related to a search query. It's empty if the
	// [employer_name][google.cloud.talent.v4beta1.EmploymentRecord.employer_name]
	// isn't related to the search query.
	EmployerNameSnippet  string   `protobuf:"bytes,13,opt,name=employer_name_snippet,json=employerNameSnippet,proto3" json:"employer_name_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmploymentRecord) Reset()         { *m = EmploymentRecord{} }
func (m *EmploymentRecord) String() string { return proto.CompactTextString(m) }
func (*EmploymentRecord) ProtoMessage()    {}
func (*EmploymentRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{8}
}

func (m *EmploymentRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EmploymentRecord.Unmarshal(m, b)
}
func (m *EmploymentRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EmploymentRecord.Marshal(b, m, deterministic)
}
func (m *EmploymentRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmploymentRecord.Merge(m, src)
}
func (m *EmploymentRecord) XXX_Size() int {
	return xxx_messageInfo_EmploymentRecord.Size(m)
}
func (m *EmploymentRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_EmploymentRecord.DiscardUnknown(m)
}

var xxx_messageInfo_EmploymentRecord proto.InternalMessageInfo

func (m *EmploymentRecord) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *EmploymentRecord) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *EmploymentRecord) GetEmployerName() string {
	if m != nil {
		return m.EmployerName
	}
	return ""
}

func (m *EmploymentRecord) GetDivisionName() string {
	if m != nil {
		return m.DivisionName
	}
	return ""
}

func (m *EmploymentRecord) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *EmploymentRecord) GetJobTitle() string {
	if m != nil {
		return m.JobTitle
	}
	return ""
}

func (m *EmploymentRecord) GetJobDescription() string {
	if m != nil {
		return m.JobDescription
	}
	return ""
}

func (m *EmploymentRecord) GetIsSupervisor() *wrappers.BoolValue {
	if m != nil {
		return m.IsSupervisor
	}
	return nil
}

func (m *EmploymentRecord) GetIsSelfEmployed() *wrappers.BoolValue {
	if m != nil {
		return m.IsSelfEmployed
	}
	return nil
}

func (m *EmploymentRecord) GetIsCurrent() *wrappers.BoolValue {
	if m != nil {
		return m.IsCurrent
	}
	return nil
}

func (m *EmploymentRecord) GetJobTitleSnippet() string {
	if m != nil {
		return m.JobTitleSnippet
	}
	return ""
}

func (m *EmploymentRecord) GetJobDescriptionSnippet() string {
	if m != nil {
		return m.JobDescriptionSnippet
	}
	return ""
}

func (m *EmploymentRecord) GetEmployerNameSnippet() string {
	if m != nil {
		return m.EmployerNameSnippet
	}
	return ""
}

// Resource that represents an education record of a candidate.
type EducationRecord struct {
	// Optional. The start date of the education.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional. The end date of the education.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Optional. The expected graduation date if currently pursuing a degree.
	ExpectedGraduationDate *date.Date `protobuf:"bytes,3,opt,name=expected_graduation_date,json=expectedGraduationDate,proto3" json:"expected_graduation_date,omitempty"`
	// Optional. The name of the school or institution.
	//
	// For example, "Stanford University", "UC Berkeley", and so on.
	//
	// Number of characters allowed is 100.
	SchoolName string `protobuf:"bytes,4,opt,name=school_name,json=schoolName,proto3" json:"school_name,omitempty"`
	// Optional. The physical address of the education institution.
	Address *Address `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// The degree information. It can be one of
	// [degree_description][google.cloud.talent.v4beta1.EducationRecord.degree_description]
	// or
	// [structured_degree][google.cloud.talent.v4beta1.EducationRecord.structured_degree].
	//
	// Types that are valid to be assigned to Degree:
	//	*EducationRecord_DegreeDescription
	//	*EducationRecord_StructuredDegree
	Degree isEducationRecord_Degree `protobuf_oneof:"degree"`
	// Optional. The description of the education.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. If this education is current.
	IsCurrent *wrappers.BoolValue `protobuf:"bytes,9,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	// Output only. The school name snippet shows how the
	// [school_name][google.cloud.talent.v4beta1.EducationRecord.school_name] is
	// related to a search query in search result. It's empty if the
	// [school_name][google.cloud.talent.v4beta1.EducationRecord.school_name]
	// isn't related to the search query.
	SchoolNameSnippet string `protobuf:"bytes,10,opt,name=school_name_snippet,json=schoolNameSnippet,proto3" json:"school_name_snippet,omitempty"`
	// Output only. The job description snippet shows how the
	// [Degree][google.cloud.talent.v4beta1.Degree] is related to a search query
	// in search result. It's empty if the
	// [Degree][google.cloud.talent.v4beta1.Degree] isn't related to the search
	// query.
	DegreeSnippet        string   `protobuf:"bytes,11,opt,name=degree_snippet,json=degreeSnippet,proto3" json:"degree_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EducationRecord) Reset()         { *m = EducationRecord{} }
func (m *EducationRecord) String() string { return proto.CompactTextString(m) }
func (*EducationRecord) ProtoMessage()    {}
func (*EducationRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{9}
}

func (m *EducationRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EducationRecord.Unmarshal(m, b)
}
func (m *EducationRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EducationRecord.Marshal(b, m, deterministic)
}
func (m *EducationRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EducationRecord.Merge(m, src)
}
func (m *EducationRecord) XXX_Size() int {
	return xxx_messageInfo_EducationRecord.Size(m)
}
func (m *EducationRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_EducationRecord.DiscardUnknown(m)
}

var xxx_messageInfo_EducationRecord proto.InternalMessageInfo

func (m *EducationRecord) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *EducationRecord) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *EducationRecord) GetExpectedGraduationDate() *date.Date {
	if m != nil {
		return m.ExpectedGraduationDate
	}
	return nil
}

func (m *EducationRecord) GetSchoolName() string {
	if m != nil {
		return m.SchoolName
	}
	return ""
}

func (m *EducationRecord) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

type isEducationRecord_Degree interface {
	isEducationRecord_Degree()
}

type EducationRecord_DegreeDescription struct {
	DegreeDescription string `protobuf:"bytes,6,opt,name=degree_description,json=degreeDescription,proto3,oneof"`
}

type EducationRecord_StructuredDegree struct {
	StructuredDegree *Degree `protobuf:"bytes,7,opt,name=structured_degree,json=structuredDegree,proto3,oneof"`
}

func (*EducationRecord_DegreeDescription) isEducationRecord_Degree() {}

func (*EducationRecord_StructuredDegree) isEducationRecord_Degree() {}

func (m *EducationRecord) GetDegree() isEducationRecord_Degree {
	if m != nil {
		return m.Degree
	}
	return nil
}

func (m *EducationRecord) GetDegreeDescription() string {
	if x, ok := m.GetDegree().(*EducationRecord_DegreeDescription); ok {
		return x.DegreeDescription
	}
	return ""
}

func (m *EducationRecord) GetStructuredDegree() *Degree {
	if x, ok := m.GetDegree().(*EducationRecord_StructuredDegree); ok {
		return x.StructuredDegree
	}
	return nil
}

func (m *EducationRecord) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EducationRecord) GetIsCurrent() *wrappers.BoolValue {
	if m != nil {
		return m.IsCurrent
	}
	return nil
}

func (m *EducationRecord) GetSchoolNameSnippet() string {
	if m != nil {
		return m.SchoolNameSnippet
	}
	return ""
}

func (m *EducationRecord) GetDegreeSnippet() string {
	if m != nil {
		return m.DegreeSnippet
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EducationRecord) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EducationRecord_DegreeDescription)(nil),
		(*EducationRecord_StructuredDegree)(nil),
	}
}

// Resource that represents a degree pursuing or acquired by a candidate.
type Degree struct {
	// Optional. ISCED degree type.
	DegreeType DegreeType `protobuf:"varint,1,opt,name=degree_type,json=degreeType,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_type,omitempty"`
	// Optional. Full Degree name.
	//
	// For example, "B.S.", "Master of Arts", and so on.
	//
	// Number of characters allowed is 100.
	DegreeName string `protobuf:"bytes,2,opt,name=degree_name,json=degreeName,proto3" json:"degree_name,omitempty"`
	// Optional. Fields of study for the degree.
	//
	// For example, "Computer science", "engineering".
	//
	// Number of characters allowed is 100.
	FieldsOfStudy        []string `protobuf:"bytes,3,rep,name=fields_of_study,json=fieldsOfStudy,proto3" json:"fields_of_study,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Degree) Reset()         { *m = Degree{} }
func (m *Degree) String() string { return proto.CompactTextString(m) }
func (*Degree) ProtoMessage()    {}
func (*Degree) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{10}
}

func (m *Degree) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Degree.Unmarshal(m, b)
}
func (m *Degree) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Degree.Marshal(b, m, deterministic)
}
func (m *Degree) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Degree.Merge(m, src)
}
func (m *Degree) XXX_Size() int {
	return xxx_messageInfo_Degree.Size(m)
}
func (m *Degree) XXX_DiscardUnknown() {
	xxx_messageInfo_Degree.DiscardUnknown(m)
}

var xxx_messageInfo_Degree proto.InternalMessageInfo

func (m *Degree) GetDegreeType() DegreeType {
	if m != nil {
		return m.DegreeType
	}
	return DegreeType_DEGREE_TYPE_UNSPECIFIED
}

func (m *Degree) GetDegreeName() string {
	if m != nil {
		return m.DegreeName
	}
	return ""
}

func (m *Degree) GetFieldsOfStudy() []string {
	if m != nil {
		return m.FieldsOfStudy
	}
	return nil
}

// Resource that represents an individual or collaborative activity participated
// in by a candidate, for example, an open-source project, a class assignment,
// and so on.
type Activity struct {
	// Optional. Activity display name.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Activity description.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Activity URI.
	//
	// Number of characters allowed is 4,000.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional. The first creation date of the activity.
	CreateDate *date.Date `protobuf:"bytes,4,opt,name=create_date,json=createDate,proto3" json:"create_date,omitempty"`
	// Optional. The last update date of the activity.
	UpdateDate *date.Date `protobuf:"bytes,5,opt,name=update_date,json=updateDate,proto3" json:"update_date,omitempty"`
	// Optional. A list of team members involved in this activity.
	//
	// Number of characters allowed is 100.
	//
	// The limitation for max number of team members is 50.
	TeamMembers []string `protobuf:"bytes,6,rep,name=team_members,json=teamMembers,proto3" json:"team_members,omitempty"`
	// Optional. A list of skills used in this activity.
	//
	// The limitation for max number of skills used is 50.
	SkillsUsed []*Skill `protobuf:"bytes,7,rep,name=skills_used,json=skillsUsed,proto3" json:"skills_used,omitempty"`
	// Output only. Activity name snippet shows how the
	// [display_name][google.cloud.talent.v4beta1.Activity.display_name] is
	// related to a search query. It's empty if the
	// [display_name][google.cloud.talent.v4beta1.Activity.display_name] isn't
	// related to the search query.
	ActivityNameSnippet string `protobuf:"bytes,8,opt,name=activity_name_snippet,json=activityNameSnippet,proto3" json:"activity_name_snippet,omitempty"`
	// Output only. Activity description snippet shows how the
	// [description][google.cloud.talent.v4beta1.Activity.description] is related
	// to a search query. It's empty if the
	// [description][google.cloud.talent.v4beta1.Activity.description] isn't
	// related to the search query.
	ActivityDescriptionSnippet string `protobuf:"bytes,9,opt,name=activity_description_snippet,json=activityDescriptionSnippet,proto3" json:"activity_description_snippet,omitempty"`
	// Output only. Skill used snippet shows how the corresponding
	// [skills_used][google.cloud.talent.v4beta1.Activity.skills_used] are related
	// to a search query. It's empty if the corresponding
	// [skills_used][google.cloud.talent.v4beta1.Activity.skills_used] are not
	// related to the search query.
	SkillsUsedSnippet    []string `protobuf:"bytes,10,rep,name=skills_used_snippet,json=skillsUsedSnippet,proto3" json:"skills_used_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Activity) Reset()         { *m = Activity{} }
func (m *Activity) String() string { return proto.CompactTextString(m) }
func (*Activity) ProtoMessage()    {}
func (*Activity) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{11}
}

func (m *Activity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Activity.Unmarshal(m, b)
}
func (m *Activity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Activity.Marshal(b, m, deterministic)
}
func (m *Activity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Activity.Merge(m, src)
}
func (m *Activity) XXX_Size() int {
	return xxx_messageInfo_Activity.Size(m)
}
func (m *Activity) XXX_DiscardUnknown() {
	xxx_messageInfo_Activity.DiscardUnknown(m)
}

var xxx_messageInfo_Activity proto.InternalMessageInfo

func (m *Activity) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Activity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Activity) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Activity) GetCreateDate() *date.Date {
	if m != nil {
		return m.CreateDate
	}
	return nil
}

func (m *Activity) GetUpdateDate() *date.Date {
	if m != nil {
		return m.UpdateDate
	}
	return nil
}

func (m *Activity) GetTeamMembers() []string {
	if m != nil {
		return m.TeamMembers
	}
	return nil
}

func (m *Activity) GetSkillsUsed() []*Skill {
	if m != nil {
		return m.SkillsUsed
	}
	return nil
}

func (m *Activity) GetActivityNameSnippet() string {
	if m != nil {
		return m.ActivityNameSnippet
	}
	return ""
}

func (m *Activity) GetActivityDescriptionSnippet() string {
	if m != nil {
		return m.ActivityDescriptionSnippet
	}
	return ""
}

func (m *Activity) GetSkillsUsedSnippet() []string {
	if m != nil {
		return m.SkillsUsedSnippet
	}
	return nil
}

// Resource that represents a publication resource of a candidate.
type Publication struct {
	// Optional. A list of author names.
	//
	// Number of characters allowed is 100.
	Authors []string `protobuf:"bytes,1,rep,name=authors,proto3" json:"authors,omitempty"`
	// Optional. The title of the publication.
	//
	// Number of characters allowed is 100.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The description of the publication.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The journal name of the publication.
	//
	// Number of characters allowed is 100.
	Journal string `protobuf:"bytes,4,opt,name=journal,proto3" json:"journal,omitempty"`
	// Optional. Volume number.
	//
	// Number of characters allowed is 100.
	Volume string `protobuf:"bytes,5,opt,name=volume,proto3" json:"volume,omitempty"`
	// Optional. The publisher of the journal.
	//
	// Number of characters allowed is 100.
	Publisher string `protobuf:"bytes,6,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Optional. The publication date.
	PublicationDate *date.Date `protobuf:"bytes,7,opt,name=publication_date,json=publicationDate,proto3" json:"publication_date,omitempty"`
	// Optional. The publication type.
	//
	// Number of characters allowed is 100.
	PublicationType string `protobuf:"bytes,8,opt,name=publication_type,json=publicationType,proto3" json:"publication_type,omitempty"`
	// Optional. ISBN number.
	//
	// Number of characters allowed is 100.
	Isbn                 string   `protobuf:"bytes,9,opt,name=isbn,proto3" json:"isbn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Publication) Reset()         { *m = Publication{} }
func (m *Publication) String() string { return proto.CompactTextString(m) }
func (*Publication) ProtoMessage()    {}
func (*Publication) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{12}
}

func (m *Publication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Publication.Unmarshal(m, b)
}
func (m *Publication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Publication.Marshal(b, m, deterministic)
}
func (m *Publication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Publication.Merge(m, src)
}
func (m *Publication) XXX_Size() int {
	return xxx_messageInfo_Publication.Size(m)
}
func (m *Publication) XXX_DiscardUnknown() {
	xxx_messageInfo_Publication.DiscardUnknown(m)
}

var xxx_messageInfo_Publication proto.InternalMessageInfo

func (m *Publication) GetAuthors() []string {
	if m != nil {
		return m.Authors
	}
	return nil
}

func (m *Publication) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Publication) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Publication) GetJournal() string {
	if m != nil {
		return m.Journal
	}
	return ""
}

func (m *Publication) GetVolume() string {
	if m != nil {
		return m.Volume
	}
	return ""
}

func (m *Publication) GetPublisher() string {
	if m != nil {
		return m.Publisher
	}
	return ""
}

func (m *Publication) GetPublicationDate() *date.Date {
	if m != nil {
		return m.PublicationDate
	}
	return nil
}

func (m *Publication) GetPublicationType() string {
	if m != nil {
		return m.PublicationType
	}
	return ""
}

func (m *Publication) GetIsbn() string {
	if m != nil {
		return m.Isbn
	}
	return ""
}

// Resource that represents the patent acquired by a candidate.
type Patent struct {
	// Optional. Name of the patent.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. A list of inventors' names.
	//
	// Number of characters allowed for each is 100.
	Inventors []string `protobuf:"bytes,2,rep,name=inventors,proto3" json:"inventors,omitempty"`
	// Optional. The status of the patent.
	//
	// Number of characters allowed is 100.
	PatentStatus string `protobuf:"bytes,3,opt,name=patent_status,json=patentStatus,proto3" json:"patent_status,omitempty"`
	// Optional. The date the last time the status of the patent was checked.
	PatentStatusDate *date.Date `protobuf:"bytes,4,opt,name=patent_status_date,json=patentStatusDate,proto3" json:"patent_status_date,omitempty"`
	// Optional. The date that the patent was filed.
	PatentFilingDate *date.Date `protobuf:"bytes,5,opt,name=patent_filing_date,json=patentFilingDate,proto3" json:"patent_filing_date,omitempty"`
	// Optional. The name of the patent office.
	//
	// Number of characters allowed is 100.
	PatentOffice string `protobuf:"bytes,6,opt,name=patent_office,json=patentOffice,proto3" json:"patent_office,omitempty"`
	// Optional. The number of the patent.
	//
	// Number of characters allowed is 100.
	PatentNumber string `protobuf:"bytes,7,opt,name=patent_number,json=patentNumber,proto3" json:"patent_number,omitempty"`
	// Optional. The description of the patent.
	//
	// Number of characters allowed is 100,000.
	PatentDescription string `protobuf:"bytes,8,opt,name=patent_description,json=patentDescription,proto3" json:"patent_description,omitempty"`
	// Optional. The skills used in this patent.
	SkillsUsed           []*Skill `protobuf:"bytes,9,rep,name=skills_used,json=skillsUsed,proto3" json:"skills_used,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Patent) Reset()         { *m = Patent{} }
func (m *Patent) String() string { return proto.CompactTextString(m) }
func (*Patent) ProtoMessage()    {}
func (*Patent) Descriptor() ([]byte, []int) {
	return fileDescriptor_f0277fc1d2fabb3b, []int{13}
}

func (m *Patent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Patent.Unmarshal(m, b)
}
func (m *Patent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Patent.Marshal(b, m, deterministic)
}
func (m *Patent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Patent.Merge(m, src)
}
func (m *Patent) XXX_Size() int {
	return xxx_messageInfo_Patent.Size(m)
}
func (m *Patent) XXX_DiscardUnknown() {
	xxx_messageInfo_Patent.DiscardUnknown(m)
}

var xxx_messageInfo_Patent proto.InternalMessageInfo

func (m *Patent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Patent) GetInventors() []string {
	if m != nil {
		return m.Inventors
	}
	return nil
}

func (m *Patent) GetPatentStatus() string {
	if m != nil {
		return m.PatentStatus
	}
	return ""
}

func (m *Patent) GetPatentStatusDate() *date.Date {
	if m != nil {
		return m.PatentStatusDate
	}
	return nil
}

func (m *Patent) GetPatentFilingDate() *date.Date {
	if m != nil {
		return m.PatentFilingDate
	}
	return nil
}

func (m *Patent) GetPatentOffice() string {
	if m != nil {
		return m.PatentOffice
	}
	return ""
}

func (m *Patent) GetPatentNumber() string {
	if m != nil {
		return m.PatentNumber
	}
	return ""
}

func (m *Patent) GetPatentDescription() string {
	if m != nil {
		return m.PatentDescription
	}
	return ""
}

func (m *Patent) GetSkillsUsed() []*Skill {
	if m != nil {
		return m.SkillsUsed
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.talent.v4beta1.Resume_ResumeType", Resume_ResumeType_name, Resume_ResumeType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.Phone_PhoneType", Phone_PhoneType_name, Phone_PhoneType_value)
	proto.RegisterType((*Profile)(nil), "google.cloud.talent.v4beta1.Profile")
	proto.RegisterMapType((map[string]*CustomAttribute)(nil), "google.cloud.talent.v4beta1.Profile.CustomAttributesEntry")
	proto.RegisterType((*Resume)(nil), "google.cloud.talent.v4beta1.Resume")
	proto.RegisterType((*PersonName)(nil), "google.cloud.talent.v4beta1.PersonName")
	proto.RegisterType((*PersonName_PersonStructuredName)(nil), "google.cloud.talent.v4beta1.PersonName.PersonStructuredName")
	proto.RegisterType((*Address)(nil), "google.cloud.talent.v4beta1.Address")
	proto.RegisterType((*Email)(nil), "google.cloud.talent.v4beta1.Email")
	proto.RegisterType((*Phone)(nil), "google.cloud.talent.v4beta1.Phone")
	proto.RegisterType((*PersonalUri)(nil), "google.cloud.talent.v4beta1.PersonalUri")
	proto.RegisterType((*AdditionalContactInfo)(nil), "google.cloud.talent.v4beta1.AdditionalContactInfo")
	proto.RegisterType((*EmploymentRecord)(nil), "google.cloud.talent.v4beta1.EmploymentRecord")
	proto.RegisterType((*EducationRecord)(nil), "google.cloud.talent.v4beta1.EducationRecord")
	proto.RegisterType((*Degree)(nil), "google.cloud.talent.v4beta1.Degree")
	proto.RegisterType((*Activity)(nil), "google.cloud.talent.v4beta1.Activity")
	proto.RegisterType((*Publication)(nil), "google.cloud.talent.v4beta1.Publication")
	proto.RegisterType((*Patent)(nil), "google.cloud.talent.v4beta1.Patent")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/profile.proto", fileDescriptor_f0277fc1d2fabb3b)
}

var fileDescriptor_f0277fc1d2fabb3b = []byte{
	// 2288 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xcd, 0x72, 0x1b, 0xb9,
	0xf1, 0x17, 0x49, 0x89, 0x1f, 0xcd, 0x0f, 0x91, 0xb0, 0x25, 0xcf, 0x5f, 0xf6, 0xfe, 0xad, 0xe5,
	0xc6, 0xb1, 0x76, 0xe3, 0xa5, 0x36, 0xda, 0x4d, 0x2a, 0xf1, 0x6e, 0xb2, 0xab, 0x0f, 0xda, 0x62,
	0xac, 0x0f, 0xd6, 0x48, 0x72, 0xad, 0x53, 0xa9, 0x9a, 0x02, 0x39, 0x20, 0x05, 0x79, 0x38, 0x33,
	0x3b, 0x98, 0x91, 0xad, 0x6b, 0x5e, 0x20, 0x95, 0x73, 0x72, 0x4a, 0xae, 0xa9, 0x5c, 0xf2, 0x28,
	0x39, 0xe4, 0xb2, 0xa7, 0xbc, 0x42, 0x5e, 0x20, 0x85, 0x06, 0x66, 0x38, 0xa4, 0x25, 0x8a, 0x49,
	0x39, 0x17, 0x69, 0xd0, 0xf8, 0xfd, 0x1a, 0x40, 0xa3, 0xd1, 0xe8, 0x06, 0xe1, 0xe3, 0xa1, 0xe7,
	0x0d, 0x1d, 0xb6, 0xd9, 0x77, 0xbc, 0xc8, 0xde, 0x0c, 0xa9, 0xc3, 0xdc, 0x70, 0xf3, 0xf2, 0x8b,
	0x1e, 0x0b, 0xe9, 0x8f, 0x37, 0xfd, 0xc0, 0x1b, 0x70, 0x87, 0xb5, 0xfc, 0xc0, 0x0b, 0x3d, 0x72,
	0x5f, 0x41, 0x5b, 0x08, 0x6d, 0x29, 0x68, 0x4b, 0x43, 0xd7, 0x1e, 0x68, 0x3d, 0xd4, 0xe7, 0x9b,
	0xd4, 0x75, 0xbd, 0x90, 0x86, 0xdc, 0x73, 0x85, 0xa2, 0xae, 0x6d, 0xcc, 0x1a, 0xa5, 0xef, 0x8d,
	0x46, 0x9e, 0xab, 0x91, 0x8f, 0x66, 0x21, 0x2f, 0xbc, 0x9e, 0x86, 0xfd, 0xbf, 0x86, 0x61, 0xab,
	0x17, 0x0d, 0x36, 0xed, 0x28, 0xc0, 0x11, 0x75, 0xff, 0xfa, 0x74, 0xff, 0x80, 0x33, 0xc7, 0xb6,
	0x46, 0x54, 0xbc, 0xd6, 0x88, 0x87, 0xd3, 0x88, 0x90, 0x8f, 0x98, 0x08, 0xe9, 0xc8, 0xbf, 0x69,
	0x88, 0x37, 0x01, 0xf5, 0x7d, 0x16, 0xc4, 0x6b, 0x5a, 0xd5, 0xfd, 0xe1, 0x95, 0xcf, 0x36, 0x6d,
	0x1a, 0xb2, 0xa9, 0xa1, 0x51, 0xee, 0x7b, 0x22, 0xa4, 0x8e, 0x45, 0x6d, 0x3b, 0x60, 0x42, 0x33,
	0x9b, 0xdf, 0x57, 0xa1, 0xd0, 0x55, 0xa6, 0x25, 0x04, 0x16, 0x5d, 0x3a, 0x62, 0x46, 0x66, 0x3d,
	0xb3, 0x51, 0x32, 0xf1, 0x9b, 0x3c, 0x84, 0x32, 0x7b, 0x1b, 0xb2, 0xc0, 0xa5, 0x8e, 0xc5, 0x6d,
	0x23, 0x8b, 0x5d, 0x10, 0x8b, 0x3a, 0x36, 0x59, 0x85, 0xbc, 0xf0, 0xa2, 0xa0, 0xcf, 0x8c, 0x1c,
	0xf6, 0xe9, 0x16, 0xa9, 0x43, 0x2e, 0x0a, 0xb8, 0xb1, 0x88, 0x42, 0xf9, 0x49, 0xfe, 0x0f, 0x8a,
	0xc3, 0xc0, 0x8b, 0x7c, 0xa9, 0x67, 0x09, 0xc5, 0x05, 0x6c, 0x77, 0x6c, 0xf2, 0x73, 0x00, 0x2e,
	0xac, 0x73, 0x1e, 0xd0, 0x9e, 0xc3, 0x8c, 0xfc, 0x7a, 0x66, 0xa3, 0xbc, 0xb5, 0xd6, 0xd2, 0x7b,
	0x1c, 0x2f, 0xba, 0xb5, 0xe3, 0x79, 0xce, 0x4b, 0xea, 0x44, 0xcc, 0x2c, 0x71, 0xb1, 0xaf, 0xc0,
	0xe4, 0x4b, 0x28, 0xf7, 0x03, 0x46, 0x43, 0x66, 0x49, 0xa3, 0x19, 0x85, 0x1b, 0xb8, 0xa7, 0xb1,
	0x45, 0x4d, 0x50, 0x70, 0x29, 0x90, 0xe4, 0xc8, 0xb7, 0x13, 0x72, 0xf1, 0x76, 0xb2, 0x82, 0x6b,
	0x72, 0x3e, 0x60, 0x22, 0x1a, 0x31, 0xe3, 0x27, 0xc8, 0xfb, 0xa8, 0x35, 0xc3, 0x29, 0x5b, 0x26,
	0x42, 0x4d, 0x4d, 0x21, 0xbf, 0x82, 0x8a, 0xdc, 0x3f, 0xcf, 0xb5, 0xa4, 0x99, 0x85, 0x51, 0x5e,
	0xcf, 0x6d, 0x94, 0xb7, 0x1e, 0xcf, 0x54, 0xd1, 0x45, 0xc2, 0x11, 0x1d, 0x31, 0xb3, 0xec, 0x27,
	0xdf, 0x82, 0xec, 0x40, 0x49, 0x6f, 0x2a, 0x13, 0x46, 0x05, 0x15, 0xfd, 0x60, 0xa6, 0xa2, 0x6d,
	0x85, 0x36, 0xc7, 0x34, 0xf2, 0x02, 0x96, 0xd9, 0x88, 0xf2, 0xc4, 0x3d, 0x98, 0x30, 0xaa, 0xa8,
	0xa9, 0x39, 0x53, 0x53, 0x5b, 0x72, 0xcc, 0x1a, 0x52, 0xb7, 0x13, 0x65, 0xcf, 0xa1, 0xea, 0x9f,
	0x7b, 0x2e, 0xb3, 0xdc, 0x68, 0xd4, 0x63, 0x81, 0x30, 0x6a, 0x73, 0xa8, 0xea, 0x4a, 0x86, 0x59,
	0x41, 0xe2, 0x91, 0xe2, 0x91, 0x43, 0xa8, 0xaa, 0x85, 0x52, 0xc7, 0x8a, 0x02, 0x2e, 0x8c, 0x65,
	0x54, 0xb4, 0x31, 0x87, 0x99, 0xa8, 0x73, 0x16, 0x70, 0xb3, 0xe2, 0x8f, 0x1b, 0x82, 0x5c, 0xc0,
	0x3d, 0x6a, 0xdb, 0x5c, 0x9e, 0x4d, 0xea, 0x58, 0x7d, 0xcf, 0x0d, 0x69, 0x3f, 0xb4, 0xb8, 0x3b,
	0xf0, 0x8c, 0x3a, 0x2a, 0xde, 0xba, 0xcd, 0x6c, 0x9a, 0xbb, 0xab, 0xa8, 0x1d, 0x77, 0xe0, 0x99,
	0x2b, 0xf4, 0x3a, 0x31, 0xf9, 0x0d, 0x10, 0x36, 0xf2, 0x1d, 0xef, 0x6a, 0xc4, 0xdc, 0xd0, 0x0a,
	0x58, 0xdf, 0x0b, 0x6c, 0x61, 0x34, 0x70, 0x98, 0x4f, 0x6f, 0xb1, 0x69, 0x4c, 0x33, 0x91, 0x65,
	0x36, 0xd8, 0x94, 0x44, 0x90, 0x57, 0xd0, 0x60, 0x76, 0xd4, 0xc7, 0x30, 0x93, 0x28, 0x27, 0xa8,
	0xfc, 0xc9, 0x6c, 0xe5, 0x31, 0x4b, 0xeb, 0xae, 0xb3, 0x49, 0x81, 0x20, 0x4f, 0x21, 0x2f, 0x5e,
	0x73, 0xc7, 0x11, 0xc6, 0x9d, 0x39, 0x76, 0xed, 0x44, 0x42, 0x4d, 0xcd, 0x20, 0x6d, 0x00, 0xda,
	0x0f, 0xf9, 0x25, 0x0f, 0x39, 0x13, 0xc6, 0x5d, 0xe4, 0x3f, 0x9a, 0x6d, 0x53, 0x05, 0xbf, 0x32,
	0x53, 0x44, 0x72, 0x00, 0x15, 0x3f, 0xea, 0x39, 0x5c, 0x4d, 0x4c, 0x18, 0x2b, 0xf3, 0xec, 0xfa,
	0x98, 0x60, 0x4e, 0xb0, 0xc9, 0x2f, 0xa0, 0xe0, 0xd3, 0x90, 0xb9, 0xa1, 0x30, 0x56, 0x51, 0xd1,
	0xec, 0x83, 0xda, 0x45, 0xac, 0x19, 0x73, 0x88, 0x09, 0xb5, 0x3e, 0x0b, 0x42, 0x3e, 0x48, 0xa6,
	0x73, 0x0f, 0xb5, 0x7c, 0x32, 0x53, 0xcb, 0x6e, 0x9a, 0x62, 0x4e, 0x69, 0x20, 0x4d, 0xa8, 0x50,
	0xdf, 0x1f, 0x2f, 0x70, 0x73, 0x3d, 0xb7, 0x51, 0x32, 0x27, 0x64, 0x64, 0x1d, 0xca, 0x54, 0x08,
	0x3e, 0x74, 0x47, 0x38, 0xf5, 0xcf, 0x10, 0x92, 0x16, 0x91, 0x21, 0x34, 0xfa, 0x91, 0x08, 0xbd,
	0x91, 0x45, 0xc3, 0x30, 0xe0, 0xbd, 0x28, 0x64, 0xc2, 0x58, 0xc3, 0xc9, 0x3d, 0x9d, 0xbd, 0x44,
	0x7d, 0x97, 0xee, 0x22, 0x7b, 0x3b, 0x21, 0xb7, 0xdd, 0x30, 0xb8, 0x32, 0xeb, 0xfd, 0x29, 0x31,
	0x79, 0x00, 0x25, 0x3f, 0xf0, 0xfa, 0xf2, 0x70, 0xdb, 0xc6, 0xfd, 0xf5, 0xcc, 0x46, 0xd1, 0x1c,
	0x0b, 0xc8, 0x63, 0x58, 0x7e, 0xcd, 0xae, 0xde, 0x78, 0x81, 0x6d, 0x09, 0x97, 0xfb, 0x3e, 0x0b,
	0x8d, 0x07, 0x18, 0xde, 0x6b, 0x5a, 0x7c, 0xa2, 0xa4, 0x6b, 0xdf, 0xc1, 0xca, 0xb5, 0x23, 0xca,
	0xbb, 0xe2, 0x35, 0xbb, 0xd2, 0xf7, 0x8e, 0xfc, 0x24, 0x3b, 0xb0, 0x74, 0x29, 0x23, 0x3d, 0x5e,
	0x38, 0xb7, 0xf9, 0xf4, 0x94, 0x52, 0x53, 0x51, 0x9f, 0x66, 0x7f, 0x96, 0x69, 0xfe, 0x3d, 0x03,
	0x79, 0x15, 0x79, 0xc9, 0x8f, 0xa0, 0x21, 0xc2, 0x20, 0xea, 0x87, 0x51, 0xc0, 0x6c, 0x4b, 0x47,
	0x6e, 0x35, 0x64, 0x7d, 0xdc, 0xa1, 0xc1, 0xc7, 0x50, 0x56, 0x08, 0x4b, 0x5e, 0x9d, 0x38, 0x8b,
	0xda, 0x56, 0x6b, 0x8e, 0x00, 0xaf, 0xff, 0x9d, 0x5e, 0xf9, 0xcc, 0x84, 0x20, 0xf9, 0x6e, 0xbe,
	0x00, 0x18, 0xf7, 0x90, 0xfb, 0x70, 0xcf, 0x6c, 0x9f, 0x9c, 0x1d, 0xb6, 0xad, 0xd3, 0x57, 0xdd,
	0xb6, 0x75, 0x76, 0x74, 0xd2, 0x6d, 0xef, 0x76, 0x9e, 0x75, 0xda, 0x7b, 0xf5, 0x05, 0x52, 0x82,
	0xa5, 0x7d, 0xf3, 0xdb, 0xc3, 0x83, 0x7a, 0x86, 0xac, 0x40, 0xe3, 0xf8, 0x74, 0xbf, 0x6d, 0x5a,
	0x29, 0x74, 0x3d, 0xdb, 0xfc, 0x5b, 0x0e, 0x60, 0x7c, 0x19, 0x90, 0xc7, 0x50, 0x1b, 0x78, 0xc1,
	0x88, 0x86, 0x21, 0xb3, 0xad, 0xf1, 0x0d, 0xbe, 0xbf, 0x60, 0x56, 0x13, 0x39, 0x02, 0x87, 0xb0,
	0x9c, 0x32, 0x01, 0x22, 0x95, 0x7d, 0xbf, 0x9a, 0xf3, 0xde, 0xd1, 0x9f, 0x27, 0x89, 0x12, 0x29,
	0xdc, 0x5f, 0x30, 0x6b, 0x62, 0x42, 0x42, 0x1e, 0x41, 0xcd, 0x0f, 0xd8, 0x80, 0x05, 0xc9, 0x38,
	0x2a, 0x39, 0xa8, 0x26, 0x52, 0x09, 0x5b, 0xfb, 0x3e, 0x03, 0x77, 0xaf, 0xd3, 0x48, 0x3e, 0x00,
	0x18, 0xf2, 0x4b, 0xe6, 0xa6, 0x56, 0x63, 0x96, 0x50, 0x72, 0x83, 0xfa, 0xfc, 0x35, 0xea, 0x25,
	0x6c, 0xc4, 0x6d, 0xdb, 0x61, 0x16, 0x77, 0x79, 0xc8, 0xa9, 0xa3, 0xd3, 0x97, 0xaa, 0x92, 0x76,
	0x94, 0x50, 0xa6, 0x38, 0x03, 0x3a, 0xe2, 0xce, 0x55, 0x7a, 0xa6, 0xa0, 0x44, 0xa8, 0x67, 0x0d,
	0x8a, 0x22, 0x1a, 0x0c, 0xf8, 0x5b, 0x26, 0x8c, 0x45, 0x3c, 0x86, 0x49, 0x5b, 0xf6, 0xc9, 0x41,
	0xb1, 0x6f, 0x49, 0xf5, 0xc5, 0xed, 0x9d, 0x2a, 0x94, 0x53, 0x77, 0x7c, 0xf3, 0xf7, 0x59, 0x28,
	0xe8, 0x3b, 0x92, 0xec, 0xc2, 0x52, 0x24, 0xe8, 0x50, 0xad, 0xad, 0x76, 0xcb, 0x85, 0x90, 0xba,
	0x56, 0xce, 0x24, 0xc9, 0x54, 0x5c, 0xf2, 0x39, 0xdc, 0x8d, 0xdc, 0xd4, 0x86, 0xea, 0xab, 0x5b,
	0xad, 0x72, 0x7f, 0xc1, 0xbc, 0x93, 0xee, 0x8d, 0x47, 0x7e, 0x01, 0xe4, 0x1a, 0x4a, 0x6e, 0x32,
	0xf3, 0x91, 0x4e, 0xdf, 0xea, 0x62, 0xbe, 0xa8, 0x79, 0xfb, 0x0b, 0x66, 0xe3, 0x5d, 0x65, 0x5f,
	0x40, 0xa1, 0x1f, 0x05, 0x01, 0x73, 0x43, 0x4c, 0xf4, 0x66, 0x27, 0x6d, 0x31, 0x74, 0xa7, 0x04,
	0x05, 0x3d, 0x6e, 0xf3, 0x3b, 0x58, 0xc2, 0x14, 0xe2, 0xfd, 0x18, 0xe4, 0x23, 0xa8, 0x4e, 0x24,
	0x31, 0x7a, 0xbf, 0x2b, 0xe9, 0xf4, 0xa4, 0xf9, 0xaf, 0x2c, 0x2c, 0x61, 0xae, 0xf1, 0x7e, 0xc6,
	0xfc, 0x06, 0x16, 0x53, 0x21, 0xe2, 0xc9, 0xed, 0x29, 0x8e, 0xfa, 0x8b, 0x01, 0x02, 0x99, 0x32,
	0x83, 0x56, 0x79, 0x52, 0x9c, 0x41, 0xab, 0x96, 0x74, 0xdf, 0x37, 0xe7, 0xcc, 0xb5, 0xe8, 0x25,
	0xe5, 0x0e, 0x26, 0xc6, 0x2a, 0x99, 0xae, 0x4a, 0xe9, 0x76, 0x2c, 0x6c, 0xfe, 0x39, 0x03, 0xa5,
	0x44, 0x25, 0x59, 0x83, 0xd5, 0xee, 0xfe, 0xf1, 0xd1, 0xb5, 0x81, 0xa5, 0x02, 0xc5, 0x83, 0xed,
	0xa3, 0xbd, 0x83, 0xce, 0x51, 0xbb, 0x9e, 0x21, 0x00, 0xf9, 0xc3, 0xe3, 0x9d, 0xce, 0x41, 0xbb,
	0x9e, 0x25, 0x05, 0xc8, 0x3d, 0xdb, 0xfe, 0xb6, 0x9e, 0x93, 0xb1, 0xa7, 0xbb, 0xfd, 0xbc, 0x6d,
	0xd6, 0x17, 0x49, 0x0d, 0xe0, 0xf4, 0xf4, 0x95, 0x75, 0x6c, 0x5a, 0xa7, 0x7b, 0x7b, 0xf5, 0x25,
	0x52, 0x85, 0xd2, 0xcb, 0xe3, 0xce, 0x6e, 0xfb, 0x70, 0xbb, 0x73, 0x50, 0xcf, 0x93, 0x32, 0x14,
	0x5e, 0x76, 0xcc, 0xd3, 0xb3, 0xed, 0x83, 0x7a, 0x81, 0x14, 0x61, 0xf1, 0xe5, 0x71, 0xa7, 0x5b,
	0x2f, 0x92, 0x55, 0x20, 0x4a, 0xab, 0x24, 0x26, 0xa3, 0x95, 0x9a, 0x0f, 0xa1, 0x9c, 0xca, 0xcb,
	0xe2, 0xea, 0x20, 0x93, 0x54, 0x07, 0xcd, 0xdf, 0x65, 0x60, 0xe5, 0xda, 0x04, 0xeb, 0xfd, 0x6c,
	0x53, 0x5c, 0xdb, 0x64, 0x53, 0xb5, 0xcd, 0x07, 0x00, 0x49, 0x0e, 0x68, 0x6b, 0xe3, 0x97, 0xb4,
	0xa4, 0x63, 0x37, 0xff, 0xb8, 0x04, 0xf5, 0xe9, 0x5c, 0x8c, 0x7c, 0x06, 0x20, 0x42, 0x1a, 0x84,
	0x96, 0x2c, 0x03, 0x70, 0x46, 0xe5, 0xad, 0xc6, 0xc4, 0xb1, 0xd9, 0xa3, 0x21, 0x33, 0x4b, 0x08,
	0x92, 0x9f, 0xe4, 0x09, 0x14, 0x99, 0x6b, 0x2b, 0x7c, 0xf6, 0x26, 0x7c, 0x81, 0xb9, 0x36, 0xa2,
	0xd1, 0x85, 0xe5, 0x98, 0x2c, 0x48, 0x87, 0xa3, 0x4a, 0x2c, 0xc4, 0x80, 0xf4, 0x11, 0x54, 0x6d,
	0x7e, 0xc9, 0x05, 0xd7, 0xa1, 0x45, 0x3b, 0x46, 0x25, 0x16, 0x22, 0xe8, 0x97, 0xc9, 0x29, 0xc3,
	0x6a, 0x6b, 0xde, 0x9a, 0x20, 0x26, 0x91, 0xfb, 0x50, 0xba, 0xf0, 0x7a, 0x56, 0xc8, 0x43, 0x27,
	0x8e, 0xaf, 0xc5, 0x0b, 0xaf, 0x77, 0x2a, 0xdb, 0xf2, 0xce, 0x97, 0x9d, 0x36, 0x13, 0xfd, 0x80,
	0xfb, 0x72, 0xcf, 0xb0, 0xf2, 0x2a, 0x99, 0xb5, 0x0b, 0xaf, 0xb7, 0x37, 0x96, 0x92, 0xaf, 0xa1,
	0xca, 0x85, 0x25, 0x22, 0x9f, 0x05, 0x97, 0x5c, 0x78, 0xc1, 0x8d, 0x35, 0xd6, 0x38, 0x4e, 0x54,
	0xb8, 0x38, 0x49, 0xf0, 0x64, 0x0f, 0xea, 0x52, 0x01, 0x73, 0x06, 0x96, 0xb6, 0x81, 0x6d, 0x94,
	0x6e, 0xd5, 0x51, 0xe3, 0xe2, 0x84, 0x39, 0x83, 0xb6, 0x66, 0xe8, 0x02, 0x33, 0x8e, 0x55, 0x30,
	0x4f, 0x81, 0xb9, 0xab, 0xc0, 0xe4, 0x13, 0x68, 0x24, 0x76, 0x48, 0x12, 0x9c, 0x32, 0x2e, 0x76,
	0x39, 0xb6, 0x87, 0xce, 0x70, 0xc8, 0x4f, 0xe1, 0xde, 0x94, 0x59, 0x12, 0x46, 0x05, 0x19, 0x2b,
	0x93, 0xe6, 0x89, 0x79, 0x5b, 0xb0, 0x32, 0xb1, 0xeb, 0x09, 0xab, 0x8a, 0xac, 0x3b, 0xe9, 0xdd,
	0xd7, 0x9c, 0xe6, 0x3f, 0x17, 0x61, 0x79, 0x2a, 0x9b, 0xff, 0x9f, 0x7b, 0xe7, 0x0b, 0x30, 0xd8,
	0x5b, 0x9f, 0xf5, 0x65, 0xa2, 0x31, 0x0c, 0xa8, 0x1d, 0xa9, 0x02, 0x04, 0xd9, 0xb9, 0x9b, 0xd8,
	0xab, 0x31, 0xe5, 0x79, 0xc2, 0x40, 0x65, 0x0f, 0xa1, 0x2c, 0xfa, 0xe7, 0x9e, 0xe7, 0xa4, 0x7d,
	0x18, 0x94, 0xe8, 0xbd, 0x78, 0xf0, 0x26, 0x10, 0x9b, 0x0d, 0x03, 0xc6, 0x26, 0xfc, 0x34, 0xaf,
	0x6f, 0xc7, 0x86, 0xea, 0x4b, 0x3b, 0xab, 0x39, 0x91, 0x22, 0xaa, 0x7e, 0xfd, 0xa2, 0x30, 0xbb,
	0x66, 0xd8, 0x43, 0xe8, 0xfe, 0x42, 0x3a, 0x93, 0x54, 0x32, 0x99, 0xc6, 0xa7, 0x47, 0x2f, 0xe2,
	0x2a, 0xd3, 0xa2, 0x29, 0xdf, 0x2c, 0xfd, 0x27, 0xbe, 0xd9, 0x82, 0x3b, 0x29, 0x13, 0x26, 0x5e,
	0x03, 0x38, 0x48, 0x63, 0x6c, 0xca, 0xd8, 0xcf, 0x1e, 0x41, 0x4d, 0x5b, 0x64, 0xd2, 0x91, 0xab,
	0x4a, 0xaa, 0x61, 0x3b, 0x45, 0xc8, 0x2b, 0x41, 0xf3, 0x0f, 0x19, 0xc8, 0xeb, 0x85, 0xec, 0xcb,
	0x85, 0x20, 0x17, 0xef, 0x3b, 0x15, 0x8c, 0x1f, 0xcf, 0x61, 0x16, 0x95, 0x0b, 0xdb, 0xc9, 0xb7,
	0xdc, 0x78, 0xad, 0x29, 0x15, 0x92, 0x35, 0x00, 0x37, 0xfe, 0x87, 0xb0, 0x8c, 0x6f, 0x64, 0xc2,
	0xf2, 0x06, 0x96, 0x08, 0x23, 0xfb, 0xca, 0xc8, 0x61, 0x6e, 0x55, 0x55, 0xe2, 0xe3, 0xc1, 0x89,
	0x14, 0x36, 0xff, 0x91, 0x83, 0x62, 0x5c, 0x40, 0x92, 0x0f, 0xa1, 0x62, 0x73, 0xe1, 0x3b, 0xf4,
	0x2a, 0x9d, 0x35, 0x96, 0xb5, 0x0c, 0xf5, 0x4e, 0xed, 0x45, 0xf6, 0xdd, 0xbd, 0xd0, 0xf7, 0x52,
	0x6e, 0xfc, 0x6a, 0xb5, 0x95, 0xbc, 0x2f, 0xa1, 0x97, 0x2f, 0xde, 0xe4, 0xe5, 0xfa, 0x59, 0x09,
	0x3d, 0x7b, 0x2b, 0x79, 0x56, 0x42, 0xce, 0xd2, 0x8d, 0x1c, 0x85, 0x42, 0xce, 0x87, 0x50, 0x09,
	0x19, 0x1d, 0x59, 0x23, 0xa6, 0x9e, 0x4c, 0xf2, 0xaa, 0xde, 0x93, 0xb2, 0x43, 0x25, 0x22, 0xbb,
	0x50, 0x56, 0x75, 0xb6, 0x15, 0xc9, 0x42, 0xac, 0x30, 0x77, 0x79, 0x0e, 0x8a, 0x76, 0x26, 0xab,
	0xb5, 0x2d, 0x58, 0xd1, 0x95, 0xf6, 0xd5, 0xa4, 0xd3, 0x28, 0xcf, 0xbc, 0x13, 0x77, 0xa6, 0xdd,
	0xe6, 0x1b, 0x78, 0x90, 0x70, 0xae, 0x8b, 0x6d, 0x25, 0xa4, 0xae, 0xc5, 0x98, 0x6b, 0x02, 0x9c,
	0x74, 0xd4, 0xf1, 0xd4, 0x53, 0x8e, 0x9a, 0x43, 0x47, 0x4d, 0xa6, 0x17, 0x07, 0xb7, 0xbf, 0x64,
	0xa1, 0x9c, 0xaa, 0xe8, 0x89, 0x01, 0x05, 0x1a, 0x85, 0xe7, 0x5e, 0x20, 0x8c, 0x0c, 0x72, 0xe2,
	0x26, 0xb9, 0x0b, 0x4b, 0xea, 0x8a, 0x52, 0xbb, 0xa9, 0x1a, 0xd3, 0x3b, 0x9d, 0x7b, 0x77, 0xa7,
	0x0d, 0x28, 0x5c, 0x78, 0x51, 0xe0, 0x52, 0x47, 0x47, 0x9e, 0xb8, 0x29, 0xf3, 0xb1, 0x4b, 0xcf,
	0x91, 0xd5, 0xa1, 0x7a, 0xa5, 0xd4, 0x2d, 0xac, 0x82, 0xe5, 0x94, 0xc4, 0x39, 0x0b, 0xf4, 0x85,
	0x38, 0x16, 0x90, 0xaf, 0xa0, 0x9e, 0x7a, 0x75, 0x50, 0x1b, 0x5f, 0xb8, 0x69, 0xe3, 0x97, 0x53,
	0x50, 0xdc, 0xfd, 0x8f, 0x27, 0xd9, 0x78, 0xc2, 0xd4, 0x86, 0xa4, 0xa1, 0x78, 0x7a, 0x08, 0x2c,
	0x72, 0xd1, 0x73, 0xb5, 0xd1, 0xf1, 0xbb, 0xf9, 0xd7, 0x1c, 0xe4, 0xd5, 0xbb, 0xc5, 0x3c, 0xc7,
	0xe0, 0x01, 0x94, 0xb8, 0x7b, 0xc9, 0xdc, 0x50, 0x9a, 0x33, 0x8b, 0xe6, 0x1c, 0x0b, 0x64, 0x72,
	0xa1, 0x9e, 0x3e, 0x2c, 0x11, 0xd2, 0x30, 0x12, 0x71, 0x06, 0xa2, 0x84, 0x27, 0x28, 0x23, 0x5f,
	0x03, 0x99, 0x00, 0xdd, 0x72, 0x38, 0xea, 0x69, 0x32, 0x2e, 0x78, 0xac, 0x60, 0xc0, 0x1d, 0xee,
	0x0e, 0x6f, 0x39, 0x29, 0x5a, 0xc1, 0x33, 0xc4, 0xc6, 0x89, 0x92, 0x56, 0xe0, 0x0d, 0x06, 0xbc,
	0x1f, 0xa7, 0x28, 0x7a, 0x9a, 0xc7, 0x28, 0x4b, 0x81, 0x74, 0x86, 0x5d, 0x48, 0x83, 0xd4, 0x2b,
	0x23, 0xf9, 0x34, 0x99, 0xca, 0xbb, 0x81, 0xba, 0xa1, 0x7a, 0xd2, 0x97, 0xc4, 0xd4, 0x29, 0x2c,
	0xfd, 0x37, 0xa7, 0x70, 0xe7, 0xb7, 0x19, 0x78, 0xd8, 0xf7, 0x46, 0xb3, 0x58, 0x3b, 0x77, 0xf5,
	0x33, 0x8d, 0xc9, 0xd4, 0x93, 0x7a, 0x57, 0x5e, 0x05, 0xdd, 0xcc, 0xaf, 0xb7, 0x35, 0x69, 0xe8,
	0x39, 0xd4, 0x1d, 0xb6, 0xbc, 0x60, 0xb8, 0x39, 0x64, 0x2e, 0x5e, 0x14, 0x9b, 0xaa, 0x8b, 0xfa,
	0x5c, 0x5c, 0xfb, 0xab, 0xc5, 0x97, 0xaa, 0xf9, 0xa7, 0x6c, 0x6e, 0xf7, 0xf4, 0xa4, 0x97, 0x47,
	0xce, 0xe7, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xbe, 0x13, 0x82, 0x47, 0x78, 0x19, 0x00, 0x00,
}
