// Copyright 2012, Google, Inc. All rights reserved.
//
// Use of this source code is governed by a BSD-style license
// that can be found in the LICENSE file in the root of the source
// tree.

package layers

import (
	"code.google.com/p/gopacket"
	"testing"
)

// testPacketIPSecESP is the packet:
//   04:30:37.629376 IP 190.0.0.1 > 190.0.0.2: ESP(spi=0x0000006e,seq=0x13), length 116
//      0x0000:  0000 0000 0012 0011 434a d70a 0800 4500  ........CJ....E.
//      0x0010:  0088 0000 4000 4032 be40 be00 0001 be00  ....@.@2.@......
//      0x0020:  0002 0000 006e 0000 0013 82f4 1077 0418  .....n.......w..
//      0x0030:  e8ce dc45 1bac 22bb daaf 2ad2 c2e8 315b  ...E.."...*...1[
//      0x0040:  ce9a 39da 2aae cf43 3716 70ab 7e7c 4676  ..9.*..C7.p.~|Fv
//      0x0050:  c3fc d109 c990 274d f81c 6534 9a40 a0ef  ......'M..e4.@..
//      0x0060:  46b1 7da5 05af dda8 d0ba 6e23 d1ee 1f10  F.}.......n#....
//      0x0070:  730c 7371 03b1 445c 2f70 852f 8475 12fb  s.sq..D\/p./.u..
//      0x0080:  b057 a19b a617 bae7 09ca 8836 942f 3334  .W.........6./34
//      0x0090:  312b 96d2 a4e3                           1+....
var testPacketIPSecESP = []byte{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x11, 0x43, 0x4a, 0xd7, 0x0a, 0x08, 0x00, 0x45, 0x00,
	0x00, 0x88, 0x00, 0x00, 0x40, 0x00, 0x40, 0x32, 0xbe, 0x40, 0xbe, 0x00, 0x00, 0x01, 0xbe, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x13, 0x82, 0xf4, 0x10, 0x77, 0x04, 0x18,
	0xe8, 0xce, 0xdc, 0x45, 0x1b, 0xac, 0x22, 0xbb, 0xda, 0xaf, 0x2a, 0xd2, 0xc2, 0xe8, 0x31, 0x5b,
	0xce, 0x9a, 0x39, 0xda, 0x2a, 0xae, 0xcf, 0x43, 0x37, 0x16, 0x70, 0xab, 0x7e, 0x7c, 0x46, 0x76,
	0xc3, 0xfc, 0xd1, 0x09, 0xc9, 0x90, 0x27, 0x4d, 0xf8, 0x1c, 0x65, 0x34, 0x9a, 0x40, 0xa0, 0xef,
	0x46, 0xb1, 0x7d, 0xa5, 0x05, 0xaf, 0xdd, 0xa8, 0xd0, 0xba, 0x6e, 0x23, 0xd1, 0xee, 0x1f, 0x10,
	0x73, 0x0c, 0x73, 0x71, 0x03, 0xb1, 0x44, 0x5c, 0x2f, 0x70, 0x85, 0x2f, 0x84, 0x75, 0x12, 0xfb,
	0xb0, 0x57, 0xa1, 0x9b, 0xa6, 0x17, 0xba, 0xe7, 0x09, 0xca, 0x88, 0x36, 0x94, 0x2f, 0x33, 0x34,
	0x31, 0x2b, 0x96, 0xd2, 0xa4, 0xe3,
}

func TestPacketIPSecESP(t *testing.T) {
	p := gopacket.NewPacket(testPacketIPSecESP, LinkTypeEthernet, gopacket.Default)
	if p.ErrorLayer() != nil {
		t.Error("Failed to decode packet:", p.ErrorLayer().Error())
	}
	checkLayers(p, []gopacket.LayerType{LayerTypeEthernet, LayerTypeIPv4, LayerTypeIPSecESP}, t)
}
func BenchmarkDecodePacketIPSecESP(b *testing.B) {
	for i := 0; i < b.N; i++ {
		gopacket.NewPacket(testPacketIPSecESP, LinkTypeEthernet, gopacket.NoCopy)
	}
}
