
# add Tests "Añadir variables a un modelo"

Las variables escogidas se añaden al modelo previo y se estima el nuevo modelo así resultante. Como consecuencia, se presenta el valor de un estadístico que contrasta la significación conjunta de las variables añadidas, junto con su probabilidad asociada (valor p). 

Menú gráfico: Ventana de modelo: Contrastes/Añadir variables

Instrucción de guión: <@ref="add">

# addline Graphs "Añadir una línea a un gráfico"

Esta caja de diálogo te permite añadirle a un gráfico, una línea definida mediante una fórmula que debe ser una expresión admisible para Gnuplot. Debes usar <@lit="x"> para denotar el valor de la variable del eje de abscisas. Ten en cuenta que Gnuplot utiliza <@lit="**"> para elevar a la potencia, y que el carácter decimal debe indicarse con “.”. Ejemplos: 

<code>          
   10+0.35*x
   100+5.3*x-0.12*x**2
   sin(x)
   exp(sqrt(pi*x))
</code>

# adf Tests "Contraste aumentado de Dickey-Fuller"

Esta instrucción necesita que indiques el orden de retardos con un número entero; si el orden es cero, se ejecuta el contraste estándar de Dickey–Fuller (no aumentado). Con él se calcula un conjunto de contrastes de Dickey–Fuller sobre la(s) variable(s) del argumento, siendo la hipótesis nula la existencia de una raíz unitaria. (Ahora bien, cuando escoges la opción 'difference', se calcula la primera diferencia de la(s) variable(s) antes de hacer el contraste, y la discusión de abajo debes entenderla como referida a la(s) variable(s) transformada(s).) 

En todos los casos, la variable dependiente es la primera diferencia de la variable especificada (<@mth="y">) y la variable independiente clave es el primer retardo de <@mth="y">. El modelo se construye de modo que el coeficiente de la variable <@mth="y"> retardada, es igual a la raíz en cuestión menos 1. Por ejemplo, el modelo con constante puede escribirse como 

  <@fig="adf1">

Bajo la hipótesis nula de existencia de una raíz unitaria, el coeficiente de la variable <@mth="y"> retardada es igual a cero; y bajo la hipótesis alternativa de que <@mth="y"> es estacionaria, este coeficiente es negativo. 

Si el orden de retardos (<@mth="k">) es mayor que 0, entonces se incluyen <@mth="k"> retardos de la variable dependiente en el lado derecho de cada una de las regresiones necesarias para calcular los estadísticos de los contrastes, sujeto esto al siguiente requisito. Cuando marcas el cuadradito de “Contrastar desde el máximo orden de retardos hacia abajo”, el orden de retardos que indicas se toma como máximo, y el orden de retardos concreto que se utilizará, se obtiene probando hacia abajo (mediante el criterio que elijas en la lista desplegable adjunta). 

Cuando pides que se pruebe hacia atrás mediante AIC o BIC, el orden de retardos final para la ecuación ADF es el que optimiza el criterio de información escogido (de Akaike o Bayesiano de Schwarz). 

Cuando pides que se pruebe hacia atrás mediante el método del estadístico <@mth="t">, el procedimiento es como se indica a continuación: 

<indent>
1. Se estima la regresión de Dickey–Fuller utilizando <@mth="k"> retardos de la variable dependiente. 
</indent>

<indent>
2. ¿Es significativo el último retardo? Si lo es, se ejecuta el contraste con un orden de retardos <@mth="k">. Si no lo es, se hace que <@mth="k"> = <@mth="k"> – 1, y se vuelve al paso 1 con un retardo menos. El proceso se repite hasta que sea significativo el último retardo de una regresión, o hasta que <@mth="k"> sea 0 (se haría el contraste con un orden de retardos igual a 0). 
</indent>

En el contexto del paso 2 de arriba, “significativo” quiere decir que el estadístico <@mth="t"> del último retardo tiene un valor <@itl="p"> asintótico de dos colas igual o menor que 0.10, frente a la distribución Normal. 

Los valores <@itl="P"> para los contrastes de Dickey–Fuller están basados en <@bib="MacKinnon (1996);mackinnon96">; y el código relevante se incluye con el amable permiso del propio autor. En el caso del contraste con la tendencia lineal utilizando MCG (GLS), estos valores <@itl="P"> no son aplicables; por eso, en su lugar se muestran los puntos críticos de la Tabla 1 que hay en <@bib="Elliott, Rothenberg y Stock (1996);ERS96">. 

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste aumentado de Dickey-Fuller

Instrucción de guión: <@ref="adf">

# anova Statistics "ANOVA"

Análisis de la Varianza: El argumento <@var="respuesta"> deberá ser una serie que mida algún efecto de interés, y <@var="tratamiento"> deberá ser una variable discreta que codifique dos o más tipos de tratamiento (o no tratamiento). Para un ANOVA de dos factores, la variable <@var="control"> (que también será discreta) deberá codificar los valores de alguna variable de control. 

La hipótesis nula del contraste <@mth="F"> es que la respuesta media es invariante con respecto al tipo de tratamiento o, en otras palabras, que el tratamiento no tiene efecto. Hablando estrictamente, el contraste solo es válido cuando la varianza de la respuesta es la misma para todos los tipos de tratamiento. 

Ten en cuenta que los resultados que muestra esta instrucción son de hecho un subconjunto de la información ofrecida por el siguiente procedimiento, que puedes preparar fácilmente en el Gretl. (1) Genera un conjunto de variables ficticias que codifiquen todos los tipos de tratamiento excepto uno. Para un ANOVA de dos factores, genera además un conjunto de variables ficticias que codifiquen todos los bloques de “control” excepto uno. (2) Haz la regresión de <@var="respuesta"> sobre una constante y las variables ficticias utilizando <@ref="ols">. Con un único factor, se presenta la tabla ANOVA mediante la opción <@opt="--⁠anova"> en esa función <@lit="ols">. En caso de dos factores, el contraste <@mth="F"> relevante lo encuentras utilizando la instrucción <@ref="omit"> luego de la regresión. Por ejemplo, (asumiendo que <@var="respuesta"> es <@lit="y">, que <@lit="xt"> codifica el tratamiento, y que <@lit="xb"> codifica los bloques de “control”): 

<code>          
   # Un factor
   list Fict_xt = dummify(xt)
   ols y 0 Fict_xt --anova
   # Dos factores
   list Fict_xb = dummify(xb)
   ols y 0 Fict_xt Fict_xb
   # Contraste de significación conjunta de Fict_xt
   omit Fict_xt --quiet
</code>

Menú gráfico: /Modelo/Otros modelos lineales/ANOVA

Instrucción de guión: <@ref="anova">

# ar Estimation "Estimación autorregresiva"

Calcula las estimaciones de los parámetros utilizando el procedimiento iterativo generalizado de Cochrane–Orcutt; consulta la Sección 9.5 de <@bib="Ramanathan (2002);ramanathan02">. Las iteraciones acaban cuando la sucesión de sumas de errores cuadrados no difiere de un término al siguiente en más del 0.005 por ciento, o después de 20 iteraciones. 

Con la “Lista de retardos AR” especificas la estructura del proceso generador del término de perturbación. Por ejemplo, la indicación “1 3 4” se corresponde con el proceso: 

  <@fig="arlags">

Menú gráfico: /Modelo/Series temporales/Errores AR (MCG)

Instrucción de guión: <@ref="ar">

# ar1 Estimation "Estimación AR(1)"

Calcula estimaciones MCG que sean viables para un modelo en el que el término de perturbación se asume que sigue un proceso autorregresivo de primer orden. 

El método utilizado por defecto es el procedimiento iterativo de Cochrane–Orcutt; por ejemplo, consulta la sección 9.4 de <@bib="Ramanathan (2002);ramanathan02">. El criterio para lograr la convergencia es que las estimaciones sucesivas del coeficiente de autocorrelación, no difieran en más de 1e-6 o, cuando indicas la opción <@opt="--⁠loose">, en más de 0.001. Si esto no se alcanza antes de que se hagan las 100 iteraciones, se muestra un fallo. 

Cuando indicas la opción <@opt="--⁠pwe">, se utiliza el estimador de Prais–Winsten. Esto implica una iteración similar a la de Cochrane–Orcutt; la diferencia está en que mientras que el método de Cochrane–Orcutt descarta la primera observación, el método de Prais–Winsten hace uso de ella. Para obtener más detalles consulta, por ejemplo, el capítulo 13 de <@bib="Greene (2000);greene00">. 

Cuando indicas la opción <@opt="--⁠hilu">, se utiliza el procedimiento de búsqueda de Hildreth–Lu. En ese caso, se afinan los resultados utilizando el método de Cochrane–Orcutt, excepto que especifiques la opción <@opt="--⁠no-corc">. Esta opción <@opt="--⁠no-corc"> se ignora para estimadores diferentes al del método de Hildreth–Lu. 

Menú gráfico: /Modelo/Series temporales/Errores AR (MCG)

Instrucción de guión: <@ref="ar1">

# arch Estimation "Modelo ARCH"

En este momento, esta instrucción se mantiene por compatibilidad con versiones anteriores, pero sales ganando si utilizas el estimador máximo verosímil que ofrece la instrucción <@ref="garch">. Si quieres estimar un modelo ARCH sencillo, puedes usar el GARCH haciendo que su primer parámetro sea 0. 

Estima la especificación indicada del modelo permitiendo ARCH (Heterocedasticidad Condicional Autorregresiva). Primero, se estima el modelo mediante MCO, y luego se ejecuta una regresión auxiliar, en la que se regresa el error cuadrado de la primera sobre sus propios valores retardados. El paso final es la estimación por mínimos cuadrados ponderados, utilizando como ponderaciones las inversas de las varianzas de los errores ajustados con la regresión auxiliar. (Si la varianza que se predice para alguna observación de la regresión auxiliar, no es positiva, entonces se utiliza en su lugar el error cuadrado correspondiente). 

Los valores <@lit="alpha"> presentados debajo de los coeficientes son los parámetros estimados del proceso ARCH con la regresión auxiliar. 

Consulta también <@ref="garch"> y <@ref="modtest"> (opción <@opt="--⁠arch">). 

Instrucción de guión: <@ref="arch">

# arima Estimation "Modelo ARIMA"

Advertencia: <@lit="arma"> es un alias aceptable para esta instrucción. 

Estima un modelo ARMA, con o sin regresores exógenos. Si el orden de diferenciación es mayor que cero, el modelo se convierte en un ARIMA. Cuando los datos tienen una frecuencia mayor que 1, se te presenta la posibilidad de que incluyas una componente estacional. 

Si quieres incluir en el modelo únicamente retardos AR o MA específicos (en contraposición a incluir todos los retardos hasta un orden indicado), marca el cuadradito a la derecha del botón con flechas arriba/abajo y teclea una lista de retardos en el campo de anotación, separados por espacios. De forma alternativa, si tienes definida una matriz que contiene el conjunto de retardos que deseas, puedes teclear su nombre en el campo de anotación. 

Por defecto, se utiliza la funcionalidad ARMA “propia” de Gretl, con la estimación Máximo Verosímil (MV) exacta; pero dispones de la opción de hacer la estimación mediante MV condicional. (Si el programa ARIMA X-12 está instalado en el ordenador, tienes la posibilidad de utilizarlo en vez del código propio.) Para otros detalles relacionados con estas opciones, consulta <@pdf="El manual de gretl#chap:timeseries"> (Capítulo 28). 

El valor del AIC de Akaike indicado en conexión con modelos ARIMA, se calcula de acuerdo con la definición que utiliza el ARIMA X-12, concretamente 

  <@fig="aic">

donde <@fig="ell"> es el logaritmo de la verosimilitud y <@mth="k"> es el número total de parámetros estimados. Observa que el ARIMA X-12 no produce criterios de información tales como AIC cuando la estimación es por Máxima Verosimilitud condicional. 

Las raíces AR y MA mostradas en conexión con la estimación ARMA se basan en la siguiente representación de un proceso ARMA(p, q): 

<mono>          
      	(1 - a_1*L - a_2*L^2 - ... - a_p*L^p)Y =
        c + (1 + b_1*L + b_2*L^2 + ... + b_q*L^q) e_t
</mono>

Por lo tanto, las raíces AR son las soluciones a 

<mono>          
       1 - a_1*z - a_2*z^2 - ... - a_p*L^p = 0
</mono>

y la estabilidad requiere que estas raíces se encuentren fuera del círculo de radio unitario. 

La cantidad “Frecuencia” presentada en conexión con las raíces AR y MA, es el valor λ que soluciona <@mth="z"> = <@mth="r"> * exp(i*2*π*λ) donde <@mth="z"> es la raíz en cuestión y <@mth="r"> es su módulo. 

Menú gráfico: /Modelo/Series temporales/ARIMA

Instrucción de guión: <@ref="arima">

# arma Estimation "Modelo ARMA"

Consulta <@ref="arima">; <@lit="arma"> es un alias. 

Instrucción de guión: <@ref="arma">

# bfgs-config Estimation "Opciones de BFGS"

Este diálogo te permite controlar algunos aspectos del funcionamiento del maximizador BFGS. En caso de que el maximizador falle en la convergencia, puede mejorar la cosa (en algunos casos) al aumentar el número de iteraciones permitidas y/o al aumentar (hacer más permisiva) la tolerancia de la convergencia. Sin embargo, debes sospechar de los resultados que obtengas utilizando una tolerancia elevada y considerar la posibilidad de que el modelo que estimas esté mal especificado. 

Para la mayoría de las aplicaciones, te recomendamos que utilices el maximizador BFGS habitual pero, para algunos problemas, la variante del algoritmo con “memoria limitada” L-BFGS-B, puede producir una convergencia más rápida. Cuando seleccionas L-BFGS-B, tienes la posibilidad de establecer el número de correcciones utilizadas en la matriz de memoria limitada (entre 3 y 20, con 8 por defecto). 

# bootstrap Tests "Opciones de Bootstrap"

En esta caja de diálogo vas a elegir: 

<indent>
• La variable o el coeficiente a examinar. (Utilizando este método, solo puedes probar un coeficiente de cada vez .) 
</indent>

<indent>
• El tipo de análisis a realizar. El intervalo de confianza por defecto (del 95 por ciento) se basa directamente en los cuantiles de las estimaciones de los coeficientes mediante bootstrap. La versión del intervalo “studentizado” es conforme a Davidson y MacKinnon, <@bib="Economic Theory and Methods;davidson-mackinnon04"> (ETM, capítulo 5): en cada repetición del bootstrap se forma un ratio <@mth="t"> que se calcula cogiendo la diferencia entre la estimación de los coeficientes obtenida mediante bootstrap y la de partida, y dividiéndola entre la desviación típica de bootstrap. El intervalo de confianza se basa entonces en los cuantiles de este ratio <@mth="t"> de bootstrap, como se explica en el citado ETM. La opción valor p se basa en la distribución del ratio <@mth="t"> de bootstrap: es la proporción de las repeticiones en las que el valor absoluto de este estadístico excede el valor absoluto del ratio <@mth="t"> de partida. 
</indent>

<indent>
• El tipo de método Bootstrap. Bajo la primera opción, se vuelve a renovar la muestra de los errores de la estimación original, con substitución (luego de volverlos a escalar como se sugiere en ETM). Bajo la segunda, se vuelve a renovar la muestra con substitución de los “pares” o “casos”; es decir, las filas de datos (<@mth="y">, <@mth="X">). En la tercera opción, los errores originales se transforman primero conforme a <@bib="Davidson y Flachaire (2001);davidson-flachaire01">; entonces, en cada repetición del bootstrap, cada error transformado se multiplica por 1 o –1, con probabilidad igual a 0.5 en cada caso. En la opción final, se generan valores normales pseudoaleatorios utilizando la varianza de los errores originales. 
</indent>

<indent>
• El número de repeticiones a realizar. Ten en cuenta que cuando estás construyendo un intervalo con el 95 por ciento de confianza, es deseable que 0.05(<@mth="B"> + 1)/2 sea un entero (donde <@mth="B"> es el número de repeticiones). Así, Gretl puede ajustar el número de repeticiones que escojas para garantizar que este es el caso. 
</indent>

<indent>
• Produce o no un gráfico de la distribución bootstrap. Esta opción utiliza el servicio de estimación de la densidad del kernel de Gretl. 
</indent>

# boxplot Graphs "Gráficos de caja"

Estos gráficos muestran la distribución de una variable. Una caja central encierra el 50 por ciento central de los datos; i.e. está deslindada por el primer y el tercer cuartiles. Un “bigote” se extiende desde cada límite de la caja con un rango igual a 1.5 veces el rango intercuartil. Las observaciones que están fuera de ese rango se consideran valores atípicos y se representan mediante puntos. Se dibuja una línea a lo ancho de la caja en la mediana. El signo “+” se utiliza para indicar la media. Si escoges la opción de mostrar un intervalo de confianza para la mediana, este se calcula mediante el método bootstrap y se muestra con formato de líneas con rayas horizontales por arriba y/o abajo de la mediana. 

La opción “factorized” te permite examinar la distribución de la variable elegida condicionada al valor de algún factor discreto. Por ejemplo, si un conjunto de datos contiene una variable con los salarios y una variable ficticia con el género, puedes escoger la de los salarios como objetivo y la del género como el factor, para ver así los gráficos de cajas de salarios de hombres y mujeres, uno al lado del otro. 

Menú gráfico: /Ver/Gráficos/Gráficos de caja

Instrucción de guión: <@ref="boxplot">

# bwfilter Transformations "El filtro de Butterworth"

El filtro de Butterworth es una aproximación a un filtro ideal de ondas cuadradas, que permite pasar con total potencia a las frecuencias que superan un cierto rango, mientras detiene todas las otras. 

En principio, los valores más elevados del parámetro de orden (<@mth="n">) producen una aproximación más precisa al filtro ideal, pero con el posible coste de tener inestabilidad numérica. El valor “de corte” establece el límite entre la banda de paso y la banda de parada; se expresa en grados, y debe ser mayor que 0 y menor que 180° (o π radianes, correspondiéndose este con la mayor frecuencia de los datos). Los valores más pequeños del valor de corte producen una tendencia más suave. 

Cuando quieras aplicar este filtro, resulta un preámbulo muy útil que revises antes el periodograma de la serie que te interesa. Consulta <@pdf="El manual de gretl#chap:genr"> (Capítulo 9) para obtener más detalles. 

Menú gráfico: /Variable/Filtrar/Butterworth

# chow Tests "Contraste de Chow"

Esta instrucción necesita un número de observación (o una fecha, si usas datos que las tengan), o bien el nombre de una variable ficticia. 

Debe ir a continuación de una regresión MCO (OLS). Si indicas un número de observación o una fecha, proporciona un contraste respecto a la hipótesis nula de que no existe cambio estructural en el punto de corte indicado. El procedimiento consiste en crear una variable ficticia que toma el valor 1 desde el punto de corte especificado por <@var="obs"> hasta el final de la muestra, y 0 en otro caso, así como generar términos de interacción entre esa ficticia y los regresores originales. Si indicas una ficticia, se contrasta esa hipótesis nula de homogeneidad estructural respecto a esa variable ficticia, y también se añaden términos de interacción. En cada caso se ejecuta una regresión ampliada incluyendo los términos adicionales. 

Por defecto, se calcula un estadístico <@mth="F">, considerando la regresión ampliada como el modelo sin restricciones y el modelo original como el restringido. Pero si el modelo original utilizó un estimador robusto para la matriz de covarianzas, el estadístico de contraste es uno de Wald con distribución chi-cuadrado; con su valor basado en un estimador robusto de la matriz de covarianzas de la regresión ampliada. 

Menú gráfico: Ventana de modelo: Contrastes/Contraste de Chow

Instrucción de guión: <@ref="chow">

# cluster Estimation "Estimación con varianza robusta"

Si escoges la segunda opción, debes ofrecer el nombre de una variable de agrupación. Esta variable debería tener al menos dos valores diferentes, pero generalmente deberá tener un número de valores diferentes considerablemente menor que el número de observaciones que haya en el rango de la muestra. 

El estimador con varianza “robusta por agrupación” divide la muestra en un número de subconjuntos o grupos de acuerdo con el valor que tome la variable seleccionada. En lugar del supuesto clásico de que el término de perturbación está independiente e idénticamente distribuido, este estimador permite que las varianzas de las perturbaciones difieran por grupos, y también permite un grado de dependencia de la perturbación dentro de cada grupo. 

# coeffsum Tests "Suma de coeficientes"

Esta instrucción necesita una lista de variables, seleccionadas de un conjunto de variables independientes de un modelo dado. 

Calcula la suma de los coeficientes de las variables de la lista especificada. Presenta esta suma junto con su desviación típica y la probabilidad asociada al estadístico para contrastar la hipótesis nula de que la suma es cero. 

Ten en cuenta la diferencia entre esto y la instrucción <@ref="omit">, pues esta última te permite contrastar la hipótesis nula de que los coeficientes de un subconjunto especificado de variables independientes son <@itl="todos"> nulos. 

Menú gráfico: Ventana de modelo: Contrastes/Suma de los coeficientes

Instrucción de guión: <@ref="coeffsum">

# coint Tests "Contraste de cointegración de Engle-Granger"

Contraste de cointegración de Engle–Granger. El proceso por defecto consiste en: (1) realizar los contrastes de Dickey–Fuller respecto a la hipótesis nula de que cada una de las variables enumeradas tiene una raíz unitaria; (2) estimar la regresión de cointegración; y (3) hacer un contraste DF respecto a los errores que comete la regresión de cointegración. Sin embargo, si marcas el cuadradito de “Omitir los contrastes DF iniciales”, el primero de estos pasos se omite. 

Si el orden de retardos (<@mth="k">) es mayor que 0, entonces se incluyen <@mth="k"> retardos de la variable dependiente en el lado derecho de la regresión que se hace para cada contraste, excepto que marques el cuadradito titulado “Contrastar desde el máximo orden de retardos hacia abajo”. En ese caso, el orden de retardos que indicas se toma como máximo, y el orden concreto de retardos que se utilizará, se obtiene probando hacia abajo. Consulta la instrucción <@ref="adf"> para tener más detalles sobre este procedimiento. 

Por defecto, la regresión de cointegración contiene una constante. Si quieres eliminar la constante o añadir una tendencia lineal (o cuadrática) y/o variables ficticias estacionales, escoge la opción adecuada del conjunto que te ofrece el botón de selección en la caja de diálogo Cointegración. 

Los valores <@itl="P"> (probabilidades asociadas) de este contraste se basan en <@bib="MacKinnon (1996);mackinnon96">. El código relevante se incluye con el amable permiso del propio autor. 

Menú gráfico: /Modelo/Series temporales/Multivariante

Instrucción de guión: <@ref="coint">

# coint2 Tests "Contraste de cointegración de Johansen"

Lleva a cabo el contraste de cointegración de Johansen entre las variables indicadas para el orden de retardos seleccionado. Para obtener más detalles sobre este contraste consulta, por ejemplo, el capítulo 20 del libro <@itl="Time Series Analysis"> (1994) de Hamilton. Las probabilidades asociadas (valores p) se calculan mediante la aproximación Gamma de Doornik (1998). Se muestran dos conjuntos de valores p para el contraste de la traza: valores asintóticos directos y valores ajustados por el tamaño de la muestra. 

La inclusión de términos determinísticos en el modelo se controla por medio de una lista desplegable de opciones. Por defecto, se incluye una “constante no restringida”, que permite la presencia de una ordenada en el origen no nula en las relaciones de cointegración, así como una tendencia en los niveles de las variables endógenas. En la literatura generada a partir del trabajo de Johansen (por ejemplo, consulta su libro de 1995) se refiere esta situación como el “caso 3”. Las 4 primeras opciones indicadas arriba producen respectivamente los casos 1, 2, 4 y 5. Tanto el significado de estos casos como el criterio para seleccionar un caso se explican en <@pdf="El manual de gretl#chap:vecm"> (Capítulo 30). 

Puedes controlar las variables exógenas añadiéndolas a la caja de la lista inferior. Por defecto, estas entran a formar parte del modelo de forma no restringida (indicada por una <@lit="U"> al lado del nombre de la variable). Si quieres que una determinada variable exógena esté restringida al espacio de cointegración, pulsa con el botón derecho del ratón sobre ella y escoge “Restringido” en el menú emergente; y el símbolo al lado de la variable se va a cambiar a R. 

Si los datos son trimestrales o mensuales, se te muestra un cuadradito de verificación que te permite incluir un conjunto de variables ficticias estacionales centradas. En todos los casos, un cuadradito de verificación adicional (“Mostrar los detalles”) permite la presentación de las regresiones auxiliares que forman el punto de comienzo del procedimiento de estimación máximo verosímil de Johansen. 

La siguiente tabla se ofrece como guía para la interpretación de los resultados del contraste que se muestran, para el caso con 3 variables. <@lit="H0"> denota la hipótesis nula, <@lit="H1"> la hipótesis alternativa, y <@lit="c"> el número de relaciones de cointegración. 

<mono>          
         Rango   Contraste traza      Contraste Lmáx
                  H0     H1          H0     H1
         ---------------------------------------
          0      c = 0  c = 3       c = 0  c = 1
          1      c = 1  c = 3       c = 1  c = 2
          2      c = 2  c = 3       c = 2  c = 3
         ---------------------------------------
</mono>

Consulta también la instrucción <@ref="vecm">. 

Menú gráfico: /Modelo/Series temporales/Multivariante

Instrucción de guión: <@ref="coint2">

# compact Dataset "Compactar datos"

Cuando añades una serie a un conjunto de datos que es de menor frecuencia, es necesario “compactar” la nueva serie. Por ejemplo, tendrás que compactar una serie mensual para adaptarla a un conjunto de datos trimestrales. 

Además, a veces puedes querer compactar un conjunto entero de datos para que tengan una frecuencia menor (quizás antes de añadir una variable de baja frecuencia al conjunto de datos). 

Gretl ofrece 5 opciones para compactar: 

<indent>
• Con la media: El valor que se escribe en el conjunto de datos va a ser la media aritmética de los valores de las series relevantes. Por ejemplo, el valor que se escribe para el primer trimestre de 1990 va a ser la media aritmética de los valores para los meses de enero, febrero y marzo de 1990. 
</indent>

<indent>
• Sumando: El valor que se escribe en el conjunto de datos va a ser la suma de los valores pertinentes de mayor frecuencia. Por ejemplo, el valor del primer trimestre va a ser la suma de los valores de enero, febrero y marzo. 
</indent>

<indent>
• Valores final-de-período: El valor que se escribe en el conjunto de datos es el último valor pertinente de los datos de frecuencia mayor. Por ejemplo, el primer trimestre de 1990 va a tener el valor de marzo de 1990. 
</indent>

<indent>
• Valores principio-de-período: El valor que se escribe en el conjunto de datos es el primer valor pertinente de los datos de frecuencia mayor. Por ejemplo, el primer trimestre de 1990 va a tener el valor de enero de 1990. 
</indent>

<indent>
• “Expandiendo”: En este caso, no se pierde ninguna información de la frecuencia mayor; más bien, se expande en un conjunto de <@mth="m"> series, donde <@mth="m"> es el ratio entre la frecuencia mayor y la menor. Cada serie de ese conjunto contiene los valores de un determinado subperíodo, que se identifica con un sufijo específico. Por ejemplo, cuando se compacta una serie <@lit="x"> de mensual a trimestral, los nombres de las series generadas van ser <@lit="x_m01">, <@lit="x_m02"> y <@lit="x_m03"> para los tres meses de cada trimestre. 
</indent>

En caso de querer compactar un conjunto de datos entero, la elección que haces en esta caja de diálogo determina el método por defecto. Pero si has establecido un método para compactar una variable individual (en el menú “Variable/Editar atributos”), se va a usar ese método en lugar del establecido por defecto. Si ya has establecido el método para compactar en todas y cada una de las variables, no se te presenta la posibilidad de elegir un método por defecto para compactar. 

# controlled Graphs "Gráficos de dispersión con control"

Esta instrucción requiere la selección de 3 variables: una para el eje X, otra para el eje Y, y otra para lo que quieres controlar (llamémosle Z). El gráfico muestra el Y axustado frente al X axustado, donde la versión axustada de la variable es el error de una regresión MCO sobre Z. 

Ejemplo: Tienes datos de salarios, experiencia laboral y nivel de educación para una muestra de personas. Quieres dibujar los salarios frente al nivel de educación, controlados por la experiencia. En ese caso, seleccionarías salarios para el eje Y, nivel de educación para el eje X y experiencia como control. El gráfico muestra los salarios frente al nivel de educación, con las dos variables “depuradas” del efecto de la experiencia. 

# corr Statistics "Coeficientes de correlación"

Presenta los coeficientes de correlación (correlación producto-momento de Pearson) por pares de las variables escogidas. El comportamiento por defecto de esta instrucción consiste en utilizar todas las observaciones disponibles para calcular cada coeficiente por parejas de variables, pero si marcas el cuadradito de opciones, la muestra se limita (si es necesario) de modo que se utiliza el mismo conjunto de observaciones para todos los coeficientes. Esta opción es adecuada solo cuando hay un número diferente de valores ausentes en las variables utilizadas. 

Menú gráfico: /Ver/Matriz de correlación
Otro acceso: Ventana principal: Menú emergente (tras selección múltiple)

Instrucción de guión: <@ref="corr">

# corrgm Statistics "Correlograma"

Presenta los valores de la función de autocorrelación (FAC) del argumento <@var="serie">, que puede especificarse por su nombre o su número. Los valores se definen como ρ(<@mth="u"><@sub="t">, <@mth="u"><@sub="t-s">) donde <@mth="u"><@sub="t"> es la <@mth="t">-ésima observación de la variable <@mth="u"> y <@mth="s"> denota el número de retardos. 

También se presentan las autocorrelaciones parciales (FACP, que se calculan utilizando el algoritmo de Durbin–Levinson), y que están libres de los efectos de los retardos intermedios. Además, se presenta el estadístico <@mth="Q"> de Ljung–Box que puedes utilizar para contrastar la hipótesis nula de que la serie es un “ruido blanco”, y que se distribuye asintóticamente como una chi-cuadrado con tantos grados de libertad como el número de retardos utilizados. 

Se utilizan asteriscos para indicar la significación estadística de las autocorrelaciones individuales. Por defecto, esto se evalúa utilizando una desviación típica igual al cociente entre 1 y la raíz cuadrada del tamaño de la muestra, pero tienes la opción de utilizar las desviaciones típicas de Bartlett para la FAC. Esta opción también determina la banda de confianza que se dibuja en el gráfico de la FAC. 

Menú gráfico: /Variable/Correlograma
Otro acceso: Ventana principal: Menú emergente (selección única)

Instrucción de guión: <@ref="corrgm">

# count-model Estimation "Modelos para datos de conteo"

Se toma la variable dependiente para representar un conteo del número de veces que ocurre un suceso de algún tipo, y debe tener solo valores enteros no negativos. Por defecto, se utiliza la distribución de Poisson, pero el botón de la lista desplegable te da la opción de utilizar la distribución Binomial Negativa. (La variante NegBin 2 se utiliza habitualmente en Econometría, pero también está disponible la menos utilizada NegBin 1.) 

Opcionalmente, puedes añadir una variable de “exposición” a la especificación. Esta es una variable de escala, cuyo logaritmo se añade a la función de regresión lineal (implícitamente, con un coeficiente de 1). Esto es lógico si esperas que el número de veces que ocurra el suceso en cuestión sea proporcional a algún factor conocido (suponiendo lo demás constante). Por ejemplo, si asumes que el número de accidentes de tráfico es proporcional al volumen de tráfico (con lo demás constante), en ese caso puedes especificar el volumen de tráfico como una variable de “exposición” en un modelo para el ratio de accidentes. La variable de exposición debe ser estrictamente positiva. 

Por defecto, las desviaciones típicas se calculan utilizando una aproximación numérica a la matriz Hessiana en la convergencia. Pero si marcas el cuadradito de 'Desviaciones típicas robustas', entonces se calculan las desviaciones típicas Cuasi Máximo Verosímiles (CMV o QML), utilizando un “emparedado” entre la inversa de la matriz Hessiana y el producto externo del vector gradiente. 

# curve Graphs "Dibujar una curva"

Esta caja de diálogo te permite generar un gráfico de Gnuplot especificando una fórmula, que deberá ser una expresión que admita Gnuplot. Utiliza <@lit="x"> para denotar la variable en el eje 'x'. Ten en cuenta que Gnuplot utiliza <@lit="**"> para preceder a un exponente (elevar a la potencia) y que el carácter decimal debe indicarse con “.”. Ejemplos: 

<code>          
   10+0.35*x
   100+5.3*x-0.12*x**2
   sin(x)
   exp(sqrt(pi*x))
</code>

Para poner una línea adicional en un gráfico generado de este modo, pulsa con el botón derecho del ratón en el gráfico y escoge “Editar”, selecciona la pestaña “Líneas” en el cuadro de diálogo de edición de gráficos, y utiliza el botón “Añadir línea”. 

# cusum Tests "Contraste CUSUM"

Debe ir después de la estimación de un modelo mediante MCO. Te permite realizar el contraste CUSUM de estabilidad de los parámetros (o el contraste CUSUMSQ si indicas la opción <@opt="--⁠squares">). Vas a obtener una serie con los errores de predicción adelantados un paso, ejecutando una serie de regresiones. En la primera regresión se utilizan las primeras <@mth="k"> observaciones y te permite generar la predicción de la variable dependiente en la observación <@mth="k"> + 1; en la segunda se utilizan las primeras <@mth="k"> + 1 observaciones y se genera una predicción para la observación <@mth="k"> + 2, y así sucesivamente (donde <@mth="k"> es el número de parámetros del modelo original). 

Se presenta y se dibuja la suma acumulada de los errores de predicción escalados (o los cuadrados de estos errores). La hipótesis nula de estabilidad de los parámetros se rechaza con un nivel de significación del 5 por ciento cuando la suma acumulada se separa de la banda de confianza del 95 por ciento. 

En el caso del contraste CUSUM, también se presenta el estadístico <@mth="t"> de Harvey–Collier para contrastar la hipótesis nula de estabilidad de los parámetros. Consulta el libro <@itl="Econometric Analysis"> de Greene para obtener más detalles. Para el contraste CUSUMSQ, se calcula la banda de confianza del 95 por ciento utilizando el algoritmo indicado en <@bib="Edgerton y Wells (1994);edgerton94">. 

Menú gráfico: Ventana de modelo: Contrastes/Contraste CUSUM(SQ)

Instrucción de guión: <@ref="cusum">

# daily-purge Dataset "Depurar datos diarios"

Cuando un conjunto de datos diarios está nominalmente en un calendario de 7 días, pero de hecho únicamente incluye datos de días laborables, se recomienda que elimines las filas en blanco de los días del fin de semana, pasando así a un calendario de 5 días. 

Cuando un conjunto de datos de días laborables contiene un número relativamente pequeño de filas sin datos (presuntamente debido a festivos comerciales) podrías querer eliminar esas filas. Esto significa, de hecho, tratar los valores ausentes por festividades como no existentes, más que como verdaderamente “ausentes”, y tratar los días comerciales como si formasen una serie temporal continua. 

Ten en cuenta que si coges cualquiera de estas opciones, aun así Gretl va a preservar la información de la fecha, y te va a ser posible reconstruir el conjunto de datos de calendario completo más tarde, si lo necesitas. Puedes hacer esto utilizando la instrucción <@ref="dataset"> con la opción <@lit="pad-daily">. 

# data-files Programming "Archivos de datos"

Este diálogo te permite especificar archivos adicionales para incluir con un paquete de funciones. Si incluyes ese material, eso implica que el paquete va a tomar la forma de un archivo zip. Cuando Gretl vaya a crear el archivo zip para ti, todos los archivos a los que se hace referencia aquí deben estar presentes en el mismo directorio que el archivo gfn. Los subdirectorios pueden indicarse igual que archivos normales y, en ese caso, eso implica que todo su contenido deberá incluirse en el paquete zip. 

Hay dos intenciones principales para usar este servicio. En primer lugar, puedes incluir un archivo de datos para utilizar con el guion de muestra del paquete, si no es adecuado ninguno de los archivos de datos ofrecidos con la distribución de Gretl. En este caso, los datos deben estar en el formato propio de Gretl (<@lit="gdt"> o <@lit="gdtb"> binario). Segundo, si tu paquete precisa una matriz grande (por ejemplo, que contenga todos los puntos críticos de un estadístico de prueba especial), podrá ser más conveniente incluirla como un archivo matricial de Gretl (<@lit="mat">) que integrar la matriz mediante múltiples expresiones del lenguaje Hansl de Gretl. 

Para acceder a un archivo empaquetado <@lit="gdt"> o <@lit="gdtb"> desde un guion de muestra, utiliza la opción <@opt="--⁠frompkg"> con la instrucción <@lit="open">, indicando el nombre del paquete como si fuese un parámetro, como en 

<code>          
   open almon.gdt --frompkg=almonreg
</code>

Para leer un archivo matricial empaquetado desde dentro de tu código de paquete, utiliza la variable de cadena incorporada <@lit="$pkgdir">, como en 

<code>          
   string mname = sprintf("%s/A.mat", $pkgdir)
   matrix A = mread(mname)
</code>

(Ten en cuenta que en las rutas de MS Windows funcionará correctamente “<@lit="/">” como separador.) 

# datasort Dataset "Ordenar los datos"

La variable escogida se utiliza como clave de ordenación para todo el conjunto de datos. Se vuelven a ordenar las observaciones de todas las variables según los valores en orden ascendente de la variable clave, o según los valores en orden decreciente si escoges la opción “Descendente”. 

# dbnomics Utilities "Acceso a dbnomics"

Este diálogo te permite inspeccionar y descargar series de datos del servidor 'dbnomics'. Puedes visitar <@url="https://db.nomics.world/"> para obtener los identificadores o códigos de las series de interés. Estos tienen la forma de 'tripletes' (tres términos separados con barras). Por ejemplo 

<code>          
   ECB/IRS/M.IT.L.L40.CI.0000.EUR.N.Z
</code>

El primer término identifica un provedor de datos, aquí <@lit="ECB"> (el Banco Central Europeo). El segundo identifica una base de datos, aquí <@lit="IRS"> (de estadísticas de tipos de interés). Y el tercero especifica una serie concreta de la base de datos, en este caso un tipo de interés italiano de 10 años. 

Si introduces un identificador de serie y pulsas “OK”, esto va a hacer que aparezca una ventana que mostrará información sobre la serie. Entonces, puedes utilizar los botones de la barra de herramientas de esa ventana para presentar los valores de la serie, dibujar la serie, o agregarla a la base de datos vigente (asumiendo que la serie es apropiada para la base de datos). 

# density Statistics "Estimación de la densidad Kernel"

La estimación de la densidad Kernel se realiza definiendo un conjunto de puntos de referencia separados de modo uniforme sobre un rango apropiado relacionado con el rango de los datos, y atribuyendo una densidad a cada punto de referencia basada en las observaciones presentes en su entorno. 

La fórmula utilizada para calcular la densidad estimada en cada punto de referencia (<@mth="x">) es 

  <@fig="kernel1">

donde <@mth="n"> denota el número de puntos con datos, <@mth="h"> es un parámetro de “ancho de banda”, y <@mth="k">() es la función Kernel. Cuanto mayor sea el valor del parámetro de ancho de banda, más suave va a ser la densidad estimada. 

Se te ofrece la posibilidad de utilizar un Kernel Gaussiano (la densidad Normal estándar) o el Kernel de Epanechnikov. Por defecto, el ancho de banda es el sugerido como norma general por <@bib="Silverman (1986);silverman96">, concretamente 

  <@fig="kernel2">

donde <@mth="s"> representa la desviación típica de los datos e IQR denota el rango intercuartil. Puedes ampliar o reducir el ancho de banda mediante el “Factor de ajuste del ancho de banda”, puesto que entonces el ancho real de banda que se va a utilizar, se obtiene multiplicando el valor de Silverman por el factor de ajuste. 

Para ver una buena discusión introductoria de la estimación de la densidad del Kernel, consulta el capítulo 15 del libro de Davidson y MacKinnon <@itl="Econometric Theory and Methods">. 

# dfgls Tests "El contraste ADF-GLS"

El contraste ADF-GLS es una variante del contraste de raíz unitaria de Dickey–Fuller, para el caso en el que se asume que la variable que se contrasta tiene una media no nula o presenta una tendencia lineal. La diferencia está en que la detracción de la media o de la tendencia de la variable se hace utilizando el procedimiento MCG (GLS) sugerido por <@bib="Elliott, Rothenberg y Stock (1996);ERS96">. Esto proporciona un contraste con mayor potencia que el enfoque estándar de Dickey–Fuller. 

Cuando se prueba hacia abajo, a partir de un orden máximo de retardos que indiques, los criterios AIC y BIC “modificados” son como se describe en <@bib="Ng y Perron (2001);ng-perron01">, con o sin la corrección propuesta por <@bib="Perron y Qu (2007);perron-qu07">. Esta corrección implica utilizar datos con la tendencia detraída con MCO en la etapa de determinación del orden de retardos óptimo, y luego detraer la tendencia con MCG en el contraste final de raíz unitaria. 

Consulta también la instrucción <@ref="adf"> y la opción <@opt="--⁠gls">. 

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste ADF-GLS

# dialog Estimation "Caja de diálogo del modelo"

Para escoger una variable como la dependiente, resalta esa variable en la lista de la izquierda y pulsa el botón “Elegir” que apunta al cuadrado de la variable Dependiente. Si marcas el cuadradito de “Selección por defecto”, la variable que escogiste se va a preseleccionar como la dependiente cuando se vuelva a abrir la caja de diálogo del modelo. Atajo: pulsa un doble clic en una variable de la izquierda para escogerla como la variable dependiente, y también fijarla por defecto. 

Para escoger las variables independientes, resáltalas en el lado izquierdo y pulsa el botón “Añadir” (o pulsa un clic con el botón derecho del ratón). Puedes resaltar varias variables contiguas arrastrando con el ratón, y puedes resaltar un grupo de variables no contiguas pulsando un clic en cada una de ellas mientras mantienes pulsada la tecla <@lit="Ctrl">. 

# dpanel Estimation "Modelos de panel dinámicos"

Realiza la estimación de modelos dinámicos con datos de panel (es decir, modelos de panel que incluyen uno o más retardos de la variable dependiente) utilizando bien el método GMM-DIF o bien GMM-SYS. 

Debes indicar la variable dependiente y los regresores con sus valores en niveles, pues ya se van a diferenciar automáticamente (dado que este estimador utiliza la diferenciación para eliminar los efectos individuales). 

En lo referente al manejo de los instrumentos, consulta la documentación para a versión de guion de esta instrucción. Actualmente no puedes especificar instrumentos explícitamente en la Interface Gráfica de Usuario (GUI), así todas las variables independientes se consideran estrictamente exógenas. 

Por defecto, se presentan los resultados de la estimación en 1 etapa (con las desviaciones típicas robustas) pero tienes la opción de escoger la estimación en 2 etapas. En ambos casos, se presentan los contrastes de autocorrelación de orden 1 y 2 , así como el contraste de sobreidentificación de Sargan y el estadístico del contraste de Wald para la significación conjunta de los regresores. Ten en cuenta que en este modelo en diferencias, la autocorrelación de primer orden no es una amenaza para la validez del modelo, pero la autocorrelación de segundo orden infringe los supuestos estadísticos vigentes. 

Para obtener otros detalles y ejemplos, consulta <@pdf="El manual de gretl#chap:dpanel"> (Capítulo 21). 

Menú gráfico: /Modelo/Panel/Modelo de panel dinámico

Instrucción de guión: <@ref="dpanel">

# dummify Transformations "Generar conjuntos de variables ficticias"

La operación “dummify” está disponible únicamente para series con valores discretos. Su efecto consiste en generar un conjunto de variables ficticias que codifican los distintos valores presentes en las series. 

Por ejemplo, supón que tienes una serie titulada <@lit="raza">, con valores de 1 para “blanco”, 2 para “negro”, 3 para “hispano” y 4 para “otros”. Crear variables ficticias a partir de esta serie significa generar 4 variables ficticias: la primera tiene el valor 1 para todas las observaciones en las que raza = 1 y cero en otro caso; la segunda tiene el valor 1 para todas las observaciones en las que raza = 2, cero en otro caso; etcétera. 

En la práctica, es posible que para una serie discreta con <@mth="k"> categorías quieras generar únicamente <@mth="k"> – 1 variables ficticias, para evitar caer en la denominada “trampa de las variables ficticias”. De ahí que tengas la posibilidad de prescindir de la codificación, bien del valor más bajo o bien del valor más alto de los considerados. 

# ema-filter Transformations "Media móvil exponencial"

La fórmula que emplea Gretl para calcular la media móvil exponencial (MME o EMA) es la de <@bib="Roberts (1959);roberts59">, concretamente 

<@mth="s"><@sub="t"> = α<@mth="y"><@sub="t"> + (1–α)<@mth="s"><@sub="t–1"> 

donde <@mth="s"> es la MME, <@mth="y"> es la serie original, y α es una constante entre 0 y 1. Los valores más grandes de α cargan más ponderación en la observación vigente; y los valores más pequeños producen un mayor suavizado. 

Como “primer valor de la MME”, si no se especifica, se toma el último valor previo a la muestra, lo que significa que el cálculo del filtro comienza con la primera observación que hay en el rango de la muestra vigente. 

Para una línea de instrucción equivalente, consulta la función <@xrf="movavg">. 

# expand Dataset "Expandir datos"

Si quieres añadir a un conjunto de datos, una serie que es de frecuencia menor, es necesario “expandir” la nueva serie. Por ejemplo, tendrás que expandir una serie trimestral para ajustarla a un conjunto de datos mensual. Además, a veces puedes querer expandir un conjunto de datos entero a otro de frecuencia mayor (quizás antes de añadir una variable de frecuencia mayor al conjunto de datos). 

Debes considerar la expansión de los datos como una opción para “expertos” pues necesitas saber qué estás haciendo. Cuando combinas series de diferentes frecuencias originales dentro de un conjunto de datos, probablemente deberías de considerar como compactar los datos de frecuencia mayor, más que expandir las series de frecuencia menor. 

Dicho esto, Gretl te permite dos opciones para la expansión: (a) puedes interpolar valores de alta frecuencia utilizando el método de <@bib="Chow y Lin (1971);chowlin71">, o (b) puedes repetir valores de las series de frecuencia menor tantas veces como sea necesario. 

El método de Chow–Lin está basado en la regresión, y utiliza una constante más una tendencia cuadrática, asumiendo un proceso autorregresivo de primer orden para las perturbaciones. Se gastan cuatro grados de libertad con este procedimiento. 

Respecto al método de repetición de valores, supón que tienes una serie trimestral con el valor 35.5 en 1990:1 (el primer trimestre de 1990). En la expansión a mensual, se va a asignar el valor 35.5 a las observaciones de enero, febrero y marzo de 1990. En consecuencia, la variable expandida es inútil para un análisis pormenorizado de series temporales, excepto en el caso especial en el que ya sabes de hecho que la variable en cuestión se mantiene constante durante los subperíodos. 

# export Dataset "Exportar datos"

Puedes exportar datos en el formato Valores Separados por Comas (CSV) que pueden abrirse en hojas de cálculo y muchos otros programas. Si escoges esta opción, vas a tener algunas opciones adicionales con relación al formato específico del archivo CSV. 

También tienes la opción de exportar datos con el formato de un archivo de datos “propio” de Gretl, o de exportarlos a una base de datos de Gretl (si los datos son adecuados). Consulta <@url="gretl.sourceforge.net/gretl_data.html"> para ver una relación de las bases de datos de Gretl. 

Puedes también exportar datos en un formato de texto plano adecuado para usarlos con los siguientes programas: 

<indent>
• GNU R (<@url="www.r-project.org">): Se escriben los datos con el formato que utiliza espacios separados y que la función <@lit="read.table"> de R puede asimilar fácilmente. Sufijo, por defecto, del nombre de archivo: <@lit=".txt"> 
</indent>

<indent>
• GNU octave (<@url="www.gnu.org/software/octave">): Los datos se escriben como una matriz en el formato favorito de Octave. Sufijo, por defecto, del nombre de archivo: <@lit=".m"> 
</indent>

<indent>
• JMulTi (<@url="www.jmulti.de">): Sufijo, por defecto, del nombre de archivo: <@lit=".dat"> 
</indent>

<indent>
• PcGive (<@url="www.pcgive.com">): Sufijo, por defecto, del nombre de archivo: <@lit=".dat"> 
</indent>

Si quieres exportar los datos copiándolos al portapapeles mejor que escribiéndolos en un archivo del disco, selecciona en la ventana principal las series que quieres copiar, pulsa con el botón derecho del ratón en la selección y escoge “Copiar al portapapeles”. (Solo se admite el formato CSV en este contexto.) 

# factorized Graphs "Gráfico con factor de separación"

Esta instrucción requiere que selecciones 3 variables, y la última de ellas debe ser una variable ficticia (con valores 1 o 0). La variable Y se representa gráficamente frente a la variable X, con los puntos de datos colorados de forma diferente dependiendo del valor de la tercera variable. 

Ejemplo: Supón que tienes datos sobre salarios y cualificaciones educativas para una muestra de personas, y también una variable ficticia con el valor 1 para los hombres y 0 para las mujeres (como en <@lit="data7-2"> de Ramanathan). Un “gráfico con factor de separación” de <@lit="WAGE"> frente a <@lit="EDUC">, utilizando la variable ficticia <@lit="GENDER"> como factor, mostrará los puntos de datos para los hombres en un color y aquellos para las mujeres en otro (con una leyenda para identificarlos). 

# fcast Prediction "Generar predicciones"

Debe ir después de una instrucción de estimación. Las predicciones se generan para el rango especificado de observaciones. Dependiendo de la naturaleza del modelo, también pueden generarse las desviaciones típicas (mira abajo). 

La elección entre una predicción estática o dinámica se aplica únicamente en caso de modelos dinámicos, con una perturbación con un proceso autorregresivo y/o que incluyan uno o más valores retardados de la variable dependiente como regresores. Las predicciones estáticas son un paso adelantadas (basadas en los valores obtenidos en el período previo), mientras que las predicciones dinámicas emplean la regla de la cadena de predicción. Por ejemplo, si una predicción para <@mth="y"> en 2008 requiere como entrada un valor de <@mth="y"> en 2007, una predicción estática es imposible sin datos actualizados para 2007, pero una predicción dinámica para 2008 es posible si puedes substituir una predicción previa para <@mth="y"> en 2007. 

Por defecto se proporciona: (a) una predicción estática para alguna porción del rango de predicción que cae dentro del rango de la muestra sobre el que se estima el modelo, y (b) una predicción dinámica (si es relevante) fuera de la muestra. La opción <@opt="--⁠dynamic"> solicita una predicción dinámica a partir de la fecha lo más temprana posible, y la opción <@opt="--⁠static"> solicita una predicción estática incluso fuera de la muestra. 

La naturaleza de las desviaciones típicas de las predicciones (si están disponibles) depende de la naturaleza del modelo y de la predicción. En modelos lineales estáticos, las desviaciones típicas se calculan utilizando el método bosquejado por <@bib="Davidson y MacKinnon (2004);davidson-mackinnon04">; ellos incorporan tanto la incertidumbre debida al proceso de la perturbación como la incertidumbre en los parámetros (resumida en la matriz de covarianzas de los estimadores de los parámetros). En modelos dinámicos, las desviaciones típicas de las predicciones se calculan únicamente en caso de una predicción dinámica, y no incorporan la incertidumbre en los parámetros. Para modelos no lineales, las desviaciones típicas de las predicciones no están disponibles actualmente. 

Menú gráfico: Ventana de modelo: Análisis/Predicciones

Instrucción de guión: <@ref="fcast">

# fractint Statistics "Integración fraccional"

Comprueba la integración fraccional (“memoria larga”) de las series especificadas contrastando la hipótesis nula de que el orden de integración de la serie es cero. Por defecto, se utiliza el Estimador Local Whittle <@bib="(Robinson, 1995);robinson95">, pero cuando indicas la opción <@opt="--⁠gph">, se realiza el contraste GPH <@bib="(Geweke y Porter-Hudak, 1983);GPH83"> en su lugar. Cuando decidas indicar la opción <@opt="--⁠all">, entonces se van a presentar los resultados de ambos contrastes. 

Para obtener más detalles sobre este tipo de contraste, consulta <@bib="Phillips y Shimotsu (2004);phillips04">. 

Cuando no indicas el argumento <@var="orden"> (opcional), el orden para el(los) contraste(s) se establece automáticamente como el número menor entre <@mth="T">/2 y <@mth="T"><@sup="0.6">. 

Puedes recuperar los resultados utilizando los accesorios <@xrf="$test"> y <@xrf="$pvalue">. Estos valores se basan en el Estimador Local Whittle excepto cuando indicas la opción <@opt="--⁠gph">. 

Menú gráfico: /Variable/Contrastes de raíz unitaria/Integración fraccional

Instrucción de guión: <@ref="fractint">

# freq Statistics "Distribución de frecuencias"

En la caja de diálogo de gráfico de frecuencia puedes controlar las características del gráfico de cualquiera de estos dos modos. 

Primero, puedes escoger el número de intervalos. En este caso, se calculan automáticamente el ancho y la situación de los intervalos. 

Como alternativa, puedes especificar el límite inferior del intervalo situado más a la izquierda, y el ancho de los intervalos. En este caso, el número de intervalos se calcula automáticamente. 

Si quieres alinear los intervalos en números redondeados, aquí tienes un modo de proceder: comienza especificando el número de intervalos que quieres y echa una ojeada al gráfico que se produce. Si no es de tu agrado, apunta la modificación que se requiere (por ejemplo, hacer que el intervalo situado más a la izquierda comience en 100 e impón un ancho de intervalo de 200). Entonces haz una segunda prueba, especificando el límite izquierdo y el ancho del intervalo. 

Este diálogo también permite elegir una distribución teórica para representar frente a los datos: la Normal o la Gamma. Cuando escoges la opción Normal, se calcula el estadístico del contraste de Normalidad de Doornik–Hansen. Cuando seleccionas la opción Gamma, Gretl calcula el estadístico del contraste no paramétrico de Locke respecto a la hipótesis nula que sostiene que la variable sigue una distribución Gamma. Ten en cuenta que la forma en la que se indican en Gretl los parámetros de la distribución Gamma es (forma, escala). 

Menú gráfico: /Variable/Distribución de frecuencias

Instrucción de guión: <@ref="freq">

# garch Estimation "Modelo GARCH"

Estima un modelo GARCH (GARCH, Heterocedasticidad Condicional Autorregresiva Generalizada), bien en un modelo univariante o bien incluyendo las variables exógenas indicadas (cuando se escogen variables independientes). La ecuación de la varianza condicionada se muestra abajo. 

  <@fig="garch_h">

Así, el parámetro <@var="p"> representa el orden Generalizado (o “AR”), mientras que <@var="q"> representa el orden normal ARCH (o “MA”). Cuando <@var="p"> es no nulo, <@var="q"> también debe ser no nulo; en otro caso, el modelo no está identificado. Con todo, puedes estimar un modelo ARCH normal estableciendo que <@var="q"> es un valor positivo, y que <@var="p"> es cero. La suma de <@var="p"> y <@var="q"> no debe ser mayor que 5. 

Por defecto, se utiliza el propio código de Gretl para estimar los modelos GARCH, pero también tienes la opción de usar el algoritmo de <@bib="Fiorentini, Calzolari y Panattoni (1996);fiorentini96">. El primero utiliza el maximizador BFGS mientras que el último usa la matriz de información para maximizar la verosimilitud, con una puesta a punto mediante la matriz Hessiana. 

Con esta instrución dispones de diversas variantes de la matriz estimada de las covarianzas dos estimadores. Por defecto, se utiliza la matriz Hessiana excepto que marques el cuadradito “Desviaciones típicas robustas”, en cuyo caso se va a usar la matriz de covarianzas CMV (QML de White). También puedes especificar otras posibilidades (e.g. la matriz de información o el estimador de Bollerslev–Wooldridge) utilizando la instrucción <@ref="set">. 

Puedes acceder a la varianza condicionada estimada, así como a los errores y a otros estadísticos del modelo, y añadirlos al conjunto de datos utilizando el menú “Guardar” de la ventana donde se presenta el modelo. Si marcas el cuadradito titulado “Estandarizar los residuos”, se dividen los errores por la raíz cuadrada de la varianza condicionada. 

Menú gráfico: /Modelo/Series temporales/GARCH

Instrucción de guión: <@ref="garch">

# genr Dataset "Generar una nueva variable"

NOTA: Esta instrucción experimentó numerosos cambios y mejoras desde que se escribió el siguiente texto de ayuda, por eso para comprender y actualizar la información sobre esta instrucción, deberás seguir la referencia de <@pdf="El manual de gretl#chap:genr"> (Capítulo 9). Por otro lado, esta ayuda no contiene nada actualmente incorrecto, por lo que interpreta lo que sigue como “tienes esto, y más”. 

Utiliza esta caja para definir una nueva variable, con el patrón <@var="nuevavariable"> = <@var="fórmula">. La fórmula debe ser una combinación bien hecha de nombres de variables, constantes, operadores y funciones (detalles más abajo). Para asegurarte de que obtienes el tipo de variable que quieres, puedes preceder la fórmula con un tipo de nombre (e.g. <@lit="scalar">, <@lit="series"> o <@lit="matrix">). Por ejemplo, para generar una serie que tenga un valor constante igual a 10, puedes escribir 

<code>          
   series c = 10
</code>

(en otro caso, <@lit="c = 10"> generaría una variable escalar). 

Se admiten los <@itl="operadores aritméticos">, en orden de prioridad: <@lit="^"> (elevar a la potencia); <@lit="*">, <@lit="/"> y <@lit="%"> (módulo o resto); <@lit="+"> y <@lit="-">. 

Los <@itl="operadores booleanos "> disponibles son (de nuevo, en orden de prioridad): <@lit="!"> (negación), <@lit="&&"> (Y lógico), <@lit="||"> (O lógico), <@lit=">">, <@lit="<">, <@lit="=="> (igual a), <@lit=">="> (mayor o igual que), <@lit="<="> (menor o igual que) y <@lit="!="> (no igual). También puedes utilizar los operadores booleanos en la construcción de variables ficticias: por ejemplo, <@lit="(x > 10)"> devuelve 1 en caso de que <@lit="x"> > 10, y 0 en otro caso. 

Las constantes integradas son <@lit="pi"> y <@lit="NA">. La última es el código de valor ausente: puedes iniciar una variable con el valor ausente mediante <@lit="scalar x = NA">. 

La instrucción <@lit="genr"> admite un amplio rango de funciones matemáticas y estadísticas, incluyendo todas las habituales más varias que son especiales de Econometría. Además, ofrece acceso a muchas variables internas que se definen durante la ejecución de las regresiones, la realización de contrastes de hipótesis, etcétera. Para ver un listado de funciones y accesorios, consulta <@gfr="Referencia de funciones de gretl">. 

Además de los operadores y de las funciones indicados arriba, hay algunos usos especiales de <@lit="genr">: 

<indent>
• <@lit="genr time"> genera una variable de tendencia temporal (1,2,3,…) llamada <@lit="time">. Y <@lit="genr index"> tiene el mismo efecto, salvo que la variable se llama <@lit="index">. 
</indent>

<indent>
• <@lit="genr dummy"> genera tantas variables ficticias como la periodicidad de los datos. En caso de tener datos trimestrales (periodicidad 4), el programa genera <@lit="dq1"> = 1 para el primer trimestre y 0 para los otros trimestres, <@lit="dq2"> = 1 para el segundo trimestre y 0 para los otros trimestres, etcétera. Con datos mensuales, las variables ficticias se nombran <@lit="dm1">, <@lit="dm2">, etcétera. Con otras frecuencias, los nombres son <@lit="dummy_1">, <@lit="dummy_2">, etc. 
</indent>

<indent>
• <@lit="genr unitdum"> y <@lit="genr timedum"> generan conjuntos de variables ficticias especiales para utilizar con datos de panel, codificando las unidades de sección cruzada con la primera, y el período de tiempo de las observaciones con la segunda. 
</indent>

<@itl="Advertencia">: Con el programa en líneas de instrucción, las instrucciones <@lit="genr"> que recuperan datos relacionados con un modelo, siempre se refieren al modelo que se estimó más recientemente. Esto también es cierto en el programa de Interface Gráfica de Usuario (GUI), cuando utilizas <@lit="genr"> en la “consola de Gretl”o si introduces una fórmula usando la opción “Definir nueva variable” bajo el menú Añadir en la ventana principal. Con la GUI, sin embargo, tienes la opción de recuperar datos de cualquiera de los modelos que se muestran en ese momento en una ventana (sea o no sea el modelo estimado más recientemente). Puedes hacer esto bajo el menú “Guardar” de la ventana del modelo correspondiente. 

La variable especial <@lit="obs"> sirve como índice para las observaciones. Por ejemplo, <@lit="series dum = (obs==15)"> genera una variable ficticia que tiene valor 1 para la observación 15, y el valor 0 en otro caso. También puedes usar esta variable para escoger observaciones concretas por fecha o nombre. Por ejemplo, <@lit="series d = (obs>1986:4)">, <@lit="series d = (obs>"2008-04-01")">, o <@lit="series d = (obs=="CA")">. Cuando utilizas fechas diarias o marcadores de observación en este contexto, debes ponerlas entre comillas, pero puedes usar las fechas trimestrales y mensuales (con dos puntos) sin comillas. Ten en cuenta que, en caso de datos de series temporales anuales, el año no se distingue sintácticamente de un sencillo número entero. Por lo tanto, si quieres comparar observaciones frente a <@lit="obs"> por año, debes usar la función <@lit="obsnum"> para convertir así el año en un valor índice en base 1, como se hace en <@lit="series d = (obs>obsnum(1986))">. 

Puedes sacar los valores escalares de una serie en el contexto de una fórmula <@lit="genr">, utilizando la sintaxis <@var="varname"><@lit="["><@var="obs"><@lit="]"> en la que puedes indicar el valor <@var="obs"> por número o fecha. Ejemplos: <@lit="x[5]">, <@lit="CPI[1996:01]">. Para datos diarios, debes usar la forma <@var="YYYY-MM-DD">; e.g. <@lit="ibm[1970-01-23]">. 

Puedes modificar una observación individual de una serie mediante <@lit="genr">. Para hacer esto, debes añadir un número válido de observación o de fecha, entre corchetes, al nombre de la variable en el lado izquierdo de la fórmula. Por ejemplo, <@lit="genr x[3] = 30"> o <@lit="genr x[1950:04] = 303.7">. 

Menú gráfico: /Añadir/Definir nueva variable
Otro acceso: Ventana principal: Menú emergente

Instrucción de guión: <@ref="genr">

# genrand Programming "Generar variables aleatorias"

En este diálogo debes indicar un nombre para la variable que se va a generar, más alguna información adicional dependiendo del tipo de distribución. 

<indent>
• Uniforme: Los límites inferior y superior de la distribución. 
</indent>

<indent>
• Normal: La media y la desviación típica (positiva). 
</indent>

<indent>
• Chi-cuadrado y t de Student: Los grados de libertad (que deben ser positivos). 
</indent>

<indent>
• F: Los grados de libertad tanto del numerador como del denominador. 
</indent>

<indent>
• Gamma: Los parámetros de forma y de escala (ambos positivos). 
</indent>

<indent>
• Binomial: La probabilidad de “éxito” y un entero con el número de intentos. 
</indent>

<indent>
• Poisson: La media positiva (que también es igual a la varianza). 
</indent>

Si quieres generar secuencias repetibles de números pseudoaleatorios, puedes establecer la semilla mediante el elemento <@mnu="SetSeed">, en el menú Herramientas. 

# genseed Programming "Establecer la semilla para números aleatorios"

La 'semilla' controla el punto de inicio para la secuencia de números pseudoaleatorios generados en una sesión determinada de Gretl. Por defecto, la semilla se establece cuando se inicia el programa, utilizando el reloj del sistema. Esto te asegura que obtienes una secuencia distinta de números aleatorios cada vez que ejecutas el programa. Si quieres obtener secuencias repetibles, necesitas establecer la semilla de forma manual (y tomar nota del valor que utilizas). 

Ten en cuenta que siempre que pulsas un clic 'OK' en esta caja de diálogo, el generador se vuelve a reiniciar utilizando la semilla indicada. Así, por ejemplo, si (a) estableces la semilla en (digamos) 147; (b) generas una serie con distribución Normal estándar; (c) vuelves a visitar este diálogo y pulsas un clic 'OK' de nuevo con la semilla aún en 147; y (d) generas una segunda serie con distribución Normal estándar, las dos series generadas serán idénticas. 

# gmm Estimation "Estimación MGM (GMM)"

Realiza la estimación con el Método Generalizado de los Momentos (MGM o GMM) utilizando el algoritmo BFGS (Broyden, Fletcher, Goldfarb, Shanno). Debes especificar: (a) una o más instrucciones para actualizar las cantidades relevantes (típicamente errores GMM), (b) uno o más conjuntos de condiciones de ortogonalidad, (c) una matriz inicial de ponderaciones, y (d) un listado con los parámetros a estimar, todo puesto entre las etiquetas <@lit="gmm"> y <@lit="end gmm">. Cualquier opción deberá añadirse a la línea <@lit="end gmm">. 

Consulta <@pdf="El manual de gretl#chap:gmm"> (Capítulo 24) para obtener más detalles sobre esta instrucción. Aquí simplemente lo ilustramos con un ejemplo sencillo. 

<code>          
   gmm e = y - X*b
     orthog e ; W
     weights V
     params b
   end gmm
</code>

En el ejemplo de arriba, asumimos que tanto <@lit="y"> como <@lit="X"> son matrices de datos, <@lit="b"> es un vector de valores de los parámetros con la dimensión adecuada, <@lit="W"> es una matriz de instrumentos, y <@lit="V"> es una matriz adecuada de ponderaciones. La expresión 

<code>          
   orthog e ; W
</code>

indica que el vector de errores (<@lit="e">) es ortogonal, en principio, a cada uno de los instrumentos que constituyen las columnas de <@lit="W">. 

<@itl="Nombres de los parámetros"> 

Al estimar un modelo no lineal, frecuentemente resulta conveniente que nombres los parámetros de modo conciso. Al presentar los resultados, sin embargo, puede que desees utilizar etiquetas más informativas. Puedes lograr esto mediante la palabra clave adicional <@lit="param_names"> dentro del bloque de instrucción. Para un modelo con <@mth="k"> parámetros, el argumento que sigue a esta palabra clave debe ser, bien una cadena de texto literal entre comillas que contenga <@mth="k"> nombres separados por espacios, o bien el nombre de una variable de cadena que contenga <@mth="k"> de esos nombres. 

Menú gráfico: /Modelo/Variables instrumentales/GMM

Instrucción de guión: <@ref="gmm">

# graphing Graphs "Representar gráficos"

Gretl solicita que un programa distinto, concretamente Gnuplot, genere gráficos. Gnuplot es un programa de representación gráfica muy completo con miles de opciones. Mediante una interface gráfica, Gretl te da acceso directo a un subconjunto de estas opciones y trata de elegir valores sensatos para ti; si quieres, también te permite que tengas un control completo sobre los detalles del gráfico. 

Con un gráfico ya representado, puedes hacer clic en la ventana del gráfico para obtener un menú emergente con varias opciones, incluidas estas: 

<indent>
• Guardar como PNG: Guarda en formato 'Portable Network Graphics' 
</indent>

<indent>
• Guardar como postscript (EPS): Guarda el gráfico en formato 'Encapsulated postscript' (EPS) 
</indent>

<indent>
• Guardar en la sesión como icono: El gráfico aparecerá en forma de icono cuando escojas “Vista de Iconos” en el menú de la sesión 
</indent>

<indent>
• Zoom: Te permite seleccionar un área dentro del gráfico para hacer una inspección más de cerca 
</indent>

<indent>
• Copiar al portapapeles: Te permite pegar el gráfico en aplicaciones tales como procesadores de texto 
</indent>

<indent>
• Editar: Abre un controlador para el gráfico que te permite ajustar varios aspectos de su aspecto 
</indent>

<indent>
• Cerrar: Cierra la ventana del gráfico 
</indent>

Si tienes algún conocimiento sobre Gnuplot y quieres obtener un control más fino sobre el aspecto de un gráfico que el que es accesible mediante el controlador gráfico (opción “Editar”), dispones de una opción adicional: 

<indent>
• Una vez que has guardado el gráfico como icono de sesión, pulsa el botón derecho del ratón sobre ese icono para ver un menú emergente posterior. Aquí, una de las opciones es “Editar las órdenes de gráfico”: esto abre una ventana de edición con la presentación de las instrucciones Gnuplot vigentes. Puedes editar estas instrucciones y, bien guardarlas para ejecutarlas en el futuro, o bien enviarlas a Gnuplot (con el icono Ejecutar de la barra de herramientas en la ventana de instrucciones del gráfico). 
</indent>

Para descubrir más sobre Gnuplot, consulta <@url="www.gnuplot.info">. 

# graphpg Graphs "Página de gráficos de Gretl"

La sesión “Página de gráficos” va a funcionar solo cuando tengas instalado el sistema de composición tipográfica LaTeX, y además puedas generar y ver un resultado PDF o PostScript. 

En la ventana de iconos de la sesión, puedes arrastrar hasta 8 gráficos sobre el icono de página de gráficos. Cuando pulses un doble clic sobre la página de gráficos (o pulses el botón derecho y elijas “Mostrar”), se va a componer una página que contiene los gráficos seleccionados y se va a abrir con un visor adecuado. Desde ahí deberías poder imprimir la página. 

Para vaciar la página de gráficos, pulsa el botón derecho del ratón sobre su icono y selecciona “Vaciar”. 

Ten en cuenta que en sistemas diferentes a MS Windows, podrías tener que ajustar la configuración del programa utilizado para ver archivos PDF o PostScript. Encuéntralo bajo la pestaña “Programas” en la caja de diálogo de las Preferencias generales de Gretl (bajo el menú Herramientas de la ventana principal). 

También es posible trabajar en la página de gráficos mediante un guion, o utilizando la consola (en el programa de Interface Gráfica de Usuario, GUI). Se le da apoyo a las siguientes instrucciones y opciones: 

Para añadir un gráfico a la página de gráficos, puedes indicar la instrucción <@lit="graphpg add"> luego de guardar un gráfico definido, como en 

<code>          
   grf1 <- gnuplot Y X
   graphpg add
</code>

Para mostrar la página de gráficos: <@lit="graphpg show">. 

Para vaciar la página de gráficos: <@lit="graphpg free">. 

Para ajustar la escala de la fuente utilizada en la página de gráficos, usa <@lit="graphpg fontscale"> <@var="escala">, donde <@var="escala"> es un múltiplo (por defecto igual a 1.0). De este modo, para hacer que el tamaño de la fuente sea un 50 por ciento mayor que el tamaño por defecto, puedes hacer 

<code>          
   graphpg fontscale 1.5
</code>

Para solicitar la impresión de la página del gráfico en un archivo, usa la opción <@opt="--⁠output="> más un nombre de archivo; este nombre debería tener la extensión “<@lit=".pdf">”, “<@lit=".ps">” o “<@lit=".eps">”. Por ejemplo: 

<code>          
   graphpg --output="myfile.pdf"
</code>

El archivo resultante va a escribirse en el directorio establecido en ese momento (<@ref="workdir">), excepto que la cadena <@var="nombrearchivo"> contenga una especificación completa de la ruta. 

En este contexto, para el resultado se utilizan líneas de colores por defecto; para utilizar patrones punto/raya en vez de colores, puedes añadir la opción <@opt="--⁠monochrome">. 

Instrucción de guión: <@ref="graphpg">

# 3-D Graphs "Gráficos en 3 dimensiones"

Si el botón “Hacer el gráfico interactivo” está disponible y marcado, puedes manejar el gráfico 3-D con el ratón (girarla, expandir o encoger los ejes). 

Al componer un gráfico 3-D, ten en cuenta que el eje Z se va a mostrar como eje vertical. Así, si tienes alguna variable dependiente que piensas que puede estar influida por dos variables independientes, debes colocar la variable dependiente en el eje Z, y las variables independientes en los ejes X e Y. 

Al contrario de la mayoría de los gráficos de Gretl, un gráfico interactivo 3-D se controla mediante Gnuplot y no con el propio Gretl. El menú de edición de gráficos de Gretl no está disponible. 

# gui-funcs Programming "Funciones especiales"

Este diálogo te permite especificar las funciones (si existe alguna) dentro de un paquete que deben asignarse a ciertos roles especiales. Ten en cuenta que puedes asignar una determinada función como mucho a uno de los siguientes roles; y que una función tiene que satisfacer ciertos criterios para calificarla como candidata a uno de esos roles. 

<indent>
• <@lit="bundle-print">: Presenta el resultado basado en el contenido de un bundle producido por tu paquete. Criterios: Esta función debe tener como primer parámetro un puntero-bundle. Cuando se presenta un segundo parámetro, debe tener el formato de un conmutador entero que tenga un valor por defecto. 
</indent>

<indent>
• <@lit="bundle-plot">: Genera uno o más gráficos utilizando un bundle producido por tu paquete. Criterios: Igual que para <@lit="bundle-print">. 
</indent>

<indent>
• <@lit="bundle-test">: Realiza algún tipo de contraste estadístico utilizando un bundle producido por tu paquete. Criterios: Igual que para <@lit="bundle-print">. 
</indent>

<indent>
• <@lit="gui-main">: La interface pública que debiera de presentarse por defecto a los usuarios al utilizar la Interface Gráfica de Usuario (GUI). Esto resulta útil solo cuando el paquete tiene más de una interface pública. 
</indent>

<indent>
• <@lit="gui-precheck">: Función guardián que devuelve 0 si la funcionalidad de tu paquete es aplicable en el contexto vigente, y en otro caso devuelve no cero. Esto está pensado para utilizar con paquetes que afectan a un modelo de algún modo, para diferenciar los tipos de modelos que no se manejan con el paquete. 
</indent>

Además, ciertas funciones pueden indicarse con “no-print”. En general, cuando se llama a una función mediante el programa de Interface Gráfica de Usuario (GUI), Gretl abre una ventana para mostrar su resultado en texto. Al marcar este cuadradito estás indicándole a Gretl que no haga esto, de ahí que no debas esperar resultados en texto. 

Finalmente, puedes marcar la función <@lit="gui-main"> (si existe) como “menu-only”. Esto le indica a Gretl que la función en cuestión está diseñada específicamente para que se invoque desde el menú de la Interface Gráfica de Usuario (GUI) a la que está unida, y no debe presentarse a los usuarios, a no ser en ese caso. 

# gui-htest Tests "Calculadora de estadísticos de contraste"

La calculadora de contrastes de Gretl encuentra los valores de los estadísticos de contraste y de sus probabilidades asociadas (valores p) en varios contrastes habituales de hipótesis, relativas a una o dos poblaciones. Las entradas que se requieren consisten en estadísticos muestrales obtenidos de una o dos muestras, en función del contraste escogido; y puedes escribir estos estadísticos con valores numéricos. Alternativamente, si tienes abierto un archivo de datos, puedes lograr que Gretl calcule los estadísticos muestrales para una o varias variables escogidas (en caso de medias y varianzas, pero no en caso de proporciones). 

Si quieres basar tu contraste en una variable del conjunto de datos, primero activa esta opción marcando el cuadradito titulado “Utilice una variable del conjunto de datos”. Entonces, la lista desplegable con las variables se activará y podrás elegir una variable. Cuando escoges una variable de la lista, los estadísticos destacados se insertan automáticamente en las cajas de debajo. 

Además de la simple selección de una variable, tienes la opción de especificar una restricción sobre la variable escogida (es decir, definiendo una submuestra). Por ejemplo, supón que tienes datos de salarios en una variable llamada <@lit="salario">, y también tienes una variable ficticia llamada <@lit="género"> que es igual a 1 para hombres y a 0 para mujeres (o viceversa). Entonces, en el contraste de la diferencia entre las dos medias, puedes escoger <@lit="salario"> en ambas cajas pero añade a la misma caja de arriba <@lit="(género=0)"> y a la de abajo <@lit="(género=1)">. Así, esto te ofrece un contraste de la diferencia entre el ingreso medio masculino y el ingreso medio femenino. Ten en cuenta que cuando tecleas una restricción de este modo, entonces debes pulsar la tecla Intro para obtener los estadísticos muestrales calculados. 

Debes colocar la restricción de la submuestra entre paréntesis a continuación de la variable escogida, y en general esa restricción tiene la forma 

<code>          
   var2 op val
</code>

donde <@lit="var2"> es el nombre de una variable del conjunto vigente de datos, <@lit="val"> es un valor numérico, y <@lit="op"> es uno de los siguientes operadores de comparación: 

<code>          
   ==  !=  <  >  <=  >=
</code>

(indicando respectivamente: igualdad, desigualdad, menor que, mayor que, menor o igual que, y mayor o igual que). Los espacios alrededor del operador son opcionales. 

# gui-htest-np Tests "Contrastes no paramétricos"

Tienes a tu disposición 3 tipos de contrastes no paramétricos mediante este diálogo: para la diferencia entre grupos, para la aleatoriedad, y para la correlación (por rangos). 

<@itl="Contrastes de diferencias"> 

Bajo la pestaña “Contraste de diferencias” puedes efectuar un contraste no paramétrico de la diferencia entre dos poblaciones o grupos dependiendo, el contraste concreto, de la opción que selecciones. 

<indent>
• <@itl="Contraste de signos">: Este contraste se basa en el hecho de que cuando se extraen dos muestras, <@mth="x"> e <@mth="y">, de forma aleatoria de una misma distribución, la probabilidad de que <@mth="x"><@sub="i"> > <@mth="y"><@sub="i">, para cada observación <@mth="i">, deberá ser igual a 0.5. El estadístico de contraste es <@mth="w">, es decir, el número de observaciones para las que se cumple que <@mth="x"><@sub="i"> > <@mth="y"><@sub="i">. Bajo la hipótesis nula, este estadístico sigue una distribución de probabilidad Binomial con parámetros (<@mth="n">, 0.5), donde <@mth="n"> indica el número de observaciones. 
</indent>

<indent>
• <@itl="Contraste de suma de rangos">: Se realiza el contraste de suma de rangos de Wilcoxon, que se desarrolla determinando el rango en jerarquía de las observaciones de ambas muestras juntas, desde la de menor valor hasta la de mayor, y luego calculando la suma de los rangos de las observaciones de una cualquiera de las dos muestras. No es necesario que las dos muestras tengan el mismo tamaño y, si son diferentes, se utiliza la muestra más pequeña para calcular la suma de los rangos. Bajo la hipótesis nula de que las muestras proceden de poblaciones con la misma mediana, la distribución de probabilidad de la suma de rangos puede calcularse para cualquier tamaño de muestra que se indique; y para muestras razonablemente largas, existe una estrecha aproximación Normal. 
</indent>

<indent>
• <@itl="Contraste de los rangos con signo">: Se realiza el contraste de los rangos con signo de Wilcoxon, que está ideada para pares de datos ligados como, por ejemplo, los pares de valores de una misma variable en una muestra de individuos, antes y después de algún tratamiento. El contraste se desenvuelve calculando las diferencias entre las observaciones emparejadas <@mth="x"><@sub="i"> – <@mth="y"><@sub="i">, y determinando el rango de estas diferencias según su valor absoluto, además de asignándole a cada par un rango con un signo que coincide con el signo de la diferencia. A continuación se calcula la suma de los rangos con signo positivo (<@mth="W"><@sub="+">). De igual modo que en el contraste de la suma de rangos, bajo la hipótesis nula de que la diferencia de medianas es cero, este estadístico sigue una distribución de probabilidad bien definida, que converge a la Normal para muestras de tamaño razonable. 
</indent>

<@itl="Aleatoriedad"> 

Bajo la pestaña “Contraste de rachas”, puedes llevar a cabo un contraste del carácter aleatorio de una determinada variable, basada en el número de rachas de valores consecutivos positivos o negativos. Si escoges la opción “Utilizar la primera diferencia”, se calcula la primera diferencia de la variable antes del análisis; y por eso las rachas se interpretan como rachas de valores crecientes o decrecientes de la variable original. El estadístico de contraste se basa en una aproximación Normal a la distribución del número de rachas bajo la hipótesis nula de que la variable tiene carácter aleatorio. 

<@itl="Correlación"> 

Bajo la pestaña “Correlación”, dispones de los coeficientes de correlación por rangos rho de Spearman y tau de Kendall. 

# hausman Tests "Diagnósticos de panel"

Este contraste está disponible únicamente después de estimar un modelo con datos de panel utilizando MCO (consulta también <@lit="setobs">). Contrasta el modelo combinado simple frente a las principales alternativas, el modelo de efectos fijos y el de efectos aleatorios. 

El modelo de efectos fijos permite que la ordenada en el origen de la regresión varíe de una unidad de sección cruzada a otra. Se presenta un contraste <@mth="F"> para la hipótesis nula de que las ordenadas en el origen no difieren. El modelo de efectos aleatorios descompone la varianza de cada perturbación en dos partes, una parte específica de la unidad de sección cruzada y otra parte específica de cada observación concreta. (Se puede calcular este estimador solo cuando el número de unidades de sección cruzada en el conjunto de datos supera al número de parámetros a estimar.) El estadístico de Multiplicadores de Lagrange de Breusch–Pagan contrasta la hipótesis nula de que el estimador combinado de MCO es adecuado frente a la alternativa de efectos aleatorios. 

El modelo combinado de MCO puede rechazarse frente a ambas alternativas, la de efectos fijos y la de efectos aleatorios. Mientras la perturbación específica por unidad o grupo no esté correlacionada con las variables independientes, el estimador de efectos aleatorios será más eficiente que el estimador de efectos fijos; en otro caso, el estimador de efectos aleatorios será inconsistente por lo que se prefiere el estimador de efectos fijos. La hipótesis nula del contraste de Hausman indica que la perturbación específica de grupo no está así correlacionada (y por eso se prefiere el modelo de efectos aleatorios). Un valor bajo de la probabilidad asociada (valor p) al estadístico de este contraste va en contra del modelo de efectos aleatorios y a favor del modelo de efectos fijos. 

Las dos opciones de esta instrucción pertenecen al modelo de efectos aleatorios. Por defecto, se utiliza el método de Swamy y Arora, mediante el cálculo del estadístico de contraste de Hausman, utilizando el método de regresión. Las opciones permiten utilizar el estimador alternativo de la varianza de Nerlove, y /o la aproximación de la matriz-diferencia al estadístico de Hausman. 

Menú gráfico: Ventana de modelo: Contrastes/Diagnósticos de panel

Instrucción de guión: <@ref="hausman">

# hccme Estimation "Desviaciones típicas robustas"

Se te ofrecen diversas variantes de cálculo de las desviaciones típicas que son robustas en la presencia de heterocedasticidad (y de autocorrelación en el caso del estimador HAC). 

HC0 produce las “Desviaciones típicas de White” originales; HC1, HC2, HC3 y HC3a son variantes subsiguientes que generalmente se considera que producen resultados superiores (más fiables). Para obtener más detalles sobre los estimadores, consulta <@bib="MacKinnon y White (Journal of Econometrics, 1985);mackinnon-white85"> o <@bib="Davidson y MacKinnon, Econometric Theory and Methods (Oxford, 2004);davidson-mackinnon04">. Las etiquetas que se indican aquí son las utilizadas por Davidson y MacKinnon. La variante “HC3a” es la 'navaja' (jackknife) tal como se describe en MacKinnon y White; y HC3 es una aproximación estrecha a la 'navaja'. 

Si utilizas el estimador HAC para MCO con datos de series temporales, puedes afinar la longitud del retardo utilizando la instrucción <@lit="set">. Consulta el manual de Gretl o el archivo de ayuda de las instrucciones de un guion para obtener más detalles. 

Cuando estimas un modelo que utiliza datos de panel mediante MCO, el estimador robusto de la matriz de covarianzas que se usa por defecto es el proporcionado por Arellano. La alternativa es el de las Desviaciones Típicas Corregidas de Panel (PCSE) de Beck y Katz. Lo último tiene en cuenta la heterocedasticidad pero no la autocorrelación. 

Se ofrecen dos estimadores robustos de la matriz de covarianzas para modelos GARCH: QML es el estimador de Cuasi-Máxima Verosimilitud (CMV), y BW es el estimador de Bollerslev-Wooldridge. 

Por defecto, Gretl usa la distribución <@mth="t">-Student al calcular las probabilidades asociadas (valores p) basadas en desviaciones típicas robustas en el contexto de estimadores de mínimos cuadrados. La opción titulada “Utilizar la distribución Normal para obtener valores p robustos” puede usarse para modificar este comportamiento. 

# hsk Estimation "Estimaciones con la heterocedasticidad corregida"

Esta instrucción es aplicable cuando existe heterocedasticidad en forma de una función desconocida de los regresores, que puede aproximarse por medio de una relación cuadrática. En ese contexto, ofrece la posibilidad de obtener desviaciones típicas consistentes y estimaciones más eficientes de los parámetros, en comparación con MCO. 

El procedimiento implica (a) la estimación MCO del modelo de interés, seguido de (b) una regresión auxiliar para generar una estimación de la varianza de la perturbación, y finalmente (c) mínimos cuadrados ponderados, utilizando como ponderación la inversa de la varianza estimada. 

En la regresión auxiliar de (b), se regresa el logaritmo de los errores cuadrados de la primera estimación MCO, sobre los regresores originales y sus cuadrados (por defecto), o solo sobre los regresores originales (si no marcas el cuadradito “La ecuación de varianza incluye términos al cuadrado”). La transformación logarítmica se realiza para asegurar que las varianzas estimadas son todas no negativas. Denominando <@mth="u"><@sup="*"> a los valores ajustados por esta regresión, la serie con las ponderaciones para la estimación MCP (WLS) final se forma entonces como 1/exp(<@mth="u"><@sup="*">). 

Menú gráfico: /Modelo/Otros modelos lineales/con corrección de Heterocedasticidad

Instrucción de guión: <@ref="hsk">

# hurst Statistics "Exponente de Hurst"

Calcula el exponente de Hurst (una medida de persistencia o larga memoria) para una variable de tipo serie temporal que tenga por lo menos 128 observaciones. 

<@bib="Mandelbrot (1983);mandelbrot83"> discute sobre el exponente de Hurst. En términos teóricos, este es el exponente (<@mth="H">) de la relación 

  <@fig="hurst">

donde RS expresa el “rango que se vuelve a escalar” de la variable <@mth="x"> en muestras de tamaño <@mth="n"> y <@mth="a"> es una constante. El rango reescalado es el rango (valor máximo menos mínimo) del valor acumulado o suma parcial de <@mth="x"> (luego de la substracción de su media muestral) en el período de la muestra, dividida por la desviación típica muestral. 

Como punto de referencia, si <@mth="x"> es una variable ruido blanco (con media y persistencia nulas) entonces el rango de su “paseo” (forma un paseo aleatorio) acumulado y escalado por su desviación típica, tiene un crecimiento igual a la raíz cuadrada del tamaño de la muestra, proporcionando un exponente de Hurst esperado de 0.5. Los valores del exponente que estén significativamente por encima de 0.5 indican persistencia, y los menores que 0.5 indican “antipersistencia” (autocorrelación negativa). En principio, el exponente está acotado entre 0 y 1, aunque en muestras finitas es posible obtener un exponente estimado mayor que 1. 

En Gretl, el exponente se estima utilizando submuestreo binario: se empieza con el rango completo de datos, después con las dos mitades del rango, después con los 4 cuartos, etcétera. Para tamaños de la muestra menores que el rango de datos, el valor RS es la media entre las muestras disponibles. El exponente se estima así como el coeficiente de la pendiente, en una regresión del logaritmo de RS sobre el logaritmo del tamaño de la muestra. 

Por defecto, si el programa no está en modo de procesamiento por lotes, se muestra un gráfico del rango reescalado pero puedes ajustar esto mediante la opción <@opt="--⁠plot">. Los parámetros que se admiten para esta opción son <@lit="none"> (para suprimir el gráfico); <@lit="display"> (para presentar un gráfico incluso en caso de procesar por lotes); o un nombre de archivo. El efecto de indicar un nombre de archivo es como el descrito para la opción <@opt="--⁠output"> de la instrucción <@ref="gnuplot">. 

Menú gráfico: /Variable/Exponente de Hurst

Instrucción de guión: <@ref="hurst">

# intreg Estimation "Modelo de regresión por intervalos"

Estima un modelo de regresión por intervalos. Este modelo surge cuando la variable dependiente está imperfectamente observada para algunas observaciones (posiblemente todas). En otras palabras, se asume que el proceso generador de datos es 

  <@mth="y* = x b + u">

pero solo observamos <@mth="m <= y* <= M"> (el intervalo puede no tener límite por la izquierda o por la derecha). Ten en cuenta que para algunas observaciones <@mth="m"> puede ser igual a <@mth="M">. Las variables <@var="minvar"> y <@var="maxvar"> deben contener <@lit="NA">s para las observaciones sin límite por la izquierda o por la derecha, respectivamente. 

En la caja de diálogo de especificación del modelo, se identifican <@var="minvar"> y <@var="maxvar"> como la variable del límite Inferior y la variable del límite Superior, respectivamente. 

El modelo se estima mediante Máxima Verosimilitud, asumiendo la distribución Normal del término de perturbación aleatoria. 

Por defecto, las desviaciones típicas se calculan utilizando la inversa negativa de la matriz Hessiana. Si marcas el cuadradito de 'Desviaciones típicas robustas', entonces se calculan en su lugar las desviaciones típicas CMV (QML) o Huber–White. En este caso, la matriz de covarianzas estimada es un “emparedado” entre la inversa de la matriz Hessiana estimada y el producto externo del vector gradiente. 

Menú gráfico: /Modelo/Variable dependiente limitada/Regresión de intervalos

Instrucción de guión: <@ref="intreg">

# irfboot Graphs "Gráficos de respuesta al impulso"

Si escoges la opción 'bootstrap' cuando representas respuestas al impulso, Gretl calcula un intervalo de confianza para las respuestas utilizando el método bootstrap. Se vuelve a hacer el muestreo con los errores del VAR (o VECM) original, con substitución; se construye un conjunto de datos artificial basado en las estimaciones originales de los parámetros y en los errores de ese nuevo muestreo; el sistema se vuelve a estimar y las respuestas al impulso se vuelven a evaluar. Esto se repite 999 veces, se hallan los cuantiles α/2 y 1 – α/2 para las respuestas, y se dibujan junto con las estimaciones por punto. Esta opción no está disponible actualmente para VECMs restringidos. 

Este diálogo también admite la reordenación de las variables para hacer la descomposición de Cholesky de la matriz de covarianzas de las ecuaciones cruzadas. El proceder por defecto viene indicado por el orden en el que se introducen las variables en la especificación del modelo, pero puedes usar las flechas de arriba y abajo para adelantar o retrasar la variable escogida. 

Respecto a la escala de las respuestas al impulso, la dimensión del “impacto” se establece en una desviación típica de las innovaciones estimadas en la variable de origen, y las respuestas se proporcionan en cualquiera que sea la unidad “natural” de la variable objetivo. 

# join Dataset "Añadir datos con controles"

Este diálogo te da acceso a cierta funcionalidad (pero no toda) de la instrucción <@lit="join">. Para obtener detalles más completos, consulta <@pdf="El manual de gretl#chap:join"> (Capítulo 7). 

En la izquierda deberías de ver un listado de las series del conjunto de datos vigente. Aquí puedes escoger una serie, y utilizar los botones con las flechas para especificarla como una u otra de las “claves internas” (opcionales). Las claves funcionan para emparejar filas entre el conjunto vigente de datos y el archivo del que estés importando datos. 

En la derecha deberían listarse las series del archivo de datos que escogiste. Puedes usar los botones con las flechas para elegir el nombre de las series a importar de esa lista, y (de ser necesario) los nombres de las series que se corresponden con las claves “internas”. (Por defecto, se presupone que las claves internas y externas tienen el mismo nombre.) 

En medio del cuadro de diálogo puedes especificar parámetros adicionales para la operación “join”: 

<indent>
• Un nombre con el que se deberá reconocer a la serie importada. (Por defecto, este es el mismo que el nombre a “importar”). 
</indent>

<indent>
• Una expresión como filtro. Esta se va a evaluar para cada fila del conjunto de datos externo, y solo se van a importar las filas en las que la expresión proporcione un valor no nulo. 
</indent>

<indent>
• Un método de agregación. Este se requiere solo cuando el emparejamiento mediante las claves selecciona más de un valor externo para cada observación interna. 
</indent>

# kpss Tests "Contraste de estacionariedad KPSS"

Calcula el contraste de estacionariedad KPSS (Kwiatkowski, Phillips, Schmidt y Shin, Journal of Econometrics, 1992) de la variable indicada (o de su primera diferencia, si escoges la opción de usar las primeras diferencias). La hipótesis nula es que la variable en cuestión es estacionaria, bien alrededor de un nivel o, si marcas el cuadradito de “Incluir una tendencia”, alrededor de una tendencia lineal determinística. 

El orden de retardos seleccionado determina el tamaño de la ventana utilizada para el suavizado de Bartlett. Si marcas el cuadradito de “Mostrar los resultados de la regresión”, se presentan los resultados de la regresión auxiliar, junto con la varianza estimada de la componente de paseo aleatorio de la variable. 

Los puntos críticos mostrados para el estadístico de contraste se basan en superficies de respuesta estimadas del modo establecido por <@bib="Sephton (Economics Letters, 1995);sephton95">, que son más fiables para muestras pequeñas que los valores indicados en el artículo original de KPSS. Cuando el estadístico de contraste cae entre los puntos críticos del 1 y del 10 por ciento, se muestra una probabilidad asociada (valor p) que se obtiene mediante interpolación lineal y no debe tomarse demasiado literalmente. Consulta la función <@xrf="kpsscrit"> para ver un medio de obtener esos puntos críticos con la ayuda del programa. 

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste KPSS

Instrucción de guión: <@ref="kpss">

# lad Estimation "Estimación de la Mínima Desviación Absoluta"

Calcula una regresión que minimiza la suma de las desviaciones absolutas de los valores ajustados respecto a los valores observados de la variable dependiente. Las estimaciones de los coeficientes se derivan utilizando el algoritmo del simplex de Barrodale–Roberts; y se presenta una advertencia si la solución no es única. 

Las desviaciones típicas se deducen utilizando el procedimiento 'bootstrap' con 500 extracciones. La matriz de covarianzas de los estimadores de los parámetros, que se presenta cuando indicas <@opt="--⁠vcv">, se basa en el mismo 'bootstrap'. Puesto que esta es una operación bastante costosa, la opción <@opt="--⁠no-vcv"> se proporciona para aquellos casos en los que no se necesita la matriz de covarianzas; cuando indicas esta opción, las desviaciones típicas no van a estar disponibles. 

Ten en cuenta que este método puede resultar lento cuando la muestra es muy larga o cuando hay muchos regresores. Por eso, en esos casos, puede ser mejor utilizar la instrucción <@ref="quantreg">. Dadas una variable dependiente <@lit="y"> junto con una lista <@lit="X"> de regresores, las siguientes instrucciones son básicamente equivalentes, con la excepción de que el método "quantreg" utiliza el algoritmo más rápido de Frisch–Newton, y que proporciona las desviaciones típicas analíticas en lugar de las de "bootstrapping". 

<code>          
   lad y const X
   quantreg 0.5 y const X
</code>

Menú gráfico: /Modelo/Estimación robusta/Mínima desviación absoluta

Instrucción de guión: <@ref="lad">

# lags-dialog Estimation "Cuadro de selección de retardos"

En este diálogo puedes elegir el orden de retardos para las variables independientes del modelo de series temporales y, en algunos casos, también para la variable dependiente. (Pero ten en cuenta que el orden de retardos habitual para modelos de vectores como VARs y VECMs se maneja por separado, mediante un botón con flechas arriba/abajo de selección, en la caja de diálogo principal del modelo.) 

Los botones con flechas arriba/abajo de la izquierda te permiten escoger un rango de retardos consecutivos para cualquier variable dada. Para indicar retardos no consecutivos, pulsa un clic en el cuadradito al lado del campo con el título “Retardos específicos”. Esto activa la caja de anotación, en la que puedes teclear una lista de retardos separados por espacios. 

La fila titulada “Por defecto” te ofrece un modo rápido de establecer una especificación de retardos común para todas las variables independientes, pues los valores colocados en esa fila se copian a todas las otras (excepto de la variable dependiente, si está presente). 

La variable dependiente se trata de modo especial: el retardo mínimo debe ser cero, lo que sitúa al valor actual de la variable en el lado izquierdo del modelo. Cualquier retardo mayor aparece con las variables independientes en el lado derecho del modelo. 

Los valores seleccionados en este diálogo se recuerdan a lo largo de la duración de tu sesión con un conjunto determinado de datos. 

# leverage Tests "Observaciones influyentes"

Debe ir después de una instrucción de MCO (<@lit="ols">). Calcula el apalancamiento (<@mth="h">, que debe caer en el rango entre 0 y 1) para cada punto de datos de la muestra sobre la que se estimó el modelo previo. Muestra el error (<@mth="u">) para cada observación junto con su apalancamiento y una medida de su influencia en las estimaciones, <@mth="uh">/(1 – <@mth="h">). Los “puntos de Leverage” para los que el valor de <@mth="h"> supera 2<@mth="k">/<@mth="n"> (donde <@mth="k"> es el número de parámetros que se estiman y <@mth="n"> es el tamaño de la muestra) se destacan mediante un asterisco. Para obtener más detalles sobre los conceptos de apalancamiento e influencia, consulta el capítulo 2 del libro de <@bib="Davidson y MacKinnon (1993);davidson-mackinnon93">. 

También se calculan los valores DFFITS: estos son iguales a los “errores tipificados” (errores de predicción divididos por sus desviaciones típicas) multiplicados por <@fig="dffit">. Para una discusión sobre errores tipificados y DFFITS consulta el capítulo 12 del libro de Maddala <@bib="Introduction to Econometrics;maddala92"> o <@bib="Belsley, Kuh y Welsch (1980);belsley-etal80">. 

Abreviadamente, un “error de predicción” es la diferencia entre el valor observado de la variable dependiente en la observación <@mth="t">, y el valor ajustado para esa observación <@mth="t"> que se obtiene de la regresión en la que se omite esa observación (o en la que se añade una variable ficticia con un valor 1 solo en la observación <@mth="t">); el error tipificado se obtiene dividiendo el error de predicción por su desviación típica. 

Con el icono '+' de la parte de arriba de la ventana del contraste de apalancamiento, puedes presentar en la pantalla una caja de diálogo que te permite guardar en el conjunto vigente de datos, una o más de las variables de ese contraste. 

Después de la ejecución, el accesorio <@xrf="$test"> devuelve el criterio de validación cruzada, que se define como la suma de las desviaciones cuadradas de la variable dependiente con relación a sus valores de predicción, estando la predicción para cada observación basada en una muestra de la que se excluye esa observación. (Este es el conocido como estimador <@itl="dejar-uno-fuera">). Para una discusión más amplia sobre el criterio de validación cruzada, consulta el libro de Davidson y MacKinnon <@itl="Econometric Theory and Methods">, páginas 685–686, y las referencias que contiene. 

Menú gráfico: Ventana de modelo: Análisis/Observaciones influyentes

Instrucción de guión: <@ref="leverage">

# levinlin Tests "Contraste de Levin-Lin-Chu"

Realiza el contraste de raíz unitaria para panel descrita por <@bib="Levin, Lin y Chu (2002);LLC2002">. La hipótesis nula es que todas las series temporales individuales presentan una raíz unitaria, y la alternativa es que ninguna de las series tiene una raíz unitaria. (Es decir, se asume un mismo coeficiente común de AR(1), aunque en otros aspectos se permite que las propiedades estadísticas de las series varíen de unos individuos a otros.) 

Observa que los contrastes de raíz unitaria en un panel también puedes hacerlos utilizando las instrucciones <@ref="adf"> y <@ref="kpss">. 

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste Levin-Lin-Chu

Instrucción de guión: <@ref="levinlin">

# loess Estimation "Loess"

Realiza la regresión local (polinómica ponderada localmente) y genera una serie que contiene los valores predichos de la variable dependiente para cada valor no ausente de la variable independiente. El método es como se describe por <@bib="William Cleveland (1979);cleveland79">. 

Los controles te permiten que especifiques el orden del polinomio de la variable independiente y la proporción de puntos de datos que se utilizan en cada regresión local (el ancho de banda). Los valores más grandes del ancho de banda producen un resultado más suave. 

Si marcas el cuadradito de ponderaciones robustas, el procedimiento de regresión local se reitera dos veces, con la modificación de las ponderaciones en base a los errores de la iteración previa, de modo que se le dé menos influencia a los valores atípicos. 

# logistic Estimation "Regresión logística"

Regresión logística: Lleva a cabo una regresión MCO utilizando la transformación logística de la variable dependiente, 

  <@fig="logistic1">

La variable dependiente debe ser estrictamente positiva. Si todos sus valores están entre 0 y 1, por defecto se utiliza un valor de <@mth="y"><@sup="*"> (el máximo asintótico de la variable dependiente) igual a 1; si sus valores están entre 0 y 100, entonces <@mth="y"><@sup="*"> es 100 por defecto. 

Puedes especificar un valor máximo diferente para <@mth="y">. Ten en cuenta que el valor que indiques debe ser mayor que todos los valores observados de la variable dependiente. 

Los valores ajustados y los errores de la regresión se transforman automáticamente utilizando la inversa de la transformación logística: 

  <@fig="logistic2">

donde <@mth="x"> representa un valor ajustado o un error, obtenidos de la regresión MCO que utiliza la variable dependiente logística. De este modo puedes comparar los valores que se presentan con los de la variable dependiente original. La aproximación es necesaria pues la transformación inversa no es lineal, y por lo tanto la esperanza no se corresponde exactamente. 

La opción <@opt="--⁠fixed-effects"> solo es aplicable cuando el conjunto de datos tiene forma de panel. En ese caso, se le restan las medias de grupo de la transformación logística de la variable dependiente, y la estimación continúa como se hace habitualmente con efectos fijos. 

Ten en cuenta que si la variable dependiente es binaria, debes utilizar en su lugar la instrucción <@ref="logit">. 

Menú gráfico: /Modelo/Variable dependiente limitada/Logística

Instrucción de guión: <@ref="logistic">

# logit Estimation "Regresión Logit"

Si la variable dependiente es una variable binaria (todos sus valores son 0 o 1), se obtienen estimaciones máximo verosímiles de los coeficientes de las variables de <@var="indepvars"> mediante el método de Newton–Raphson. Como el modelo es no lineal, las pendientes están condicionadas por los valores de las variables independientes. Por defecto, se calculan las pendientes con respecto a cada una de las variables independientes (en las medias de esas variables), y estas pendientes substituyen los valores p habituales en el resultado de la regresión. Puedes prescindir de este proceder indicando la opción <@opt="--⁠p-values">. El estadístico chi-cuadrado contrasta la hipótesis nula de que todos los coeficientes son cero, excepto el de la constante. 

Por defecto, las desviaciones típicas se calculan utilizando la inversa negativa de la matriz Hessiana. Si marcas el cuadradito de 'Desviaciones típicas robustas', entonces se calculan en su lugar las desviaciones típicas CMV (QML) o de Huber–White. En este caso, la matriz de covarianzas estimadas es un “emparedado” entre la inversa de la matriz Hessiana estimada y el producto externo del vector gradiente. Consulta el capítulo 10 del libro de Davidson y MacKinnon para obtener más detalles. 

Si la variable dependiente no es binaria sino discreta, entonces por defecto se interpreta como una respuesta ordinal y se obtienen las estimaciones con un Logit Ordenado. Sin embargo, cuando indicas la opción <@opt="--⁠multinomial">, la variable dependiente se interpreta como una respuesta sin ordenar y se generan las estimaciones con un Logit Multinomial. (En otro caso, si la variable escogida como dependiente no es de tipo discreto, se muestra un fallo.) En el caso multinomial, el accesorio <@lit="$mnlprobs"> está disponible después de la estimación, para conseguir una matriz que contenga las probabilidades estimadas de los posibles valores de la variable dependiente para cada observación (con las observaciones por filas y los posibles valores por columnas). 

Si quieres utilizar un Logit para el análisis de proporciones donde, para cada observación, la variable dependiente es la proporción de casos que tienen una determinada característica (en vez de una variable con 1 o 0 para indicar si está presente o no la característica), no debes utilizar la instrucción <@lit="logit">, sino más bien construir la variable logit, como en 

<code>          
   series lgt_p = log(p/(1 - p))
</code>

y utilizar esta como la variable dependiente de una regresión MCO. Consulta el capítulo 12 de <@bib="Ramanathan (2002);ramanathan02">. 

Menú gráfico: /Modelo/Variable dependiente limitada/Logit

Instrucción de guión: <@ref="logit">

# mahal Statistics "Distancias de Mahalanobis"

Calcula las distancias de Mahalanobis entre las series indicadas en <@var="listavariables">. La distancia de Mahalanobis es la distancia entre dos puntos en un espacio de dimensión <@mth="k">, escalada por la variación estadística en cada dimensión del espacio. Por ejemplo, si <@mth="p"> y <@mth="q"> son dos observaciones de un conjunto de <@mth="k"> variables con matriz de covarianzas <@mth="C">, entonces la distancia de Mahalanobis entre las observaciones viene dada por 

  <@fig="mahal">

donde (<@mth="p"> – <@mth="q">) es un vector de dimensión <@mth="k">. Esto se reduce a la distancia euclidiana en caso de que la matriz de covarianzas sea una matriz identidad. 

El espacio para el que se calculan las distancias está definido por las variables seleccionadas. Para cada observación del rango vigente de la muestra, la distancia se calcula entre la observación y el centroide de las variables escogidas. Esta distancia es la contrapartida multidimensional de una puntuación <@mth="z"> estándar, y puedes utilizarla para juzgar si una observación dada “pertenece” a un grupo de otras observaciones. 

Cuando el número de variables seleccionadas es de 4 o menos, se presentan tanto la matriz de covarianzas como su inversa. Al pulsar con el ratón en el botón '+' en lo alto de la ventana que muestra las distancias, te permite la posibilidad de añadir las distancias al conjunto de datos como una nueva variable. 

Menú gráfico: /Ver/Distancias de Mahalanobis

Instrucción de guión: <@ref="mahal">

# meantest Tests "Diferencia de medias"

Por defecto, el estadístico de contraste se calcula bajo el supuesto de que las varianzas son iguales para las dos variables. Con la opción <@opt="--⁠unequal-vars"> se asume que las varianzas son diferentes; y en este caso, los grados de libertad del estadístico de contraste se aproximan conforme a <@bib="Satterthwaite (1946);satter46">. 

Calcula el estadístico t para contrastar la hipótesis nula de que las medias en la población son iguales para dos series seleccionadas, y muestra su probabilidad asociada (valor p). Puedes invocar esta instrucción asumiendo o no que las varianzas son iguales para las dos variables. En el último caso, los grados de libertad del estadístico para el contraste se aproximan conforme a <@bib="Satterthwaite (1946);satter46">. 

Menú gráfico: /Herramientas/Calculadora de estadísticos de contraste

Instrucción de guión: <@ref="meantest">

# MIDAS_list Dataset "Lista MIDAS"

Una lista MIDAS (MIDAS = Mixed Data Sampling) es una lista definida (de series) cuyos elementos representan conjuntamente una variable de tipo serie temporal que se observa en una frecuencia mayor que la del conjunto de datos del contexto (“host”). Por ejemplo, una lista de este tipo podría representar una serie mensual en el contexto de un conjunto de datos trimestrales o anuales, o una serie diaria en el contexto de un conjunto de datos mensual. 

Una lista de este tipo debe tener <@mth="m"> elementos, donde <@mth="m"> es el número de períodos de alta frecuencia por período del conjunto de datos, y cada serie contiene los valores para un determinado subperíodo. En el caso mensual/trimestral, esto quiere decir que una lista tiene 3 elementos: un elemento contiene los valores para el tercer mes del trimestre, otro contiene los valores para el segundo mes, y el otro los valores para el primer mes. 

Además, estos miembros de la lista deben estar colocados en el orden particular <@itl="primero los más recientes">, en concreto. Continuando con el ejemplo mensual/trimestral, el orden debe ser: mes 3, mes 2, mes 1. Aunque esto podría parecer “al revés” es el orden que se requiere para poder generar las listas de retardos, que es la característica distintiva de la modelización MIDAS. 

Para tener una guía de cómo generar un conjunto de datos que admita listas MIDAS, consulta 

<@url="http://gretl.sourceforge.net/midas/midas_gretl.pdf"> 

# MIDAS_parm Estimation "Hiperparámetros del MIDAS"

En este diálogo se te pide que escojas el tipo de disposición de parámetros para un conjunto de términos de alta frecuencia, así como el rango de retardos de estos términos. Los tipos admitidos de disposición de parámetros son: 

<indent>
• U-MIDAS o “MIDAS no restringido”: cada retardo tiene su propio coeficiente. 
</indent>

<indent>
• Almon exponencial normalizada: requiere por lo menos un parámetro y habitualmente utiliza dos. 
</indent>

<indent>
• Beta normalizada con un último retardo nulo: requiere exactamente dos parámetros. 
</indent>

<indent>
• Beta normalizada con un último retardo no nulo: requiere exactamente tres parámetros. 
</indent>

<indent>
• Polinomio de Almon: requiere por lo menos un parámetro. 
</indent>

<indent>
• Beta normalizada, 1 parámetro: esta es una variante del Beta normalizada con un último retardo nulo, en el que el valor del primer parámetro se fija en 1.0. El segundo parámetro se estima sujeto a la restricción de que este es cuando menos 1.0. 
</indent>

# midasreg Estimation "Regresión MIDAS"

Lleva a cabo la estimación por mínimos cuadrados (bien MCNL o bien MCO, dependiendo de la especificación) de un modelo MIDAS (Mixed Data Sampling). Este tipo de modelos incluye una o más variables independientes que se observan con una frecuencia mayor que a variable dependiente; para una buena y breve introducción consulta <@bib="Armesto, Engemann y Owyang (2010);armesto10">. 

Las variables bajo <@var="Regresores"> tienen la misma frecuencia que la variable dependiente, y se escogen de la lista superior del lado izquierdo. Los modelos MIDAS habitualmente incluyen uno o más retardos de la variable dependiente; esto se controla mediante el botón con flechas arriba/abajo de “Orden AR”, que por defecto marca 1 retardo. Para añadir términos MIDAS (alta frecuencia), elige variables en la lista del lado inferior izquierdo y usa la flecha verde inferior (o pulsa el botón derecho del ratón). 

Al añadir un término MIDAS, emerge un diálogo para permitirte escoger: el rango de retardos, el tipo de disposición de parámetros y el número de hiperparámetros (para aquellos tipos que no tienen un número fijo de parámetros). Puedes hacer emerger otra vez este diálogo para revisar una especificación, pulsando el botón derecho del ratón en un término MIDAS de la derecha. 

El método de estimación que utiliza esta instrucción depende de la especificación de los elementos de alta frecuencia. En el caso de U-MIDAS, el método es MCO (OLS); de lo contario, es mínimos cuadrados no lineales (MCNL o NLS). Cuando especificas las disposiciones de parámetros Almon exponencial normalizada o Beta normalizada, el método MCNL por defecto es una combinación de BFGS restringido y MCO, excepto que marques la cajita titulada “Prefiere NLS via Levenberg-Marquardt”. 

Menú gráfico: /Modelo/Series temporales/MIDAS

Instrucción de guión: <@ref="midasreg">

# missing Dataset "Valores para datos ausentes"

Establece un valor numérico que se interpreta como “ausente” o “no disponible”, bien para una serie de datos particular (bajo el menú Variable) o bien globalmente para todo el conjunto de datos (bajo el menú Datos). 

Gretl tiene su propia codificación interna para los valores ausentes, pero a veces los datos que se importan pueden emplear otro código distinto. Por ejemplo, si una serie concreta está codificada de modo que el valor '-1' indica “no aplicable”, puedes escoger “Establecer código de valor ausente” bajo el menú Variable y teclear el valor “-1” (sin las comillas). Entonces Gretl va a leer esos (-1) como observaciones ausentes. 

# menu-attach Programming "Anexo al menú"

Este diálogo te permite especificar un anexo al menú para un paquete de funciones. Para eso debes completar los siguientes tres campos en la caja de diálogo. 

<@itl="1. Etiqueta"> 

Esto requiere una corta cadena de texto como etiqueta, que aparecerá como acceso al paquete, en el menú. 

<@itl="2. Ventana"> 

Selecciona “Ventana de modelo” para un paquete de funciones que hace algo con un modelo de Gretl, y deba aparecer en la barra de menús de una ventana de modelos de Gretl. En otro caso, selecciona “Ventana principal”. 

<@itl="3. Árbol del menú"> 

Escoge la posición dentro del árbol del menú (bien de la ventana principal o bien de la ventana de modelos, como has elegido de acuerdo con lo indicado arriba), donde debe aparecer el acceso al paquete. 

<@itl="Elementos opcionales"> 

Además, puedes utilizar el botón “Texto de ayuda” de la GUI para añadir o editar texto de ayuda específico de Interface Gráfica de Usuario (GUI) para que se muestre cuando se invoque el paquete desde un menú. Y si el paquete está pensado para invocarlo desde la ventana de un modelo, puedes especificar un cierto tipo de modelo (identificado por su palabra clave como instrucción de Gretl) como requisito. 

# mle Estimation "Estimación Máximo Verosímil"

Realiza la estimación de Máxima Verosimilitud (MV o ML) usando el algoritmo BFGS (Broyden, Fletcher, Goldfarb, Shanno). Debes especificar la función logaritmo de verosimilitud; y se te recomienda que también proporciones las expresiones de las derivadas de esta función con respecto a cada uno de los parámetros, si es posible. 

Ejemplo sencillo: Supón que tenemos una serie <@lit="X"> con valores 0 o 1, y queremos obtener la estimación máximo verosímil de la probabilidad (<@lit="p">) de que <@lit="X"> = 1. (En este caso sencillo, se puede adelantar que la estimación MV de <@lit="p"> será simplemente equivalente a la proporción de Xs iguales a 1, en la muestra.) 

Debes primero añadir el parámetro <@lit="p"> al conjunto de datos e indicar su valor inicial. Puedes hacer esto usando la instrucción 'genr' o mediante elecciones de menú. Puedes teclear las líneas “genr” adecuadas en la ventana de especificación de la EMV, antes de especificar la función logaritmo de verosimilitud. 

En la ventana EMV, tecleamos las siguientes líneas: 

<code>          
   loglik = X*log(p) + (1-X)*log(1-p)
   deriv p = X/p - (1-X)/(1-p)
</code>

La primera línea especifica la función logaritmo de verosimilitud, y la siguiente línea proporciona la derivada de esa función con respecto al parámetro 'p'. Si no indicas líneas 'deriv', se calcula una aproximación numérica a las derivadas. 

Cuando no se expresa previamente el parámetro 'p', podemos poner antes de las líneas de arriba algo como lo siguiente: 

<code>          
   scalar p = 0.5
</code>

Las desviaciones típicas se basan en el Producto Externo del vector Gradiente, por defecto. Si marcas el cuadradito “Desviaciones típicas robustas”, se utiliza un estimador CMV (QML, un “emparedado” entre la inversa negativa de la matriz Hessiana y la matriz de covarianzas del vector gradiente, en concreto). La matriz Hessiana se aproxima numéricamente. 

Para una descripción mucho más en profundidad de la estimación <@lit="mle">, consulta <@pdf="El manual de gretl#chap:mle"> (Capítulo 23). 

Menú gráfico: /Modelo/Máxima Verosimilitud

Instrucción de guión: <@ref="mle">

# modeltab Utilities "La tabla de modelos"

En la investigación econométrica es habitual estimar varios modelos con una misma variable dependiente, diferenciándose esos modelos en las variables independientes que están incluidas en cada uno o, quizás, en el tipo de estimador utilizado. En esta situación, resulta conveniente presentar los resultados de la regresión en forma de una tabla, en la que cada columna contenga los resultados (las estimaciones de los coeficientes y de las desviaciones típicas) para un modelo dado, y en la que cada fila contenga las estimaciones para una determinada variable en los diferentes modelos. 

Gretl proporciona un medio para elaborar una tabla de este tipo (y de copiarla en texto plano, LaTeX o Rich Text Format). Aquí tienes como hacerlo: 

<indent>
1. Estima un modelo que quieras incluir en la tabla y, bajo el menú Archivo de la ventana de modelos, selecciona “Guardar en la sesión como icono” o “Guardar como icono y cerrar”. 
</indent>

<indent>
2. Repite el paso 1 para los otros modelos que se van a incluir en la tabla (hasta un total de 6 modelos). 
</indent>

<indent>
3. Cuando ya tengas hecha la estimación de los modelos, abre el visor de iconos de tu sesión de Gretl (escogiendo “Vista de iconos” bajo el menú de Ver en la ventana principal de Gretl, o pulsando en el icono titulado “Vista de iconos de sesión” en la barra de herramientas de Gretl). 
</indent>

<indent>
4. En la vista de iconos de sesión, hay un icono titulado “Tabla de modelos”. Decide el modelo que quieres que aparezca en la columna más a la izquierda de la Tabla de modelos y añádelo a la tabla, bien arrastrando su icono sobre el icono de la Tabla de modelos, o bien pulsando el botón derecho del ratón sobre el icono del modelo, y escogiendo “Añadir a la tabla de modelos” del menú emergente. 
</indent>

<indent>
5. Repite el paso 4 para los demás modelos que quieras incluir en la tabla; así el segundo modelo que selecciones va a aparecer en la segunda columna, empezando por la izquierda; etcétera. 
</indent>

<indent>
6. Cuando acabes de componer la tabla de modelos, muéstrala pulsando un doble clic sobre su icono. Bajo el menú 'Copiar' de la ventana que aparece, tienes la posibilidad de copiar la tabla al portapapeles en varios tipos de formato. 
</indent>

<indent>
7. Si el orden de los modelos en la tabla no es el que querías, pulsa el botón derecho del ratón sobre el icono de la tabla de modelos, y escoge “Vaciar”. Entonces vuelve al paso 4 de arriba e inténtalo de nuevo. 
</indent>

Menú gráfico: Ventana de iconos de sesión: icono de Tabla de modelos

Instrucción de guión: <@ref="modeltab">

# mpols Estimation "MCO de alta precisión"

Calcula las estimaciones de MCO para el modelo especificado, utilizando aritmética de punto flotante con precisión múltiple, con la ayuda de la biblioteca Gnu Multiple Precision (GMP). Por defecto, se utilizan 256 bits de precisión en los cálculos, pero puedes aumentar esto mediante la variable de entorno <@lit="GRETL_MP_BITS">. Por ejemplo, cuando utilizas el intérprete Bash se te podría ocurrir la siguiente instrucción para establecer una precisión de 1024 bits antes de comenzar Gretl. 

<code>          
   export GRETL_MP_BITS=1024
</code>

Menú gráfico: /Modelo/Otros modelos lineales/MCO de alta precisión

Instrucción de guión: <@ref="mpols">

# nadarwat Estimation "Nadaraya-Watson"

Calcula <@mth="m(x)">, el estimador no paramétrico de Nadaraya–Watson de la media condicionada de la variable dependiente, para cada valor no ausente de la variable independiente. 

La función núcleo (kernel) viene determinada por <@mth="K = exp(-x"><@sup="2"><@mth="/2h)"> para <@mth="|x|<T">, y cero en otro caso. <@mth="T"> es un parámetro de recorte, por defecto igual a 4<@mth="h">. 

El ancho de banda <@mth="h">, que habitualmente es un número pequeño, controla la suavidad de <@mth="m(x)"> (los valores más grandes producen series más suaves). Por defecto, este valor está determinado por los datos y resulta proporcional a <@mth="n"><@sup="-0.2">, siendo <@mth="n"> el tamaño de la muestra. 

Si marcas el cuadradito de “dejar una fuera”, se emplea una variante del estimador en la que la <@mth="i">-ésima observación no se utiliza para evaluar <@mth="m(x"><@sub="i"><@mth=")">. Esto hace que el algoritmo sea numéricamente más robusto, y su utilización se aconseja normalmente cuando el estimador se calcula con el propósito de hacer inferencias. 

Para obtener más detalles sobre la estimación no paramétrica, consulta <@pdf="El manual de gretl#chap:nonparam"> (Capítulo 37). 

# negbin Estimation "Regresión Binomial Negativa"

Estima un modelo Binomial Negativo. Se toma la variable dependiente para representar un recuento del número de veces que ocurre un suceso de algún tipo, y debe tener solo valores enteros no negativos. Por defecto, se utiliza el modelo NegBin 2 en el que la varianza condicionada del recuento viene determinada por μ(1 + αμ), donde μ denota la media condicionada. Pero si indicas la opción <@opt="--⁠model1">, la varianza condicionada es μ(1 + α). 

La serie de exposición (<@lit="offset">, opcional) funciona del mismo modo que para la instrucción <@ref="poisson">. El modelo de Poisson es una forma restringida de la Binomial Negativa en la que α = 0 por construcción. 

Por defecto, las desviaciones típicas se calculan utilizando una aproximación numérica a la matriz Hessiana en la convergencia. Pero si indicas la opción <@opt="--⁠opg">, la matriz de covarianzas se basa en el Producto Externo del vector Gradiente, PEG (OPG), y si indicas la opción <@opt="--⁠robust">, se calculan las desviaciones típicas CMV (QML), utilizando un “emparedado” entre la inversa de la matriz Hessiana y el PEG. 

Menú gráfico: /Modelo/Variable dependiente limitada/Datos de conteo

Instrucción de guión: <@ref="negbin">

# nls Estimation "Mínimos Cuadrados No Lineales"

Realiza la estimación de Mínimos Cuadrados No Lineales (MCNL o NLS) utilizando una versión modificada del algoritmo de Levenberg–Marquardt. Debes proporcionar la especificación de una función; y aunque no es imprescindible, se recomienda que también proporciones las expresiones de las derivadas de esta función con respecto a cada uno de los parámetros, si es posible. Si no ofreces las derivadas, en su lugar debes indicar una lista de los parámetros que se van a estimar (separados por espacios o comas), precedida por la palabra clave <@lit="params">; estos pueden ser bien escalares, bien vectores o bien cualquier combinación de los dos. 

Ejemplo: Supón que tienes un conjunto de datos con las variables <@mth="C"> e <@mth="Y"> (e.g. <@lit="greene11_3.gdt">) y que deseas estimar una función no lineal de consumo con la expresión 

  <@fig="greene_Cfunc">

En primer lugar, debes añadir los parámetros alfa, beta y gamma al conjunto de datos, además de darles unos valores iniciales. Puedes escribir las líneas apropiadas en la ventana de especificaciones de MC No Lineales antes de definir la función. 

En la ventana MC No Lineales, escribes las siguientes líneas: 

<code>          
   C = alfa + beta * Y^gamma
   deriv alfa = 1
   deriv beta = Y^gamma
   deriv gamma = beta * Y^gamma * log(Y)
</code>

La primera línea especifica la función de regresión, y las siguientes 3 líneas proporcionan las derivadas de esa función con respecto a cada parámetro, de uno en uno. Si no indicas las líneas 'deriv', se calcula una aproximación numérica al Jacobiano. 

Si no enuncias previamente los parámetros alfa, beta y gamma, puedes preceder las líneas de arriba con algo como lo siguiente: 

<code>          
   scalar alfa = 1
   scalar beta = 1
   scalar gamma = 1
</code>

Para otros detalles sobre la estimación MCNL (NLS), consulta <@pdf="El manual de gretl#chap:nls"> (Capítulo 22). 

Menú gráfico: /Modelo/Mínimos cuadrados no lineales

Instrucción de guión: <@ref="nls">

# normtest Tests "Contraste de Normalidad"

Realiza un contraste de Normalidad para la <@var="serie"> indicada. El tipo concreto de contraste se controla con el indicador de opción (y se ejecuta el contraste de Doornik–Hansen cuando no indicas ninguna opción). Advertencia: Los contrastes de Doornik–Hansen y Shapiro–Wilk son más recomendables que los otros, teniendo en cuenta sus mejores propiedades en muestras pequeñas. 

Mediante los accesorios <@xrf="$test"> y <@xrf="$pvalue"> puedes recuperar el estadístico de contraste y su probabilidad asociada (valor p), respectivamente. Ten en cuenta que cuando indicas la opción <@opt="--⁠all">, el resultado guardado es el del contraste de Doornik–Hansen. 

Menú gráfico: /Variable/Contraste de Normalidad

Instrucción de guión: <@ref="normtest">

# nulldata Dataset "Generar una base de datos vacía"

Establece un conjunto de datos “en blanco” que: incluye solo una constante más una variable índice, tiene periodicidad 1 y contiene el número de observaciones especificado en el argumento. Puedes utilizar esto con la intención de hacer simulaciones, pues funciones como <@lit="uniform()"> y <@lit="normal()"> generan series artificiales comenzando por el principio, para rellenar el conjunto de datos. Esta instrucción puede ser muy útil en combinación con <@lit="loop">. Consulta también la opción “seed” (semilla) de la instrucción <@ref="set">. 

Por defecto, esta instrucción vacía todos los datos del espacio vigente de trabajo de Gretl, no solo las series sino también las matrices, los escalares, las cadenas de texto, etc. Ahora bien, cuando indicas la opción <@opt="--⁠preserve">, se retiene cualquier variable que no sea una serie y esté definida en ese momento. 

Menú gráfico: /Archivo/Nuevo conjunto de datos

Instrucción de guión: <@ref="nulldata">

# ols Estimation "Mínimos Cuadrados Ordinarios"

Calcula las estimaciones de mínimos cuadrados ordinarios (MCO u OLS) para el modelo especificado. 

Aparte de las estimaciones de los coeficientes y de las desviaciones típicas, el programa también presenta las probabilidades asociadas (valores p) a los estadísticos <@mth="t"> (con dos colas) y <@mth="F">. Un 'valor p' por debajo de 0.01 indica significación estadística a un nivel del 1 por ciento, y se marca con <@lit="***">. La marca <@lit="**"> indica niveles de significación entre 1 y 5 por ciento, y la marca <@lit="*"> indica niveles entre 5 y 10 por ciento. También se presentan los estadísticos para elegir modelos (el Criterio de Información de Akaike o AIC, y el Criterio de Información Bayesiano de Schwarz). La fórmula utilizada para el AIC es la proporcionada por <@bib="Akaike (1974);akaike74">, en concreto, menos dos veces el logaritmo de la verosimilitud maximizada más dos veces el número de parámetros estimados. 

Menú gráfico: /Modelo/Mínimos Cuadrados Ordinarios
Otro acceso: Botón con el símbolo beta en la barra de herramientas

Instrucción de guión: <@ref="ols">

# omit Tests "Excluir variables"

Esta instrucción vuelve a estimar un determinado modelo, bien luego de excluir las variables especificadas, o bien luego de omitir de modo secuencial las variables que no son significativas (si el correspondiente cuadradito está disponible y lo marcas). Aparte del resultado habitual del modelo, presenta un contraste de la significación conjunta de las variables excluidas. La hipótesis nula es que los verdaderos coeficientes de todas las variables excluidas son iguales a cero. 

La eliminación secuencial funciona por pasos, como se indica a continuación. En cada etapa se excluye la variable ligada a la mayor probabilidad asociada (valor p), hasta que todas las que queden, estén ligadas a valores p que no sean mayores que algún valor de corte. Por defecto, este es el 10 por ciento (con 2 colas) y puedes ajustarlo con el botón con flechas arriba/abajo. Este proceso opera automáticamente sobre todas las variables en el modelo (aparte de la constante). Si quieres limitarlo solo a un subconjunto de las variables, marca el cuadradito de “Contrastar solo las variables seleccionadas” y haz la selección. 

Menú gráfico: Ventana de modelo: Contrastes/Omitir variables

Instrucción de guión: <@ref="omit">

# online Dataset "Acceso a bases de datos en línea"

Gretl es capaz de acceder a bases de datos de la Universidad Wake Forest (tu ordenador debe estar conectado a Internet para que esto funcione). 

Bajo el menú “Archivo: Bases de datos”, escoge la opción “Sobre servidor”. Debiera de aparecer una ventana, mostrando un listado de las bases de datos de Gretl disponibles en la Wake Forest. (Dependiendo de tu localización y de la velocidad de tu conexión a Internet, esto puede demorar unos pocos segundos.) Junto con el nombre de la base de datos y una corta descripción, aparece una anotación “Estado local”: esta indica si tienes instalada localmente una de las bases de datos (en el disco duro de tu ordenador) y en caso de ser así, si está o no actualizada en comparación con la versión disponible en el servidor. 

Si tienes una determinada base de datos ya instalada localmente, y está actualizada, no tienes ninguna ventaja accediendo a ella por medio del servidor. Pero para una base de datos que no está aún instalada ni actualizada, podrías querer obtener un listado de sus series de datos; entonces pulsa un clic sobre “Listar las series”. Esto abre una ventana más, desde la que puedes representar los valores de una de las series de datos que elijas, dibujar esos valores o incluso importarlos al espacio de trabajo de Gretl. Puedes completar estas tareas utilizando el menú “Series”, o mediante el menú emergente que aparece cuando pulsas el botón derecho del ratón sobre una determinada serie. También puedes buscar el listado de una variable de interés (en el elemento “Buscar” del menú). 

Si quieres un acceso más rápido a los datos, o deseas acceder a la base de datos fuera de línea, entonces escoge la línea que muestra la base de datos que quieres (en la ventana inicial de la base de datos) y pulsa el botón “Instalar”. Esto va a descargar la base de datos en formato comprimido, luego descomprimirlo e instalarlo en tu disco duro. En adelante ya deberías ser capaz de encontrarlo bajo “Archivo, Bases de datos, Nativa Gretl” en el menú. 

# packages Utilities "Paquetes de funciones"

Puedes ampliar las prestaciones de Gretl mediante la utilización de paquetes de funciones que son de dos tipos: los “Complementos” oficiales y los paquetes de contribuciones. En conjunto, cubren muchos estimadores y utilidades que no están disponibles como instrucciones o funciones integradas en el programa. 

Los 'Complementos' oficiales están incluidos en los instaladores de Gretl para Windows y para Mac. Para Linux, si no se instalan previamente, entonces se descargan cuando se solicite (por ejemplo, si escoges el elemento del menú /Modelo/Series temporales/GARCH, entonces Gretl va a descargar el 'Complemento' <@lit="gig"> (GARCH in Gretl). Puedes verificar que tus 'Complementos' están actualizados mediante <@mnu="SFAddons"> en el menú Ayuda. 

Puedes echar un vistazo a los paquetes de contribuciones instalados en tu ordenador mediante el elemento del menú <@mnu="LocalGfn"> y, si estás conectado a la red, puedes acceder a una lista de paquetes disponibles mediante el elemento <@mnu="RemoteGfn">. Ambos elementos se encuentran bajo el elemento /Archivo/Paquetes de funciones. 

Muchos paquetes proponen agregarse por sí mismos a los menús de la Interface Gráfica de Usuario (GUI). Puedes revisar estas anexiones mediante <@mnu="Registry"> (accede a él mediante el botón de Preferencias en el buscador de paquetes instalados). 

Para obtener detalles completos sobre la instalación y el trabajo con paquetes de funciones, consulta <@mnu="Pkgbook"> (bajo el menú Ayuda). Esta guía también contiene detalles sobre cómo escribir paquetes de funciones. 

# panel Estimation "Modelos de panel"

Estima un modelo de panel. Por defecto, se utiliza el estimador de efectos fijos; esto se pone en práctica restándoles las medias de grupo o unidad, a los datos originales. 

Si marcas el cuadradito de 'Efectos aleatorios', se van a calcular las estimaciones (MCG) de efectos aleatorios. Por defecto, se utiliza el método de Swamy y Arora para la transformación MCG, pero está disponible el método de Nerlove como opción (mediante el botón para desplegar). El método de “Swamy-Arora/Baltagi-Chang” también es una opción adicional, pues en caso de un panel no equilibrado hace una llamada a una modificación del método de Swamy-Arora ideada por <@bib="Baltagi and Chang (1994);baltagi-chang94">. En otro caso, simplemente es equivalente al método normal de Swamy-Arora. 

Para obtener más detalles sobre la estimación de un panel, consulta <@pdf="El manual de gretl#chap:panel"> (Capítulo 20). 

Menú gráfico: /Modelo/Panel

Instrucción de guión: <@ref="panel">

# panel-between Estimation "Modelo entre-grupos"

Este diálogo te permite introducir una especificación para el modelo “between” en el contexto de datos de panel. Esta regresión utiliza las medias de grupo de los datos, ignorando por lo tanto la variación dentro de los grupos. Este modelo raramente resulta de gran interés por si mismo, pero puede serte útil con el fin de hacer comparaciones (por ejemplo, con el modelo de efectos fijos). 

# panel-mode Dataset "Organización de datos de panel"

Este diálogo ofrece hasta 3 opciones con respecto a la definición de un conjunto de datos como un panel. Las dos primeras opciones requieren que el conjunto de datos esté ya organizado en el formato de un panel (incluso aunque Gretl todavía no lo tenga reconocido). La tercera opción requiere que el conjunto de datos contenga variables que representen la estructura de un panel. 

<@itl="Series temporales apiladas">: Supón que <@var="N"> es el total de unidades de sección cruzada del conjunto de datos, y que <@var="T"> = el número observaciones de las series temporales por unidad. Escogiendo esta opción le estás indicando a Gretl que el conjunto de datos se compone en ese momento de <@var="N"> bloques consecutivos de <@var="T"> observaciones de series temporales, uno por cada unidad de sección cruzada. La siguiente etapa será especificar el valor de <@var="N">. 

<@itl="Secciones cruzadas apiladas">: Le estás indicando a Gretl que el conjunto de datos se compone en ese momento de <@var="T"> bloques consecutivos de <@var="N"> observaciones de sección cruzada, uno por cada período de tiempo. La siguiente etapa, de nuevo, será especificar el valor de <@var="N">. 

Si el número total de observaciones del conjunto vigente de datos es primo, no tienes disponibles las opciones de arriba. 

<@itl="Utilizar variables índice">: Estás indicando que el conjunto de datos está organizado en ese momento de modo descuidado (no importa cómo), pero que contiene dos variables que indexan las unidades de sección cruzada y los períodos de tiempo, respectivamente. La siguiente etapa será escoger esas dos variables. Las variables índices de un panel no deben tener nada excepto valores enteros no negativos, sin valores ausentes. Si no hay tales variables en el conjunto de datos, no dispones de esta opción. 

# panel-wls Estimation "Mínimos Cuadrados Ponderados por grupos"

Mínimos cuadrados ponderados por grupos para datos de panel. Calcula las estimaciones de mínimos cuadrados ponderados (MCP o WLS), con las ponderaciones basadas en las varianzas estimadas de la perturbación para las respectivas unidades de sección cruzada de la muestra. 

Cuando seleccionas la opción de iteración, el procedimiento se repite. En cada ciclo, los errores se vuelven a calcular utilizando las estimaciones MCP actuales de los parámetros; con ellos se genera un nuevo conjunto de estimaciones de las varianzas de las perturbaciones y, a partir de ellas, un nuevo conjunto de ponderaciones. Las iteraciones terminan cuando (a) la máxima diferencia en las estimaciones de los parámetros de un ciclo al siguiente, cae por debajo de 0.0001, o (b) el número de iteraciones llega a 20. Si la iteración converge, las estimaciones resultantes son Máximo Verosímiles. 

# pca Statistics "Análisis de Componentes Principales"

Análisis de Componentes Principales. Presenta los autovalores de la matriz de correlaciones (o de la matriz de covarianzas si marcas el cuadradito de opciones) para las variables de <@var="listavariables">, junto con la proporción de la varianza conjunta representada por cada componente. También presenta los correspondientes autovectores (o “pesos de las componentes”). 

En la ventana que presenta los resultados, tienes la posibilidad de guardar las Componentes Principales como series, en el conjunto de datos. 

Menú gráfico: /Ver/Componentes principales

Instrucción de guión: <@ref="pca">

# pergm Statistics "Periodograma"

Calcula y muestra el espectro de la serie especificada. Por defecto, se indica el periodograma de la muestra, pero se utiliza opcionalmente una ventana de retardo de Bartlett al estimar el espectro, (consulta por ejemplo, el libro de Greene <@itl="Econometric Analysis"> para ver una discusión sobre esto). La anchura por defecto de la ventana de Bartlett es de dos veces la raíz cuadrada del tamaño de la muestra, pero puedes establecer esto de modo manual utilizando el parámetro <@var="anchobanda">, hasta un máximo de la mitad del tamaño de la muestra. 

Cuando indicas la opción <@opt="--⁠log">, se representa el espectro en una escala logarítmica. 

Las opciones (mutuamente excluyentes) <@opt="--⁠radians"> y <@opt="--⁠degrees"> afectan al aspecto del eje de frecuencias cuando se dibuja el periodograma. Por defecto, la frecuencia se escala por el número de períodos de la muestra, pero esas dos opciones provocan que el eje se etiquete desde 0 hasta π radianes o desde 0 a 180°, respectivamente. 

Por defecto, si el programa no está en modo de procesamiento por lotes, se muestra un gráfico del periodograma. Puedes ajustar esto mediante la opción <@opt="--⁠plot">. Los parámetros admisibles para esta opción son <@lit="none"> (para suprimir el gráfico), <@lit="display"> (para representar un gráfico incluso en modo de procesamiento por lotes), o un nombre de archivo. El efecto de indicar un nombre de archivo es como se describe para la opción <@opt="--⁠output"> de la instrucción <@ref="gnuplot">. 

Menú gráfico: /Variable/Periodograma
Otro acceso: Ventana principal: Menú emergente (selección única)

Instrucción de guión: <@ref="pergm">

# pkg-depends Programming "Dependencies"

Por “dependencias” queremos referirnos a los paquetes de funciones de los que depende tu propio paquete para alguna de sus funcionalidades; y que, consecuentemente, debes tener descargados e instalados con objeto de que tu paquete funcione correctamente. Puedes especificar hasta cuatro de esos paquetes en este diálogo. 

Por ejemplo, supón que utilizas una o más funciones del paquete <@lit="extra">, que contiene varias utilidades para la redacción con Hansl. En ese caso, podrías escribir 

<code>          
   extra
</code>

en uno de los huecos disponibles (en el primero si no hay ninguna otra dependencia). Observa que debes indicar el nombre 'plano' del paquete, sin poner la ruta completa ni el sufijo <@lit=".gfn"> ni <@lit=".zip">. 

Opcionalmente, puedes marcar la primera dependencia como un “proveedor”. El efecto de esto es el de propiciar que tu paquete tenga acceso a cualquier función privada del paquete especificado. Generalmente, esto no va a hacer falta pero puede serte útil cuando diseñas dos paquetes para que funcionen en estrecha colaboración. 

# polyweights Transformations "Ajustar una tendencia polinómica"

Al ajustar una tendencia polinómica a una serie temporal puedes desear darles un peso adicional a las observaciones del principio y del final de la muestra. (Los puntos en el medio del rango de la muestra tienen vecinos a ambos lados que es probable que estén tirando del ajuste en la misma dirección común.) 

Puedes utilizar los esquemas de ponderación (cuadrático, coseno-campana y por pasos) que se ofrecen aquí con ese propósito. Si escoges uno de estos esquemas, debes elegir dos opciones adicionales. Primero: ¿Qué ponderación máxima se debe utilizar (la mínima ponderación básica es 1.0)? Segundo: ¿A qué fracción central de la muestra se le debe aplicar una ponderación uniforme (la mínima)? 

Supón, por ejemplo, que eliges una ponderación máxima de 3.0 y una fracción central de 0.4. Esto significa que el 40 por ciento central de los datos tienen una ponderación de 1.0. Si seleccionas la forma “steps”, el primer y el último 30 por ciento de las observaciones tienen una ponderación de 3.0; en otro caso, para el primer 30 por ciento de observaciones, las ponderaciones declinan gradualmente desde 3.0 hasta 1.0 y, para el último 30 por ciento, las ponderaciones aumentan desde 1.0 hasta 3.0. 

# poisson Estimation "Estimación de Poisson"

Estima una regresión de Poisson. Se coge la variable dependiente para representar el acaecimiento de sucesos de algún tipo, y debe tener solo valores enteros no negativos. 

Si una variable aleatoria discreta <@mth="Y"> sigue una distribución de Poisson, entonces 

  <@fig="poisson1">

para <@mth="y"> = 0, 1, 2,…. La media y la varianza de la distribución son ambas iguales a <@mth="v">. En el modelo de regresión de Poisson, el parámetro <@mth="v"> está representado como una función de una o más variables independientes. La versión más habitual (y la única que admite Gretl) cumple 

  <@fig="poisson2">

o, en otras palabras, el logaritmo de <@mth="v"> es una función lineal de las variables independientes. 

Como opción, puedes añadir una variable de exposición (“offset”) a la especificación. Esta es una variable de escala, y su logaritmo se añade a la función lineal de regresión (implícitamente, con un coeficiente de 1.0). Esto tiene sentido si esperas que el número de ocurrencias del evento en cuestión es proporcional (manteniéndose lo demás constante) a algún factor conocido. Por ejemplo, puedes suponer que el número de accidentes de tráfico es proporcional al volumen de tráfico (manteniéndose lo demás constante) y, en ese caso, el volumen de tráfico puede expresarse como una variable “de exposición” en un modelo de Poisson del cociente de accidentes. La variable de exposición debe ser estrictamente positiva. 

Por defecto, se calculan las desviaciones típicas utilizando la inversa negativa de la matriz Hessiana. Si especificas la opción <@opt="--⁠robust">, entonces se calculan en su lugar las desviaciones típicas CMV (QML) o de Huber–White. En este caso, la matriz de covarianzas estimada es un “emparedado” entre la inversa de la matriz Hessiana estimada y el producto externo del vector gradiente. 

Consulta también <@ref="negbin">. 

Menú gráfico: /Modelo/Variable dependiente limitada/Datos de conteo

Instrucción de guión: <@ref="poisson">

# probit Estimation "Modelo Probit"

Si la variable dependiente es una variable binaria (todos sus valores son 0 o 1), se obtienen estimaciones máximo verosímiles de los coeficientes de las variables de <@var="indepvars"> mediante el método de Newton–Raphson. Como el modelo es no lineal, las pendientes están condicionadas por los valores de las variables independientes. Por defecto, se calculan las pendientes con respecto a cada una de las variables independientes (en las medias de esas variables) y estas pendientes substituyen a los valores p habituales en el resultado de la regresión. Puedes prescindir de este proceder indicando la opción <@opt="--⁠p-values">. El estadístico chi-cuadrado contrasta la hipótesis nula de que todos los coeficientes son cero, excepto el de la constante. 

Por defecto, las desviaciones típicas se calculan utilizando la inversa negativa de la matriz Hessiana. Si marcas el cuadradito de 'Desviaciones típicas robustas', entonces se calculan en su lugar las desviaciones típicas CMV (QML) o de Huber–White. En este caso, la matriz de covarianzas estimadas es un “emparedado” entre la inversa de la matriz Hessiana estimada y el producto externo del vector gradiente. Consulta el capítulo 10 del libro de Davidson y MacKinnon para obtener más detalles. 

Si la variable dependiente no es binaria sino discreta, entonces se obtienen las estimaciones de un Probit Ordenado. (Si la variable elegida como dependiente no es discreta, se muestra un fallo.) 

<@itl="Probit para datos de panel"> 

Con la opción <@opt="--⁠random-effects">, se asume que cada perturbación está compuesta por dos componentes Normalmente distribuidas: (a) un término invariante en el tiempo que es específico de la unidad de sección cruzada o “individuo” (y que se conoce como efecto individual), y (b) un término que es específico de la observación concreta. 

La evaluación de la verosimilitud de este modelo implica utilizar la cuadratura de Gauss-Hermite para aproximar el valor de las esperanzas de funciones de variables Normales. Puedes escoger el número de puntos de cuadratura utilizados mediante la opción <@opt="--⁠quadpoints"> (por defecto es de 32). Utilizando más puntos se mejora la precisión de los resultados, pero con el coste de más tiempo de cálculo; así, con muchos puntos de cuadratura, la estimación con un conjunto de datos muy grande puede consumir demasiado tiempo. 

Además de las estimaciones habituales de los parámetros (y de los estadísticos asociados) relacionados con los regresores incluidos, se presenta alguna información adicional sobre la estimación de este tipo de modelo: 

<indent>
• <@lit="lnsigma2">: La estimación máximo verosímil del logaritmo de la varianza del efecto individual; 
</indent>

<indent>
• <@lit="sigma_u">: La estimación de la desviación típica del efecto individual; y 
</indent>

<indent>
• <@lit="rho">: La estimación de la parte del efecto individual en la varianza compuesta de la perturbación (también conocida como la correlación intra-clase). 
</indent>

El contraste de Razón de Verosimilitudes respecto a la hipótesis nula de que <@lit="rho"> es igual a cero, proporciona un modo de evaluar si es necesaria la especificación de efectos aleatorios. Si la hipótesis nula no se rechaza, eso sugiere que es adecuada una simple especificación Probit combinada. 

Menú gráfico: /Modelo/Variable dependiente limitada/Probit

Instrucción de guión: <@ref="probit">

# qlrtest Tests "Contraste de Razón de Verosimilitudes de Quandt"

Para un modelo estimado con datos de series temporales mediante MCO, realiza el contraste de la Razón de Verosimilitudes de Quandt (QLR) para un cambio estructural en un punto desconocido en el tiempo, con un 15 por ciento de recorte al comienzo y al final del período de la muestra. 

Para cada punto potencial de cambio dentro del 70 por ciento central de las observaciones, se realiza un contraste de Chow. Consulta <@ref="chow"> para obtener más detalles; pues, de igual modo que con el contraste habitual de Chow, este es un contraste robusto de Wald cuando el modelo original se estima con la opción <@opt="--⁠robust">, y un contraste F en otro caso. Entonces el estadístico QLR es el máximo de los estadísticos de contraste particulares. 

Se obtiene una probabilidad asociada (valor p) asintótica utilizando el método de <@bib="Bruce Hansen (1997);hansen97">. 

Además de los accesorios <@xrf="$test"> y <@xrf="$pvalue"> típicos de los contrastes de hipótesis, puedes utilizar <@xrf="$qlrbreak"> para recuperar el índice de la observación en la que el estadístico de contraste se maximiza. 

Cuando ejecutas de modo interactivo (únicamente) esta instrucción, se muestra por defecto un gráfico del estadístico de contraste de Chow, pero puedes ajustar esto mediante la opción <@opt="--⁠plot">. Los parámetros que se admiten en esta opción son <@lit="none"> (para eliminar el gráfico), <@lit="display"> (para mostrar un gráfico incluso cuando no se está en modo interactivo), o un nombre de archivo. El efecto de proporcionar un nombre de archivo es como el descrito para la opción <@opt="--⁠output"> de la instrucción <@ref="gnuplot">. 

Menú gráfico: Ventana de modelo: Contraste/Contraste de RV de Quandt

Instrucción de guión: <@ref="qlrtest">

# qqplot Graphs "Gráfico Q-Q"

Con una única serie seleccionada, muestra un gráfico de los cuantiles empíricos de esa serie dada, frente a los cuantiles de la distribución Normal. La serie debe incluir cuando menos 20 observaciones válidas en el rango vigente de la muestra. Por defecto, los cuantiles empíricos se dibujan frente a los cuantiles de una distribución Normal que tiene las mismas media y varianza que los datos de la muestra, pero dispones de dos alternativas: puedes tipificar los datos (convertirlos en puntuaciones z) antes de dibujarlos, o puedes dibujar los cuantiles empíricos “en bruto” frente a los cuantiles de la distribución Normal estándar. 

La opción <@opt="--⁠output"> tiene como efecto el envío del resultado al archivo especificado; utiliza “display” para forzar que el resultado se presente en la pantalla. Consulta la instrucción <@ref="gnuplot"> para obtener más detalles sobre esta opción. 

Dadas dos series como argumentos, <@var="y"> y <@var="x">, se muestra un gráfico de los cuantiles empíricos de <@var="y"> frente a los de <@var="x">. Los valores de los datos no se tipifican. 

Menú gráfico: /Variable/Gráfico Q-Q normal
Menú gráfico: /Ver/Gráficos/Gráfico Q-Q

Instrucción de guión: <@ref="qqplot">

# quantreg Estimation "Regresión de cuantiles"

Regresión de cuantiles. Por defecto, las desviaciones típicas se calculan de acuerdo con la fórmula asintótica indicada por <@bib="Koenker y Bassett (1978);koenker-bassett78">, pero si marcas el cuadradito de “Desviaciones típicas robustas”, se utiliza la variante robusta a la heterocedasticidad de <@bib="Koenker y Zhao (1994);koenker-zhao94">. 

Si marcas la opción “Calcular los intervalos de confianza”, Gretl calcula los intervalos de confianza para los coeficientes en lugar de las desviaciones típicas. Y el cuadradito de validación de “Desviaciones típicas robustas” tiene otro efecto: si no se marca, los intervalos se calculan bajo el supuesto de perturbaciones IID; y al marcarlo, Gretl utiliza el estimador robusto desarrollado por <@bib="Koenker y Machado (1999);koenker-machado99">. Ten en cuenta que estos intervalos no son exactamente “más o menos tantas desviaciones típicas” pues, en general, son asimétricos respecto a las estimaciones puntuales de los coeficientes. 

Puedes indicar una lista de cuantiles (consulta la lista desplegable para algunas posibilidades ya definidas con anterioridad). En ese caso, Gretl calcula las estimaciones de cuantiles y, o bien las desviaciones típicas o bien los intervalos de confianza para cada uno de los valores especificados. 

Para seguir la pista de las referencias indicadas arriba, consulta <@pdf="El manual de gretl#chap:quantreg"> (Capítulo 36). 

Menú gráfico: /Modelo/Estimación Robusta/Regresión de cuantil

Instrucción de guión: <@ref="quantreg">

# reprobit Estimation "Probit de efectos aleatorios"

El estimador Probit de efectos aleatorios proporciona un medio de estimar un modelo Probit (binario) con datos de panel. Se asume que cada perturbación está compuesta por dos componentes Normalmente distribuidas: (a) un término invariante respecto al tiempo que es especifico de la unidad de sección cruzada o “individuo” (y que se conoce como efecto individual), y (b) un término que es específico de la observación concreta. 

La evaluación de la verosimilitud de este modelo implica utilizar la cuadratura de Gauss-Hermite para aproximar el valor de las esperanzas de funciones de variables Normales. En este diálogo, puedes escoger el número de puntos de cuadratura utilizados. Usando más puntos se mejora la precisión de los resultados, pero con el coste de mayor tiempo de cálculo; así con muchos puntos de cuadratura, la estimación con un conjunto de datos muy grande puede consumir demasiado tiempo. 

Además de las estimaciones habituales de los parámetros (y de los estadísticos asociados) relacionados con los regresores incluidos, se presenta alguna información adicional sobre la estimación de este tipo de modelo: 

<indent>
• <@lit="lnsigma2">: La estimación máximo verosímil del logaritmo de la varianza del efecto individual; 
</indent>

<indent>
• <@lit="sigma_u">: La estimación de la desviación típica del efecto individual; y 
</indent>

<indent>
• <@lit="rho">: La estimación de la parte del efecto individual en la varianza compuesta de la perturbación (también conocida como la correlación intra-clase). 
</indent>

El contraste de Razón de Verosimilitudes respecto a la hipótesis nula de que <@lit="rho"> es igual a cero, proporciona un modo de evaluar si es necesaria la especificación de efectos aleatorios. Si la hipótesis nula no se rechaza, eso sugiere que es adecuada una simple especificación Probit combinada. 

En modo guion, el modelo Probit de efectos aleatorios se estima utilizando la instrucción <@lit="probit"> con la opción <@opt="--⁠random-effects">. 

# reset Tests "RESET de Ramsey"

Debe ir después de la estimación de un modelo mediante MCO. Lleva a cabo el contraste RESET de Ramsey sobre la especificación (no lineal) de un modelo, añadiéndole a la regresión los cuadrados y/o los cubos de los valores ajustados, y calculando el estadístico <@mth="F"> para contrastar la hipótesis nula de que los parámetros de los términos añadidos son cero. 

Menú gráfico: Ventana de modelo: Contrastes/Contraste RESET de Ramsey

Instrucción de guión: <@ref="reset">

# restrict-model Tests "Restricciones en un modelo"

Debes expresar cada restricción del conjunto como una ecuación, con una combinación lineal de parámetros a la izquierda del signo de igualdad y un valor numérico a la derecha. Puedes referirte a sus parámetros con el formato <@lit="b["><@var="i"><@lit="]">, donde <@var="i"> representa la posición en la lista de regresores (comenzando en el 1), o con el formato <@lit="b["><@var="nombrevar"><@lit="]">, donde <@var="nombrevar"> es el nombre del regresor en cuestión. 

Puedes anteponer multiplicadores numéricos a los elementos <@lit="b"> de la ecuación que representa una restricción, utilizando <@lit="*"> para indicar la multiplicación, por ejemplo <@lit="3.5*b[4]">. 

Aquí tienes un ejemplo de un conjunto de restricciones: 

<code>          
   b[1] = 0
   b[2] - b[3] = 0
   b[4] + 2*b[5] = 1
</code>

# restrict-system Tests "Restricciones en un sistema de ecuaciones"

Debes expresar cada restricción del conjunto como una ecuación, con una combinación lineal de parámetros a la izquierda del signo de igualdad y un valor numérico a la derecha. La referencia a los parámetros se hace utilizando la letra <@lit="b"> junto con dos números colocados entre corchetes. El primer número representa la posición de la ecuación dentro del sistema, y el segundo número indica la posición del regresor dentro de la lista de ellos, comenzando por 1 en ambos casos. Por ejemplo, <@lit="b[2,1]"> denota el primer parámetro de la segunda ecuación, mientras que <@lit="b[3,2]"> denota el segundo parámetro de la tercera ecuación. 

Puedes anteponer multiplicadores numéricos a los elementos <@lit="b"> de la ecuación que representa una restricción, utilizando <@lit="*"> para indicar la multiplicación, por ejemplo <@lit="3.5*b[1,4]">. 

Aquí tienes un ejemplo de un conjunto de restricciones: 

<code>          
   b[1,1] = 0
   b[1,2] - b[2,2] = 0
   b[3,4] + 2*b[3,5] = 1
</code>

# restrict-vecm Tests "Restricciones en un VECM"

Utiliza esta instrucción para establecer restricciones lineales sobre las relaciones de cointegración (beta) y/o los coeficientes de ajuste (alfa) en un Modelo de Vectores de Corrección del Error (VECM). 

Debes expresar cada restricción del conjunto como una ecuación, con una combinación lineal de parámetros a la izquierda del signo de igualdad y un valor numérico a la derecha. Las restricciones sobre beta pueden ser no homogéneas (con valores distintos de cero a la derecha), pero las restricciones sobre alfa deben ser homogéneas (con ceros a la derecha). 

Si el VECM es de rango 1, la referencia a los parámetros se hace utilizando el formato <@lit="b["><@var="i"><@lit="]">, donde <@var="i"> representa la posición en el vector de cointegración, comenzando en 1. Por ejemplo, <@lit="b[2]"> denota el segundo elemento de beta. Pero si el rango es mayor que 1, utiliza <@lit="b"> junto con dos números colocados entre corchetes. Por ejemplo, <@lit="b[2,1]"> denota el primer elemento del segundo vector de cointegración. 

Para referirte a los elementos de alfa, utiliza <@lit="a"> en vez de <@lit="b">. 

Puedes anteponer multiplicadores numéricos a los identificadores de los parámetros de la ecuación que representa una restricción, utilizando <@lit="*"> para indicar la multiplicación, por ejemplo <@lit="3.5*b[4]">. 

Aquí tienes un ejemplo de un conjunto de restricciones en un VECM de rango 1. 

<code>          
   b[1] + b[2] = 0
   b[1] + b[3] = 0
</code>

Consulta también <@pdf="El manual de gretl#chap:vecm"> (Capítulo 30). 

# rmplot Graphs "Gráfico Rango-Media"

Gráfico Rango–Media: Esta instrucción genera un gráfico sencillo para ayudar a decidir si una serie temporal, <@mth="y">(t), tiene una varianza constante o no. Se coge la muestra completa (t=1,...,T) y se divide en pequeñas submuestras de tamaño arbitrario <@mth="k">. La primera submuestra está compuesta por <@mth="y">(1),...,<@mth="y">(k), la segunda por <@mth="y">(k+1), ..., <@mth="y">(2k), etcétera. Para cada submuestra, se calcula la media de la serie en la muestra y el rango (= máximo menos mínimo), y se construye un gráfico con las medias en el eje horizontal y los rangos en el vertical. Así cada submuestra se representa mediante un punto en este plano. Si la varianza de la serie es constante, se esperaría que el rango de la submuestra sea independiente de la media de la submuestra. Por eso, si observamos que los puntos se aproximan a una línea con pendiente positiva, esto sugiere que la varianza de las series aumenta a medida que lo hace la media; y si los puntos se aproximan a una línea con pendiente negativa, esto sugiere que la varianza decrece al aumentar la media. 

Además del gráfico, Gretl muestra las medias y rangos para cada submuestra, junto con el coeficiente de la pendiente de una regresión MCO do rango sobre la media, y con la probabilidad asociada al estadístico para contrastar la hipótesis nula de que esta pendiente es cero. Si el coeficiente de la pendiente es significativo con un nivel de significación del 10 por ciento, entonces se muestra en el gráfico la línea ajustada de la regresión del rango sobre la media. Se registran tanto el estadístico <@mth="t"> para contrastar la hipótesis nula como la probabilidad asociada correspondiente, y puedes recuperarlos usando los accesorios <@xrf="$test"> y <@xrf="$pvalue">, respectivamente. 

Menú gráfico: /Variable/Gráfico rango-media

Instrucción de guión: <@ref="rmplot">

# runs Tests "Contraste de rachas"

Realiza el contraste no paramétrico “de rachas” para comprobar el carácter aleatorio de la <@var="serie"> indicada, donde las rachas se definen como secuencias de valores consecutivos positivos o negativos. Si quieres contrastar el carácter aleatorio de las desviaciones respecto a la mediana, para una variable llamada <@lit="x1"> que tiene una mediana no nula, puedes hacer lo siguiente: 

<code>          
   series signx1 = x1 - median(x1)
   runs signx1
</code>

Cuando indicas la opción <@opt="--⁠difference">, se van a calcular las primeras diferencias de la serie antes del análisis, por lo que las rachas se interpretarían como secuencias de aumentos o de diminuciones consecutivas del valor de la variable. 

Cuando indicas la opción <@opt="--⁠equal">, la hipótesis nula también incorpora el supuesto de que los valores positivos y negativos son igual de probables; de lo contrario, el estadístico de contraste resulta invariante con respecto a la “neutralidad” del proceso que generó la secuencia de valores, y el contraste se centra únicamente en la independencia. 

Menú gráfico: /Herramientas/Contrastes no paramétricos

Instrucción de guión: <@ref="runs">

# sampling Dataset "Configurando la muestra"

El menú Muestra ofrece varios modos de seleccionar una submuestra del conjunto vigente de datos. 

Si escoges “Muestra/Restringir, a partir del criterio...” es necesario que indiques una expresión booleana (lógica), del mismo tipo que usarías para definir una variable ficticia. Por ejemplo, la expresión “sqft > 1400” seleccionará solo los casos en los que la variable 'sqft' tiene un valor mayor que 1400. Puedes encadenar las condiciones utilizando los operadores lógicos “&&” (AND) y “||” (OR), y puedes aplicar la negación utilizando “!” (NOT). Si el conjunto de datos ya contiene variables ficticias, también tienes la posibilidad de escoger una de ellas para definir la muestra (las observaciones que tengan el valor 1 en la variable ficticia escogida, se van a incluir, y las otras se van a excluir). 

El elemento del menú “Muestra/Quitar todas las observaciones con valores ausentes” vuelve a definir la muestra, para excluir todas las observaciones para las que los valores de una o más variables están ausentes (dejando solo los casos completos). 

Para seleccionar observaciones para las que una variable concreta tiene valores no ausentes, usa “Restringir, a partir del criterio...” e indica la condición booleana “!missing(nombrevar)” (substituye “nombrevar” con el nombre de la variable que quieras usar). 

Si las observaciones tienen etiquetas, puedes excluir observaciones concretas utilizando, por ejemplo, <@lit="obs!="Francia""> como criterio booleano. Debes delimitar el nombre de la observación con comillas. 

Debes tener en cuenta la siguiente cuestión en relación a la definición de una muestra en base a una variable ficticia, a una expresión booleana o al criterio de valores ausentes. Cualquier información “estructural” en el archivo cabecera de los datos se pierde (en relación a la temporalidad de las series o a la naturaleza de panel de los datos). Pero puedes volver a forzar la estructura con el elemento “Estructura del conjunto de datos” del menú de Datos. 

Consulta <@pdf="El manual de gretl#chap:sampling"> (Capítulo 5) para obtener otros detalles. 

# save-labels Utilities "Guardar o eliminar etiquetas de las series"

Si escoges aquí 'Exportar', Gretl escribe un archivo que contiene las etiquetas descriptivas de cualquier serie (que tenga etiquetas) del conjunto vigente de datos. Ese archivo es de texto plano con una línea por variable, pero la línea estará vacía para las variables que no tengan etiqueta descriptiva. 

Cuando escoges 'Borrar', se eliminan las etiquetas descriptivas de todas las series que tengan etiquetas. Esto únicamente será oportuno en caso de que las etiquetas actuales se añadieran de algún modo debido a un fallo. 

# add-labels Utilities "Añadir etiquetas de las series"

Si aquí escoges la opción 'Si', se te ofrece una caja de diálogo para abrir archivos, con el fin de que selecciones uno de texto plano que contenga las etiquetas descriptivas para las series del conjunto vigente de datos. El archivo deberá contener una etiqueta por línea, y una línea en blanco significará que no hay etiqueta. Gretl tratará de leer tantas etiquetas como series haya en el conjunto de datos, excluyendo la constante. 

# save-script Utilities "¿Guardar instrucciones?"

Si aquí escoges 'Si', Gretl escribe un archivo que contiene un registro de las instrucciones que ejecutaste en la sesión vigente. La mayor parte de las instrucciones que ejecutas mediante “apuntar y hacer clic” tienen una contrapartida de “guion”, y estas instrucciones de guion son las que se guardarán. Así podrás coger el archivo como base para escribir un guion de instrucciones de Gretl. 

Si no te importa que se te avise para guardar un registro de las instrucciones al salir, no pongas la marca en la caja del diálogo para guardar instrucciones. 

# save-session Utilities "¿Guardar esta sesión de Gretl?"

Si aquí escoges 'Sí', Gretl escribe un archivo que contiene una “foto instantánea” de la sesión vigente, incluyendo una copia del conjunto de datos con el que se trabaja, junto con cualquier modelo, gráfico u otro objeto que guardaras “como icono”. Puedes volver a abrir este archivo más tarde para recrear el estado de Gretl tal como era en el momento en el que saliste de la sesión (consulta el menú “Archivo/Archivos de sesión”). 

Si trabajas con Gretl utilizando la mayoría de las veces guiones de instrucciones (lo que se recomienda para un trabajo econométrico “serio”), probablemente no necesites guardar la sesión, pero debes asegurarte de guardar cualquier cambio en tu guion, que quieras mantener. También puedes querer guardar cualquier cambio en tu conjunto de datos, excepto que sea de un tipo que puedas repetir fácilmente ejecutando un guion. 

Si trabajas con guiones y no te importa que se te avise para guardar tu sesión al salir, no pongas la marca en la caja del diálogo para guardar sesión. 

# scatters Graphs "Varios gráficos de dos variables"

Genera gráficos de dos variables, de la “Variable del eje Y” escogida, frente a cada una de las “Variables del eje X” escogidas, una por una. (O puedes escoger varias variables para el eje Y y una para el eje X.) Repasar un conjunto de esos gráficos puede ser un paso conveniente en el análisis exploratorio de datos. El número máximo de gráficos es de 16, por lo que se va a ignorar cualquier variable adicional en la lista. 

Cuando el conjunto de datos es de series temporales, entonces puedes omitir la segunda lista, pues en ese caso se va a tomar implícitamente al 'tiempo' como tal, por lo que puedes dibujar varias series temporales en gráficos separados. 

Menú gráfico: /Ver/Gráficos múltiples

Instrucción de guión: <@ref="scatters">

# script-editor Utilities "Preferencias del editor de guiones"

Ten en cuenta que algunas de estas preferencias solo se aplican cuando se editan guiones de Gretl originales (Tabulador e Intro inteligentes, Usar pestañas en el editor de guiones), y que otras también se aplican cuando se edita o mira cualquier guion (Mostrar los números de línea, Estilo de resaltado). 

<@itl="Tabulador e Intro inteligentes">: Si marcas esta opción, entonces cuando pulsas la tecla <@lit="Tabulador"> al comienzo de una línea en un guion de Hansl, en lugar de introducir tan solo un salto de tabulación, el programa va a tratar de ajustar el nivel de sangrado de la línea consistentemente con otras líneas que ya se hayan introducido antes. Igualmente, cuando pulsas la tecla <@lit="Intro">, el programa va a tratar de asegurar que el sangrado de la línea completada es correcta. 

<@itl="Mostrar los números de línea">: Presenta los números de línea en el margen izquierdo del editor de guiones o del visor. 

<@itl="Usar pestañas en el editor de guiones">: Afecta al comportamiento del programa cuando estés editando más de un guion al mismo tiempo. Si marcas esto, entonces se muestra cada guion en una “pestaña” de una ventana con estilo de cuaderno de notas; y en otro caso, cada guion tiene su propia ventana. 

<@itl="Activar autocompletado">: Si marcas esto, se te ofrecerá la posibilidad de completar la palabra que estés tecleando, en base a las palabras que ya has introducido en la ventana o pestaña del editor. Para escoger una de las posibilidades, utiliza las teclas de flechas arriba/abajo y la tecla <@lit="Intro">; o simplemente sigue tecleando para descartar los términos sugeridos. 

<@itl="Activar paréntesis automáticos">: Si marcas esto, entonces cuando tecleas un paréntesis, corchete o llave izquierdos al final de una línea, se va a añadir automáticamente el delimitador correspondiente del lado derecho, y se va a colocar el cursor entre los dos delimitadores. 

<@itl="Número de espacios por tabulador">: ¿Cuánto quieres que sea la longitud de un salto de tabulador o del nivel de sangría? Un valor entero de 2 a 8. 

<@itl="Estilo de resaltado">: Proporciona una lista que se despliega hacia abajo, con estilos para resaltar la sintaxis. Algunos de estos son 'oscuro sobre claro' y algunos son 'claro sobre oscuro': experimenta y encuentra el que te guste. 

# setinfo Dataset "Editar los atributos de una variable"

En esta caja de diálogo puedes: 

* Renombrar una variable (tipo serie). 

* Añadir o editar la descripción de la variable que aparece al lado del nombre de estas, en la ventana principal de Gretl. 

* Añadir o editar el 'nombre a mostrar' de una variable (si la variable es una serie, no un escalar). Esta cadena de texto (de 19 caracteres como máximo) se muestra en lugar del nombre de la variable, cuando esta se representa en un gráfico. Así, por ejemplo, puedes asociar una cadena más comprensible tal como 'Tipo de la letra del tesoro' con una variable nombrada abreviadamente 'tb3'. 

* Determinar el método para compactar una variable (para datos de series temporales). Ese método se va a utilizar cuando decidas reducir la frecuencia del conjunto de datos, o cuando actualices una variable importándola de una base de datos donde esa variable tiene una frecuencia mayor que en el conjunto de datos de trabajo. 

* Marcar una variable como discreta (para series que solo tienen valores enteros). Esto afecta al modo en el que se maneja la variable cuando pides un gráfico de frecuencias. 

Menú gráfico: /Variable/Editar atributos
Otro acceso: Ventana principal: Menú emergente

Instrucción de guión: <@ref="setinfo">

# setmiss Dataset "Código de valor ausente"

Establece un valor numérico que va a interpretarse como 'ausente' o 'no aplicable', bien para una serie de datos en concreto (bajo el menú Variable) o globalmente para todo el conjunto de datos (bajo el menú Datos). 

Gretl tiene su propia codificación interna para los valores ausentes, pero a veces con los datos que se importan se pudo emplear un código diferente. Por ejemplo, si una serie en concreto está codificada de modo que el valor -1 significa 'no aplicable', puedes seleccionar 'Establecer código de valor ausente' bajo el menú Variable, y teclear el valor '-1' (sin comillas). Entonces Gretl leerá los valores -1 como observaciones ausentes. 

Menú gráfico: /Datos/Establecer código de valor ausente

Instrucción de guión: <@ref="setmiss">

# spearman Statistics "Correlación por rangos de Spearman"

Presenta el coeficiente de la correlación por rangos de Spearman para un par especificado de series. No tienes que jerarquizar manualmente las series por adelantado, pues la función ya se ocupa de ello. 

La forma automática de jerarquizar es de mayor a menor (i.e. el valor más grande de los datos adquiere el rango 1). Si necesitas invertir esta forma de jerarquizar, genera una nueva variable que sea la negativa de la original. Por ejemplo: 

<code>          
   series altx = -x
   spearman altx y
</code>

Menú gráfico: /Herramientas/Contrastes no paramétricos/Correlación

Instrucción de guión: <@ref="spearman">

# store Dataset "Guardar los datos"

Guarda los datos en <@var="nombrearchivo">. Por defecto, se guardan todas las series ya definidas en ese momento, pero puedes utilizar el argumento <@var="listavariables"> (opcional) para escoger un subconjunto de series. Si el conjunto de datos es una submuestra, solo se guardan las observaciones del rango vigente de la muestra. 

El archivo resultante va a escribirse en el directorio (<@ref="workdir">) establecido en ese momento, excepto que la cadena <@var="nombrearchivo"> contenga una especificación completa de la ruta. 

Hasta cierto punto, puedes controlar el formato en el que se escriben los datos mediante la extensión o sufijo de <@var="nombrearchivo">, como se indica a continuación: 

<indent>
• <@lit=".gdt"> (o sin extensión): Formato de datos XML propio de Gretl. (Si no indicas ninguna extensión, automáticamente se añade “<@lit=".gdt">”) 
</indent>

<indent>
• <@lit=".gtdb">: Formato de datos binario propio de Gretl. 
</indent>

<indent>
• <@lit=".csv">: Valores Separados por Comas (CSV). 
</indent>

<indent>
• <@lit=".txt"> o <@lit=".asc">: valores separados por espacios. 
</indent>

<indent>
• <@lit=".m">: Formato matricial GNU Octave. 
</indent>

<indent>
• <@lit=".dta">: Formato dta de Stata (versión 113). 
</indent>

Puedes usar los indicadores de opción relacionados con el formato que se muestran arriba para forzar la cuestión del formato cuando se guarda, con independencia del nombre del archivo (o para lograr que Gretl escriba en los formatos de PcGive o JMulTi). Sin embargo, si <@var="nombrearchivo"> tiene una extensión <@lit=".gdt"> o <@lit=".gdtb">, esto implica utilizar necesariamente el formato propio, y si añades un indicador de opción conflictivo, va a generarse un fallo. 

Cuando guardas los datos en el formato propio (únicamente), puedes utilizar la opción <@opt="--⁠gzipped"> para comprimir los datos, lo que puede ser muy útil para conjuntos grandes de datos. El parámetro (opcional) de esta opción controla el nivel de compresión (de 0 a 9): los niveles más altos producen un archivo más pequeño, pero la compresión lleva más tiempo. El nivel por defecto es 1, y un nivel igual a 0 significa que no se aplica ninguna compresión. 

Los indicadores de opción <@opt="--⁠omit-obs"> y <@opt="--⁠no-header"> son solo aplicables cuando se guardan datos en el formato CSV. Por defecto, si los datos son series temporales o de panel, o si el conjunto de datos incluye marcadores específicos de observación, el archivo CSV incluye una primera columna que identifica las observaciones (e.g. por fecha). Cuando indicas la opción <@opt="--⁠omit-obs">, esta columna se omite. La opción <@opt="--⁠no-header"> elimina la habitual representación de los nombres de las variables en el encabezamiento de las columnas. 

El indicador de opción <@opt="--⁠decimal-comma"> está también limitado al caso de que se guarden los datos en formato CSV. El efecto de esta opción consiste en substituir el punto decimal con la coma decimal; y, por añadido, se fuerza a que el separador de columnas sea el punto y coma. 

La posibilidad de guardar en el formato de base de datos de Gretl está pensada para ayudar a construir conjuntos largos de series, tal vez mezclando frecuencias y rangos de observaciones. En este momento, esta opción solo está disponible para datos de series temporales de tipo anual, trimestral o mensual. Si guardas en un archivo que ya existe, el efecto por defecto consiste en añadir las series recientemente guardadas al contenido existente en la base de datos. En este contexto, es un fallo que una (o más) de las variables que se van a guardar tenga el mismo nombre que una variable que ya está presente en la base de datos. La opción <@opt="--⁠overwrite"> tiene como consecuencia que, si hay nombres de variables en común, la variable recientemente guardada substituye a la variable del mismo nombre en el conjunto de datos original. 

La opción <@opt="--⁠comment"> está disponible cuando se guardan datos como base de datos o en formato CSV. El parámetro que se requiere es una cadena en una línea, entre comillas, ligada al indicador de opción mediante un signo de igualdad. La cadena de texto se inserta como comentario en el archivo índice de la base de datos o en el encabezamiento del CSV. 

La instrucción <@lit="store"> se comporta de modo especial en el contexto de un “bucle progresivo”. Consulta <@pdf="El manual de gretl#chap:looping"> (Capítulo 12) para obtener más detalles. 

Menú gráfico: /Archivo/Guardar datos; /Archivo/Exportar datos

Instrucción de guión: <@ref="store">

# system Estimation "Sistemas de ecuaciones"

En esta ventana puedes definir un sistema de ecuaciones y escoger un estimador para el sistema. Aquí puedes indicar 4 tipos de enunciado, como los siguientes: 

<indent>
• <@ref="equation">: Especifica una ecuación del sistema. 
</indent>

<indent>
• <@lit="instr">: Para estimar un sistema mediante Mínimos Cuadrados en 3 etapas, se indica una lista de instrumentos (mediante el nombre de la variable o su número). Alternativamente, puedes poner esta información en la línea <@lit="equation"> usando la misma sintaxis que en la instrucción <@ref="tsls">. 
</indent>

<indent>
• <@lit="endog">: Para un sistema de ecuaciones simultáneas, se indica una lista de variables endógenas. En principio, esto está pensado para utilizar con la estimación FIML, pero puedes utilizar este enfoque con Mínimos Cuadrados en 3 Etapas en lugar de indicar una lista <@lit="instr">; y entonces todas las variables que no se identifiquen como endógenas, se van a utilizar como instrumentos. 
</indent>

<indent>
• <@lit="identity">: Para utilizar con Máxima Verosimilitud con Información Completa (MVIC, FIML), se indica una identidad que enlaza dos o más variables del sistema. Este tipo de enunciado se ignora cuando se utiliza un estimador diferente al de MVIC. 
</indent>

Menú gráfico: /Modelo/Ecuaciones simultáneas

Instrucción de guión: <@ref="system">

# tobit Estimation "Modelo Tobit"

Estima un modelo Tobit, que puede ser lo adecuado cuando la variable dependiente está “censurada”. Por ejemplo, cuando se observan valores positivos y nulos en la adquisición de bienes duraderos por parte de los hogares, y ningún valor negativo, puede llegar a pensarse que las decisiones sobre esas compras son el resultado de una disposición subyacente e inobservada a comprar, que puede ser negativa en algunos casos. 

Por defecto, se asume que la variable dependiente está 'censurada' en el cero por la izquierda, y que no está 'censurada' por la derecha. Sin embargo, puedes usar las cajas de anotación marcadas “Cota izquierda” y “Cota derecha” para especificar un patrón diferente de censura. Introduce un valor numérico o <@lit="NA"> para no hacer censura. 

El modelo Tobit es un caso especial de la regresión de intervalos. Consulta la instrucción <@ref="intreg"> para obtener detalles adicionales, incluída una explicación de las opciones <@opt="--⁠robust"> y <@opt="--⁠opg">. 

Menú gráfico: /Modelo/Variable dependiente limitada/Tobit

Instrucción de guión: <@ref="tobit">

# transpos Dataset "Trasponer los datos"

Transpone el conjunto vigente de datos. Es decir, cada observación (fila) del conjunto vigente de datos se va a tratar como una variable (columna), y cada variable como una observación. Esta instrucción puede resultar útil cuando se leen los datos de algún origen externo, en el que las filas de la tabla de datos representan variables. 

Consulta también <@ref="dataset">. 

Menú gráfico: /Datos/Transponer datos

# tsls Estimation "Regresión con Variables Instrumentales"

La instrucción requiere que se seleccionen 2 listas de variables: las variables independientes que aparecen en el modelo indicado y un conjunto de instrumentos. Ten en cuenta que cualquier regresor exógeno debe aparecer en ambas listas. 

El resultado de las estimaciones de Mínimos Cuadrados en 2 Etapas incluyen el contraste de Hausman y (si el modelo está sobreidentificado) el contraste de sobreidentificación de Sargan. En el contraste de Hausman, la hipótesis nula es que las estimaciones MCO son consistentes o, en otras palabras, que la estimación por medio de variables instrumentales en realidad no es necesaria. Un modelo de este tipo está sobreidentificado si hay más instrumentos de los que estrictamente se requieren. El contraste de Sargan se basa en una regresión auxiliar de los errores de la estimación del modelo por Mínimos Cuadrados en 2 Etapas sobre la lista completa de instrumentos. La hipótesis nula es que todos los instrumentos son válidos, y se sospecha de la validez de esta hipótesis si la regresión auxiliar tiene un grado de poder explicativo que es significativo. Para una buena explicación de los dos contrastes, consulta el capítulo 8 de <@bib="Davidson y MacKinnon (2004);davidson-mackinnon04">. 

Tanto para MC2E (TSLS) como para la estimación MVIL (LIML), se muestra el resultado de un contraste adicional, puesto que el modelo se estima bajo el supuesto de perturbaciones IID (es decir, no se escoge la opción <@opt="--⁠robust">). Este es un contraste de la debilidad de los instrumentos, pues instrumentos débiles pueden llevar a serios problemas en la regresión de VI: estimaciones sesgadas y/o tamaño incorrecto de los contrastes de hipótesis basados en la matriz de covarianzas, con tasas de rechazo que superan mucho el nivel de significación nominal <@bib="(Stock, Wright y Yogo, 2002);stock-wright-yogo02">. El estadístico es el del contraste <@mth="F"> de la primera etapa si el modelo tiene tan solo un regresor endógeno; de lo contrario, es el valor propio más pequeño de la matriz de contrapartida del <@mth="F"> de la primera etapa. Se muestran los puntos críticos basados en el análisis Monte Carlo de <@bib="Stock y Yogo (2003);stock-yogo03">, cuando estén disponibles. 

El valor de R-cuadrado que se presenta para modelos estimados mediante Mínimos Cuadrados en 2 Etapas es el cuadrado de la correlación entre la variable dependiente y la variable con los valores ajustados. 

Menú gráfico: /Modelo/Variables instrumentales

Instrucción de guión: <@ref="tsls">

# var Estimation "Autorregresión de vectores (VAR)"

Esta instrucción requiere la especificación de: 

<indent>
• el orden de retardos, es decir, el número de retardos de cada variable que debería de incluirse en el sistema; 
</indent>

<indent>
• cualquier variable exógena (pero ten en cuenta que se incluye una constante automáticamente, excepto que indiques otra cosa; puedes añadir una tendencia usando el recuadro de selección de tendencia; y puedes añadir variables ficticias estacionales usando el recuadro de selección de la estacionalidad); y 
</indent>

<indent>
• una lista de variables endógenas, de las que se incluyen sus retardos en el lado derecho de cada ecuación. (Nota: No incluyas variables retardadas en esta lista, pues se van a añadir automáticamente). 
</indent>

Se va a ejecutar una regresión por separado para cada variable del sistema. El resultado para cada ecuación incluye los contrastes F de restricciones cero sobre todos los retardos de cada una de las variables; y un contraste F para el retardo máximo, junto con (opcionalmente) las descomposiciones de la varianza de predicción y las funciones de respuesta al impulso. 

Las descomposiciones de la varianza de la predicción y las respuestas al impulso se basan en la descomposición de Cholesky de la matriz de covarianzas contemporánea y, en este contexto, tiene importancia el orden en el que indicas las variables (estocásticas). Así, la primera variable de la lista se asume que es la “más exógena” dentro del período. Puedes establecer el horizonte para las descomposiciones de la varianza y las respuestas al impulso, utilizando la instrucción <@ref="set">. Para recuperar una función concreta de respuesta al impulso en forma matricial, consulta la función <@xrf="irf">. 

Menú gráfico: /Modelo/Series temporales/Multivariante

Instrucción de guión: <@ref="var">

# VAR-lagselect Tests "Selección de la longitud de retardos del VAR"

En esta caja de diálogo especifica un VAR como siempre, pero utiliza el botón (con flechas arriba/abajo) del orden de retardos, para indicar el número máximo a probar. 

El resultado consiste en una tabla que muestra los valores de los criterios de información de Akaike (AIC), Schwarz (BIC) y Hannan–Quinn (HQC), calculados para VARs de órdenes desde 1 hasta el máximo indicado. Esto trata de ayudar en la selección del orden óptimo de retardos. 

# VAR-omit Tests "Contrastar las variables exógenas de un VAR"

Utiliza esta caja de diálogo para especificar un subconjunto de variables exógenas de un VAR. Estas variables se van a quitar del VAR original, y el sistema vuelve a estimarse. 

Se presenta un contraste de Razón de Verosimilitudes, en el que la hipótesis nula es que los verdaderos valores de los parámetros de las variables omitidas son cero, en todas las ecuaciones del VAR. El contraste se basa en la diferencia entre el logaritmo del determinante de la matriz de varianzas del sistema sin restringir, y el del sistema restringido omitiendo las variables elegidas. 

# vartest Tests "Contrastar la diferencia de varianzas"

Calcula el estadístico <@mth="F"> para contrastar la hipótesis nula de que las varianzas poblacionales de las dos series elegidas son iguales, y muestra su probabilidad asociada (valor p). 

Menú gráfico: /Herramientas/Calculadora de estadísticos de contraste

Instrucción de guión: <@ref="vartest">

# vecm Estimation "Modelo de Vectores de Corrección del Error"

Un VECM es una forma de autorregresión de vectores o VAR (consulta <@ref="var">), aplicable cuando las variables del modelo son individualmente integradas de orden 1 (por lo tanto son paseos aleatorios, con o sin deriva) pero presentan cointegración. Esta instrucción está íntimamente relacionada con el contraste de cointegración de Johansen (consulta <@ref="coint2">). 

El orden de retardos escogido en la caja de diálogo del VECM es el del sistema VAR. El número de retardos en el propio VECM (donde la variable dependiente se indica como una primera diferencia) es de uno menos que ese número. 

El “rango” representa el número de vectores cointegrantes. Este debe ser mayor que cero, y menor o igual (generalmente menor) que el número de variables endógenas escogidas. 

En el cuadradito “Variables endógenas ” puedes escoger el vector de variables endógenas, expresadas en niveles. La inclusión de términos de tipo determinístico en el modelo se controla mediante el botón de la caja de opciones. Por defecto, se incluye una “Constante no restringida”, lo que permite que haya una ordenada en el origen no nula en las relaciones de cointegración, así como una tendencia en los niveles de las variables endógenas. La literatura derivada del trabajo de Johansen (por ejemplo, consulta su libro de 1995) habitualmente se refiere a esto como el “caso 3”. Las otras 4 opciones generan los casos 1, 2, 4 y 5, respectivamente. Los significados de estos casos y los criterios que se usan para escoger un caso, se explican en <@pdf="El manual de gretl#chap:vecm"> (Capítulo 30). 

En el cuadradito “Variables exógenas” puedes añadir determinadas variables exógenas. Por defecto, estas entran en el modelo de forma no restringida (indicada con una <@lit="U"> al lado del nombre de la variable). Si quieres que una determinada variable exógena esté restringida al espacio de cointegración, pulsa un clic con el botón derecho del ratón sobre ella y selecciona “Restringida” en el menú emergente. Entonces el símbolo al lado de la variable va a cambiarse a R. 

Si los datos son trimestrales o mensuales, se muestra un cuadro de verificación que te permite incluir un conjunto de variables ficticias estacionales centradas. En todos los casos, otro cuadradito de verificación (“Mostrar los detalles de las regresiónes”) permite presentar las regresiones auxiliares que forman el punto de inicio del procedimiento de estimación Máximo Verosímil de Johansen. 

Menú gráfico: /Modelo/Series temporales/Multivariante

Instrucción de guión: <@ref="vecm">

# wls Estimation "Mínimos Cuadrados Ponderados"

Sea 'varponder' la variable escogida en el cuadradito 'Variable de ponderaciones'. Se ejecuta una regresión MCO, donde la variable dependiente es el producto de la raíz cuadrada positiva de 'varponder' y la variable dependiente elegida, y las variables independientes se multiplican también por la raíz cuadrada de 'varponder'. Los estadísticos como <@itl="R">-cuadrado se basa en los datos ponderados. Si 'varponder' es una variable ficticia, la estimación de mínimos cuadrados ponderados es equivalente a la que resulta al eliminar todas las observaciones que tienen un valor de cero para 'varponder'. 

Menú gráfico: /Modelo/Otros modelos lineales/Mínimos cuadrados ponderados

Instrucción de guión: <@ref="wls">

# workdir Utilities "Directorio de trabajo"

El directorio de trabajo (o “workdir”) es donde Gretl hace la búsqueda por defecto al leer o escribir archivos de datos o guiones, mediante los diálogos 'Abrir archivo de datos' y 'Guardar datos'. Además, es la localización por defecto para 

<indent>
• leer archivos mediante instrucciones tales como <@lit="append">, <@lit="open">, <@lit="run"> e <@lit="include">; y 
</indent>

<indent>
• escribir archivos mediante instrucciones tales como <@lit="eqnprint">, <@lit="tabprint">, <@lit="gnuplot">, <@lit="outfile"> y <@lit="store">. 
</indent>

Puedes determinar el directorio de trabajo de uno de estos dos modos: (a) utilizando el diálogo al que se accede mediante el elemento “Directorio de trabajo” en el menú Archivo, o (b) usando la instrucción <@ref="set">, como en 

<code>          
   set workdir /ruta/a/unsitio
</code>

Puedes revisar el valor vigente de la variable <@lit="workdir"> en el diálogo que se acaba de mencionar, o mediante la instrucción 

<code>          
   eval $workdir
</code>

Por defecto, el valor de <@lit="workdir"> se mantiene a lo largo de las sesiones de Gretl. Sin embargo, los usuarios que quieran trabajar con el indicador de instrucciones (lanzando Gretl desde una ventana de un terminal) pueden preferir tener el directorio de trabajo determinado automáticamente, desde el principio, como directorio vigente (de acuerdo con el intérprete). Puedes escoger esta opción en el diálogo o mediante la instrucción 

<code>          
   set use_cwd on
</code>

(“cwd” = directorio de trabajo vigente). 

El diálogo del directorio de trabajo también te permite determinar el comportamiento del selector de archivos de la Interface Gráfica de Usuario (GUI). Así, si abres o guardas un archivo en un determinado directorio, ¿el selector debe recordarlo y volver al mismo directorio en la siguiente solicitud? ¿O el selector debe visitar siempre el directorio de trabajo elegido? 

Menú gráfico: /Archivo/Directorio de trabajo

# x12a Utilities "ARIMA X-12"

Aquí hay dos opciones para proceder, controladas por el conjunto que te ofrece el botón inferior de selección. 

Si escoges “Ejecutar directamente ARIMA-X-12 ” entonces Gretl escribe un archivo de instrucciones para ARIMA X-12, y solicita que el programa 'x12a' ejecute las instrucciones. En este caso, tienes la posibilidad de generar un gráfico, y/o guardar series escogidas del resultado en el conjunto de datos de Gretl. 

Si escoges “Preparar un archivo de instrucciones de ARIMA X-12”, Gretl escribe un archivo de instrucciones para ARIMA X-12 (igual que en el caso de arriba), pero entonces abre este archivo en una ventana del editor. En esta ventana puedes hacer cambios y guardar el archivo con el nombre que tú elijas. También puedes enviar el archivo para que lo ejecute 'x12a' (pulsando un clic en el botón “Ejecutar” en la barra de herramientas de la ventana del editor) y comprobar el resultado. Pero en este caso, no tienes la posibilidad de guardar los datos como series, ni de generar un gráfico de Gretl. 

# xcorrgm Statistics "Correlograma cruzado"

Presenta y dibuja el correlograma cruzado de <@var="serie1"> con <@var="serie2">, las que puedes especificar mediante sus nombres o sus números. Los valores son los coeficientes de correlación muestrales entre el valor vigente de <@var="serie1"> y los sucesivos adelantos y retardos de <@var="serie2">. 

Si especificas un valor para <@var="orden">, la longitud del correlograma cruzado se limita a ese número de adelantos y retardos (al menos); de lo contrario, la longitud se determina de forma automática en función de la frecuencia de los datos y del número de observaciones. 

Por defecto, se genera un gráfico del correlograma cruzado: un gráfico Gnuplot en modo interactivo o un gráfico ASCII en modo de procesamiento por lotes. Puedes ajustar esto mediante la opción <@opt="--⁠plot">. Los parámetros admisibles para esta opción son <@lit="none"> (para omitir el gráfico), <@lit="ascii"> (para generar un gráfico de texto aunque sea en modo interactivo), <@lit="display"> (para generar un gráfico Gnuplot aunque sea en modo de procesamiento por lotes), o un nombre de archivo. El efecto de proporcionar un nombre de archivo es como se describió para la opción <@opt="--⁠output"> de la instrucción <@ref="gnuplot">. 

Menú gráfico: /Ver/Correlograma cruzado
Otro acceso: Ventana principal: Menú emergente (tras selección múltiple)

Instrucción de guión: <@ref="xcorrgm">

# xtab Statistics "Tabulación cruzada de variables"

Muestra una tabla de contingencia o una tabulación cruzada para cada combinación de las variables escogidas. Ten en cuenta que todas las variables deben ser discretas. 

Por defecto, en las celdas y en los márgenes de la tabla se muestran los valores que cuentan la frecuencia. Sin embargo, puedes escoger que se muestren en su lugar los porcentajes, bien por filas, o bien por columnas. 

Por defecto, las celdas con un recuento de cero casos se muestran como vacías, pero puedes escoger que se muestre explícitamente el valor cero. 

El contraste de independencia chi-cuadrado de Pearson se muestra si la frecuencia esperada bajo independencia es al menos de 1.0e-7 para todas las celdas. Una regla general habitual de la validez de este estadístico es que, al menos el 80 por ciento de las celdas, deben tener frecuencias esperadas iguales a 5 o más; y si este criterio no se cumple, se presenta una advertencia. 

Si una tabla de contingencia es 2 por 2, se calcula el Contraste Exacto de independencia de Fisher. Ten en cuenta que este contraste se basa en el supuesto de que los totales por fila y por columna son fijos, lo que puede ser o no ser adecuado dependiendo de cómo se generaron los datos. Debes utilizar la probabilidad asociada (valor p) de la izquierda cuando la hipótesis alternativa a la de independencia es la asociación negativa (los valores tienden a agruparse en las celdas de abajo a la izquierda y de arriba a la derecha); y debes utilizar el valor p de la derecha si la alternativa es la asociación positiva. El valor p de dos colas para este contraste se calcula mediante el método (b) de la sección 2.1 de <@bib="Agresti (1992);agresti92">: esto es la suma de las probabilidades de todas las tablas posibles que tengan los totales de filas y columnas indicados, y que tengan una probabilidad menor o igual a la de la tabla observada. 

Instrucción de guión: <@ref="xtab">
