/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS avx_128_fma_double kernel generator.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

#include "../nb_kernel.h"
#include "types/simple.h"
#include "vec.h"
#include "nrnb.h"

#include "gromacs/simd/math_x86_avx_128_fma_double.h"
#include "kernelutil_x86_avx_128_fma_double.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSw_VdwNone_GeomW4W4_VF_avx_128_fma_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecEwSw_VdwNone_GeomW4W4_VF_avx_128_fma_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    __m128d          ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx1A,vdwjidx1B;
    __m128d          jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    __m128d          jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B;
    __m128d          jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    __m128d          dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128d          dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128d          dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    __m128d          dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128d          dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128d          dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    __m128d          dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    __m128d          dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    __m128d          dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128i          ewitab;
    __m128d          ewtabscale,eweps,twoeweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    __m128d          rswitch,swV3,swV4,swV5,swF2,swF3,swF4,d,d2,sw,dsw;
    real             rswitch_scalar,d_scalar;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = _mm_set1_pd(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));
    iq3              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+3]));

    jq1              = _mm_set1_pd(charge[inr+1]);
    jq2              = _mm_set1_pd(charge[inr+2]);
    jq3              = _mm_set1_pd(charge[inr+3]);
    qq11             = _mm_mul_pd(iq1,jq1);
    qq12             = _mm_mul_pd(iq1,jq2);
    qq13             = _mm_mul_pd(iq1,jq3);
    qq21             = _mm_mul_pd(iq2,jq1);
    qq22             = _mm_mul_pd(iq2,jq2);
    qq23             = _mm_mul_pd(iq2,jq3);
    qq31             = _mm_mul_pd(iq3,jq1);
    qq32             = _mm_mul_pd(iq3,jq2);
    qq33             = _mm_mul_pd(iq3,jq3);

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm_set1_pd(rcutoff_scalar);
    rcutoff2         = _mm_mul_pd(rcutoff,rcutoff);

    rswitch_scalar   = fr->rcoulomb_switch;
    rswitch          = _mm_set1_pd(rswitch_scalar);
    /* Setup switch parameters */
    d_scalar         = rcutoff_scalar-rswitch_scalar;
    d                = _mm_set1_pd(d_scalar);
    swV3             = _mm_set1_pd(-10.0/(d_scalar*d_scalar*d_scalar));
    swV4             = _mm_set1_pd( 15.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swV5             = _mm_set1_pd( -6.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));
    swF2             = _mm_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar));
    swF3             = _mm_set1_pd( 60.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swF4             = _mm_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset+DIM,
                                                 &ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();
        fix3             = _mm_setzero_pd();
        fiy3             = _mm_setzero_pd();
        fiz3             = _mm_setzero_pd();

        /* Reset potential sums */
        velecsum         = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_2ptr_swizzle_pd(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx13             = _mm_sub_pd(ix1,jx3);
            dy13             = _mm_sub_pd(iy1,jy3);
            dz13             = _mm_sub_pd(iz1,jz3);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);
            dx23             = _mm_sub_pd(ix2,jx3);
            dy23             = _mm_sub_pd(iy2,jy3);
            dz23             = _mm_sub_pd(iz2,jz3);
            dx31             = _mm_sub_pd(ix3,jx1);
            dy31             = _mm_sub_pd(iy3,jy1);
            dz31             = _mm_sub_pd(iz3,jz1);
            dx32             = _mm_sub_pd(ix3,jx2);
            dy32             = _mm_sub_pd(iy3,jy2);
            dz32             = _mm_sub_pd(iz3,jz2);
            dx33             = _mm_sub_pd(ix3,jx3);
            dy33             = _mm_sub_pd(iy3,jy3);
            dz33             = _mm_sub_pd(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_pd(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_pd(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_pd(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_pd(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_pd(dx33,dy33,dz33);

            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv13           = gmx_mm_invsqrt_pd(rsq13);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);
            rinv23           = gmx_mm_invsqrt_pd(rsq23);
            rinv31           = gmx_mm_invsqrt_pd(rsq31);
            rinv32           = gmx_mm_invsqrt_pd(rsq32);
            rinv33           = gmx_mm_invsqrt_pd(rsq33);

            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq13         = _mm_mul_pd(rinv13,rinv13);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);
            rinvsq23         = _mm_mul_pd(rinv23,rinv23);
            rinvsq31         = _mm_mul_pd(rinv31,rinv31);
            rinvsq32         = _mm_mul_pd(rinv32,rinv32);
            rinvsq33         = _mm_mul_pd(rinv33,rinv33);

            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();
            fjx3             = _mm_setzero_pd();
            fjy3             = _mm_setzero_pd();
            fjz3             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(rinv11,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            d                = _mm_sub_pd(r11,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv11,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq11,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(rinv12,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            d                = _mm_sub_pd(r12,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv12,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq12,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm_mul_pd(rsq13,rinv13);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r13,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq13,_mm_sub_pd(rinv13,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq13,rinv13),_mm_sub_pd(rinvsq13,felec));

            d                = _mm_sub_pd(r13,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv13,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq13,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx13,fscal,fix1);
            fiy1             = _mm_macc_pd(dy13,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz13,fscal,fiz1);
            
            fjx3             = _mm_macc_pd(dx13,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy13,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz13,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(rinv21,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            d                = _mm_sub_pd(r21,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv21,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq21,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(rinv22,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            d                = _mm_sub_pd(r22,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv22,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq22,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm_mul_pd(rsq23,rinv23);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r23,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq23,_mm_sub_pd(rinv23,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq23,rinv23),_mm_sub_pd(rinvsq23,felec));

            d                = _mm_sub_pd(r23,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv23,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq23,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx23,fscal,fix2);
            fiy2             = _mm_macc_pd(dy23,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz23,fscal,fiz2);
            
            fjx3             = _mm_macc_pd(dx23,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy23,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz23,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm_mul_pd(rsq31,rinv31);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r31,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq31,_mm_sub_pd(rinv31,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq31,rinv31),_mm_sub_pd(rinvsq31,felec));

            d                = _mm_sub_pd(r31,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv31,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq31,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx31,fscal,fix3);
            fiy3             = _mm_macc_pd(dy31,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz31,fscal,fiz3);
            
            fjx1             = _mm_macc_pd(dx31,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy31,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz31,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm_mul_pd(rsq32,rinv32);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r32,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq32,_mm_sub_pd(rinv32,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq32,rinv32),_mm_sub_pd(rinvsq32,felec));

            d                = _mm_sub_pd(r32,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv32,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq32,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx32,fscal,fix3);
            fiy3             = _mm_macc_pd(dy32,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz32,fscal,fiz3);
            
            fjx2             = _mm_macc_pd(dx32,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy32,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz32,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm_mul_pd(rsq33,rinv33);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r33,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq33,_mm_sub_pd(rinv33,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq33,rinv33),_mm_sub_pd(rinvsq33,felec));

            d                = _mm_sub_pd(r33,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv33,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq33,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx33,fscal,fix3);
            fiy3             = _mm_macc_pd(dy33,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz33,fscal,fiz3);
            
            fjx3             = _mm_macc_pd(dx33,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy33,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz33,fscal,fjz3);

            }

            gmx_mm_decrement_3rvec_2ptr_swizzle_pd(f+j_coord_offsetA+DIM,f+j_coord_offsetB+DIM,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 612 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_1ptr_swizzle_pd(x+j_coord_offsetA+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx13             = _mm_sub_pd(ix1,jx3);
            dy13             = _mm_sub_pd(iy1,jy3);
            dz13             = _mm_sub_pd(iz1,jz3);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);
            dx23             = _mm_sub_pd(ix2,jx3);
            dy23             = _mm_sub_pd(iy2,jy3);
            dz23             = _mm_sub_pd(iz2,jz3);
            dx31             = _mm_sub_pd(ix3,jx1);
            dy31             = _mm_sub_pd(iy3,jy1);
            dz31             = _mm_sub_pd(iz3,jz1);
            dx32             = _mm_sub_pd(ix3,jx2);
            dy32             = _mm_sub_pd(iy3,jy2);
            dz32             = _mm_sub_pd(iz3,jz2);
            dx33             = _mm_sub_pd(ix3,jx3);
            dy33             = _mm_sub_pd(iy3,jy3);
            dz33             = _mm_sub_pd(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_pd(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_pd(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_pd(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_pd(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_pd(dx33,dy33,dz33);

            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv13           = gmx_mm_invsqrt_pd(rsq13);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);
            rinv23           = gmx_mm_invsqrt_pd(rsq23);
            rinv31           = gmx_mm_invsqrt_pd(rsq31);
            rinv32           = gmx_mm_invsqrt_pd(rsq32);
            rinv33           = gmx_mm_invsqrt_pd(rsq33);

            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq13         = _mm_mul_pd(rinv13,rinv13);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);
            rinvsq23         = _mm_mul_pd(rinv23,rinv23);
            rinvsq31         = _mm_mul_pd(rinv31,rinv31);
            rinvsq32         = _mm_mul_pd(rinv32,rinv32);
            rinvsq33         = _mm_mul_pd(rinv33,rinv33);

            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();
            fjx3             = _mm_setzero_pd();
            fjy3             = _mm_setzero_pd();
            fjz3             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(rinv11,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            d                = _mm_sub_pd(r11,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv11,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq11,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(rinv12,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            d                = _mm_sub_pd(r12,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv12,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq12,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm_mul_pd(rsq13,rinv13);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r13,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq13,_mm_sub_pd(rinv13,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq13,rinv13),_mm_sub_pd(rinvsq13,felec));

            d                = _mm_sub_pd(r13,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv13,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq13,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx13,fscal,fix1);
            fiy1             = _mm_macc_pd(dy13,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz13,fscal,fiz1);
            
            fjx3             = _mm_macc_pd(dx13,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy13,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz13,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(rinv21,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            d                = _mm_sub_pd(r21,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv21,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq21,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(rinv22,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            d                = _mm_sub_pd(r22,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv22,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq22,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm_mul_pd(rsq23,rinv23);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r23,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq23,_mm_sub_pd(rinv23,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq23,rinv23),_mm_sub_pd(rinvsq23,felec));

            d                = _mm_sub_pd(r23,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv23,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq23,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx23,fscal,fix2);
            fiy2             = _mm_macc_pd(dy23,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz23,fscal,fiz2);
            
            fjx3             = _mm_macc_pd(dx23,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy23,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz23,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm_mul_pd(rsq31,rinv31);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r31,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq31,_mm_sub_pd(rinv31,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq31,rinv31),_mm_sub_pd(rinvsq31,felec));

            d                = _mm_sub_pd(r31,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv31,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq31,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx31,fscal,fix3);
            fiy3             = _mm_macc_pd(dy31,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz31,fscal,fiz3);
            
            fjx1             = _mm_macc_pd(dx31,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy31,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz31,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm_mul_pd(rsq32,rinv32);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r32,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq32,_mm_sub_pd(rinv32,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq32,rinv32),_mm_sub_pd(rinvsq32,felec));

            d                = _mm_sub_pd(r32,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv32,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq32,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx32,fscal,fix3);
            fiy3             = _mm_macc_pd(dy32,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz32,fscal,fiz3);
            
            fjx2             = _mm_macc_pd(dx32,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy32,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz32,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm_mul_pd(rsq33,rinv33);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r33,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq33,_mm_sub_pd(rinv33,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq33,rinv33),_mm_sub_pd(rinvsq33,felec));

            d                = _mm_sub_pd(r33,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv33,_mm_mul_pd(velec,dsw)) );
            velec            = _mm_mul_pd(velec,sw);
            cutoff_mask      = _mm_cmplt_pd(rsq33,rcutoff2);

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_and_pd(velec,cutoff_mask);
            velec            = _mm_unpacklo_pd(velec,_mm_setzero_pd());
            velecsum         = _mm_add_pd(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx33,fscal,fix3);
            fiy3             = _mm_macc_pd(dy33,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz33,fscal,fiz3);
            
            fjx3             = _mm_macc_pd(dx33,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy33,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz33,fscal,fjz3);

            }

            gmx_mm_decrement_3rvec_1ptr_swizzle_pd(f+j_coord_offsetA+DIM,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 612 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_pd(fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset+DIM,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_pd(velecsum,kernel_data->energygrp_elec+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 19 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W4W4_VF,outeriter*19 + inneriter*612);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecEwSw_VdwNone_GeomW4W4_F_avx_128_fma_double
 * Electrostatics interaction: Ewald
 * VdW interaction:            None
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecEwSw_VdwNone_GeomW4W4_F_avx_128_fma_double
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     t_forcerec                  * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B refer to j loop unrolling done with SSE double precision, e.g. for the two different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB;
    int              j_coord_offsetA,j_coord_offsetB;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    __m128d          tx,ty,tz,fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset1;
    __m128d          ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128d          ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    __m128d          ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx1A,vdwjidx1B;
    __m128d          jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B;
    __m128d          jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B;
    __m128d          jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    __m128d          dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128d          dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128d          dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    __m128d          dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128d          dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128d          dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    __m128d          dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    __m128d          dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    __m128d          dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    __m128d          velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128i          ewitab;
    __m128d          ewtabscale,eweps,twoeweps,sh_ewald,ewrt,ewtabhalfspace,ewtabF,ewtabFn,ewtabD,ewtabV;
    real             *ewtab;
    __m128d          rswitch,swV3,swV4,swV5,swF2,swF3,swF4,d,d2,sw,dsw;
    real             rswitch_scalar,d_scalar;
    __m128d          dummy_mask,cutoff_mask;
    __m128d          signbit   = gmx_mm_castsi128_pd( _mm_set_epi32(0x80000000,0x00000000,0x80000000,0x00000000) );
    __m128d          one     = _mm_set1_pd(1.0);
    __m128d          two     = _mm_set1_pd(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_pd(fr->epsfac);
    charge           = mdatoms->chargeA;

    sh_ewald         = _mm_set1_pd(fr->ic->sh_ewald);
    ewtab            = fr->ic->tabq_coul_FDV0;
    ewtabscale       = _mm_set1_pd(fr->ic->tabq_scale);
    ewtabhalfspace   = _mm_set1_pd(0.5/fr->ic->tabq_scale);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+1]));
    iq2              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+2]));
    iq3              = _mm_mul_pd(facel,_mm_set1_pd(charge[inr+3]));

    jq1              = _mm_set1_pd(charge[inr+1]);
    jq2              = _mm_set1_pd(charge[inr+2]);
    jq3              = _mm_set1_pd(charge[inr+3]);
    qq11             = _mm_mul_pd(iq1,jq1);
    qq12             = _mm_mul_pd(iq1,jq2);
    qq13             = _mm_mul_pd(iq1,jq3);
    qq21             = _mm_mul_pd(iq2,jq1);
    qq22             = _mm_mul_pd(iq2,jq2);
    qq23             = _mm_mul_pd(iq2,jq3);
    qq31             = _mm_mul_pd(iq3,jq1);
    qq32             = _mm_mul_pd(iq3,jq2);
    qq33             = _mm_mul_pd(iq3,jq3);

    /* When we use explicit cutoffs the value must be identical for elec and VdW, so use elec as an arbitrary choice */
    rcutoff_scalar   = fr->rcoulomb;
    rcutoff          = _mm_set1_pd(rcutoff_scalar);
    rcutoff2         = _mm_mul_pd(rcutoff,rcutoff);

    rswitch_scalar   = fr->rcoulomb_switch;
    rswitch          = _mm_set1_pd(rswitch_scalar);
    /* Setup switch parameters */
    d_scalar         = rcutoff_scalar-rswitch_scalar;
    d                = _mm_set1_pd(d_scalar);
    swV3             = _mm_set1_pd(-10.0/(d_scalar*d_scalar*d_scalar));
    swV4             = _mm_set1_pd( 15.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swV5             = _mm_set1_pd( -6.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));
    swF2             = _mm_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar));
    swF3             = _mm_set1_pd( 60.0/(d_scalar*d_scalar*d_scalar*d_scalar));
    swF4             = _mm_set1_pd(-30.0/(d_scalar*d_scalar*d_scalar*d_scalar*d_scalar));

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;

    outeriter        = 0;
    inneriter        = 0;

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_pd(shiftvec+i_shift_offset,x+i_coord_offset+DIM,
                                                 &ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix1             = _mm_setzero_pd();
        fiy1             = _mm_setzero_pd();
        fiz1             = _mm_setzero_pd();
        fix2             = _mm_setzero_pd();
        fiy2             = _mm_setzero_pd();
        fiz2             = _mm_setzero_pd();
        fix3             = _mm_setzero_pd();
        fiy3             = _mm_setzero_pd();
        fiz3             = _mm_setzero_pd();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end-1; jidx+=2)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_2ptr_swizzle_pd(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx13             = _mm_sub_pd(ix1,jx3);
            dy13             = _mm_sub_pd(iy1,jy3);
            dz13             = _mm_sub_pd(iz1,jz3);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);
            dx23             = _mm_sub_pd(ix2,jx3);
            dy23             = _mm_sub_pd(iy2,jy3);
            dz23             = _mm_sub_pd(iz2,jz3);
            dx31             = _mm_sub_pd(ix3,jx1);
            dy31             = _mm_sub_pd(iy3,jy1);
            dz31             = _mm_sub_pd(iz3,jz1);
            dx32             = _mm_sub_pd(ix3,jx2);
            dy32             = _mm_sub_pd(iy3,jy2);
            dz32             = _mm_sub_pd(iz3,jz2);
            dx33             = _mm_sub_pd(ix3,jx3);
            dy33             = _mm_sub_pd(iy3,jy3);
            dz33             = _mm_sub_pd(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_pd(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_pd(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_pd(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_pd(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_pd(dx33,dy33,dz33);

            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv13           = gmx_mm_invsqrt_pd(rsq13);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);
            rinv23           = gmx_mm_invsqrt_pd(rsq23);
            rinv31           = gmx_mm_invsqrt_pd(rsq31);
            rinv32           = gmx_mm_invsqrt_pd(rsq32);
            rinv33           = gmx_mm_invsqrt_pd(rsq33);

            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq13         = _mm_mul_pd(rinv13,rinv13);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);
            rinvsq23         = _mm_mul_pd(rinv23,rinv23);
            rinvsq31         = _mm_mul_pd(rinv31,rinv31);
            rinvsq32         = _mm_mul_pd(rinv32,rinv32);
            rinvsq33         = _mm_mul_pd(rinv33,rinv33);

            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();
            fjx3             = _mm_setzero_pd();
            fjy3             = _mm_setzero_pd();
            fjz3             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(rinv11,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            d                = _mm_sub_pd(r11,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv11,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq11,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(rinv12,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            d                = _mm_sub_pd(r12,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv12,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq12,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm_mul_pd(rsq13,rinv13);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r13,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq13,_mm_sub_pd(rinv13,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq13,rinv13),_mm_sub_pd(rinvsq13,felec));

            d                = _mm_sub_pd(r13,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv13,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq13,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx13,fscal,fix1);
            fiy1             = _mm_macc_pd(dy13,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz13,fscal,fiz1);
            
            fjx3             = _mm_macc_pd(dx13,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy13,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz13,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(rinv21,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            d                = _mm_sub_pd(r21,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv21,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq21,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(rinv22,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            d                = _mm_sub_pd(r22,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv22,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq22,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm_mul_pd(rsq23,rinv23);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r23,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq23,_mm_sub_pd(rinv23,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq23,rinv23),_mm_sub_pd(rinvsq23,felec));

            d                = _mm_sub_pd(r23,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv23,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq23,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx23,fscal,fix2);
            fiy2             = _mm_macc_pd(dy23,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz23,fscal,fiz2);
            
            fjx3             = _mm_macc_pd(dx23,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy23,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz23,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm_mul_pd(rsq31,rinv31);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r31,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq31,_mm_sub_pd(rinv31,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq31,rinv31),_mm_sub_pd(rinvsq31,felec));

            d                = _mm_sub_pd(r31,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv31,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq31,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx31,fscal,fix3);
            fiy3             = _mm_macc_pd(dy31,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz31,fscal,fiz3);
            
            fjx1             = _mm_macc_pd(dx31,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy31,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz31,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm_mul_pd(rsq32,rinv32);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r32,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq32,_mm_sub_pd(rinv32,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq32,rinv32),_mm_sub_pd(rinvsq32,felec));

            d                = _mm_sub_pd(r32,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv32,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq32,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx32,fscal,fix3);
            fiy3             = _mm_macc_pd(dy32,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz32,fscal,fiz3);
            
            fjx2             = _mm_macc_pd(dx32,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy32,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz32,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm_mul_pd(rsq33,rinv33);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r33,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,1) );
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,1) +2);
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq33,_mm_sub_pd(rinv33,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq33,rinv33),_mm_sub_pd(rinvsq33,felec));

            d                = _mm_sub_pd(r33,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv33,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq33,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx33,fscal,fix3);
            fiy3             = _mm_macc_pd(dy33,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz33,fscal,fiz3);
            
            fjx3             = _mm_macc_pd(dx33,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy33,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz33,fscal,fjz3);

            }

            gmx_mm_decrement_3rvec_2ptr_swizzle_pd(f+j_coord_offsetA+DIM,f+j_coord_offsetB+DIM,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 585 flops */
        }

        if(jidx<j_index_end)
        {

            jnrA             = jjnr[jidx];
            j_coord_offsetA  = DIM*jnrA;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_1ptr_swizzle_pd(x+j_coord_offsetA+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_pd(ix1,jx1);
            dy11             = _mm_sub_pd(iy1,jy1);
            dz11             = _mm_sub_pd(iz1,jz1);
            dx12             = _mm_sub_pd(ix1,jx2);
            dy12             = _mm_sub_pd(iy1,jy2);
            dz12             = _mm_sub_pd(iz1,jz2);
            dx13             = _mm_sub_pd(ix1,jx3);
            dy13             = _mm_sub_pd(iy1,jy3);
            dz13             = _mm_sub_pd(iz1,jz3);
            dx21             = _mm_sub_pd(ix2,jx1);
            dy21             = _mm_sub_pd(iy2,jy1);
            dz21             = _mm_sub_pd(iz2,jz1);
            dx22             = _mm_sub_pd(ix2,jx2);
            dy22             = _mm_sub_pd(iy2,jy2);
            dz22             = _mm_sub_pd(iz2,jz2);
            dx23             = _mm_sub_pd(ix2,jx3);
            dy23             = _mm_sub_pd(iy2,jy3);
            dz23             = _mm_sub_pd(iz2,jz3);
            dx31             = _mm_sub_pd(ix3,jx1);
            dy31             = _mm_sub_pd(iy3,jy1);
            dz31             = _mm_sub_pd(iz3,jz1);
            dx32             = _mm_sub_pd(ix3,jx2);
            dy32             = _mm_sub_pd(iy3,jy2);
            dz32             = _mm_sub_pd(iz3,jz2);
            dx33             = _mm_sub_pd(ix3,jx3);
            dy33             = _mm_sub_pd(iy3,jy3);
            dz33             = _mm_sub_pd(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_pd(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_pd(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_pd(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_pd(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_pd(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_pd(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_pd(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_pd(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_pd(dx33,dy33,dz33);

            rinv11           = gmx_mm_invsqrt_pd(rsq11);
            rinv12           = gmx_mm_invsqrt_pd(rsq12);
            rinv13           = gmx_mm_invsqrt_pd(rsq13);
            rinv21           = gmx_mm_invsqrt_pd(rsq21);
            rinv22           = gmx_mm_invsqrt_pd(rsq22);
            rinv23           = gmx_mm_invsqrt_pd(rsq23);
            rinv31           = gmx_mm_invsqrt_pd(rsq31);
            rinv32           = gmx_mm_invsqrt_pd(rsq32);
            rinv33           = gmx_mm_invsqrt_pd(rsq33);

            rinvsq11         = _mm_mul_pd(rinv11,rinv11);
            rinvsq12         = _mm_mul_pd(rinv12,rinv12);
            rinvsq13         = _mm_mul_pd(rinv13,rinv13);
            rinvsq21         = _mm_mul_pd(rinv21,rinv21);
            rinvsq22         = _mm_mul_pd(rinv22,rinv22);
            rinvsq23         = _mm_mul_pd(rinv23,rinv23);
            rinvsq31         = _mm_mul_pd(rinv31,rinv31);
            rinvsq32         = _mm_mul_pd(rinv32,rinv32);
            rinvsq33         = _mm_mul_pd(rinv33,rinv33);

            fjx1             = _mm_setzero_pd();
            fjy1             = _mm_setzero_pd();
            fjz1             = _mm_setzero_pd();
            fjx2             = _mm_setzero_pd();
            fjy2             = _mm_setzero_pd();
            fjz2             = _mm_setzero_pd();
            fjx3             = _mm_setzero_pd();
            fjy3             = _mm_setzero_pd();
            fjz3             = _mm_setzero_pd();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq11,rcutoff2))
            {

            r11              = _mm_mul_pd(rsq11,rinv11);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r11,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq11,_mm_sub_pd(rinv11,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq11,rinv11),_mm_sub_pd(rinvsq11,felec));

            d                = _mm_sub_pd(r11,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv11,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq11,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx11,fscal,fix1);
            fiy1             = _mm_macc_pd(dy11,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz11,fscal,fiz1);
            
            fjx1             = _mm_macc_pd(dx11,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy11,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz11,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq12,rcutoff2))
            {

            r12              = _mm_mul_pd(rsq12,rinv12);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r12,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq12,_mm_sub_pd(rinv12,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq12,rinv12),_mm_sub_pd(rinvsq12,felec));

            d                = _mm_sub_pd(r12,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv12,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq12,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx12,fscal,fix1);
            fiy1             = _mm_macc_pd(dy12,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz12,fscal,fiz1);
            
            fjx2             = _mm_macc_pd(dx12,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy12,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz12,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq13,rcutoff2))
            {

            r13              = _mm_mul_pd(rsq13,rinv13);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r13,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq13,_mm_sub_pd(rinv13,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq13,rinv13),_mm_sub_pd(rinvsq13,felec));

            d                = _mm_sub_pd(r13,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv13,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq13,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix1             = _mm_macc_pd(dx13,fscal,fix1);
            fiy1             = _mm_macc_pd(dy13,fscal,fiy1);
            fiz1             = _mm_macc_pd(dz13,fscal,fiz1);
            
            fjx3             = _mm_macc_pd(dx13,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy13,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz13,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq21,rcutoff2))
            {

            r21              = _mm_mul_pd(rsq21,rinv21);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r21,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq21,_mm_sub_pd(rinv21,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq21,rinv21),_mm_sub_pd(rinvsq21,felec));

            d                = _mm_sub_pd(r21,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv21,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq21,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx21,fscal,fix2);
            fiy2             = _mm_macc_pd(dy21,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz21,fscal,fiz2);
            
            fjx1             = _mm_macc_pd(dx21,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy21,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz21,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq22,rcutoff2))
            {

            r22              = _mm_mul_pd(rsq22,rinv22);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r22,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq22,_mm_sub_pd(rinv22,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq22,rinv22),_mm_sub_pd(rinvsq22,felec));

            d                = _mm_sub_pd(r22,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv22,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq22,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx22,fscal,fix2);
            fiy2             = _mm_macc_pd(dy22,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz22,fscal,fiz2);
            
            fjx2             = _mm_macc_pd(dx22,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy22,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz22,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq23,rcutoff2))
            {

            r23              = _mm_mul_pd(rsq23,rinv23);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r23,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq23,_mm_sub_pd(rinv23,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq23,rinv23),_mm_sub_pd(rinvsq23,felec));

            d                = _mm_sub_pd(r23,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv23,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq23,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix2             = _mm_macc_pd(dx23,fscal,fix2);
            fiy2             = _mm_macc_pd(dy23,fscal,fiy2);
            fiz2             = _mm_macc_pd(dz23,fscal,fiz2);
            
            fjx3             = _mm_macc_pd(dx23,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy23,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz23,fscal,fjz3);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq31,rcutoff2))
            {

            r31              = _mm_mul_pd(rsq31,rinv31);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r31,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq31,_mm_sub_pd(rinv31,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq31,rinv31),_mm_sub_pd(rinvsq31,felec));

            d                = _mm_sub_pd(r31,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv31,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq31,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx31,fscal,fix3);
            fiy3             = _mm_macc_pd(dy31,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz31,fscal,fiz3);
            
            fjx1             = _mm_macc_pd(dx31,fscal,fjx1);
            fjy1             = _mm_macc_pd(dy31,fscal,fjy1);
            fjz1             = _mm_macc_pd(dz31,fscal,fjz1);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq32,rcutoff2))
            {

            r32              = _mm_mul_pd(rsq32,rinv32);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r32,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq32,_mm_sub_pd(rinv32,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq32,rinv32),_mm_sub_pd(rinvsq32,felec));

            d                = _mm_sub_pd(r32,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv32,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq32,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx32,fscal,fix3);
            fiy3             = _mm_macc_pd(dy32,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz32,fscal,fiz3);
            
            fjx2             = _mm_macc_pd(dx32,fscal,fjx2);
            fjy2             = _mm_macc_pd(dy32,fscal,fjy2);
            fjz2             = _mm_macc_pd(dz32,fscal,fjz2);

            }

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            if (gmx_mm_any_lt(rsq33,rcutoff2))
            {

            r33              = _mm_mul_pd(rsq33,rinv33);

            /* EWALD ELECTROSTATICS */

            /* Calculate Ewald table index by multiplying r with scale and truncate to integer */
            ewrt             = _mm_mul_pd(r33,ewtabscale);
            ewitab           = _mm_cvttpd_epi32(ewrt);
#ifdef __XOP__
            eweps            = _mm_frcz_pd(ewrt);
#else
            eweps            = _mm_sub_pd(ewrt,_mm_round_pd(ewrt, _MM_FROUND_FLOOR));
#endif
            twoeweps         = _mm_add_pd(eweps,eweps);
            ewitab           = _mm_slli_epi32(ewitab,2);
            ewtabF           = _mm_load_pd( ewtab + _mm_extract_epi32(ewitab,0) );
            ewtabD           = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabF,ewtabD);
            ewtabV           = _mm_load_sd( ewtab + _mm_extract_epi32(ewitab,0) +2);
            ewtabFn          = _mm_setzero_pd();
            GMX_MM_TRANSPOSE2_PD(ewtabV,ewtabFn);
            felec            = _mm_macc_pd(eweps,ewtabD,ewtabF);
            velec            = _mm_nmacc_pd(_mm_mul_pd(ewtabhalfspace,eweps) ,_mm_add_pd(ewtabF,felec), ewtabV);
            velec            = _mm_mul_pd(qq33,_mm_sub_pd(rinv33,velec));
            felec            = _mm_mul_pd(_mm_mul_pd(qq33,rinv33),_mm_sub_pd(rinvsq33,felec));

            d                = _mm_sub_pd(r33,rswitch);
            d                = _mm_max_pd(d,_mm_setzero_pd());
            d2               = _mm_mul_pd(d,d);
            sw               = _mm_add_pd(one,_mm_mul_pd(d2,_mm_mul_pd(d,_mm_macc_pd(d,_mm_macc_pd(d,swV5,swV4),swV3))));

            dsw              = _mm_mul_pd(d2,_mm_macc_pd(d,_mm_macc_pd(d,swF4,swF3),swF2));

            /* Evaluate switch function */
            /* fscal'=f'/r=-(v*sw)'/r=-(v'*sw+v*dsw)/r=-v'*sw/r-v*dsw/r=fscal*sw-v*dsw/r */
            felec            = _mm_msub_pd( felec,sw , _mm_mul_pd(rinv33,_mm_mul_pd(velec,dsw)) );
            cutoff_mask      = _mm_cmplt_pd(rsq33,rcutoff2);

            fscal            = felec;

            fscal            = _mm_and_pd(fscal,cutoff_mask);

            fscal            = _mm_unpacklo_pd(fscal,_mm_setzero_pd());

            /* Update vectorial force */
            fix3             = _mm_macc_pd(dx33,fscal,fix3);
            fiy3             = _mm_macc_pd(dy33,fscal,fiy3);
            fiz3             = _mm_macc_pd(dz33,fscal,fiz3);
            
            fjx3             = _mm_macc_pd(dx33,fscal,fjx3);
            fjy3             = _mm_macc_pd(dy33,fscal,fjy3);
            fjz3             = _mm_macc_pd(dz33,fscal,fjz3);

            }

            gmx_mm_decrement_3rvec_1ptr_swizzle_pd(f+j_coord_offsetA+DIM,fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 585 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_pd(fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset+DIM,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W4W4_F,outeriter*18 + inneriter*585);
}
