#ifndef _NAP_TIMER_H
#define _NAP_TIMER_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */


struct timer_s 
{
  time_t t;
  time_t interval;
  /* "new" timer: arbitrary callback function */
  void (*callback)(void *data); /* callback function */
  void *data;                   /* callback data (allocated) */
  char *desc;                   /* a description printed by tlist (alloc'd) */ 
  bool recurring;               /* is it a repeating event? */
  struct timer_s *next;
};
typedef struct timer_s ntimer_t;


void tevent(void);
void timerlist(WINDOW *);
void pfunc(ntimer_t *);
ntimer_t *addtimer(int sec, void callback(void *data), void *data, char *desc,
                   bool recurring);
void deltimer(ntimer_t *);
bool deltimer_by_index(int index);

#endif /* _NAP_TIMER_H */
