/* $Id: ProjectFolder.cpp 410943 2013-08-22 20:54:31Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gbproj.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/gbproj/ProjectFolder.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

CAtomicCounter CProjectFolder::m_IdCounter;

// destructor
CProjectFolder::~CProjectFolder(void)
{
}


CProjectFolder* CProjectFolder::GetParentFolder()
{
    return m_ParentFolder;
}


void CProjectFolder::SetParentFolder(CProjectFolder* parent)
{
    m_ParentFolder = parent;
}

/// CIdSelector finds a Project Item by Id
class CPrjItemSelector_Id : public CProjectFolder::IProjectItemVisitor
{
public:
    CPrjItemSelector_Id(CProjectItem::TId id)
        : m_Id(id), m_Item(NULL)  {}

    virtual bool    Visit(CProjectItem& item)
    {
        if(item.GetId() == m_Id)  {
            m_Item = &item;
            return false; // stop iterating
        }
        return true; // continue
    }

public:
    CProjectItem::TId m_Id;
    CProjectItem*   m_Item;
};


/// CLabelSelector finds a Project Item by Label
class CPrjItemSelector_Label : public CProjectFolder::IProjectItemVisitor
{
public:
    CPrjItemSelector_Label(const string& label)
        : m_Label(label), m_Item(NULL)  {}

    virtual bool    Visit(CProjectItem& item)
    {
        if(item.GetLabel() == m_Label)  {
            m_Item = &item;
            return false; // stop iterating
        }
        return true; // continue
    }

public:
    string  m_Label;
    CProjectItem*   m_Item;
};


class CPrjItemSelector_Data : public CProjectFolder::IProjectItemVisitor
{
public:
    CPrjItemSelector_Data(const CSerialObject& object)
        : m_Object(&object), m_Item(NULL)  {}

    virtual bool    Visit(CProjectItem& item)
    {
        if(item.GetObject() == m_Object)  {
            m_Item = &item;
            return false; // stop iterating
        }
        return true; // continue
    }

public:
    const CSerialObject*    m_Object;
    CProjectItem*   m_Item;
};


CProjectItem* CProjectFolder::FindProjectItemByLabel(const string& label)
{
    CPrjItemSelector_Label selector(label);
    ForEachProjectItem(selector, false);
    return selector.m_Item;
}


CProjectItem* CProjectFolder::FindProjectItemById(CProjectItem::TId id,
                                                  bool recursive)
{
    CPrjItemSelector_Id selector(id);
    ForEachProjectItem(selector, recursive);
    return selector.m_Item;
}


CProjectItem* CProjectFolder::FindProjectItemByData(const CSerialObject& object,
                                                    bool recursive)
{
    CPrjItemSelector_Data selector(object);
    ForEachProjectItem(selector, recursive);
    return selector.m_Item;
}


CProjectFolder* CProjectFolder::FindChildFolderById(TId id, bool recursive)
{
    NON_CONST_ITERATE(TFolders, it, SetFolders())    {
        CProjectFolder& child = **it;
        if(child.GetId() == id) {
            return &child;
        } else if(recursive)    {
            CProjectFolder* res = child.FindChildFolderById(id, true);
            if(res) {
                return res;
            }
        }
    }
    return NULL;
}


CProjectFolder* CProjectFolder::FindChildFolderByTitle(const string& title)
{
    NON_CONST_ITERATE(TFolders, it, SetFolders())    {
        CProjectFolder& child = **it;
        if(child.SetInfo().SetTitle() == title)   {
            return &child;
        }
    }
    return NULL; // not found
}


void CProjectFolder::AddChildItem(CProjectItem& child_item)
{
    _ASSERT(child_item.GetParentFolder() == NULL);

    CRef<CProjectItem> ref(&child_item);
    TItems& items = SetItems();
    items.push_back(ref);
    child_item.SetParentFolder(this);
}


bool CProjectFolder::RemoveChildItem(CProjectItem& child_item)
{
    if(IsSetItems())    {
        CRef<CProjectItem> ref(&child_item);
        TItems& items = SetItems();
        TItems::iterator it = std::find(items.begin(), items.end(), ref);
        if(it != items.end())   {
            child_item.SetParentFolder(NULL);
            items.erase(it);
            return true;
        }
    }
    return false;
}


bool CProjectFolder::RemoveChildItem(CProjectItem::TId id)
{
    if(IsSetItems())    {
        TItems& items = SetItems();
        NON_CONST_ITERATE(TItems, it, items)    {
            CProjectItem& item = **it;
            if(item.GetId() == id)   {
                item.SetParentFolder(NULL);
                items.erase(it);
                return true;
            }
        }
    }
    return false;
}


void CProjectFolder::RemoveAllChildItems()
{
    if(IsSetItems())    {
        TItems& items = SetItems();
        NON_CONST_ITERATE(TItems, it, items)    {
            CProjectItem& item = **it;
            item.SetParentFolder(NULL);
        }
        items.clear();
    }
}


void CProjectFolder::AddChildFolder(CProjectFolder& child_folder)
{
    _ASSERT(child_folder.GetParentFolder() == NULL);

    CRef<CProjectFolder> ref(&child_folder);
    TFolders& folders = SetFolders();
    folders.push_back(ref);
    child_folder.SetParentFolder(this);
}


void CProjectFolder::RemoveChildFolder(CProjectFolder& child_folder)
{
    _ASSERT(child_folder.GetParentFolder() == this);

    TFolders& folders = SetFolders();
    CRef<CProjectFolder> ref(&child_folder);
    TFolders::iterator it = std::find(folders.begin(), folders.end(), ref);

    if(it !=  folders.end())    {
        child_folder.SetParentFolder(NULL);
        folders.erase(it);
    } else {
        NCBI_THROW(CException, eUnknown, "Folder is not found.");
    }
}


void CProjectFolder::RemoveChildFolder(CProjectFolder::TId folder_id)
{
    TFolders& folders = SetFolders();
    NON_CONST_ITERATE(TFolders, it, folders)  {
        CProjectFolder& sub_folder = **it;
        if(sub_folder.GetId() == folder_id) {
            _ASSERT(sub_folder.GetParentFolder() == this);
            sub_folder.SetParentFolder(NULL);
            folders.erase(it);
            return;
        }
    }
    NCBI_THROW(CException, eUnknown, "Folder is not found.");
}

bool CProjectFolder::ForEachProjectItem(IProjectItemVisitor& visitor,
                                    bool recursive)
{
    bool ok = true;

    if(IsSetItems())    {
        //  iterate through Project Items in this Folder
        TItems& items = SetItems();
        NON_CONST_ITERATE(TItems, it, items)    {
            CProjectItem& item = **it;
            ok = visitor.Visit(item);
            if( ! ok)
                return false;
        }
    }

    if(recursive)   {
        // recursively iterate through child Folders
        TFolders& folders = SetFolders();
        NON_CONST_ITERATE(TFolders, it, folders)    {
            CProjectFolder& child = **it;
            ok = child.ForEachProjectItem(visitor, true);
            if( ! ok) {
                return false;
            }
        }
    }
    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1734, CRC32: b33bdb51 */
