/* $Id: SeqTable_multi_data.cpp 399723 2013-05-15 19:53:24Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqtable.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/seqtable/SeqTable_multi_data.hpp>
#include <objects/seqtable/CommonString_table.hpp>
#include <objects/seqtable/CommonBytes_table.hpp>
#include <objects/seqtable/Seq_table.hpp>
#include <serial/objhook.hpp>
#include <corelib/ncbi_param.hpp>

#include <util/bitset/ncbi_bitset.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CSeqTable_multi_data::~CSeqTable_multi_data(void)
{
}


DEFINE_STATIC_MUTEX(sx_PrepareMutex_multi_data);


void CSeqTable_multi_data::x_Preprocess(void) const
{
    CMutexGuard guard(sx_PrepareMutex_multi_data);
    if ( IsInt_delta() ) {
        CSeqTable_multi_data* nc_this =
            const_cast<CSeqTable_multi_data*>(this);
        TInt arr;
        const CSeqTable_multi_data& data = GetInt_delta();
        size_t size = data.GetSize();
        E_Choice data_type = data.Which();
        if ( data_type == e_Bit ) {
            arr.reserve(size);
            const TBit& src = data.GetBit();
            TInt::value_type v = 0;
            ITERATE ( TBit, it, src ) {
                Uint1 bb = *it;
                for ( size_t i = 0; i < 8; ++i, bb <<= 1 ) {
                    if ( bb&0x80 ) {
                        ++v;
                    }
                    arr.push_back(v);
                }
            }
        }
        else if ( data_type == e_Bit_bvector ) {
            arr.reserve(size);
            const bm::bvector<>& src = *data.m_BitVector;
            TInt::value_type v = 0;
            if ( src.any() ) {
                for ( bm::id_t i = src.get_first(); (i=src.get_next(i)); ) {
                    arr.resize(i, v);
                    ++v;
                    arr.push_back(v);
                }
            }
            arr.resize(size, v);
        }
        else {
            swap(const_cast<TInt&>(data.GetInt()), arr);
            TInt::value_type v = 0;
            NON_CONST_ITERATE ( TInt, it, arr ) {
                v += *it;
                *it = v;
            }
        }
        swap(nc_this->SetInt(), arr);
    }
    else if ( IsInt_scaled() ) {
        CSeqTable_multi_data* nc_this =
            const_cast<CSeqTable_multi_data*>(this);
        TInt arr;
        const TInt_scaled& scale = GetInt_scaled();
        TInt::value_type value0 = scale.GetAdd();
        const CSeqTable_multi_data& data = scale.GetData();
        size_t size = data.GetSize();
        E_Choice data_type = data.Which();
        if ( data_type == e_Bit ) {
            const TBit& src = data.GetBit();
            arr.reserve(size);
            TInt::value_type value1 = value0 + scale.GetMul();
            ITERATE ( TBit, it, src ) {
                Uint1 bb = *it;
                for ( size_t i = 0; i < 8; ++i, bb <<= 1 ) {
                    arr.push_back((bb&0x80)? value1: value0);
                }
            }
        }
        else if ( data_type == e_Bit_bvector ) {
            arr.reserve(size);
            const bm::bvector<>& src = *data.m_BitVector;
            if ( src.any() ) {
                TInt::value_type value1 = value0 + scale.GetMul();
                for ( bm::id_t i = src.get_first(); (i=src.get_next(i)); ) {
                    arr.resize(i, value0);
                    arr.push_back(value1);
                }
            }
            arr.resize(size, value0);
        }
        else {
            swap(const_cast<TInt&>(data.GetInt()), arr);
            TInt_scaled::TMul mul = scale.GetMul();
            NON_CONST_ITERATE ( TInt, it, arr ) {
                *it = *it*mul + value0;
            }
        }
        swap(nc_this->SetInt(), arr);
    }
    else if ( IsReal_scaled() ) {
        CSeqTable_multi_data* nc_this =
            const_cast<CSeqTable_multi_data*>(this);
        TReal arr;
        const TReal_scaled& scale = GetReal_scaled();
        TReal::value_type value0 = scale.GetAdd();
        const CSeqTable_multi_data& data = scale.GetData();
        size_t size = data.GetSize();
        E_Choice data_type = data.Which();
        if ( data_type == e_Bit ) {
            const TBit& src = data.GetBit();
            arr.reserve(size);
            TReal::value_type value1 = value0 + scale.GetMul();
            ITERATE ( TBit, it, src ) {
                Uint1 bb = *it;
                for ( size_t i = 0; i < 8; ++i, bb <<= 1 ) {
                    arr.push_back((bb&0x80)? value1: value0);
                }
            }
        }
        else if ( data_type == e_Bit_bvector ) {
            arr.reserve(size);
            const bm::bvector<>& src = *data.m_BitVector;
            if ( src.any() ) {
                TReal::value_type value1 = value0 + scale.GetMul();
                for ( bm::id_t i = src.get_first(); (i=src.get_next(i)); ) {
                    arr.resize(i, value0);
                    arr.push_back(value1);
                }
            }
            arr.resize(size, value0);
        }
        else if ( data_type == e_Int ) {
            const TInt& src = data.GetInt();
            arr.reserve(size);
            TReal_scaled::TMul mul = scale.GetMul();
            ITERATE ( TInt, it, src ) {
                arr.push_back(*it*mul + value0);
            }
        }
        else {
            swap(const_cast<TReal&>(data.GetReal()), arr);
            TReal_scaled::TMul mul = scale.GetMul();
            NON_CONST_ITERATE ( TReal, it, arr ) {
                *it = *it*mul + value0;
            }
        }
        swap(nc_this->SetReal(), arr);
    }
    else if ( IsBit_bvector() && !m_BitVector ) {
        AutoPtr<bm::bvector<> > bv(new bm::bvector<>());
        bm::deserialize(*bv, (const unsigned char*)&GetBit_bvector()[0]);
        m_BitVector = bv;
    }
}


bool CSeqTable_multi_data::x_GetRowBit(size_t row_index) const
{
    if ( IsBit() ) {
        const TBit& bits = GetBit();
        size_t i = row_index/8;
        if ( i >= bits.size() ) {
            return 0;
        }
        size_t j = row_index%8;
        Uint1 bb = bits[i];
        return ((bb<<j)&0x80) != 0;
    }
    else {
        return m_BitVector->get_bit(row_index);
    }
}


size_t CSeqTable_multi_data::GetSize(void) const
{
    x_EnsurePreprocessed();
    switch ( Which() ) {
    case e_Int:
        return GetInt().size();
    case e_Real:
        return GetReal().size();
    case e_String:
        return GetString().size();
    case e_Bytes:
        return GetBytes().size();
    case e_Common_string:
        return GetCommon_string().GetIndexes().size();
    case e_Common_bytes:
        return GetCommon_bytes().GetIndexes().size();
    case e_Bit:
        return GetBit().size()*8;
    case e_Loc:
        return GetLoc().size();
    case e_Id:
        return GetId().size();
    case e_Interval:
        return GetInterval().size();
    case e_Bit_bvector:
        return m_BitVector->size();
    default:
        break;
    }
    return 0;
}


NCBI_PARAM_DECL(bool, OBJECTS, SEQ_TABLE_RESERVE);
NCBI_PARAM_DEF_EX(bool, OBJECTS, SEQ_TABLE_RESERVE, true,
                  eParam_NoThread, OBJECTS_SEQ_TABLE_RESERVE);

void CSeqTable_multi_data::CReserveHook::PreReadChoiceVariant(
    CObjectIStream& in,
    const CObjectInfoCV& variant)
{
    static const bool s_Reserve =
        NCBI_PARAM_TYPE(OBJECTS, SEQ_TABLE_RESERVE)::GetDefault();

    if ( !s_Reserve ) {
        return;
    }
    if ( CSeq_table* table = CType<CSeq_table>::GetParent(in, 2, 2) ) {
        size_t size = table->GetNum_rows();
        CSeqTable_multi_data* data =
            CType<CSeqTable_multi_data>::Get(variant.GetChoiceObject());
        switch ( variant.GetVariantIndex() ) {
        case e_Int:
            data->SetInt().reserve(size);
            break;
        case e_Real:
            data->SetReal().reserve(size);
            break;
        case e_String:
            data->SetString().reserve(size);
            break;
        case e_Bytes:
            data->SetBytes().reserve(size);
            break;
        case e_Common_string:
            data->SetCommon_string().SetIndexes().reserve(size);
            break;
        case e_Common_bytes:
            data->SetCommon_bytes().SetIndexes().reserve(size);
            break;
        case e_Bit:
            data->SetBit().reserve((size+7)/8);
            break;
        case e_Loc:
            data->SetLoc().reserve(size);
            break;
        case e_Id:
            data->SetId().reserve(size);
            break;
        case e_Interval:
            data->SetInterval().reserve(size);
            break;
        default:
            break;
        }
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE
