#ifndef BMSIMD__H__INCLUDED__
#define BMSIMD__H__INCLUDED__
/*
Copyright(c) 2002-2017 Anatoliy Kuznetsov(anatoliy_kuznetsov at yahoo.com)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

For more information please visit:  http://bitmagic.io
*/
/*! \file bmsimd.h
    \brief SIMD target version definitions
*/


#ifdef BMAVX2OPT
# undef BMSSE42OPT
# undef BMSSE2OPT
# define BMVECTOPT
# include "bmavx2.h"
#endif


#ifdef BMSSE42OPT
# define BMVECTOPT
# include "bmsse4.h"
#endif

#ifdef BMSSE2OPT
# undef BM64OPT
# define BMVECTOPT
# include "bmsse2.h"
#endif

namespace bm
{

/**
    @brief return SIMD optimization used for building BitMagic
    @return SIMD code
 
    @ingroup bmagic
*/
inline int simd_version()
{
#ifdef BMAVX2OPT
    return bm::simd_avx2;
#endif
#ifdef BMSSE42OPT
    return bm::simd_sse42;
#endif
#ifdef BMSSE2OPT
    return bm::simd_sse2;
#else
    return bm::simd_none;
#endif
}


} // namespace

#endif
