C
C $Id: fcurv2dp.f,v 1.3 2008-07-27 03:10:11 haley Exp $
C
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
C NOTE: If you make any changes to this software, please remember to
C make the same changes to the corresponding single precision routine.
C
      SUBROUTINE FCURV2DP(N,XI,YI,YP,SIGMA,M,XO,YO)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION YP
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION CURV2DP
C
      DIMENSION XI(N),YI(N),YP(N),XO(M),YO(M)
C
      DO 10 I = 1,M
          YO(I) = CURV2DP(XO(I),N,XI,YI,YP,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FCURVDDP(N,XI,YI,YP,SIGMA,M,XO,YO)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION YP
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION CURVDDP
C
      DIMENSION XI(N),YI(N),YP(N),XO(M),YO(M)
C
      DO 10 I = 1,M
          YO(I) = CURVDDP(XO(I),N,XI,YI,YP,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FCURVIDP(XL,XR,N,XI,YI,YP,SIGMA,FINT)
      DOUBLE PRECISION XL
      DOUBLE PRECISION XR
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION YP
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION FINT
      DOUBLE PRECISION CURVIDP
C
      DIMENSION XI(N),YI(N),YP(N)
C
      FINT = CURVIDP(XL,XR,N,XI,YI,YP,SIGMA)
C
      RETURN
      END
      SUBROUTINE FCURVP2DP(N,XI,YI,YP,P,SIGMA,M,XO,YO)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION YP
      DOUBLE PRECISION P
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION CURVP2DP
C
      DIMENSION XI(N),YI(N),YP(N),XO(M),YO(M)
C
      DO 10 I = 1,M
          YO(I) = CURVP2DP(XO(I),N,XI,YI,P,YP,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FCURVPIDP(XL,XR,P,N,XI,YI,YP,SIGMA,FINT)
      DOUBLE PRECISION XL
      DOUBLE PRECISION XR
      DOUBLE PRECISION P
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION YP
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION FINT
      DOUBLE PRECISION CURVPIDP
C
      DIMENSION XI(N),YI(N),YP(N)
C
      FINT = CURVPIDP(XL,XR,N,XI,YI,P,YP,SIGMA)
C
      RETURN
      END
      SUBROUTINE FKURV2DP(N,XI,YI,M,T,XO,YO,XP,YP,S,SIGMA)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION T
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION XP
      DOUBLE PRECISION YP
      DOUBLE PRECISION S
      DOUBLE PRECISION SIGMA
C
      DIMENSION XI(N),YI(N),YP(N),S(N),T(M),XO(M),YO(M)
C
      DO 10 I = 1,M
          CALL KURV2DP(T(I),XO(I),YO(I),N,XI,YI,XP,YP,S,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FKURVP2DP(N,XI,YI,M,T,XO,YO,XP,YP,S,SIGMA)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION T
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION XP
      DOUBLE PRECISION YP
      DOUBLE PRECISION S
      DOUBLE PRECISION SIGMA
C
      DIMENSION XI(N),YI(N),YP(N),S(N),T(M),XO(M),YO(M)
C
      DO 10 I = 1,M
          CALL KURVP2DP(T(I),XO(I),YO(I),N,XI,YI,XP,YP,S,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FKURVDDP(N,XI,YI,M,T,XO,YO,XD,YD,XDD,YDD,XP,YP,S,SIGMA)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION T
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION XD
      DOUBLE PRECISION YD
      DOUBLE PRECISION XDD
      DOUBLE PRECISION YDD
      DOUBLE PRECISION XP
      DOUBLE PRECISION YP
      DOUBLE PRECISION S
      DOUBLE PRECISION SIGMA
C
      DIMENSION XI(N),YI(N),YP(N),S(N),T(M),XO(M),YO(M),XD(M),YD(M),
     +          XDD(M),YDD(M)
C
      DO 10 I = 1,M
          CALL KURVDDP(T(I),XO(I),YO(I),XD(I),YD(I),XDD(I),YDD(I),N,XI,
     +                 YI,XP,YP,S,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FKURVPDDP(N,XI,YI,M,T,XO,YO,XD,YD,XDD,YDD,XP,YP,S,
     +                     SIGMA)
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION T
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION XD
      DOUBLE PRECISION YD
      DOUBLE PRECISION XDD
      DOUBLE PRECISION YDD
      DOUBLE PRECISION XP
      DOUBLE PRECISION YP
      DOUBLE PRECISION S
      DOUBLE PRECISION SIGMA
C
      DIMENSION XI(N),YI(N),YP(N),S(N),T(M),XO(M),YO(M),XD(M),YD(M),
     +          XDD(M),YDD(M)
C
      DO 10 I = 1,M
          CALL KURVPDDP(T(I),XO(I),YO(I),XD(I),YD(I),XDD(I),YDD(I),N,
     +                  XI,YI,XP,YP,S,SIGMA)
   10 CONTINUE
C
      RETURN
      END
      SUBROUTINE FSURF2DP(SVALUE,XO,YO,M,N,XI,YI,ZI,IZ,ZP,SIGMA)
      DOUBLE PRECISION SVALUE
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION ZI
      DOUBLE PRECISION ZP
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION SURF2DP
C
      DIMENSION XI(M),YI(N),ZI(IZ,N),ZP(M,N,3)
C
      SVALUE = SURF2DP(XO,YO,M,N,XI,YI,ZI,IZ,ZP,SIGMA)
C
      RETURN
      END
      SUBROUTINE FCURVS2DP(N,PARAM,XI,YI,XS,XSP,YS,YSP,SIGMA,M,XL,XR,XO,
     +                     YO)
      DOUBLE PRECISION PARAM
      DOUBLE PRECISION XI
      DOUBLE PRECISION YI
      DOUBLE PRECISION XS
      DOUBLE PRECISION XSP
      DOUBLE PRECISION YS
      DOUBLE PRECISION YSP
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION XL
      DOUBLE PRECISION XR
      DOUBLE PRECISION XO
      DOUBLE PRECISION YO
      DOUBLE PRECISION XINC
C
      DIMENSION PARAM(N),XI(N),YI(N),XS(N),XSP(N),YS(N),YSP(N),XO(M),
     +          YO(M)
C
      XINC = (XR-XL)/DBLE(M-1)
      DO 10 I = 1,M
          CALL CURVS2DP(DBLE(I-1)*XINC,N,PARAM,XS,YS,XSP,YSP,SIGMA,
     +                  XO(I),YO(I))
   10 CONTINUE
C
      RETURN
      END
