# Changelog

## [v1.16.0](https://github.com/netdata/netdata/tree/v1.16.0) (2019-07-08)

**Fixed bugs:**

- Double free or corruption \(fasttop\) [\#6370](https://github.com/netdata/netdata/issues/6370)
- Netdata not ignoring /dev and /run by default [\#6361](https://github.com/netdata/netdata/issues/6361)
- \[critical\] netdata segfault when restart service [\#6356](https://github.com/netdata/netdata/issues/6356)
- Backend as-collected values from statsd are 1000 time to high [\#6347](https://github.com/netdata/netdata/issues/6347)
- Tomcat collector break on invalid XML caused by single quotes in Memory Pool names \(code solution inside\) [\#6343](https://github.com/netdata/netdata/issues/6343)
- adaptec\_raid: failed to parse `arcconf GETCONFIG 1 LD` output [\#6337](https://github.com/netdata/netdata/issues/6337)
- Cannot reinstall netdata [\#6329](https://github.com/netdata/netdata/issues/6329)
- collectors/perf.plugin/perf\_plugin.c:171: error: 'PERF\_COUNT\_HW\_REF\_CPU\_CYCLES' undeclared here \(not in a function\) [\#6321](https://github.com/netdata/netdata/issues/6321)
- Never able to sign in [\#6306](https://github.com/netdata/netdata/issues/6306)
- /dev/fd/63: line 113:  : command not found when trying to update  [\#6289](https://github.com/netdata/netdata/issues/6289)
- Redirect cannot overwrite netdata. [\#6288](https://github.com/netdata/netdata/issues/6288)
- Netdata lateral menu hidden [\#6287](https://github.com/netdata/netdata/issues/6287)
- How to remove/unregister a streaming node to prevent the health alarms from triggering [\#6266](https://github.com/netdata/netdata/issues/6266)
- netdata/daemon: Service down with multiple "too many open files" occurring on DB engine [\#6265](https://github.com/netdata/netdata/issues/6265)
- RFE: Minor change to the spec.in file in order to help with building rpms on RHEL [\#6256](https://github.com/netdata/netdata/issues/6256)
- addgroup: gid '999' in use [\#6253](https://github.com/netdata/netdata/issues/6253)
- Starting netdata official container fails with `addgroup: gid '999' in use` [\#6251](https://github.com/netdata/netdata/issues/6251)
- Elasticsearch plugin error - 'module' object has no attribute 'Retry' [\#6248](https://github.com/netdata/netdata/issues/6248)
- "Missing charts" on v1.15.0-70-nightly  \(\*\*solved\*\*\) [\#6244](https://github.com/netdata/netdata/issues/6244)
- netdata daemon collectors stuck [\#6239](https://github.com/netdata/netdata/issues/6239)
- URL Parser changes, correct health cmd api conditions to create silencer [\#6238](https://github.com/netdata/netdata/issues/6238)
- Error during installation in devuan [\#6230](https://github.com/netdata/netdata/issues/6230)
-  kickstart.sh: Getting Nightly SHA256 sums from storage.googleapis.com times out [\#6227](https://github.com/netdata/netdata/issues/6227)
- Use major/minor from sys/types.h [\#6218](https://github.com/netdata/netdata/issues/6218)
- Update fails because of new system dependencies \(\*\*Resolved\*\*\) [\#6200](https://github.com/netdata/netdata/issues/6200)
- netdata/database: db engine crashing under certain conditions [\#6199](https://github.com/netdata/netdata/issues/6199)
- Update frequency for x509check alarm [\#6193](https://github.com/netdata/netdata/issues/6193)
- kickstart.sh: Getting Nightly SHA256 sums from storage.googleapis.com times out [\#6191](https://github.com/netdata/netdata/issues/6191)
- tv.html errors on https [\#6188](https://github.com/netdata/netdata/issues/6188)
- Error messages on old database files [\#6186](https://github.com/netdata/netdata/issues/6186)
- netdata/packaging: Sporadic job failures in Travis CI [\#6185](https://github.com/netdata/netdata/issues/6185)
- Fix date in pushbullet alarm notifications [\#6178](https://github.com/netdata/netdata/issues/6178)
- Chart's "name" not streamed [\#6177](https://github.com/netdata/netdata/issues/6177)
- Why is auto-update not working? V1.14.0 [\#6170](https://github.com/netdata/netdata/issues/6170)
- \[solved\] ZFS database \(was: netdata FATAL : MAIN :uv\_fs\_fsopen: invalid argument \# : Invalid argument\) [\#6161](https://github.com/netdata/netdata/issues/6161)
- httpcheck does not export some metrics in version 1.15 [\#6157](https://github.com/netdata/netdata/issues/6157)
- opensuse - installation by hand issues due to hardcoded libexec in netdata-installer.sh [\#6153](https://github.com/netdata/netdata/issues/6153)
- httpcheck causes lots of SYN\_SENT dangling sockets [\#6152](https://github.com/netdata/netdata/issues/6152)
- varnish plugin not showing \(varnish version 4\) [\#6149](https://github.com/netdata/netdata/issues/6149)
- Reduce number of codacy issues [\#6131](https://github.com/netdata/netdata/issues/6131)
- Optimize calls that gather system-info [\#6130](https://github.com/netdata/netdata/issues/6130)
- Fix telemetry config in installer [\#6129](https://github.com/netdata/netdata/issues/6129)
- web\_log reports unmatched lines [\#6125](https://github.com/netdata/netdata/issues/6125)
- Netdata 1.15 crashes on Ubuntu 16.04 [\#6117](https://github.com/netdata/netdata/issues/6117)
- netdata doesn't start with the new dbengine [\#6110](https://github.com/netdata/netdata/issues/6110)
- "mdstat.mdX\_disks" chart's total is misleading [\#6108](https://github.com/netdata/netdata/issues/6108)
- Telemetry rarely received from docker containers [\#6095](https://github.com/netdata/netdata/issues/6095)
- netdata/packaging/installer: Fine tuning based on user feedback and findings from testing [\#6094](https://github.com/netdata/netdata/issues/6094)
- opensuse - installation by hand issues due to hardcoded libexec in netdata-installer.sh [\#6092](https://github.com/netdata/netdata/issues/6092)
- Problem updating [\#6088](https://github.com/netdata/netdata/issues/6088)
- invalid help links on platform \(web log nginx/apache\) [\#6086](https://github.com/netdata/netdata/issues/6086)
- install on debian jessie [\#6083](https://github.com/netdata/netdata/issues/6083)
- error "cgroup-network-helper.sh: DEBUG: virsh command is not available" with the lastest docker image [\#6073](https://github.com/netdata/netdata/issues/6073)
- Kickstart script verification md5sum is out of date, verification fails [\#6049](https://github.com/netdata/netdata/issues/6049)
- AWS Kinesis dependency [\#6002](https://github.com/netdata/netdata/issues/6002)
- HTTP requests are classified as AF\_UNIX [\#5987](https://github.com/netdata/netdata/issues/5987)
- swapio chart is missing on CentOS 7 [\#5845](https://github.com/netdata/netdata/issues/5845)
- Netdata behind caddy reverse proxy wont login. [\#5794](https://github.com/netdata/netdata/issues/5794)
- netdata/packaging/installer: error when running the kickstart and also when uninstalling it with uninstaller [\#5745](https://github.com/netdata/netdata/issues/5745)
- cgroups name resolution doesn't work \(on Raspbian\) [\#5314](https://github.com/netdata/netdata/issues/5314)
- Old Monit metrics still remains in Netdata even after Netdata restarted [\#5074](https://github.com/netdata/netdata/issues/5074)
- netdata/packaging/docker: Fix docker documentation and a fix to avoid failures [\#6344](https://github.com/netdata/netdata/pull/6344) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fix devuan support for initd [\#6275](https://github.com/netdata/netdata/pull/6275) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/docker: Fix docker socket utilization, first pass [\#6233](https://github.com/netdata/netdata/pull/6233) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/daemon: Eliminate a couple of warnings, plus tabs removal [\#6222](https://github.com/netdata/netdata/pull/6222) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/ci: Add lifecycle checks to bare operating system installations [\#6209](https://github.com/netdata/netdata/pull/6209) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/daemon: SSL fix - broken compilation case when ssl library not present! [\#6201](https://github.com/netdata/netdata/pull/6201) ([thiagoftsm](https://github.com/thiagoftsm))
- netdata/packaging/installer: Fix updater issue on empty config value [\#6182](https://github.com/netdata/netdata/pull/6182) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/installer: nits and fixes [\#6121](https://github.com/netdata/netdata/pull/6121) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata: Fix labels usage, quotes are not needed [\#6091](https://github.com/netdata/netdata/pull/6091) ([paulkatsoulakis](https://github.com/paulkatsoulakis))

**Closed issues:**

- \[QUESTION\] Show Docker Container without ID [\#6358](https://github.com/netdata/netdata/issues/6358)
- Allow user to configure the maximum number of File Descriptors for the netdata service [\#6313](https://github.com/netdata/netdata/issues/6313)
- XMPP/Jabber notification support [\#6292](https://github.com/netdata/netdata/issues/6292)
- collector/freeipmi - option to remove the ID added to the label [\#6284](https://github.com/netdata/netdata/issues/6284)
- FreeIPMI - option to remove the ID added to the label [\#6283](https://github.com/netdata/netdata/issues/6283)
- Scope of 1.16-rc2 [\#6243](https://github.com/netdata/netdata/issues/6243)
- Documentation improvements [\#6214](https://github.com/netdata/netdata/issues/6214)
- monitor dnsmasq dhcp server leases [\#6206](https://github.com/netdata/netdata/issues/6206)
- Pihole stats modules  [\#6204](https://github.com/netdata/netdata/issues/6204)
- Scope of 1.16-rc1 [\#6159](https://github.com/netdata/netdata/issues/6159)
- Netdata variable granularity Research [\#6148](https://github.com/netdata/netdata/issues/6148)
- SN\_EMPTY\_SLOT RRDDIMM value detection inside DB engine [\#6105](https://github.com/netdata/netdata/issues/6105)
- force page alignment per dimension of chart [\#6104](https://github.com/netdata/netdata/issues/6104)
- When the collector restarts after having stopped a long time ago fill the chart gaps efficiently [\#6103](https://github.com/netdata/netdata/issues/6103)
- Introduce cross-distro release testing on our CI  [\#6102](https://github.com/netdata/netdata/issues/6102)
- Optimize the memory footprint of the Database Engine [\#6010](https://github.com/netdata/netdata/issues/6010)
- phpdaemon monitoring [\#6006](https://github.com/netdata/netdata/issues/6006)
- Secure streaming via SSL [\#6004](https://github.com/netdata/netdata/issues/6004)
- \[Binary releases\] Optimise netdata.spec file [\#5969](https://github.com/netdata/netdata/issues/5969)
- \[Binary releases\] Create a script to containerise the RPM build process [\#5967](https://github.com/netdata/netdata/issues/5967)
- Clearer communiation of  telemetry [\#5863](https://github.com/netdata/netdata/issues/5863)
- alarm-notify.sh should respect the cloud base url setting [\#5791](https://github.com/netdata/netdata/issues/5791)
- Design k8s collector endpoint autodiscovery [\#5729](https://github.com/netdata/netdata/issues/5729)
- notify package maintainers of the new netdata releases [\#5682](https://github.com/netdata/netdata/issues/5682)
- \[preparation\] VMware Vsphere monitoring [\#5635](https://github.com/netdata/netdata/issues/5635)
- Feature: add VictoriaMetrics backend for long-term archiving [\#5619](https://github.com/netdata/netdata/issues/5619)
- Update docs for obsolete Python modules [\#5339](https://github.com/netdata/netdata/issues/5339)
- Hide: timestamps, memory values left, background and use graph as a gif [\#5186](https://github.com/netdata/netdata/issues/5186)
- Cookie consent for the Netdata sites [\#4798](https://github.com/netdata/netdata/issues/4798)
- netdata startup order on boot \(systemd\) [\#4266](https://github.com/netdata/netdata/issues/4266)
- RFC: registry v2 [\#3990](https://github.com/netdata/netdata/issues/3990)
- mail notifications wiki points to a non-existing file [\#3433](https://github.com/netdata/netdata/issues/3433)
- Simple way to disable alerts [\#3414](https://github.com/netdata/netdata/issues/3414)
- CPU performance monitoring [\#3232](https://github.com/netdata/netdata/issues/3232)
- \[RFE\] send notifications repeatedly until the alert is resolved [\#2956](https://github.com/netdata/netdata/issues/2956)
- allow netdata to know the plugin that collects each chart [\#2692](https://github.com/netdata/netdata/issues/2692)
- riak-rv support [\#2413](https://github.com/netdata/netdata/issues/2413)
- alarms to monitor the number of processes in a system [\#2239](https://github.com/netdata/netdata/issues/2239)
- Support OpenTSDB back-end via HTTP\(S\) API [\#1642](https://github.com/netdata/netdata/issues/1642)

**Merged pull requests:**

- Ignore /dev and /run space/inode usage [\#6399](https://github.com/netdata/netdata/pull/6399) ([vlvkobal](https://github.com/vlvkobal))
- Update favicon with new logo  [\#6398](https://github.com/netdata/netdata/pull/6398) ([cakrit](https://github.com/cakrit))
- Update apps\_groups.conf for time group [\#6397](https://github.com/netdata/netdata/pull/6397) ([mbarper](https://github.com/mbarper))
- Update to icons [\#6396](https://github.com/netdata/netdata/pull/6396) ([ivorjvr](https://github.com/ivorjvr))
- Changed links from my-netdata.io to netdata.cloud [\#6389](https://github.com/netdata/netdata/pull/6389) ([joelhans](https://github.com/joelhans))
- alarm-notify.sh should respect the cloud base url setting  [\#6383](https://github.com/netdata/netdata/pull/6383) ([ladakis](https://github.com/ladakis))
- Add a check for a macro declaration for the perf plugin [\#6382](https://github.com/netdata/netdata/pull/6382) ([vlvkobal](https://github.com/vlvkobal))
- Add a .gitattributes file [\#6381](https://github.com/netdata/netdata/pull/6381) ([ac000](https://github.com/ac000))
- Health fix double Free Corruption [\#6379](https://github.com/netdata/netdata/pull/6379) ([thiagoftsm](https://github.com/thiagoftsm))
- Health giving wrong message [\#6377](https://github.com/netdata/netdata/pull/6377) ([thiagoftsm](https://github.com/thiagoftsm))
- Health could not read properly the health silencers file [\#6374](https://github.com/netdata/netdata/pull/6374) ([thiagoftsm](https://github.com/thiagoftsm))
- Add more debug messages for pluginsd pipe errors [\#6373](https://github.com/netdata/netdata/pull/6373) ([vlvkobal](https://github.com/vlvkobal))
- Improve documentation about file descriptors and systemd configuration. [\#6372](https://github.com/netdata/netdata/pull/6372) ([mfundul](https://github.com/mfundul))
- netdata/packaging: Netdata binary packages generation - spec file refinement, support for nightlies \(RPM\) [\#6369](https://github.com/netdata/netdata/pull/6369) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- apps.plugin: detect openldap server processes by default on Debian [\#6364](https://github.com/netdata/netdata/pull/6364) ([nodiscc](https://github.com/nodiscc))
- Easily disable alarms, by persisting the silencers configuration [\#6360](https://github.com/netdata/netdata/pull/6360) ([thiagoftsm](https://github.com/thiagoftsm))
- Redirect old site to new site at www.netdata.cloud [\#6359](https://github.com/netdata/netdata/pull/6359) ([cakrit](https://github.com/cakrit))
- Better checks for nfacct headers [\#6351](https://github.com/netdata/netdata/pull/6351) ([vlvkobal](https://github.com/vlvkobal))
- Tomcat status invalid XML fix [\#6345](https://github.com/netdata/netdata/pull/6345) ([Danamir](https://github.com/Danamir))
- pihole: alarms delay fix [\#6342](https://github.com/netdata/netdata/pull/6342) ([ilyam8](https://github.com/ilyam8))
- monit: obsolete service in runtime [\#6340](https://github.com/netdata/netdata/pull/6340) ([ilyam8](https://github.com/ilyam8))
- adaptec\_raid: logical device regex fix [\#6338](https://github.com/netdata/netdata/pull/6338) ([ilyam8](https://github.com/ilyam8))
- Better context name to client context [\#6336](https://github.com/netdata/netdata/pull/6336) ([thiagoftsm](https://github.com/thiagoftsm))
- installer: include go.d.plugin version v0.7.0 [\#6328](https://github.com/netdata/netdata/pull/6328) ([ilyam8](https://github.com/ilyam8))
- pihole: add to the dashboard\_info [\#6325](https://github.com/netdata/netdata/pull/6325) ([ilyam8](https://github.com/ilyam8))
- pihole collector: add alarms [\#6320](https://github.com/netdata/netdata/pull/6320) ([ilyam8](https://github.com/ilyam8))
- dnsmasq\_dhcp: dhcp-range utilization alarm [\#6319](https://github.com/netdata/netdata/pull/6319) ([ilyam8](https://github.com/ilyam8))
- Update the documentation on charts with zero metrics [\#6314](https://github.com/netdata/netdata/pull/6314) ([vlvkobal](https://github.com/vlvkobal))
- fix elasticsearch plugin [\#6311](https://github.com/netdata/netdata/pull/6311) ([Wing924](https://github.com/Wing924))
- Repeating alarm notifications [\#6309](https://github.com/netdata/netdata/pull/6309) ([thiagoftsm](https://github.com/thiagoftsm))
- Chart name streaming [\#6304](https://github.com/netdata/netdata/pull/6304) ([vlvkobal](https://github.com/vlvkobal))
- Handle file descriptors running out [\#6303](https://github.com/netdata/netdata/pull/6303) ([mfundul](https://github.com/mfundul))
- Add note regarding libexecdir [\#6301](https://github.com/netdata/netdata/pull/6301) ([cakrit](https://github.com/cakrit))
- stale bot limits update [\#6297](https://github.com/netdata/netdata/pull/6297) ([ilyam8](https://github.com/ilyam8))
- \[freeipmi\] Remove id in sensor name when already unique [\#6296](https://github.com/netdata/netdata/pull/6296) ([Saruspete](https://github.com/Saruspete))
- Web [\#6294](https://github.com/netdata/netdata/pull/6294) ([thiagoftsm](https://github.com/thiagoftsm))
- doc: remove single/multi-threaded web server configuration [\#6291](https://github.com/netdata/netdata/pull/6291) ([nodiscc](https://github.com/nodiscc))
- Add a riak plugin [\#6286](https://github.com/netdata/netdata/pull/6286) ([jchristgit](https://github.com/jchristgit))
- netdata/packaging: Separate beta messages from production messages [\#6282](https://github.com/netdata/netdata/pull/6282) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Add more info on the stream.conf health enabled by default = auto option [\#6281](https://github.com/netdata/netdata/pull/6281) ([cakrit](https://github.com/cakrit))
- Add comments about AWS SDK for C++ installation [\#6277](https://github.com/netdata/netdata/pull/6277) ([vlvkobal](https://github.com/vlvkobal))
- Easily disable alarms, by persisting the silencers configuration [\#6274](https://github.com/netdata/netdata/pull/6274) ([thiagoftsm](https://github.com/thiagoftsm))
- netdata/packaging: During install,  many file not found were raised [\#6272](https://github.com/netdata/netdata/pull/6272) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/documentation: Its Redhat, then came the others [\#6271](https://github.com/netdata/netdata/pull/6271) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging: Adjust CI notification logic [\#6268](https://github.com/netdata/netdata/pull/6268) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Update README.md [\#6264](https://github.com/netdata/netdata/pull/6264) ([mfundul](https://github.com/mfundul))
- UrlService: add min required version check [\#6263](https://github.com/netdata/netdata/pull/6263) ([ilyam8](https://github.com/ilyam8))
- Fix variable namespace in memory health check [\#6261](https://github.com/netdata/netdata/pull/6261) ([octomike](https://github.com/octomike))
- Fix typo in nfacct.plugin [\#6260](https://github.com/netdata/netdata/pull/6260) ([vlvkobal](https://github.com/vlvkobal))
- netdata/packaging: Fix netdata/netdata docker image failure, when users passing PGID that already exists on the system [\#6259](https://github.com/netdata/netdata/pull/6259) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- PR to fix issue \#6238 [\#6242](https://github.com/netdata/netdata/pull/6242) ([thiagoftsm](https://github.com/thiagoftsm))
- Update CODEOWNERS [\#6241](https://github.com/netdata/netdata/pull/6241) ([cakrit](https://github.com/cakrit))
- Force page alignment per dimension of chart. [\#6240](https://github.com/netdata/netdata/pull/6240) ([mfundul](https://github.com/mfundul))
- dns\_query\_time py module: saving dns request in 'r', checking response for answer, recording '-… [\#6237](https://github.com/netdata/netdata/pull/6237) ([n0coast](https://github.com/n0coast))
- netdata/packaging: Add more distribution validations [\#6235](https://github.com/netdata/netdata/pull/6235) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Remove CNCF logo and TOC presentation reference [\#6234](https://github.com/netdata/netdata/pull/6234) ([dankohn](https://github.com/dankohn))
- URL\_parser fixing allmetrics! [\#6231](https://github.com/netdata/netdata/pull/6231) ([thiagoftsm](https://github.com/thiagoftsm))
- Perf plugin [\#6225](https://github.com/netdata/netdata/pull/6225) ([vlvkobal](https://github.com/vlvkobal))
- netdata/packaging: Introducing automatic binary packages generation and delivery for RPM types \(Phase 1\) [\#6223](https://github.com/netdata/netdata/pull/6223) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Backend and SSL! [\#6220](https://github.com/netdata/netdata/pull/6220) ([thiagoftsm](https://github.com/thiagoftsm))
- SSL\_fix\_format Fix wrong format used with SSL! [\#6219](https://github.com/netdata/netdata/pull/6219) ([thiagoftsm](https://github.com/thiagoftsm))
- installer: include go.d.plugin version v0.6.1 [\#6217](https://github.com/netdata/netdata/pull/6217) ([ilyam8](https://github.com/ilyam8))
- Fill chart gaps efficiently. [\#6216](https://github.com/netdata/netdata/pull/6216) ([mfundul](https://github.com/mfundul))
- Add code style guidance to CONTRIBUTING [\#6212](https://github.com/netdata/netdata/pull/6212) ([cakrit](https://github.com/cakrit))
- Simplify health cmdapi tester - no setup/cleanup needed [\#6210](https://github.com/netdata/netdata/pull/6210) ([cakrit](https://github.com/cakrit))
- Visibility fix in anonymous-statistics.md [\#6208](https://github.com/netdata/netdata/pull/6208) ([cakrit](https://github.com/cakrit))
- smartd documentation improvements [\#6207](https://github.com/netdata/netdata/pull/6207) ([cakrit](https://github.com/cakrit))
- Add note to make smartd directory [\#6203](https://github.com/netdata/netdata/pull/6203) ([Steve8291](https://github.com/Steve8291))
- Fix page cache descriptor race condition [\#6202](https://github.com/netdata/netdata/pull/6202) ([mfundul](https://github.com/mfundul))
- Turn tv.html links to https [\#6198](https://github.com/netdata/netdata/pull/6198) ([cakrit](https://github.com/cakrit))
- wmi collector: `fa-server` icon [\#6197](https://github.com/netdata/netdata/pull/6197) ([ilyam8](https://github.com/ilyam8))
- Change print level from error to info [\#6195](https://github.com/netdata/netdata/pull/6195) ([mfundul](https://github.com/mfundul))
- health: change x509check\_last\_collected\_secs alarm every to 60s [\#6194](https://github.com/netdata/netdata/pull/6194) ([ilyam8](https://github.com/ilyam8))
- Documentation: Correct example list for python.d SimpleService [\#6189](https://github.com/netdata/netdata/pull/6189) ([kvisle](https://github.com/kvisle))
- Terminate email header lines with \r\n [\#6187](https://github.com/netdata/netdata/pull/6187) ([toofar](https://github.com/toofar))
- Make custom notification's instructions clearer [\#6181](https://github.com/netdata/netdata/pull/6181) ([cakrit](https://github.com/cakrit))
- web log pattern fix [\#6180](https://github.com/netdata/netdata/pull/6180) ([ilyam8](https://github.com/ilyam8))
- Correct date used in pushbullet notifications [\#6179](https://github.com/netdata/netdata/pull/6179) ([cakrit](https://github.com/cakrit))
- Support falling back to buffered I/O when direct I/O is unavailable [\#6174](https://github.com/netdata/netdata/pull/6174) ([mfundul](https://github.com/mfundul))
- Add empty page detection in DB engine [\#6173](https://github.com/netdata/netdata/pull/6173) ([mfundul](https://github.com/mfundul))
- Increase the cpu\_limit chart precision in cgroup plugin [\#6172](https://github.com/netdata/netdata/pull/6172) ([vlvkobal](https://github.com/vlvkobal))
- varnish v4 compatibility fix [\#6168](https://github.com/netdata/netdata/pull/6168) ([ilyam8](https://github.com/ilyam8))
- Update security policy [\#6166](https://github.com/netdata/netdata/pull/6166) ([cakrit](https://github.com/cakrit))
- Fix mdstat disks chart [\#6164](https://github.com/netdata/netdata/pull/6164) ([vlvkobal](https://github.com/vlvkobal))
- Properly add security policy [\#6163](https://github.com/netdata/netdata/pull/6163) ([cakrit](https://github.com/cakrit))
- Fix typo in README [\#6146](https://github.com/netdata/netdata/pull/6146) ([cakrit](https://github.com/cakrit))
- Documentation fixes [\#6144](https://github.com/netdata/netdata/pull/6144) ([cakrit](https://github.com/cakrit))
- x509check: add last\_collected alarm [\#6139](https://github.com/netdata/netdata/pull/6139) ([ilyam8](https://github.com/ilyam8))
- web\_log: remove trailing space from nginx\_ext2 pattern [\#6138](https://github.com/netdata/netdata/pull/6138) ([ilyam8](https://github.com/ilyam8))
- Change 'netdata' to 'Netdata' in /docs/ and /README.md [\#6137](https://github.com/netdata/netdata/pull/6137) ([apardyl](https://github.com/apardyl))
- DB engine optimize RAM usage [\#6134](https://github.com/netdata/netdata/pull/6134) ([mfundul](https://github.com/mfundul))
- Optimize calls that gather system info [\#6128](https://github.com/netdata/netdata/pull/6128) ([cakrit](https://github.com/cakrit))
- Fix telemetry config in netdata-installer [\#6127](https://github.com/netdata/netdata/pull/6127) ([cakrit](https://github.com/cakrit))
- Pass correct info to run funct. [\#6126](https://github.com/netdata/netdata/pull/6126) ([Steve8291](https://github.com/Steve8291))
- Add modules to charts.d.conf [\#6120](https://github.com/netdata/netdata/pull/6120) ([Steve8291](https://github.com/Steve8291))
- add userstats charts for mysql [\#6118](https://github.com/netdata/netdata/pull/6118) ([kam1kaze](https://github.com/kam1kaze))
- Active processes number alert [\#6116](https://github.com/netdata/netdata/pull/6116) ([apardyl](https://github.com/apardyl))
- add mysql deadlocks chart [\#6115](https://github.com/netdata/netdata/pull/6115) ([kam1kaze](https://github.com/kam1kaze))
- Remove system\_info copying [\#6113](https://github.com/netdata/netdata/pull/6113) ([vlvkobal](https://github.com/vlvkobal))
- Fix incorrect module name: energi [\#6112](https://github.com/netdata/netdata/pull/6112) ([Steve8291](https://github.com/Steve8291))
- Update README.md [\#6111](https://github.com/netdata/netdata/pull/6111) ([mfundul](https://github.com/mfundul))
- installer: include go.d.plugin version v0.6.0 [\#6097](https://github.com/netdata/netdata/pull/6097) ([ilyam8](https://github.com/ilyam8))
- Move call to send\_statistics later, to get more events from docker [\#6096](https://github.com/netdata/netdata/pull/6096) ([cakrit](https://github.com/cakrit))
- Fix path \#6085 [\#6093](https://github.com/netdata/netdata/pull/6093) ([gmosx](https://github.com/gmosx))
- Fix minor typos [\#6090](https://github.com/netdata/netdata/pull/6090) ([Steve8291](https://github.com/Steve8291))
- Create missing /etc/netdata/custom-plugins.d [\#6089](https://github.com/netdata/netdata/pull/6089) ([Steve8291](https://github.com/Steve8291))
- Corrected links to web\_log.conf [\#6087](https://github.com/netdata/netdata/pull/6087) ([cakrit](https://github.com/cakrit))
- Mention anonymous statistics in additional places in the docs [\#6084](https://github.com/netdata/netdata/pull/6084) ([cakrit](https://github.com/cakrit))
- Add "custom-plugins.d" to fix error in log file [\#6080](https://github.com/netdata/netdata/pull/6080) ([Steve8291](https://github.com/Steve8291))
- New URL parser [\#6070](https://github.com/netdata/netdata/pull/6070) ([thiagoftsm](https://github.com/thiagoftsm))
- wmi alarms [\#6068](https://github.com/netdata/netdata/pull/6068) ([ilyam8](https://github.com/ilyam8))
- Add perforce server process monitoring [\#6064](https://github.com/netdata/netdata/pull/6064) ([akwan](https://github.com/akwan))
- Prometheus remote write backend [\#6062](https://github.com/netdata/netdata/pull/6062) ([vlvkobal](https://github.com/vlvkobal))
- SSL implementation for Netdata [\#5956](https://github.com/netdata/netdata/pull/5956) ([thiagoftsm](https://github.com/thiagoftsm))
- NEW: local remark-lint checks and autofix support [\#5898](https://github.com/netdata/netdata/pull/5898) ([andvgal](https://github.com/andvgal))
- use github templating mechanisms to classify issues when they are created [\#5776](https://github.com/netdata/netdata/pull/5776) ([paulfantom](https://github.com/paulfantom))

## [v1.15.0](https://github.com/netdata/netdata/tree/v1.15.0) (2019-05-22)

**Fixed bugs:**

- Fix rrdengineapi compiler warning [\#6075](https://github.com/netdata/netdata/issues/6075)
- New dbengine stil creates directories for individual charts in the cache directory. [\#6067](https://github.com/netdata/netdata/issues/6067)
- v1.15.0 fails to build due to missing CFLAGS [\#6066](https://github.com/netdata/netdata/issues/6066)
- netdata/dbengine: constant restarts on octopuscs [\#6053](https://github.com/netdata/netdata/issues/6053)
- Nodes are inconsistently unreachables [\#6051](https://github.com/netdata/netdata/issues/6051)
- BUG when compiling code in mac OS [\#6043](https://github.com/netdata/netdata/issues/6043)
- Unexpected change to metrics sent to backends with new dbengine [\#6039](https://github.com/netdata/netdata/issues/6039)
- packages installer failed [\#6027](https://github.com/netdata/netdata/issues/6027)
- netdata/packaging: Fix installer failure on missing packages [\#6026](https://github.com/netdata/netdata/issues/6026)
- Prowl notifications ignored by alarm-notify.sh [\#6021](https://github.com/netdata/netdata/issues/6021)
- using with docker. got error after update. [\#6018](https://github.com/netdata/netdata/issues/6018)
- Segfault on NetData v1.14.0-51-g18336910 [\#6013](https://github.com/netdata/netdata/issues/6013)
- Slack does not send to channel [\#6003](https://github.com/netdata/netdata/issues/6003)
- api/v1/chart and api/v1/data calls don't return chart variables names, values [\#5990](https://github.com/netdata/netdata/issues/5990)
- elasticsearch throws exception and kills whole python.d [\#5978](https://github.com/netdata/netdata/issues/5978)
- System info doesn't show OS name and version in Mac OS X [\#5950](https://github.com/netdata/netdata/issues/5950)
- nvidia\_smi wrong power draw numbers [\#5939](https://github.com/netdata/netdata/issues/5939)
- Coverity Scan issues on get\_system\_info [\#5937](https://github.com/netdata/netdata/issues/5937)
- `timeout` requires flag [\#5935](https://github.com/netdata/netdata/issues/5935)
- docker image is missing nut package [\#5934](https://github.com/netdata/netdata/issues/5934)
- mongodb error exception on check : ‘locks’ [\#5929](https://github.com/netdata/netdata/issues/5929)
- v1.14.0 is released but status is draft [\#5921](https://github.com/netdata/netdata/issues/5921)
- Weird WD values [\#5919](https://github.com/netdata/netdata/issues/5919)
- Alert badge not showing after reverse proxy [\#5900](https://github.com/netdata/netdata/issues/5900)
- Docker image has plugins not executable for netdata user [\#5890](https://github.com/netdata/netdata/issues/5890)
- cgroup-network-helper.sh issues in our Docker images [\#5880](https://github.com/netdata/netdata/issues/5880)
- Fix dependency installation for Fedora 30 [\#5831](https://github.com/netdata/netdata/issues/5831)
- netdata/packaging: Fix pipeline so that it detects possible updater issues [\#5786](https://github.com/netdata/netdata/issues/5786)
- netdata/packaging/installer: User management during install/uninstall broken for MacOS [\#5737](https://github.com/netdata/netdata/issues/5737)
- netdata/packaging/ci: Investigate pipeline failure [\#5733](https://github.com/netdata/netdata/issues/5733)
- netdata-updater should remain after all installations [\#5673](https://github.com/netdata/netdata/issues/5673)
- \[Question\] Are python-pymongo and python-yaml needed for a barebones install of netdata? [\#5632](https://github.com/netdata/netdata/issues/5632)
- python SocketService: lack of connect timeout, python.d.plugin hangs [\#5541](https://github.com/netdata/netdata/issues/5541)
- installer wrong message on centos [\#5474](https://github.com/netdata/netdata/issues/5474)
- Misleading information on memory consumption [\#5203](https://github.com/netdata/netdata/issues/5203)
- File not found by glob when building an rpm \(latest code - 20181218\) [\#5033](https://github.com/netdata/netdata/issues/5033)
- Issue creating deb package from v1.11.1 [\#4979](https://github.com/netdata/netdata/issues/4979)
- netdata service fails to start - pfsense [\#3469](https://github.com/netdata/netdata/issues/3469)
- netdata/packaging: Fix kickstart/kickstart-static64 formatting bugs [\#6048](https://github.com/netdata/netdata/pull/6048) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging: install/uninstall fixes for macOS case [\#6045](https://github.com/netdata/netdata/pull/6045) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging: Adjust auto-updater installation logic [\#6035](https://github.com/netdata/netdata/pull/6035) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging: Fix broken netdata docker image for dbengine-enabled code [\#6020](https://github.com/netdata/netdata/pull/6020) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fix segmentation fault [\#6011](https://github.com/netdata/netdata/pull/6011) ([vlvkobal](https://github.com/vlvkobal))
- netdata/packaging: Fix failing CI nightly process [\#6007](https://github.com/netdata/netdata/pull/6007) ([paulkatsoulakis](https://github.com/paulkatsoulakis))

**Closed issues:**

- \[feature\] collects windows metrics from wmi\_exporter [\#6001](https://github.com/netdata/netdata/issues/6001)
- \[Binary releases\] Establish RPM repository servers and software [\#5966](https://github.com/netdata/netdata/issues/5966)
- \[Binary releases\] Establish Debian/Ubuntu repository servers and software [\#5965](https://github.com/netdata/netdata/issues/5965)
- Add collectors list and system information to /api/v1/info [\#5888](https://github.com/netdata/netdata/issues/5888)
- Database engine internal stress testing [\#5879](https://github.com/netdata/netdata/issues/5879)
- Database engine testing by the netdata team [\#5878](https://github.com/netdata/netdata/issues/5878)
- research: docker swarm [\#5877](https://github.com/netdata/netdata/issues/5877)
- research: ScaleIO [\#5876](https://github.com/netdata/netdata/issues/5876)
- Implement CPU limits for cgroup v2 [\#5850](https://github.com/netdata/netdata/issues/5850)
- feature: kubelet collector improvements \(leftovers from \#5720\) [\#5824](https://github.com/netdata/netdata/issues/5824)
- fresh install of ubuntu 18.04.1 and netdata missing no "read" showing up in Disk [\#5817](https://github.com/netdata/netdata/issues/5817)
- netdata/packaging: \[SPIKE\] Investigate CPack/CMake status, clarify and estimate the available approaches [\#5775](https://github.com/netdata/netdata/issues/5775)
- "Healthy" entrypoint for HTTP-interface [\#5764](https://github.com/netdata/netdata/issues/5764)
- netdata/packaging/ci: Create and document a manual nightly deployment procedure [\#5762](https://github.com/netdata/netdata/issues/5762)
- feature: collect docker swarm metrics [\#5710](https://github.com/netdata/netdata/issues/5710)
- snmp-trap receiver [\#5597](https://github.com/netdata/netdata/issues/5597)
- AWS Kinesis as backend collector [\#5596](https://github.com/netdata/netdata/issues/5596)
- Travis CI should upload docker images for PRs to docker hub [\#5583](https://github.com/netdata/netdata/issues/5583)
- Custom dashboard - Just displaying a number [\#5578](https://github.com/netdata/netdata/issues/5578)
- Prototype for netdata internal database v2.0 [\#5303](https://github.com/netdata/netdata/issues/5303)
- Tengine monitoring [\#4886](https://github.com/netdata/netdata/issues/4886)
- Scaleio monitoring [\#4825](https://github.com/netdata/netdata/issues/4825)
- Monitor disk access latency \(e.g. ioping\) [\#4660](https://github.com/netdata/netdata/issues/4660)
- provide binary repos for main distros [\#2728](https://github.com/netdata/netdata/issues/2728)
- RPM Packaging Discussion [\#1306](https://github.com/netdata/netdata/issues/1306)
- Setup PPA for Debian systems [\#1302](https://github.com/netdata/netdata/issues/1302)
- Binary release [\#87](https://github.com/netdata/netdata/issues/87)
- Provide Ubuntu PPA [\#69](https://github.com/netdata/netdata/issues/69)
- Build packaging for debian [\#42](https://github.com/netdata/netdata/issues/42)

**Merged pull requests:**

- Shorten netdata version and correctly send OS\_VERSION\_ID [\#6082](https://github.com/netdata/netdata/pull/6082) ([cakrit](https://github.com/cakrit))
- Fix build errors [\#6081](https://github.com/netdata/netdata/pull/6081) ([mfundul](https://github.com/mfundul))
- Fix race condition in DB engine API [\#6079](https://github.com/netdata/netdata/pull/6079) ([mfundul](https://github.com/mfundul))
- Fix creating chart directories when not necessary with memory mode dbengine [\#6078](https://github.com/netdata/netdata/pull/6078) ([mfundul](https://github.com/mfundul))
- Add more metrics to the prometheus bats tests [\#6074](https://github.com/netdata/netdata/pull/6074) ([cakrit](https://github.com/cakrit))
- Add 1.15 to news section of main README [\#6065](https://github.com/netdata/netdata/pull/6065) ([cakrit](https://github.com/cakrit))
- Fix delete datafile error [\#6057](https://github.com/netdata/netdata/pull/6057) ([mfundul](https://github.com/mfundul))
- Update swagger with definition of api/v1/alarm\_variables [\#6055](https://github.com/netdata/netdata/pull/6055) ([cakrit](https://github.com/cakrit))
- Reiterate the proper way to persist configurations in the Configuration guid [\#6052](https://github.com/netdata/netdata/pull/6052) ([cakrit](https://github.com/cakrit))
- netdata/daemon/backends: Fix AWS Kinesis link error [\#6047](https://github.com/netdata/netdata/pull/6047) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging: Fix makeself packaging [\#6041](https://github.com/netdata/netdata/pull/6041) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fix timestamps being reversed for backends [\#6040](https://github.com/netdata/netdata/pull/6040) ([mfundul](https://github.com/mfundul))
- Improve paragraphs in HTML docs [\#6032](https://github.com/netdata/netdata/pull/6032) ([cakrit](https://github.com/cakrit))
- Reduce HTML documentation font size [\#6030](https://github.com/netdata/netdata/pull/6030) ([cakrit](https://github.com/cakrit))
- Add database engine doc to the menu [\#6029](https://github.com/netdata/netdata/pull/6029) ([cakrit](https://github.com/cakrit))
- Minor improvements for Nodes integration [\#6028](https://github.com/netdata/netdata/pull/6028) ([gmosx](https://github.com/gmosx))
- installer: include go.d.plugin version v0.5.0 [\#6025](https://github.com/netdata/netdata/pull/6025) ([ilyam8](https://github.com/ilyam8))
- netdata/packaging: Fine tune documentation on how to test docker images [\#6024](https://github.com/netdata/netdata/pull/6024) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Add prowl to list of methods checked for enablement of notifications [\#6022](https://github.com/netdata/netdata/pull/6022) ([cakrit](https://github.com/cakrit))
- Correct instructions on Slack webhooks [\#6016](https://github.com/netdata/netdata/pull/6016) ([cakrit](https://github.com/cakrit))
- netdata/packaging: Make docker image bring onboard the required packages for the new DB [\#6014](https://github.com/netdata/netdata/pull/6014) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fix Coverity defects [\#6008](https://github.com/netdata/netdata/pull/6008) ([vlvkobal](https://github.com/vlvkobal))
- Do not cache alarms and info api calls. Extend no-cache headers. [\#5999](https://github.com/netdata/netdata/pull/5999) ([cakrit](https://github.com/cakrit))
- UserService self.\_get\_raw\_data except fix [\#5997](https://github.com/netdata/netdata/pull/5997) ([ilyam8](https://github.com/ilyam8))
- Add system info streaming [\#5996](https://github.com/netdata/netdata/pull/5996) ([vlvkobal](https://github.com/vlvkobal))
- Provide sample implementation for custom notifications [\#5992](https://github.com/netdata/netdata/pull/5992) ([cakrit](https://github.com/cakrit))
- \(Docs\) fix pfsense instructions [\#5982](https://github.com/netdata/netdata/pull/5982) ([Fohdeesha](https://github.com/Fohdeesha))
- fix typo in the mysql graph [\#5980](https://github.com/netdata/netdata/pull/5980) ([kam1kaze](https://github.com/kam1kaze))
- Change HTTP version to HTTP method [\#5974](https://github.com/netdata/netdata/pull/5974) ([SahAssar](https://github.com/SahAssar))
- Add "text-only" chart renderer [\#5971](https://github.com/netdata/netdata/pull/5971) ([Daniel15](https://github.com/Daniel15))
- Update Node app\_group [\#5962](https://github.com/netdata/netdata/pull/5962) ([jonfairbanks](https://github.com/jonfairbanks))
- Fix coverity warnings [\#5952](https://github.com/netdata/netdata/pull/5952) ([cakrit](https://github.com/cakrit))
- Add support for Mac OS X Name and Version [\#5949](https://github.com/netdata/netdata/pull/5949) ([cakrit](https://github.com/cakrit))
- netdata/packaging: Do not install netdata service when within docker [\#5947](https://github.com/netdata/netdata/pull/5947) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- nvidia\_smi: power chart algorithm,mul,div fix [\#5940](https://github.com/netdata/netdata/pull/5940) ([ilyam8](https://github.com/ilyam8))
- netdata/packaging/ci:  Make timeout usage more cross-distro compliant [\#5938](https://github.com/netdata/netdata/pull/5938) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fixing a typo in documentation [\#5936](https://github.com/netdata/netdata/pull/5936) ([smonff](https://github.com/smonff))
- mongodb: various KeyError  fixes [\#5931](https://github.com/netdata/netdata/pull/5931) ([ilyam8](https://github.com/ilyam8))
- netdata/packaging/ci: minor improvements [\#5928](https://github.com/netdata/netdata/pull/5928) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- smartd\_log: attrs 3, 194 fix [\#5923](https://github.com/netdata/netdata/pull/5923) ([ilyam8](https://github.com/ilyam8))
- Fix lifecycle script [\#5918](https://github.com/netdata/netdata/pull/5918) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/docker: fix docker permissions and other things [\#5917](https://github.com/netdata/netdata/pull/5917) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Add AWS Kinesis backend [\#5914](https://github.com/netdata/netdata/pull/5914) ([vlvkobal](https://github.com/vlvkobal))
- SocketService: set socket operation timeout before connecting [\#5911](https://github.com/netdata/netdata/pull/5911) ([ilyam8](https://github.com/ilyam8))
- Support for aggregate node view [\#5902](https://github.com/netdata/netdata/pull/5902) ([gmosx](https://github.com/gmosx))
- netdata/packaging/ci: Create manual nightly deployment tool [\#5899](https://github.com/netdata/netdata/pull/5899) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Implement unified cgroup cpu limit [\#5895](https://github.com/netdata/netdata/pull/5895) ([skrzyp1](https://github.com/skrzyp1))
- NEW: Energi Core daemon monitoring, suits other Bitcoin forks [\#5894](https://github.com/netdata/netdata/pull/5894) ([andvgal](https://github.com/andvgal))
- NEW: allow additional name argument passing to urllib3 request in UrlService [\#5893](https://github.com/netdata/netdata/pull/5893) ([andvgal](https://github.com/andvgal))
- Initial script for API load testing [\#5892](https://github.com/netdata/netdata/pull/5892) ([cakrit](https://github.com/cakrit))
- info API minor enhancements [\#5891](https://github.com/netdata/netdata/pull/5891) ([cakrit](https://github.com/cakrit))
- Extend netdata info API call [\#5889](https://github.com/netdata/netdata/pull/5889) ([cakrit](https://github.com/cakrit))
- Add ioping plugin [\#5725](https://github.com/netdata/netdata/pull/5725) ([vlvkobal](https://github.com/vlvkobal))
- Database engine [\#5282](https://github.com/netdata/netdata/pull/5282) ([mfundul](https://github.com/mfundul))

## [v1.14.0](https://github.com/netdata/netdata/tree/v1.14.0) (2019-04-18)

**Fixed bugs:**

- Follow up adjustment of plugin permissions [\#5858](https://github.com/netdata/netdata/issues/5858)
- netdata/packaging: In particular cases netdata binary produces broken version string [\#5855](https://github.com/netdata/netdata/issues/5855)
- python module autodetection\_retry don't work as expected [\#5832](https://github.com/netdata/netdata/issues/5832)
- CouchDB collector exception [\#5830](https://github.com/netdata/netdata/issues/5830)
- Segfault when using postgres plugin [\#5829](https://github.com/netdata/netdata/issues/5829)
- macOS: python.d.plugin crashes on start [\#5821](https://github.com/netdata/netdata/issues/5821)
- Travis: Nightlies job fails when no changes in the code [\#5815](https://github.com/netdata/netdata/issues/5815)
- Errorneous netdata version [\#5808](https://github.com/netdata/netdata/issues/5808)
- Kickstart-static64.sh installation problems [\#5807](https://github.com/netdata/netdata/issues/5807)
- Netdata Installer : $NETDATA\_USER not defined ? [\#5803](https://github.com/netdata/netdata/issues/5803)
- Typo in netdata-updater [\#5781](https://github.com/netdata/netdata/issues/5781)
- Kickstart installer fails to due missing function [\#5768](https://github.com/netdata/netdata/issues/5768)
- smstools 3 notifications error handling [\#5767](https://github.com/netdata/netdata/issues/5767)
- netdata-installer.sh: sha256sum binaries do not exist in FreeBSD [\#5747](https://github.com/netdata/netdata/issues/5747)
- netdata/packaging/build: Build getting broken sporadically at times in py2-psycopg2 package [\#5713](https://github.com/netdata/netdata/issues/5713)
- netdata-updater broke [\#5529](https://github.com/netdata/netdata/issues/5529)
- centos6: python.d.plugin zombie process after netdata restart [\#5491](https://github.com/netdata/netdata/issues/5491)
- Socket proxying through unix socket doesnt work in FreeBSD 12 [\#5178](https://github.com/netdata/netdata/issues/5178)
- netdata/packaging/ci: Do not trigger deployment if certain conditions are not met [\#5816](https://github.com/netdata/netdata/pull/5816) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/installer: HoS situation - Fix broken install-or-update script [\#5806](https://github.com/netdata/netdata/pull/5806) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging: Fix non compatible function declaration [\#5789](https://github.com/netdata/netdata/pull/5789) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Make netdata.spec more futureproof [\#5766](https://github.com/netdata/netdata/pull/5766) ([nichivo](https://github.com/nichivo))

**Closed issues:**

- API Key not enabled [\#5869](https://github.com/netdata/netdata/issues/5869)
- last\_collected\_secs health check for phpfpm [\#5820](https://github.com/netdata/netdata/issues/5820)
- update  /packaging/docker/README.md  in Mac OS run build [\#5818](https://github.com/netdata/netdata/issues/5818)
- feature: LDAPS support for openldap-collector [\#5783](https://github.com/netdata/netdata/issues/5783)
- Add execution of updated kickstart scripts to the CI pipeline [\#5769](https://github.com/netdata/netdata/issues/5769)
- netdata/packaging/ci: re-design travis pipeline [\#5761](https://github.com/netdata/netdata/issues/5761)
- feature: kubelet collector improvements [\#5720](https://github.com/netdata/netdata/issues/5720)
- How can i set syslog facility for netdata daemon? [\#5717](https://github.com/netdata/netdata/issues/5717)
- netdata/packaging: Master issue - overall building pipelines cleanup: improvements, bug fixes, etc [\#5716](https://github.com/netdata/netdata/issues/5716)
- feature: openvpn module - use management interface [\#5699](https://github.com/netdata/netdata/issues/5699)
- feature: postgres module add connection via URI [\#5684](https://github.com/netdata/netdata/issues/5684)
- Status of netdata/binary-packages [\#5671](https://github.com/netdata/netdata/issues/5671)
- Full integration with netdata of the new database implementation [\#5641](https://github.com/netdata/netdata/issues/5641)
- Ensure that `jq` is available in netdata installations  [\#5621](https://github.com/netdata/netdata/issues/5621)
- Can I check monthly or daily reports or history [\#5287](https://github.com/netdata/netdata/issues/5287)
- SSL support for Elasticsearch plugin [\#5179](https://github.com/netdata/netdata/issues/5179)
- support filtering disk naming by id [\#4957](https://github.com/netdata/netdata/issues/4957)
- CoreDNS monitoring [\#4861](https://github.com/netdata/netdata/issues/4861)
- Netdata's cgroup tracking does not work with version 2 cgroups. [\#3750](https://github.com/netdata/netdata/issues/3750)

**Merged pull requests:**

- Pipeline redesign master [\#5885](https://github.com/netdata/netdata/pull/5885) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fix segmentation fault in streaming [\#5882](https://github.com/netdata/netdata/pull/5882) ([vlvkobal](https://github.com/vlvkobal))
- netdata/packaging/ci: Use proper notifier in slack message [\#5866](https://github.com/netdata/netdata/pull/5866) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/installer: Dont use --always in git describe. [\#5860](https://github.com/netdata/netdata/pull/5860) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Openldap tls support rebased [\#5859](https://github.com/netdata/netdata/pull/5859) ([ekartsonakis](https://github.com/ekartsonakis))
- netdata/packaging/installer: correlate permissions amongst plugins to 0750 [\#5856](https://github.com/netdata/netdata/pull/5856) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/web/gui/dashboard: do not remove the dashboard upon make clean [\#5853](https://github.com/netdata/netdata/pull/5853) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- installer: include go.d.plugin version v0.4.0 [\#5849](https://github.com/netdata/netdata/pull/5849) ([ilyam8](https://github.com/ilyam8))
- netdata/collectors/cgroups.plugin: When jq not available, prompt the user he may have to install jq [\#5848](https://github.com/netdata/netdata/pull/5848) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- python.d.plugin: py2 fix crash on macos [\#5838](https://github.com/netdata/netdata/pull/5838) ([ilyam8](https://github.com/ilyam8))
- python.d.plugin: autodetection retry fix [\#5837](https://github.com/netdata/netdata/pull/5837) ([ilyam8](https://github.com/ilyam8))
- phpfpm collector: add last\_collected\_secs health check [\#5836](https://github.com/netdata/netdata/pull/5836) ([ilyam8](https://github.com/ilyam8))
- elasticsearch: update config file [\#5834](https://github.com/netdata/netdata/pull/5834) ([ilyam8](https://github.com/ilyam8))
- couchdb: \_fetch\_data TypeError fix [\#5833](https://github.com/netdata/netdata/pull/5833) ([ilyam8](https://github.com/ilyam8))
- Return responses even in memory mode none [\#5819](https://github.com/netdata/netdata/pull/5819) ([cakrit](https://github.com/cakrit))
- netdata/packaging/installer: Update README [\#5811](https://github.com/netdata/netdata/pull/5811) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- python.d.plugin zombie fix [\#5797](https://github.com/netdata/netdata/pull/5797) ([ilyam8](https://github.com/ilyam8))
- Add memory free and per process memory usage to nvidia\_smi [\#5796](https://github.com/netdata/netdata/pull/5796) ([huww98](https://github.com/huww98))
- python.d.plugin: allow delete dimension in runtime [\#5795](https://github.com/netdata/netdata/pull/5795) ([ilyam8](https://github.com/ilyam8))
- Support configurable syslog facilities [\#5792](https://github.com/netdata/netdata/pull/5792) ([thiagoftsm](https://github.com/thiagoftsm))
- netdata/packaging/docker: Change password [\#5790](https://github.com/netdata/netdata/pull/5790) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/updater: fix updater [\#5785](https://github.com/netdata/netdata/pull/5785) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/ci: fix travis syntax [\#5780](https://github.com/netdata/netdata/pull/5780) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Add preferred disk id pattern [\#5779](https://github.com/netdata/netdata/pull/5779) ([vlvkobal](https://github.com/vlvkobal))
- netdata/packaging/ci: Add kickstart execution integrity tests [\#5778](https://github.com/netdata/netdata/pull/5778) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata: Add another global owner [\#5777](https://github.com/netdata/netdata/pull/5777) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/kickstart: fix kickstart [\#5771](https://github.com/netdata/netdata/pull/5771) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Fix smstools3 error handling [\#5770](https://github.com/netdata/netdata/pull/5770) ([cakrit](https://github.com/cakrit))
- netdata/packaging: Remove .tar.gz on distclean [\#5763](https://github.com/netdata/netdata/pull/5763) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/installer: fix sha256sum failure on freeBSD [\#5760](https://github.com/netdata/netdata/pull/5760) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- postgres module: connect via uri [\#5758](https://github.com/netdata/netdata/pull/5758) ([ilyam8](https://github.com/ilyam8))
- Fix unix socket access on FreeBSD [\#5756](https://github.com/netdata/netdata/pull/5756) ([vlvkobal](https://github.com/vlvkobal))
- libapache2-mod-proxy-html was a transitional package for apache2-bin [\#5753](https://github.com/netdata/netdata/pull/5753) ([piiiggg](https://github.com/piiiggg))
- Fix the Polyverse reinstall that caused APK broken state [\#5751](https://github.com/netdata/netdata/pull/5751) ([archisgore](https://github.com/archisgore))
- fix go.d.plugin config.tar.gz checksum [\#5750](https://github.com/netdata/netdata/pull/5750) ([ilyam8](https://github.com/ilyam8))
- Correct typo in ceph README [\#5742](https://github.com/netdata/netdata/pull/5742) ([cakrit](https://github.com/cakrit))
- Fix some misspells in docs and code [\#5549](https://github.com/netdata/netdata/pull/5549) ([JoeWrightss](https://github.com/JoeWrightss))
- Added RocketChat default recipient for roles [\#5545](https://github.com/netdata/netdata/pull/5545) ([tctovsli](https://github.com/tctovsli))
- Add simonnagl as CODEOWNER for cups.plugin [\#5453](https://github.com/netdata/netdata/pull/5453) ([simonnagl](https://github.com/simonnagl))
- unified cgroup support [\#5407](https://github.com/netdata/netdata/pull/5407) ([skrzyp1](https://github.com/skrzyp1))

## [v1.14.0-rc0](https://github.com/netdata/netdata/tree/v1.14.0-rc0) (2019-03-30)

**Fixed bugs:**

- NetData no longer installs after recent xenstat commit [\#5726](https://github.com/netdata/netdata/issues/5726)
- Errant netdata-updater logs on root "/" directory [\#5679](https://github.com/netdata/netdata/issues/5679)
- remove python obsolete modules [\#5647](https://github.com/netdata/netdata/issues/5647)
- Reinstalling with kickstart.sh fails [\#5584](https://github.com/netdata/netdata/issues/5584)
- Uninstaller fixes and instructions [\#5290](https://github.com/netdata/netdata/issues/5290)
- Installer problem with config files under 'orig' symlink  [\#5039](https://github.com/netdata/netdata/issues/5039)

**Closed issues:**

- netdata/packaging/installer: Finish up netdata installer refactoring [\#5705](https://github.com/netdata/netdata/issues/5705)
- Feature: Netdata alarms as POST events to a configurable endpoint in health\_alarm\_notify.conf [\#5702](https://github.com/netdata/netdata/issues/5702)
- feature cgroups plugin: make containers priority user configurable [\#5697](https://github.com/netdata/netdata/issues/5697)
- Basic kubeproxy collector [\#5683](https://github.com/netdata/netdata/issues/5683)
- push kickstart.sh to https://my-netdata.io/kickstart.sh [\#5681](https://github.com/netdata/netdata/issues/5681)
- Slack footer link breaks when the URL is too long [\#5654](https://github.com/netdata/netdata/issues/5654)
- netdata build error [\#5649](https://github.com/netdata/netdata/issues/5649)
- Scalable page cache, metrics index and space management [\#5640](https://github.com/netdata/netdata/issues/5640)
- Basic kubelet collector [\#5639](https://github.com/netdata/netdata/issues/5639)
- Kubernetes helmchart improvements [\#5637](https://github.com/netdata/netdata/issues/5637)
- Isn't it a security risk not having SSL mode for postgres plugin? [\#5629](https://github.com/netdata/netdata/issues/5629)
- feature: collect docker-engine metrics [\#5622](https://github.com/netdata/netdata/issues/5622)
- nightlies.sh should stop on error [\#5580](https://github.com/netdata/netdata/issues/5580)
- /etc/cron.daily/netdata-updater -f $'\E\(B\E\[0m\\n' /dev/fd/63: line 86: : command not found [\#5570](https://github.com/netdata/netdata/issues/5570)
- NetData on XCP-ng dom0 CentOS [\#5357](https://github.com/netdata/netdata/issues/5357)
- Kubelet monitoring [\#4859](https://github.com/netdata/netdata/issues/4859)
- Docker Hub monitoring [\#4843](https://github.com/netdata/netdata/issues/4843)
- fping 4.1 released [\#4227](https://github.com/netdata/netdata/issues/4227)
- support gauges without a needle [\#4206](https://github.com/netdata/netdata/issues/4206)
- RFC: a new design for alert system [\#3963](https://github.com/netdata/netdata/issues/3963)
- notifications with smstools \(direct connection to mobile phone\) [\#2720](https://github.com/netdata/netdata/issues/2720)
- remove not updated charts after some time [\#688](https://github.com/netdata/netdata/issues/688)

**Merged pull requests:**

- netdata/packaging/ci: small improvements in logging [\#5746](https://github.com/netdata/netdata/pull/5746) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/makeself: no comment [\#5743](https://github.com/netdata/netdata/pull/5743) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- installer: include go.d.plugin version v0.3.1 [\#5740](https://github.com/netdata/netdata/pull/5740) ([ilyam8](https://github.com/ilyam8))
- access: fix codeowners [\#5739](https://github.com/netdata/netdata/pull/5739) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/installer: netdata-installer.sh script \(and subscripts\) refactoring wrap-up [\#5736](https://github.com/netdata/netdata/pull/5736) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Spelling fix for streaming readme.md [\#5734](https://github.com/netdata/netdata/pull/5734) ([vinyasmusic](https://github.com/vinyasmusic))
- Fix dist build [\#5728](https://github.com/netdata/netdata/pull/5728) ([vlvkobal](https://github.com/vlvkobal))
- add some kubelet alarms [\#5724](https://github.com/netdata/netdata/pull/5724) ([ilyam8](https://github.com/ilyam8))
- Update fping version [\#5719](https://github.com/netdata/netdata/pull/5719) ([vlvkobal](https://github.com/vlvkobal))
- add some kubernetes to apps\_groups.conf [\#5714](https://github.com/netdata/netdata/pull/5714) ([ilyam8](https://github.com/ilyam8))
- netdata/packaging/ci: nits [\#5709](https://github.com/netdata/netdata/pull/5709) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/ci: Make Travis CI more strict on nightlies run [\#5708](https://github.com/netdata/netdata/pull/5708) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- NEW: authdb option for MongoDB collector [\#5707](https://github.com/netdata/netdata/pull/5707) ([andvgal](https://github.com/andvgal))
- Send custom docs [\#5703](https://github.com/netdata/netdata/pull/5703) ([cakrit](https://github.com/cakrit))
- add 'containers priority' option to cgroups plugin [\#5700](https://github.com/netdata/netdata/pull/5700) ([ilyam8](https://github.com/ilyam8))
- Remove temp log file if no update needed [\#5695](https://github.com/netdata/netdata/pull/5695) ([cakrit](https://github.com/cakrit))
- add a description how to achieve vhost access logs with nginx in web\_log [\#5694](https://github.com/netdata/netdata/pull/5694) ([hsegnitz](https://github.com/hsegnitz))
- netdata/packaging/docker/publish: Fix docker publishing [\#5692](https://github.com/netdata/netdata/pull/5692) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- netdata/packaging/docker: Fix build - typo on array iteration [\#5691](https://github.com/netdata/netdata/pull/5691) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Integrity testing: Check published kickstart files integrity [\#5689](https://github.com/netdata/netdata/pull/5689) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- do not show the modal on demo sites [\#5686](https://github.com/netdata/netdata/pull/5686) ([ktsaou](https://github.com/ktsaou))
- netdata/packaging/uninstaller: Update uninstall document [\#5678](https://github.com/netdata/netdata/pull/5678) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- fix incorrect use of isnormal\(\) [\#5677](https://github.com/netdata/netdata/pull/5677) ([ktsaou](https://github.com/ktsaou))
- py stuff: change l2isbad to ilyam8 [\#5676](https://github.com/netdata/netdata/pull/5676) ([ilyam8](https://github.com/ilyam8))
- bring uninstaller back [\#5675](https://github.com/netdata/netdata/pull/5675) ([paulfantom](https://github.com/paulfantom))
- Fix py2-psycopg2 right after upgrade [\#5667](https://github.com/netdata/netdata/pull/5667) ([archisgore](https://github.com/archisgore))
- Add SMS Server Tools 3 SMS notifications [\#5662](https://github.com/netdata/netdata/pull/5662) ([cakrit](https://github.com/cakrit))
- postgres add ssl connection support [\#5661](https://github.com/netdata/netdata/pull/5661) ([ilyam8](https://github.com/ilyam8))
- Add xenstat plugin [\#5660](https://github.com/netdata/netdata/pull/5660) ([vlvkobal](https://github.com/vlvkobal))
- Remove obsolete python modules [\#5659](https://github.com/netdata/netdata/pull/5659) ([ilyam8](https://github.com/ilyam8))
- Fix path to pidfile in FreeBSD rc.d file [\#5657](https://github.com/netdata/netdata/pull/5657) ([honzahommer](https://github.com/honzahommer))
- netdata/build: A small house keeping around coverity scan \(no functional  or process change\) [\#5656](https://github.com/netdata/netdata/pull/5656) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Load gtm only if anonymous\_statistics are enabled [\#5651](https://github.com/netdata/netdata/pull/5651) ([cakrit](https://github.com/cakrit))
- Fix slack notifications footer and set cloud redirect URL to http [\#5650](https://github.com/netdata/netdata/pull/5650) ([cakrit](https://github.com/cakrit))
- x509check alarm fix [\#5645](https://github.com/netdata/netdata/pull/5645) ([ilyam8](https://github.com/ilyam8))
- Split docker build script into build and publish - attempt small cleanups along the way [\#5591](https://github.com/netdata/netdata/pull/5591) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- fix command not found error when run script under root user. [\#5581](https://github.com/netdata/netdata/pull/5581) ([vinsia](https://github.com/vinsia))
- Patch netdata-installer.sh to avoid unwanted errors during stock config cleanup [\#5571](https://github.com/netdata/netdata/pull/5571) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Make sign-in functionality more visible [\#5569](https://github.com/netdata/netdata/pull/5569) ([gmosx](https://github.com/gmosx))

## [v1.13.0](https://github.com/netdata/netdata/tree/v1.13.0) (2019-03-14)

**Fixed bugs:**

- ssl\_check memory leak [\#5624](https://github.com/netdata/netdata/issues/5624)
- postgresql : invalid connection option "autodetection\_retry" [\#5615](https://github.com/netdata/netdata/issues/5615)
- Proxmox containers no longer being renamed [\#5606](https://github.com/netdata/netdata/issues/5606)
- spigotmc py2 : load source error : 'module' object has no attribute 'A' [\#5595](https://github.com/netdata/netdata/issues/5595)
- swap chart should use stack mode instead of area mode [\#5567](https://github.com/netdata/netdata/issues/5567)
- streaming master is incorrectly detected \(home icon of streamed hosts\) [\#5560](https://github.com/netdata/netdata/issues/5560)
- netdata segfault since 1.12.1 [\#5553](https://github.com/netdata/netdata/issues/5553)
- Alert if process isn't alive [\#5547](https://github.com/netdata/netdata/issues/5547)
- sha256sum: go.d.plugin-v0.1.0.linux-arm64: No such file or directory [\#5538](https://github.com/netdata/netdata/issues/5538)
- RESOLVED - NS\_ERROR\_FILE\_CORRUPTED:  [\#5535](https://github.com/netdata/netdata/issues/5535)
- Reliability of Prometheus exposed metrics names [\#5527](https://github.com/netdata/netdata/issues/5527)
- Unexpected host seen in list of hosts [\#5518](https://github.com/netdata/netdata/issues/5518)
- apps\_plugin plots zeroes for empty groups [\#5514](https://github.com/netdata/netdata/issues/5514)
- Docker containers resources missing unless a netdata full restart executed [\#5512](https://github.com/netdata/netdata/issues/5512)
- Problem loading module sensors [\#5490](https://github.com/netdata/netdata/issues/5490)
- Need more graceful handling of duplicate machine GUIDs [\#5488](https://github.com/netdata/netdata/issues/5488)
- Used ram for container shows incorrectly [\#5477](https://github.com/netdata/netdata/issues/5477)
- SpigotMC Chart won't show [\#4131](https://github.com/netdata/netdata/issues/4131)
- Memory leak in python.d.plugin [\#3817](https://github.com/netdata/netdata/issues/3817)

**Closed issues:**

- ssl check module [\#5631](https://github.com/netdata/netdata/issues/5631)
- Support connect to mysql via SSL [\#5608](https://github.com/netdata/netdata/issues/5608)
- Document how to install netdata on kubernetes [\#5526](https://github.com/netdata/netdata/issues/5526)
- descrease python.d.plugin memory usage [\#5525](https://github.com/netdata/netdata/issues/5525)
- Per User statistics from apps.plugin disappear / stopped working [\#5517](https://github.com/netdata/netdata/issues/5517)
- google is blocked. [\#5410](https://github.com/netdata/netdata/issues/5410)
- Kubernetes pod/containers monitoring [\#5387](https://github.com/netdata/netdata/issues/5387)
- Configuration translator [\#5144](https://github.com/netdata/netdata/issues/5144)
- Move to CMake [\#4610](https://github.com/netdata/netdata/issues/4610)
- Modularize installer script [\#4609](https://github.com/netdata/netdata/issues/4609)
- Normalize data to use standard units [\#4380](https://github.com/netdata/netdata/issues/4380)
- RFC: Remove node and bash plugins [\#4036](https://github.com/netdata/netdata/issues/4036)

**Merged pull requests:**

- installer: include go.d.plugin version v0.2.0 [\#5638](https://github.com/netdata/netdata/pull/5638) ([paulfantom](https://github.com/paulfantom))
- Beanstalk fix [\#5633](https://github.com/netdata/netdata/pull/5633) ([ilyam8](https://github.com/ilyam8))
- Add link to k8s helm chart in installation [\#5627](https://github.com/netdata/netdata/pull/5627) ([cakrit](https://github.com/cakrit))
- Remove ssl check module [\#5626](https://github.com/netdata/netdata/pull/5626) ([ilyam8](https://github.com/ilyam8))
- Fix Postgres connect, incorrect port value [\#5618](https://github.com/netdata/netdata/pull/5618) ([Jaxmetalmax](https://github.com/Jaxmetalmax))
- postgres connect fix [\#5617](https://github.com/netdata/netdata/pull/5617) ([ilyam8](https://github.com/ilyam8))
- Fix a bug in cgroups renaming [\#5612](https://github.com/netdata/netdata/pull/5612) ([vlvkobal](https://github.com/vlvkobal))
- mysql module add ssl connection support [\#5610](https://github.com/netdata/netdata/pull/5610) ([ilyam8](https://github.com/ilyam8))
- Fix memory leaks [\#5604](https://github.com/netdata/netdata/pull/5604) ([vlvkobal](https://github.com/vlvkobal))
- python loaders cleanup [\#5602](https://github.com/netdata/netdata/pull/5602) ([ilyam8](https://github.com/ilyam8))
- Update custom dashboards documentation [\#5600](https://github.com/netdata/netdata/pull/5600) ([cakrit](https://github.com/cakrit))
- spigotmc fix UnicodeDecodeError [\#5598](https://github.com/netdata/netdata/pull/5598) ([ilyam8](https://github.com/ilyam8))
- SimpleService cleanup: do not inherit from OldVersionCompatibility [\#5594](https://github.com/netdata/netdata/pull/5594) ([ilyam8](https://github.com/ilyam8))
- spigotmc: py2 compatibility fix [\#5593](https://github.com/netdata/netdata/pull/5593) ([ilyam8](https://github.com/ilyam8))
- Use total\_\* memory counters for cgroups [\#5592](https://github.com/netdata/netdata/pull/5592) ([vlvkobal](https://github.com/vlvkobal))
- remove paulfantom code ownership and TODO notices [\#5579](https://github.com/netdata/netdata/pull/5579) ([paulfantom](https://github.com/paulfantom))
- When running from within a k8s pod, use the k8s API to get the cgroup name  [\#5576](https://github.com/netdata/netdata/pull/5576) ([cakrit](https://github.com/cakrit))
- Wait for logs to be opened before calling anonymous statistics [\#5573](https://github.com/netdata/netdata/pull/5573) ([cakrit](https://github.com/cakrit))
- Fix nonobsolete dimension deletion [\#5563](https://github.com/netdata/netdata/pull/5563) ([vlvkobal](https://github.com/vlvkobal))
- Fix incorrect icon for streaming master \#5560 [\#5561](https://github.com/netdata/netdata/pull/5561) ([gmosx](https://github.com/gmosx))
- Delay renaming for docker containers [\#5557](https://github.com/netdata/netdata/pull/5557) ([vlvkobal](https://github.com/vlvkobal))
- Correct PLUGINS\_DIR flag in CMakeLists.txt [\#5555](https://github.com/netdata/netdata/pull/5555) ([cakrit](https://github.com/cakrit))
- python.d.plugin: use separate process for initial module checking [\#5552](https://github.com/netdata/netdata/pull/5552) ([ilyam8](https://github.com/ilyam8))
- Pass agent id to authorization pages [\#5551](https://github.com/netdata/netdata/pull/5551) ([gmosx](https://github.com/gmosx))
- Have the debug option set the freeipmi debug flags [\#5548](https://github.com/netdata/netdata/pull/5548) ([cakrit](https://github.com/cakrit))
- Fix typo [\#5546](https://github.com/netdata/netdata/pull/5546) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Add news for 1.12.1 and 1.12.2 to main readme [\#5544](https://github.com/netdata/netdata/pull/5544) ([cakrit](https://github.com/cakrit))
- Don't send zeroes for empty groups [\#5540](https://github.com/netdata/netdata/pull/5540) ([vlvkobal](https://github.com/vlvkobal))
- Correct go.d.plugin sha256sum check [\#5539](https://github.com/netdata/netdata/pull/5539) ([cakrit](https://github.com/cakrit))
- Registry delete should allow deleting the host we are looking at [\#5537](https://github.com/netdata/netdata/pull/5537) ([cakrit](https://github.com/cakrit))
- Minor fixes around plugin\_directories initialization [\#5536](https://github.com/netdata/netdata/pull/5536) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Support legacy Prometheus metric names for source average [\#5531](https://github.com/netdata/netdata/pull/5531) ([cakrit](https://github.com/cakrit))
- Update unbound module documenttion with troubleshooting section. [\#5528](https://github.com/netdata/netdata/pull/5528) ([Ferroin](https://github.com/Ferroin))
- Add IPC shared memory charts [\#5522](https://github.com/netdata/netdata/pull/5522) ([vlvkobal](https://github.com/vlvkobal))
- Prevent data corruption upon GUID duplication between master and slave netdata instances [\#5511](https://github.com/netdata/netdata/pull/5511) ([paulkatsoulakis](https://github.com/paulkatsoulakis))
- Convert SpigotMC module to use regexes for parsing. [\#5507](https://github.com/netdata/netdata/pull/5507) ([Ferroin](https://github.com/Ferroin))
- Add zero minimum in linux power supply module [\#5395](https://github.com/netdata/netdata/pull/5395) ([vlvkobal](https://github.com/vlvkobal))
- sslcheck module: \(remote\) SSL certificate expiry time check [\#5365](https://github.com/netdata/netdata/pull/5365) ([p-thurner](https://github.com/p-thurner))

## [v1.12.2](https://github.com/netdata/netdata/tree/v1.12.2) (2019-02-28)

**Fixed bugs:**

- Installer at  https://my-netdata.io/kickstart.sh isnt updated to master branch? [\#5492](https://github.com/netdata/netdata/issues/5492)
- Verbose curl output causes unwanted emails from netdata-updater cronjob [\#5484](https://github.com/netdata/netdata/issues/5484)
- Invalid URL [\#5479](https://github.com/netdata/netdata/issues/5479)
- \[FIX\] RocketChat notifications not working [\#5470](https://github.com/netdata/netdata/issues/5470)
- go.d.plugin installation fails due to insufficient timeout [\#5467](https://github.com/netdata/netdata/issues/5467)
- netdata segfault when restart service  [\#5366](https://github.com/netdata/netdata/issues/5366)

**Closed issues:**

- tc.plugin: use high-precission bash sleep as loadable [\#5161](https://github.com/netdata/netdata/issues/5161)
- Unexpected data exposure by default value of "\[registry\].registry to announce" [\#2760](https://github.com/netdata/netdata/issues/2760)
- Oracle monitoring [\#1996](https://github.com/netdata/netdata/issues/1996)

**Merged pull requests:**

- Show streamed servers even for users that are not signed in! \#5482 [\#5519](https://github.com/netdata/netdata/pull/5519) ([gmosx](https://github.com/gmosx))
- python.d.plugin add heartbeat [\#5503](https://github.com/netdata/netdata/pull/5503) ([ilyam8](https://github.com/ilyam8))
- prevent merging changes to kickstart.sh when checksum in docs is wrong [\#5498](https://github.com/netdata/netdata/pull/5498) ([paulfantom](https://github.com/paulfantom))
- Update kickstart md5sums in README [\#5496](https://github.com/netdata/netdata/pull/5496) ([cakrit](https://github.com/cakrit))
- Fix SIGSEGV crash during shutdown of tc plugin. [\#5495](https://github.com/netdata/netdata/pull/5495) ([mfundul](https://github.com/mfundul))
- introduce stable installation channel [\#5487](https://github.com/netdata/netdata/pull/5487) ([paulfantom](https://github.com/paulfantom))
-  Make curl silent and show errors only if it fails [\#5485](https://github.com/netdata/netdata/pull/5485) ([mullnerz](https://github.com/mullnerz))
- Fix curl timeout [\#5476](https://github.com/netdata/netdata/pull/5476) ([elfgoh](https://github.com/elfgoh))
- Correct kickstart md5sums [\#5473](https://github.com/netdata/netdata/pull/5473) ([cakrit](https://github.com/cakrit))
- Correct docs: apps plugin is not an internal collector [\#5472](https://github.com/netdata/netdata/pull/5472) ([cakrit](https://github.com/cakrit))
- Added rocketchat to method-list [\#5471](https://github.com/netdata/netdata/pull/5471) ([tctovsli](https://github.com/tctovsli))
- Increase timeout for download of go.d.plugin [\#5468](https://github.com/netdata/netdata/pull/5468) ([elfgoh](https://github.com/elfgoh))
- docker: use base images build by us [\#5465](https://github.com/netdata/netdata/pull/5465) ([paulfantom](https://github.com/paulfantom))
- oracledb py module [\#5421](https://github.com/netdata/netdata/pull/5421) ([ilyam8](https://github.com/ilyam8))
- Fix CMake warning for nfacct plugin [\#5379](https://github.com/netdata/netdata/pull/5379) ([vlvkobal](https://github.com/vlvkobal))

## [v1.12.1](https://github.com/netdata/netdata/tree/v1.12.1) (2019-02-21)

**Fixed bugs:**

- \#5457 broke `go.d.plugin` installation. [\#5459](https://github.com/netdata/netdata/issues/5459)
- wrong netdata version in response header [\#5438](https://github.com/netdata/netdata/issues/5438)
- Readme - News section: shows 1.11.1 as the latest release [\#5436](https://github.com/netdata/netdata/issues/5436)
- Under python3 the LogService.\_get\_raw\_data fails on undecodable data [\#5430](https://github.com/netdata/netdata/issues/5430)
- apcupsd chart not updating when on battery [\#5428](https://github.com/netdata/netdata/issues/5428)
- /usr/bin/ld: cannot find -lcupsimage [\#5426](https://github.com/netdata/netdata/issues/5426)
- ERROR 405: Cannot download charts index from server [\#5418](https://github.com/netdata/netdata/issues/5418)
- Installer/Updater download via curl redirect [\#5411](https://github.com/netdata/netdata/issues/5411)
- Cannot update netdata [\#5405](https://github.com/netdata/netdata/issues/5405)
- sensors plugin only plots sensors that have hard-coded limits [\#5402](https://github.com/netdata/netdata/issues/5402)
- kickstart-static64.sh should be looking in GCS for the binary package [\#5390](https://github.com/netdata/netdata/issues/5390)
- Docker container networking [\#5383](https://github.com/netdata/netdata/issues/5383)
- Race condition in UI may result in streamed hosts not showing when not signed in [\#5370](https://github.com/netdata/netdata/issues/5370)
- clock\_gettime\(7, &timespec\) failed. \(errno 22, Invalid argument\) [\#5367](https://github.com/netdata/netdata/issues/5367)
- Missing build deps for automake and autoconf from the spec file [\#5362](https://github.com/netdata/netdata/issues/5362)
- wget command that dowlonad go.d plugin creates lots of output in headless install [\#5356](https://github.com/netdata/netdata/issues/5356)
- Update checker false positive [\#5352](https://github.com/netdata/netdata/issues/5352)
- cups.plugin fails to be compiled [\#5324](https://github.com/netdata/netdata/issues/5324)
- Codacy is unconfigured [\#5320](https://github.com/netdata/netdata/issues/5320)
- netdata-installer.sh fails to detect netdata is restarted [\#5304](https://github.com/netdata/netdata/issues/5304)
- bcache writeback\_rate unknown units [\#4719](https://github.com/netdata/netdata/issues/4719)
- Split NFACCT handling to a dedicated helper program. [\#3749](https://github.com/netdata/netdata/issues/3749)
- Don't send host/port in to anonymous stats in fatal of STREAM\_RECEIVER [\#5378](https://github.com/netdata/netdata/pull/5378) ([cakrit](https://github.com/cakrit))

**Closed issues:**

- Alert alarm flapping [\#5346](https://github.com/netdata/netdata/issues/5346)
- Localization of HTML Docs [\#5197](https://github.com/netdata/netdata/issues/5197)
- move node.js module named to go.d [\#5048](https://github.com/netdata/netdata/issues/5048)
- Fluentd monitoring [\#4847](https://github.com/netdata/netdata/issues/4847)
- collect CPU, memory and disk limits from cgroups and provide alarms using thresholds as percentages [\#2401](https://github.com/netdata/netdata/issues/2401)
- Feature request: ability to process detailed `ipcs -q` output [\#1890](https://github.com/netdata/netdata/issues/1890)
- Add multi-language support\(such as Chinese\) [\#219](https://github.com/netdata/netdata/issues/219)

**Merged pull requests:**

- Fix timer crash during exit [\#5464](https://github.com/netdata/netdata/pull/5464) ([mfundul](https://github.com/mfundul))
- Mention installer option `--disable-go` [\#5461](https://github.com/netdata/netdata/pull/5461) ([cakrit](https://github.com/cakrit))
- revert \#5457 and test if files exist after installation [\#5460](https://github.com/netdata/netdata/pull/5460) ([paulfantom](https://github.com/paulfantom))
- Update icon in demosites.html [\#5458](https://github.com/netdata/netdata/pull/5458) ([cakrit](https://github.com/cakrit))
- Installer - Handle cases when go.d plugin can't be downloaded  [\#5457](https://github.com/netdata/netdata/pull/5457) ([cakrit](https://github.com/cakrit))
- Update md5sums on README.md [\#5456](https://github.com/netdata/netdata/pull/5456) ([cakrit](https://github.com/cakrit))
- Fix SEGV by removing free of vars of charts that do not exist [\#5455](https://github.com/netdata/netdata/pull/5455) ([cakrit](https://github.com/cakrit))
- cups.plugin: remove flag -cupsimage [\#5448](https://github.com/netdata/netdata/pull/5448) ([simonnagl](https://github.com/simonnagl))
- Prevent invalid Linux power supply alarms during startup [\#5447](https://github.com/netdata/netdata/pull/5447) ([cakrit](https://github.com/cakrit))
- Use go.d.plugin in version v0.1.0 [\#5446](https://github.com/netdata/netdata/pull/5446) ([paulfantom](https://github.com/paulfantom))
- Correct duplicate flag enum in health.h [\#5441](https://github.com/netdata/netdata/pull/5441) ([cakrit](https://github.com/cakrit))
- Remove extra 'v' from Server response header [\#5440](https://github.com/netdata/netdata/pull/5440) ([cakrit](https://github.com/cakrit))
- Fix curl download [\#5439](https://github.com/netdata/netdata/pull/5439) ([Hufschmidt](https://github.com/Hufschmidt))
- Update README.md - add news for 1.12 [\#5437](https://github.com/netdata/netdata/pull/5437) ([cakrit](https://github.com/cakrit))
- apcupsd - Treat ONBATT the same as ONLINE [\#5435](https://github.com/netdata/netdata/pull/5435) ([cakrit](https://github.com/cakrit))
- Add tor to the default app groups [\#5434](https://github.com/netdata/netdata/pull/5434) ([jamezrin](https://github.com/jamezrin))
- fix \#5430 - LogService.\_get\_raw\_data under python3 fails on undecodable data [\#5431](https://github.com/netdata/netdata/pull/5431) ([apardyl](https://github.com/apardyl))
- Correct version check in UI [\#5429](https://github.com/netdata/netdata/pull/5429) ([cakrit](https://github.com/cakrit))
- spec: fixed template issue for netdata source. [\#5427](https://github.com/netdata/netdata/pull/5427) ([k0ste](https://github.com/k0ste))
- cpuidle handle newlines in names [\#5425](https://github.com/netdata/netdata/pull/5425) ([cakrit](https://github.com/cakrit))
- Improve configure.ac mnl and netfilter\_acc checks for static builds [\#5424](https://github.com/netdata/netdata/pull/5424) ([mfundul](https://github.com/mfundul))
- remove redudant pipes for cgroup-network netnsid [\#5417](https://github.com/netdata/netdata/pull/5417) ([ktsaou](https://github.com/ktsaou))
- Fix clock\_gettime\(\) failures with the CLOCK\_BOOTTIME argument [\#5415](https://github.com/netdata/netdata/pull/5415) ([mfundul](https://github.com/mfundul))
- Uninstall instruction improvements [\#5414](https://github.com/netdata/netdata/pull/5414) ([cakrit](https://github.com/cakrit))
- use netnsid for detecting cgroup networks;  [\#5413](https://github.com/netdata/netdata/pull/5413) ([ktsaou](https://github.com/ktsaou))
- python module sensors fix [\#5406](https://github.com/netdata/netdata/pull/5406) ([ilyam8](https://github.com/ilyam8))
- Refactored static kickstart script [\#5397](https://github.com/netdata/netdata/pull/5397) ([paulfantom](https://github.com/paulfantom))
- Fix ceph.chart.py for Python3 [\#5396](https://github.com/netdata/netdata/pull/5396) ([GaetanF](https://github.com/GaetanF))
- Fix Coverity defects [\#5394](https://github.com/netdata/netdata/pull/5394) ([vlvkobal](https://github.com/vlvkobal))
- Update CODEOWNERS [\#5389](https://github.com/netdata/netdata/pull/5389) ([cakrit](https://github.com/cakrit))
- Add driver-type option to the freeipmi plugin [\#5384](https://github.com/netdata/netdata/pull/5384) ([cakrit](https://github.com/cakrit))
- Add documentation for network interfaces [\#5381](https://github.com/netdata/netdata/pull/5381) ([vlvkobal](https://github.com/vlvkobal))
- Correct Installation link in updating doc [\#5380](https://github.com/netdata/netdata/pull/5380) ([cakrit](https://github.com/cakrit))
- Add support of tera-byte size for Linux bcache. [\#5373](https://github.com/netdata/netdata/pull/5373) ([kamcpp](https://github.com/kamcpp))
- Render MyNetdata menu after fetching hosts info \#5370 [\#5371](https://github.com/netdata/netdata/pull/5371) ([gmosx](https://github.com/gmosx))
- Added missing BuildRequires for autoconf, automake [\#5363](https://github.com/netdata/netdata/pull/5363) ([johnhomelan](https://github.com/johnhomelan))
- Split nfacct plugin into separate process [\#5361](https://github.com/netdata/netdata/pull/5361) ([vlvkobal](https://github.com/vlvkobal))
- fix: wget log spam in headless mode \(fixes \#5356\) [\#5359](https://github.com/netdata/netdata/pull/5359) ([mkg20001](https://github.com/mkg20001))
- Fix replacement of whitespace for versions retrieved from github [\#5355](https://github.com/netdata/netdata/pull/5355) ([cakrit](https://github.com/cakrit))
- fix warning condition for mem.available [\#5353](https://github.com/netdata/netdata/pull/5353) ([cakrit](https://github.com/cakrit))
- cups.plugin: Support older versions [\#5350](https://github.com/netdata/netdata/pull/5350) ([simonnagl](https://github.com/simonnagl))
- fix AC\_CHECK\_LIB to work correctly with cups library [\#5349](https://github.com/netdata/netdata/pull/5349) ([mfundul](https://github.com/mfundul))
- Add link to writing a new module in example readme [\#5348](https://github.com/netdata/netdata/pull/5348) ([cakrit](https://github.com/cakrit))
- Provide more precise uninstall instructions [\#5347](https://github.com/netdata/netdata/pull/5347) ([cakrit](https://github.com/cakrit))
- Localization support in HTML docs, simplification of checklinks.sh [\#5342](https://github.com/netdata/netdata/pull/5342) ([cakrit](https://github.com/cakrit))
- Fix cgroups Codacy issue [\#5340](https://github.com/netdata/netdata/pull/5340) ([vlvkobal](https://github.com/vlvkobal))
- Fix FreeBSD plugin Codacy issues [\#5338](https://github.com/netdata/netdata/pull/5338) ([vlvkobal](https://github.com/vlvkobal))
- cleanup updater script and no `/opt` usage [\#5218](https://github.com/netdata/netdata/pull/5218) ([paulfantom](https://github.com/paulfantom))
- Add go.d documentation [\#5215](https://github.com/netdata/netdata/pull/5215) ([cakrit](https://github.com/cakrit))
- Add cgroup cpu and memory limits and alarms [\#5172](https://github.com/netdata/netdata/pull/5172) ([vlvkobal](https://github.com/vlvkobal))
- Add message queue statistics [\#5115](https://github.com/netdata/netdata/pull/5115) ([vlvkobal](https://github.com/vlvkobal))

## [v1.12.0](https://github.com/netdata/netdata/tree/v1.12.0) (2019-02-06)

**Fixed bugs:**

- Slack alert displaying URL after manual update of net-data [\#5301](https://github.com/netdata/netdata/issues/5301)
- Netdata update in a /tmp hardened system [\#5289](https://github.com/netdata/netdata/issues/5289)
- Certificate error while running netdata kickstart script [\#5273](https://github.com/netdata/netdata/issues/5273)
- Netdata won't update anymore [\#5272](https://github.com/netdata/netdata/issues/5272)
- alarm-notify.sh not working with latest update of netdata [\#5261](https://github.com/netdata/netdata/issues/5261)
- /etc/netdata/edit-config charts.d.conf [\#5252](https://github.com/netdata/netdata/issues/5252)
- Cannot install netdata from source \(the source directory does not include netdata-installer.sh\) [\#5251](https://github.com/netdata/netdata/issues/5251)
- Non-interactive install fails if required packages are already present [\#5240](https://github.com/netdata/netdata/issues/5240)
- apps.plugin memory usage bug [\#5237](https://github.com/netdata/netdata/issues/5237)
- Automatic updates \(via CRON\) giving error [\#5229](https://github.com/netdata/netdata/issues/5229)
- Updater script no longer seems to be working after a recent update [\#5228](https://github.com/netdata/netdata/issues/5228)
- Cron Update fails \(again\) [\#5208](https://github.com/netdata/netdata/issues/5208)
- It is netdata instalation hacked ? [\#5207](https://github.com/netdata/netdata/issues/5207)
- Wrong version string in GUI [\#5204](https://github.com/netdata/netdata/issues/5204)
- GUI links to github wiki [\#5202](https://github.com/netdata/netdata/issues/5202)
- Version checker shouldn't compare commits [\#5201](https://github.com/netdata/netdata/issues/5201)
- python.d/dockerd plugin update error [\#5200](https://github.com/netdata/netdata/issues/5200)
- Netdata registry with basic auth \(behind nginx proxy\) results in error 409 [\#5180](https://github.com/netdata/netdata/issues/5180)
- alarm-notify.sh: WARNING: Cannot find file [\#5136](https://github.com/netdata/netdata/issues/5136)
- Netdata w/ Docker Container not show Disk space utilization for mounts [\#5071](https://github.com/netdata/netdata/issues/5071)
- zfs charts appear, even when they are zero [\#4115](https://github.com/netdata/netdata/issues/4115)
- Ceph - No JSON object could be decoded [\#3563](https://github.com/netdata/netdata/issues/3563)

**Closed issues:**

- integrate go-orchestrator into go.d.plugin [\#5308](https://github.com/netdata/netdata/issues/5308)
- Update not working or UI just showing wrong information? How to uninstall? [\#5285](https://github.com/netdata/netdata/issues/5285)
- Slack Notifications Ignored by alarm-notify.sh [\#5267](https://github.com/netdata/netdata/issues/5267)
- varnish plugin doesn't support custom varnishd working directory [\#5262](https://github.com/netdata/netdata/issues/5262)
- Developing a new plugin questions [\#5235](https://github.com/netdata/netdata/issues/5235)
- Split go.d plugin into two packages [\#5195](https://github.com/netdata/netdata/issues/5195)
- move python module nvidia\_smi to go.d [\#5190](https://github.com/netdata/netdata/issues/5190)
- Logstash monitoring [\#5147](https://github.com/netdata/netdata/issues/5147)
- integrate go.d into netdata [\#5006](https://github.com/netdata/netdata/issues/5006)
- new database format design [\#4687](https://github.com/netdata/netdata/issues/4687)
- \[REQUEST\] Prowl integration for iOS users? [\#3788](https://github.com/netdata/netdata/issues/3788)
- CUPS information [\#857](https://github.com/netdata/netdata/issues/857)

**Merged pull requests:**

- Fix Codacy issues for FreeBSD plugin [\#5334](https://github.com/netdata/netdata/pull/5334) ([vlvkobal](https://github.com/vlvkobal))
- portcheck: remove unused var [\#5332](https://github.com/netdata/netdata/pull/5332) ([ilyam8](https://github.com/ilyam8))
- fix some python codacy errors [\#5331](https://github.com/netdata/netdata/pull/5331) ([ilyam8](https://github.com/ilyam8))
- Remove codacy warnings from sma\_webbox [\#5330](https://github.com/netdata/netdata/pull/5330) ([cakrit](https://github.com/cakrit))
- Allow user to override the default behavior for read-only mounts [\#5327](https://github.com/netdata/netdata/pull/5327) ([vlvkobal](https://github.com/vlvkobal))
- Remove deprecated API call [\#5326](https://github.com/netdata/netdata/pull/5326) ([Aisbergg](https://github.com/Aisbergg))
- fix compilation of cups.plugin; fixes \#5324 [\#5325](https://github.com/netdata/netdata/pull/5325) ([ktsaou](https://github.com/ktsaou))
- Clarify that uninstaller.sh needs to be downloaded [\#5315](https://github.com/netdata/netdata/pull/5315) ([cakrit](https://github.com/cakrit))
- Remove registrypath from alarm-notify [\#5302](https://github.com/netdata/netdata/pull/5302) ([cakrit](https://github.com/cakrit))
- Minor updates to anonymous statistics [\#5295](https://github.com/netdata/netdata/pull/5295) ([cakrit](https://github.com/cakrit))
- kickstart: noexec detection [\#5293](https://github.com/netdata/netdata/pull/5293) ([paulfantom](https://github.com/paulfantom))
- Correct info on what kickstart.sh does [\#5292](https://github.com/netdata/netdata/pull/5292) ([cakrit](https://github.com/cakrit))
- Add errno to fatal event for statistics [\#5291](https://github.com/netdata/netdata/pull/5291) ([cakrit](https://github.com/cakrit))
- updated cncf landscape url [\#5288](https://github.com/netdata/netdata/pull/5288) ([ktsaou](https://github.com/ktsaou))
- Add back the symlink netdata-latest.gz.run [\#5286](https://github.com/netdata/netdata/pull/5286) ([cakrit](https://github.com/cakrit))
- Additional UI fixes [\#5284](https://github.com/netdata/netdata/pull/5284) ([gmosx](https://github.com/gmosx))
- GUI Update check - use version instead of commit [\#5283](https://github.com/netdata/netdata/pull/5283) ([cakrit](https://github.com/cakrit))
- Correct auto-updater to netdata-updater [\#5281](https://github.com/netdata/netdata/pull/5281) ([cakrit](https://github.com/cakrit))
- netdata update instructions after recent changes [\#5277](https://github.com/netdata/netdata/pull/5277) ([cakrit](https://github.com/cakrit))
- Fix incorrect parsing of ACLs [\#5275](https://github.com/netdata/netdata/pull/5275) ([cakrit](https://github.com/cakrit))
- Improve apps grouping config and docs [\#5269](https://github.com/netdata/netdata/pull/5269) ([vlvkobal](https://github.com/vlvkobal))
- Always run make clean before make [\#5265](https://github.com/netdata/netdata/pull/5265) ([cakrit](https://github.com/cakrit))
- varnish module: add instance\_name option [\#5264](https://github.com/netdata/netdata/pull/5264) ([ilyam8](https://github.com/ilyam8))
- Bug fix for 5261 [\#5263](https://github.com/netdata/netdata/pull/5263) ([cakrit](https://github.com/cakrit))
- ceph module bugfix: fix invalid json response [\#5260](https://github.com/netdata/netdata/pull/5260) ([ilyam8](https://github.com/ilyam8))
- Fix typo in docs/configuration-guide.md [\#5259](https://github.com/netdata/netdata/pull/5259) ([u32i64](https://github.com/u32i64))
- SUSE addition [\#5258](https://github.com/netdata/netdata/pull/5258) ([dannysauer](https://github.com/dannysauer))
- Check version.txt in correct directory and fix link to docs [\#5256](https://github.com/netdata/netdata/pull/5256) ([cakrit](https://github.com/cakrit))
- Mysql charts fix [\#5250](https://github.com/netdata/netdata/pull/5250) ([ilyam8](https://github.com/ilyam8))
- plugins.d doc: Remove empty similar headline [\#5245](https://github.com/netdata/netdata/pull/5245) ([simonnagl](https://github.com/simonnagl))
- Pass correct options to the configure command [\#5244](https://github.com/netdata/netdata/pull/5244) ([cakrit](https://github.com/cakrit))
- Update kickstart.sh md5sum in docs [\#5242](https://github.com/netdata/netdata/pull/5242) ([cakrit](https://github.com/cakrit))
- Fix check for install-required-packages.sh [\#5241](https://github.com/netdata/netdata/pull/5241) ([cakrit](https://github.com/cakrit))
- Fix nightly builds and cron autoupdater [\#5232](https://github.com/netdata/netdata/pull/5232) ([paulfantom](https://github.com/paulfantom))
- Remove v before the version [\#5223](https://github.com/netdata/netdata/pull/5223) ([cakrit](https://github.com/cakrit))
- Instruct users to use edit-config [\#5222](https://github.com/netdata/netdata/pull/5222) ([cakrit](https://github.com/cakrit))
- Improvements to QoS \(tc\) documentation [\#5221](https://github.com/netdata/netdata/pull/5221) ([cakrit](https://github.com/cakrit))
- python dockerd module: check version [\#5217](https://github.com/netdata/netdata/pull/5217) ([ilyam8](https://github.com/ilyam8))
- Bug fix for netdata behind authenticated proxies [\#5216](https://github.com/netdata/netdata/pull/5216) ([cakrit](https://github.com/cakrit))
- add go.d.plugin to apps\_groups.conf [\#5214](https://github.com/netdata/netdata/pull/5214) ([ilyam8](https://github.com/ilyam8))
- Don't show zero charts for ZFS filesystem [\#5211](https://github.com/netdata/netdata/pull/5211) ([vlvkobal](https://github.com/vlvkobal))
- install go.d.plugin [\#5199](https://github.com/netdata/netdata/pull/5199) ([paulfantom](https://github.com/paulfantom))
- Correct link to Rest API [\#5193](https://github.com/netdata/netdata/pull/5193) ([cakrit](https://github.com/cakrit))
- CUPS plugin [\#5188](https://github.com/netdata/netdata/pull/5188) ([simonnagl](https://github.com/simonnagl))
- alarm-notify: Add Prowl integration for iOS users. [\#5132](https://github.com/netdata/netdata/pull/5132) ([Ferroin](https://github.com/Ferroin))
- Anonymous statistics [\#5113](https://github.com/netdata/netdata/pull/5113) ([cakrit](https://github.com/cakrit))
- Update info on plugins in performance doc [\#5101](https://github.com/netdata/netdata/pull/5101) ([cakrit](https://github.com/cakrit))
- Cloud Sign-In [\#5095](https://github.com/netdata/netdata/pull/5095) ([gmosx](https://github.com/gmosx))

## [v1.12.0-rc3](https://github.com/netdata/netdata/tree/v1.12.0-rc3) (2019-01-17)

**Fixed bugs:**

- megacli isn't included in python.d.conf [\#5191](https://github.com/netdata/netdata/issues/5191)
- Unix Domain Socket no longer working. Permission denied [\#5181](https://github.com/netdata/netdata/issues/5181)
- netdata-updater.sh doesn't have exec perms [\#5175](https://github.com/netdata/netdata/issues/5175)
- FireQoS name not showing due to recent change [\#5171](https://github.com/netdata/netdata/issues/5171)
- python go\_expvar: reuse same expvar key in different charts [\#5133](https://github.com/netdata/netdata/issues/5133)
- hddtemp.chart.py is hardcoded to only use /dev/sdX [\#5129](https://github.com/netdata/netdata/issues/5129)
- RabbitMQ Plugin wrong metrics for nodes in cluster [\#5118](https://github.com/netdata/netdata/issues/5118)
- cannot install netdata [\#5117](https://github.com/netdata/netdata/issues/5117)
- Anomalous \(big\) values on graphite/carbon  [\#5104](https://github.com/netdata/netdata/issues/5104)
- \[Bug\] Stale metrics being exported to prometheus [\#5064](https://github.com/netdata/netdata/issues/5064)
- Uninstaller script should be self-contained [\#5031](https://github.com/netdata/netdata/issues/5031)
- Netdata doesn't properly lookup docker container name when running in ECS with task level cpu/memory limits enabled [\#4981](https://github.com/netdata/netdata/issues/4981)
- Dashboard TV white page [\#4710](https://github.com/netdata/netdata/issues/4710)
- Review of system.ram plugin: treat Slab memory as Cached \(PR 3288\) [\#3929](https://github.com/netdata/netdata/issues/3929)
- Fix for unix sockets after addition of port ACLs [\#5184](https://github.com/netdata/netdata/pull/5184) ([cakrit](https://github.com/cakrit))

**Closed issues:**

- Remove support for multi-threaded and single-threaded web servers [\#5154](https://github.com/netdata/netdata/issues/5154)
- Use GCS instead of git for updating netdata [\#5110](https://github.com/netdata/netdata/issues/5110)
- error.log: IPv6 not properly show in error messages [\#5067](https://github.com/netdata/netdata/issues/5067)
- Introduce Polymorphic Linux in the Docker Image [\#5034](https://github.com/netdata/netdata/issues/5034)
- Allow netdata to listen to multiple ports [\#5017](https://github.com/netdata/netdata/issues/5017)
- SNMP section not visible [\#4021](https://github.com/netdata/netdata/issues/4021)
- allow different ports for streaming reception and API requests [\#3830](https://github.com/netdata/netdata/issues/3830)
- Consul monitoring service health checks [\#3674](https://github.com/netdata/netdata/issues/3674)
- maintenance time and silence time [\#3187](https://github.com/netdata/netdata/issues/3187)
- Suppressing alerts programatically [\#2673](https://github.com/netdata/netdata/issues/2673)
- include chart values in alarm info text [\#2351](https://github.com/netdata/netdata/issues/2351)
- allow streamed data to be received on dedicated port [\#2149](https://github.com/netdata/netdata/issues/2149)
- alarm notifications should state a count of active alarms per state [\#946](https://github.com/netdata/netdata/issues/946)

**Merged pull requests:**

- update bug\_report.md [\#5205](https://github.com/netdata/netdata/pull/5205) ([ilyam8](https://github.com/ilyam8))
- add missing modules to python.d.conf [\#5194](https://github.com/netdata/netdata/pull/5194) ([ilyam8](https://github.com/ilyam8))
- remove double 'afraid to' in CONTRIBUTING.md [\#5189](https://github.com/netdata/netdata/pull/5189) ([arkamar](https://github.com/arkamar))
- Use tarballs from GCS in kickstart.sh [\#5185](https://github.com/netdata/netdata/pull/5185) ([paulfantom](https://github.com/paulfantom))
- fix for fireqos classname not showing [\#5176](https://github.com/netdata/netdata/pull/5176) ([psychomelet](https://github.com/psychomelet))
- GCS-based updater [\#5174](https://github.com/netdata/netdata/pull/5174) ([paulfantom](https://github.com/paulfantom))
- Updated Polyverse reinstall commands in Dockerfile [\#5173](https://github.com/netdata/netdata/pull/5173) ([archisgore](https://github.com/archisgore))
- Change how the ip address and port are logged in socket.c [\#5166](https://github.com/netdata/netdata/pull/5166) ([krinfels](https://github.com/krinfels))
- Correct SNMP module name in plugin error handling [\#5153](https://github.com/netdata/netdata/pull/5153) ([pablerass](https://github.com/pablerass))
- Fix cached memory calculation [\#5151](https://github.com/netdata/netdata/pull/5151) ([vlvkobal](https://github.com/vlvkobal))
- Fix typo in plugins.d/README.md [\#5150](https://github.com/netdata/netdata/pull/5150) ([arkamar](https://github.com/arkamar))
- "Network Traffic \(system.net\)" is always zero on FreeBSD virtual machines if hypervisor uses VirtIO NIC [\#5149](https://github.com/netdata/netdata/pull/5149) ([vladmovchan](https://github.com/vladmovchan))
- rabbitmq: api/nodes requests fix [\#5142](https://github.com/netdata/netdata/pull/5142) ([ilyam8](https://github.com/ilyam8))
- go\_expavar fix: don't check for duplicate expvars [\#5141](https://github.com/netdata/netdata/pull/5141) ([ilyam8](https://github.com/ilyam8))
- hddtemp fix: don't use disk model as dim name [\#5140](https://github.com/netdata/netdata/pull/5140) ([ilyam8](https://github.com/ilyam8))
- add option to opt-out from telemetry program [\#5138](https://github.com/netdata/netdata/pull/5138) ([paulfantom](https://github.com/paulfantom))
- Scramble packages in docker images with polymorphic linux [\#5137](https://github.com/netdata/netdata/pull/5137) ([paulfantom](https://github.com/paulfantom))
- change ownership of .gitignore [\#5131](https://github.com/netdata/netdata/pull/5131) ([paulfantom](https://github.com/paulfantom))
- Update Charts.md [\#5124](https://github.com/netdata/netdata/pull/5124) ([mfundul](https://github.com/mfundul))
- self-contained uninstaller [\#5121](https://github.com/netdata/netdata/pull/5121) ([paulfantom](https://github.com/paulfantom))
- force git describe to always create a version [\#5119](https://github.com/netdata/netdata/pull/5119) ([paulfantom](https://github.com/paulfantom))
- Clarify backend modes of operation [\#5116](https://github.com/netdata/netdata/pull/5116) ([cakrit](https://github.com/cakrit))
- web-site content; why-netdata content [\#5097](https://github.com/netdata/netdata/pull/5097) ([ktsaou](https://github.com/ktsaou))
- Add variables to alarm-notify.sh  [\#5096](https://github.com/netdata/netdata/pull/5096) ([cakrit](https://github.com/cakrit))
- do not report stale metrics to prometheus [\#5084](https://github.com/netdata/netdata/pull/5084) ([ktsaou](https://github.com/ktsaou))
- Unify versioning [\#5051](https://github.com/netdata/netdata/pull/5051) ([paulfantom](https://github.com/paulfantom))
- Port ACLs, Management API and Health commands [\#4969](https://github.com/netdata/netdata/pull/4969) ([cakrit](https://github.com/cakrit))
- Generate a configure script for RPM build \(\#4570\) [\#4571](https://github.com/netdata/netdata/pull/4571) ([ananace](https://github.com/ananace))

## [v1.12.0-rc2](https://github.com/netdata/netdata/tree/v1.12.0-rc2) (2019-01-03)

**Fixed bugs:**

- smartd\_log: check\(\) unhandled exception: list index out of range [\#5079](https://github.com/netdata/netdata/issues/5079)
- Additional character in Counter64 hex string [\#5028](https://github.com/netdata/netdata/issues/5028)
- Error every second PLUGIN\[proc\] [\#4994](https://github.com/netdata/netdata/issues/4994)
- Inconsistency in netdata.spec.in when comparing logdir permission with git-installation [\#4963](https://github.com/netdata/netdata/issues/4963)
- Docker-compose: a lot of errors; Connection refused, Can't establish connection to MySQL... [\#4956](https://github.com/netdata/netdata/issues/4956)
- Log flooding with new proc plugin [\#4945](https://github.com/netdata/netdata/issues/4945)
- Free memory shows as 'inactive' in FreeBSD [\#4737](https://github.com/netdata/netdata/issues/4737)
- Should use IEC-compliant abbreviations, e.g. KiB, MiB, etc. [\#4711](https://github.com/netdata/netdata/issues/4711)
- FreeBSD: \(apps.cpu\) not show a specific program [\#4037](https://github.com/netdata/netdata/issues/4037)
- Apcupsd: Connection loss further collects data, but it should stop [\#3927](https://github.com/netdata/netdata/issues/3927)
- FreeBSD: apps.plugin reports spikes and apps.cpu less user CPU [\#3245](https://github.com/netdata/netdata/issues/3245)

**Closed issues:**

- disable respect `Retry-After` response header in python UrlService by default [\#5078](https://github.com/netdata/netdata/issues/5078)
- move freeradius module to go.d [\#5063](https://github.com/netdata/netdata/issues/5063)
- move python module dns\_query\_time to go.d [\#5047](https://github.com/netdata/netdata/issues/5047)
- move python module web\_log to go.d [\#5046](https://github.com/netdata/netdata/issues/5046)
- R&D: Collectors landscape page [\#5045](https://github.com/netdata/netdata/issues/5045)
- Copy updater script instead of linking it [\#4924](https://github.com/netdata/netdata/issues/4924)
- Activemq monitoring [\#4818](https://github.com/netdata/netdata/issues/4818)
- Move packaging related code into `packaging/` directory [\#4611](https://github.com/netdata/netdata/issues/4611)
- Simplify makeself [\#4527](https://github.com/netdata/netdata/issues/4527)
- new netdata logo [\#4476](https://github.com/netdata/netdata/issues/4476)
- Add info on disabling alarms for specific target - part 2 [\#4324](https://github.com/netdata/netdata/issues/4324)
- Add info on disabling alarms for specific target - part 1 [\#4323](https://github.com/netdata/netdata/issues/4323)
- Document how to monitor log files [\#4318](https://github.com/netdata/netdata/issues/4318)
- Solr monitoring [\#3218](https://github.com/netdata/netdata/issues/3218)

**Merged pull requests:**

- postgres : fix WAL query [\#5105](https://github.com/netdata/netdata/pull/5105) ([anayrat](https://github.com/anayrat))
- Correct memory usage statement in memory=none [\#5100](https://github.com/netdata/netdata/pull/5100) ([cakrit](https://github.com/cakrit))
- fix permissions for log files when building rpms [\#5099](https://github.com/netdata/netdata/pull/5099) ([paulfantom](https://github.com/paulfantom))
- fix web site install link [\#5092](https://github.com/netdata/netdata/pull/5092) ([ktsaou](https://github.com/ktsaou))
- Removed c3, morris and raphael JS libraries \(\#5086\) [\#5088](https://github.com/netdata/netdata/pull/5088) ([gmosx](https://github.com/gmosx))
- Improve instructions on how to view the slave UI [\#5083](https://github.com/netdata/netdata/pull/5083) ([cakrit](https://github.com/cakrit))
- UrlService dont respect Retry-After header by default [\#5082](https://github.com/netdata/netdata/pull/5082) ([ilyam8](https://github.com/ilyam8))
- smartd\_log: skip non-CSVs early [\#5081](https://github.com/netdata/netdata/pull/5081) ([kevlar1818](https://github.com/kevlar1818))
- Dashboard grammar change [\#5080](https://github.com/netdata/netdata/pull/5080) ([Xalaxis](https://github.com/Xalaxis))
- Add systemd pattern list parameter to the documentation [\#5077](https://github.com/netdata/netdata/pull/5077) ([vlvkobal](https://github.com/vlvkobal))
- Fix update instructions URL in frontend [\#5076](https://github.com/netdata/netdata/pull/5076) ([jorisvervuurt](https://github.com/jorisvervuurt))
- Add how to add new alarm [\#5069](https://github.com/netdata/netdata/pull/5069) ([cakrit](https://github.com/cakrit))
- Fix cpuidle statistics in containers [\#5065](https://github.com/netdata/netdata/pull/5065) ([vlvkobal](https://github.com/vlvkobal))
- Fix coverity issues [\#5061](https://github.com/netdata/netdata/pull/5061) ([vlvkobal](https://github.com/vlvkobal))
- Disable cpuidle module if schedstat file is missing [\#5059](https://github.com/netdata/netdata/pull/5059) ([vlvkobal](https://github.com/vlvkobal))
- Fixed typo [\#5054](https://github.com/netdata/netdata/pull/5054) ([samnela](https://github.com/samnela))
- New option clear\_alarm\_always [\#5050](https://github.com/netdata/netdata/pull/5050) ([dex4er](https://github.com/dex4er))
- fix IEC units in bash modules [\#5049](https://github.com/netdata/netdata/pull/5049) ([paulfantom](https://github.com/paulfantom))
- Gracefully ignore the offset if the value is not a number [\#5040](https://github.com/netdata/netdata/pull/5040) ([cakrit](https://github.com/cakrit))
- Fix process statistics collection for FreeBSD in apps.plugin [\#5038](https://github.com/netdata/netdata/pull/5038) ([vlvkobal](https://github.com/vlvkobal))
- Apcupsd add check for UPS online [\#5037](https://github.com/netdata/netdata/pull/5037) ([cakrit](https://github.com/cakrit))
- Add warning for offset in Counter64 metrics [\#5032](https://github.com/netdata/netdata/pull/5032) ([cakrit](https://github.com/cakrit))
- Add other web servers to proxy instructions [\#5027](https://github.com/netdata/netdata/pull/5027) ([cakrit](https://github.com/cakrit))
- copy updater script instead of linking it [\#5010](https://github.com/netdata/netdata/pull/5010) ([paulfantom](https://github.com/paulfantom))

## [v1.12.0-rc1](https://github.com/netdata/netdata/tree/v1.12.0-rc1) (2018-12-19)

**Fixed bugs:**

- mdstat module causing netdata segv and crash [\#4990](https://github.com/netdata/netdata/issues/4990)
- Cannot read /proc/mdstat line. Expected 7 params, read 6. [\#4975](https://github.com/netdata/netdata/issues/4975)
- custom notification method does not work [\#4968](https://github.com/netdata/netdata/issues/4968)
- Info logging command in netdata-updater.sh contains command substitution. [\#4950](https://github.com/netdata/netdata/issues/4950)
- No data in charts [\#4920](https://github.com/netdata/netdata/issues/4920)
- Postgres module: detect servers version and use the right query [\#4910](https://github.com/netdata/netdata/issues/4910)
- Uninstaller script is always interactive [\#4791](https://github.com/netdata/netdata/issues/4791)
- Cannot update & cannot disable mail logging of events [\#4557](https://github.com/netdata/netdata/issues/4557)
- web\_log plugin cannot handle high load traffic [\#4354](https://github.com/netdata/netdata/issues/4354)
- \[bug\]some metrics don't report to /allmetrics endpoint with prometheus format [\#3866](https://github.com/netdata/netdata/issues/3866)

**Closed issues:**

- move python module portcheck to go.d [\#5005](https://github.com/netdata/netdata/issues/5005)
- move python module httpcheck to go.d [\#5004](https://github.com/netdata/netdata/issues/5004)
- move python module lighttpd to go.d [\#5003](https://github.com/netdata/netdata/issues/5003)
- move python module rabbitmq to go.d  [\#5002](https://github.com/netdata/netdata/issues/5002)
- move python module nginx to go.d [\#5001](https://github.com/netdata/netdata/issues/5001)
- move python module apache to go.d [\#5000](https://github.com/netdata/netdata/issues/5000)
- Pass cloud\_base\_url from netdata.conf to web/gui [\#4980](https://github.com/netdata/netdata/issues/4980)
- Improve configuration documentation [\#4781](https://github.com/netdata/netdata/issues/4781)
- Python.d.plugin infinite retries, ignore penalty, and plotting 'None' [\#4756](https://github.com/netdata/netdata/issues/4756)
- move `/proc` and `/sys` python modules to `proc` plugin [\#4541](https://github.com/netdata/netdata/issues/4541)
- mdstat RAID0 support [\#4010](https://github.com/netdata/netdata/issues/4010)
- FreeIPMI Plugin cant graph the wattage [\#3977](https://github.com/netdata/netdata/issues/3977)
- web\_log: charts per URL [\#3111](https://github.com/netdata/netdata/issues/3111)
- FQDN in alert sending [\#2477](https://github.com/netdata/netdata/issues/2477)
- on frontend, if JavaScript is disabled, there's no graceful degradation [\#2422](https://github.com/netdata/netdata/issues/2422)
- netdata dead but pid file exists [\#2266](https://github.com/netdata/netdata/issues/2266)

**Merged pull requests:**

- Non-interactive uninstaller [\#5021](https://github.com/netdata/netdata/pull/5021) ([paulfantom](https://github.com/paulfantom))
- Kavenegar returns 200 [\#5020](https://github.com/netdata/netdata/pull/5020) ([salehi](https://github.com/salehi))
- Fix missing method\_name: kavenegar [\#5019](https://github.com/netdata/netdata/pull/5019) ([salehi](https://github.com/salehi))
- remove cross-directory dependency in build system [\#5012](https://github.com/netdata/netdata/pull/5012) ([paulfantom](https://github.com/paulfantom))
- Move installer dir under packaging [\#5009](https://github.com/netdata/netdata/pull/5009) ([paulfantom](https://github.com/paulfantom))
- Show a warning if JavaScript is disabled \#2422 [\#4999](https://github.com/netdata/netdata/pull/4999) ([gmosx](https://github.com/gmosx))
- \[python\] make units compliant with IEC standard  [\#4995](https://github.com/netdata/netdata/pull/4995) ([ilyam8](https://github.com/ilyam8))
- Integrate patches from freeipmi and set paramters [\#4993](https://github.com/netdata/netdata/pull/4993) ([Preisschild](https://github.com/Preisschild))
- Fix crash in mdstat module [\#4992](https://github.com/netdata/netdata/pull/4992) ([vlvkobal](https://github.com/vlvkobal))
- Update cgroup-name.sh.in [\#4991](https://github.com/netdata/netdata/pull/4991) ([n0coast](https://github.com/n0coast))
- postgres timeouts [\#4988](https://github.com/netdata/netdata/pull/4988) ([ilyam8](https://github.com/ilyam8))
- Make units compliant with IEC standard [\#4985](https://github.com/netdata/netdata/pull/4985) ([vlvkobal](https://github.com/vlvkobal))
- Typo: `stab\_status` -\> `stub\_status` [\#4984](https://github.com/netdata/netdata/pull/4984) ([petecooper](https://github.com/petecooper))
- Pass cloud\_base\_url from daemon to web/gui through hello endpoint \#4980 [\#4982](https://github.com/netdata/netdata/pull/4982) ([gmosx](https://github.com/gmosx))
- Fix to \#4968, custom recipients were not working properly [\#4978](https://github.com/netdata/netdata/pull/4978) ([cakrit](https://github.com/cakrit))
- Fix mdstat parsing [\#4977](https://github.com/netdata/netdata/pull/4977) ([vlvkobal](https://github.com/vlvkobal))
- GCS access key shouldn't be encrypted [\#4976](https://github.com/netdata/netdata/pull/4976) ([paulfantom](https://github.com/paulfantom))
- Fix accidentally changed file permissions [\#4974](https://github.com/netdata/netdata/pull/4974) ([vlvkobal](https://github.com/vlvkobal))
- fix month 'Dec' being detected as IPv6 address in ovpn python.d plugin [\#4970](https://github.com/netdata/netdata/pull/4970) ([vpnable](https://github.com/vpnable))
- Add support for Factorio server monitoring [\#4966](https://github.com/netdata/netdata/pull/4966) ([jonfairbanks](https://github.com/jonfairbanks))
- Add mdstat to CMake configuration [\#4965](https://github.com/netdata/netdata/pull/4965) ([vlvkobal](https://github.com/vlvkobal))
- Move power supply python module to proc plugin [\#4960](https://github.com/netdata/netdata/pull/4960) ([vlvkobal](https://github.com/vlvkobal))
- dovecot readme update [\#4959](https://github.com/netdata/netdata/pull/4959) ([ilyam8](https://github.com/ilyam8))
- Add cakrit to health codeowners [\#4953](https://github.com/netdata/netdata/pull/4953) ([cakrit](https://github.com/cakrit))
- Prevent netdata-updater.sh from sending cron report for git stash entries [\#4952](https://github.com/netdata/netdata/pull/4952) ([cakrit](https://github.com/cakrit))
- Temporary workaround for \#4945 [\#4951](https://github.com/netdata/netdata/pull/4951) ([cakrit](https://github.com/cakrit))
- allow label modification [\#4949](https://github.com/netdata/netdata/pull/4949) ([paulfantom](https://github.com/paulfantom))
- Fix link in streaming hosts list [\#4948](https://github.com/netdata/netdata/pull/4948) ([adherzog](https://github.com/adherzog))
- Show demosite/host in GA for demo sites [\#4947](https://github.com/netdata/netdata/pull/4947) ([cakrit](https://github.com/cakrit))
- Update GA in demosites.html [\#4946](https://github.com/netdata/netdata/pull/4946) ([cakrit](https://github.com/cakrit))
- postgres fix: detect servers version and use the right query [\#4944](https://github.com/netdata/netdata/pull/4944) ([ilyam8](https://github.com/ilyam8))
- Add support for providing FQDN in alarm notifications. [\#4943](https://github.com/netdata/netdata/pull/4943) ([Ferroin](https://github.com/Ferroin))
- Add header to SMA webbox readme [\#4942](https://github.com/netdata/netdata/pull/4942) ([cakrit](https://github.com/cakrit))
- Add doc before path to GA in static site [\#4940](https://github.com/netdata/netdata/pull/4940) ([cakrit](https://github.com/cakrit))
- Add a Google Analytics tag to every markdown [\#4938](https://github.com/netdata/netdata/pull/4938) ([cakrit](https://github.com/cakrit))
- Update README.md [\#4937](https://github.com/netdata/netdata/pull/4937) ([cakrit](https://github.com/cakrit))
- python.d.plugin update [\#4936](https://github.com/netdata/netdata/pull/4936) ([ilyam8](https://github.com/ilyam8))
- Update Performance.md [\#4935](https://github.com/netdata/netdata/pull/4935) ([cakrit](https://github.com/cakrit))
- cleaner labeler code [\#4933](https://github.com/netdata/netdata/pull/4933) ([paulfantom](https://github.com/paulfantom))
- use proper request types and urls to update labels [\#4931](https://github.com/netdata/netdata/pull/4931) ([paulfantom](https://github.com/paulfantom))
- update code owners [\#4930](https://github.com/netdata/netdata/pull/4930) ([paulfantom](https://github.com/paulfantom))
- Removed vlvkobal as a codeowner of web/gui [\#4929](https://github.com/netdata/netdata/pull/4929) ([gmosx](https://github.com/gmosx))
- Add support for nonredundant arrays [\#4923](https://github.com/netdata/netdata/pull/4923) ([vlvkobal](https://github.com/vlvkobal))
- Config docs improvements [\#4918](https://github.com/netdata/netdata/pull/4918) ([cakrit](https://github.com/cakrit))
- Introduced IEC-compliant unit abbreviations \#4711 [\#4912](https://github.com/netdata/netdata/pull/4912) ([gmosx](https://github.com/gmosx))

## [v1.12.0-rc0](https://github.com/netdata/netdata/tree/v1.12.0-rc0) (2018-12-06)

**Fixed bugs:**

- nvidia\_smi module bug [\#4892](https://github.com/netdata/netdata/issues/4892)
- No alarms are running in some systems [\#4809](https://github.com/netdata/netdata/issues/4809)
- netdata-updater.sh cron report [\#4808](https://github.com/netdata/netdata/issues/4808)
- Netdata is not generating any alarms [\#4793](https://github.com/netdata/netdata/issues/4793)
- Fail2ban: Read "Restore Ban" for persistent bans [\#4769](https://github.com/netdata/netdata/issues/4769)
- Change in Incomming Webhooks Slack API breaks alerts [\#4755](https://github.com/netdata/netdata/issues/4755)
- registry items are clickable, but no action is taken [\#4721](https://github.com/netdata/netdata/issues/4721)
- Enable default alarms disabled after restart service netdata [\#4636](https://github.com/netdata/netdata/issues/4636)
- Spec file doesn't generate configure script before build [\#4570](https://github.com/netdata/netdata/issues/4570)
- sensors.chart.py ignores fans running at 0 RPM when netdata was started [\#4158](https://github.com/netdata/netdata/issues/4158)
- Postgres plugin lock output incorrect [\#4090](https://github.com/netdata/netdata/issues/4090)
- python plugins got behind by 5 seconds [\#3752](https://github.com/netdata/netdata/issues/3752)
- Constant stream of "chart took too long to be updated" INFO messages in error.log [\#3505](https://github.com/netdata/netdata/issues/3505)
- SNMP 64bit Counter Issue - Far from correct bandwidth values [\#3488](https://github.com/netdata/netdata/issues/3488)
- Update health reference documentation [\#3468](https://github.com/netdata/netdata/issues/3468)
- Alarm badge link escaping for disk paths in default dashboard [\#3253](https://github.com/netdata/netdata/issues/3253)

**Closed issues:**

- Docker netdata documentation [\#4899](https://github.com/netdata/netdata/issues/4899)
- Tiny Proxy monitoring [\#4834](https://github.com/netdata/netdata/issues/4834)
- Phusion Passenger monitoring [\#4833](https://github.com/netdata/netdata/issues/4833)
- Iis monitoring [\#4832](https://github.com/netdata/netdata/issues/4832)
- Scaleio monitoring [\#4828](https://github.com/netdata/netdata/issues/4828)
- Leofs monitoring [\#4826](https://github.com/netdata/netdata/issues/4826)
- Jumpy data when running on kubernetes [\#4778](https://github.com/netdata/netdata/issues/4778)
- Create documentation on how to opt-out of anonymous data collection [\#4746](https://github.com/netdata/netdata/issues/4746)
- Use `--future-release` in changelog generation [\#4718](https://github.com/netdata/netdata/issues/4718)
- requirements.txt in TLD are not related to netdata [\#4693](https://github.com/netdata/netdata/issues/4693)
- What is The Right Role for Netdata MongoDB Python Plugins? [\#4666](https://github.com/netdata/netdata/issues/4666)
- Store nightly build artifacts somewhere [\#4628](https://github.com/netdata/netdata/issues/4628)
- Remove old packaging scripts [\#4608](https://github.com/netdata/netdata/issues/4608)
- Use the new logo in web/gui [\#4598](https://github.com/netdata/netdata/issues/4598)
- Labelling bot [\#4528](https://github.com/netdata/netdata/issues/4528)
- Extract registry functionality from dashboard.js [\#4474](https://github.com/netdata/netdata/issues/4474)
- HTML Documentation  [\#4439](https://github.com/netdata/netdata/issues/4439)
- New documentation structure [\#4321](https://github.com/netdata/netdata/issues/4321)
- Add instructions to debug alarm notifications [\#4319](https://github.com/netdata/netdata/issues/4319)
- Fix file classification in LGTM [\#4259](https://github.com/netdata/netdata/issues/4259)
- Add CONTRIBUTING.md [\#4146](https://github.com/netdata/netdata/issues/4146)
- Send alerts via Slack to a single user \(direct message\)? [\#3722](https://github.com/netdata/netdata/issues/3722)
- golang orchestrator [\#3589](https://github.com/netdata/netdata/issues/3589)
- \[web api\] Add /api/v1/version [\#3540](https://github.com/netdata/netdata/issues/3540)
- Feature: UKSM support [\#2994](https://github.com/netdata/netdata/issues/2994)
- web\_log reports unmatched lines [\#2295](https://github.com/netdata/netdata/issues/2295)
- Ceph support [\#1673](https://github.com/netdata/netdata/issues/1673)
- Misaligned option points of REST API v1 endpoint data [\#1628](https://github.com/netdata/netdata/issues/1628)
- Adding support for time markers [\#1195](https://github.com/netdata/netdata/issues/1195)
- Scheduled “downtime” for a type of check? [\#1133](https://github.com/netdata/netdata/issues/1133)
- split snmp.conf into several conf files possible? [\#1126](https://github.com/netdata/netdata/issues/1126)
- sensu/collectd integration [\#174](https://github.com/netdata/netdata/issues/174)

**Merged pull requests:**

- run shfmt on CI scripts [\#4928](https://github.com/netdata/netdata/pull/4928) ([paulfantom](https://github.com/paulfantom))
- use relative path for logo [\#4927](https://github.com/netdata/netdata/pull/4927) ([ktsaou](https://github.com/ktsaou))
- fix symbolic link file detection in etc [\#4926](https://github.com/netdata/netdata/pull/4926) ([ktsaou](https://github.com/ktsaou))
- send all git log msg to fd3 [\#4922](https://github.com/netdata/netdata/pull/4922) ([paulfantom](https://github.com/paulfantom))
- RabbitMQ chart for message rates should be "line" [\#4916](https://github.com/netdata/netdata/pull/4916) ([dex4er](https://github.com/dex4er))
- better labeling [\#4915](https://github.com/netdata/netdata/pull/4915) ([paulfantom](https://github.com/paulfantom))
- Improve docker installation readme, docs navbar fix [\#4914](https://github.com/netdata/netdata/pull/4914) ([cakrit](https://github.com/cakrit))
- Use the new logo in the UI [\#4913](https://github.com/netdata/netdata/pull/4913) ([gmosx](https://github.com/gmosx))
- fix info api method compilation warnings [\#4911](https://github.com/netdata/netdata/pull/4911) ([ktsaou](https://github.com/ktsaou))
- smartd\_log: ata 194 attr fix [\#4908](https://github.com/netdata/netdata/pull/4908) ([ilyam8](https://github.com/ilyam8))
- Do not update repositories in CI operating system  [\#4907](https://github.com/netdata/netdata/pull/4907) ([paulfantom](https://github.com/paulfantom))
- Don't use IE11 incompatible for-const \#4710 [\#4906](https://github.com/netdata/netdata/pull/4906) ([gmosx](https://github.com/gmosx))
- Update python.d readme [\#4905](https://github.com/netdata/netdata/pull/4905) ([cakrit](https://github.com/cakrit))
- do not use protected variable name in updater script [\#4902](https://github.com/netdata/netdata/pull/4902) ([paulfantom](https://github.com/paulfantom))
- postgres module: locks count fix [\#4901](https://github.com/netdata/netdata/pull/4901) ([ilyam8](https://github.com/ilyam8))
- treat DT\_UNKNOWN files as regular files [\#4898](https://github.com/netdata/netdata/pull/4898) ([ktsaou](https://github.com/ktsaou))
- more health debugging to trace config files [\#4897](https://github.com/netdata/netdata/pull/4897) ([ktsaou](https://github.com/ktsaou))
- added debug statements when loading health config files [\#4896](https://github.com/netdata/netdata/pull/4896) ([ktsaou](https://github.com/ktsaou))
- Added info on health configuration and page for Charts [\#4895](https://github.com/netdata/netdata/pull/4895) ([cakrit](https://github.com/cakrit))
- added more debug outpput to freeipmi [\#4894](https://github.com/netdata/netdata/pull/4894) ([ktsaou](https://github.com/ktsaou))
- nvidia\_smi: handle `N/A` values [\#4893](https://github.com/netdata/netdata/pull/4893) ([ilyam8](https://github.com/ilyam8))
- add api/v1/info endpoint to swagger [\#4807](https://github.com/netdata/netdata/pull/4807) ([Wing924](https://github.com/Wing924))
- Update CONTRIBUTING.md [\#4805](https://github.com/netdata/netdata/pull/4805) ([cakrit](https://github.com/cakrit))
- Add info from PR 208 [\#4804](https://github.com/netdata/netdata/pull/4804) ([cakrit](https://github.com/cakrit))
- Anonymize IPs in README.md Google Analytics [\#4803](https://github.com/netdata/netdata/pull/4803) ([cakrit](https://github.com/cakrit))
- Minor updates in htmldoc [\#4802](https://github.com/netdata/netdata/pull/4802) ([cakrit](https://github.com/cakrit))
- Add cookie consent javascript to docs [\#4801](https://github.com/netdata/netdata/pull/4801) ([cakrit](https://github.com/cakrit))
- Improve SYNPROXY documentation [\#4800](https://github.com/netdata/netdata/pull/4800) ([cakrit](https://github.com/cakrit))
- Add debug instructions for python modules [\#4799](https://github.com/netdata/netdata/pull/4799) ([cakrit](https://github.com/cakrit))
- Added Legal section to documentation, added missing link for apps.plugin [\#4797](https://github.com/netdata/netdata/pull/4797) ([cakrit](https://github.com/cakrit))
- auto-label PRs and minor cleanup [\#4795](https://github.com/netdata/netdata/pull/4795) ([paulfantom](https://github.com/paulfantom))
- automatic labeling of new features [\#4792](https://github.com/netdata/netdata/pull/4792) ([paulfantom](https://github.com/paulfantom))
- Small content change to the netdata-installer.sh [\#4790](https://github.com/netdata/netdata/pull/4790) ([ei8fdb](https://github.com/ei8fdb))
- lifecycle test [\#4789](https://github.com/netdata/netdata/pull/4789) ([paulfantom](https://github.com/paulfantom))
- Documentation TOC bug fix [\#4787](https://github.com/netdata/netdata/pull/4787) ([cakrit](https://github.com/cakrit))
- netdata-security doc corrections [\#4786](https://github.com/netdata/netdata/pull/4786) ([cakrit](https://github.com/cakrit))
- Update README.md for release 1.11.1 [\#4777](https://github.com/netdata/netdata/pull/4777) ([taniaab](https://github.com/taniaab))
- Fix typo in "Github Star" documentation [\#4776](https://github.com/netdata/netdata/pull/4776) ([josemaia](https://github.com/josemaia))
- Added a few more debugging instructions for notifications [\#4774](https://github.com/netdata/netdata/pull/4774) ([cakrit](https://github.com/cakrit))
- buildhtml.sh should exit with 1 if anything fails [\#4773](https://github.com/netdata/netdata/pull/4773) ([cakrit](https://github.com/cakrit))
- fail2ban fix: add 'Restore Ban' action [\#4772](https://github.com/netdata/netdata/pull/4772) ([ilyam8](https://github.com/ilyam8))
- add api/v1/info endpoint [\#4770](https://github.com/netdata/netdata/pull/4770) ([Wing924](https://github.com/Wing924))
- Move mdstat python module to proc plugin [\#4768](https://github.com/netdata/netdata/pull/4768) ([vlvkobal](https://github.com/vlvkobal))
- bugfix: query engine resampling duration [\#4759](https://github.com/netdata/netdata/pull/4759) ([ktsaou](https://github.com/ktsaou))
- web\_log: add alarm on unmatched lines [\#4757](https://github.com/netdata/netdata/pull/4757) ([ilyam8](https://github.com/ilyam8))
- sensors: don't ignore 0 RPM funs on start [\#4753](https://github.com/netdata/netdata/pull/4753) ([ilyam8](https://github.com/ilyam8))
- Use var to make NETDATA variable global [\#4752](https://github.com/netdata/netdata/pull/4752) ([gmosx](https://github.com/gmosx))
- move build Dockerfiles to external repo [\#4749](https://github.com/netdata/netdata/pull/4749) ([paulfantom](https://github.com/paulfantom))
- remove rolling version suffix [\#4748](https://github.com/netdata/netdata/pull/4748) ([paulfantom](https://github.com/paulfantom))
- Docs point to docs.netdata.cloud instead of wiki. Correct padding-bot… [\#4747](https://github.com/netdata/netdata/pull/4747) ([cakrit](https://github.com/cakrit))
- Make Getting Started just a top level link [\#4740](https://github.com/netdata/netdata/pull/4740) ([cakrit](https://github.com/cakrit))
- docker: correct invalid syntax [\#4738](https://github.com/netdata/netdata/pull/4738) ([paulfantom](https://github.com/paulfantom))
- Make the whole title area clickable,  closes \#4721 [\#4733](https://github.com/netdata/netdata/pull/4733) ([gmosx](https://github.com/gmosx))
- Correctly apply B unit conversion [\#4724](https://github.com/netdata/netdata/pull/4724) ([gmosx](https://github.com/gmosx))
- add more layers to container image [\#4722](https://github.com/netdata/netdata/pull/4722) ([paulfantom](https://github.com/paulfantom))
- python.d: use real time for calc sinceLast [\#4720](https://github.com/netdata/netdata/pull/4720) ([ilyam8](https://github.com/ilyam8))
- strictier use of URL separators [\#4716](https://github.com/netdata/netdata/pull/4716) ([ktsaou](https://github.com/ktsaou))
- Test integrity of dashboard.js [\#4715](https://github.com/netdata/netdata/pull/4715) ([paulfantom](https://github.com/paulfantom))
- fix\(pagerduty\): Use cURL instead of PagerDuty agent to send alarms. [\#4694](https://github.com/netdata/netdata/pull/4694) ([elisiariocouto](https://github.com/elisiariocouto))
- lint all shell collectors code [\#4690](https://github.com/netdata/netdata/pull/4690) ([paulfantom](https://github.com/paulfantom))
- Move cpuidle python module to proc plugin [\#4635](https://github.com/netdata/netdata/pull/4635) ([vlvkobal](https://github.com/vlvkobal))
- Cleanup docker packaging and contrib [\#4627](https://github.com/netdata/netdata/pull/4627) ([paulfantom](https://github.com/paulfantom))
- Better updater [\#4558](https://github.com/netdata/netdata/pull/4558) ([paulfantom](https://github.com/paulfantom))
- Generalize the recipient finding logic and reduce the boilerplate code. [\#3960](https://github.com/netdata/netdata/pull/3960) ([Ferroin](https://github.com/Ferroin))
- RPM spec and patches for sles 11 [\#3708](https://github.com/netdata/netdata/pull/3708) ([veksh](https://github.com/veksh))

## [v1.11.1](https://github.com/netdata/netdata/tree/v1.11.1) (2018-11-22)

**Fixed bugs:**

- Sensors module of python plugin not working \(again?\) [\#4692](https://github.com/netdata/netdata/issues/4692)
- Ubuntu 18.04 apt package is still on v1.9.0, though apt is the recommended installation method [\#4675](https://github.com/netdata/netdata/issues/4675)
- pre-built static binary install script does not detect SLES as systemd OS [\#4641](https://github.com/netdata/netdata/issues/4641)
- Sensors don`t work [\#4602](https://github.com/netdata/netdata/issues/4602)
- smartd\_log check\(\) unhandled exception: 'list' object has no attribute 'clear' [\#4583](https://github.com/netdata/netdata/issues/4583)
- 1m\_received\_traffic\_overflow alarm is faulty on 10G or 40G network interfaces [\#4577](https://github.com/netdata/netdata/issues/4577)
- 1.11 release reports as 1.10.0\_rolling [\#4572](https://github.com/netdata/netdata/issues/4572)
- update  netdata error  [\#4560](https://github.com/netdata/netdata/issues/4560)
- edit-config uses vi, even if it isn't the system editor [\#4549](https://github.com/netdata/netdata/issues/4549)
- inbound packets dropped inbound  [\#4536](https://github.com/netdata/netdata/issues/4536)
- incremental chart algorithm doesn't handle counter wrap properly [\#4533](https://github.com/netdata/netdata/issues/4533)
- Disk full \(inodes\) due to netdata [\#4518](https://github.com/netdata/netdata/issues/4518)
- Systemd not working on Ubuntu 14.04 [\#4465](https://github.com/netdata/netdata/issues/4465)
- Links on the wiki are returning 404s [\#4408](https://github.com/netdata/netdata/issues/4408)
- It figures [\#4184](https://github.com/netdata/netdata/issues/4184)
- netdata stream clients disconnecting from netdata server [\#4049](https://github.com/netdata/netdata/issues/4049)
- False positive alarm for RAM [\#4013](https://github.com/netdata/netdata/issues/4013)
- Occasional rm "cannot remove" on netdata-updater [\#3457](https://github.com/netdata/netdata/issues/3457)
- opensuse - installation by hand issues due to hardcoded libexec in netdata-installer.sh [\#3346](https://github.com/netdata/netdata/issues/3346)
- Netdata Installation failed in Manjaro（Arch）Latest [\#2812](https://github.com/netdata/netdata/issues/2812)
- undefined applications show up in system category? [\#2385](https://github.com/netdata/netdata/issues/2385)
- memory mode map initialization slow when database is too big [\#2382](https://github.com/netdata/netdata/issues/2382)
- Long hostnames cause alignment issues in my-netdata [\#2335](https://github.com/netdata/netdata/issues/2335)
- dont get snmp running properly [\#1734](https://github.com/netdata/netdata/issues/1734)
- Plugins continue to log to old error.log after a SIGHUP [\#805](https://github.com/netdata/netdata/issues/805)

**Closed issues:**

- Improve footer of web/gui [\#4708](https://github.com/netdata/netdata/issues/4708)
- Ignores EMAIL\_SENDER [\#4695](https://github.com/netdata/netdata/issues/4695)
- Add option to do pre-releases in GitHub [\#4684](https://github.com/netdata/netdata/issues/4684)
- Invalid links in \*.md files [\#4672](https://github.com/netdata/netdata/issues/4672)
- Replace all wiki links with repo links in netdata files [\#4650](https://github.com/netdata/netdata/issues/4650)
- Replace http URLs with https in markdown fils [\#4626](https://github.com/netdata/netdata/issues/4626)
- Extract JS and CSS from index.html [\#4586](https://github.com/netdata/netdata/issues/4586)
- Improved management of netdata urls in the `my-netdata` menu [\#4582](https://github.com/netdata/netdata/issues/4582)
- Ignore web/gui/src in LGTM and Codacy checks. [\#4516](https://github.com/netdata/netdata/issues/4516)
- Remove excessive requestAnimationFrame\(\) compatibility checks [\#4501](https://github.com/netdata/netdata/issues/4501)
- Remove obsolete chart renderers [\#4492](https://github.com/netdata/netdata/issues/4492)
- Split dashboard.js into multiple files [\#4479](https://github.com/netdata/netdata/issues/4479)
- Hdd temperature monitoring on FreeBSD [\#4463](https://github.com/netdata/netdata/issues/4463)
- Modernize dashboard.js [\#4461](https://github.com/netdata/netdata/issues/4461)
- Documentation links sanity checker [\#4416](https://github.com/netdata/netdata/issues/4416)
- Write a blog entry about monitoring and performance tuning mysql with netdata [\#4326](https://github.com/netdata/netdata/issues/4326)
- Document supported python versions [\#4322](https://github.com/netdata/netdata/issues/4322)
- Add coverity scans to Travis [\#4248](https://github.com/netdata/netdata/issues/4248)
- Lint all shell scripts [\#4166](https://github.com/netdata/netdata/issues/4166)
- Include tests in CI pipeline [\#4133](https://github.com/netdata/netdata/issues/4133)
- Runfile installation doesn't fix earlier incorrect netdata init script [\#4009](https://github.com/netdata/netdata/issues/4009)
- http://IP:19999/lib/bootstrap-3.3.7.min.js [\#3908](https://github.com/netdata/netdata/issues/3908)
- Netdata - Spring boot plugin [\#2074](https://github.com/netdata/netdata/issues/2074)
- support standard deviation in reduce functions [\#808](https://github.com/netdata/netdata/issues/808)
- web server optimization [\#532](https://github.com/netdata/netdata/issues/532)
- Containers: running plugins in different namespaces to allow netdata collect application metrics from containers [\#474](https://github.com/netdata/netdata/issues/474)

**Merged pull requests:**

- Cleanup of web/gui footer [\#4709](https://github.com/netdata/netdata/pull/4709) ([gmosx](https://github.com/gmosx))
- added byte unit scaling [\#4707](https://github.com/netdata/netdata/pull/4707) ([AndCycle](https://github.com/AndCycle))
- Add missing quote to tc-qos-helper.sh.in [\#4703](https://github.com/netdata/netdata/pull/4703) ([drwtsn32x](https://github.com/drwtsn32x))
- Fix typo and py2 compatibility issue. [\#4697](https://github.com/netdata/netdata/pull/4697) ([Ferroin](https://github.com/Ferroin))
- Update Doc links for adding charts and alarms in sidebar. Isuue \#4650 [\#4669](https://github.com/netdata/netdata/pull/4669) ([nekkabcire](https://github.com/nekkabcire))
- Update lm\_sensors and catch specific errors. [\#4667](https://github.com/netdata/netdata/pull/4667) ([Ferroin](https://github.com/Ferroin))
- Remove left over code [\#4662](https://github.com/netdata/netdata/pull/4662) ([xPaw](https://github.com/xPaw))
- Fix changelog path, add all README.md files to Debian package doc [\#4657](https://github.com/netdata/netdata/pull/4657) ([runejuhl](https://github.com/runejuhl))
- properly parse network interface names with colon on them [\#4653](https://github.com/netdata/netdata/pull/4653) ([ktsaou](https://github.com/ktsaou))
- sensors module fix [\#4651](https://github.com/netdata/netdata/pull/4651) ([ilyam8](https://github.com/ilyam8))
- Update installer/functions.sh [\#4643](https://github.com/netdata/netdata/pull/4643) ([tsingletonacic](https://github.com/tsingletonacic))
- Fix documentation in beanstalk.conf. [\#4639](https://github.com/netdata/netdata/pull/4639) ([Ferroin](https://github.com/Ferroin))
- Minor cleanup of main.js [\#4634](https://github.com/netdata/netdata/pull/4634) ([gmosx](https://github.com/gmosx))
- Fixed tc-helper plugin broken link [\#4617](https://github.com/netdata/netdata/pull/4617) ([ofirule](https://github.com/ofirule))
- Another Readme Update [\#4612](https://github.com/netdata/netdata/pull/4612) ([ktsaou](https://github.com/ktsaou))
- Fix spelling mistake in dashboard\_info.js [\#4601](https://github.com/netdata/netdata/pull/4601) ([hotio](https://github.com/hotio))
- bug fix: conntrack\_max alarm was accessing invalid variable [\#4595](https://github.com/netdata/netdata/pull/4595) ([ktsaou](https://github.com/ktsaou))
- fixed max interface speed calculation [\#4594](https://github.com/netdata/netdata/pull/4594) ([ktsaou](https://github.com/ktsaou))
- Issue 4582 \(Show alternate urls in my-netdata menu\) [\#4590](https://github.com/netdata/netdata/pull/4590) ([gmosx](https://github.com/gmosx))
- nvidia\_smi: init version added [\#4589](https://github.com/netdata/netdata/pull/4589) ([ilyam8](https://github.com/ilyam8))
- smartd\_log: py2 compatibility fix [\#4584](https://github.com/netdata/netdata/pull/4584) ([ilyam8](https://github.com/ilyam8))
- Split js 2 [\#4581](https://github.com/netdata/netdata/pull/4581) ([gmosx](https://github.com/gmosx))
- Alerta.io notification improvements [\#4576](https://github.com/netdata/netdata/pull/4576) ([satterly](https://github.com/satterly))
- netdata-openrc: Move check from depends\(\) to start\_pre\(\) [\#4575](https://github.com/netdata/netdata/pull/4575) ([aadityabagga](https://github.com/aadityabagga))
- Fix badges link that leads to 404. [\#4569](https://github.com/netdata/netdata/pull/4569) ([nekkabcire](https://github.com/nekkabcire))
- Move cpufreq python module to proc plugin [\#4562](https://github.com/netdata/netdata/pull/4562) ([vlvkobal](https://github.com/vlvkobal))
- decouple nightly cron jobs from packaging stage [\#4559](https://github.com/netdata/netdata/pull/4559) ([paulfantom](https://github.com/paulfantom))
- Clarify application configuration and fix broken link [\#4554](https://github.com/netdata/netdata/pull/4554) ([JBaczuk](https://github.com/JBaczuk))
- edit-config: Better support for custom editors. [\#4551](https://github.com/netdata/netdata/pull/4551) ([Ferroin](https://github.com/Ferroin))
- add tor python module [\#4546](https://github.com/netdata/netdata/pull/4546) ([ilyam8](https://github.com/ilyam8))
- incremental overflows should not show zeros values [\#4538](https://github.com/netdata/netdata/pull/4538) ([ktsaou](https://github.com/ktsaou))
- smartd\_log refactor plus SCSI support [\#4523](https://github.com/netdata/netdata/pull/4523) ([ilyam8](https://github.com/ilyam8))
- openldap monitoring plugin added [\#4513](https://github.com/netdata/netdata/pull/4513) ([ekartsonakis](https://github.com/ekartsonakis))
- Refactoring dashboard.js, splitting monolithic file into multiple source files. [\#4496](https://github.com/netdata/netdata/pull/4496) ([gmosx](https://github.com/gmosx))
- Switch e-mail threading to be enabled by default. [\#3780](https://github.com/netdata/netdata/pull/3780) ([Ferroin](https://github.com/Ferroin))

## [v1.11.0](https://github.com/netdata/netdata/tree/v1.11.0) (2018-11-02)

**Fixed bugs:**

- Cannot use oidname in snmp config [\#4512](https://github.com/netdata/netdata/issues/4512)
- config.status: error: cannot find input file: `web/api/badges/Makefile.in' [\#4502](https://github.com/netdata/netdata/issues/4502)
- Diskspace plugin accesses excluded filesystem and stalls netdata process [\#4491](https://github.com/netdata/netdata/issues/4491)
- netdata allocates 170MB memory after startup \(without the database\) [\#4487](https://github.com/netdata/netdata/issues/4487)
- Logcheck security alert: netdata : command not allowed ; TTY=unknown ; PWD=/etc/netdata ; USER=root ; COMMAND=validate [\#4473](https://github.com/netdata/netdata/issues/4473)
- duplicate name in cgroup if dash present in container name [\#4468](https://github.com/netdata/netdata/issues/4468)
- Wrong logos in infographic [\#4455](https://github.com/netdata/netdata/issues/4455)
- Netdata in Docker cannot load stock config \(permission denied\) [\#4453](https://github.com/netdata/netdata/issues/4453)
- Icecast module not working [\#4432](https://github.com/netdata/netdata/issues/4432)
- Installer does not detect systemd on Ubuntu 14.04 [\#4421](https://github.com/netdata/netdata/issues/4421)
- netdata.spec seems to reference missing files [\#4409](https://github.com/netdata/netdata/issues/4409)
- mongodb.chart.py does not check pymongo version [\#4407](https://github.com/netdata/netdata/issues/4407)
- node.d.plugin issue after modularizing plugins commit [\#4406](https://github.com/netdata/netdata/issues/4406)
- netdata: CONFIG: cannot load user config ‘/etc/netdata/stream.conf’. Will try stock config. [\#4403](https://github.com/netdata/netdata/issues/4403)
- netdata \(20181015\) compiles fine but 'make dist' aborts [\#4400](https://github.com/netdata/netdata/issues/4400)
- netdata does not compile on FreeBSD 11.2-RELEASE-p4 [\#4393](https://github.com/netdata/netdata/issues/4393)
- API documentation cannot be read [\#4371](https://github.com/netdata/netdata/issues/4371)
- Error message: Cannot open file stream.conf [\#4341](https://github.com/netdata/netdata/issues/4341)
- MegaCli Plugin fails to parse [\#4278](https://github.com/netdata/netdata/issues/4278)
- Apps plugin: wrong open\_sockets counter when fd type changes [\#4233](https://github.com/netdata/netdata/issues/4233)
- Logind bug [\#4230](https://github.com/netdata/netdata/issues/4230)
- Should netdata identify the js binary as NodeJS by default? [\#4217](https://github.com/netdata/netdata/issues/4217)
- Cannot load jQuery: ERROR 101 [\#4212](https://github.com/netdata/netdata/issues/4212)
- redis.chart.py stops with error "check\(\) unhandled exception: 'rdb\_bgsave\_in\_progress'" [\#4204](https://github.com/netdata/netdata/issues/4204)
- Failed to start netdata.service: Exec format error [\#4169](https://github.com/netdata/netdata/issues/4169)
- python clocks don't work under FreeBSD [\#4152](https://github.com/netdata/netdata/issues/4152)
- error: cannot take the address of an rvalue of type 'FILE \*' when building on OpenBSD [\#4145](https://github.com/netdata/netdata/issues/4145)
- packages installer failed [\#4119](https://github.com/netdata/netdata/issues/4119)
- update\_every in postgres plugin [\#4089](https://github.com/netdata/netdata/issues/4089)
- /proc/interrupts plugin memory leak [\#4051](https://github.com/netdata/netdata/issues/4051)
- Problem with logrotate config \(PID discovery\) [\#4020](https://github.com/netdata/netdata/issues/4020)
- \[SECURITY\] Mitigate CVE-2017-18342 [\#4012](https://github.com/netdata/netdata/issues/4012)
- Netdata looks in ../../../../ to get it's config [\#3988](https://github.com/netdata/netdata/issues/3988)
- Statsd counters/gauges stuck on -167,772,150,000,000 [\#3978](https://github.com/netdata/netdata/issues/3978)
- After netdata slave is rebooted, timestamp doesn't match [\#3966](https://github.com/netdata/netdata/issues/3966)
- netdata-updater.sh fails due to missing './' on 'netdata-installer.sh' line [\#3940](https://github.com/netdata/netdata/issues/3940)
- Problem with running any python.d plugin? [\#3854](https://github.com/netdata/netdata/issues/3854)
- Alert email syntax problem [\#3843](https://github.com/netdata/netdata/issues/3843)
- kickstart-static64.sh fails with sh as root [\#3840](https://github.com/netdata/netdata/issues/3840)
- Illegal characters in URLs [\#3819](https://github.com/netdata/netdata/issues/3819)
- Use bash loadable sleep in tc-qos-helper.sh [\#3754](https://github.com/netdata/netdata/issues/3754)
- btrfs shows wrong disk space when the filesystem has sector size 4k but the logical disk sector size is 512B [\#3746](https://github.com/netdata/netdata/issues/3746)
- ERROR 405 with squid and web\_logs plugin [\#3738](https://github.com/netdata/netdata/issues/3738)
- tcp listen alarm integer expression expected [\#3733](https://github.com/netdata/netdata/issues/3733)
- Cannot load required JS library: http://ipaddress:19999/dashboard\_info.js?v20180510-2 after update or fresh install [\#3707](https://github.com/netdata/netdata/issues/3707)
- IPv4 UDPLite stats are always visible, even if UDPLite is not used on a system [\#3706](https://github.com/netdata/netdata/issues/3706)
- When listening on a unix socket, web server still attempts to set TCP\_NODELAY. [\#3682](https://github.com/netdata/netdata/issues/3682)
- httpcheck do not accept URLs that do not end with com [\#3656](https://github.com/netdata/netdata/issues/3656)
- httpcheck python.d plugin fails [\#3641](https://github.com/netdata/netdata/issues/3641)
- Issue with statsd sample rate [\#3630](https://github.com/netdata/netdata/issues/3630)
- netdata-uninstaller.sh not working \(with macOS 10.13\) [\#2941](https://github.com/netdata/netdata/issues/2941)
- Problem with plugins in debug mode \(wrong path to cfgs\) [\#2593](https://github.com/netdata/netdata/issues/2593)
- dashboard with thousands of charts [\#2275](https://github.com/netdata/netdata/issues/2275)
- fix docker image tagging problem [\#4250](https://github.com/netdata/netdata/pull/4250) ([paulfantom](https://github.com/paulfantom))

**Closed issues:**

- Feature request: Support for Adaptec RAID [\#4396](https://github.com/netdata/netdata/issues/4396)
- Is there any way to diable the example chart? [\#4384](https://github.com/netdata/netdata/issues/4384)
- modularize c source [\#4339](https://github.com/netdata/netdata/issues/4339)
- Diff migration of Wiki updates to new documentation [\#4320](https://github.com/netdata/netdata/issues/4320)
- Change GPL-3.0+ to GPL-3.0-or-later in all SPDX headers [\#4274](https://github.com/netdata/netdata/issues/4274)
- How to stop some metrics to save bandwidth [\#4223](https://github.com/netdata/netdata/issues/4223)
- UTC Timezone [\#4202](https://github.com/netdata/netdata/issues/4202)
- stock config files should be in `/usr/lib/netdata/` [\#4182](https://github.com/netdata/netdata/issues/4182)
- Lint python code \(PEP8 standard\) [\#4167](https://github.com/netdata/netdata/issues/4167)
- Fail2ban'd IPv6 addresses are not processed [\#4144](https://github.com/netdata/netdata/issues/4144)
- httpcheck support for HTTP methods  \(e.g. GET, OPTIONS, HEAD, etc...\) [\#4127](https://github.com/netdata/netdata/issues/4127)
- Naming for Diskstats for Veritas Volume Manger disks [\#4116](https://github.com/netdata/netdata/issues/4116)
- Raise an alarm when a docker container is unhealthy [\#4111](https://github.com/netdata/netdata/issues/4111)
- elasticsearch plugin python json exception if another service running on port 9200 [\#4092](https://github.com/netdata/netdata/issues/4092)
- varnish 5 support [\#4073](https://github.com/netdata/netdata/issues/4073)
- 'Other' is the Largest Category Under Applications \> Mem due to Node processes [\#4063](https://github.com/netdata/netdata/issues/4063)
- send netdata health monitoring variables to backends [\#4035](https://github.com/netdata/netdata/issues/4035)
- Badges - seconds units [\#4029](https://github.com/netdata/netdata/issues/4029)
- Web\_log doesn't support response times in nanoseconds [\#4003](https://github.com/netdata/netdata/issues/4003)
- 400 error when netdata tries to send slack notification [\#3989](https://github.com/netdata/netdata/issues/3989)
- Disable probing device mapper [\#3974](https://github.com/netdata/netdata/issues/3974)
- MySQL Python Plugin not work  [\#3968](https://github.com/netdata/netdata/issues/3968)
- How to enable sensor plugin? [\#3953](https://github.com/netdata/netdata/issues/3953)
- netdata does not appear to send host tags via graphite backend [\#3936](https://github.com/netdata/netdata/issues/3936)
- Netdata breaks suspend in debian stretch [\#3842](https://github.com/netdata/netdata/issues/3842)
- NUT ups names [\#3829](https://github.com/netdata/netdata/issues/3829)
- New at netdata and a lot of alarms [\#3826](https://github.com/netdata/netdata/issues/3826)
- \[REQUEST\] Add Fleep/webhook notifications [\#3792](https://github.com/netdata/netdata/issues/3792)
- Enhancement  Redis protocol\(Pika\) ? [\#3783](https://github.com/netdata/netdata/issues/3783)
- Plugin for Litespeed stats [\#3781](https://github.com/netdata/netdata/issues/3781)
- Do you have in plan to implement Megacli \(hardware RAID\) support metrics ? [\#3757](https://github.com/netdata/netdata/issues/3757)
- Add a Safari pinned tab icon [\#3743](https://github.com/netdata/netdata/issues/3743)
- Colors for BTRFS graphs are inconsistent [\#3719](https://github.com/netdata/netdata/issues/3719)
- \[Information\] Adding tutorial for Netdata in HTTPS for Plesk systems [\#3717](https://github.com/netdata/netdata/issues/3717)
- hddtemp module fails: received data doesn't have needed records [\#3683](https://github.com/netdata/netdata/issues/3683)
- "alarm-notify.sh test" produces error exit code on success [\#3667](https://github.com/netdata/netdata/issues/3667)
- init file is not installed on Amazon Linux 2018.03 [\#3650](https://github.com/netdata/netdata/issues/3650)
- Option to prevent netdata dashboard.js from downloading FontAwesome [\#3644](https://github.com/netdata/netdata/issues/3644)
- FYI: Homebrew formula \(package\) of netdata for macOS  [\#3642](https://github.com/netdata/netdata/issues/3642)
- python.d nginx module -- stub status from https server block on localhost? [\#3628](https://github.com/netdata/netdata/issues/3628)
- mdadm mismatch\_cnt statistic/alarm [\#3622](https://github.com/netdata/netdata/issues/3622)
- Python.d postgres unhandled exception [\#3614](https://github.com/netdata/netdata/issues/3614)
- Support for RethinkDB stats [\#3422](https://github.com/netdata/netdata/issues/3422)
- Notifications to Microsoft Teams [\#3330](https://github.com/netdata/netdata/issues/3330)
- enable system alarms on freebsd [\#3267](https://github.com/netdata/netdata/issues/3267)
- web\_log: response time should support summary or histgram [\#3102](https://github.com/netdata/netdata/issues/3102)
- Alarm for big system load [\#3003](https://github.com/netdata/netdata/issues/3003)
- Illegal instruction - Debian Stretch i586 [\#2909](https://github.com/netdata/netdata/issues/2909)
- New documentation \[bounty\] [\#2638](https://github.com/netdata/netdata/issues/2638)
- web\_log: support squid logs [\#2235](https://github.com/netdata/netdata/issues/2235)
- Monitoring PHP APCu [\#2199](https://github.com/netdata/netdata/issues/2199)
- MySQLService \(or DatabaseService\) for python.d [\#1906](https://github.com/netdata/netdata/issues/1906)
- RocketChat notifications [\#1811](https://github.com/netdata/netdata/issues/1811)
- SCTP Information [\#1218](https://github.com/netdata/netdata/issues/1218)
- python.d enhancements [\#692](https://github.com/netdata/netdata/issues/692)
- feature request: pause all data processing if noone is watching the graphs [\#656](https://github.com/netdata/netdata/issues/656)
- netdata package maintainers [\#651](https://github.com/netdata/netdata/issues/651)

**Merged pull requests:**

- Changed swagger editor url to the correct one [\#4539](https://github.com/netdata/netdata/pull/4539) ([infeeeee](https://github.com/infeeeee))
- fixed wrong annotations given to google charts [\#4535](https://github.com/netdata/netdata/pull/4535) ([ktsaou](https://github.com/ktsaou))
- allow debugging memory per module [\#4524](https://github.com/netdata/netdata/pull/4524) ([ktsaou](https://github.com/ktsaou))
- fixed vulnerabilities identified by red4sec.com [\#4521](https://github.com/netdata/netdata/pull/4521) ([ktsaou](https://github.com/ktsaou))
- Do not enable unused per core interrupts by default [\#4519](https://github.com/netdata/netdata/pull/4519) ([ktsaou](https://github.com/ktsaou))
- exclude web/gui/src from codacy checks [\#4515](https://github.com/netdata/netdata/pull/4515) ([paulfantom](https://github.com/paulfantom))
- do not send duplicate chart names while streaming metrics [\#4508](https://github.com/netdata/netdata/pull/4508) ([ktsaou](https://github.com/ktsaou))
- fix RPM build [\#4507](https://github.com/netdata/netdata/pull/4507) ([ktsaou](https://github.com/ktsaou))
- Split the API formatters in modules [\#4504](https://github.com/netdata/netdata/pull/4504) ([ktsaou](https://github.com/ktsaou))
- fixed rpm build;  [\#4503](https://github.com/netdata/netdata/pull/4503) ([ktsaou](https://github.com/ktsaou))
- Fix\(snmp\): fix parse oidname and santilize dimension name [\#4498](https://github.com/netdata/netdata/pull/4498) ([Ehekatl](https://github.com/Ehekatl))
- fix query min-max, again... [\#4495](https://github.com/netdata/netdata/pull/4495) ([ktsaou](https://github.com/ktsaou))
- diskspace plugin should not stat\(\) excluded mountpoints [\#4494](https://github.com/netdata/netdata/pull/4494) ([ktsaou](https://github.com/ktsaou))
- restored min-max calculation of RRDR [\#4489](https://github.com/netdata/netdata/pull/4489) ([ktsaou](https://github.com/ktsaou))
- query engine documentation and stats [\#4483](https://github.com/netdata/netdata/pull/4483) ([ktsaou](https://github.com/ktsaou))
- fix query sum [\#4482](https://github.com/netdata/netdata/pull/4482) ([ktsaou](https://github.com/ktsaou))
- query code cleanup [\#4480](https://github.com/netdata/netdata/pull/4480) ([ktsaou](https://github.com/ktsaou))
- Fix checking of grouping time [\#4478](https://github.com/netdata/netdata/pull/4478) ([vlvkobal](https://github.com/vlvkobal))
- Disable python sudo modules by default [\#4477](https://github.com/netdata/netdata/pull/4477) ([ilyam8](https://github.com/ilyam8))
- bug-fix: fixed aligned queries that returned no data [\#4472](https://github.com/netdata/netdata/pull/4472) ([ktsaou](https://github.com/ktsaou))
- Add proxysql to python.d.plugin Makefile.am [\#4466](https://github.com/netdata/netdata/pull/4466) ([alibo](https://github.com/alibo))
- updated tests for the new hierarchy [\#4464](https://github.com/netdata/netdata/pull/4464) ([ktsaou](https://github.com/ktsaou))
- Remove duplicated entry and put modules in order in python.d.conf [\#4460](https://github.com/netdata/netdata/pull/4460) ([vladmovchan](https://github.com/vladmovchan))
- fix permissions for config files in a container [\#4454](https://github.com/netdata/netdata/pull/4454) ([paulfantom](https://github.com/paulfantom))
- mongodb fix  [\#4449](https://github.com/netdata/netdata/pull/4449) ([ilyam8](https://github.com/ilyam8))
- icecast bugfix [\#4448](https://github.com/netdata/netdata/pull/4448) ([ilyam8](https://github.com/ilyam8))
- invalidate incorrect rpm spec changelog [\#4445](https://github.com/netdata/netdata/pull/4445) ([paulfantom](https://github.com/paulfantom))
- modularize the query api [\#4443](https://github.com/netdata/netdata/pull/4443) ([ktsaou](https://github.com/ktsaou))
- Indicate FreeIPMI support for FreeBSD [\#4440](https://github.com/netdata/netdata/pull/4440) ([openspork](https://github.com/openspork))
- remove unused variables [\#4437](https://github.com/netdata/netdata/pull/4437) ([paulfantom](https://github.com/paulfantom))
- Feat: detect NIC speed and alarm on each device for net traffic overflow [\#4430](https://github.com/netdata/netdata/pull/4430) ([Ehekatl](https://github.com/Ehekatl))
- fix streaming bug [\#4425](https://github.com/netdata/netdata/pull/4425) ([ktsaou](https://github.com/ktsaou))
- fix systemd detection;  [\#4423](https://github.com/netdata/netdata/pull/4423) ([ktsaou](https://github.com/ktsaou))
- moved stream.conf initialization after log files have been open [\#4422](https://github.com/netdata/netdata/pull/4422) ([ktsaou](https://github.com/ktsaou))
- Fix cmake build on macos [\#4420](https://github.com/netdata/netdata/pull/4420) ([Ehekatl](https://github.com/Ehekatl))
- Evaluate $used\_ram\_to\_ignore on FreeBSD [\#4419](https://github.com/netdata/netdata/pull/4419) ([openspork](https://github.com/openspork))
- fix node.d.plugin;  [\#4413](https://github.com/netdata/netdata/pull/4413) ([ktsaou](https://github.com/ktsaou))
- fix netdata.spec for new directory structure [\#4410](https://github.com/netdata/netdata/pull/4410) ([ktsaou](https://github.com/ktsaou))
- Added uwsgi plugin [\#4404](https://github.com/netdata/netdata/pull/4404) ([robbert-ef](https://github.com/robbert-ef))
- Add sendmail into the list of mail servers [\#4402](https://github.com/netdata/netdata/pull/4402) ([vladmovchan](https://github.com/vladmovchan))
- Fix make dist [\#4401](https://github.com/netdata/netdata/pull/4401) ([ktsaou](https://github.com/ktsaou))
- fix compilation on FreeBSD;  [\#4398](https://github.com/netdata/netdata/pull/4398) ([ktsaou](https://github.com/ktsaou))
- modularized all source code [\#4391](https://github.com/netdata/netdata/pull/4391) ([ktsaou](https://github.com/ktsaou))
- Account "Laundry" pages on FreeBSD [\#4390](https://github.com/netdata/netdata/pull/4390) ([vladmovchan](https://github.com/vladmovchan))
- normalized plugin names on all plugins;  [\#4387](https://github.com/netdata/netdata/pull/4387) ([ktsaou](https://github.com/ktsaou))
- updated swagger info for HTTPS [\#4386](https://github.com/netdata/netdata/pull/4386) ([ktsaou](https://github.com/ktsaou))
- make future code PEP8 compliant [\#4382](https://github.com/netdata/netdata/pull/4382) ([paulfantom](https://github.com/paulfantom))
- modularize C source code [\#4372](https://github.com/netdata/netdata/pull/4372) ([ktsaou](https://github.com/ktsaou))
- fix docker builds [\#4367](https://github.com/netdata/netdata/pull/4367) ([paulfantom](https://github.com/paulfantom))
- add option to run netdata in the background [\#4364](https://github.com/netdata/netdata/pull/4364) ([pohzipohzi](https://github.com/pohzipohzi))
- support filtering of charts during streaming; [\#4361](https://github.com/netdata/netdata/pull/4361) ([ktsaou](https://github.com/ktsaou))
- edit-config should use . instead of source with /bin/sh [\#4360](https://github.com/netdata/netdata/pull/4360) ([ktsaou](https://github.com/ktsaou))
- send pipes URL encoded [\#4358](https://github.com/netdata/netdata/pull/4358) ([ktsaou](https://github.com/ktsaou))
- updated configs.signatures [\#4356](https://github.com/netdata/netdata/pull/4356) ([ktsaou](https://github.com/ktsaou))
- Fix firehol image tagging [\#4355](https://github.com/netdata/netdata/pull/4355) ([paulfantom](https://github.com/paulfantom))
- Fix apache ipv6 configuration [\#4349](https://github.com/netdata/netdata/pull/4349) ([candrews](https://github.com/candrews))
- Fix phpfpm ipv6 configuration [\#4348](https://github.com/netdata/netdata/pull/4348) ([candrews](https://github.com/candrews))
- Add query types to mysql plugin [\#4347](https://github.com/netdata/netdata/pull/4347) ([roedie](https://github.com/roedie))
- ExecutableService: return \[\] instead of None if no data. [\#4346](https://github.com/netdata/netdata/pull/4346) ([Ferroin](https://github.com/Ferroin))
- Fix the last few PEP 8 compliance issues. [\#4345](https://github.com/netdata/netdata/pull/4345) ([Ferroin](https://github.com/Ferroin))
- log flood should not be disabled;  [\#4344](https://github.com/netdata/netdata/pull/4344) ([ktsaou](https://github.com/ktsaou))
- better daemon errors about files;  [\#4342](https://github.com/netdata/netdata/pull/4342) ([ktsaou](https://github.com/ktsaou))
- added edit-config [\#4338](https://github.com/netdata/netdata/pull/4338) ([ktsaou](https://github.com/ktsaou))
- Fix BIND outgoing stats in a multiview environment [\#4337](https://github.com/netdata/netdata/pull/4337) ([vobruba-martin](https://github.com/vobruba-martin))
- fixes coverity identified issues [\#4333](https://github.com/netdata/netdata/pull/4333) ([ktsaou](https://github.com/ktsaou))
- Use newer docker in CI build [\#4332](https://github.com/netdata/netdata/pull/4332) ([paulfantom](https://github.com/paulfantom))
- fix docker image [\#4330](https://github.com/netdata/netdata/pull/4330) ([paulfantom](https://github.com/paulfantom))
- Auto-releaser [\#4328](https://github.com/netdata/netdata/pull/4328) ([paulfantom](https://github.com/paulfantom))
- fix spdx headers [\#4327](https://github.com/netdata/netdata/pull/4327) ([paulfantom](https://github.com/paulfantom))
- updated LGTM URLs [\#4317](https://github.com/netdata/netdata/pull/4317) ([ktsaou](https://github.com/ktsaou))
- more code owners [\#4316](https://github.com/netdata/netdata/pull/4316) ([paulfantom](https://github.com/paulfantom))
- Use docker manifests [\#4315](https://github.com/netdata/netdata/pull/4315) ([paulfantom](https://github.com/paulfantom))
- install some libs for coverity [\#4314](https://github.com/netdata/netdata/pull/4314) ([paulfantom](https://github.com/paulfantom))
- cleanup FIXME tags [\#4309](https://github.com/netdata/netdata/pull/4309) ([ktsaou](https://github.com/ktsaou))
- force symlink of netdata-updater.sh [\#4307](https://github.com/netdata/netdata/pull/4307) ([mrdrogdrog](https://github.com/mrdrogdrog))
- Build OSX earlier than linux [\#4305](https://github.com/netdata/netdata/pull/4305) ([paulfantom](https://github.com/paulfantom))
- Fix coverity-scan.sh [\#4304](https://github.com/netdata/netdata/pull/4304) ([paulfantom](https://github.com/paulfantom))
- Python.d PEP 8 cleanup, modules S-Z [\#4302](https://github.com/netdata/netdata/pull/4302) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules P-R [\#4299](https://github.com/netdata/netdata/pull/4299) ([Ferroin](https://github.com/Ferroin))
- Python.d/postgres.chart.py PEP 8 code cleanup [\#4298](https://github.com/netdata/netdata/pull/4298) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules N-O [\#4297](https://github.com/netdata/netdata/pull/4297) ([Ferroin](https://github.com/Ferroin))
- reproducible build system [\#4294](https://github.com/netdata/netdata/pull/4294) ([paulfantom](https://github.com/paulfantom))
- update variable after install [\#4292](https://github.com/netdata/netdata/pull/4292) ([paulfantom](https://github.com/paulfantom))
- give credit where credit is due [\#4291](https://github.com/netdata/netdata/pull/4291) ([paulfantom](https://github.com/paulfantom))
- fix typo in coverity scan script [\#4290](https://github.com/netdata/netdata/pull/4290) ([paulfantom](https://github.com/paulfantom))
- Python.d PEP 8 cleanup, modules M [\#4289](https://github.com/netdata/netdata/pull/4289) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules I-L [\#4288](https://github.com/netdata/netdata/pull/4288) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules D-H [\#4287](https://github.com/netdata/netdata/pull/4287) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules A-C [\#4286](https://github.com/netdata/netdata/pull/4286) ([Ferroin](https://github.com/Ferroin))
- Fix typo in documentation [\#4284](https://github.com/netdata/netdata/pull/4284) ([eduherminio](https://github.com/eduherminio))
- stock configs in /usr/lib/netdata [\#4283](https://github.com/netdata/netdata/pull/4283) ([ktsaou](https://github.com/ktsaou))
- use flake8 instead of pylint [\#4282](https://github.com/netdata/netdata/pull/4282) ([paulfantom](https://github.com/paulfantom))
- tcp syn and accept queue charts and alarms [\#4281](https://github.com/netdata/netdata/pull/4281) ([ktsaou](https://github.com/ktsaou))
- add code of conduct [\#4280](https://github.com/netdata/netdata/pull/4280) ([paulfantom](https://github.com/paulfantom))
- megacli plugin: adapter regex update [\#4279](https://github.com/netdata/netdata/pull/4279) ([ilyam8](https://github.com/ilyam8))
- Allow DOCKER\_HOST env variable to override default docker socket path [\#4277](https://github.com/netdata/netdata/pull/4277) ([xginn8](https://github.com/xginn8))
- Add other common IoT services to apps\_groups.conf [\#4276](https://github.com/netdata/netdata/pull/4276) ([xginn8](https://github.com/xginn8))
- fix python warnings identified by LGTM [\#4275](https://github.com/netdata/netdata/pull/4275) ([ilyam8](https://github.com/ilyam8))
- nightly builds + coverity scan [\#4273](https://github.com/netdata/netdata/pull/4273) ([paulfantom](https://github.com/paulfantom))
- better lgtm config [\#4272](https://github.com/netdata/netdata/pull/4272) ([paulfantom](https://github.com/paulfantom))
- Fixup small python-logind typos [\#4271](https://github.com/netdata/netdata/pull/4271) ([xginn8](https://github.com/xginn8))
- Fix several typos in documentation [\#4270](https://github.com/netdata/netdata/pull/4270) ([Calinou](https://github.com/Calinou))
- \[WIP\] LGTM tag classification [\#4269](https://github.com/netdata/netdata/pull/4269) ([paulfantom](https://github.com/paulfantom))
- create stale bot integration [\#4268](https://github.com/netdata/netdata/pull/4268) ([paulfantom](https://github.com/paulfantom))
- apps.plugin fixes [\#4267](https://github.com/netdata/netdata/pull/4267) ([ktsaou](https://github.com/ktsaou))
- finetune Code Owners entries [\#4264](https://github.com/netdata/netdata/pull/4264) ([paulfantom](https://github.com/paulfantom))
- updated readme for netdata org [\#4262](https://github.com/netdata/netdata/pull/4262) ([ktsaou](https://github.com/ktsaou))
- \[cleanup crusade\] Shellcheck [\#4261](https://github.com/netdata/netdata/pull/4261) ([paulfantom](https://github.com/paulfantom))
- \[WIP\] release less artifacts [\#4260](https://github.com/netdata/netdata/pull/4260) ([paulfantom](https://github.com/paulfantom))
- Make method in url service configurable [\#4257](https://github.com/netdata/netdata/pull/4257) ([ccremer](https://github.com/ccremer))
- Fix typo in documentation [\#4255](https://github.com/netdata/netdata/pull/4255) ([olivierlambert](https://github.com/olivierlambert))
- coverity should still use firehol/netdata until we find a solution [\#4253](https://github.com/netdata/netdata/pull/4253) ([ktsaou](https://github.com/ktsaou))
- fix badges in README.md [\#4251](https://github.com/netdata/netdata/pull/4251) ([paulfantom](https://github.com/paulfantom))
- replaced referenced to firehol github org with netdata github org [\#4249](https://github.com/netdata/netdata/pull/4249) ([ktsaou](https://github.com/ktsaou))
- Travis and docker setup after migration [\#4247](https://github.com/netdata/netdata/pull/4247) ([paulfantom](https://github.com/paulfantom))
- collect TcpExtTCPReqQFullDrop;  [\#4246](https://github.com/netdata/netdata/pull/4246) ([ktsaou](https://github.com/ktsaou))
- fixed typo in prometheus\_all\_hosts output [\#4245](https://github.com/netdata/netdata/pull/4245) ([ktsaou](https://github.com/ktsaou))
- apps.plugin now checks fds for changes, with adaptive caching [\#4243](https://github.com/netdata/netdata/pull/4243) ([ktsaou](https://github.com/ktsaou))
- Added -NoLog parameter for megacli calls [\#4242](https://github.com/netdata/netdata/pull/4242) ([vobruba-martin](https://github.com/vobruba-martin))
- updated configs.signatures [\#4240](https://github.com/netdata/netdata/pull/4240) ([ktsaou](https://github.com/ktsaou))
- command js is not node.js [\#4239](https://github.com/netdata/netdata/pull/4239) ([ktsaou](https://github.com/ktsaou))
- Fix missing comma in couchdb module. [\#4238](https://github.com/netdata/netdata/pull/4238) ([Ferroin](https://github.com/Ferroin))
- Fix LGTM complaints in monit module. [\#4237](https://github.com/netdata/netdata/pull/4237) ([Ferroin](https://github.com/Ferroin))
- daemon cleanup [\#4231](https://github.com/netdata/netdata/pull/4231) ([ktsaou](https://github.com/ktsaou))
- varnish plugin bugfix [\#4228](https://github.com/netdata/netdata/pull/4228) ([ilyam8](https://github.com/ilyam8))
- CLA signing using cla-assistant.io [\#4226](https://github.com/netdata/netdata/pull/4226) ([ktsaou](https://github.com/ktsaou))
- Disable IPFS Pin API [\#4224](https://github.com/netdata/netdata/pull/4224) ([jkpit](https://github.com/jkpit))
- fixes identified by LGTM [\#4220](https://github.com/netdata/netdata/pull/4220) ([ktsaou](https://github.com/ktsaou))
- workaround for LGTM false-positives [\#4218](https://github.com/netdata/netdata/pull/4218) ([ktsaou](https://github.com/ktsaou))
- fixed issues identified by lgtm [\#4216](https://github.com/netdata/netdata/pull/4216) ([ktsaou](https://github.com/ktsaou))
- fix netdata server URL detection in dashboard.js; [\#4215](https://github.com/netdata/netdata/pull/4215) ([ktsaou](https://github.com/ktsaou))
- Create lgtm config [\#4213](https://github.com/netdata/netdata/pull/4213) ([paulfantom](https://github.com/paulfantom))
- more LGTM minor fixes [\#4211](https://github.com/netdata/netdata/pull/4211) ([ktsaou](https://github.com/ktsaou))
- updated configs.signatures [\#4210](https://github.com/netdata/netdata/pull/4210) ([ktsaou](https://github.com/ktsaou))
- fixes identified by LGTM [\#4209](https://github.com/netdata/netdata/pull/4209) ([ktsaou](https://github.com/ktsaou))
- allow empty values in config settings;  [\#4208](https://github.com/netdata/netdata/pull/4208) ([ktsaou](https://github.com/ktsaou))
- added UTC to server timezones list; [\#4207](https://github.com/netdata/netdata/pull/4207) ([ktsaou](https://github.com/ktsaou))
- redis plugin bugfix [\#4205](https://github.com/netdata/netdata/pull/4205) ([ilyam8](https://github.com/ilyam8))
- send host variables to prometheus [\#4200](https://github.com/netdata/netdata/pull/4200) ([ktsaou](https://github.com/ktsaou))
- Update CONTRIBUTORS.md [\#4197](https://github.com/netdata/netdata/pull/4197) ([paulfantom](https://github.com/paulfantom))
- nginx\_plus: use upstream server IP:port in dimension IDs, not the transient ID [\#4194](https://github.com/netdata/netdata/pull/4194) ([illes](https://github.com/illes))
- time-duration badges should show "undefined" instead of "never"  [\#4193](https://github.com/netdata/netdata/pull/4193) ([ktsaou](https://github.com/ktsaou))
- Add docker plugin [\#4191](https://github.com/netdata/netdata/pull/4191) ([tuxity](https://github.com/tuxity))
- Improve packaging checks [\#4188](https://github.com/netdata/netdata/pull/4188) ([philwhineray](https://github.com/philwhineray))
- elasticsearch: handle json parse error in threads [\#4186](https://github.com/netdata/netdata/pull/4186) ([ilyam8](https://github.com/ilyam8))
- pythond\_small\_fixes [\#4185](https://github.com/netdata/netdata/pull/4185) ([ilyam8](https://github.com/ilyam8))
- \[cleanup crusade\] more linting of bash modules [\#4183](https://github.com/netdata/netdata/pull/4183) ([paulfantom](https://github.com/paulfantom))
-  create pid directory, if not present [\#4181](https://github.com/netdata/netdata/pull/4181) ([ktsaou](https://github.com/ktsaou))
- fix for load alarms [\#4180](https://github.com/netdata/netdata/pull/4180) ([ktsaou](https://github.com/ktsaou))
- updated configs.signatures [\#4179](https://github.com/netdata/netdata/pull/4179) ([ktsaou](https://github.com/ktsaou))
- Add permission file check in ceph module [\#4177](https://github.com/netdata/netdata/pull/4177) ([lets00](https://github.com/lets00))
- \[cleanup crusade\] disable linters on installer scripts [\#4176](https://github.com/netdata/netdata/pull/4176) ([paulfantom](https://github.com/paulfantom))
- Add alarms for abnormally high load averages. [\#4175](https://github.com/netdata/netdata/pull/4175) ([Ferroin](https://github.com/Ferroin))
- CI builds in containers [\#4174](https://github.com/netdata/netdata/pull/4174) ([paulfantom](https://github.com/paulfantom))
- Fix lack of dot [\#4172](https://github.com/netdata/netdata/pull/4172) ([paulfantom](https://github.com/paulfantom))
- remove condition from netdata.service [\#4170](https://github.com/netdata/netdata/pull/4170) ([ktsaou](https://github.com/ktsaou))
- \[WIP\] fail2ban: ipv6 support added + module simplification [\#4168](https://github.com/netdata/netdata/pull/4168) ([ilyam8](https://github.com/ilyam8))
- \[cleanup crusade\] linting shell scripts for docker, tests and python [\#4162](https://github.com/netdata/netdata/pull/4162) ([paulfantom](https://github.com/paulfantom))
- \[cleanup crusade\] shellcheck in contrib [\#4160](https://github.com/netdata/netdata/pull/4160) ([paulfantom](https://github.com/paulfantom))
- \[cleanup crusade\] Lint bash scripts on letter A [\#4159](https://github.com/netdata/netdata/pull/4159) ([paulfantom](https://github.com/paulfantom))
- use pidfile to send HUP to netdata via logrotate; [\#4157](https://github.com/netdata/netdata/pull/4157) ([ktsaou](https://github.com/ktsaou))
- python plugin monotonic fix [\#4156](https://github.com/netdata/netdata/pull/4156) ([ilyam8](https://github.com/ilyam8))
- add variable system.cpu.processors for alarms;  [\#4155](https://github.com/netdata/netdata/pull/4155) ([ktsaou](https://github.com/ktsaou))
- netdata.service is now installed in /lib/systemd/system;  [\#4151](https://github.com/netdata/netdata/pull/4151) ([ktsaou](https://github.com/ktsaou))
- name veritas volume disk groups [\#4150](https://github.com/netdata/netdata/pull/4150) ([ktsaou](https://github.com/ktsaou))
- do not get the address of FILE pointer;  [\#4149](https://github.com/netdata/netdata/pull/4149) ([ktsaou](https://github.com/ktsaou))
- Add some extra error logging to the spigotmc module. [\#4148](https://github.com/netdata/netdata/pull/4148) ([Ferroin](https://github.com/Ferroin))
- /proc/net/snmp minimum line length for IcmpMsg is 2 words, not 3 [\#4147](https://github.com/netdata/netdata/pull/4147) ([ktsaou](https://github.com/ktsaou))
- when running under systemd, keep the process scheduling parameters set [\#4143](https://github.com/netdata/netdata/pull/4143) ([ktsaou](https://github.com/ktsaou))
- \[cleanup crusade\] travis build stages [\#4142](https://github.com/netdata/netdata/pull/4142) ([paulfantom](https://github.com/paulfantom))
- Add ignore-status option to freeipmi\_plugin [\#4141](https://github.com/netdata/netdata/pull/4141) ([plasticrake](https://github.com/plasticrake))
- \[cleanup crusade\] move profiling to tests directory [\#4140](https://github.com/netdata/netdata/pull/4140) ([paulfantom](https://github.com/paulfantom))
- Less verbose bash and curl unpacking [\#4139](https://github.com/netdata/netdata/pull/4139) ([paulfantom](https://github.com/paulfantom))
- \[project management\] add github CODEOWNERS [\#4137](https://github.com/netdata/netdata/pull/4137) ([paulfantom](https://github.com/paulfantom))
- \[cleanup crusade\] cleanup licenses [\#4136](https://github.com/netdata/netdata/pull/4136) ([paulfantom](https://github.com/paulfantom))
- Add ProxySQL python plugin [\#4112](https://github.com/netdata/netdata/pull/4112) ([alibo](https://github.com/alibo))
- Optimize counting of recusive pins [\#4095](https://github.com/netdata/netdata/pull/4095) ([pjz](https://github.com/pjz))
- \[nginx\_plus\] fix handling of non-contiguous peer IDs [\#4093](https://github.com/netdata/netdata/pull/4093) ([illes](https://github.com/illes))
- web\_log Virtual host enhancement and http/https [\#4076](https://github.com/netdata/netdata/pull/4076) ([jgrossiord](https://github.com/jgrossiord))
- push host tags for graphite;  [\#3992](https://github.com/netdata/netdata/pull/3992) ([ktsaou](https://github.com/ktsaou))
- rethinkdb python plugin [\#3955](https://github.com/netdata/netdata/pull/3955) ([ilyam8](https://github.com/ilyam8))
- Add a python plugin for monitoring power supplies on Linux. [\#3799](https://github.com/netdata/netdata/pull/3799) ([Ferroin](https://github.com/Ferroin))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
