/* usr.c -- Userspace routing.

   Copyright (C) 2007, 2008 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <dnet.h>

#include "usr.h"

/*
 * Default IPv4 routing table. Initially populated during initialization
 * of the USR subsystem.
 */
struct rtable *default_ipv4rt;

/*
 * Default system interfaces. Initially populated during initialization
 * of the USR subsystem.
 */
struct iftable *default_iftable;

int
usr_init(void)
{

    default_ipv4rt = rtable_new(RTABLE_IPV4, 1);
    if (default_ipv4rt == NULL)
	return -1;

    default_iftable = iftable_new(1);
    if (default_iftable == NULL)
	return -1;

    return 0;
}

int
usr_outif(struct intf_entry *i, struct addr *dest)
{
    return 0;
}

