# -*- coding: utf-8 -*-
#
#  Copyright (C) 2011-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os


if os.name == 'posix':
    import fcntl
    def lockfile(fileobj):
        fcntl.lockf(fileobj.fileno(), fcntl.LOCK_EX | fcntl.LOCK_NB)
    def unlockfile(fileobj):
        fcntl.lockf(fileobj.fileno(), fcntl.LOCK_UN)
elif os.name == 'nt':
    import win32con
    import win32file
    import pywintypes
    def lockfile(fileobj):
        overlapped = pywintypes.OVERLAPPED()
        handle = win32file._get_osfhandle(fileobj.fileno())
        win32file.LockFileEx(
            handle,
            win32con.LOCKFILE_EXCLUSIVE_LOCK | win32con.LOCKFILE_FAIL_IMMEDIATELY,
            0, -0x7fff0000, overlapped) # XXX: eq. 0xffff0000
    def unlockfile(fileobj):
        overlapped = pywintypes.OVERLAPPED()
        handle = win32file._get_osfhandle(fileobj.fileno())
        win32file.UnlockFileEx(handle, 0, -0x7fff0000, overlapped) # XXX: eq. 0xffff0000
else:
    def lockfile(fileobj):
        pass ## FIXME
    def unlockfile(fileobj):
        pass ## FIXME
