const UglifyJsPlugin = require('uglifyjs-webpack-plugin');


module.exports = {
    entry: {
	'chai.js' : './index.js',
	'chai.min.js' : './index.js'
    },
    devtool: "source-map",
    output: {
        library: "chai",
	libraryTarget: "umd",
	filename: "[name]"
    },
    plugins: [
	new UglifyJsPlugin({
	    include: /\.min\.js$/,
	    minimize: true,
	    sourceMap: true
	})
    ],
    /* not yet 
    optimization: {
        minimizer: [
            new UglifyJsPlugin({
                sourceMap: true,
            }),
        ],
    },*/
    resolve: {
        modules: process.env.NODE_PATH.split(':')
    },
    resolveLoader: {
        modules: process.env.NODE_PATH.split(':')
    }
}
