## Proposed changes

Describe the big picture of your changes here to communicate to the maintainers why we should accept this pull request. If it fixes a bug or resolves a feature request, be sure to link to that issue.

## Types of changes

What types of changes does your code introduce
_Put an `x` in the boxes that apply_

- [ ] Bug (non-breaking change which fixes an issue)
- [ ] Feature (non-breaking change which adds functionality)
- [ ] Breaking Change (fix or feature which changes existing functionality)

## Checklist

_Put an `x` in the boxes that apply. You can also fill these out after creating the PR. If you're unsure about any of them, don't hesitate to ask. We're here to help! This is a reminder of what we are going to look for before merging your code._

- [ ] I have read the [CONTRIBUTING](https://github.com/michael-ciniawsky/postcss-load-config/blob/master/CONTRIBUTING.md) guide
- [ ] Lint and unit tests pass with my changes
- [ ] I have added tests that prove my fix is effective/works
- [ ] I have added necessary documentation (if appropriate)
- [ ] Any dependent changes are merged and published in downstream modules

## Further comments

If this is a large or complex change, kick off the discussion by explaining why you chose the solution you did and what alternatives you considered, etc...

### Reviewers: @michael-ciniawsky, @ertrzyiks
