## Usage

```js
var set = require('{%= name %}');
set(object, prop, value);
```

### Params

- `object` **{object}**: The object to set `value` on
- `prop` **{string}**: The property to set. Dot-notation may be used.
- `value` **{any}**: The value to set on `object[prop]`


## Examples

Updates and returns the given object:

```js
var obj = {};
set(obj, 'a.b.c', 'd');
console.log(obj);
//=> { a: { b: { c: 'd' } } }
```

### Escaping

**Escaping with backslashes**

Prevent set-value from splitting on a dot by prefixing it with backslashes:

```js
console.log(set({}, 'a\\.b.c', 'd'));
//=> { 'a.b': { c: 'd' } }

console.log(set({}, 'a\\.b\\.c', 'd'));
//=> { 'a.b.c': 'd' }
```

## Benchmarks

_(benchmarks were run on a MacBook Pro 2.5 GHz Intel Core i7, 16 GB 1600 MHz DDR3)_.

set-value is more reliable and has more features than dot-prop, without sacrificing performance.

```
{%= include("./benchmark/stats.md") %}
```

### Running the benchmarks

Clone this library into a local directory:

```sh
$ git clone https://github.com/jonschlinkert/set-value.git
```

Then install devDependencies and run benchmarks:

```sh
$ npm install && node benchmark
```

## Comparisons to other libs, or _"the list of shame"_

These are just a few of the duplicate libraries on NPM. 

- [bury][] fails all of the tests. I even wrapped it to have it return the object instead of the value, but with all of that work it still fails the vast majority of tests. 
- [deep-get-set][] fails 22 of 26 unit tests.
- [deep-object][] fails 25 of 26 unit tests, completely butchered given objects.
- [deep-property][] fails 17 of 26 unit tests.
- [deep-set][] fails 13 of 26 unit tests.
- [deephas][] fails 17 of 26 unit tests.
- [dot-prop][] fails 9 of 26 unit tests.
- [dot2val][] fails 17 of 26 unit tests.
- [es5-dot-prop][] fails 15 of 26 unit tests.
- [getsetdeep][] fails all unit tests due to `this` being used improperly in the methods. I was able to patch it by binding the (plain) object to the methods, but it still fails 17 of 26 unit tests.
- [lodash.set][] fails 11 of 26 unit tests.
- [object-path-set][] fails 12 of 26 unit tests.
- [object-path][] fails 16 of 26 unit tests.
- [object-set][] fails 13 of 26 unit tests.
- [set-nested-prop][] fails 24 of 26 unit tests.
- [setvalue][] (this library is almost identical to a previous version of this library)
- Many dozens of others

**Others that do the same thing, but use a completely different API**

- [deep-set-in][] 
- [set-deep][] 
- [set-deep-prop][] 
- [bury][] 
- Many dozens of others


## History

### v3.0.0

- Added support for a custom `split` function to be passed on the options. 
- Removed support for splitting on brackets, since a [custom function][split-string] can be passed to do this now.

### v2.0.0

- Adds support for escaping with double or single quotes. See [escaping](#escaping) for examples.
- Will no longer split inside brackets or braces. See [bracket support](#bracket-support) for examples.

If there are any regressions please create a [bug report](../../issues/new). Thanks!
